// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.util.xhttp');
goog.require('cljs.core');
goog.require('goog.net.XhrIo');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
fluree.db.util.xhttp.format_error_response = (function fluree$db$util$xhttp$format_error_response(url,e){
var status = (function (){var temp__5735__auto__ = e.getStatus();
if(cljs.core.truth_(temp__5735__auto__)){
var st = temp__5735__auto__;
if((st > (0))){
return st;
} else {
return null;
}
} else {
return null;
}
})();
var error = (function (){var pred__108525 = cljs.core._EQ_;
var expr__108526 = e.getLastErrorCode();
if(cljs.core.truth_(pred__108525.call(null,goog.net.ErrorCode.NO_ERROR,expr__108526))){
return new cljs.core.Keyword("xhttp","no-error","xhttp/no-error",1902047248);
} else {
if(cljs.core.truth_(pred__108525.call(null,goog.net.ErrorCode.EXCEPTION,expr__108526))){
return new cljs.core.Keyword("xhttp","exception","xhttp/exception",1363682040);
} else {
if(cljs.core.truth_(pred__108525.call(null,goog.net.ErrorCode.HTTP_ERROR,expr__108526))){
return new cljs.core.Keyword("xhttp","http-error","xhttp/http-error",-960604305);
} else {
if(cljs.core.truth_(pred__108525.call(null,goog.net.ErrorCode.ABORT,expr__108526))){
return new cljs.core.Keyword("xhttp","abort","xhttp/abort",666776046);
} else {
if(cljs.core.truth_(pred__108525.call(null,goog.net.ErrorCode.TIMEOUT,expr__108526))){
return new cljs.core.Keyword("xhttp","timeout","xhttp/timeout",357433562);
} else {
return new cljs.core.Keyword("xhttp","unknown-error","xhttp/unknown-error",693274399);
}
}
}
}
}
})();
var message = ["xhttp error - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url),(cljs.core.truth_((function (){var and__4115__auto__ = status;
if(cljs.core.truth_(and__4115__auto__)){
return (status > (0));
} else {
return and__4115__auto__;
}
})())?[": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(status)].join(''):"")].join('');
return cljs.core.ex_info.call(null,message,(function (){var G__108528 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
if(cljs.core.truth_(status)){
return cljs.core.assoc.call(null,G__108528,new cljs.core.Keyword(null,"status","status",-1997798413),status);
} else {
return G__108528;
}
})());
});
/**
 * Posts JSON content.
 *   opts is a map with following optional keys:
 *   :request-timeout - how many milliseconds until we throw an exception without a response (default 5000)
 */
fluree.db.util.xhttp.post_json = (function fluree$db$util$xhttp$post_json(url,message,opts){
var map__108529 = opts;
var map__108529__$1 = (((((!((map__108529 == null))))?(((((map__108529.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__108529.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__108529):map__108529);
var request_timeout = cljs.core.get.call(null,map__108529__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.call(null,map__108529__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.call(null,map__108529__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var response_chan = cljs.core.async.chan.call(null);
var headers__$1 = (function (){var G__108531 = new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","application/json"], null);
var G__108531__$1 = (cljs.core.truth_(headers)?cljs.core.merge.call(null,G__108531,headers):G__108531);
if(cljs.core.truth_(token)){
return cljs.core.assoc.call(null,G__108531__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__108531__$1;
}
})();
try{goog.net.XhrIo.send(url,(function (event){
var xhr = event.target;
var success_QMARK_ = xhr.isSuccess();
if(cljs.core.truth_(success_QMARK_)){
return cljs.core.async.put_BANG_.call(null,response_chan,cljs.core.js__GT_clj.call(null,xhr.getResponseJson(),new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true));
} else {
return cljs.core.async.put_BANG_.call(null,response_chan,fluree.db.util.xhttp.format_error_response.call(null,url,xhr));
}
}),"POST",fluree.db.util.json.stringify.call(null,message),cljs.core.clj__GT_js.call(null,headers__$1),request_timeout);
}catch (e108532){var e_108533 = e108532;
fluree.db.util.log.warn.call(null,"CAUGHT ERROR!");

cljs.core.async.put_BANG_.call(null,response_chan,e_108533);
}
return response_chan;
});
/**
 * Returns result body as a string, or an exception.
 * 
 *   If opts contains :body,
 *   It is assumed body is already in a format that can be sent directly in request (already encoded).
 * 
 *   Options
 *   - output-format - can be :text, :json or :binary (default text), or special format (wikidata) to handle wikidata errors, which come back as html.
 * 
 *   
 */
fluree.db.util.xhttp.get = (function fluree$db$util$xhttp$get(url,opts){
var map__108534 = opts;
var map__108534__$1 = (((((!((map__108534 == null))))?(((((map__108534.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__108534.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__108534):map__108534);
var request_timeout = cljs.core.get.call(null,map__108534__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.call(null,map__108534__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.call(null,map__108534__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var body = cljs.core.get.call(null,map__108534__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var output_format = cljs.core.get.call(null,map__108534__$1,new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"text","text",-1790561697));
var response_chan = cljs.core.async.chan.call(null);
var headers__$1 = (function (){var G__108536 = cljs.core.PersistentArrayMap.EMPTY;
var G__108536__$1 = (cljs.core.truth_(headers)?cljs.core.merge.call(null,G__108536,headers):G__108536);
if(cljs.core.truth_(token)){
return cljs.core.assoc.call(null,G__108536__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__108536__$1;
}
})();
try{goog.net.XhrIo.send(url,(function (event){
var xhr = event.target;
var success_QMARK_ = xhr.isSuccess();
if(cljs.core.truth_(success_QMARK_)){
return cljs.core.async.put_BANG_.call(null,response_chan,(function (){var G__108538 = output_format;
var G__108538__$1 = (((G__108538 instanceof cljs.core.Keyword))?G__108538.fqn:null);
switch (G__108538__$1) {
case "text":
return xhr.getResponseText();

break;
case "json":
return xhr.getResponseJson();

break;
default:
throw cljs.core.ex_info.call(null,"http get only supports output formats of json and text for now.",cljs.core.PersistentArrayMap.EMPTY);

}
})());
} else {
return cljs.core.async.put_BANG_.call(null,response_chan,fluree.db.util.xhttp.format_error_response.call(null,url,xhr));
}
}),"GET",body,cljs.core.clj__GT_js.call(null,headers__$1),request_timeout);
}catch (e108537){var e_108540 = e108537;
fluree.db.util.log.warn.call(null,"CAUUGHT ERROR!");

cljs.core.async.put_BANG_.call(null,response_chan,e_108540);
}
return response_chan;
});
/**
 * http get with JSON response.
 * 
 *   If opts contains :body key, it is encoded into JSON and sent as part
 *   of the body.
 */
fluree.db.util.xhttp.get_json = (function fluree$db$util$xhttp$get_json(url,opts){
var opts_STAR_ = (function (){var G__108541 = cljs.core.assoc.call(null,cljs.core.assoc_in.call(null,opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"Accept"], null),"application/json"),new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"json","json",1279968570));
if(cljs.core.truth_(new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core.assoc.call(null,G__108541,new cljs.core.Keyword(null,"body","body",-2049205669),fluree.db.util.json.stringify.call(null,new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts)));
} else {
return G__108541;
}
})();
return fluree.db.util.xhttp.get.call(null,url,opts_STAR_);
});
/**
 * Sends messages across web socket. Sends never block and will immediately queue.
 *   Message to send should be a two-tuple placed on the pub-chan, of:
 *  [msg resp-chan]
 *   where a true/false response will eventually be placed on the resp-chan if the send
 *   is successful.
 */
fluree.db.util.xhttp.socket_publish_loop = (function fluree$db$util$xhttp$socket_publish_loop(ws,pub_chan){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_108571){
var state_val_108572 = (state_108571[(1)]);
if((state_val_108572 === (7))){
var inst_108567 = (state_108571[(2)]);
var state_108571__$1 = state_108571;
var statearr_108573_108591 = state_108571__$1;
(statearr_108573_108591[(2)] = inst_108567);

(statearr_108573_108591[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108572 === (1))){
var state_108571__$1 = state_108571;
var statearr_108574_108592 = state_108571__$1;
(statearr_108574_108592[(2)] = null);

(statearr_108574_108592[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108572 === (4))){
var inst_108545 = (state_108571[(7)]);
var inst_108545__$1 = (state_108571[(2)]);
var inst_108546 = (inst_108545__$1 == null);
var state_108571__$1 = (function (){var statearr_108575 = state_108571;
(statearr_108575[(7)] = inst_108545__$1);

return statearr_108575;
})();
if(cljs.core.truth_(inst_108546)){
var statearr_108576_108593 = state_108571__$1;
(statearr_108576_108593[(1)] = (5));

} else {
var statearr_108577_108594 = state_108571__$1;
(statearr_108577_108594[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108572 === (6))){
var inst_108545 = (state_108571[(7)]);
var inst_108553 = cljs.core.nth.call(null,inst_108545,(0),null);
var inst_108554 = cljs.core.nth.call(null,inst_108545,(1),null);
var state_108571__$1 = (function (){var statearr_108578 = state_108571;
(statearr_108578[(8)] = inst_108554);

(statearr_108578[(9)] = inst_108553);

return statearr_108578;
})();
var statearr_108579_108595 = state_108571__$1;
(statearr_108579_108595[(2)] = null);

(statearr_108579_108595[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108572 === (3))){
var inst_108569 = (state_108571[(2)]);
var state_108571__$1 = state_108571;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_108571__$1,inst_108569);
} else {
if((state_val_108572 === (2))){
var state_108571__$1 = state_108571;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_108571__$1,(4),pub_chan);
} else {
if((state_val_108572 === (9))){
var inst_108554 = (state_108571[(8)]);
var inst_108555 = (state_108571[(2)]);
var inst_108556 = fluree.db.util.log.error.call(null,inst_108555,"Websocket send message error:",inst_108555);
var inst_108557 = cljs.core.async.put_BANG_.call(null,inst_108554,false);
var state_108571__$1 = (function (){var statearr_108580 = state_108571;
(statearr_108580[(10)] = inst_108556);

return statearr_108580;
})();
var statearr_108581_108596 = state_108571__$1;
(statearr_108581_108596[(2)] = inst_108557);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_108571__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108572 === (5))){
var inst_108548 = fluree.db.util.log.info.call(null,"Web socket pub/producer channel closed.");
var state_108571__$1 = state_108571;
var statearr_108582_108597 = state_108571__$1;
(statearr_108582_108597[(2)] = inst_108548);

(statearr_108582_108597[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108572 === (10))){
var inst_108554 = (state_108571[(8)]);
var inst_108553 = (state_108571[(9)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_108571,(9),Error,null,(8));
var inst_108561 = ws.send(inst_108553);
var inst_108562 = cljs.core.async.put_BANG_.call(null,inst_108554,true);
var state_108571__$1 = (function (){var statearr_108583 = state_108571;
(statearr_108583[(11)] = inst_108561);

return statearr_108583;
})();
var statearr_108584_108598 = state_108571__$1;
(statearr_108584_108598[(2)] = inst_108562);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_108571__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108572 === (8))){
var inst_108564 = (state_108571[(2)]);
var state_108571__$1 = (function (){var statearr_108585 = state_108571;
(statearr_108585[(12)] = inst_108564);

return statearr_108585;
})();
var statearr_108586_108599 = state_108571__$1;
(statearr_108586_108599[(2)] = null);

(statearr_108586_108599[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__99975__auto__ = null;
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__99975__auto____0 = (function (){
var statearr_108587 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_108587[(0)] = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__99975__auto__);

(statearr_108587[(1)] = (1));

return statearr_108587;
});
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__99975__auto____1 = (function (state_108571){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_108571);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e108588){if((e108588 instanceof Object)){
var ex__99978__auto__ = e108588;
var statearr_108589_108600 = state_108571;
(statearr_108589_108600[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_108571);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e108588;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__108601 = state_108571;
state_108571 = G__108601;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__99975__auto__ = function(state_108571){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__99975__auto____1.call(this,state_108571);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__99975__auto____0;
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__99975__auto____1;
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_108590 = f__100070__auto__.call(null);
(statearr_108590[(6)] = c__100069__auto__);

return statearr_108590;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
fluree.db.util.xhttp.close_websocket = (function fluree$db$util$xhttp$close_websocket(ws){
return ws.close();
});
fluree.db.util.xhttp.try_socket = (function fluree$db$util$xhttp$try_socket(url,sub_chan,pub_chan,resp_chan,timeout,close_fn){
var ws = (new WebSocket(url));
var open_QMARK_ = cljs.core.async.promise_chan.call(null);
var timeout_chan = cljs.core.async.timeout.call(null,timeout);
(ws.binaryType = "arraybuffer");

(ws.onopen = (function (){
return cljs.core.async.put_BANG_.call(null,open_QMARK_,true);
}));

(ws.onmessage = (function (e){
return cljs.core.async.put_BANG_.call(null,sub_chan,e.data);
}));

(ws.onclose = (function (e){
fluree.db.util.log.warn.call(null,"Websocket closed: ",e.reason,"Code: ",e.code);

return close_fn.call(null);
}));

var c__100069__auto___108639 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_108627){
var state_val_108628 = (state_108627[(1)]);
if((state_val_108628 === (1))){
var inst_108606 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_108607 = [open_QMARK_,timeout_chan];
var inst_108608 = (new cljs.core.PersistentVector(null,2,(5),inst_108606,inst_108607,null));
var state_108627__$1 = state_108627;
return cljs.core.async.ioc_alts_BANG_.call(null,state_108627__$1,(2),inst_108608,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_108628 === (2))){
var inst_108610 = (state_108627[(2)]);
var inst_108611 = cljs.core.nth.call(null,inst_108610,(0),null);
var inst_108612 = cljs.core.nth.call(null,inst_108610,(1),null);
var inst_108613 = cljs.core._EQ_.call(null,inst_108612,timeout_chan);
var state_108627__$1 = (function (){var statearr_108629 = state_108627;
(statearr_108629[(7)] = inst_108611);

return statearr_108629;
})();
if(inst_108613){
var statearr_108630_108640 = state_108627__$1;
(statearr_108630_108640[(1)] = (3));

} else {
var statearr_108631_108641 = state_108627__$1;
(statearr_108631_108641[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108628 === (3))){
var inst_108615 = ["Timeout reached, unable to establish communication to server, which responded healthy: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)].join('');
var inst_108616 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_108617 = [(400),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_108618 = cljs.core.PersistentHashMap.fromArrays(inst_108616,inst_108617);
var inst_108619 = cljs.core.ex_info.call(null,inst_108615,inst_108618);
var inst_108620 = cljs.core.async.put_BANG_.call(null,resp_chan,inst_108619);
var inst_108621 = fluree.db.util.xhttp.close_websocket.call(null,ws);
var state_108627__$1 = (function (){var statearr_108632 = state_108627;
(statearr_108632[(8)] = inst_108620);

return statearr_108632;
})();
var statearr_108633_108642 = state_108627__$1;
(statearr_108633_108642[(2)] = inst_108621);

(statearr_108633_108642[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108628 === (4))){
var inst_108623 = fluree.db.util.xhttp.socket_publish_loop.call(null,ws,pub_chan);
var state_108627__$1 = state_108627;
var statearr_108634_108643 = state_108627__$1;
(statearr_108634_108643[(2)] = inst_108623);

(statearr_108634_108643[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108628 === (5))){
var inst_108625 = (state_108627[(2)]);
var state_108627__$1 = state_108627;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_108627__$1,inst_108625);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$try_socket_$_state_machine__99975__auto__ = null;
var fluree$db$util$xhttp$try_socket_$_state_machine__99975__auto____0 = (function (){
var statearr_108635 = [null,null,null,null,null,null,null,null,null];
(statearr_108635[(0)] = fluree$db$util$xhttp$try_socket_$_state_machine__99975__auto__);

(statearr_108635[(1)] = (1));

return statearr_108635;
});
var fluree$db$util$xhttp$try_socket_$_state_machine__99975__auto____1 = (function (state_108627){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_108627);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e108636){if((e108636 instanceof Object)){
var ex__99978__auto__ = e108636;
var statearr_108637_108644 = state_108627;
(statearr_108637_108644[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_108627);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e108636;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__108645 = state_108627;
state_108627 = G__108645;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$util$xhttp$try_socket_$_state_machine__99975__auto__ = function(state_108627){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$try_socket_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$try_socket_$_state_machine__99975__auto____1.call(this,state_108627);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$try_socket_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$try_socket_$_state_machine__99975__auto____0;
fluree$db$util$xhttp$try_socket_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$try_socket_$_state_machine__99975__auto____1;
return fluree$db$util$xhttp$try_socket_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_108638 = f__100070__auto__.call(null);
(statearr_108638[(6)] = c__100069__auto___108639);

return statearr_108638;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));


return new cljs.core.Keyword("fluree.db.util.xhttp","no-return","fluree.db.util.xhttp/no-return",1591333002);
});
