// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.query.schema');
goog.require('cljs.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.schema');
/**
 * Takes an predicate name (string) and returns the namespace portion of it as a keyword.
 */
fluree.db.query.schema.pred_name__GT_keyword = (function fluree$db$query$schema$pred_name__GT_keyword(pred_name){
if(typeof pred_name === 'string'){
return cljs.core.keyword.call(null,cljs.core.re_find.call(null,/[^\/]+$/,pred_name));
} else {
return null;
}
});
/**
 * Converts a tag sid for a _predicate/type attributes into a keyword of just the 'name'.
 */
fluree.db.query.schema.convert_type_to_kw = (function fluree$db$query$schema$convert_type_to_kw(type_tag_sid,db){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_104565){
var state_val_104566 = (state_104565[(1)]);
if((state_val_104566 === (1))){
var state_104565__$1 = state_104565;
var statearr_104567_104574 = state_104565__$1;
(statearr_104567_104574[(2)] = null);

(statearr_104567_104574[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104566 === (2))){
var inst_104563 = (state_104565[(2)]);
var state_104565__$1 = state_104565;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_104565__$1,inst_104563);
} else {
if((state_val_104566 === (3))){
var inst_104553 = (state_104565[(2)]);
var state_104565__$1 = state_104565;
var statearr_104568_104575 = state_104565__$1;
(statearr_104568_104575[(2)] = inst_104553);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_104565__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104566 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_104565,(3),Error,null,(2));
var inst_104557 = fluree.db.dbproto._tag.call(null,db,type_tag_sid,"_predicate/type");
var state_104565__$1 = state_104565;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_104565__$1,(5),inst_104557);
} else {
if((state_val_104566 === (5))){
var inst_104559 = (state_104565[(2)]);
var inst_104560 = fluree.db.util.async.throw_err.call(null,inst_104559);
var inst_104561 = cljs.core.keyword.call(null,inst_104560);
var state_104565__$1 = state_104565;
var statearr_104569_104576 = state_104565__$1;
(statearr_104569_104576[(2)] = inst_104561);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_104565__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__99975__auto__ = null;
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__99975__auto____0 = (function (){
var statearr_104570 = [null,null,null,null,null,null,null];
(statearr_104570[(0)] = fluree$db$query$schema$convert_type_to_kw_$_state_machine__99975__auto__);

(statearr_104570[(1)] = (1));

return statearr_104570;
});
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__99975__auto____1 = (function (state_104565){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_104565);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e104571){if((e104571 instanceof Object)){
var ex__99978__auto__ = e104571;
var statearr_104572_104577 = state_104565;
(statearr_104572_104577[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_104565);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e104571;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__104578 = state_104565;
state_104565 = G__104578;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$schema$convert_type_to_kw_$_state_machine__99975__auto__ = function(state_104565){
switch(arguments.length){
case 0:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__99975__auto____1.call(this,state_104565);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$convert_type_to_kw_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__99975__auto____0;
fluree$db$query$schema$convert_type_to_kw_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__99975__auto____1;
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_104573 = f__100070__auto__.call(null);
(statearr_104573[(6)] = c__100069__auto__);

return statearr_104573;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
fluree.db.query.schema.pred_objects_unique_QMARK_ = (function fluree$db$query$schema$pred_objects_unique_QMARK_(db,pred_id){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_104607){
var state_val_104608 = (state_104607[(1)]);
if((state_val_104608 === (7))){
var inst_104592 = (state_104607[(7)]);
var state_104607__$1 = state_104607;
var statearr_104609_104626 = state_104607__$1;
(statearr_104609_104626[(2)] = inst_104592);

(statearr_104609_104626[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104608 === (1))){
var state_104607__$1 = state_104607;
var statearr_104610_104627 = state_104607__$1;
(statearr_104610_104627[(2)] = null);

(statearr_104610_104627[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104608 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_104607,(3),Error,null,(2));
var inst_104584 = (function (){return (function (p1__104579_SHARP_){
return p1__104579_SHARP_.o;
});
})();
var inst_104585 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_104586 = [pred_id];
var inst_104587 = (new cljs.core.PersistentVector(null,1,(5),inst_104585,inst_104586,null));
var inst_104588 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_104587);
var state_104607__$1 = (function (){var statearr_104611 = state_104607;
(statearr_104611[(8)] = inst_104584);

return statearr_104611;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_104607__$1,(5),inst_104588);
} else {
if((state_val_104608 === (6))){
var inst_104592 = (state_104607[(7)]);
var inst_104594 = cljs.core.empty_QMARK_.call(null,inst_104592);
var inst_104595 = (!(inst_104594));
var state_104607__$1 = state_104607;
var statearr_104612_104628 = state_104607__$1;
(statearr_104612_104628[(2)] = inst_104595);

(statearr_104612_104628[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104608 === (3))){
var inst_104580 = (state_104607[(2)]);
var state_104607__$1 = state_104607;
var statearr_104613_104629 = state_104607__$1;
(statearr_104613_104629[(2)] = inst_104580);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_104607__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104608 === (2))){
var inst_104605 = (state_104607[(2)]);
var state_104607__$1 = state_104607;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_104607__$1,inst_104605);
} else {
if((state_val_104608 === (11))){
var inst_104603 = (state_104607[(2)]);
var state_104607__$1 = state_104607;
var statearr_104614_104630 = state_104607__$1;
(statearr_104614_104630[(2)] = inst_104603);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_104607__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104608 === (9))){
var inst_104592 = (state_104607[(7)]);
var inst_104600 = cljs.core.apply.call(null,cljs.core.distinct_QMARK_,inst_104592);
var state_104607__$1 = state_104607;
var statearr_104615_104631 = state_104607__$1;
(statearr_104615_104631[(2)] = inst_104600);

(statearr_104615_104631[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104608 === (5))){
var inst_104584 = (state_104607[(8)]);
var inst_104592 = (state_104607[(7)]);
var inst_104590 = (state_104607[(2)]);
var inst_104591 = fluree.db.util.async.throw_err.call(null,inst_104590);
var inst_104592__$1 = cljs.core.map.call(null,inst_104584,inst_104591);
var state_104607__$1 = (function (){var statearr_104616 = state_104607;
(statearr_104616[(7)] = inst_104592__$1);

return statearr_104616;
})();
if(cljs.core.truth_(inst_104592__$1)){
var statearr_104617_104632 = state_104607__$1;
(statearr_104617_104632[(1)] = (6));

} else {
var statearr_104618_104633 = state_104607__$1;
(statearr_104618_104633[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104608 === (10))){
var state_104607__$1 = state_104607;
var statearr_104619_104634 = state_104607__$1;
(statearr_104619_104634[(2)] = true);

(statearr_104619_104634[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104608 === (8))){
var inst_104598 = (state_104607[(2)]);
var state_104607__$1 = state_104607;
if(cljs.core.truth_(inst_104598)){
var statearr_104620_104635 = state_104607__$1;
(statearr_104620_104635[(1)] = (9));

} else {
var statearr_104621_104636 = state_104607__$1;
(statearr_104621_104636[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__99975__auto__ = null;
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__99975__auto____0 = (function (){
var statearr_104622 = [null,null,null,null,null,null,null,null,null];
(statearr_104622[(0)] = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__99975__auto__);

(statearr_104622[(1)] = (1));

return statearr_104622;
});
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__99975__auto____1 = (function (state_104607){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_104607);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e104623){if((e104623 instanceof Object)){
var ex__99978__auto__ = e104623;
var statearr_104624_104637 = state_104607;
(statearr_104624_104637[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_104607);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e104623;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__104638 = state_104607;
state_104607 = G__104638;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__99975__auto__ = function(state_104607){
switch(arguments.length){
case 0:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__99975__auto____1.call(this,state_104607);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__99975__auto____0;
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__99975__auto____1;
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_104625 = f__100070__auto__.call(null);
(statearr_104625[(6)] = c__100069__auto__);

return statearr_104625;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Returns a map of predicate changes with their respective old
 *   value and new value, both the key and value of the map are two-tuples as follows:
 *   {subid  {:new?  true
 *        :type  {:old :int :new :long}
 *        :index {:old nil  :new true }}}
 * 
 *   If the predicate being changed is the :type, it resolves the type _tag to its short keyword name
 * 
 *   When an old value does not exist, old-val is nil.
 *   If they subject being created is completely new, :new? true 
 */
fluree.db.query.schema.new_pred_changes = (function fluree$db$query$schema$new_pred_changes(db,tempids,flakes){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_104712){
var state_val_104713 = (state_104712[(1)]);
if((state_val_104713 === (7))){
var inst_104663 = (state_104712[(7)]);
var state_104712__$1 = state_104712;
var statearr_104714_104740 = state_104712__$1;
(statearr_104714_104740[(2)] = inst_104663);

(statearr_104714_104740[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104713 === (1))){
var state_104712__$1 = state_104712;
var statearr_104715_104741 = state_104712__$1;
(statearr_104715_104741[(2)] = null);

(statearr_104715_104741[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104713 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_104712,(3),Error,null,(2));
var inst_104645 = cljs.core.filter.call(null,fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
var inst_104646 = cljs.core.PersistentHashSet.EMPTY;
var inst_104647 = cljs.core.vals.call(null,tempids);
var inst_104648 = cljs.core.into.call(null,inst_104646,inst_104647);
var inst_104649 = (function (){var pred_flakes = inst_104645;
var is_new_QMARK_ = inst_104648;
return (function (p1__104639_SHARP_,p2__104640_SHARP_){
return cljs.core.assoc_in.call(null,p1__104639_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2__104640_SHARP_.s,new cljs.core.Keyword(null,"new?","new?",777958557)], null),cljs.core.boolean$.call(null,is_new_QMARK_.call(null,p2__104640_SHARP_.s)));
});
})();
var inst_104650 = cljs.core.PersistentHashMap.EMPTY;
var inst_104651 = cljs.core.reduce.call(null,inst_104649,inst_104650,inst_104645);
var inst_104659 = cljs.core.seq.call(null,inst_104645);
var inst_104660 = cljs.core.first.call(null,inst_104659);
var inst_104661 = cljs.core.next.call(null,inst_104659);
var inst_104662 = inst_104645;
var inst_104663 = inst_104651;
var state_104712__$1 = (function (){var statearr_104716 = state_104712;
(statearr_104716[(8)] = inst_104662);

(statearr_104716[(9)] = inst_104661);

(statearr_104716[(10)] = inst_104660);

(statearr_104716[(7)] = inst_104663);

return statearr_104716;
})();
var statearr_104717_104742 = state_104712__$1;
(statearr_104717_104742[(2)] = null);

(statearr_104717_104742[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104713 === (15))){
var inst_104676 = (state_104712[(11)]);
var inst_104669 = (state_104712[(12)]);
var inst_104689 = (state_104712[(13)]);
var inst_104663 = (state_104712[(7)]);
var inst_104697 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_104698 = inst_104669.s;
var inst_104699 = [inst_104698,inst_104676,new cljs.core.Keyword(null,"new","new",-2085437848)];
var inst_104700 = (new cljs.core.PersistentVector(null,3,(5),inst_104697,inst_104699,null));
var inst_104701 = cljs.core.assoc_in.call(null,inst_104663,inst_104700,inst_104689);
var state_104712__$1 = state_104712;
var statearr_104718_104743 = state_104712__$1;
(statearr_104718_104743[(2)] = inst_104701);

(statearr_104718_104743[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104713 === (13))){
var inst_104684 = (state_104712[(2)]);
var inst_104685 = fluree.db.util.async.throw_err.call(null,inst_104684);
var state_104712__$1 = state_104712;
var statearr_104719_104744 = state_104712__$1;
(statearr_104719_104744[(2)] = inst_104685);

(statearr_104719_104744[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104713 === (6))){
var inst_104708 = (state_104712[(2)]);
var state_104712__$1 = state_104712;
var statearr_104720_104745 = state_104712__$1;
(statearr_104720_104745[(2)] = inst_104708);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_104712__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104713 === (3))){
var inst_104641 = (state_104712[(2)]);
var state_104712__$1 = state_104712;
var statearr_104721_104746 = state_104712__$1;
(statearr_104721_104746[(2)] = inst_104641);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_104712__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104713 === (12))){
var inst_104678 = (state_104712[(14)]);
var inst_104689 = (state_104712[(2)]);
var state_104712__$1 = (function (){var statearr_104722 = state_104712;
(statearr_104722[(13)] = inst_104689);

return statearr_104722;
})();
if(cljs.core.truth_(inst_104678)){
var statearr_104723_104747 = state_104712__$1;
(statearr_104723_104747[(1)] = (14));

} else {
var statearr_104724_104748 = state_104712__$1;
(statearr_104724_104748[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104713 === (2))){
var inst_104710 = (state_104712[(2)]);
var state_104712__$1 = state_104712;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_104712__$1,inst_104710);
} else {
if((state_val_104713 === (11))){
var inst_104669 = (state_104712[(12)]);
var inst_104687 = inst_104669.o;
var state_104712__$1 = state_104712;
var statearr_104725_104749 = state_104712__$1;
(statearr_104725_104749[(2)] = inst_104687);

(statearr_104725_104749[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104713 === (9))){
var inst_104706 = (state_104712[(2)]);
var state_104712__$1 = state_104712;
var statearr_104726_104750 = state_104712__$1;
(statearr_104726_104750[(2)] = inst_104706);

(statearr_104726_104750[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104713 === (5))){
var inst_104662 = (state_104712[(8)]);
var inst_104669 = (state_104712[(12)]);
var inst_104668 = cljs.core.seq.call(null,inst_104662);
var inst_104669__$1 = cljs.core.first.call(null,inst_104668);
var inst_104670 = cljs.core.next.call(null,inst_104668);
var inst_104671 = cljs.core.not.call(null,inst_104669__$1);
var state_104712__$1 = (function (){var statearr_104727 = state_104712;
(statearr_104727[(12)] = inst_104669__$1);

(statearr_104727[(15)] = inst_104670);

return statearr_104727;
})();
if(inst_104671){
var statearr_104728_104751 = state_104712__$1;
(statearr_104728_104751[(1)] = (7));

} else {
var statearr_104729_104752 = state_104712__$1;
(statearr_104729_104752[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104713 === (14))){
var inst_104676 = (state_104712[(11)]);
var inst_104669 = (state_104712[(12)]);
var inst_104689 = (state_104712[(13)]);
var inst_104663 = (state_104712[(7)]);
var inst_104691 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_104692 = inst_104669.s;
var inst_104693 = [inst_104692,inst_104676,new cljs.core.Keyword(null,"old","old",-1825222690)];
var inst_104694 = (new cljs.core.PersistentVector(null,3,(5),inst_104691,inst_104693,null));
var inst_104695 = cljs.core.assoc_in.call(null,inst_104663,inst_104694,inst_104689);
var state_104712__$1 = state_104712;
var statearr_104730_104753 = state_104712__$1;
(statearr_104730_104753[(2)] = inst_104695);

(statearr_104730_104753[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104713 === (16))){
var inst_104670 = (state_104712[(15)]);
var inst_104703 = (state_104712[(2)]);
var inst_104662 = inst_104670;
var inst_104663 = inst_104703;
var state_104712__$1 = (function (){var statearr_104731 = state_104712;
(statearr_104731[(8)] = inst_104662);

(statearr_104731[(7)] = inst_104663);

return statearr_104731;
})();
var statearr_104732_104754 = state_104712__$1;
(statearr_104732_104754[(2)] = null);

(statearr_104732_104754[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104713 === (10))){
var inst_104669 = (state_104712[(12)]);
var inst_104681 = inst_104669.o;
var inst_104682 = fluree.db.query.schema.convert_type_to_kw.call(null,inst_104681,db);
var state_104712__$1 = state_104712;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_104712__$1,(13),inst_104682);
} else {
if((state_val_104713 === (8))){
var inst_104676 = (state_104712[(11)]);
var inst_104669 = (state_104712[(12)]);
var inst_104674 = inst_104669.p;
var inst_104675 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_104674);
var inst_104676__$1 = fluree.db.query.schema.pred_name__GT_keyword.call(null,inst_104675);
var inst_104677 = inst_104669.op;
var inst_104678 = inst_104677 === false;
var inst_104679 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348),inst_104676__$1);
var state_104712__$1 = (function (){var statearr_104733 = state_104712;
(statearr_104733[(11)] = inst_104676__$1);

(statearr_104733[(14)] = inst_104678);

return statearr_104733;
})();
if(inst_104679){
var statearr_104734_104755 = state_104712__$1;
(statearr_104734_104755[(1)] = (10));

} else {
var statearr_104735_104756 = state_104712__$1;
(statearr_104735_104756[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$new_pred_changes_$_state_machine__99975__auto__ = null;
var fluree$db$query$schema$new_pred_changes_$_state_machine__99975__auto____0 = (function (){
var statearr_104736 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_104736[(0)] = fluree$db$query$schema$new_pred_changes_$_state_machine__99975__auto__);

(statearr_104736[(1)] = (1));

return statearr_104736;
});
var fluree$db$query$schema$new_pred_changes_$_state_machine__99975__auto____1 = (function (state_104712){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_104712);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e104737){if((e104737 instanceof Object)){
var ex__99978__auto__ = e104737;
var statearr_104738_104757 = state_104712;
(statearr_104738_104757[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_104712);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e104737;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__104758 = state_104712;
state_104712 = G__104758;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$schema$new_pred_changes_$_state_machine__99975__auto__ = function(state_104712){
switch(arguments.length){
case 0:
return fluree$db$query$schema$new_pred_changes_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$schema$new_pred_changes_$_state_machine__99975__auto____1.call(this,state_104712);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$new_pred_changes_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$new_pred_changes_$_state_machine__99975__auto____0;
fluree$db$query$schema$new_pred_changes_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$new_pred_changes_$_state_machine__99975__auto____1;
return fluree$db$query$schema$new_pred_changes_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_104739 = f__100070__auto__.call(null);
(statearr_104739[(6)] = c__100069__auto__);

return statearr_104739;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Throw an error if schema update attempt is invalid.
 */
fluree.db.query.schema.type_error = (function fluree$db$query$schema$type_error(var_args){
var G__104760 = arguments.length;
switch (G__104760) {
case 3:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3 = (function (current_type,new_type,throw_QMARK_){
return fluree.db.query.schema.type_error.call(null,null,current_type,new_type,throw_QMARK_);
}));

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4 = (function (db,current_type,new_type,throw_QMARK_){
var message = ["Cannot convert an _predicate from ",cljs.core.name.call(null,current_type)," to ",cljs.core.name.call(null,new_type),"."].join('');
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.call(null,message,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
} else {
return db;
}
}));

(fluree.db.query.schema.type_error.cljs$lang$maxFixedArity = 4);

/**
 * Accepts a db (should have root permissions) and a map of predicate changes as produced by new-pred-changes.
 *   Returns a db with updated idxs if relevant, i.e. if non-unique predicate converted to unique
 *   If optional throw? parameter is true, will throw with an ex-info error.
 */
fluree.db.query.schema.predicate_change_error = (function fluree$db$query$schema$predicate_change_error(var_args){
var G__104763 = arguments.length;
switch (G__104763) {
case 2:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2 = (function (pred_changes,db){
return fluree.db.query.schema.predicate_change_error.call(null,pred_changes,db,false);
}));

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3 = (function (pred_changes,db,throw_QMARK_){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_105067){
var state_val_105068 = (state_105067[(1)]);
if((state_val_105068 === (65))){
var inst_104931 = (state_105067[(7)]);
var state_105067__$1 = state_105067;
var G__105069_105234 = inst_104931;
var G__105069_105235__$1 = (((G__105069_105234 instanceof cljs.core.Keyword))?G__105069_105234.fqn:null);
switch (G__105069_105235__$1) {
case "long":
var statearr_105070_105237 = state_105067__$1;
(statearr_105070_105237[(1)] = (69));


break;
case "bigint":
var statearr_105071_105238 = state_105067__$1;
(statearr_105071_105238[(1)] = (73));


break;
case "double":
var statearr_105072_105239 = state_105067__$1;
(statearr_105072_105239[(1)] = (77));


break;
case "float":
var statearr_105073_105240 = state_105067__$1;
(statearr_105073_105240[(1)] = (81));


break;
case "bigdec":
var statearr_105074_105241 = state_105067__$1;
(statearr_105074_105241[(1)] = (85));


break;
case "string":
var statearr_105075_105242 = state_105067__$1;
(statearr_105075_105242[(1)] = (89));


break;
case "instant":
var statearr_105076_105243 = state_105067__$1;
(statearr_105076_105243[(1)] = (93));


break;
default:
var statearr_105077_105244 = state_105067__$1;
(statearr_105077_105244[(1)] = (97));



}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (70))){
var inst_104898 = (state_105067[(8)]);
var state_105067__$1 = state_105067;
var statearr_105078_105245 = state_105067__$1;
(statearr_105078_105245[(2)] = inst_104898);

(statearr_105078_105245[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (62))){
var inst_104930 = (state_105067[(9)]);
var inst_104931 = (state_105067[(7)]);
var inst_104940 = fluree.db.query.schema.type_error.call(null,inst_104930,inst_104931,throw_QMARK_);
var state_105067__$1 = state_105067;
var statearr_105079_105246 = state_105067__$1;
(statearr_105079_105246[(2)] = inst_104940);

(statearr_105079_105246[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (74))){
var inst_104898 = (state_105067[(8)]);
var state_105067__$1 = state_105067;
var statearr_105080_105247 = state_105067__$1;
(statearr_105080_105247[(2)] = inst_104898);

(statearr_105080_105247[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (7))){
var inst_104787 = (state_105067[(10)]);
var state_105067__$1 = state_105067;
var statearr_105081_105248 = state_105067__$1;
(statearr_105081_105248[(2)] = inst_104787);

(statearr_105081_105248[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (59))){
var inst_104898 = (state_105067[(8)]);
var state_105067__$1 = state_105067;
var statearr_105082_105249 = state_105067__$1;
(statearr_105082_105249[(2)] = inst_104898);

(statearr_105082_105249[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (86))){
var inst_104898 = (state_105067[(8)]);
var state_105067__$1 = state_105067;
var statearr_105083_105250 = state_105067__$1;
(statearr_105083_105250[(2)] = inst_104898);

(statearr_105083_105250[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (20))){
var inst_104822 = (state_105067[(11)]);
var state_105067__$1 = state_105067;
var statearr_105084_105251 = state_105067__$1;
(statearr_105084_105251[(2)] = inst_104822);

(statearr_105084_105251[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (72))){
var inst_104951 = (state_105067[(2)]);
var state_105067__$1 = state_105067;
var statearr_105085_105252 = state_105067__$1;
(statearr_105085_105252[(2)] = inst_104951);

(statearr_105085_105252[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (58))){
var inst_104930 = (state_105067[(9)]);
var inst_104931 = (state_105067[(7)]);
var inst_104929 = (state_105067[(2)]);
var inst_104930__$1 = cljs.core.get.call(null,inst_104929,new cljs.core.Keyword(null,"old","old",-1825222690));
var inst_104931__$1 = cljs.core.get.call(null,inst_104929,new cljs.core.Keyword(null,"new","new",-2085437848));
var inst_104932 = cljs.core._EQ_.call(null,inst_104931__$1,inst_104930__$1);
var state_105067__$1 = (function (){var statearr_105086 = state_105067;
(statearr_105086[(9)] = inst_104930__$1);

(statearr_105086[(7)] = inst_104931__$1);

return statearr_105086;
})();
if(inst_104932){
var statearr_105087_105253 = state_105067__$1;
(statearr_105087_105253[(1)] = (59));

} else {
var statearr_105088_105254 = state_105067__$1;
(statearr_105088_105254[(1)] = (60));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (60))){
var inst_104930 = (state_105067[(9)]);
var inst_104931 = (state_105067[(7)]);
var inst_104935 = [new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"string","string",-1989541586),null,new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),null];
var inst_104936 = inst_104931.call(null,cljs.core.PersistentArrayMap,null,3,inst_104935,null);
var inst_104937 = inst_104931.call(null,cljs.core.PersistentHashSet,null,inst_104936,null);
var inst_104938 = inst_104937.call(null,inst_104930);
var state_105067__$1 = state_105067;
if(cljs.core.truth_(inst_104938)){
var statearr_105089_105255 = state_105067__$1;
(statearr_105089_105255[(1)] = (62));

} else {
var statearr_105090_105256 = state_105067__$1;
(statearr_105090_105256[(1)] = (63));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (27))){
var inst_104848 = (state_105067[(2)]);
var state_105067__$1 = state_105067;
var statearr_105091_105257 = state_105067__$1;
(statearr_105091_105257[(2)] = inst_104848);

(statearr_105091_105257[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (1))){
var state_105067__$1 = state_105067;
var statearr_105092_105258 = state_105067__$1;
(statearr_105092_105258[(2)] = null);

(statearr_105092_105258[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (69))){
var inst_104930 = (state_105067[(9)]);
var inst_104931 = (state_105067[(7)]);
var inst_104943 = [new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_104944 = inst_104931.call(null,cljs.core.PersistentArrayMap,null,2,inst_104943,null);
var inst_104945 = inst_104931.call(null,cljs.core.PersistentHashSet,null,inst_104944,null);
var inst_104946 = inst_104945.call(null,inst_104930);
var state_105067__$1 = state_105067;
if(cljs.core.truth_(inst_104946)){
var statearr_105093_105259 = state_105067__$1;
(statearr_105093_105259[(1)] = (70));

} else {
var statearr_105094_105260 = state_105067__$1;
(statearr_105094_105260[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (101))){
var inst_104799 = (state_105067[(12)]);
var inst_105032 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_104799);
var inst_105033 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_105032);
var inst_105034 = inst_105033 === true;
var inst_105035 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_104799);
var inst_105036 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_105035);
var inst_105037 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"ref","ref",1289896967),inst_105036);
var inst_105038 = (!(inst_105037));
var inst_105039 = ((inst_105034) && (inst_105038));
var state_105067__$1 = state_105067;
var statearr_105095_105261 = state_105067__$1;
(statearr_105095_105261[(2)] = inst_105039);

(statearr_105095_105261[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (24))){
var inst_104852 = (state_105067[(13)]);
var inst_104799 = (state_105067[(12)]);
var inst_104851 = (state_105067[(2)]);
var inst_104852__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_104799);
var state_105067__$1 = (function (){var statearr_105096 = state_105067;
(statearr_105096[(14)] = inst_104851);

(statearr_105096[(13)] = inst_104852__$1);

return statearr_105096;
})();
if(cljs.core.truth_(inst_104852__$1)){
var statearr_105097_105262 = state_105067__$1;
(statearr_105097_105262[(1)] = (28));

} else {
var statearr_105098_105263 = state_105067__$1;
(statearr_105098_105263[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (102))){
var inst_105030 = (state_105067[(15)]);
var state_105067__$1 = state_105067;
var statearr_105099_105264 = state_105067__$1;
(statearr_105099_105264[(2)] = inst_105030);

(statearr_105099_105264[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (55))){
var inst_104921 = (state_105067[(2)]);
var state_105067__$1 = state_105067;
var statearr_105100_105265 = state_105067__$1;
(statearr_105100_105265[(2)] = inst_104921);

(statearr_105100_105265[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (85))){
var inst_104930 = (state_105067[(9)]);
var inst_104931 = (state_105067[(7)]);
var inst_104983 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"double","double",884886883),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_104984 = inst_104931.call(null,cljs.core.PersistentArrayMap,null,5,inst_104983,null);
var inst_104985 = inst_104931.call(null,cljs.core.PersistentHashSet,null,inst_104984,null);
var inst_104986 = inst_104985.call(null,inst_104930);
var state_105067__$1 = state_105067;
if(cljs.core.truth_(inst_104986)){
var statearr_105101_105266 = state_105067__$1;
(statearr_105101_105266[(1)] = (86));

} else {
var statearr_105102_105267 = state_105067__$1;
(statearr_105102_105267[(1)] = (87));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (39))){
var inst_104867 = (state_105067[(16)]);
var state_105067__$1 = state_105067;
var statearr_105103_105268 = state_105067__$1;
(statearr_105103_105268[(2)] = inst_104867);

(statearr_105103_105268[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (88))){
var inst_104991 = (state_105067[(2)]);
var state_105067__$1 = state_105067;
var statearr_105104_105269 = state_105067__$1;
(statearr_105104_105269[(2)] = inst_104991);

(statearr_105104_105269[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (46))){
var inst_104905 = (state_105067[(2)]);
var state_105067__$1 = state_105067;
if(cljs.core.truth_(inst_104905)){
var statearr_105105_105270 = state_105067__$1;
(statearr_105105_105270[(1)] = (47));

} else {
var statearr_105106_105271 = state_105067__$1;
(statearr_105106_105271[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_105067,(3),Error,null,(2));
var inst_104781 = cljs.core.seq.call(null,pred_changes);
var inst_104782 = cljs.core.first.call(null,inst_104781);
var inst_104783 = cljs.core.next.call(null,inst_104781);
var inst_104784 = cljs.core.nth.call(null,inst_104782,(0),null);
var inst_104785 = cljs.core.nth.call(null,inst_104782,(1),null);
var inst_104786 = pred_changes;
var inst_104787 = db;
var state_105067__$1 = (function (){var statearr_105107 = state_105067;
(statearr_105107[(10)] = inst_104787);

(statearr_105107[(17)] = inst_104783);

(statearr_105107[(18)] = inst_104784);

(statearr_105107[(19)] = inst_104786);

(statearr_105107[(20)] = inst_104785);

return statearr_105107;
})();
var statearr_105108_105272 = state_105067__$1;
(statearr_105108_105272[(2)] = null);

(statearr_105108_105272[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (77))){
var inst_104930 = (state_105067[(9)]);
var inst_104931 = (state_105067[(7)]);
var inst_104963 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_104964 = inst_104931.call(null,cljs.core.PersistentArrayMap,null,3,inst_104963,null);
var inst_104965 = inst_104931.call(null,cljs.core.PersistentHashSet,null,inst_104964,null);
var inst_104966 = inst_104965.call(null,inst_104930);
var state_105067__$1 = state_105067;
if(cljs.core.truth_(inst_104966)){
var statearr_105109_105273 = state_105067__$1;
(statearr_105109_105273[(1)] = (78));

} else {
var statearr_105110_105274 = state_105067__$1;
(statearr_105110_105274[(1)] = (79));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (106))){
var inst_104797 = (state_105067[(21)]);
var inst_105058 = (state_105067[(2)]);
var inst_104786 = inst_104797;
var inst_104787 = inst_105058;
var state_105067__$1 = (function (){var statearr_105111 = state_105067;
(statearr_105111[(10)] = inst_104787);

(statearr_105111[(19)] = inst_104786);

return statearr_105111;
})();
var statearr_105112_105275 = state_105067__$1;
(statearr_105112_105275[(2)] = null);

(statearr_105112_105275[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (95))){
var inst_104930 = (state_105067[(9)]);
var inst_104931 = (state_105067[(7)]);
var inst_105009 = fluree.db.query.schema.type_error.call(null,inst_104930,inst_104931,throw_QMARK_);
var state_105067__$1 = state_105067;
var statearr_105113_105276 = state_105067__$1;
(statearr_105113_105276[(2)] = inst_105009);

(statearr_105113_105276[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (54))){
var state_105067__$1 = state_105067;
var statearr_105114_105277 = state_105067__$1;
(statearr_105114_105277[(2)] = false);

(statearr_105114_105277[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (92))){
var inst_105001 = (state_105067[(2)]);
var state_105067__$1 = state_105067;
var statearr_105115_105278 = state_105067__$1;
(statearr_105115_105278[(2)] = inst_105001);

(statearr_105115_105278[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (104))){
var state_105067__$1 = state_105067;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_105116_105279 = state_105067__$1;
(statearr_105116_105279[(1)] = (107));

} else {
var statearr_105117_105280 = state_105067__$1;
(statearr_105117_105280[(1)] = (108));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (15))){
var inst_104820 = (state_105067[(22)]);
var inst_104799 = (state_105067[(12)]);
var inst_104819 = (state_105067[(2)]);
var inst_104820__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_104799);
var state_105067__$1 = (function (){var statearr_105118 = state_105067;
(statearr_105118[(23)] = inst_104819);

(statearr_105118[(22)] = inst_104820__$1);

return statearr_105118;
})();
if(cljs.core.truth_(inst_104820__$1)){
var statearr_105119_105281 = state_105067__$1;
(statearr_105119_105281[(1)] = (16));

} else {
var statearr_105120_105282 = state_105067__$1;
(statearr_105120_105282[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (48))){
var inst_104898 = (state_105067[(8)]);
var state_105067__$1 = state_105067;
var statearr_105121_105283 = state_105067__$1;
(statearr_105121_105283[(2)] = inst_104898);

(statearr_105121_105283[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (50))){
var inst_104908 = (state_105067[(24)]);
var inst_104913 = inst_104908.cljs$lang$protocol_mask$partition0$;
var inst_104914 = (inst_104913 & (64));
var inst_104915 = inst_104908.cljs$core$ISeq$;
var inst_104916 = (cljs.core.PROTOCOL_SENTINEL === inst_104915);
var inst_104917 = ((inst_104914) || (inst_104916));
var state_105067__$1 = state_105067;
if(cljs.core.truth_(inst_104917)){
var statearr_105122_105284 = state_105067__$1;
(statearr_105122_105284[(1)] = (53));

} else {
var statearr_105123_105285 = state_105067__$1;
(statearr_105123_105285[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (75))){
var inst_104930 = (state_105067[(9)]);
var inst_104931 = (state_105067[(7)]);
var inst_104959 = fluree.db.query.schema.type_error.call(null,inst_104930,inst_104931,throw_QMARK_);
var state_105067__$1 = state_105067;
var statearr_105124_105286 = state_105067__$1;
(statearr_105124_105286[(2)] = inst_104959);

(statearr_105124_105286[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (99))){
var state_105067__$1 = state_105067;
var statearr_105125_105287 = state_105067__$1;
(statearr_105125_105287[(2)] = false);

(statearr_105125_105287[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (21))){
var inst_104835 = (state_105067[(2)]);
var state_105067__$1 = state_105067;
var statearr_105126_105288 = state_105067__$1;
(statearr_105126_105288[(2)] = inst_104835);

(statearr_105126_105288[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (31))){
var inst_104851 = (state_105067[(14)]);
var inst_104864 = fluree.db.query.schema.type_error.call(null,inst_104851,"a component","a non-component",throw_QMARK_);
var state_105067__$1 = state_105067;
var statearr_105127_105289 = state_105067__$1;
(statearr_105127_105289[(2)] = inst_104864);

(statearr_105127_105289[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (32))){
var inst_104851 = (state_105067[(14)]);
var state_105067__$1 = state_105067;
var statearr_105128_105290 = state_105067__$1;
(statearr_105128_105290[(2)] = inst_104851);

(statearr_105128_105290[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (40))){
var inst_104899 = (state_105067[(25)]);
var inst_104799 = (state_105067[(12)]);
var inst_104898 = (state_105067[(2)]);
var inst_104899__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_104799);
var state_105067__$1 = (function (){var statearr_105129 = state_105067;
(statearr_105129[(25)] = inst_104899__$1);

(statearr_105129[(8)] = inst_104898);

return statearr_105129;
})();
if(cljs.core.truth_(inst_104899__$1)){
var statearr_105130_105291 = state_105067__$1;
(statearr_105130_105291[(1)] = (44));

} else {
var statearr_105131_105292 = state_105067__$1;
(statearr_105131_105292[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (91))){
var inst_104930 = (state_105067[(9)]);
var inst_104931 = (state_105067[(7)]);
var inst_104999 = fluree.db.query.schema.type_error.call(null,inst_104930,inst_104931,throw_QMARK_);
var state_105067__$1 = state_105067;
var statearr_105132_105293 = state_105067__$1;
(statearr_105132_105293[(2)] = inst_104999);

(statearr_105132_105293[(1)] = (92));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (108))){
var inst_105026 = (state_105067[(26)]);
var state_105067__$1 = state_105067;
var statearr_105133_105294 = state_105067__$1;
(statearr_105133_105294[(2)] = inst_105026);

(statearr_105133_105294[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (56))){
var inst_104908 = (state_105067[(24)]);
var inst_104926 = cljs.core.apply.call(null,cljs.core.hash_map,inst_104908);
var state_105067__$1 = state_105067;
var statearr_105134_105295 = state_105067__$1;
(statearr_105134_105295[(2)] = inst_104926);

(statearr_105134_105295[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (33))){
var inst_104868 = (state_105067[(27)]);
var inst_104799 = (state_105067[(12)]);
var inst_104867 = (state_105067[(2)]);
var inst_104868__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_104799);
var state_105067__$1 = (function (){var statearr_105135 = state_105067;
(statearr_105135[(27)] = inst_104868__$1);

(statearr_105135[(16)] = inst_104867);

return statearr_105135;
})();
if(cljs.core.truth_(inst_104868__$1)){
var statearr_105136_105296 = state_105067__$1;
(statearr_105136_105296[(1)] = (34));

} else {
var statearr_105137_105297 = state_105067__$1;
(statearr_105137_105297[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (13))){
var inst_104787 = (state_105067[(10)]);
var inst_104816 = fluree.db.query.schema.type_error.call(null,inst_104787,"multi-cardinality","single-cardinality",throw_QMARK_);
var state_105067__$1 = state_105067;
var statearr_105138_105298 = state_105067__$1;
(statearr_105138_105298[(2)] = inst_104816);

(statearr_105138_105298[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (22))){
var state_105067__$1 = state_105067;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_105139_105299 = state_105067__$1;
(statearr_105139_105299[(1)] = (25));

} else {
var statearr_105140_105300 = state_105067__$1;
(statearr_105140_105300[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (90))){
var inst_104898 = (state_105067[(8)]);
var state_105067__$1 = state_105067;
var statearr_105141_105301 = state_105067__$1;
(statearr_105141_105301[(2)] = inst_104898);

(statearr_105141_105301[(1)] = (92));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (109))){
var inst_105055 = (state_105067[(2)]);
var state_105067__$1 = state_105067;
var statearr_105142_105302 = state_105067__$1;
(statearr_105142_105302[(2)] = inst_105055);

(statearr_105142_105302[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (36))){
var inst_104883 = (state_105067[(2)]);
var state_105067__$1 = state_105067;
if(cljs.core.truth_(inst_104883)){
var statearr_105143_105303 = state_105067__$1;
(statearr_105143_105303[(1)] = (38));

} else {
var statearr_105144_105304 = state_105067__$1;
(statearr_105144_105304[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (41))){
var inst_104798 = (state_105067[(28)]);
var inst_104787 = (state_105067[(10)]);
var inst_104886 = fluree.db.dbproto._p_prop.call(null,inst_104787,new cljs.core.Keyword(null,"name","name",1843675177),inst_104798);
var inst_104887 = ["The _predicate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_104886)," cannot be set to unique, because there are existing non-unique values."].join('');
var inst_104888 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_104889 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_104890 = cljs.core.PersistentHashMap.fromArrays(inst_104888,inst_104889);
var inst_104891 = cljs.core.ex_info.call(null,inst_104887,inst_104890);
var inst_104892 = (function(){throw inst_104891})();
var state_105067__$1 = state_105067;
var statearr_105145_105305 = state_105067__$1;
(statearr_105145_105305[(2)] = inst_104892);

(statearr_105145_105305[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (89))){
var inst_104930 = (state_105067[(9)]);
var inst_104931 = (state_105067[(7)]);
var inst_104993 = [new cljs.core.Keyword(null,"geojson","geojson",-719473398),null,new cljs.core.Keyword(null,"bytes","bytes",1175866680),null,new cljs.core.Keyword(null,"uri","uri",-774711847),null,new cljs.core.Keyword(null,"uuid","uuid",-2145095719),null,new cljs.core.Keyword(null,"json","json",1279968570),null];
var inst_104994 = inst_104931.call(null,cljs.core.PersistentArrayMap,null,5,inst_104993,null);
var inst_104995 = inst_104931.call(null,cljs.core.PersistentHashSet,null,inst_104994,null);
var inst_104996 = inst_104995.call(null,inst_104930);
var state_105067__$1 = state_105067;
if(cljs.core.truth_(inst_104996)){
var statearr_105146_105306 = state_105067__$1;
(statearr_105146_105306[(1)] = (90));

} else {
var statearr_105147_105307 = state_105067__$1;
(statearr_105147_105307[(1)] = (91));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (100))){
var inst_105045 = (state_105067[(2)]);
var state_105067__$1 = state_105067;
if(cljs.core.truth_(inst_105045)){
var statearr_105148_105308 = state_105067__$1;
(statearr_105148_105308[(1)] = (104));

} else {
var statearr_105149_105309 = state_105067__$1;
(statearr_105149_105309[(1)] = (105));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (43))){
var inst_104895 = (state_105067[(2)]);
var state_105067__$1 = state_105067;
var statearr_105150_105310 = state_105067__$1;
(statearr_105150_105310[(2)] = inst_104895);

(statearr_105150_105310[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (61))){
var inst_105023 = (state_105067[(2)]);
var state_105067__$1 = state_105067;
var statearr_105151_105311 = state_105067__$1;
(statearr_105151_105311[(2)] = inst_105023);

(statearr_105151_105311[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (29))){
var inst_104852 = (state_105067[(13)]);
var state_105067__$1 = state_105067;
var statearr_105152_105312 = state_105067__$1;
(statearr_105152_105312[(2)] = inst_104852);

(statearr_105152_105312[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (44))){
var inst_104799 = (state_105067[(12)]);
var inst_104901 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_104799);
var inst_104902 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_104901);
var state_105067__$1 = state_105067;
var statearr_105153_105313 = state_105067__$1;
(statearr_105153_105313[(2)] = inst_104902);

(statearr_105153_105313[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (93))){
var inst_104930 = (state_105067[(9)]);
var inst_104931 = (state_105067[(7)]);
var inst_105003 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_105004 = inst_104931.call(null,cljs.core.PersistentArrayMap,null,2,inst_105003,null);
var inst_105005 = inst_104931.call(null,cljs.core.PersistentHashSet,null,inst_105004,null);
var inst_105006 = inst_105005.call(null,inst_104930);
var state_105067__$1 = state_105067;
if(cljs.core.truth_(inst_105006)){
var statearr_105154_105314 = state_105067__$1;
(statearr_105154_105314[(1)] = (94));

} else {
var statearr_105155_105315 = state_105067__$1;
(statearr_105155_105315[(1)] = (95));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (6))){
var inst_105063 = (state_105067[(2)]);
var state_105067__$1 = state_105067;
var statearr_105156_105316 = state_105067__$1;
(statearr_105156_105316[(2)] = inst_105063);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_105067__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (28))){
var inst_104799 = (state_105067[(12)]);
var inst_104854 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_104799);
var inst_104855 = cljs.core.not.call(null,inst_104854);
var inst_104856 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_104799);
var inst_104857 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_104856);
var inst_104858 = inst_104857 === true;
var inst_104859 = ((inst_104855) && (inst_104858));
var state_105067__$1 = state_105067;
var statearr_105157_105317 = state_105067__$1;
(statearr_105157_105317[(2)] = inst_104859);

(statearr_105157_105317[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (64))){
var inst_105021 = (state_105067[(2)]);
var state_105067__$1 = state_105067;
var statearr_105158_105318 = state_105067__$1;
(statearr_105158_105318[(2)] = inst_105021);

(statearr_105158_105318[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (103))){
var inst_105042 = (state_105067[(2)]);
var state_105067__$1 = state_105067;
var statearr_105159_105319 = state_105067__$1;
(statearr_105159_105319[(2)] = inst_105042);

(statearr_105159_105319[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (51))){
var state_105067__$1 = state_105067;
var statearr_105160_105320 = state_105067__$1;
(statearr_105160_105320[(2)] = false);

(statearr_105160_105320[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (25))){
var inst_104841 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_104842 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_104843 = cljs.core.PersistentHashMap.fromArrays(inst_104841,inst_104842);
var inst_104844 = cljs.core.ex_info.call(null,"A boolean _predicate cannot be unique.",inst_104843);
var inst_104845 = (function(){throw inst_104844})();
var state_105067__$1 = state_105067;
var statearr_105161_105321 = state_105067__$1;
(statearr_105161_105321[(2)] = inst_104845);

(statearr_105161_105321[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (34))){
var inst_104798 = (state_105067[(28)]);
var inst_104787 = (state_105067[(10)]);
var inst_104799 = (state_105067[(12)]);
var inst_104870 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_104799);
var inst_104871 = cljs.core.not.call(null,inst_104870);
var inst_104872 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_104799);
var inst_104873 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_104872);
var inst_104874 = inst_104873 === true;
var inst_104875 = fluree.db.query.schema.pred_objects_unique_QMARK_.call(null,inst_104787,inst_104798);
var state_105067__$1 = (function (){var statearr_105162 = state_105067;
(statearr_105162[(29)] = inst_104871);

(statearr_105162[(30)] = inst_104874);

return statearr_105162;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_105067__$1,(37),inst_104875);
} else {
if((state_val_105068 === (17))){
var inst_104820 = (state_105067[(22)]);
var state_105067__$1 = state_105067;
var statearr_105163_105322 = state_105067__$1;
(statearr_105163_105322[(2)] = inst_104820);

(statearr_105163_105322[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (3))){
var inst_104764 = (state_105067[(2)]);
var state_105067__$1 = state_105067;
var statearr_105164_105323 = state_105067__$1;
(statearr_105164_105323[(2)] = inst_104764);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_105067__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (12))){
var inst_104814 = (state_105067[(2)]);
var state_105067__$1 = state_105067;
if(cljs.core.truth_(inst_104814)){
var statearr_105165_105324 = state_105067__$1;
(statearr_105165_105324[(1)] = (13));

} else {
var statearr_105166_105325 = state_105067__$1;
(statearr_105166_105325[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (2))){
var inst_105065 = (state_105067[(2)]);
var state_105067__$1 = state_105067;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_105067__$1,inst_105065);
} else {
if((state_val_105068 === (66))){
var state_105067__$1 = state_105067;
var statearr_105167_105326 = state_105067__$1;
(statearr_105167_105326[(2)] = null);

(statearr_105167_105326[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (107))){
var inst_105048 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_105049 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_105050 = cljs.core.PersistentHashMap.fromArrays(inst_105048,inst_105049);
var inst_105051 = cljs.core.ex_info.call(null,"A component _predicate must be of type \"ref.\"",inst_105050);
var inst_105052 = (function(){throw inst_105051})();
var state_105067__$1 = state_105067;
var statearr_105168_105327 = state_105067__$1;
(statearr_105168_105327[(2)] = inst_105052);

(statearr_105168_105327[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (23))){
var inst_104819 = (state_105067[(23)]);
var state_105067__$1 = state_105067;
var statearr_105169_105328 = state_105067__$1;
(statearr_105169_105328[(2)] = inst_104819);

(statearr_105169_105328[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (47))){
var inst_104908 = (state_105067[(24)]);
var inst_104799 = (state_105067[(12)]);
var inst_104908__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_104799);
var inst_104910 = (inst_104908__$1 == null);
var inst_104911 = cljs.core.not.call(null,inst_104910);
var state_105067__$1 = (function (){var statearr_105170 = state_105067;
(statearr_105170[(24)] = inst_104908__$1);

return statearr_105170;
})();
if(inst_104911){
var statearr_105171_105329 = state_105067__$1;
(statearr_105171_105329[(1)] = (50));

} else {
var statearr_105172_105330 = state_105067__$1;
(statearr_105172_105330[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (35))){
var inst_104868 = (state_105067[(27)]);
var state_105067__$1 = state_105067;
var statearr_105173_105331 = state_105067__$1;
(statearr_105173_105331[(2)] = inst_104868);

(statearr_105173_105331[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (82))){
var inst_104898 = (state_105067[(8)]);
var state_105067__$1 = state_105067;
var statearr_105174_105332 = state_105067__$1;
(statearr_105174_105332[(2)] = inst_104898);

(statearr_105174_105332[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (76))){
var inst_104961 = (state_105067[(2)]);
var state_105067__$1 = state_105067;
var statearr_105175_105333 = state_105067__$1;
(statearr_105175_105333[(2)] = inst_104961);

(statearr_105175_105333[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (97))){
var inst_104930 = (state_105067[(9)]);
var inst_104931 = (state_105067[(7)]);
var inst_105013 = fluree.db.query.schema.type_error.call(null,inst_104930,inst_104931,throw_QMARK_);
var state_105067__$1 = state_105067;
var statearr_105176_105334 = state_105067__$1;
(statearr_105176_105334[(2)] = inst_105013);

(statearr_105176_105334[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (19))){
var inst_104799 = (state_105067[(12)]);
var inst_104824 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_104799);
var inst_104825 = inst_104824 === true;
var inst_104826 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_104799);
var inst_104827 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_104826);
var inst_104828 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"boolean","boolean",-1919418404),inst_104827);
var inst_104829 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_104799);
var inst_104830 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_104829);
var inst_104831 = inst_104830 === true;
var inst_104832 = ((inst_104825) && (inst_104828) && (inst_104831));
var state_105067__$1 = state_105067;
var statearr_105177_105335 = state_105067__$1;
(statearr_105177_105335[(2)] = inst_104832);

(statearr_105177_105335[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (57))){
var inst_104908 = (state_105067[(24)]);
var state_105067__$1 = state_105067;
var statearr_105178_105336 = state_105067__$1;
(statearr_105178_105336[(2)] = inst_104908);

(statearr_105178_105336[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (68))){
var inst_105016 = (state_105067[(2)]);
var state_105067__$1 = state_105067;
var statearr_105179_105337 = state_105067__$1;
(statearr_105179_105337[(2)] = inst_105016);

(statearr_105179_105337[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (11))){
var inst_104803 = (state_105067[(31)]);
var state_105067__$1 = state_105067;
var statearr_105180_105338 = state_105067__$1;
(statearr_105180_105338[(2)] = inst_104803);

(statearr_105180_105338[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (9))){
var inst_105061 = (state_105067[(2)]);
var state_105067__$1 = state_105067;
var statearr_105181_105339 = state_105067__$1;
(statearr_105181_105339[(2)] = inst_105061);

(statearr_105181_105339[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (5))){
var inst_104798 = (state_105067[(28)]);
var inst_104786 = (state_105067[(19)]);
var inst_104795 = cljs.core.seq.call(null,inst_104786);
var inst_104796 = cljs.core.first.call(null,inst_104795);
var inst_104797 = cljs.core.next.call(null,inst_104795);
var inst_104798__$1 = cljs.core.nth.call(null,inst_104796,(0),null);
var inst_104799 = cljs.core.nth.call(null,inst_104796,(1),null);
var inst_104800 = cljs.core.not.call(null,inst_104798__$1);
var state_105067__$1 = (function (){var statearr_105182 = state_105067;
(statearr_105182[(28)] = inst_104798__$1);

(statearr_105182[(21)] = inst_104797);

(statearr_105182[(12)] = inst_104799);

return statearr_105182;
})();
if(inst_104800){
var statearr_105183_105340 = state_105067__$1;
(statearr_105183_105340[(1)] = (7));

} else {
var statearr_105184_105341 = state_105067__$1;
(statearr_105184_105341[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (83))){
var inst_104930 = (state_105067[(9)]);
var inst_104931 = (state_105067[(7)]);
var inst_104979 = fluree.db.query.schema.type_error.call(null,inst_104930,inst_104931,throw_QMARK_);
var state_105067__$1 = state_105067;
var statearr_105185_105342 = state_105067__$1;
(statearr_105185_105342[(2)] = inst_104979);

(statearr_105185_105342[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (14))){
var inst_104787 = (state_105067[(10)]);
var state_105067__$1 = state_105067;
var statearr_105186_105343 = state_105067__$1;
(statearr_105186_105343[(2)] = inst_104787);

(statearr_105186_105343[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (45))){
var inst_104899 = (state_105067[(25)]);
var state_105067__$1 = state_105067;
var statearr_105187_105344 = state_105067__$1;
(statearr_105187_105344[(2)] = inst_104899);

(statearr_105187_105344[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (53))){
var state_105067__$1 = state_105067;
var statearr_105188_105345 = state_105067__$1;
(statearr_105188_105345[(2)] = true);

(statearr_105188_105345[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (78))){
var inst_104898 = (state_105067[(8)]);
var state_105067__$1 = state_105067;
var statearr_105189_105346 = state_105067__$1;
(statearr_105189_105346[(2)] = inst_104898);

(statearr_105189_105346[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (26))){
var inst_104819 = (state_105067[(23)]);
var state_105067__$1 = state_105067;
var statearr_105190_105347 = state_105067__$1;
(statearr_105190_105347[(2)] = inst_104819);

(statearr_105190_105347[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (16))){
var inst_104799 = (state_105067[(12)]);
var inst_104822 = (state_105067[(11)]);
var inst_104822__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_104799);
var state_105067__$1 = (function (){var statearr_105191 = state_105067;
(statearr_105191[(11)] = inst_104822__$1);

return statearr_105191;
})();
if(cljs.core.truth_(inst_104822__$1)){
var statearr_105192_105348 = state_105067__$1;
(statearr_105192_105348[(1)] = (19));

} else {
var statearr_105193_105349 = state_105067__$1;
(statearr_105193_105349[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (81))){
var inst_104930 = (state_105067[(9)]);
var inst_104931 = (state_105067[(7)]);
var inst_104973 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_104974 = inst_104931.call(null,cljs.core.PersistentArrayMap,null,3,inst_104973,null);
var inst_104975 = inst_104931.call(null,cljs.core.PersistentHashSet,null,inst_104974,null);
var inst_104976 = inst_104975.call(null,inst_104930);
var state_105067__$1 = state_105067;
if(cljs.core.truth_(inst_104976)){
var statearr_105194_105350 = state_105067__$1;
(statearr_105194_105350[(1)] = (82));

} else {
var statearr_105195_105351 = state_105067__$1;
(statearr_105195_105351[(1)] = (83));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (79))){
var inst_104930 = (state_105067[(9)]);
var inst_104931 = (state_105067[(7)]);
var inst_104969 = fluree.db.query.schema.type_error.call(null,inst_104930,inst_104931,throw_QMARK_);
var state_105067__$1 = state_105067;
var statearr_105196_105352 = state_105067__$1;
(statearr_105196_105352[(2)] = inst_104969);

(statearr_105196_105352[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (38))){
var state_105067__$1 = state_105067;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_105197_105353 = state_105067__$1;
(statearr_105197_105353[(1)] = (41));

} else {
var statearr_105198_105354 = state_105067__$1;
(statearr_105198_105354[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (98))){
var inst_105030 = (state_105067[(15)]);
var inst_104799 = (state_105067[(12)]);
var inst_105030__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_104799);
var state_105067__$1 = (function (){var statearr_105199 = state_105067;
(statearr_105199[(15)] = inst_105030__$1);

return statearr_105199;
})();
if(cljs.core.truth_(inst_105030__$1)){
var statearr_105200_105355 = state_105067__$1;
(statearr_105200_105355[(1)] = (101));

} else {
var statearr_105201_105356 = state_105067__$1;
(statearr_105201_105356[(1)] = (102));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (87))){
var inst_104930 = (state_105067[(9)]);
var inst_104931 = (state_105067[(7)]);
var inst_104989 = fluree.db.query.schema.type_error.call(null,inst_104930,inst_104931,throw_QMARK_);
var state_105067__$1 = state_105067;
var statearr_105202_105357 = state_105067__$1;
(statearr_105202_105357[(2)] = inst_104989);

(statearr_105202_105357[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (30))){
var inst_104862 = (state_105067[(2)]);
var state_105067__$1 = state_105067;
if(cljs.core.truth_(inst_104862)){
var statearr_105203_105358 = state_105067__$1;
(statearr_105203_105358[(1)] = (31));

} else {
var statearr_105204_105359 = state_105067__$1;
(statearr_105204_105359[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (73))){
var inst_104930 = (state_105067[(9)]);
var inst_104931 = (state_105067[(7)]);
var inst_104953 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_104954 = inst_104931.call(null,cljs.core.PersistentArrayMap,null,3,inst_104953,null);
var inst_104955 = inst_104931.call(null,cljs.core.PersistentHashSet,null,inst_104954,null);
var inst_104956 = inst_104955.call(null,inst_104930);
var state_105067__$1 = state_105067;
if(cljs.core.truth_(inst_104956)){
var statearr_105205_105360 = state_105067__$1;
(statearr_105205_105360[(1)] = (74));

} else {
var statearr_105206_105361 = state_105067__$1;
(statearr_105206_105361[(1)] = (75));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (96))){
var inst_105011 = (state_105067[(2)]);
var state_105067__$1 = state_105067;
var statearr_105207_105362 = state_105067__$1;
(statearr_105207_105362[(2)] = inst_105011);

(statearr_105207_105362[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (10))){
var inst_104799 = (state_105067[(12)]);
var inst_104805 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_104799);
var inst_104806 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_104805);
var inst_104807 = inst_104806 === false;
var inst_104808 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_104799);
var inst_104809 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_104808);
var inst_104810 = inst_104809 === true;
var inst_104811 = ((inst_104807) && (inst_104810));
var state_105067__$1 = state_105067;
var statearr_105208_105363 = state_105067__$1;
(statearr_105208_105363[(2)] = inst_104811);

(statearr_105208_105363[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (18))){
var inst_104838 = (state_105067[(2)]);
var state_105067__$1 = state_105067;
if(cljs.core.truth_(inst_104838)){
var statearr_105209_105364 = state_105067__$1;
(statearr_105209_105364[(1)] = (22));

} else {
var statearr_105210_105365 = state_105067__$1;
(statearr_105210_105365[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (105))){
var inst_105026 = (state_105067[(26)]);
var state_105067__$1 = state_105067;
var statearr_105211_105366 = state_105067__$1;
(statearr_105211_105366[(2)] = inst_105026);

(statearr_105211_105366[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (52))){
var inst_104924 = (state_105067[(2)]);
var state_105067__$1 = state_105067;
if(cljs.core.truth_(inst_104924)){
var statearr_105212_105367 = state_105067__$1;
(statearr_105212_105367[(1)] = (56));

} else {
var statearr_105213_105368 = state_105067__$1;
(statearr_105213_105368[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (67))){
var inst_105019 = (state_105067[(2)]);
var state_105067__$1 = state_105067;
var statearr_105214_105369 = state_105067__$1;
(statearr_105214_105369[(2)] = inst_105019);

(statearr_105214_105369[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (71))){
var inst_104930 = (state_105067[(9)]);
var inst_104931 = (state_105067[(7)]);
var inst_104949 = fluree.db.query.schema.type_error.call(null,inst_104930,inst_104931,throw_QMARK_);
var state_105067__$1 = state_105067;
var statearr_105215_105370 = state_105067__$1;
(statearr_105215_105370[(2)] = inst_104949);

(statearr_105215_105370[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (42))){
var inst_104867 = (state_105067[(16)]);
var state_105067__$1 = state_105067;
var statearr_105216_105371 = state_105067__$1;
(statearr_105216_105371[(2)] = inst_104867);

(statearr_105216_105371[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (80))){
var inst_104971 = (state_105067[(2)]);
var state_105067__$1 = state_105067;
var statearr_105217_105372 = state_105067__$1;
(statearr_105217_105372[(2)] = inst_104971);

(statearr_105217_105372[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (37))){
var inst_104871 = (state_105067[(29)]);
var inst_104874 = (state_105067[(30)]);
var inst_104877 = (state_105067[(2)]);
var inst_104878 = fluree.db.util.async.throw_err.call(null,inst_104877);
var inst_104879 = cljs.core.not.call(null,inst_104878);
var inst_104880 = ((inst_104871) && (inst_104874) && (inst_104879));
var state_105067__$1 = state_105067;
var statearr_105218_105373 = state_105067__$1;
(statearr_105218_105373[(2)] = inst_104880);

(statearr_105218_105373[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (63))){
var state_105067__$1 = state_105067;
var statearr_105219_105374 = state_105067__$1;
(statearr_105219_105374[(1)] = (65));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (94))){
var inst_104898 = (state_105067[(8)]);
var state_105067__$1 = state_105067;
var statearr_105221_105375 = state_105067__$1;
(statearr_105221_105375[(2)] = inst_104898);

(statearr_105221_105375[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (8))){
var inst_104803 = (state_105067[(31)]);
var inst_104799 = (state_105067[(12)]);
var inst_104803__$1 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_104799);
var state_105067__$1 = (function (){var statearr_105222 = state_105067;
(statearr_105222[(31)] = inst_104803__$1);

return statearr_105222;
})();
if(cljs.core.truth_(inst_104803__$1)){
var statearr_105223_105376 = state_105067__$1;
(statearr_105223_105376[(1)] = (10));

} else {
var statearr_105224_105377 = state_105067__$1;
(statearr_105224_105377[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (49))){
var inst_104799 = (state_105067[(12)]);
var inst_105026 = (state_105067[(2)]);
var inst_105027 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_104799);
var inst_105028 = inst_105027 === true;
var state_105067__$1 = (function (){var statearr_105225 = state_105067;
(statearr_105225[(26)] = inst_105026);

return statearr_105225;
})();
if(cljs.core.truth_(inst_105028)){
var statearr_105226_105378 = state_105067__$1;
(statearr_105226_105378[(1)] = (98));

} else {
var statearr_105227_105379 = state_105067__$1;
(statearr_105227_105379[(1)] = (99));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105068 === (84))){
var inst_104981 = (state_105067[(2)]);
var state_105067__$1 = state_105067;
var statearr_105228_105380 = state_105067__$1;
(statearr_105228_105380[(2)] = inst_104981);

(statearr_105228_105380[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__99975__auto__ = null;
var fluree$db$query$schema$state_machine__99975__auto____0 = (function (){
var statearr_105229 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_105229[(0)] = fluree$db$query$schema$state_machine__99975__auto__);

(statearr_105229[(1)] = (1));

return statearr_105229;
});
var fluree$db$query$schema$state_machine__99975__auto____1 = (function (state_105067){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_105067);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e105230){if((e105230 instanceof Object)){
var ex__99978__auto__ = e105230;
var statearr_105231_105381 = state_105067;
(statearr_105231_105381[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_105067);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e105230;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__105382 = state_105067;
state_105067 = G__105382;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__99975__auto__ = function(state_105067){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__99975__auto____1.call(this,state_105067);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__99975__auto____0;
fluree$db$query$schema$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__99975__auto____1;
return fluree$db$query$schema$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_105232 = f__100070__auto__.call(null);
(statearr_105232[(6)] = c__100069__auto__);

return statearr_105232;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.query.schema.predicate_change_error.cljs$lang$maxFixedArity = 3);

fluree.db.query.schema.validate_schema_change = (function fluree$db$query$schema$validate_schema_change(db,tempids,flakes){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_105403){
var state_val_105404 = (state_105403[(1)]);
if((state_val_105404 === (7))){
var inst_105390 = (state_105403[(7)]);
var inst_105394 = fluree.db.query.schema.predicate_change_error.call(null,inst_105390,db,true);
var state_105403__$1 = state_105403;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_105403__$1,(9),inst_105394);
} else {
if((state_val_105404 === (1))){
var state_105403__$1 = state_105403;
var statearr_105405_105417 = state_105403__$1;
(statearr_105405_105417[(2)] = null);

(statearr_105405_105417[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105404 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_105403,(3),Error,null,(2));
var inst_105387 = fluree.db.query.schema.new_pred_changes.call(null,db,tempids,flakes);
var state_105403__$1 = state_105403;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_105403__$1,(5),inst_105387);
} else {
if((state_val_105404 === (6))){
var state_105403__$1 = state_105403;
var statearr_105406_105418 = state_105403__$1;
(statearr_105406_105418[(2)] = db);

(statearr_105406_105418[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105404 === (3))){
var inst_105383 = (state_105403[(2)]);
var state_105403__$1 = state_105403;
var statearr_105407_105419 = state_105403__$1;
(statearr_105407_105419[(2)] = inst_105383);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_105403__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105404 === (2))){
var inst_105401 = (state_105403[(2)]);
var state_105403__$1 = state_105403;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_105403__$1,inst_105401);
} else {
if((state_val_105404 === (9))){
var inst_105396 = (state_105403[(2)]);
var inst_105397 = fluree.db.util.async.throw_err.call(null,inst_105396);
var state_105403__$1 = state_105403;
var statearr_105408_105420 = state_105403__$1;
(statearr_105408_105420[(2)] = inst_105397);

(statearr_105408_105420[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105404 === (5))){
var inst_105390 = (state_105403[(7)]);
var inst_105389 = (state_105403[(2)]);
var inst_105390__$1 = fluree.db.util.async.throw_err.call(null,inst_105389);
var inst_105391 = cljs.core.empty_QMARK_.call(null,inst_105390__$1);
var state_105403__$1 = (function (){var statearr_105409 = state_105403;
(statearr_105409[(7)] = inst_105390__$1);

return statearr_105409;
})();
if(inst_105391){
var statearr_105410_105421 = state_105403__$1;
(statearr_105410_105421[(1)] = (6));

} else {
var statearr_105411_105422 = state_105403__$1;
(statearr_105411_105422[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105404 === (8))){
var inst_105399 = (state_105403[(2)]);
var state_105403__$1 = state_105403;
var statearr_105412_105423 = state_105403__$1;
(statearr_105412_105423[(2)] = inst_105399);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_105403__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$validate_schema_change_$_state_machine__99975__auto__ = null;
var fluree$db$query$schema$validate_schema_change_$_state_machine__99975__auto____0 = (function (){
var statearr_105413 = [null,null,null,null,null,null,null,null];
(statearr_105413[(0)] = fluree$db$query$schema$validate_schema_change_$_state_machine__99975__auto__);

(statearr_105413[(1)] = (1));

return statearr_105413;
});
var fluree$db$query$schema$validate_schema_change_$_state_machine__99975__auto____1 = (function (state_105403){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_105403);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e105414){if((e105414 instanceof Object)){
var ex__99978__auto__ = e105414;
var statearr_105415_105424 = state_105403;
(statearr_105415_105424[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_105403);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e105414;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__105425 = state_105403;
state_105403 = G__105425;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$schema$validate_schema_change_$_state_machine__99975__auto__ = function(state_105403){
switch(arguments.length){
case 0:
return fluree$db$query$schema$validate_schema_change_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$schema$validate_schema_change_$_state_machine__99975__auto____1.call(this,state_105403);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$validate_schema_change_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$validate_schema_change_$_state_machine__99975__auto____0;
fluree$db$query$schema$validate_schema_change_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$validate_schema_change_$_state_machine__99975__auto____1;
return fluree$db$query$schema$validate_schema_change_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_105416 = f__100070__auto__.call(null);
(statearr_105416[(6)] = c__100069__auto__);

return statearr_105416;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
fluree.db.query.schema.predicate_re = /(?:([^\/]+)\/)([^\/]+)/;
fluree.db.query.schema.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.query.schema.reverse_ref_QMARK_ = (function fluree$db$query$schema$reverse_ref_QMARK_(var_args){
var G__105427 = arguments.length;
switch (G__105427) {
case 1:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (predicate_name){
return fluree.db.query.schema.reverse_ref_QMARK_.call(null,predicate_name,false);
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (predicate_name,throw_QMARK_){
if(typeof predicate_name === 'string'){
return cljs.core.boolean$.call(null,cljs.core.re_matches.call(null,fluree.db.query.schema.pred_reverse_ref_re,predicate_name));
} else {
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.call(null,["Bad predicate name, should be string: ",cljs.core.pr_str.call(null,predicate_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
} else {
return false;
}
}
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$lang$maxFixedArity = 2);

/**
 * Reverses an predicate name.
 */
fluree.db.query.schema.reverse_ref = (function fluree$db$query$schema$reverse_ref(predicate_name){
if(typeof predicate_name === 'string'){
var vec__105429 = cljs.core.re_matches.call(null,/(?:([^\/]+)\/)?([^\/]+)/,predicate_name);
var _ = cljs.core.nth.call(null,vec__105429,(0),null);
var ns = cljs.core.nth.call(null,vec__105429,(1),null);
var name = cljs.core.nth.call(null,vec__105429,(2),null);
if(cljs.core.truth_(ns)){
if(cljs.core._EQ_.call(null,"_",cljs.core.nth.call(null,name,(0)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.subs.call(null,name,(1))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('');
}
} else {
throw cljs.core.ex_info.call(null,["Bad predicate name, does not contain a namespace portion: ",cljs.core.pr_str.call(null,predicate_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
throw cljs.core.ex_info.call(null,["Bad predicate name, should be string: ",cljs.core.pr_str.call(null,predicate_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
fluree.db.query.schema.type_sid__GT_type = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid.call(null,(3),(2)),fluree.db.flake.__GT_sid.call(null,(3),(9)),fluree.db.flake.__GT_sid.call(null,(3),(14)),fluree.db.flake.__GT_sid.call(null,(3),(16)),fluree.db.flake.__GT_sid.call(null,(3),(8)),fluree.db.flake.__GT_sid.call(null,(3),(4)),fluree.db.flake.__GT_sid.call(null,(3),(5)),fluree.db.flake.__GT_sid.call(null,(3),(15)),fluree.db.flake.__GT_sid.call(null,(3),(17)),fluree.db.flake.__GT_sid.call(null,(3),(11)),fluree.db.flake.__GT_sid.call(null,(3),(12)),fluree.db.flake.__GT_sid.call(null,(3),(1)),fluree.db.flake.__GT_sid.call(null,(3),(10)),fluree.db.flake.__GT_sid.call(null,(3),(6)),fluree.db.flake.__GT_sid.call(null,(3),(7)),fluree.db.flake.__GT_sid.call(null,(3),(13))],[new cljs.core.Keyword(null,"ref","ref",1289896967),new cljs.core.Keyword(null,"int","int",-1741416922),new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"bytes","bytes",1175866680),new cljs.core.Keyword(null,"boolean","boolean",-1919418404),new cljs.core.Keyword(null,"instant","instant",655498374),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"geojson","geojson",-719473398),new cljs.core.Keyword(null,"bigint","bigint",-1710937017),new cljs.core.Keyword(null,"float","float",-1732389368),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"long","long",-171452093),new cljs.core.Keyword(null,"uuid","uuid",-2145095719),new cljs.core.Keyword(null,"uri","uri",-774711847),new cljs.core.Keyword(null,"double","double",884886883)]);
fluree.db.query.schema.lang_sid__GT_lang = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid.call(null,(3),(62)),fluree.db.flake.__GT_sid.call(null,(3),(68)),fluree.db.flake.__GT_sid.call(null,(3),(67)),fluree.db.flake.__GT_sid.call(null,(3),(69)),fluree.db.flake.__GT_sid.call(null,(3),(63)),fluree.db.flake.__GT_sid.call(null,(3),(70)),fluree.db.flake.__GT_sid.call(null,(3),(65)),fluree.db.flake.__GT_sid.call(null,(3),(66)),fluree.db.flake.__GT_sid.call(null,(3),(64)),fluree.db.flake.__GT_sid.call(null,(3),(61))],[new cljs.core.Keyword(null,"bn","bn",-1320495310),new cljs.core.Keyword(null,"hi","hi",-1821422114),new cljs.core.Keyword(null,"fr","fr",1577713888),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"br","br",934104792),new cljs.core.Keyword(null,"ru","ru",-1755311210),new cljs.core.Keyword(null,"en","en",88457073),new cljs.core.Keyword(null,"es","es",1831673219),new cljs.core.Keyword(null,"cn","cn",457269822),new cljs.core.Keyword(null,"ar","ar",-2093907980)]);
fluree.db.query.schema.flake__GT_pred_map = (function fluree$db$query$schema$flake__GT_pred_map(flakes){
return cljs.core.reduce.call(null,(function (acc,flake){
var p = flake.p;
var o = flake.o;
var existing_QMARK_ = cljs.core.get.call(null,acc,p);
if(cljs.core.truth_((function (){var and__4115__auto__ = existing_QMARK_;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.vector_QMARK_.call(null,existing_QMARK_);
} else {
return and__4115__auto__;
}
})())){
return cljs.core.update.call(null,acc,p,cljs.core.conj,o);
} else {
if(cljs.core.truth_(existing_QMARK_)){
return cljs.core.update.call(null,acc,p,(function (p1__105432_SHARP_,p2__105433_SHARP_){
return cljs.core.vec.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__105432_SHARP_,p2__105433_SHARP_], null));
}),o);
} else {
return cljs.core.assoc.call(null,acc,p,o);

}
}
}),cljs.core.PersistentArrayMap.EMPTY,flakes);
});
/**
 * Returns a map of the schema for a db to allow quick lookups of schema properties.
 *   Schema is a map with two keys:
 *   - :coll - collection info, mapping cid->name and name->cid all within the same map
 *   - :pred - predicate info, mapping pid->properties and name->properties for quick lookup based on id or name respectively
 *   
 */
fluree.db.query.schema.schema_map = (function fluree$db$query$schema$schema_map(db){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_105496){
var state_val_105497 = (state_105496[(1)]);
if((state_val_105497 === (1))){
var state_105496__$1 = state_105496;
var statearr_105498_105508 = state_105496__$1;
(statearr_105498_105508[(2)] = null);

(statearr_105498_105508[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105497 === (2))){
var inst_105494 = (state_105496[(2)]);
var state_105496__$1 = state_105496;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_105496__$1,inst_105494);
} else {
if((state_val_105497 === (3))){
var inst_105439 = (state_105496[(2)]);
var state_105496__$1 = state_105496;
var statearr_105499_105509 = state_105496__$1;
(statearr_105499_105509[(2)] = inst_105439);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_105496__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105497 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_105496,(3),Error,null,(2));
var inst_105449 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_105450 = fluree.db.flake.max_subject_id.call(null,(1));
var inst_105451 = [inst_105450];
var inst_105452 = (new cljs.core.PersistentVector(null,1,(5),inst_105449,inst_105451,null));
var inst_105453 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_105454 = [(0)];
var inst_105455 = (new cljs.core.PersistentVector(null,1,(5),inst_105453,inst_105454,null));
var inst_105456 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_105452,cljs.core._LT__EQ_,inst_105455);
var state_105496__$1 = state_105496;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_105496__$1,(5),inst_105456);
} else {
if((state_val_105497 === (5))){
var inst_105458 = (state_105496[(2)]);
var inst_105459 = fluree.db.util.async.throw_err.call(null,inst_105458);
var inst_105460 = (function (){var schema_flakes = inst_105459;
return (function (p1__105434_SHARP_){
return (p1__105434_SHARP_.s <= fluree.db.flake.MAX_COLL_SUBJECTS);
});
})();
var inst_105461 = cljs.core.partition_by.call(null,inst_105460,inst_105459);
var inst_105462 = cljs.core.nth.call(null,inst_105461,(0),null);
var inst_105463 = cljs.core.nth.call(null,inst_105461,(1),null);
var inst_105464 = (function (){var schema_flakes = inst_105459;
var vec__105443 = inst_105461;
var collection_flakes = inst_105462;
var predicate_flakes = inst_105463;
return (function (acc,coll_flakes){
var sid = cljs.core.first.call(null,coll_flakes).s;
var id = fluree.db.flake.sid__GT_i.call(null,sid);
var p__GT_v = cljs.core.reduce.call(null,(function (p1__105436_SHARP_,p2__105437_SHARP_){
return cljs.core.assoc.call(null,p1__105436_SHARP_,p2__105437_SHARP_.p,p2__105437_SHARP_.o);
}),cljs.core.PersistentArrayMap.EMPTY,coll_flakes);
var c_name = cljs.core.get.call(null,p__GT_v,(40));
var spec = cljs.core.get.call(null,p__GT_v,(43));
var specDoc = cljs.core.get.call(null,p__GT_v,(44));
var c_props = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),c_name,new cljs.core.Keyword(null,"sid","sid",1815016414),sid,new cljs.core.Keyword(null,"spec","spec",347520401),spec,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),specDoc,new cljs.core.Keyword(null,"id","id",-1388402092),id], null);
return cljs.core.assoc.call(null,acc,id,c_props,c_name,c_props);
});
})();
var inst_105465 = [(-1),"_tx"];
var inst_105466 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414)];
var inst_105467 = ["_tx",(-1),(-1)];
var inst_105468 = cljs.core.PersistentHashMap.fromArrays(inst_105466,inst_105467);
var inst_105469 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414)];
var inst_105470 = ["_tx",(-1),(-1)];
var inst_105471 = cljs.core.PersistentHashMap.fromArrays(inst_105469,inst_105470);
var inst_105472 = [inst_105468,inst_105471];
var inst_105473 = cljs.core.PersistentHashMap.fromArrays(inst_105465,inst_105472);
var inst_105474 = (function (){var schema_flakes = inst_105459;
var vec__105443 = inst_105461;
var collection_flakes = inst_105462;
var predicate_flakes = inst_105463;
return (function (p1__105435_SHARP_){
return p1__105435_SHARP_.s;
});
})();
var inst_105475 = cljs.core.partition_by.call(null,inst_105474,inst_105462);
var inst_105476 = cljs.core.reduce.call(null,inst_105464,inst_105473,inst_105475);
var inst_105478 = (function (){var schema_flakes = inst_105459;
var vec__105443 = inst_105461;
var collection_flakes = inst_105462;
var predicate_flakes = inst_105463;
var coll = inst_105476;
return (function (p__105477,pred_flakes){
var vec__105500 = p__105477;
var pred = cljs.core.nth.call(null,vec__105500,(0),null);
var fullText = cljs.core.nth.call(null,vec__105500,(1),null);
var id = cljs.core.first.call(null,pred_flakes).s;
var p__GT_v = fluree.db.query.schema.flake__GT_pred_map.call(null,pred_flakes);
var p_name = cljs.core.get.call(null,p__GT_v,(10));
var p_type = cljs.core.get.call(null,fluree.db.query.schema.type_sid__GT_type,cljs.core.get.call(null,p__GT_v,(12)));
var ref_QMARK_ = cljs.core.boolean$.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ref","ref",1289896967),null,new cljs.core.Keyword(null,"tag","tag",-1290361223),null], null), null).call(null,p_type));
var idx_QMARK_ = cljs.core.boolean$.call(null,(function (){var or__4126__auto__ = ref_QMARK_;
if(or__4126__auto__){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = cljs.core.get.call(null,p__GT_v,(15));
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return cljs.core.get.call(null,p__GT_v,(13));
}
}
})());
var fullText_QMARK_ = cljs.core.get.call(null,p__GT_v,(27));
var p_props = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"unique","unique",329397282),new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),new cljs.core.Keyword(null,"index","index",-1531685915),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),new cljs.core.Keyword(null,"component","component",1555936782),new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"multi","multi",-190293005),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),new cljs.core.Keyword(null,"idx?","idx?",-564590377),new cljs.core.Keyword(null,"ref?","ref?",1932693720),new cljs.core.Keyword(null,"upsert","upsert",1416724984),new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)],[cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(13))),cljs.core.get.call(null,p__GT_v,(19)),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(15))),p_name,cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(18))),p_type,cljs.core.get.call(null,p__GT_v,(24)),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(17))),cljs.core.get.call(null,p__GT_v,(25)),cljs.core.get.call(null,p__GT_v,(20)),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(14))),id,cljs.core.get.call(null,p__GT_v,(23)),idx_QMARK_,ref_QMARK_,cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(16))),cljs.core.get.call(null,p__GT_v,(26)),fullText_QMARK_]);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,pred,id,p_props,p_name,p_props),(cljs.core.truth_(fullText_QMARK_)?cljs.core.conj.call(null,fullText,id):fullText)], null);
});
})();
var inst_105479 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_105480 = cljs.core.PersistentHashMap.EMPTY;
var inst_105481 = cljs.core.PersistentHashSet.EMPTY;
var inst_105482 = [inst_105480,inst_105481];
var inst_105483 = (new cljs.core.PersistentVector(null,2,(5),inst_105479,inst_105482,null));
var inst_105484 = (function (){var schema_flakes = inst_105459;
var vec__105443 = inst_105461;
var collection_flakes = inst_105462;
var predicate_flakes = inst_105463;
var coll = inst_105476;
return (function (p1__105438_SHARP_){
return p1__105438_SHARP_.s;
});
})();
var inst_105485 = cljs.core.partition_by.call(null,inst_105484,inst_105463);
var inst_105486 = cljs.core.reduce.call(null,inst_105478,inst_105483,inst_105485);
var inst_105487 = cljs.core.nth.call(null,inst_105486,(0),null);
var inst_105488 = cljs.core.nth.call(null,inst_105486,(1),null);
var inst_105489 = [new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"coll","coll",1647737163),new cljs.core.Keyword(null,"pred","pred",1927423397),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)];
var inst_105490 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_105491 = [inst_105490,inst_105476,inst_105487,inst_105488];
var inst_105492 = cljs.core.PersistentHashMap.fromArrays(inst_105489,inst_105491);
var state_105496__$1 = state_105496;
var statearr_105503_105510 = state_105496__$1;
(statearr_105503_105510[(2)] = inst_105492);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_105496__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$schema_map_$_state_machine__99975__auto__ = null;
var fluree$db$query$schema$schema_map_$_state_machine__99975__auto____0 = (function (){
var statearr_105504 = [null,null,null,null,null,null,null];
(statearr_105504[(0)] = fluree$db$query$schema$schema_map_$_state_machine__99975__auto__);

(statearr_105504[(1)] = (1));

return statearr_105504;
});
var fluree$db$query$schema$schema_map_$_state_machine__99975__auto____1 = (function (state_105496){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_105496);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e105505){if((e105505 instanceof Object)){
var ex__99978__auto__ = e105505;
var statearr_105506_105511 = state_105496;
(statearr_105506_105511[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_105496);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e105505;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__105512 = state_105496;
state_105496 = G__105512;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$schema$schema_map_$_state_machine__99975__auto__ = function(state_105496){
switch(arguments.length){
case 0:
return fluree$db$query$schema$schema_map_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$schema$schema_map_$_state_machine__99975__auto____1.call(this,state_105496);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$schema_map_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$schema_map_$_state_machine__99975__auto____0;
fluree$db$query$schema$schema_map_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$schema_map_$_state_machine__99975__auto____1;
return fluree$db$query$schema$schema_map_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_105507 = f__100070__auto__.call(null);
(statearr_105507[(6)] = c__100069__auto__);

return statearr_105507;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
fluree.db.query.schema.setting_map = (function fluree$db$query$schema$setting_map(db){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_105548){
var state_val_105549 = (state_105548[(1)]);
if((state_val_105549 === (1))){
var state_105548__$1 = state_105548;
var statearr_105550_105561 = state_105548__$1;
(statearr_105550_105561[(2)] = null);

(statearr_105550_105561[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105549 === (2))){
var inst_105546 = (state_105548[(2)]);
var state_105548__$1 = state_105548;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_105548__$1,inst_105546);
} else {
if((state_val_105549 === (3))){
var inst_105513 = (state_105548[(2)]);
var state_105548__$1 = state_105548;
var statearr_105551_105562 = state_105548__$1;
(statearr_105551_105562[(2)] = inst_105513);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_105548__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105549 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_105548,(3),Error,null,(2));
var state_105548__$1 = state_105548;
var statearr_105552_105563 = state_105548__$1;
(statearr_105552_105563[(2)] = null);

(statearr_105552_105563[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105549 === (5))){
var inst_105532 = (state_105548[(2)]);
var inst_105533 = fluree.db.query.schema.flake__GT_pred_map.call(null,inst_105532);
var inst_105534 = [new cljs.core.Keyword(null,"passwords","passwords",-403324634),new cljs.core.Keyword(null,"anonymous","anonymous",447897231),new cljs.core.Keyword(null,"language","language",-1591107564),new cljs.core.Keyword(null,"ledgers","ledgers",-2111050533),new cljs.core.Keyword(null,"txMax","txMax",418352369),new cljs.core.Keyword(null,"consensus","consensus",1370116681)];
var inst_105535 = cljs.core.get.call(null,inst_105533,(114));
var inst_105536 = cljs.core.boolean$.call(null,inst_105535);
var inst_105537 = cljs.core.get.call(null,inst_105533,(110));
var inst_105538 = cljs.core.get.call(null,inst_105533,(117));
var inst_105539 = cljs.core.get.call(null,fluree.db.query.schema.lang_sid__GT_lang,inst_105538);
var inst_105540 = cljs.core.get.call(null,inst_105533,(111));
var inst_105541 = cljs.core.get.call(null,inst_105533,(115));
var inst_105542 = cljs.core.get.call(null,inst_105533,(112));
var inst_105543 = [inst_105536,inst_105537,inst_105539,inst_105540,inst_105541,inst_105542];
var inst_105544 = cljs.core.PersistentHashMap.fromArrays(inst_105534,inst_105543);
var state_105548__$1 = state_105548;
var statearr_105553_105564 = state_105548__$1;
(statearr_105553_105564[(2)] = inst_105544);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_105548__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105549 === (6))){
var inst_105517 = (state_105548[(2)]);
var state_105548__$1 = (function (){var statearr_105554 = state_105548;
(statearr_105554[(7)] = inst_105517);

return statearr_105554;
})();
var statearr_105555_105565 = state_105548__$1;
(statearr_105555_105565[(2)] = null);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_105548__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105549 === (7))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_105548,(6),new cljs.core.Keyword(null,"default","default",-1987822328),null,(5));
var inst_105521 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_105522 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_105523 = ["_setting/id","root"];
var inst_105524 = (new cljs.core.PersistentVector(null,2,(5),inst_105522,inst_105523,null));
var inst_105525 = [inst_105524];
var inst_105526 = (new cljs.core.PersistentVector(null,1,(5),inst_105521,inst_105525,null));
var inst_105527 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_105526);
var state_105548__$1 = state_105548;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_105548__$1,(8),inst_105527);
} else {
if((state_val_105549 === (8))){
var inst_105529 = (state_105548[(2)]);
var inst_105530 = fluree.db.util.async.throw_err.call(null,inst_105529);
var state_105548__$1 = state_105548;
var statearr_105556_105566 = state_105548__$1;
(statearr_105556_105566[(2)] = inst_105530);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_105548__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$setting_map_$_state_machine__99975__auto__ = null;
var fluree$db$query$schema$setting_map_$_state_machine__99975__auto____0 = (function (){
var statearr_105557 = [null,null,null,null,null,null,null,null];
(statearr_105557[(0)] = fluree$db$query$schema$setting_map_$_state_machine__99975__auto__);

(statearr_105557[(1)] = (1));

return statearr_105557;
});
var fluree$db$query$schema$setting_map_$_state_machine__99975__auto____1 = (function (state_105548){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_105548);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e105558){if((e105558 instanceof Object)){
var ex__99978__auto__ = e105558;
var statearr_105559_105567 = state_105548;
(statearr_105559_105567[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_105548);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e105558;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__105568 = state_105548;
state_105548 = G__105568;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$schema$setting_map_$_state_machine__99975__auto__ = function(state_105548){
switch(arguments.length){
case 0:
return fluree$db$query$schema$setting_map_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$schema$setting_map_$_state_machine__99975__auto____1.call(this,state_105548);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$setting_map_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$setting_map_$_state_machine__99975__auto____0;
fluree$db$query$schema$setting_map_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$setting_map_$_state_machine__99975__auto____1;
return fluree$db$query$schema$setting_map_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_105560 = f__100070__auto__.call(null);
(statearr_105560[(6)] = c__100069__auto__);

return statearr_105560;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Returns schema version from a db, which is the :t when the schema was last updated.
 */
fluree.db.query.schema.version = (function fluree$db$query$schema$version(db){
return cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"t","t",-1397832519)], null));
});
