// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.query.analytical_wikidata');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
fluree.db.query.analytical_wikidata.variable_QMARK_ = (function fluree$db$query$analytical_wikidata$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"?")))){
return cljs.core.symbol.call(null,form);
} else {
return null;
}
});
/**
 * Takes replacement vars, retrieves values from ctx, and puts into Wikidata VALUES statement,
 *   i.e. VALUES (?name ?countryName) {("Vincent van Gogh" "Kingdom of the Netherlands") ("Edvard Munch" "Norway")}
 */
fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt = (function fluree$db$query$analytical_wikidata$replacementVars__GT_ValuesSmt(vars,values){
var value_groups = cljs.core.map.call(null,(function (value_group){
var stringified = cljs.core.map.call(null,(function (p1__108648_SHARP_){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__108648_SHARP_),"\""].join('');
}),value_group);
var joined_group = clojure.string.join.call(null," ",stringified);
return [" ( ",joined_group," ) "].join('');
}),values);
var value_group_str = clojure.string.join.call(null," ",value_groups);
return ["VALUES ( ",clojure.string.join.call(null," ",vars)," ) { ",value_group_str," } "].join('');
});
fluree.db.query.analytical_wikidata.get_next_wd_clauses = (function fluree$db$query$analytical_wikidata$get_next_wd_clauses(coll){
var G__108652 = coll;
var vec__108653 = G__108652;
var seq__108654 = cljs.core.seq.call(null,vec__108653);
var first__108655 = cljs.core.first.call(null,seq__108654);
var seq__108654__$1 = cljs.core.next.call(null,seq__108654);
var clause = first__108655;
var r = seq__108654__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__108652__$1 = G__108652;
var res__$1 = res;
while(true){
var vec__108659 = G__108652__$1;
var seq__108660 = cljs.core.seq.call(null,vec__108659);
var first__108661 = cljs.core.first.call(null,seq__108660);
var seq__108660__$1 = cljs.core.next.call(null,seq__108660);
var clause__$1 = first__108661;
var r__$1 = seq__108660__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__108662 = r__$1;
var G__108663 = cljs.core.conj.call(null,res__$2,clause__$1);
G__108652__$1 = G__108662;
res__$1 = G__108663;
continue;
} else {
return res__$2;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.get_all_wd_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_clauses(coll){
var G__108667 = coll;
var vec__108668 = G__108667;
var seq__108669 = cljs.core.seq.call(null,vec__108668);
var first__108670 = cljs.core.first.call(null,seq__108669);
var seq__108669__$1 = cljs.core.next.call(null,seq__108669);
var clause = first__108670;
var r = seq__108669__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__108667__$1 = G__108667;
var res__$1 = res;
while(true){
var vec__108674 = G__108667__$1;
var seq__108675 = cljs.core.seq.call(null,vec__108674);
var first__108676 = cljs.core.first.call(null,seq__108675);
var seq__108675__$1 = cljs.core.next.call(null,seq__108675);
var clause__$1 = first__108676;
var r__$1 = seq__108675__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__108677 = r__$1;
var G__108678 = cljs.core.conj.call(null,res__$2,cljs.core.rest.call(null,clause__$1));
G__108667__$1 = G__108677;
res__$1 = G__108678;
continue;
} else {
var G__108679 = r__$1;
var G__108680 = res__$2;
G__108667__$1 = G__108679;
res__$1 = G__108680;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.drop_all_wd_clauses = (function fluree$db$query$analytical_wikidata$drop_all_wd_clauses(coll){
var G__108684 = coll;
var vec__108685 = G__108684;
var seq__108686 = cljs.core.seq.call(null,vec__108685);
var first__108687 = cljs.core.first.call(null,seq__108686);
var seq__108686__$1 = cljs.core.next.call(null,seq__108686);
var clause = first__108687;
var r = seq__108686__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__108684__$1 = G__108684;
var res__$1 = res;
while(true){
var vec__108691 = G__108684__$1;
var seq__108692 = cljs.core.seq.call(null,vec__108691);
var first__108693 = cljs.core.first.call(null,seq__108692);
var seq__108692__$1 = cljs.core.next.call(null,seq__108692);
var clause__$1 = first__108693;
var r__$1 = seq__108692__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__108694 = r__$1;
var G__108695 = res__$2;
G__108684__$1 = G__108694;
res__$1 = G__108695;
continue;
} else {
var G__108696 = r__$1;
var G__108697 = cljs.core.conj.call(null,res__$2,clause__$1);
G__108684__$1 = G__108696;
res__$1 = G__108697;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.wikiDataVar_QMARK_ = (function fluree$db$query$analytical_wikidata$wikiDataVar_QMARK_(string){
if(cljs.core.truth_(((typeof string === 'string')?cljs.core.re_matches.call(null,/^wd(t)*:(P|Q)\d+$/,string):false))){
cljs.core.symbol.call(null,string);
} else {
if(typeof string === 'string'){
["\"",string,"\""].join('');
} else {
}
}


return string;
});
fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata = (function fluree$db$query$analytical_wikidata$ad_hoc_clause_to_wikidata(clause,optional_QMARK_){
var clause_str = [clojure.string.join.call(null," ",cljs.core.map.call(null,fluree.db.query.analytical_wikidata.wikiDataVar_QMARK_,clause)),"."].join('');
if(cljs.core.truth_(optional_QMARK_)){
return ["OPTIONAL {",clause_str,"}"].join('');
} else {
return clause_str;
}
});
fluree.db.query.analytical_wikidata.parse_prefixes = (function fluree$db$query$analytical_wikidata$parse_prefixes(prefixes){
return cljs.core.reduce.call(null,(function (acc_str,prefix){
var pfx = cljs.core.symbol.call(null,[fluree.db.util.core.keyword__GT_str.call(null,cljs.core.key.call(null,prefix)),":"].join(''));
var source = cljs.core.symbol.call(null,cljs.core.val.call(null,prefix));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc_str)," PREFIX ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfx)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source)," \n "].join('');
}),"",prefixes);
});
fluree.db.query.analytical_wikidata.generateWikiDataQuery = (function fluree$db$query$analytical_wikidata$generateWikiDataQuery(q_map,clauses,select_vars,value_clause,optional_clauses){
var _ = (cljs.core.truth_(new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132).cljs$core$IFn$_invoke$arity$1(q_map))?fluree.db.util.log.warn.call(null,["The Wikidata query option map should be included in the opts map. Top-level options are being deprecated. Provided: ",cljs.core.pr_str.call(null,q_map)].join('')):null);
var opts = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"limit","limit",-1355822363),(100),new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"distinct","distinct",-1788879121),false,new cljs.core.Keyword(null,"language","language",-1591107564),"en"], null),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132).cljs$core$IFn$_invoke$arity$1(q_map),cljs.core.get_in.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132)], null),q_map));
var map__108701 = opts;
var map__108701__$1 = (((((!((map__108701 == null))))?(((((map__108701.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__108701.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__108701):map__108701);
var limit = cljs.core.get.call(null,map__108701__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__108701__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var distinct = cljs.core.get.call(null,map__108701__$1,new cljs.core.Keyword(null,"distinct","distinct",-1788879121));
var language = cljs.core.get.call(null,map__108701__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var prefixes = cljs.core.get.call(null,map__108701__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var prefixes__$1 = (cljs.core.truth_(prefixes)?fluree.db.query.analytical_wikidata.parse_prefixes.call(null,prefixes):null);
var select_smt = ["SELECT ",(cljs.core.truth_(distinct)?"DISTINCT ":null)," ",clojure.string.join.call(null," ",cljs.core.map.call(null,(function (p1__108698_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__108698_SHARP_),"Label"].join('');
}),select_vars))," ",clojure.string.join.call(null," ",select_vars)].join('');
var where_smt = clojure.string.join.call(null," ",cljs.core.mapv.call(null,(function (p1__108699_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata.call(null,p1__108699_SHARP_,false);
}),clauses));
var optional_smt = clojure.string.join.call(null," ",cljs.core.mapv.call(null,(function (p1__108700_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata.call(null,p1__108700_SHARP_,true);
}),optional_clauses));
var serviceLabel = ["SERVICE wikibase:label { bd:serviceParam wikibase:language \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4126__auto__ = language;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return "en";
}
})()),"\" . }"].join('');
var full_query = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefixes__$1)," ",select_smt," WHERE { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_clause)," ",where_smt," ",optional_smt," ",serviceLabel," } ",(cljs.core.truth_(limit)?["\n                          LIMIT ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit)].join(''):null)," OFFSET ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset)].join('');
return full_query;
});
fluree.db.query.analytical_wikidata.wikidataURL = "https://query.wikidata.org/bigdata/namespace/wdq/sparql?format=json&query=";
fluree.db.query.analytical_wikidata.submit_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_wikidata_query(query){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_108716){
var state_val_108717 = (state_108716[(1)]);
if((state_val_108717 === (1))){
var inst_108703 = fluree.db.util.core.url_encode.call(null,query);
var inst_108704 = [fluree.db.query.analytical_wikidata.wikidataURL,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_108703)].join('');
var inst_108705 = ["User-Agent","Accept"];
var inst_108706 = ["Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36","application/sparql-results+json"];
var inst_108707 = cljs.core.PersistentHashMap.fromArrays(inst_108705,inst_108706);
var inst_108708 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_108709 = [inst_108707,(30000),new cljs.core.Keyword(null,"wikidata","wikidata",2100084440)];
var inst_108710 = cljs.core.PersistentHashMap.fromArrays(inst_108708,inst_108709);
var inst_108711 = fluree.db.util.xhttp.get.call(null,inst_108704,inst_108710);
var state_108716__$1 = state_108716;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_108716__$1,(2),inst_108711);
} else {
if((state_val_108717 === (2))){
var inst_108713 = (state_108716[(2)]);
var inst_108714 = fluree.db.util.async.throw_err.call(null,inst_108713);
var state_108716__$1 = state_108716;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_108716__$1,inst_108714);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__99975__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__99975__auto____0 = (function (){
var statearr_108718 = [null,null,null,null,null,null,null];
(statearr_108718[(0)] = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__99975__auto__);

(statearr_108718[(1)] = (1));

return statearr_108718;
});
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__99975__auto____1 = (function (state_108716){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_108716);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e108719){if((e108719 instanceof Object)){
var ex__99978__auto__ = e108719;
var statearr_108720_108722 = state_108716;
(statearr_108720_108722[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_108716);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e108719;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__108723 = state_108716;
state_108716 = G__108723;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__99975__auto__ = function(state_108716){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__99975__auto____1.call(this,state_108716);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__99975__auto____0;
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__99975__auto____1;
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_108721 = f__100070__auto__.call(null);
(statearr_108721[(6)] = c__100069__auto__);

return statearr_108721;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query(query){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_108741){
var state_val_108742 = (state_108741[(1)]);
if((state_val_108742 === (1))){
var inst_108724 = fluree.db.query.analytical_wikidata.submit_wikidata_query.call(null,query);
var state_108741__$1 = state_108741;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_108741__$1,(2),inst_108724);
} else {
if((state_val_108742 === (2))){
var inst_108727 = (state_108741[(7)]);
var inst_108726 = (state_108741[(2)]);
var inst_108727__$1 = fluree.db.util.async.throw_err.call(null,inst_108726);
var inst_108728 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_108727__$1);
var inst_108729 = cljs.core.not_EQ_.call(null,(200),inst_108728);
var state_108741__$1 = (function (){var statearr_108743 = state_108741;
(statearr_108743[(7)] = inst_108727__$1);

return statearr_108743;
})();
if(inst_108729){
var statearr_108744_108752 = state_108741__$1;
(statearr_108744_108752[(1)] = (3));

} else {
var statearr_108745_108753 = state_108741__$1;
(statearr_108745_108753[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108742 === (3))){
var inst_108727 = (state_108741[(7)]);
var state_108741__$1 = state_108741;
var statearr_108746_108754 = state_108741__$1;
(statearr_108746_108754[(2)] = inst_108727);

(statearr_108746_108754[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108742 === (4))){
var inst_108727 = (state_108741[(7)]);
var inst_108732 = (function (){var body = inst_108727;
return (function (item){
return cljs.core.reduce.call(null,(function (acc,k_v){
return cljs.core.assoc.call(null,acc,cljs.core.key.call(null,k_v),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(cljs.core.val.call(null,k_v)));
}),cljs.core.PersistentArrayMap.EMPTY,item);
});
})();
var inst_108733 = cljs.core.second.call(null,inst_108727);
var inst_108734 = cljs.core.second.call(null,inst_108733);
var inst_108735 = cljs.core.first.call(null,inst_108734);
var inst_108736 = cljs.core.second.call(null,inst_108735);
var inst_108737 = cljs.core.mapv.call(null,inst_108732,inst_108736);
var state_108741__$1 = state_108741;
var statearr_108747_108755 = state_108741__$1;
(statearr_108747_108755[(2)] = inst_108737);

(statearr_108747_108755[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108742 === (5))){
var inst_108739 = (state_108741[(2)]);
var state_108741__$1 = state_108741;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_108741__$1,inst_108739);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__99975__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__99975__auto____0 = (function (){
var statearr_108748 = [null,null,null,null,null,null,null,null];
(statearr_108748[(0)] = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__99975__auto__);

(statearr_108748[(1)] = (1));

return statearr_108748;
});
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__99975__auto____1 = (function (state_108741){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_108741);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e108749){if((e108749 instanceof Object)){
var ex__99978__auto__ = e108749;
var statearr_108750_108756 = state_108741;
(statearr_108750_108756[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_108741);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e108749;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__108757 = state_108741;
state_108741 = G__108757;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__99975__auto__ = function(state_108741){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__99975__auto____1.call(this,state_108741);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__99975__auto____0;
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__99975__auto____1;
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_108751 = f__100070__auto__.call(null);
(statearr_108751[(6)] = c__100069__auto__);

return statearr_108751;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples = (function fluree$db$query$analytical_wikidata$wikiDataResp__GT_tuples(wikidataRes,vars){
var labelVars = cljs.core.map.call(null,(function (p1__108758_SHARP_){
return cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__108758_SHARP_),"Label"].join(''));
}),vars);
var headers = cljs.core.concat.call(null,cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,vars),labelVars);
var headers_as_kws = cljs.core.map.call(null,(function (p1__108759_SHARP_){
return fluree.db.util.core.str__GT_keyword.call(null,cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__108759_SHARP_),(1)));
}),headers);
var results = new cljs.core.Keyword(null,"bindings","bindings",1271397192).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"results","results",-1134170113).cljs$core$IFn$_invoke$arity$1(wikidataRes));
var tuples = cljs.core.map.call(null,(function (res){
return cljs.core.map.call(null,(function (p1__108760_SHARP_){
return new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(p1__108760_SHARP_.call(null,res));
}),headers_as_kws);
}),results);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples], null);
});
fluree.db.query.analytical_wikidata.get_wikidata_tuples = (function fluree$db$query$analytical_wikidata$get_wikidata_tuples(q_map,clauses,matching_vars,matching_vals,all_vars,optional_clauses){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_108795){
var state_val_108796 = (state_108795[(1)]);
if((state_val_108796 === (7))){
var inst_108770 = (state_108795[(2)]);
var inst_108771 = fluree.db.query.analytical_wikidata.generateWikiDataQuery.call(null,q_map,clauses,all_vars,inst_108770,optional_clauses);
var inst_108772 = fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query.call(null,inst_108771);
var state_108795__$1 = state_108795;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_108795__$1,(8),inst_108772);
} else {
if((state_val_108796 === (1))){
var state_108795__$1 = state_108795;
var statearr_108797_108813 = state_108795__$1;
(statearr_108797_108813[(2)] = null);

(statearr_108797_108813[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108796 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_108795,(3),Error,null,(2));
var inst_108765 = cljs.core.empty_QMARK_.call(null,matching_vars);
var state_108795__$1 = state_108795;
if(inst_108765){
var statearr_108798_108814 = state_108795__$1;
(statearr_108798_108814[(1)] = (5));

} else {
var statearr_108799_108815 = state_108795__$1;
(statearr_108799_108815[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108796 === (6))){
var inst_108768 = fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt.call(null,matching_vars,matching_vals);
var state_108795__$1 = state_108795;
var statearr_108800_108816 = state_108795__$1;
(statearr_108800_108816[(2)] = inst_108768);

(statearr_108800_108816[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108796 === (3))){
var inst_108761 = (state_108795[(2)]);
var state_108795__$1 = state_108795;
var statearr_108801_108817 = state_108795__$1;
(statearr_108801_108817[(2)] = inst_108761);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_108795__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108796 === (2))){
var inst_108793 = (state_108795[(2)]);
var state_108795__$1 = state_108795;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_108795__$1,inst_108793);
} else {
if((state_val_108796 === (11))){
var inst_108791 = (state_108795[(2)]);
var state_108795__$1 = state_108795;
var statearr_108802_108818 = state_108795__$1;
(statearr_108802_108818[(2)] = inst_108791);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_108795__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108796 === (9))){
var inst_108775 = (state_108795[(7)]);
var inst_108779 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_108775);
var inst_108780 = cljs.core.subs.call(null,inst_108779,(0),(1000));
var inst_108781 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_108782 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_108775);
var inst_108783 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_108775);
var inst_108784 = [inst_108782,inst_108783];
var inst_108785 = cljs.core.PersistentHashMap.fromArrays(inst_108781,inst_108784);
var inst_108786 = cljs.core.ex_info.call(null,inst_108780,inst_108785);
var inst_108787 = (function(){throw inst_108786})();
var state_108795__$1 = state_108795;
var statearr_108803_108819 = state_108795__$1;
(statearr_108803_108819[(2)] = inst_108787);

(statearr_108803_108819[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108796 === (5))){
var state_108795__$1 = state_108795;
var statearr_108804_108820 = state_108795__$1;
(statearr_108804_108820[(2)] = null);

(statearr_108804_108820[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108796 === (10))){
var inst_108775 = (state_108795[(7)]);
var inst_108789 = fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples.call(null,inst_108775,all_vars);
var state_108795__$1 = state_108795;
var statearr_108805_108821 = state_108795__$1;
(statearr_108805_108821[(2)] = inst_108789);

(statearr_108805_108821[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108796 === (8))){
var inst_108775 = (state_108795[(7)]);
var inst_108774 = (state_108795[(2)]);
var inst_108775__$1 = fluree.db.util.async.throw_err.call(null,inst_108774);
var inst_108776 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_108775__$1);
var inst_108777 = cljs.core._EQ_.call(null,(400),inst_108776);
var state_108795__$1 = (function (){var statearr_108806 = state_108795;
(statearr_108806[(7)] = inst_108775__$1);

return statearr_108806;
})();
if(inst_108777){
var statearr_108807_108822 = state_108795__$1;
(statearr_108807_108822[(1)] = (9));

} else {
var statearr_108808_108823 = state_108795__$1;
(statearr_108808_108823[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__99975__auto__ = null;
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__99975__auto____0 = (function (){
var statearr_108809 = [null,null,null,null,null,null,null,null];
(statearr_108809[(0)] = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__99975__auto__);

(statearr_108809[(1)] = (1));

return statearr_108809;
});
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__99975__auto____1 = (function (state_108795){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_108795);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e108810){if((e108810 instanceof Object)){
var ex__99978__auto__ = e108810;
var statearr_108811_108824 = state_108795;
(statearr_108811_108824[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_108795);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e108810;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__108825 = state_108795;
state_108795 = G__108825;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__99975__auto__ = function(state_108795){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__99975__auto____1.call(this,state_108795);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__99975__auto____0;
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__99975__auto____1;
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_108812 = f__100070__auto__.call(null);
(statearr_108812[(6)] = c__100069__auto__);

return statearr_108812;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
