// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.query.analytical');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.analytical_wikidata');
goog.require('fluree.db.query.analytical_filter');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
goog.require('fluree.db.dbproto');
fluree.db.query.analytical.variable_QMARK_ = (function fluree$db$query$analytical$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"?")))){
return cljs.core.symbol.call(null,form);
} else {
return null;
}
});
fluree.db.query.analytical.internal_filter_QMARK_ = (function fluree$db$query$analytical$internal_filter_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"#")) && (cljs.core._EQ_.call(null,cljs.core.second.call(null,cljs.core.name.call(null,form)),"(")))){
return cljs.core.symbol.call(null,form);
} else {
return null;
}
});
fluree.db.query.analytical.escaped_string_QMARK_ = (function fluree$db$query$analytical$escaped_string_QMARK_(form){
return ((typeof form === 'string') && (cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"\"")) && (cljs.core._EQ_.call(null,cljs.core.last.call(null,cljs.core.name.call(null,form)),"\"")));
});
fluree.db.query.analytical.safe_read_string = (function fluree$db$query$analytical$safe_read_string(string){
try{return cljs.reader.read_string.call(null,string);
}catch (e108828){var e = e108828;
return string;
}});
fluree.db.query.analytical.get_vars = (function fluree$db$query$analytical$get_vars(filter_code){
return cljs.core.some.call(null,(function (p1__108829_SHARP_){
var or__4126__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,p1__108829_SHARP_);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.coll_QMARK_.call(null,p1__108829_SHARP_)){
return fluree.db.query.analytical.get_vars.call(null,p1__108829_SHARP_);
} else {
return null;
}
}
}),filter_code);
});
/**
 * Given any interm-vars, such as {?article 351843720901583}
 *   and an fdb clause, such as  ["?article", "articles/leadInstitutionOrg", "?org"],
 * 
 * 
 *   Returns a map with the following keys:
 * 
 *   - search - a vector that will be passed to query-range/search, i.e. [ nil "articles/leadInstitutionOrg" nil ]
 *   - rel - a map with any variables (that are not present in interm-vars) and their idx, i.e. {?org 2}
 *   - opts - search opts, currently recur, if the predicate is recurred, and object-fn, if there is an object function.
 *  
 */
fluree.db.query.analytical.clause__GT_rel = (function fluree$db$query$analytical$clause__GT_rel(db,interm_vars,clause){
return cljs.core.reduce_kv.call(null,(function (acc,idx,key){
var key_as_var = fluree.db.query.analytical.variable_QMARK_.call(null,key);
var static_value = cljs.core.get.call(null,interm_vars,key_as_var);
if(((cljs.core._EQ_.call(null,idx,(1))) && (cljs.core.not.call(null,key_as_var)) && (cljs.core.not.call(null,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.re_find.call(null,/[_a-zA-Z0-9\/]*/,key)))))){
throw cljs.core.ex_info.call(null,["Invalid predicate provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
}

if(cljs.core.truth_(static_value)){
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__108830_SHARP_){
return cljs.core.conj.call(null,p1__108830_SHARP_,static_value);
}));
} else {
if(cljs.core.truth_(key_as_var)){
return cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__108831_SHARP_){
return cljs.core.conj.call(null,p1__108831_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),key_as_var], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = fluree.db.query.analytical.internal_filter_QMARK_.call(null,key);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.call(null,idx,(2));
} else {
return and__4115__auto__;
}
})())){
var filter_code = cljs.reader.read_string.call(null,cljs.core.subs.call(null,key,(1)));
var var$ = (function (){var or__4126__auto__ = fluree.db.query.analytical.get_vars.call(null,filter_code);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.call(null,["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__108836 = fluree.db.query.analytical_filter.valid_filter_QMARK_.call(null,filter_code,cljs.core.PersistentHashSet.createAsIfByAssoc([var$]));
var fun = cljs.core.nth.call(null,vec__108836,(0),null);
var _ = cljs.core.nth.call(null,vec__108836,(1),null);
var filter_fn = fluree.db.query.analytical_filter.get_internal_filter_fn.call(null,var$,fun);
return cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__108832_SHARP_){
return cljs.core.conj.call(null,p1__108832_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)], null),filter_fn),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),var$], null),idx);
} else {
if(cljs.core.truth_(((cljs.core._EQ_.call(null,idx,(1)))?cljs.core.re_find.call(null,/\+/,key):false))){
var vec__108839 = clojure.string.split.call(null,key,/\+/);
var pred = cljs.core.nth.call(null,vec__108839,(0),null);
var recur_amt = cljs.core.nth.call(null,vec__108839,(1),null);
var recur_amt__$1 = (cljs.core.truth_(recur_amt)?(function (){var or__4126__auto__ = fluree.db.query.analytical.safe_read_string.call(null,recur_amt);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (100);
}
})():(100));
return cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__108833_SHARP_){
return cljs.core.conj.call(null,p1__108833_SHARP_,pred);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"recur","recur",-437573268)], null),recur_amt__$1);
} else {
if(fluree.db.query.analytical.escaped_string_QMARK_.call(null,key)){
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__108834_SHARP_){
return cljs.core.conj.call(null,p1__108834_SHARP_,fluree.db.query.analytical.safe_read_string.call(null,key));
}));
} else {
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__108835_SHARP_){
return cljs.core.conj.call(null,p1__108835_SHARP_,key);
}));

}
}
}
}
}
}),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"search","search",1564939822),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"rel","rel",1378823488),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.PersistentArrayMap.EMPTY], null),clause);
});
fluree.db.query.analytical.get_ns_arrays = (function fluree$db$query$analytical$get_ns_arrays(ns,arrays){
return cljs.core.map.call(null,(function (array){
return cljs.core.map.call(null,(function (p1__108842_SHARP_){
return cljs.core.nth.call(null,array,p1__108842_SHARP_);
}),ns);
}),arrays);
});
fluree.db.query.analytical.clause__GT_keys = (function fluree$db$query$analytical$clause__GT_keys(clause){
return cljs.core.reduce.call(null,(function (acc,var$){
var temp__5733__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,var$);
if(cljs.core.truth_(temp__5733__auto__)){
var var$__$1 = temp__5733__auto__;
return cljs.core.conj.call(null,acc,var$__$1);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause);
});
fluree.db.query.analytical.intersecting_keys_tuples_clause = (function fluree$db$query$analytical$intersecting_keys_tuples_clause(tuples,clause){
var rel_keys = cljs.core.set.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples));
var clause_keys = fluree.db.query.analytical.clause__GT_keys.call(null,clause);
return cljs.core.reduce.call(null,(function (acc,key){
if(cljs.core.truth_(rel_keys.call(null,key))){
return cljs.core.conj.call(null,acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause_keys);
});
fluree.db.query.analytical.intersecting_keys_tuples = (function fluree$db$query$analytical$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.call(null,(function (acc,key){
if(cljs.core.truth_(a_keys.call(null,key))){
return cljs.core.conj.call(null,acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,b_keys);
});
fluree.db.query.analytical.select_from_tuples = (function fluree$db$query$analytical$select_from_tuples(vars,tuples){
var ns = cljs.core.reduce.call(null,(function (acc,var_smt){
var temp__5733__auto__ = (function (){var or__4126__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,var_smt);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(var_smt);
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var var$ = temp__5733__auto__;
return cljs.core.conj.call(null,acc,fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples),var$));
} else {
throw cljs.core.ex_info.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_smt)," cannot be retrieved from the results. Check that it is declared in your where clause."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
}),cljs.core.PersistentVector.EMPTY,vars);
return fluree.db.query.analytical.get_ns_arrays.call(null,ns,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(tuples));
});
fluree.db.query.analytical.add_fuel = (function fluree$db$query$analytical$add_fuel(add_amount,fuel,max_fuel){
if(cljs.core.truth_((function (){var and__4115__auto__ = max_fuel;
if(cljs.core.truth_(and__4115__auto__)){
return (add_amount > max_fuel);
} else {
return and__4115__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query fuel exceeded: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = fuel;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.volatile_QMARK_.call(null,fuel);
} else {
return and__4115__auto__;
}
})())){
return cljs.core._vreset_BANG_.call(null,fuel,(cljs.core._deref.call(null,fuel) + add_amount));
} else {
return null;
}
}
});
fluree.db.query.analytical.replace_vars_wikidata = (function fluree$db$query$analytical$replace_vars_wikidata(all_wd,intersecting_vars,vars){
return cljs.core.mapv.call(null,(function (clause){
return cljs.core.mapv.call(null,(function (clause_item){
var temp__5733__auto__ = intersecting_vars.call(null,cljs.core.symbol.call(null,clause_item));
if(cljs.core.truth_(temp__5733__auto__)){
var key_replace = temp__5733__auto__;
var replacement = cljs.core.get.call(null,vars,key_replace);
var replacement_SINGLEQUOTE_ = ((typeof cljs.reader.read_string.call(null,replacement) === 'number')?replacement:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(replacement),"\""].join(''));
return replacement_SINGLEQUOTE_;
} else {
return clause_item;
}
}),clause);
}),all_wd);
});
fluree.db.query.analytical.wikidata__GT_tuples = (function fluree$db$query$analytical$wikidata__GT_tuples(q_map,clause,r,p__108845,optional_QMARK_,fuel,max_fuel){
var map__108846 = p__108845;
var map__108846__$1 = (((((!((map__108846 == null))))?(((((map__108846.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__108846.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__108846):map__108846);
var res = map__108846__$1;
var vars = cljs.core.get.call(null,map__108846__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_108909){
var state_val_108910 = (state_108909[(1)]);
if((state_val_108910 === (7))){
var inst_108905 = (state_108909[(2)]);
var state_108909__$1 = state_108909;
var statearr_108911_108932 = state_108909__$1;
(statearr_108911_108932[(2)] = inst_108905);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_108909__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108910 === (1))){
var state_108909__$1 = state_108909;
var statearr_108912_108933 = state_108909__$1;
(statearr_108912_108933[(2)] = null);

(statearr_108912_108933[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108910 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_108909,(3),Error,null,(2));
var inst_108852 = (r == null);
var state_108909__$1 = state_108909;
if(cljs.core.truth_(inst_108852)){
var statearr_108913_108934 = state_108909__$1;
(statearr_108913_108934[(1)] = (5));

} else {
var statearr_108914_108935 = state_108909__$1;
(statearr_108914_108935[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108910 === (13))){
var inst_108897 = (state_108909[(2)]);
var state_108909__$1 = state_108909;
var statearr_108915_108936 = state_108909__$1;
(statearr_108915_108936[(2)] = inst_108897);

(statearr_108915_108936[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108910 === (6))){
var inst_108899 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_108900 = fluree.db.query.analytical_wikidata.drop_all_wd_clauses.call(null,r);
var inst_108901 = cljs.core.conj.call(null,inst_108900,clause);
var inst_108902 = [null,inst_108901];
var inst_108903 = (new cljs.core.PersistentVector(null,2,(5),inst_108899,inst_108902,null));
var state_108909__$1 = state_108909;
var statearr_108916_108937 = state_108909__$1;
(statearr_108916_108937[(2)] = inst_108903);

(statearr_108916_108937[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108910 === (3))){
var inst_108848 = (state_108909[(2)]);
var state_108909__$1 = state_108909;
var statearr_108917_108938 = state_108909__$1;
(statearr_108917_108938[(2)] = inst_108848);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_108909__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108910 === (12))){
var inst_108855 = (state_108909[(7)]);
var inst_108867 = new cljs.core.Keyword(null,"optional","optional",2053951509).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_108868 = fluree.db.query.analytical_wikidata.get_all_wd_clauses.call(null,inst_108867);
var inst_108869 = cljs.core.map.call(null,fluree.db.query.analytical.clause__GT_keys,inst_108855);
var inst_108870 = cljs.core.apply.call(null,cljs.core.concat,inst_108869);
var inst_108871 = cljs.core.set.call(null,inst_108870);
var inst_108872 = cljs.core.map.call(null,fluree.db.query.analytical.clause__GT_keys,inst_108868);
var inst_108873 = cljs.core.apply.call(null,cljs.core.concat,inst_108872);
var inst_108874 = cljs.core.into.call(null,inst_108871,inst_108873);
var inst_108875 = (function (){var all_wd = inst_108855;
var optional = inst_108868;
var all_wd_vars = inst_108871;
var all_vars = inst_108874;
return (function (p1__108843_SHARP_){
return all_vars.call(null,p1__108843_SHARP_);
});
})();
var inst_108876 = cljs.core.keys.call(null,vars);
var inst_108877 = cljs.core.map.call(null,inst_108875,inst_108876);
var inst_108878 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,inst_108877);
var inst_108879 = cljs.core.set.call(null,inst_108878);
var inst_108880 = (function (){var all_wd = inst_108855;
var optional = inst_108868;
var all_wd_vars = inst_108871;
var all_vars = inst_108874;
var intersecting_vars = inst_108879;
return (function (p1__108844_SHARP_){
return fluree.db.query.analytical.intersecting_keys_tuples_clause.call(null,res,p1__108844_SHARP_);
});
})();
var inst_108881 = cljs.core.map.call(null,inst_108880,inst_108855);
var inst_108882 = cljs.core.apply.call(null,cljs.core.concat,inst_108881);
var inst_108883 = fluree.db.query.analytical.select_from_tuples.call(null,inst_108882,res);
var inst_108884 = fluree.db.query.analytical.replace_vars_wikidata.call(null,inst_108855,inst_108879,vars);
var inst_108885 = cljs.core.remove.call(null,inst_108879,inst_108874);
var inst_108886 = fluree.db.query.analytical_wikidata.get_wikidata_tuples.call(null,q_map,inst_108884,inst_108882,inst_108883,inst_108885,inst_108868);
var state_108909__$1 = state_108909;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_108909__$1,(14),inst_108886);
} else {
if((state_val_108910 === (2))){
var inst_108907 = (state_108909[(2)]);
var state_108909__$1 = state_108909;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_108909__$1,inst_108907);
} else {
if((state_val_108910 === (11))){
var inst_108863 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_108864 = [null,r];
var inst_108865 = (new cljs.core.PersistentVector(null,2,(5),inst_108863,inst_108864,null));
var state_108909__$1 = state_108909;
var statearr_108918_108939 = state_108909__$1;
(statearr_108918_108939[(2)] = inst_108865);

(statearr_108918_108939[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108910 === (9))){
var state_108909__$1 = state_108909;
var statearr_108919_108940 = state_108909__$1;
(statearr_108919_108940[(2)] = optional_QMARK_);

(statearr_108919_108940[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108910 === (5))){
var inst_108854 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_108855 = fluree.db.query.analytical_wikidata.get_all_wd_clauses.call(null,inst_108854);
var state_108909__$1 = (function (){var statearr_108920 = state_108909;
(statearr_108920[(7)] = inst_108855);

return statearr_108920;
})();
if(cljs.core.truth_(optional_QMARK_)){
var statearr_108921_108941 = state_108909__$1;
(statearr_108921_108941[(1)] = (8));

} else {
var statearr_108922_108942 = state_108909__$1;
(statearr_108922_108942[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108910 === (14))){
var inst_108888 = (state_108909[(2)]);
var inst_108889 = fluree.db.util.async.throw_err.call(null,inst_108888);
var inst_108890 = new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(inst_108889);
var inst_108891 = cljs.core.count.call(null,inst_108890);
var inst_108892 = fluree.db.query.analytical.add_fuel.call(null,inst_108891,fuel,max_fuel);
var inst_108893 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_108894 = [inst_108889,r];
var inst_108895 = (new cljs.core.PersistentVector(null,2,(5),inst_108893,inst_108894,null));
var state_108909__$1 = (function (){var statearr_108923 = state_108909;
(statearr_108923[(8)] = inst_108892);

return statearr_108923;
})();
var statearr_108924_108943 = state_108909__$1;
(statearr_108924_108943[(2)] = inst_108895);

(statearr_108924_108943[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108910 === (10))){
var inst_108861 = (state_108909[(2)]);
var state_108909__$1 = state_108909;
if(cljs.core.truth_(inst_108861)){
var statearr_108925_108944 = state_108909__$1;
(statearr_108925_108944[(1)] = (11));

} else {
var statearr_108926_108945 = state_108909__$1;
(statearr_108926_108945[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108910 === (8))){
var inst_108855 = (state_108909[(7)]);
var inst_108857 = cljs.core.empty_QMARK_.call(null,inst_108855);
var inst_108858 = (!(inst_108857));
var state_108909__$1 = state_108909;
var statearr_108927_108946 = state_108909__$1;
(statearr_108927_108946[(2)] = inst_108858);

(statearr_108927_108946[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__99975__auto__ = null;
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__99975__auto____0 = (function (){
var statearr_108928 = [null,null,null,null,null,null,null,null,null];
(statearr_108928[(0)] = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__99975__auto__);

(statearr_108928[(1)] = (1));

return statearr_108928;
});
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__99975__auto____1 = (function (state_108909){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_108909);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e108929){if((e108929 instanceof Object)){
var ex__99978__auto__ = e108929;
var statearr_108930_108947 = state_108909;
(statearr_108930_108947[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_108909);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e108929;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__108948 = state_108909;
state_108909 = G__108948;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__99975__auto__ = function(state_108909){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__99975__auto____1.call(this,state_108909);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__99975__auto____0;
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__99975__auto____1;
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_108931 = f__100070__auto__.call(null);
(statearr_108931[(6)] = c__100069__auto__);

return statearr_108931;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
fluree.db.query.analytical.db_ident_QMARK_ = (function fluree$db$query$analytical$db_ident_QMARK_(source){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,clojure.string.split.call(null,source,/\//)),(2));
});
fluree.db.query.analytical.parse_block_from_source = (function fluree$db$query$analytical$parse_block_from_source(block){
var block_SINGLEQUOTE_ = fluree.db.query.analytical.safe_read_string.call(null,block);
if(cljs.core.int_QMARK_.call(null,block_SINGLEQUOTE_)){
return block_SINGLEQUOTE_;
} else {
return block;
}
});
fluree.db.query.analytical.isolate_source_name = (function fluree$db$query$analytical$isolate_source_name(dbid){
return cljs.core.re_find.call(null,/[a-z]+/,dbid);
});
fluree.db.query.analytical.isolate_source_block = (function fluree$db$query$analytical$isolate_source_block(dbid){
return cljs.core.re_find.call(null,/[A-Z0-9]+/,dbid);
});
fluree.db.query.analytical.get_source_clause = (function fluree$db$query$analytical$get_source_clause(var_args){
var G__108950 = arguments.length;
switch (G__108950) {
case 2:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2 = (function (db,clause){
return fluree.db.query.analytical.get_source_clause.call(null,db,clause,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4 = (function (db,clause,prefixes,opts){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_109041){
var state_val_109042 = (state_109041[(1)]);
if((state_val_109042 === (7))){
var inst_109037 = (state_109041[(2)]);
var state_109041__$1 = state_109041;
var statearr_109043_109085 = state_109041__$1;
(statearr_109043_109085[(2)] = inst_109037);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_109041__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109042 === (20))){
var inst_109031 = (state_109041[(2)]);
var state_109041__$1 = state_109041;
var statearr_109044_109086 = state_109041__$1;
(statearr_109044_109086[(2)] = inst_109031);

(statearr_109044_109086[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109042 === (27))){
var inst_109013 = (state_109041[(2)]);
var inst_109014 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_109015 = cljs.core.PersistentVector.EMPTY;
var inst_109016 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_109017 = cljs.core.into.call(null,inst_109015,inst_109016);
var inst_109018 = [inst_109013,inst_109017];
var inst_109019 = (new cljs.core.PersistentVector(null,2,(5),inst_109014,inst_109018,null));
var state_109041__$1 = state_109041;
var statearr_109045_109087 = state_109041__$1;
(statearr_109045_109087[(2)] = inst_109019);

(statearr_109045_109087[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109042 === (1))){
var state_109041__$1 = state_109041;
var statearr_109046_109088 = state_109041__$1;
(statearr_109046_109088[(2)] = null);

(statearr_109046_109088[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109042 === (24))){
var inst_108998 = (state_109041[(7)]);
var inst_109004 = (state_109041[(2)]);
var inst_109005 = fluree.db.util.async.throw_err.call(null,inst_109004);
var state_109041__$1 = (function (){var statearr_109047 = state_109041;
(statearr_109047[(8)] = inst_109005);

return statearr_109047;
})();
if(cljs.core.truth_(inst_108998)){
var statearr_109048_109089 = state_109041__$1;
(statearr_109048_109089[(1)] = (25));

} else {
var statearr_109049_109090 = state_109041__$1;
(statearr_109049_109090[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109042 === (4))){
var inst_108955 = (state_109041[(9)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_109041,(3),Error,null,(2));
var inst_108955__$1 = cljs.core.first.call(null,clause);
var inst_108956 = cljs.core._EQ_.call(null,"$fdb",inst_108955__$1);
var state_109041__$1 = (function (){var statearr_109050 = state_109041;
(statearr_109050[(9)] = inst_108955__$1);

return statearr_109050;
})();
if(inst_108956){
var statearr_109051_109091 = state_109041__$1;
(statearr_109051_109091[(1)] = (5));

} else {
var statearr_109052_109092 = state_109041__$1;
(statearr_109052_109092[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109042 === (15))){
var inst_108988 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_108989 = ["$wd",clause];
var inst_108990 = (new cljs.core.PersistentVector(null,2,(5),inst_108988,inst_108989,null));
var state_109041__$1 = state_109041;
var statearr_109053_109093 = state_109041__$1;
(statearr_109053_109093[(2)] = inst_108990);

(statearr_109053_109093[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109042 === (21))){
var inst_108994 = (state_109041[(10)]);
var inst_108996 = (state_109041[(11)]);
var inst_108998 = fluree.db.query.analytical.parse_block_from_source.call(null,inst_108994);
var inst_108999 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_109000 = [new cljs.core.Keyword(null,"sources","sources",-321166424),inst_108996];
var inst_109001 = (new cljs.core.PersistentVector(null,2,(5),inst_108999,inst_109000,null));
var inst_109002 = cljs.core.get_in.call(null,opts,inst_109001);
var state_109041__$1 = (function (){var statearr_109054 = state_109041;
(statearr_109054[(7)] = inst_108998);

return statearr_109054;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_109041__$1,(24),inst_109002);
} else {
if((state_val_109042 === (13))){
var state_109041__$1 = state_109041;
var statearr_109055_109094 = state_109041__$1;
(statearr_109055_109094[(2)] = null);

(statearr_109055_109094[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109042 === (22))){
var inst_108955 = (state_109041[(9)]);
var inst_109021 = ["The data source: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_108955)," is not supported in Fluree"].join('');
var inst_109022 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_109023 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_109024 = cljs.core.PersistentHashMap.fromArrays(inst_109022,inst_109023);
var inst_109025 = cljs.core.ex_info.call(null,inst_109021,inst_109024);
var inst_109026 = (function(){throw inst_109025})();
var state_109041__$1 = state_109041;
var statearr_109056_109095 = state_109041__$1;
(statearr_109056_109095[(2)] = inst_109026);

(statearr_109056_109095[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109042 === (6))){
var inst_108955 = (state_109041[(9)]);
var inst_108965 = clojure.string.starts_with_QMARK_.call(null,inst_108955,"$fdb");
var state_109041__$1 = state_109041;
if(inst_108965){
var statearr_109057_109096 = state_109041__$1;
(statearr_109057_109096[(1)] = (8));

} else {
var statearr_109058_109097 = state_109041__$1;
(statearr_109058_109097[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109042 === (28))){
var inst_109009 = (state_109041[(2)]);
var inst_109010 = fluree.db.util.async.throw_err.call(null,inst_109009);
var state_109041__$1 = state_109041;
var statearr_109059_109098 = state_109041__$1;
(statearr_109059_109098[(2)] = inst_109010);

(statearr_109059_109098[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109042 === (25))){
var inst_109005 = (state_109041[(8)]);
var inst_108998 = (state_109041[(7)]);
var inst_109007 = fluree.db.time_travel.as_of_block.call(null,inst_109005,inst_108998);
var state_109041__$1 = state_109041;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_109041__$1,(28),inst_109007);
} else {
if((state_val_109042 === (17))){
var inst_109033 = (state_109041[(2)]);
var state_109041__$1 = state_109041;
var statearr_109060_109099 = state_109041__$1;
(statearr_109060_109099[(2)] = inst_109033);

(statearr_109060_109099[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109042 === (3))){
var inst_108951 = (state_109041[(2)]);
var state_109041__$1 = state_109041;
var statearr_109061_109100 = state_109041__$1;
(statearr_109061_109100[(2)] = inst_108951);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_109041__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109042 === (12))){
var inst_108972 = (state_109041[(12)]);
var inst_108975 = (function(){throw inst_108972})();
var state_109041__$1 = state_109041;
var statearr_109062_109101 = state_109041__$1;
(statearr_109062_109101[(2)] = inst_108975);

(statearr_109062_109101[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109042 === (2))){
var inst_109039 = (state_109041[(2)]);
var state_109041__$1 = state_109041;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_109041__$1,inst_109039);
} else {
if((state_val_109042 === (23))){
var inst_109028 = (state_109041[(2)]);
var state_109041__$1 = state_109041;
var statearr_109063_109102 = state_109041__$1;
(statearr_109063_109102[(2)] = inst_109028);

(statearr_109063_109102[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109042 === (19))){
var state_109041__$1 = state_109041;
var statearr_109064_109103 = state_109041__$1;
(statearr_109064_109103[(2)] = null);

(statearr_109064_109103[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109042 === (11))){
var inst_108972 = (state_109041[(12)]);
var inst_108971 = (state_109041[(2)]);
var inst_108972__$1 = fluree.db.util.async.throw_err.call(null,inst_108971);
var inst_108973 = fluree.db.util.core.exception_QMARK_.call(null,inst_108972__$1);
var state_109041__$1 = (function (){var statearr_109065 = state_109041;
(statearr_109065[(12)] = inst_108972__$1);

return statearr_109065;
})();
if(inst_108973){
var statearr_109066_109104 = state_109041__$1;
(statearr_109066_109104[(1)] = (12));

} else {
var statearr_109067_109105 = state_109041__$1;
(statearr_109067_109105[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109042 === (9))){
var inst_108955 = (state_109041[(9)]);
var inst_108986 = cljs.core._EQ_.call(null,"$wd",inst_108955);
var state_109041__$1 = state_109041;
if(inst_108986){
var statearr_109068_109106 = state_109041__$1;
(statearr_109068_109106[(1)] = (15));

} else {
var statearr_109069_109107 = state_109041__$1;
(statearr_109069_109107[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109042 === (5))){
var inst_108958 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_108959 = cljs.core.PersistentVector.EMPTY;
var inst_108960 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_108961 = cljs.core.into.call(null,inst_108959,inst_108960);
var inst_108962 = [db,inst_108961];
var inst_108963 = (new cljs.core.PersistentVector(null,2,(5),inst_108958,inst_108962,null));
var state_109041__$1 = state_109041;
var statearr_109070_109108 = state_109041__$1;
(statearr_109070_109108[(2)] = inst_108963);

(statearr_109070_109108[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109042 === (14))){
var inst_108972 = (state_109041[(12)]);
var inst_108978 = (state_109041[(2)]);
var inst_108979 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_108980 = cljs.core.PersistentVector.EMPTY;
var inst_108981 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_108982 = cljs.core.into.call(null,inst_108980,inst_108981);
var inst_108983 = [inst_108972,inst_108982];
var inst_108984 = (new cljs.core.PersistentVector(null,2,(5),inst_108979,inst_108983,null));
var state_109041__$1 = (function (){var statearr_109071 = state_109041;
(statearr_109071[(13)] = inst_108978);

return statearr_109071;
})();
var statearr_109072_109109 = state_109041__$1;
(statearr_109072_109109[(2)] = inst_108984);

(statearr_109072_109109[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109042 === (26))){
var inst_109005 = (state_109041[(8)]);
var state_109041__$1 = state_109041;
var statearr_109073_109110 = state_109041__$1;
(statearr_109073_109110[(2)] = inst_109005);

(statearr_109073_109110[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109042 === (16))){
var state_109041__$1 = state_109041;
var statearr_109074_109111 = state_109041__$1;
(statearr_109074_109111[(1)] = (18));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109042 === (10))){
var inst_109035 = (state_109041[(2)]);
var state_109041__$1 = state_109041;
var statearr_109076_109112 = state_109041__$1;
(statearr_109076_109112[(2)] = inst_109035);

(statearr_109076_109112[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109042 === (18))){
var inst_108955 = (state_109041[(9)]);
var inst_108996 = (state_109041[(11)]);
var inst_108993 = fluree.db.query.analytical.isolate_source_name.call(null,inst_108955);
var inst_108994 = fluree.db.query.analytical.isolate_source_block.call(null,inst_108955);
var inst_108995 = cljs.core.keyword.call(null,inst_108993);
var inst_108996__$1 = cljs.core.get.call(null,prefixes,inst_108995);
var state_109041__$1 = (function (){var statearr_109077 = state_109041;
(statearr_109077[(10)] = inst_108994);

(statearr_109077[(11)] = inst_108996__$1);

return statearr_109077;
})();
if(cljs.core.truth_(inst_108996__$1)){
var statearr_109078_109113 = state_109041__$1;
(statearr_109078_109113[(1)] = (21));

} else {
var statearr_109079_109114 = state_109041__$1;
(statearr_109079_109114[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109042 === (8))){
var inst_108955 = (state_109041[(9)]);
var inst_108967 = cljs.core.subs.call(null,inst_108955,(4));
var inst_108968 = fluree.db.query.analytical.parse_block_from_source.call(null,inst_108967);
var inst_108969 = fluree.db.time_travel.as_of_block.call(null,db,inst_108968);
var state_109041__$1 = state_109041;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_109041__$1,(11),inst_108969);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__99975__auto__ = null;
var fluree$db$query$analytical$state_machine__99975__auto____0 = (function (){
var statearr_109080 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_109080[(0)] = fluree$db$query$analytical$state_machine__99975__auto__);

(statearr_109080[(1)] = (1));

return statearr_109080;
});
var fluree$db$query$analytical$state_machine__99975__auto____1 = (function (state_109041){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_109041);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e109081){if((e109081 instanceof Object)){
var ex__99978__auto__ = e109081;
var statearr_109082_109115 = state_109041;
(statearr_109082_109115[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_109041);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e109081;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__109116 = state_109041;
state_109041 = G__109116;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__99975__auto__ = function(state_109041){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__99975__auto____1.call(this,state_109041);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__99975__auto____0;
fluree$db$query$analytical$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__99975__auto____1;
return fluree$db$query$analytical$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_109083 = f__100070__auto__.call(null);
(statearr_109083[(6)] = c__100069__auto__);

return statearr_109083;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.query.analytical.get_source_clause.cljs$lang$maxFixedArity = 4);

fluree.db.query.analytical.tuples__GT_map = (function fluree$db$query$analytical$tuples__GT_map(start_map,tuples){
return cljs.core.reduce.call(null,(function (acc,p__109117){
var vec__109118 = p__109117;
var sub = cljs.core.nth.call(null,vec__109118,(0),null);
var obj = cljs.core.nth.call(null,vec__109118,(1),null);
return cljs.core.update.call(null,acc,sub,cljs.core.conj,obj);
}),start_map,tuples);
});
fluree.db.query.analytical.expand_map = (function fluree$db$query$analytical$expand_map(tuple_map){
return cljs.core.zipmap.call(null,cljs.core.keys.call(null,tuple_map),cljs.core.map.call(null,(function (p1__109121_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"done","done",-889844188),new cljs.core.Keyword(null,"followed","followed",821961472),new cljs.core.Keyword(null,"all","all",892129742)],[false,cljs.core.PersistentHashSet.EMPTY,cljs.core.set.call(null,p1__109121_SHARP_)]);
}),cljs.core.vals.call(null,tuple_map)));
});
fluree.db.query.analytical.follow_all_original_subject_paths = (function fluree$db$query$analytical$follow_all_original_subject_paths(subjects,tuple_map){
var expanded_map = fluree.db.query.analytical.expand_map.call(null,tuple_map);
var G__109125 = subjects;
var vec__109126 = G__109125;
var seq__109127 = cljs.core.seq.call(null,vec__109126);
var first__109128 = cljs.core.first.call(null,seq__109127);
var seq__109127__$1 = cljs.core.next.call(null,seq__109127);
var subject = first__109128;
var r = seq__109127__$1;
var acc = expanded_map;
var G__109125__$1 = G__109125;
var acc__$1 = acc;
while(true){
var vec__109132 = G__109125__$1;
var seq__109133 = cljs.core.seq.call(null,vec__109132);
var first__109134 = cljs.core.first.call(null,seq__109133);
var seq__109133__$1 = cljs.core.next.call(null,seq__109133);
var subject__$1 = first__109134;
var r__$1 = seq__109133__$1;
var acc__$2 = acc__$1;
if(cljs.core.not.call(null,subject__$1)){
return acc__$2;
} else {
if(cljs.core.truth_(cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
var G__109135 = r__$1;
var G__109136 = acc__$2;
G__109125__$1 = G__109135;
acc__$1 = G__109136;
continue;
} else {
var subject_all = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_followed = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subjects_to_follow = clojure.set.difference.call(null,subject_all,subject_followed);
var acc_STAR_ = cljs.core.reduce.call(null,((function (G__109125__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__109132,seq__109133,first__109134,seq__109133__$1,subject__$1,r__$1,acc__$2,G__109125,vec__109126,seq__109127,first__109128,seq__109127__$1,subject,r,acc,expanded_map){
return (function (acc__$3,subject_to_follow){
var all_followed = cljs.core.get_in.call(null,acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var self_QMARK_ = cljs.core._EQ_.call(null,subject__$1,subject_to_follow);
var already_followed_QMARK_ = ((self_QMARK_)?false:all_followed.call(null,subject_to_follow));
var acc_SINGLEQUOTE_ = cljs.core.update_in.call(null,acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),cljs.core.conj,subject_to_follow);
if(cljs.core.truth_((function (){var or__4126__auto__ = already_followed_QMARK_;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return self_QMARK_;
}
})())){
return acc_SINGLEQUOTE_;
} else {
var subject_to_follow_all = cljs.core.get_in.call(null,acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"all","all",892129742)], null));
var acc_SINGLEQUOTE___$1 = cljs.core.update_in.call(null,acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null),((function (G__109125__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__109132,seq__109133,first__109134,seq__109133__$1,subject__$1,r__$1,acc__$2,G__109125,vec__109126,seq__109127,first__109128,seq__109127__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.call(null,cljs.core.conj,existing,subject_to_follow_all);
});})(G__109125__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__109132,seq__109133,first__109134,seq__109133__$1,subject__$1,r__$1,acc__$2,G__109125,vec__109126,seq__109127,first__109128,seq__109127__$1,subject,r,acc,expanded_map))
);
if(cljs.core.truth_(cljs.core.get_in.call(null,acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
return cljs.core.update_in.call(null,acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),((function (G__109125__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__109132,seq__109133,first__109134,seq__109133__$1,subject__$1,r__$1,acc__$2,G__109125,vec__109126,seq__109127,first__109128,seq__109127__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.call(null,cljs.core.conj,existing,subject_to_follow_all);
});})(G__109125__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__109132,seq__109133,first__109134,seq__109133__$1,subject__$1,r__$1,acc__$2,G__109125,vec__109126,seq__109127,first__109128,seq__109127__$1,subject,r,acc,expanded_map))
);
} else {
return acc_SINGLEQUOTE___$1;
}
}
});})(G__109125__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__109132,seq__109133,first__109134,seq__109133__$1,subject__$1,r__$1,acc__$2,G__109125,vec__109126,seq__109127,first__109128,seq__109127__$1,subject,r,acc,expanded_map))
,acc__$2,subjects_to_follow);
var subject_followed_count = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subject_all_count = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_done_QMARK_ = cljs.core._EQ_.call(null,subject_followed_count,subject_all_count);
if(subject_done_QMARK_){
var G__109137 = r__$1;
var G__109138 = cljs.core.assoc_in.call(null,acc_STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null),true);
G__109125__$1 = G__109137;
acc__$1 = G__109138;
continue;
} else {
var G__109139 = subjects;
var G__109140 = acc_STAR_;
G__109125__$1 = G__109139;
acc__$1 = G__109140;
continue;
}

}
}
break;
}
});
fluree.db.query.analytical.recur_map__GT_tuples = (function fluree$db$query$analytical$recur_map__GT_tuples(subjects,recur_map){
return cljs.core.reduce.call(null,(function (acc,subject){
var subject_vals = cljs.core.get_in.call(null,recur_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
return cljs.core.concat.call(null,acc,cljs.core.map.call(null,(function (p1__109141_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,p1__109141_SHARP_],null));
}),subject_vals));
}),cljs.core.PersistentVector.EMPTY,subjects);
});
fluree.db.query.analytical.tuples__GT_recur = (function fluree$db$query$analytical$tuples__GT_recur(db,predicate,recur_map,depth,var_first_QMARK_){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_109227){
var state_val_109228 = (state_109227[(1)]);
if((state_val_109228 === (7))){
var inst_109150 = (state_109227[(2)]);
var inst_109151 = recur_map;
var inst_109152 = (1);
var state_109227__$1 = (function (){var statearr_109229 = state_109227;
(statearr_109229[(7)] = inst_109150);

(statearr_109229[(8)] = inst_109151);

(statearr_109229[(9)] = inst_109152);

return statearr_109229;
})();
var statearr_109230_109267 = state_109227__$1;
(statearr_109230_109267[(2)] = null);

(statearr_109230_109267[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109228 === (20))){
var inst_109198 = (state_109227[(2)]);
var state_109227__$1 = state_109227;
var statearr_109231_109268 = state_109227__$1;
(statearr_109231_109268[(2)] = inst_109198);

(statearr_109231_109268[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109228 === (1))){
var state_109227__$1 = state_109227;
var statearr_109232_109269 = state_109227__$1;
(statearr_109232_109269[(2)] = null);

(statearr_109232_109269[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109228 === (24))){
var inst_109223 = (state_109227[(2)]);
var state_109227__$1 = state_109227;
var statearr_109233_109270 = state_109227__$1;
(statearr_109233_109270[(2)] = inst_109223);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_109227__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109228 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_109227,(3),Error,null,(2));
var state_109227__$1 = state_109227;
if(cljs.core.truth_(depth)){
var statearr_109234_109271 = state_109227__$1;
(statearr_109234_109271[(1)] = (5));

} else {
var statearr_109235_109272 = state_109227__$1;
(statearr_109235_109272[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109228 === (15))){
var inst_109209 = (state_109227[(2)]);
var state_109227__$1 = state_109227;
var statearr_109236_109273 = state_109227__$1;
(statearr_109236_109273[(2)] = inst_109209);

(statearr_109236_109273[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109228 === (21))){
var inst_109177 = (state_109227[(10)]);
var inst_109185 = (state_109227[(11)]);
var inst_109192 = (state_109227[(2)]);
var inst_109193 = fluree.db.util.async.throw_err.call(null,inst_109192);
var inst_109194 = cljs.core.concat.call(null,inst_109177,inst_109193);
var inst_109177__$1 = inst_109194;
var inst_109178 = inst_109185;
var state_109227__$1 = (function (){var statearr_109237 = state_109227;
(statearr_109237[(12)] = inst_109178);

(statearr_109237[(10)] = inst_109177__$1);

return statearr_109237;
})();
var statearr_109238_109274 = state_109227__$1;
(statearr_109238_109274[(2)] = null);

(statearr_109238_109274[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109228 === (13))){
var inst_109151 = (state_109227[(8)]);
var state_109227__$1 = state_109227;
var statearr_109239_109275 = state_109227__$1;
(statearr_109239_109275[(2)] = inst_109151);

(statearr_109239_109275[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109228 === (22))){
var inst_109216 = (state_109227[(13)]);
var state_109227__$1 = state_109227;
var statearr_109240_109276 = state_109227__$1;
(statearr_109240_109276[(2)] = inst_109216);

(statearr_109240_109276[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109228 === (6))){
var state_109227__$1 = state_109227;
var statearr_109241_109277 = state_109227__$1;
(statearr_109241_109277[(2)] = (100));

(statearr_109241_109277[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109228 === (17))){
var inst_109151 = (state_109227[(8)]);
var inst_109152 = (state_109227[(9)]);
var inst_109200 = (state_109227[(2)]);
var inst_109201 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_109202 = [(0),(2)];
var inst_109203 = (new cljs.core.PersistentVector(null,2,(5),inst_109201,inst_109202,null));
var inst_109204 = fluree.db.query.analytical.get_ns_arrays.call(null,inst_109203,inst_109200);
var inst_109205 = fluree.db.query.analytical.tuples__GT_map.call(null,inst_109151,inst_109204);
var inst_109206 = (inst_109152 + (1));
var inst_109151__$1 = inst_109205;
var inst_109152__$1 = inst_109206;
var state_109227__$1 = (function (){var statearr_109242 = state_109227;
(statearr_109242[(8)] = inst_109151__$1);

(statearr_109242[(9)] = inst_109152__$1);

return statearr_109242;
})();
var statearr_109243_109278 = state_109227__$1;
(statearr_109243_109278[(2)] = null);

(statearr_109243_109278[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109228 === (3))){
var inst_109143 = (state_109227[(2)]);
var state_109227__$1 = state_109227;
var statearr_109244_109279 = state_109227__$1;
(statearr_109244_109279[(2)] = inst_109143);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_109227__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109228 === (12))){
var inst_109211 = (state_109227[(2)]);
var state_109227__$1 = state_109227;
var statearr_109245_109280 = state_109227__$1;
(statearr_109245_109280[(2)] = inst_109211);

(statearr_109245_109280[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109228 === (2))){
var inst_109225 = (state_109227[(2)]);
var state_109227__$1 = state_109227;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_109227__$1,inst_109225);
} else {
if((state_val_109228 === (23))){
var inst_109150 = (state_109227[(7)]);
var inst_109215 = (state_109227[(14)]);
var inst_109214 = (state_109227[(15)]);
var inst_109216 = (state_109227[(13)]);
var inst_109219 = (function (){var max_depth = inst_109150;
var recur_map__$1 = inst_109215;
var subjects = inst_109214;
var tuples = inst_109216;
return (function (p1__109142_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second.call(null,p1__109142_SHARP_)],null));
});
})();
var inst_109220 = cljs.core.map.call(null,inst_109219,inst_109216);
var inst_109221 = cljs.core.distinct.call(null,inst_109220);
var state_109227__$1 = state_109227;
var statearr_109246_109281 = state_109227__$1;
(statearr_109246_109281[(2)] = inst_109221);

(statearr_109246_109281[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109228 === (19))){
var inst_109177 = (state_109227[(10)]);
var state_109227__$1 = state_109227;
var statearr_109247_109282 = state_109227__$1;
(statearr_109247_109282[(2)] = inst_109177);

(statearr_109247_109282[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109228 === (11))){
var inst_109151 = (state_109227[(8)]);
var inst_109162 = (state_109227[(16)]);
var inst_109157 = cljs.core.vals.call(null,inst_109151);
var inst_109158 = cljs.core.flatten.call(null,inst_109157);
var inst_109159 = cljs.core.set.call(null,inst_109158);
var inst_109160 = cljs.core.keys.call(null,inst_109151);
var inst_109161 = cljs.core.set.call(null,inst_109160);
var inst_109162__$1 = clojure.set.difference.call(null,inst_109159,inst_109161);
var inst_109163 = cljs.core.empty_QMARK_.call(null,inst_109162__$1);
var state_109227__$1 = (function (){var statearr_109248 = state_109227;
(statearr_109248[(16)] = inst_109162__$1);

return statearr_109248;
})();
if(inst_109163){
var statearr_109249_109283 = state_109227__$1;
(statearr_109249_109283[(1)] = (13));

} else {
var statearr_109250_109284 = state_109227__$1;
(statearr_109250_109284[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109228 === (9))){
var inst_109215 = (state_109227[(14)]);
var inst_109214 = (state_109227[(15)]);
var inst_109213 = (state_109227[(2)]);
var inst_109214__$1 = cljs.core.keys.call(null,inst_109213);
var inst_109215__$1 = fluree.db.query.analytical.follow_all_original_subject_paths.call(null,inst_109214__$1,inst_109213);
var inst_109216 = fluree.db.query.analytical.recur_map__GT_tuples.call(null,inst_109214__$1,inst_109215__$1);
var state_109227__$1 = (function (){var statearr_109251 = state_109227;
(statearr_109251[(14)] = inst_109215__$1);

(statearr_109251[(15)] = inst_109214__$1);

(statearr_109251[(13)] = inst_109216);

return statearr_109251;
})();
if(cljs.core.truth_(var_first_QMARK_)){
var statearr_109252_109285 = state_109227__$1;
(statearr_109252_109285[(1)] = (22));

} else {
var statearr_109253_109286 = state_109227__$1;
(statearr_109253_109286[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109228 === (5))){
var state_109227__$1 = state_109227;
var statearr_109254_109287 = state_109227__$1;
(statearr_109254_109287[(2)] = depth);

(statearr_109254_109287[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109228 === (14))){
var inst_109162 = (state_109227[(16)]);
var inst_109173 = cljs.core.PersistentVector.EMPTY;
var inst_109174 = cljs.core.seq.call(null,inst_109162);
var inst_109175 = cljs.core.first.call(null,inst_109174);
var inst_109176 = cljs.core.next.call(null,inst_109174);
var inst_109177 = inst_109173;
var inst_109178 = inst_109162;
var state_109227__$1 = (function (){var statearr_109255 = state_109227;
(statearr_109255[(17)] = inst_109176);

(statearr_109255[(12)] = inst_109178);

(statearr_109255[(10)] = inst_109177);

(statearr_109255[(18)] = inst_109175);

return statearr_109255;
})();
var statearr_109256_109288 = state_109227__$1;
(statearr_109256_109288[(2)] = null);

(statearr_109256_109288[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109228 === (16))){
var inst_109178 = (state_109227[(12)]);
var inst_109184 = (state_109227[(19)]);
var inst_109183 = cljs.core.seq.call(null,inst_109178);
var inst_109184__$1 = cljs.core.first.call(null,inst_109183);
var inst_109185 = cljs.core.next.call(null,inst_109183);
var state_109227__$1 = (function (){var statearr_109257 = state_109227;
(statearr_109257[(19)] = inst_109184__$1);

(statearr_109257[(11)] = inst_109185);

return statearr_109257;
})();
if(cljs.core.truth_(inst_109184__$1)){
var statearr_109258_109289 = state_109227__$1;
(statearr_109258_109289[(1)] = (18));

} else {
var statearr_109259_109290 = state_109227__$1;
(statearr_109259_109290[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109228 === (10))){
var inst_109151 = (state_109227[(8)]);
var state_109227__$1 = state_109227;
var statearr_109260_109291 = state_109227__$1;
(statearr_109260_109291[(2)] = inst_109151);

(statearr_109260_109291[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109228 === (18))){
var inst_109184 = (state_109227[(19)]);
var inst_109187 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_109188 = [inst_109184,predicate];
var inst_109189 = (new cljs.core.PersistentVector(null,2,(5),inst_109187,inst_109188,null));
var inst_109190 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_109189);
var state_109227__$1 = state_109227;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_109227__$1,(21),inst_109190);
} else {
if((state_val_109228 === (8))){
var inst_109150 = (state_109227[(7)]);
var inst_109152 = (state_109227[(9)]);
var inst_109154 = (inst_109152 >= inst_109150);
var state_109227__$1 = state_109227;
if(cljs.core.truth_(inst_109154)){
var statearr_109261_109292 = state_109227__$1;
(statearr_109261_109292[(1)] = (10));

} else {
var statearr_109262_109293 = state_109227__$1;
(statearr_109262_109293[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__99975__auto__ = null;
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__99975__auto____0 = (function (){
var statearr_109263 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_109263[(0)] = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__99975__auto__);

(statearr_109263[(1)] = (1));

return statearr_109263;
});
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__99975__auto____1 = (function (state_109227){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_109227);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e109264){if((e109264 instanceof Object)){
var ex__99978__auto__ = e109264;
var statearr_109265_109294 = state_109227;
(statearr_109265_109294[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_109227);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e109264;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__109295 = state_109227;
state_109227 = G__109295;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__99975__auto__ = function(state_109227){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__99975__auto____1.call(this,state_109227);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__99975__auto____0;
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__99975__auto____1;
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_109266 = f__100070__auto__.call(null);
(statearr_109266[(6)] = c__100069__auto__);

return statearr_109266;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
fluree.db.query.analytical.fdb_clause__GT_tuples = (function fluree$db$query$analytical$fdb_clause__GT_tuples(db,p__109296,clause,fuel,max_fuel){
var map__109297 = p__109296;
var map__109297__$1 = (((((!((map__109297 == null))))?(((((map__109297.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__109297.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__109297):map__109297);
var res = map__109297__$1;
var headers = cljs.core.get.call(null,map__109297__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__109297__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vars = cljs.core.get.call(null,map__109297__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_109426){
var state_val_109427 = (state_109426[(1)]);
if((state_val_109427 === (7))){
var inst_109323 = (state_109426[(2)]);
var state_109426__$1 = state_109426;
if(cljs.core.truth_(inst_109323)){
var statearr_109428_109487 = state_109426__$1;
(statearr_109428_109487[(1)] = (11));

} else {
var statearr_109429_109488 = state_109426__$1;
(statearr_109429_109488[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109427 === (20))){
var inst_109330 = (state_109426[(7)]);
var inst_109418 = (state_109426[(2)]);
var inst_109419 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_109420 = cljs.core.keys.call(null,inst_109330);
var inst_109421 = [inst_109420,vars,inst_109418];
var inst_109422 = cljs.core.PersistentHashMap.fromArrays(inst_109419,inst_109421);
var state_109426__$1 = state_109426;
var statearr_109430_109489 = state_109426__$1;
(statearr_109430_109489[(2)] = inst_109422);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_109426__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109427 === (27))){
var inst_109359 = (state_109426[(8)]);
var inst_109389 = cljs.core.PersistentHashMap.EMPTY;
var inst_109390 = fluree.db.query.analytical.tuples__GT_map.call(null,inst_109389,inst_109359);
var state_109426__$1 = state_109426;
var statearr_109431_109490 = state_109426__$1;
(statearr_109431_109490[(2)] = inst_109390);

(statearr_109431_109490[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109427 === (1))){
var state_109426__$1 = state_109426;
var statearr_109432_109491 = state_109426__$1;
(statearr_109432_109491[(2)] = null);

(statearr_109432_109491[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109427 === (24))){
var state_109426__$1 = state_109426;
var statearr_109433_109492 = state_109426__$1;
(statearr_109433_109492[(2)] = null);

(statearr_109433_109492[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109427 === (4))){
var inst_109307 = (state_109426[(9)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_109426,(3),Error,null,(2));
var inst_109307__$1 = fluree.db.query.analytical.clause__GT_rel.call(null,db,vars,clause);
var inst_109309 = (inst_109307__$1 == null);
var inst_109310 = cljs.core.not.call(null,inst_109309);
var state_109426__$1 = (function (){var statearr_109434 = state_109426;
(statearr_109434[(9)] = inst_109307__$1);

return statearr_109434;
})();
if(inst_109310){
var statearr_109435_109493 = state_109426__$1;
(statearr_109435_109493[(1)] = (5));

} else {
var statearr_109436_109494 = state_109426__$1;
(statearr_109436_109494[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109427 === (15))){
var inst_109333 = (state_109426[(10)]);
var state_109426__$1 = state_109426;
var statearr_109437_109495 = state_109426__$1;
(statearr_109437_109495[(2)] = inst_109333);

(statearr_109437_109495[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109427 === (21))){
var inst_109343 = (state_109426[(11)]);
var inst_109367 = ["Cannot use predicate recursion when predicate is variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_109343)].join('');
var inst_109368 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_109369 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_109370 = cljs.core.PersistentHashMap.fromArrays(inst_109368,inst_109369);
var inst_109371 = cljs.core.ex_info.call(null,inst_109367,inst_109370);
var inst_109372 = (function(){throw inst_109371})();
var state_109426__$1 = state_109426;
var statearr_109438_109496 = state_109426__$1;
(statearr_109438_109496[(2)] = inst_109372);

(statearr_109438_109496[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109427 === (31))){
var inst_109361 = (state_109426[(12)]);
var inst_109398 = cljs.core.coll_QMARK_.call(null,inst_109361);
var state_109426__$1 = state_109426;
if(inst_109398){
var statearr_109439_109497 = state_109426__$1;
(statearr_109439_109497[(1)] = (33));

} else {
var statearr_109440_109498 = state_109426__$1;
(statearr_109440_109498[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109427 === (32))){
var inst_109409 = (state_109426[(2)]);
var state_109426__$1 = state_109426;
var statearr_109441_109499 = state_109426__$1;
(statearr_109441_109499[(2)] = inst_109409);

(statearr_109441_109499[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109427 === (33))){
var inst_109359 = (state_109426[(8)]);
var inst_109355 = (state_109426[(13)]);
var inst_109400 = cljs.core.PersistentHashMap.EMPTY;
var inst_109401 = cljs.core.first.call(null,inst_109355);
var inst_109402 = cljs.core.first.call(null,inst_109401);
var inst_109403 = cljs.core.flatten.call(null,inst_109359);
var inst_109404 = cljs.core.assoc.call(null,inst_109400,inst_109402,inst_109403);
var state_109426__$1 = state_109426;
var statearr_109442_109500 = state_109426__$1;
(statearr_109442_109500[(2)] = inst_109404);

(statearr_109442_109500[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109427 === (13))){
var inst_109333 = (state_109426[(10)]);
var inst_109330 = (state_109426[(7)]);
var inst_109345 = (state_109426[(14)]);
var inst_109334 = (state_109426[(15)]);
var inst_109328 = (state_109426[(2)]);
var inst_109329 = cljs.core.get.call(null,inst_109328,new cljs.core.Keyword(null,"search","search",1564939822));
var inst_109330__$1 = cljs.core.get.call(null,inst_109328,new cljs.core.Keyword(null,"rel","rel",1378823488));
var inst_109331 = cljs.core.get.call(null,inst_109328,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_109332 = fluree.db.query.analytical.intersecting_keys_tuples_clause.call(null,res,clause);
var inst_109333__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_109331);
var inst_109334__$1 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_109331);
var inst_109336 = (function (){var map__109303 = inst_109328;
var search = inst_109329;
var rel = inst_109330__$1;
var opts = inst_109331;
var common_keys = inst_109332;
var object_fn = inst_109333__$1;
var recur_depth = inst_109334__$1;
return (function (p__109335,common_key){
var vec__109443 = p__109335;
var acc = cljs.core.nth.call(null,vec__109443,(0),null);
var clause_SINGLEQUOTE_ = cljs.core.nth.call(null,vec__109443,(1),null);
var idx_of = fluree.db.util.core.index_of.call(null,clause,cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_key));
var k = (function (){var pred__109446 = cljs.core._EQ_;
var expr__109447 = idx_of;
if(cljs.core.truth_(pred__109446.call(null,(0),expr__109447))){
return new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441);
} else {
if(cljs.core.truth_(pred__109446.call(null,(1),expr__109447))){
return new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845);
} else {
if(cljs.core.truth_(pred__109446.call(null,(2),expr__109447))){
return new cljs.core.Keyword(null,"object-fn","object-fn",1425858481);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__109447)].join('')));
}
}
}
})();
var res_idx = fluree.db.util.core.index_of.call(null,headers,common_key);
var v = cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.map.call(null,cljs.core.first,fluree.db.query.analytical.get_ns_arrays.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res_idx], null),tuples)));
var single_v_QMARK_ = cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,v));
var v__$1 = (cljs.core.truth_((((!(single_v_QMARK_)))?(function (){var and__4115__auto__ = object_fn;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.call(null,k,object_fn);
} else {
return and__4115__auto__;
}
})():false))?cljs.core.comp.call(null,v,object_fn):v);
if(single_v_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,cljs.core.assoc.call(null,clause_SINGLEQUOTE_,idx_of,cljs.core.first.call(null,v__$1))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,acc,k,v__$1),clause_SINGLEQUOTE_], null);
}
});
})();
var inst_109337 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_109338 = cljs.core.PersistentHashMap.EMPTY;
var inst_109339 = [inst_109338,inst_109329];
var inst_109340 = (new cljs.core.PersistentVector(null,2,(5),inst_109337,inst_109339,null));
var inst_109341 = cljs.core.reduce.call(null,inst_109336,inst_109340,inst_109332);
var inst_109342 = cljs.core.nth.call(null,inst_109341,(0),null);
var inst_109343 = cljs.core.nth.call(null,inst_109341,(1),null);
var inst_109344 = [new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)];
var inst_109345__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_109342);
var state_109426__$1 = (function (){var statearr_109449 = state_109426;
(statearr_109449[(10)] = inst_109333__$1);

(statearr_109449[(16)] = inst_109344);

(statearr_109449[(7)] = inst_109330__$1);

(statearr_109449[(14)] = inst_109345__$1);

(statearr_109449[(11)] = inst_109343);

(statearr_109449[(15)] = inst_109334__$1);

return statearr_109449;
})();
if(cljs.core.truth_(inst_109345__$1)){
var statearr_109450_109501 = state_109426__$1;
(statearr_109450_109501[(1)] = (14));

} else {
var statearr_109451_109502 = state_109426__$1;
(statearr_109451_109502[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109427 === (22))){
var state_109426__$1 = state_109426;
var statearr_109452_109503 = state_109426__$1;
(statearr_109452_109503[(2)] = null);

(statearr_109452_109503[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109427 === (36))){
var inst_109414 = (state_109426[(2)]);
var inst_109415 = fluree.db.util.async.throw_err.call(null,inst_109414);
var state_109426__$1 = state_109426;
var statearr_109453_109504 = state_109426__$1;
(statearr_109453_109504[(2)] = inst_109415);

(statearr_109453_109504[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109427 === (29))){
var inst_109363 = (state_109426[(17)]);
var inst_109334 = (state_109426[(15)]);
var inst_109364 = (state_109426[(18)]);
var inst_109411 = (state_109426[(2)]);
var inst_109412 = fluree.db.query.analytical.tuples__GT_recur.call(null,db,inst_109364,inst_109411,inst_109334,inst_109363);
var state_109426__$1 = state_109426;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_109426__$1,(36),inst_109412);
} else {
if((state_val_109427 === (6))){
var state_109426__$1 = state_109426;
var statearr_109454_109505 = state_109426__$1;
(statearr_109454_109505[(2)] = false);

(statearr_109454_109505[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109427 === (28))){
var inst_109361 = (state_109426[(12)]);
var inst_109392 = typeof inst_109361 === 'number';
var state_109426__$1 = state_109426;
if(cljs.core.truth_(inst_109392)){
var statearr_109455_109506 = state_109426__$1;
(statearr_109455_109506[(1)] = (30));

} else {
var statearr_109456_109507 = state_109426__$1;
(statearr_109456_109507[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109427 === (25))){
var inst_109343 = (state_109426[(11)]);
var inst_109380 = ["Cannot use predicate recursion when object is not a variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_109343)].join('');
var inst_109381 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_109382 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_109383 = cljs.core.PersistentHashMap.fromArrays(inst_109381,inst_109382);
var inst_109384 = cljs.core.ex_info.call(null,inst_109380,inst_109383);
var inst_109385 = (function(){throw inst_109384})();
var state_109426__$1 = state_109426;
var statearr_109457_109508 = state_109426__$1;
(statearr_109457_109508[(2)] = inst_109385);

(statearr_109457_109508[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109427 === (34))){
var state_109426__$1 = state_109426;
var statearr_109458_109509 = state_109426__$1;
(statearr_109458_109509[(2)] = null);

(statearr_109458_109509[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109427 === (17))){
var inst_109330 = (state_109426[(7)]);
var inst_109334 = (state_109426[(15)]);
var inst_109355 = (state_109426[(13)]);
var inst_109354 = (state_109426[(2)]);
var inst_109355__$1 = fluree.db.util.async.throw_err.call(null,inst_109354);
var inst_109356 = cljs.core.count.call(null,inst_109355__$1);
var inst_109357 = fluree.db.query.analytical.add_fuel.call(null,inst_109356,fuel,max_fuel);
var inst_109358 = cljs.core.vals.call(null,inst_109330);
var inst_109359 = fluree.db.query.analytical.get_ns_arrays.call(null,inst_109358,inst_109355__$1);
var state_109426__$1 = (function (){var statearr_109459 = state_109426;
(statearr_109459[(19)] = inst_109357);

(statearr_109459[(8)] = inst_109359);

(statearr_109459[(13)] = inst_109355__$1);

return statearr_109459;
})();
if(cljs.core.truth_(inst_109334)){
var statearr_109460_109510 = state_109426__$1;
(statearr_109460_109510[(1)] = (18));

} else {
var statearr_109461_109511 = state_109426__$1;
(statearr_109461_109511[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109427 === (3))){
var inst_109299 = (state_109426[(2)]);
var state_109426__$1 = state_109426;
var statearr_109462_109512 = state_109426__$1;
(statearr_109462_109512[(2)] = inst_109299);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_109426__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109427 === (12))){
var inst_109307 = (state_109426[(9)]);
var state_109426__$1 = state_109426;
var statearr_109463_109513 = state_109426__$1;
(statearr_109463_109513[(2)] = inst_109307);

(statearr_109463_109513[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109427 === (2))){
var inst_109424 = (state_109426[(2)]);
var state_109426__$1 = state_109426;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_109426__$1,inst_109424);
} else {
if((state_val_109427 === (23))){
var inst_109375 = (state_109426[(2)]);
var inst_109376 = cljs.core.nth.call(null,clause,(2));
var inst_109377 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_109376);
var state_109426__$1 = (function (){var statearr_109464 = state_109426;
(statearr_109464[(20)] = inst_109375);

return statearr_109464;
})();
if(cljs.core.truth_(inst_109377)){
var statearr_109465_109514 = state_109426__$1;
(statearr_109465_109514[(1)] = (24));

} else {
var statearr_109466_109515 = state_109426__$1;
(statearr_109466_109515[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109427 === (35))){
var inst_109407 = (state_109426[(2)]);
var state_109426__$1 = state_109426;
var statearr_109467_109516 = state_109426__$1;
(statearr_109467_109516[(2)] = inst_109407);

(statearr_109467_109516[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109427 === (19))){
var inst_109359 = (state_109426[(8)]);
var state_109426__$1 = state_109426;
var statearr_109468_109517 = state_109426__$1;
(statearr_109468_109517[(2)] = inst_109359);

(statearr_109468_109517[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109427 === (11))){
var inst_109307 = (state_109426[(9)]);
var inst_109325 = cljs.core.apply.call(null,cljs.core.hash_map,inst_109307);
var state_109426__$1 = state_109426;
var statearr_109469_109518 = state_109426__$1;
(statearr_109469_109518[(2)] = inst_109325);

(statearr_109469_109518[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109427 === (9))){
var state_109426__$1 = state_109426;
var statearr_109470_109519 = state_109426__$1;
(statearr_109470_109519[(2)] = false);

(statearr_109470_109519[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109427 === (5))){
var inst_109307 = (state_109426[(9)]);
var inst_109312 = inst_109307.cljs$lang$protocol_mask$partition0$;
var inst_109313 = (inst_109312 & (64));
var inst_109314 = inst_109307.cljs$core$ISeq$;
var inst_109315 = (cljs.core.PROTOCOL_SENTINEL === inst_109314);
var inst_109316 = ((inst_109313) || (inst_109315));
var state_109426__$1 = state_109426;
if(cljs.core.truth_(inst_109316)){
var statearr_109471_109520 = state_109426__$1;
(statearr_109471_109520[(1)] = (8));

} else {
var statearr_109472_109521 = state_109426__$1;
(statearr_109472_109521[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109427 === (14))){
var inst_109345 = (state_109426[(14)]);
var state_109426__$1 = state_109426;
var statearr_109473_109522 = state_109426__$1;
(statearr_109473_109522[(2)] = inst_109345);

(statearr_109473_109522[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109427 === (26))){
var inst_109363 = (state_109426[(17)]);
var inst_109387 = (state_109426[(2)]);
var state_109426__$1 = (function (){var statearr_109474 = state_109426;
(statearr_109474[(21)] = inst_109387);

return statearr_109474;
})();
if(cljs.core.truth_(inst_109363)){
var statearr_109475_109523 = state_109426__$1;
(statearr_109475_109523[(1)] = (27));

} else {
var statearr_109476_109524 = state_109426__$1;
(statearr_109476_109524[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109427 === (16))){
var inst_109344 = (state_109426[(16)]);
var inst_109343 = (state_109426[(11)]);
var inst_109349 = (state_109426[(2)]);
var inst_109350 = [inst_109349];
var inst_109351 = cljs.core.PersistentHashMap.fromArrays(inst_109344,inst_109350);
var inst_109352 = fluree.db.query.range.search.call(null,db,inst_109343,inst_109351);
var state_109426__$1 = state_109426;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_109426__$1,(17),inst_109352);
} else {
if((state_val_109427 === (30))){
var inst_109361 = (state_109426[(12)]);
var inst_109359 = (state_109426[(8)]);
var inst_109394 = cljs.core.PersistentHashMap.EMPTY;
var inst_109395 = cljs.core.flatten.call(null,inst_109359);
var inst_109396 = cljs.core.assoc.call(null,inst_109394,inst_109361,inst_109395);
var state_109426__$1 = state_109426;
var statearr_109477_109525 = state_109426__$1;
(statearr_109477_109525[(2)] = inst_109396);

(statearr_109477_109525[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109427 === (10))){
var inst_109320 = (state_109426[(2)]);
var state_109426__$1 = state_109426;
var statearr_109478_109526 = state_109426__$1;
(statearr_109478_109526[(2)] = inst_109320);

(statearr_109478_109526[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109427 === (18))){
var inst_109343 = (state_109426[(11)]);
var inst_109364 = (state_109426[(18)]);
var inst_109361 = cljs.core.first.call(null,inst_109343);
var inst_109362 = cljs.core.first.call(null,clause);
var inst_109363 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_109362);
var inst_109364__$1 = cljs.core.nth.call(null,inst_109343,(1));
var inst_109365 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_109364__$1);
var state_109426__$1 = (function (){var statearr_109479 = state_109426;
(statearr_109479[(17)] = inst_109363);

(statearr_109479[(18)] = inst_109364__$1);

(statearr_109479[(12)] = inst_109361);

return statearr_109479;
})();
if(cljs.core.truth_(inst_109365)){
var statearr_109480_109527 = state_109426__$1;
(statearr_109480_109527[(1)] = (21));

} else {
var statearr_109481_109528 = state_109426__$1;
(statearr_109481_109528[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109427 === (8))){
var state_109426__$1 = state_109426;
var statearr_109482_109529 = state_109426__$1;
(statearr_109482_109529[(2)] = true);

(statearr_109482_109529[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__99975__auto__ = null;
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__99975__auto____0 = (function (){
var statearr_109483 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_109483[(0)] = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__99975__auto__);

(statearr_109483[(1)] = (1));

return statearr_109483;
});
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__99975__auto____1 = (function (state_109426){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_109426);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e109484){if((e109484 instanceof Object)){
var ex__99978__auto__ = e109484;
var statearr_109485_109530 = state_109426;
(statearr_109485_109530[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_109426);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e109484;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__109531 = state_109426;
state_109426 = G__109531;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__99975__auto__ = function(state_109426){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__99975__auto____1.call(this,state_109426);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__99975__auto____0;
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__99975__auto____1;
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_109486 = f__100070__auto__.call(null);
(statearr_109486[(6)] = c__100069__auto__);

return statearr_109486;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
fluree.db.query.analytical.full_text__GT_tuples = (function fluree$db$query$analytical$full_text__GT_tuples(db,res,clause){
throw cljs.core.ex_info.call(null,"Full text search is not supported in JS",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
});
fluree.db.query.analytical.collection__GT_tuples = (function fluree$db$query$analytical$collection__GT_tuples(db,res,clause){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_109627){
var state_val_109628 = (state_109627[(1)]);
if((state_val_109628 === (7))){
var inst_109545 = (state_109627[(2)]);
var state_109627__$1 = state_109627;
if(cljs.core.truth_(inst_109545)){
var statearr_109629_109662 = state_109627__$1;
(statearr_109629_109662[(1)] = (8));

} else {
var statearr_109630_109663 = state_109627__$1;
(statearr_109630_109663[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109628 === (20))){
var inst_109592 = (state_109627[(7)]);
var state_109627__$1 = state_109627;
var statearr_109631_109664 = state_109627__$1;
(statearr_109631_109664[(2)] = inst_109592);

(statearr_109631_109664[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109628 === (1))){
var state_109627__$1 = state_109627;
var statearr_109632_109665 = state_109627__$1;
(statearr_109632_109665[(2)] = null);

(statearr_109632_109665[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109628 === (4))){
var inst_109539 = (state_109627[(8)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_109627,(3),Error,null,(2));
var inst_109538 = cljs.core.first.call(null,clause);
var inst_109539__$1 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_109538);
var inst_109540 = cljs.core.last.call(null,clause);
var inst_109541 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_109540);
var state_109627__$1 = (function (){var statearr_109633 = state_109627;
(statearr_109633[(9)] = inst_109541);

(statearr_109633[(8)] = inst_109539__$1);

return statearr_109633;
})();
if(cljs.core.truth_(inst_109539__$1)){
var statearr_109634_109666 = state_109627__$1;
(statearr_109634_109666[(1)] = (5));

} else {
var statearr_109635_109667 = state_109627__$1;
(statearr_109635_109667[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109628 === (15))){
var inst_109541 = (state_109627[(9)]);
var inst_109539 = (state_109627[(8)]);
var inst_109572 = cljs.core.last.call(null,clause);
var inst_109573 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_109572);
var inst_109574 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_109575 = cljs.core.get.call(null,inst_109574,inst_109573);
var inst_109576 = fluree.db.flake.min_subject_id.call(null,inst_109573);
var inst_109577 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_109578 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_109579 = [inst_109539];
var inst_109580 = (new cljs.core.PersistentVector(null,1,(5),inst_109578,inst_109579,null));
var inst_109581 = (function (){var subject_var = inst_109539;
var object_var = inst_109541;
var cid = inst_109573;
var max_sid = inst_109575;
var min_sid = inst_109576;
return (function (p1__109533_SHARP_){
return cljs.core.conj.call(null,cljs.core.PersistentVector.EMPTY,p1__109533_SHARP_);
});
})();
var inst_109582 = (inst_109575 + (1));
var inst_109583 = cljs.core.range.call(null,inst_109576,inst_109582);
var inst_109584 = cljs.core.map.call(null,inst_109581,inst_109583);
var inst_109585 = cljs.core.PersistentHashMap.EMPTY;
var inst_109586 = [inst_109580,inst_109584,inst_109585];
var inst_109587 = cljs.core.PersistentHashMap.fromArrays(inst_109577,inst_109586);
var state_109627__$1 = state_109627;
var statearr_109636_109668 = state_109627__$1;
(statearr_109636_109668[(2)] = inst_109587);

(statearr_109636_109668[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109628 === (21))){
var inst_109592 = (state_109627[(7)]);
var inst_109596 = fluree.db.dbproto._subid.call(null,db,inst_109592);
var state_109627__$1 = state_109627;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_109627__$1,(23),inst_109596);
} else {
if((state_val_109628 === (13))){
var inst_109621 = (state_109627[(2)]);
var state_109627__$1 = state_109627;
var statearr_109637_109669 = state_109627__$1;
(statearr_109637_109669[(2)] = inst_109621);

(statearr_109637_109669[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109628 === (22))){
var inst_109541 = (state_109627[(9)]);
var inst_109601 = (state_109627[(2)]);
var inst_109602 = fluree.db.flake.sid__GT_cid.call(null,inst_109601);
var inst_109603 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_109602);
var inst_109604 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_109605 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_109606 = [inst_109541];
var inst_109607 = (new cljs.core.PersistentVector(null,1,(5),inst_109605,inst_109606,null));
var inst_109608 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_109609 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_109610 = [inst_109603];
var inst_109611 = (new cljs.core.PersistentVector(null,1,(5),inst_109609,inst_109610,null));
var inst_109612 = [inst_109611];
var inst_109613 = (new cljs.core.PersistentVector(null,1,(5),inst_109608,inst_109612,null));
var inst_109614 = cljs.core.PersistentHashMap.EMPTY;
var inst_109615 = [inst_109607,inst_109613,inst_109614];
var inst_109616 = cljs.core.PersistentHashMap.fromArrays(inst_109604,inst_109615);
var state_109627__$1 = state_109627;
var statearr_109638_109670 = state_109627__$1;
(statearr_109638_109670[(2)] = inst_109616);

(statearr_109638_109670[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109628 === (6))){
var inst_109539 = (state_109627[(8)]);
var state_109627__$1 = state_109627;
var statearr_109639_109671 = state_109627__$1;
(statearr_109639_109671[(2)] = inst_109539);

(statearr_109639_109671[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109628 === (17))){
var inst_109592 = (state_109627[(7)]);
var inst_109592__$1 = cljs.core.first.call(null,clause);
var inst_109593 = typeof inst_109592__$1 === 'number';
var state_109627__$1 = (function (){var statearr_109640 = state_109627;
(statearr_109640[(7)] = inst_109592__$1);

return statearr_109640;
})();
if(cljs.core.truth_(inst_109593)){
var statearr_109641_109672 = state_109627__$1;
(statearr_109641_109672[(1)] = (20));

} else {
var statearr_109642_109673 = state_109627__$1;
(statearr_109642_109673[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109628 === (3))){
var inst_109534 = (state_109627[(2)]);
var state_109627__$1 = state_109627;
var statearr_109643_109674 = state_109627__$1;
(statearr_109643_109674[(2)] = inst_109534);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_109627__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109628 === (12))){
var inst_109541 = (state_109627[(9)]);
var state_109627__$1 = state_109627;
if(cljs.core.truth_(inst_109541)){
var statearr_109644_109675 = state_109627__$1;
(statearr_109644_109675[(1)] = (17));

} else {
var statearr_109645_109676 = state_109627__$1;
(statearr_109645_109676[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109628 === (2))){
var inst_109625 = (state_109627[(2)]);
var state_109627__$1 = state_109627;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_109627__$1,inst_109625);
} else {
if((state_val_109628 === (23))){
var inst_109598 = (state_109627[(2)]);
var inst_109599 = fluree.db.util.async.throw_err.call(null,inst_109598);
var state_109627__$1 = state_109627;
var statearr_109646_109677 = state_109627__$1;
(statearr_109646_109677[(2)] = inst_109599);

(statearr_109646_109677[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109628 === (19))){
var inst_109619 = (state_109627[(2)]);
var state_109627__$1 = state_109627;
var statearr_109647_109678 = state_109627__$1;
(statearr_109647_109678[(2)] = inst_109619);

(statearr_109647_109678[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109628 === (11))){
var inst_109554 = ["_tx",null,"_block",null];
var inst_109555 = (new cljs.core.PersistentArrayMap(null,2,inst_109554,null));
var inst_109556 = (new cljs.core.PersistentHashSet(null,inst_109555,null));
var inst_109557 = cljs.core.last.call(null,clause);
var inst_109558 = inst_109556.call(null,inst_109557);
var state_109627__$1 = state_109627;
if(cljs.core.truth_(inst_109558)){
var statearr_109648_109679 = state_109627__$1;
(statearr_109648_109679[(1)] = (14));

} else {
var statearr_109649_109680 = state_109627__$1;
(statearr_109649_109680[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109628 === (9))){
var inst_109539 = (state_109627[(8)]);
var state_109627__$1 = state_109627;
if(cljs.core.truth_(inst_109539)){
var statearr_109650_109681 = state_109627__$1;
(statearr_109650_109681[(1)] = (11));

} else {
var statearr_109651_109682 = state_109627__$1;
(statearr_109651_109682[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109628 === (5))){
var inst_109541 = (state_109627[(9)]);
var state_109627__$1 = state_109627;
var statearr_109652_109683 = state_109627__$1;
(statearr_109652_109683[(2)] = inst_109541);

(statearr_109652_109683[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109628 === (14))){
var inst_109541 = (state_109627[(9)]);
var inst_109539 = (state_109627[(8)]);
var inst_109560 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_109561 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_109562 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_109563 = [inst_109539];
var inst_109564 = (new cljs.core.PersistentVector(null,1,(5),inst_109562,inst_109563,null));
var inst_109565 = (function (){var subject_var = inst_109539;
var object_var = inst_109541;
var min_sid = inst_109560;
var max_sid = (0);
return (function (p1__109532_SHARP_){
return cljs.core.conj.call(null,cljs.core.PersistentVector.EMPTY,p1__109532_SHARP_);
});
})();
var inst_109566 = cljs.core.range.call(null,inst_109560,(0));
var inst_109567 = cljs.core.map.call(null,inst_109565,inst_109566);
var inst_109568 = cljs.core.PersistentHashMap.EMPTY;
var inst_109569 = [inst_109564,inst_109567,inst_109568];
var inst_109570 = cljs.core.PersistentHashMap.fromArrays(inst_109561,inst_109569);
var state_109627__$1 = state_109627;
var statearr_109653_109684 = state_109627__$1;
(statearr_109653_109684[(2)] = inst_109570);

(statearr_109653_109684[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109628 === (16))){
var inst_109589 = (state_109627[(2)]);
var state_109627__$1 = state_109627;
var statearr_109654_109685 = state_109627__$1;
(statearr_109654_109685[(2)] = inst_109589);

(statearr_109654_109685[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109628 === (10))){
var inst_109623 = (state_109627[(2)]);
var state_109627__$1 = state_109627;
var statearr_109655_109686 = state_109627__$1;
(statearr_109655_109686[(2)] = inst_109623);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_109627__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109628 === (18))){
var state_109627__$1 = state_109627;
var statearr_109656_109687 = state_109627__$1;
(statearr_109656_109687[(2)] = null);

(statearr_109656_109687[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109628 === (8))){
var inst_109547 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_109548 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_109549 = cljs.core.PersistentHashMap.fromArrays(inst_109547,inst_109548);
var inst_109550 = cljs.core.ex_info.call(null,"When using rdf:type, either a subject or a type (collection) must be specified.",inst_109549);
var inst_109551 = (function(){throw inst_109550})();
var state_109627__$1 = state_109627;
var statearr_109657_109688 = state_109627__$1;
(statearr_109657_109688[(2)] = inst_109551);

(statearr_109657_109688[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__99975__auto__ = null;
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__99975__auto____0 = (function (){
var statearr_109658 = [null,null,null,null,null,null,null,null,null,null];
(statearr_109658[(0)] = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__99975__auto__);

(statearr_109658[(1)] = (1));

return statearr_109658;
});
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__99975__auto____1 = (function (state_109627){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_109627);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e109659){if((e109659 instanceof Object)){
var ex__99978__auto__ = e109659;
var statearr_109660_109689 = state_109627;
(statearr_109660_109689[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_109627);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e109659;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__109690 = state_109627;
state_109627 = G__109690;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__99975__auto__ = function(state_109627){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__99975__auto____1.call(this,state_109627);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__99975__auto____0;
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__99975__auto____1;
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_109661 = f__100070__auto__.call(null);
(statearr_109661[(6)] = c__100069__auto__);

return statearr_109661;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
fluree.db.query.analytical.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 41, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"isNUMERIC",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null], null), null);
fluree.db.query.analytical.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical$sum(coll){
return cljs.core.reduce.call(null,cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical$avg(coll){
return (sum.call(null,coll) / cljs.core.count.call(null,coll));
});
var median = (function fluree$db$query$analytical$median(coll){
var terms = cljs.core.sort.call(null,coll);
var size = cljs.core.count.call(null,coll);
var med = (size >> (1));
var G__109696 = cljs.core.nth.call(null,terms,med);
if(cljs.core.even_QMARK_.call(null,size)){
return ((G__109696 + cljs.core.nth.call(null,terms,(med - (1)))) / (2));
} else {
return G__109696;
}
});
var variance = (function fluree$db$query$analytical$variance(coll){
var mean = avg.call(null,coll);
var sum__$1 = sum.call(null,(function (){var iter__4529__auto__ = (function fluree$db$query$analytical$variance_$_iter__109697(s__109698){
return (new cljs.core.LazySeq(null,(function (){
var s__109698__$1 = s__109698;
while(true){
var temp__5735__auto__ = cljs.core.seq.call(null,s__109698__$1);
if(temp__5735__auto__){
var s__109698__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__109698__$2)){
var c__4527__auto__ = cljs.core.chunk_first.call(null,s__109698__$2);
var size__4528__auto__ = cljs.core.count.call(null,c__4527__auto__);
var b__109700 = cljs.core.chunk_buffer.call(null,size__4528__auto__);
if((function (){var i__109699 = (0);
while(true){
if((i__109699 < size__4528__auto__)){
var x = cljs.core._nth.call(null,c__4527__auto__,i__109699);
var delta = (x - mean);
cljs.core.chunk_append.call(null,b__109700,(delta * delta));

var G__109701 = (i__109699 + (1));
i__109699 = G__109701;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__109700),fluree$db$query$analytical$variance_$_iter__109697.call(null,cljs.core.chunk_rest.call(null,s__109698__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__109700),null);
}
} else {
var x = cljs.core.first.call(null,s__109698__$2);
var delta = (x - mean);
return cljs.core.cons.call(null,(delta * delta),fluree$db$query$analytical$variance_$_iter__109697.call(null,cljs.core.rest.call(null,s__109698__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__.call(null,coll);
})());
return (sum__$1 / cljs.core.count.call(null,coll));
});
var stddev = (function fluree$db$query$analytical$stddev(coll){
return Math.sqrt(variance.call(null,coll));
});
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"variance","variance",-1522424942,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"median","median",-2084869638,null),new cljs.core.Symbol(null,"groupconcat","groupconcat",-736310912,null),new cljs.core.Symbol(null,"sum","sum",1777518341,null),new cljs.core.Symbol(null,"abs","abs",1394505050,null),new cljs.core.Symbol(null,"min","min",2085523049,null),new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"count-distinct","count-distinct",-1566572514,null),new cljs.core.Symbol(null,"avg","avg",1837937727,null),new cljs.core.Symbol(null,"floor","floor",-772394748,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),new cljs.core.Symbol(null,"stddev","stddev",775056588,null),new cljs.core.Symbol(null,"rand","rand",-1745930995,null),new cljs.core.Symbol(null,"sample","sample",1719555128,null)],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__4214__auto__ = n;
var y__4215__auto__ = (- n);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
}),(function() {
var G__109702 = null;
var G__109702__1 = (function (coll){
return cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.compare.call(null,x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first.call(null,coll),cljs.core.next.call(null,coll));
});
var G__109702__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.count.call(null,acc) < n)){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,acc,x));
} else {
if((cljs.core.compare.call(null,x,cljs.core.last.call(null,acc)) < (0))){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,cljs.core.butlast.call(null,acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__109702 = function(n,coll){
switch(arguments.length){
case 1:
return G__109702__1.call(this,n);
case 2:
return G__109702__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__109702.cljs$core$IFn$_invoke$arity$1 = G__109702__1;
G__109702.cljs$core$IFn$_invoke$arity$2 = G__109702__2;
return G__109702;
})()
,(function (n){
if(cljs.core._EQ_.call(null,n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__109703 = null;
var G__109703__1 = (function (coll){
return cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.compare.call(null,x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first.call(null,coll),cljs.core.next.call(null,coll));
});
var G__109703__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.count.call(null,acc) < n)){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,acc,x));
} else {
if((cljs.core.compare.call(null,x,cljs.core.first.call(null,acc)) > (0))){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,cljs.core.next.call(null,acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__109703 = function(n,coll){
switch(arguments.length){
case 1:
return G__109703__1.call(this,n);
case 2:
return G__109703__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__109703.cljs$core$IFn$_invoke$arity$1 = G__109703__1;
G__109703.cljs$core$IFn$_invoke$arity$2 = G__109703__2;
return G__109703;
})()
,(function (coll){
return cljs.core.count.call(null,cljs.core.distinct.call(null,coll));
}),avg,(function (n){
if(cljs.core._EQ_.call(null,n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__109704 = null;
var G__109704__1 = (function (coll){
return cljs.core.rand_nth.call(null,coll);
});
var G__109704__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.repeatedly.call(null,n,(function (){
return cljs.core.rand_nth.call(null,coll);
})));
});
G__109704 = function(n,coll){
switch(arguments.length){
case 1:
return G__109704__1.call(this,n);
case 2:
return G__109704__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__109704.cljs$core$IFn$_invoke$arity$1 = G__109704__1;
G__109704.cljs$core$IFn$_invoke$arity$2 = G__109704__2;
return G__109704;
})()
,(function (n,coll){
return cljs.core.vec.call(null,cljs.core.take.call(null,n,cljs.core.shuffle.call(null,coll)));
})]);
})();
fluree.db.query.analytical.aggregate_QMARK_ = (function fluree$db$query$analytical$aggregate_QMARK_(x){
if(typeof x === 'string'){
return cljs.core.re_matches.call(null,/^\(.+\)$/,x);
} else {
return false;
}
});
fluree.db.query.analytical.interm_aggregate_QMARK_ = (function fluree$db$query$analytical$interm_aggregate_QMARK_(x){
if(typeof x === 'string'){
return cljs.core.re_matches.call(null,/^#\(.+\)$/,x);
} else {
return false;
}
});
fluree.db.query.analytical.parse_aggregate = (function fluree$db$query$analytical$parse_aggregate(x,valid_var){
var list_agg = cljs.reader.read_string.call(null,x);
var as_QMARK_ = cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"as","as",-1505746128,null),cljs.core.first.call(null,list_agg));
var as = ((as_QMARK_)?cljs.core.symbol.call(null,["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last.call(null,list_agg))].join('')):cljs.core.symbol.call(null,["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(list_agg)].join('')));
var func_list = ((as_QMARK_)?(function (){var func_list = cljs.core.second.call(null,list_agg);
if(cljs.core.coll_QMARK_.call(null,func_list)){
return func_list;
} else {
throw cljs.core.ex_info.call(null,["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})():list_agg);
var list_count = cljs.core.count.call(null,func_list);
var vec__109705 = ((cljs.core._EQ_.call(null,(3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,func_list),cljs.core.second.call(null,func_list),cljs.core.last.call(null,func_list)], null):((((cljs.core._EQ_.call(null,(2),list_count)) && (cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"sample","sample",1719555128,null),cljs.core.first.call(null,func_list)))))?(function(){throw cljs.core.ex_info.call(null,["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():((cljs.core._EQ_.call(null,(2),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,func_list),null,cljs.core.last.call(null,func_list)], null):(function(){throw cljs.core.ex_info.call(null,["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var fun = cljs.core.nth.call(null,vec__109705,(0),null);
var arg = cljs.core.nth.call(null,vec__109705,(1),null);
var var$ = cljs.core.nth.call(null,vec__109705,(2),null);
var agg_fn = (function (){var temp__5733__auto__ = fluree.db.query.analytical.built_in_aggregates.call(null,fun);
if(cljs.core.truth_(temp__5733__auto__)){
var agg_fn = temp__5733__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return agg_fn.call(null,arg,coll);
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.call(null,["Invalid aggregate selection function, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__109708 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_.call(null,var$)) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,var$),new cljs.core.Symbol(null,"distinct","distinct",-148347594,null))));
var variable = ((distinct_QMARK_)?cljs.core.second.call(null,var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
return agg_fn.call(null,cljs.core.distinct.call(null,coll));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.call(null,vec__109708,(0),null);
var variable = cljs.core.nth.call(null,vec__109708,(1),null);
var _ = (cljs.core.truth_(valid_var.call(null,variable))?null:(function(){throw cljs.core.ex_info.call(null,["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"variable","variable",-281346492),variable,new cljs.core.Keyword(null,"as","as",1148689641),as,new cljs.core.Keyword(null,"code","code",1586293142),agg_fn__$1], null);
});
fluree.db.query.analytical.calculate_aggregate = (function fluree$db$query$analytical$calculate_aggregate(res,agg){
var map__109711 = agg;
var map__109711__$1 = (((((!((map__109711 == null))))?(((((map__109711.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__109711.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__109711):map__109711);
var variable = cljs.core.get.call(null,map__109711__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var as = cljs.core.get.call(null,map__109711__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var code = cljs.core.get.call(null,map__109711__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var agg_params = cljs.core.flatten.call(null,fluree.db.query.analytical.select_from_tuples.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [variable], null),res));
var agg_result = code.call(null,agg_params);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [as,agg_result], null);
});
fluree.db.query.analytical.add_aggregate_cols = (function fluree$db$query$analytical$add_aggregate_cols(res,aggregate){
return cljs.core.reduce.call(null,(function (res__$1,agg){
var vec__109714 = fluree.db.query.analytical.calculate_aggregate.call(null,res__$1,agg);
var as = cljs.core.nth.call(null,vec__109714,(0),null);
var agg_result = cljs.core.nth.call(null,vec__109714,(1),null);
var map__109717 = res__$1;
var map__109717__$1 = (((((!((map__109717 == null))))?(((((map__109717.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__109717.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__109717):map__109717);
var headers = cljs.core.get.call(null,map__109717__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__109717__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var tuples_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__109713_SHARP_){
return cljs.core.conj.call(null,cljs.core.vec.call(null,p1__109713_SHARP_),agg_result);
}),tuples);
var headers_SINGLEQUOTE_ = cljs.core.conj.call(null,cljs.core.vec.call(null,headers),as);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_], null);
}),res,aggregate);
});
fluree.db.query.analytical.symbolize_keys = (function fluree$db$query$analytical$symbolize_keys(q_map){
var keys = cljs.core.map.call(null,cljs.core.symbol,cljs.core.keys.call(null,q_map));
var vals = cljs.core.vals.call(null,q_map);
return cljs.core.zipmap.call(null,keys,vals);
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 */
fluree.db.query.analytical.find_match = (function fluree$db$query$analytical$find_match(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.call(null,(function (p1__109719_SHARP_){
return cljs.core.nth.call(null,a_tuple,p1__109719_SHARP_);
}),a_idxs);
return cljs.core.reduce.call(null,(function (acc,b_tuple){
if(cljs.core._EQ_.call(null,a_tuple_part,cljs.core.map.call(null,(function (p1__109720_SHARP_){
return cljs.core.nth.call(null,b_tuple,p1__109720_SHARP_);
}),b_idxs))){
return cljs.core.conj.call(null,(function (){var or__4126__auto__ = acc;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.call(null,a_tuple,cljs.core.map.call(null,(function (p1__109721_SHARP_){
return cljs.core.nth.call(null,b_tuple,p1__109721_SHARP_);
}),b_not_idxs)));
} else {
return acc;
}
}),null,b_tuples);
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.analytical.find_match_PLUS_row_nums = (function fluree$db$query$analytical$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.call(null,(function (p1__109722_SHARP_){
return cljs.core.nth.call(null,a_tuple,p1__109722_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv.call(null,(function (p__109725,row,b_tuple){
var vec__109726 = p__109725;
var acc = cljs.core.nth.call(null,vec__109726,(0),null);
var b_rows = cljs.core.nth.call(null,vec__109726,(1),null);
if(cljs.core._EQ_.call(null,a_tuple_part,cljs.core.map.call(null,(function (p1__109723_SHARP_){
return cljs.core.nth.call(null,b_tuple,p1__109723_SHARP_);
}),b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,(function (){var or__4126__auto__ = acc;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.call(null,a_tuple,cljs.core.map.call(null,(function (p1__109724_SHARP_){
return cljs.core.nth.call(null,b_tuple,p1__109724_SHARP_);
}),b_not_idxs))),cljs.core.conj.call(null,b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,b_tuples));
});
fluree.db.query.analytical.inner_join = (function fluree$db$query$analytical$inner_join(a_res,b_res){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples.call(null,a_res,b_res);
var a_idxs = cljs.core.map.call(null,(function (p1__109729_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),p1__109729_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.call(null,(function (p1__109730_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__109730_SHARP_);
}),common_keys);
var b_not_idxs = (function (p1__109732_SHARP_){
return cljs.core.apply.call(null,cljs.core.vector,p1__109732_SHARP_);
}).call(null,clojure.set.difference.call(null,cljs.core.set.call(null,(function (p1__109731_SHARP_){
return cljs.core.range.call(null,(0),p1__109731_SHARP_);
}).call(null,cljs.core.count.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res)))),cljs.core.set.call(null,b_idxs)));
var c_tuples = cljs.core.apply.call(null,cljs.core.concat,cljs.core.map.call(null,(function (a_tuple){
return fluree.db.query.analytical.find_match.call(null,a_tuple,a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_res),b_idxs,b_not_idxs);
}),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_res)));
var c_headers = cljs.core.concat.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.map.call(null,(function (p1__109733_SHARP_){
return cljs.core.nth.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__109733_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.call(null,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_res),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_res)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
/**
 * OPTIONAL clause is equivalent to a left outer join. If there are no matches in the b-tuples,
 *   we just return a 'match' where each element of the match from b-tuple is nil.
 */
fluree.db.query.analytical.left_outer_join = (function fluree$db$query$analytical$left_outer_join(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples.call(null,a_tuples,b_tuples);
var a_idxs = cljs.core.map.call(null,(function (p1__109734_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),p1__109734_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.call(null,(function (p1__109735_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__109735_SHARP_);
}),common_keys);
var b_not_idxs = (function (p1__109737_SHARP_){
return cljs.core.apply.call(null,cljs.core.vector,p1__109737_SHARP_);
}).call(null,clojure.set.difference.call(null,cljs.core.set.call(null,(function (p1__109736_SHARP_){
return cljs.core.range.call(null,(0),p1__109736_SHARP_);
}).call(null,cljs.core.count.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples)))),cljs.core.set.call(null,b_idxs)));
var c_tuples = cljs.core.apply.call(null,cljs.core.concat,cljs.core.map.call(null,(function (a_tuple){
var matches = fluree.db.query.analytical.find_match.call(null,a_tuple,a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_idxs,b_not_idxs);
var or__4126__auto__ = matches;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.call(null,a_tuple,cljs.core.repeat.call(null,cljs.core.count.call(null,b_not_idxs),null))], null);
}
}),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_tuples)));
var c_headers = cljs.core.concat.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.call(null,(function (p1__109738_SHARP_){
return cljs.core.nth.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__109738_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.call(null,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_tuples),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_tuples)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
/**
 * UNION clause takes a left-hand side, which is inner-joined, and a right-hand side, which is inner-joined.
 *   Any tuples unbound by the other set are included.
 */
fluree.db.query.analytical.outer_union = (function fluree$db$query$analytical$outer_union(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples.call(null,a_tuples,b_tuples);
var a_idxs = cljs.core.map.call(null,(function (p1__109739_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),p1__109739_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.call(null,(function (p1__109740_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__109740_SHARP_);
}),common_keys);
var b_not_idxs = (function (p1__109742_SHARP_){
return cljs.core.apply.call(null,cljs.core.vector,p1__109742_SHARP_);
}).call(null,clojure.set.difference.call(null,cljs.core.set.call(null,(function (p1__109741_SHARP_){
return cljs.core.range.call(null,(0),p1__109741_SHARP_);
}).call(null,cljs.core.count.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples)))),cljs.core.set.call(null,b_idxs)));
var vec__109745 = cljs.core.reduce.call(null,(function (p__109748,a_tuple){
var vec__109749 = p__109748;
var c_tuples = cljs.core.nth.call(null,vec__109749,(0),null);
var b_matched_rows = cljs.core.nth.call(null,vec__109749,(1),null);
var vec__109752 = fluree.db.query.analytical.find_match_PLUS_row_nums.call(null,a_tuple,a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_idxs,b_not_idxs);
var matches = cljs.core.nth.call(null,vec__109752,(0),null);
var matched_rows = cljs.core.nth.call(null,vec__109752,(1),null);
var matches__$1 = (function (){var or__4126__auto__ = matches;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.call(null,a_tuple,cljs.core.repeat.call(null,cljs.core.count.call(null,b_not_idxs),null))], null);
}
})();
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.call(null,c_tuples,matches__$1),clojure.set.union.call(null,b_matched_rows,matched_rows)], null);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY,cljs.core.PersistentHashSet.EMPTY], null),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_tuples));
var c_tuples = cljs.core.nth.call(null,vec__109745,(0),null);
var b_matched_rows = cljs.core.nth.call(null,vec__109745,(1),null);
var b_unmatched_rows = cljs.core.remove.call(null,b_matched_rows,cljs.core.range.call(null,(0),cljs.core.count.call(null,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples))));
var c_headers = cljs.core.concat.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.call(null,(function (p1__109743_SHARP_){
return cljs.core.nth.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__109743_SHARP_);
}),b_not_idxs));
var b_idxs__GT_c_idxs = cljs.core.map.call(null,(function (p1__109744_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__109744_SHARP_);
}),c_headers);
var c_from_unmatched_b_tuples = cljs.core.map.call(null,(function (b_row){
var b_tuple = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.nth.call(null,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_row));
return cljs.core.map.call(null,(function (c_idx){
if((c_idx == null)){
return null;
} else {
return cljs.core.get.call(null,b_tuple,c_idx);
}
}),b_idxs__GT_c_idxs);
}),b_unmatched_rows);
var c_tuples__$1 = cljs.core.concat.call(null,c_tuples,c_from_unmatched_b_tuples);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.call(null,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_tuples),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_tuples)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples__$1], null);
});
fluree.db.query.analytical.tuples__GT_filter_required = (function fluree$db$query$analytical$tuples__GT_filter_required(headers,tuples,valid_vars,filter_code_req){
var filter_code_req_str = ["(and ",clojure.string.join.call(null," ",filter_code_req),")"].join('');
var vec__109756 = (function (){var or__4126__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.call(null,filter_code_req_str,valid_vars);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid required filters, provided: ",filter_code_req_str].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filter_code_req_STAR_ = cljs.core.nth.call(null,vec__109756,(0),null);
var _ = cljs.core.nth.call(null,vec__109756,(1),null);
var filter_code_req_str_STAR_ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_code_req_STAR_);
return cljs.core.filter.call(null,(function (p1__109755_SHARP_){
return fluree.db.query.analytical_filter.filter_row.call(null,headers,p1__109755_SHARP_,filter_code_req_str_STAR_);
}),tuples);
});
fluree.db.query.analytical.tuples__GT_filter_optional = (function fluree$db$query$analytical$tuples__GT_filter_optional(headers,tuples,valid_vars,filter_code_opts){
return cljs.core.reduce.call(null,(function (tuples__$1,filt){
var var_atom = cljs.core.atom.call(null,cljs.core.PersistentHashSet.EMPTY);
var vec__109761 = (function (){var or__4126__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.call(null,filt,valid_vars,var_atom);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid filter, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filt_STAR_ = cljs.core.nth.call(null,vec__109761,(0),null);
var filt_vars = cljs.core.nth.call(null,vec__109761,(1),null);
var filt_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt_STAR_);
var filt_vars_idxs = cljs.core.map.call(null,(function (p1__109759_SHARP_){
return fluree.db.util.core.index_of.call(null,headers,p1__109759_SHARP_);
}),cljs.core.deref.call(null,filt_vars));
var filtered_tuples = cljs.core.reduce.call(null,(function (acc,clause){
if(cljs.core.every_QMARK_.call(null,(function (p1__109760_SHARP_){
return cljs.core.nth.call(null,clause,p1__109760_SHARP_);
}),filt_vars_idxs)){
if(cljs.core.truth_(fluree.db.query.analytical_filter.filter_row.call(null,headers,clause,filt_str))){
return cljs.core.conj.call(null,acc,clause);
} else {
return acc;
}
} else {
return cljs.core.conj.call(null,acc,clause);
}
}),cljs.core.PersistentVector.EMPTY,tuples__$1);
return filtered_tuples;
}),tuples,filter_code_opts);
});
fluree.db.query.analytical.tuples__GT_filtered = (function fluree$db$query$analytical$tuples__GT_filtered(p__109764,filters,optional_QMARK_){
var map__109765 = p__109764;
var map__109765__$1 = (((((!((map__109765 == null))))?(((((map__109765.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__109765.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__109765):map__109765);
var tuple_map = map__109765__$1;
var headers = cljs.core.get.call(null,map__109765__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__109765__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var tuples = cljs.core.get.call(null,map__109765__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var valid_vars = cljs.core.set.call(null,headers);
var header_vec = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,headers);
var _ = ((typeof filters === 'string')?(function(){throw cljs.core.ex_info.call(null,["Filter must be enclosed in square brackets. Provided: ",filters].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
if(cljs.core.truth_(optional_QMARK_)){
var res = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),fluree.db.query.analytical.tuples__GT_filter_optional.call(null,header_vec,tuples,valid_vars,filters)], null);
return res;
} else {
var filter_code_req = fluree.db.query.analytical_filter.get_filters.call(null,filters,false);
var tuples__$1 = (cljs.core.truth_(cljs.core.not_empty.call(null,filter_code_req))?fluree.db.query.analytical.tuples__GT_filter_required.call(null,header_vec,tuples,valid_vars,filter_code_req):tuples);
var filter_code_opt = fluree.db.query.analytical_filter.get_filters.call(null,filters,true);
var tuples__$2 = (cljs.core.truth_(cljs.core.not_empty.call(null,filter_code_opt))?fluree.db.query.analytical.tuples__GT_filter_optional.call(null,header_vec,tuples__$1,valid_vars,filter_code_opt):tuples__$1);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples__$2], null);
}
});
fluree.db.query.analytical.bind_clause__GT_vars = (function fluree$db$query$analytical$bind_clause__GT_vars(res,clause){
var vec__109767 = clause;
var k = cljs.core.nth.call(null,vec__109767,(0),null);
var v = cljs.core.nth.call(null,vec__109767,(1),null);
var k__$1 = fluree.db.query.analytical.variable_QMARK_.call(null,k);
var _ = (cljs.core.truth_(k__$1)?null:(function(){throw cljs.core.ex_info.call(null,["Invalid intermediate aggregate value. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var map__109770 = res;
var map__109770__$1 = (((((!((map__109770 == null))))?(((((map__109770.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__109770.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__109770):map__109770);
var headers = cljs.core.get.call(null,map__109770__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__109770__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var var_value = (cljs.core.truth_(fluree.db.query.analytical.interm_aggregate_QMARK_.call(null,v))?cljs.core.second.call(null,fluree.db.query.analytical.calculate_aggregate.call(null,res,fluree.db.query.analytical.parse_aggregate.call(null,cljs.core.subs.call(null,v,(1)),cljs.core.set.call(null,(function (){var temp__5733__auto__ = cljs.core.keys.call(null,vars);
if(cljs.core.truth_(temp__5733__auto__)){
var valid_var = temp__5733__auto__;
return cljs.core.conj.call(null,headers,valid_var);
} else {
return headers;
}
})())))):v);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k__$1,var_value]);
});
fluree.db.query.analytical.optional__GT_left_outer_joins = (function fluree$db$query$analytical$optional__GT_left_outer_joins(db,q_map,optional_clauses,where_tuples,fuel,max_fuel,opts){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_109825){
var state_val_109826 = (state_109825[(1)]);
if((state_val_109826 === (7))){
var inst_109799 = (state_109825[(7)]);
var inst_109797 = (state_109825[(2)]);
var inst_109798 = fluree.db.util.async.throw_err.call(null,inst_109797);
var inst_109799__$1 = cljs.core.nth.call(null,inst_109798,(0),null);
var inst_109800 = cljs.core.nth.call(null,inst_109798,(1),null);
var inst_109801 = (inst_109799__$1 == null);
var state_109825__$1 = (function (){var statearr_109827 = state_109825;
(statearr_109827[(7)] = inst_109799__$1);

(statearr_109827[(8)] = inst_109800);

return statearr_109827;
})();
if(cljs.core.truth_(inst_109801)){
var statearr_109828_109856 = state_109825__$1;
(statearr_109828_109856[(1)] = (8));

} else {
var statearr_109829_109857 = state_109825__$1;
(statearr_109829_109857[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109826 === (1))){
var inst_109779 = cljs.core.seq.call(null,optional_clauses);
var inst_109780 = cljs.core.first.call(null,inst_109779);
var inst_109781 = cljs.core.next.call(null,inst_109779);
var inst_109782 = optional_clauses;
var inst_109783 = where_tuples;
var state_109825__$1 = (function (){var statearr_109830 = state_109825;
(statearr_109830[(9)] = inst_109781);

(statearr_109830[(10)] = inst_109780);

(statearr_109830[(11)] = inst_109783);

(statearr_109830[(12)] = inst_109782);

return statearr_109830;
})();
var statearr_109831_109858 = state_109825__$1;
(statearr_109831_109858[(2)] = null);

(statearr_109831_109858[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109826 === (4))){
var inst_109783 = (state_109825[(11)]);
var inst_109789 = (state_109825[(13)]);
var inst_109790 = (state_109825[(14)]);
var inst_109795 = fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_109783,inst_109789,inst_109790,true,fuel,max_fuel,opts);
var state_109825__$1 = state_109825;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_109825__$1,(7),inst_109795);
} else {
if((state_val_109826 === (15))){
var state_109825__$1 = state_109825;
var statearr_109832_109859 = state_109825__$1;
(statearr_109832_109859[(2)] = null);

(statearr_109832_109859[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109826 === (13))){
var inst_109816 = (state_109825[(2)]);
var state_109825__$1 = state_109825;
var statearr_109833_109860 = state_109825__$1;
(statearr_109833_109860[(2)] = inst_109816);

(statearr_109833_109860[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109826 === (6))){
var inst_109821 = (state_109825[(2)]);
var state_109825__$1 = state_109825;
var statearr_109834_109861 = state_109825__$1;
(statearr_109834_109861[(2)] = inst_109821);

(statearr_109834_109861[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109826 === (3))){
var inst_109823 = (state_109825[(2)]);
var state_109825__$1 = state_109825;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_109825__$1,inst_109823);
} else {
if((state_val_109826 === (12))){
var state_109825__$1 = state_109825;
var statearr_109835_109862 = state_109825__$1;
(statearr_109835_109862[(1)] = (14));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109826 === (2))){
var inst_109789 = (state_109825[(13)]);
var inst_109782 = (state_109825[(12)]);
var inst_109788 = cljs.core.seq.call(null,inst_109782);
var inst_109789__$1 = cljs.core.first.call(null,inst_109788);
var inst_109790 = cljs.core.next.call(null,inst_109788);
var state_109825__$1 = (function (){var statearr_109837 = state_109825;
(statearr_109837[(13)] = inst_109789__$1);

(statearr_109837[(14)] = inst_109790);

return statearr_109837;
})();
if(cljs.core.truth_(inst_109789__$1)){
var statearr_109838_109863 = state_109825__$1;
(statearr_109838_109863[(1)] = (4));

} else {
var statearr_109839_109864 = state_109825__$1;
(statearr_109839_109864[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109826 === (11))){
var inst_109799 = (state_109825[(7)]);
var inst_109800 = (state_109825[(8)]);
var inst_109782 = inst_109800;
var inst_109783 = inst_109799;
var state_109825__$1 = (function (){var statearr_109840 = state_109825;
(statearr_109840[(11)] = inst_109783);

(statearr_109840[(12)] = inst_109782);

return statearr_109840;
})();
var statearr_109841_109865 = state_109825__$1;
(statearr_109841_109865[(2)] = null);

(statearr_109841_109865[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109826 === (9))){
var inst_109789 = (state_109825[(13)]);
var inst_109805 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(inst_109789);
var state_109825__$1 = state_109825;
if(cljs.core.truth_(inst_109805)){
var statearr_109842_109866 = state_109825__$1;
(statearr_109842_109866[(1)] = (11));

} else {
var statearr_109843_109867 = state_109825__$1;
(statearr_109843_109867[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109826 === (5))){
var inst_109783 = (state_109825[(11)]);
var state_109825__$1 = state_109825;
var statearr_109844_109868 = state_109825__$1;
(statearr_109844_109868[(2)] = inst_109783);

(statearr_109844_109868[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109826 === (14))){
var inst_109799 = (state_109825[(7)]);
var inst_109783 = (state_109825[(11)]);
var inst_109800 = (state_109825[(8)]);
var inst_109810 = fluree.db.query.analytical.left_outer_join.call(null,inst_109783,inst_109799);
var inst_109782 = inst_109800;
var inst_109783__$1 = inst_109810;
var state_109825__$1 = (function (){var statearr_109845 = state_109825;
(statearr_109845[(11)] = inst_109783__$1);

(statearr_109845[(12)] = inst_109782);

return statearr_109845;
})();
var statearr_109846_109869 = state_109825__$1;
(statearr_109846_109869[(2)] = null);

(statearr_109846_109869[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109826 === (16))){
var inst_109814 = (state_109825[(2)]);
var state_109825__$1 = state_109825;
var statearr_109848_109870 = state_109825__$1;
(statearr_109848_109870[(2)] = inst_109814);

(statearr_109848_109870[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109826 === (10))){
var inst_109818 = (state_109825[(2)]);
var state_109825__$1 = state_109825;
var statearr_109849_109871 = state_109825__$1;
(statearr_109849_109871[(2)] = inst_109818);

(statearr_109849_109871[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109826 === (8))){
var inst_109783 = (state_109825[(11)]);
var inst_109800 = (state_109825[(8)]);
var tmp109847 = inst_109783;
var inst_109782 = inst_109800;
var inst_109783__$1 = tmp109847;
var state_109825__$1 = (function (){var statearr_109850 = state_109825;
(statearr_109850[(11)] = inst_109783__$1);

(statearr_109850[(12)] = inst_109782);

return statearr_109850;
})();
var statearr_109851_109872 = state_109825__$1;
(statearr_109851_109872[(2)] = null);

(statearr_109851_109872[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__99975__auto__ = null;
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__99975__auto____0 = (function (){
var statearr_109852 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_109852[(0)] = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__99975__auto__);

(statearr_109852[(1)] = (1));

return statearr_109852;
});
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__99975__auto____1 = (function (state_109825){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_109825);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e109853){if((e109853 instanceof Object)){
var ex__99978__auto__ = e109853;
var statearr_109854_109873 = state_109825;
(statearr_109854_109873[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_109825);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e109853;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__109874 = state_109825;
state_109825 = G__109874;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__99975__auto__ = function(state_109825){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__99975__auto____1.call(this,state_109825);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__99975__auto____0;
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__99975__auto____1;
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_109855 = f__100070__auto__.call(null);
(statearr_109855[(6)] = c__100069__auto__);

return statearr_109855;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
fluree.db.query.analytical.res_absorb_vars = (function fluree$db$query$analytical$res_absorb_vars(res){
return cljs.core.reduce.call(null,(function (acc,p__109876){
var vec__109877 = p__109876;
var var_name = cljs.core.nth.call(null,vec__109877,(0),null);
var var_val = cljs.core.nth.call(null,vec__109877,(1),null);
var tuples_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__109875_SHARP_){
return cljs.core.conj.call(null,p1__109875_SHARP_,var_val);
}),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(res));
var headers_SINGLEQUOTE_ = cljs.core.conj.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(res),var_name);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_,new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_], null);
}),res,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(res));
});
/**
 * Tuples and optional? are only used for Wikidata, because need to both limit calls to Wikidata,
 *   and ensure that returned results are as limited as possible (but still relevant).
 */
fluree.db.query.analytical.clause__GT_tuples = (function fluree$db$query$analytical$clause__GT_tuples(db,p__109881,p__109882,clause,r,optional_QMARK_,fuel,max_fuel,opts){
var map__109883 = p__109881;
var map__109883__$1 = (((((!((map__109883 == null))))?(((((map__109883.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__109883.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__109883):map__109883);
var q_map = map__109883__$1;
var prefixes = cljs.core.get.call(null,map__109883__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var map__109884 = p__109882;
var map__109884__$1 = (((((!((map__109884 == null))))?(((((map__109884.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__109884.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__109884):map__109884);
var res = map__109884__$1;
var vars = cljs.core.get.call(null,map__109884__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_110089){
var state_val_110090 = (state_110089[(1)]);
if((state_val_110090 === (7))){
var inst_110085 = (state_110089[(2)]);
var state_110089__$1 = state_110089;
var statearr_110091_110171 = state_110089__$1;
(statearr_110091_110171[(2)] = inst_110085);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_110089__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110090 === (20))){
var inst_109929 = (state_110089[(7)]);
var inst_109921 = (state_110089[(8)]);
var inst_109930 = (state_110089[(9)]);
var inst_109920 = (state_110089[(10)]);
var inst_109922 = (state_110089[(11)]);
var inst_109894 = (state_110089[(12)]);
var inst_109918 = (state_110089[(13)]);
var inst_109923 = (state_110089[(14)]);
var inst_109934 = (state_110089[(2)]);
var inst_109935 = fluree.db.util.async.throw_err.call(null,inst_109934);
var inst_109936 = (function (){var vec__109925 = inst_109922;
var new_res = inst_109935;
var seq__109916 = inst_109921;
var rest = inst_109930;
var first__109927 = inst_109929;
var pred__109895 = cljs.core._EQ_;
var tuples = inst_109923;
var expr__109896 = inst_109894;
var seq__109926 = inst_109930;
var G__109914 = inst_109922;
var first__109917 = inst_109920;
var vec__109915 = inst_109918;
var segment_type = inst_109894;
var clause_group = inst_109929;
return (function (res__$1,var$){
return cljs.core.update.call(null,new_res,new cljs.core.Keyword(null,"var","var",-769682797),cljs.core.dissoc,var$);
});
})();
var inst_109937 = cljs.core.keys.call(null,vars);
var inst_109938 = cljs.core.reduce.call(null,inst_109936,inst_109935,inst_109937);
var inst_109939 = fluree.db.query.analytical.res_absorb_vars.call(null,inst_109938);
var state_110089__$1 = (function (){var statearr_110092 = state_110089;
(statearr_110092[(15)] = inst_109939);

return statearr_110092;
})();
if(cljs.core.truth_(inst_109923)){
var statearr_110093_110172 = state_110089__$1;
(statearr_110093_110172[(1)] = (21));

} else {
var statearr_110094_110173 = state_110089__$1;
(statearr_110094_110173[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110090 === (58))){
var inst_110059 = (state_110089[(16)]);
var inst_110062 = (state_110089[(2)]);
var inst_110063 = fluree.db.util.async.throw_err.call(null,inst_110062);
var inst_110064 = [inst_110063,r];
var inst_110065 = (new cljs.core.PersistentVector(null,2,(5),inst_110059,inst_110064,null));
var state_110089__$1 = state_110089;
var statearr_110095_110174 = state_110089__$1;
(statearr_110095_110174[(2)] = inst_110065);

(statearr_110095_110174[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110090 === (27))){
var inst_109970 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_109971 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(clause);
var inst_109972 = fluree.db.query.analytical.tuples__GT_filtered.call(null,res,inst_109971,optional_QMARK_);
var inst_109973 = [inst_109972,r];
var inst_109974 = (new cljs.core.PersistentVector(null,2,(5),inst_109970,inst_109973,null));
var state_110089__$1 = state_110089;
var statearr_110096_110175 = state_110089__$1;
(statearr_110096_110175[(2)] = inst_109974);

(statearr_110096_110175[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110090 === (1))){
var state_110089__$1 = state_110089;
var statearr_110097_110176 = state_110089__$1;
(statearr_110097_110176[(2)] = null);

(statearr_110097_110176[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110090 === (24))){
var inst_109894 = (state_110089[(12)]);
var inst_109958 = new cljs.core.Keyword(null,"bind","bind",-113428417).cljs$core$IFn$_invoke$arity$1(clause);
var inst_109959 = (function (){var segment_type = inst_109894;
var pred__109895 = cljs.core._EQ_;
var expr__109896 = inst_109894;
var bindings = inst_109958;
return (function (p1__109880_SHARP_){
return fluree.db.query.analytical.bind_clause__GT_vars.call(null,res,p1__109880_SHARP_);
});
})();
var inst_109960 = cljs.core.map.call(null,inst_109959,inst_109958);
var inst_109961 = cljs.core.PersistentHashMap.EMPTY;
var inst_109962 = cljs.core.into.call(null,inst_109961,inst_109960);
var inst_109963 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_109964 = cljs.core.update.call(null,res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_109962);
var inst_109965 = [inst_109964,r];
var inst_109966 = (new cljs.core.PersistentVector(null,2,(5),inst_109963,inst_109965,null));
var state_110089__$1 = state_110089;
var statearr_110098_110177 = state_110089__$1;
(statearr_110098_110177[(2)] = inst_109966);

(statearr_110098_110177[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110090 === (55))){
var inst_110042 = (state_110089[(17)]);
var inst_110041 = (state_110089[(18)]);
var inst_110059 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_110060 = fluree.db.query.analytical.fdb_clause__GT_tuples.call(null,inst_110041,res,inst_110042,fuel,max_fuel);
var state_110089__$1 = (function (){var statearr_110099 = state_110089;
(statearr_110099[(16)] = inst_110059);

return statearr_110099;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_110089__$1,(58),inst_110060);
} else {
if((state_val_110090 === (39))){
var inst_110079 = (state_110089[(2)]);
var state_110089__$1 = state_110089;
var statearr_110100_110178 = state_110089__$1;
(statearr_110100_110178[(2)] = inst_110079);

(statearr_110100_110178[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110090 === (46))){
var inst_110075 = (state_110089[(2)]);
var state_110089__$1 = state_110089;
var statearr_110101_110179 = state_110089__$1;
(statearr_110101_110179[(2)] = inst_110075);

(statearr_110101_110179[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110090 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_110089,(3),Error,null,(2));
var inst_109891 = cljs.core.map_QMARK_.call(null,clause);
var state_110089__$1 = state_110089;
if(inst_109891){
var statearr_110102_110180 = state_110089__$1;
(statearr_110102_110180[(1)] = (5));

} else {
var statearr_110103_110181 = state_110089__$1;
(statearr_110103_110181[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110090 === (54))){
var inst_110070 = (state_110089[(2)]);
var state_110089__$1 = state_110089;
var statearr_110104_110182 = state_110089__$1;
(statearr_110104_110182[(2)] = inst_110070);

(statearr_110104_110182[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110090 === (15))){
var inst_109929 = (state_110089[(7)]);
var inst_109922 = (state_110089[(11)]);
var inst_109928 = cljs.core.seq.call(null,inst_109922);
var inst_109929__$1 = cljs.core.first.call(null,inst_109928);
var inst_109930 = cljs.core.next.call(null,inst_109928);
var state_110089__$1 = (function (){var statearr_110105 = state_110089;
(statearr_110105[(7)] = inst_109929__$1);

(statearr_110105[(9)] = inst_109930);

return statearr_110105;
})();
if(cljs.core.truth_(inst_109929__$1)){
var statearr_110106_110183 = state_110089__$1;
(statearr_110106_110183[(1)] = (17));

} else {
var statearr_110107_110184 = state_110089__$1;
(statearr_110107_110184[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110090 === (48))){
var inst_110042 = (state_110089[(17)]);
var inst_110045 = fluree.db.query.analytical.wikidata__GT_tuples.call(null,q_map,inst_110042,r,res,optional_QMARK_,fuel,max_fuel);
var state_110089__$1 = state_110089;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_110089__$1,(51),inst_110045);
} else {
if((state_val_110090 === (50))){
var inst_110072 = (state_110089[(2)]);
var state_110089__$1 = state_110089;
var statearr_110108_110185 = state_110089__$1;
(statearr_110108_110185[(2)] = inst_110072);

(statearr_110108_110185[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110090 === (21))){
var inst_109930 = (state_110089[(9)]);
var inst_109939 = (state_110089[(15)]);
var inst_109923 = (state_110089[(14)]);
var inst_109941 = fluree.db.query.analytical.outer_union.call(null,inst_109923,inst_109939);
var inst_109922 = inst_109930;
var inst_109923__$1 = inst_109941;
var state_110089__$1 = (function (){var statearr_110109 = state_110089;
(statearr_110109[(11)] = inst_109922);

(statearr_110109[(14)] = inst_109923__$1);

return statearr_110109;
})();
var statearr_110110_110186 = state_110089__$1;
(statearr_110110_110186[(2)] = null);

(statearr_110110_110186[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110090 === (31))){
var inst_109999 = cljs.core.count.call(null,clause);
var inst_110000 = cljs.core._EQ_.call(null,(3),inst_109999);
var inst_110001 = cljs.core.second.call(null,clause);
var inst_110002 = cljs.core._EQ_.call(null,inst_110001,"rdf:type");
var inst_110003 = ((inst_110000) && (inst_110002));
var state_110089__$1 = state_110089;
if(cljs.core.truth_(inst_110003)){
var statearr_110111_110187 = state_110089__$1;
(statearr_110111_110187[(1)] = (33));

} else {
var statearr_110112_110188 = state_110089__$1;
(statearr_110112_110188[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110090 === (32))){
var inst_110083 = (state_110089[(2)]);
var state_110089__$1 = state_110089;
var statearr_110113_110189 = state_110089__$1;
(statearr_110113_110189[(2)] = inst_110083);

(statearr_110113_110189[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110090 === (40))){
var inst_110016 = (state_110089[(19)]);
var inst_110019 = (state_110089[(2)]);
var inst_110020 = fluree.db.util.async.throw_err.call(null,inst_110019);
var inst_110021 = [inst_110020,r];
var inst_110022 = (new cljs.core.PersistentVector(null,2,(5),inst_110016,inst_110021,null));
var state_110089__$1 = state_110089;
var statearr_110114_110190 = state_110089__$1;
(statearr_110114_110190[(2)] = inst_110022);

(statearr_110114_110190[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110090 === (56))){
var state_110089__$1 = state_110089;
var statearr_110115_110191 = state_110089__$1;
(statearr_110115_110191[(2)] = null);

(statearr_110115_110191[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110090 === (33))){
var inst_110005 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_110006 = fluree.db.query.analytical.collection__GT_tuples.call(null,db,res,clause);
var state_110089__$1 = (function (){var statearr_110116 = state_110089;
(statearr_110116[(20)] = inst_110005);

return statearr_110116;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_110089__$1,(36),inst_110006);
} else {
if((state_val_110090 === (13))){
var inst_109894 = (state_110089[(12)]);
var inst_109956 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"bind","bind",-113428417),inst_109894);
var state_110089__$1 = state_110089;
if(inst_109956){
var statearr_110117_110192 = state_110089__$1;
(statearr_110117_110192[(1)] = (24));

} else {
var statearr_110118_110193 = state_110089__$1;
(statearr_110118_110193[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110090 === (22))){
var inst_109930 = (state_110089[(9)]);
var inst_109939 = (state_110089[(15)]);
var inst_109922 = inst_109930;
var inst_109923 = inst_109939;
var state_110089__$1 = (function (){var statearr_110119 = state_110089;
(statearr_110119[(11)] = inst_109922);

(statearr_110119[(14)] = inst_109923);

return statearr_110119;
})();
var statearr_110120_110194 = state_110089__$1;
(statearr_110120_110194[(2)] = null);

(statearr_110120_110194[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110090 === (36))){
var inst_110005 = (state_110089[(20)]);
var inst_110008 = (state_110089[(2)]);
var inst_110009 = fluree.db.util.async.throw_err.call(null,inst_110008);
var inst_110010 = [inst_110009,r];
var inst_110011 = (new cljs.core.PersistentVector(null,2,(5),inst_110005,inst_110010,null));
var state_110089__$1 = state_110089;
var statearr_110121_110195 = state_110089__$1;
(statearr_110121_110195[(2)] = inst_110011);

(statearr_110121_110195[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110090 === (41))){
var inst_110027 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_110028 = fluree.db.query.analytical.bind_clause__GT_vars.call(null,res,clause);
var inst_110029 = cljs.core.update.call(null,res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_110028);
var inst_110030 = [inst_110029,r];
var inst_110031 = (new cljs.core.PersistentVector(null,2,(5),inst_110027,inst_110030,null));
var state_110089__$1 = state_110089;
var statearr_110122_110196 = state_110089__$1;
(statearr_110122_110196[(2)] = inst_110031);

(statearr_110122_110196[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110090 === (43))){
var inst_110077 = (state_110089[(2)]);
var state_110089__$1 = state_110089;
var statearr_110123_110197 = state_110089__$1;
(statearr_110123_110197[(2)] = inst_110077);

(statearr_110123_110197[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110090 === (29))){
var inst_109980 = (state_110089[(2)]);
var state_110089__$1 = state_110089;
var statearr_110124_110198 = state_110089__$1;
(statearr_110124_110198[(2)] = inst_109980);

(statearr_110124_110198[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110090 === (44))){
var inst_110037 = fluree.db.query.analytical.get_source_clause.call(null,db,clause,prefixes,opts);
var state_110089__$1 = state_110089;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_110089__$1,(47),inst_110037);
} else {
if((state_val_110090 === (6))){
var inst_109988 = cljs.core.count.call(null,clause);
var inst_109989 = cljs.core._EQ_.call(null,(3),inst_109988);
var inst_109990 = cljs.core.second.call(null,clause);
var inst_109991 = clojure.string.starts_with_QMARK_.call(null,inst_109990,"fullText:");
var inst_109992 = ((inst_109989) && (inst_109991));
var state_110089__$1 = state_110089;
if(cljs.core.truth_(inst_109992)){
var statearr_110125_110199 = state_110089__$1;
(statearr_110125_110199[(1)] = (30));

} else {
var statearr_110126_110200 = state_110089__$1;
(statearr_110126_110200[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110090 === (28))){
var inst_109894 = (state_110089[(12)]);
var inst_109976 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_109894)].join('');
var inst_109977 = (new Error(inst_109976));
var inst_109978 = (function(){throw inst_109977})();
var state_110089__$1 = state_110089;
var statearr_110127_110201 = state_110089__$1;
(statearr_110127_110201[(2)] = inst_109978);

(statearr_110127_110201[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110090 === (51))){
var inst_110047 = (state_110089[(2)]);
var inst_110048 = fluree.db.util.async.throw_err.call(null,inst_110047);
var state_110089__$1 = state_110089;
var statearr_110128_110202 = state_110089__$1;
(statearr_110128_110202[(2)] = inst_110048);

(statearr_110128_110202[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110090 === (25))){
var inst_109894 = (state_110089[(12)]);
var inst_109968 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"filter","filter",-948537934),inst_109894);
var state_110089__$1 = state_110089;
if(inst_109968){
var statearr_110129_110203 = state_110089__$1;
(statearr_110129_110203[(1)] = (27));

} else {
var statearr_110130_110204 = state_110089__$1;
(statearr_110130_110204[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110090 === (34))){
var inst_110013 = cljs.core.count.call(null,clause);
var inst_110014 = cljs.core._EQ_.call(null,(3),inst_110013);
var state_110089__$1 = state_110089;
if(inst_110014){
var statearr_110131_110205 = state_110089__$1;
(statearr_110131_110205[(1)] = (37));

} else {
var statearr_110132_110206 = state_110089__$1;
(statearr_110132_110206[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110090 === (17))){
var inst_109929 = (state_110089[(7)]);
var inst_109932 = fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_109929,q_map,vars,fuel,max_fuel,opts);
var state_110089__$1 = state_110089;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_110089__$1,(20),inst_109932);
} else {
if((state_val_110090 === (3))){
var inst_109887 = (state_110089[(2)]);
var state_110089__$1 = state_110089;
var statearr_110133_110207 = state_110089__$1;
(statearr_110133_110207[(2)] = inst_109887);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_110089__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110090 === (12))){
var inst_109918 = (state_110089[(13)]);
var inst_109918__$1 = new cljs.core.Keyword(null,"union","union",2142937499).cljs$core$IFn$_invoke$arity$1(clause);
var inst_109919 = cljs.core.seq.call(null,inst_109918__$1);
var inst_109920 = cljs.core.first.call(null,inst_109919);
var inst_109921 = cljs.core.next.call(null,inst_109919);
var inst_109922 = inst_109918__$1;
var inst_109923 = null;
var state_110089__$1 = (function (){var statearr_110134 = state_110089;
(statearr_110134[(8)] = inst_109921);

(statearr_110134[(10)] = inst_109920);

(statearr_110134[(11)] = inst_109922);

(statearr_110134[(13)] = inst_109918__$1);

(statearr_110134[(14)] = inst_109923);

return statearr_110134;
})();
var statearr_110135_110208 = state_110089__$1;
(statearr_110135_110208[(2)] = null);

(statearr_110135_110208[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110090 === (2))){
var inst_110087 = (state_110089[(2)]);
var state_110089__$1 = state_110089;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_110089__$1,inst_110087);
} else {
if((state_val_110090 === (23))){
var inst_109946 = (state_110089[(2)]);
var state_110089__$1 = state_110089;
var statearr_110136_110209 = state_110089__$1;
(statearr_110136_110209[(2)] = inst_109946);

(statearr_110136_110209[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110090 === (47))){
var inst_110041 = (state_110089[(18)]);
var inst_110039 = (state_110089[(2)]);
var inst_110040 = fluree.db.util.async.throw_err.call(null,inst_110039);
var inst_110041__$1 = cljs.core.nth.call(null,inst_110040,(0),null);
var inst_110042 = cljs.core.nth.call(null,inst_110040,(1),null);
var inst_110043 = cljs.core._EQ_.call(null,"$wd",inst_110041__$1);
var state_110089__$1 = (function (){var statearr_110137 = state_110089;
(statearr_110137[(17)] = inst_110042);

(statearr_110137[(18)] = inst_110041__$1);

return statearr_110137;
})();
if(inst_110043){
var statearr_110138_110210 = state_110089__$1;
(statearr_110138_110210[(1)] = (48));

} else {
var statearr_110139_110211 = state_110089__$1;
(statearr_110139_110211[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110090 === (35))){
var inst_110081 = (state_110089[(2)]);
var state_110089__$1 = state_110089;
var statearr_110140_110212 = state_110089__$1;
(statearr_110140_110212[(2)] = inst_110081);

(statearr_110140_110212[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110090 === (19))){
var inst_109952 = (state_110089[(2)]);
var state_110089__$1 = state_110089;
var statearr_110141_110213 = state_110089__$1;
(statearr_110141_110213[(2)] = inst_109952);

(statearr_110141_110213[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110090 === (57))){
var inst_110068 = (state_110089[(2)]);
var state_110089__$1 = state_110089;
var statearr_110142_110214 = state_110089__$1;
(statearr_110142_110214[(2)] = inst_110068);

(statearr_110142_110214[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110090 === (11))){
var inst_109900 = (state_110089[(21)]);
var inst_109904 = (state_110089[(2)]);
var inst_109905 = fluree.db.util.async.throw_err.call(null,inst_109904);
var inst_109906 = [inst_109905,r];
var inst_109907 = (new cljs.core.PersistentVector(null,2,(5),inst_109900,inst_109906,null));
var state_110089__$1 = state_110089;
var statearr_110143_110215 = state_110089__$1;
(statearr_110143_110215[(2)] = inst_109907);

(statearr_110143_110215[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110090 === (9))){
var inst_109894 = (state_110089[(12)]);
var inst_109909 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"union","union",2142937499),inst_109894);
var state_110089__$1 = state_110089;
if(inst_109909){
var statearr_110144_110216 = state_110089__$1;
(statearr_110144_110216[(1)] = (12));

} else {
var statearr_110145_110217 = state_110089__$1;
(statearr_110145_110217[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110090 === (5))){
var inst_109894 = (state_110089[(12)]);
var inst_109893 = cljs.core.keys.call(null,clause);
var inst_109894__$1 = cljs.core.first.call(null,inst_109893);
var inst_109898 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"optional","optional",2053951509),inst_109894__$1);
var state_110089__$1 = (function (){var statearr_110146 = state_110089;
(statearr_110146[(12)] = inst_109894__$1);

return statearr_110146;
})();
if(inst_109898){
var statearr_110147_110218 = state_110089__$1;
(statearr_110147_110218[(1)] = (8));

} else {
var statearr_110148_110219 = state_110089__$1;
(statearr_110148_110219[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110090 === (14))){
var inst_109984 = (state_110089[(2)]);
var state_110089__$1 = state_110089;
var statearr_110149_110220 = state_110089__$1;
(statearr_110149_110220[(2)] = inst_109984);

(statearr_110149_110220[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110090 === (45))){
var state_110089__$1 = state_110089;
var statearr_110150_110221 = state_110089__$1;
(statearr_110150_110221[(2)] = null);

(statearr_110150_110221[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110090 === (53))){
var state_110089__$1 = state_110089;
var statearr_110151_110222 = state_110089__$1;
(statearr_110151_110222[(1)] = (55));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110090 === (26))){
var inst_109982 = (state_110089[(2)]);
var state_110089__$1 = state_110089;
var statearr_110153_110223 = state_110089__$1;
(statearr_110153_110223[(2)] = inst_109982);

(statearr_110153_110223[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110090 === (16))){
var inst_109954 = (state_110089[(2)]);
var state_110089__$1 = state_110089;
var statearr_110154_110224 = state_110089__$1;
(statearr_110154_110224[(2)] = inst_109954);

(statearr_110154_110224[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110090 === (38))){
var inst_110024 = cljs.core.count.call(null,clause);
var inst_110025 = cljs.core._EQ_.call(null,(2),inst_110024);
var state_110089__$1 = state_110089;
if(inst_110025){
var statearr_110155_110225 = state_110089__$1;
(statearr_110155_110225[(1)] = (41));

} else {
var statearr_110156_110226 = state_110089__$1;
(statearr_110156_110226[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110090 === (30))){
var inst_109994 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_109995 = fluree.db.query.analytical.full_text__GT_tuples.call(null,db,res,clause);
var inst_109996 = [inst_109995,r];
var inst_109997 = (new cljs.core.PersistentVector(null,2,(5),inst_109994,inst_109996,null));
var state_110089__$1 = state_110089;
var statearr_110157_110227 = state_110089__$1;
(statearr_110157_110227[(2)] = inst_109997);

(statearr_110157_110227[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110090 === (10))){
var inst_109986 = (state_110089[(2)]);
var state_110089__$1 = state_110089;
var statearr_110158_110228 = state_110089__$1;
(statearr_110158_110228[(2)] = inst_109986);

(statearr_110158_110228[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110090 === (18))){
var inst_109923 = (state_110089[(14)]);
var inst_109948 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_109949 = [inst_109923,r];
var inst_109950 = (new cljs.core.PersistentVector(null,2,(5),inst_109948,inst_109949,null));
var state_110089__$1 = state_110089;
var statearr_110159_110229 = state_110089__$1;
(statearr_110159_110229[(2)] = inst_109950);

(statearr_110159_110229[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110090 === (52))){
var inst_110042 = (state_110089[(17)]);
var inst_110041 = (state_110089[(18)]);
var inst_110053 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_110054 = fluree.db.query.analytical.full_text__GT_tuples.call(null,inst_110041,res,inst_110042);
var inst_110055 = [inst_110054,r];
var inst_110056 = (new cljs.core.PersistentVector(null,2,(5),inst_110053,inst_110055,null));
var state_110089__$1 = state_110089;
var statearr_110160_110230 = state_110089__$1;
(statearr_110160_110230[(2)] = inst_110056);

(statearr_110160_110230[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110090 === (42))){
var state_110089__$1 = state_110089;
var statearr_110161_110231 = state_110089__$1;
(statearr_110161_110231[(1)] = (44));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110090 === (37))){
var inst_110016 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_110017 = fluree.db.query.analytical.fdb_clause__GT_tuples.call(null,db,res,clause,fuel,max_fuel);
var state_110089__$1 = (function (){var statearr_110163 = state_110089;
(statearr_110163[(19)] = inst_110016);

return statearr_110163;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_110089__$1,(40),inst_110017);
} else {
if((state_val_110090 === (8))){
var inst_109900 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_109901 = new cljs.core.Keyword(null,"optional","optional",2053951509).cljs$core$IFn$_invoke$arity$1(clause);
var inst_109902 = fluree.db.query.analytical.optional__GT_left_outer_joins.call(null,db,q_map,inst_109901,res,fuel,max_fuel,opts);
var state_110089__$1 = (function (){var statearr_110164 = state_110089;
(statearr_110164[(21)] = inst_109900);

return statearr_110164;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_110089__$1,(11),inst_109902);
} else {
if((state_val_110090 === (49))){
var inst_110042 = (state_110089[(17)]);
var inst_110050 = cljs.core.second.call(null,inst_110042);
var inst_110051 = clojure.string.starts_with_QMARK_.call(null,inst_110050,"fullText:");
var state_110089__$1 = state_110089;
if(inst_110051){
var statearr_110165_110232 = state_110089__$1;
(statearr_110165_110232[(1)] = (52));

} else {
var statearr_110166_110233 = state_110089__$1;
(statearr_110166_110233[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__99975__auto__ = null;
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__99975__auto____0 = (function (){
var statearr_110167 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_110167[(0)] = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__99975__auto__);

(statearr_110167[(1)] = (1));

return statearr_110167;
});
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__99975__auto____1 = (function (state_110089){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_110089);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e110168){if((e110168 instanceof Object)){
var ex__99978__auto__ = e110168;
var statearr_110169_110234 = state_110089;
(statearr_110169_110234[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_110089);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e110168;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__110235 = state_110089;
state_110089 = G__110235;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__99975__auto__ = function(state_110089){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__99975__auto____1.call(this,state_110089);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__99975__auto____0;
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__99975__auto____1;
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_110170 = f__100070__auto__.call(null);
(statearr_110170[(6)] = c__100069__auto__);

return statearr_110170;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
fluree.db.query.analytical.resolve_where_clause = (function fluree$db$query$analytical$resolve_where_clause(var_args){
var G__110237 = arguments.length;
switch (G__110237) {
case 6:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6 = (function (db,where,q_map,vars,fuel,max_fuel){
return fluree.db.query.analytical.resolve_where_clause.call(null,db,where,q_map,vars,fuel,max_fuel,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 = (function (db,where,q_map,vars,fuel,max_fuel,opts){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_110313){
var state_val_110314 = (state_110313[(1)]);
if((state_val_110314 === (7))){
var inst_110263 = (state_110313[(7)]);
var inst_110264 = (state_110313[(8)]);
var inst_110257 = (state_110313[(9)]);
var inst_110269 = fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_110257,inst_110263,inst_110264,false,fuel,max_fuel,opts);
var state_110313__$1 = state_110313;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_110313__$1,(10),inst_110269);
} else {
if((state_val_110314 === (20))){
var inst_110274 = (state_110313[(10)]);
var inst_110257 = (state_110313[(9)]);
var tmp110315 = inst_110257;
var inst_110256 = inst_110274;
var inst_110257__$1 = tmp110315;
var state_110313__$1 = (function (){var statearr_110316 = state_110313;
(statearr_110316[(11)] = inst_110256);

(statearr_110316[(9)] = inst_110257__$1);

return statearr_110316;
})();
var statearr_110317_110357 = state_110313__$1;
(statearr_110317_110357[(2)] = null);

(statearr_110317_110357[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110314 === (1))){
var state_110313__$1 = state_110313;
var statearr_110318_110358 = state_110313__$1;
(statearr_110318_110358[(2)] = null);

(statearr_110318_110358[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110314 === (24))){
var state_110313__$1 = state_110313;
var statearr_110319_110359 = state_110313__$1;
(statearr_110319_110359[(2)] = null);

(statearr_110319_110359[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110314 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_110313,(3),Error,null,(2));
var inst_110249 = cljs.core.seq.call(null,where);
var inst_110250 = cljs.core.first.call(null,inst_110249);
var inst_110251 = cljs.core.next.call(null,inst_110249);
var inst_110252 = [new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_110253 = fluree.db.query.analytical.symbolize_keys.call(null,vars);
var inst_110254 = [inst_110253];
var inst_110255 = cljs.core.PersistentHashMap.fromArrays(inst_110252,inst_110254);
var inst_110256 = where;
var inst_110257 = inst_110255;
var state_110313__$1 = (function (){var statearr_110320 = state_110313;
(statearr_110320[(12)] = inst_110251);

(statearr_110320[(13)] = inst_110250);

(statearr_110320[(11)] = inst_110256);

(statearr_110320[(9)] = inst_110257);

return statearr_110320;
})();
var statearr_110321_110360 = state_110313__$1;
(statearr_110321_110360[(2)] = null);

(statearr_110321_110360[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110314 === (15))){
var inst_110273 = (state_110313[(14)]);
var inst_110289 = (inst_110273 == null);
var state_110313__$1 = state_110313;
if(cljs.core.truth_(inst_110289)){
var statearr_110322_110361 = state_110313__$1;
(statearr_110322_110361[(1)] = (20));

} else {
var statearr_110323_110362 = state_110313__$1;
(statearr_110323_110362[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110314 === (21))){
var state_110313__$1 = state_110313;
var statearr_110324_110363 = state_110313__$1;
(statearr_110324_110363[(1)] = (23));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110314 === (13))){
var inst_110304 = (state_110313[(2)]);
var state_110313__$1 = state_110313;
var statearr_110326_110364 = state_110313__$1;
(statearr_110326_110364[(2)] = inst_110304);

(statearr_110326_110364[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110314 === (22))){
var inst_110300 = (state_110313[(2)]);
var state_110313__$1 = state_110313;
var statearr_110327_110365 = state_110313__$1;
(statearr_110327_110365[(2)] = inst_110300);

(statearr_110327_110365[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110314 === (6))){
var inst_110309 = (state_110313[(2)]);
var state_110313__$1 = state_110313;
var statearr_110328_110366 = state_110313__$1;
(statearr_110328_110366[(2)] = inst_110309);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_110313__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110314 === (25))){
var inst_110298 = (state_110313[(2)]);
var state_110313__$1 = state_110313;
var statearr_110329_110367 = state_110313__$1;
(statearr_110329_110367[(2)] = inst_110298);

(statearr_110329_110367[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110314 === (17))){
var inst_110273 = (state_110313[(14)]);
var state_110313__$1 = state_110313;
var statearr_110330_110368 = state_110313__$1;
(statearr_110330_110368[(2)] = inst_110273);

(statearr_110330_110368[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110314 === (3))){
var inst_110238 = (state_110313[(2)]);
var state_110313__$1 = state_110313;
var statearr_110331_110369 = state_110313__$1;
(statearr_110331_110369[(2)] = inst_110238);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_110313__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110314 === (12))){
var inst_110257 = (state_110313[(9)]);
var inst_110280 = cljs.core.dissoc.call(null,inst_110257,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_110281 = cljs.core.empty_QMARK_.call(null,inst_110280);
var state_110313__$1 = state_110313;
if(inst_110281){
var statearr_110332_110370 = state_110313__$1;
(statearr_110332_110370[(1)] = (14));

} else {
var statearr_110333_110371 = state_110313__$1;
(statearr_110333_110371[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110314 === (2))){
var inst_110311 = (state_110313[(2)]);
var state_110313__$1 = state_110313;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_110313__$1,inst_110311);
} else {
if((state_val_110314 === (23))){
var inst_110273 = (state_110313[(14)]);
var inst_110274 = (state_110313[(10)]);
var inst_110257 = (state_110313[(9)]);
var inst_110294 = fluree.db.query.analytical.inner_join.call(null,inst_110257,inst_110273);
var inst_110256 = inst_110274;
var inst_110257__$1 = inst_110294;
var state_110313__$1 = (function (){var statearr_110334 = state_110313;
(statearr_110334[(11)] = inst_110256);

(statearr_110334[(9)] = inst_110257__$1);

return statearr_110334;
})();
var statearr_110335_110372 = state_110313__$1;
(statearr_110335_110372[(2)] = null);

(statearr_110335_110372[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110314 === (19))){
var inst_110274 = (state_110313[(10)]);
var inst_110286 = (state_110313[(2)]);
var inst_110256 = inst_110274;
var inst_110257 = inst_110286;
var state_110313__$1 = (function (){var statearr_110336 = state_110313;
(statearr_110336[(11)] = inst_110256);

(statearr_110336[(9)] = inst_110257);

return statearr_110336;
})();
var statearr_110337_110373 = state_110313__$1;
(statearr_110337_110373[(2)] = null);

(statearr_110337_110373[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110314 === (11))){
var inst_110273 = (state_110313[(14)]);
var inst_110274 = (state_110313[(10)]);
var inst_110256 = inst_110274;
var inst_110257 = inst_110273;
var state_110313__$1 = (function (){var statearr_110338 = state_110313;
(statearr_110338[(11)] = inst_110256);

(statearr_110338[(9)] = inst_110257);

return statearr_110338;
})();
var statearr_110339_110374 = state_110313__$1;
(statearr_110339_110374[(2)] = null);

(statearr_110339_110374[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110314 === (9))){
var inst_110307 = (state_110313[(2)]);
var state_110313__$1 = state_110313;
var statearr_110340_110375 = state_110313__$1;
(statearr_110340_110375[(2)] = inst_110307);

(statearr_110340_110375[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110314 === (5))){
var inst_110256 = (state_110313[(11)]);
var inst_110263 = (state_110313[(7)]);
var inst_110262 = cljs.core.seq.call(null,inst_110256);
var inst_110263__$1 = cljs.core.first.call(null,inst_110262);
var inst_110264 = cljs.core.next.call(null,inst_110262);
var state_110313__$1 = (function (){var statearr_110341 = state_110313;
(statearr_110341[(7)] = inst_110263__$1);

(statearr_110341[(8)] = inst_110264);

return statearr_110341;
})();
if(cljs.core.truth_(inst_110263__$1)){
var statearr_110342_110376 = state_110313__$1;
(statearr_110342_110376[(1)] = (7));

} else {
var statearr_110343_110377 = state_110313__$1;
(statearr_110343_110377[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110314 === (14))){
var inst_110273 = (state_110313[(14)]);
var state_110313__$1 = state_110313;
if(cljs.core.truth_(inst_110273)){
var statearr_110344_110378 = state_110313__$1;
(statearr_110344_110378[(1)] = (17));

} else {
var statearr_110345_110379 = state_110313__$1;
(statearr_110345_110379[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110314 === (16))){
var inst_110302 = (state_110313[(2)]);
var state_110313__$1 = state_110313;
var statearr_110346_110380 = state_110313__$1;
(statearr_110346_110380[(2)] = inst_110302);

(statearr_110346_110380[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110314 === (10))){
var inst_110263 = (state_110313[(7)]);
var inst_110271 = (state_110313[(2)]);
var inst_110272 = fluree.db.util.async.throw_err.call(null,inst_110271);
var inst_110273 = cljs.core.nth.call(null,inst_110272,(0),null);
var inst_110274 = cljs.core.nth.call(null,inst_110272,(1),null);
var inst_110275 = cljs.core.count.call(null,inst_110263);
var inst_110276 = cljs.core._EQ_.call(null,(2),inst_110275);
var state_110313__$1 = (function (){var statearr_110347 = state_110313;
(statearr_110347[(14)] = inst_110273);

(statearr_110347[(10)] = inst_110274);

return statearr_110347;
})();
if(inst_110276){
var statearr_110348_110381 = state_110313__$1;
(statearr_110348_110381[(1)] = (11));

} else {
var statearr_110349_110382 = state_110313__$1;
(statearr_110349_110382[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110314 === (18))){
var inst_110257 = (state_110313[(9)]);
var state_110313__$1 = state_110313;
var statearr_110350_110383 = state_110313__$1;
(statearr_110350_110383[(2)] = inst_110257);

(statearr_110350_110383[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110314 === (8))){
var inst_110257 = (state_110313[(9)]);
var state_110313__$1 = state_110313;
var statearr_110351_110384 = state_110313__$1;
(statearr_110351_110384[(2)] = inst_110257);

(statearr_110351_110384[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__99975__auto__ = null;
var fluree$db$query$analytical$state_machine__99975__auto____0 = (function (){
var statearr_110352 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_110352[(0)] = fluree$db$query$analytical$state_machine__99975__auto__);

(statearr_110352[(1)] = (1));

return statearr_110352;
});
var fluree$db$query$analytical$state_machine__99975__auto____1 = (function (state_110313){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_110313);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e110353){if((e110353 instanceof Object)){
var ex__99978__auto__ = e110353;
var statearr_110354_110385 = state_110313;
(statearr_110354_110385[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_110313);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e110353;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__110386 = state_110313;
state_110313 = G__110386;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__99975__auto__ = function(state_110313){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__99975__auto____1.call(this,state_110313);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__99975__auto____0;
fluree$db$query$analytical$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__99975__auto____1;
return fluree$db$query$analytical$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_110355 = f__100070__auto__.call(null);
(statearr_110355[(6)] = c__100069__auto__);

return statearr_110355;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$lang$maxFixedArity = 7);

fluree.db.query.analytical.q = (function fluree$db$query$analytical$q(q_map,fuel,max_fuel,db,opts){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_110443){
var state_val_110444 = (state_110443[(1)]);
if((state_val_110444 === (7))){
var inst_110407 = (state_110443[(2)]);
var state_110443__$1 = state_110443;
if(cljs.core.truth_(inst_110407)){
var statearr_110445_110477 = state_110443__$1;
(statearr_110445_110477[(1)] = (11));

} else {
var statearr_110446_110478 = state_110443__$1;
(statearr_110446_110478[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110444 === (20))){
var inst_110431 = (state_110443[(7)]);
var state_110443__$1 = state_110443;
var statearr_110447_110479 = state_110443__$1;
(statearr_110447_110479[(2)] = inst_110431);

(statearr_110447_110479[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110444 === (1))){
var state_110443__$1 = state_110443;
var statearr_110448_110480 = state_110443__$1;
(statearr_110448_110480[(2)] = null);

(statearr_110448_110480[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110444 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_110443,(3),Error,null,(2));
var inst_110393 = (q_map == null);
var inst_110394 = cljs.core.not.call(null,inst_110393);
var state_110443__$1 = state_110443;
if(inst_110394){
var statearr_110449_110481 = state_110443__$1;
(statearr_110449_110481[(1)] = (5));

} else {
var statearr_110450_110482 = state_110443__$1;
(statearr_110450_110482[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110444 === (15))){
var inst_110420 = (state_110443[(8)]);
var inst_110415 = (state_110443[(9)]);
var inst_110422 = cljs.core.pr_str.call(null,q_map);
var inst_110423 = ["The query key: optional should be included in the 'where' array. The top-level 'optional' is being deprecated. Provided: ",inst_110422].join('');
var inst_110424 = fluree.db.util.log.warn.call(null,inst_110423);
var inst_110425 = fluree.db.query.analytical.optional__GT_left_outer_joins.call(null,db,q_map,inst_110415,inst_110420,fuel,max_fuel,opts);
var state_110443__$1 = (function (){var statearr_110451 = state_110443;
(statearr_110451[(10)] = inst_110424);

return statearr_110451;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_110443__$1,(18),inst_110425);
} else {
if((state_val_110444 === (21))){
var inst_110439 = (state_110443[(2)]);
var state_110443__$1 = state_110443;
var statearr_110452_110483 = state_110443__$1;
(statearr_110452_110483[(2)] = inst_110439);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_110443__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110444 === (13))){
var inst_110412 = (state_110443[(2)]);
var inst_110413 = cljs.core.get.call(null,inst_110412,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_110414 = cljs.core.get.call(null,inst_110412,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_110415 = cljs.core.get.call(null,inst_110412,new cljs.core.Keyword(null,"optional","optional",2053951509));
var inst_110416 = cljs.core.get.call(null,inst_110412,new cljs.core.Keyword(null,"filter","filter",-948537934));
var inst_110417 = fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_110414,q_map,inst_110413,fuel,max_fuel,opts);
var state_110443__$1 = (function (){var statearr_110453 = state_110443;
(statearr_110453[(11)] = inst_110416);

(statearr_110453[(9)] = inst_110415);

return statearr_110453;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_110443__$1,(14),inst_110417);
} else {
if((state_val_110444 === (6))){
var state_110443__$1 = state_110443;
var statearr_110454_110484 = state_110443__$1;
(statearr_110454_110484[(2)] = false);

(statearr_110454_110484[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110444 === (17))){
var inst_110416 = (state_110443[(11)]);
var inst_110431 = (state_110443[(2)]);
var state_110443__$1 = (function (){var statearr_110455 = state_110443;
(statearr_110455[(7)] = inst_110431);

return statearr_110455;
})();
if(cljs.core.truth_(inst_110416)){
var statearr_110456_110485 = state_110443__$1;
(statearr_110456_110485[(1)] = (19));

} else {
var statearr_110457_110486 = state_110443__$1;
(statearr_110457_110486[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110444 === (3))){
var inst_110387 = (state_110443[(2)]);
var state_110443__$1 = state_110443;
var statearr_110458_110487 = state_110443__$1;
(statearr_110458_110487[(2)] = inst_110387);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_110443__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110444 === (12))){
var state_110443__$1 = state_110443;
var statearr_110459_110488 = state_110443__$1;
(statearr_110459_110488[(2)] = q_map);

(statearr_110459_110488[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110444 === (2))){
var inst_110441 = (state_110443[(2)]);
var state_110443__$1 = state_110443;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_110443__$1,inst_110441);
} else {
if((state_val_110444 === (19))){
var inst_110431 = (state_110443[(7)]);
var inst_110416 = (state_110443[(11)]);
var inst_110433 = cljs.core.pr_str.call(null,q_map);
var inst_110434 = ["The query key: filter should be included in the 'where' array. The top-level 'filter' is being deprecated. Provided: ",inst_110433].join('');
var inst_110435 = fluree.db.util.log.warn.call(null,inst_110434);
var inst_110436 = fluree.db.query.analytical.tuples__GT_filtered.call(null,inst_110431,inst_110416,null);
var state_110443__$1 = (function (){var statearr_110460 = state_110443;
(statearr_110460[(12)] = inst_110435);

return statearr_110460;
})();
var statearr_110461_110489 = state_110443__$1;
(statearr_110461_110489[(2)] = inst_110436);

(statearr_110461_110489[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110444 === (11))){
var inst_110409 = cljs.core.apply.call(null,cljs.core.hash_map,q_map);
var state_110443__$1 = state_110443;
var statearr_110462_110490 = state_110443__$1;
(statearr_110462_110490[(2)] = inst_110409);

(statearr_110462_110490[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110444 === (9))){
var state_110443__$1 = state_110443;
var statearr_110463_110491 = state_110443__$1;
(statearr_110463_110491[(2)] = false);

(statearr_110463_110491[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110444 === (5))){
var inst_110396 = q_map.cljs$lang$protocol_mask$partition0$;
var inst_110397 = (inst_110396 & (64));
var inst_110398 = q_map.cljs$core$ISeq$;
var inst_110399 = (cljs.core.PROTOCOL_SENTINEL === inst_110398);
var inst_110400 = ((inst_110397) || (inst_110399));
var state_110443__$1 = state_110443;
if(cljs.core.truth_(inst_110400)){
var statearr_110464_110492 = state_110443__$1;
(statearr_110464_110492[(1)] = (8));

} else {
var statearr_110465_110493 = state_110443__$1;
(statearr_110465_110493[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110444 === (14))){
var inst_110415 = (state_110443[(9)]);
var inst_110419 = (state_110443[(2)]);
var inst_110420 = fluree.db.util.async.throw_err.call(null,inst_110419);
var state_110443__$1 = (function (){var statearr_110466 = state_110443;
(statearr_110466[(8)] = inst_110420);

return statearr_110466;
})();
if(cljs.core.truth_(inst_110415)){
var statearr_110467_110494 = state_110443__$1;
(statearr_110467_110494[(1)] = (15));

} else {
var statearr_110468_110495 = state_110443__$1;
(statearr_110468_110495[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110444 === (16))){
var inst_110420 = (state_110443[(8)]);
var state_110443__$1 = state_110443;
var statearr_110469_110496 = state_110443__$1;
(statearr_110469_110496[(2)] = inst_110420);

(statearr_110469_110496[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110444 === (10))){
var inst_110404 = (state_110443[(2)]);
var state_110443__$1 = state_110443;
var statearr_110470_110497 = state_110443__$1;
(statearr_110470_110497[(2)] = inst_110404);

(statearr_110470_110497[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110444 === (18))){
var inst_110427 = (state_110443[(2)]);
var inst_110428 = fluree.db.util.async.throw_err.call(null,inst_110427);
var state_110443__$1 = state_110443;
var statearr_110471_110498 = state_110443__$1;
(statearr_110471_110498[(2)] = inst_110428);

(statearr_110471_110498[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110444 === (8))){
var state_110443__$1 = state_110443;
var statearr_110472_110499 = state_110443__$1;
(statearr_110472_110499[(2)] = true);

(statearr_110472_110499[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$q_$_state_machine__99975__auto__ = null;
var fluree$db$query$analytical$q_$_state_machine__99975__auto____0 = (function (){
var statearr_110473 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_110473[(0)] = fluree$db$query$analytical$q_$_state_machine__99975__auto__);

(statearr_110473[(1)] = (1));

return statearr_110473;
});
var fluree$db$query$analytical$q_$_state_machine__99975__auto____1 = (function (state_110443){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_110443);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e110474){if((e110474 instanceof Object)){
var ex__99978__auto__ = e110474;
var statearr_110475_110500 = state_110443;
(statearr_110475_110500[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_110443);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e110474;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__110501 = state_110443;
state_110443 = G__110501;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$analytical$q_$_state_machine__99975__auto__ = function(state_110443){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$q_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$analytical$q_$_state_machine__99975__auto____1.call(this,state_110443);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$q_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$q_$_state_machine__99975__auto____0;
fluree$db$query$analytical$q_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$q_$_state_machine__99975__auto____1;
return fluree$db$query$analytical$q_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_110476 = f__100070__auto__.call(null);
(statearr_110476[(6)] = c__100069__auto__);

return statearr_110476;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
