// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.operations');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
/**
 * Returns true if connection has been closed.
 */
fluree.db.operations.conn_closed_QMARK_ = (function fluree$db$operations$conn_closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Creates the operation header.
 */
fluree.db.operations.formulate_op_header = (function fluree$db$operations$formulate_op_header(var_args){
var G__107216 = arguments.length;
switch (G__107216) {
case 2:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2 = (function (operation,db){
return fluree.db.operations.formulate_op_header.call(null,operation,db,(60000));
}));

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3 = (function (operation,db,timeout){
var req_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid.call(null));
var header = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"op","op",-1882987955),operation,new cljs.core.Keyword(null,"req-id","req-id",-471642231),req_id,new cljs.core.Keyword(null,"timestamp","timestamp",579478971),fluree.db.util.core.current_time_millis.call(null),new cljs.core.Keyword(null,"timeout","timeout",-318625318),timeout], null);
return header;
}));

(fluree.db.operations.formulate_op_header.cljs$lang$maxFixedArity = 3);

/**
 * Sends operation off, returns core async promise channel that will have eventual response
 *   or timeout response.
 * 
 *   Records the request-id which is stored in an atom along with the response channel.
 * 
 *   Incoming ledger notifications will look at request id and see if
 *   there is a matching request-id in the record with its corresponding
 *   async channel, and if so it will populate that channel with the response.
 * 
 *   We use the timeout to create a timeout channel, so if no transactions with
 *   the corresponding request id are 'seen' in that timeframe, a timeout response
 *   is given.
 */
fluree.db.operations.send_operation = (function fluree$db$operations$send_operation(var_args){
var G__107219 = arguments.length;
switch (G__107219) {
case 3:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3 = (function (conn,operation,data){
return fluree.db.operations.send_operation.call(null,conn,operation,data,null);
}));

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4 = (function (conn,operation,data,opts){
var pc = cljs.core.async.promise_chan.call(null);
var c__100069__auto___107262 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_107247){
var state_val_107248 = (state_107247[(1)]);
if((state_val_107248 === (1))){
var state_107247__$1 = state_107247;
var statearr_107249_107263 = state_107247__$1;
(statearr_107249_107263[(2)] = null);

(statearr_107249_107263[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107248 === (2))){
var inst_107245 = (state_107247[(2)]);
var state_107247__$1 = state_107247;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_107247__$1,inst_107245);
} else {
if((state_val_107248 === (3))){
var inst_107220 = (state_107247[(2)]);
var inst_107221 = cljs.core.async.put_BANG_.call(null,pc,inst_107220);
var state_107247__$1 = state_107247;
var statearr_107250_107264 = state_107247__$1;
(statearr_107250_107264[(2)] = inst_107221);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_107247__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107248 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_107247,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var inst_107225 = fluree.db.operations.conn_closed_QMARK_.call(null,conn);
var state_107247__$1 = state_107247;
if(cljs.core.truth_(inst_107225)){
var statearr_107251_107265 = state_107247__$1;
(statearr_107251_107265[(1)] = (5));

} else {
var statearr_107252_107266 = state_107247__$1;
(statearr_107252_107266[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107248 === (5))){
var inst_107227 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_107228 = [(400),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)];
var inst_107229 = cljs.core.PersistentHashMap.fromArrays(inst_107227,inst_107228);
var inst_107230 = cljs.core.ex_info.call(null,"Connection was closed.",inst_107229);
var inst_107231 = (function(){throw inst_107230})();
var state_107247__$1 = state_107247;
var statearr_107253_107267 = state_107247__$1;
(statearr_107253_107267[(2)] = inst_107231);

(statearr_107253_107267[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107248 === (6))){
var inst_107233 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_107234 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_107235 = [operation,data,pc,opts];
var inst_107236 = (new cljs.core.PersistentVector(null,4,(5),inst_107234,inst_107235,null));
var inst_107237 = cljs.core.async.put_BANG_.call(null,inst_107233,inst_107236);
var inst_107238 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_107239 = [operation,data,pc,opts];
var inst_107240 = (new cljs.core.PersistentVector(null,4,(5),inst_107238,inst_107239,null));
var inst_107241 = fluree.db.util.log.trace.call(null,"Put operation on connection req-chan: ",inst_107240);
var state_107247__$1 = (function (){var statearr_107254 = state_107247;
(statearr_107254[(7)] = inst_107237);

return statearr_107254;
})();
var statearr_107255_107268 = state_107247__$1;
(statearr_107255_107268[(2)] = inst_107241);

(statearr_107255_107268[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107248 === (7))){
var inst_107243 = (state_107247[(2)]);
var state_107247__$1 = state_107247;
var statearr_107256_107269 = state_107247__$1;
(statearr_107256_107269[(2)] = inst_107243);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_107247__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$operations$state_machine__99975__auto__ = null;
var fluree$db$operations$state_machine__99975__auto____0 = (function (){
var statearr_107257 = [null,null,null,null,null,null,null,null];
(statearr_107257[(0)] = fluree$db$operations$state_machine__99975__auto__);

(statearr_107257[(1)] = (1));

return statearr_107257;
});
var fluree$db$operations$state_machine__99975__auto____1 = (function (state_107247){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_107247);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e107258){if((e107258 instanceof Object)){
var ex__99978__auto__ = e107258;
var statearr_107259_107270 = state_107247;
(statearr_107259_107270[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_107247);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e107258;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__107271 = state_107247;
state_107247 = G__107271;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$operations$state_machine__99975__auto__ = function(state_107247){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__99975__auto____1.call(this,state_107247);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__99975__auto____0;
fluree$db$operations$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__99975__auto____1;
return fluree$db$operations$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_107260 = f__100070__auto__.call(null);
(statearr_107260[(6)] = c__100069__auto___107262);

return statearr_107260;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));


return pc;
}));

(fluree.db.operations.send_operation.cljs$lang$maxFixedArity = 4);

/**
 * A quick async response to confirm as initiated, but deletion happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.delete_ledger_async = (function fluree$db$operations$delete_ledger_async(var_args){
var G__107273 = arguments.length;
switch (G__107273) {
case 1:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.delete_ledger_async.call(null,session,null);
}));

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2 = (function (session,p__107274){
var map__107275 = p__107274;
var map__107275__$1 = (((((!((map__107275 == null))))?(((((map__107275.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__107275.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__107275):map__107275);
var opts = map__107275__$1;
var snapshot_QMARK_ = cljs.core.get.call(null,map__107275__$1,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670));
var map__107277 = session;
var map__107277__$1 = (((((!((map__107277 == null))))?(((((map__107277.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__107277.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__107277):map__107277);
var dbid = cljs.core.get.call(null,map__107277__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var network = cljs.core.get.call(null,map__107277__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.call(null,map__107277__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"delete-db","delete-db",1646085839),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),dbid,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670),snapshot_QMARK_], null));
}));

(fluree.db.operations.delete_ledger_async.cljs$lang$maxFixedArity = 2);

/**
 * A quick async response to confirm as initiated, but garbage collection happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.garbage_collect_async = (function fluree$db$operations$garbage_collect_async(var_args){
var args__4742__auto__ = [];
var len__4736__auto___107336 = arguments.length;
var i__4737__auto___107337 = (0);
while(true){
if((i__4737__auto___107337 < len__4736__auto___107336)){
args__4742__auto__.push((arguments[i__4737__auto___107337]));

var G__107338 = (i__4737__auto___107337 + (1));
i__4737__auto___107337 = G__107338;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic = (function (session,p__107282){
var vec__107283 = p__107282;
var map__107286 = cljs.core.nth.call(null,vec__107283,(0),null);
var map__107286__$1 = (((((!((map__107286 == null))))?(((((map__107286.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__107286.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__107286):map__107286);
var toBlock = cljs.core.get.call(null,map__107286__$1,new cljs.core.Keyword(null,"toBlock","toBlock",1609458185));
var toTime = cljs.core.get.call(null,map__107286__$1,new cljs.core.Keyword(null,"toTime","toTime",903224641));
var opts = vec__107283;
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_107318){
var state_val_107319 = (state_107318[(1)]);
if((state_val_107319 === (7))){
var inst_107301 = (state_107318[(2)]);
var state_107318__$1 = state_107318;
var statearr_107320_107339 = state_107318__$1;
(statearr_107320_107339[(2)] = inst_107301);

(statearr_107320_107339[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107319 === (1))){
var inst_107290 = (session == null);
var inst_107291 = cljs.core.not.call(null,inst_107290);
var state_107318__$1 = state_107318;
if(inst_107291){
var statearr_107321_107340 = state_107318__$1;
(statearr_107321_107340[(1)] = (2));

} else {
var statearr_107322_107341 = state_107318__$1;
(statearr_107322_107341[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107319 === (4))){
var inst_107304 = (state_107318[(2)]);
var state_107318__$1 = state_107318;
if(cljs.core.truth_(inst_107304)){
var statearr_107323_107342 = state_107318__$1;
(statearr_107323_107342[(1)] = (8));

} else {
var statearr_107324_107343 = state_107318__$1;
(statearr_107324_107343[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107319 === (6))){
var state_107318__$1 = state_107318;
var statearr_107325_107344 = state_107318__$1;
(statearr_107325_107344[(2)] = false);

(statearr_107325_107344[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107319 === (3))){
var state_107318__$1 = state_107318;
var statearr_107326_107345 = state_107318__$1;
(statearr_107326_107345[(2)] = false);

(statearr_107326_107345[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107319 === (2))){
var inst_107293 = session.cljs$lang$protocol_mask$partition0$;
var inst_107294 = (inst_107293 & (64));
var inst_107295 = session.cljs$core$ISeq$;
var inst_107296 = (cljs.core.PROTOCOL_SENTINEL === inst_107295);
var inst_107297 = ((inst_107294) || (inst_107296));
var state_107318__$1 = state_107318;
if(cljs.core.truth_(inst_107297)){
var statearr_107327_107346 = state_107318__$1;
(statearr_107327_107346[(1)] = (5));

} else {
var statearr_107328_107347 = state_107318__$1;
(statearr_107328_107347[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107319 === (9))){
var state_107318__$1 = state_107318;
var statearr_107329_107348 = state_107318__$1;
(statearr_107329_107348[(2)] = session);

(statearr_107329_107348[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107319 === (5))){
var state_107318__$1 = state_107318;
var statearr_107330_107349 = state_107318__$1;
(statearr_107330_107349[(2)] = true);

(statearr_107330_107349[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107319 === (10))){
var inst_107309 = (state_107318[(2)]);
var inst_107310 = cljs.core.get.call(null,inst_107309,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_107311 = cljs.core.get.call(null,inst_107309,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_107312 = cljs.core.get.call(null,inst_107309,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_107313 = [new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"toBlock","toBlock",1609458185),new cljs.core.Keyword(null,"toTime","toTime",903224641)];
var inst_107314 = [inst_107310,inst_107311,toBlock,toTime];
var inst_107315 = cljs.core.PersistentHashMap.fromArrays(inst_107313,inst_107314);
var inst_107316 = fluree.db.operations.send_operation.call(null,inst_107312,new cljs.core.Keyword(null,"garbage","garbage",-2063107600),inst_107315);
var state_107318__$1 = state_107318;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_107318__$1,inst_107316);
} else {
if((state_val_107319 === (8))){
var inst_107306 = cljs.core.apply.call(null,cljs.core.hash_map,session);
var state_107318__$1 = state_107318;
var statearr_107331_107350 = state_107318__$1;
(statearr_107331_107350[(2)] = inst_107306);

(statearr_107331_107350[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$operations$state_machine__99975__auto__ = null;
var fluree$db$operations$state_machine__99975__auto____0 = (function (){
var statearr_107332 = [null,null,null,null,null,null,null];
(statearr_107332[(0)] = fluree$db$operations$state_machine__99975__auto__);

(statearr_107332[(1)] = (1));

return statearr_107332;
});
var fluree$db$operations$state_machine__99975__auto____1 = (function (state_107318){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_107318);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e107333){if((e107333 instanceof Object)){
var ex__99978__auto__ = e107333;
var statearr_107334_107351 = state_107318;
(statearr_107334_107351[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_107318);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e107333;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__107352 = state_107318;
state_107318 = G__107352;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$operations$state_machine__99975__auto__ = function(state_107318){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__99975__auto____1.call(this,state_107318);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__99975__auto____0;
fluree$db$operations$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__99975__auto____1;
return fluree$db$operations$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_107335 = f__100070__auto__.call(null);
(statearr_107335[(6)] = c__100069__auto__);

return statearr_107335;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.operations.garbage_collect_async.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.operations.garbage_collect_async.cljs$lang$applyTo = (function (seq107280){
var G__107281 = cljs.core.first.call(null,seq107280);
var seq107280__$1 = cljs.core.next.call(null,seq107280);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__107281,seq107280__$1);
}));

/**
 * A quick async response to confirm, but archival happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.snapshot_ledger_async = (function fluree$db$operations$snapshot_ledger_async(session,opts){
var map__107353 = session;
var map__107353__$1 = (((((!((map__107353 == null))))?(((((map__107353.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__107353.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__107353):map__107353);
var network = cljs.core.get.call(null,map__107353__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__107353__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var conn = cljs.core.get.call(null,map__107353__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"snapshot-db","snapshot-db",199417128),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Submits a command to connected tx-group server
 */
fluree.db.operations.command_async = (function fluree$db$operations$command_async(conn,cmd){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.unsigned_command_async = (function fluree$db$operations$unsigned_command_async(conn,unsigned_cmd_map){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"unsigned-cmd","unsigned-cmd",1466012010),unsigned_cmd_map);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_info_async = (function fluree$db$operations$ledger_info_async(conn,ledger){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_status_async = (function fluree$db$operations$ledger_status_async(conn,ledger){
return new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger));
});
/**
 * Returns stats about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_stats_async = (function fluree$db$operations$ledger_stats_async(conn,ledger){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-stats","ledger-stats",765646297),ledger);
});
/**
 * Returns a list of ledgers in two-tuples of [network ledger-id].
 */
fluree.db.operations.ledgers_async = (function fluree$db$operations$ledgers_async(conn){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"db-list","db-list",230589843),null);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.transact_async = (function fluree$db$operations$transact_async(conn,tx_map){
fluree.db.util.log.trace.call(null,"Sending transaction async: ",tx_map);

return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"tx","tx",466630418),tx_map);
});
/**
 * Starts a subscription to the session's ledger.
 * 
 *   Supported options:
 *   - auth    - auth, if specified, takes precedence
 *   - jwt     - valid jwt
 *   
 */
fluree.db.operations.subscribe = (function fluree$db$operations$subscribe(var_args){
var G__107356 = arguments.length;
switch (G__107356) {
case 1:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.subscribe.call(null,session,null);
}));

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2 = (function (session,opts){
var map__107357 = opts;
var map__107357__$1 = (((((!((map__107357 == null))))?(((((map__107357.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__107357.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__107357):map__107357);
var auth = cljs.core.get.call(null,map__107357__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.call(null,map__107357__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var auth_or_jwt = (function (){var or__4126__auto__ = auth;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return jwt;
}
})();
var _ = fluree.db.util.log.trace.call(null,"Subscribe to: ",new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session),auth_or_jwt);
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"subscribe","subscribe",416253756),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session)], null),auth_or_jwt], null));
}));

(fluree.db.operations.subscribe.cljs$lang$maxFixedArity = 2);

/**
 * Unsubscribes from the session's ledger.
 */
fluree.db.operations.unsubscribe = (function fluree$db$operations$unsubscribe(session){
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"unsbuscribe","unsbuscribe",888593047),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session)], null));
});
