// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.tools.reader.edn');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.tools.reader.edn.read_string.call(null,param_str):param_str);
if(cljs.core.map_QMARK_.call(null,parsed_param)){
var key = cljs.core.first.call(null,cljs.core.keys.call(null,parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace.call(null,key) == null))?cljs.core.name.call(null,key):[cljs.core.namespace.call(null,key),"/",cljs.core.name.call(null,key)].join('')));
var value = cljs.core.first.call(null,cljs.core.vals.call(null,parsed_param));
var value_SINGLEQUOTE_ = fluree.db.dbfunctions.internal.parse_select_map.call(null,value);
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_.call(null,value_SINGLEQUOTE_))?cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.call(null,cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_.call(null,parsed_param)))){
if((cljs.core.namespace.call(null,parsed_param) == null)){
return cljs.core.name.call(null,parsed_param);
} else {
return [cljs.core.namespace.call(null,parsed_param),"/",cljs.core.name.call(null,parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_.call(null,parsed_param)){
return cljs.core.mapv.call(null,fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.call(null,["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__4742__auto__ = [];
var len__4736__auto___127193 = arguments.length;
var i__4737__auto___127194 = (0);
while(true){
if((i__4737__auto___127194 < len__4736__auto___127193)){
args__4742__auto__.push((arguments[i__4737__auto___127194]));

var G__127195 = (i__4737__auto___127194 + (1));
i__4737__auto___127194 = G__127195;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
fluree.db.util.log.error.call(null,e,"Function Error: ",function_name,"args: ",cljs.core.pr_str.call(null,args));

throw cljs.core.ex_info.call(null,["Error in database function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((((e.getMessage() == null))?e.getClass():e.getMessage())),". Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(((cljs.core.coll_QMARK_.call(null,args))?clojure.string.join.call(null," ",args):args))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
}));

(fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq127190){
var G__127191 = cljs.core.first.call(null,seq127190);
var seq127190__$1 = cljs.core.next.call(null,seq127190);
var G__127192 = cljs.core.first.call(null,seq127190__$1);
var seq127190__$2 = cljs.core.next.call(null,seq127190__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__127191,G__127192,seq127190__$2);
}));

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$.call(null,x);
}catch (e127196){var e = e127196;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"boolean",x);
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e127197){var e = e127197;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"nil?",arg);
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not.call(null,arg);
}catch (e127198){var e = e127198;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"not",arg);
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_.call(null,arg)) || (cljs.core._EQ_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e127199){var e = e127199;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"empty?",arg);
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e127200){var e = e127200;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"if-else",test,true_res,false_res);
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__4742__auto__ = [];
var len__4736__auto___127203 = arguments.length;
var i__4737__auto___127204 = (0);
while(true){
if((i__4737__auto___127204 < len__4736__auto___127203)){
args__4742__auto__.push((arguments[i__4737__auto___127204]));

var G__127205 = (i__4737__auto___127204 + (1));
i__4737__auto___127204 = G__127205;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.call(null,fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$.call(null,cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,coerced_coll));
}
}catch (e127202){var e = e127202;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"and",args);
}}));

(fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq127201){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq127201));
}));

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__4742__auto__ = [];
var len__4736__auto___127208 = arguments.length;
var i__4737__auto___127209 = (0);
while(true){
if((i__4737__auto___127209 < len__4736__auto___127208)){
args__4742__auto__.push((arguments[i__4737__auto___127209]));

var G__127210 = (i__4737__auto___127209 + (1));
i__4737__auto___127209 = G__127210;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.call(null,fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$.call(null,cljs.core.some.call(null,cljs.core.true_QMARK_,coerced_coll));
}
}catch (e127207){var e = e127207;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"or",args);
}}));

(fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq127206){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq127206));
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count.call(null,coll);
}catch (e127211){var e = e127211;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"count",coll);
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__4742__auto__ = [];
var len__4736__auto___127214 = arguments.length;
var i__4737__auto___127215 = (0);
while(true){
if((i__4737__auto___127215 < len__4736__auto___127214)){
args__4742__auto__.push((arguments[i__4737__auto___127215]));

var G__127216 = (i__4737__auto___127215 + (1));
i__4737__auto___127215 = G__127216;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.str,args);
}catch (e127213){var e = e127213;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"str",args);
}}));

(fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq127212){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq127212));
}));

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case.call(null,str);
}catch (e127217){var e = e127217;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"lower-case",str);
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case.call(null,str);
}catch (e127218){var e = e127218;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"upper-case",str);
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__4742__auto__ = [];
var len__4736__auto___127221 = arguments.length;
var i__4737__auto___127222 = (0);
while(true){
if((i__4737__auto___127222 < len__4736__auto___127221)){
args__4742__auto__.push((arguments[i__4737__auto___127222]));

var G__127223 = (i__4737__auto___127222 + (1));
i__4737__auto___127222 = G__127223;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.max,cljs.core.remove.call(null,fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e127220){var e = e127220;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"max",args);
}}));

(fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq127219){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq127219));
}));

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__4742__auto__ = [];
var len__4736__auto___127226 = arguments.length;
var i__4737__auto___127227 = (0);
while(true){
if((i__4737__auto___127227 < len__4736__auto___127226)){
args__4742__auto__.push((arguments[i__4737__auto___127227]));

var G__127228 = (i__4737__auto___127227 + (1));
i__4737__auto___127227 = G__127228;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.min,cljs.core.remove.call(null,fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e127225){var e = e127225;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"min",args);
}}));

(fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq127224){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq127224));
}));

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___127231 = arguments.length;
var i__4737__auto___127232 = (0);
while(true){
if((i__4737__auto___127232 < len__4736__auto___127231)){
args__4742__auto__.push((arguments[i__4737__auto___127232]));

var G__127233 = (i__4737__auto___127232 + (1));
i__4737__auto___127232 = G__127233;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._GT_,args);
}catch (e127230){var e = e127230;
return fluree.db.dbfunctions.internal.function_error.call(null,e,">",args);
}}));

(fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq127229){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq127229));
}));

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___127236 = arguments.length;
var i__4737__auto___127237 = (0);
while(true){
if((i__4737__auto___127237 < len__4736__auto___127236)){
args__4742__auto__.push((arguments[i__4737__auto___127237]));

var G__127238 = (i__4737__auto___127237 + (1));
i__4737__auto___127237 = G__127238;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._GT__EQ_,args);
}catch (e127235){var e = e127235;
return fluree.db.dbfunctions.internal.function_error.call(null,e,">=",args);
}}));

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq127234){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq127234));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___127241 = arguments.length;
var i__4737__auto___127242 = (0);
while(true){
if((i__4737__auto___127242 < len__4736__auto___127241)){
args__4742__auto__.push((arguments[i__4737__auto___127242]));

var G__127243 = (i__4737__auto___127242 + (1));
i__4737__auto___127242 = G__127243;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._LT_,args);
}catch (e127240){var e = e127240;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"<",args);
}}));

(fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq127239){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq127239));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___127246 = arguments.length;
var i__4737__auto___127247 = (0);
while(true){
if((i__4737__auto___127247 < len__4736__auto___127246)){
args__4742__auto__.push((arguments[i__4737__auto___127247]));

var G__127248 = (i__4737__auto___127247 + (1));
i__4737__auto___127247 = G__127248;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._LT__EQ_,args);
}catch (e127245){var e = e127245;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"<=",args);
}}));

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq127244){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq127244));
}));

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__127250 = arguments.length;
switch (G__127250) {
case 3:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$3 = (function (db,query_map,opts){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_127273){
var state_val_127274 = (state_127273[(1)]);
if((state_val_127274 === (1))){
var state_127273__$1 = state_127273;
var statearr_127275_127354 = state_127273__$1;
(statearr_127275_127354[(2)] = null);

(statearr_127275_127354[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127274 === (2))){
var inst_127271 = (state_127273[(2)]);
var state_127273__$1 = state_127273;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_127273__$1,inst_127271);
} else {
if((state_val_127274 === (3))){
var inst_127251 = (state_127273[(2)]);
var state_127273__$1 = state_127273;
var statearr_127276_127355 = state_127273__$1;
(statearr_127276_127355[(2)] = inst_127251);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_127273__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127274 === (4))){
var inst_127255 = (state_127273[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_127273,(3),Error,null,(2));
var inst_127255__$1 = cljs.core.volatile_BANG_.call(null,(0));
var inst_127256 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_127255__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),(100000));
var inst_127257 = fluree.db.query.fql.query.call(null,db,query_map,inst_127256);
var state_127273__$1 = (function (){var statearr_127277 = state_127273;
(statearr_127277[(7)] = inst_127255__$1);

return statearr_127277;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_127273__$1,(5),inst_127257);
} else {
if((state_val_127274 === (5))){
var inst_127259 = (state_127273[(8)]);
var inst_127259__$1 = (state_127273[(2)]);
var inst_127260 = fluree.db.util.core.exception_QMARK_.call(null,inst_127259__$1);
var state_127273__$1 = (function (){var statearr_127278 = state_127273;
(statearr_127278[(8)] = inst_127259__$1);

return statearr_127278;
})();
if(inst_127260){
var statearr_127279_127356 = state_127273__$1;
(statearr_127279_127356[(1)] = (6));

} else {
var statearr_127280_127357 = state_127273__$1;
(statearr_127280_127357[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127274 === (6))){
var inst_127259 = (state_127273[(8)]);
var inst_127262 = fluree.db.dbfunctions.internal.function_error.call(null,inst_127259,"query",query_map);
var state_127273__$1 = state_127273;
var statearr_127281_127358 = state_127273__$1;
(statearr_127281_127358[(2)] = inst_127262);

(statearr_127281_127358[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127274 === (7))){
var inst_127255 = (state_127273[(7)]);
var inst_127259 = (state_127273[(8)]);
var inst_127264 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_127265 = cljs.core.deref.call(null,inst_127255);
var inst_127266 = [inst_127259,inst_127265];
var inst_127267 = (new cljs.core.PersistentVector(null,2,(5),inst_127264,inst_127266,null));
var state_127273__$1 = state_127273;
var statearr_127282_127359 = state_127273__$1;
(statearr_127282_127359[(2)] = inst_127267);

(statearr_127282_127359[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127274 === (8))){
var inst_127269 = (state_127273[(2)]);
var state_127273__$1 = state_127273;
var statearr_127283_127360 = state_127273__$1;
(statearr_127283_127360[(2)] = inst_127269);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_127273__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__99975__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__99975__auto____0 = (function (){
var statearr_127284 = [null,null,null,null,null,null,null,null,null];
(statearr_127284[(0)] = fluree$db$dbfunctions$internal$state_machine__99975__auto__);

(statearr_127284[(1)] = (1));

return statearr_127284;
});
var fluree$db$dbfunctions$internal$state_machine__99975__auto____1 = (function (state_127273){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_127273);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e127285){if((e127285 instanceof Object)){
var ex__99978__auto__ = e127285;
var statearr_127286_127361 = state_127273;
(statearr_127286_127361[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_127273);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e127285;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__127362 = state_127273;
state_127273 = G__127362;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__99975__auto__ = function(state_127273){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__99975__auto____1.call(this,state_127273);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__99975__auto____0;
fluree$db$dbfunctions$internal$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__99975__auto____1;
return fluree$db$dbfunctions$internal$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_127287 = f__100070__auto__.call(null);
(statearr_127287[(6)] = c__100069__auto__);

return statearr_127287;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_127332){
var state_val_127333 = (state_127332[(1)]);
if((state_val_127333 === (7))){
var inst_127315 = (state_127332[(7)]);
var inst_127314 = (state_127332[(2)]);
var inst_127315__$1 = cljs.core.volatile_BANG_.call(null,(0));
var inst_127316 = [new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012)];
var inst_127317 = [inst_127315__$1,(100000)];
var inst_127318 = cljs.core.PersistentHashMap.fromArrays(inst_127316,inst_127317);
var inst_127319 = fluree.db.query.fql.query.call(null,db,inst_127314,inst_127318);
var state_127332__$1 = (function (){var statearr_127334 = state_127332;
(statearr_127334[(7)] = inst_127315__$1);

return statearr_127334;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_127332__$1,(8),inst_127319);
} else {
if((state_val_127333 === (1))){
var inst_127288 = typeof select === 'string';
var state_127332__$1 = state_127332;
if(cljs.core.truth_(inst_127288)){
var statearr_127335_127363 = state_127332__$1;
(statearr_127335_127363[(1)] = (2));

} else {
var statearr_127336_127364 = state_127332__$1;
(statearr_127336_127364[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127333 === (4))){
var inst_127297 = (state_127332[(8)]);
var inst_127293 = (state_127332[(2)]);
var inst_127294 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_127295 = [inst_127293,from,where,block,limit];
var inst_127296 = cljs.core.PersistentHashMap.fromArrays(inst_127294,inst_127295);
var inst_127297__$1 = fluree.db.util.core.without_nils.call(null,inst_127296);
var inst_127298 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_127297__$1);
var inst_127299 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_127297__$1);
var inst_127300 = cljs.core.first.call(null,inst_127299);
var inst_127301 = fluree.db.dbfunctions.internal.str.call(null,inst_127300);
var inst_127302 = cljs.core._EQ_.call(null,"[",inst_127301);
var inst_127303 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_127297__$1);
var inst_127304 = cljs.core.last.call(null,inst_127303);
var inst_127305 = fluree.db.dbfunctions.internal.str.call(null,inst_127304);
var inst_127306 = cljs.core._EQ_.call(null,"]",inst_127305);
var inst_127307 = fluree.db.dbfunctions.internal.and.call(null,inst_127298,inst_127302,inst_127306);
var state_127332__$1 = (function (){var statearr_127337 = state_127332;
(statearr_127337[(8)] = inst_127297__$1);

return statearr_127337;
})();
if(cljs.core.truth_(inst_127307)){
var statearr_127338_127365 = state_127332__$1;
(statearr_127338_127365[(1)] = (5));

} else {
var statearr_127339_127366 = state_127332__$1;
(statearr_127339_127366[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127333 === (6))){
var inst_127297 = (state_127332[(8)]);
var state_127332__$1 = state_127332;
var statearr_127340_127367 = state_127332__$1;
(statearr_127340_127367[(2)] = inst_127297);

(statearr_127340_127367[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127333 === (3))){
var state_127332__$1 = state_127332;
var statearr_127341_127368 = state_127332__$1;
(statearr_127341_127368[(2)] = select);

(statearr_127341_127368[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127333 === (2))){
var inst_127290 = fluree.db.dbfunctions.internal.parse_select_map.call(null,select);
var state_127332__$1 = state_127332;
var statearr_127342_127369 = state_127332__$1;
(statearr_127342_127369[(2)] = inst_127290);

(statearr_127342_127369[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127333 === (11))){
var inst_127330 = (state_127332[(2)]);
var state_127332__$1 = state_127332;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_127332__$1,inst_127330);
} else {
if((state_val_127333 === (9))){
var inst_127321 = (state_127332[(9)]);
var state_127332__$1 = state_127332;
var statearr_127343_127370 = state_127332__$1;
(statearr_127343_127370[(2)] = inst_127321);

(statearr_127343_127370[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127333 === (5))){
var inst_127297 = (state_127332[(8)]);
var inst_127309 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_127297);
var inst_127310 = cljs.reader.read_string.call(null,inst_127309);
var inst_127311 = cljs.core.assoc.call(null,inst_127297,new cljs.core.Keyword(null,"where","where",-2044795965),inst_127310);
var state_127332__$1 = state_127332;
var statearr_127344_127371 = state_127332__$1;
(statearr_127344_127371[(2)] = inst_127311);

(statearr_127344_127371[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127333 === (10))){
var inst_127315 = (state_127332[(7)]);
var inst_127321 = (state_127332[(9)]);
var inst_127325 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_127326 = cljs.core.deref.call(null,inst_127315);
var inst_127327 = [inst_127321,inst_127326];
var inst_127328 = (new cljs.core.PersistentVector(null,2,(5),inst_127325,inst_127327,null));
var state_127332__$1 = state_127332;
var statearr_127345_127372 = state_127332__$1;
(statearr_127345_127372[(2)] = inst_127328);

(statearr_127345_127372[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127333 === (8))){
var inst_127321 = (state_127332[(9)]);
var inst_127321__$1 = (state_127332[(2)]);
var inst_127322 = fluree.db.util.core.exception_QMARK_.call(null,inst_127321__$1);
var state_127332__$1 = (function (){var statearr_127346 = state_127332;
(statearr_127346[(9)] = inst_127321__$1);

return statearr_127346;
})();
if(inst_127322){
var statearr_127347_127373 = state_127332__$1;
(statearr_127347_127373[(1)] = (9));

} else {
var statearr_127348_127374 = state_127332__$1;
(statearr_127348_127374[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__99975__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__99975__auto____0 = (function (){
var statearr_127349 = [null,null,null,null,null,null,null,null,null,null];
(statearr_127349[(0)] = fluree$db$dbfunctions$internal$state_machine__99975__auto__);

(statearr_127349[(1)] = (1));

return statearr_127349;
});
var fluree$db$dbfunctions$internal$state_machine__99975__auto____1 = (function (state_127332){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_127332);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e127350){if((e127350 instanceof Object)){
var ex__99978__auto__ = e127350;
var statearr_127351_127375 = state_127332;
(statearr_127351_127375[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_127332);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e127350;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__127376 = state_127332;
state_127332 = G__127376;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__99975__auto__ = function(state_127332){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__99975__auto____1.call(this,state_127332);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__99975__auto____0;
fluree$db$dbfunctions$internal$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__99975__auto____1;
return fluree$db$dbfunctions$internal$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_127352 = f__100070__auto__.call(null);
(statearr_127352[(6)] = c__100069__auto__);

return statearr_127352;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6);

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$.call(null,cljs.core.re_matches.call(null,fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.call(null,fluree.db.dbfunctions.internal.str.call(null,"Bad predicate name, should be string: ",cljs.core.pr_str.call(null,predicate_name)),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(var$){
var vec__127377 = clojure.string.split.call(null,var$,/\//);
var coll = cljs.core.nth.call(null,vec__127377,(0),null);
var pred = cljs.core.nth.call(null,vec__127377,(1),null);
var pred__$1 = cljs.core.subs.call(null,pred,(1));
return fluree.db.dbfunctions.internal.str.call(null,coll,"/",pred__$1);
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__127383 = path;
var vec__127384 = G__127383;
var seq__127385 = cljs.core.seq.call(null,vec__127384);
var first__127386 = cljs.core.first.call(null,seq__127385);
var seq__127385__$1 = cljs.core.next.call(null,seq__127385);
var var$ = first__127386;
var r = seq__127385__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__127383__$1 = G__127383;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__127390 = G__127383__$1;
var seq__127391 = cljs.core.seq.call(null,vec__127390);
var first__127392 = cljs.core.first.call(null,seq__127391);
var seq__127391__$1 = cljs.core.next.call(null,seq__127391);
var var$__$1 = first__127392;
var r__$1 = seq__127391__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.call(null,fluree.db.dbfunctions.internal.empty_QMARK_.call(null,where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_.call(null,r__$1)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path.call(null,endSubject,fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path.call(null,startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_.call(null,where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2),fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2)], null)], null));
var G__127393 = r__$1;
var G__127394 = n__$2;
var G__127395 = next_clauses;
G__127383__$1 = G__127393;
n__$1 = G__127394;
where_clauses__$1 = G__127395;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",next_n),fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2),var$__$1,fluree.db.dbfunctions.internal.str.call(null,"?var",next_n)], null));
var G__127396 = r__$1;
var G__127397 = next_n;
var G__127398 = cljs.core.conj.call(null,where_clauses__$2,next_clause);
G__127383__$1 = G__127396;
n__$1 = G__127397;
where_clauses__$1 = G__127398;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2),var$__$1,endSubject], null));
return cljs.core.conj.call(null,where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_127430){
var state_val_127431 = (state_127430[(1)]);
if((state_val_127431 === (7))){
var inst_127410 = (state_127430[(7)]);
var inst_127410__$1 = (state_127430[(2)]);
var inst_127411 = fluree.db.dbfunctions.internal.build_where_clause.call(null,startSubject,inst_127410__$1,endSubject);
var inst_127412 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_127413 = ["?var1",inst_127411];
var inst_127414 = cljs.core.PersistentHashMap.fromArrays(inst_127412,inst_127413);
var state_127430__$1 = (function (){var statearr_127432 = state_127430;
(statearr_127432[(8)] = inst_127414);

(statearr_127432[(7)] = inst_127410__$1);

return statearr_127432;
})();
var statearr_127433_127447 = state_127430__$1;
(statearr_127433_127447[(2)] = null);

(statearr_127433_127447[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127431 === (1))){
var state_127430__$1 = state_127430;
var statearr_127434_127448 = state_127430__$1;
(statearr_127434_127448[(2)] = null);

(statearr_127434_127448[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127431 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_127430,(3),Error,null,(2));
var inst_127403 = cljs.core.vector_QMARK_.call(null,path);
var state_127430__$1 = state_127430;
if(inst_127403){
var statearr_127435_127449 = state_127430__$1;
(statearr_127435_127449[(1)] = (5));

} else {
var statearr_127436_127450 = state_127430__$1;
(statearr_127436_127450[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127431 === (6))){
var inst_127406 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_127407 = [path];
var inst_127408 = (new cljs.core.PersistentVector(null,1,(5),inst_127406,inst_127407,null));
var state_127430__$1 = state_127430;
var statearr_127437_127451 = state_127430__$1;
(statearr_127437_127451[(2)] = inst_127408);

(statearr_127437_127451[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127431 === (3))){
var inst_127399 = (state_127430[(2)]);
var state_127430__$1 = state_127430;
var statearr_127438_127452 = state_127430__$1;
(statearr_127438_127452[(2)] = inst_127399);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_127430__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127431 === (2))){
var inst_127428 = (state_127430[(2)]);
var state_127430__$1 = state_127430;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_127430__$1,inst_127428);
} else {
if((state_val_127431 === (11))){
var inst_127423 = (state_127430[(2)]);
var inst_127424 = fluree.db.util.async.throw_err.call(null,inst_127423);
var state_127430__$1 = state_127430;
var statearr_127439_127453 = state_127430__$1;
(statearr_127439_127453[(2)] = inst_127424);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_127430__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127431 === (9))){
var inst_127410 = (state_127430[(7)]);
var inst_127415 = (state_127430[(2)]);
var inst_127416 = fluree.db.dbfunctions.internal.function_error.call(null,inst_127415,"relationship?",startSubject,inst_127410,endSubject);
var state_127430__$1 = state_127430;
var statearr_127440_127454 = state_127430__$1;
(statearr_127440_127454[(2)] = inst_127416);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_127430__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127431 === (5))){
var state_127430__$1 = state_127430;
var statearr_127441_127455 = state_127430__$1;
(statearr_127441_127455[(2)] = path);

(statearr_127441_127455[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127431 === (10))){
var inst_127414 = (state_127430[(8)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_127430,(9),new cljs.core.Keyword(null,"default","default",-1987822328),null,(8));
var inst_127420 = cljs.core.PersistentHashMap.EMPTY;
var inst_127421 = fluree.db.dbfunctions.internal.query.call(null,db,inst_127414,inst_127420);
var state_127430__$1 = state_127430;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_127430__$1,(11),inst_127421);
} else {
if((state_val_127431 === (8))){
var inst_127426 = (state_127430[(2)]);
var state_127430__$1 = state_127430;
var statearr_127442_127456 = state_127430__$1;
(statearr_127442_127456[(2)] = inst_127426);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_127430__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__99975__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__99975__auto____0 = (function (){
var statearr_127443 = [null,null,null,null,null,null,null,null,null];
(statearr_127443[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__99975__auto__);

(statearr_127443[(1)] = (1));

return statearr_127443;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__99975__auto____1 = (function (state_127430){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_127430);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e127444){if((e127444 instanceof Object)){
var ex__99978__auto__ = e127444;
var statearr_127445_127457 = state_127430;
(statearr_127445_127457[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_127430);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e127444;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__127458 = state_127430;
state_127430 = G__127458;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__99975__auto__ = function(state_127430){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__99975__auto____1.call(this,state_127430);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__99975__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__99975__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_127446 = f__100070__auto__.call(null);
(statearr_127446[(6)] = c__100069__auto__);

return statearr_127446;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,n))){
return (1);
} else {
return (n + (1));
}
}catch (e127459){var e = e127459;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"inc",n);
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,n))){
return (-1);
} else {
return (n - (1));
}
}catch (e127460){var e = e127460;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"dec",n);
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__4126__auto__ = cljs.core.get.call(null,m,k);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.call(null,m,cljs.core.keyword.call(null,k));
}
}catch (e127461){var e = e127461;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"get",m,k);
}});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis.call(null);
}catch (e127462){var e = e127462;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"now");
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___127465 = arguments.length;
var i__4737__auto___127466 = (0);
while(true){
if((i__4737__auto___127466 < len__4736__auto___127465)){
args__4742__auto__.push((arguments[i__4737__auto___127466]));

var G__127467 = (i__4737__auto___127466 + (1));
i__4737__auto___127466 = G__127467;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._PLUS_,args);
}catch (e127464){var e = e127464;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"+",args);
}}));

(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq127463){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq127463));
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___127470 = arguments.length;
var i__4737__auto___127471 = (0);
while(true){
if((i__4737__auto___127471 < len__4736__auto___127470)){
args__4742__auto__.push((arguments[i__4737__auto___127471]));

var G__127472 = (i__4737__auto___127471 + (1));
i__4737__auto___127471 = G__127472;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._,args);
}catch (e127469){var e = e127469;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"-",args);
}}));

(fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq127468){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq127468));
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___127475 = arguments.length;
var i__4737__auto___127476 = (0);
while(true){
if((i__4737__auto___127476 < len__4736__auto___127475)){
args__4742__auto__.push((arguments[i__4737__auto___127476]));

var G__127477 = (i__4737__auto___127476 + (1));
i__4737__auto___127476 = G__127477;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__4126__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_.call(null,args);
}
})())){
return (1);
} else {
return cljs.core.apply.call(null,cljs.core._STAR_,args);
}
}catch (e127474){var e = e127474;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"*",args);
}}));

(fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq127473){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq127473));
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___127480 = arguments.length;
var i__4737__auto___127481 = (0);
while(true){
if((i__4737__auto___127481 < len__4736__auto___127480)){
args__4742__auto__.push((arguments[i__4737__auto___127481]));

var G__127482 = (i__4737__auto___127481 + (1));
i__4737__auto___127481 = G__127482;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args))){
throw cljs.core.ex_info.call(null,"Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
} else {
return cljs.core.apply.call(null,cljs.core._SLASH_,args);
}
}catch (e127479){var e = e127479;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"/",args);
}}));

(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq127478){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq127478));
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot.call(null,n,d);
}catch (e127483){var e = e127483;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"quot",n,d);
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod.call(null,n,d);
}catch (e127484){var e = e127484;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"mod",n,d);
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem.call(null,n,d);
}catch (e127485){var e = e127485;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"rem",n,d);
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e127486){var e = e127486;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"ceil",num);
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e127487){var e = e127487;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"floor",num);
}});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__127493 = path;
var vec__127494 = G__127493;
var seq__127495 = cljs.core.seq.call(null,vec__127494);
var first__127496 = cljs.core.first.call(null,seq__127495);
var seq__127495__$1 = cljs.core.next.call(null,seq__127495);
var pred = first__127496;
var r = seq__127495__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__127493__$1 = G__127493;
var subjects__$1 = subjects;
while(true){
var vec__127500 = G__127493__$1;
var seq__127501 = cljs.core.seq.call(null,vec__127500);
var first__127502 = cljs.core.first.call(null,seq__127501);
var seq__127501__$1 = cljs.core.next.call(null,seq__127501);
var pred__$1 = first__127502;
var r__$1 = seq__127501__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.call(null,((function (G__127493__$1,subjects__$1,vec__127500,seq__127501,first__127502,seq__127501__$1,pred__$1,r__$1,subjects__$2,G__127493,vec__127494,seq__127495,first__127496,seq__127495__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_.call(null,subject))?cljs.core.mapv.call(null,((function (G__127493__$1,subjects__$1,vec__127500,seq__127501,first__127502,seq__127501__$1,pred__$1,r__$1,subjects__$2,G__127493,vec__127494,seq__127495,first__127496,seq__127495__$1,pred,r,subjects){
return (function (p1__127488_SHARP_){
return fluree.db.dbfunctions.internal.get.call(null,p1__127488_SHARP_,pred__$1);
});})(G__127493__$1,subjects__$1,vec__127500,seq__127501,first__127502,seq__127501__$1,pred__$1,r__$1,subjects__$2,G__127493,vec__127494,seq__127495,first__127496,seq__127495__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get.call(null,subject,pred__$1));
if(((cljs.core.vector_QMARK_.call(null,sub_subjects)) || (cljs.core.set_QMARK_.call(null,sub_subjects)))){
return cljs.core.into.call(null,acc,sub_subjects);
} else {
return cljs.core.conj.call(null,acc,sub_subjects);
}
});})(G__127493__$1,subjects__$1,vec__127500,seq__127501,first__127502,seq__127501__$1,pred__$1,r__$1,subjects__$2,G__127493,vec__127494,seq__127495,first__127496,seq__127495__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__4115__auto__ = r__$1;
if(and__4115__auto__){
return cljs.core.not_empty.call(null,next_subjects);
} else {
return and__4115__auto__;
}
})())){
var G__127503 = r__$1;
var G__127504 = next_subjects;
G__127493__$1 = G__127503;
subjects__$1 = G__127504;
continue;
} else {
return cljs.core.set.call(null,cljs.core.remove.call(null,fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e127489){var e = e127489;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"get-all",start_subject,path);
}});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all.call(null,m,ks);
}catch (e127505){var e = e127505;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"get-in",m,ks);
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{return cljs.core.contains_QMARK_.call(null,coll,key);
}catch (e127506){var e = e127506;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"contains?",coll,key);
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__4742__auto__ = [];
var len__4736__auto___127509 = arguments.length;
var i__4737__auto___127510 = (0);
while(true){
if((i__4737__auto___127510 < len__4736__auto___127509)){
args__4742__auto__.push((arguments[i__4737__auto___127510]));

var G__127511 = (i__4737__auto___127510 + (1));
i__4737__auto___127510 = G__127511;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.hash_set,args);
}catch (e127508){var e = e127508;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"hash-set",args);
}}));

(fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq127507){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq127507));
}));

/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_.call(null,coll))?cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.call(null,coll_SINGLEQUOTE_,key);
}catch (e127512){var e = e127512;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"nth",coll,key);
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___127515 = arguments.length;
var i__4737__auto___127516 = (0);
while(true){
if((i__4737__auto___127516 < len__4736__auto___127515)){
args__4742__auto__.push((arguments[i__4737__auto___127516]));

var G__127517 = (i__4737__auto___127516 + (1));
i__4737__auto___127516 = G__127517;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._EQ_,args);
}catch (e127514){var e = e127514;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"==",args);
}}));

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq127513){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq127513));
}));

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find.call(null,cljs.core.re_pattern.call(null,pattern),string);
}catch (e127518){var e = e127518;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"re-find",pattern,string);
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_127567){
var state_val_127568 = (state_127567[(1)]);
if((state_val_127568 === (7))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_127567,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var inst_127530 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_127531 = typeof inst_127530 === 'string';
var state_127567__$1 = state_127567;
if(cljs.core.truth_(inst_127531)){
var statearr_127569_127589 = state_127567__$1;
(statearr_127569_127589[(1)] = (8));

} else {
var statearr_127570_127590 = state_127567__$1;
(statearr_127570_127590[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127568 === (1))){
var state_127567__$1 = state_127567;
var statearr_127571_127591 = state_127567__$1;
(statearr_127571_127591[(2)] = null);

(statearr_127571_127591[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127568 === (4))){
var inst_127526 = (state_127567[(2)]);
var state_127567__$1 = state_127567;
var statearr_127572_127592 = state_127567__$1;
(statearr_127572_127592[(2)] = inst_127526);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_127567__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127568 === (13))){
var inst_127552 = (state_127567[(7)]);
var inst_127556 = inst_127552.o;
var state_127567__$1 = state_127567;
var statearr_127573_127593 = state_127567__$1;
(statearr_127573_127593[(2)] = inst_127556);

(statearr_127573_127593[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127568 === (6))){
var inst_127519 = (state_127567[(8)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_127567,(5),new cljs.core.Keyword(null,"default","default",-1987822328),null,(4));
var inst_127524 = fluree.db.dbfunctions.internal.function_error.call(null,inst_127519,"?pO","Context Object");
var state_127567__$1 = state_127567;
var statearr_127574_127594 = state_127567__$1;
(statearr_127574_127594[(2)] = inst_127524);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_127567__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127568 === (3))){
var inst_127519 = (state_127567[(2)]);
var state_127567__$1 = (function (){var statearr_127575 = state_127567;
(statearr_127575[(8)] = inst_127519);

return statearr_127575;
})();
var statearr_127576_127595 = state_127567__$1;
(statearr_127576_127595[(2)] = null);

(statearr_127576_127595[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127568 === (12))){
var state_127567__$1 = state_127567;
var statearr_127577_127596 = state_127567__$1;
(statearr_127577_127596[(2)] = null);

(statearr_127577_127596[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127568 === (2))){
var inst_127565 = (state_127567[(2)]);
var state_127567__$1 = state_127567;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_127567__$1,inst_127565);
} else {
if((state_val_127568 === (11))){
var inst_127552 = (state_127567[(7)]);
var inst_127548 = (state_127567[(2)]);
var inst_127549 = fluree.db.util.async.throw_err.call(null,inst_127548);
var inst_127550 = fluree.db.dbfunctions.internal.count.call(null,inst_127549);
var inst_127552__$1 = cljs.core.first.call(null,inst_127549);
var inst_127553 = (inst_127552__$1 == null);
var state_127567__$1 = (function (){var statearr_127578 = state_127567;
(statearr_127578[(7)] = inst_127552__$1);

(statearr_127578[(9)] = inst_127550);

return statearr_127578;
})();
if(cljs.core.truth_(inst_127553)){
var statearr_127579_127597 = state_127567__$1;
(statearr_127579_127597[(1)] = (12));

} else {
var statearr_127580_127598 = state_127567__$1;
(statearr_127580_127598[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127568 === (9))){
var inst_127537 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_127538 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_127537);
var inst_127539 = fluree.db.dbfunctions.internal.inc.call(null,inst_127538);
var inst_127540 = cljs.core.assoc.call(null,inst_127537,new cljs.core.Keyword(null,"t","t",-1397832519),inst_127539);
var inst_127541 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_127542 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_127543 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_127544 = [inst_127542,inst_127543];
var inst_127545 = (new cljs.core.PersistentVector(null,2,(5),inst_127541,inst_127544,null));
var inst_127546 = fluree.db.dbproto._search.call(null,inst_127540,inst_127545);
var state_127567__$1 = state_127567;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_127567__$1,(11),inst_127546);
} else {
if((state_val_127568 === (5))){
var inst_127520 = (state_127567[(2)]);
var state_127567__$1 = state_127567;
var statearr_127581_127599 = state_127567__$1;
(statearr_127581_127599[(2)] = inst_127520);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_127567__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127568 === (14))){
var inst_127550 = (state_127567[(9)]);
var inst_127558 = (state_127567[(2)]);
var inst_127559 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_127560 = [inst_127558,inst_127550];
var inst_127561 = (new cljs.core.PersistentVector(null,2,(5),inst_127559,inst_127560,null));
var state_127567__$1 = state_127567;
var statearr_127582_127600 = state_127567__$1;
(statearr_127582_127600[(2)] = inst_127561);

(statearr_127582_127600[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127568 === (10))){
var inst_127563 = (state_127567[(2)]);
var state_127567__$1 = state_127567;
var statearr_127583_127601 = state_127567__$1;
(statearr_127583_127601[(2)] = inst_127563);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_127567__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127568 === (8))){
var inst_127533 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_127534 = [null,(0)];
var inst_127535 = (new cljs.core.PersistentVector(null,2,(5),inst_127533,inst_127534,null));
var state_127567__$1 = state_127567;
var statearr_127584_127602 = state_127567__$1;
(statearr_127584_127602[(2)] = inst_127535);

(statearr_127584_127602[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__99975__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__99975__auto____0 = (function (){
var statearr_127585 = [null,null,null,null,null,null,null,null,null,null];
(statearr_127585[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__99975__auto__);

(statearr_127585[(1)] = (1));

return statearr_127585;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__99975__auto____1 = (function (state_127567){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_127567);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e127586){if((e127586 instanceof Object)){
var ex__99978__auto__ = e127586;
var statearr_127587_127603 = state_127567;
(statearr_127587_127603[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_127567);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e127586;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__127604 = state_127567;
state_127567 = G__127604;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__99975__auto__ = function(state_127567){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__99975__auto____1.call(this,state_127567);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__99975__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__99975__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_127588 = f__100070__auto__.call(null);
(statearr_127588[(6)] = c__100069__auto__);

return statearr_127588;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name,opts){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_127650){
var state_val_127651 = (state_127650[(1)]);
if((state_val_127651 === (7))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_127650,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var inst_127619 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_127620 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_127621 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_127622 = [null,pred_name,"?o"];
var inst_127623 = (new cljs.core.PersistentVector(null,3,(5),inst_127621,inst_127622,null));
var inst_127624 = [inst_127623];
var inst_127625 = (new cljs.core.PersistentVector(null,1,(5),inst_127620,inst_127624,null));
var inst_127626 = ["?o",inst_127625];
var inst_127627 = cljs.core.PersistentHashMap.fromArrays(inst_127619,inst_127626);
var inst_127628 = fluree.db.dbfunctions.internal.query.call(null,db,inst_127627,opts);
var state_127650__$1 = state_127650;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_127650__$1,(8),inst_127628);
} else {
if((state_val_127651 === (1))){
var state_127650__$1 = state_127650;
var statearr_127652_127668 = state_127650__$1;
(statearr_127652_127668[(2)] = null);

(statearr_127652_127668[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127651 === (4))){
var inst_127612 = (state_127650[(2)]);
var state_127650__$1 = state_127650;
var statearr_127653_127669 = state_127650__$1;
(statearr_127653_127669[(2)] = inst_127612);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_127650__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127651 === (6))){
var inst_127605 = (state_127650[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_127650,(5),new cljs.core.Keyword(null,"default","default",-1987822328),null,(4));
var inst_127610 = fluree.db.dbfunctions.internal.function_error.call(null,inst_127605,"max-pred-val",pred_name);
var state_127650__$1 = state_127650;
var statearr_127654_127670 = state_127650__$1;
(statearr_127654_127670[(2)] = inst_127610);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_127650__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127651 === (3))){
var inst_127605 = (state_127650[(2)]);
var state_127650__$1 = (function (){var statearr_127655 = state_127650;
(statearr_127655[(7)] = inst_127605);

return statearr_127655;
})();
var statearr_127656_127671 = state_127650__$1;
(statearr_127656_127671[(2)] = null);

(statearr_127656_127671[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127651 === (2))){
var inst_127648 = (state_127650[(2)]);
var state_127650__$1 = state_127650;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_127650__$1,inst_127648);
} else {
if((state_val_127651 === (11))){
var inst_127646 = (state_127650[(2)]);
var state_127650__$1 = state_127650;
var statearr_127657_127672 = state_127650__$1;
(statearr_127657_127672[(2)] = inst_127646);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_127650__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127651 === (9))){
var inst_127633 = (state_127650[(8)]);
var inst_127632 = (state_127650[(9)]);
var inst_127637 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_127638 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.max,inst_127632);
var inst_127639 = [inst_127638,inst_127633];
var inst_127640 = (new cljs.core.PersistentVector(null,2,(5),inst_127637,inst_127639,null));
var state_127650__$1 = state_127650;
var statearr_127658_127673 = state_127650__$1;
(statearr_127658_127673[(2)] = inst_127640);

(statearr_127658_127673[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127651 === (5))){
var inst_127606 = (state_127650[(2)]);
var state_127650__$1 = state_127650;
var statearr_127659_127674 = state_127650__$1;
(statearr_127659_127674[(2)] = inst_127606);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_127650__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127651 === (10))){
var inst_127633 = (state_127650[(8)]);
var inst_127642 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_127643 = [null,inst_127633];
var inst_127644 = (new cljs.core.PersistentVector(null,2,(5),inst_127642,inst_127643,null));
var state_127650__$1 = state_127650;
var statearr_127660_127675 = state_127650__$1;
(statearr_127660_127675[(2)] = inst_127644);

(statearr_127660_127675[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127651 === (8))){
var inst_127632 = (state_127650[(9)]);
var inst_127630 = (state_127650[(2)]);
var inst_127631 = fluree.db.util.async.throw_err.call(null,inst_127630);
var inst_127632__$1 = cljs.core.nth.call(null,inst_127631,(0),null);
var inst_127633 = cljs.core.nth.call(null,inst_127631,(1),null);
var inst_127634 = fluree.db.dbfunctions.internal.empty_QMARK_.call(null,inst_127632__$1);
var inst_127635 = cljs.core.not.call(null,inst_127634);
var state_127650__$1 = (function (){var statearr_127661 = state_127650;
(statearr_127661[(8)] = inst_127633);

(statearr_127661[(9)] = inst_127632__$1);

return statearr_127661;
})();
if(inst_127635){
var statearr_127662_127676 = state_127650__$1;
(statearr_127662_127676[(1)] = (9));

} else {
var statearr_127663_127677 = state_127650__$1;
(statearr_127663_127677[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__99975__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__99975__auto____0 = (function (){
var statearr_127664 = [null,null,null,null,null,null,null,null,null,null];
(statearr_127664[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__99975__auto__);

(statearr_127664[(1)] = (1));

return statearr_127664;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__99975__auto____1 = (function (state_127650){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_127650);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e127665){if((e127665 instanceof Object)){
var ex__99978__auto__ = e127665;
var statearr_127666_127678 = state_127650;
(statearr_127666_127678[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_127650);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e127665;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__127679 = state_127650;
state_127650 = G__127679;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__99975__auto__ = function(state_127650){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__99975__auto____1.call(this,state_127650);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__99975__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__99975__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_127667 = f__100070__auto__.call(null);
(statearr_127667[(6)] = c__100069__auto__);

return statearr_127667;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$.call(null,((typeof email === 'string')?cljs.core.re_matches.call(null,pattern,email):false));
}catch (e127680){var e = e127680;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"valid-email?",email);
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__127682 = arguments.length;
switch (G__127682) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_127746){
var state_val_127747 = (state_127746[(1)]);
if((state_val_127747 === (7))){
var inst_127694 = (state_127746[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_127746,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var inst_127694__$1 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_127746__$1 = (function (){var statearr_127748 = state_127746;
(statearr_127748[(7)] = inst_127694__$1);

return statearr_127748;
})();
if(cljs.core.truth_(inst_127694__$1)){
var statearr_127749_127779 = state_127746__$1;
(statearr_127749_127779[(1)] = (8));

} else {
var statearr_127750_127780 = state_127746__$1;
(statearr_127750_127780[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127747 === (20))){
var inst_127734 = (state_127746[(2)]);
var inst_127735 = fluree.db.util.async.throw_err.call(null,inst_127734);
var inst_127736 = cljs.core.nth.call(null,inst_127735,(0),null);
var inst_127737 = cljs.core.nth.call(null,inst_127735,(1),null);
var inst_127738 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_127739 = [inst_127736,inst_127737];
var inst_127740 = (new cljs.core.PersistentVector(null,2,(5),inst_127738,inst_127739,null));
var state_127746__$1 = state_127746;
var statearr_127751_127781 = state_127746__$1;
(statearr_127751_127781[(2)] = inst_127740);

(statearr_127751_127781[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127747 === (1))){
var state_127746__$1 = state_127746;
var statearr_127752_127782 = state_127746__$1;
(statearr_127752_127782[(2)] = null);

(statearr_127752_127782[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127747 === (4))){
var inst_127690 = (state_127746[(2)]);
var state_127746__$1 = state_127746;
var statearr_127753_127783 = state_127746__$1;
(statearr_127753_127783[(2)] = inst_127690);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_127746__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127747 === (15))){
var inst_127710 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_127711 = fluree.db.dbfunctions.internal.get.call(null,inst_127710,new cljs.core.Keyword(null,"_id","_id",-789960287));
var state_127746__$1 = state_127746;
var statearr_127754_127784 = state_127746__$1;
(statearr_127754_127784[(2)] = inst_127711);

(statearr_127754_127784[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127747 === (13))){
var inst_127742 = (state_127746[(2)]);
var state_127746__$1 = state_127746;
var statearr_127755_127785 = state_127746__$1;
(statearr_127755_127785[(2)] = inst_127742);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_127746__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127747 === (6))){
var inst_127683 = (state_127746[(8)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_127746,(5),new cljs.core.Keyword(null,"default","default",-1987822328),null,(4));
var inst_127688 = fluree.db.dbfunctions.internal.function_error.call(null,inst_127683,"?s","Context Object",additional_params);
var state_127746__$1 = state_127746;
var statearr_127756_127786 = state_127746__$1;
(statearr_127756_127786[(2)] = inst_127688);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_127746__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127747 === (17))){
var inst_127715 = cljs.core.PersistentVector.EMPTY;
var inst_127716 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_127717 = ["*"];
var inst_127718 = (new cljs.core.PersistentVector(null,1,(5),inst_127716,inst_127717,null));
var inst_127719 = fluree.db.dbfunctions.internal.parse_select_map.call(null,additional_params);
var inst_127720 = cljs.core.concat.call(null,inst_127718,inst_127719);
var inst_127721 = cljs.core.into.call(null,inst_127715,inst_127720);
var state_127746__$1 = state_127746;
var statearr_127757_127787 = state_127746__$1;
(statearr_127757_127787[(2)] = inst_127721);

(statearr_127757_127787[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127747 === (3))){
var inst_127683 = (state_127746[(2)]);
var state_127746__$1 = (function (){var statearr_127758 = state_127746;
(statearr_127758[(8)] = inst_127683);

return statearr_127758;
})();
var statearr_127759_127788 = state_127746__$1;
(statearr_127759_127788[(2)] = null);

(statearr_127759_127788[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127747 === (12))){
var inst_127707 = (state_127746[(9)]);
var inst_127706 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_127707__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_127746__$1 = (function (){var statearr_127760 = state_127746;
(statearr_127760[(9)] = inst_127707__$1);

(statearr_127760[(10)] = inst_127706);

return statearr_127760;
})();
if(cljs.core.truth_(inst_127707__$1)){
var statearr_127761_127789 = state_127746__$1;
(statearr_127761_127789[(1)] = (14));

} else {
var statearr_127762_127790 = state_127746__$1;
(statearr_127762_127790[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127747 === (2))){
var inst_127744 = (state_127746[(2)]);
var state_127746__$1 = state_127746;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_127746__$1,inst_127744);
} else {
if((state_val_127747 === (19))){
var inst_127713 = (state_127746[(11)]);
var inst_127706 = (state_127746[(10)]);
var inst_127727 = (state_127746[(2)]);
var inst_127728 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044)];
var inst_127729 = [inst_127727,inst_127713];
var inst_127730 = cljs.core.PersistentHashMap.fromArrays(inst_127728,inst_127729);
var inst_127731 = cljs.core.PersistentHashMap.EMPTY;
var inst_127732 = fluree.db.dbfunctions.internal.query.call(null,inst_127706,inst_127730,inst_127731);
var state_127746__$1 = state_127746;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_127746__$1,(20),inst_127732);
} else {
if((state_val_127747 === (11))){
var inst_127701 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_127746__$1 = state_127746;
var statearr_127763_127791 = state_127746__$1;
(statearr_127763_127791[(2)] = inst_127701);

(statearr_127763_127791[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127747 === (9))){
var inst_127694 = (state_127746[(7)]);
var state_127746__$1 = state_127746;
var statearr_127764_127792 = state_127746__$1;
(statearr_127764_127792[(2)] = inst_127694);

(statearr_127764_127792[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127747 === (5))){
var inst_127684 = (state_127746[(2)]);
var state_127746__$1 = state_127746;
var statearr_127765_127793 = state_127746__$1;
(statearr_127765_127793[(2)] = inst_127684);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_127746__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127747 === (14))){
var inst_127707 = (state_127746[(9)]);
var state_127746__$1 = state_127746;
var statearr_127766_127794 = state_127746__$1;
(statearr_127766_127794[(2)] = inst_127707);

(statearr_127766_127794[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127747 === (16))){
var inst_127713 = (state_127746[(2)]);
var state_127746__$1 = (function (){var statearr_127767 = state_127746;
(statearr_127767[(11)] = inst_127713);

return statearr_127767;
})();
if(cljs.core.truth_(additional_params)){
var statearr_127768_127795 = state_127746__$1;
(statearr_127768_127795[(1)] = (17));

} else {
var statearr_127769_127796 = state_127746__$1;
(statearr_127769_127796[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127747 === (10))){
var inst_127699 = (state_127746[(2)]);
var state_127746__$1 = state_127746;
if(cljs.core.truth_(inst_127699)){
var statearr_127770_127797 = state_127746__$1;
(statearr_127770_127797[(1)] = (11));

} else {
var statearr_127771_127798 = state_127746__$1;
(statearr_127771_127798[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127747 === (18))){
var inst_127723 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_127724 = ["*"];
var inst_127725 = (new cljs.core.PersistentVector(null,1,(5),inst_127723,inst_127724,null));
var state_127746__$1 = state_127746;
var statearr_127772_127799 = state_127746__$1;
(statearr_127772_127799[(2)] = inst_127725);

(statearr_127772_127799[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127747 === (8))){
var inst_127696 = fluree.db.dbfunctions.internal.empty_QMARK_.call(null,additional_params);
var state_127746__$1 = state_127746;
var statearr_127773_127800 = state_127746__$1;
(statearr_127773_127800[(2)] = inst_127696);

(statearr_127773_127800[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__99975__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__99975__auto____0 = (function (){
var statearr_127774 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_127774[(0)] = fluree$db$dbfunctions$internal$state_machine__99975__auto__);

(statearr_127774[(1)] = (1));

return statearr_127774;
});
var fluree$db$dbfunctions$internal$state_machine__99975__auto____1 = (function (state_127746){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_127746);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e127775){if((e127775 instanceof Object)){
var ex__99978__auto__ = e127775;
var statearr_127776_127801 = state_127746;
(statearr_127776_127801[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_127746);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e127775;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__127802 = state_127746;
state_127746 = G__127802;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__99975__auto__ = function(state_127746){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__99975__auto____1.call(this,state_127746);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__99975__auto____0;
fluree$db$dbfunctions$internal$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__99975__auto____1;
return fluree$db$dbfunctions$internal$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_127777 = f__100070__auto__.call(null);
(statearr_127777[(6)] = c__100069__auto__);

return statearr_127777;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__127804 = arguments.length;
switch (G__127804) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_127845){
var state_val_127846 = (state_127845[(1)]);
if((state_val_127846 === (1))){
var state_127845__$1 = state_127845;
var statearr_127847_127860 = state_127845__$1;
(statearr_127847_127860[(2)] = null);

(statearr_127847_127860[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127846 === (2))){
var inst_127843 = (state_127845[(2)]);
var state_127845__$1 = state_127845;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_127845__$1,inst_127843);
} else {
if((state_val_127846 === (3))){
var inst_127805 = (state_127845[(2)]);
var inst_127806 = fluree.db.dbfunctions.internal.function_error.call(null,inst_127805,"?p","Context Object",additional_params);
var state_127845__$1 = state_127845;
var statearr_127848_127861 = state_127845__$1;
(statearr_127848_127861[(2)] = inst_127806);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_127845__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127846 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_127845,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var inst_127813 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_127814 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_127845__$1 = (function (){var statearr_127849 = state_127845;
(statearr_127849[(7)] = inst_127813);

(statearr_127849[(8)] = inst_127814);

return statearr_127849;
})();
if(cljs.core.truth_(additional_params)){
var statearr_127850_127862 = state_127845__$1;
(statearr_127850_127862[(1)] = (5));

} else {
var statearr_127851_127863 = state_127845__$1;
(statearr_127851_127863[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127846 === (5))){
var inst_127816 = cljs.core.PersistentVector.EMPTY;
var inst_127817 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_127818 = ["*"];
var inst_127819 = (new cljs.core.PersistentVector(null,1,(5),inst_127817,inst_127818,null));
var inst_127820 = fluree.db.dbfunctions.internal.parse_select_map.call(null,additional_params);
var inst_127821 = cljs.core.concat.call(null,inst_127819,inst_127820);
var inst_127822 = cljs.core.into.call(null,inst_127816,inst_127821);
var state_127845__$1 = state_127845;
var statearr_127852_127864 = state_127845__$1;
(statearr_127852_127864[(2)] = inst_127822);

(statearr_127852_127864[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127846 === (6))){
var inst_127824 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_127825 = ["*"];
var inst_127826 = (new cljs.core.PersistentVector(null,1,(5),inst_127824,inst_127825,null));
var state_127845__$1 = state_127845;
var statearr_127853_127865 = state_127845__$1;
(statearr_127853_127865[(2)] = inst_127826);

(statearr_127853_127865[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127846 === (7))){
var inst_127813 = (state_127845[(7)]);
var inst_127814 = (state_127845[(8)]);
var inst_127828 = (state_127845[(2)]);
var inst_127829 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044)];
var inst_127830 = [inst_127828,inst_127814];
var inst_127831 = cljs.core.PersistentHashMap.fromArrays(inst_127829,inst_127830);
var inst_127832 = cljs.core.PersistentHashMap.EMPTY;
var inst_127833 = fluree.db.dbfunctions.internal.query.call(null,inst_127813,inst_127831,inst_127832);
var state_127845__$1 = state_127845;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_127845__$1,(8),inst_127833);
} else {
if((state_val_127846 === (8))){
var inst_127835 = (state_127845[(2)]);
var inst_127836 = fluree.db.util.async.throw_err.call(null,inst_127835);
var inst_127837 = cljs.core.nth.call(null,inst_127836,(0),null);
var inst_127838 = cljs.core.nth.call(null,inst_127836,(1),null);
var inst_127839 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_127840 = [inst_127837,inst_127838];
var inst_127841 = (new cljs.core.PersistentVector(null,2,(5),inst_127839,inst_127840,null));
var state_127845__$1 = state_127845;
var statearr_127854_127866 = state_127845__$1;
(statearr_127854_127866[(2)] = inst_127841);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_127845__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__99975__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__99975__auto____0 = (function (){
var statearr_127855 = [null,null,null,null,null,null,null,null,null];
(statearr_127855[(0)] = fluree$db$dbfunctions$internal$state_machine__99975__auto__);

(statearr_127855[(1)] = (1));

return statearr_127855;
});
var fluree$db$dbfunctions$internal$state_machine__99975__auto____1 = (function (state_127845){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_127845);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e127856){if((e127856 instanceof Object)){
var ex__99978__auto__ = e127856;
var statearr_127857_127867 = state_127845;
(statearr_127857_127867[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_127845);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e127856;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__127868 = state_127845;
state_127845 = G__127868;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__99975__auto__ = function(state_127845){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__99975__auto____1.call(this,state_127845);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__99975__auto____0;
fluree$db$dbfunctions$internal$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__99975__auto____1;
return fluree$db$dbfunctions$internal$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_127858 = f__100070__auto__.call(null);
(statearr_127858[(6)] = c__100069__auto__);

return statearr_127858;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2);

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_127909){
var state_val_127910 = (state_127909[(1)]);
if((state_val_127910 === (1))){
var state_127909__$1 = state_127909;
var statearr_127911_127918 = state_127909__$1;
(statearr_127911_127918[(2)] = null);

(statearr_127911_127918[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127910 === (2))){
var inst_127907 = (state_127909[(2)]);
var state_127909__$1 = state_127909;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_127909__$1,inst_127907);
} else {
if((state_val_127910 === (3))){
var inst_127869 = (state_127909[(2)]);
var inst_127870 = fluree.db.dbfunctions.internal.function_error.call(null,inst_127869,"?user_id-from-auth","Context Object");
var state_127909__$1 = state_127909;
var statearr_127912_127919 = state_127909__$1;
(statearr_127912_127919[(2)] = inst_127870);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_127909__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127910 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_127909,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var inst_127877 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044)];
var inst_127878 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_127879 = ["_user/_auth"];
var inst_127880 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_127881 = ["*"];
var inst_127882 = (new cljs.core.PersistentVector(null,1,(5),inst_127880,inst_127881,null));
var inst_127883 = [inst_127882];
var inst_127884 = cljs.core.PersistentHashMap.fromArrays(inst_127879,inst_127883);
var inst_127885 = [inst_127884];
var inst_127886 = (new cljs.core.PersistentVector(null,1,(5),inst_127878,inst_127885,null));
var inst_127887 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_127888 = [inst_127886,inst_127887];
var inst_127889 = cljs.core.PersistentHashMap.fromArrays(inst_127877,inst_127888);
var inst_127890 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_127891 = cljs.core.PersistentHashMap.EMPTY;
var inst_127892 = fluree.db.dbfunctions.internal.query.call(null,inst_127890,inst_127889,inst_127891);
var state_127909__$1 = state_127909;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_127909__$1,(5),inst_127892);
} else {
if((state_val_127910 === (5))){
var inst_127894 = (state_127909[(2)]);
var inst_127895 = fluree.db.util.async.throw_err.call(null,inst_127894);
var inst_127896 = cljs.core.nth.call(null,inst_127895,(0),null);
var inst_127897 = cljs.core.nth.call(null,inst_127895,(1),null);
var inst_127898 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_127899 = ["_user/_auth","_id"];
var inst_127900 = (new cljs.core.PersistentVector(null,2,(5),inst_127898,inst_127899,null));
var inst_127901 = fluree.db.dbfunctions.internal.get_in.call(null,inst_127896,inst_127900);
var inst_127902 = cljs.core.first.call(null,inst_127901);
var inst_127903 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_127904 = [inst_127902,inst_127897];
var inst_127905 = (new cljs.core.PersistentVector(null,2,(5),inst_127903,inst_127904,null));
var state_127909__$1 = state_127909;
var statearr_127913_127920 = state_127909__$1;
(statearr_127913_127920[(2)] = inst_127905);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_127909__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__99975__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__99975__auto____0 = (function (){
var statearr_127914 = [null,null,null,null,null,null,null];
(statearr_127914[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__99975__auto__);

(statearr_127914[(1)] = (1));

return statearr_127914;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__99975__auto____1 = (function (state_127909){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_127909);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e127915){if((e127915 instanceof Object)){
var ex__99978__auto__ = e127915;
var statearr_127916_127921 = state_127909;
(statearr_127916_127921[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_127909);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e127915;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__127922 = state_127909;
state_127909 = G__127922;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__99975__auto__ = function(state_127909){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__99975__auto____1.call(this,state_127909);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__99975__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__99975__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_127917 = f__100070__auto__.call(null);
(statearr_127917[(6)] = c__100069__auto__);

return statearr_127917;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_127936){
var state_val_127937 = (state_127936[(1)]);
if((state_val_127937 === (1))){
var state_127936__$1 = state_127936;
var statearr_127938_127945 = state_127936__$1;
(statearr_127938_127945[(2)] = null);

(statearr_127938_127945[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127937 === (2))){
var inst_127934 = (state_127936[(2)]);
var state_127936__$1 = state_127936;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_127936__$1,inst_127934);
} else {
if((state_val_127937 === (3))){
var inst_127923 = (state_127936[(2)]);
var state_127936__$1 = state_127936;
var statearr_127939_127946 = state_127936__$1;
(statearr_127939_127946[(2)] = inst_127923);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_127936__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_127937 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_127936,(3),Error,null,(2));
var inst_127927 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_127928 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_127929 = fluree.db.dbproto._subid.call(null,inst_127928,inst_127927);
var state_127936__$1 = state_127936;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_127936__$1,(5),inst_127929);
} else {
if((state_val_127937 === (5))){
var inst_127931 = (state_127936[(2)]);
var inst_127932 = fluree.db.util.async.throw_err.call(null,inst_127931);
var state_127936__$1 = state_127936;
var statearr_127940_127947 = state_127936__$1;
(statearr_127940_127947[(2)] = inst_127932);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_127936__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__99975__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__99975__auto____0 = (function (){
var statearr_127941 = [null,null,null,null,null,null,null];
(statearr_127941[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__99975__auto__);

(statearr_127941[(1)] = (1));

return statearr_127941;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__99975__auto____1 = (function (state_127936){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_127936);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e127942){if((e127942 instanceof Object)){
var ex__99978__auto__ = e127942;
var statearr_127943_127948 = state_127936;
(statearr_127943_127948[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_127936);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e127942;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__127949 = state_127936;
state_127936 = G__127949;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__99975__auto__ = function(state_127936){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__99975__auto____1.call(this,state_127936);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__99975__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__99975__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_127944 = f__100070__auto__.call(null);
(statearr_127944[(6)] = c__100069__auto__);

return statearr_127944;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv.call(null,(function (p1__127950_SHARP_){
return p1__127950_SHARP_.op === true;
}),flakes);
var objs = cljs.core.map.call(null,(function (p1__127951_SHARP_){
return p1__127951_SHARP_.o;
}),trueF);
var sum = cljs.core.reduce.call(null,cljs.core._PLUS_,objs);
return sum;
}catch (e127952){var e = e127952;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"objT",flakes);
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv.call(null,(function (p1__127953_SHARP_){
return p1__127953_SHARP_.op === false;
}),flakes);
var objs = cljs.core.map.call(null,(function (p1__127954_SHARP_){
return p1__127954_SHARP_.o;
}),falseF);
var sum = cljs.core.reduce.call(null,cljs.core._PLUS_,objs);
return sum;
}catch (e127955){var e = e127955;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"objF",flakes);
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = (Math.floor(fluree.db.dbfunctions.internal._STAR_.call(null,base,max_SINGLEQUOTE_)) | (0));
return num;
}catch (e127956){var e = e127956;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"rand",instant,max_SINGLEQUOTE_);
}});
