// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true}
goog.provide('fluree.db.util.xhttp');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('goog.net.XhrIo');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
fluree.db.util.xhttp.format_error_response = (function fluree$db$util$xhttp$format_error_response(url,e){
var status = (function (){var temp__5735__auto__ = e.getStatus();
if(cljs.core.truth_(temp__5735__auto__)){
var st = temp__5735__auto__;
if((st > (0))){
return st;
} else {
return null;
}
} else {
return null;
}
})();
var error = (function (){var pred__109490 = cljs.core._EQ_;
var expr__109491 = e.getLastErrorCode();
if(cljs.core.truth_((pred__109490.cljs$core$IFn$_invoke$arity$2 ? pred__109490.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.NO_ERROR,expr__109491) : pred__109490.call(null,goog.net.ErrorCode.NO_ERROR,expr__109491)))){
return cljs.core.cst$kw$xhttp_SLASH_no_DASH_error;
} else {
if(cljs.core.truth_((pred__109490.cljs$core$IFn$_invoke$arity$2 ? pred__109490.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.EXCEPTION,expr__109491) : pred__109490.call(null,goog.net.ErrorCode.EXCEPTION,expr__109491)))){
return cljs.core.cst$kw$xhttp_SLASH_exception;
} else {
if(cljs.core.truth_((pred__109490.cljs$core$IFn$_invoke$arity$2 ? pred__109490.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.HTTP_ERROR,expr__109491) : pred__109490.call(null,goog.net.ErrorCode.HTTP_ERROR,expr__109491)))){
return cljs.core.cst$kw$xhttp_SLASH_http_DASH_error;
} else {
if(cljs.core.truth_((pred__109490.cljs$core$IFn$_invoke$arity$2 ? pred__109490.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.ABORT,expr__109491) : pred__109490.call(null,goog.net.ErrorCode.ABORT,expr__109491)))){
return cljs.core.cst$kw$xhttp_SLASH_abort;
} else {
if(cljs.core.truth_((pred__109490.cljs$core$IFn$_invoke$arity$2 ? pred__109490.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.TIMEOUT,expr__109491) : pred__109490.call(null,goog.net.ErrorCode.TIMEOUT,expr__109491)))){
return cljs.core.cst$kw$xhttp_SLASH_timeout;
} else {
return cljs.core.cst$kw$xhttp_SLASH_unknown_DASH_error;
}
}
}
}
}
})();
var message = ["xhttp error - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url),(cljs.core.truth_((function (){var and__4115__auto__ = status;
if(cljs.core.truth_(and__4115__auto__)){
return (status > (0));
} else {
return and__4115__auto__;
}
})())?[": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(status)].join(''):"")].join('');
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,(function (){var G__109493 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$url,url,cljs.core.cst$kw$error,error], null);
if(cljs.core.truth_(status)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__109493,cljs.core.cst$kw$status,status);
} else {
return G__109493;
}
})());
});
/**
 * Posts JSON content.
 *   opts is a map with following optional keys:
 *   :request-timeout - how many milliseconds until we throw an exception without a response (default 5000)
 */
fluree.db.util.xhttp.post_json = (function fluree$db$util$xhttp$post_json(url,message,opts){
var map__109494 = opts;
var map__109494__$1 = (((((!((map__109494 == null))))?(((((map__109494.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__109494.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__109494):map__109494);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__109494__$1,cljs.core.cst$kw$request_DASH_timeout,(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__109494__$1,cljs.core.cst$kw$token);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__109494__$1,cljs.core.cst$kw$headers);
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__109496 = new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","application/json"], null);
var G__109496__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__109496,headers], 0)):G__109496);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__109496__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__109496__$1;
}
})();
try{var G__109498_109504 = url;
var G__109499_109505 = (function (event){
var xhr = event.target;
var success_QMARK_ = xhr.isSuccess();
if(cljs.core.truth_(success_QMARK_)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(xhr.getResponseJson(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$keywordize_DASH_keys,true], 0)));
} else {
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,xhr));
}
});
var G__109500_109506 = "POST";
var G__109501_109507 = fluree.db.util.json.stringify(message);
var G__109502_109508 = cljs.core.clj__GT_js(headers__$1);
var G__109503_109509 = request_timeout;
goog.net.XhrIo.send(G__109498_109504,G__109499_109505,G__109500_109506,G__109501_109507,G__109502_109508,G__109503_109509);
}catch (e109497){var e_109510 = e109497;
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["CAUGHT ERROR!"], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,e_109510);
}
return response_chan;
});
/**
 * Returns result body as a string, or an exception.
 * 
 *   If opts contains :body,
 *   It is assumed body is already in a format that can be sent directly in request (already encoded).
 * 
 *   Options
 *   - output-format - can be :text, :json or :binary (default text), or special format (wikidata) to handle wikidata errors, which come back as html.
 * 
 *   
 */
fluree.db.util.xhttp.get = (function fluree$db$util$xhttp$get(url,opts){
var map__109511 = opts;
var map__109511__$1 = (((((!((map__109511 == null))))?(((((map__109511.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__109511.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__109511):map__109511);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__109511__$1,cljs.core.cst$kw$request_DASH_timeout,(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__109511__$1,cljs.core.cst$kw$token);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__109511__$1,cljs.core.cst$kw$headers);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__109511__$1,cljs.core.cst$kw$body);
var output_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__109511__$1,cljs.core.cst$kw$output_DASH_format,cljs.core.cst$kw$text);
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__109513 = cljs.core.PersistentArrayMap.EMPTY;
var G__109513__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__109513,headers], 0)):G__109513);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__109513__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__109513__$1;
}
})();
try{var G__109515_109522 = url;
var G__109516_109523 = (function (event){
var xhr = event.target;
var success_QMARK_ = xhr.isSuccess();
if(cljs.core.truth_(success_QMARK_)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,(function (){var G__109521 = output_format;
var G__109521__$1 = (((G__109521 instanceof cljs.core.Keyword))?G__109521.fqn:null);
switch (G__109521__$1) {
case "text":
return xhr.getResponseText();

break;
case "json":
return xhr.getResponseJson();

break;
default:
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("http get only supports output formats of json and text for now.",cljs.core.PersistentArrayMap.EMPTY);

}
})());
} else {
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,xhr));
}
});
var G__109517_109524 = "GET";
var G__109518_109525 = body;
var G__109519_109526 = cljs.core.clj__GT_js(headers__$1);
var G__109520_109527 = request_timeout;
goog.net.XhrIo.send(G__109515_109522,G__109516_109523,G__109517_109524,G__109518_109525,G__109519_109526,G__109520_109527);
}catch (e109514){var e_109529 = e109514;
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["CAUUGHT ERROR!"], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,e_109529);
}
return response_chan;
});
/**
 * http get with JSON response.
 * 
 *   If opts contains :body key, it is encoded into JSON and sent as part
 *   of the body.
 */
fluree.db.util.xhttp.get_json = (function fluree$db$util$xhttp$get_json(url,opts){
var opts_STAR_ = (function (){var G__109530 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc_in(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$headers,"Accept"], null),"application/json"),cljs.core.cst$kw$output_DASH_format,cljs.core.cst$kw$json);
if(cljs.core.truth_(cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__109530,cljs.core.cst$kw$body,fluree.db.util.json.stringify(cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(opts)));
} else {
return G__109530;
}
})();
return fluree.db.util.xhttp.get(url,opts_STAR_);
});
/**
 * Sends messages across web socket. Sends never block and will immediately queue.
 *   Message to send should be a two-tuple placed on the pub-chan, of:
 *  [msg resp-chan]
 *   where a true/false response will eventually be placed on the resp-chan if the send
 *   is successful.
 */
fluree.db.util.xhttp.socket_publish_loop = (function fluree$db$util$xhttp$socket_publish_loop(ws,pub_chan){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_109560){
var state_val_109561 = (state_109560[(1)]);
if((state_val_109561 === (7))){
var inst_109556 = (state_109560[(2)]);
var state_109560__$1 = state_109560;
var statearr_109562_109580 = state_109560__$1;
(statearr_109562_109580[(2)] = inst_109556);

(statearr_109562_109580[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109561 === (1))){
var state_109560__$1 = state_109560;
var statearr_109563_109581 = state_109560__$1;
(statearr_109563_109581[(2)] = null);

(statearr_109563_109581[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109561 === (4))){
var inst_109534 = (state_109560[(7)]);
var inst_109534__$1 = (state_109560[(2)]);
var inst_109535 = (inst_109534__$1 == null);
var state_109560__$1 = (function (){var statearr_109564 = state_109560;
(statearr_109564[(7)] = inst_109534__$1);

return statearr_109564;
})();
if(cljs.core.truth_(inst_109535)){
var statearr_109565_109582 = state_109560__$1;
(statearr_109565_109582[(1)] = (5));

} else {
var statearr_109566_109583 = state_109560__$1;
(statearr_109566_109583[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_109561 === (6))){
var inst_109534 = (state_109560[(7)]);
var inst_109542 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_109534,(0),null);
var inst_109543 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_109534,(1),null);
var state_109560__$1 = (function (){var statearr_109567 = state_109560;
(statearr_109567[(8)] = inst_109543);

(statearr_109567[(9)] = inst_109542);

return statearr_109567;
})();
var statearr_109568_109584 = state_109560__$1;
(statearr_109568_109584[(2)] = null);

(statearr_109568_109584[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109561 === (3))){
var inst_109558 = (state_109560[(2)]);
var state_109560__$1 = state_109560;
return cljs.core.async.impl.ioc_helpers.return_chan(state_109560__$1,inst_109558);
} else {
if((state_val_109561 === (2))){
var state_109560__$1 = state_109560;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_109560__$1,(4),pub_chan);
} else {
if((state_val_109561 === (9))){
var inst_109543 = (state_109560[(8)]);
var inst_109544 = (state_109560[(2)]);
var inst_109545 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_109544,"Websocket send message error:",inst_109544], 0));
var inst_109546 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_109543,false);
var state_109560__$1 = (function (){var statearr_109569 = state_109560;
(statearr_109569[(10)] = inst_109545);

return statearr_109569;
})();
var statearr_109570_109585 = state_109560__$1;
(statearr_109570_109585[(2)] = inst_109546);


cljs.core.async.impl.ioc_helpers.process_exception(state_109560__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_109561 === (5))){
var inst_109537 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Web socket pub/producer channel closed."], 0));
var state_109560__$1 = state_109560;
var statearr_109571_109586 = state_109560__$1;
(statearr_109571_109586[(2)] = inst_109537);

(statearr_109571_109586[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109561 === (10))){
var inst_109543 = (state_109560[(8)]);
var inst_109542 = (state_109560[(9)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_109560,(9),Error,null,(8));
var inst_109550 = ws.send(inst_109542);
var inst_109551 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_109543,true);
var state_109560__$1 = (function (){var statearr_109572 = state_109560;
(statearr_109572[(11)] = inst_109550);

return statearr_109572;
})();
var statearr_109573_109587 = state_109560__$1;
(statearr_109573_109587[(2)] = inst_109551);


cljs.core.async.impl.ioc_helpers.process_exception(state_109560__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_109561 === (8))){
var inst_109553 = (state_109560[(2)]);
var state_109560__$1 = (function (){var statearr_109574 = state_109560;
(statearr_109574[(12)] = inst_109553);

return statearr_109574;
})();
var statearr_109575_109588 = state_109560__$1;
(statearr_109575_109588[(2)] = null);

(statearr_109575_109588[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__100742__auto__ = null;
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__100742__auto____0 = (function (){
var statearr_109576 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_109576[(0)] = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__100742__auto__);

(statearr_109576[(1)] = (1));

return statearr_109576;
});
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__100742__auto____1 = (function (state_109560){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_109560);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e109577){if((e109577 instanceof Object)){
var ex__100745__auto__ = e109577;
var statearr_109578_109589 = state_109560;
(statearr_109578_109589[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_109560);

return cljs.core.cst$kw$recur;
} else {
throw e109577;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__109590 = state_109560;
state_109560 = G__109590;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__100742__auto__ = function(state_109560){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__100742__auto____1.call(this,state_109560);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__100742__auto____0;
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__100742__auto____1;
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_109579 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_109579[(6)] = c__100848__auto__);

return statearr_109579;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
fluree.db.util.xhttp.close_websocket = (function fluree$db$util$xhttp$close_websocket(ws){
return ws.close();
});
fluree.db.util.xhttp.try_socket = (function fluree$db$util$xhttp$try_socket(url,sub_chan,pub_chan,resp_chan,timeout,close_fn){
var ws = (new WebSocket(url));
var open_QMARK_ = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var timeout_chan = cljs.core.async.timeout(timeout);
(ws.binaryType = "arraybuffer");

(ws.onopen = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(open_QMARK_,true);
}));

(ws.onmessage = (function (e){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(sub_chan,e.data);
}));

(ws.onclose = (function (e){
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Websocket closed: ",e.reason,"Code: ",e.code], 0));

return (close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
}));

var c__100848__auto___109628 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_109616){
var state_val_109617 = (state_109616[(1)]);
if((state_val_109617 === (1))){
var inst_109595 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_109596 = [open_QMARK_,timeout_chan];
var inst_109597 = (new cljs.core.PersistentVector(null,2,(5),inst_109595,inst_109596,null));
var state_109616__$1 = state_109616;
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(state_109616__$1,(2),inst_109597,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$priority,true], 0));
} else {
if((state_val_109617 === (2))){
var inst_109599 = (state_109616[(2)]);
var inst_109600 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_109599,(0),null);
var inst_109601 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_109599,(1),null);
var inst_109602 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_109601,timeout_chan);
var state_109616__$1 = (function (){var statearr_109618 = state_109616;
(statearr_109618[(7)] = inst_109600);

return statearr_109618;
})();
if(inst_109602){
var statearr_109619_109629 = state_109616__$1;
(statearr_109619_109629[(1)] = (3));

} else {
var statearr_109620_109630 = state_109616__$1;
(statearr_109620_109630[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_109617 === (3))){
var inst_109604 = ["Timeout reached, unable to establish communication to server, which responded healthy: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)].join('');
var inst_109605 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_109606 = [(400),cljs.core.cst$kw$db_SLASH_connection_DASH_error];
var inst_109607 = cljs.core.PersistentHashMap.fromArrays(inst_109605,inst_109606);
var inst_109608 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_109604,inst_109607);
var inst_109609 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,inst_109608);
var inst_109610 = fluree.db.util.xhttp.close_websocket(ws);
var state_109616__$1 = (function (){var statearr_109621 = state_109616;
(statearr_109621[(8)] = inst_109609);

return statearr_109621;
})();
var statearr_109622_109631 = state_109616__$1;
(statearr_109622_109631[(2)] = inst_109610);

(statearr_109622_109631[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109617 === (4))){
var inst_109612 = fluree.db.util.xhttp.socket_publish_loop(ws,pub_chan);
var state_109616__$1 = state_109616;
var statearr_109623_109632 = state_109616__$1;
(statearr_109623_109632[(2)] = inst_109612);

(statearr_109623_109632[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109617 === (5))){
var inst_109614 = (state_109616[(2)]);
var state_109616__$1 = state_109616;
return cljs.core.async.impl.ioc_helpers.return_chan(state_109616__$1,inst_109614);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$try_socket_$_state_machine__100742__auto__ = null;
var fluree$db$util$xhttp$try_socket_$_state_machine__100742__auto____0 = (function (){
var statearr_109624 = [null,null,null,null,null,null,null,null,null];
(statearr_109624[(0)] = fluree$db$util$xhttp$try_socket_$_state_machine__100742__auto__);

(statearr_109624[(1)] = (1));

return statearr_109624;
});
var fluree$db$util$xhttp$try_socket_$_state_machine__100742__auto____1 = (function (state_109616){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_109616);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e109625){if((e109625 instanceof Object)){
var ex__100745__auto__ = e109625;
var statearr_109626_109633 = state_109616;
(statearr_109626_109633[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_109616);

return cljs.core.cst$kw$recur;
} else {
throw e109625;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__109634 = state_109616;
state_109616 = G__109634;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$util$xhttp$try_socket_$_state_machine__100742__auto__ = function(state_109616){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$try_socket_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$try_socket_$_state_machine__100742__auto____1.call(this,state_109616);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$try_socket_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$try_socket_$_state_machine__100742__auto____0;
fluree$db$util$xhttp$try_socket_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$try_socket_$_state_machine__100742__auto____1;
return fluree$db$util$xhttp$try_socket_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_109627 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_109627[(6)] = c__100848__auto___109628);

return statearr_109627;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));


return cljs.core.cst$kw$fluree$db$util$xhttp_SLASH_no_DASH_return;
});
