// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true}
goog.provide('fluree.db.storage.core');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.serde.protocol');
goog.require('fluree.db.flake');
goog.require('clojure.data.avl');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
/**
 * Returns truthy if the provided key exists in storage.
 */
fluree.db.storage.core.storage_exists_QMARK_ = (function fluree$db$storage$core$storage_exists_QMARK_(conn,key){
var storage_exists_fn = cljs.core.cst$kw$storage_DASH_exists.cljs$core$IFn$_invoke$arity$1(conn);
return (storage_exists_fn.cljs$core$IFn$_invoke$arity$1 ? storage_exists_fn.cljs$core$IFn$_invoke$arity$1(key) : storage_exists_fn.call(null,key));
});
/**
 * Reads raw bytes from storage based on provided key.
 *   Returns core async channel with eventual response
 */
fluree.db.storage.core.storage_read = (function fluree$db$storage$core$storage_read(conn,key){
var storage_read_fn = cljs.core.cst$kw$storage_DASH_read.cljs$core$IFn$_invoke$arity$1(conn);
return (storage_read_fn.cljs$core$IFn$_invoke$arity$1 ? storage_read_fn.cljs$core$IFn$_invoke$arity$1(key) : storage_read_fn.call(null,key));
});
/**
 * Writes raw bytes to storage based with provided key.
 */
fluree.db.storage.core.storage_write = (function fluree$db$storage$core$storage_write(conn,key,val){
var storage_write_fn = cljs.core.cst$kw$storage_DASH_write.cljs$core$IFn$_invoke$arity$1(conn);
return (storage_write_fn.cljs$core$IFn$_invoke$arity$2 ? storage_write_fn.cljs$core$IFn$_invoke$arity$2(key,val) : storage_write_fn.call(null,key,val));
});
/**
 * Returns serializer from connection.
 */
fluree.db.storage.core.serde = (function fluree$db$storage$core$serde(conn){
return cljs.core.cst$kw$serializer.cljs$core$IFn$_invoke$arity$1(conn);
});
fluree.db.storage.core.ledger_root_key = (function fluree$db$storage$core$ledger_root_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_root_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_garbage_key = (function fluree$db$storage$core$ledger_garbage_key(network,ledger_key,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_key),"_garbage_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join('');
});
fluree.db.storage.core.ledger_node_key = (function fluree$db$storage$core$ledger_node_key(network,ledger_id,idx_type,base_id,node_type){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_",cljs.core.name(idx_type),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(base_id),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_type)].join('');
});
fluree.db.storage.core.ledger_block_key = (function fluree$db$storage$core$ledger_block_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_block_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_block_file_path = (function fluree$db$storage$core$ledger_block_file_path(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"/block/",fluree.db.util.core.zero_pad(block,(15))].join('');
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block = (function fluree$db$storage$core$read_block(conn,network,ledger_id,block){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_106560){
var state_val_106561 = (state_106560[(1)]);
if((state_val_106561 === (1))){
var state_106560__$1 = state_106560;
var statearr_106562_106574 = state_106560__$1;
(statearr_106562_106574[(2)] = null);

(statearr_106562_106574[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106561 === (2))){
var inst_106558 = (state_106560[(2)]);
var state_106560__$1 = state_106560;
return cljs.core.async.impl.ioc_helpers.return_chan(state_106560__$1,inst_106558);
} else {
if((state_val_106561 === (3))){
var inst_106542 = (state_106560[(2)]);
var state_106560__$1 = state_106560;
var statearr_106563_106575 = state_106560__$1;
(statearr_106563_106575[(2)] = inst_106542);


cljs.core.async.impl.ioc_helpers.process_exception(state_106560__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_106561 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_106560,(3),Error,null,(2));
var inst_106546 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_106547 = fluree.db.storage.core.storage_read(conn,inst_106546);
var state_106560__$1 = state_106560;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_106560__$1,(5),inst_106547);
} else {
if((state_val_106561 === (5))){
var inst_106550 = (state_106560[(7)]);
var inst_106549 = (state_106560[(2)]);
var inst_106550__$1 = fluree.db.util.async.throw_err(inst_106549);
var state_106560__$1 = (function (){var statearr_106564 = state_106560;
(statearr_106564[(7)] = inst_106550__$1);

return statearr_106564;
})();
if(cljs.core.truth_(inst_106550__$1)){
var statearr_106565_106576 = state_106560__$1;
(statearr_106565_106576[(1)] = (6));

} else {
var statearr_106566_106577 = state_106560__$1;
(statearr_106566_106577[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_106561 === (6))){
var inst_106550 = (state_106560[(7)]);
var inst_106552 = fluree.db.storage.core.serde(conn);
var inst_106553 = fluree.db.serde.protocol._deserialize_block(inst_106552,inst_106550);
var state_106560__$1 = state_106560;
var statearr_106567_106578 = state_106560__$1;
(statearr_106567_106578[(2)] = inst_106553);

(statearr_106567_106578[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106561 === (7))){
var state_106560__$1 = state_106560;
var statearr_106568_106579 = state_106560__$1;
(statearr_106568_106579[(2)] = null);

(statearr_106568_106579[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106561 === (8))){
var inst_106556 = (state_106560[(2)]);
var state_106560__$1 = state_106560;
var statearr_106569_106580 = state_106560__$1;
(statearr_106569_106580[(2)] = inst_106556);


cljs.core.async.impl.ioc_helpers.process_exception(state_106560__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_$_state_machine__100742__auto__ = null;
var fluree$db$storage$core$read_block_$_state_machine__100742__auto____0 = (function (){
var statearr_106570 = [null,null,null,null,null,null,null,null];
(statearr_106570[(0)] = fluree$db$storage$core$read_block_$_state_machine__100742__auto__);

(statearr_106570[(1)] = (1));

return statearr_106570;
});
var fluree$db$storage$core$read_block_$_state_machine__100742__auto____1 = (function (state_106560){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_106560);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e106571){if((e106571 instanceof Object)){
var ex__100745__auto__ = e106571;
var statearr_106572_106581 = state_106560;
(statearr_106572_106581[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_106560);

return cljs.core.cst$kw$recur;
} else {
throw e106571;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__106582 = state_106560;
state_106560 = G__106582;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_$_state_machine__100742__auto__ = function(state_106560){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_$_state_machine__100742__auto____1.call(this,state_106560);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_$_state_machine__100742__auto____0;
fluree$db$storage$core$read_block_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_$_state_machine__100742__auto____1;
return fluree$db$storage$core$read_block_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_106573 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_106573[(6)] = c__100848__auto__);

return statearr_106573;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block_version = (function fluree$db$storage$core$read_block_version(conn,network,ledger_id,block,version){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_106602){
var state_val_106603 = (state_106602[(1)]);
if((state_val_106603 === (1))){
var state_106602__$1 = state_106602;
var statearr_106604_106616 = state_106602__$1;
(statearr_106604_106616[(2)] = null);

(statearr_106604_106616[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106603 === (2))){
var inst_106600 = (state_106602[(2)]);
var state_106602__$1 = state_106602;
return cljs.core.async.impl.ioc_helpers.return_chan(state_106602__$1,inst_106600);
} else {
if((state_val_106603 === (3))){
var inst_106583 = (state_106602[(2)]);
var state_106602__$1 = state_106602;
var statearr_106605_106617 = state_106602__$1;
(statearr_106605_106617[(2)] = inst_106583);


cljs.core.async.impl.ioc_helpers.process_exception(state_106602__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_106603 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_106602,(3),Error,null,(2));
var inst_106587 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_106588 = [inst_106587,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_106589 = fluree.db.storage.core.storage_read(conn,inst_106588);
var state_106602__$1 = state_106602;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_106602__$1,(5),inst_106589);
} else {
if((state_val_106603 === (5))){
var inst_106592 = (state_106602[(7)]);
var inst_106591 = (state_106602[(2)]);
var inst_106592__$1 = fluree.db.util.async.throw_err(inst_106591);
var state_106602__$1 = (function (){var statearr_106606 = state_106602;
(statearr_106606[(7)] = inst_106592__$1);

return statearr_106606;
})();
if(cljs.core.truth_(inst_106592__$1)){
var statearr_106607_106618 = state_106602__$1;
(statearr_106607_106618[(1)] = (6));

} else {
var statearr_106608_106619 = state_106602__$1;
(statearr_106608_106619[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_106603 === (6))){
var inst_106592 = (state_106602[(7)]);
var inst_106594 = fluree.db.storage.core.serde(conn);
var inst_106595 = fluree.db.serde.protocol._deserialize_block(inst_106594,inst_106592);
var state_106602__$1 = state_106602;
var statearr_106609_106620 = state_106602__$1;
(statearr_106609_106620[(2)] = inst_106595);

(statearr_106609_106620[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106603 === (7))){
var state_106602__$1 = state_106602;
var statearr_106610_106621 = state_106602__$1;
(statearr_106610_106621[(2)] = null);

(statearr_106610_106621[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106603 === (8))){
var inst_106598 = (state_106602[(2)]);
var state_106602__$1 = state_106602;
var statearr_106611_106622 = state_106602__$1;
(statearr_106611_106622[(2)] = inst_106598);


cljs.core.async.impl.ioc_helpers.process_exception(state_106602__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_version_$_state_machine__100742__auto__ = null;
var fluree$db$storage$core$read_block_version_$_state_machine__100742__auto____0 = (function (){
var statearr_106612 = [null,null,null,null,null,null,null,null];
(statearr_106612[(0)] = fluree$db$storage$core$read_block_version_$_state_machine__100742__auto__);

(statearr_106612[(1)] = (1));

return statearr_106612;
});
var fluree$db$storage$core$read_block_version_$_state_machine__100742__auto____1 = (function (state_106602){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_106602);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e106613){if((e106613 instanceof Object)){
var ex__100745__auto__ = e106613;
var statearr_106614_106623 = state_106602;
(statearr_106614_106623[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_106602);

return cljs.core.cst$kw$recur;
} else {
throw e106613;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__106624 = state_106602;
state_106602 = G__106624;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_version_$_state_machine__100742__auto__ = function(state_106602){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_version_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_version_$_state_machine__100742__auto____1.call(this,state_106602);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_version_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_version_$_state_machine__100742__auto____0;
fluree$db$storage$core$read_block_version_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_version_$_state_machine__100742__auto____1;
return fluree$db$storage$core$read_block_version_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_106615 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_106615[(6)] = c__100848__auto__);

return statearr_106615;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block_version = (function fluree$db$storage$core$write_block_version(conn,network,dbid,block_data,version){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_106645){
var state_val_106646 = (state_106645[(1)]);
if((state_val_106646 === (1))){
var state_106645__$1 = state_106645;
var statearr_106647_106654 = state_106645__$1;
(statearr_106647_106654[(2)] = null);

(statearr_106647_106654[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106646 === (2))){
var inst_106643 = (state_106645[(2)]);
var state_106645__$1 = state_106645;
return cljs.core.async.impl.ioc_helpers.return_chan(state_106645__$1,inst_106643);
} else {
if((state_val_106646 === (3))){
var inst_106625 = (state_106645[(2)]);
var state_106645__$1 = state_106645;
var statearr_106648_106655 = state_106645__$1;
(statearr_106648_106655[(2)] = inst_106625);


cljs.core.async.impl.ioc_helpers.process_exception(state_106645__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_106646 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_106645,(3),Error,null,(2));
var inst_106629 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_106630 = [cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$flakes];
var inst_106631 = (new cljs.core.PersistentVector(null,3,(5),inst_106629,inst_106630,null));
var inst_106632 = cljs.core.select_keys(block_data,inst_106631);
var inst_106633 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_106632);
var inst_106634 = fluree.db.storage.core.ledger_block_key(network,dbid,inst_106633);
var inst_106635 = [inst_106634,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_106636 = fluree.db.storage.core.serde(conn);
var inst_106637 = fluree.db.serde.protocol._serialize_block(inst_106636,inst_106632);
var inst_106638 = fluree.db.storage.core.storage_write(conn,inst_106635,inst_106637);
var state_106645__$1 = state_106645;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_106645__$1,(5),inst_106638);
} else {
if((state_val_106646 === (5))){
var inst_106640 = (state_106645[(2)]);
var inst_106641 = fluree.db.util.async.throw_err(inst_106640);
var state_106645__$1 = state_106645;
var statearr_106649_106656 = state_106645__$1;
(statearr_106649_106656[(2)] = inst_106641);


cljs.core.async.impl.ioc_helpers.process_exception(state_106645__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_version_$_state_machine__100742__auto__ = null;
var fluree$db$storage$core$write_block_version_$_state_machine__100742__auto____0 = (function (){
var statearr_106650 = [null,null,null,null,null,null,null];
(statearr_106650[(0)] = fluree$db$storage$core$write_block_version_$_state_machine__100742__auto__);

(statearr_106650[(1)] = (1));

return statearr_106650;
});
var fluree$db$storage$core$write_block_version_$_state_machine__100742__auto____1 = (function (state_106645){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_106645);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e106651){if((e106651 instanceof Object)){
var ex__100745__auto__ = e106651;
var statearr_106652_106657 = state_106645;
(statearr_106652_106657[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_106645);

return cljs.core.cst$kw$recur;
} else {
throw e106651;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__106658 = state_106645;
state_106645 = G__106658;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_version_$_state_machine__100742__auto__ = function(state_106645){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_version_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_version_$_state_machine__100742__auto____1.call(this,state_106645);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_version_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_version_$_state_machine__100742__auto____0;
fluree$db$storage$core$write_block_version_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_version_$_state_machine__100742__auto____1;
return fluree$db$storage$core$write_block_version_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_106653 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_106653[(6)] = c__100848__auto__);

return statearr_106653;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block = (function fluree$db$storage$core$write_block(conn,network,dbid,block_data){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_106678){
var state_val_106679 = (state_106678[(1)]);
if((state_val_106679 === (1))){
var state_106678__$1 = state_106678;
var statearr_106680_106687 = state_106678__$1;
(statearr_106680_106687[(2)] = null);

(statearr_106680_106687[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106679 === (2))){
var inst_106676 = (state_106678[(2)]);
var state_106678__$1 = state_106678;
return cljs.core.async.impl.ioc_helpers.return_chan(state_106678__$1,inst_106676);
} else {
if((state_val_106679 === (3))){
var inst_106659 = (state_106678[(2)]);
var state_106678__$1 = state_106678;
var statearr_106681_106688 = state_106678__$1;
(statearr_106681_106688[(2)] = inst_106659);


cljs.core.async.impl.ioc_helpers.process_exception(state_106678__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_106679 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_106678,(3),Error,null,(2));
var inst_106663 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_106664 = [cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$flakes];
var inst_106665 = (new cljs.core.PersistentVector(null,3,(5),inst_106663,inst_106664,null));
var inst_106666 = cljs.core.select_keys(block_data,inst_106665);
var inst_106667 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_106666);
var inst_106668 = fluree.db.storage.core.ledger_block_key(network,dbid,inst_106667);
var inst_106669 = fluree.db.storage.core.serde(conn);
var inst_106670 = fluree.db.serde.protocol._serialize_block(inst_106669,inst_106666);
var inst_106671 = fluree.db.storage.core.storage_write(conn,inst_106668,inst_106670);
var state_106678__$1 = state_106678;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_106678__$1,(5),inst_106671);
} else {
if((state_val_106679 === (5))){
var inst_106673 = (state_106678[(2)]);
var inst_106674 = fluree.db.util.async.throw_err(inst_106673);
var state_106678__$1 = state_106678;
var statearr_106682_106689 = state_106678__$1;
(statearr_106682_106689[(2)] = inst_106674);


cljs.core.async.impl.ioc_helpers.process_exception(state_106678__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_$_state_machine__100742__auto__ = null;
var fluree$db$storage$core$write_block_$_state_machine__100742__auto____0 = (function (){
var statearr_106683 = [null,null,null,null,null,null,null];
(statearr_106683[(0)] = fluree$db$storage$core$write_block_$_state_machine__100742__auto__);

(statearr_106683[(1)] = (1));

return statearr_106683;
});
var fluree$db$storage$core$write_block_$_state_machine__100742__auto____1 = (function (state_106678){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_106678);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e106684){if((e106684 instanceof Object)){
var ex__100745__auto__ = e106684;
var statearr_106685_106690 = state_106678;
(statearr_106685_106690[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_106678);

return cljs.core.cst$kw$recur;
} else {
throw e106684;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__106691 = state_106678;
state_106678 = G__106691;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_$_state_machine__100742__auto__ = function(state_106678){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_$_state_machine__100742__auto____1.call(this,state_106678);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_$_state_machine__100742__auto____0;
fluree$db$storage$core$write_block_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_$_state_machine__100742__auto____1;
return fluree$db$storage$core$write_block_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_106686 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_106686[(6)] = c__100848__auto__);

return statearr_106686;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
/**
 * Given a child, unresolved node, extracts just the data that will go into storage.
 */
fluree.db.storage.core.child_data = (function fluree$db$storage$core$child_data(child){
return cljs.core.select_keys(child,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$id,cljs.core.cst$kw$leaf,cljs.core.cst$kw$first,cljs.core.cst$kw$rhs,cljs.core.cst$kw$size], null));
});
fluree.db.storage.core.write_history = (function fluree$db$storage$core$write_history(conn,history,his_key,next_his_key){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_106708){
var state_val_106709 = (state_106708[(1)]);
if((state_val_106709 === (1))){
var state_106708__$1 = state_106708;
var statearr_106710_106717 = state_106708__$1;
(statearr_106710_106717[(2)] = null);

(statearr_106710_106717[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106709 === (2))){
var inst_106706 = (state_106708[(2)]);
var state_106708__$1 = state_106708;
return cljs.core.async.impl.ioc_helpers.return_chan(state_106708__$1,inst_106706);
} else {
if((state_val_106709 === (3))){
var inst_106692 = (state_106708[(2)]);
var state_106708__$1 = state_106708;
var statearr_106711_106718 = state_106708__$1;
(statearr_106711_106718[(2)] = inst_106692);


cljs.core.async.impl.ioc_helpers.process_exception(state_106708__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_106709 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_106708,(3),Error,null,(2));
var inst_106696 = [cljs.core.cst$kw$flakes,cljs.core.cst$kw$his];
var inst_106697 = [history,next_his_key];
var inst_106698 = cljs.core.PersistentHashMap.fromArrays(inst_106696,inst_106697);
var inst_106699 = fluree.db.storage.core.serde(conn);
var inst_106700 = fluree.db.serde.protocol._serialize_leaf(inst_106699,inst_106698);
var inst_106701 = fluree.db.storage.core.storage_write(conn,his_key,inst_106700);
var state_106708__$1 = state_106708;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_106708__$1,(5),inst_106701);
} else {
if((state_val_106709 === (5))){
var inst_106703 = (state_106708[(2)]);
var inst_106704 = fluree.db.util.async.throw_err(inst_106703);
var state_106708__$1 = state_106708;
var statearr_106712_106719 = state_106708__$1;
(statearr_106712_106719[(2)] = inst_106704);


cljs.core.async.impl.ioc_helpers.process_exception(state_106708__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_history_$_state_machine__100742__auto__ = null;
var fluree$db$storage$core$write_history_$_state_machine__100742__auto____0 = (function (){
var statearr_106713 = [null,null,null,null,null,null,null];
(statearr_106713[(0)] = fluree$db$storage$core$write_history_$_state_machine__100742__auto__);

(statearr_106713[(1)] = (1));

return statearr_106713;
});
var fluree$db$storage$core$write_history_$_state_machine__100742__auto____1 = (function (state_106708){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_106708);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e106714){if((e106714 instanceof Object)){
var ex__100745__auto__ = e106714;
var statearr_106715_106720 = state_106708;
(statearr_106715_106720[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_106708);

return cljs.core.cst$kw$recur;
} else {
throw e106714;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__106721 = state_106708;
state_106708 = G__106721;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$storage$core$write_history_$_state_machine__100742__auto__ = function(state_106708){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_history_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_history_$_state_machine__100742__auto____1.call(this,state_106708);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_history_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_history_$_state_machine__100742__auto____0;
fluree$db$storage$core$write_history_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_history_$_state_machine__100742__auto____1;
return fluree$db$storage$core$write_history_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_106716 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_106716[(6)] = c__100848__auto__);

return statearr_106716;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
/**
 * Writes a leaf plus its history.
 * 
 *   Writes history first, and only on successful history write then writes leaf.
 * 
 *   Returns leaf's key
 */
fluree.db.storage.core.write_leaf = (function fluree$db$storage$core$write_leaf(conn,network,dbid,idx_type,id,flakes,history){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_106744){
var state_val_106745 = (state_106744[(1)]);
if((state_val_106745 === (1))){
var state_106744__$1 = state_106744;
var statearr_106746_106756 = state_106744__$1;
(statearr_106746_106756[(2)] = null);

(statearr_106746_106756[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106745 === (2))){
var inst_106742 = (state_106744[(2)]);
var state_106744__$1 = state_106744;
return cljs.core.async.impl.ioc_helpers.return_chan(state_106744__$1,inst_106742);
} else {
if((state_val_106745 === (3))){
var inst_106722 = (state_106744[(2)]);
var state_106744__$1 = state_106744;
var statearr_106747_106757 = state_106744__$1;
(statearr_106747_106757[(2)] = inst_106722);


cljs.core.async.impl.ioc_helpers.process_exception(state_106744__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_106745 === (4))){
var inst_106726 = (state_106744[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_106744,(3),Error,null,(2));
var inst_106726__$1 = fluree.db.storage.core.ledger_node_key(network,dbid,idx_type,id,"l");
var inst_106727 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_106726__$1),"-his"].join('');
var inst_106728 = [cljs.core.cst$kw$flakes,cljs.core.cst$kw$his];
var inst_106729 = [flakes,inst_106727];
var inst_106730 = cljs.core.PersistentHashMap.fromArrays(inst_106728,inst_106729);
var inst_106731 = fluree.db.storage.core.serde(conn);
var inst_106732 = fluree.db.serde.protocol._serialize_leaf(inst_106731,inst_106730);
var inst_106733 = fluree.db.storage.core.write_history(conn,history,inst_106727,null);
var inst_106734 = fluree.db.storage.core.storage_write(conn,inst_106726__$1,inst_106732);
var state_106744__$1 = (function (){var statearr_106748 = state_106744;
(statearr_106748[(8)] = inst_106734);

(statearr_106748[(7)] = inst_106726__$1);

return statearr_106748;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_106744__$1,(5),inst_106733);
} else {
if((state_val_106745 === (5))){
var inst_106734 = (state_106744[(8)]);
var inst_106736 = (state_106744[(2)]);
var inst_106737 = fluree.db.util.async.throw_err(inst_106736);
var state_106744__$1 = (function (){var statearr_106749 = state_106744;
(statearr_106749[(9)] = inst_106737);

return statearr_106749;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_106744__$1,(6),inst_106734);
} else {
if((state_val_106745 === (6))){
var inst_106726 = (state_106744[(7)]);
var inst_106739 = (state_106744[(2)]);
var inst_106740 = fluree.db.util.async.throw_err(inst_106739);
var state_106744__$1 = (function (){var statearr_106750 = state_106744;
(statearr_106750[(10)] = inst_106740);

return statearr_106750;
})();
var statearr_106751_106758 = state_106744__$1;
(statearr_106751_106758[(2)] = inst_106726);


cljs.core.async.impl.ioc_helpers.process_exception(state_106744__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_leaf_$_state_machine__100742__auto__ = null;
var fluree$db$storage$core$write_leaf_$_state_machine__100742__auto____0 = (function (){
var statearr_106752 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_106752[(0)] = fluree$db$storage$core$write_leaf_$_state_machine__100742__auto__);

(statearr_106752[(1)] = (1));

return statearr_106752;
});
var fluree$db$storage$core$write_leaf_$_state_machine__100742__auto____1 = (function (state_106744){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_106744);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e106753){if((e106753 instanceof Object)){
var ex__100745__auto__ = e106753;
var statearr_106754_106759 = state_106744;
(statearr_106754_106759[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_106744);

return cljs.core.cst$kw$recur;
} else {
throw e106753;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__106760 = state_106744;
state_106744 = G__106760;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$storage$core$write_leaf_$_state_machine__100742__auto__ = function(state_106744){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_leaf_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_leaf_$_state_machine__100742__auto____1.call(this,state_106744);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_leaf_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_leaf_$_state_machine__100742__auto____0;
fluree$db$storage$core$write_leaf_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_leaf_$_state_machine__100742__auto____1;
return fluree$db$storage$core$write_leaf_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_106755 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_106755[(6)] = c__100848__auto__);

return statearr_106755;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
/**
 * Serializes final data for branch and writes it to provided key
 */
fluree.db.storage.core.write_branch_data = (function fluree$db$storage$core$write_branch_data(conn,key,data){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_106774){
var state_val_106775 = (state_106774[(1)]);
if((state_val_106775 === (1))){
var state_106774__$1 = state_106774;
var statearr_106776_106784 = state_106774__$1;
(statearr_106776_106784[(2)] = null);

(statearr_106776_106784[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106775 === (2))){
var inst_106772 = (state_106774[(2)]);
var state_106774__$1 = state_106774;
return cljs.core.async.impl.ioc_helpers.return_chan(state_106774__$1,inst_106772);
} else {
if((state_val_106775 === (3))){
var inst_106761 = (state_106774[(2)]);
var state_106774__$1 = state_106774;
var statearr_106777_106785 = state_106774__$1;
(statearr_106777_106785[(2)] = inst_106761);


cljs.core.async.impl.ioc_helpers.process_exception(state_106774__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_106775 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_106774,(3),Error,null,(2));
var inst_106765 = fluree.db.storage.core.serde(conn);
var inst_106766 = fluree.db.serde.protocol._serialize_branch(inst_106765,data);
var inst_106767 = fluree.db.storage.core.storage_write(conn,key,inst_106766);
var state_106774__$1 = state_106774;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_106774__$1,(5),inst_106767);
} else {
if((state_val_106775 === (5))){
var inst_106769 = (state_106774[(2)]);
var inst_106770 = fluree.db.util.async.throw_err(inst_106769);
var state_106774__$1 = (function (){var statearr_106778 = state_106774;
(statearr_106778[(7)] = inst_106770);

return statearr_106778;
})();
var statearr_106779_106786 = state_106774__$1;
(statearr_106779_106786[(2)] = key);


cljs.core.async.impl.ioc_helpers.process_exception(state_106774__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_branch_data_$_state_machine__100742__auto__ = null;
var fluree$db$storage$core$write_branch_data_$_state_machine__100742__auto____0 = (function (){
var statearr_106780 = [null,null,null,null,null,null,null,null];
(statearr_106780[(0)] = fluree$db$storage$core$write_branch_data_$_state_machine__100742__auto__);

(statearr_106780[(1)] = (1));

return statearr_106780;
});
var fluree$db$storage$core$write_branch_data_$_state_machine__100742__auto____1 = (function (state_106774){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_106774);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e106781){if((e106781 instanceof Object)){
var ex__100745__auto__ = e106781;
var statearr_106782_106787 = state_106774;
(statearr_106782_106787[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_106774);

return cljs.core.cst$kw$recur;
} else {
throw e106781;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__106788 = state_106774;
state_106774 = G__106788;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$storage$core$write_branch_data_$_state_machine__100742__auto__ = function(state_106774){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_branch_data_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_branch_data_$_state_machine__100742__auto____1.call(this,state_106774);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_branch_data_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_branch_data_$_state_machine__100742__auto____0;
fluree$db$storage$core$write_branch_data_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_branch_data_$_state_machine__100742__auto____1;
return fluree$db$storage$core$write_branch_data_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_106783 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_106783[(6)] = c__100848__auto__);

return statearr_106783;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
/**
 * Returns core async channel with index key
 */
fluree.db.storage.core.write_branch = (function fluree$db$storage$core$write_branch(conn,network,dbid,idx_type,id,children){
var branch_key = fluree.db.storage.core.ledger_node_key(network,dbid,idx_type,id,"b");
var child_vals = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__106789_SHARP_){
return fluree.db.storage.core.child_data(cljs.core.val(p1__106789_SHARP_));
}),children);
var rhs = cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(cljs.core.last(child_vals));
var data = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$children,child_vals,cljs.core.cst$kw$rhs,rhs], null);
return fluree.db.storage.core.write_branch_data(conn,branch_key,data);
});
/**
 * Writes garbage record out for latest index.
 */
fluree.db.storage.core.write_garbage = (function fluree$db$storage$core$write_garbage(db,p__106790){
var map__106791 = p__106790;
var map__106791__$1 = (((((!((map__106791 == null))))?(((((map__106791.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__106791.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__106791):map__106791);
var progress = map__106791__$1;
var garbage = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106791__$1,cljs.core.cst$kw$garbage);
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_106836){
var state_val_106837 = (state_106836[(1)]);
if((state_val_106837 === (7))){
var inst_106813 = (state_106836[(2)]);
var state_106836__$1 = state_106836;
if(cljs.core.truth_(inst_106813)){
var statearr_106838_106859 = state_106836__$1;
(statearr_106838_106859[(1)] = (11));

} else {
var statearr_106839_106860 = state_106836__$1;
(statearr_106839_106860[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_106837 === (1))){
var state_106836__$1 = state_106836;
var statearr_106840_106861 = state_106836__$1;
(statearr_106840_106861[(2)] = null);

(statearr_106840_106861[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106837 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_106836,(3),Error,null,(2));
var inst_106799 = (db == null);
var inst_106800 = cljs.core.not(inst_106799);
var state_106836__$1 = state_106836;
if(inst_106800){
var statearr_106841_106862 = state_106836__$1;
(statearr_106841_106862[(1)] = (5));

} else {
var statearr_106842_106863 = state_106836__$1;
(statearr_106842_106863[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_106837 === (13))){
var inst_106823 = (state_106836[(7)]);
var inst_106818 = (state_106836[(2)]);
var inst_106819 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_106818,cljs.core.cst$kw$conn);
var inst_106820 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_106818,cljs.core.cst$kw$network);
var inst_106821 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_106818,cljs.core.cst$kw$dbid);
var inst_106822 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_106818,cljs.core.cst$kw$block);
var inst_106823__$1 = fluree.db.storage.core.ledger_garbage_key(inst_106820,inst_106821,inst_106822);
var inst_106824 = [cljs.core.cst$kw$dbid,cljs.core.cst$kw$block,cljs.core.cst$kw$garbage];
var inst_106825 = [inst_106821,inst_106822,garbage];
var inst_106826 = cljs.core.PersistentHashMap.fromArrays(inst_106824,inst_106825);
var inst_106827 = fluree.db.storage.core.serde(inst_106819);
var inst_106828 = fluree.db.serde.protocol._serialize_garbage(inst_106827,inst_106826);
var inst_106829 = fluree.db.storage.core.storage_write(inst_106819,inst_106823__$1,inst_106828);
var state_106836__$1 = (function (){var statearr_106843 = state_106836;
(statearr_106843[(7)] = inst_106823__$1);

return statearr_106843;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_106836__$1,(14),inst_106829);
} else {
if((state_val_106837 === (6))){
var state_106836__$1 = state_106836;
var statearr_106844_106864 = state_106836__$1;
(statearr_106844_106864[(2)] = false);

(statearr_106844_106864[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106837 === (3))){
var inst_106793 = (state_106836[(2)]);
var state_106836__$1 = state_106836;
var statearr_106845_106865 = state_106836__$1;
(statearr_106845_106865[(2)] = inst_106793);


cljs.core.async.impl.ioc_helpers.process_exception(state_106836__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_106837 === (12))){
var state_106836__$1 = state_106836;
var statearr_106846_106866 = state_106836__$1;
(statearr_106846_106866[(2)] = db);

(statearr_106846_106866[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106837 === (2))){
var inst_106834 = (state_106836[(2)]);
var state_106836__$1 = state_106836;
return cljs.core.async.impl.ioc_helpers.return_chan(state_106836__$1,inst_106834);
} else {
if((state_val_106837 === (11))){
var inst_106815 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,db);
var state_106836__$1 = state_106836;
var statearr_106847_106867 = state_106836__$1;
(statearr_106847_106867[(2)] = inst_106815);

(statearr_106847_106867[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106837 === (9))){
var state_106836__$1 = state_106836;
var statearr_106848_106868 = state_106836__$1;
(statearr_106848_106868[(2)] = false);

(statearr_106848_106868[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106837 === (5))){
var inst_106802 = db.cljs$lang$protocol_mask$partition0$;
var inst_106803 = (inst_106802 & (64));
var inst_106804 = db.cljs$core$ISeq$;
var inst_106805 = (cljs.core.PROTOCOL_SENTINEL === inst_106804);
var inst_106806 = ((inst_106803) || (inst_106805));
var state_106836__$1 = state_106836;
if(cljs.core.truth_(inst_106806)){
var statearr_106849_106869 = state_106836__$1;
(statearr_106849_106869[(1)] = (8));

} else {
var statearr_106850_106870 = state_106836__$1;
(statearr_106850_106870[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_106837 === (14))){
var inst_106823 = (state_106836[(7)]);
var inst_106831 = (state_106836[(2)]);
var inst_106832 = fluree.db.util.async.throw_err(inst_106831);
var state_106836__$1 = (function (){var statearr_106851 = state_106836;
(statearr_106851[(8)] = inst_106832);

return statearr_106851;
})();
var statearr_106852_106871 = state_106836__$1;
(statearr_106852_106871[(2)] = inst_106823);


cljs.core.async.impl.ioc_helpers.process_exception(state_106836__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_106837 === (10))){
var inst_106810 = (state_106836[(2)]);
var state_106836__$1 = state_106836;
var statearr_106853_106872 = state_106836__$1;
(statearr_106853_106872[(2)] = inst_106810);

(statearr_106853_106872[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106837 === (8))){
var state_106836__$1 = state_106836;
var statearr_106854_106873 = state_106836__$1;
(statearr_106854_106873[(2)] = true);

(statearr_106854_106873[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_garbage_$_state_machine__100742__auto__ = null;
var fluree$db$storage$core$write_garbage_$_state_machine__100742__auto____0 = (function (){
var statearr_106855 = [null,null,null,null,null,null,null,null,null];
(statearr_106855[(0)] = fluree$db$storage$core$write_garbage_$_state_machine__100742__auto__);

(statearr_106855[(1)] = (1));

return statearr_106855;
});
var fluree$db$storage$core$write_garbage_$_state_machine__100742__auto____1 = (function (state_106836){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_106836);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e106856){if((e106856 instanceof Object)){
var ex__100745__auto__ = e106856;
var statearr_106857_106874 = state_106836;
(statearr_106857_106874[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_106836);

return cljs.core.cst$kw$recur;
} else {
throw e106856;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__106875 = state_106836;
state_106836 = G__106875;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$storage$core$write_garbage_$_state_machine__100742__auto__ = function(state_106836){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_garbage_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_garbage_$_state_machine__100742__auto____1.call(this,state_106836);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_garbage_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_garbage_$_state_machine__100742__auto____0;
fluree$db$storage$core$write_garbage_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_garbage_$_state_machine__100742__auto____1;
return fluree$db$storage$core$write_garbage_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_106858 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_106858[(6)] = c__100848__auto__);

return statearr_106858;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
fluree.db.storage.core.write_db_root = (function fluree$db$storage$core$write_db_root(var_args){
var G__106877 = arguments.length;
switch (G__106877) {
case 1:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1 = (function (db){
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2(db,null);
}));

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2 = (function (db,custom_ecount){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_106948){
var state_val_106949 = (state_106948[(1)]);
if((state_val_106949 === (7))){
var inst_106898 = (state_106948[(2)]);
var state_106948__$1 = state_106948;
if(cljs.core.truth_(inst_106898)){
var statearr_106950_106981 = state_106948__$1;
(statearr_106950_106981[(1)] = (11));

} else {
var statearr_106951_106982 = state_106948__$1;
(statearr_106951_106982[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_106949 === (20))){
var inst_106917 = (state_106948[(7)]);
var inst_106943 = (state_106948[(2)]);
var inst_106944 = fluree.db.util.async.throw_err(inst_106943);
var state_106948__$1 = (function (){var statearr_106952 = state_106948;
(statearr_106952[(8)] = inst_106944);

return statearr_106952;
})();
var statearr_106953_106983 = state_106948__$1;
(statearr_106953_106983[(2)] = inst_106917);


cljs.core.async.impl.ioc_helpers.process_exception(state_106948__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_106949 === (1))){
var state_106948__$1 = state_106948;
var statearr_106954_106984 = state_106948__$1;
(statearr_106954_106984[(2)] = null);

(statearr_106954_106984[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106949 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_106948,(3),Error,null,(2));
var inst_106884 = (db == null);
var inst_106885 = cljs.core.not(inst_106884);
var state_106948__$1 = state_106948;
if(inst_106885){
var statearr_106955_106985 = state_106948__$1;
(statearr_106955_106985[(1)] = (5));

} else {
var statearr_106956_106986 = state_106948__$1;
(statearr_106956_106986[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_106949 === (15))){
var state_106948__$1 = state_106948;
var statearr_106957_106987 = state_106948__$1;
(statearr_106957_106987[(2)] = (0));

(statearr_106957_106987[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106949 === (13))){
var inst_106908 = (state_106948[(9)]);
var inst_106910 = (state_106948[(10)]);
var inst_106920 = (state_106948[(11)]);
var inst_106912 = (state_106948[(12)]);
var inst_106903 = (state_106948[(2)]);
var inst_106904 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_106903,cljs.core.cst$kw$network);
var inst_106905 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_106903,cljs.core.cst$kw$t);
var inst_106906 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_106903,cljs.core.cst$kw$fork);
var inst_106907 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_106903,cljs.core.cst$kw$spot);
var inst_106908__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_106903,cljs.core.cst$kw$stats);
var inst_106909 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_106903,cljs.core.cst$kw$conn);
var inst_106910__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_106903,cljs.core.cst$kw$block);
var inst_106911 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_106903,cljs.core.cst$kw$psot);
var inst_106912__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_106903,cljs.core.cst$kw$dbid);
var inst_106913 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_106903,cljs.core.cst$kw$ecount);
var inst_106914 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_106903,cljs.core.cst$kw$opst);
var inst_106915 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_106903,cljs.core.cst$kw$fork_DASH_block);
var inst_106916 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_106903,cljs.core.cst$kw$post);
var inst_106917 = fluree.db.storage.core.ledger_root_key(inst_106904,inst_106912__$1,inst_106910__$1);
var inst_106918 = [cljs.core.cst$kw$block,cljs.core.cst$kw$psot,cljs.core.cst$kw$dbid,cljs.core.cst$kw$prevIndex,cljs.core.cst$kw$ecount,cljs.core.cst$kw$opst,cljs.core.cst$kw$post,cljs.core.cst$kw$t,cljs.core.cst$kw$timestamp,cljs.core.cst$kw$fork,cljs.core.cst$kw$forkBlock,cljs.core.cst$kw$stats,cljs.core.cst$kw$spot];
var inst_106919 = fluree.db.storage.core.child_data(inst_106911);
var inst_106920__$1 = cljs.core.cst$kw$indexed.cljs$core$IFn$_invoke$arity$1(inst_106908__$1);
var state_106948__$1 = (function (){var statearr_106958 = state_106948;
(statearr_106958[(9)] = inst_106908__$1);

(statearr_106958[(10)] = inst_106910__$1);

(statearr_106958[(11)] = inst_106920__$1);

(statearr_106958[(13)] = inst_106907);

(statearr_106958[(14)] = inst_106905);

(statearr_106958[(15)] = inst_106914);

(statearr_106958[(16)] = inst_106916);

(statearr_106958[(17)] = inst_106915);

(statearr_106958[(18)] = inst_106909);

(statearr_106958[(12)] = inst_106912__$1);

(statearr_106958[(7)] = inst_106917);

(statearr_106958[(19)] = inst_106918);

(statearr_106958[(20)] = inst_106906);

(statearr_106958[(21)] = inst_106919);

(statearr_106958[(22)] = inst_106913);

return statearr_106958;
})();
if(cljs.core.truth_(inst_106920__$1)){
var statearr_106959_106988 = state_106948__$1;
(statearr_106959_106988[(1)] = (14));

} else {
var statearr_106960_106989 = state_106948__$1;
(statearr_106960_106989[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_106949 === (6))){
var state_106948__$1 = state_106948;
var statearr_106961_106990 = state_106948__$1;
(statearr_106961_106990[(2)] = false);

(statearr_106961_106990[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106949 === (17))){
var state_106948__$1 = state_106948;
var statearr_106962_106991 = state_106948__$1;
(statearr_106962_106991[(2)] = custom_ecount);

(statearr_106962_106991[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106949 === (3))){
var inst_106878 = (state_106948[(2)]);
var state_106948__$1 = state_106948;
var statearr_106963_106992 = state_106948__$1;
(statearr_106963_106992[(2)] = inst_106878);


cljs.core.async.impl.ioc_helpers.process_exception(state_106948__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_106949 === (12))){
var state_106948__$1 = state_106948;
var statearr_106964_106993 = state_106948__$1;
(statearr_106964_106993[(2)] = db);

(statearr_106964_106993[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106949 === (2))){
var inst_106946 = (state_106948[(2)]);
var state_106948__$1 = state_106948;
return cljs.core.async.impl.ioc_helpers.return_chan(state_106948__$1,inst_106946);
} else {
if((state_val_106949 === (19))){
var inst_106908 = (state_106948[(9)]);
var inst_106910 = (state_106948[(10)]);
var inst_106907 = (state_106948[(13)]);
var inst_106905 = (state_106948[(14)]);
var inst_106914 = (state_106948[(15)]);
var inst_106916 = (state_106948[(16)]);
var inst_106924 = (state_106948[(23)]);
var inst_106915 = (state_106948[(17)]);
var inst_106909 = (state_106948[(18)]);
var inst_106912 = (state_106948[(12)]);
var inst_106917 = (state_106948[(7)]);
var inst_106918 = (state_106948[(19)]);
var inst_106906 = (state_106948[(20)]);
var inst_106919 = (state_106948[(21)]);
var inst_106928 = (state_106948[(2)]);
var inst_106929 = fluree.db.storage.core.child_data(inst_106914);
var inst_106930 = fluree.db.storage.core.child_data(inst_106916);
var inst_106931 = fluree.db.util.core.current_time_millis();
var inst_106932 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_106933 = [cljs.core.cst$kw$flakes,cljs.core.cst$kw$size];
var inst_106934 = (new cljs.core.PersistentVector(null,2,(5),inst_106932,inst_106933,null));
var inst_106935 = cljs.core.select_keys(inst_106908,inst_106934);
var inst_106936 = fluree.db.storage.core.child_data(inst_106907);
var inst_106937 = [inst_106910,inst_106919,inst_106912,inst_106924,inst_106928,inst_106929,inst_106930,inst_106905,inst_106931,inst_106906,inst_106915,inst_106935,inst_106936];
var inst_106938 = cljs.core.PersistentHashMap.fromArrays(inst_106918,inst_106937);
var inst_106939 = fluree.db.storage.core.serde(inst_106909);
var inst_106940 = fluree.db.serde.protocol._serialize_db_root(inst_106939,inst_106938);
var inst_106941 = fluree.db.storage.core.storage_write(inst_106909,inst_106917,inst_106940);
var state_106948__$1 = state_106948;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_106948__$1,(20),inst_106941);
} else {
if((state_val_106949 === (11))){
var inst_106900 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,db);
var state_106948__$1 = state_106948;
var statearr_106965_106994 = state_106948__$1;
(statearr_106965_106994[(2)] = inst_106900);

(statearr_106965_106994[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106949 === (9))){
var state_106948__$1 = state_106948;
var statearr_106966_106995 = state_106948__$1;
(statearr_106966_106995[(2)] = false);

(statearr_106966_106995[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106949 === (5))){
var inst_106887 = db.cljs$lang$protocol_mask$partition0$;
var inst_106888 = (inst_106887 & (64));
var inst_106889 = db.cljs$core$ISeq$;
var inst_106890 = (cljs.core.PROTOCOL_SENTINEL === inst_106889);
var inst_106891 = ((inst_106888) || (inst_106890));
var state_106948__$1 = state_106948;
if(cljs.core.truth_(inst_106891)){
var statearr_106967_106996 = state_106948__$1;
(statearr_106967_106996[(1)] = (8));

} else {
var statearr_106968_106997 = state_106948__$1;
(statearr_106968_106997[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_106949 === (14))){
var inst_106920 = (state_106948[(11)]);
var state_106948__$1 = state_106948;
var statearr_106969_106998 = state_106948__$1;
(statearr_106969_106998[(2)] = inst_106920);

(statearr_106969_106998[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106949 === (16))){
var inst_106924 = (state_106948[(2)]);
var state_106948__$1 = (function (){var statearr_106970 = state_106948;
(statearr_106970[(23)] = inst_106924);

return statearr_106970;
})();
if(cljs.core.truth_(custom_ecount)){
var statearr_106971_106999 = state_106948__$1;
(statearr_106971_106999[(1)] = (17));

} else {
var statearr_106972_107000 = state_106948__$1;
(statearr_106972_107000[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_106949 === (10))){
var inst_106895 = (state_106948[(2)]);
var state_106948__$1 = state_106948;
var statearr_106973_107001 = state_106948__$1;
(statearr_106973_107001[(2)] = inst_106895);

(statearr_106973_107001[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106949 === (18))){
var inst_106913 = (state_106948[(22)]);
var state_106948__$1 = state_106948;
var statearr_106974_107002 = state_106948__$1;
(statearr_106974_107002[(2)] = inst_106913);

(statearr_106974_107002[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106949 === (8))){
var state_106948__$1 = state_106948;
var statearr_106975_107003 = state_106948__$1;
(statearr_106975_107003[(2)] = true);

(statearr_106975_107003[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__100742__auto__ = null;
var fluree$db$storage$core$state_machine__100742__auto____0 = (function (){
var statearr_106976 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_106976[(0)] = fluree$db$storage$core$state_machine__100742__auto__);

(statearr_106976[(1)] = (1));

return statearr_106976;
});
var fluree$db$storage$core$state_machine__100742__auto____1 = (function (state_106948){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_106948);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e106977){if((e106977 instanceof Object)){
var ex__100745__auto__ = e106977;
var statearr_106978_107004 = state_106948;
(statearr_106978_107004[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_106948);

return cljs.core.cst$kw$recur;
} else {
throw e106977;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__107005 = state_106948;
state_106948 = G__107005;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__100742__auto__ = function(state_106948){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__100742__auto____1.call(this,state_106948);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__100742__auto____0;
fluree$db$storage$core$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__100742__auto____1;
return fluree$db$storage$core$state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_106979 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_106979[(6)] = c__100848__auto__);

return statearr_106979;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
}));

(fluree.db.storage.core.write_db_root.cljs$lang$maxFixedArity = 2);

fluree.db.storage.core.reify_history = (function fluree$db$storage$core$reify_history(conn,key,error_fn){
var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__100848__auto___107047 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_107032){
var state_val_107033 = (state_107032[(1)]);
if((state_val_107033 === (1))){
var state_107032__$1 = state_107032;
var statearr_107034_107048 = state_107032__$1;
(statearr_107034_107048[(2)] = null);

(statearr_107034_107048[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107033 === (2))){
var inst_107030 = (state_107032[(2)]);
var state_107032__$1 = state_107032;
return cljs.core.async.impl.ioc_helpers.return_chan(state_107032__$1,inst_107030);
} else {
if((state_val_107033 === (3))){
var inst_107006 = (state_107032[(2)]);
var inst_107007 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_107008 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_107006);
var inst_107009 = cljs.core.async.close_BANG_(return_ch);
var state_107032__$1 = (function (){var statearr_107035 = state_107032;
(statearr_107035[(7)] = inst_107008);

(statearr_107035[(8)] = inst_107007);

return statearr_107035;
})();
var statearr_107036_107049 = state_107032__$1;
(statearr_107036_107049[(2)] = inst_107009);


cljs.core.async.impl.ioc_helpers.process_exception(state_107032__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_107033 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_107032,(3),cljs.core.cst$kw$default,null,(2));
var inst_107013 = fluree.db.storage.core.storage_read(conn,key);
var state_107032__$1 = state_107032;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_107032__$1,(5),inst_107013);
} else {
if((state_val_107033 === (5))){
var inst_107015 = (state_107032[(9)]);
var inst_107015__$1 = (state_107032[(2)]);
var inst_107016 = (inst_107015__$1 == null);
var inst_107017 = (inst_107015__$1 instanceof Error);
var inst_107018 = ((inst_107016) || (inst_107017));
var state_107032__$1 = (function (){var statearr_107037 = state_107032;
(statearr_107037[(9)] = inst_107015__$1);

return statearr_107037;
})();
if(cljs.core.truth_(inst_107018)){
var statearr_107038_107050 = state_107032__$1;
(statearr_107038_107050[(1)] = (6));

} else {
var statearr_107039_107051 = state_107032__$1;
(statearr_107039_107051[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107033 === (6))){
var inst_107020 = cljs.core.async.close_BANG_(return_ch);
var state_107032__$1 = state_107032;
var statearr_107040_107052 = state_107032__$1;
(statearr_107040_107052[(2)] = inst_107020);

(statearr_107040_107052[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107033 === (7))){
var inst_107015 = (state_107032[(9)]);
var inst_107022 = fluree.db.storage.core.serde(conn);
var inst_107023 = fluree.db.serde.protocol._deserialize_leaf(inst_107022,inst_107015);
var inst_107024 = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(inst_107023);
var inst_107025 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_history,inst_107024);
var inst_107026 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_107025);
var state_107032__$1 = state_107032;
var statearr_107041_107053 = state_107032__$1;
(statearr_107041_107053[(2)] = inst_107026);

(statearr_107041_107053[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107033 === (8))){
var inst_107028 = (state_107032[(2)]);
var state_107032__$1 = state_107032;
var statearr_107042_107054 = state_107032__$1;
(statearr_107042_107054[(2)] = inst_107028);


cljs.core.async.impl.ioc_helpers.process_exception(state_107032__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_history_$_state_machine__100742__auto__ = null;
var fluree$db$storage$core$reify_history_$_state_machine__100742__auto____0 = (function (){
var statearr_107043 = [null,null,null,null,null,null,null,null,null,null];
(statearr_107043[(0)] = fluree$db$storage$core$reify_history_$_state_machine__100742__auto__);

(statearr_107043[(1)] = (1));

return statearr_107043;
});
var fluree$db$storage$core$reify_history_$_state_machine__100742__auto____1 = (function (state_107032){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_107032);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e107044){if((e107044 instanceof Object)){
var ex__100745__auto__ = e107044;
var statearr_107045_107055 = state_107032;
(statearr_107045_107055[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_107032);

return cljs.core.cst$kw$recur;
} else {
throw e107044;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__107056 = state_107032;
state_107032 = G__107056;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$storage$core$reify_history_$_state_machine__100742__auto__ = function(state_107032){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_history_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_history_$_state_machine__100742__auto____1.call(this,state_107032);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_history_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_history_$_state_machine__100742__auto____0;
fluree$db$storage$core$reify_history_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_history_$_state_machine__100742__auto____1;
return fluree$db$storage$core$reify_history_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_107046 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_107046[(6)] = c__100848__auto___107047);

return statearr_107046;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));


return return_ch;
});
/**
 * Given a novelty set, a first-flake and rhs flake boundary,
 *   returns novelty subrange as a collection.
 * 
 *   If through-t is specified, will return novelty only through the
 *   specified t.
 */
fluree.db.storage.core.source_novelty_t = (function fluree$db$storage$core$source_novelty_t(var_args){
var G__107058 = arguments.length;
switch (G__107058) {
case 4:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4 = (function (novelty,first_flake,rhs,leftmost_QMARK_){
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(novelty,first_flake,rhs,leftmost_QMARK_,null);
}));

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5 = (function (novelty,first_flake,rhs,leftmost_QMARK_,through_t){
var novelty_subrange = (cljs.core.truth_((function (){var and__4115__auto__ = rhs;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.not(leftmost_QMARK_);
} else {
return and__4115__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$5(novelty,cljs.core._GT_,first_flake,cljs.core._LT__EQ_,rhs):(cljs.core.truth_((function (){var and__4115__auto__ = rhs;
if(cljs.core.truth_(and__4115__auto__)){
return leftmost_QMARK_;
} else {
return and__4115__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._LT__EQ_,rhs):(((((rhs == null)) && (cljs.core.not(leftmost_QMARK_))))?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._GT_,first_flake):(cljs.core.truth_((((rhs == null))?leftmost_QMARK_:false))?novelty:null))));
if(cljs.core.truth_(through_t)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (novelty_set,f){
if((f.t < through_t)){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(novelty_set,f);
} else {
return novelty_set;
}
}),novelty_subrange,novelty_subrange);
} else {
return novelty_subrange;
}
}));

(fluree.db.storage.core.source_novelty_t.cljs$lang$maxFixedArity = 5);

fluree.db.storage.core.resolve_t = (function fluree$db$storage$core$resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,error_fn){
var result_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__100848__auto___107160 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_107118){
var state_val_107119 = (state_107118[(1)]);
if((state_val_107119 === (7))){
var inst_107073 = (state_107118[(7)]);
var inst_107077 = (inst_107073 < t);
var state_107118__$1 = state_107118;
if(cljs.core.truth_(inst_107077)){
var statearr_107120_107161 = state_107118__$1;
(statearr_107120_107161[(1)] = (9));

} else {
var statearr_107121_107162 = state_107118__$1;
(statearr_107121_107162[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107119 === (20))){
var inst_107088 = (state_107118[(8)]);
var inst_107073 = (state_107118[(7)]);
var inst_107072 = (state_107118[(9)]);
var inst_107071 = (state_107118[(10)]);
var inst_107101 = (state_107118[(11)]);
var inst_107108 = (state_107118[(2)]);
var inst_107109 = (function (){var base_node = inst_107071;
var first_flake = inst_107072;
var node_t = inst_107073;
var source = inst_107088;
var coll = inst_107101;
var conj_QMARK_ = inst_107108;
return (function (acc,f){
if(cljs.core.truth_((function (){var G__107123 = f.p;
var fexpr__107122 = (function (){var or__4126__auto__ = remove_preds;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})();
return (fexpr__107122.cljs$core$IFn$_invoke$arity$1 ? fexpr__107122.cljs$core$IFn$_invoke$arity$1(G__107123) : fexpr__107122.call(null,G__107123));
})())){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(acc,f);
} else {
if(cljs.core.truth_((conj_QMARK_.cljs$core$IFn$_invoke$arity$1 ? conj_QMARK_.cljs$core$IFn$_invoke$arity$1(f) : conj_QMARK_.call(null,f)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,f);
} else {
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(acc,f);

}
}
});
})();
var inst_107110 = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(inst_107071);
var inst_107111 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_107109,inst_107110,inst_107101);
var inst_107112 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_107111);
var inst_107113 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_107071,cljs.core.cst$kw$flakes,inst_107112);
var inst_107114 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_ch,inst_107113);
var state_107118__$1 = state_107118;
var statearr_107124_107163 = state_107118__$1;
(statearr_107124_107163[(2)] = inst_107114);


cljs.core.async.impl.ioc_helpers.process_exception(state_107118__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_107119 === (1))){
var state_107118__$1 = state_107118;
var statearr_107125_107164 = state_107118__$1;
(statearr_107125_107164[(2)] = null);

(statearr_107125_107164[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107119 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_107118,(3),cljs.core.cst$kw$default,null,(2));
var inst_107068 = fluree.db.dbproto._resolve(node);
var state_107118__$1 = state_107118;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_107118__$1,(5),inst_107068);
} else {
if((state_val_107119 === (15))){
var inst_107088 = (state_107118[(8)]);
var inst_107101 = (state_107118[(2)]);
var state_107118__$1 = (function (){var statearr_107126 = state_107118;
(statearr_107126[(11)] = inst_107101);

return statearr_107126;
})();
var G__107127_107165 = inst_107088;
var G__107127_107166__$1 = (((G__107127_107165 instanceof cljs.core.Keyword))?G__107127_107165.fqn:null);
switch (G__107127_107166__$1) {
case "novelty":
var statearr_107128_107168 = state_107118__$1;
(statearr_107128_107168[(1)] = (21));


break;
case "history":
var statearr_107129_107169 = state_107118__$1;
(statearr_107129_107169[(1)] = (22));


break;
case "none":
var statearr_107130_107170 = state_107118__$1;
(statearr_107130_107170[(1)] = (23));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__107127_107166__$1)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107119 === (21))){
var inst_107088 = (state_107118[(8)]);
var inst_107073 = (state_107118[(7)]);
var inst_107072 = (state_107118[(9)]);
var inst_107071 = (state_107118[(10)]);
var inst_107101 = (state_107118[(11)]);
var inst_107102 = (function (){var base_node = inst_107071;
var first_flake = inst_107072;
var node_t = inst_107073;
var source = inst_107088;
var coll = inst_107101;
return (function (f){
return f.op === true;
});
})();
var state_107118__$1 = state_107118;
var statearr_107131_107171 = state_107118__$1;
(statearr_107131_107171[(2)] = inst_107102);

(statearr_107131_107171[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107119 === (13))){
var state_107118__$1 = state_107118;
var statearr_107132_107172 = state_107118__$1;
(statearr_107132_107172[(2)] = null);

(statearr_107132_107172[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107119 === (22))){
var inst_107088 = (state_107118[(8)]);
var inst_107073 = (state_107118[(7)]);
var inst_107072 = (state_107118[(9)]);
var inst_107071 = (state_107118[(10)]);
var inst_107101 = (state_107118[(11)]);
var inst_107104 = (function (){var base_node = inst_107071;
var first_flake = inst_107072;
var node_t = inst_107073;
var source = inst_107088;
var coll = inst_107101;
return (function (f){
return f.op === false;
});
})();
var state_107118__$1 = state_107118;
var statearr_107133_107173 = state_107118__$1;
(statearr_107133_107173[(2)] = inst_107104);

(statearr_107133_107173[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107119 === (6))){
var state_107118__$1 = state_107118;
var statearr_107134_107174 = state_107118__$1;
(statearr_107134_107174[(2)] = cljs.core.cst$kw$novelty);

(statearr_107134_107174[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107119 === (17))){
var inst_107088 = (state_107118[(8)]);
var inst_107073 = (state_107118[(7)]);
var inst_107072 = (state_107118[(9)]);
var inst_107071 = (state_107118[(10)]);
var inst_107091 = (function (){var base_node = inst_107071;
var first_flake = inst_107072;
var node_t = inst_107073;
var source = inst_107088;
return (function (p1__107060_SHARP_){
return (p1__107060_SHARP_.t <= t);
});
})();
var inst_107092 = fluree.db.dbproto._resolve_history(node);
var state_107118__$1 = (function (){var statearr_107135 = state_107118;
(statearr_107135[(12)] = inst_107091);

return statearr_107135;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_107118__$1,(18),inst_107092);
} else {
if((state_val_107119 === (3))){
var inst_107061 = (state_107118[(2)]);
var inst_107062 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_107063 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_ch,inst_107061);
var inst_107064 = cljs.core.async.close_BANG_(result_ch);
var state_107118__$1 = (function (){var statearr_107136 = state_107118;
(statearr_107136[(13)] = inst_107062);

(statearr_107136[(14)] = inst_107063);

return statearr_107136;
})();
var statearr_107137_107175 = state_107118__$1;
(statearr_107137_107175[(2)] = inst_107064);


cljs.core.async.impl.ioc_helpers.process_exception(state_107118__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_107119 === (12))){
var state_107118__$1 = state_107118;
var statearr_107138_107176 = state_107118__$1;
(statearr_107138_107176[(2)] = cljs.core.cst$kw$none);

(statearr_107138_107176[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107119 === (2))){
var inst_107116 = (state_107118[(2)]);
var state_107118__$1 = state_107118;
return cljs.core.async.impl.ioc_helpers.return_chan(state_107118__$1,inst_107116);
} else {
if((state_val_107119 === (23))){
var state_107118__$1 = state_107118;
var statearr_107139_107177 = state_107118__$1;
(statearr_107139_107177[(2)] = null);

(statearr_107139_107177[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107119 === (19))){
var inst_107098 = cljs.core.PersistentVector.EMPTY;
var state_107118__$1 = state_107118;
var statearr_107140_107178 = state_107118__$1;
(statearr_107140_107178[(2)] = inst_107098);

(statearr_107140_107178[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107119 === (11))){
var inst_107086 = (state_107118[(2)]);
var state_107118__$1 = state_107118;
var statearr_107141_107179 = state_107118__$1;
(statearr_107141_107179[(2)] = inst_107086);

(statearr_107141_107179[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107119 === (9))){
var state_107118__$1 = state_107118;
var statearr_107142_107180 = state_107118__$1;
(statearr_107142_107180[(2)] = cljs.core.cst$kw$history);

(statearr_107142_107180[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107119 === (5))){
var inst_107073 = (state_107118[(7)]);
var inst_107071 = (state_107118[(10)]);
var inst_107070 = (state_107118[(2)]);
var inst_107071__$1 = fluree.db.util.async.throw_err(inst_107070);
var inst_107072 = fluree.db.dbproto._first_flake(inst_107071__$1);
var inst_107073__$1 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(inst_107071__$1);
var inst_107074 = (inst_107073__$1 > t);
var state_107118__$1 = (function (){var statearr_107143 = state_107118;
(statearr_107143[(7)] = inst_107073__$1);

(statearr_107143[(9)] = inst_107072);

(statearr_107143[(10)] = inst_107071__$1);

return statearr_107143;
})();
if(cljs.core.truth_(inst_107074)){
var statearr_107144_107181 = state_107118__$1;
(statearr_107144_107181[(1)] = (6));

} else {
var statearr_107145_107182 = state_107118__$1;
(statearr_107145_107182[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107119 === (14))){
var inst_107084 = (state_107118[(2)]);
var state_107118__$1 = state_107118;
var statearr_107146_107183 = state_107118__$1;
(statearr_107146_107183[(2)] = inst_107084);

(statearr_107146_107183[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107119 === (16))){
var inst_107072 = (state_107118[(9)]);
var inst_107089 = fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(idx_novelty,inst_107072,rhs,leftmost_QMARK_,t);
var state_107118__$1 = state_107118;
var statearr_107147_107184 = state_107118__$1;
(statearr_107147_107184[(2)] = inst_107089);

(statearr_107147_107184[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107119 === (10))){
var inst_107073 = (state_107118[(7)]);
var inst_107080 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_107073,t);
var state_107118__$1 = state_107118;
if(inst_107080){
var statearr_107148_107185 = state_107118__$1;
(statearr_107148_107185[(1)] = (12));

} else {
var statearr_107149_107186 = state_107118__$1;
(statearr_107149_107186[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107119 === (18))){
var inst_107091 = (state_107118[(12)]);
var inst_107094 = (state_107118[(2)]);
var inst_107095 = fluree.db.util.async.throw_err(inst_107094);
var inst_107096 = cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(inst_107091,inst_107095);
var state_107118__$1 = state_107118;
var statearr_107150_107187 = state_107118__$1;
(statearr_107150_107187[(2)] = inst_107096);

(statearr_107150_107187[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107119 === (8))){
var inst_107088 = (state_107118[(8)]);
var inst_107088__$1 = (state_107118[(2)]);
var state_107118__$1 = (function (){var statearr_107151 = state_107118;
(statearr_107151[(8)] = inst_107088__$1);

return statearr_107151;
})();
var G__107152_107188 = inst_107088__$1;
var G__107152_107189__$1 = (((G__107152_107188 instanceof cljs.core.Keyword))?G__107152_107188.fqn:null);
switch (G__107152_107189__$1) {
case "novelty":
var statearr_107153_107191 = state_107118__$1;
(statearr_107153_107191[(1)] = (16));


break;
case "history":
var statearr_107154_107192 = state_107118__$1;
(statearr_107154_107192[(1)] = (17));


break;
case "none":
var statearr_107155_107193 = state_107118__$1;
(statearr_107155_107193[(1)] = (19));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__107152_107189__$1)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_t_$_state_machine__100742__auto__ = null;
var fluree$db$storage$core$resolve_t_$_state_machine__100742__auto____0 = (function (){
var statearr_107156 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_107156[(0)] = fluree$db$storage$core$resolve_t_$_state_machine__100742__auto__);

(statearr_107156[(1)] = (1));

return statearr_107156;
});
var fluree$db$storage$core$resolve_t_$_state_machine__100742__auto____1 = (function (state_107118){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_107118);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e107157){if((e107157 instanceof Object)){
var ex__100745__auto__ = e107157;
var statearr_107158_107194 = state_107118;
(statearr_107158_107194[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_107118);

return cljs.core.cst$kw$recur;
} else {
throw e107157;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__107195 = state_107118;
state_107118 = G__107195;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_t_$_state_machine__100742__auto__ = function(state_107118){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_t_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_t_$_state_machine__100742__auto____1.call(this,state_107118);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_t_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_t_$_state_machine__100742__auto____0;
fluree$db$storage$core$resolve_t_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_t_$_state_machine__100742__auto____1;
return fluree$db$storage$core$resolve_t_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_107159 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_107159[(6)] = c__100848__auto___107160);

return statearr_107159;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));


return result_ch;
});
/**
 * Gets a history slice of a node with the oldest 't' from-t, to the
 *   most recent 't', to-t.
 * 
 *   Returns sorted set in novelty's sort order (spot, psot, post, or opst)
 */
fluree.db.storage.core.resolve_history_range = (function fluree$db$storage$core$resolve_history_range(node,from_t,to_t,idx_novelty,leftmost_QMARK_){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_107249){
var state_val_107250 = (state_107249[(1)]);
if((state_val_107250 === (7))){
var inst_107229 = (state_107249[(2)]);
var inst_107230 = fluree.db.dbproto._first_flake(node);
var inst_107231 = fluree.db.dbproto._rhs(node);
var inst_107232 = cljs.core.cst$kw$leaf.cljs$core$IFn$_invoke$arity$1(node);
var state_107249__$1 = (function (){var statearr_107251 = state_107249;
(statearr_107251[(7)] = inst_107230);

(statearr_107251[(8)] = inst_107229);

(statearr_107251[(9)] = inst_107231);

return statearr_107251;
})();
if(cljs.core.truth_(inst_107232)){
var statearr_107252_107280 = state_107249__$1;
(statearr_107252_107280[(1)] = (15));

} else {
var statearr_107253_107281 = state_107249__$1;
(statearr_107253_107281[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107250 === (1))){
var state_107249__$1 = state_107249;
var statearr_107254_107282 = state_107249__$1;
(statearr_107254_107282[(2)] = null);

(statearr_107254_107282[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107250 === (4))){
var inst_107204 = (state_107249[(10)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_107249,(3),cljs.core.cst$kw$default,null,(2));
var inst_107204__$1 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(node);
var inst_107205 = (from_t == null);
var inst_107206 = (inst_107204__$1 <= from_t);
var inst_107207 = ((inst_107205) || (inst_107206));
var state_107249__$1 = (function (){var statearr_107255 = state_107249;
(statearr_107255[(10)] = inst_107204__$1);

return statearr_107255;
})();
if(cljs.core.truth_(inst_107207)){
var statearr_107256_107283 = state_107249__$1;
(statearr_107256_107283[(1)] = (5));

} else {
var statearr_107257_107284 = state_107249__$1;
(statearr_107257_107284[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107250 === (15))){
var state_107249__$1 = state_107249;
var statearr_107258_107285 = state_107249__$1;
(statearr_107258_107285[(2)] = null);

(statearr_107258_107285[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107250 === (13))){
var inst_107220 = (state_107249[(11)]);
var state_107249__$1 = state_107249;
var statearr_107259_107286 = state_107249__$1;
(statearr_107259_107286[(2)] = inst_107220);

(statearr_107259_107286[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107250 === (6))){
var state_107249__$1 = state_107249;
var statearr_107260_107287 = state_107249__$1;
(statearr_107260_107287[(2)] = null);

(statearr_107260_107287[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107250 === (17))){
var inst_107230 = (state_107249[(7)]);
var inst_107229 = (state_107249[(8)]);
var inst_107231 = (state_107249[(9)]);
var inst_107243 = (state_107249[(2)]);
var inst_107244 = fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(idx_novelty,inst_107230,inst_107231,leftmost_QMARK_,to_t);
var inst_107245 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_107244,inst_107229);
var state_107249__$1 = (function (){var statearr_107261 = state_107249;
(statearr_107261[(12)] = inst_107243);

return statearr_107261;
})();
var statearr_107262_107288 = state_107249__$1;
(statearr_107262_107288[(2)] = inst_107245);


cljs.core.async.impl.ioc_helpers.process_exception(state_107249__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_107250 === (3))){
var inst_107198 = (state_107249[(2)]);
var inst_107199 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_107198], 0));
var inst_107200 = (function(){throw inst_107198})();
var state_107249__$1 = (function (){var statearr_107263 = state_107249;
(statearr_107263[(13)] = inst_107199);

return statearr_107263;
})();
var statearr_107264_107289 = state_107249__$1;
(statearr_107264_107289[(2)] = inst_107200);


cljs.core.async.impl.ioc_helpers.process_exception(state_107249__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_107250 === (12))){
var inst_107204 = (state_107249[(10)]);
var inst_107220 = (state_107249[(11)]);
var inst_107222 = (function (){var node_t = inst_107204;
var G__107209 = inst_107220;
return (function (p1__107197_SHARP_){
return (p1__107197_SHARP_.t <= from_t);
});
})();
var inst_107223 = cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(inst_107222,inst_107220);
var state_107249__$1 = state_107249;
var statearr_107265_107290 = state_107249__$1;
(statearr_107265_107290[(2)] = inst_107223);

(statearr_107265_107290[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107250 === (2))){
var inst_107247 = (state_107249[(2)]);
var state_107249__$1 = state_107249;
return cljs.core.async.impl.ioc_helpers.return_chan(state_107249__$1,inst_107247);
} else {
if((state_val_107250 === (11))){
var inst_107220 = (state_107249[(2)]);
var state_107249__$1 = (function (){var statearr_107266 = state_107249;
(statearr_107266[(11)] = inst_107220);

return statearr_107266;
})();
if(cljs.core.truth_(from_t)){
var statearr_107267_107291 = state_107249__$1;
(statearr_107267_107291[(1)] = (12));

} else {
var statearr_107268_107292 = state_107249__$1;
(statearr_107268_107292[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107250 === (9))){
var inst_107213 = (state_107249[(14)]);
var inst_107204 = (state_107249[(10)]);
var inst_107216 = (function (){var node_t = inst_107204;
var G__107209 = inst_107213;
return (function (p1__107196_SHARP_){
return (p1__107196_SHARP_.t < to_t);
});
})();
var inst_107217 = cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(inst_107216,inst_107213);
var state_107249__$1 = state_107249;
var statearr_107269_107293 = state_107249__$1;
(statearr_107269_107293[(2)] = inst_107217);

(statearr_107269_107293[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107250 === (5))){
var inst_107210 = fluree.db.dbproto._resolve_history(node);
var state_107249__$1 = state_107249;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_107249__$1,(8),inst_107210);
} else {
if((state_val_107250 === (14))){
var inst_107226 = (state_107249[(2)]);
var state_107249__$1 = state_107249;
var statearr_107270_107294 = state_107249__$1;
(statearr_107270_107294[(2)] = inst_107226);

(statearr_107270_107294[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107250 === (16))){
var inst_107235 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(node);
var inst_107236 = ["resolve-history-range called on index node: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_107235)].join('');
var inst_107237 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_107238 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_107239 = cljs.core.PersistentHashMap.fromArrays(inst_107237,inst_107238);
var inst_107240 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_107236,inst_107239);
var inst_107241 = (function(){throw inst_107240})();
var state_107249__$1 = state_107249;
var statearr_107271_107295 = state_107249__$1;
(statearr_107271_107295[(2)] = inst_107241);

(statearr_107271_107295[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107250 === (10))){
var inst_107213 = (state_107249[(14)]);
var state_107249__$1 = state_107249;
var statearr_107272_107296 = state_107249__$1;
(statearr_107272_107296[(2)] = inst_107213);

(statearr_107272_107296[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107250 === (8))){
var inst_107204 = (state_107249[(10)]);
var inst_107212 = (state_107249[(2)]);
var inst_107213 = fluree.db.util.async.throw_err(inst_107212);
var inst_107214 = (to_t > inst_107204);
var state_107249__$1 = (function (){var statearr_107273 = state_107249;
(statearr_107273[(14)] = inst_107213);

return statearr_107273;
})();
if(cljs.core.truth_(inst_107214)){
var statearr_107274_107297 = state_107249__$1;
(statearr_107274_107297[(1)] = (9));

} else {
var statearr_107275_107298 = state_107249__$1;
(statearr_107275_107298[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_history_range_$_state_machine__100742__auto__ = null;
var fluree$db$storage$core$resolve_history_range_$_state_machine__100742__auto____0 = (function (){
var statearr_107276 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_107276[(0)] = fluree$db$storage$core$resolve_history_range_$_state_machine__100742__auto__);

(statearr_107276[(1)] = (1));

return statearr_107276;
});
var fluree$db$storage$core$resolve_history_range_$_state_machine__100742__auto____1 = (function (state_107249){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_107249);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e107277){if((e107277 instanceof Object)){
var ex__100745__auto__ = e107277;
var statearr_107278_107299 = state_107249;
(statearr_107278_107299[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_107249);

return cljs.core.cst$kw$recur;
} else {
throw e107277;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__107300 = state_107249;
state_107249 = G__107300;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_history_range_$_state_machine__100742__auto__ = function(state_107249){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_history_range_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_history_range_$_state_machine__100742__auto____1.call(this,state_107249);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_history_range_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_history_range_$_state_machine__100742__auto____0;
fluree$db$storage$core$resolve_history_range_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_history_range_$_state_machine__100742__auto____1;
return fluree$db$storage$core$resolve_history_range_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_107279 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_107279[(6)] = c__100848__auto__);

return statearr_107279;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
fluree.db.storage.core.resolve_to_t = (function fluree$db$storage$core$resolve_to_t(node,id,tempid,rhs,leftmost_QMARK_,t,tt_id,idx_novelty,conn,fast_foward_db_QMARK_,remove_preds){
if(cljs.core.truth_((function (){var or__4126__auto__ = fast_foward_db_QMARK_;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$empty,id);
}
})())){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,null);
} else {
var object_cache = cljs.core.cst$kw$object_DASH_cache.cljs$core$IFn$_invoke$arity$1(conn);
if((!(cljs.core.empty_QMARK_(remove_preds)))){
var G__107301_107311 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__107302_107312 = null;
(object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__107301_107311,G__107302_107312) : object_cache.call(null,G__107301_107311,G__107302_107312));

var G__107303 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__107304 = (function (_){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
var G__107305 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__107306 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__107305,G__107306) : object_cache.call(null,G__107305,G__107306));
}));
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__107303,G__107304) : object_cache.call(null,G__107303,G__107304));
} else {
var G__107307 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__107308 = (function (_){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
var G__107309 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__107310 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__107309,G__107310) : object_cache.call(null,G__107309,G__107310));
}));
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__107307,G__107308) : object_cache.call(null,G__107307,G__107308));
}
}
});
/**
 * Reads and deserializes branch node.
 */
fluree.db.storage.core.read_branch = (function fluree$db$storage$core$read_branch(conn,key){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_107330){
var state_val_107331 = (state_107330[(1)]);
if((state_val_107331 === (1))){
var state_107330__$1 = state_107330;
var statearr_107332_107345 = state_107330__$1;
(statearr_107332_107345[(2)] = null);

(statearr_107332_107345[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107331 === (2))){
var inst_107328 = (state_107330[(2)]);
var state_107330__$1 = state_107330;
return cljs.core.async.impl.ioc_helpers.return_chan(state_107330__$1,inst_107328);
} else {
if((state_val_107331 === (3))){
var inst_107313 = (state_107330[(2)]);
var state_107330__$1 = state_107330;
var statearr_107333_107346 = state_107330__$1;
(statearr_107333_107346[(2)] = inst_107313);


cljs.core.async.impl.ioc_helpers.process_exception(state_107330__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_107331 === (4))){
var inst_107317 = (state_107330[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_107330,(3),Error,null,(2));
var inst_107317__$1 = fluree.db.storage.core.storage_read(conn,key);
var state_107330__$1 = (function (){var statearr_107334 = state_107330;
(statearr_107334[(7)] = inst_107317__$1);

return statearr_107334;
})();
if(cljs.core.truth_(inst_107317__$1)){
var statearr_107335_107347 = state_107330__$1;
(statearr_107335_107347[(1)] = (5));

} else {
var statearr_107336_107348 = state_107330__$1;
(statearr_107336_107348[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107331 === (5))){
var inst_107317 = (state_107330[(7)]);
var inst_107319 = fluree.db.storage.core.serde(conn);
var state_107330__$1 = (function (){var statearr_107337 = state_107330;
(statearr_107337[(8)] = inst_107319);

return statearr_107337;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_107330__$1,(8),inst_107317);
} else {
if((state_val_107331 === (6))){
var state_107330__$1 = state_107330;
var statearr_107338_107349 = state_107330__$1;
(statearr_107338_107349[(2)] = null);

(statearr_107338_107349[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107331 === (7))){
var inst_107326 = (state_107330[(2)]);
var state_107330__$1 = state_107330;
var statearr_107339_107350 = state_107330__$1;
(statearr_107339_107350[(2)] = inst_107326);


cljs.core.async.impl.ioc_helpers.process_exception(state_107330__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_107331 === (8))){
var inst_107319 = (state_107330[(8)]);
var inst_107321 = (state_107330[(2)]);
var inst_107322 = fluree.db.util.async.throw_err(inst_107321);
var inst_107323 = fluree.db.serde.protocol._deserialize_branch(inst_107319,inst_107322);
var state_107330__$1 = state_107330;
var statearr_107340_107351 = state_107330__$1;
(statearr_107340_107351[(2)] = inst_107323);

(statearr_107340_107351[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_branch_$_state_machine__100742__auto__ = null;
var fluree$db$storage$core$read_branch_$_state_machine__100742__auto____0 = (function (){
var statearr_107341 = [null,null,null,null,null,null,null,null,null];
(statearr_107341[(0)] = fluree$db$storage$core$read_branch_$_state_machine__100742__auto__);

(statearr_107341[(1)] = (1));

return statearr_107341;
});
var fluree$db$storage$core$read_branch_$_state_machine__100742__auto____1 = (function (state_107330){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_107330);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e107342){if((e107342 instanceof Object)){
var ex__100745__auto__ = e107342;
var statearr_107343_107352 = state_107330;
(statearr_107343_107352[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_107330);

return cljs.core.cst$kw$recur;
} else {
throw e107342;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__107353 = state_107330;
state_107330 = G__107353;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$storage$core$read_branch_$_state_machine__100742__auto__ = function(state_107330){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_branch_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_branch_$_state_machine__100742__auto____1.call(this,state_107330);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_branch_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_branch_$_state_machine__100742__auto____0;
fluree$db$storage$core$read_branch_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_branch_$_state_machine__100742__auto____1;
return fluree$db$storage$core$read_branch_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_107344 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_107344[(6)] = c__100848__auto__);

return statearr_107344;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_branch = (function fluree$db$storage$core$reify_branch(conn,config,network,dbid,key,block,t,tt_id,leftmost_QMARK_,tempid,error_fn){
var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__100848__auto___107488 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_107440){
var state_val_107441 = (state_107440[(1)]);
if((state_val_107441 === (7))){
var state_107440__$1 = state_107440;
var statearr_107442_107489 = state_107440__$1;
(statearr_107442_107489[(2)] = null);

(statearr_107442_107489[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107441 === (20))){
var inst_107404 = (state_107440[(7)]);
var inst_107404__$1 = (state_107440[(2)]);
var inst_107405 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_107404__$1,cljs.core.cst$kw$children);
var inst_107406 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_107404__$1,cljs.core.cst$kw$rhs);
var inst_107408 = (config == null);
var inst_107409 = cljs.core.not(inst_107408);
var state_107440__$1 = (function (){var statearr_107443 = state_107440;
(statearr_107443[(8)] = inst_107406);

(statearr_107443[(9)] = inst_107405);

(statearr_107443[(7)] = inst_107404__$1);

return statearr_107443;
})();
if(inst_107409){
var statearr_107444_107490 = state_107440__$1;
(statearr_107444_107490[(1)] = (21));

} else {
var statearr_107445_107491 = state_107440__$1;
(statearr_107445_107491[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107441 === (27))){
var inst_107424 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,config);
var state_107440__$1 = state_107440;
var statearr_107446_107492 = state_107440__$1;
(statearr_107446_107492[(2)] = inst_107424);

(statearr_107446_107492[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107441 === (1))){
var state_107440__$1 = state_107440;
var statearr_107447_107493 = state_107440__$1;
(statearr_107447_107493[(2)] = null);

(statearr_107447_107493[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107441 === (24))){
var state_107440__$1 = state_107440;
var statearr_107448_107494 = state_107440__$1;
(statearr_107448_107494[(2)] = true);

(statearr_107448_107494[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107441 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_107440,(3),cljs.core.cst$kw$default,null,(2));
var inst_107363 = fluree.db.storage.core.read_branch(conn,key);
var state_107440__$1 = state_107440;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_107440__$1,(5),inst_107363);
} else {
if((state_val_107441 === (15))){
var state_107440__$1 = state_107440;
var statearr_107449_107495 = state_107440__$1;
(statearr_107449_107495[(2)] = true);

(statearr_107449_107495[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107441 === (21))){
var inst_107411 = config.cljs$lang$protocol_mask$partition0$;
var inst_107412 = (inst_107411 & (64));
var inst_107413 = config.cljs$core$ISeq$;
var inst_107414 = (cljs.core.PROTOCOL_SENTINEL === inst_107413);
var inst_107415 = ((inst_107412) || (inst_107414));
var state_107440__$1 = state_107440;
if(cljs.core.truth_(inst_107415)){
var statearr_107450_107496 = state_107440__$1;
(statearr_107450_107496[(1)] = (24));

} else {
var statearr_107451_107497 = state_107440__$1;
(statearr_107451_107497[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107441 === (13))){
var state_107440__$1 = state_107440;
var statearr_107452_107498 = state_107440__$1;
(statearr_107452_107498[(2)] = false);

(statearr_107452_107498[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107441 === (22))){
var state_107440__$1 = state_107440;
var statearr_107453_107499 = state_107440__$1;
(statearr_107453_107499[(2)] = false);

(statearr_107453_107499[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107441 === (29))){
var inst_107383 = (state_107440[(10)]);
var inst_107406 = (state_107440[(8)]);
var inst_107405 = (state_107440[(9)]);
var inst_107404 = (state_107440[(7)]);
var inst_107366 = (state_107440[(11)]);
var inst_107427 = (state_107440[(2)]);
var inst_107428 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_107427,cljs.core.cst$kw$comparator);
var inst_107430 = (function (){var data = inst_107366;
var _ = inst_107383;
var map__107361 = inst_107404;
var children = inst_107405;
var rhs = inst_107406;
var map__107362 = inst_107427;
var comparator = inst_107428;
return (function (idx,p__107429){
var map__107454 = p__107429;
var map__107454__$1 = (((((!((map__107454 == null))))?(((((map__107454.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__107454.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__107454):map__107454);
var child = map__107454__$1;
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__107454__$1,cljs.core.cst$kw$id);
var leaf = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__107454__$1,cljs.core.cst$kw$leaf);
var first = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__107454__$1,cljs.core.cst$kw$first);
var rhs__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__107454__$1,cljs.core.cst$kw$rhs);
var size = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__107454__$1,cljs.core.cst$kw$size);
var at_leftmost_QMARK_ = (function (){var and__4115__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(and__4115__auto__)){
return (idx === (0));
} else {
return and__4115__auto__;
}
})();
return (fluree.db.storage.core.__GT_UnresolvedNode.cljs$core$IFn$_invoke$arity$14 ? fluree.db.storage.core.__GT_UnresolvedNode.cljs$core$IFn$_invoke$arity$14(conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid) : fluree.db.storage.core.__GT_UnresolvedNode.call(null,conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid));
});
})();
var inst_107431 = cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(inst_107430,inst_107405);
var inst_107432 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$first,inst_107431);
var inst_107433 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(inst_107432,inst_107431);
var inst_107434 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(clojure.data.avl.sorted_map_by,inst_107428,inst_107433);
var inst_107435 = fluree.db.index.__GT_IndexNode(block,t,inst_107406,inst_107434,config,leftmost_QMARK_);
var inst_107436 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_107435);
var state_107440__$1 = state_107440;
var statearr_107456_107500 = state_107440__$1;
(statearr_107456_107500[(2)] = inst_107436);


cljs.core.async.impl.ioc_helpers.process_exception(state_107440__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_107441 === (6))){
var inst_107369 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_107370 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_107371 = [(500),cljs.core.cst$kw$db_SLASH_storage_DASH_error];
var inst_107372 = cljs.core.PersistentHashMap.fromArrays(inst_107370,inst_107371);
var inst_107373 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_107369,inst_107372);
var inst_107374 = (function(){throw inst_107373})();
var state_107440__$1 = state_107440;
var statearr_107457_107501 = state_107440__$1;
(statearr_107457_107501[(2)] = inst_107374);

(statearr_107457_107501[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107441 === (28))){
var state_107440__$1 = state_107440;
var statearr_107458_107502 = state_107440__$1;
(statearr_107458_107502[(2)] = config);

(statearr_107458_107502[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107441 === (25))){
var state_107440__$1 = state_107440;
var statearr_107459_107503 = state_107440__$1;
(statearr_107459_107503[(2)] = false);

(statearr_107459_107503[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107441 === (17))){
var inst_107396 = (state_107440[(2)]);
var state_107440__$1 = state_107440;
var statearr_107460_107504 = state_107440__$1;
(statearr_107460_107504[(2)] = inst_107396);

(statearr_107460_107504[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107441 === (3))){
var inst_107354 = (state_107440[(2)]);
var inst_107355 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_107356 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_107354);
var inst_107357 = cljs.core.async.close_BANG_(return_ch);
var state_107440__$1 = (function (){var statearr_107461 = state_107440;
(statearr_107461[(12)] = inst_107356);

(statearr_107461[(13)] = inst_107355);

return statearr_107461;
})();
var statearr_107462_107505 = state_107440__$1;
(statearr_107462_107505[(2)] = inst_107357);


cljs.core.async.impl.ioc_helpers.process_exception(state_107440__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_107441 === (12))){
var inst_107366 = (state_107440[(11)]);
var inst_107388 = inst_107366.cljs$lang$protocol_mask$partition0$;
var inst_107389 = (inst_107388 & (64));
var inst_107390 = inst_107366.cljs$core$ISeq$;
var inst_107391 = (cljs.core.PROTOCOL_SENTINEL === inst_107390);
var inst_107392 = ((inst_107389) || (inst_107391));
var state_107440__$1 = state_107440;
if(cljs.core.truth_(inst_107392)){
var statearr_107463_107506 = state_107440__$1;
(statearr_107463_107506[(1)] = (15));

} else {
var statearr_107464_107507 = state_107440__$1;
(statearr_107464_107507[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107441 === (2))){
var inst_107438 = (state_107440[(2)]);
var state_107440__$1 = state_107440;
return cljs.core.async.impl.ioc_helpers.return_chan(state_107440__$1,inst_107438);
} else {
if((state_val_107441 === (23))){
var inst_107422 = (state_107440[(2)]);
var state_107440__$1 = state_107440;
if(cljs.core.truth_(inst_107422)){
var statearr_107465_107508 = state_107440__$1;
(statearr_107465_107508[(1)] = (27));

} else {
var statearr_107466_107509 = state_107440__$1;
(statearr_107466_107509[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107441 === (19))){
var inst_107366 = (state_107440[(11)]);
var state_107440__$1 = state_107440;
var statearr_107467_107510 = state_107440__$1;
(statearr_107467_107510[(2)] = inst_107366);

(statearr_107467_107510[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107441 === (11))){
var inst_107366 = (state_107440[(11)]);
var inst_107383 = (state_107440[(2)]);
var inst_107385 = (inst_107366 == null);
var inst_107386 = cljs.core.not(inst_107385);
var state_107440__$1 = (function (){var statearr_107468 = state_107440;
(statearr_107468[(10)] = inst_107383);

return statearr_107468;
})();
if(inst_107386){
var statearr_107469_107511 = state_107440__$1;
(statearr_107469_107511[(1)] = (12));

} else {
var statearr_107470_107512 = state_107440__$1;
(statearr_107470_107512[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107441 === (9))){
var inst_107366 = (state_107440[(11)]);
var inst_107380 = (function(){throw inst_107366})();
var state_107440__$1 = state_107440;
var statearr_107471_107513 = state_107440__$1;
(statearr_107471_107513[(2)] = inst_107380);

(statearr_107471_107513[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107441 === (5))){
var inst_107366 = (state_107440[(11)]);
var inst_107365 = (state_107440[(2)]);
var inst_107366__$1 = fluree.db.util.async.throw_err(inst_107365);
var inst_107367 = (inst_107366__$1 == null);
var state_107440__$1 = (function (){var statearr_107472 = state_107440;
(statearr_107472[(11)] = inst_107366__$1);

return statearr_107472;
})();
if(cljs.core.truth_(inst_107367)){
var statearr_107473_107514 = state_107440__$1;
(statearr_107473_107514[(1)] = (6));

} else {
var statearr_107474_107515 = state_107440__$1;
(statearr_107474_107515[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107441 === (14))){
var inst_107399 = (state_107440[(2)]);
var state_107440__$1 = state_107440;
if(cljs.core.truth_(inst_107399)){
var statearr_107475_107516 = state_107440__$1;
(statearr_107475_107516[(1)] = (18));

} else {
var statearr_107476_107517 = state_107440__$1;
(statearr_107476_107517[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107441 === (26))){
var inst_107419 = (state_107440[(2)]);
var state_107440__$1 = state_107440;
var statearr_107477_107518 = state_107440__$1;
(statearr_107477_107518[(2)] = inst_107419);

(statearr_107477_107518[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107441 === (16))){
var state_107440__$1 = state_107440;
var statearr_107478_107519 = state_107440__$1;
(statearr_107478_107519[(2)] = false);

(statearr_107478_107519[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107441 === (10))){
var state_107440__$1 = state_107440;
var statearr_107479_107520 = state_107440__$1;
(statearr_107479_107520[(2)] = null);

(statearr_107479_107520[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107441 === (18))){
var inst_107366 = (state_107440[(11)]);
var inst_107401 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_107366);
var state_107440__$1 = state_107440;
var statearr_107480_107521 = state_107440__$1;
(statearr_107480_107521[(2)] = inst_107401);

(statearr_107480_107521[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107441 === (8))){
var inst_107366 = (state_107440[(11)]);
var inst_107377 = (state_107440[(2)]);
var inst_107378 = fluree.db.util.core.exception_QMARK_(inst_107366);
var state_107440__$1 = (function (){var statearr_107481 = state_107440;
(statearr_107481[(14)] = inst_107377);

return statearr_107481;
})();
if(inst_107378){
var statearr_107482_107522 = state_107440__$1;
(statearr_107482_107522[(1)] = (9));

} else {
var statearr_107483_107523 = state_107440__$1;
(statearr_107483_107523[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_branch_$_state_machine__100742__auto__ = null;
var fluree$db$storage$core$reify_branch_$_state_machine__100742__auto____0 = (function (){
var statearr_107484 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_107484[(0)] = fluree$db$storage$core$reify_branch_$_state_machine__100742__auto__);

(statearr_107484[(1)] = (1));

return statearr_107484;
});
var fluree$db$storage$core$reify_branch_$_state_machine__100742__auto____1 = (function (state_107440){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_107440);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e107485){if((e107485 instanceof Object)){
var ex__100745__auto__ = e107485;
var statearr_107486_107524 = state_107440;
(statearr_107486_107524[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_107440);

return cljs.core.cst$kw$recur;
} else {
throw e107485;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__107525 = state_107440;
state_107440 = G__107525;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$storage$core$reify_branch_$_state_machine__100742__auto__ = function(state_107440){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_branch_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_branch_$_state_machine__100742__auto____1.call(this,state_107440);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_branch_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_branch_$_state_machine__100742__auto____0;
fluree$db$storage$core$reify_branch_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_branch_$_state_machine__100742__auto____1;
return fluree$db$storage$core$reify_branch_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_107487 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_107487[(6)] = c__100848__auto___107488);

return statearr_107487;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));


return return_ch;
});
/**
 * Reads and deserializes a leaf node
 */
fluree.db.storage.core.read_leaf = (function fluree$db$storage$core$read_leaf(conn,key){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_107543){
var state_val_107544 = (state_107543[(1)]);
if((state_val_107544 === (1))){
var state_107543__$1 = state_107543;
var statearr_107545_107558 = state_107543__$1;
(statearr_107545_107558[(2)] = null);

(statearr_107545_107558[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107544 === (2))){
var inst_107541 = (state_107543[(2)]);
var state_107543__$1 = state_107543;
return cljs.core.async.impl.ioc_helpers.return_chan(state_107543__$1,inst_107541);
} else {
if((state_val_107544 === (3))){
var inst_107526 = (state_107543[(2)]);
var state_107543__$1 = state_107543;
var statearr_107546_107559 = state_107543__$1;
(statearr_107546_107559[(2)] = inst_107526);


cljs.core.async.impl.ioc_helpers.process_exception(state_107543__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_107544 === (4))){
var inst_107530 = (state_107543[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_107543,(3),Error,null,(2));
var inst_107530__$1 = fluree.db.storage.core.storage_read(conn,key);
var state_107543__$1 = (function (){var statearr_107547 = state_107543;
(statearr_107547[(7)] = inst_107530__$1);

return statearr_107547;
})();
if(cljs.core.truth_(inst_107530__$1)){
var statearr_107548_107560 = state_107543__$1;
(statearr_107548_107560[(1)] = (5));

} else {
var statearr_107549_107561 = state_107543__$1;
(statearr_107549_107561[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107544 === (5))){
var inst_107530 = (state_107543[(7)]);
var inst_107532 = fluree.db.storage.core.serde(conn);
var state_107543__$1 = (function (){var statearr_107550 = state_107543;
(statearr_107550[(8)] = inst_107532);

return statearr_107550;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_107543__$1,(8),inst_107530);
} else {
if((state_val_107544 === (6))){
var state_107543__$1 = state_107543;
var statearr_107551_107562 = state_107543__$1;
(statearr_107551_107562[(2)] = null);

(statearr_107551_107562[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107544 === (7))){
var inst_107539 = (state_107543[(2)]);
var state_107543__$1 = state_107543;
var statearr_107552_107563 = state_107543__$1;
(statearr_107552_107563[(2)] = inst_107539);


cljs.core.async.impl.ioc_helpers.process_exception(state_107543__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_107544 === (8))){
var inst_107532 = (state_107543[(8)]);
var inst_107534 = (state_107543[(2)]);
var inst_107535 = fluree.db.util.async.throw_err(inst_107534);
var inst_107536 = fluree.db.serde.protocol._deserialize_leaf(inst_107532,inst_107535);
var state_107543__$1 = state_107543;
var statearr_107553_107564 = state_107543__$1;
(statearr_107553_107564[(2)] = inst_107536);

(statearr_107553_107564[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_leaf_$_state_machine__100742__auto__ = null;
var fluree$db$storage$core$read_leaf_$_state_machine__100742__auto____0 = (function (){
var statearr_107554 = [null,null,null,null,null,null,null,null,null];
(statearr_107554[(0)] = fluree$db$storage$core$read_leaf_$_state_machine__100742__auto__);

(statearr_107554[(1)] = (1));

return statearr_107554;
});
var fluree$db$storage$core$read_leaf_$_state_machine__100742__auto____1 = (function (state_107543){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_107543);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e107555){if((e107555 instanceof Object)){
var ex__100745__auto__ = e107555;
var statearr_107556_107565 = state_107543;
(statearr_107556_107565[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_107543);

return cljs.core.cst$kw$recur;
} else {
throw e107555;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__107566 = state_107543;
state_107543 = G__107566;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$storage$core$read_leaf_$_state_machine__100742__auto__ = function(state_107543){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_leaf_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_leaf_$_state_machine__100742__auto____1.call(this,state_107543);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_leaf_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_leaf_$_state_machine__100742__auto____0;
fluree$db$storage$core$read_leaf_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_leaf_$_state_machine__100742__auto____1;
return fluree$db$storage$core$read_leaf_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_107557 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_107557[(6)] = c__100848__auto__);

return statearr_107557;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_leaf = (function fluree$db$storage$core$reify_leaf(conn,config,key,block,t,rhs,error_fn){
if(cljs.core.truth_(cljs.core.cst$kw$comparator.cljs$core$IFn$_invoke$arity$1(config))){
} else {
throw (new Error(["Assert failed: ",["Cannot reify leaf, config does not have a comparator. Config: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([config], 0))].join(''),"\n","(:comparator config)"].join('')));
}

var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__100848__auto___107693 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_107647){
var state_val_107648 = (state_107647[(1)]);
if((state_val_107648 === (7))){
var state_107647__$1 = state_107647;
var statearr_107649_107694 = state_107647__$1;
(statearr_107649_107694[(2)] = null);

(statearr_107649_107694[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107648 === (20))){
var inst_107616 = (state_107647[(2)]);
var inst_107617 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_107616,cljs.core.cst$kw$flakes);
var inst_107618 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_107616,cljs.core.cst$kw$his);
var inst_107620 = (config == null);
var inst_107621 = cljs.core.not(inst_107620);
var state_107647__$1 = (function (){var statearr_107650 = state_107647;
(statearr_107650[(7)] = inst_107618);

(statearr_107650[(8)] = inst_107617);

return statearr_107650;
})();
if(inst_107621){
var statearr_107651_107695 = state_107647__$1;
(statearr_107651_107695[(1)] = (21));

} else {
var statearr_107652_107696 = state_107647__$1;
(statearr_107652_107696[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107648 === (27))){
var inst_107636 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,config);
var state_107647__$1 = state_107647;
var statearr_107653_107697 = state_107647__$1;
(statearr_107653_107697[(2)] = inst_107636);

(statearr_107653_107697[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107648 === (1))){
var state_107647__$1 = state_107647;
var statearr_107654_107698 = state_107647__$1;
(statearr_107654_107698[(2)] = null);

(statearr_107654_107698[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107648 === (24))){
var state_107647__$1 = state_107647;
var statearr_107655_107699 = state_107647__$1;
(statearr_107655_107699[(2)] = true);

(statearr_107655_107699[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107648 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_107647,(3),cljs.core.cst$kw$default,null,(2));
var inst_107576 = fluree.db.storage.core.read_leaf(conn,key);
var state_107647__$1 = state_107647;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_107647__$1,(5),inst_107576);
} else {
if((state_val_107648 === (15))){
var state_107647__$1 = state_107647;
var statearr_107656_107700 = state_107647__$1;
(statearr_107656_107700[(2)] = true);

(statearr_107656_107700[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107648 === (21))){
var inst_107623 = config.cljs$lang$protocol_mask$partition0$;
var inst_107624 = (inst_107623 & (64));
var inst_107625 = config.cljs$core$ISeq$;
var inst_107626 = (cljs.core.PROTOCOL_SENTINEL === inst_107625);
var inst_107627 = ((inst_107624) || (inst_107626));
var state_107647__$1 = state_107647;
if(cljs.core.truth_(inst_107627)){
var statearr_107657_107701 = state_107647__$1;
(statearr_107657_107701[(1)] = (24));

} else {
var statearr_107658_107702 = state_107647__$1;
(statearr_107658_107702[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107648 === (13))){
var state_107647__$1 = state_107647;
var statearr_107659_107703 = state_107647__$1;
(statearr_107659_107703[(2)] = false);

(statearr_107659_107703[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107648 === (22))){
var state_107647__$1 = state_107647;
var statearr_107660_107704 = state_107647__$1;
(statearr_107660_107704[(2)] = false);

(statearr_107660_107704[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107648 === (29))){
var inst_107617 = (state_107647[(8)]);
var inst_107639 = (state_107647[(2)]);
var inst_107640 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_107639,cljs.core.cst$kw$comparator);
var inst_107641 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.db.flake.sorted_set_by,inst_107640,inst_107617);
var inst_107642 = fluree.db.index.data_node(block,t,inst_107641,rhs,config);
var inst_107643 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_107642);
var state_107647__$1 = state_107647;
var statearr_107661_107705 = state_107647__$1;
(statearr_107661_107705[(2)] = inst_107643);


cljs.core.async.impl.ioc_helpers.process_exception(state_107647__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_107648 === (6))){
var inst_107581 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_107582 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_107583 = [(500),cljs.core.cst$kw$db_SLASH_storage_DASH_error];
var inst_107584 = cljs.core.PersistentHashMap.fromArrays(inst_107582,inst_107583);
var inst_107585 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_107581,inst_107584);
var inst_107586 = (function(){throw inst_107585})();
var state_107647__$1 = state_107647;
var statearr_107662_107706 = state_107647__$1;
(statearr_107662_107706[(2)] = inst_107586);

(statearr_107662_107706[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107648 === (28))){
var state_107647__$1 = state_107647;
var statearr_107663_107707 = state_107647__$1;
(statearr_107663_107707[(2)] = config);

(statearr_107663_107707[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107648 === (25))){
var state_107647__$1 = state_107647;
var statearr_107664_107708 = state_107647__$1;
(statearr_107664_107708[(2)] = false);

(statearr_107664_107708[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107648 === (17))){
var inst_107608 = (state_107647[(2)]);
var state_107647__$1 = state_107647;
var statearr_107665_107709 = state_107647__$1;
(statearr_107665_107709[(2)] = inst_107608);

(statearr_107665_107709[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107648 === (3))){
var inst_107567 = (state_107647[(2)]);
var inst_107568 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_107569 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_107567);
var inst_107570 = cljs.core.async.close_BANG_(return_ch);
var state_107647__$1 = (function (){var statearr_107666 = state_107647;
(statearr_107666[(9)] = inst_107568);

(statearr_107666[(10)] = inst_107569);

return statearr_107666;
})();
var statearr_107667_107710 = state_107647__$1;
(statearr_107667_107710[(2)] = inst_107570);


cljs.core.async.impl.ioc_helpers.process_exception(state_107647__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_107648 === (12))){
var inst_107578 = (state_107647[(11)]);
var inst_107600 = inst_107578.cljs$lang$protocol_mask$partition0$;
var inst_107601 = (inst_107600 & (64));
var inst_107602 = inst_107578.cljs$core$ISeq$;
var inst_107603 = (cljs.core.PROTOCOL_SENTINEL === inst_107602);
var inst_107604 = ((inst_107601) || (inst_107603));
var state_107647__$1 = state_107647;
if(cljs.core.truth_(inst_107604)){
var statearr_107668_107711 = state_107647__$1;
(statearr_107668_107711[(1)] = (15));

} else {
var statearr_107669_107712 = state_107647__$1;
(statearr_107669_107712[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107648 === (2))){
var inst_107645 = (state_107647[(2)]);
var state_107647__$1 = state_107647;
return cljs.core.async.impl.ioc_helpers.return_chan(state_107647__$1,inst_107645);
} else {
if((state_val_107648 === (23))){
var inst_107634 = (state_107647[(2)]);
var state_107647__$1 = state_107647;
if(cljs.core.truth_(inst_107634)){
var statearr_107670_107713 = state_107647__$1;
(statearr_107670_107713[(1)] = (27));

} else {
var statearr_107671_107714 = state_107647__$1;
(statearr_107671_107714[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107648 === (19))){
var inst_107578 = (state_107647[(11)]);
var state_107647__$1 = state_107647;
var statearr_107672_107715 = state_107647__$1;
(statearr_107672_107715[(2)] = inst_107578);

(statearr_107672_107715[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107648 === (11))){
var inst_107578 = (state_107647[(11)]);
var inst_107595 = (state_107647[(2)]);
var inst_107597 = (inst_107578 == null);
var inst_107598 = cljs.core.not(inst_107597);
var state_107647__$1 = (function (){var statearr_107673 = state_107647;
(statearr_107673[(12)] = inst_107595);

return statearr_107673;
})();
if(inst_107598){
var statearr_107674_107716 = state_107647__$1;
(statearr_107674_107716[(1)] = (12));

} else {
var statearr_107675_107717 = state_107647__$1;
(statearr_107675_107717[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107648 === (9))){
var inst_107578 = (state_107647[(11)]);
var inst_107592 = (function(){throw inst_107578})();
var state_107647__$1 = state_107647;
var statearr_107676_107718 = state_107647__$1;
(statearr_107676_107718[(2)] = inst_107592);

(statearr_107676_107718[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107648 === (5))){
var inst_107578 = (state_107647[(11)]);
var inst_107578__$1 = (state_107647[(2)]);
var inst_107579 = (inst_107578__$1 == null);
var state_107647__$1 = (function (){var statearr_107677 = state_107647;
(statearr_107677[(11)] = inst_107578__$1);

return statearr_107677;
})();
if(cljs.core.truth_(inst_107579)){
var statearr_107678_107719 = state_107647__$1;
(statearr_107678_107719[(1)] = (6));

} else {
var statearr_107679_107720 = state_107647__$1;
(statearr_107679_107720[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107648 === (14))){
var inst_107611 = (state_107647[(2)]);
var state_107647__$1 = state_107647;
if(cljs.core.truth_(inst_107611)){
var statearr_107680_107721 = state_107647__$1;
(statearr_107680_107721[(1)] = (18));

} else {
var statearr_107681_107722 = state_107647__$1;
(statearr_107681_107722[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107648 === (26))){
var inst_107631 = (state_107647[(2)]);
var state_107647__$1 = state_107647;
var statearr_107682_107723 = state_107647__$1;
(statearr_107682_107723[(2)] = inst_107631);

(statearr_107682_107723[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107648 === (16))){
var state_107647__$1 = state_107647;
var statearr_107683_107724 = state_107647__$1;
(statearr_107683_107724[(2)] = false);

(statearr_107683_107724[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107648 === (10))){
var state_107647__$1 = state_107647;
var statearr_107684_107725 = state_107647__$1;
(statearr_107684_107725[(2)] = null);

(statearr_107684_107725[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107648 === (18))){
var inst_107578 = (state_107647[(11)]);
var inst_107613 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_107578);
var state_107647__$1 = state_107647;
var statearr_107685_107726 = state_107647__$1;
(statearr_107685_107726[(2)] = inst_107613);

(statearr_107685_107726[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107648 === (8))){
var inst_107578 = (state_107647[(11)]);
var inst_107589 = (state_107647[(2)]);
var inst_107590 = fluree.db.util.core.exception_QMARK_(inst_107578);
var state_107647__$1 = (function (){var statearr_107686 = state_107647;
(statearr_107686[(13)] = inst_107589);

return statearr_107686;
})();
if(inst_107590){
var statearr_107687_107727 = state_107647__$1;
(statearr_107687_107727[(1)] = (9));

} else {
var statearr_107688_107728 = state_107647__$1;
(statearr_107688_107728[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_leaf_$_state_machine__100742__auto__ = null;
var fluree$db$storage$core$reify_leaf_$_state_machine__100742__auto____0 = (function (){
var statearr_107689 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_107689[(0)] = fluree$db$storage$core$reify_leaf_$_state_machine__100742__auto__);

(statearr_107689[(1)] = (1));

return statearr_107689;
});
var fluree$db$storage$core$reify_leaf_$_state_machine__100742__auto____1 = (function (state_107647){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_107647);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e107690){if((e107690 instanceof Object)){
var ex__100745__auto__ = e107690;
var statearr_107691_107729 = state_107647;
(statearr_107691_107729[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_107647);

return cljs.core.cst$kw$recur;
} else {
throw e107690;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__107730 = state_107647;
state_107647 = G__107730;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$storage$core$reify_leaf_$_state_machine__100742__auto__ = function(state_107647){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_leaf_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_leaf_$_state_machine__100742__auto____1.call(this,state_107647);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_leaf_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_leaf_$_state_machine__100742__auto____0;
fluree$db$storage$core$reify_leaf_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_leaf_$_state_machine__100742__auto____1;
return fluree$db$storage$core$reify_leaf_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_107692 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_107692[(6)] = c__100848__auto___107693);

return statearr_107692;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));


return return_ch;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.storage.core.UnresolvedNode = (function (conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,__meta,__extmap,__hash){
this.conn = conn;
this.config = config;
this.network = network;
this.dbid = dbid;
this.id = id;
this.leaf = leaf;
this.first = first;
this.rhs = rhs;
this.size = size;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.tempid = tempid;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k107732,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__107736 = k107732;
var G__107736__$1 = (((G__107736 instanceof cljs.core.Keyword))?G__107736.fqn:null);
switch (G__107736__$1) {
case "conn":
return self__.conn;

break;
case "config":
return self__.config;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "id":
return self__.id;

break;
case "leaf":
return self__.leaf;

break;
case "first":
return self__.first;

break;
case "rhs":
return self__.rhs;

break;
case "size":
return self__.size;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
case "tempid":
return self__.tempid;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k107732,else__4383__auto__);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__107737){
var vec__107738 = p__107737;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__107738,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__107738,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#fluree.db.storage.core.UnresolvedNode{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$conn,self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$config,self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$network,self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$dbid,self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$id,self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$leaf,self__.leaf],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$first,self__.first],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$rhs,self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$size,self__.size],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$block,self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$t,self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tt_DASH_id,self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$leftmost_QMARK_,self__.leftmost_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tempid,self__.tempid],null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__107731){
var self__ = this;
var G__107731__$1 = this;
return (new cljs.core.RecordIter((0),G__107731__$1,14,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$config,cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$id,cljs.core.cst$kw$leaf,cljs.core.cst$kw$first,cljs.core.cst$kw$rhs,cljs.core.cst$kw$size,cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$leftmost_QMARK_,cljs.core.cst$kw$tempid], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.first;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$empty,self__.id)){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,fluree.db.index.data_node((0),(0),fluree.db.flake.sorted_set_by(cljs.core.cst$kw$comparator.cljs$core$IFn$_invoke$arity$1(self__.config)),null,self__.config));

return pc;
} else {
var object_cache = cljs.core.cst$kw$object_DASH_cache.cljs$core$IFn$_invoke$arity$1(self__.conn);
var G__107741 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__107742 = (function (___$2){
if(cljs.core.truth_(self__.leaf)){
return fluree.db.storage.core.reify_leaf(self__.conn,self__.config,self__.id,self__.block,self__.t,self__.rhs,(function (){
var G__107743 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__107744 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__107743,G__107744) : object_cache.call(null,G__107743,G__107744));
}));
} else {
return fluree.db.storage.core.reify_branch(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,(function (){
var G__107745 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__107746 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__107745,G__107746) : object_cache.call(null,G__107745,G__107746));
}));
}
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__107741,G__107742) : object_cache.call(null,G__107741,G__107742));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var history_id = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.id),"-his"].join('');
var object_cache = cljs.core.cst$kw$object_DASH_cache.cljs$core$IFn$_invoke$arity$1(self__.conn);
var error_fn = (function (){
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(history_id,null) : object_cache.call(null,history_id,null));
});
var G__107747 = history_id;
var G__107748 = (function (___$2){
return fluree.db.storage.core.reify_history(self__.conn,history_id,error_fn);
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__107747,G__107748) : object_cache.call(null,G__107747,G__107748));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$3 = (function (this$,to_t,idx_novelty){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,false,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$4 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$5 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_,remove_preds){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,remove_preds);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$3 = (function (node,from_t,to_t){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range(node__$1,from_t,to_t,null,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$4 = (function (node,from_t,to_t,idx_novelty){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range(node__$1,from_t,to_t,idx_novelty,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (14 + cljs.core.count(self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (){var fexpr__107749 = (function (coll__4377__auto__){
return (502391120 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
});
return fexpr__107749(this__4376__auto____$1);
})();
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this107733,other107734){
var self__ = this;
var this107733__$1 = this;
return (((!((other107734 == null)))) && ((this107733__$1.constructor === other107734.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this107733__$1.conn,other107734.conn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this107733__$1.config,other107734.config)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this107733__$1.network,other107734.network)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this107733__$1.dbid,other107734.dbid)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this107733__$1.id,other107734.id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this107733__$1.leaf,other107734.leaf)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this107733__$1.first,other107734.first)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this107733__$1.rhs,other107734.rhs)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this107733__$1.size,other107734.size)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this107733__$1.block,other107734.block)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this107733__$1.t,other107734.t)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this107733__$1.tt_id,other107734.tt_id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this107733__$1.leftmost_QMARK_,other107734.leftmost_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this107733__$1.tempid,other107734.tempid)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this107733__$1.__extmap,other107734.__extmap)));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [cljs.core.cst$kw$block,null,cljs.core.cst$kw$dbid,null,cljs.core.cst$kw$config,null,cljs.core.cst$kw$leaf,null,cljs.core.cst$kw$size,null,cljs.core.cst$kw$leftmost_QMARK_,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$tempid,null,cljs.core.cst$kw$t,null,cljs.core.cst$kw$network,null,cljs.core.cst$kw$first,null,cljs.core.cst$kw$tt_DASH_id,null,cljs.core.cst$kw$rhs,null,cljs.core.cst$kw$conn,null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__107731){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__107750 = cljs.core.keyword_identical_QMARK_;
var expr__107751 = k__4388__auto__;
if(cljs.core.truth_((function (){var G__107753 = cljs.core.cst$kw$conn;
var G__107754 = expr__107751;
return (pred__107750.cljs$core$IFn$_invoke$arity$2 ? pred__107750.cljs$core$IFn$_invoke$arity$2(G__107753,G__107754) : pred__107750.call(null,G__107753,G__107754));
})())){
return (new fluree.db.storage.core.UnresolvedNode(G__107731,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__107755 = cljs.core.cst$kw$config;
var G__107756 = expr__107751;
return (pred__107750.cljs$core$IFn$_invoke$arity$2 ? pred__107750.cljs$core$IFn$_invoke$arity$2(G__107755,G__107756) : pred__107750.call(null,G__107755,G__107756));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,G__107731,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__107757 = cljs.core.cst$kw$network;
var G__107758 = expr__107751;
return (pred__107750.cljs$core$IFn$_invoke$arity$2 ? pred__107750.cljs$core$IFn$_invoke$arity$2(G__107757,G__107758) : pred__107750.call(null,G__107757,G__107758));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,G__107731,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__107759 = cljs.core.cst$kw$dbid;
var G__107760 = expr__107751;
return (pred__107750.cljs$core$IFn$_invoke$arity$2 ? pred__107750.cljs$core$IFn$_invoke$arity$2(G__107759,G__107760) : pred__107750.call(null,G__107759,G__107760));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,G__107731,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__107761 = cljs.core.cst$kw$id;
var G__107762 = expr__107751;
return (pred__107750.cljs$core$IFn$_invoke$arity$2 ? pred__107750.cljs$core$IFn$_invoke$arity$2(G__107761,G__107762) : pred__107750.call(null,G__107761,G__107762));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,G__107731,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__107763 = cljs.core.cst$kw$leaf;
var G__107764 = expr__107751;
return (pred__107750.cljs$core$IFn$_invoke$arity$2 ? pred__107750.cljs$core$IFn$_invoke$arity$2(G__107763,G__107764) : pred__107750.call(null,G__107763,G__107764));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,G__107731,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__107765 = cljs.core.cst$kw$first;
var G__107766 = expr__107751;
return (pred__107750.cljs$core$IFn$_invoke$arity$2 ? pred__107750.cljs$core$IFn$_invoke$arity$2(G__107765,G__107766) : pred__107750.call(null,G__107765,G__107766));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,G__107731,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__107767 = cljs.core.cst$kw$rhs;
var G__107768 = expr__107751;
return (pred__107750.cljs$core$IFn$_invoke$arity$2 ? pred__107750.cljs$core$IFn$_invoke$arity$2(G__107767,G__107768) : pred__107750.call(null,G__107767,G__107768));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,G__107731,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__107769 = cljs.core.cst$kw$size;
var G__107770 = expr__107751;
return (pred__107750.cljs$core$IFn$_invoke$arity$2 ? pred__107750.cljs$core$IFn$_invoke$arity$2(G__107769,G__107770) : pred__107750.call(null,G__107769,G__107770));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,G__107731,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__107771 = cljs.core.cst$kw$block;
var G__107772 = expr__107751;
return (pred__107750.cljs$core$IFn$_invoke$arity$2 ? pred__107750.cljs$core$IFn$_invoke$arity$2(G__107771,G__107772) : pred__107750.call(null,G__107771,G__107772));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,G__107731,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__107773 = cljs.core.cst$kw$t;
var G__107774 = expr__107751;
return (pred__107750.cljs$core$IFn$_invoke$arity$2 ? pred__107750.cljs$core$IFn$_invoke$arity$2(G__107773,G__107774) : pred__107750.call(null,G__107773,G__107774));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,G__107731,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__107775 = cljs.core.cst$kw$tt_DASH_id;
var G__107776 = expr__107751;
return (pred__107750.cljs$core$IFn$_invoke$arity$2 ? pred__107750.cljs$core$IFn$_invoke$arity$2(G__107775,G__107776) : pred__107750.call(null,G__107775,G__107776));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,G__107731,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__107777 = cljs.core.cst$kw$leftmost_QMARK_;
var G__107778 = expr__107751;
return (pred__107750.cljs$core$IFn$_invoke$arity$2 ? pred__107750.cljs$core$IFn$_invoke$arity$2(G__107777,G__107778) : pred__107750.call(null,G__107777,G__107778));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,G__107731,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__107779 = cljs.core.cst$kw$tempid;
var G__107780 = expr__107751;
return (pred__107750.cljs$core$IFn$_invoke$arity$2 ? pred__107750.cljs$core$IFn$_invoke$arity$2(G__107779,G__107780) : pred__107750.call(null,G__107779,G__107780));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,G__107731,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__107731),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$conn,self__.conn,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$config,self__.config,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$network,self__.network,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$dbid,self__.dbid,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$id,self__.id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$leaf,self__.leaf,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$first,self__.first,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$rhs,self__.rhs,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$size,self__.size,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$block,self__.block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$t,self__.t,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tt_DASH_id,self__.tt_id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$leftmost_QMARK_,self__.leftmost_QMARK_,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tempid,self__.tempid,null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__107731){
var self__ = this;
var this__4379__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,G__107731,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4386__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(fluree.db.storage.core.UnresolvedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$conn,cljs.core.cst$sym$config,cljs.core.cst$sym$network,cljs.core.cst$sym$dbid,cljs.core.cst$sym$id,cljs.core.cst$sym$leaf,cljs.core.cst$sym$first,cljs.core.cst$sym$rhs,cljs.core.cst$sym$size,cljs.core.cst$sym$block,cljs.core.cst$sym$t,cljs.core.cst$sym$tt_DASH_id,cljs.core.cst$sym$leftmost_QMARK_,cljs.core.cst$sym$tempid], null);
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$type = true);

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"fluree.db.storage.core/UnresolvedNode",null,(1),null));
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"fluree.db.storage.core/UnresolvedNode");
}));

/**
 * Positional factory function for fluree.db.storage.core/UnresolvedNode.
 */
fluree.db.storage.core.__GT_UnresolvedNode = (function fluree$db$storage$core$__GT_UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid){
return (new fluree.db.storage.core.UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,null,null,null));
});

/**
 * Factory function for fluree.db.storage.core/UnresolvedNode, taking a map of keywords to field values.
 */
fluree.db.storage.core.map__GT_UnresolvedNode = (function fluree$db$storage$core$map__GT_UnresolvedNode(G__107735){
var extmap__4419__auto__ = (function (){var G__107781 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__107735,cljs.core.cst$kw$conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$config,cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$id,cljs.core.cst$kw$leaf,cljs.core.cst$kw$first,cljs.core.cst$kw$rhs,cljs.core.cst$kw$size,cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$leftmost_QMARK_,cljs.core.cst$kw$tempid], 0));
if(cljs.core.record_QMARK_(G__107735)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__107781);
} else {
return G__107781;
}
})();
return (new fluree.db.storage.core.UnresolvedNode(cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(G__107735),cljs.core.cst$kw$config.cljs$core$IFn$_invoke$arity$1(G__107735),cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(G__107735),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(G__107735),cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(G__107735),cljs.core.cst$kw$leaf.cljs$core$IFn$_invoke$arity$1(G__107735),cljs.core.cst$kw$first.cljs$core$IFn$_invoke$arity$1(G__107735),cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(G__107735),cljs.core.cst$kw$size.cljs$core$IFn$_invoke$arity$1(G__107735),cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(G__107735),cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(G__107735),cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(G__107735),cljs.core.cst$kw$leftmost_QMARK_.cljs$core$IFn$_invoke$arity$1(G__107735),cljs.core.cst$kw$tempid.cljs$core$IFn$_invoke$arity$1(G__107735),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

/**
 * Turns each index root node into an unresolved node.
 */
fluree.db.storage.core.reify_index_root = (function fluree$db$storage$core$reify_index_root(conn,index_configs,network,dbid,index,index_data,block,t){
var cfg = (function (){var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(index_configs,index);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Internal error reifying db root index: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([index], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null));
}
})();
return fluree.db.storage.core.map__GT_UnresolvedNode(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(index_data,cljs.core.cst$kw$conn,conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$config,cfg,cljs.core.cst$kw$network,network,cljs.core.cst$kw$dbid,dbid,cljs.core.cst$kw$block,block,cljs.core.cst$kw$t,t,cljs.core.cst$kw$leftmost_QMARK_,true], 0)));
});
/**
 * Constructs db from blank-db, and ensure index roots have proper config as unresolved nodes.
 */
fluree.db.storage.core.reify_db_root = (function fluree$db$storage$core$reify_db_root(conn,blank_db,root_data){
var map__107783 = blank_db;
var map__107783__$1 = (((((!((map__107783 == null))))?(((((map__107783.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__107783.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__107783):map__107783);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__107783__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__107783__$1,cljs.core.cst$kw$dbid);
var index_configs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__107783__$1,cljs.core.cst$kw$index_DASH_configs);
var map__107784 = root_data;
var map__107784__$1 = (((((!((map__107784 == null))))?(((((map__107784.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__107784.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__107784):map__107784);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__107784__$1,cljs.core.cst$kw$block);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__107784__$1,cljs.core.cst$kw$t);
var ecount = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__107784__$1,cljs.core.cst$kw$ecount);
var stats = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__107784__$1,cljs.core.cst$kw$stats);
var db_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(blank_db,cljs.core.cst$kw$block,block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$t,t,cljs.core.cst$kw$ecount,ecount,cljs.core.cst$kw$stats,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(stats,cljs.core.cst$kw$indexed,block)], 0));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (db,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,idx,fluree.db.storage.core.reify_index_root(conn,index_configs,network,dbid,idx,cljs.core.get.cljs$core$IFn$_invoke$arity$2(root_data,idx),block,t));
}),db_STAR_,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst], null));
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_garbage = (function fluree$db$storage$core$read_garbage(conn,network,dbid,block){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_107805){
var state_val_107806 = (state_107805[(1)]);
if((state_val_107806 === (1))){
var state_107805__$1 = state_107805;
var statearr_107807_107820 = state_107805__$1;
(statearr_107807_107820[(2)] = null);

(statearr_107807_107820[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107806 === (2))){
var inst_107803 = (state_107805[(2)]);
var state_107805__$1 = state_107805;
return cljs.core.async.impl.ioc_helpers.return_chan(state_107805__$1,inst_107803);
} else {
if((state_val_107806 === (3))){
var inst_107787 = (state_107805[(2)]);
var state_107805__$1 = state_107805;
var statearr_107808_107821 = state_107805__$1;
(statearr_107808_107821[(2)] = inst_107787);


cljs.core.async.impl.ioc_helpers.process_exception(state_107805__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_107806 === (4))){
var inst_107792 = (state_107805[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_107805,(3),Error,null,(2));
var inst_107791 = fluree.db.storage.core.ledger_garbage_key(network,dbid,block);
var inst_107792__$1 = fluree.db.storage.core.storage_read(conn,inst_107791);
var state_107805__$1 = (function (){var statearr_107809 = state_107805;
(statearr_107809[(7)] = inst_107792__$1);

return statearr_107809;
})();
if(cljs.core.truth_(inst_107792__$1)){
var statearr_107810_107822 = state_107805__$1;
(statearr_107810_107822[(1)] = (5));

} else {
var statearr_107811_107823 = state_107805__$1;
(statearr_107811_107823[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107806 === (5))){
var inst_107792 = (state_107805[(7)]);
var inst_107794 = fluree.db.storage.core.serde(conn);
var state_107805__$1 = (function (){var statearr_107812 = state_107805;
(statearr_107812[(8)] = inst_107794);

return statearr_107812;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_107805__$1,(8),inst_107792);
} else {
if((state_val_107806 === (6))){
var state_107805__$1 = state_107805;
var statearr_107813_107824 = state_107805__$1;
(statearr_107813_107824[(2)] = null);

(statearr_107813_107824[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107806 === (7))){
var inst_107801 = (state_107805[(2)]);
var state_107805__$1 = state_107805;
var statearr_107814_107825 = state_107805__$1;
(statearr_107814_107825[(2)] = inst_107801);


cljs.core.async.impl.ioc_helpers.process_exception(state_107805__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_107806 === (8))){
var inst_107794 = (state_107805[(8)]);
var inst_107796 = (state_107805[(2)]);
var inst_107797 = fluree.db.util.async.throw_err(inst_107796);
var inst_107798 = fluree.db.serde.protocol._deserialize_garbage(inst_107794,inst_107797);
var state_107805__$1 = state_107805;
var statearr_107815_107826 = state_107805__$1;
(statearr_107815_107826[(2)] = inst_107798);

(statearr_107815_107826[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_garbage_$_state_machine__100742__auto__ = null;
var fluree$db$storage$core$read_garbage_$_state_machine__100742__auto____0 = (function (){
var statearr_107816 = [null,null,null,null,null,null,null,null,null];
(statearr_107816[(0)] = fluree$db$storage$core$read_garbage_$_state_machine__100742__auto__);

(statearr_107816[(1)] = (1));

return statearr_107816;
});
var fluree$db$storage$core$read_garbage_$_state_machine__100742__auto____1 = (function (state_107805){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_107805);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e107817){if((e107817 instanceof Object)){
var ex__100745__auto__ = e107817;
var statearr_107818_107827 = state_107805;
(statearr_107818_107827[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_107805);

return cljs.core.cst$kw$recur;
} else {
throw e107817;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__107828 = state_107805;
state_107805 = G__107828;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$storage$core$read_garbage_$_state_machine__100742__auto__ = function(state_107805){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_garbage_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_garbage_$_state_machine__100742__auto____1.call(this,state_107805);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_garbage_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_garbage_$_state_machine__100742__auto____0;
fluree$db$storage$core$read_garbage_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_garbage_$_state_machine__100742__auto____1;
return fluree$db$storage$core$read_garbage_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_107819 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_107819[(6)] = c__100848__auto__);

return statearr_107819;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_db_root = (function fluree$db$storage$core$read_db_root(conn,network,dbid,block){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_107847){
var state_val_107848 = (state_107847[(1)]);
if((state_val_107848 === (1))){
var state_107847__$1 = state_107847;
var statearr_107849_107862 = state_107847__$1;
(statearr_107849_107862[(2)] = null);

(statearr_107849_107862[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107848 === (2))){
var inst_107845 = (state_107847[(2)]);
var state_107847__$1 = state_107847;
return cljs.core.async.impl.ioc_helpers.return_chan(state_107847__$1,inst_107845);
} else {
if((state_val_107848 === (3))){
var inst_107829 = (state_107847[(2)]);
var state_107847__$1 = state_107847;
var statearr_107850_107863 = state_107847__$1;
(statearr_107850_107863[(2)] = inst_107829);


cljs.core.async.impl.ioc_helpers.process_exception(state_107847__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_107848 === (4))){
var inst_107834 = (state_107847[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_107847,(3),Error,null,(2));
var inst_107833 = fluree.db.storage.core.ledger_root_key(network,dbid,block);
var inst_107834__$1 = fluree.db.storage.core.storage_read(conn,inst_107833);
var state_107847__$1 = (function (){var statearr_107851 = state_107847;
(statearr_107851[(7)] = inst_107834__$1);

return statearr_107851;
})();
if(cljs.core.truth_(inst_107834__$1)){
var statearr_107852_107864 = state_107847__$1;
(statearr_107852_107864[(1)] = (5));

} else {
var statearr_107853_107865 = state_107847__$1;
(statearr_107853_107865[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107848 === (5))){
var inst_107834 = (state_107847[(7)]);
var inst_107836 = fluree.db.storage.core.serde(conn);
var state_107847__$1 = (function (){var statearr_107854 = state_107847;
(statearr_107854[(8)] = inst_107836);

return statearr_107854;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_107847__$1,(8),inst_107834);
} else {
if((state_val_107848 === (6))){
var state_107847__$1 = state_107847;
var statearr_107855_107866 = state_107847__$1;
(statearr_107855_107866[(2)] = null);

(statearr_107855_107866[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107848 === (7))){
var inst_107843 = (state_107847[(2)]);
var state_107847__$1 = state_107847;
var statearr_107856_107867 = state_107847__$1;
(statearr_107856_107867[(2)] = inst_107843);


cljs.core.async.impl.ioc_helpers.process_exception(state_107847__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_107848 === (8))){
var inst_107836 = (state_107847[(8)]);
var inst_107838 = (state_107847[(2)]);
var inst_107839 = fluree.db.util.async.throw_err(inst_107838);
var inst_107840 = fluree.db.serde.protocol._deserialize_db_root(inst_107836,inst_107839);
var state_107847__$1 = state_107847;
var statearr_107857_107868 = state_107847__$1;
(statearr_107857_107868[(2)] = inst_107840);

(statearr_107857_107868[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_db_root_$_state_machine__100742__auto__ = null;
var fluree$db$storage$core$read_db_root_$_state_machine__100742__auto____0 = (function (){
var statearr_107858 = [null,null,null,null,null,null,null,null,null];
(statearr_107858[(0)] = fluree$db$storage$core$read_db_root_$_state_machine__100742__auto__);

(statearr_107858[(1)] = (1));

return statearr_107858;
});
var fluree$db$storage$core$read_db_root_$_state_machine__100742__auto____1 = (function (state_107847){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_107847);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e107859){if((e107859 instanceof Object)){
var ex__100745__auto__ = e107859;
var statearr_107860_107869 = state_107847;
(statearr_107860_107869[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_107847);

return cljs.core.cst$kw$recur;
} else {
throw e107859;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__107870 = state_107847;
state_107847 = G__107870;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$storage$core$read_db_root_$_state_machine__100742__auto__ = function(state_107847){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_db_root_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_db_root_$_state_machine__100742__auto____1.call(this,state_107847);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_db_root_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_db_root_$_state_machine__100742__auto____0;
fluree$db$storage$core$read_db_root_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_db_root_$_state_machine__100742__auto____1;
return fluree$db$storage$core$read_db_root_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_107861 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_107861[(6)] = c__100848__auto__);

return statearr_107861;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
/**
 * Reifies db at specified index point. If unable to read db-root at index, throws.
 */
fluree.db.storage.core.reify_db = (function fluree$db$storage$core$reify_db(conn,network,dbid,blank_db,index){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_107903){
var state_val_107904 = (state_107903[(1)]);
if((state_val_107904 === (7))){
var inst_107875 = (state_107903[(7)]);
var inst_107885 = (state_107903[(2)]);
var state_107903__$1 = (function (){var statearr_107905 = state_107903;
(statearr_107905[(8)] = inst_107885);

return statearr_107905;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_107903__$1,(8),inst_107875);
} else {
if((state_val_107904 === (1))){
var state_107903__$1 = state_107903;
var statearr_107906_107920 = state_107903__$1;
(statearr_107906_107920[(2)] = null);

(statearr_107906_107920[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107904 === (4))){
var inst_107875 = (state_107903[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_107903,(3),Error,null,(2));
var inst_107875__$1 = fluree.db.storage.core.read_db_root(conn,network,dbid,index);
var state_107903__$1 = (function (){var statearr_107907 = state_107903;
(statearr_107907[(7)] = inst_107875__$1);

return statearr_107907;
})();
if(cljs.core.truth_(inst_107875__$1)){
var statearr_107908_107921 = state_107903__$1;
(statearr_107908_107921[(1)] = (5));

} else {
var statearr_107909_107922 = state_107903__$1;
(statearr_107909_107922[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107904 === (6))){
var inst_107878 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)," could not be loaded at index point: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(index),"."].join('');
var inst_107879 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_107880 = [(400),cljs.core.cst$kw$db_SLASH_unavailable];
var inst_107881 = cljs.core.PersistentHashMap.fromArrays(inst_107879,inst_107880);
var inst_107882 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_107878,inst_107881);
var inst_107883 = (function(){throw inst_107882})();
var state_107903__$1 = state_107903;
var statearr_107910_107923 = state_107903__$1;
(statearr_107910_107923[(2)] = inst_107883);

(statearr_107910_107923[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107904 === (3))){
var inst_107871 = (state_107903[(2)]);
var state_107903__$1 = state_107903;
var statearr_107911_107924 = state_107903__$1;
(statearr_107911_107924[(2)] = inst_107871);


cljs.core.async.impl.ioc_helpers.process_exception(state_107903__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_107904 === (2))){
var inst_107901 = (state_107903[(2)]);
var state_107903__$1 = state_107903;
return cljs.core.async.impl.ioc_helpers.return_chan(state_107903__$1,inst_107901);
} else {
if((state_val_107904 === (9))){
var inst_107894 = (state_107903[(9)]);
var inst_107889 = (state_107903[(10)]);
var inst_107892 = (state_107903[(2)]);
var inst_107893 = fluree.db.util.async.throw_err(inst_107892);
var inst_107894__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_107889,cljs.core.cst$kw$schema,inst_107893);
var inst_107895 = fluree.db.query.schema.setting_map(inst_107894__$1);
var state_107903__$1 = (function (){var statearr_107912 = state_107903;
(statearr_107912[(9)] = inst_107894__$1);

return statearr_107912;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_107903__$1,(10),inst_107895);
} else {
if((state_val_107904 === (5))){
var state_107903__$1 = state_107903;
var statearr_107913_107925 = state_107903__$1;
(statearr_107913_107925[(2)] = null);

(statearr_107913_107925[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107904 === (10))){
var inst_107894 = (state_107903[(9)]);
var inst_107897 = (state_107903[(2)]);
var inst_107898 = fluree.db.util.async.throw_err(inst_107897);
var inst_107899 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_107894,cljs.core.cst$kw$settings,inst_107898);
var state_107903__$1 = state_107903;
var statearr_107914_107926 = state_107903__$1;
(statearr_107914_107926[(2)] = inst_107899);


cljs.core.async.impl.ioc_helpers.process_exception(state_107903__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_107904 === (8))){
var inst_107889 = (state_107903[(10)]);
var inst_107887 = (state_107903[(2)]);
var inst_107888 = fluree.db.util.async.throw_err(inst_107887);
var inst_107889__$1 = fluree.db.storage.core.reify_db_root(conn,blank_db,inst_107888);
var inst_107890 = fluree.db.query.schema.schema_map(inst_107889__$1);
var state_107903__$1 = (function (){var statearr_107915 = state_107903;
(statearr_107915[(10)] = inst_107889__$1);

return statearr_107915;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_107903__$1,(9),inst_107890);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_db_$_state_machine__100742__auto__ = null;
var fluree$db$storage$core$reify_db_$_state_machine__100742__auto____0 = (function (){
var statearr_107916 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_107916[(0)] = fluree$db$storage$core$reify_db_$_state_machine__100742__auto__);

(statearr_107916[(1)] = (1));

return statearr_107916;
});
var fluree$db$storage$core$reify_db_$_state_machine__100742__auto____1 = (function (state_107903){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_107903);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e107917){if((e107917 instanceof Object)){
var ex__100745__auto__ = e107917;
var statearr_107918_107927 = state_107903;
(statearr_107918_107927[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_107903);

return cljs.core.cst$kw$recur;
} else {
throw e107917;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__107928 = state_107903;
state_107903 = G__107928;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$storage$core$reify_db_$_state_machine__100742__auto__ = function(state_107903){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_db_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_db_$_state_machine__100742__auto____1.call(this,state_107903);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_db_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_db_$_state_machine__100742__auto____0;
fluree$db$storage$core$reify_db_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_db_$_state_machine__100742__auto____1;
return fluree$db$storage$core$reify_db_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_107919 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_107919[(6)] = c__100848__auto__);

return statearr_107919;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
/**
 * Returns a channel that will contains blocks in specified range.
 */
fluree.db.storage.core.block_range = (function fluree$db$storage$core$block_range(var_args){
var G__107930 = arguments.length;
switch (G__107930) {
case 4:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,network,dbid,start){
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5(conn,network,dbid,start,null);
}));

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,dbid,start,end){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Block-range request: ",network,dbid,start,end], 0));

var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_107976){
var state_val_107977 = (state_107976[(1)]);
if((state_val_107977 === (7))){
var inst_107942 = (state_107976[(2)]);
var inst_107943 = cljs.core.cst$kw$parallelism.cljs$core$IFn$_invoke$arity$1(conn);
var inst_107944 = cljs.core.PersistentVector.EMPTY;
var inst_107945 = start;
var inst_107946 = inst_107944;
var state_107976__$1 = (function (){var statearr_107978 = state_107976;
(statearr_107978[(7)] = inst_107945);

(statearr_107978[(8)] = inst_107942);

(statearr_107978[(9)] = inst_107946);

(statearr_107978[(10)] = inst_107943);

return statearr_107978;
})();
var statearr_107979_108007 = state_107976__$1;
(statearr_107979_108007[(2)] = null);

(statearr_107979_108007[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107977 === (1))){
var state_107976__$1 = state_107976;
var statearr_107980_108008 = state_107976__$1;
(statearr_107980_108008[(2)] = null);

(statearr_107980_108008[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107977 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_107976,(3),Error,null,(2));
var inst_107935 = (end >= start);
var state_107976__$1 = state_107976;
if(cljs.core.truth_(inst_107935)){
var statearr_107981_108009 = state_107976__$1;
(statearr_107981_108009[(1)] = (5));

} else {
var statearr_107982_108010 = state_107976__$1;
(statearr_107982_108010[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107977 === (15))){
var state_107976__$1 = state_107976;
var statearr_107983_108011 = state_107976__$1;
(statearr_107983_108011[(1)] = (17));



return cljs.core.cst$kw$recur;
} else {
if((state_val_107977 === (13))){
var inst_107970 = (state_107976[(2)]);
var state_107976__$1 = state_107976;
var statearr_107985_108012 = state_107976__$1;
(statearr_107985_108012[(2)] = inst_107970);

(statearr_107985_108012[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107977 === (6))){
var inst_107938 = ["Assert failed: ","Block range should be in ascending order, from earliest (smallest) block to most recent (largest) block.","\n","(>= end start)"].join('');
var inst_107939 = (new Error(inst_107938));
var inst_107940 = (function(){throw inst_107939})();
var state_107976__$1 = state_107976;
var statearr_107986_108013 = state_107976__$1;
(statearr_107986_108013[(2)] = inst_107940);

(statearr_107986_108013[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107977 === (17))){
var inst_107950 = (state_107976[(11)]);
var inst_107945 = (state_107976[(7)]);
var inst_107946 = (state_107976[(9)]);
var inst_107961 = (inst_107945 + (1));
var inst_107962 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_107946,inst_107950);
var inst_107945__$1 = inst_107961;
var inst_107946__$1 = inst_107962;
var state_107976__$1 = (function (){var statearr_107987 = state_107976;
(statearr_107987[(7)] = inst_107945__$1);

(statearr_107987[(9)] = inst_107946__$1);

return statearr_107987;
})();
var statearr_107988_108014 = state_107976__$1;
(statearr_107988_108014[(2)] = null);

(statearr_107988_108014[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107977 === (3))){
var inst_107931 = (state_107976[(2)]);
var state_107976__$1 = state_107976;
var statearr_107989_108015 = state_107976__$1;
(statearr_107989_108015[(2)] = inst_107931);


cljs.core.async.impl.ioc_helpers.process_exception(state_107976__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_107977 === (12))){
var inst_107945 = (state_107976[(7)]);
var inst_107956 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_107945,end);
var state_107976__$1 = state_107976;
if(inst_107956){
var statearr_107990_108016 = state_107976__$1;
(statearr_107990_108016[(1)] = (14));

} else {
var statearr_107991_108017 = state_107976__$1;
(statearr_107991_108017[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107977 === (2))){
var inst_107974 = (state_107976[(2)]);
var state_107976__$1 = state_107976;
return cljs.core.async.impl.ioc_helpers.return_chan(state_107976__$1,inst_107974);
} else {
if((state_val_107977 === (19))){
var inst_107966 = (state_107976[(2)]);
var state_107976__$1 = state_107976;
var statearr_107992_108018 = state_107976__$1;
(statearr_107992_108018[(2)] = inst_107966);

(statearr_107992_108018[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107977 === (11))){
var inst_107946 = (state_107976[(9)]);
var state_107976__$1 = state_107976;
var statearr_107993_108019 = state_107976__$1;
(statearr_107993_108019[(2)] = inst_107946);

(statearr_107993_108019[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107977 === (9))){
var inst_107972 = (state_107976[(2)]);
var state_107976__$1 = state_107976;
var statearr_107994_108020 = state_107976__$1;
(statearr_107994_108020[(2)] = inst_107972);


cljs.core.async.impl.ioc_helpers.process_exception(state_107976__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_107977 === (5))){
var state_107976__$1 = state_107976;
var statearr_107995_108021 = state_107976__$1;
(statearr_107995_108021[(2)] = null);

(statearr_107995_108021[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107977 === (14))){
var inst_107950 = (state_107976[(11)]);
var inst_107946 = (state_107976[(9)]);
var inst_107958 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_107946,inst_107950);
var state_107976__$1 = state_107976;
var statearr_107996_108022 = state_107976__$1;
(statearr_107996_108022[(2)] = inst_107958);

(statearr_107996_108022[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107977 === (16))){
var inst_107968 = (state_107976[(2)]);
var state_107976__$1 = state_107976;
var statearr_107997_108023 = state_107976__$1;
(statearr_107997_108023[(2)] = inst_107968);

(statearr_107997_108023[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107977 === (10))){
var inst_107950 = (state_107976[(11)]);
var inst_107950__$1 = (state_107976[(2)]);
var inst_107951 = (inst_107950__$1 == null);
var inst_107952 = (inst_107950__$1 instanceof Error);
var inst_107953 = ((inst_107951) || (inst_107952));
var state_107976__$1 = (function (){var statearr_107998 = state_107976;
(statearr_107998[(11)] = inst_107950__$1);

return statearr_107998;
})();
if(cljs.core.truth_(inst_107953)){
var statearr_107999_108024 = state_107976__$1;
(statearr_107999_108024[(1)] = (11));

} else {
var statearr_108000_108025 = state_107976__$1;
(statearr_108000_108025[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107977 === (18))){
var state_107976__$1 = state_107976;
var statearr_108001_108026 = state_107976__$1;
(statearr_108001_108026[(2)] = null);

(statearr_108001_108026[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107977 === (8))){
var inst_107945 = (state_107976[(7)]);
var inst_107948 = fluree.db.storage.core.read_block(conn,network,dbid,inst_107945);
var state_107976__$1 = state_107976;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_107976__$1,(10),inst_107948);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__100742__auto__ = null;
var fluree$db$storage$core$state_machine__100742__auto____0 = (function (){
var statearr_108002 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_108002[(0)] = fluree$db$storage$core$state_machine__100742__auto__);

(statearr_108002[(1)] = (1));

return statearr_108002;
});
var fluree$db$storage$core$state_machine__100742__auto____1 = (function (state_107976){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_107976);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e108003){if((e108003 instanceof Object)){
var ex__100745__auto__ = e108003;
var statearr_108004_108027 = state_107976;
(statearr_108004_108027[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_107976);

return cljs.core.cst$kw$recur;
} else {
throw e108003;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__108028 = state_107976;
state_107976 = G__108028;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__100742__auto__ = function(state_107976){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__100742__auto____1.call(this,state_107976);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__100742__auto____0;
fluree$db$storage$core$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__100742__auto____1;
return fluree$db$storage$core$state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_108005 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_108005[(6)] = c__100848__auto__);

return statearr_108005;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
}));

(fluree.db.storage.core.block_range.cljs$lang$maxFixedArity = 5);

/**
 * Reads a single block from storage
 */
fluree.db.storage.core.block = (function fluree$db$storage$core$block(conn,network,dbid,block){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_108041){
var state_val_108042 = (state_108041[(1)]);
if((state_val_108042 === (1))){
var state_108041__$1 = state_108041;
var statearr_108043_108050 = state_108041__$1;
(statearr_108043_108050[(2)] = null);

(statearr_108043_108050[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108042 === (2))){
var inst_108039 = (state_108041[(2)]);
var state_108041__$1 = state_108041;
return cljs.core.async.impl.ioc_helpers.return_chan(state_108041__$1,inst_108039);
} else {
if((state_val_108042 === (3))){
var inst_108029 = (state_108041[(2)]);
var state_108041__$1 = state_108041;
var statearr_108044_108051 = state_108041__$1;
(statearr_108044_108051[(2)] = inst_108029);


cljs.core.async.impl.ioc_helpers.process_exception(state_108041__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_108042 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_108041,(3),Error,null,(2));
var inst_108033 = fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5(conn,network,dbid,block,block);
var state_108041__$1 = state_108041;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_108041__$1,(5),inst_108033);
} else {
if((state_val_108042 === (5))){
var inst_108035 = (state_108041[(2)]);
var inst_108036 = fluree.db.util.async.throw_err(inst_108035);
var inst_108037 = cljs.core.first(inst_108036);
var state_108041__$1 = state_108041;
var statearr_108045_108052 = state_108041__$1;
(statearr_108045_108052[(2)] = inst_108037);


cljs.core.async.impl.ioc_helpers.process_exception(state_108041__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$block_$_state_machine__100742__auto__ = null;
var fluree$db$storage$core$block_$_state_machine__100742__auto____0 = (function (){
var statearr_108046 = [null,null,null,null,null,null,null];
(statearr_108046[(0)] = fluree$db$storage$core$block_$_state_machine__100742__auto__);

(statearr_108046[(1)] = (1));

return statearr_108046;
});
var fluree$db$storage$core$block_$_state_machine__100742__auto____1 = (function (state_108041){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_108041);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e108047){if((e108047 instanceof Object)){
var ex__100745__auto__ = e108047;
var statearr_108048_108053 = state_108041;
(statearr_108048_108053[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_108041);

return cljs.core.cst$kw$recur;
} else {
throw e108047;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__108054 = state_108041;
state_108041 = G__108054;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$storage$core$block_$_state_machine__100742__auto__ = function(state_108041){
switch(arguments.length){
case 0:
return fluree$db$storage$core$block_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$storage$core$block_$_state_machine__100742__auto____1.call(this,state_108041);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$block_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$block_$_state_machine__100742__auto____0;
fluree$db$storage$core$block_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$block_$_state_machine__100742__auto____1;
return fluree$db$storage$core$block_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_108049 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_108049[(6)] = c__100848__auto__);

return statearr_108049;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
