// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true}
goog.provide('fluree.db.query.range');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
/**
 * Checks whether an index range is :spot, starts with [s1 -1 o1] and ends with [s1 int/max p1]
 */
fluree.db.query.range.value_with_nil_pred = (function fluree$db$query$range$value_with_nil_pred(idx,start_flake,end_flake){
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$spot,idx)) && ((!((start_flake.o == null)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(start_flake.o,end_flake.o)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),start_flake.p)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.MAX_PREDICATE_ID,end_flake.p)));
});
/**
 * Will throw if predicate doesn't exist.
 */
fluree.db.query.range.pred_id_strict = (function fluree$db$query$range$pred_id_strict(db,p){
if(cljs.core.truth_(p)){
var or__4126__auto__ = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate, does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
} else {
return null;
}
});
/**
 * Takes a match from index-range, and based on the index
 *   returns flake-ordered components of [s p o t op m].
 *   Coerces idents and string predicate names.
 */
fluree.db.query.range.match__GT_flake_parts = (function fluree$db$query$range$match__GT_flake_parts(db,idx,match){
var vec__103467 = match;
var p1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__103467,(0),null);
var p2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__103467,(1),null);
var p3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__103467,(2),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__103467,(3),null);
var op = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__103467,(4),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__103467,(5),null);
var G__103470 = idx;
var G__103470__$1 = (((G__103470 instanceof cljs.core.Keyword))?G__103470.fqn:null);
switch (G__103470__$1) {
case "spot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p2),p3,t,op,m], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p1),p3,t,op,m], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p1),p2,t,op,m], null);

break;
case "opst":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p2),p1,t,op,m], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__103470__$1)].join('')));

}
});
fluree.db.query.range.subject_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.max_long], null);
fluree.db.query.range.subject_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null);
fluree.db.query.range.pred_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
fluree.db.query.range.pred_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.MAX_PREDICATE_ID], null);
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.min_match = (function fluree$db$query$range$min_match(idx){
var G__103472 = idx;
var G__103472__$1 = (((G__103472 instanceof cljs.core.Keyword))?G__103472.fqn:null);
switch (G__103472__$1) {
case "spot":
return fluree.db.query.range.subject_min_match;

break;
case "psot":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "opst":
return fluree.db.query.range.subject_min_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__103472__$1)].join('')));

}
});
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.max_match = (function fluree$db$query$range$max_match(idx){
var G__103474 = idx;
var G__103474__$1 = (((G__103474 instanceof cljs.core.Keyword))?G__103474.fqn:null);
switch (G__103474__$1) {
case "spot":
return fluree.db.query.range.subject_max_match;

break;
case "psot":
return fluree.db.query.range.pred_max_match;

break;
case "post":
return fluree.db.query.range.pred_max_match;

break;
case "opst":
return fluree.db.query.range.subject_max_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__103474__$1)].join('')));

}
});
/**
 * Range query across an index.
 * 
 *   Uses a DB, but in the future support supplying a connection and db name, as we don't need a 't'
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :from-t - start transaction (transaction 't' is negative, so smallest number is most recent). Defaults to db's t
 *   :to-t - stop transaction - can be null, which pulls full history
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.time_range = (function fluree$db$query$range$time_range(var_args){
var G__103477 = arguments.length;
switch (G__103477) {
case 2:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__103478 = (function (){var pred__103481 = cljs.core.identical_QMARK_;
var expr__103482 = test;
if(cljs.core.truth_((pred__103481.cljs$core$IFn$_invoke$arity$2 ? pred__103481.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__103482) : pred__103481.call(null,cljs.core._EQ_,expr__103482)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__103481.cljs$core$IFn$_invoke$arity$2 ? pred__103481.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__103482) : pred__103481.call(null,cljs.core._LT_,expr__103482)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__103481.cljs$core$IFn$_invoke$arity$2 ? pred__103481.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__103482) : pred__103481.call(null,cljs.core._LT__EQ_,expr__103482)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__103481.cljs$core$IFn$_invoke$arity$2 ? pred__103481.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__103482) : pred__103481.call(null,cljs.core._GT_,expr__103482)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__103481.cljs$core$IFn$_invoke$arity$2 ? pred__103481.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__103482) : pred__103481.call(null,cljs.core._GT__EQ_,expr__103482)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__103482)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__103478,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__103478,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__103478,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__103478,(3),null);
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_103692){
var state_val_103693 = (state_103692[(1)]);
if((state_val_103693 === (65))){
var inst_103645 = (state_103692[(7)]);
var inst_103653 = (state_103692[(8)]);
var inst_103646 = (state_103692[(9)]);
var inst_103660 = (inst_103645 + (1));
var tmp103694 = inst_103646;
var inst_103644 = inst_103653;
var inst_103645__$1 = inst_103660;
var inst_103646__$1 = tmp103694;
var state_103692__$1 = (function (){var statearr_103695 = state_103692;
(statearr_103695[(7)] = inst_103645__$1);

(statearr_103695[(9)] = inst_103646__$1);

(statearr_103695[(10)] = inst_103644);

return statearr_103695;
})();
var statearr_103696_103803 = state_103692__$1;
(statearr_103696_103803[(2)] = null);

(statearr_103696_103803[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (70))){
var inst_103667 = (state_103692[(11)]);
var state_103692__$1 = state_103692;
var statearr_103697_103804 = state_103692__$1;
(statearr_103697_103804[(2)] = inst_103667);

(statearr_103697_103804[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (62))){
var inst_103645 = (state_103692[(7)]);
var inst_103586 = (state_103692[(12)]);
var inst_103644 = (state_103692[(10)]);
var inst_103651 = cljs.core.seq(inst_103644);
var inst_103652 = cljs.core.first(inst_103651);
var inst_103653 = cljs.core.next(inst_103651);
var inst_103654 = (inst_103652 == null);
var inst_103655 = (inst_103645 > inst_103586);
var inst_103656 = ((inst_103654) || (inst_103655));
var state_103692__$1 = (function (){var statearr_103698 = state_103692;
(statearr_103698[(8)] = inst_103653);

return statearr_103698;
})();
if(cljs.core.truth_(inst_103656)){
var statearr_103699_103805 = state_103692__$1;
(statearr_103699_103805[(1)] = (64));

} else {
var statearr_103700_103806 = state_103692__$1;
(statearr_103700_103806[(1)] = (65));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (7))){
var inst_103502 = (state_103692[(13)]);
var inst_103516 = (state_103692[(2)]);
var inst_103517 = fluree.db.util.core.pred_ident_QMARK_(inst_103502);
var state_103692__$1 = (function (){var statearr_103701 = state_103692;
(statearr_103701[(14)] = inst_103516);

return statearr_103701;
})();
if(inst_103517){
var statearr_103702_103807 = state_103692__$1;
(statearr_103702_103807[(1)] = (9));

} else {
var statearr_103703_103808 = state_103692__$1;
(statearr_103703_103808[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (59))){
var inst_103586 = (state_103692[(12)]);
var inst_103614 = (state_103692[(15)]);
var inst_103627 = (state_103692[(16)]);
var inst_103613 = (state_103692[(17)]);
var inst_103630 = (inst_103586 - inst_103613);
var inst_103631 = fluree.db.flake.take(inst_103630,inst_103627);
var inst_103632 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_103631,inst_103614);
var state_103692__$1 = state_103692;
var statearr_103704_103809 = state_103692__$1;
(statearr_103704_103809[(2)] = inst_103632);

(statearr_103704_103809[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (20))){
var inst_103539 = (state_103692[(2)]);
var inst_103540 = fluree.db.util.async.throw_err(inst_103539);
var state_103692__$1 = state_103692;
var statearr_103705_103810 = state_103692__$1;
(statearr_103705_103810[(2)] = inst_103540);

(statearr_103705_103810[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (72))){
var inst_103686 = (state_103692[(2)]);
var state_103692__$1 = state_103692;
var statearr_103706_103811 = state_103692__$1;
(statearr_103706_103811[(2)] = inst_103686);

(statearr_103706_103811[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (58))){
var inst_103612 = (state_103692[(18)]);
var inst_103627 = (state_103692[(2)]);
var inst_103628 = fluree.db.dbproto._rhs(inst_103612);
var state_103692__$1 = (function (){var statearr_103707 = state_103692;
(statearr_103707[(19)] = inst_103628);

(statearr_103707[(16)] = inst_103627);

return statearr_103707;
})();
var statearr_103708_103812 = state_103692__$1;
(statearr_103708_103812[(1)] = (59));



return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (60))){
var inst_103627 = (state_103692[(16)]);
var inst_103613 = (state_103692[(17)]);
var inst_103641 = cljs.core.seq(inst_103627);
var inst_103642 = cljs.core.first(inst_103641);
var inst_103643 = cljs.core.next(inst_103641);
var inst_103644 = inst_103627;
var inst_103645 = inst_103613;
var inst_103646 = inst_103627;
var state_103692__$1 = (function (){var statearr_103710 = state_103692;
(statearr_103710[(7)] = inst_103645);

(statearr_103710[(20)] = inst_103643);

(statearr_103710[(21)] = inst_103642);

(statearr_103710[(9)] = inst_103646);

(statearr_103710[(10)] = inst_103644);

return statearr_103710;
})();
var statearr_103711_103813 = state_103692__$1;
(statearr_103711_103813[(2)] = null);

(statearr_103711_103813[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (27))){
var inst_103543 = (state_103692[(22)]);
var state_103692__$1 = state_103692;
var statearr_103712_103814 = state_103692__$1;
(statearr_103712_103814[(2)] = inst_103543);

(statearr_103712_103814[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (1))){
var state_103692__$1 = state_103692;
var statearr_103713_103815 = state_103692__$1;
(statearr_103713_103815[(2)] = null);

(statearr_103713_103815[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (69))){
var inst_103676 = (state_103692[(2)]);
var inst_103677 = cljs.core.not(inst_103676);
var state_103692__$1 = state_103692;
if(inst_103677){
var statearr_103714_103816 = state_103692__$1;
(statearr_103714_103816[(1)] = (70));

} else {
var statearr_103715_103817 = state_103692__$1;
(statearr_103715_103817[(1)] = (71));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (24))){
var state_103692__$1 = state_103692;
var statearr_103716_103818 = state_103692__$1;
(statearr_103716_103818[(2)] = (-1));

(statearr_103716_103818[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (55))){
var inst_103581 = (state_103692[(23)]);
var inst_103580 = (state_103692[(24)]);
var inst_103619 = (state_103692[(25)]);
var inst_103618 = (state_103692[(2)]);
var inst_103619__$1 = fluree.db.util.async.throw_err(inst_103618);
var inst_103620 = fluree.db.flake.subrange(inst_103619__$1,start_test,inst_103580,end_test,inst_103581);
var inst_103621 = fluree.db.query.range.value_with_nil_pred(idx,inst_103580,inst_103581);
var state_103692__$1 = (function (){var statearr_103717 = state_103692;
(statearr_103717[(26)] = inst_103620);

(statearr_103717[(25)] = inst_103619__$1);

return statearr_103717;
})();
if(inst_103621){
var statearr_103718_103819 = state_103692__$1;
(statearr_103718_103819[(1)] = (56));

} else {
var statearr_103719_103820 = state_103692__$1;
(statearr_103719_103820[(1)] = (57));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (39))){
var inst_103507 = (state_103692[(27)]);
var state_103692__$1 = state_103692;
var statearr_103720_103821 = state_103692__$1;
(statearr_103720_103821[(2)] = inst_103507);

(statearr_103720_103821[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (46))){
var state_103692__$1 = state_103692;
var statearr_103721_103822 = state_103692__$1;
(statearr_103721_103822[(2)] = fluree.db.util.core.max_long);

(statearr_103721_103822[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (4))){
var inst_103494 = (state_103692[(28)]);
var inst_103501 = (state_103692[(29)]);
var inst_103495 = (state_103692[(30)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_103692,(3),Error,null,(2));
var inst_103494__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var inst_103495__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_103494__$1,(0),null);
var inst_103496 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_103494__$1,(1),null);
var inst_103497 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_103494__$1,(2),null);
var inst_103498 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_103494__$1,(3),null);
var inst_103499 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_103494__$1,(4),null);
var inst_103500 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_103494__$1,(5),null);
var inst_103501__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var inst_103502 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_103501__$1,(0),null);
var inst_103503 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_103501__$1,(1),null);
var inst_103504 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_103501__$1,(2),null);
var inst_103505 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_103501__$1,(3),null);
var inst_103506 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_103501__$1,(4),null);
var inst_103507 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_103501__$1,(5),null);
var inst_103508 = fluree.db.util.core.pred_ident_QMARK_(inst_103495__$1);
var state_103692__$1 = (function (){var statearr_103722 = state_103692;
(statearr_103722[(31)] = inst_103505);

(statearr_103722[(28)] = inst_103494__$1);

(statearr_103722[(32)] = inst_103503);

(statearr_103722[(33)] = inst_103506);

(statearr_103722[(34)] = inst_103504);

(statearr_103722[(35)] = inst_103499);

(statearr_103722[(36)] = inst_103497);

(statearr_103722[(37)] = inst_103500);

(statearr_103722[(13)] = inst_103502);

(statearr_103722[(38)] = inst_103498);

(statearr_103722[(39)] = inst_103496);

(statearr_103722[(29)] = inst_103501__$1);

(statearr_103722[(27)] = inst_103507);

(statearr_103722[(30)] = inst_103495__$1);

return statearr_103722;
})();
if(inst_103508){
var statearr_103723_103823 = state_103692__$1;
(statearr_103723_103823[(1)] = (5));

} else {
var statearr_103724_103824 = state_103692__$1;
(statearr_103724_103824[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (54))){
var inst_103688 = (state_103692[(2)]);
var state_103692__$1 = state_103692;
var statearr_103725_103825 = state_103692__$1;
(statearr_103725_103825[(2)] = inst_103688);


cljs.core.async.impl.ioc_helpers.process_exception(state_103692__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (15))){
var inst_103504 = (state_103692[(34)]);
var inst_103534 = (state_103692[(2)]);
var inst_103535 = fluree.db.util.core.pred_ident_QMARK_(inst_103504);
var state_103692__$1 = (function (){var statearr_103726 = state_103692;
(statearr_103726[(40)] = inst_103534);

return statearr_103726;
})();
if(inst_103535){
var statearr_103727_103826 = state_103692__$1;
(statearr_103727_103826[(1)] = (17));

} else {
var statearr_103728_103827 = state_103692__$1;
(statearr_103728_103827[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (48))){
var inst_103592 = (state_103692[(41)]);
var state_103692__$1 = state_103692;
var statearr_103729_103828 = state_103692__$1;
(statearr_103729_103828[(2)] = inst_103592);

(statearr_103729_103828[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (50))){
var inst_103597 = (state_103692[(2)]);
var inst_103598 = cljs.core.cst$kw$to_DASH_t.cljs$core$IFn$_invoke$arity$1(opts);
var inst_103599 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_103600 = [cljs.core.cst$kw$novelty,idx];
var inst_103601 = (new cljs.core.PersistentVector(null,2,(5),inst_103599,inst_103600,null));
var inst_103602 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_103601);
var inst_103603 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_103604 = fluree.db.dbproto._resolve(inst_103603);
var state_103692__$1 = (function (){var statearr_103730 = state_103692;
(statearr_103730[(42)] = inst_103602);

(statearr_103730[(43)] = inst_103597);

(statearr_103730[(44)] = inst_103598);

return statearr_103730;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_103692__$1,(51),inst_103604);
} else {
if((state_val_103693 === (21))){
var inst_103534 = (state_103692[(40)]);
var state_103692__$1 = state_103692;
var statearr_103731_103829 = state_103692__$1;
(statearr_103731_103829[(2)] = inst_103534);

(statearr_103731_103829[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (31))){
var inst_103503 = (state_103692[(32)]);
var state_103692__$1 = state_103692;
var statearr_103732_103830 = state_103692__$1;
(statearr_103732_103830[(2)] = inst_103503);

(statearr_103732_103830[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (32))){
var inst_103500 = (state_103692[(37)]);
var inst_103561 = (state_103692[(2)]);
var state_103692__$1 = (function (){var statearr_103733 = state_103692;
(statearr_103733[(45)] = inst_103561);

return statearr_103733;
})();
if(cljs.core.truth_(inst_103500)){
var statearr_103734_103831 = state_103692__$1;
(statearr_103734_103831[(1)] = (33));

} else {
var statearr_103735_103832 = state_103692__$1;
(statearr_103735_103832[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (40))){
var inst_103573 = (cljs.core._LT__EQ_ === end_test);
var state_103692__$1 = state_103692;
if(cljs.core.truth_(inst_103573)){
var statearr_103736_103833 = state_103692__$1;
(statearr_103736_103833[(1)] = (42));

} else {
var statearr_103737_103834 = state_103692__$1;
(statearr_103737_103834[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (56))){
var inst_103586 = (state_103692[(12)]);
var inst_103516 = (state_103692[(14)]);
var inst_103581 = (state_103692[(23)]);
var inst_103602 = (state_103692[(42)]);
var inst_103505 = (state_103692[(31)]);
var inst_103552 = (state_103692[(46)]);
var inst_103494 = (state_103692[(28)]);
var inst_103506 = (state_103692[(33)]);
var inst_103614 = (state_103692[(15)]);
var inst_103499 = (state_103692[(35)]);
var inst_103561 = (state_103692[(45)]);
var inst_103597 = (state_103692[(43)]);
var inst_103607 = (state_103692[(47)]);
var inst_103620 = (state_103692[(26)]);
var inst_103498 = (state_103692[(38)]);
var inst_103543 = (state_103692[(22)]);
var inst_103534 = (state_103692[(40)]);
var inst_103587 = (state_103692[(48)]);
var inst_103591 = (state_103692[(49)]);
var inst_103580 = (state_103692[(24)]);
var inst_103501 = (state_103692[(29)]);
var inst_103598 = (state_103692[(44)]);
var inst_103525 = (state_103692[(50)]);
var inst_103613 = (state_103692[(17)]);
var inst_103579 = (state_103692[(51)]);
var inst_103612 = (state_103692[(18)]);
var inst_103570 = (state_103692[(52)]);
var inst_103619 = (state_103692[(25)]);
var inst_103623 = (function (){var no_filter_QMARK_ = true;
var next_node = inst_103612;
var flakes = inst_103619;
var s1 = inst_103516;
var o2 = inst_103543;
var t1 = inst_103498;
var i = inst_103613;
var m1 = inst_103570;
var root_node = inst_103607;
var to_t = inst_103598;
var s2 = inst_103525;
var vec__103491 = inst_103501;
var p2 = inst_103561;
var permissions = inst_103587;
var limit = inst_103586;
var start_flake = inst_103580;
var acc = inst_103614;
var t2 = inst_103505;
var op1 = inst_103499;
var o1 = inst_103534;
var end_flake = inst_103581;
var base_result = inst_103620;
var p1 = inst_103552;
var idx_compare = inst_103591;
var vec__103488 = inst_103494;
var op2 = inst_103506;
var from_t = inst_103597;
var m2 = inst_103579;
var novelty = inst_103602;
return (function (filtered_result,f){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.o,start_flake.o)){
return filtered_result;
} else {
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(filtered_result,f);
}
});
})();
var inst_103624 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_103623,inst_103620,inst_103620);
var state_103692__$1 = state_103692;
var statearr_103738_103835 = state_103692__$1;
(statearr_103738_103835[(2)] = inst_103624);

(statearr_103738_103835[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (33))){
var inst_103500 = (state_103692[(37)]);
var state_103692__$1 = state_103692;
var statearr_103739_103836 = state_103692__$1;
(statearr_103739_103836[(2)] = inst_103500);

(statearr_103739_103836[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (13))){
var inst_103497 = (state_103692[(36)]);
var inst_103528 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_103497);
var state_103692__$1 = state_103692;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_103692__$1,(16),inst_103528);
} else {
if((state_val_103693 === (22))){
var state_103692__$1 = state_103692;
var statearr_103740_103837 = state_103692__$1;
(statearr_103740_103837[(2)] = false);

(statearr_103740_103837[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (36))){
var state_103692__$1 = state_103692;
var statearr_103741_103838 = state_103692__$1;
(statearr_103741_103838[(2)] = fluree.db.util.core.min_integer);

(statearr_103741_103838[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (41))){
var inst_103516 = (state_103692[(14)]);
var inst_103582 = (state_103692[(53)]);
var inst_103505 = (state_103692[(31)]);
var inst_103552 = (state_103692[(46)]);
var inst_103506 = (state_103692[(33)]);
var inst_103499 = (state_103692[(35)]);
var inst_103561 = (state_103692[(45)]);
var inst_103498 = (state_103692[(38)]);
var inst_103543 = (state_103692[(22)]);
var inst_103534 = (state_103692[(40)]);
var inst_103525 = (state_103692[(50)]);
var inst_103579 = (state_103692[(51)]);
var inst_103570 = (state_103692[(52)]);
var inst_103579__$1 = (state_103692[(2)]);
var inst_103580 = fluree.db.flake.__GT_Flake(inst_103516,inst_103552,inst_103534,inst_103498,inst_103499,inst_103570);
var inst_103581 = fluree.db.flake.__GT_Flake(inst_103525,inst_103561,inst_103543,inst_103505,inst_103506,inst_103579__$1);
var inst_103582__$1 = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(opts);
var state_103692__$1 = (function (){var statearr_103742 = state_103692;
(statearr_103742[(53)] = inst_103582__$1);

(statearr_103742[(23)] = inst_103581);

(statearr_103742[(24)] = inst_103580);

(statearr_103742[(51)] = inst_103579__$1);

return statearr_103742;
})();
if(cljs.core.truth_(inst_103582__$1)){
var statearr_103743_103839 = state_103692__$1;
(statearr_103743_103839[(1)] = (45));

} else {
var statearr_103744_103840 = state_103692__$1;
(statearr_103744_103840[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (43))){
var state_103692__$1 = state_103692;
var statearr_103745_103841 = state_103692__$1;
(statearr_103745_103841[(2)] = fluree.db.util.core.min_integer);

(statearr_103745_103841[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (61))){
var inst_103628 = (state_103692[(19)]);
var inst_103667 = (state_103692[(11)]);
var inst_103667__$1 = (state_103692[(2)]);
var inst_103668 = cljs.core.count(inst_103667__$1);
var state_103692__$1 = (function (){var statearr_103746 = state_103692;
(statearr_103746[(54)] = inst_103668);

(statearr_103746[(11)] = inst_103667__$1);

return statearr_103746;
})();
if(cljs.core.truth_(inst_103628)){
var statearr_103747_103842 = state_103692__$1;
(statearr_103747_103842[(1)] = (67));

} else {
var statearr_103748_103843 = state_103692__$1;
(statearr_103748_103843[(1)] = (68));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (29))){
var inst_103557 = (state_103692[(2)]);
var state_103692__$1 = state_103692;
if(cljs.core.truth_(inst_103557)){
var statearr_103749_103844 = state_103692__$1;
(statearr_103749_103844[(1)] = (30));

} else {
var statearr_103750_103845 = state_103692__$1;
(statearr_103750_103845[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (44))){
var inst_103577 = (state_103692[(2)]);
var state_103692__$1 = state_103692;
var statearr_103751_103846 = state_103692__$1;
(statearr_103751_103846[(2)] = inst_103577);

(statearr_103751_103846[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (6))){
var inst_103495 = (state_103692[(30)]);
var state_103692__$1 = state_103692;
var statearr_103752_103847 = state_103692__$1;
(statearr_103752_103847[(2)] = inst_103495);

(statearr_103752_103847[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (28))){
var state_103692__$1 = state_103692;
var statearr_103753_103848 = state_103692__$1;
(statearr_103753_103848[(2)] = false);

(statearr_103753_103848[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (64))){
var inst_103614 = (state_103692[(15)]);
var inst_103646 = (state_103692[(9)]);
var inst_103658 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_103646,inst_103614);
var state_103692__$1 = state_103692;
var statearr_103754_103849 = state_103692__$1;
(statearr_103754_103849[(2)] = inst_103658);

(statearr_103754_103849[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (51))){
var inst_103607 = (state_103692[(47)]);
var inst_103580 = (state_103692[(24)]);
var inst_103606 = (state_103692[(2)]);
var inst_103607__$1 = fluree.db.util.async.throw_err(inst_103606);
var inst_103608 = fluree.db.dbproto._lookup_leaf(inst_103607__$1,inst_103580);
var state_103692__$1 = (function (){var statearr_103755 = state_103692;
(statearr_103755[(47)] = inst_103607__$1);

return statearr_103755;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_103692__$1,(52),inst_103608);
} else {
if((state_val_103693 === (25))){
var inst_103496 = (state_103692[(39)]);
var state_103692__$1 = state_103692;
var statearr_103756_103850 = state_103692__$1;
(statearr_103756_103850[(2)] = inst_103496);

(statearr_103756_103850[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (34))){
var inst_103564 = (cljs.core._GT__EQ_ === start_test);
var state_103692__$1 = state_103692;
if(cljs.core.truth_(inst_103564)){
var statearr_103757_103851 = state_103692__$1;
(statearr_103757_103851[(1)] = (36));

} else {
var statearr_103758_103852 = state_103692__$1;
(statearr_103758_103852[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (17))){
var inst_103504 = (state_103692[(34)]);
var inst_103537 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_103504);
var state_103692__$1 = state_103692;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_103692__$1,(20),inst_103537);
} else {
if((state_val_103693 === (3))){
var inst_103484 = (state_103692[(2)]);
var state_103692__$1 = state_103692;
var statearr_103759_103853 = state_103692__$1;
(statearr_103759_103853[(2)] = inst_103484);


cljs.core.async.impl.ioc_helpers.process_exception(state_103692__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (12))){
var inst_103521 = (state_103692[(2)]);
var inst_103522 = fluree.db.util.async.throw_err(inst_103521);
var state_103692__$1 = state_103692;
var statearr_103760_103854 = state_103692__$1;
(statearr_103760_103854[(2)] = inst_103522);

(statearr_103760_103854[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (2))){
var inst_103690 = (state_103692[(2)]);
var state_103692__$1 = state_103692;
return cljs.core.async.impl.ioc_helpers.return_chan(state_103692__$1,inst_103690);
} else {
if((state_val_103693 === (66))){
var inst_103663 = (state_103692[(2)]);
var state_103692__$1 = state_103692;
var statearr_103761_103855 = state_103692__$1;
(statearr_103761_103855[(2)] = inst_103663);

(statearr_103761_103855[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (23))){
var inst_103548 = (state_103692[(2)]);
var state_103692__$1 = state_103692;
if(cljs.core.truth_(inst_103548)){
var statearr_103762_103856 = state_103692__$1;
(statearr_103762_103856[(1)] = (24));

} else {
var statearr_103763_103857 = state_103692__$1;
(statearr_103763_103857[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (47))){
var inst_103592 = (state_103692[(41)]);
var inst_103586 = (state_103692[(2)]);
var inst_103587 = cljs.core.cst$kw$permissions.cljs$core$IFn$_invoke$arity$1(db);
var inst_103588 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_103589 = [cljs.core.cst$kw$index_DASH_configs,idx,cljs.core.cst$kw$comparator];
var inst_103590 = (new cljs.core.PersistentVector(null,3,(5),inst_103588,inst_103589,null));
var inst_103591 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_103590);
var inst_103592__$1 = cljs.core.cst$kw$from_DASH_t.cljs$core$IFn$_invoke$arity$1(opts);
var state_103692__$1 = (function (){var statearr_103764 = state_103692;
(statearr_103764[(12)] = inst_103586);

(statearr_103764[(48)] = inst_103587);

(statearr_103764[(49)] = inst_103591);

(statearr_103764[(41)] = inst_103592__$1);

return statearr_103764;
})();
if(cljs.core.truth_(inst_103592__$1)){
var statearr_103765_103858 = state_103692__$1;
(statearr_103765_103858[(1)] = (48));

} else {
var statearr_103766_103859 = state_103692__$1;
(statearr_103766_103859[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (35))){
var inst_103507 = (state_103692[(27)]);
var inst_103570 = (state_103692[(2)]);
var state_103692__$1 = (function (){var statearr_103767 = state_103692;
(statearr_103767[(52)] = inst_103570);

return statearr_103767;
})();
if(cljs.core.truth_(inst_103507)){
var statearr_103768_103860 = state_103692__$1;
(statearr_103768_103860[(1)] = (39));

} else {
var statearr_103769_103861 = state_103692__$1;
(statearr_103769_103861[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (19))){
var inst_103496 = (state_103692[(39)]);
var inst_103543 = (state_103692[(2)]);
var inst_103544 = (inst_103496 == null);
var state_103692__$1 = (function (){var statearr_103770 = state_103692;
(statearr_103770[(22)] = inst_103543);

return statearr_103770;
})();
if(cljs.core.truth_(inst_103544)){
var statearr_103771_103862 = state_103692__$1;
(statearr_103771_103862[(1)] = (21));

} else {
var statearr_103772_103863 = state_103692__$1;
(statearr_103772_103863[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (57))){
var inst_103620 = (state_103692[(26)]);
var state_103692__$1 = state_103692;
var statearr_103773_103864 = state_103692__$1;
(statearr_103773_103864[(2)] = inst_103620);

(statearr_103773_103864[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (68))){
var inst_103628 = (state_103692[(19)]);
var state_103692__$1 = state_103692;
var statearr_103774_103865 = state_103692__$1;
(statearr_103774_103865[(2)] = inst_103628);

(statearr_103774_103865[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (11))){
var inst_103497 = (state_103692[(36)]);
var inst_103525 = (state_103692[(2)]);
var inst_103526 = fluree.db.util.core.pred_ident_QMARK_(inst_103497);
var state_103692__$1 = (function (){var statearr_103775 = state_103692;
(statearr_103775[(50)] = inst_103525);

return statearr_103775;
})();
if(inst_103526){
var statearr_103776_103866 = state_103692__$1;
(statearr_103776_103866[(1)] = (13));

} else {
var statearr_103777_103867 = state_103692__$1;
(statearr_103777_103867[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (9))){
var inst_103502 = (state_103692[(13)]);
var inst_103519 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_103502);
var state_103692__$1 = state_103692;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_103692__$1,(12),inst_103519);
} else {
if((state_val_103693 === (5))){
var inst_103495 = (state_103692[(30)]);
var inst_103510 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_103495);
var state_103692__$1 = state_103692;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_103692__$1,(8),inst_103510);
} else {
if((state_val_103693 === (14))){
var inst_103497 = (state_103692[(36)]);
var state_103692__$1 = state_103692;
var statearr_103778_103868 = state_103692__$1;
(statearr_103778_103868[(2)] = inst_103497);

(statearr_103778_103868[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (45))){
var inst_103582 = (state_103692[(53)]);
var state_103692__$1 = state_103692;
var statearr_103779_103869 = state_103692__$1;
(statearr_103779_103869[(2)] = inst_103582);

(statearr_103779_103869[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (53))){
var inst_103602 = (state_103692[(42)]);
var inst_103597 = (state_103692[(43)]);
var inst_103598 = (state_103692[(44)]);
var inst_103612 = (state_103692[(18)]);
var inst_103616 = fluree.db.dbproto._resolve_history_range.cljs$core$IFn$_invoke$arity$4(inst_103612,inst_103597,inst_103598,inst_103602);
var state_103692__$1 = state_103692;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_103692__$1,(55),inst_103616);
} else {
if((state_val_103693 === (26))){
var inst_103503 = (state_103692[(32)]);
var inst_103552 = (state_103692[(2)]);
var inst_103553 = (inst_103503 == null);
var state_103692__$1 = (function (){var statearr_103780 = state_103692;
(statearr_103780[(46)] = inst_103552);

return statearr_103780;
})();
if(cljs.core.truth_(inst_103553)){
var statearr_103781_103870 = state_103692__$1;
(statearr_103781_103870[(1)] = (27));

} else {
var statearr_103782_103871 = state_103692__$1;
(statearr_103782_103871[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (16))){
var inst_103530 = (state_103692[(2)]);
var inst_103531 = fluree.db.util.async.throw_err(inst_103530);
var state_103692__$1 = state_103692;
var statearr_103783_103872 = state_103692__$1;
(statearr_103783_103872[(2)] = inst_103531);

(statearr_103783_103872[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (38))){
var inst_103568 = (state_103692[(2)]);
var state_103692__$1 = state_103692;
var statearr_103784_103873 = state_103692__$1;
(statearr_103784_103873[(2)] = inst_103568);

(statearr_103784_103873[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (30))){
var state_103692__$1 = state_103692;
var statearr_103785_103874 = state_103692__$1;
(statearr_103785_103874[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_103785_103874[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (73))){
var inst_103668 = (state_103692[(54)]);
var inst_103667 = (state_103692[(11)]);
var inst_103682 = (state_103692[(2)]);
var inst_103683 = fluree.db.util.async.throw_err(inst_103682);
var inst_103612 = inst_103683;
var inst_103613 = inst_103668;
var inst_103614 = inst_103667;
var state_103692__$1 = (function (){var statearr_103786 = state_103692;
(statearr_103786[(15)] = inst_103614);

(statearr_103786[(17)] = inst_103613);

(statearr_103786[(18)] = inst_103612);

return statearr_103786;
})();
var statearr_103787_103875 = state_103692__$1;
(statearr_103787_103875[(2)] = null);

(statearr_103787_103875[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (10))){
var inst_103502 = (state_103692[(13)]);
var state_103692__$1 = state_103692;
var statearr_103788_103876 = state_103692__$1;
(statearr_103788_103876[(2)] = inst_103502);

(statearr_103788_103876[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (18))){
var inst_103504 = (state_103692[(34)]);
var state_103692__$1 = state_103692;
var statearr_103789_103877 = state_103692__$1;
(statearr_103789_103877[(2)] = inst_103504);

(statearr_103789_103877[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (52))){
var inst_103610 = (state_103692[(2)]);
var inst_103611 = fluree.db.util.async.throw_err(inst_103610);
var inst_103612 = inst_103611;
var inst_103613 = (0);
var inst_103614 = null;
var state_103692__$1 = (function (){var statearr_103790 = state_103692;
(statearr_103790[(15)] = inst_103614);

(statearr_103790[(17)] = inst_103613);

(statearr_103790[(18)] = inst_103612);

return statearr_103790;
})();
var statearr_103791_103878 = state_103692__$1;
(statearr_103791_103878[(2)] = null);

(statearr_103791_103878[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (67))){
var inst_103586 = (state_103692[(12)]);
var inst_103581 = (state_103692[(23)]);
var inst_103628 = (state_103692[(19)]);
var inst_103591 = (state_103692[(49)]);
var inst_103668 = (state_103692[(54)]);
var inst_103670 = (inst_103591.cljs$core$IFn$_invoke$arity$2 ? inst_103591.cljs$core$IFn$_invoke$arity$2(inst_103628,inst_103581) : inst_103591.call(null,inst_103628,inst_103581));
var inst_103671 = (inst_103670 < (0));
var inst_103672 = (inst_103668 < inst_103586);
var inst_103673 = ((inst_103671) && (inst_103672));
var state_103692__$1 = state_103692;
var statearr_103792_103879 = state_103692__$1;
(statearr_103792_103879[(2)] = inst_103673);

(statearr_103792_103879[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (71))){
var inst_103628 = (state_103692[(19)]);
var inst_103607 = (state_103692[(47)]);
var inst_103680 = fluree.db.dbproto._lookup_leaf(inst_103607,inst_103628);
var state_103692__$1 = state_103692;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_103692__$1,(73),inst_103680);
} else {
if((state_val_103693 === (42))){
var state_103692__$1 = state_103692;
var statearr_103793_103880 = state_103692__$1;
(statearr_103793_103880[(2)] = (2147483647));

(statearr_103793_103880[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (37))){
var state_103692__$1 = state_103692;
var statearr_103794_103881 = state_103692__$1;
(statearr_103794_103881[(2)] = (2147483647));

(statearr_103794_103881[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (63))){
var inst_103665 = (state_103692[(2)]);
var state_103692__$1 = state_103692;
var statearr_103795_103882 = state_103692__$1;
(statearr_103795_103882[(2)] = inst_103665);

(statearr_103795_103882[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (8))){
var inst_103512 = (state_103692[(2)]);
var inst_103513 = fluree.db.util.async.throw_err(inst_103512);
var state_103692__$1 = state_103692;
var statearr_103796_103883 = state_103692__$1;
(statearr_103796_103883[(2)] = inst_103513);

(statearr_103796_103883[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103693 === (49))){
var inst_103595 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var state_103692__$1 = state_103692;
var statearr_103797_103884 = state_103692__$1;
(statearr_103797_103884[(2)] = inst_103595);

(statearr_103797_103884[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__100742__auto__ = null;
var fluree$db$query$range$state_machine__100742__auto____0 = (function (){
var statearr_103798 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_103798[(0)] = fluree$db$query$range$state_machine__100742__auto__);

(statearr_103798[(1)] = (1));

return statearr_103798;
});
var fluree$db$query$range$state_machine__100742__auto____1 = (function (state_103692){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_103692);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e103799){if((e103799 instanceof Object)){
var ex__100745__auto__ = e103799;
var statearr_103800_103885 = state_103692;
(statearr_103800_103885[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_103692);

return cljs.core.cst$kw$recur;
} else {
throw e103799;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__103886 = state_103692;
state_103692 = G__103886;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__100742__auto__ = function(state_103692){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__100742__auto____1.call(this,state_103692);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__100742__auto____0;
fluree$db$query$range$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__100742__auto____1;
return fluree$db$query$range$state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_103801 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_103801[(6)] = c__100848__auto__);

return statearr_103801;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
}));

(fluree.db.query.range.time_range.cljs$lang$maxFixedArity = 7);

/**
 * Starting with flakes grouped by subject id, filters the flakes until
 *   either flake-limit or subject-limit reached.
 */
fluree.db.query.range.subject_groups__GT_allow_flakes = (function fluree$db$query$range$subject_groups__GT_allow_flakes(db,subject_groups,flake_start,subject_start,flake_limit,subject_limit){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_103933){
var state_val_103934 = (state_103933[(1)]);
if((state_val_103934 === (7))){
var state_103933__$1 = state_103933;
var statearr_103935_103953 = state_103933__$1;
(statearr_103935_103953[(2)] = (0));

(statearr_103935_103953[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103934 === (1))){
var inst_103894 = cljs.core.seq(subject_groups);
var inst_103895 = cljs.core.first(inst_103894);
var inst_103896 = cljs.core.next(inst_103894);
var inst_103897 = cljs.core.PersistentVector.EMPTY;
var inst_103898 = subject_groups;
var inst_103899 = flake_start;
var inst_103900 = subject_start;
var inst_103901 = inst_103897;
var state_103933__$1 = (function (){var statearr_103936 = state_103933;
(statearr_103936[(7)] = inst_103900);

(statearr_103936[(8)] = inst_103898);

(statearr_103936[(9)] = inst_103899);

(statearr_103936[(10)] = inst_103895);

(statearr_103936[(11)] = inst_103901);

(statearr_103936[(12)] = inst_103896);

return statearr_103936;
})();
var statearr_103937_103954 = state_103933__$1;
(statearr_103937_103954[(2)] = null);

(statearr_103937_103954[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103934 === (4))){
var inst_103900 = (state_103933[(7)]);
var inst_103899 = (state_103933[(9)]);
var inst_103901 = (state_103933[(11)]);
var inst_103914 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_103915 = [inst_103899,inst_103900,inst_103901];
var inst_103916 = (new cljs.core.PersistentVector(null,3,(5),inst_103914,inst_103915,null));
var state_103933__$1 = state_103933;
var statearr_103938_103955 = state_103933__$1;
(statearr_103938_103955[(2)] = inst_103916);

(statearr_103938_103955[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103934 === (6))){
var inst_103929 = (state_103933[(2)]);
var state_103933__$1 = state_103933;
var statearr_103939_103956 = state_103933__$1;
(statearr_103939_103956[(2)] = inst_103929);

(statearr_103939_103956[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103934 === (3))){
var inst_103931 = (state_103933[(2)]);
var state_103933__$1 = state_103933;
return cljs.core.async.impl.ioc_helpers.return_chan(state_103933__$1,inst_103931);
} else {
if((state_val_103934 === (2))){
var inst_103900 = (state_103933[(7)]);
var inst_103907 = (state_103933[(13)]);
var inst_103898 = (state_103933[(8)]);
var inst_103899 = (state_103933[(9)]);
var inst_103906 = cljs.core.seq(inst_103898);
var inst_103907__$1 = cljs.core.first(inst_103906);
var inst_103908 = cljs.core.next(inst_103906);
var inst_103909 = (inst_103907__$1 == null);
var inst_103910 = (inst_103899 >= flake_limit);
var inst_103911 = (inst_103900 >= subject_limit);
var inst_103912 = ((inst_103909) || (inst_103910) || (inst_103911));
var state_103933__$1 = (function (){var statearr_103940 = state_103933;
(statearr_103940[(13)] = inst_103907__$1);

(statearr_103940[(14)] = inst_103908);

return statearr_103940;
})();
if(cljs.core.truth_(inst_103912)){
var statearr_103941_103957 = state_103933__$1;
(statearr_103941_103957[(1)] = (4));

} else {
var statearr_103942_103958 = state_103933__$1;
(statearr_103942_103958[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_103934 === (9))){
var inst_103900 = (state_103933[(7)]);
var inst_103907 = (state_103933[(13)]);
var inst_103918 = (state_103933[(15)]);
var inst_103908 = (state_103933[(14)]);
var inst_103899 = (state_103933[(9)]);
var inst_103901 = (state_103933[(11)]);
var inst_103923 = (state_103933[(2)]);
var inst_103924 = (inst_103899 + inst_103918);
var inst_103925 = (inst_103900 + inst_103923);
var inst_103926 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_103901,inst_103907);
var inst_103898 = inst_103908;
var inst_103899__$1 = inst_103924;
var inst_103900__$1 = inst_103925;
var inst_103901__$1 = inst_103926;
var state_103933__$1 = (function (){var statearr_103943 = state_103933;
(statearr_103943[(7)] = inst_103900__$1);

(statearr_103943[(8)] = inst_103898);

(statearr_103943[(9)] = inst_103899__$1);

(statearr_103943[(11)] = inst_103901__$1);

return statearr_103943;
})();
var statearr_103944_103959 = state_103933__$1;
(statearr_103944_103959[(2)] = null);

(statearr_103944_103959[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103934 === (5))){
var inst_103907 = (state_103933[(13)]);
var inst_103918 = (state_103933[(15)]);
var inst_103918__$1 = cljs.core.count(inst_103907);
var inst_103919 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_103918__$1);
var state_103933__$1 = (function (){var statearr_103945 = state_103933;
(statearr_103945[(15)] = inst_103918__$1);

return statearr_103945;
})();
if(inst_103919){
var statearr_103946_103960 = state_103933__$1;
(statearr_103946_103960[(1)] = (7));

} else {
var statearr_103947_103961 = state_103933__$1;
(statearr_103947_103961[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_103934 === (8))){
var state_103933__$1 = state_103933;
var statearr_103948_103962 = state_103933__$1;
(statearr_103948_103962[(2)] = (1));

(statearr_103948_103962[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__100742__auto__ = null;
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__100742__auto____0 = (function (){
var statearr_103949 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_103949[(0)] = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__100742__auto__);

(statearr_103949[(1)] = (1));

return statearr_103949;
});
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__100742__auto____1 = (function (state_103933){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_103933);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e103950){if((e103950 instanceof Object)){
var ex__100745__auto__ = e103950;
var statearr_103951_103963 = state_103933;
(statearr_103951_103963[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_103933);

return cljs.core.cst$kw$recur;
} else {
throw e103950;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__103964 = state_103933;
state_103933 = G__103964;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__100742__auto__ = function(state_103933){
switch(arguments.length){
case 0:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__100742__auto____1.call(this,state_103933);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__100742__auto____0;
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__100742__auto____1;
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_103952 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_103952[(6)] = c__100848__auto__);

return statearr_103952;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
fluree.db.query.range.find_next_valid_node = (function fluree$db$query$range$find_next_valid_node(root_node,rhs,t,novelty,fast_forward_db_QMARK_){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_104004){
var state_val_104005 = (state_104004[(1)]);
if((state_val_104005 === (7))){
var inst_104000 = (state_104004[(2)]);
var state_104004__$1 = state_104004;
var statearr_104006_104031 = state_104004__$1;
(statearr_104006_104031[(2)] = inst_104000);


cljs.core.async.impl.ioc_helpers.process_exception(state_104004__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_104005 === (1))){
var state_104004__$1 = state_104004;
var statearr_104007_104032 = state_104004__$1;
(statearr_104007_104032[(2)] = null);

(statearr_104007_104032[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104005 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_104004,(3),Error,null,(2));
var inst_103969 = fluree.db.dbproto._lookup_leaf(root_node,rhs);
var state_104004__$1 = state_104004;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_104004__$1,(5),inst_103969);
} else {
if((state_val_104005 === (15))){
var inst_103987 = (state_104004[(7)]);
var inst_103989 = fluree.db.dbproto._lookup_leaf(root_node,inst_103987);
var state_104004__$1 = state_104004;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_104004__$1,(18),inst_103989);
} else {
if((state_val_104005 === (13))){
var inst_103973 = (state_104004[(8)]);
var inst_103987 = (state_104004[(7)]);
var inst_103987__$1 = cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(inst_103973);
var state_104004__$1 = (function (){var statearr_104008 = state_104004;
(statearr_104008[(7)] = inst_103987__$1);

return statearr_104008;
})();
if(cljs.core.truth_(inst_103987__$1)){
var statearr_104009_104033 = state_104004__$1;
(statearr_104009_104033[(1)] = (15));

} else {
var statearr_104010_104034 = state_104004__$1;
(statearr_104010_104034[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104005 === (6))){
var state_104004__$1 = state_104004;
var statearr_104011_104035 = state_104004__$1;
(statearr_104011_104035[(2)] = null);

(statearr_104011_104035[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104005 === (17))){
var inst_103996 = (state_104004[(2)]);
var state_104004__$1 = state_104004;
var statearr_104012_104036 = state_104004__$1;
(statearr_104012_104036[(2)] = inst_103996);

(statearr_104012_104036[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104005 === (3))){
var inst_103965 = (state_104004[(2)]);
var state_104004__$1 = state_104004;
var statearr_104013_104037 = state_104004__$1;
(statearr_104013_104037[(2)] = inst_103965);


cljs.core.async.impl.ioc_helpers.process_exception(state_104004__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_104005 === (12))){
var inst_103984 = (state_104004[(9)]);
var state_104004__$1 = state_104004;
var statearr_104014_104038 = state_104004__$1;
(statearr_104014_104038[(2)] = inst_103984);

(statearr_104014_104038[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104005 === (2))){
var inst_104002 = (state_104004[(2)]);
var state_104004__$1 = state_104004;
return cljs.core.async.impl.ioc_helpers.return_chan(state_104004__$1,inst_104002);
} else {
if((state_val_104005 === (11))){
var inst_103981 = (state_104004[(2)]);
var inst_103982 = fluree.db.util.async.throw_err(inst_103981);
var state_104004__$1 = state_104004;
var statearr_104015_104039 = state_104004__$1;
(statearr_104015_104039[(2)] = inst_103982);


cljs.core.async.impl.ioc_helpers.process_exception(state_104004__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_104005 === (9))){
var inst_103975 = (state_104004[(2)]);
var state_104004__$1 = (function (){var statearr_104016 = state_104004;
(statearr_104016[(10)] = inst_103975);

return statearr_104016;
})();
var statearr_104017_104040 = state_104004__$1;
(statearr_104017_104040[(2)] = null);


cljs.core.async.impl.ioc_helpers.process_exception(state_104004__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_104005 === (5))){
var inst_103971 = (state_104004[(2)]);
var inst_103972 = fluree.db.util.async.throw_err(inst_103971);
var inst_103973 = inst_103972;
var state_104004__$1 = (function (){var statearr_104018 = state_104004;
(statearr_104018[(8)] = inst_103973);

return statearr_104018;
})();
var statearr_104019_104041 = state_104004__$1;
(statearr_104019_104041[(2)] = null);

(statearr_104019_104041[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104005 === (14))){
var inst_103998 = (state_104004[(2)]);
var state_104004__$1 = state_104004;
var statearr_104020_104042 = state_104004__$1;
(statearr_104020_104042[(2)] = inst_103998);

(statearr_104020_104042[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104005 === (16))){
var state_104004__$1 = state_104004;
var statearr_104021_104043 = state_104004__$1;
(statearr_104021_104043[(2)] = null);

(statearr_104021_104043[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104005 === (10))){
var inst_103973 = (state_104004[(8)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_104004,(9),cljs.core.cst$kw$default,null,(8));
var inst_103979 = fluree.db.dbproto._resolve_to_t.cljs$core$IFn$_invoke$arity$4(inst_103973,t,novelty,fast_forward_db_QMARK_);
var state_104004__$1 = state_104004;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_104004__$1,(11),inst_103979);
} else {
if((state_val_104005 === (18))){
var inst_103991 = (state_104004[(2)]);
var inst_103992 = fluree.db.util.async.throw_err(inst_103991);
var inst_103973 = inst_103992;
var state_104004__$1 = (function (){var statearr_104022 = state_104004;
(statearr_104022[(8)] = inst_103973);

return statearr_104022;
})();
var statearr_104023_104044 = state_104004__$1;
(statearr_104023_104044[(2)] = null);

(statearr_104023_104044[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104005 === (8))){
var inst_103984 = (state_104004[(9)]);
var inst_103984__$1 = (state_104004[(2)]);
var state_104004__$1 = (function (){var statearr_104024 = state_104004;
(statearr_104024[(9)] = inst_103984__$1);

return statearr_104024;
})();
if(cljs.core.truth_(inst_103984__$1)){
var statearr_104025_104045 = state_104004__$1;
(statearr_104025_104045[(1)] = (12));

} else {
var statearr_104026_104046 = state_104004__$1;
(statearr_104026_104046[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$find_next_valid_node_$_state_machine__100742__auto__ = null;
var fluree$db$query$range$find_next_valid_node_$_state_machine__100742__auto____0 = (function (){
var statearr_104027 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_104027[(0)] = fluree$db$query$range$find_next_valid_node_$_state_machine__100742__auto__);

(statearr_104027[(1)] = (1));

return statearr_104027;
});
var fluree$db$query$range$find_next_valid_node_$_state_machine__100742__auto____1 = (function (state_104004){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_104004);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e104028){if((e104028 instanceof Object)){
var ex__100745__auto__ = e104028;
var statearr_104029_104047 = state_104004;
(statearr_104029_104047[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_104004);

return cljs.core.cst$kw$recur;
} else {
throw e104028;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__104048 = state_104004;
state_104004 = G__104048;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$query$range$find_next_valid_node_$_state_machine__100742__auto__ = function(state_104004){
switch(arguments.length){
case 0:
return fluree$db$query$range$find_next_valid_node_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$query$range$find_next_valid_node_$_state_machine__100742__auto____1.call(this,state_104004);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$find_next_valid_node_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$find_next_valid_node_$_state_machine__100742__auto____0;
fluree$db$query$range$find_next_valid_node_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$find_next_valid_node_$_state_machine__100742__auto____1;
return fluree$db$query$range$find_next_valid_node_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_104030 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_104030[(6)] = c__100848__auto__);

return statearr_104030;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
/**
 * Range query across an index as of a 't' defined by the db.
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.index_range = (function fluree$db$query$range$index_range(var_args){
var G__104055 = arguments.length;
switch (G__104055) {
case 2:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__104056 = (function (){var pred__104059 = cljs.core.identical_QMARK_;
var expr__104060 = test;
if(cljs.core.truth_((pred__104059.cljs$core$IFn$_invoke$arity$2 ? pred__104059.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__104060) : pred__104059.call(null,cljs.core._EQ_,expr__104060)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__104059.cljs$core$IFn$_invoke$arity$2 ? pred__104059.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__104060) : pred__104059.call(null,cljs.core._LT_,expr__104060)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__104059.cljs$core$IFn$_invoke$arity$2 ? pred__104059.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__104060) : pred__104059.call(null,cljs.core._LT__EQ_,expr__104060)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__104059.cljs$core$IFn$_invoke$arity$2 ? pred__104059.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__104060) : pred__104059.call(null,cljs.core._GT_,expr__104060)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__104059.cljs$core$IFn$_invoke$arity$2 ? pred__104059.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__104060) : pred__104059.call(null,cljs.core._GT__EQ_,expr__104060)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__104060)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104056,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104056,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104056,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104056,(3),null);
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_104453){
var state_val_104454 = (state_104453[(1)]);
if((state_val_104454 === (121))){
var inst_104426 = (state_104453[(7)]);
var inst_104426__$1 = (state_104453[(2)]);
var state_104453__$1 = (function (){var statearr_104455 = state_104453;
(statearr_104455[(7)] = inst_104426__$1);

return statearr_104455;
})();
if(cljs.core.truth_(inst_104426__$1)){
var statearr_104456_104654 = state_104453__$1;
(statearr_104456_104654[(1)] = (122));

} else {
var statearr_104457_104655 = state_104453__$1;
(statearr_104457_104655[(1)] = (123));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (65))){
var inst_104222 = (state_104453[(2)]);
var state_104453__$1 = state_104453;
var statearr_104458_104656 = state_104453__$1;
(statearr_104458_104656[(2)] = inst_104222);

(statearr_104458_104656[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (70))){
var state_104453__$1 = state_104453;
var statearr_104459_104657 = state_104453__$1;
(statearr_104459_104657[(2)] = false);

(statearr_104459_104657[(1)] = (71));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (62))){
var inst_104179 = (state_104453[(8)]);
var inst_104084 = (state_104453[(9)]);
var inst_104126 = (state_104453[(10)]);
var inst_104091 = (state_104453[(11)]);
var inst_104135 = (state_104453[(12)]);
var inst_104188 = (state_104453[(13)]);
var inst_104197 = (state_104453[(14)]);
var inst_104092 = (state_104453[(15)]);
var inst_104085 = (state_104453[(16)]);
var inst_104206 = (state_104453[(17)]);
var inst_104224 = (state_104453[(18)]);
var inst_104215 = (state_104453[(19)]);
var inst_104224__$1 = (state_104453[(2)]);
var inst_104225 = fluree.db.flake.__GT_Flake(inst_104126,inst_104197,inst_104179,inst_104084,inst_104085,inst_104215);
var inst_104226 = fluree.db.flake.__GT_Flake(inst_104135,inst_104206,inst_104188,inst_104091,inst_104092,inst_104224__$1);
var inst_104228 = (opts == null);
var inst_104229 = cljs.core.not(inst_104228);
var state_104453__$1 = (function (){var statearr_104460 = state_104453;
(statearr_104460[(20)] = inst_104225);

(statearr_104460[(18)] = inst_104224__$1);

(statearr_104460[(21)] = inst_104226);

return statearr_104460;
})();
if(inst_104229){
var statearr_104461_104658 = state_104453__$1;
(statearr_104461_104658[(1)] = (66));

} else {
var statearr_104462_104659 = state_104453__$1;
(statearr_104462_104659[(1)] = (67));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (74))){
var inst_104249 = (state_104453[(22)]);
var inst_104247 = (state_104453[(23)]);
var inst_104247__$1 = (state_104453[(2)]);
var inst_104248 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_104247__$1,cljs.core.cst$kw$flake_DASH_limit,fluree.db.util.core.max_long);
var inst_104249__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_104247__$1,cljs.core.cst$kw$limit);
var inst_104250 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_104247__$1,cljs.core.cst$kw$offset,(0));
var state_104453__$1 = (function (){var statearr_104463 = state_104453;
(statearr_104463[(24)] = inst_104248);

(statearr_104463[(22)] = inst_104249__$1);

(statearr_104463[(23)] = inst_104247__$1);

(statearr_104463[(25)] = inst_104250);

return statearr_104463;
})();
if(cljs.core.truth_(inst_104249__$1)){
var statearr_104464_104660 = state_104453__$1;
(statearr_104464_104660[(1)] = (75));

} else {
var statearr_104465_104661 = state_104453__$1;
(statearr_104465_104661[(1)] = (76));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (110))){
var inst_104348 = (state_104453[(26)]);
var inst_104248 = (state_104453[(24)]);
var inst_104254 = (state_104453[(27)]);
var inst_104281 = (state_104453[(28)]);
var inst_104280 = (state_104453[(29)]);
var inst_104397 = fluree.db.query.range.subject_groups__GT_allow_flakes(db,inst_104348,inst_104280,inst_104281,inst_104248,inst_104254);
var state_104453__$1 = state_104453;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_104453__$1,(118),inst_104397);
} else {
if((state_val_104454 === (130))){
var inst_104417 = (state_104453[(30)]);
var inst_104434 = (state_104453[(31)]);
var inst_104414 = (state_104453[(32)]);
var inst_104415 = (state_104453[(33)]);
var inst_104416 = (state_104453[(34)]);
var inst_104278 = inst_104434;
var inst_104279 = inst_104414;
var inst_104280 = inst_104415;
var inst_104281 = inst_104416;
var inst_104282 = inst_104417;
var state_104453__$1 = (function (){var statearr_104466 = state_104453;
(statearr_104466[(35)] = inst_104278);

(statearr_104466[(36)] = inst_104279);

(statearr_104466[(28)] = inst_104281);

(statearr_104466[(37)] = inst_104282);

(statearr_104466[(29)] = inst_104280);

return statearr_104466;
})();
var statearr_104467_104662 = state_104453__$1;
(statearr_104467_104662[(2)] = null);

(statearr_104467_104662[(1)] = (83));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (128))){
var inst_104438 = (state_104453[(2)]);
var inst_104439 = cljs.core.not(inst_104438);
var state_104453__$1 = state_104453;
if(inst_104439){
var statearr_104468_104663 = state_104453__$1;
(statearr_104468_104663[(1)] = (129));

} else {
var statearr_104469_104664 = state_104453__$1;
(statearr_104469_104664[(1)] = (130));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (7))){
var inst_104109 = (state_104453[(2)]);
var state_104453__$1 = state_104453;
if(cljs.core.truth_(inst_104109)){
var statearr_104470_104665 = state_104453__$1;
(statearr_104470_104665[(1)] = (11));

} else {
var statearr_104471_104666 = state_104453__$1;
(statearr_104471_104666[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (59))){
var inst_104213 = (state_104453[(2)]);
var state_104453__$1 = state_104453;
var statearr_104472_104667 = state_104453__$1;
(statearr_104472_104667[(2)] = inst_104213);

(statearr_104472_104667[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (86))){
var inst_104288 = (state_104453[(38)]);
var state_104453__$1 = state_104453;
var statearr_104473_104668 = state_104453__$1;
(statearr_104473_104668[(2)] = inst_104288);

(statearr_104473_104668[(1)] = (87));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (20))){
var inst_104083 = (state_104453[(39)]);
var inst_104135 = (state_104453[(2)]);
var inst_104136 = cljs.core.boolean_QMARK_(inst_104083);
var state_104453__$1 = (function (){var statearr_104474 = state_104453;
(statearr_104474[(12)] = inst_104135);

return statearr_104474;
})();
if(inst_104136){
var statearr_104475_104669 = state_104453__$1;
(statearr_104475_104669[(1)] = (22));

} else {
var statearr_104476_104670 = state_104453__$1;
(statearr_104476_104670[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (72))){
var inst_104244 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,opts);
var state_104453__$1 = state_104453;
var statearr_104477_104671 = state_104453__$1;
(statearr_104477_104671[(2)] = inst_104244);

(statearr_104477_104671[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (58))){
var state_104453__$1 = state_104453;
var statearr_104478_104672 = state_104453__$1;
(statearr_104478_104672[(2)] = (2147483647));

(statearr_104478_104672[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (60))){
var inst_104093 = (state_104453[(40)]);
var state_104453__$1 = state_104453;
var statearr_104479_104673 = state_104453__$1;
(statearr_104479_104673[(2)] = inst_104093);

(statearr_104479_104673[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (27))){
var inst_104147 = (state_104453[(2)]);
var state_104453__$1 = state_104453;
var statearr_104480_104674 = state_104453__$1;
(statearr_104480_104674[(2)] = inst_104147);

(statearr_104480_104674[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (1))){
var state_104453__$1 = state_104453;
var statearr_104481_104675 = state_104453__$1;
(statearr_104481_104675[(2)] = null);

(statearr_104481_104675[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (69))){
var state_104453__$1 = state_104453;
var statearr_104482_104676 = state_104453__$1;
(statearr_104482_104676[(2)] = true);

(statearr_104482_104676[(1)] = (71));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (101))){
var state_104453__$1 = state_104453;
var statearr_104483_104677 = state_104453__$1;
(statearr_104483_104677[(2)] = false);

(statearr_104483_104677[(1)] = (102));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (24))){
var inst_104149 = (state_104453[(41)]);
var inst_104149__$1 = (state_104453[(2)]);
var state_104453__$1 = (function (){var statearr_104484 = state_104453;
(statearr_104484[(41)] = inst_104149__$1);

return statearr_104484;
})();
if(cljs.core.truth_(inst_104149__$1)){
var statearr_104485_104678 = state_104453__$1;
(statearr_104485_104678[(1)] = (31));

} else {
var statearr_104486_104679 = state_104453__$1;
(statearr_104486_104679[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (102))){
var inst_104321 = (state_104453[(2)]);
var state_104453__$1 = state_104453;
var statearr_104487_104680 = state_104453__$1;
(statearr_104487_104680[(2)] = inst_104321);

(statearr_104487_104680[(1)] = (99));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (55))){
var inst_104209 = (cljs.core._GT__EQ_ === start_test);
var state_104453__$1 = state_104453;
if(cljs.core.truth_(inst_104209)){
var statearr_104488_104681 = state_104453__$1;
(statearr_104488_104681[(1)] = (57));

} else {
var statearr_104489_104682 = state_104453__$1;
(statearr_104489_104682[(1)] = (58));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (85))){
var inst_104225 = (state_104453[(20)]);
var inst_104278 = (state_104453[(35)]);
var inst_104266 = (state_104453[(42)]);
var inst_104255 = (state_104453[(43)]);
var inst_104167 = (state_104453[(44)]);
var inst_104114 = (state_104453[(45)]);
var inst_104260 = (state_104453[(46)]);
var inst_104271 = (state_104453[(47)]);
var inst_104179 = (state_104453[(8)]);
var inst_104087 = (state_104453[(48)]);
var inst_104256 = (state_104453[(49)]);
var inst_104084 = (state_104453[(9)]);
var inst_104126 = (state_104453[(10)]);
var inst_104248 = (state_104453[(24)]);
var inst_104091 = (state_104453[(11)]);
var inst_104265 = (state_104453[(50)]);
var inst_104261 = (state_104453[(51)]);
var inst_104254 = (state_104453[(27)]);
var inst_104135 = (state_104453[(12)]);
var inst_104166 = (state_104453[(52)]);
var inst_104279 = (state_104453[(36)]);
var inst_104281 = (state_104453[(28)]);
var inst_104080 = (state_104453[(53)]);
var inst_104188 = (state_104453[(13)]);
var inst_104197 = (state_104453[(14)]);
var inst_104275 = (state_104453[(54)]);
var inst_104092 = (state_104453[(15)]);
var inst_104085 = (state_104453[(16)]);
var inst_104115 = (state_104453[(55)]);
var inst_104170 = (state_104453[(56)]);
var inst_104247 = (state_104453[(23)]);
var inst_104206 = (state_104453[(17)]);
var inst_104116 = (state_104453[(57)]);
var inst_104224 = (state_104453[(18)]);
var inst_104226 = (state_104453[(21)]);
var inst_104282 = (state_104453[(37)]);
var inst_104215 = (state_104453[(19)]);
var inst_104280 = (state_104453[(29)]);
var inst_104288 = (state_104453[(38)]);
var inst_104292 = (function (){var no_filter_QMARK_ = true;
var t = inst_104261;
var max_limit_QMARK_ = inst_104255;
var next_node = inst_104278;
var map__104072 = inst_104114;
var fast_forward_db_QMARK_ = inst_104266;
var s1 = inst_104126;
var vec__104073 = inst_104166;
var o2 = inst_104188;
var t1 = inst_104084;
var vec__104066 = inst_104080;
var predicate_fn = inst_104116;
var i = inst_104280;
var m1 = inst_104215;
var root_node = inst_104271;
var vec__104076 = inst_104167;
var G__104289 = inst_104288;
var s2 = inst_104135;
var p2 = inst_104206;
var permissions = inst_104256;
var limit = inst_104254;
var start_flake = inst_104225;
var flake_limit = inst_104248;
var offset = inst_104279;
var vec__104069 = inst_104087;
var acc = inst_104282;
var t2 = inst_104091;
var op1 = inst_104085;
var o1 = inst_104179;
var end_flake = inst_104226;
var base_result = inst_104288;
var s = inst_104281;
var node_start = inst_104275;
var p1 = inst_104197;
var subject_fn = inst_104115;
var object_fn = inst_104170;
var idx_compare = inst_104260;
var op2 = inst_104092;
var map__104079 = inst_104247;
var m2 = inst_104224;
var novelty = inst_104265;
return (function (p1__104049_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__104049_SHARP_.o,start_flake.o);
});
})();
var inst_104293 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_104292,inst_104288);
var state_104453__$1 = state_104453;
var statearr_104490_104683 = state_104453__$1;
(statearr_104490_104683[(2)] = inst_104293);

(statearr_104490_104683[(1)] = (87));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (39))){
var inst_104169 = (state_104453[(58)]);
var state_104453__$1 = state_104453;
var statearr_104491_104684 = state_104453__$1;
(statearr_104491_104684[(2)] = inst_104169);

(statearr_104491_104684[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (88))){
var inst_104225 = (state_104453[(20)]);
var inst_104278 = (state_104453[(35)]);
var inst_104266 = (state_104453[(42)]);
var inst_104255 = (state_104453[(43)]);
var inst_104167 = (state_104453[(44)]);
var inst_104114 = (state_104453[(45)]);
var inst_104260 = (state_104453[(46)]);
var inst_104271 = (state_104453[(47)]);
var inst_104179 = (state_104453[(8)]);
var inst_104087 = (state_104453[(48)]);
var inst_104256 = (state_104453[(49)]);
var inst_104084 = (state_104453[(9)]);
var inst_104126 = (state_104453[(10)]);
var inst_104248 = (state_104453[(24)]);
var inst_104091 = (state_104453[(11)]);
var inst_104265 = (state_104453[(50)]);
var inst_104296 = (state_104453[(59)]);
var inst_104261 = (state_104453[(51)]);
var inst_104254 = (state_104453[(27)]);
var inst_104135 = (state_104453[(12)]);
var inst_104166 = (state_104453[(52)]);
var inst_104279 = (state_104453[(36)]);
var inst_104281 = (state_104453[(28)]);
var inst_104080 = (state_104453[(53)]);
var inst_104188 = (state_104453[(13)]);
var inst_104197 = (state_104453[(14)]);
var inst_104275 = (state_104453[(54)]);
var inst_104092 = (state_104453[(15)]);
var inst_104085 = (state_104453[(16)]);
var inst_104115 = (state_104453[(55)]);
var inst_104170 = (state_104453[(56)]);
var inst_104247 = (state_104453[(23)]);
var inst_104206 = (state_104453[(17)]);
var inst_104116 = (state_104453[(57)]);
var inst_104224 = (state_104453[(18)]);
var inst_104226 = (state_104453[(21)]);
var inst_104282 = (state_104453[(37)]);
var inst_104215 = (state_104453[(19)]);
var inst_104280 = (state_104453[(29)]);
var inst_104288 = (state_104453[(38)]);
var inst_104298 = (function (){var no_filter_QMARK_ = true;
var t = inst_104261;
var max_limit_QMARK_ = inst_104255;
var next_node = inst_104278;
var map__104072 = inst_104114;
var fast_forward_db_QMARK_ = inst_104266;
var s1 = inst_104126;
var vec__104073 = inst_104166;
var o2 = inst_104188;
var t1 = inst_104084;
var vec__104066 = inst_104080;
var predicate_fn = inst_104116;
var i = inst_104280;
var m1 = inst_104215;
var root_node = inst_104271;
var vec__104076 = inst_104167;
var G__104289 = inst_104296;
var s2 = inst_104135;
var p2 = inst_104206;
var permissions = inst_104256;
var limit = inst_104254;
var start_flake = inst_104225;
var flake_limit = inst_104248;
var offset = inst_104279;
var vec__104069 = inst_104087;
var acc = inst_104282;
var t2 = inst_104091;
var op1 = inst_104085;
var o1 = inst_104179;
var end_flake = inst_104226;
var base_result = inst_104288;
var s = inst_104281;
var node_start = inst_104275;
var p1 = inst_104197;
var subject_fn = inst_104115;
var object_fn = inst_104170;
var idx_compare = inst_104260;
var op2 = inst_104092;
var map__104079 = inst_104247;
var m2 = inst_104224;
var novelty = inst_104265;
return (function (p1__104050_SHARP_){
var G__104492 = p1__104050_SHARP_.s;
return (subject_fn.cljs$core$IFn$_invoke$arity$1 ? subject_fn.cljs$core$IFn$_invoke$arity$1(G__104492) : subject_fn.call(null,G__104492));
});
})();
var inst_104299 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_104298,inst_104296);
var state_104453__$1 = state_104453;
var statearr_104493_104685 = state_104453__$1;
(statearr_104493_104685[(2)] = inst_104299);

(statearr_104493_104685[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (46))){
var inst_104082 = (state_104453[(60)]);
var state_104453__$1 = state_104453;
var statearr_104494_104686 = state_104453__$1;
(statearr_104494_104686[(2)] = inst_104082);

(statearr_104494_104686[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (4))){
var inst_104087 = (state_104453[(48)]);
var inst_104080 = (state_104453[(53)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_104453,(3),Error,null,(2));
var inst_104080__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var inst_104081 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_104080__$1,(0),null);
var inst_104082 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_104080__$1,(1),null);
var inst_104083 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_104080__$1,(2),null);
var inst_104084 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_104080__$1,(3),null);
var inst_104085 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_104080__$1,(4),null);
var inst_104086 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_104080__$1,(5),null);
var inst_104087__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var inst_104088 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_104087__$1,(0),null);
var inst_104089 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_104087__$1,(1),null);
var inst_104090 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_104087__$1,(2),null);
var inst_104091 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_104087__$1,(3),null);
var inst_104092 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_104087__$1,(4),null);
var inst_104093 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_104087__$1,(5),null);
var inst_104095 = (opts == null);
var inst_104096 = cljs.core.not(inst_104095);
var state_104453__$1 = (function (){var statearr_104495 = state_104453;
(statearr_104495[(61)] = inst_104090);

(statearr_104495[(60)] = inst_104082);

(statearr_104495[(48)] = inst_104087__$1);

(statearr_104495[(9)] = inst_104084);

(statearr_104495[(39)] = inst_104083);

(statearr_104495[(11)] = inst_104091);

(statearr_104495[(40)] = inst_104093);

(statearr_104495[(62)] = inst_104088);

(statearr_104495[(53)] = inst_104080__$1);

(statearr_104495[(63)] = inst_104086);

(statearr_104495[(15)] = inst_104092);

(statearr_104495[(16)] = inst_104085);

(statearr_104495[(64)] = inst_104081);

(statearr_104495[(65)] = inst_104089);

return statearr_104495;
})();
if(inst_104096){
var statearr_104496_104687 = state_104453__$1;
(statearr_104496_104687[(1)] = (5));

} else {
var statearr_104497_104688 = state_104453__$1;
(statearr_104497_104688[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (77))){
var inst_104254 = (state_104453[(27)]);
var inst_104254__$1 = (state_104453[(2)]);
var inst_104255 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_104254__$1,fluree.db.util.core.max_long);
var inst_104256 = cljs.core.cst$kw$permissions.cljs$core$IFn$_invoke$arity$1(db);
var inst_104257 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_104258 = [cljs.core.cst$kw$index_DASH_configs,idx,cljs.core.cst$kw$comparator];
var inst_104259 = (new cljs.core.PersistentVector(null,3,(5),inst_104257,inst_104258,null));
var inst_104260 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_104259);
var inst_104261 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_104262 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_104263 = [cljs.core.cst$kw$novelty,idx];
var inst_104264 = (new cljs.core.PersistentVector(null,2,(5),inst_104262,inst_104263,null));
var inst_104265 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_104264);
var inst_104266 = cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(db);
var inst_104267 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_104268 = fluree.db.dbproto._resolve(inst_104267);
var state_104453__$1 = (function (){var statearr_104498 = state_104453;
(statearr_104498[(42)] = inst_104266);

(statearr_104498[(43)] = inst_104255);

(statearr_104498[(46)] = inst_104260);

(statearr_104498[(49)] = inst_104256);

(statearr_104498[(50)] = inst_104265);

(statearr_104498[(51)] = inst_104261);

(statearr_104498[(27)] = inst_104254__$1);

return statearr_104498;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_104453__$1,(78),inst_104268);
} else {
if((state_val_104454 === (106))){
var inst_104337 = (state_104453[(66)]);
var inst_104279 = (state_104453[(36)]);
var inst_104281 = (state_104453[(28)]);
var inst_104282 = (state_104453[(37)]);
var inst_104280 = (state_104453[(29)]);
var inst_104340 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_104341 = (inst_104279 - inst_104337);
var inst_104342 = [inst_104341,inst_104280,inst_104281,inst_104282];
var inst_104343 = (new cljs.core.PersistentVector(null,4,(5),inst_104340,inst_104342,null));
var state_104453__$1 = state_104453;
var statearr_104499_104689 = state_104453__$1;
(statearr_104499_104689[(2)] = inst_104343);

(statearr_104499_104689[(1)] = (108));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (119))){
var inst_104260 = (state_104453[(46)]);
var inst_104315 = (state_104453[(67)]);
var inst_104248 = (state_104453[(24)]);
var inst_104254 = (state_104453[(27)]);
var inst_104415 = (state_104453[(33)]);
var inst_104416 = (state_104453[(34)]);
var inst_104226 = (state_104453[(21)]);
var inst_104419 = (inst_104260.cljs$core$IFn$_invoke$arity$2 ? inst_104260.cljs$core$IFn$_invoke$arity$2(inst_104315,inst_104226) : inst_104260.call(null,inst_104315,inst_104226));
var inst_104420 = (inst_104419 < (0));
var inst_104421 = (inst_104415 < inst_104248);
var inst_104422 = (inst_104416 < inst_104254);
var inst_104423 = ((inst_104420) && (inst_104421) && (inst_104422));
var state_104453__$1 = state_104453;
var statearr_104500_104690 = state_104453__$1;
(statearr_104500_104690[(2)] = inst_104423);

(statearr_104500_104690[(1)] = (121));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (95))){
var inst_104308 = (state_104453[(68)]);
var state_104453__$1 = state_104453;
var statearr_104501_104691 = state_104453__$1;
(statearr_104501_104691[(2)] = inst_104308);

(statearr_104501_104691[(1)] = (96));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (54))){
var inst_104086 = (state_104453[(63)]);
var state_104453__$1 = state_104453;
var statearr_104502_104692 = state_104453__$1;
(statearr_104502_104692[(2)] = inst_104086);

(statearr_104502_104692[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (92))){
var inst_104302 = (state_104453[(69)]);
var state_104453__$1 = state_104453;
var statearr_104503_104693 = state_104453__$1;
(statearr_104503_104693[(2)] = inst_104302);

(statearr_104503_104693[(1)] = (93));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (104))){
var inst_104225 = (state_104453[(20)]);
var inst_104278 = (state_104453[(35)]);
var inst_104266 = (state_104453[(42)]);
var inst_104255 = (state_104453[(43)]);
var inst_104167 = (state_104453[(44)]);
var inst_104114 = (state_104453[(45)]);
var inst_104260 = (state_104453[(46)]);
var inst_104271 = (state_104453[(47)]);
var inst_104179 = (state_104453[(8)]);
var inst_104087 = (state_104453[(48)]);
var inst_104256 = (state_104453[(49)]);
var inst_104315 = (state_104453[(67)]);
var inst_104084 = (state_104453[(9)]);
var inst_104126 = (state_104453[(10)]);
var inst_104248 = (state_104453[(24)]);
var inst_104091 = (state_104453[(11)]);
var inst_104265 = (state_104453[(50)]);
var inst_104337 = (state_104453[(66)]);
var inst_104261 = (state_104453[(51)]);
var inst_104336 = (state_104453[(70)]);
var inst_104254 = (state_104453[(27)]);
var inst_104135 = (state_104453[(12)]);
var inst_104166 = (state_104453[(52)]);
var inst_104279 = (state_104453[(36)]);
var inst_104281 = (state_104453[(28)]);
var inst_104080 = (state_104453[(53)]);
var inst_104188 = (state_104453[(13)]);
var inst_104197 = (state_104453[(14)]);
var inst_104275 = (state_104453[(54)]);
var inst_104092 = (state_104453[(15)]);
var inst_104085 = (state_104453[(16)]);
var inst_104115 = (state_104453[(55)]);
var inst_104170 = (state_104453[(56)]);
var inst_104247 = (state_104453[(23)]);
var inst_104206 = (state_104453[(17)]);
var inst_104116 = (state_104453[(57)]);
var inst_104224 = (state_104453[(18)]);
var inst_104226 = (state_104453[(21)]);
var inst_104282 = (state_104453[(37)]);
var inst_104215 = (state_104453[(19)]);
var inst_104280 = (state_104453[(29)]);
var inst_104288 = (state_104453[(38)]);
var inst_104314 = (state_104453[(71)]);
var inst_104335 = (function (){var no_filter_QMARK_ = true;
var base_result_SINGLEQUOTE_ = inst_104314;
var t = inst_104261;
var max_limit_QMARK_ = inst_104255;
var next_node = inst_104278;
var map__104072 = inst_104114;
var fast_forward_db_QMARK_ = inst_104266;
var s1 = inst_104126;
var vec__104073 = inst_104166;
var o2 = inst_104188;
var t1 = inst_104084;
var vec__104066 = inst_104080;
var predicate_fn = inst_104116;
var i = inst_104280;
var rhs = inst_104315;
var m1 = inst_104215;
var root_node = inst_104271;
var vec__104076 = inst_104167;
var s2 = inst_104135;
var p2 = inst_104206;
var permissions = inst_104256;
var limit = inst_104254;
var start_flake = inst_104225;
var flake_limit = inst_104248;
var offset = inst_104279;
var vec__104069 = inst_104087;
var acc = inst_104282;
var t2 = inst_104091;
var op1 = inst_104085;
var o1 = inst_104179;
var end_flake = inst_104226;
var base_result = inst_104288;
var s = inst_104281;
var node_start = inst_104275;
var p1 = inst_104197;
var subject_fn = inst_104115;
var object_fn = inst_104170;
var idx_compare = inst_104260;
var op2 = inst_104092;
var map__104079 = inst_104247;
var m2 = inst_104224;
var novelty = inst_104265;
return (function (p1__104053_SHARP_){
return p1__104053_SHARP_.s;
});
})();
var inst_104336__$1 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_104335,inst_104314);
var inst_104337__$1 = cljs.core.count(inst_104336__$1);
var inst_104338 = (inst_104279 > inst_104337__$1);
var state_104453__$1 = (function (){var statearr_104504 = state_104453;
(statearr_104504[(66)] = inst_104337__$1);

(statearr_104504[(70)] = inst_104336__$1);

return statearr_104504;
})();
if(cljs.core.truth_(inst_104338)){
var statearr_104505_104694 = state_104453__$1;
(statearr_104505_104694[(1)] = (106));

} else {
var statearr_104506_104695 = state_104453__$1;
(statearr_104506_104695[(1)] = (107));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (15))){
var inst_104081 = (state_104453[(64)]);
var state_104453__$1 = state_104453;
var statearr_104507_104696 = state_104453__$1;
(statearr_104507_104696[(2)] = inst_104081);

(statearr_104507_104696[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (48))){
var inst_104188 = (state_104453[(13)]);
var state_104453__$1 = state_104453;
var statearr_104508_104697 = state_104453__$1;
(statearr_104508_104697[(2)] = inst_104188);

(statearr_104508_104697[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (50))){
var inst_104202 = (state_104453[(2)]);
var state_104453__$1 = state_104453;
if(cljs.core.truth_(inst_104202)){
var statearr_104509_104698 = state_104453__$1;
(statearr_104509_104698[(1)] = (51));

} else {
var statearr_104510_104699 = state_104453__$1;
(statearr_104510_104699[(1)] = (52));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (116))){
var inst_104376 = (state_104453[(72)]);
var inst_104374 = (state_104453[(73)]);
var inst_104386 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_104387 = [inst_104376,inst_104374];
var inst_104388 = (new cljs.core.PersistentVector(null,2,(5),inst_104386,inst_104387,null));
var state_104453__$1 = state_104453;
var statearr_104511_104700 = state_104453__$1;
(statearr_104511_104700[(2)] = inst_104388);

(statearr_104511_104700[(1)] = (117));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (75))){
var inst_104249 = (state_104453[(22)]);
var state_104453__$1 = state_104453;
var statearr_104512_104701 = state_104453__$1;
(statearr_104512_104701[(2)] = inst_104249);

(statearr_104512_104701[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (99))){
var inst_104324 = (state_104453[(2)]);
var state_104453__$1 = state_104453;
if(cljs.core.truth_(inst_104324)){
var statearr_104513_104702 = state_104453__$1;
(statearr_104513_104702[(1)] = (103));

} else {
var statearr_104514_104703 = state_104453__$1;
(statearr_104514_104703[(1)] = (104));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (21))){
var inst_104131 = (state_104453[(2)]);
var inst_104132 = fluree.db.util.async.throw_err(inst_104131);
var state_104453__$1 = state_104453;
var statearr_104515_104704 = state_104453__$1;
(statearr_104515_104704[(2)] = inst_104132);

(statearr_104515_104704[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (31))){
var inst_104114 = (state_104453[(45)]);
var inst_104090 = (state_104453[(61)]);
var inst_104082 = (state_104453[(60)]);
var inst_104087 = (state_104453[(48)]);
var inst_104084 = (state_104453[(9)]);
var inst_104126 = (state_104453[(10)]);
var inst_104083 = (state_104453[(39)]);
var inst_104091 = (state_104453[(11)]);
var inst_104117 = (state_104453[(74)]);
var inst_104093 = (state_104453[(40)]);
var inst_104135 = (state_104453[(12)]);
var inst_104080 = (state_104453[(53)]);
var inst_104086 = (state_104453[(63)]);
var inst_104092 = (state_104453[(15)]);
var inst_104085 = (state_104453[(16)]);
var inst_104115 = (state_104453[(55)]);
var inst_104116 = (state_104453[(57)]);
var inst_104089 = (state_104453[(65)]);
var inst_104149 = (state_104453[(41)]);
var inst_104151 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_104152 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_104153 = [null,null];
var inst_104154 = (new cljs.core.PersistentVector(null,2,(5),inst_104152,inst_104153,null));
var inst_104155 = (function (){var bool = inst_104149;
var temp__5733__auto__ = inst_104149;
var map__104072 = inst_104114;
var s1 = inst_104126;
var o2 = inst_104090;
var t1 = inst_104084;
var vec__104066 = inst_104080;
var predicate_fn = inst_104116;
var m1 = inst_104086;
var s2 = inst_104135;
var p2 = inst_104089;
var vec__104069 = inst_104087;
var t2 = inst_104091;
var op1 = inst_104085;
var o1 = inst_104083;
var p1 = inst_104082;
var subject_fn = inst_104115;
var object_fn = inst_104117;
var op2 = inst_104092;
var m2 = inst_104093;
return (function (o){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(o,bool);
});
})();
var inst_104156 = [inst_104154,inst_104155];
var inst_104157 = (new cljs.core.PersistentVector(null,2,(5),inst_104151,inst_104156,null));
var state_104453__$1 = state_104453;
var statearr_104516_104705 = state_104453__$1;
(statearr_104516_104705[(2)] = inst_104157);

(statearr_104516_104705[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (113))){
var inst_104357 = (state_104453[(75)]);
var inst_104366 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_104367 = [inst_104357,inst_104357];
var inst_104368 = (new cljs.core.PersistentVector(null,2,(5),inst_104366,inst_104367,null));
var state_104453__$1 = state_104453;
var statearr_104517_104706 = state_104453__$1;
(statearr_104517_104706[(2)] = inst_104368);

(statearr_104517_104706[(1)] = (114));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (32))){
var inst_104090 = (state_104453[(61)]);
var inst_104083 = (state_104453[(39)]);
var inst_104117 = (state_104453[(74)]);
var inst_104159 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_104160 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_104161 = [inst_104083,inst_104090];
var inst_104162 = (new cljs.core.PersistentVector(null,2,(5),inst_104160,inst_104161,null));
var inst_104163 = [inst_104162,inst_104117];
var inst_104164 = (new cljs.core.PersistentVector(null,2,(5),inst_104159,inst_104163,null));
var state_104453__$1 = state_104453;
var statearr_104518_104707 = state_104453__$1;
(statearr_104518_104707[(2)] = inst_104164);

(statearr_104518_104707[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (40))){
var inst_104082 = (state_104453[(60)]);
var inst_104188 = (state_104453[(2)]);
var inst_104189 = (inst_104082 == null);
var state_104453__$1 = (function (){var statearr_104519 = state_104453;
(statearr_104519[(13)] = inst_104188);

return statearr_104519;
})();
if(cljs.core.truth_(inst_104189)){
var statearr_104520_104708 = state_104453__$1;
(statearr_104520_104708[(1)] = (42));

} else {
var statearr_104521_104709 = state_104453__$1;
(statearr_104521_104709[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (129))){
var inst_104417 = (state_104453[(30)]);
var state_104453__$1 = state_104453;
var statearr_104522_104710 = state_104453__$1;
(statearr_104522_104710[(2)] = inst_104417);

(statearr_104522_104710[(1)] = (131));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (91))){
var inst_104225 = (state_104453[(20)]);
var inst_104278 = (state_104453[(35)]);
var inst_104266 = (state_104453[(42)]);
var inst_104255 = (state_104453[(43)]);
var inst_104167 = (state_104453[(44)]);
var inst_104114 = (state_104453[(45)]);
var inst_104260 = (state_104453[(46)]);
var inst_104271 = (state_104453[(47)]);
var inst_104179 = (state_104453[(8)]);
var inst_104087 = (state_104453[(48)]);
var inst_104256 = (state_104453[(49)]);
var inst_104084 = (state_104453[(9)]);
var inst_104126 = (state_104453[(10)]);
var inst_104248 = (state_104453[(24)]);
var inst_104091 = (state_104453[(11)]);
var inst_104265 = (state_104453[(50)]);
var inst_104261 = (state_104453[(51)]);
var inst_104254 = (state_104453[(27)]);
var inst_104135 = (state_104453[(12)]);
var inst_104166 = (state_104453[(52)]);
var inst_104279 = (state_104453[(36)]);
var inst_104281 = (state_104453[(28)]);
var inst_104080 = (state_104453[(53)]);
var inst_104188 = (state_104453[(13)]);
var inst_104197 = (state_104453[(14)]);
var inst_104275 = (state_104453[(54)]);
var inst_104092 = (state_104453[(15)]);
var inst_104085 = (state_104453[(16)]);
var inst_104115 = (state_104453[(55)]);
var inst_104170 = (state_104453[(56)]);
var inst_104247 = (state_104453[(23)]);
var inst_104206 = (state_104453[(17)]);
var inst_104116 = (state_104453[(57)]);
var inst_104224 = (state_104453[(18)]);
var inst_104226 = (state_104453[(21)]);
var inst_104282 = (state_104453[(37)]);
var inst_104215 = (state_104453[(19)]);
var inst_104280 = (state_104453[(29)]);
var inst_104288 = (state_104453[(38)]);
var inst_104302 = (state_104453[(69)]);
var inst_104304 = (function (){var no_filter_QMARK_ = true;
var t = inst_104261;
var max_limit_QMARK_ = inst_104255;
var next_node = inst_104278;
var map__104072 = inst_104114;
var fast_forward_db_QMARK_ = inst_104266;
var s1 = inst_104126;
var vec__104073 = inst_104166;
var o2 = inst_104188;
var t1 = inst_104084;
var vec__104066 = inst_104080;
var predicate_fn = inst_104116;
var i = inst_104280;
var m1 = inst_104215;
var root_node = inst_104271;
var vec__104076 = inst_104167;
var G__104289 = inst_104302;
var s2 = inst_104135;
var p2 = inst_104206;
var permissions = inst_104256;
var limit = inst_104254;
var start_flake = inst_104225;
var flake_limit = inst_104248;
var offset = inst_104279;
var vec__104069 = inst_104087;
var acc = inst_104282;
var t2 = inst_104091;
var op1 = inst_104085;
var o1 = inst_104179;
var end_flake = inst_104226;
var base_result = inst_104288;
var s = inst_104281;
var node_start = inst_104275;
var p1 = inst_104197;
var subject_fn = inst_104115;
var object_fn = inst_104170;
var idx_compare = inst_104260;
var op2 = inst_104092;
var map__104079 = inst_104247;
var m2 = inst_104224;
var novelty = inst_104265;
return (function (p1__104051_SHARP_){
var G__104523 = p1__104051_SHARP_.p;
return (predicate_fn.cljs$core$IFn$_invoke$arity$1 ? predicate_fn.cljs$core$IFn$_invoke$arity$1(G__104523) : predicate_fn.call(null,G__104523));
});
})();
var inst_104305 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_104304,inst_104302);
var state_104453__$1 = state_104453;
var statearr_104524_104711 = state_104453__$1;
(statearr_104524_104711[(2)] = inst_104305);

(statearr_104524_104711[(1)] = (93));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (117))){
var inst_104371 = (state_104453[(76)]);
var inst_104390 = (state_104453[(2)]);
var inst_104391 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_104390,(0),null);
var inst_104392 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_104390,(1),null);
var inst_104393 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_104394 = [inst_104391,inst_104371,inst_104392];
var inst_104395 = (new cljs.core.PersistentVector(null,3,(5),inst_104393,inst_104394,null));
var state_104453__$1 = state_104453;
var statearr_104525_104712 = state_104453__$1;
(statearr_104525_104712[(2)] = inst_104395);

(statearr_104525_104712[(1)] = (111));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (108))){
var inst_104411 = (state_104453[(2)]);
var state_104453__$1 = state_104453;
var statearr_104526_104713 = state_104453__$1;
(statearr_104526_104713[(2)] = inst_104411);

(statearr_104526_104713[(1)] = (105));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (56))){
var inst_104093 = (state_104453[(40)]);
var inst_104215 = (state_104453[(2)]);
var state_104453__$1 = (function (){var statearr_104527 = state_104453;
(statearr_104527[(19)] = inst_104215);

return statearr_104527;
})();
if(cljs.core.truth_(inst_104093)){
var statearr_104528_104714 = state_104453__$1;
(statearr_104528_104714[(1)] = (60));

} else {
var statearr_104529_104715 = state_104453__$1;
(statearr_104529_104715[(1)] = (61));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (33))){
var inst_104167 = (state_104453[(44)]);
var inst_104168 = (state_104453[(77)]);
var inst_104166 = (state_104453[(52)]);
var inst_104166__$1 = (state_104453[(2)]);
var inst_104167__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_104166__$1,(0),null);
var inst_104168__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_104167__$1,(0),null);
var inst_104169 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_104167__$1,(1),null);
var inst_104170 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_104166__$1,(1),null);
var inst_104171 = fluree.db.util.core.pred_ident_QMARK_(inst_104168__$1);
var state_104453__$1 = (function (){var statearr_104530 = state_104453;
(statearr_104530[(44)] = inst_104167__$1);

(statearr_104530[(77)] = inst_104168__$1);

(statearr_104530[(52)] = inst_104166__$1);

(statearr_104530[(56)] = inst_104170);

(statearr_104530[(58)] = inst_104169);

return statearr_104530;
})();
if(inst_104171){
var statearr_104531_104716 = state_104453__$1;
(statearr_104531_104716[(1)] = (34));

} else {
var statearr_104532_104717 = state_104453__$1;
(statearr_104532_104717[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (13))){
var inst_104114 = (state_104453[(45)]);
var inst_104081 = (state_104453[(64)]);
var inst_104114__$1 = (state_104453[(2)]);
var inst_104115 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_104114__$1,cljs.core.cst$kw$subject_DASH_fn);
var inst_104116 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_104114__$1,cljs.core.cst$kw$predicate_DASH_fn);
var inst_104117 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_104114__$1,cljs.core.cst$kw$object_DASH_fn);
var inst_104118 = fluree.db.util.core.pred_ident_QMARK_(inst_104081);
var state_104453__$1 = (function (){var statearr_104533 = state_104453;
(statearr_104533[(45)] = inst_104114__$1);

(statearr_104533[(74)] = inst_104117);

(statearr_104533[(55)] = inst_104115);

(statearr_104533[(57)] = inst_104116);

return statearr_104533;
})();
if(inst_104118){
var statearr_104534_104718 = state_104453__$1;
(statearr_104534_104718[(1)] = (14));

} else {
var statearr_104535_104719 = state_104453__$1;
(statearr_104535_104719[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (22))){
var inst_104083 = (state_104453[(39)]);
var state_104453__$1 = state_104453;
var statearr_104536_104720 = state_104453__$1;
(statearr_104536_104720[(2)] = inst_104083);

(statearr_104536_104720[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (90))){
var inst_104116 = (state_104453[(57)]);
var inst_104302 = (state_104453[(2)]);
var state_104453__$1 = (function (){var statearr_104537 = state_104453;
(statearr_104537[(69)] = inst_104302);

return statearr_104537;
})();
if(cljs.core.truth_(inst_104116)){
var statearr_104538_104721 = state_104453__$1;
(statearr_104538_104721[(1)] = (91));

} else {
var statearr_104539_104722 = state_104453__$1;
(statearr_104539_104722[(1)] = (92));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (109))){
var inst_104348 = (state_104453[(26)]);
var inst_104357 = (state_104453[(75)]);
var inst_104356 = (state_104453[(78)]);
var inst_104358 = (state_104453[(79)]);
var inst_104254 = (state_104453[(27)]);
var inst_104281 = (state_104453[(28)]);
var inst_104356__$1 = cljs.core.count(inst_104348);
var inst_104357__$1 = (inst_104281 + inst_104356__$1);
var inst_104358__$1 = (inst_104357__$1 - inst_104254);
var inst_104359 = cljs.core.pos_int_QMARK_(inst_104358__$1);
var state_104453__$1 = (function (){var statearr_104540 = state_104453;
(statearr_104540[(75)] = inst_104357__$1);

(statearr_104540[(78)] = inst_104356__$1);

(statearr_104540[(79)] = inst_104358__$1);

return statearr_104540;
})();
if(inst_104359){
var statearr_104541_104723 = state_104453__$1;
(statearr_104541_104723[(1)] = (112));

} else {
var statearr_104542_104724 = state_104453__$1;
(statearr_104542_104724[(1)] = (113));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (36))){
var inst_104169 = (state_104453[(58)]);
var inst_104179 = (state_104453[(2)]);
var inst_104180 = fluree.db.util.core.pred_ident_QMARK_(inst_104169);
var state_104453__$1 = (function (){var statearr_104543 = state_104453;
(statearr_104543[(8)] = inst_104179);

return statearr_104543;
})();
if(inst_104180){
var statearr_104544_104725 = state_104453__$1;
(statearr_104544_104725[(1)] = (38));

} else {
var statearr_104545_104726 = state_104453__$1;
(statearr_104545_104726[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (41))){
var inst_104184 = (state_104453[(2)]);
var inst_104185 = fluree.db.util.async.throw_err(inst_104184);
var state_104453__$1 = state_104453;
var statearr_104546_104727 = state_104453__$1;
(statearr_104546_104727[(2)] = inst_104185);

(statearr_104546_104727[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (118))){
var inst_104399 = (state_104453[(2)]);
var inst_104400 = fluree.db.util.async.throw_err(inst_104399);
var state_104453__$1 = state_104453;
var statearr_104547_104728 = state_104453__$1;
(statearr_104547_104728[(2)] = inst_104400);

(statearr_104547_104728[(1)] = (111));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (89))){
var inst_104296 = (state_104453[(59)]);
var state_104453__$1 = state_104453;
var statearr_104548_104729 = state_104453__$1;
(statearr_104548_104729[(2)] = inst_104296);

(statearr_104548_104729[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (100))){
var state_104453__$1 = state_104453;
var statearr_104549_104730 = state_104453__$1;
(statearr_104549_104730[(2)] = true);

(statearr_104549_104730[(1)] = (102));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (131))){
var inst_104444 = (state_104453[(2)]);
var state_104453__$1 = state_104453;
var statearr_104550_104731 = state_104453__$1;
(statearr_104550_104731[(2)] = inst_104444);

(statearr_104550_104731[(1)] = (84));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (122))){
var inst_104266 = (state_104453[(42)]);
var inst_104271 = (state_104453[(47)]);
var inst_104315 = (state_104453[(67)]);
var inst_104265 = (state_104453[(50)]);
var inst_104261 = (state_104453[(51)]);
var inst_104428 = fluree.db.query.range.find_next_valid_node(inst_104271,inst_104315,inst_104261,inst_104265,inst_104266);
var state_104453__$1 = state_104453;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_104453__$1,(125),inst_104428);
} else {
if((state_val_104454 === (43))){
var state_104453__$1 = state_104453;
var statearr_104551_104732 = state_104453__$1;
(statearr_104551_104732[(2)] = false);

(statearr_104551_104732[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (61))){
var inst_104218 = (cljs.core._LT__EQ_ === end_test);
var state_104453__$1 = state_104453;
if(cljs.core.truth_(inst_104218)){
var statearr_104552_104733 = state_104453__$1;
(statearr_104552_104733[(1)] = (63));

} else {
var statearr_104553_104734 = state_104453__$1;
(statearr_104553_104734[(1)] = (64));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (29))){
var state_104453__$1 = state_104453;
var statearr_104554_104735 = state_104453__$1;
(statearr_104554_104735[(2)] = null);

(statearr_104554_104735[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (44))){
var inst_104193 = (state_104453[(2)]);
var state_104453__$1 = state_104453;
if(cljs.core.truth_(inst_104193)){
var statearr_104555_104736 = state_104453__$1;
(statearr_104555_104736[(1)] = (45));

} else {
var statearr_104556_104737 = state_104453__$1;
(statearr_104556_104737[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (93))){
var inst_104170 = (state_104453[(56)]);
var inst_104308 = (state_104453[(2)]);
var state_104453__$1 = (function (){var statearr_104557 = state_104453;
(statearr_104557[(68)] = inst_104308);

return statearr_104557;
})();
if(cljs.core.truth_(inst_104170)){
var statearr_104558_104738 = state_104453__$1;
(statearr_104558_104738[(1)] = (94));

} else {
var statearr_104559_104739 = state_104453__$1;
(statearr_104559_104739[(1)] = (95));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (6))){
var state_104453__$1 = state_104453;
var statearr_104560_104740 = state_104453__$1;
(statearr_104560_104740[(2)] = false);

(statearr_104560_104740[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (111))){
var inst_104282 = (state_104453[(37)]);
var inst_104402 = (state_104453[(2)]);
var inst_104403 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_104402,(0),null);
var inst_104404 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_104402,(1),null);
var inst_104405 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_104402,(2),null);
var inst_104406 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_104407 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_104282,inst_104405);
var inst_104408 = [(0),inst_104403,inst_104404,inst_104407];
var inst_104409 = (new cljs.core.PersistentVector(null,4,(5),inst_104406,inst_104408,null));
var state_104453__$1 = state_104453;
var statearr_104561_104741 = state_104453__$1;
(statearr_104561_104741[(2)] = inst_104409);

(statearr_104561_104741[(1)] = (108));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (28))){
var state_104453__$1 = state_104453;
var statearr_104562_104742 = state_104453__$1;
(statearr_104562_104742[(2)] = null);

(statearr_104562_104742[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (64))){
var state_104453__$1 = state_104453;
var statearr_104563_104743 = state_104453__$1;
(statearr_104563_104743[(2)] = fluree.db.util.core.min_integer);

(statearr_104563_104743[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (103))){
var inst_104248 = (state_104453[(24)]);
var inst_104281 = (state_104453[(28)]);
var inst_104282 = (state_104453[(37)]);
var inst_104280 = (state_104453[(29)]);
var inst_104314 = (state_104453[(71)]);
var inst_104326 = cljs.core.count(inst_104314);
var inst_104327 = (inst_104248 - inst_104280);
var inst_104328 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_104327,inst_104314);
var inst_104329 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_104282,inst_104328);
var inst_104330 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_104331 = (inst_104280 + inst_104326);
var inst_104332 = [(0),inst_104331,inst_104281,inst_104329];
var inst_104333 = (new cljs.core.PersistentVector(null,4,(5),inst_104330,inst_104332,null));
var state_104453__$1 = state_104453;
var statearr_104564_104744 = state_104453__$1;
(statearr_104564_104744[(2)] = inst_104333);

(statearr_104564_104744[(1)] = (105));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (51))){
var state_104453__$1 = state_104453;
var statearr_104565_104745 = state_104453__$1;
(statearr_104565_104745[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_104565_104745[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (25))){
var inst_104090 = (state_104453[(61)]);
var state_104453__$1 = state_104453;
var statearr_104566_104746 = state_104453__$1;
(statearr_104566_104746[(2)] = inst_104090);

(statearr_104566_104746[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (34))){
var inst_104168 = (state_104453[(77)]);
var inst_104173 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_104168);
var state_104453__$1 = state_104453;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_104453__$1,(37),inst_104173);
} else {
if((state_val_104454 === (125))){
var inst_104430 = (state_104453[(2)]);
var inst_104431 = fluree.db.util.async.throw_err(inst_104430);
var state_104453__$1 = state_104453;
var statearr_104567_104747 = state_104453__$1;
(statearr_104567_104747[(2)] = inst_104431);

(statearr_104567_104747[(1)] = (124));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (17))){
var inst_104122 = (state_104453[(2)]);
var inst_104123 = fluree.db.util.async.throw_err(inst_104122);
var state_104453__$1 = state_104453;
var statearr_104568_104748 = state_104453__$1;
(statearr_104568_104748[(2)] = inst_104123);

(statearr_104568_104748[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (3))){
var inst_104062 = (state_104453[(2)]);
var state_104453__$1 = state_104453;
var statearr_104569_104749 = state_104453__$1;
(statearr_104569_104749[(2)] = inst_104062);


cljs.core.async.impl.ioc_helpers.process_exception(state_104453__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (12))){
var state_104453__$1 = state_104453;
var statearr_104570_104750 = state_104453__$1;
(statearr_104570_104750[(2)] = opts);

(statearr_104570_104750[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (2))){
var inst_104451 = (state_104453[(2)]);
var state_104453__$1 = state_104453;
return cljs.core.async.impl.ioc_helpers.return_chan(state_104453__$1,inst_104451);
} else {
if((state_val_104454 === (66))){
var inst_104231 = opts.cljs$lang$protocol_mask$partition0$;
var inst_104232 = (inst_104231 & (64));
var inst_104233 = opts.cljs$core$ISeq$;
var inst_104234 = (cljs.core.PROTOCOL_SENTINEL === inst_104233);
var inst_104235 = ((inst_104232) || (inst_104234));
var state_104453__$1 = state_104453;
if(cljs.core.truth_(inst_104235)){
var statearr_104571_104751 = state_104453__$1;
(statearr_104571_104751[(1)] = (69));

} else {
var statearr_104572_104752 = state_104453__$1;
(statearr_104572_104752[(1)] = (70));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (107))){
var inst_104336 = (state_104453[(70)]);
var inst_104279 = (state_104453[(36)]);
var inst_104348 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_104279,inst_104336);
var state_104453__$1 = (function (){var statearr_104573 = state_104453;
(statearr_104573[(26)] = inst_104348);

return statearr_104573;
})();
var statearr_104574_104753 = state_104453__$1;
(statearr_104574_104753[(1)] = (109));



return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (23))){
var inst_104090 = (state_104453[(61)]);
var inst_104139 = cljs.core.boolean_QMARK_(inst_104090);
var state_104453__$1 = state_104453;
if(inst_104139){
var statearr_104576_104754 = state_104453__$1;
(statearr_104576_104754[(1)] = (25));

} else {
var statearr_104577_104755 = state_104453__$1;
(statearr_104577_104755[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (47))){
var inst_104089 = (state_104453[(65)]);
var inst_104197 = (state_104453[(2)]);
var inst_104198 = (inst_104089 == null);
var state_104453__$1 = (function (){var statearr_104578 = state_104453;
(statearr_104578[(14)] = inst_104197);

return statearr_104578;
})();
if(cljs.core.truth_(inst_104198)){
var statearr_104579_104756 = state_104453__$1;
(statearr_104579_104756[(1)] = (48));

} else {
var statearr_104580_104757 = state_104453__$1;
(statearr_104580_104757[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (35))){
var inst_104168 = (state_104453[(77)]);
var state_104453__$1 = state_104453;
var statearr_104581_104758 = state_104453__$1;
(statearr_104581_104758[(2)] = inst_104168);

(statearr_104581_104758[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (127))){
var inst_104426 = (state_104453[(7)]);
var state_104453__$1 = state_104453;
var statearr_104582_104759 = state_104453__$1;
(statearr_104582_104759[(2)] = inst_104426);

(statearr_104582_104759[(1)] = (128));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (82))){
var inst_104449 = (state_104453[(2)]);
var state_104453__$1 = state_104453;
var statearr_104583_104760 = state_104453__$1;
(statearr_104583_104760[(2)] = inst_104449);


cljs.core.async.impl.ioc_helpers.process_exception(state_104453__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (76))){
var state_104453__$1 = state_104453;
var statearr_104584_104761 = state_104453__$1;
(statearr_104584_104761[(2)] = fluree.db.util.core.max_long);

(statearr_104584_104761[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (97))){
var inst_104279 = (state_104453[(36)]);
var inst_104317 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_104279);
var state_104453__$1 = state_104453;
if(inst_104317){
var statearr_104585_104762 = state_104453__$1;
(statearr_104585_104762[(1)] = (100));

} else {
var statearr_104586_104763 = state_104453__$1;
(statearr_104586_104763[(1)] = (101));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (19))){
var inst_104088 = (state_104453[(62)]);
var state_104453__$1 = state_104453;
var statearr_104587_104764 = state_104453__$1;
(statearr_104587_104764[(2)] = inst_104088);

(statearr_104587_104764[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (57))){
var state_104453__$1 = state_104453;
var statearr_104588_104765 = state_104453__$1;
(statearr_104588_104765[(2)] = fluree.db.util.core.min_integer);

(statearr_104588_104765[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (68))){
var inst_104242 = (state_104453[(2)]);
var state_104453__$1 = state_104453;
if(cljs.core.truth_(inst_104242)){
var statearr_104589_104766 = state_104453__$1;
(statearr_104589_104766[(1)] = (72));

} else {
var statearr_104590_104767 = state_104453__$1;
(statearr_104590_104767[(1)] = (73));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (11))){
var inst_104111 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,opts);
var state_104453__$1 = state_104453;
var statearr_104591_104768 = state_104453__$1;
(statearr_104591_104768[(2)] = inst_104111);

(statearr_104591_104768[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (115))){
var inst_104248 = (state_104453[(24)]);
var inst_104375 = (state_104453[(80)]);
var inst_104376 = (state_104453[(72)]);
var inst_104374 = (state_104453[(73)]);
var inst_104379 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_104380 = (inst_104376 - inst_104248);
var inst_104381 = (inst_104375 - inst_104380);
var inst_104382 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_104381,inst_104374);
var inst_104383 = [inst_104248,inst_104382];
var inst_104384 = (new cljs.core.PersistentVector(null,2,(5),inst_104379,inst_104383,null));
var state_104453__$1 = state_104453;
var statearr_104592_104769 = state_104453__$1;
(statearr_104592_104769[(2)] = inst_104384);

(statearr_104592_104769[(1)] = (117));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (9))){
var state_104453__$1 = state_104453;
var statearr_104593_104770 = state_104453__$1;
(statearr_104593_104770[(2)] = false);

(statearr_104593_104770[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (5))){
var inst_104098 = opts.cljs$lang$protocol_mask$partition0$;
var inst_104099 = (inst_104098 & (64));
var inst_104100 = opts.cljs$core$ISeq$;
var inst_104101 = (cljs.core.PROTOCOL_SENTINEL === inst_104100);
var inst_104102 = ((inst_104099) || (inst_104101));
var state_104453__$1 = state_104453;
if(cljs.core.truth_(inst_104102)){
var statearr_104594_104771 = state_104453__$1;
(statearr_104594_104771[(1)] = (8));

} else {
var statearr_104595_104772 = state_104453__$1;
(statearr_104595_104772[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (112))){
var inst_104356 = (state_104453[(78)]);
var inst_104358 = (state_104453[(79)]);
var inst_104254 = (state_104453[(27)]);
var inst_104361 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_104362 = (inst_104356 - inst_104358);
var inst_104363 = [inst_104254,inst_104362];
var inst_104364 = (new cljs.core.PersistentVector(null,2,(5),inst_104361,inst_104363,null));
var state_104453__$1 = state_104453;
var statearr_104596_104773 = state_104453__$1;
(statearr_104596_104773[(2)] = inst_104364);

(statearr_104596_104773[(1)] = (114));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (83))){
var inst_104225 = (state_104453[(20)]);
var inst_104278 = (state_104453[(35)]);
var inst_104226 = (state_104453[(21)]);
var inst_104287 = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(inst_104278);
var inst_104288 = fluree.db.flake.subrange(inst_104287,start_test,inst_104225,end_test,inst_104226);
var inst_104290 = fluree.db.query.range.value_with_nil_pred(idx,inst_104225,inst_104226);
var state_104453__$1 = (function (){var statearr_104597 = state_104453;
(statearr_104597[(38)] = inst_104288);

return statearr_104597;
})();
if(inst_104290){
var statearr_104598_104774 = state_104453__$1;
(statearr_104598_104774[(1)] = (85));

} else {
var statearr_104599_104775 = state_104453__$1;
(statearr_104599_104775[(1)] = (86));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (14))){
var inst_104081 = (state_104453[(64)]);
var inst_104120 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_104081);
var state_104453__$1 = state_104453;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_104453__$1,(17),inst_104120);
} else {
if((state_val_104454 === (45))){
var state_104453__$1 = state_104453;
var statearr_104600_104776 = state_104453__$1;
(statearr_104600_104776[(2)] = (-1));

(statearr_104600_104776[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (53))){
var inst_104086 = (state_104453[(63)]);
var inst_104206 = (state_104453[(2)]);
var state_104453__$1 = (function (){var statearr_104601 = state_104453;
(statearr_104601[(17)] = inst_104206);

return statearr_104601;
})();
if(cljs.core.truth_(inst_104086)){
var statearr_104602_104777 = state_104453__$1;
(statearr_104602_104777[(1)] = (54));

} else {
var statearr_104603_104778 = state_104453__$1;
(statearr_104603_104778[(1)] = (55));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (78))){
var inst_104225 = (state_104453[(20)]);
var inst_104266 = (state_104453[(42)]);
var inst_104271 = (state_104453[(47)]);
var inst_104265 = (state_104453[(50)]);
var inst_104261 = (state_104453[(51)]);
var inst_104270 = (state_104453[(2)]);
var inst_104271__$1 = fluree.db.util.async.throw_err(inst_104270);
var inst_104272 = fluree.db.query.range.find_next_valid_node(inst_104271__$1,inst_104225,inst_104261,inst_104265,inst_104266);
var state_104453__$1 = (function (){var statearr_104604 = state_104453;
(statearr_104604[(47)] = inst_104271__$1);

return statearr_104604;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_104453__$1,(79),inst_104272);
} else {
if((state_val_104454 === (26))){
var state_104453__$1 = state_104453;
var statearr_104605_104779 = state_104453__$1;
(statearr_104605_104779[(1)] = (28));



return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (123))){
var state_104453__$1 = state_104453;
var statearr_104607_104780 = state_104453__$1;
(statearr_104607_104780[(2)] = null);

(statearr_104607_104780[(1)] = (124));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (16))){
var inst_104088 = (state_104453[(62)]);
var inst_104126 = (state_104453[(2)]);
var inst_104127 = fluree.db.util.core.pred_ident_QMARK_(inst_104088);
var state_104453__$1 = (function (){var statearr_104608 = state_104453;
(statearr_104608[(10)] = inst_104126);

return statearr_104608;
})();
if(inst_104127){
var statearr_104609_104781 = state_104453__$1;
(statearr_104609_104781[(1)] = (18));

} else {
var statearr_104610_104782 = state_104453__$1;
(statearr_104610_104782[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (81))){
var state_104453__$1 = state_104453;
var statearr_104611_104783 = state_104453__$1;
(statearr_104611_104783[(2)] = null);

(statearr_104611_104783[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (120))){
var inst_104315 = (state_104453[(67)]);
var state_104453__$1 = state_104453;
var statearr_104612_104784 = state_104453__$1;
(statearr_104612_104784[(2)] = inst_104315);

(statearr_104612_104784[(1)] = (121));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (79))){
var inst_104275 = (state_104453[(54)]);
var inst_104274 = (state_104453[(2)]);
var inst_104275__$1 = fluree.db.util.async.throw_err(inst_104274);
var state_104453__$1 = (function (){var statearr_104613 = state_104453;
(statearr_104613[(54)] = inst_104275__$1);

return statearr_104613;
})();
if(cljs.core.truth_(inst_104275__$1)){
var statearr_104614_104785 = state_104453__$1;
(statearr_104614_104785[(1)] = (80));

} else {
var statearr_104615_104786 = state_104453__$1;
(statearr_104615_104786[(1)] = (81));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (38))){
var inst_104169 = (state_104453[(58)]);
var inst_104182 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_104169);
var state_104453__$1 = state_104453;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_104453__$1,(41),inst_104182);
} else {
if((state_val_104454 === (126))){
var inst_104434 = (state_104453[(31)]);
var state_104453__$1 = state_104453;
var statearr_104616_104787 = state_104453__$1;
(statearr_104616_104787[(2)] = inst_104434);

(statearr_104616_104787[(1)] = (128));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (98))){
var inst_104255 = (state_104453[(43)]);
var state_104453__$1 = state_104453;
var statearr_104617_104788 = state_104453__$1;
(statearr_104617_104788[(2)] = inst_104255);

(statearr_104617_104788[(1)] = (99));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (124))){
var inst_104426 = (state_104453[(7)]);
var inst_104434 = (state_104453[(2)]);
var state_104453__$1 = (function (){var statearr_104618 = state_104453;
(statearr_104618[(31)] = inst_104434);

return statearr_104618;
})();
if(cljs.core.truth_(inst_104426)){
var statearr_104619_104789 = state_104453__$1;
(statearr_104619_104789[(1)] = (126));

} else {
var statearr_104620_104790 = state_104453__$1;
(statearr_104620_104790[(1)] = (127));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (87))){
var inst_104115 = (state_104453[(55)]);
var inst_104296 = (state_104453[(2)]);
var state_104453__$1 = (function (){var statearr_104621 = state_104453;
(statearr_104621[(59)] = inst_104296);

return statearr_104621;
})();
if(cljs.core.truth_(inst_104115)){
var statearr_104622_104791 = state_104453__$1;
(statearr_104622_104791[(1)] = (88));

} else {
var statearr_104623_104792 = state_104453__$1;
(statearr_104623_104792[(1)] = (89));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (30))){
var inst_104145 = (state_104453[(2)]);
var state_104453__$1 = state_104453;
var statearr_104624_104793 = state_104453__$1;
(statearr_104624_104793[(2)] = inst_104145);

(statearr_104624_104793[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (73))){
var state_104453__$1 = state_104453;
var statearr_104625_104794 = state_104453__$1;
(statearr_104625_104794[(2)] = opts);

(statearr_104625_104794[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (96))){
var inst_104278 = (state_104453[(35)]);
var inst_104255 = (state_104453[(43)]);
var inst_104314 = (state_104453[(2)]);
var inst_104315 = fluree.db.dbproto._rhs(inst_104278);
var state_104453__$1 = (function (){var statearr_104626 = state_104453;
(statearr_104626[(67)] = inst_104315);

(statearr_104626[(71)] = inst_104314);

return statearr_104626;
})();
if(cljs.core.truth_(inst_104255)){
var statearr_104627_104795 = state_104453__$1;
(statearr_104627_104795[(1)] = (97));

} else {
var statearr_104628_104796 = state_104453__$1;
(statearr_104628_104796[(1)] = (98));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (10))){
var inst_104106 = (state_104453[(2)]);
var state_104453__$1 = state_104453;
var statearr_104629_104797 = state_104453__$1;
(statearr_104629_104797[(2)] = inst_104106);

(statearr_104629_104797[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (18))){
var inst_104088 = (state_104453[(62)]);
var inst_104129 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_104088);
var state_104453__$1 = state_104453;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_104453__$1,(21),inst_104129);
} else {
if((state_val_104454 === (105))){
var inst_104315 = (state_104453[(67)]);
var inst_104413 = (state_104453[(2)]);
var inst_104414 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_104413,(0),null);
var inst_104415 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_104413,(1),null);
var inst_104416 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_104413,(2),null);
var inst_104417 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_104413,(3),null);
var state_104453__$1 = (function (){var statearr_104630 = state_104453;
(statearr_104630[(30)] = inst_104417);

(statearr_104630[(32)] = inst_104414);

(statearr_104630[(33)] = inst_104415);

(statearr_104630[(34)] = inst_104416);

return statearr_104630;
})();
if(cljs.core.truth_(inst_104315)){
var statearr_104631_104798 = state_104453__$1;
(statearr_104631_104798[(1)] = (119));

} else {
var statearr_104632_104799 = state_104453__$1;
(statearr_104632_104799[(1)] = (120));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (52))){
var inst_104089 = (state_104453[(65)]);
var state_104453__$1 = state_104453;
var statearr_104633_104800 = state_104453__$1;
(statearr_104633_104800[(2)] = inst_104089);

(statearr_104633_104800[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (114))){
var inst_104348 = (state_104453[(26)]);
var inst_104248 = (state_104453[(24)]);
var inst_104375 = (state_104453[(80)]);
var inst_104376 = (state_104453[(72)]);
var inst_104280 = (state_104453[(29)]);
var inst_104374 = (state_104453[(73)]);
var inst_104370 = (state_104453[(2)]);
var inst_104371 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_104370,(0),null);
var inst_104372 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_104370,(1),null);
var inst_104373 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_104372,inst_104348);
var inst_104374__$1 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_104373);
var inst_104375__$1 = cljs.core.count(inst_104374__$1);
var inst_104376__$1 = (inst_104280 + inst_104375__$1);
var inst_104377 = (inst_104376__$1 > inst_104248);
var state_104453__$1 = (function (){var statearr_104634 = state_104453;
(statearr_104634[(76)] = inst_104371);

(statearr_104634[(80)] = inst_104375__$1);

(statearr_104634[(72)] = inst_104376__$1);

(statearr_104634[(73)] = inst_104374__$1);

return statearr_104634;
})();
if(cljs.core.truth_(inst_104377)){
var statearr_104635_104801 = state_104453__$1;
(statearr_104635_104801[(1)] = (115));

} else {
var statearr_104636_104802 = state_104453__$1;
(statearr_104636_104802[(1)] = (116));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (67))){
var state_104453__$1 = state_104453;
var statearr_104637_104803 = state_104453__$1;
(statearr_104637_104803[(2)] = false);

(statearr_104637_104803[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (71))){
var inst_104239 = (state_104453[(2)]);
var state_104453__$1 = state_104453;
var statearr_104638_104804 = state_104453__$1;
(statearr_104638_104804[(2)] = inst_104239);

(statearr_104638_104804[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (42))){
var inst_104179 = (state_104453[(8)]);
var state_104453__$1 = state_104453;
var statearr_104639_104805 = state_104453__$1;
(statearr_104639_104805[(2)] = inst_104179);

(statearr_104639_104805[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (80))){
var inst_104275 = (state_104453[(54)]);
var inst_104250 = (state_104453[(25)]);
var inst_104277 = cljs.core.PersistentVector.EMPTY;
var inst_104278 = inst_104275;
var inst_104279 = inst_104250;
var inst_104280 = (0);
var inst_104281 = (0);
var inst_104282 = inst_104277;
var state_104453__$1 = (function (){var statearr_104640 = state_104453;
(statearr_104640[(35)] = inst_104278);

(statearr_104640[(36)] = inst_104279);

(statearr_104640[(28)] = inst_104281);

(statearr_104640[(37)] = inst_104282);

(statearr_104640[(29)] = inst_104280);

return statearr_104640;
})();
var statearr_104641_104806 = state_104453__$1;
(statearr_104641_104806[(2)] = null);

(statearr_104641_104806[(1)] = (83));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (37))){
var inst_104175 = (state_104453[(2)]);
var inst_104176 = fluree.db.util.async.throw_err(inst_104175);
var state_104453__$1 = state_104453;
var statearr_104642_104807 = state_104453__$1;
(statearr_104642_104807[(2)] = inst_104176);

(statearr_104642_104807[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (63))){
var state_104453__$1 = state_104453;
var statearr_104643_104808 = state_104453__$1;
(statearr_104643_104808[(2)] = (2147483647));

(statearr_104643_104808[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (94))){
var inst_104225 = (state_104453[(20)]);
var inst_104278 = (state_104453[(35)]);
var inst_104266 = (state_104453[(42)]);
var inst_104255 = (state_104453[(43)]);
var inst_104167 = (state_104453[(44)]);
var inst_104114 = (state_104453[(45)]);
var inst_104260 = (state_104453[(46)]);
var inst_104271 = (state_104453[(47)]);
var inst_104179 = (state_104453[(8)]);
var inst_104087 = (state_104453[(48)]);
var inst_104256 = (state_104453[(49)]);
var inst_104084 = (state_104453[(9)]);
var inst_104126 = (state_104453[(10)]);
var inst_104248 = (state_104453[(24)]);
var inst_104091 = (state_104453[(11)]);
var inst_104265 = (state_104453[(50)]);
var inst_104261 = (state_104453[(51)]);
var inst_104308 = (state_104453[(68)]);
var inst_104254 = (state_104453[(27)]);
var inst_104135 = (state_104453[(12)]);
var inst_104166 = (state_104453[(52)]);
var inst_104279 = (state_104453[(36)]);
var inst_104281 = (state_104453[(28)]);
var inst_104080 = (state_104453[(53)]);
var inst_104188 = (state_104453[(13)]);
var inst_104197 = (state_104453[(14)]);
var inst_104275 = (state_104453[(54)]);
var inst_104092 = (state_104453[(15)]);
var inst_104085 = (state_104453[(16)]);
var inst_104115 = (state_104453[(55)]);
var inst_104170 = (state_104453[(56)]);
var inst_104247 = (state_104453[(23)]);
var inst_104206 = (state_104453[(17)]);
var inst_104116 = (state_104453[(57)]);
var inst_104224 = (state_104453[(18)]);
var inst_104226 = (state_104453[(21)]);
var inst_104282 = (state_104453[(37)]);
var inst_104215 = (state_104453[(19)]);
var inst_104280 = (state_104453[(29)]);
var inst_104288 = (state_104453[(38)]);
var inst_104310 = (function (){var no_filter_QMARK_ = true;
var t = inst_104261;
var max_limit_QMARK_ = inst_104255;
var next_node = inst_104278;
var map__104072 = inst_104114;
var fast_forward_db_QMARK_ = inst_104266;
var s1 = inst_104126;
var vec__104073 = inst_104166;
var o2 = inst_104188;
var t1 = inst_104084;
var vec__104066 = inst_104080;
var predicate_fn = inst_104116;
var i = inst_104280;
var m1 = inst_104215;
var root_node = inst_104271;
var vec__104076 = inst_104167;
var G__104289 = inst_104308;
var s2 = inst_104135;
var p2 = inst_104206;
var permissions = inst_104256;
var limit = inst_104254;
var start_flake = inst_104225;
var flake_limit = inst_104248;
var offset = inst_104279;
var vec__104069 = inst_104087;
var acc = inst_104282;
var t2 = inst_104091;
var op1 = inst_104085;
var o1 = inst_104179;
var end_flake = inst_104226;
var base_result = inst_104288;
var s = inst_104281;
var node_start = inst_104275;
var p1 = inst_104197;
var subject_fn = inst_104115;
var object_fn = inst_104170;
var idx_compare = inst_104260;
var op2 = inst_104092;
var map__104079 = inst_104247;
var m2 = inst_104224;
var novelty = inst_104265;
return (function (p1__104052_SHARP_){
var G__104644 = p1__104052_SHARP_.o;
return (object_fn.cljs$core$IFn$_invoke$arity$1 ? object_fn.cljs$core$IFn$_invoke$arity$1(G__104644) : object_fn.call(null,G__104644));
});
})();
var inst_104311 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_104310,inst_104308);
var state_104453__$1 = state_104453;
var statearr_104645_104809 = state_104453__$1;
(statearr_104645_104809[(2)] = inst_104311);

(statearr_104645_104809[(1)] = (96));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (8))){
var state_104453__$1 = state_104453;
var statearr_104646_104810 = state_104453__$1;
(statearr_104646_104810[(2)] = true);

(statearr_104646_104810[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (49))){
var state_104453__$1 = state_104453;
var statearr_104647_104811 = state_104453__$1;
(statearr_104647_104811[(2)] = false);

(statearr_104647_104811[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104454 === (84))){
var inst_104446 = (state_104453[(2)]);
var state_104453__$1 = state_104453;
var statearr_104648_104812 = state_104453__$1;
(statearr_104648_104812[(2)] = inst_104446);

(statearr_104648_104812[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__100742__auto__ = null;
var fluree$db$query$range$state_machine__100742__auto____0 = (function (){
var statearr_104649 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_104649[(0)] = fluree$db$query$range$state_machine__100742__auto__);

(statearr_104649[(1)] = (1));

return statearr_104649;
});
var fluree$db$query$range$state_machine__100742__auto____1 = (function (state_104453){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_104453);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e104650){if((e104650 instanceof Object)){
var ex__100745__auto__ = e104650;
var statearr_104651_104813 = state_104453;
(statearr_104651_104813[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_104453);

return cljs.core.cst$kw$recur;
} else {
throw e104650;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__104814 = state_104453;
state_104453 = G__104814;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__100742__auto__ = function(state_104453){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__100742__auto____1.call(this,state_104453);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__100742__auto____0;
fluree$db$query$range$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__100742__auto____1;
return fluree$db$query$range$state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_104652 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_104652[(6)] = c__100848__auto__);

return statearr_104652;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
}));

(fluree.db.query.range.index_range.cljs$lang$maxFixedArity = 7);

fluree.db.query.range.non_nil_non_boolean_QMARK_ = (function fluree$db$query$range$non_nil_non_boolean_QMARK_(o){
return (((!((o == null)))) && ((!(cljs.core.boolean_QMARK_(o)))));
});
fluree.db.query.range.tag_string_QMARK_ = (function fluree$db$query$range$tag_string_QMARK_(possible_tag){
return cljs.core.re_find(/^[a-zA-Z0-9-_]*\/[a-zA-Z0-9-_]*:[a-zA-Z0-9-]*$/,possible_tag);
});
fluree.db.query.range.tag_sid_start = fluree.db.flake.min_subject_id((3));
fluree.db.query.range.tag_sid_end = fluree.db.flake.max_subject_id((3));
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.query.range.is_tag_flake_QMARK_ = (function fluree$db$query$range$is_tag_flake_QMARK_(f){
return (((fluree.db.query.range.tag_sid_start <= f.o)) && ((f.o <= fluree.db.query.range.tag_sid_end)));
});
fluree.db.query.range.coerce_tag_flakes = (function fluree$db$query$range$coerce_tag_flakes(db,flakes){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_104869){
var state_val_104870 = (state_104869[(1)]);
if((state_val_104870 === (7))){
var inst_104833 = (state_104869[(7)]);
var inst_104843 = (state_104869[(8)]);
var inst_104841 = fluree.db.flake.Flake__GT_parts(inst_104833);
var inst_104842 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_104841,(0),null);
var inst_104843__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_104841,(1),null);
var inst_104844 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_104841,(2),null);
var inst_104845 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_104841,(3),null);
var inst_104846 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_104841,(4),null);
var inst_104847 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_104841,(5),null);
var inst_104848 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_104844,inst_104843__$1);
var state_104869__$1 = (function (){var statearr_104871 = state_104869;
(statearr_104871[(9)] = inst_104846);

(statearr_104871[(10)] = inst_104842);

(statearr_104871[(11)] = inst_104845);

(statearr_104871[(12)] = inst_104847);

(statearr_104871[(8)] = inst_104843__$1);

return statearr_104871;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_104869__$1,(10),inst_104848);
} else {
if((state_val_104870 === (1))){
var inst_104822 = cljs.core.seq(flakes);
var inst_104823 = cljs.core.first(inst_104822);
var inst_104824 = cljs.core.next(inst_104822);
var inst_104825 = cljs.core.PersistentVector.EMPTY;
var inst_104826 = flakes;
var inst_104827 = inst_104825;
var state_104869__$1 = (function (){var statearr_104872 = state_104869;
(statearr_104872[(13)] = inst_104826);

(statearr_104872[(14)] = inst_104823);

(statearr_104872[(15)] = inst_104824);

(statearr_104872[(16)] = inst_104827);

return statearr_104872;
})();
var statearr_104873_104890 = state_104869__$1;
(statearr_104873_104890[(2)] = null);

(statearr_104873_104890[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104870 === (4))){
var inst_104833 = (state_104869[(7)]);
var inst_104836 = fluree.db.query.range.is_tag_flake_QMARK_(inst_104833);
var state_104869__$1 = state_104869;
if(inst_104836){
var statearr_104874_104891 = state_104869__$1;
(statearr_104874_104891[(1)] = (7));

} else {
var statearr_104875_104892 = state_104869__$1;
(statearr_104875_104892[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104870 === (6))){
var inst_104865 = (state_104869[(2)]);
var state_104869__$1 = state_104869;
var statearr_104876_104893 = state_104869__$1;
(statearr_104876_104893[(2)] = inst_104865);

(statearr_104876_104893[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104870 === (3))){
var inst_104867 = (state_104869[(2)]);
var state_104869__$1 = state_104869;
return cljs.core.async.impl.ioc_helpers.return_chan(state_104869__$1,inst_104867);
} else {
if((state_val_104870 === (2))){
var inst_104826 = (state_104869[(13)]);
var inst_104833 = (state_104869[(7)]);
var inst_104832 = cljs.core.seq(inst_104826);
var inst_104833__$1 = cljs.core.first(inst_104832);
var inst_104834 = cljs.core.next(inst_104832);
var state_104869__$1 = (function (){var statearr_104877 = state_104869;
(statearr_104877[(7)] = inst_104833__$1);

(statearr_104877[(17)] = inst_104834);

return statearr_104877;
})();
if(cljs.core.truth_(inst_104833__$1)){
var statearr_104878_104894 = state_104869__$1;
(statearr_104878_104894[(1)] = (4));

} else {
var statearr_104879_104895 = state_104869__$1;
(statearr_104879_104895[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104870 === (9))){
var inst_104862 = (state_104869[(2)]);
var state_104869__$1 = state_104869;
var statearr_104880_104896 = state_104869__$1;
(statearr_104880_104896[(2)] = inst_104862);

(statearr_104880_104896[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104870 === (5))){
var inst_104827 = (state_104869[(16)]);
var state_104869__$1 = state_104869;
var statearr_104881_104897 = state_104869__$1;
(statearr_104881_104897[(2)] = inst_104827);

(statearr_104881_104897[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104870 === (10))){
var inst_104846 = (state_104869[(9)]);
var inst_104842 = (state_104869[(10)]);
var inst_104845 = (state_104869[(11)]);
var inst_104834 = (state_104869[(17)]);
var inst_104847 = (state_104869[(12)]);
var inst_104827 = (state_104869[(16)]);
var inst_104843 = (state_104869[(8)]);
var inst_104850 = (state_104869[(2)]);
var inst_104851 = fluree.db.util.async.throw_err(inst_104850);
var inst_104852 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_104853 = [inst_104842,inst_104843,inst_104851,inst_104845,inst_104846,inst_104847];
var inst_104854 = (new cljs.core.PersistentVector(null,6,(5),inst_104852,inst_104853,null));
var inst_104855 = fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(inst_104854);
var inst_104856 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_104827,inst_104855);
var inst_104826 = inst_104834;
var inst_104827__$1 = inst_104856;
var state_104869__$1 = (function (){var statearr_104882 = state_104869;
(statearr_104882[(13)] = inst_104826);

(statearr_104882[(16)] = inst_104827__$1);

return statearr_104882;
})();
var statearr_104883_104898 = state_104869__$1;
(statearr_104883_104898[(2)] = null);

(statearr_104883_104898[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104870 === (8))){
var inst_104833 = (state_104869[(7)]);
var inst_104834 = (state_104869[(17)]);
var inst_104827 = (state_104869[(16)]);
var inst_104859 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_104827,inst_104833);
var inst_104826 = inst_104834;
var inst_104827__$1 = inst_104859;
var state_104869__$1 = (function (){var statearr_104884 = state_104869;
(statearr_104884[(13)] = inst_104826);

(statearr_104884[(16)] = inst_104827__$1);

return statearr_104884;
})();
var statearr_104885_104899 = state_104869__$1;
(statearr_104885_104899[(2)] = null);

(statearr_104885_104899[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__100742__auto__ = null;
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__100742__auto____0 = (function (){
var statearr_104886 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_104886[(0)] = fluree$db$query$range$coerce_tag_flakes_$_state_machine__100742__auto__);

(statearr_104886[(1)] = (1));

return statearr_104886;
});
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__100742__auto____1 = (function (state_104869){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_104869);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e104887){if((e104887 instanceof Object)){
var ex__100745__auto__ = e104887;
var statearr_104888_104900 = state_104869;
(statearr_104888_104900[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_104869);

return cljs.core.cst$kw$recur;
} else {
throw e104887;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__104901 = state_104869;
state_104869 = G__104901;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$query$range$coerce_tag_flakes_$_state_machine__100742__auto__ = function(state_104869){
switch(arguments.length){
case 0:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__100742__auto____1.call(this,state_104869);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$coerce_tag_flakes_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__100742__auto____0;
fluree$db$query$range$coerce_tag_flakes_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__100742__auto____1;
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_104889 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_104889[(6)] = c__100848__auto__);

return statearr_104889;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
fluree.db.query.range.search = (function fluree$db$query$range$search(var_args){
var G__104903 = arguments.length;
switch (G__104903) {
case 2:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2 = (function (db,fparts){
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,fparts,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3 = (function (db,fparts,opts){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_105050){
var state_val_105051 = (state_105050[(1)]);
if((state_val_105051 === (62))){
var inst_105046 = (state_105050[(2)]);
var state_105050__$1 = state_105050;
var statearr_105052_105134 = state_105050__$1;
(statearr_105052_105134[(2)] = inst_105046);


cljs.core.async.impl.ioc_helpers.process_exception(state_105050__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_105051 === (7))){
var inst_104921 = (state_105050[(7)]);
var inst_104921__$1 = (state_105050[(2)]);
var state_105050__$1 = (function (){var statearr_105053 = state_105050;
(statearr_105053[(7)] = inst_104921__$1);

return statearr_105053;
})();
if(cljs.core.truth_(inst_104921__$1)){
var statearr_105054_105135 = state_105050__$1;
(statearr_105054_105135[(1)] = (8));

} else {
var statearr_105055_105136 = state_105050__$1;
(statearr_105055_105136[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105051 === (59))){
var inst_105026 = (state_105050[(2)]);
var inst_105027 = fluree.db.util.async.throw_err(inst_105026);
var state_105050__$1 = state_105050;
var statearr_105056_105137 = state_105050__$1;
(statearr_105056_105137[(2)] = inst_105027);

(statearr_105056_105137[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105051 === (20))){
var inst_104947 = (state_105050[(2)]);
var state_105050__$1 = state_105050;
var statearr_105057_105138 = state_105050__$1;
(statearr_105057_105138[(2)] = inst_104947);

(statearr_105057_105138[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105051 === (58))){
var inst_105030 = (state_105050[(2)]);
var state_105050__$1 = state_105050;
var statearr_105058_105139 = state_105050__$1;
(statearr_105058_105139[(2)] = inst_105030);

(statearr_105058_105139[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105051 === (60))){
var inst_105038 = (state_105050[(8)]);
var inst_105040 = fluree.db.query.range.coerce_tag_flakes(db,inst_105038);
var state_105050__$1 = state_105050;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_105050__$1,(63),inst_105040);
} else {
if((state_val_105051 === (27))){
var inst_104912 = (state_105050[(9)]);
var state_105050__$1 = state_105050;
var statearr_105059_105140 = state_105050__$1;
(statearr_105059_105140[(2)] = inst_104912);

(statearr_105059_105140[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105051 === (1))){
var state_105050__$1 = state_105050;
var statearr_105060_105141 = state_105050__$1;
(statearr_105060_105141[(2)] = null);

(statearr_105060_105141[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105051 === (24))){
var inst_104921 = (state_105050[(7)]);
var inst_105038 = (state_105050[(2)]);
var state_105050__$1 = (function (){var statearr_105061 = state_105050;
(statearr_105061[(8)] = inst_105038);

return statearr_105061;
})();
if(cljs.core.truth_(inst_104921)){
var statearr_105062_105142 = state_105050__$1;
(statearr_105062_105142[(1)] = (60));

} else {
var statearr_105063_105143 = state_105050__$1;
(statearr_105063_105143[(1)] = (61));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105051 === (55))){
var inst_105017 = (state_105050[(2)]);
var inst_105018 = fluree.db.util.async.throw_err(inst_105017);
var state_105050__$1 = state_105050;
var statearr_105064_105144 = state_105050__$1;
(statearr_105064_105144[(2)] = inst_105018);

(statearr_105064_105144[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105051 === (39))){
var inst_104915 = (state_105050[(10)]);
var inst_104986 = cljs.core.not(inst_104915);
var state_105050__$1 = state_105050;
if(inst_104986){
var statearr_105065_105145 = state_105050__$1;
(statearr_105065_105145[(1)] = (42));

} else {
var statearr_105066_105146 = state_105050__$1;
(statearr_105066_105146[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105051 === (46))){
var inst_104912 = (state_105050[(9)]);
var state_105050__$1 = state_105050;
if(cljs.core.truth_(inst_104912)){
var statearr_105067_105147 = state_105050__$1;
(statearr_105067_105147[(1)] = (52));

} else {
var statearr_105068_105148 = state_105050__$1;
(statearr_105068_105148[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105051 === (4))){
var inst_104912 = (state_105050[(9)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_105050,(3),Error,null,(2));
var inst_104911 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(fparts,(0),null);
var inst_104912__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(fparts,(1),null);
var inst_104913 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(fparts,(2),null);
var inst_104914 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(fparts,(3),null);
var inst_104915 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$idx_QMARK_,inst_104912__$1);
var state_105050__$1 = (function (){var statearr_105069 = state_105050;
(statearr_105069[(9)] = inst_104912__$1);

(statearr_105069[(11)] = inst_104914);

(statearr_105069[(12)] = inst_104913);

(statearr_105069[(10)] = inst_104915);

(statearr_105069[(13)] = inst_104911);

return statearr_105069;
})();
if(cljs.core.truth_(inst_104912__$1)){
var statearr_105070_105149 = state_105050__$1;
(statearr_105070_105149[(1)] = (5));

} else {
var statearr_105071_105150 = state_105050__$1;
(statearr_105071_105150[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105051 === (54))){
var inst_105032 = (state_105050[(2)]);
var state_105050__$1 = state_105050;
var statearr_105072_105151 = state_105050__$1;
(statearr_105072_105151[(2)] = inst_105032);

(statearr_105072_105151[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105051 === (15))){
var inst_104913 = (state_105050[(12)]);
var inst_104937 = typeof inst_104913 === 'string';
var state_105050__$1 = state_105050;
if(cljs.core.truth_(inst_104937)){
var statearr_105073_105152 = state_105050__$1;
(statearr_105073_105152[(1)] = (18));

} else {
var statearr_105074_105153 = state_105050__$1;
(statearr_105074_105153[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105051 === (48))){
var inst_104912 = (state_105050[(9)]);
var inst_104914 = (state_105050[(11)]);
var inst_104915 = (state_105050[(10)]);
var inst_104911 = (state_105050[(13)]);
var inst_104995 = (state_105050[(14)]);
var inst_104951 = (state_105050[(15)]);
var inst_104926 = (state_105050[(16)]);
var inst_104921 = (state_105050[(7)]);
var inst_104997 = (function (){var obj_fn = inst_104995;
var t = inst_104914;
var temp__5733__auto__ = inst_104995;
var p = inst_104912;
var idx_predicate_QMARK_ = inst_104915;
var o = inst_104951;
var tag_predicate_QMARK_ = inst_104921;
var s = inst_104911;
var o_coerce_QMARK_ = inst_104926;
var vec__104908 = fparts;
return (function (x){
var and__4115__auto__ = (obj_fn.cljs$core$IFn$_invoke$arity$1 ? obj_fn.cljs$core$IFn$_invoke$arity$1(x) : obj_fn.call(null,x));
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
} else {
return and__4115__auto__;
}
});
})();
var state_105050__$1 = state_105050;
var statearr_105075_105154 = state_105050__$1;
(statearr_105075_105154[(2)] = inst_104997);

(statearr_105075_105154[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105051 === (50))){
var inst_104912 = (state_105050[(9)]);
var inst_104914 = (state_105050[(11)]);
var inst_104911 = (state_105050[(13)]);
var inst_105001 = (state_105050[(2)]);
var inst_105002 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_105003 = [inst_104912,inst_104911,null,inst_104914];
var inst_105004 = (new cljs.core.PersistentVector(null,4,(5),inst_105002,inst_105003,null));
var inst_105005 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,cljs.core.cst$kw$object_DASH_fn,inst_105001);
var inst_105006 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_105004,inst_105005);
var state_105050__$1 = state_105050;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_105050__$1,(51),inst_105006);
} else {
if((state_val_105051 === (21))){
var inst_104943 = (state_105050[(2)]);
var inst_104944 = fluree.db.util.async.throw_err(inst_104943);
var state_105050__$1 = state_105050;
var statearr_105076_105155 = state_105050__$1;
(statearr_105076_105155[(2)] = inst_104944);

(statearr_105076_105155[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105051 === (31))){
var inst_104972 = (state_105050[(2)]);
var state_105050__$1 = state_105050;
var statearr_105077_105156 = state_105050__$1;
(statearr_105077_105156[(2)] = inst_104972);

(statearr_105077_105156[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105051 === (32))){
var inst_104951 = (state_105050[(15)]);
var inst_104965 = cljs.core.fn_QMARK_(inst_104951);
var inst_104966 = (!(inst_104965));
var state_105050__$1 = state_105050;
var statearr_105078_105157 = state_105050__$1;
(statearr_105078_105157[(2)] = inst_104966);

(statearr_105078_105157[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105051 === (40))){
var inst_104912 = (state_105050[(9)]);
var state_105050__$1 = state_105050;
var statearr_105079_105158 = state_105050__$1;
(statearr_105079_105158[(2)] = inst_104912);

(statearr_105079_105158[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105051 === (56))){
var inst_104912 = (state_105050[(9)]);
var inst_104914 = (state_105050[(11)]);
var inst_104911 = (state_105050[(13)]);
var inst_104951 = (state_105050[(15)]);
var inst_105021 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_105022 = [inst_104951,inst_104912,inst_104911,inst_104914];
var inst_105023 = (new cljs.core.PersistentVector(null,4,(5),inst_105021,inst_105022,null));
var inst_105024 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$opst,cljs.core._EQ_,inst_105023,opts);
var state_105050__$1 = state_105050;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_105050__$1,(59),inst_105024);
} else {
if((state_val_105051 === (33))){
var inst_104915 = (state_105050[(10)]);
var state_105050__$1 = state_105050;
var statearr_105080_105159 = state_105050__$1;
(statearr_105080_105159[(2)] = inst_104915);

(statearr_105080_105159[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105051 === (13))){
var inst_104911 = (state_105050[(13)]);
var inst_104951 = (state_105050[(2)]);
var state_105050__$1 = (function (){var statearr_105081 = state_105050;
(statearr_105081[(15)] = inst_104951);

return statearr_105081;
})();
if(cljs.core.truth_(inst_104911)){
var statearr_105082_105160 = state_105050__$1;
(statearr_105082_105160[(1)] = (22));

} else {
var statearr_105083_105161 = state_105050__$1;
(statearr_105083_105161[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105051 === (22))){
var inst_104912 = (state_105050[(9)]);
var inst_104914 = (state_105050[(11)]);
var inst_104911 = (state_105050[(13)]);
var inst_104951 = (state_105050[(15)]);
var inst_104953 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_104954 = [inst_104911,inst_104912,inst_104951,inst_104914];
var inst_104955 = (new cljs.core.PersistentVector(null,4,(5),inst_104953,inst_104954,null));
var inst_104956 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_104955,opts);
var state_105050__$1 = state_105050;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_105050__$1,(25),inst_104956);
} else {
if((state_val_105051 === (36))){
var inst_104912 = (state_105050[(9)]);
var state_105050__$1 = state_105050;
if(cljs.core.truth_(inst_104912)){
var statearr_105084_105162 = state_105050__$1;
(statearr_105084_105162[(1)] = (39));

} else {
var statearr_105085_105163 = state_105050__$1;
(statearr_105085_105163[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105051 === (41))){
var inst_104993 = (state_105050[(2)]);
var state_105050__$1 = state_105050;
if(cljs.core.truth_(inst_104993)){
var statearr_105086_105164 = state_105050__$1;
(statearr_105086_105164[(1)] = (45));

} else {
var statearr_105087_105165 = state_105050__$1;
(statearr_105087_105165[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105051 === (43))){
var state_105050__$1 = state_105050;
var statearr_105088_105166 = state_105050__$1;
(statearr_105088_105166[(2)] = false);

(statearr_105088_105166[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105051 === (61))){
var inst_105038 = (state_105050[(8)]);
var state_105050__$1 = state_105050;
var statearr_105089_105167 = state_105050__$1;
(statearr_105089_105167[(2)] = inst_105038);

(statearr_105089_105167[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105051 === (29))){
var inst_104915 = (state_105050[(10)]);
var state_105050__$1 = state_105050;
if(cljs.core.truth_(inst_104915)){
var statearr_105090_105168 = state_105050__$1;
(statearr_105090_105168[(1)] = (32));

} else {
var statearr_105091_105169 = state_105050__$1;
(statearr_105091_105169[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105051 === (44))){
var inst_104990 = (state_105050[(2)]);
var state_105050__$1 = state_105050;
var statearr_105092_105170 = state_105050__$1;
(statearr_105092_105170[(2)] = inst_104990);

(statearr_105092_105170[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105051 === (6))){
var state_105050__$1 = state_105050;
var statearr_105093_105171 = state_105050__$1;
(statearr_105093_105171[(2)] = false);

(statearr_105093_105171[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105051 === (28))){
var inst_104975 = (state_105050[(2)]);
var state_105050__$1 = state_105050;
if(cljs.core.truth_(inst_104975)){
var statearr_105094_105172 = state_105050__$1;
(statearr_105094_105172[(1)] = (35));

} else {
var statearr_105095_105173 = state_105050__$1;
(statearr_105095_105173[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105051 === (51))){
var inst_105008 = (state_105050[(2)]);
var inst_105009 = fluree.db.util.async.throw_err(inst_105008);
var state_105050__$1 = state_105050;
var statearr_105096_105174 = state_105050__$1;
(statearr_105096_105174[(2)] = inst_105009);

(statearr_105096_105174[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105051 === (25))){
var inst_104958 = (state_105050[(2)]);
var inst_104959 = fluree.db.util.async.throw_err(inst_104958);
var state_105050__$1 = state_105050;
var statearr_105097_105175 = state_105050__$1;
(statearr_105097_105175[(2)] = inst_104959);

(statearr_105097_105175[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105051 === (34))){
var inst_104969 = (state_105050[(2)]);
var state_105050__$1 = state_105050;
var statearr_105098_105176 = state_105050__$1;
(statearr_105098_105176[(2)] = inst_104969);

(statearr_105098_105176[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105051 === (17))){
var inst_104934 = (state_105050[(2)]);
var inst_104935 = fluree.db.util.async.throw_err(inst_104934);
var state_105050__$1 = state_105050;
var statearr_105099_105177 = state_105050__$1;
(statearr_105099_105177[(2)] = inst_104935);

(statearr_105099_105177[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105051 === (3))){
var inst_104904 = (state_105050[(2)]);
var state_105050__$1 = state_105050;
var statearr_105100_105178 = state_105050__$1;
(statearr_105100_105178[(2)] = inst_104904);


cljs.core.async.impl.ioc_helpers.process_exception(state_105050__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_105051 === (12))){
var inst_104913 = (state_105050[(12)]);
var inst_104930 = fluree.db.query.range.tag_string_QMARK_(inst_104913);
var state_105050__$1 = state_105050;
if(cljs.core.truth_(inst_104930)){
var statearr_105101_105179 = state_105050__$1;
(statearr_105101_105179[(1)] = (14));

} else {
var statearr_105102_105180 = state_105050__$1;
(statearr_105102_105180[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105051 === (2))){
var inst_105048 = (state_105050[(2)]);
var state_105050__$1 = state_105050;
return cljs.core.async.impl.ioc_helpers.return_chan(state_105050__$1,inst_105048);
} else {
if((state_val_105051 === (23))){
var inst_104912 = (state_105050[(9)]);
var state_105050__$1 = state_105050;
if(cljs.core.truth_(inst_104912)){
var statearr_105103_105181 = state_105050__$1;
(statearr_105103_105181[(1)] = (26));

} else {
var statearr_105104_105182 = state_105050__$1;
(statearr_105104_105182[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105051 === (47))){
var inst_105034 = (state_105050[(2)]);
var state_105050__$1 = state_105050;
var statearr_105105_105183 = state_105050__$1;
(statearr_105105_105183[(2)] = inst_105034);

(statearr_105105_105183[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105051 === (35))){
var inst_104912 = (state_105050[(9)]);
var inst_104914 = (state_105050[(11)]);
var inst_104911 = (state_105050[(13)]);
var inst_104951 = (state_105050[(15)]);
var inst_104977 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_104978 = [inst_104912,inst_104951,inst_104911,inst_104914];
var inst_104979 = (new cljs.core.PersistentVector(null,4,(5),inst_104977,inst_104978,null));
var inst_104980 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$post,cljs.core._EQ_,inst_104979,opts);
var state_105050__$1 = state_105050;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_105050__$1,(38),inst_104980);
} else {
if((state_val_105051 === (19))){
var state_105050__$1 = state_105050;
var statearr_105106_105184 = state_105050__$1;
(statearr_105106_105184[(2)] = null);

(statearr_105106_105184[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105051 === (57))){
var state_105050__$1 = state_105050;
var statearr_105107_105185 = state_105050__$1;
(statearr_105107_105185[(2)] = null);

(statearr_105107_105185[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105051 === (11))){
var inst_104913 = (state_105050[(12)]);
var state_105050__$1 = state_105050;
var statearr_105108_105186 = state_105050__$1;
(statearr_105108_105186[(2)] = inst_104913);

(statearr_105108_105186[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105051 === (9))){
var inst_104921 = (state_105050[(7)]);
var state_105050__$1 = state_105050;
var statearr_105109_105187 = state_105050__$1;
(statearr_105109_105187[(2)] = inst_104921);

(statearr_105109_105187[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105051 === (5))){
var inst_104912 = (state_105050[(9)]);
var inst_104917 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$type,inst_104912);
var inst_104918 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$tag,inst_104917);
var state_105050__$1 = state_105050;
var statearr_105110_105188 = state_105050__$1;
(statearr_105110_105188[(2)] = inst_104918);

(statearr_105110_105188[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105051 === (14))){
var inst_104913 = (state_105050[(12)]);
var inst_104932 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_104913);
var state_105050__$1 = state_105050;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_105050__$1,(17),inst_104932);
} else {
if((state_val_105051 === (45))){
var inst_104995 = (state_105050[(14)]);
var inst_104995__$1 = cljs.core.cst$kw$object_DASH_fn.cljs$core$IFn$_invoke$arity$1(opts);
var state_105050__$1 = (function (){var statearr_105111 = state_105050;
(statearr_105111[(14)] = inst_104995__$1);

return statearr_105111;
})();
if(cljs.core.truth_(inst_104995__$1)){
var statearr_105112_105189 = state_105050__$1;
(statearr_105112_105189[(1)] = (48));

} else {
var statearr_105113_105190 = state_105050__$1;
(statearr_105113_105190[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105051 === (53))){
var inst_104951 = (state_105050[(15)]);
var state_105050__$1 = state_105050;
if(cljs.core.truth_(inst_104951)){
var statearr_105114_105191 = state_105050__$1;
(statearr_105114_105191[(1)] = (56));

} else {
var statearr_105115_105192 = state_105050__$1;
(statearr_105115_105192[(1)] = (57));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105051 === (26))){
var inst_104951 = (state_105050[(15)]);
var inst_104962 = fluree.db.query.range.non_nil_non_boolean_QMARK_(inst_104951);
var state_105050__$1 = state_105050;
if(inst_104962){
var statearr_105116_105193 = state_105050__$1;
(statearr_105116_105193[(1)] = (29));

} else {
var statearr_105117_105194 = state_105050__$1;
(statearr_105117_105194[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105051 === (16))){
var inst_104949 = (state_105050[(2)]);
var state_105050__$1 = state_105050;
var statearr_105118_105195 = state_105050__$1;
(statearr_105118_105195[(2)] = inst_104949);

(statearr_105118_105195[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105051 === (38))){
var inst_104982 = (state_105050[(2)]);
var inst_104983 = fluree.db.util.async.throw_err(inst_104982);
var state_105050__$1 = state_105050;
var statearr_105119_105196 = state_105050__$1;
(statearr_105119_105196[(2)] = inst_104983);

(statearr_105119_105196[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105051 === (30))){
var state_105050__$1 = state_105050;
var statearr_105120_105197 = state_105050__$1;
(statearr_105120_105197[(2)] = false);

(statearr_105120_105197[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105051 === (10))){
var inst_104926 = (state_105050[(16)]);
var inst_104926__$1 = (state_105050[(2)]);
var inst_104927 = cljs.core.not(inst_104926__$1);
var state_105050__$1 = (function (){var statearr_105121 = state_105050;
(statearr_105121[(16)] = inst_104926__$1);

return statearr_105121;
})();
if(inst_104927){
var statearr_105122_105198 = state_105050__$1;
(statearr_105122_105198[(1)] = (11));

} else {
var statearr_105123_105199 = state_105050__$1;
(statearr_105123_105199[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105051 === (18))){
var inst_104912 = (state_105050[(9)]);
var inst_104913 = (state_105050[(12)]);
var inst_104939 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,inst_104912);
var inst_104940 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_104939),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_104913)].join('');
var inst_104941 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_104940);
var state_105050__$1 = state_105050;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_105050__$1,(21),inst_104941);
} else {
if((state_val_105051 === (52))){
var inst_104912 = (state_105050[(9)]);
var inst_104914 = (state_105050[(11)]);
var inst_104911 = (state_105050[(13)]);
var inst_104951 = (state_105050[(15)]);
var inst_105012 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_105013 = [inst_104912,inst_104911,inst_104951,inst_104914];
var inst_105014 = (new cljs.core.PersistentVector(null,4,(5),inst_105012,inst_105013,null));
var inst_105015 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_105014,opts);
var state_105050__$1 = state_105050;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_105050__$1,(55),inst_105015);
} else {
if((state_val_105051 === (42))){
var inst_104951 = (state_105050[(15)]);
var state_105050__$1 = state_105050;
var statearr_105124_105200 = state_105050__$1;
(statearr_105124_105200[(2)] = inst_104951);

(statearr_105124_105200[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105051 === (37))){
var inst_105036 = (state_105050[(2)]);
var state_105050__$1 = state_105050;
var statearr_105125_105201 = state_105050__$1;
(statearr_105125_105201[(2)] = inst_105036);

(statearr_105125_105201[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105051 === (63))){
var inst_105042 = (state_105050[(2)]);
var inst_105043 = fluree.db.util.async.throw_err(inst_105042);
var state_105050__$1 = state_105050;
var statearr_105126_105202 = state_105050__$1;
(statearr_105126_105202[(2)] = inst_105043);

(statearr_105126_105202[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105051 === (8))){
var inst_104913 = (state_105050[(12)]);
var inst_104923 = typeof inst_104913 === 'string';
var state_105050__$1 = state_105050;
var statearr_105127_105203 = state_105050__$1;
(statearr_105127_105203[(2)] = inst_104923);

(statearr_105127_105203[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105051 === (49))){
var inst_104912 = (state_105050[(9)]);
var inst_104914 = (state_105050[(11)]);
var inst_104915 = (state_105050[(10)]);
var inst_104911 = (state_105050[(13)]);
var inst_104995 = (state_105050[(14)]);
var inst_104951 = (state_105050[(15)]);
var inst_104926 = (state_105050[(16)]);
var inst_104921 = (state_105050[(7)]);
var inst_104999 = (function (){var t = inst_104914;
var temp__5733__auto__ = inst_104995;
var p = inst_104912;
var idx_predicate_QMARK_ = inst_104915;
var o = inst_104951;
var tag_predicate_QMARK_ = inst_104921;
var s = inst_104911;
var o_coerce_QMARK_ = inst_104926;
var vec__104908 = fparts;
return (function (x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
});
})();
var state_105050__$1 = state_105050;
var statearr_105128_105204 = state_105050__$1;
(statearr_105128_105204[(2)] = inst_104999);

(statearr_105128_105204[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__100742__auto__ = null;
var fluree$db$query$range$state_machine__100742__auto____0 = (function (){
var statearr_105129 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_105129[(0)] = fluree$db$query$range$state_machine__100742__auto__);

(statearr_105129[(1)] = (1));

return statearr_105129;
});
var fluree$db$query$range$state_machine__100742__auto____1 = (function (state_105050){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_105050);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e105130){if((e105130 instanceof Object)){
var ex__100745__auto__ = e105130;
var statearr_105131_105205 = state_105050;
(statearr_105131_105205[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_105050);

return cljs.core.cst$kw$recur;
} else {
throw e105130;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__105206 = state_105050;
state_105050 = G__105206;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__100742__auto__ = function(state_105050){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__100742__auto____1.call(this,state_105050);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__100742__auto____0;
fluree$db$query$range$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__100742__auto____1;
return fluree$db$query$range$state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_105132 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_105132[(6)] = c__100848__auto__);

return statearr_105132;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
}));

(fluree.db.query.range.search.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range.collection = (function fluree$db$query$range$collection(var_args){
var G__105208 = arguments.length;
switch (G__105208) {
case 2:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2 = (function (db,name){
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,name,null);
}));

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3 = (function (db,name,opts){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_105240){
var state_val_105241 = (state_105240[(1)]);
if((state_val_105241 === (1))){
var state_105240__$1 = state_105240;
var statearr_105242_105255 = state_105240__$1;
(statearr_105242_105255[(2)] = null);

(statearr_105242_105255[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105241 === (2))){
var inst_105238 = (state_105240[(2)]);
var state_105240__$1 = state_105240;
return cljs.core.async.impl.ioc_helpers.return_chan(state_105240__$1,inst_105238);
} else {
if((state_val_105241 === (3))){
var inst_105209 = (state_105240[(2)]);
var state_105240__$1 = state_105240;
var statearr_105243_105256 = state_105240__$1;
(statearr_105243_105256[(2)] = inst_105209);


cljs.core.async.impl.ioc_helpers.process_exception(state_105240__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_105241 === (4))){
var inst_105213 = (state_105240[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_105240,(3),cljs.core.cst$kw$default,null,(2));
var inst_105213__$1 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$id,name);
var state_105240__$1 = (function (){var statearr_105244 = state_105240;
(statearr_105244[(7)] = inst_105213__$1);

return statearr_105244;
})();
if(cljs.core.truth_(inst_105213__$1)){
var statearr_105245_105257 = state_105240__$1;
(statearr_105245_105257[(1)] = (5));

} else {
var statearr_105246_105258 = state_105240__$1;
(statearr_105246_105258[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105241 === (5))){
var inst_105213 = (state_105240[(7)]);
var inst_105215 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_105216 = fluree.db.flake.max_subject_id(inst_105213);
var inst_105217 = [inst_105216];
var inst_105218 = (new cljs.core.PersistentVector(null,1,(5),inst_105215,inst_105217,null));
var inst_105219 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_105220 = fluree.db.flake.min_subject_id(inst_105213);
var inst_105221 = [inst_105220];
var inst_105222 = (new cljs.core.PersistentVector(null,1,(5),inst_105219,inst_105221,null));
var inst_105223 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,cljs.core.cst$kw$spot,cljs.core._GT__EQ_,inst_105218,cljs.core._LT__EQ_,inst_105222,opts);
var state_105240__$1 = state_105240;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_105240__$1,(8),inst_105223);
} else {
if((state_val_105241 === (6))){
var inst_105228 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([name], 0));
var inst_105229 = ["Invalid collection name: ",inst_105228].join('');
var inst_105230 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_105231 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_collection];
var inst_105232 = cljs.core.PersistentHashMap.fromArrays(inst_105230,inst_105231);
var inst_105233 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_105229,inst_105232);
var inst_105234 = (function(){throw inst_105233})();
var state_105240__$1 = state_105240;
var statearr_105247_105259 = state_105240__$1;
(statearr_105247_105259[(2)] = inst_105234);

(statearr_105247_105259[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105241 === (7))){
var inst_105236 = (state_105240[(2)]);
var state_105240__$1 = state_105240;
var statearr_105248_105260 = state_105240__$1;
(statearr_105248_105260[(2)] = inst_105236);


cljs.core.async.impl.ioc_helpers.process_exception(state_105240__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_105241 === (8))){
var inst_105225 = (state_105240[(2)]);
var inst_105226 = fluree.db.util.async.throw_err(inst_105225);
var state_105240__$1 = state_105240;
var statearr_105249_105261 = state_105240__$1;
(statearr_105249_105261[(2)] = inst_105226);

(statearr_105249_105261[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__100742__auto__ = null;
var fluree$db$query$range$state_machine__100742__auto____0 = (function (){
var statearr_105250 = [null,null,null,null,null,null,null,null];
(statearr_105250[(0)] = fluree$db$query$range$state_machine__100742__auto__);

(statearr_105250[(1)] = (1));

return statearr_105250;
});
var fluree$db$query$range$state_machine__100742__auto____1 = (function (state_105240){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_105240);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e105251){if((e105251 instanceof Object)){
var ex__100745__auto__ = e105251;
var statearr_105252_105262 = state_105240;
(statearr_105252_105262[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_105240);

return cljs.core.cst$kw$recur;
} else {
throw e105251;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__105263 = state_105240;
state_105240 = G__105263;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__100742__auto__ = function(state_105240){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__100742__auto____1.call(this,state_105240);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__100742__auto____0;
fluree$db$query$range$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__100742__auto____1;
return fluree$db$query$range$state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_105253 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_105253[(6)] = c__100848__auto__);

return statearr_105253;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
}));

(fluree.db.query.range.collection.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range._block_or_tx_collection = (function fluree$db$query$range$_block_or_tx_collection(db,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,cljs.core.cst$kw$spot,cljs.core._GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cljs.core._LT__EQ_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null),opts);
});
/**
 * Returns vector of transactions from a set of flakes.
 * Each transaction is a map with the following keys:
 * 1. db - the associated ledger
 * 2. tx - a map containing all transaction data in the original cmd
 * 3. nonce - the nonce
 * 4. auth - the authority that submitted the transaction
 * 5. expire - expiration
 */
fluree.db.query.range.txn_from_flakes = (function fluree$db$query$range$txn_from_flakes(flakes){
var G__105267 = flakes;
var vec__105268 = G__105267;
var seq__105269 = cljs.core.seq(vec__105268);
var first__105270 = cljs.core.first(seq__105269);
var seq__105269__$1 = cljs.core.next(seq__105269);
var flake_SINGLEQUOTE_ = first__105270;
var r = seq__105269__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__105267__$1 = G__105267;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__105277 = G__105267__$1;
var seq__105278 = cljs.core.seq(vec__105277);
var first__105279 = cljs.core.first(seq__105278);
var seq__105278__$1 = cljs.core.next(seq__105278);
var flake_SINGLEQUOTE___$1 = first__105279;
var r__$1 = seq__105278__$1;
var result_STAR___$2 = result_STAR___$1;
if((flake_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var obj = flake_SINGLEQUOTE___$1.o;
var cmd_map = (function (){try{return fluree.db.util.json.parse(obj);
}catch (e105281){var e = e105281;
return null;
}})();
var map__105280 = cmd_map;
var map__105280__$1 = (((((!((map__105280 == null))))?(((((map__105280.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__105280.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__105280):map__105280);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105280__$1,cljs.core.cst$kw$type);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105280__$1,cljs.core.cst$kw$db);
var tx = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105280__$1,cljs.core.cst$kw$tx);
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105280__$1,cljs.core.cst$kw$nonce);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105280__$1,cljs.core.cst$kw$auth);
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105280__$1,cljs.core.cst$kw$expire);
var G__105283 = r__$1;
var G__105284 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"tx"))?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$db,db,cljs.core.cst$kw$tx,tx,cljs.core.cst$kw$nonce,nonce,cljs.core.cst$kw$auth,auth,cljs.core.cst$kw$expire,expire], null)):result_STAR___$2);
G__105267__$1 = G__105283;
result_STAR___$1 = G__105284;
continue;
}
break;
}
});
/**
 * Returns block data as a map, with the following keys:
 *   1. block - block number
 *   2. t - fluree "time" since ledger creation
 *   3. sigs - List of transactor signatures that signed this block
 *   4. instant - instant this block was created, per the transactor.
 *   5. hash - hash of current block
 *   6. prev-hash - hash of previous block, if relevant
 *   7. flakes - list of flakes comprising block
 *   8. txn - list of transactions in block
 *   
 */
fluree.db.query.range.block_with_tx_data = (function fluree$db$query$range$block_with_tx_data(blocks){
var G__105293 = blocks;
var vec__105294 = G__105293;
var seq__105295 = cljs.core.seq(vec__105294);
var first__105296 = cljs.core.first(seq__105295);
var seq__105295__$1 = cljs.core.next(seq__105295);
var block_SINGLEQUOTE_ = first__105296;
var r = seq__105295__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__105293__$1 = G__105293;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__105302 = G__105293__$1;
var seq__105303 = cljs.core.seq(vec__105302);
var first__105304 = cljs.core.first(seq__105303);
var seq__105303__$1 = cljs.core.next(seq__105303);
var block_SINGLEQUOTE___$1 = first__105304;
var r__$1 = seq__105303__$1;
var result_STAR___$2 = result_STAR___$1;
if((block_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var map__105305 = block_SINGLEQUOTE___$1;
var map__105305__$1 = (((((!((map__105305 == null))))?(((((map__105305.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__105305.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__105305):map__105305);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105305__$1,cljs.core.cst$kw$block);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105305__$1,cljs.core.cst$kw$t);
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105305__$1,cljs.core.cst$kw$flakes);
var prev_hash = cljs.core.some(((function (G__105293__$1,result_STAR___$1,map__105305,map__105305__$1,block,t,flakes,vec__105302,seq__105303,first__105304,seq__105303__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__105293,vec__105294,seq__105295,first__105296,seq__105295__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__105285_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__105285_SHARP_.p,(2))){
return p1__105285_SHARP_.o;
} else {
return null;
}
});})(G__105293__$1,result_STAR___$1,map__105305,map__105305__$1,block,t,flakes,vec__105302,seq__105303,first__105304,seq__105303__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__105293,vec__105294,seq__105295,first__105296,seq__105295__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var hash = cljs.core.some(((function (G__105293__$1,result_STAR___$1,map__105305,map__105305__$1,block,t,flakes,prev_hash,vec__105302,seq__105303,first__105304,seq__105303__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__105293,vec__105294,seq__105295,first__105296,seq__105295__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__105286_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__105286_SHARP_.p,(1))){
return p1__105286_SHARP_.o;
} else {
return null;
}
});})(G__105293__$1,result_STAR___$1,map__105305,map__105305__$1,block,t,flakes,prev_hash,vec__105302,seq__105303,first__105304,seq__105303__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__105293,vec__105294,seq__105295,first__105296,seq__105295__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var instant = cljs.core.some(((function (G__105293__$1,result_STAR___$1,map__105305,map__105305__$1,block,t,flakes,prev_hash,hash,vec__105302,seq__105303,first__105304,seq__105303__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__105293,vec__105294,seq__105295,first__105296,seq__105295__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__105287_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__105287_SHARP_.p,(5))){
return p1__105287_SHARP_.o;
} else {
return null;
}
});})(G__105293__$1,result_STAR___$1,map__105305,map__105305__$1,block,t,flakes,prev_hash,hash,vec__105302,seq__105303,first__105304,seq__105303__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__105293,vec__105294,seq__105295,first__105296,seq__105295__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var sigs = cljs.core.some(((function (G__105293__$1,result_STAR___$1,map__105305,map__105305__$1,block,t,flakes,prev_hash,hash,instant,vec__105302,seq__105303,first__105304,seq__105303__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__105293,vec__105294,seq__105295,first__105296,seq__105295__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__105288_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__105288_SHARP_.p,(7))){
return p1__105288_SHARP_.o;
} else {
return null;
}
});})(G__105293__$1,result_STAR___$1,map__105305,map__105305__$1,block,t,flakes,prev_hash,hash,instant,vec__105302,seq__105303,first__105304,seq__105303__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__105293,vec__105294,seq__105295,first__105296,seq__105295__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (G__105293__$1,result_STAR___$1,map__105305,map__105305__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__105302,seq__105303,first__105304,seq__105303__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__105293,vec__105294,seq__105295,first__105296,seq__105295__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__105289_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__105289_SHARP_.p,(106));
});})(G__105293__$1,result_STAR___$1,map__105305,map__105305__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__105302,seq__105303,first__105304,seq__105303__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__105293,vec__105294,seq__105295,first__105296,seq__105295__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes_SINGLEQUOTE_ = fluree.db.query.range.txn_from_flakes(txn_flakes);
var G__105307 = r__$1;
var G__105308 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$block,block,cljs.core.cst$kw$t,t,cljs.core.cst$kw$hash,hash,cljs.core.cst$kw$prev_DASH_hash,prev_hash,cljs.core.cst$kw$instant,instant,cljs.core.cst$kw$sigs,sigs,cljs.core.cst$kw$flakes,flakes,cljs.core.cst$kw$txn,txn_flakes_SINGLEQUOTE_], null));
G__105293__$1 = G__105307;
result_STAR___$1 = G__105308;
continue;
}
break;
}
});
