// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');

/**
 * Can sit in a flake pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__111752 = null;
var G__111752__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__111752__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__111752__2 = (function (result,flake){
cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + (1)));

if(cljs.core.truth_((function (){var and__4115__auto__ = max_fuel;
if(cljs.core.truth_(and__4115__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4115__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
}

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flake) : xf.call(null,result,flake));
});
G__111752 = function(result,flake){
switch(arguments.length){
case 0:
return G__111752__0.call(this);
case 1:
return G__111752__1.call(this,result);
case 2:
return G__111752__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__111752.cljs$core$IFn$_invoke$arity$0 = G__111752__0;
G__111752.cljs$core$IFn$_invoke$arity$1 = G__111752__1;
G__111752.cljs$core$IFn$_invoke$arity$2 = G__111752__2;
return G__111752;
})()
});
});
/**
 * Can sit in a flake group pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Supply with a volatile!
 * 
 *   To get final count, just deref volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flakes_transducer = (function fluree$db$query$fql$fuel_flakes_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__111753 = null;
var G__111753__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__111753__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__111753__2 = (function (result,flakes){
cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + cljs.core.count(flakes)));

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flakes) : xf.call(null,result,flakes));
});
G__111753 = function(result,flakes){
switch(arguments.length){
case 0:
return G__111753__0.call(this);
case 1:
return G__111753__1.call(this,result);
case 2:
return G__111753__2.call(this,result,flakes);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__111753.cljs$core$IFn$_invoke$arity$0 = G__111753__0;
G__111753.cljs$core$IFn$_invoke$arity$1 = G__111753__1;
G__111753.cljs$core$IFn$_invoke$arity$2 = G__111753__2;
return G__111753;
})()
});
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql.add_fuel = (function fluree$db$query$fql$add_fuel(fuel,n,max_fuel){
cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + n));

if(cljs.core.truth_((function (){var and__4115__auto__ = max_fuel;
if(cljs.core.truth_(and__4115__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4115__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
return null;
}
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql.wildcard_pred_spec = (function fluree$db$query$fql$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__4126__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config(db,p,compact_QMARK_);
cljs.core._vreset_BANG_(cache,cljs.core.assoc_in(cljs.core._deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map));

return p_map;
}
});
fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare(clojure.string.upper_case(a),clojure.string.upper_case(b));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(res,(0))){
return ((-1) * cljs.core.compare(a,b));
} else {
return res;
}
} else {
return cljs.core.compare(a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql.sort_offset_and_limit_res = (function fluree$db$query$fql$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_(res)){
var G__111755 = res;
var G__111755__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((function (p1__111754_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__111754_SHARP_,sortPred);
}),fluree.db.query.fql.compare_fn,G__111755):G__111755);
var G__111755__$2 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortOrder))?cljs.core.reverse(G__111755__$1):G__111755__$1);
var G__111755__$3 = (cljs.core.truth_(offset)?cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,G__111755__$2):G__111755__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,G__111755__$3);
} else {
return G__111755__$3;
}
} else {
return res;
}
});
fluree.db.query.fql.add_pred = (function fluree$db$query$fql$add_pred(var_args){
var G__111757 = arguments.length;
switch (G__111757) {
case 9:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_){
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_,offset_map){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_112056){
var state_val_112057 = (state_112056[(1)]);
if((state_val_112057 === (65))){
var state_112056__$1 = state_112056;
if(cljs.core.truth_(componentFollow_QMARK_)){
var statearr_112058_112217 = state_112056__$1;
(statearr_112058_112217[(1)] = (71));

} else {
var statearr_112059_112218 = state_112056__$1;
(statearr_112059_112218[(1)] = (72));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (70))){
var inst_111785 = (state_112056[(7)]);
var inst_111923 = (state_112056[(2)]);
var inst_111924 = fluree.db.util.async.throw_err(inst_111923);
var inst_111925 = cljs.core._deref(cache);
var inst_111926 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_111927 = flake.o;
var inst_111928 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_111785);
var inst_111929 = [inst_111927,inst_111928];
var inst_111930 = (new cljs.core.PersistentVector(null,2,(5),inst_111926,inst_111929,null));
var inst_111931 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_111925,inst_111930,inst_111924);
var inst_111932 = cljs.core._vreset_BANG_(cache,inst_111931);
var state_112056__$1 = (function (){var statearr_112060 = state_112056;
(statearr_112060[(8)] = inst_111932);

return statearr_112060;
})();
var statearr_112061_112219 = state_112056__$1;
(statearr_112061_112219[(2)] = inst_111924);

(statearr_112061_112219[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (62))){
var inst_111894 = (state_112056[(9)]);
var state_112056__$1 = state_112056;
var statearr_112062_112220 = state_112056__$1;
(statearr_112062_112220[(2)] = inst_111894);

(statearr_112062_112220[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (74))){
var inst_111785 = (state_112056[(7)]);
var inst_111944 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_111945 = flake.o;
var inst_111946 = [inst_111945];
var inst_111947 = (new cljs.core.PersistentVector(null,1,(5),inst_111944,inst_111946,null));
var inst_111948 = [cljs.core.cst$kw$limit];
var inst_111949 = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(inst_111785);
var inst_111950 = [inst_111949];
var inst_111951 = cljs.core.PersistentHashMap.fromArrays(inst_111948,inst_111950);
var inst_111952 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_111947,inst_111951);
var state_112056__$1 = state_112056;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_112056__$1,(77),inst_111952);
} else {
if((state_val_112057 === (7))){
var inst_111772 = (state_112056[(2)]);
var state_112056__$1 = state_112056;
if(cljs.core.truth_(inst_111772)){
var statearr_112063_112221 = state_112056__$1;
(statearr_112063_112221[(1)] = (8));

} else {
var statearr_112064_112222 = state_112056__$1;
(statearr_112064_112222[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (59))){
var inst_111888 = (state_112056[(10)]);
var state_112056__$1 = state_112056;
var statearr_112065_112223 = state_112056__$1;
(statearr_112065_112223[(2)] = inst_111888);

(statearr_112065_112223[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (86))){
var inst_111973 = (state_112056[(11)]);
var state_112056__$1 = state_112056;
var statearr_112066_112224 = state_112056__$1;
(statearr_112066_112224[(2)] = inst_111973);

(statearr_112066_112224[(1)] = (87));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (20))){
var inst_111785 = (state_112056[(7)]);
var inst_111801 = inst_111785.cljs$lang$protocol_mask$partition0$;
var inst_111802 = (inst_111801 & (64));
var inst_111803 = inst_111785.cljs$core$ISeq$;
var inst_111804 = (cljs.core.PROTOCOL_SENTINEL === inst_111803);
var inst_111805 = ((inst_111802) || (inst_111804));
var state_112056__$1 = state_112056;
if(cljs.core.truth_(inst_111805)){
var statearr_112067_112225 = state_112056__$1;
(statearr_112067_112225[(1)] = (23));

} else {
var statearr_112068_112226 = state_112056__$1;
(statearr_112068_112226[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (72))){
var state_112056__$1 = state_112056;
var statearr_112069_112227 = state_112056__$1;
(statearr_112069_112227[(2)] = componentFollow_QMARK_);

(statearr_112069_112227[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (58))){
var inst_111888 = (state_112056[(10)]);
var inst_111890 = fluree.db.query.fql.fuel_flake_transducer(fuel,max_fuel);
var inst_111891 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_111890,inst_111888);
var state_112056__$1 = state_112056;
var statearr_112070_112228 = state_112056__$1;
(statearr_112070_112228[(2)] = inst_111891);

(statearr_112070_112228[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (60))){
var inst_111894 = (state_112056[(2)]);
var state_112056__$1 = (function (){var statearr_112071 = state_112056;
(statearr_112071[(9)] = inst_111894);

return statearr_112071;
})();
var statearr_112072_112229 = state_112056__$1;
(statearr_112072_112229[(1)] = (61));



return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (27))){
var inst_111785 = (state_112056[(7)]);
var state_112056__$1 = state_112056;
var statearr_112074_112230 = state_112056__$1;
(statearr_112074_112230[(2)] = inst_111785);

(statearr_112074_112230[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (1))){
var state_112056__$1 = state_112056;
var statearr_112075_112231 = state_112056__$1;
(statearr_112075_112231[(2)] = null);

(statearr_112075_112231[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (69))){
var inst_111909 = (state_112056[(12)]);
var inst_111934 = (state_112056[(2)]);
var inst_111935 = [inst_111934,offset_map];
var inst_111936 = (new cljs.core.PersistentVector(null,2,(5),inst_111909,inst_111935,null));
var state_112056__$1 = state_112056;
var statearr_112076_112232 = state_112056__$1;
(statearr_112076_112232[(2)] = inst_111936);

(statearr_112076_112232[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (101))){
var state_112056__$1 = state_112056;
var statearr_112077_112233 = state_112056__$1;
(statearr_112077_112233[(1)] = (103));



return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (24))){
var state_112056__$1 = state_112056;
var statearr_112079_112234 = state_112056__$1;
(statearr_112079_112234[(2)] = false);

(statearr_112079_112234[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (102))){
var inst_112050 = (state_112056[(2)]);
var state_112056__$1 = state_112056;
var statearr_112080_112235 = state_112056__$1;
(statearr_112080_112235[(2)] = inst_112050);

(statearr_112080_112235[(1)] = (99));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (55))){
var inst_112012 = (state_112056[(2)]);
var state_112056__$1 = state_112056;
var statearr_112081_112236 = state_112056__$1;
(statearr_112081_112236[(2)] = inst_112012);

(statearr_112081_112236[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (85))){
var inst_111818 = (state_112056[(13)]);
var inst_111955 = (state_112056[(14)]);
var inst_111785 = (state_112056[(7)]);
var inst_111817 = (state_112056[(15)]);
var inst_111973 = (state_112056[(11)]);
var inst_111819 = (state_112056[(16)]);
var inst_111823 = (state_112056[(17)]);
var inst_111779 = (state_112056[(18)]);
var inst_111796 = (state_112056[(19)]);
var inst_111822 = (state_112056[(20)]);
var inst_111820 = (state_112056[(21)]);
var inst_111821 = (state_112056[(22)]);
var inst_111975 = (function (){var G__111967 = inst_111973;
var p = inst_111823;
var pred_spec__$1 = inst_111779;
var orderBy = inst_111821;
var children = inst_111955;
var multi_QMARK_ = inst_111818;
var limit = inst_111820;
var offset = inst_111822;
var k = inst_111796;
var map__111762 = inst_111817;
var pred_spec_SINGLEQUOTE_ = inst_111785;
var ref_QMARK_ = inst_111819;
return (function (n){
var G__112082 = db;
var G__112083 = cache;
var G__112084 = fuel;
var G__112085 = max_fuel;
var G__112086 = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$wildcard_QMARK_,true], null);
var G__112087 = n;
return (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(G__112082,G__112083,G__112084,G__112085,G__112086,G__112087) : fluree.db.query.fql.flakes__GT_res.call(null,G__112082,G__112083,G__112084,G__112085,G__112086,G__112087));
});
})();
var inst_111976 = (inst_111975.cljs$core$IFn$_invoke$arity$1 ? inst_111975.cljs$core$IFn$_invoke$arity$1(inst_111973) : inst_111975.call(null,inst_111973));
var state_112056__$1 = state_112056;
var statearr_112088_112237 = state_112056__$1;
(statearr_112088_112237[(2)] = inst_111976);

(statearr_112088_112237[(1)] = (87));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (39))){
var inst_111823 = (state_112056[(17)]);
var inst_111822 = (state_112056[(20)]);
var inst_111842 = (inst_111822 - (1));
var inst_111843 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(offset_map,inst_111823,inst_111842);
var state_112056__$1 = state_112056;
var statearr_112089_112238 = state_112056__$1;
(statearr_112089_112238[(2)] = inst_111843);

(statearr_112089_112238[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (88))){
var inst_111989 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_111990 = ["_id"];
var inst_111991 = flake.o;
var inst_111992 = [inst_111991];
var inst_111993 = cljs.core.PersistentHashMap.fromArrays(inst_111990,inst_111992);
var inst_111994 = [inst_111993,offset_map];
var inst_111995 = (new cljs.core.PersistentVector(null,2,(5),inst_111989,inst_111994,null));
var state_112056__$1 = state_112056;
var statearr_112090_112239 = state_112056__$1;
(statearr_112090_112239[(2)] = inst_111995);

(statearr_112090_112239[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (46))){
var inst_112014 = (state_112056[(2)]);
var state_112056__$1 = state_112056;
var statearr_112091_112240 = state_112056__$1;
(statearr_112091_112240[(2)] = inst_112014);

(statearr_112091_112240[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (4))){
var inst_111766 = (state_112056[(23)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_112056,(3),Error,null,(2));
var inst_111766__$1 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_112056__$1 = (function (){var statearr_112092 = state_112056;
(statearr_112092[(23)] = inst_111766__$1);

return statearr_112092;
})();
if(cljs.core.truth_(inst_111766__$1)){
var statearr_112093_112241 = state_112056__$1;
(statearr_112093_112241[(1)] = (5));

} else {
var statearr_112094_112242 = state_112056__$1;
(statearr_112094_112242[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (77))){
var inst_111955 = (state_112056[(14)]);
var inst_111954 = (state_112056[(2)]);
var inst_111955__$1 = fluree.db.util.async.throw_err(inst_111954);
var inst_111956 = cljs.core.empty_QMARK_(inst_111955__$1);
var state_112056__$1 = (function (){var statearr_112095 = state_112056;
(statearr_112095[(14)] = inst_111955__$1);

return statearr_112095;
})();
if(inst_111956){
var statearr_112096_112243 = state_112056__$1;
(statearr_112096_112243[(1)] = (78));

} else {
var statearr_112097_112244 = state_112056__$1;
(statearr_112097_112244[(1)] = (79));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (95))){
var state_112056__$1 = state_112056;
var statearr_112098_112245 = state_112056__$1;
(statearr_112098_112245[(2)] = false);

(statearr_112098_112245[(1)] = (96));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (54))){
var inst_111785 = (state_112056[(7)]);
var inst_111907 = cljs.core.cst$kw$tag_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_111785);
var state_112056__$1 = state_112056;
if(cljs.core.truth_(inst_111907)){
var statearr_112099_112246 = state_112056__$1;
(statearr_112099_112246[(1)] = (64));

} else {
var statearr_112100_112247 = state_112056__$1;
(statearr_112100_112247[(1)] = (65));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (92))){
var state_112056__$1 = state_112056;
var statearr_112101_112248 = state_112056__$1;
(statearr_112101_112248[(2)] = null);

(statearr_112101_112248[(1)] = (93));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (104))){
var state_112056__$1 = state_112056;
var statearr_112102_112249 = state_112056__$1;
(statearr_112102_112249[(2)] = null);

(statearr_112102_112249[(1)] = (105));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (15))){
var inst_111785 = (state_112056[(7)]);
var inst_111789 = (state_112056[(24)]);
var inst_111789__$1 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_111785);
var state_112056__$1 = (function (){var statearr_112103 = state_112056;
(statearr_112103[(24)] = inst_111789__$1);

return statearr_112103;
})();
if(cljs.core.truth_(inst_111789__$1)){
var statearr_112104_112250 = state_112056__$1;
(statearr_112104_112250[(1)] = (17));

} else {
var statearr_112105_112251 = state_112056__$1;
(statearr_112105_112251[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (48))){
var state_112056__$1 = state_112056;
var statearr_112106_112252 = state_112056__$1;
(statearr_112106_112252[(2)] = false);

(statearr_112106_112252[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (50))){
var inst_111865 = (state_112056[(25)]);
var state_112056__$1 = state_112056;
var statearr_112107_112253 = state_112056__$1;
(statearr_112107_112253[(2)] = inst_111865);

(statearr_112107_112253[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (75))){
var inst_111819 = (state_112056[(16)]);
var state_112056__$1 = state_112056;
if(cljs.core.truth_(inst_111819)){
var statearr_112108_112254 = state_112056__$1;
(statearr_112108_112254[(1)] = (88));

} else {
var statearr_112109_112255 = state_112056__$1;
(statearr_112109_112255[(1)] = (89));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (99))){
var inst_112052 = (state_112056[(2)]);
var state_112056__$1 = state_112056;
var statearr_112110_112256 = state_112056__$1;
(statearr_112110_112256[(2)] = inst_112052);


cljs.core.async.impl.ioc_helpers.process_exception(state_112056__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (21))){
var state_112056__$1 = state_112056;
var statearr_112111_112257 = state_112056__$1;
(statearr_112111_112257[(2)] = false);

(statearr_112111_112257[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (31))){
var inst_111835 = (state_112056[(2)]);
var state_112056__$1 = state_112056;
if(cljs.core.truth_(inst_111835)){
var statearr_112112_112258 = state_112056__$1;
(statearr_112112_112258[(1)] = (35));

} else {
var statearr_112113_112259 = state_112056__$1;
(statearr_112113_112259[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (32))){
var inst_111823 = (state_112056[(17)]);
var inst_111822 = (state_112056[(20)]);
var inst_111826 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_111822);
var inst_111827 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_111823);
var inst_111828 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_111827);
var inst_111829 = ((inst_111826) && (inst_111828));
var state_112056__$1 = state_112056;
var statearr_112114_112260 = state_112056__$1;
(statearr_112114_112260[(2)] = inst_111829);

(statearr_112114_112260[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (40))){
var inst_111837 = (state_112056[(26)]);
var inst_111845 = (state_112056[(2)]);
var inst_111846 = [null,inst_111845];
var inst_111847 = (new cljs.core.PersistentVector(null,2,(5),inst_111837,inst_111846,null));
var state_112056__$1 = state_112056;
var statearr_112115_112261 = state_112056__$1;
(statearr_112115_112261[(2)] = inst_111847);

(statearr_112115_112261[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (91))){
var inst_111998 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_111999 = flake.o;
var inst_112000 = [inst_111999,offset_map];
var inst_112001 = (new cljs.core.PersistentVector(null,2,(5),inst_111998,inst_112000,null));
var state_112056__$1 = state_112056;
var statearr_112116_112262 = state_112056__$1;
(statearr_112116_112262[(2)] = inst_112001);

(statearr_112116_112262[(1)] = (93));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (56))){
var inst_111879 = (state_112056[(27)]);
var inst_111902 = (state_112056[(2)]);
var inst_111903 = fluree.db.util.async.throw_err(inst_111902);
var inst_111904 = [inst_111903,offset_map];
var inst_111905 = (new cljs.core.PersistentVector(null,2,(5),inst_111879,inst_111904,null));
var state_112056__$1 = state_112056;
var statearr_112117_112263 = state_112056__$1;
(statearr_112117_112263[(2)] = inst_111905);

(statearr_112117_112263[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (33))){
var inst_111822 = (state_112056[(20)]);
var state_112056__$1 = state_112056;
var statearr_112118_112264 = state_112056__$1;
(statearr_112118_112264[(2)] = inst_111822);

(statearr_112118_112264[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (13))){
var inst_111785 = (state_112056[(7)]);
var inst_111786 = (state_112056[(28)]);
var inst_111785__$1 = (state_112056[(2)]);
var inst_111786__$1 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(inst_111785__$1);
var state_112056__$1 = (function (){var statearr_112119 = state_112056;
(statearr_112119[(7)] = inst_111785__$1);

(statearr_112119[(28)] = inst_111786__$1);

return statearr_112119;
})();
if(cljs.core.truth_(inst_111786__$1)){
var statearr_112120_112265 = state_112056__$1;
(statearr_112120_112265[(1)] = (14));

} else {
var statearr_112121_112266 = state_112056__$1;
(statearr_112121_112266[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (22))){
var inst_111812 = (state_112056[(2)]);
var state_112056__$1 = state_112056;
if(cljs.core.truth_(inst_111812)){
var statearr_112122_112267 = state_112056__$1;
(statearr_112122_112267[(1)] = (26));

} else {
var statearr_112123_112268 = state_112056__$1;
(statearr_112123_112268[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (90))){
var inst_112006 = (state_112056[(2)]);
var state_112056__$1 = state_112056;
var statearr_112124_112269 = state_112056__$1;
(statearr_112124_112269[(2)] = inst_112006);

(statearr_112124_112269[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (36))){
var inst_111818 = (state_112056[(13)]);
var state_112056__$1 = state_112056;
if(cljs.core.truth_(inst_111818)){
var statearr_112125_112270 = state_112056__$1;
(statearr_112125_112270[(1)] = (41));

} else {
var statearr_112126_112271 = state_112056__$1;
(statearr_112126_112271[(1)] = (42));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (41))){
var inst_111796 = (state_112056[(19)]);
var inst_111820 = (state_112056[(21)]);
var inst_111821 = (state_112056[(22)]);
var inst_111850 = cljs.core.not(inst_111821);
var inst_111851 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,inst_111796);
var inst_111852 = cljs.core.count(inst_111851);
var inst_111853 = (inst_111852 >= inst_111820);
var inst_111854 = ((inst_111850) && (inst_111853));
var state_112056__$1 = state_112056;
var statearr_112127_112272 = state_112056__$1;
(statearr_112127_112272[(2)] = inst_111854);

(statearr_112127_112272[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (89))){
var state_112056__$1 = state_112056;
var statearr_112128_112273 = state_112056__$1;
(statearr_112128_112273[(1)] = (91));



return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (100))){
var inst_111796 = (state_112056[(19)]);
var inst_112017 = (state_112056[(29)]);
var inst_112018 = (state_112056[(30)]);
var inst_112037 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_112038 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_111796,inst_112017);
var inst_112039 = [inst_112038,inst_112018];
var inst_112040 = (new cljs.core.PersistentVector(null,2,(5),inst_112037,inst_112039,null));
var state_112056__$1 = state_112056;
var statearr_112130_112274 = state_112056__$1;
(statearr_112130_112274[(2)] = inst_112040);

(statearr_112130_112274[(1)] = (102));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (43))){
var inst_111857 = (state_112056[(2)]);
var state_112056__$1 = state_112056;
if(cljs.core.truth_(inst_111857)){
var statearr_112131_112275 = state_112056__$1;
(statearr_112131_112275[(1)] = (44));

} else {
var statearr_112132_112276 = state_112056__$1;
(statearr_112132_112276[(1)] = (45));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (61))){
var inst_111818 = (state_112056[(13)]);
var inst_111785 = (state_112056[(7)]);
var inst_111878 = (state_112056[(31)]);
var inst_111817 = (state_112056[(15)]);
var inst_111819 = (state_112056[(16)]);
var inst_111894 = (state_112056[(9)]);
var inst_111823 = (state_112056[(17)]);
var inst_111779 = (state_112056[(18)]);
var inst_111796 = (state_112056[(19)]);
var inst_111822 = (state_112056[(20)]);
var inst_111820 = (state_112056[(21)]);
var inst_111821 = (state_112056[(22)]);
var inst_111896 = (function (){var p = inst_111823;
var pred_spec__$1 = inst_111779;
var orderBy = inst_111821;
var nested_select_spec = inst_111878;
var multi_QMARK_ = inst_111818;
var limit = inst_111820;
var offset = inst_111822;
var k = inst_111796;
var map__111762 = inst_111817;
var G__111880 = inst_111894;
var pred_spec_SINGLEQUOTE_ = inst_111785;
var ref_QMARK_ = inst_111819;
return (function (n){
return (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,nested_select_spec,n) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,nested_select_spec,n));
});
})();
var inst_111897 = (inst_111896.cljs$core$IFn$_invoke$arity$1 ? inst_111896.cljs$core$IFn$_invoke$arity$1(inst_111894) : inst_111896.call(null,inst_111894));
var state_112056__$1 = state_112056;
var statearr_112133_112277 = state_112056__$1;
(statearr_112133_112277[(2)] = inst_111897);

(statearr_112133_112277[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (29))){
var inst_111822 = (state_112056[(20)]);
var state_112056__$1 = state_112056;
if(cljs.core.truth_(inst_111822)){
var statearr_112134_112278 = state_112056__$1;
(statearr_112134_112278[(1)] = (32));

} else {
var statearr_112135_112279 = state_112056__$1;
(statearr_112135_112279[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (44))){
var inst_111859 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_111860 = [null,offset_map];
var inst_111861 = (new cljs.core.PersistentVector(null,2,(5),inst_111859,inst_111860,null));
var state_112056__$1 = state_112056;
var statearr_112136_112280 = state_112056__$1;
(statearr_112136_112280[(2)] = inst_111861);

(statearr_112136_112280[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (93))){
var inst_112004 = (state_112056[(2)]);
var state_112056__$1 = state_112056;
var statearr_112137_112281 = state_112056__$1;
(statearr_112137_112281[(2)] = inst_112004);

(statearr_112137_112281[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (6))){
var inst_111766 = (state_112056[(23)]);
var state_112056__$1 = state_112056;
var statearr_112138_112282 = state_112056__$1;
(statearr_112138_112282[(2)] = inst_111766);

(statearr_112138_112282[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (28))){
var inst_111818 = (state_112056[(13)]);
var inst_111817 = (state_112056[(15)]);
var inst_111817__$1 = (state_112056[(2)]);
var inst_111818__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_111817__$1,cljs.core.cst$kw$multi_QMARK_);
var inst_111819 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_111817__$1,cljs.core.cst$kw$ref_QMARK_);
var inst_111820 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_111817__$1,cljs.core.cst$kw$limit);
var inst_111821 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_111817__$1,cljs.core.cst$kw$orderBy);
var inst_111822 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_111817__$1,cljs.core.cst$kw$offset);
var inst_111823 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_111817__$1,cljs.core.cst$kw$p);
var state_112056__$1 = (function (){var statearr_112139 = state_112056;
(statearr_112139[(13)] = inst_111818__$1);

(statearr_112139[(15)] = inst_111817__$1);

(statearr_112139[(16)] = inst_111819);

(statearr_112139[(17)] = inst_111823);

(statearr_112139[(20)] = inst_111822);

(statearr_112139[(21)] = inst_111820);

(statearr_112139[(22)] = inst_111821);

return statearr_112139;
})();
if(cljs.core.truth_(inst_111818__$1)){
var statearr_112140_112283 = state_112056__$1;
(statearr_112140_112283[(1)] = (29));

} else {
var statearr_112141_112284 = state_112056__$1;
(statearr_112141_112284[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (64))){
var inst_111785 = (state_112056[(7)]);
var inst_111916 = (state_112056[(32)]);
var inst_111909 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_111910 = cljs.core.deref(cache);
var inst_111911 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_111912 = flake.o;
var inst_111913 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_111785);
var inst_111914 = [inst_111912,inst_111913];
var inst_111915 = (new cljs.core.PersistentVector(null,2,(5),inst_111911,inst_111914,null));
var inst_111916__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_111910,inst_111915);
var state_112056__$1 = (function (){var statearr_112142 = state_112056;
(statearr_112142[(12)] = inst_111909);

(statearr_112142[(32)] = inst_111916__$1);

return statearr_112142;
})();
if(cljs.core.truth_(inst_111916__$1)){
var statearr_112143_112285 = state_112056__$1;
(statearr_112143_112285[(1)] = (67));

} else {
var statearr_112144_112286 = state_112056__$1;
(statearr_112144_112286[(1)] = (68));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (103))){
var inst_112018 = (state_112056[(30)]);
var inst_112043 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_112044 = [acc,inst_112018];
var inst_112045 = (new cljs.core.PersistentVector(null,2,(5),inst_112043,inst_112044,null));
var state_112056__$1 = state_112056;
var statearr_112145_112287 = state_112056__$1;
(statearr_112145_112287[(2)] = inst_112045);

(statearr_112145_112287[(1)] = (105));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (51))){
var inst_111785 = (state_112056[(7)]);
var inst_111868 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_111785);
var state_112056__$1 = state_112056;
var statearr_112146_112288 = state_112056__$1;
(statearr_112146_112288[(2)] = inst_111868);

(statearr_112146_112288[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (25))){
var inst_111809 = (state_112056[(2)]);
var state_112056__$1 = state_112056;
var statearr_112147_112289 = state_112056__$1;
(statearr_112147_112289[(2)] = inst_111809);

(statearr_112147_112289[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (34))){
var inst_111832 = (state_112056[(2)]);
var state_112056__$1 = state_112056;
var statearr_112148_112290 = state_112056__$1;
(statearr_112148_112290[(2)] = inst_111832);

(statearr_112148_112290[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (17))){
var inst_111789 = (state_112056[(24)]);
var state_112056__$1 = state_112056;
var statearr_112149_112291 = state_112056__$1;
(statearr_112149_112291[(2)] = inst_111789);

(statearr_112149_112291[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (3))){
var inst_111758 = (state_112056[(2)]);
var state_112056__$1 = state_112056;
var statearr_112150_112292 = state_112056__$1;
(statearr_112150_112292[(2)] = inst_111758);


cljs.core.async.impl.ioc_helpers.process_exception(state_112056__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (12))){
var inst_111779 = (state_112056[(18)]);
var inst_111783 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_111779,cljs.core.cst$kw$componentFollow_QMARK_,componentFollow_QMARK_);
var state_112056__$1 = state_112056;
var statearr_112151_112293 = state_112056__$1;
(statearr_112151_112293[(2)] = inst_111783);

(statearr_112151_112293[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (2))){
var inst_112054 = (state_112056[(2)]);
var state_112056__$1 = state_112056;
return cljs.core.async.impl.ioc_helpers.return_chan(state_112056__$1,inst_112054);
} else {
if((state_val_112057 === (66))){
var inst_112010 = (state_112056[(2)]);
var state_112056__$1 = state_112056;
var statearr_112152_112294 = state_112056__$1;
(statearr_112152_112294[(2)] = inst_112010);

(statearr_112152_112294[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (23))){
var state_112056__$1 = state_112056;
var statearr_112153_112295 = state_112056__$1;
(statearr_112153_112295[(2)] = true);

(statearr_112153_112295[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (47))){
var inst_111785 = (state_112056[(7)]);
var inst_111865 = (state_112056[(25)]);
var inst_111865__$1 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_111785);
var state_112056__$1 = (function (){var statearr_112154 = state_112056;
(statearr_112154[(25)] = inst_111865__$1);

return statearr_112154;
})();
if(cljs.core.truth_(inst_111865__$1)){
var statearr_112155_112296 = state_112056__$1;
(statearr_112155_112296[(1)] = (50));

} else {
var statearr_112156_112297 = state_112056__$1;
(statearr_112156_112297[(1)] = (51));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (35))){
var inst_111823 = (state_112056[(17)]);
var inst_111837 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_111838 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_111823);
var state_112056__$1 = (function (){var statearr_112157 = state_112056;
(statearr_112157[(26)] = inst_111837);

return statearr_112157;
})();
if(cljs.core.truth_(inst_111838)){
var statearr_112158_112298 = state_112056__$1;
(statearr_112158_112298[(1)] = (38));

} else {
var statearr_112159_112299 = state_112056__$1;
(statearr_112159_112299[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (82))){
var inst_111955 = (state_112056[(14)]);
var inst_111969 = fluree.db.query.fql.fuel_flake_transducer(fuel,max_fuel);
var inst_111970 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_111969,inst_111955);
var state_112056__$1 = state_112056;
var statearr_112160_112300 = state_112056__$1;
(statearr_112160_112300[(2)] = inst_111970);

(statearr_112160_112300[(1)] = (84));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (76))){
var inst_112008 = (state_112056[(2)]);
var state_112056__$1 = state_112056;
var statearr_112161_112301 = state_112056__$1;
(statearr_112161_112301[(2)] = inst_112008);

(statearr_112161_112301[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (97))){
var inst_111796 = (state_112056[(19)]);
var inst_112017 = (state_112056[(29)]);
var inst_112018 = (state_112056[(30)]);
var inst_112026 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_112027 = cljs.core.PersistentVector.EMPTY;
var inst_112028 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(acc,inst_111796,inst_112027);
var inst_112029 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_112028,inst_112017);
var inst_112030 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_111796,inst_112029);
var inst_112031 = [inst_112030,inst_112018];
var inst_112032 = (new cljs.core.PersistentVector(null,2,(5),inst_112026,inst_112031,null));
var state_112056__$1 = state_112056;
var statearr_112162_112302 = state_112056__$1;
(statearr_112162_112302[(2)] = inst_112032);

(statearr_112162_112302[(1)] = (99));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (19))){
var inst_111794 = (state_112056[(2)]);
var state_112056__$1 = state_112056;
var statearr_112163_112303 = state_112056__$1;
(statearr_112163_112303[(2)] = inst_111794);

(statearr_112163_112303[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (57))){
var inst_111887 = (state_112056[(2)]);
var inst_111888 = fluree.db.util.async.throw_err(inst_111887);
var state_112056__$1 = (function (){var statearr_112164 = state_112056;
(statearr_112164[(10)] = inst_111888);

return statearr_112164;
})();
if(cljs.core.truth_(fuel)){
var statearr_112165_112304 = state_112056__$1;
(statearr_112165_112304[(1)] = (58));

} else {
var statearr_112166_112305 = state_112056__$1;
(statearr_112166_112305[(1)] = (59));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (68))){
var inst_111785 = (state_112056[(7)]);
var inst_111919 = flake.o;
var inst_111920 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_111785);
var inst_111921 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_111919,inst_111920);
var state_112056__$1 = state_112056;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_112056__$1,(70),inst_111921);
} else {
if((state_val_112057 === (11))){
var inst_111779 = (state_112056[(18)]);
var state_112056__$1 = state_112056;
var statearr_112167_112306 = state_112056__$1;
(statearr_112167_112306[(2)] = inst_111779);

(statearr_112167_112306[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (9))){
var state_112056__$1 = state_112056;
var statearr_112168_112307 = state_112056__$1;
(statearr_112168_112307[(2)] = pred_spec);

(statearr_112168_112307[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (5))){
var inst_111768 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_111769 = (inst_111768 == null);
var state_112056__$1 = state_112056;
var statearr_112169_112308 = state_112056__$1;
(statearr_112169_112308[(2)] = inst_111769);

(statearr_112169_112308[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (83))){
var inst_111955 = (state_112056[(14)]);
var state_112056__$1 = state_112056;
var statearr_112170_112309 = state_112056__$1;
(statearr_112170_112309[(2)] = inst_111955);

(statearr_112170_112309[(1)] = (84));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (14))){
var inst_111786 = (state_112056[(28)]);
var state_112056__$1 = state_112056;
var statearr_112171_112310 = state_112056__$1;
(statearr_112171_112310[(2)] = inst_111786);

(statearr_112171_112310[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (45))){
var inst_111863 = cljs.core.not(recur_QMARK_);
var state_112056__$1 = state_112056;
if(inst_111863){
var statearr_112172_112311 = state_112056__$1;
(statearr_112172_112311[(1)] = (47));

} else {
var statearr_112173_112312 = state_112056__$1;
(statearr_112173_112312[(1)] = (48));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (53))){
var inst_111785 = (state_112056[(7)]);
var inst_111875 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_111876 = [cljs.core.cst$kw$wildcard_QMARK_,cljs.core.cst$kw$compact_QMARK_,cljs.core.cst$kw$select];
var inst_111877 = (new cljs.core.PersistentVector(null,3,(5),inst_111875,inst_111876,null));
var inst_111878 = cljs.core.select_keys(inst_111785,inst_111877);
var inst_111879 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_111881 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_111882 = flake.o;
var inst_111883 = [inst_111882];
var inst_111884 = (new cljs.core.PersistentVector(null,1,(5),inst_111881,inst_111883,null));
var inst_111885 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_111884);
var state_112056__$1 = (function (){var statearr_112174 = state_112056;
(statearr_112174[(31)] = inst_111878);

(statearr_112174[(27)] = inst_111879);

return statearr_112174;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_112056__$1,(57),inst_111885);
} else {
if((state_val_112057 === (78))){
var inst_111958 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_111959 = ["_id"];
var inst_111960 = flake.o;
var inst_111961 = [inst_111960];
var inst_111962 = cljs.core.PersistentHashMap.fromArrays(inst_111959,inst_111961);
var inst_111963 = [inst_111962,offset_map];
var inst_111964 = (new cljs.core.PersistentVector(null,2,(5),inst_111958,inst_111963,null));
var state_112056__$1 = state_112056;
var statearr_112175_112313 = state_112056__$1;
(statearr_112175_112313[(2)] = inst_111964);

(statearr_112175_112313[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (26))){
var inst_111785 = (state_112056[(7)]);
var inst_111814 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_111785);
var state_112056__$1 = state_112056;
var statearr_112176_112314 = state_112056__$1;
(statearr_112176_112314[(2)] = inst_111814);

(statearr_112176_112314[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (16))){
var inst_111785 = (state_112056[(7)]);
var inst_111796 = (state_112056[(2)]);
var inst_111798 = (inst_111785 == null);
var inst_111799 = cljs.core.not(inst_111798);
var state_112056__$1 = (function (){var statearr_112177 = state_112056;
(statearr_112177[(19)] = inst_111796);

return statearr_112177;
})();
if(inst_111799){
var statearr_112178_112315 = state_112056__$1;
(statearr_112178_112315[(1)] = (20));

} else {
var statearr_112179_112316 = state_112056__$1;
(statearr_112179_112316[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (81))){
var inst_111966 = (state_112056[(33)]);
var inst_111981 = (state_112056[(2)]);
var inst_111982 = fluree.db.util.async.throw_err(inst_111981);
var inst_111983 = [inst_111982,offset_map];
var inst_111984 = (new cljs.core.PersistentVector(null,2,(5),inst_111966,inst_111983,null));
var state_112056__$1 = state_112056;
var statearr_112180_112317 = state_112056__$1;
(statearr_112180_112317[(2)] = inst_111984);

(statearr_112180_112317[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (79))){
var inst_111966 = cljs.core.PersistentVector.EMPTY_NODE;
var state_112056__$1 = (function (){var statearr_112181 = state_112056;
(statearr_112181[(33)] = inst_111966);

return statearr_112181;
})();
if(cljs.core.truth_(fuel)){
var statearr_112182_112318 = state_112056__$1;
(statearr_112182_112318[(1)] = (82));

} else {
var statearr_112183_112319 = state_112056__$1;
(statearr_112183_112319[(1)] = (83));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (38))){
var inst_111823 = (state_112056[(17)]);
var inst_111840 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(offset_map,inst_111823,cljs.core.dec);
var state_112056__$1 = state_112056;
var statearr_112184_112320 = state_112056__$1;
(statearr_112184_112320[(2)] = inst_111840);

(statearr_112184_112320[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (98))){
var inst_112017 = (state_112056[(29)]);
var inst_112034 = (inst_112017 == null);
var inst_112035 = cljs.core.not(inst_112034);
var state_112056__$1 = state_112056;
if(inst_112035){
var statearr_112185_112321 = state_112056__$1;
(statearr_112185_112321[(1)] = (100));

} else {
var statearr_112186_112322 = state_112056__$1;
(statearr_112186_112322[(1)] = (101));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (87))){
var inst_111979 = (state_112056[(2)]);
var state_112056__$1 = state_112056;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_112056__$1,(81),inst_111979);
} else {
if((state_val_112057 === (30))){
var inst_111818 = (state_112056[(13)]);
var state_112056__$1 = state_112056;
var statearr_112187_112323 = state_112056__$1;
(statearr_112187_112323[(2)] = inst_111818);

(statearr_112187_112323[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (73))){
var inst_111942 = (state_112056[(2)]);
var state_112056__$1 = state_112056;
if(cljs.core.truth_(inst_111942)){
var statearr_112188_112324 = state_112056__$1;
(statearr_112188_112324[(1)] = (74));

} else {
var statearr_112189_112325 = state_112056__$1;
(statearr_112189_112325[(1)] = (75));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (96))){
var inst_112024 = (state_112056[(2)]);
var state_112056__$1 = state_112056;
if(cljs.core.truth_(inst_112024)){
var statearr_112190_112326 = state_112056__$1;
(statearr_112190_112326[(1)] = (97));

} else {
var statearr_112191_112327 = state_112056__$1;
(statearr_112191_112327[(1)] = (98));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (10))){
var inst_111779 = (state_112056[(18)]);
var inst_111779__$1 = (state_112056[(2)]);
var inst_111780 = cljs.core.contains_QMARK_(inst_111779__$1,cljs.core.cst$kw$componentFollow_QMARK_);
var state_112056__$1 = (function (){var statearr_112192 = state_112056;
(statearr_112192[(18)] = inst_111779__$1);

return statearr_112192;
})();
if(inst_111780){
var statearr_112193_112328 = state_112056__$1;
(statearr_112193_112328[(1)] = (11));

} else {
var statearr_112194_112329 = state_112056__$1;
(statearr_112194_112329[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (18))){
var inst_111785 = (state_112056[(7)]);
var inst_111792 = cljs.core.cst$kw$p.cljs$core$IFn$_invoke$arity$1(inst_111785);
var state_112056__$1 = state_112056;
var statearr_112195_112330 = state_112056__$1;
(statearr_112195_112330[(2)] = inst_111792);

(statearr_112195_112330[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (105))){
var inst_112048 = (state_112056[(2)]);
var state_112056__$1 = state_112056;
var statearr_112196_112331 = state_112056__$1;
(statearr_112196_112331[(2)] = inst_112048);

(statearr_112196_112331[(1)] = (102));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (52))){
var inst_111870 = (state_112056[(2)]);
var state_112056__$1 = state_112056;
var statearr_112197_112332 = state_112056__$1;
(statearr_112197_112332[(2)] = inst_111870);

(statearr_112197_112332[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (67))){
var inst_111916 = (state_112056[(32)]);
var state_112056__$1 = state_112056;
var statearr_112198_112333 = state_112056__$1;
(statearr_112198_112333[(2)] = inst_111916);

(statearr_112198_112333[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (71))){
var inst_111785 = (state_112056[(7)]);
var inst_111939 = cljs.core.cst$kw$component_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_111785);
var state_112056__$1 = state_112056;
var statearr_112199_112334 = state_112056__$1;
(statearr_112199_112334[(2)] = inst_111939);

(statearr_112199_112334[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (42))){
var inst_111818 = (state_112056[(13)]);
var state_112056__$1 = state_112056;
var statearr_112200_112335 = state_112056__$1;
(statearr_112200_112335[(2)] = inst_111818);

(statearr_112200_112335[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (80))){
var inst_111986 = (state_112056[(2)]);
var state_112056__$1 = state_112056;
var statearr_112201_112336 = state_112056__$1;
(statearr_112201_112336[(2)] = inst_111986);

(statearr_112201_112336[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (37))){
var inst_112017 = (state_112056[(29)]);
var inst_112016 = (state_112056[(2)]);
var inst_112017__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_112016,(0),null);
var inst_112018 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_112016,(1),null);
var inst_112019 = (inst_112017__$1 == null);
var inst_112020 = cljs.core.not(inst_112019);
var state_112056__$1 = (function (){var statearr_112202 = state_112056;
(statearr_112202[(29)] = inst_112017__$1);

(statearr_112202[(30)] = inst_112018);

return statearr_112202;
})();
if(inst_112020){
var statearr_112203_112337 = state_112056__$1;
(statearr_112203_112337[(1)] = (94));

} else {
var statearr_112204_112338 = state_112056__$1;
(statearr_112204_112338[(1)] = (95));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (63))){
var inst_111900 = (state_112056[(2)]);
var state_112056__$1 = state_112056;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_112056__$1,(56),inst_111900);
} else {
if((state_val_112057 === (94))){
var inst_111818 = (state_112056[(13)]);
var state_112056__$1 = state_112056;
var statearr_112205_112339 = state_112056__$1;
(statearr_112205_112339[(2)] = inst_111818);

(statearr_112205_112339[(1)] = (96));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (8))){
var inst_111774 = flake.p;
var inst_111775 = cljs.core.cst$kw$compact_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_111776 = fluree.db.query.fql.wildcard_pred_spec(db,cache,inst_111774,inst_111775);
var state_112056__$1 = state_112056;
var statearr_112206_112340 = state_112056__$1;
(statearr_112206_112340[(2)] = inst_111776);

(statearr_112206_112340[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (49))){
var inst_111873 = (state_112056[(2)]);
var state_112056__$1 = state_112056;
if(cljs.core.truth_(inst_111873)){
var statearr_112207_112341 = state_112056__$1;
(statearr_112207_112341[(1)] = (53));

} else {
var statearr_112208_112342 = state_112056__$1;
(statearr_112208_112342[(1)] = (54));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112057 === (84))){
var inst_111973 = (state_112056[(2)]);
var state_112056__$1 = (function (){var statearr_112209 = state_112056;
(statearr_112209[(11)] = inst_111973);

return statearr_112209;
})();
var statearr_112210_112343 = state_112056__$1;
(statearr_112210_112343[(1)] = (85));



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__100742__auto__ = null;
var fluree$db$query$fql$state_machine__100742__auto____0 = (function (){
var statearr_112212 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_112212[(0)] = fluree$db$query$fql$state_machine__100742__auto__);

(statearr_112212[(1)] = (1));

return statearr_112212;
});
var fluree$db$query$fql$state_machine__100742__auto____1 = (function (state_112056){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_112056);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e112213){if((e112213 instanceof Object)){
var ex__100745__auto__ = e112213;
var statearr_112214_112344 = state_112056;
(statearr_112214_112344[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_112056);

return cljs.core.cst$kw$recur;
} else {
throw e112213;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__112345 = state_112056;
state_112056 = G__112345;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__100742__auto__ = function(state_112056){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__100742__auto____1.call(this,state_112056);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__100742__auto____0;
fluree$db$query$fql$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__100742__auto____1;
return fluree$db$query$fql$state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_112215 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_112215[(6)] = c__100848__auto__);

return statearr_112215;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
}));

(fluree.db.query.fql.add_pred.cljs$lang$maxFixedArity = 10);

/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql.full_select_spec = (function fluree$db$query$fql$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid(subject_id);
var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec(db,coll_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$ns_DASH_lookup], null)));
var updated_spec = cljs.core.update.cljs$core$IFn$_invoke$arity$3(base_pred_spec,cljs.core.cst$kw$select,(function (sel){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(sel,cljs.core.cst$kw$pred_DASH_id,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([lookup_specs,cljs.core.cst$kw$pred_DASH_id.cljs$core$IFn$_invoke$arity$1(sel)], 0))),cljs.core.cst$kw$ns_DASH_lookup);
}));
cljs.core._vreset_BANG_(cache,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core._deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec));

return updated_spec;
}
});
/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql.has_ns_lookups_QMARK_ = (function fluree$db$query$fql$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$ns_DASH_lookup], null));
});
fluree.db.query.fql.s = (function fluree$db$query$fql$s(f){
return f.s;
});
fluree.db.query.fql.o = (function fluree$db$query$fql$o(f){
return f.o;
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql.resolve_reverse_refs = (function fluree$db$query$fql$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,reverse_refs_specs){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_112521){
var state_val_112522 = (state_112521[(1)]);
if((state_val_112522 === (7))){
var inst_112361 = (state_112521[(7)]);
var state_112521__$1 = state_112521;
var statearr_112523_112612 = state_112521__$1;
(statearr_112523_112612[(2)] = inst_112361);

(statearr_112523_112612[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112522 === (59))){
var inst_112509 = (state_112521[(2)]);
var state_112521__$1 = state_112521;
var statearr_112524_112613 = state_112521__$1;
(statearr_112524_112613[(2)] = inst_112509);

(statearr_112524_112613[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112522 === (20))){
var state_112521__$1 = state_112521;
var statearr_112525_112614 = state_112521__$1;
(statearr_112525_112614[(2)] = fuel);

(statearr_112525_112614[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112522 === (58))){
var inst_112403 = (state_112521[(8)]);
var state_112521__$1 = state_112521;
var statearr_112526_112615 = state_112521__$1;
(statearr_112526_112615[(2)] = inst_112403);

(statearr_112526_112615[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112522 === (27))){
var inst_112401 = (state_112521[(9)]);
var inst_112503 = (state_112521[(2)]);
var state_112521__$1 = (function (){var statearr_112527 = state_112521;
(statearr_112527[(10)] = inst_112503);

return statearr_112527;
})();
if(cljs.core.truth_(inst_112401)){
var statearr_112528_112616 = state_112521__$1;
(statearr_112528_112616[(1)] = (54));

} else {
var statearr_112529_112617 = state_112521__$1;
(statearr_112529_112617[(1)] = (55));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112522 === (1))){
var state_112521__$1 = state_112521;
var statearr_112530_112618 = state_112521__$1;
(statearr_112530_112618[(2)] = null);

(statearr_112530_112618[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112522 === (24))){
var state_112521__$1 = state_112521;
var statearr_112531_112619 = state_112521__$1;
(statearr_112531_112619[(2)] = null);

(statearr_112531_112619[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112522 === (55))){
var inst_112402 = (state_112521[(11)]);
var state_112521__$1 = state_112521;
if(cljs.core.truth_(inst_112402)){
var statearr_112532_112620 = state_112521__$1;
(statearr_112532_112620[(1)] = (57));

} else {
var statearr_112533_112621 = state_112521__$1;
(statearr_112533_112621[(1)] = (58));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112522 === (39))){
var inst_112460 = (state_112521[(2)]);
var state_112521__$1 = state_112521;
if(cljs.core.truth_(inst_112460)){
var statearr_112534_112622 = state_112521__$1;
(statearr_112534_112622[(1)] = (40));

} else {
var statearr_112535_112623 = state_112521__$1;
(statearr_112535_112623[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112522 === (46))){
var inst_112472 = (state_112521[(12)]);
var inst_112377 = (state_112521[(13)]);
var inst_112471 = (state_112521[(2)]);
var inst_112472__$1 = fluree.db.util.async.throw_err(inst_112471);
var inst_112473 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_112474 = [cljs.core.cst$kw$wildcard_QMARK_,cljs.core.cst$kw$compact_QMARK_,cljs.core.cst$kw$select,cljs.core.cst$kw$limit];
var inst_112475 = (new cljs.core.PersistentVector(null,4,(5),inst_112473,inst_112474,null));
var inst_112476 = cljs.core.select_keys(inst_112377,inst_112475);
var inst_112477 = cljs.core.empty_QMARK_(inst_112472__$1);
var state_112521__$1 = (function (){var statearr_112536 = state_112521;
(statearr_112536[(12)] = inst_112472__$1);

(statearr_112536[(14)] = inst_112476);

return statearr_112536;
})();
if(inst_112477){
var statearr_112537_112624 = state_112521__$1;
(statearr_112537_112624[(1)] = (47));

} else {
var statearr_112538_112625 = state_112521__$1;
(statearr_112538_112625[(1)] = (48));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112522 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_112521,(3),Error,null,(2));
var inst_112357 = cljs.core.seq(reverse_refs_specs);
var inst_112358 = cljs.core.first(inst_112357);
var inst_112359 = cljs.core.next(inst_112357);
var inst_112360 = reverse_refs_specs;
var inst_112361 = null;
var state_112521__$1 = (function (){var statearr_112539 = state_112521;
(statearr_112539[(15)] = inst_112360);

(statearr_112539[(7)] = inst_112361);

(statearr_112539[(16)] = inst_112359);

(statearr_112539[(17)] = inst_112358);

return statearr_112539;
})();
var statearr_112540_112626 = state_112521__$1;
(statearr_112540_112626[(2)] = null);

(statearr_112540_112626[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112522 === (54))){
var inst_112401 = (state_112521[(9)]);
var state_112521__$1 = state_112521;
var statearr_112541_112627 = state_112521__$1;
(statearr_112541_112627[(2)] = inst_112401);

(statearr_112541_112627[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112522 === (15))){
var inst_112390 = (state_112521[(2)]);
var state_112521__$1 = state_112521;
var statearr_112542_112628 = state_112521__$1;
(statearr_112542_112628[(2)] = inst_112390);

(statearr_112542_112628[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112522 === (48))){
var state_112521__$1 = state_112521;
if(cljs.core.truth_(fuel)){
var statearr_112543_112629 = state_112521__$1;
(statearr_112543_112629[(1)] = (50));

} else {
var statearr_112544_112630 = state_112521__$1;
(statearr_112544_112630[(1)] = (51));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112522 === (50))){
var inst_112472 = (state_112521[(12)]);
var inst_112481 = cljs.core.count(inst_112472);
var inst_112482 = fluree.db.query.fql.add_fuel(fuel,inst_112481,max_fuel);
var state_112521__$1 = state_112521;
var statearr_112545_112631 = state_112521__$1;
(statearr_112545_112631[(2)] = inst_112482);

(statearr_112545_112631[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112522 === (21))){
var inst_112412 = (state_112521[(18)]);
var state_112521__$1 = state_112521;
var statearr_112546_112632 = state_112521__$1;
(statearr_112546_112632[(2)] = inst_112412);

(statearr_112546_112632[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112522 === (31))){
var inst_112435 = (state_112521[(19)]);
var inst_112400 = (state_112521[(20)]);
var inst_112448 = (inst_112435 >= inst_112400);
var state_112521__$1 = state_112521;
var statearr_112548_112633 = state_112521__$1;
(statearr_112548_112633[(2)] = inst_112448);

(statearr_112548_112633[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112522 === (32))){
var inst_112400 = (state_112521[(20)]);
var state_112521__$1 = state_112521;
var statearr_112549_112634 = state_112521__$1;
(statearr_112549_112634[(2)] = inst_112400);

(statearr_112549_112634[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112522 === (40))){
var inst_112436 = (state_112521[(21)]);
var inst_112435 = (state_112521[(19)]);
var inst_112443 = (state_112521[(22)]);
var inst_112462 = (inst_112435 + (1));
var tmp112547 = inst_112436;
var inst_112434 = inst_112443;
var inst_112435__$1 = inst_112462;
var inst_112436__$1 = tmp112547;
var state_112521__$1 = (function (){var statearr_112550 = state_112521;
(statearr_112550[(21)] = inst_112436__$1);

(statearr_112550[(19)] = inst_112435__$1);

(statearr_112550[(23)] = inst_112434);

return statearr_112550;
})();
var statearr_112551_112635 = state_112521__$1;
(statearr_112551_112635[(2)] = null);

(statearr_112551_112635[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112522 === (56))){
var inst_112361 = (state_112521[(7)]);
var inst_112503 = (state_112521[(10)]);
var inst_112368 = (state_112521[(24)]);
var inst_112511 = (state_112521[(2)]);
var inst_112512 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_112361,inst_112511,inst_112503);
var inst_112360 = inst_112368;
var inst_112361__$1 = inst_112512;
var state_112521__$1 = (function (){var statearr_112552 = state_112521;
(statearr_112552[(15)] = inst_112360);

(statearr_112552[(7)] = inst_112361__$1);

return statearr_112552;
})();
var statearr_112553_112636 = state_112521__$1;
(statearr_112553_112636[(2)] = null);

(statearr_112553_112636[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112522 === (33))){
var inst_112451 = (state_112521[(2)]);
var state_112521__$1 = state_112521;
var statearr_112554_112637 = state_112521__$1;
(statearr_112554_112637[(2)] = inst_112451);

(statearr_112554_112637[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112522 === (13))){
var state_112521__$1 = state_112521;
var statearr_112555_112638 = state_112521__$1;
(statearr_112555_112638[(2)] = true);

(statearr_112555_112638[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112522 === (22))){
var inst_112416 = (state_112521[(2)]);
var state_112521__$1 = state_112521;
if(cljs.core.truth_(inst_112416)){
var statearr_112556_112639 = state_112521__$1;
(statearr_112556_112639[(1)] = (23));

} else {
var statearr_112557_112640 = state_112521__$1;
(statearr_112557_112640[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112522 === (36))){
var inst_112501 = (state_112521[(2)]);
var state_112521__$1 = state_112521;
var statearr_112558_112641 = state_112521__$1;
(statearr_112558_112641[(2)] = inst_112501);

(statearr_112558_112641[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112522 === (41))){
var state_112521__$1 = state_112521;
var statearr_112559_112642 = state_112521__$1;
(statearr_112559_112642[(1)] = (43));



return cljs.core.cst$kw$recur;
} else {
if((state_val_112522 === (43))){
var inst_112442 = (state_112521[(25)]);
var inst_112466 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_112467 = [inst_112442];
var inst_112468 = (new cljs.core.PersistentVector(null,1,(5),inst_112466,inst_112467,null));
var inst_112469 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_112468);
var state_112521__$1 = state_112521;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_112521__$1,(46),inst_112469);
} else {
if((state_val_112522 === (29))){
var inst_112400 = (state_112521[(20)]);
var state_112521__$1 = state_112521;
if(cljs.core.truth_(inst_112400)){
var statearr_112561_112643 = state_112521__$1;
(statearr_112561_112643[(1)] = (31));

} else {
var statearr_112562_112644 = state_112521__$1;
(statearr_112562_112644[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112522 === (44))){
var state_112521__$1 = state_112521;
var statearr_112563_112645 = state_112521__$1;
(statearr_112563_112645[(2)] = null);

(statearr_112563_112645[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112522 === (6))){
var inst_112517 = (state_112521[(2)]);
var state_112521__$1 = state_112521;
var statearr_112564_112646 = state_112521__$1;
(statearr_112564_112646[(2)] = inst_112517);


cljs.core.async.impl.ioc_helpers.process_exception(state_112521__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_112522 === (28))){
var inst_112444 = (state_112521[(26)]);
var state_112521__$1 = state_112521;
var statearr_112565_112647 = state_112521__$1;
(statearr_112565_112647[(2)] = inst_112444);

(statearr_112565_112647[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112522 === (51))){
var state_112521__$1 = state_112521;
var statearr_112566_112648 = state_112521__$1;
(statearr_112566_112648[(2)] = null);

(statearr_112566_112648[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112522 === (25))){
var inst_112412 = (state_112521[(18)]);
var inst_112422 = (state_112521[(2)]);
var inst_112430 = cljs.core.seq(inst_112412);
var inst_112431 = cljs.core.first(inst_112430);
var inst_112432 = cljs.core.next(inst_112430);
var inst_112433 = cljs.core.PersistentVector.EMPTY;
var inst_112434 = inst_112412;
var inst_112435 = (0);
var inst_112436 = inst_112433;
var state_112521__$1 = (function (){var statearr_112567 = state_112521;
(statearr_112567[(21)] = inst_112436);

(statearr_112567[(19)] = inst_112435);

(statearr_112567[(27)] = inst_112422);

(statearr_112567[(28)] = inst_112431);

(statearr_112567[(23)] = inst_112434);

(statearr_112567[(29)] = inst_112432);

return statearr_112567;
})();
var statearr_112568_112649 = state_112521__$1;
(statearr_112568_112649[(2)] = null);

(statearr_112568_112649[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112522 === (34))){
var inst_112436 = (state_112521[(21)]);
var state_112521__$1 = state_112521;
var statearr_112569_112650 = state_112521__$1;
(statearr_112569_112650[(2)] = inst_112436);

(statearr_112569_112650[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112522 === (17))){
var inst_112377 = (state_112521[(13)]);
var state_112521__$1 = state_112521;
var statearr_112570_112651 = state_112521__$1;
(statearr_112570_112651[(2)] = inst_112377);

(statearr_112570_112651[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112522 === (3))){
var inst_112346 = (state_112521[(2)]);
var state_112521__$1 = state_112521;
var statearr_112571_112652 = state_112521__$1;
(statearr_112571_112652[(2)] = inst_112346);


cljs.core.async.impl.ioc_helpers.process_exception(state_112521__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_112522 === (12))){
var inst_112393 = (state_112521[(2)]);
var state_112521__$1 = state_112521;
if(cljs.core.truth_(inst_112393)){
var statearr_112572_112653 = state_112521__$1;
(statearr_112572_112653[(1)] = (16));

} else {
var statearr_112573_112654 = state_112521__$1;
(statearr_112573_112654[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112522 === (2))){
var inst_112519 = (state_112521[(2)]);
var state_112521__$1 = state_112521;
return cljs.core.async.impl.ioc_helpers.return_chan(state_112521__$1,inst_112519);
} else {
if((state_val_112522 === (23))){
var inst_112412 = (state_112521[(18)]);
var inst_112418 = cljs.core.count(inst_112412);
var inst_112419 = fluree.db.query.fql.add_fuel(fuel,inst_112418,max_fuel);
var state_112521__$1 = state_112521;
var statearr_112574_112655 = state_112521__$1;
(statearr_112574_112655[(2)] = inst_112419);

(statearr_112574_112655[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112522 === (47))){
var inst_112436 = (state_112521[(21)]);
var state_112521__$1 = state_112521;
var statearr_112575_112656 = state_112521__$1;
(statearr_112575_112656[(2)] = inst_112436);

(statearr_112575_112656[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112522 === (35))){
var inst_112399 = (state_112521[(30)]);
var state_112521__$1 = state_112521;
if(cljs.core.truth_(inst_112399)){
var statearr_112576_112657 = state_112521__$1;
(statearr_112576_112657[(1)] = (37));

} else {
var statearr_112577_112658 = state_112521__$1;
(statearr_112577_112658[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112522 === (19))){
var inst_112412 = (state_112521[(18)]);
var inst_112409 = (state_112521[(2)]);
var inst_112410 = fluree.db.util.async.throw_err(inst_112409);
var inst_112411 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_112410);
var inst_112412__$1 = cljs.core.not_empty(inst_112411);
var state_112521__$1 = (function (){var statearr_112578 = state_112521;
(statearr_112578[(18)] = inst_112412__$1);

return statearr_112578;
})();
if(cljs.core.truth_(inst_112412__$1)){
var statearr_112579_112659 = state_112521__$1;
(statearr_112579_112659[(1)] = (20));

} else {
var statearr_112580_112660 = state_112521__$1;
(statearr_112580_112660[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112522 === (57))){
var inst_112402 = (state_112521[(11)]);
var state_112521__$1 = state_112521;
var statearr_112581_112661 = state_112521__$1;
(statearr_112581_112661[(2)] = inst_112402);

(statearr_112581_112661[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112522 === (11))){
var state_112521__$1 = state_112521;
var statearr_112582_112662 = state_112521__$1;
(statearr_112582_112662[(2)] = false);

(statearr_112582_112662[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112522 === (9))){
var inst_112515 = (state_112521[(2)]);
var state_112521__$1 = state_112521;
var statearr_112583_112663 = state_112521__$1;
(statearr_112583_112663[(2)] = inst_112515);

(statearr_112583_112663[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112522 === (5))){
var inst_112360 = (state_112521[(15)]);
var inst_112367 = (state_112521[(31)]);
var inst_112366 = cljs.core.seq(inst_112360);
var inst_112367__$1 = cljs.core.first(inst_112366);
var inst_112368 = cljs.core.next(inst_112366);
var inst_112369 = cljs.core.not(inst_112367__$1);
var state_112521__$1 = (function (){var statearr_112584 = state_112521;
(statearr_112584[(31)] = inst_112367__$1);

(statearr_112584[(24)] = inst_112368);

return statearr_112584;
})();
if(inst_112369){
var statearr_112585_112664 = state_112521__$1;
(statearr_112585_112664[(1)] = (7));

} else {
var statearr_112586_112665 = state_112521__$1;
(statearr_112586_112665[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112522 === (14))){
var state_112521__$1 = state_112521;
var statearr_112587_112666 = state_112521__$1;
(statearr_112587_112666[(2)] = false);

(statearr_112587_112666[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112522 === (45))){
var inst_112497 = (state_112521[(2)]);
var state_112521__$1 = state_112521;
var statearr_112588_112667 = state_112521__$1;
(statearr_112588_112667[(2)] = inst_112497);

(statearr_112588_112667[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112522 === (53))){
var inst_112436 = (state_112521[(21)]);
var inst_112488 = (state_112521[(2)]);
var inst_112489 = fluree.db.util.async.throw_err(inst_112488);
var inst_112490 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_112436,inst_112489);
var state_112521__$1 = state_112521;
var statearr_112589_112668 = state_112521__$1;
(statearr_112589_112668[(2)] = inst_112490);

(statearr_112589_112668[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112522 === (26))){
var inst_112442 = (state_112521[(25)]);
var inst_112444 = (state_112521[(26)]);
var inst_112434 = (state_112521[(23)]);
var inst_112441 = cljs.core.seq(inst_112434);
var inst_112442__$1 = cljs.core.first(inst_112441);
var inst_112443 = cljs.core.next(inst_112441);
var inst_112444__$1 = cljs.core.not(inst_112442__$1);
var state_112521__$1 = (function (){var statearr_112590 = state_112521;
(statearr_112590[(22)] = inst_112443);

(statearr_112590[(25)] = inst_112442__$1);

(statearr_112590[(26)] = inst_112444__$1);

return statearr_112590;
})();
if(inst_112444__$1){
var statearr_112591_112669 = state_112521__$1;
(statearr_112591_112669[(1)] = (28));

} else {
var statearr_112592_112670 = state_112521__$1;
(statearr_112592_112670[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112522 === (16))){
var inst_112377 = (state_112521[(13)]);
var inst_112395 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_112377);
var state_112521__$1 = state_112521;
var statearr_112593_112671 = state_112521__$1;
(statearr_112593_112671[(2)] = inst_112395);

(statearr_112593_112671[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112522 === (38))){
var inst_112399 = (state_112521[(30)]);
var state_112521__$1 = state_112521;
var statearr_112594_112672 = state_112521__$1;
(statearr_112594_112672[(2)] = inst_112399);

(statearr_112594_112672[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112522 === (30))){
var inst_112453 = (state_112521[(2)]);
var state_112521__$1 = state_112521;
if(cljs.core.truth_(inst_112453)){
var statearr_112595_112673 = state_112521__$1;
(statearr_112595_112673[(1)] = (34));

} else {
var statearr_112596_112674 = state_112521__$1;
(statearr_112596_112674[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112522 === (10))){
var inst_112377 = (state_112521[(13)]);
var inst_112382 = inst_112377.cljs$lang$protocol_mask$partition0$;
var inst_112383 = (inst_112382 & (64));
var inst_112384 = inst_112377.cljs$core$ISeq$;
var inst_112385 = (cljs.core.PROTOCOL_SENTINEL === inst_112384);
var inst_112386 = ((inst_112383) || (inst_112385));
var state_112521__$1 = state_112521;
if(cljs.core.truth_(inst_112386)){
var statearr_112597_112675 = state_112521__$1;
(statearr_112597_112675[(1)] = (13));

} else {
var statearr_112598_112676 = state_112521__$1;
(statearr_112598_112676[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112522 === (18))){
var inst_112376 = (state_112521[(32)]);
var inst_112398 = (state_112521[(2)]);
var inst_112399 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_112398,cljs.core.cst$kw$offset);
var inst_112400 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_112398,cljs.core.cst$kw$limit);
var inst_112401 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_112398,cljs.core.cst$kw$as);
var inst_112402 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_112398,cljs.core.cst$kw$name);
var inst_112403 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_112398,cljs.core.cst$kw$p);
var inst_112404 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_112405 = [subject_id,inst_112376];
var inst_112406 = (new cljs.core.PersistentVector(null,2,(5),inst_112404,inst_112405,null));
var inst_112407 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$opst,cljs.core._EQ_,inst_112406);
var state_112521__$1 = (function (){var statearr_112599 = state_112521;
(statearr_112599[(30)] = inst_112399);

(statearr_112599[(20)] = inst_112400);

(statearr_112599[(9)] = inst_112401);

(statearr_112599[(8)] = inst_112403);

(statearr_112599[(11)] = inst_112402);

return statearr_112599;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_112521__$1,(19),inst_112407);
} else {
if((state_val_112522 === (52))){
var inst_112472 = (state_112521[(12)]);
var inst_112476 = (state_112521[(14)]);
var inst_112485 = (state_112521[(2)]);
var inst_112486 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_112476,inst_112472) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_112476,inst_112472));
var state_112521__$1 = (function (){var statearr_112600 = state_112521;
(statearr_112600[(33)] = inst_112485);

return statearr_112600;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_112521__$1,(53),inst_112486);
} else {
if((state_val_112522 === (42))){
var inst_112499 = (state_112521[(2)]);
var state_112521__$1 = state_112521;
var statearr_112601_112677 = state_112521__$1;
(statearr_112601_112677[(2)] = inst_112499);

(statearr_112601_112677[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112522 === (37))){
var inst_112399 = (state_112521[(30)]);
var inst_112435 = (state_112521[(19)]);
var inst_112457 = (inst_112435 < inst_112399);
var state_112521__$1 = state_112521;
var statearr_112602_112678 = state_112521__$1;
(statearr_112602_112678[(2)] = inst_112457);

(statearr_112602_112678[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112522 === (8))){
var inst_112377 = (state_112521[(13)]);
var inst_112367 = (state_112521[(31)]);
var inst_112376 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_112367,(0),null);
var inst_112377__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_112367,(1),null);
var inst_112379 = (inst_112377__$1 == null);
var inst_112380 = cljs.core.not(inst_112379);
var state_112521__$1 = (function (){var statearr_112603 = state_112521;
(statearr_112603[(32)] = inst_112376);

(statearr_112603[(13)] = inst_112377__$1);

return statearr_112603;
})();
if(inst_112380){
var statearr_112604_112679 = state_112521__$1;
(statearr_112604_112679[(1)] = (10));

} else {
var statearr_112605_112680 = state_112521__$1;
(statearr_112605_112680[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112522 === (49))){
var inst_112435 = (state_112521[(19)]);
var inst_112443 = (state_112521[(22)]);
var inst_112492 = (state_112521[(2)]);
var inst_112493 = (inst_112435 + (1));
var inst_112434 = inst_112443;
var inst_112435__$1 = inst_112493;
var inst_112436 = inst_112492;
var state_112521__$1 = (function (){var statearr_112606 = state_112521;
(statearr_112606[(21)] = inst_112436);

(statearr_112606[(19)] = inst_112435__$1);

(statearr_112606[(23)] = inst_112434);

return statearr_112606;
})();
var statearr_112607_112681 = state_112521__$1;
(statearr_112607_112681[(2)] = null);

(statearr_112607_112681[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__100742__auto__ = null;
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__100742__auto____0 = (function (){
var statearr_112608 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_112608[(0)] = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__100742__auto__);

(statearr_112608[(1)] = (1));

return statearr_112608;
});
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__100742__auto____1 = (function (state_112521){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_112521);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e112609){if((e112609 instanceof Object)){
var ex__100745__auto__ = e112609;
var statearr_112610_112682 = state_112521;
(statearr_112610_112682[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_112521);

return cljs.core.cst$kw$recur;
} else {
throw e112609;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__112683 = state_112521;
state_112521 = G__112683;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__100742__auto__ = function(state_112521){
switch(arguments.length){
case 0:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__100742__auto____1.call(this,state_112521);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__100742__auto____0;
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__100742__auto____1;
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_112611 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_112611[(6)] = c__100848__auto__);

return statearr_112611;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
fluree.db.query.fql.component_follow_QMARK_ = (function fluree$db$query$fql$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_(pred_spec,cljs.core.cst$kw$componentFollow_QMARK_)){
return cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__4126__auto__ = cljs.core.cst$kw$component_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
fluree.db.query.fql.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,spec){
var key_spec = cljs.core.key(spec);
var val_spec = (((cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.val(spec)) == null))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.val(spec),cljs.core.cst$kw$componentFollow_QMARK_,cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val(spec));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$reverse], null)));
});
fluree.db.query.fql.get_recursion_map_multi = (function fluree$db$query$fql$get_recursion_map_multi(recursion_map,k,f,full_select_spec,seen_QMARK_){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.query.fql.o(f)], null)], null),cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(recursion_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,fluree.db.query.fql.o(f)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.query.fql.o(f)], null)], null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,cljs.core.cst$kw$depth], null),(0)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$pred_DASH_ids,k], null),f.p),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select_DASH_specs,f.p], null),full_select_spec),true], null);
});
fluree.db.query.fql.add_in_multi_flakes = (function fluree$db$query$fql$add_in_multi_flakes(acc,new_child_paths,k,f,db,cache,fuel,max_fuel,pred_spec,component_follow_QMARK_,parent_exists){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_112797){
var state_val_112798 = (state_112797[(1)]);
if((state_val_112798 === (7))){
var inst_112700 = (state_112797[(7)]);
var state_112797__$1 = state_112797;
var statearr_112799_112848 = state_112797__$1;
(statearr_112799_112848[(2)] = inst_112700);

(statearr_112799_112848[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112798 === (20))){
var inst_112744 = (state_112797[(2)]);
var state_112797__$1 = state_112797;
var statearr_112800_112849 = state_112797__$1;
(statearr_112800_112849[(2)] = inst_112744);

(statearr_112800_112849[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112798 === (27))){
var inst_112767 = (state_112797[(2)]);
var inst_112768 = fluree.db.util.async.throw_err(inst_112767);
var state_112797__$1 = state_112797;
var statearr_112801_112850 = state_112797__$1;
(statearr_112801_112850[(2)] = inst_112768);

(statearr_112801_112850[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112798 === (1))){
var state_112797__$1 = state_112797;
var statearr_112802_112851 = state_112797__$1;
(statearr_112802_112851[(2)] = null);

(statearr_112802_112851[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112798 === (24))){
var inst_112700 = (state_112797[(7)]);
var inst_112765 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9(db,cache,fuel,max_fuel,inst_112700,pred_spec,f,component_follow_QMARK_,true);
var state_112797__$1 = state_112797;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_112797__$1,(27),inst_112765);
} else {
if((state_val_112798 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_112797,(3),Error,null,(2));
var inst_112696 = cljs.core.seq(new_child_paths);
var inst_112697 = cljs.core.first(inst_112696);
var inst_112698 = cljs.core.next(inst_112696);
var inst_112699 = new_child_paths;
var inst_112700 = acc;
var state_112797__$1 = (function (){var statearr_112803 = state_112797;
(statearr_112803[(7)] = inst_112700);

(statearr_112803[(8)] = inst_112698);

(statearr_112803[(9)] = inst_112699);

(statearr_112803[(10)] = inst_112697);

return statearr_112803;
})();
var statearr_112804_112852 = state_112797__$1;
(statearr_112804_112852[(2)] = null);

(statearr_112804_112852[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112798 === (15))){
var inst_112749 = (state_112797[(11)]);
var inst_112749__$1 = (state_112797[(2)]);
var inst_112750 = cljs.core.count(inst_112749__$1);
var inst_112751 = (inst_112750 > (1));
var state_112797__$1 = (function (){var statearr_112805 = state_112797;
(statearr_112805[(11)] = inst_112749__$1);

return statearr_112805;
})();
if(cljs.core.truth_(inst_112751)){
var statearr_112806_112853 = state_112797__$1;
(statearr_112806_112853[(1)] = (21));

} else {
var statearr_112807_112854 = state_112797__$1;
(statearr_112807_112854[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112798 === (21))){
var inst_112749 = (state_112797[(11)]);
var inst_112753 = cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1(inst_112749);
var state_112797__$1 = state_112797;
var statearr_112808_112855 = state_112797__$1;
(statearr_112808_112855[(2)] = inst_112753);

(statearr_112808_112855[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112798 === (31))){
var inst_112707 = (state_112797[(12)]);
var inst_112700 = (state_112797[(7)]);
var inst_112787 = (state_112797[(2)]);
var inst_112788 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_112700,inst_112787);
var inst_112699 = inst_112707;
var inst_112700__$1 = inst_112788;
var state_112797__$1 = (function (){var statearr_112809 = state_112797;
(statearr_112809[(7)] = inst_112700__$1);

(statearr_112809[(9)] = inst_112699);

return statearr_112809;
})();
var statearr_112810_112856 = state_112797__$1;
(statearr_112810_112856[(2)] = null);

(statearr_112810_112856[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112798 === (13))){
var inst_112718 = (state_112797[(13)]);
var inst_112715 = (state_112797[(14)]);
var inst_112726 = inst_112715;
var inst_112727 = inst_112718;
var state_112797__$1 = (function (){var statearr_112811 = state_112797;
(statearr_112811[(15)] = inst_112727);

(statearr_112811[(16)] = inst_112726);

return statearr_112811;
})();
var statearr_112812_112857 = state_112797__$1;
(statearr_112812_112857[(2)] = null);

(statearr_112812_112857[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112798 === (22))){
var inst_112749 = (state_112797[(11)]);
var state_112797__$1 = state_112797;
var statearr_112813_112858 = state_112797__$1;
(statearr_112813_112858[(2)] = inst_112749);

(statearr_112813_112858[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112798 === (29))){
var inst_112776 = (state_112797[(17)]);
var state_112797__$1 = state_112797;
var statearr_112814_112859 = state_112797__$1;
(statearr_112814_112859[(2)] = inst_112776);

(statearr_112814_112859[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112798 === (6))){
var inst_112793 = (state_112797[(2)]);
var state_112797__$1 = state_112797;
var statearr_112815_112860 = state_112797__$1;
(statearr_112815_112860[(2)] = inst_112793);


cljs.core.async.impl.ioc_helpers.process_exception(state_112797__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_112798 === (28))){
var inst_112772 = (state_112797[(2)]);
var inst_112773 = fluree.db.util.async.throw_err(inst_112772);
var state_112797__$1 = state_112797;
var statearr_112816_112861 = state_112797__$1;
(statearr_112816_112861[(2)] = inst_112773);

(statearr_112816_112861[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112798 === (25))){
var inst_112757 = (state_112797[(18)]);
var inst_112770 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9(db,cache,fuel,max_fuel,inst_112757,pred_spec,f,component_follow_QMARK_,true);
var state_112797__$1 = state_112797;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_112797__$1,(28),inst_112770);
} else {
if((state_val_112798 === (17))){
var inst_112746 = (state_112797[(2)]);
var state_112797__$1 = state_112797;
var statearr_112817_112862 = state_112797__$1;
(statearr_112817_112862[(2)] = inst_112746);

(statearr_112817_112862[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112798 === (3))){
var inst_112685 = (state_112797[(2)]);
var state_112797__$1 = state_112797;
var statearr_112818_112863 = state_112797__$1;
(statearr_112818_112863[(2)] = inst_112685);


cljs.core.async.impl.ioc_helpers.process_exception(state_112797__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_112798 === (12))){
var inst_112700 = (state_112797[(7)]);
var inst_112715 = (state_112797[(14)]);
var inst_112715__$1 = (state_112797[(2)]);
var inst_112716 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_112717 = [k];
var inst_112718 = (new cljs.core.PersistentVector(null,1,(5),inst_112716,inst_112717,null));
var inst_112719 = cljs.core.cst$kw$_id.cljs$core$IFn$_invoke$arity$1(inst_112700);
var inst_112720 = fluree.db.query.fql.s(f);
var inst_112721 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(inst_112719,inst_112720);
var inst_112722 = cljs.core.empty_QMARK_(inst_112715__$1);
var inst_112723 = (!(inst_112722));
var inst_112724 = ((inst_112721) && (inst_112723));
var state_112797__$1 = (function (){var statearr_112819 = state_112797;
(statearr_112819[(13)] = inst_112718);

(statearr_112819[(14)] = inst_112715__$1);

return statearr_112819;
})();
if(cljs.core.truth_(inst_112724)){
var statearr_112820_112864 = state_112797__$1;
(statearr_112820_112864[(1)] = (13));

} else {
var statearr_112821_112865 = state_112797__$1;
(statearr_112821_112865[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112798 === (2))){
var inst_112795 = (state_112797[(2)]);
var state_112797__$1 = state_112797;
return cljs.core.async.impl.ioc_helpers.return_chan(state_112797__$1,inst_112795);
} else {
if((state_val_112798 === (23))){
var inst_112756 = (state_112797[(19)]);
var inst_112700 = (state_112797[(7)]);
var inst_112756__$1 = (state_112797[(2)]);
var inst_112757 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_112700,inst_112756__$1);
var inst_112761 = cljs.core.cst$kw$_id.cljs$core$IFn$_invoke$arity$1(inst_112700);
var inst_112762 = fluree.db.query.fql.s(f);
var inst_112763 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_112761,inst_112762);
var state_112797__$1 = (function (){var statearr_112822 = state_112797;
(statearr_112822[(19)] = inst_112756__$1);

(statearr_112822[(18)] = inst_112757);

return statearr_112822;
})();
if(inst_112763){
var statearr_112823_112866 = state_112797__$1;
(statearr_112823_112866[(1)] = (24));

} else {
var statearr_112824_112867 = state_112797__$1;
(statearr_112824_112867[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112798 === (19))){
var inst_112735 = (state_112797[(20)]);
var state_112797__$1 = state_112797;
var statearr_112825_112868 = state_112797__$1;
(statearr_112825_112868[(2)] = inst_112735);

(statearr_112825_112868[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112798 === (11))){
var inst_112706 = (state_112797[(21)]);
var inst_112713 = cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1(inst_112706);
var state_112797__$1 = state_112797;
var statearr_112826_112869 = state_112797__$1;
(statearr_112826_112869[(2)] = inst_112713);

(statearr_112826_112869[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112798 === (9))){
var inst_112791 = (state_112797[(2)]);
var state_112797__$1 = state_112797;
var statearr_112827_112870 = state_112797__$1;
(statearr_112827_112870[(2)] = inst_112791);

(statearr_112827_112870[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112798 === (5))){
var inst_112706 = (state_112797[(21)]);
var inst_112699 = (state_112797[(9)]);
var inst_112705 = cljs.core.seq(inst_112699);
var inst_112706__$1 = cljs.core.first(inst_112705);
var inst_112707 = cljs.core.next(inst_112705);
var inst_112708 = cljs.core.not(inst_112706__$1);
var state_112797__$1 = (function (){var statearr_112828 = state_112797;
(statearr_112828[(12)] = inst_112707);

(statearr_112828[(21)] = inst_112706__$1);

return statearr_112828;
})();
if(inst_112708){
var statearr_112829_112871 = state_112797__$1;
(statearr_112829_112871[(1)] = (7));

} else {
var statearr_112830_112872 = state_112797__$1;
(statearr_112830_112872[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112798 === (14))){
var inst_112718 = (state_112797[(13)]);
var state_112797__$1 = state_112797;
var statearr_112831_112873 = state_112797__$1;
(statearr_112831_112873[(2)] = inst_112718);

(statearr_112831_112873[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112798 === (26))){
var inst_112756 = (state_112797[(19)]);
var inst_112700 = (state_112797[(7)]);
var inst_112775 = (state_112797[(2)]);
var inst_112776 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_112775,(0),null);
var inst_112777 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_112775,(1),null);
var inst_112778 = cljs.core.cst$kw$_id.cljs$core$IFn$_invoke$arity$1(inst_112700);
var inst_112779 = fluree.db.query.fql.s(f);
var inst_112780 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_112778,inst_112779);
var inst_112781 = cljs.core.empty_QMARK_(inst_112756);
var inst_112782 = ((inst_112780) || (inst_112781));
var state_112797__$1 = (function (){var statearr_112832 = state_112797;
(statearr_112832[(22)] = inst_112777);

(statearr_112832[(17)] = inst_112776);

return statearr_112832;
})();
if(cljs.core.truth_(inst_112782)){
var statearr_112833_112874 = state_112797__$1;
(statearr_112833_112874[(1)] = (29));

} else {
var statearr_112834_112875 = state_112797__$1;
(statearr_112834_112875[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112798 === (16))){
var inst_112707 = (state_112797[(12)]);
var inst_112727 = (state_112797[(15)]);
var inst_112706 = (state_112797[(21)]);
var inst_112700 = (state_112797[(7)]);
var inst_112698 = (state_112797[(8)]);
var inst_112699 = (state_112797[(9)]);
var inst_112726 = (state_112797[(16)]);
var inst_112697 = (state_112797[(10)]);
var inst_112729 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_112700,inst_112727);
var inst_112730 = (function (){var seq__112694 = inst_112698;
var keys_SINGLEQUOTE_ = inst_112727;
var first__112704 = inst_112706;
var r = inst_112707;
var child_path = inst_112726;
var acc__$1 = inst_112700;
var value = inst_112729;
var G__112692 = inst_112699;
var vec__112702 = inst_112699;
var seq__112703 = inst_112707;
var first__112695 = inst_112697;
var vec__112693 = new_child_paths;
return (function (p1__112684_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$_id.cljs$core$IFn$_invoke$arity$1(p1__112684_SHARP_),cljs.core.first(child_path));
});
})();
var inst_112731 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_112730,inst_112729);
var inst_112732 = cljs.core.first(inst_112731);
var inst_112733 = inst_112729.indexOf(inst_112732);
var inst_112734 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_112727,inst_112733);
var inst_112735 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_112734,k);
var inst_112736 = cljs.core.rest(inst_112726);
var inst_112737 = cljs.core.count(inst_112736);
var inst_112738 = (inst_112737 > (0));
var state_112797__$1 = (function (){var statearr_112835 = state_112797;
(statearr_112835[(20)] = inst_112735);

return statearr_112835;
})();
if(cljs.core.truth_(inst_112738)){
var statearr_112836_112876 = state_112797__$1;
(statearr_112836_112876[(1)] = (18));

} else {
var statearr_112837_112877 = state_112797__$1;
(statearr_112837_112877[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112798 === (30))){
var inst_112756 = (state_112797[(19)]);
var inst_112700 = (state_112797[(7)]);
var inst_112776 = (state_112797[(17)]);
var inst_112785 = cljs.core.assoc_in(inst_112700,inst_112756,inst_112776);
var state_112797__$1 = state_112797;
var statearr_112838_112878 = state_112797__$1;
(statearr_112838_112878[(2)] = inst_112785);

(statearr_112838_112878[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112798 === (10))){
var inst_112706 = (state_112797[(21)]);
var state_112797__$1 = state_112797;
var statearr_112839_112879 = state_112797__$1;
(statearr_112839_112879[(2)] = inst_112706);

(statearr_112839_112879[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112798 === (18))){
var inst_112726 = (state_112797[(16)]);
var inst_112735 = (state_112797[(20)]);
var inst_112740 = cljs.core.rest(inst_112726);
var inst_112726__$1 = inst_112740;
var inst_112727 = inst_112735;
var state_112797__$1 = (function (){var statearr_112840 = state_112797;
(statearr_112840[(15)] = inst_112727);

(statearr_112840[(16)] = inst_112726__$1);

return statearr_112840;
})();
var statearr_112841_112880 = state_112797__$1;
(statearr_112841_112880[(2)] = null);

(statearr_112841_112880[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112798 === (8))){
var state_112797__$1 = state_112797;
if(cljs.core.truth_(parent_exists)){
var statearr_112842_112881 = state_112797__$1;
(statearr_112842_112881[(1)] = (10));

} else {
var statearr_112843_112882 = state_112797__$1;
(statearr_112843_112882[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$add_in_multi_flakes_$_state_machine__100742__auto__ = null;
var fluree$db$query$fql$add_in_multi_flakes_$_state_machine__100742__auto____0 = (function (){
var statearr_112844 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_112844[(0)] = fluree$db$query$fql$add_in_multi_flakes_$_state_machine__100742__auto__);

(statearr_112844[(1)] = (1));

return statearr_112844;
});
var fluree$db$query$fql$add_in_multi_flakes_$_state_machine__100742__auto____1 = (function (state_112797){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_112797);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e112845){if((e112845 instanceof Object)){
var ex__100745__auto__ = e112845;
var statearr_112846_112883 = state_112797;
(statearr_112846_112883[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_112797);

return cljs.core.cst$kw$recur;
} else {
throw e112845;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__112884 = state_112797;
state_112797 = G__112884;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$query$fql$add_in_multi_flakes_$_state_machine__100742__auto__ = function(state_112797){
switch(arguments.length){
case 0:
return fluree$db$query$fql$add_in_multi_flakes_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$query$fql$add_in_multi_flakes_$_state_machine__100742__auto____1.call(this,state_112797);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$add_in_multi_flakes_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$add_in_multi_flakes_$_state_machine__100742__auto____0;
fluree$db$query$fql$add_in_multi_flakes_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$add_in_multi_flakes_$_state_machine__100742__auto____1;
return fluree$db$query$fql$add_in_multi_flakes_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_112847 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_112847[(6)] = c__100848__auto__);

return statearr_112847;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
fluree.db.query.fql.flake__GT_recur_multi = (function fluree$db$query$fql$flake__GT_recur_multi(db,f,pred_spec,recursion_map,flakes,acc,fuel,max_fuel,select_spec,cache,component_follow_QMARK_){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_112994){
var state_val_112995 = (state_112994[(1)]);
if((state_val_112995 === (7))){
var inst_112894 = (state_112994[(7)]);
var inst_112905 = (state_112994[(8)]);
var inst_112909 = (state_112994[(9)]);
var inst_112905__$1 = (state_112994[(2)]);
var inst_112906 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_112907 = [inst_112905__$1,inst_112894];
var inst_112908 = (new cljs.core.PersistentVector(null,2,(5),inst_112906,inst_112907,null));
var inst_112909__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(recursion_map,inst_112908);
var state_112994__$1 = (function (){var statearr_112996 = state_112994;
(statearr_112996[(8)] = inst_112905__$1);

(statearr_112996[(9)] = inst_112909__$1);

return statearr_112996;
})();
if(cljs.core.truth_(inst_112909__$1)){
var statearr_112997_113056 = state_112994__$1;
(statearr_112997_113056[(1)] = (11));

} else {
var statearr_112998_113057 = state_112994__$1;
(statearr_112998_113057[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112995 === (20))){
var inst_112936 = (state_112994[(10)]);
var inst_112938 = f.o;
var inst_112939 = fluree.db.query.fql.resolve_reverse_refs(db,cache,fuel,max_fuel,inst_112938,inst_112936);
var state_112994__$1 = state_112994;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_112994__$1,(23),inst_112939);
} else {
if((state_val_112995 === (27))){
var inst_112956 = (state_112994[(2)]);
var state_112994__$1 = state_112994;
if(cljs.core.truth_(inst_112956)){
var statearr_112999_113058 = state_112994__$1;
(statearr_112999_113058[(1)] = (28));

} else {
var statearr_113000_113059 = state_112994__$1;
(statearr_113000_113059[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112995 === (1))){
var state_112994__$1 = state_112994;
var statearr_113001_113060 = state_112994__$1;
(statearr_113001_113060[(2)] = null);

(statearr_113001_113060[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112995 === (24))){
var inst_112923 = (state_112994[(11)]);
var inst_112950 = (state_112994[(2)]);
var inst_112951 = fluree.db.util.async.throw_err(inst_112950);
var state_112994__$1 = (function (){var statearr_113002 = state_112994;
(statearr_113002[(12)] = inst_112951);

return statearr_113002;
})();
if(cljs.core.truth_(inst_112923)){
var statearr_113003_113061 = state_112994__$1;
(statearr_113003_113061[(1)] = (25));

} else {
var statearr_113004_113062 = state_112994__$1;
(statearr_113004_113062[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112995 === (39))){
var inst_112973 = (state_112994[(13)]);
var state_112994__$1 = state_112994;
var statearr_113005_113063 = state_112994__$1;
(statearr_113005_113063[(2)] = inst_112973);

(statearr_113005_113063[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112995 === (4))){
var inst_112895 = (state_112994[(14)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_112994,(3),Error,null,(2));
var inst_112892 = fluree.db.query.fql.s(f);
var inst_112893 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$_id,inst_112892);
var inst_112894 = fluree.db.query.fql.o(f);
var inst_112895__$1 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_112994__$1 = (function (){var statearr_113006 = state_112994;
(statearr_113006[(15)] = inst_112893);

(statearr_113006[(14)] = inst_112895__$1);

(statearr_113006[(7)] = inst_112894);

return statearr_113006;
})();
if(cljs.core.truth_(inst_112895__$1)){
var statearr_113007_113064 = state_112994__$1;
(statearr_113007_113064[(1)] = (5));

} else {
var statearr_113008_113065 = state_112994__$1;
(statearr_113008_113065[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112995 === (15))){
var inst_112917 = (state_112994[(16)]);
var inst_112926 = cljs.core.not(inst_112917);
var state_112994__$1 = state_112994;
var statearr_113009_113066 = state_112994__$1;
(statearr_113009_113066[(2)] = inst_112926);

(statearr_113009_113066[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112995 === (21))){
var state_112994__$1 = state_112994;
var statearr_113010_113067 = state_112994__$1;
(statearr_113010_113067[(2)] = null);

(statearr_113010_113067[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112995 === (31))){
var inst_112947 = (state_112994[(17)]);
var inst_112961 = cljs.core.rest(flakes);
var inst_112962 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_112961,inst_112947);
var state_112994__$1 = state_112994;
var statearr_113011_113068 = state_112994__$1;
(statearr_113011_113068[(2)] = inst_112962);

(statearr_113011_113068[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112995 === (32))){
var state_112994__$1 = state_112994;
var statearr_113012_113069 = state_112994__$1;
(statearr_113012_113069[(1)] = (34));



return cljs.core.cst$kw$recur;
} else {
if((state_val_112995 === (40))){
var inst_112965 = (state_112994[(18)]);
var inst_112979 = (state_112994[(2)]);
var inst_112980 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_112965,inst_112979);
var state_112994__$1 = state_112994;
var statearr_113014_113070 = state_112994__$1;
(statearr_113014_113070[(2)] = inst_112980);

(statearr_113014_113070[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112995 === (33))){
var inst_112985 = (state_112994[(2)]);
var state_112994__$1 = state_112994;
var statearr_113015_113071 = state_112994__$1;
(statearr_113015_113071[(2)] = inst_112985);

(statearr_113015_113071[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112995 === (13))){
var inst_112923 = (state_112994[(11)]);
var inst_112905 = (state_112994[(8)]);
var inst_112916 = (state_112994[(19)]);
var inst_112913 = (state_112994[(2)]);
var inst_112914 = fluree.db.query.fql.get_recursion_map_multi(recursion_map,inst_112905,f,select_spec,inst_112913);
var inst_112915 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_112914,(0),null);
var inst_112916__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_112914,(1),null);
var inst_112917 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_112914,(2),null);
var inst_112918 = cljs.core.cst$kw$recur.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_112919 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_112920 = [inst_112905,cljs.core.cst$kw$depth];
var inst_112921 = (new cljs.core.PersistentVector(null,2,(5),inst_112919,inst_112920,null));
var inst_112922 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_112916__$1,inst_112921);
var inst_112923__$1 = (inst_112918 < inst_112922);
var state_112994__$1 = (function (){var statearr_113016 = state_112994;
(statearr_113016[(16)] = inst_112917);

(statearr_113016[(11)] = inst_112923__$1);

(statearr_113016[(20)] = inst_112915);

(statearr_113016[(19)] = inst_112916__$1);

return statearr_113016;
})();
if(cljs.core.truth_(inst_112923__$1)){
var statearr_113017_113072 = state_112994__$1;
(statearr_113017_113072[(1)] = (14));

} else {
var statearr_113018_113073 = state_112994__$1;
(statearr_113018_113073[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112995 === (22))){
var inst_112945 = (state_112994[(2)]);
var state_112994__$1 = state_112994;
var statearr_113019_113074 = state_112994__$1;
(statearr_113019_113074[(2)] = inst_112945);

(statearr_113019_113074[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112995 === (36))){
var inst_112983 = (state_112994[(2)]);
var state_112994__$1 = state_112994;
var statearr_113020_113075 = state_112994__$1;
(statearr_113020_113075[(2)] = inst_112983);

(statearr_113020_113075[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112995 === (29))){
var inst_112947 = (state_112994[(17)]);
var state_112994__$1 = state_112994;
if(cljs.core.truth_(inst_112947)){
var statearr_113021_113076 = state_112994__$1;
(statearr_113021_113076[(1)] = (31));

} else {
var statearr_113022_113077 = state_112994__$1;
(statearr_113022_113077[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112995 === (6))){
var inst_112898 = (state_112994[(21)]);
var inst_112898__$1 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_112994__$1 = (function (){var statearr_113023 = state_112994;
(statearr_113023[(21)] = inst_112898__$1);

return statearr_113023;
})();
if(cljs.core.truth_(inst_112898__$1)){
var statearr_113024_113078 = state_112994__$1;
(statearr_113024_113078[(1)] = (8));

} else {
var statearr_113025_113079 = state_112994__$1;
(statearr_113025_113079[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112995 === (28))){
var inst_112958 = cljs.core.rest(flakes);
var state_112994__$1 = state_112994;
var statearr_113026_113080 = state_112994__$1;
(statearr_113026_113080[(2)] = inst_112958);

(statearr_113026_113080[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112995 === (25))){
var inst_112923 = (state_112994[(11)]);
var state_112994__$1 = state_112994;
var statearr_113027_113081 = state_112994__$1;
(statearr_113027_113081[(2)] = inst_112923);

(statearr_113027_113081[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112995 === (34))){
var inst_112894 = (state_112994[(7)]);
var inst_112965 = cljs.core.rest(flakes);
var inst_112967 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_112968 = [inst_112894];
var inst_112969 = (new cljs.core.PersistentVector(null,1,(5),inst_112967,inst_112968,null));
var inst_112970 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_112969);
var state_112994__$1 = (function (){var statearr_113028 = state_112994;
(statearr_113028[(18)] = inst_112965);

return statearr_113028;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_112994__$1,(37),inst_112970);
} else {
if((state_val_112995 === (17))){
var state_112994__$1 = state_112994;
var statearr_113029_113082 = state_112994__$1;
(statearr_113029_113082[(2)] = null);

(statearr_113029_113082[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112995 === (3))){
var inst_112885 = (state_112994[(2)]);
var state_112994__$1 = state_112994;
var statearr_113030_113083 = state_112994__$1;
(statearr_113030_113083[(2)] = inst_112885);


cljs.core.async.impl.ioc_helpers.process_exception(state_112994__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_112995 === (12))){
var state_112994__$1 = state_112994;
var statearr_113031_113084 = state_112994__$1;
(statearr_113031_113084[(2)] = false);

(statearr_113031_113084[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112995 === (2))){
var inst_112992 = (state_112994[(2)]);
var state_112994__$1 = state_112994;
return cljs.core.async.impl.ioc_helpers.return_chan(state_112994__$1,inst_112992);
} else {
if((state_val_112995 === (23))){
var inst_112941 = (state_112994[(2)]);
var inst_112942 = fluree.db.util.async.throw_err(inst_112941);
var state_112994__$1 = state_112994;
var statearr_113032_113085 = state_112994__$1;
(statearr_113032_113085[(2)] = inst_112942);

(statearr_113032_113085[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112995 === (35))){
var state_112994__$1 = state_112994;
var statearr_113033_113086 = state_112994__$1;
(statearr_113033_113086[(2)] = null);

(statearr_113033_113086[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112995 === (19))){
var inst_112893 = (state_112994[(15)]);
var inst_112905 = (state_112994[(8)]);
var inst_112915 = (state_112994[(20)]);
var inst_112947 = (state_112994[(2)]);
var inst_112948 = fluree.db.query.fql.add_in_multi_flakes(inst_112893,inst_112915,inst_112905,f,db,cache,fuel,max_fuel,pred_spec,component_follow_QMARK_,false);
var state_112994__$1 = (function (){var statearr_113034 = state_112994;
(statearr_113034[(17)] = inst_112947);

return statearr_113034;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_112994__$1,(24),inst_112948);
} else {
if((state_val_112995 === (11))){
var inst_112909 = (state_112994[(9)]);
var state_112994__$1 = state_112994;
var statearr_113035_113087 = state_112994__$1;
(statearr_113035_113087[(2)] = inst_112909);

(statearr_113035_113087[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112995 === (9))){
var inst_112901 = cljs.core.cst$kw$p.cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_112994__$1 = state_112994;
var statearr_113036_113088 = state_112994__$1;
(statearr_113036_113088[(2)] = inst_112901);

(statearr_113036_113088[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112995 === (5))){
var inst_112895 = (state_112994[(14)]);
var state_112994__$1 = state_112994;
var statearr_113037_113089 = state_112994__$1;
(statearr_113037_113089[(2)] = inst_112895);

(statearr_113037_113089[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112995 === (14))){
var inst_112923 = (state_112994[(11)]);
var state_112994__$1 = state_112994;
var statearr_113038_113090 = state_112994__$1;
(statearr_113038_113090[(2)] = inst_112923);

(statearr_113038_113090[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112995 === (26))){
var inst_112917 = (state_112994[(16)]);
var inst_112954 = cljs.core.not(inst_112917);
var state_112994__$1 = state_112994;
var statearr_113039_113091 = state_112994__$1;
(statearr_113039_113091[(2)] = inst_112954);

(statearr_113039_113091[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112995 === (16))){
var inst_112928 = (state_112994[(2)]);
var state_112994__$1 = state_112994;
if(cljs.core.truth_(inst_112928)){
var statearr_113040_113092 = state_112994__$1;
(statearr_113040_113092[(1)] = (17));

} else {
var statearr_113041_113093 = state_112994__$1;
(statearr_113041_113093[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112995 === (38))){
var inst_112973 = (state_112994[(13)]);
var inst_112975 = fluree.db.query.fql.fuel_flake_transducer(fuel,max_fuel);
var inst_112976 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_112975,inst_112973);
var state_112994__$1 = state_112994;
var statearr_113042_113094 = state_112994__$1;
(statearr_113042_113094[(2)] = inst_112976);

(statearr_113042_113094[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112995 === (30))){
var inst_112951 = (state_112994[(12)]);
var inst_112916 = (state_112994[(19)]);
var inst_112987 = (state_112994[(2)]);
var inst_112988 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_112989 = [inst_112951,inst_112987,inst_112916];
var inst_112990 = (new cljs.core.PersistentVector(null,3,(5),inst_112988,inst_112989,null));
var state_112994__$1 = state_112994;
var statearr_113043_113095 = state_112994__$1;
(statearr_113043_113095[(2)] = inst_112990);


cljs.core.async.impl.ioc_helpers.process_exception(state_112994__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_112995 === (10))){
var inst_112903 = (state_112994[(2)]);
var state_112994__$1 = state_112994;
var statearr_113044_113096 = state_112994__$1;
(statearr_113044_113096[(2)] = inst_112903);

(statearr_113044_113096[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112995 === (18))){
var inst_112936 = (state_112994[(10)]);
var inst_112916 = (state_112994[(19)]);
var inst_112931 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_112932 = f.p;
var inst_112933 = [cljs.core.cst$kw$select_DASH_specs,inst_112932];
var inst_112934 = (new cljs.core.PersistentVector(null,2,(5),inst_112931,inst_112933,null));
var inst_112935 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_112916,inst_112934);
var inst_112936__$1 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs(inst_112935);
var state_112994__$1 = (function (){var statearr_113045 = state_112994;
(statearr_113045[(10)] = inst_112936__$1);

return statearr_113045;
})();
if(cljs.core.truth_(inst_112936__$1)){
var statearr_113046_113097 = state_112994__$1;
(statearr_113046_113097[(1)] = (20));

} else {
var statearr_113047_113098 = state_112994__$1;
(statearr_113047_113098[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112995 === (37))){
var inst_112972 = (state_112994[(2)]);
var inst_112973 = fluree.db.util.async.throw_err(inst_112972);
var state_112994__$1 = (function (){var statearr_113048 = state_112994;
(statearr_113048[(13)] = inst_112973);

return statearr_113048;
})();
if(cljs.core.truth_(fuel)){
var statearr_113049_113099 = state_112994__$1;
(statearr_113049_113099[(1)] = (38));

} else {
var statearr_113050_113100 = state_112994__$1;
(statearr_113050_113100[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112995 === (8))){
var inst_112898 = (state_112994[(21)]);
var state_112994__$1 = state_112994;
var statearr_113051_113101 = state_112994__$1;
(statearr_113051_113101[(2)] = inst_112898);

(statearr_113051_113101[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__100742__auto__ = null;
var fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__100742__auto____0 = (function (){
var statearr_113052 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_113052[(0)] = fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__100742__auto__);

(statearr_113052[(1)] = (1));

return statearr_113052;
});
var fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__100742__auto____1 = (function (state_112994){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_112994);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e113053){if((e113053 instanceof Object)){
var ex__100745__auto__ = e113053;
var statearr_113054_113102 = state_112994;
(statearr_113054_113102[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_112994);

return cljs.core.cst$kw$recur;
} else {
throw e113053;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__113103 = state_112994;
state_112994 = G__113103;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__100742__auto__ = function(state_112994){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__100742__auto____1.call(this,state_112994);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__100742__auto____0;
fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__100742__auto____1;
return fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_113055 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_113055[(6)] = c__100848__auto__);

return statearr_113055;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
fluree.db.query.fql.get_recursion_map = (function fluree$db$query$fql$get_recursion_map(db,recursion_map,select_spec,cache,k,f){
var select_spec__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,f.p], null));
var full_select_spec = (cljs.core.truth_(fluree.db.query.fql.has_ns_lookups_QMARK_(select_spec__$1))?fluree.db.query.fql.full_select_spec(db,cache,select_spec__$1,fluree.db.query.fql.s(f)):select_spec__$1);
return cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(recursion_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,fluree.db.query.fql.s(f)], null),(0)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$pred_DASH_ids,k], null),f.p),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select_DASH_specs,f.p], null),full_select_spec);
});
fluree.db.query.fql.flake__GT_recur = (function fluree$db$query$fql$flake__GT_recur(db,f,pred_spec,recursion_map,flakes,acc,fuel,max_fuel,select_spec,cache){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_113263){
var state_val_113264 = (state_113263[(1)]);
if((state_val_113264 === (7))){
var inst_113108 = (state_113263[(7)]);
var inst_113128 = (state_113263[(8)]);
var inst_113120 = (state_113263[(9)]);
var inst_113120__$1 = (state_113263[(2)]);
var inst_113121 = cljs.core.PersistentVector.EMPTY;
var inst_113122 = cljs.core.repeat.cljs$core$IFn$_invoke$arity$2((0),inst_113120__$1);
var inst_113123 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_113121,inst_113122);
var inst_113124 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc,inst_113123);
var inst_113125 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_113126 = [inst_113120__$1,inst_113108];
var inst_113127 = (new cljs.core.PersistentVector(null,2,(5),inst_113125,inst_113126,null));
var inst_113128__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(recursion_map,inst_113127);
var state_113263__$1 = (function (){var statearr_113265 = state_113263;
(statearr_113265[(10)] = inst_113124);

(statearr_113265[(8)] = inst_113128__$1);

(statearr_113265[(9)] = inst_113120__$1);

return statearr_113265;
})();
if(cljs.core.truth_(inst_113128__$1)){
var statearr_113266_113357 = state_113263__$1;
(statearr_113266_113357[(1)] = (11));

} else {
var statearr_113267_113358 = state_113263__$1;
(statearr_113267_113358[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113264 === (59))){
var inst_113245 = (state_113263[(11)]);
var state_113263__$1 = state_113263;
var statearr_113268_113359 = state_113263__$1;
(statearr_113268_113359[(2)] = inst_113245);

(statearr_113268_113359[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113264 === (20))){
var inst_113152 = (state_113263[(12)]);
var state_113263__$1 = state_113263;
var statearr_113269_113360 = state_113263__$1;
(statearr_113269_113360[(2)] = inst_113152);

(statearr_113269_113360[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113264 === (58))){
var inst_113245 = (state_113263[(11)]);
var inst_113247 = fluree.db.query.fql.fuel_flake_transducer(fuel,max_fuel);
var inst_113248 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_113247,inst_113245);
var state_113263__$1 = state_113263;
var statearr_113270_113361 = state_113263__$1;
(statearr_113270_113361[(2)] = inst_113248);

(statearr_113270_113361[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113264 === (60))){
var inst_113237 = (state_113263[(13)]);
var inst_113251 = (state_113263[(2)]);
var inst_113252 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_113237,inst_113251);
var state_113263__$1 = state_113263;
var statearr_113271_113362 = state_113263__$1;
(statearr_113271_113362[(2)] = inst_113252);

(statearr_113271_113362[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113264 === (27))){
var state_113263__$1 = state_113263;
var statearr_113272_113363 = state_113263__$1;
(statearr_113272_113363[(2)] = null);

(statearr_113272_113363[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113264 === (1))){
var state_113263__$1 = state_113263;
var statearr_113273_113364 = state_113263__$1;
(statearr_113273_113364[(2)] = null);

(statearr_113273_113364[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113264 === (24))){
var inst_113147 = (state_113263[(14)]);
var inst_113164 = (state_113263[(15)]);
var inst_113159 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_113160 = f.p;
var inst_113161 = [cljs.core.cst$kw$select_DASH_specs,inst_113160];
var inst_113162 = (new cljs.core.PersistentVector(null,2,(5),inst_113159,inst_113161,null));
var inst_113163 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_113147,inst_113162);
var inst_113164__$1 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs(inst_113163);
var state_113263__$1 = (function (){var statearr_113274 = state_113263;
(statearr_113274[(15)] = inst_113164__$1);

return statearr_113274;
})();
if(cljs.core.truth_(inst_113164__$1)){
var statearr_113275_113365 = state_113263__$1;
(statearr_113275_113365[(1)] = (26));

} else {
var statearr_113276_113366 = state_113263__$1;
(statearr_113276_113366[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113264 === (55))){
var inst_113108 = (state_113263[(7)]);
var inst_113237 = cljs.core.rest(flakes);
var inst_113239 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_113240 = [inst_113108];
var inst_113241 = (new cljs.core.PersistentVector(null,1,(5),inst_113239,inst_113240,null));
var inst_113242 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_113241);
var state_113263__$1 = (function (){var statearr_113277 = state_113263;
(statearr_113277[(13)] = inst_113237);

return statearr_113277;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_113263__$1,(57),inst_113242);
} else {
if((state_val_113264 === (39))){
var inst_113175 = (state_113263[(16)]);
var inst_113205 = (state_113263[(17)]);
var inst_113120 = (state_113263[(9)]);
var inst_113207 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_113205,inst_113120);
var inst_113208 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_113207,inst_113175], 0));
var inst_113209 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_113205,inst_113120,inst_113208);
var state_113263__$1 = state_113263;
var statearr_113278_113367 = state_113263__$1;
(statearr_113278_113367[(2)] = inst_113209);

(statearr_113278_113367[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113264 === (46))){
var state_113263__$1 = state_113263;
var statearr_113279_113368 = state_113263__$1;
(statearr_113279_113368[(1)] = (48));



return cljs.core.cst$kw$recur;
} else {
if((state_val_113264 === (4))){
var inst_113110 = (state_113263[(18)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_113263,(3),Error,null,(2));
var inst_113108 = f.o;
var inst_113109 = cljs.core.cst$kw$multi_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_113110__$1 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_113263__$1 = (function (){var statearr_113281 = state_113263;
(statearr_113281[(19)] = inst_113109);

(statearr_113281[(7)] = inst_113108);

(statearr_113281[(18)] = inst_113110__$1);

return statearr_113281;
})();
if(cljs.core.truth_(inst_113110__$1)){
var statearr_113282_113369 = state_113263__$1;
(statearr_113282_113369[(1)] = (5));

} else {
var statearr_113283_113370 = state_113263__$1;
(statearr_113283_113370[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113264 === (54))){
var inst_113235 = cljs.core.rest(flakes);
var state_113263__$1 = state_113263;
var statearr_113284_113371 = state_113263__$1;
(statearr_113284_113371[(2)] = inst_113235);

(statearr_113284_113371[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113264 === (15))){
var state_113263__$1 = state_113263;
var statearr_113285_113372 = state_113263__$1;
(statearr_113285_113372[(2)] = recursion_map);

(statearr_113285_113372[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113264 === (48))){
var inst_113212 = (state_113263[(20)]);
var inst_113120 = (state_113263[(9)]);
var inst_113219 = cljs.core.PersistentVector.EMPTY;
var inst_113220 = cljs.core.repeat.cljs$core$IFn$_invoke$arity$2((0),inst_113120);
var inst_113221 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_113219,inst_113220);
var inst_113222 = cljs.core.assoc_in(acc,inst_113221,inst_113212);
var state_113263__$1 = state_113263;
var statearr_113286_113373 = state_113263__$1;
(statearr_113286_113373[(2)] = inst_113222);

(statearr_113286_113373[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113264 === (50))){
var inst_113225 = (state_113263[(2)]);
var state_113263__$1 = state_113263;
var statearr_113287_113374 = state_113263__$1;
(statearr_113287_113374[(2)] = inst_113225);

(statearr_113287_113374[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113264 === (21))){
var inst_113132 = (state_113263[(21)]);
var state_113263__$1 = state_113263;
var statearr_113288_113375 = state_113263__$1;
(statearr_113288_113375[(2)] = inst_113132);

(statearr_113288_113375[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113264 === (31))){
var inst_113109 = (state_113263[(19)]);
var state_113263__$1 = state_113263;
var statearr_113289_113376 = state_113263__$1;
(statearr_113289_113376[(2)] = inst_113109);

(statearr_113289_113376[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113264 === (32))){
var inst_113183 = (state_113263[(2)]);
var state_113263__$1 = state_113263;
if(cljs.core.truth_(inst_113183)){
var statearr_113290_113377 = state_113263__$1;
(statearr_113290_113377[(1)] = (33));

} else {
var statearr_113291_113378 = state_113263__$1;
(statearr_113291_113378[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113264 === (40))){
var inst_113205 = (state_113263[(17)]);
var state_113263__$1 = state_113263;
var statearr_113292_113379 = state_113263__$1;
(statearr_113292_113379[(2)] = inst_113205);

(statearr_113292_113379[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113264 === (56))){
var inst_113229 = (state_113263[(22)]);
var inst_113147 = (state_113263[(14)]);
var inst_113254 = (state_113263[(2)]);
var inst_113255 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_113256 = [inst_113229,inst_113254,inst_113147];
var inst_113257 = (new cljs.core.PersistentVector(null,3,(5),inst_113255,inst_113256,null));
var state_113263__$1 = state_113263;
var statearr_113293_113380 = state_113263__$1;
(statearr_113293_113380[(2)] = inst_113257);

(statearr_113293_113380[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113264 === (33))){
var inst_113147 = (state_113263[(14)]);
var inst_113185 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_113186 = cljs.core.rest(flakes);
var inst_113187 = [acc,inst_113186,inst_113147];
var inst_113188 = (new cljs.core.PersistentVector(null,3,(5),inst_113185,inst_113187,null));
var state_113263__$1 = state_113263;
var statearr_113294_113381 = state_113263__$1;
(statearr_113294_113381[(2)] = inst_113188);

(statearr_113294_113381[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113264 === (13))){
var inst_113132 = (state_113263[(21)]);
var inst_113132__$1 = (state_113263[(2)]);
var inst_113133 = cljs.core.not(inst_113132__$1);
var state_113263__$1 = (function (){var statearr_113295 = state_113263;
(statearr_113295[(21)] = inst_113132__$1);

return statearr_113295;
})();
if(inst_113133){
var statearr_113296_113382 = state_113263__$1;
(statearr_113296_113382[(1)] = (14));

} else {
var statearr_113297_113383 = state_113263__$1;
(statearr_113297_113383[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113264 === (22))){
var inst_113156 = (state_113263[(2)]);
var state_113263__$1 = state_113263;
if(cljs.core.truth_(inst_113156)){
var statearr_113298_113384 = state_113263__$1;
(statearr_113298_113384[(1)] = (23));

} else {
var statearr_113299_113385 = state_113263__$1;
(statearr_113299_113385[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113264 === (36))){
var inst_113124 = (state_113263[(10)]);
var inst_113108 = (state_113263[(7)]);
var inst_113120 = (state_113263[(9)]);
var inst_113191 = cljs.core.PersistentVector.EMPTY;
var inst_113192 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_113124,inst_113120);
var inst_113193 = [cljs.core.cst$kw$_id];
var inst_113194 = [inst_113108];
var inst_113195 = cljs.core.PersistentHashMap.fromArrays(inst_113193,inst_113194);
var inst_113196 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_113192,inst_113195);
var inst_113197 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_113191,inst_113196);
var inst_113198 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_113124,inst_113120,inst_113197);
var state_113263__$1 = state_113263;
var statearr_113300_113386 = state_113263__$1;
(statearr_113300_113386[(2)] = inst_113198);

(statearr_113300_113386[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113264 === (41))){
var inst_113132 = (state_113263[(21)]);
var inst_113212 = (state_113263[(2)]);
var inst_113213 = cljs.core.not(inst_113132);
var state_113263__$1 = (function (){var statearr_113301 = state_113263;
(statearr_113301[(20)] = inst_113212);

return statearr_113301;
})();
if(inst_113213){
var statearr_113302_113387 = state_113263__$1;
(statearr_113302_113387[(1)] = (42));

} else {
var statearr_113303_113388 = state_113263__$1;
(statearr_113303_113388[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113264 === (43))){
var inst_113132 = (state_113263[(21)]);
var state_113263__$1 = state_113263;
if(cljs.core.truth_(inst_113132)){
var statearr_113304_113389 = state_113263__$1;
(statearr_113304_113389[(1)] = (45));

} else {
var statearr_113305_113390 = state_113263__$1;
(statearr_113305_113390[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113264 === (29))){
var inst_113169 = (state_113263[(2)]);
var inst_113170 = fluree.db.util.async.throw_err(inst_113169);
var state_113263__$1 = state_113263;
var statearr_113306_113391 = state_113263__$1;
(statearr_113306_113391[(2)] = inst_113170);

(statearr_113306_113391[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113264 === (44))){
var inst_113152 = (state_113263[(12)]);
var inst_113229 = (state_113263[(2)]);
var state_113263__$1 = (function (){var statearr_113307 = state_113263;
(statearr_113307[(22)] = inst_113229);

return statearr_113307;
})();
if(cljs.core.truth_(inst_113152)){
var statearr_113308_113392 = state_113263__$1;
(statearr_113308_113392[(1)] = (51));

} else {
var statearr_113309_113393 = state_113263__$1;
(statearr_113309_113393[(1)] = (52));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113264 === (6))){
var inst_113113 = (state_113263[(23)]);
var inst_113113__$1 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_113263__$1 = (function (){var statearr_113310 = state_113263;
(statearr_113310[(23)] = inst_113113__$1);

return statearr_113310;
})();
if(cljs.core.truth_(inst_113113__$1)){
var statearr_113311_113394 = state_113263__$1;
(statearr_113311_113394[(1)] = (8));

} else {
var statearr_113312_113395 = state_113263__$1;
(statearr_113312_113395[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113264 === (28))){
var inst_113173 = (state_113263[(2)]);
var state_113263__$1 = state_113263;
var statearr_113313_113396 = state_113263__$1;
(statearr_113313_113396[(2)] = inst_113173);

(statearr_113313_113396[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113264 === (51))){
var inst_113152 = (state_113263[(12)]);
var state_113263__$1 = state_113263;
var statearr_113314_113397 = state_113263__$1;
(statearr_113314_113397[(2)] = inst_113152);

(statearr_113314_113397[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113264 === (25))){
var inst_113109 = (state_113263[(19)]);
var inst_113175 = (state_113263[(2)]);
var state_113263__$1 = (function (){var statearr_113315 = state_113263;
(statearr_113315[(16)] = inst_113175);

return statearr_113315;
})();
if(cljs.core.truth_(inst_113109)){
var statearr_113316_113398 = state_113263__$1;
(statearr_113316_113398[(1)] = (30));

} else {
var statearr_113317_113399 = state_113263__$1;
(statearr_113317_113399[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113264 === (34))){
var inst_113109 = (state_113263[(19)]);
var state_113263__$1 = state_113263;
if(cljs.core.truth_(inst_113109)){
var statearr_113318_113400 = state_113263__$1;
(statearr_113318_113400[(1)] = (36));

} else {
var statearr_113319_113401 = state_113263__$1;
(statearr_113319_113401[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113264 === (17))){
var inst_113138 = (state_113263[(24)]);
var state_113263__$1 = state_113263;
var statearr_113320_113402 = state_113263__$1;
(statearr_113320_113402[(2)] = inst_113138);

(statearr_113320_113402[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113264 === (3))){
var inst_113104 = (state_113263[(2)]);
var state_113263__$1 = state_113263;
var statearr_113321_113403 = state_113263__$1;
(statearr_113321_113403[(2)] = inst_113104);


cljs.core.async.impl.ioc_helpers.process_exception(state_113263__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_113264 === (12))){
var state_113263__$1 = state_113263;
var statearr_113322_113404 = state_113263__$1;
(statearr_113322_113404[(2)] = false);

(statearr_113322_113404[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113264 === (2))){
var inst_113261 = (state_113263[(2)]);
var state_113263__$1 = state_113263;
return cljs.core.async.impl.ioc_helpers.return_chan(state_113263__$1,inst_113261);
} else {
if((state_val_113264 === (23))){
var state_113263__$1 = state_113263;
var statearr_113323_113405 = state_113263__$1;
(statearr_113323_113405[(2)] = null);

(statearr_113323_113405[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113264 === (47))){
var inst_113227 = (state_113263[(2)]);
var state_113263__$1 = state_113263;
var statearr_113324_113406 = state_113263__$1;
(statearr_113324_113406[(2)] = inst_113227);

(statearr_113324_113406[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113264 === (35))){
var inst_113259 = (state_113263[(2)]);
var state_113263__$1 = state_113263;
var statearr_113325_113407 = state_113263__$1;
(statearr_113325_113407[(2)] = inst_113259);


cljs.core.async.impl.ioc_helpers.process_exception(state_113263__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_113264 === (19))){
var inst_113147 = (state_113263[(14)]);
var inst_113120 = (state_113263[(9)]);
var inst_113152 = (state_113263[(12)]);
var inst_113147__$1 = (state_113263[(2)]);
var inst_113148 = cljs.core.cst$kw$recur.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_113149 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_113147__$1,inst_113120);
var inst_113150 = cljs.core.vals(inst_113149);
var inst_113151 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,inst_113150);
var inst_113152__$1 = (inst_113148 < inst_113151);
var state_113263__$1 = (function (){var statearr_113326 = state_113263;
(statearr_113326[(14)] = inst_113147__$1);

(statearr_113326[(12)] = inst_113152__$1);

return statearr_113326;
})();
if(cljs.core.truth_(inst_113152__$1)){
var statearr_113327_113408 = state_113263__$1;
(statearr_113327_113408[(1)] = (20));

} else {
var statearr_113328_113409 = state_113263__$1;
(statearr_113328_113409[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113264 === (57))){
var inst_113244 = (state_113263[(2)]);
var inst_113245 = fluree.db.util.async.throw_err(inst_113244);
var state_113263__$1 = (function (){var statearr_113329 = state_113263;
(statearr_113329[(11)] = inst_113245);

return statearr_113329;
})();
if(cljs.core.truth_(fuel)){
var statearr_113330_113410 = state_113263__$1;
(statearr_113330_113410[(1)] = (58));

} else {
var statearr_113331_113411 = state_113263__$1;
(statearr_113331_113411[(1)] = (59));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113264 === (11))){
var inst_113128 = (state_113263[(8)]);
var state_113263__$1 = state_113263;
var statearr_113332_113412 = state_113263__$1;
(statearr_113332_113412[(2)] = inst_113128);

(statearr_113332_113412[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113264 === (9))){
var inst_113116 = cljs.core.cst$kw$p.cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_113263__$1 = state_113263;
var statearr_113333_113413 = state_113263__$1;
(statearr_113333_113413[(2)] = inst_113116);

(statearr_113333_113413[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113264 === (5))){
var inst_113110 = (state_113263[(18)]);
var state_113263__$1 = state_113263;
var statearr_113334_113414 = state_113263__$1;
(statearr_113334_113414[(2)] = inst_113110);

(statearr_113334_113414[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113264 === (14))){
var inst_113120 = (state_113263[(9)]);
var inst_113135 = fluree.db.query.fql.get_recursion_map(db,recursion_map,select_spec,cache,inst_113120,f);
var state_113263__$1 = state_113263;
var statearr_113335_113415 = state_113263__$1;
(statearr_113335_113415[(2)] = inst_113135);

(statearr_113335_113415[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113264 === (45))){
var state_113263__$1 = state_113263;
var statearr_113336_113416 = state_113263__$1;
(statearr_113336_113416[(2)] = acc);

(statearr_113336_113416[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113264 === (53))){
var inst_113233 = (state_113263[(2)]);
var state_113263__$1 = state_113263;
if(cljs.core.truth_(inst_113233)){
var statearr_113337_113417 = state_113263__$1;
(statearr_113337_113417[(1)] = (54));

} else {
var statearr_113338_113418 = state_113263__$1;
(statearr_113338_113418[(1)] = (55));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113264 === (26))){
var inst_113164 = (state_113263[(15)]);
var inst_113166 = f.o;
var inst_113167 = fluree.db.query.fql.resolve_reverse_refs(db,cache,fuel,max_fuel,inst_113166,inst_113164);
var state_113263__$1 = state_113263;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_113263__$1,(29),inst_113167);
} else {
if((state_val_113264 === (16))){
var inst_113132 = (state_113263[(21)]);
var inst_113138 = (state_113263[(2)]);
var state_113263__$1 = (function (){var statearr_113339 = state_113263;
(statearr_113339[(24)] = inst_113138);

return statearr_113339;
})();
if(cljs.core.truth_(inst_113132)){
var statearr_113340_113419 = state_113263__$1;
(statearr_113340_113419[(1)] = (17));

} else {
var statearr_113341_113420 = state_113263__$1;
(statearr_113341_113420[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113264 === (38))){
var inst_113175 = (state_113263[(16)]);
var inst_113205 = (state_113263[(2)]);
var state_113263__$1 = (function (){var statearr_113342 = state_113263;
(statearr_113342[(17)] = inst_113205);

return statearr_113342;
})();
if(cljs.core.truth_(inst_113175)){
var statearr_113343_113421 = state_113263__$1;
(statearr_113343_113421[(1)] = (39));

} else {
var statearr_113344_113422 = state_113263__$1;
(statearr_113344_113422[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113264 === (30))){
var inst_113124 = (state_113263[(10)]);
var inst_113120 = (state_113263[(9)]);
var inst_113177 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_113124,inst_113120);
var inst_113178 = cljs.core.count(inst_113177);
var inst_113179 = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_113180 = (inst_113178 > inst_113179);
var state_113263__$1 = state_113263;
var statearr_113345_113423 = state_113263__$1;
(statearr_113345_113423[(2)] = inst_113180);

(statearr_113345_113423[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113264 === (10))){
var inst_113118 = (state_113263[(2)]);
var state_113263__$1 = state_113263;
var statearr_113346_113424 = state_113263__$1;
(statearr_113346_113424[(2)] = inst_113118);

(statearr_113346_113424[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113264 === (18))){
var inst_113108 = (state_113263[(7)]);
var inst_113138 = (state_113263[(24)]);
var inst_113120 = (state_113263[(9)]);
var inst_113141 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_113142 = [inst_113120,inst_113108];
var inst_113143 = (new cljs.core.PersistentVector(null,2,(5),inst_113141,inst_113142,null));
var inst_113144 = ((0) + (1));
var inst_113145 = cljs.core.assoc_in(inst_113138,inst_113143,inst_113144);
var state_113263__$1 = state_113263;
var statearr_113347_113425 = state_113263__$1;
(statearr_113347_113425[(2)] = inst_113145);

(statearr_113347_113425[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113264 === (52))){
var inst_113132 = (state_113263[(21)]);
var state_113263__$1 = state_113263;
var statearr_113348_113426 = state_113263__$1;
(statearr_113348_113426[(2)] = inst_113132);

(statearr_113348_113426[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113264 === (42))){
var inst_113212 = (state_113263[(20)]);
var state_113263__$1 = state_113263;
var statearr_113349_113427 = state_113263__$1;
(statearr_113349_113427[(2)] = inst_113212);

(statearr_113349_113427[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113264 === (37))){
var inst_113124 = (state_113263[(10)]);
var inst_113108 = (state_113263[(7)]);
var inst_113120 = (state_113263[(9)]);
var inst_113200 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_113201 = [inst_113120,cljs.core.cst$kw$_id];
var inst_113202 = (new cljs.core.PersistentVector(null,2,(5),inst_113200,inst_113201,null));
var inst_113203 = cljs.core.assoc_in(inst_113124,inst_113202,inst_113108);
var state_113263__$1 = state_113263;
var statearr_113350_113428 = state_113263__$1;
(statearr_113350_113428[(2)] = inst_113203);

(statearr_113350_113428[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113264 === (8))){
var inst_113113 = (state_113263[(23)]);
var state_113263__$1 = state_113263;
var statearr_113351_113429 = state_113263__$1;
(statearr_113351_113429[(2)] = inst_113113);

(statearr_113351_113429[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113264 === (49))){
var state_113263__$1 = state_113263;
var statearr_113352_113430 = state_113263__$1;
(statearr_113352_113430[(2)] = null);

(statearr_113352_113430[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flake__GT_recur_$_state_machine__100742__auto__ = null;
var fluree$db$query$fql$flake__GT_recur_$_state_machine__100742__auto____0 = (function (){
var statearr_113353 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_113353[(0)] = fluree$db$query$fql$flake__GT_recur_$_state_machine__100742__auto__);

(statearr_113353[(1)] = (1));

return statearr_113353;
});
var fluree$db$query$fql$flake__GT_recur_$_state_machine__100742__auto____1 = (function (state_113263){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_113263);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e113354){if((e113354 instanceof Object)){
var ex__100745__auto__ = e113354;
var statearr_113355_113431 = state_113263;
(statearr_113355_113431[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_113263);

return cljs.core.cst$kw$recur;
} else {
throw e113354;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__113432 = state_113263;
state_113263 = G__113432;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$query$fql$flake__GT_recur_$_state_machine__100742__auto__ = function(state_113263){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__100742__auto____1.call(this,state_113263);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flake__GT_recur_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flake__GT_recur_$_state_machine__100742__auto____0;
fluree$db$query$fql$flake__GT_recur_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flake__GT_recur_$_state_machine__100742__auto____1;
return fluree$db$query$fql$flake__GT_recur_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_113356 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_113356[(6)] = c__100848__auto__);

return statearr_113356;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql.flakes__GT_res = (function fluree$db$query$fql$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,flakes){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_113616){
var state_val_113617 = (state_113616[(1)]);
if((state_val_113617 === (7))){
var inst_113612 = (state_113616[(2)]);
var state_113616__$1 = state_113616;
var statearr_113618_113697 = state_113616__$1;
(statearr_113618_113697[(2)] = inst_113612);


cljs.core.async.impl.ioc_helpers.process_exception(state_113616__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_113617 === (20))){
var inst_113454 = (state_113616[(7)]);
var inst_113474 = cljs.core.first(flakes);
var inst_113475 = fluree.db.query.fql.s(inst_113474);
var inst_113476 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs(inst_113454);
var inst_113477 = fluree.db.query.fql.resolve_reverse_refs(db,cache,fuel,max_fuel,inst_113475,inst_113476);
var state_113616__$1 = state_113616;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_113616__$1,(23),inst_113477);
} else {
if((state_val_113617 === (27))){
var inst_113503 = (state_113616[(8)]);
var inst_113505 = (state_113616[(9)]);
var inst_113487 = (state_113616[(10)]);
var inst_113498 = (state_113616[(11)]);
var inst_113454 = (state_113616[(7)]);
var inst_113498__$1 = cljs.core.first(inst_113487);
var inst_113499 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_113500 = inst_113498__$1.p;
var inst_113501 = [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,inst_113500];
var inst_113502 = (new cljs.core.PersistentVector(null,3,(5),inst_113499,inst_113501,null));
var inst_113503__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_113454,inst_113502);
var inst_113504 = fluree.db.query.fql.component_follow_QMARK_(inst_113503__$1,inst_113454);
var inst_113505__$1 = cljs.core.cst$kw$multi_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_113503__$1);
var state_113616__$1 = (function (){var statearr_113619 = state_113616;
(statearr_113619[(12)] = inst_113504);

(statearr_113619[(8)] = inst_113503__$1);

(statearr_113619[(9)] = inst_113505__$1);

(statearr_113619[(11)] = inst_113498__$1);

return statearr_113619;
})();
if(cljs.core.truth_(inst_113505__$1)){
var statearr_113620_113698 = state_113616__$1;
(statearr_113620_113698[(1)] = (29));

} else {
var statearr_113621_113699 = state_113616__$1;
(statearr_113621_113699[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113617 === (1))){
var state_113616__$1 = state_113616;
var statearr_113622_113700 = state_113616__$1;
(statearr_113622_113700[(2)] = null);

(statearr_113622_113700[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113617 === (24))){
var inst_113487 = (state_113616[(10)]);
var inst_113492 = cljs.core.empty_QMARK_(inst_113487);
var state_113616__$1 = state_113616;
if(inst_113492){
var statearr_113623_113701 = state_113616__$1;
(statearr_113623_113701[(1)] = (26));

} else {
var statearr_113624_113702 = state_113616__$1;
(statearr_113624_113702[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113617 === (55))){
var state_113616__$1 = state_113616;
var statearr_113625_113703 = state_113616__$1;
(statearr_113625_113703[(2)] = null);

(statearr_113625_113703[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113617 === (39))){
var inst_113521 = (state_113616[(2)]);
var inst_113522 = fluree.db.util.async.throw_err(inst_113521);
var state_113616__$1 = state_113616;
var statearr_113626_113704 = state_113616__$1;
(statearr_113626_113704[(2)] = inst_113522);

(statearr_113626_113704[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113617 === (46))){
var inst_113579 = (state_113616[(2)]);
var state_113616__$1 = state_113616;
var statearr_113627_113705 = state_113616__$1;
(statearr_113627_113705[(2)] = inst_113579);

(statearr_113627_113705[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113617 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_113616,(3),Error,null,(2));
var inst_113437 = cljs.core.not_empty(flakes);
var state_113616__$1 = state_113616;
if(cljs.core.truth_(inst_113437)){
var statearr_113628_113706 = state_113616__$1;
(statearr_113628_113706[(1)] = (5));

} else {
var statearr_113629_113707 = state_113616__$1;
(statearr_113629_113707[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113617 === (54))){
var inst_113487 = (state_113616[(10)]);
var inst_113489 = (state_113616[(13)]);
var inst_113490 = (state_113616[(14)]);
var inst_113488 = (state_113616[(15)]);
var inst_113569 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_113570 = cljs.core.rest(inst_113487);
var inst_113571 = [inst_113488,inst_113570,inst_113489,inst_113490];
var inst_113572 = (new cljs.core.PersistentVector(null,4,(5),inst_113569,inst_113571,null));
var state_113616__$1 = state_113616;
var statearr_113630_113708 = state_113616__$1;
(statearr_113630_113708[(2)] = inst_113572);

(statearr_113630_113708[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113617 === (15))){
var inst_113454 = (state_113616[(7)]);
var inst_113458 = cljs.core.cst$kw$id_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_113454);
var state_113616__$1 = state_113616;
var statearr_113631_113709 = state_113616__$1;
(statearr_113631_113709[(2)] = inst_113458);

(statearr_113631_113709[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113617 === (48))){
var inst_113454 = (state_113616[(7)]);
var inst_113554 = cljs.core.cst$kw$id_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_113454);
var state_113616__$1 = state_113616;
var statearr_113632_113710 = state_113616__$1;
(statearr_113632_113710[(2)] = inst_113554);

(statearr_113632_113710[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113617 === (50))){
var inst_113557 = (state_113616[(2)]);
var state_113616__$1 = state_113616;
if(cljs.core.truth_(inst_113557)){
var statearr_113633_113711 = state_113616__$1;
(statearr_113633_113711[(1)] = (51));

} else {
var statearr_113634_113712 = state_113616__$1;
(statearr_113634_113712[(1)] = (52));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113617 === (21))){
var inst_113468 = (state_113616[(16)]);
var state_113616__$1 = state_113616;
var statearr_113635_113713 = state_113616__$1;
(statearr_113635_113713[(2)] = inst_113468);

(statearr_113635_113713[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113617 === (31))){
var inst_113510 = (state_113616[(2)]);
var state_113616__$1 = state_113616;
if(cljs.core.truth_(inst_113510)){
var statearr_113636_113714 = state_113616__$1;
(statearr_113636_113714[(1)] = (32));

} else {
var statearr_113637_113715 = state_113616__$1;
(statearr_113637_113715[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113617 === (32))){
var inst_113503 = (state_113616[(8)]);
var inst_113487 = (state_113616[(10)]);
var inst_113489 = (state_113616[(13)]);
var inst_113498 = (state_113616[(11)]);
var inst_113488 = (state_113616[(15)]);
var inst_113454 = (state_113616[(7)]);
var inst_113512 = fluree.db.query.fql.flake__GT_recur_multi(db,inst_113498,inst_113503,inst_113489,inst_113487,inst_113488,fuel,max_fuel,inst_113454,cache,fluree.db.query.fql.component_follow_QMARK_);
var state_113616__$1 = state_113616;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_113616__$1,(35),inst_113512);
} else {
if((state_val_113617 === (40))){
var inst_113504 = (state_113616[(12)]);
var inst_113503 = (state_113616[(8)]);
var inst_113498 = (state_113616[(11)]);
var inst_113490 = (state_113616[(14)]);
var inst_113488 = (state_113616[(15)]);
var inst_113528 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,inst_113488,inst_113503,inst_113498,inst_113504,false,inst_113490);
var state_113616__$1 = state_113616;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_113616__$1,(43),inst_113528);
} else {
if((state_val_113617 === (56))){
var inst_113575 = (state_113616[(2)]);
var state_113616__$1 = state_113616;
var statearr_113638_113716 = state_113616__$1;
(statearr_113638_113716[(2)] = inst_113575);

(statearr_113638_113716[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113617 === (33))){
var inst_113503 = (state_113616[(8)]);
var inst_113517 = cljs.core.cst$kw$recur.cljs$core$IFn$_invoke$arity$1(inst_113503);
var state_113616__$1 = state_113616;
if(cljs.core.truth_(inst_113517)){
var statearr_113639_113717 = state_113616__$1;
(statearr_113639_113717[(1)] = (36));

} else {
var statearr_113640_113718 = state_113616__$1;
(statearr_113640_113718[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113617 === (13))){
var inst_113455 = (state_113616[(17)]);
var inst_113454 = (state_113616[(7)]);
var inst_113454__$1 = (state_113616[(2)]);
var inst_113455__$1 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_113454__$1);
var state_113616__$1 = (function (){var statearr_113641 = state_113616;
(statearr_113641[(17)] = inst_113455__$1);

(statearr_113641[(7)] = inst_113454__$1);

return statearr_113641;
})();
if(cljs.core.truth_(inst_113455__$1)){
var statearr_113642_113719 = state_113616__$1;
(statearr_113642_113719[(1)] = (14));

} else {
var statearr_113643_113720 = state_113616__$1;
(statearr_113643_113720[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113617 === (22))){
var inst_113484 = (state_113616[(18)]);
var inst_113484__$1 = (state_113616[(2)]);
var inst_113485 = cljs.core.PersistentHashMap.EMPTY;
var inst_113486 = cljs.core.PersistentHashMap.EMPTY;
var inst_113487 = flakes;
var inst_113488 = inst_113484__$1;
var inst_113489 = inst_113485;
var inst_113490 = inst_113486;
var state_113616__$1 = (function (){var statearr_113644 = state_113616;
(statearr_113644[(10)] = inst_113487);

(statearr_113644[(13)] = inst_113489);

(statearr_113644[(14)] = inst_113490);

(statearr_113644[(15)] = inst_113488);

(statearr_113644[(18)] = inst_113484__$1);

return statearr_113644;
})();
var statearr_113645_113721 = state_113616__$1;
(statearr_113645_113721[(2)] = null);

(statearr_113645_113721[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113617 === (36))){
var inst_113503 = (state_113616[(8)]);
var inst_113487 = (state_113616[(10)]);
var inst_113489 = (state_113616[(13)]);
var inst_113498 = (state_113616[(11)]);
var inst_113488 = (state_113616[(15)]);
var inst_113454 = (state_113616[(7)]);
var inst_113519 = fluree.db.query.fql.flake__GT_recur(db,inst_113498,inst_113503,inst_113489,inst_113487,inst_113488,fuel,max_fuel,inst_113454,cache);
var state_113616__$1 = state_113616;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_113616__$1,(39),inst_113519);
} else {
if((state_val_113617 === (41))){
var inst_113454 = (state_113616[(7)]);
var inst_113539 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_113454);
var state_113616__$1 = state_113616;
if(cljs.core.truth_(inst_113539)){
var statearr_113646_113722 = state_113616__$1;
(statearr_113646_113722[(1)] = (44));

} else {
var statearr_113647_113723 = state_113616__$1;
(statearr_113647_113723[(1)] = (45));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113617 === (43))){
var inst_113487 = (state_113616[(10)]);
var inst_113489 = (state_113616[(13)]);
var inst_113530 = (state_113616[(2)]);
var inst_113531 = fluree.db.util.async.throw_err(inst_113530);
var inst_113532 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_113531,(0),null);
var inst_113533 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_113531,(1),null);
var inst_113534 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_113535 = cljs.core.rest(inst_113487);
var inst_113536 = [inst_113532,inst_113535,inst_113489,inst_113533];
var inst_113537 = (new cljs.core.PersistentVector(null,4,(5),inst_113534,inst_113536,null));
var state_113616__$1 = state_113616;
var statearr_113648_113724 = state_113616__$1;
(statearr_113648_113724[(2)] = inst_113537);

(statearr_113648_113724[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113617 === (29))){
var inst_113503 = (state_113616[(8)]);
var inst_113507 = cljs.core.cst$kw$recur.cljs$core$IFn$_invoke$arity$1(inst_113503);
var state_113616__$1 = state_113616;
var statearr_113649_113725 = state_113616__$1;
(statearr_113649_113725[(2)] = inst_113507);

(statearr_113649_113725[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113617 === (44))){
var inst_113504 = (state_113616[(12)]);
var inst_113498 = (state_113616[(11)]);
var inst_113488 = (state_113616[(15)]);
var inst_113454 = (state_113616[(7)]);
var inst_113541 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_113542 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9(db,cache,fuel,max_fuel,inst_113488,inst_113454,inst_113498,inst_113504,false);
var state_113616__$1 = (function (){var statearr_113650 = state_113616;
(statearr_113650[(19)] = inst_113541);

return statearr_113650;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_113616__$1,(47),inst_113542);
} else {
if((state_val_113617 === (6))){
var state_113616__$1 = state_113616;
var statearr_113651_113726 = state_113616__$1;
(statearr_113651_113726[(2)] = null);

(statearr_113651_113726[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113617 === (28))){
var inst_113594 = (state_113616[(2)]);
var state_113616__$1 = state_113616;
var statearr_113652_113727 = state_113616__$1;
(statearr_113652_113727[(2)] = inst_113594);

(statearr_113652_113727[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113617 === (51))){
var inst_113487 = (state_113616[(10)]);
var inst_113489 = (state_113616[(13)]);
var inst_113498 = (state_113616[(11)]);
var inst_113490 = (state_113616[(14)]);
var inst_113559 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_113560 = ["_id"];
var inst_113561 = inst_113498.s;
var inst_113562 = [inst_113561];
var inst_113563 = cljs.core.PersistentHashMap.fromArrays(inst_113560,inst_113562);
var inst_113564 = cljs.core.rest(inst_113487);
var inst_113565 = [inst_113563,inst_113564,inst_113489,inst_113490];
var inst_113566 = (new cljs.core.PersistentVector(null,4,(5),inst_113559,inst_113565,null));
var state_113616__$1 = state_113616;
var statearr_113653_113728 = state_113616__$1;
(statearr_113653_113728[(2)] = inst_113566);

(statearr_113653_113728[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113617 === (25))){
var inst_113448 = (state_113616[(20)]);
var inst_113468 = (state_113616[(16)]);
var inst_113454 = (state_113616[(7)]);
var inst_113484 = (state_113616[(18)]);
var inst_113596 = (state_113616[(2)]);
var inst_113597 = (function (){var top_level_subject = inst_113448;
var select_spec = inst_113454;
var base_acc = inst_113468;
var acc_PLUS_refs = inst_113484;
var result = inst_113596;
return (function (acc,spec){
if(cljs.core.truth_((function (){var or__4126__auto__ = (function (){var and__4115__auto__ = cljs.core.cst$kw$multi_QMARK_.cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var and__4115__auto__ = cljs.core.cst$kw$reverse_QMARK_.cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4115__auto__;
}
}
})())){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(spec),cljs.core.cst$kw$order.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec)),cljs.core.cst$kw$predicate.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec)),cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
})();
var inst_113598 = cljs.core.PersistentVector.EMPTY;
var inst_113599 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_113454);
var inst_113600 = cljs.core.cst$kw$pred_DASH_id.cljs$core$IFn$_invoke$arity$1(inst_113599);
var inst_113601 = cljs.core.vals(inst_113600);
var inst_113602 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_113454);
var inst_113603 = cljs.core.cst$kw$reverse.cljs$core$IFn$_invoke$arity$1(inst_113602);
var inst_113604 = cljs.core.vals(inst_113603);
var inst_113605 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_113601,inst_113604);
var inst_113606 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_113597,inst_113598,inst_113605);
var inst_113608 = (function (){var top_level_subject = inst_113448;
var select_spec = inst_113454;
var base_acc = inst_113468;
var acc_PLUS_refs = inst_113484;
var result = inst_113596;
var sort_preds = inst_113606;
return (function (acc,p__113607){
var vec__113654 = p__113607;
var selectPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__113654,(0),null);
var sortOrder = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__113654,(1),null);
var sortPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__113654,(2),null);
var limit = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__113654,(3),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,selectPred,fluree.db.query.fql.sort_offset_and_limit_res(sortPred,sortOrder,(0),limit,cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,selectPred)));
});
})();
var inst_113609 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_113608,inst_113596,inst_113606);
var state_113616__$1 = state_113616;
var statearr_113657_113729 = state_113616__$1;
(statearr_113657_113729[(2)] = inst_113609);

(statearr_113657_113729[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113617 === (34))){
var inst_113498 = (state_113616[(11)]);
var inst_113585 = (state_113616[(2)]);
var inst_113586 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_113585,(0),null);
var inst_113587 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_113585,(1),null);
var inst_113588 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_113585,(2),null);
var inst_113589 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_113585,(3),null);
var inst_113590 = inst_113498.s;
var inst_113591 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_113586,cljs.core.cst$kw$_id,inst_113590);
var inst_113487 = inst_113587;
var inst_113488 = inst_113591;
var inst_113489 = inst_113588;
var inst_113490 = inst_113589;
var state_113616__$1 = (function (){var statearr_113658 = state_113616;
(statearr_113658[(10)] = inst_113487);

(statearr_113658[(13)] = inst_113489);

(statearr_113658[(14)] = inst_113490);

(statearr_113658[(15)] = inst_113488);

return statearr_113658;
})();
var statearr_113659_113730 = state_113616__$1;
(statearr_113659_113730[(2)] = null);

(statearr_113659_113730[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113617 === (17))){
var inst_113448 = (state_113616[(20)]);
var inst_113462 = ["_id"];
var inst_113463 = [inst_113448];
var inst_113464 = cljs.core.PersistentHashMap.fromArrays(inst_113462,inst_113463);
var state_113616__$1 = state_113616;
var statearr_113660_113731 = state_113616__$1;
(statearr_113660_113731[(2)] = inst_113464);

(statearr_113660_113731[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113617 === (3))){
var inst_113433 = (state_113616[(2)]);
var state_113616__$1 = state_113616;
var statearr_113661_113732 = state_113616__$1;
(statearr_113661_113732[(2)] = inst_113433);


cljs.core.async.impl.ioc_helpers.process_exception(state_113616__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_113617 === (12))){
var state_113616__$1 = state_113616;
var statearr_113662_113733 = state_113616__$1;
(statearr_113662_113733[(2)] = base_select_spec);

(statearr_113662_113733[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113617 === (2))){
var inst_113614 = (state_113616[(2)]);
var state_113616__$1 = state_113616;
return cljs.core.async.impl.ioc_helpers.return_chan(state_113616__$1,inst_113614);
} else {
if((state_val_113617 === (23))){
var inst_113468 = (state_113616[(16)]);
var inst_113479 = (state_113616[(2)]);
var inst_113480 = fluree.db.util.async.throw_err(inst_113479);
var inst_113481 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_113468,inst_113480], 0));
var state_113616__$1 = state_113616;
var statearr_113663_113734 = state_113616__$1;
(statearr_113663_113734[(2)] = inst_113481);

(statearr_113663_113734[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113617 === (47))){
var inst_113541 = (state_113616[(19)]);
var inst_113487 = (state_113616[(10)]);
var inst_113489 = (state_113616[(13)]);
var inst_113490 = (state_113616[(14)]);
var inst_113544 = (state_113616[(2)]);
var inst_113545 = fluree.db.util.async.throw_err(inst_113544);
var inst_113546 = cljs.core.first(inst_113545);
var inst_113547 = cljs.core.rest(inst_113487);
var inst_113548 = [inst_113546,inst_113547,inst_113489,inst_113490];
var inst_113549 = (new cljs.core.PersistentVector(null,4,(5),inst_113541,inst_113548,null));
var state_113616__$1 = state_113616;
var statearr_113664_113735 = state_113616__$1;
(statearr_113664_113735[(2)] = inst_113549);

(statearr_113664_113735[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113617 === (35))){
var inst_113514 = (state_113616[(2)]);
var inst_113515 = fluree.db.util.async.throw_err(inst_113514);
var state_113616__$1 = state_113616;
var statearr_113665_113736 = state_113616__$1;
(statearr_113665_113736[(2)] = inst_113515);

(statearr_113665_113736[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113617 === (19))){
var inst_113454 = (state_113616[(7)]);
var inst_113468 = (state_113616[(2)]);
var inst_113469 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_113470 = [cljs.core.cst$kw$select,cljs.core.cst$kw$reverse];
var inst_113471 = (new cljs.core.PersistentVector(null,2,(5),inst_113469,inst_113470,null));
var inst_113472 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_113454,inst_113471);
var state_113616__$1 = (function (){var statearr_113666 = state_113616;
(statearr_113666[(16)] = inst_113468);

return statearr_113666;
})();
if(cljs.core.truth_(inst_113472)){
var statearr_113667_113737 = state_113616__$1;
(statearr_113667_113737[(1)] = (20));

} else {
var statearr_113668_113738 = state_113616__$1;
(statearr_113668_113738[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113617 === (11))){
var inst_113448 = (state_113616[(20)]);
var inst_113451 = fluree.db.query.fql.full_select_spec(db,cache,base_select_spec,inst_113448);
var state_113616__$1 = state_113616;
var statearr_113669_113739 = state_113616__$1;
(statearr_113669_113739[(2)] = inst_113451);

(statearr_113669_113739[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113617 === (9))){
var inst_113439 = (state_113616[(2)]);
var inst_113440 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_113439], 0));
var inst_113441 = (function(){throw inst_113439})();
var state_113616__$1 = (function (){var statearr_113670 = state_113616;
(statearr_113670[(21)] = inst_113440);

return statearr_113670;
})();
var statearr_113671_113740 = state_113616__$1;
(statearr_113671_113740[(2)] = inst_113441);


cljs.core.async.impl.ioc_helpers.process_exception(state_113616__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_113617 === (5))){
var state_113616__$1 = state_113616;
var statearr_113672_113741 = state_113616__$1;
(statearr_113672_113741[(2)] = null);

(statearr_113672_113741[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113617 === (14))){
var inst_113455 = (state_113616[(17)]);
var state_113616__$1 = state_113616;
var statearr_113673_113742 = state_113616__$1;
(statearr_113673_113742[(2)] = inst_113455);

(statearr_113673_113742[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113617 === (45))){
var inst_113454 = (state_113616[(7)]);
var inst_113551 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_113454);
var inst_113552 = cljs.core.empty_QMARK_(inst_113551);
var state_113616__$1 = state_113616;
if(inst_113552){
var statearr_113674_113743 = state_113616__$1;
(statearr_113674_113743[(1)] = (48));

} else {
var statearr_113675_113744 = state_113616__$1;
(statearr_113675_113744[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113617 === (53))){
var inst_113577 = (state_113616[(2)]);
var state_113616__$1 = state_113616;
var statearr_113676_113745 = state_113616__$1;
(statearr_113676_113745[(2)] = inst_113577);

(statearr_113676_113745[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113617 === (26))){
var inst_113488 = (state_113616[(15)]);
var state_113616__$1 = state_113616;
var statearr_113677_113746 = state_113616__$1;
(statearr_113677_113746[(2)] = inst_113488);

(statearr_113677_113746[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113617 === (16))){
var inst_113460 = (state_113616[(2)]);
var state_113616__$1 = state_113616;
if(cljs.core.truth_(inst_113460)){
var statearr_113678_113747 = state_113616__$1;
(statearr_113678_113747[(1)] = (17));

} else {
var statearr_113679_113748 = state_113616__$1;
(statearr_113679_113748[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113617 === (38))){
var inst_113583 = (state_113616[(2)]);
var state_113616__$1 = state_113616;
var statearr_113680_113749 = state_113616__$1;
(statearr_113680_113749[(2)] = inst_113583);

(statearr_113680_113749[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113617 === (30))){
var inst_113505 = (state_113616[(9)]);
var state_113616__$1 = state_113616;
var statearr_113681_113750 = state_113616__$1;
(statearr_113681_113750[(2)] = inst_113505);

(statearr_113681_113750[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113617 === (10))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_113616,(9),cljs.core.cst$kw$default,null,(8));
var inst_113445 = cljs.core.first(flakes);
var inst_113446 = fluree.db.query.fql.s(inst_113445);
var state_113616__$1 = state_113616;
var statearr_113682_113751 = state_113616__$1;
(statearr_113682_113751[(2)] = inst_113446);


cljs.core.async.impl.ioc_helpers.process_exception(state_113616__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_113617 === (18))){
var inst_113466 = cljs.core.PersistentHashMap.EMPTY;
var state_113616__$1 = state_113616;
var statearr_113683_113752 = state_113616__$1;
(statearr_113683_113752[(2)] = inst_113466);

(statearr_113683_113752[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113617 === (52))){
var state_113616__$1 = state_113616;
var statearr_113684_113753 = state_113616__$1;
(statearr_113684_113753[(1)] = (54));



return cljs.core.cst$kw$recur;
} else {
if((state_val_113617 === (42))){
var inst_113581 = (state_113616[(2)]);
var state_113616__$1 = state_113616;
var statearr_113686_113754 = state_113616__$1;
(statearr_113686_113754[(2)] = inst_113581);

(statearr_113686_113754[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113617 === (37))){
var inst_113503 = (state_113616[(8)]);
var state_113616__$1 = state_113616;
if(cljs.core.truth_(inst_113503)){
var statearr_113687_113755 = state_113616__$1;
(statearr_113687_113755[(1)] = (40));

} else {
var statearr_113688_113756 = state_113616__$1;
(statearr_113688_113756[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113617 === (8))){
var inst_113448 = (state_113616[(2)]);
var inst_113449 = fluree.db.query.fql.has_ns_lookups_QMARK_(base_select_spec);
var state_113616__$1 = (function (){var statearr_113689 = state_113616;
(statearr_113689[(20)] = inst_113448);

return statearr_113689;
})();
if(cljs.core.truth_(inst_113449)){
var statearr_113690_113757 = state_113616__$1;
(statearr_113690_113757[(1)] = (11));

} else {
var statearr_113691_113758 = state_113616__$1;
(statearr_113691_113758[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113617 === (49))){
var state_113616__$1 = state_113616;
var statearr_113692_113759 = state_113616__$1;
(statearr_113692_113759[(2)] = false);

(statearr_113692_113759[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flakes__GT_res_$_state_machine__100742__auto__ = null;
var fluree$db$query$fql$flakes__GT_res_$_state_machine__100742__auto____0 = (function (){
var statearr_113693 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_113693[(0)] = fluree$db$query$fql$flakes__GT_res_$_state_machine__100742__auto__);

(statearr_113693[(1)] = (1));

return statearr_113693;
});
var fluree$db$query$fql$flakes__GT_res_$_state_machine__100742__auto____1 = (function (state_113616){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_113616);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e113694){if((e113694 instanceof Object)){
var ex__100745__auto__ = e113694;
var statearr_113695_113760 = state_113616;
(statearr_113695_113760[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_113616);

return cljs.core.cst$kw$recur;
} else {
throw e113694;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__113761 = state_113616;
state_113616 = G__113761;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$query$fql$flakes__GT_res_$_state_machine__100742__auto__ = function(state_113616){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__100742__auto____1.call(this,state_113616);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flakes__GT_res_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flakes__GT_res_$_state_machine__100742__auto____0;
fluree$db$query$fql$flakes__GT_res_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flakes__GT_res_$_state_machine__100742__auto____1;
return fluree$db$query$fql$flakes__GT_res_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_113696 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_113696[(6)] = c__100848__auto__);

return statearr_113696;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
/**
 * Runs a select statement based on a sequence of flakes.
 */
fluree.db.query.fql.flake_select = (function fluree$db$query$fql$flake_select(var_args){
var G__113764 = arguments.length;
switch (G__113764) {
case 6:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,flakes){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,null,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,limit,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit,offset){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_113803){
var state_val_113804 = (state_113803[(1)]);
if((state_val_113804 === (7))){
var inst_113776 = (state_113803[(2)]);
var state_113803__$1 = (function (){var statearr_113805 = state_113803;
(statearr_113805[(7)] = inst_113776);

return statearr_113805;
})();
if(cljs.core.truth_(offset)){
var statearr_113806_113828 = state_113803__$1;
(statearr_113806_113828[(1)] = (8));

} else {
var statearr_113807_113829 = state_113803__$1;
(statearr_113807_113829[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113804 === (1))){
var state_113803__$1 = state_113803;
var statearr_113808_113830 = state_113803__$1;
(statearr_113808_113830[(2)] = null);

(statearr_113808_113830[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113804 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_113803,(3),Error,null,(2));
var inst_113770 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_113803__$1 = (function (){var statearr_113809 = state_113803;
(statearr_113809[(8)] = inst_113770);

return statearr_113809;
})();
if(cljs.core.truth_(fuel)){
var statearr_113810_113831 = state_113803__$1;
(statearr_113810_113831[(1)] = (5));

} else {
var statearr_113811_113832 = state_113803__$1;
(statearr_113811_113832[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113804 === (13))){
var inst_113788 = (state_113803[(2)]);
var inst_113789 = (function (){return (function (x){
var and__4115__auto__ = max_fuel;
if(cljs.core.truth_(and__4115__auto__)){
return (cljs.core.deref(fuel) >= max_fuel);
} else {
return and__4115__auto__;
}
});
})();
var inst_113790 = cljs.core.halt_when.cljs$core$IFn$_invoke$arity$1(inst_113789);
var inst_113791 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_113788,inst_113790);
var inst_113792 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_113791,flakes);
var inst_113793 = cljs.core.PersistentVector.EMPTY;
var inst_113794 = (function (){var xf = inst_113791;
var flakes_by_sub = inst_113792;
return (function (p1__113762_SHARP_){
return fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,p1__113762_SHARP_);
});
})();
var inst_113795 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_113794,inst_113792);
var inst_113796 = fluree.db.util.async.merge_into_QMARK_(inst_113793,inst_113795);
var state_113803__$1 = state_113803;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_113803__$1,(14),inst_113796);
} else {
if((state_val_113804 === (6))){
var inst_113770 = (state_113803[(8)]);
var state_113803__$1 = state_113803;
var statearr_113812_113833 = state_113803__$1;
(statearr_113812_113833[(2)] = inst_113770);

(statearr_113812_113833[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113804 === (3))){
var inst_113765 = (state_113803[(2)]);
var state_113803__$1 = state_113803;
var statearr_113813_113834 = state_113803__$1;
(statearr_113813_113834[(2)] = inst_113765);


cljs.core.async.impl.ioc_helpers.process_exception(state_113803__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_113804 === (12))){
var inst_113782 = (state_113803[(9)]);
var state_113803__$1 = state_113803;
var statearr_113814_113835 = state_113803__$1;
(statearr_113814_113835[(2)] = inst_113782);

(statearr_113814_113835[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113804 === (2))){
var inst_113801 = (state_113803[(2)]);
var state_113803__$1 = state_113803;
return cljs.core.async.impl.ioc_helpers.return_chan(state_113803__$1,inst_113801);
} else {
if((state_val_113804 === (11))){
var inst_113782 = (state_113803[(9)]);
var inst_113784 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(limit);
var inst_113785 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_113782,inst_113784);
var state_113803__$1 = state_113803;
var statearr_113815_113836 = state_113803__$1;
(statearr_113815_113836[(2)] = inst_113785);

(statearr_113815_113836[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113804 === (9))){
var inst_113776 = (state_113803[(7)]);
var state_113803__$1 = state_113803;
var statearr_113816_113837 = state_113803__$1;
(statearr_113816_113837[(2)] = inst_113776);

(statearr_113816_113837[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113804 === (5))){
var inst_113770 = (state_113803[(8)]);
var inst_113772 = fluree.db.query.fql.fuel_flakes_transducer(fuel,max_fuel);
var inst_113773 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_113770,inst_113772);
var state_113803__$1 = state_113803;
var statearr_113817_113838 = state_113803__$1;
(statearr_113817_113838[(2)] = inst_113773);

(statearr_113817_113838[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113804 === (14))){
var inst_113798 = (state_113803[(2)]);
var inst_113799 = fluree.db.util.async.throw_err(inst_113798);
var state_113803__$1 = state_113803;
var statearr_113818_113839 = state_113803__$1;
(statearr_113818_113839[(2)] = inst_113799);


cljs.core.async.impl.ioc_helpers.process_exception(state_113803__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_113804 === (10))){
var inst_113782 = (state_113803[(2)]);
var state_113803__$1 = (function (){var statearr_113819 = state_113803;
(statearr_113819[(9)] = inst_113782);

return statearr_113819;
})();
if(cljs.core.truth_(limit)){
var statearr_113820_113840 = state_113803__$1;
(statearr_113820_113840[(1)] = (11));

} else {
var statearr_113821_113841 = state_113803__$1;
(statearr_113821_113841[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113804 === (8))){
var inst_113776 = (state_113803[(7)]);
var inst_113778 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(offset);
var inst_113779 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_113776,inst_113778);
var state_113803__$1 = state_113803;
var statearr_113822_113842 = state_113803__$1;
(statearr_113822_113842[(2)] = inst_113779);

(statearr_113822_113842[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__100742__auto__ = null;
var fluree$db$query$fql$state_machine__100742__auto____0 = (function (){
var statearr_113823 = [null,null,null,null,null,null,null,null,null,null];
(statearr_113823[(0)] = fluree$db$query$fql$state_machine__100742__auto__);

(statearr_113823[(1)] = (1));

return statearr_113823;
});
var fluree$db$query$fql$state_machine__100742__auto____1 = (function (state_113803){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_113803);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e113824){if((e113824 instanceof Object)){
var ex__100745__auto__ = e113824;
var statearr_113825_113843 = state_113803;
(statearr_113825_113843[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_113803);

return cljs.core.cst$kw$recur;
} else {
throw e113824;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__113844 = state_113803;
state_113803 = G__113844;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__100742__auto__ = function(state_113803){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__100742__auto____1.call(this,state_113803);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__100742__auto____0;
fluree$db$query$fql$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__100742__auto____1;
return fluree$db$query$fql$state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_113826 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_113826[(6)] = c__100848__auto__);

return statearr_113826;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
}));

(fluree.db.query.fql.flake_select.cljs$lang$maxFixedArity = 8);

/**
 * Like flake select, but takes a collection of subject ids which we
 *   then find collections of flakes for.
 */
fluree.db.query.fql.subject_select = (function fluree$db$query$fql$subject_select(var_args){
var G__113846 = arguments.length;
switch (G__113846) {
case 6:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,subjects){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,null,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,limit,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit,offset){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_113924){
var state_val_113925 = (state_113924[(1)]);
if((state_val_113925 === (7))){
var inst_113872 = (state_113924[(7)]);
var state_113924__$1 = state_113924;
var statearr_113926_113966 = state_113924__$1;
(statearr_113926_113966[(2)] = inst_113872);

(statearr_113926_113966[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113925 === (20))){
var state_113924__$1 = state_113924;
var statearr_113927_113967 = state_113924__$1;
(statearr_113927_113967[(1)] = (22));



return cljs.core.cst$kw$recur;
} else {
if((state_val_113925 === (1))){
var state_113924__$1 = state_113924;
var statearr_113929_113968 = state_113924__$1;
(statearr_113929_113968[(2)] = null);

(statearr_113929_113968[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113925 === (24))){
var inst_113914 = (state_113924[(2)]);
var state_113924__$1 = state_113924;
var statearr_113930_113969 = state_113924__$1;
(statearr_113930_113969[(2)] = inst_113914);

(statearr_113930_113969[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113925 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_113924,(3),Error,null,(2));
var inst_113858 = cljs.core.seq(subjects);
var inst_113859 = cljs.core.first(inst_113858);
var inst_113860 = cljs.core.next(inst_113858);
var inst_113861 = cljs.core.PersistentVector.EMPTY;
var inst_113862 = subjects;
var inst_113863 = (0);
var inst_113864 = inst_113861;
var state_113924__$1 = (function (){var statearr_113931 = state_113924;
(statearr_113931[(8)] = inst_113864);

(statearr_113931[(9)] = inst_113859);

(statearr_113931[(10)] = inst_113863);

(statearr_113931[(11)] = inst_113862);

(statearr_113931[(12)] = inst_113860);

return statearr_113931;
})();
var statearr_113932_113970 = state_113924__$1;
(statearr_113932_113970[(2)] = null);

(statearr_113932_113970[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113925 === (15))){
var inst_113918 = (state_113924[(2)]);
var state_113924__$1 = state_113924;
var statearr_113933_113971 = state_113924__$1;
(statearr_113933_113971[(2)] = inst_113918);

(statearr_113933_113971[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113925 === (21))){
var inst_113916 = (state_113924[(2)]);
var state_113924__$1 = state_113924;
var statearr_113934_113972 = state_113924__$1;
(statearr_113934_113972[(2)] = inst_113916);

(statearr_113934_113972[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113925 === (13))){
var inst_113864 = (state_113924[(8)]);
var state_113924__$1 = state_113924;
var statearr_113935_113973 = state_113924__$1;
(statearr_113935_113973[(2)] = inst_113864);

(statearr_113935_113973[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113925 === (22))){
var inst_113864 = (state_113924[(8)]);
var inst_113859 = (state_113924[(9)]);
var inst_113863 = (state_113924[(10)]);
var inst_113862 = (state_113924[(11)]);
var inst_113860 = (state_113924[(12)]);
var inst_113870 = (state_113924[(13)]);
var inst_113871 = (state_113924[(14)]);
var inst_113894 = (inst_113863 + (1));
var inst_113895 = (function (){var first__113857 = inst_113859;
var r = inst_113871;
var vec__113855 = subjects;
var vec__113866 = inst_113862;
var seq__113867 = inst_113871;
var acc = inst_113864;
var n = inst_113863;
var s = inst_113870;
var first__113868 = inst_113870;
var G__113854 = inst_113862;
var seq__113856 = inst_113860;
return (function (n__$1){
return fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,n__$1);
});
})();
var inst_113896 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_113897 = [inst_113870];
var inst_113898 = (new cljs.core.PersistentVector(null,1,(5),inst_113896,inst_113897,null));
var inst_113899 = [cljs.core.cst$kw$limit];
var inst_113900 = [limit];
var inst_113901 = cljs.core.PersistentHashMap.fromArrays(inst_113899,inst_113900);
var inst_113902 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_113898,inst_113901);
var state_113924__$1 = (function (){var statearr_113936 = state_113924;
(statearr_113936[(15)] = inst_113895);

(statearr_113936[(16)] = inst_113894);

return statearr_113936;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_113924__$1,(26),inst_113902);
} else {
if((state_val_113925 === (6))){
var inst_113920 = (state_113924[(2)]);
var state_113924__$1 = state_113924;
var statearr_113937_113974 = state_113924__$1;
(statearr_113937_113974[(2)] = inst_113920);


cljs.core.async.impl.ioc_helpers.process_exception(state_113924__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_113925 === (25))){
var inst_113864 = (state_113924[(8)]);
var inst_113894 = (state_113924[(16)]);
var inst_113871 = (state_113924[(14)]);
var inst_113908 = (state_113924[(2)]);
var inst_113909 = fluree.db.util.async.throw_err(inst_113908);
var inst_113910 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_113864,inst_113909);
var inst_113862 = inst_113871;
var inst_113863 = inst_113894;
var inst_113864__$1 = inst_113910;
var state_113924__$1 = (function (){var statearr_113938 = state_113924;
(statearr_113938[(8)] = inst_113864__$1);

(statearr_113938[(10)] = inst_113863);

(statearr_113938[(11)] = inst_113862);

return statearr_113938;
})();
var statearr_113939_113975 = state_113924__$1;
(statearr_113939_113975[(2)] = null);

(statearr_113939_113975[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113925 === (17))){
var state_113924__$1 = state_113924;
var statearr_113940_113976 = state_113924__$1;
(statearr_113940_113976[(2)] = offset);

(statearr_113940_113976[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113925 === (3))){
var inst_113847 = (state_113924[(2)]);
var state_113924__$1 = state_113924;
var statearr_113941_113977 = state_113924__$1;
(statearr_113941_113977[(2)] = inst_113847);


cljs.core.async.impl.ioc_helpers.process_exception(state_113924__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_113925 === (12))){
var inst_113879 = (state_113924[(2)]);
var state_113924__$1 = state_113924;
var statearr_113942_113978 = state_113924__$1;
(statearr_113942_113978[(2)] = inst_113879);

(statearr_113942_113978[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113925 === (2))){
var inst_113922 = (state_113924[(2)]);
var state_113924__$1 = state_113924;
return cljs.core.async.impl.ioc_helpers.return_chan(state_113924__$1,inst_113922);
} else {
if((state_val_113925 === (23))){
var state_113924__$1 = state_113924;
var statearr_113944_113979 = state_113924__$1;
(statearr_113944_113979[(2)] = null);

(statearr_113944_113979[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113925 === (19))){
var inst_113864 = (state_113924[(8)]);
var inst_113863 = (state_113924[(10)]);
var inst_113871 = (state_113924[(14)]);
var inst_113890 = (inst_113863 + (1));
var tmp113943 = inst_113864;
var inst_113862 = inst_113871;
var inst_113863__$1 = inst_113890;
var inst_113864__$1 = tmp113943;
var state_113924__$1 = (function (){var statearr_113945 = state_113924;
(statearr_113945[(8)] = inst_113864__$1);

(statearr_113945[(10)] = inst_113863__$1);

(statearr_113945[(11)] = inst_113862);

return statearr_113945;
})();
var statearr_113946_113980 = state_113924__$1;
(statearr_113946_113980[(2)] = null);

(statearr_113946_113980[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113925 === (11))){
var state_113924__$1 = state_113924;
var statearr_113947_113981 = state_113924__$1;
(statearr_113947_113981[(2)] = limit);

(statearr_113947_113981[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113925 === (9))){
var inst_113881 = (state_113924[(2)]);
var state_113924__$1 = state_113924;
if(cljs.core.truth_(inst_113881)){
var statearr_113948_113982 = state_113924__$1;
(statearr_113948_113982[(1)] = (13));

} else {
var statearr_113949_113983 = state_113924__$1;
(statearr_113949_113983[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113925 === (5))){
var inst_113862 = (state_113924[(11)]);
var inst_113872 = (state_113924[(7)]);
var inst_113870 = (state_113924[(13)]);
var inst_113869 = cljs.core.seq(inst_113862);
var inst_113870__$1 = cljs.core.first(inst_113869);
var inst_113871 = cljs.core.next(inst_113869);
var inst_113872__$1 = (inst_113870__$1 == null);
var state_113924__$1 = (function (){var statearr_113950 = state_113924;
(statearr_113950[(7)] = inst_113872__$1);

(statearr_113950[(13)] = inst_113870__$1);

(statearr_113950[(14)] = inst_113871);

return statearr_113950;
})();
if(cljs.core.truth_(inst_113872__$1)){
var statearr_113951_113984 = state_113924__$1;
(statearr_113951_113984[(1)] = (7));

} else {
var statearr_113952_113985 = state_113924__$1;
(statearr_113952_113985[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113925 === (14))){
var state_113924__$1 = state_113924;
if(cljs.core.truth_(offset)){
var statearr_113953_113986 = state_113924__$1;
(statearr_113953_113986[(1)] = (16));

} else {
var statearr_113954_113987 = state_113924__$1;
(statearr_113954_113987[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113925 === (26))){
var inst_113895 = (state_113924[(15)]);
var inst_113904 = (state_113924[(2)]);
var inst_113905 = fluree.db.util.async.throw_err(inst_113904);
var inst_113906 = (inst_113895.cljs$core$IFn$_invoke$arity$1 ? inst_113895.cljs$core$IFn$_invoke$arity$1(inst_113905) : inst_113895.call(null,inst_113905));
var state_113924__$1 = state_113924;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_113924__$1,(25),inst_113906);
} else {
if((state_val_113925 === (16))){
var inst_113863 = (state_113924[(10)]);
var inst_113885 = (inst_113863 < offset);
var state_113924__$1 = state_113924;
var statearr_113955_113988 = state_113924__$1;
(statearr_113955_113988[(2)] = inst_113885);

(statearr_113955_113988[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113925 === (10))){
var inst_113863 = (state_113924[(10)]);
var inst_113876 = (inst_113863 > limit);
var state_113924__$1 = state_113924;
var statearr_113956_113989 = state_113924__$1;
(statearr_113956_113989[(2)] = inst_113876);

(statearr_113956_113989[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113925 === (18))){
var inst_113888 = (state_113924[(2)]);
var state_113924__$1 = state_113924;
if(cljs.core.truth_(inst_113888)){
var statearr_113957_113990 = state_113924__$1;
(statearr_113957_113990[(1)] = (19));

} else {
var statearr_113958_113991 = state_113924__$1;
(statearr_113958_113991[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113925 === (8))){
var state_113924__$1 = state_113924;
if(cljs.core.truth_(limit)){
var statearr_113959_113992 = state_113924__$1;
(statearr_113959_113992[(1)] = (10));

} else {
var statearr_113960_113993 = state_113924__$1;
(statearr_113960_113993[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__100742__auto__ = null;
var fluree$db$query$fql$state_machine__100742__auto____0 = (function (){
var statearr_113961 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_113961[(0)] = fluree$db$query$fql$state_machine__100742__auto__);

(statearr_113961[(1)] = (1));

return statearr_113961;
});
var fluree$db$query$fql$state_machine__100742__auto____1 = (function (state_113924){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_113924);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e113962){if((e113962 instanceof Object)){
var ex__100745__auto__ = e113962;
var statearr_113963_113994 = state_113924;
(statearr_113963_113994[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_113924);

return cljs.core.cst$kw$recur;
} else {
throw e113962;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__113995 = state_113924;
state_113924 = G__113995;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__100742__auto__ = function(state_113924){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__100742__auto____1.call(this,state_113924);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__100742__auto____0;
fluree$db$query$fql$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__100742__auto____1;
return fluree$db$query$fql$state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_113964 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_113964[(6)] = c__100848__auto__);

return statearr_113964;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
}));

(fluree.db.query.fql.subject_select.cljs$lang$maxFixedArity = 8);

fluree.db.query.fql.valid_where_predicate_QMARK_ = (function fluree$db$query$fql$valid_where_predicate_QMARK_(db,p){
var or__4126__auto__ = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$idx_QMARK_,p);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$ref_QMARK_,p);
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$tag,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$type,p));
}
}
});
/**
 * Takes a where clause and returns subjects that match.
 */
fluree.db.query.fql.where_filter = (function fluree$db$query$fql$where_filter(var_args){
var G__113997 = arguments.length;
switch (G__113997) {
case 2:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2 = (function (db,where_clause){
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3(db,where_clause,null);
}));

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3 = (function (db,where_clause,default_collection){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_114181){
var state_val_114182 = (state_114181[(1)]);
if((state_val_114182 === (7))){
var inst_114177 = (state_114181[(2)]);
var state_114181__$1 = state_114181;
var statearr_114183_114247 = state_114181__$1;
(statearr_114183_114247[(2)] = inst_114177);


cljs.core.async.impl.ioc_helpers.process_exception(state_114181__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_114182 === (20))){
var inst_114066 = (state_114181[(7)]);
var inst_114075 = (state_114181[(2)]);
var inst_114076 = fluree.db.util.async.throw_err(inst_114075);
var inst_114077 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_114066,inst_114076);
var state_114181__$1 = state_114181;
var statearr_114184_114248 = state_114181__$1;
(statearr_114184_114248[(2)] = inst_114077);

(statearr_114184_114248[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114182 === (27))){
var inst_114149 = (state_114181[(2)]);
var state_114181__$1 = state_114181;
var statearr_114185_114249 = state_114181__$1;
(statearr_114185_114249[(2)] = inst_114149);

(statearr_114185_114249[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114182 === (1))){
var state_114181__$1 = state_114181;
var statearr_114186_114250 = state_114181__$1;
(statearr_114186_114250[(2)] = null);

(statearr_114186_114250[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114182 === (24))){
var inst_114086 = (state_114181[(2)]);
var inst_114087 = fluree.db.util.async.throw_err(inst_114086);
var state_114181__$1 = state_114181;
var statearr_114187_114251 = state_114181__$1;
(statearr_114187_114251[(2)] = inst_114087);

(statearr_114187_114251[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114182 === (39))){
var inst_114143 = (state_114181[(2)]);
var state_114181__$1 = state_114181;
var statearr_114188_114252 = state_114181__$1;
(statearr_114188_114252[(2)] = inst_114143);

(statearr_114188_114252[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114182 === (46))){
var inst_114170 = (state_114181[(2)]);
var state_114181__$1 = state_114181;
var statearr_114189_114253 = state_114181__$1;
(statearr_114189_114253[(2)] = inst_114170);

(statearr_114189_114253[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114182 === (4))){
var inst_114007 = (state_114181[(8)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_114181,(3),Error,null,(2));
var inst_114005 = fluree.db.query.fql_parser.parse_where.cljs$core$IFn$_invoke$arity$3(db,where_clause,default_collection);
var inst_114006 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_114005,(0),null);
var inst_114007__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_114005,(1),null);
var inst_114008 = cljs.core.not_empty(inst_114007__$1);
var state_114181__$1 = (function (){var statearr_114190 = state_114181;
(statearr_114190[(8)] = inst_114007__$1);

(statearr_114190[(9)] = inst_114006);

return statearr_114190;
})();
if(cljs.core.truth_(inst_114008)){
var statearr_114191_114254 = state_114181__$1;
(statearr_114191_114254[(1)] = (5));

} else {
var statearr_114192_114255 = state_114181__$1;
(statearr_114192_114255[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114182 === (15))){
var inst_114037 = (state_114181[(10)]);
var inst_114051 = (state_114181[(2)]);
var inst_114055 = (cljs.core.not_EQ_ === inst_114037);
var state_114181__$1 = (function (){var statearr_114193 = state_114181;
(statearr_114193[(11)] = inst_114051);

return statearr_114193;
})();
if(inst_114055){
var statearr_114194_114256 = state_114181__$1;
(statearr_114194_114256[(1)] = (16));

} else {
var statearr_114195_114257 = state_114181__$1;
(statearr_114195_114257[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114182 === (21))){
var inst_114036 = (state_114181[(12)]);
var inst_114038 = (state_114181[(13)]);
var inst_114081 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114082 = [inst_114036,inst_114038];
var inst_114083 = (new cljs.core.PersistentVector(null,2,(5),inst_114081,inst_114082,null));
var inst_114084 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$post,cljs.core._EQ_,inst_114083);
var state_114181__$1 = state_114181;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_114181__$1,(24),inst_114084);
} else {
if((state_val_114182 === (31))){
var inst_114147 = (state_114181[(2)]);
var state_114181__$1 = state_114181;
var statearr_114196_114258 = state_114181__$1;
(statearr_114196_114258[(2)] = inst_114147);

(statearr_114196_114258[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114182 === (32))){
var inst_114112 = (state_114181[(2)]);
var inst_114113 = fluree.db.util.async.throw_err(inst_114112);
var state_114181__$1 = state_114181;
var statearr_114197_114259 = state_114181__$1;
(statearr_114197_114259[(2)] = inst_114113);

(statearr_114197_114259[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114182 === (40))){
var inst_114138 = (state_114181[(2)]);
var inst_114139 = fluree.db.util.async.throw_err(inst_114138);
var state_114181__$1 = state_114181;
var statearr_114198_114260 = state_114181__$1;
(statearr_114198_114260[(2)] = inst_114139);

(statearr_114198_114260[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114182 === (33))){
var inst_114036 = (state_114181[(12)]);
var inst_114038 = (state_114181[(13)]);
var inst_114117 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114118 = [inst_114036];
var inst_114119 = (new cljs.core.PersistentVector(null,1,(5),inst_114117,inst_114118,null));
var inst_114120 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114121 = [inst_114036,inst_114038];
var inst_114122 = (new cljs.core.PersistentVector(null,2,(5),inst_114120,inst_114121,null));
var inst_114123 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_114119,cljs.core._LT_,inst_114122);
var state_114181__$1 = state_114181;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_114181__$1,(36),inst_114123);
} else {
if((state_val_114182 === (13))){
var inst_114036 = (state_114181[(12)]);
var inst_114042 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,inst_114036);
var inst_114043 = ["Non-indexed predicates are not valid in where clause statements. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_114042)].join('');
var inst_114044 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_114045 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_114046 = cljs.core.PersistentHashMap.fromArrays(inst_114044,inst_114045);
var inst_114047 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_114043,inst_114046);
var inst_114048 = (function(){throw inst_114047})();
var state_114181__$1 = state_114181;
var statearr_114199_114261 = state_114181__$1;
(statearr_114199_114261[(2)] = inst_114048);

(statearr_114199_114261[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114182 === (22))){
var inst_114037 = (state_114181[(10)]);
var inst_114089 = (cljs.core._GT_ === inst_114037);
var state_114181__$1 = state_114181;
if(inst_114089){
var statearr_114200_114262 = state_114181__$1;
(statearr_114200_114262[(1)] = (25));

} else {
var statearr_114201_114263 = state_114181__$1;
(statearr_114201_114263[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114182 === (36))){
var inst_114125 = (state_114181[(2)]);
var inst_114126 = fluree.db.util.async.throw_err(inst_114125);
var state_114181__$1 = state_114181;
var statearr_114202_114264 = state_114181__$1;
(statearr_114202_114264[(2)] = inst_114126);

(statearr_114202_114264[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114182 === (41))){
var inst_114006 = (state_114181[(9)]);
var inst_114162 = (state_114181[(14)]);
var inst_114162__$1 = (state_114181[(2)]);
var inst_114163 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$and,inst_114006);
var inst_114164 = cljs.core.empty_QMARK_(inst_114162__$1);
var inst_114165 = ((inst_114163) && (inst_114164));
var state_114181__$1 = (function (){var statearr_114203 = state_114181;
(statearr_114203[(14)] = inst_114162__$1);

return statearr_114203;
})();
if(cljs.core.truth_(inst_114165)){
var statearr_114204_114265 = state_114181__$1;
(statearr_114204_114265[(1)] = (44));

} else {
var statearr_114205_114266 = state_114181__$1;
(statearr_114205_114266[(1)] = (45));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114182 === (43))){
var inst_114154 = (state_114181[(15)]);
var inst_114022 = (state_114181[(16)]);
var inst_114157 = cljs.core.PersistentHashSet.EMPTY;
var inst_114158 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_114157,inst_114154);
var inst_114159 = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(inst_114022,inst_114158);
var state_114181__$1 = state_114181;
var statearr_114206_114267 = state_114181__$1;
(statearr_114206_114267[(2)] = inst_114159);

(statearr_114206_114267[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114182 === (29))){
var inst_114036 = (state_114181[(12)]);
var inst_114038 = (state_114181[(13)]);
var inst_114104 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114105 = [inst_114036,inst_114038];
var inst_114106 = (new cljs.core.PersistentVector(null,2,(5),inst_114104,inst_114105,null));
var inst_114107 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114108 = [inst_114036];
var inst_114109 = (new cljs.core.PersistentVector(null,1,(5),inst_114107,inst_114108,null));
var inst_114110 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_114106,cljs.core._LT__EQ_,inst_114109);
var state_114181__$1 = state_114181;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_114181__$1,(32),inst_114110);
} else {
if((state_val_114182 === (44))){
var inst_114162 = (state_114181[(14)]);
var state_114181__$1 = state_114181;
var statearr_114207_114268 = state_114181__$1;
(statearr_114207_114268[(2)] = inst_114162);

(statearr_114207_114268[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114182 === (6))){
var state_114181__$1 = state_114181;
var statearr_114208_114269 = state_114181__$1;
(statearr_114208_114269[(2)] = null);

(statearr_114208_114269[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114182 === (28))){
var inst_114099 = (state_114181[(2)]);
var inst_114100 = fluree.db.util.async.throw_err(inst_114099);
var state_114181__$1 = state_114181;
var statearr_114209_114270 = state_114181__$1;
(statearr_114209_114270[(2)] = inst_114100);

(statearr_114209_114270[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114182 === (25))){
var inst_114036 = (state_114181[(12)]);
var inst_114038 = (state_114181[(13)]);
var inst_114091 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114092 = [inst_114036,inst_114038];
var inst_114093 = (new cljs.core.PersistentVector(null,2,(5),inst_114091,inst_114092,null));
var inst_114094 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114095 = [inst_114036];
var inst_114096 = (new cljs.core.PersistentVector(null,1,(5),inst_114094,inst_114095,null));
var inst_114097 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT_,inst_114093,cljs.core._LT__EQ_,inst_114096);
var state_114181__$1 = state_114181;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_114181__$1,(28),inst_114097);
} else {
if((state_val_114182 === (34))){
var inst_114037 = (state_114181[(10)]);
var inst_114128 = (cljs.core._LT__EQ_ === inst_114037);
var state_114181__$1 = state_114181;
if(inst_114128){
var statearr_114210_114271 = state_114181__$1;
(statearr_114210_114271[(1)] = (37));

} else {
var statearr_114211_114272 = state_114181__$1;
(statearr_114211_114272[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114182 === (17))){
var inst_114037 = (state_114181[(10)]);
var inst_114079 = (cljs.core._EQ_ === inst_114037);
var state_114181__$1 = state_114181;
if(inst_114079){
var statearr_114212_114273 = state_114181__$1;
(statearr_114212_114273[(1)] = (21));

} else {
var statearr_114213_114274 = state_114181__$1;
(statearr_114213_114274[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114182 === (3))){
var inst_113998 = (state_114181[(2)]);
var state_114181__$1 = state_114181;
var statearr_114214_114275 = state_114181__$1;
(statearr_114214_114275[(2)] = inst_113998);


cljs.core.async.impl.ioc_helpers.process_exception(state_114181__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_114182 === (12))){
var inst_114172 = (state_114181[(2)]);
var state_114181__$1 = state_114181;
var statearr_114215_114276 = state_114181__$1;
(statearr_114215_114276[(2)] = inst_114172);

(statearr_114215_114276[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114182 === (2))){
var inst_114179 = (state_114181[(2)]);
var state_114181__$1 = state_114181;
return cljs.core.async.impl.ioc_helpers.return_chan(state_114181__$1,inst_114179);
} else {
if((state_val_114182 === (23))){
var inst_114151 = (state_114181[(2)]);
var state_114181__$1 = state_114181;
var statearr_114216_114277 = state_114181__$1;
(statearr_114216_114277[(2)] = inst_114151);

(statearr_114216_114277[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114182 === (35))){
var inst_114145 = (state_114181[(2)]);
var state_114181__$1 = state_114181;
var statearr_114217_114278 = state_114181__$1;
(statearr_114217_114278[(2)] = inst_114145);

(statearr_114217_114278[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114182 === (19))){
var inst_114036 = (state_114181[(12)]);
var inst_114038 = (state_114181[(13)]);
var inst_114065 = (state_114181[(2)]);
var inst_114066 = fluree.db.util.async.throw_err(inst_114065);
var inst_114067 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114068 = [inst_114036];
var inst_114069 = (new cljs.core.PersistentVector(null,1,(5),inst_114067,inst_114068,null));
var inst_114070 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114071 = [inst_114036,inst_114038];
var inst_114072 = (new cljs.core.PersistentVector(null,2,(5),inst_114070,inst_114071,null));
var inst_114073 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_114069,cljs.core._LT_,inst_114072);
var state_114181__$1 = (function (){var statearr_114218 = state_114181;
(statearr_114218[(7)] = inst_114066);

return statearr_114218;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_114181__$1,(20),inst_114073);
} else {
if((state_val_114182 === (11))){
var inst_114028 = (state_114181[(17)]);
var inst_114036 = (state_114181[(12)]);
var inst_114036__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_114028,(0),null);
var inst_114037 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_114028,(1),null);
var inst_114038 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_114028,(2),null);
var inst_114039 = fluree.db.query.fql.valid_where_predicate_QMARK_(db,inst_114036__$1);
var inst_114040 = cljs.core.not(inst_114039);
var state_114181__$1 = (function (){var statearr_114219 = state_114181;
(statearr_114219[(12)] = inst_114036__$1);

(statearr_114219[(13)] = inst_114038);

(statearr_114219[(10)] = inst_114037);

return statearr_114219;
})();
if(inst_114040){
var statearr_114220_114279 = state_114181__$1;
(statearr_114220_114279[(1)] = (13));

} else {
var statearr_114221_114280 = state_114181__$1;
(statearr_114221_114280[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114182 === (9))){
var inst_114174 = (state_114181[(2)]);
var state_114181__$1 = state_114181;
var statearr_114222_114281 = state_114181__$1;
(statearr_114222_114281[(2)] = inst_114174);

(statearr_114222_114281[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114182 === (5))){
var inst_114007 = (state_114181[(8)]);
var inst_114017 = cljs.core.seq(inst_114007);
var inst_114018 = cljs.core.first(inst_114017);
var inst_114019 = cljs.core.next(inst_114017);
var inst_114020 = cljs.core.PersistentHashSet.EMPTY;
var inst_114021 = inst_114007;
var inst_114022 = inst_114020;
var state_114181__$1 = (function (){var statearr_114223 = state_114181;
(statearr_114223[(18)] = inst_114019);

(statearr_114223[(19)] = inst_114021);

(statearr_114223[(20)] = inst_114018);

(statearr_114223[(16)] = inst_114022);

return statearr_114223;
})();
var statearr_114224_114282 = state_114181__$1;
(statearr_114224_114282[(2)] = null);

(statearr_114224_114282[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114182 === (14))){
var state_114181__$1 = state_114181;
var statearr_114225_114283 = state_114181__$1;
(statearr_114225_114283[(2)] = null);

(statearr_114225_114283[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114182 === (45))){
var inst_114162 = (state_114181[(14)]);
var inst_114029 = (state_114181[(21)]);
var inst_114021 = inst_114029;
var inst_114022 = inst_114162;
var state_114181__$1 = (function (){var statearr_114226 = state_114181;
(statearr_114226[(19)] = inst_114021);

(statearr_114226[(16)] = inst_114022);

return statearr_114226;
})();
var statearr_114227_114284 = state_114181__$1;
(statearr_114227_114284[(2)] = null);

(statearr_114227_114284[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114182 === (26))){
var inst_114037 = (state_114181[(10)]);
var inst_114102 = (cljs.core._GT__EQ_ === inst_114037);
var state_114181__$1 = state_114181;
if(inst_114102){
var statearr_114228_114285 = state_114181__$1;
(statearr_114228_114285[(1)] = (29));

} else {
var statearr_114229_114286 = state_114181__$1;
(statearr_114229_114286[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114182 === (16))){
var inst_114036 = (state_114181[(12)]);
var inst_114038 = (state_114181[(13)]);
var inst_114057 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114058 = [inst_114036,inst_114038];
var inst_114059 = (new cljs.core.PersistentVector(null,2,(5),inst_114057,inst_114058,null));
var inst_114060 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114061 = [inst_114036];
var inst_114062 = (new cljs.core.PersistentVector(null,1,(5),inst_114060,inst_114061,null));
var inst_114063 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT_,inst_114059,cljs.core._LT__EQ_,inst_114062);
var state_114181__$1 = state_114181;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_114181__$1,(19),inst_114063);
} else {
if((state_val_114182 === (38))){
var inst_114141 = null;
var state_114181__$1 = state_114181;
var statearr_114230_114287 = state_114181__$1;
(statearr_114230_114287[(2)] = inst_114141);

(statearr_114230_114287[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114182 === (30))){
var inst_114037 = (state_114181[(10)]);
var inst_114115 = (cljs.core._LT_ === inst_114037);
var state_114181__$1 = state_114181;
if(inst_114115){
var statearr_114231_114288 = state_114181__$1;
(statearr_114231_114288[(1)] = (33));

} else {
var statearr_114232_114289 = state_114181__$1;
(statearr_114232_114289[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114182 === (10))){
var inst_114022 = (state_114181[(16)]);
var state_114181__$1 = state_114181;
var statearr_114233_114290 = state_114181__$1;
(statearr_114233_114290[(2)] = inst_114022);

(statearr_114233_114290[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114182 === (18))){
var inst_114006 = (state_114181[(9)]);
var inst_114153 = (state_114181[(2)]);
var inst_114154 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_114153);
var state_114181__$1 = (function (){var statearr_114234 = state_114181;
(statearr_114234[(15)] = inst_114154);

return statearr_114234;
})();
var G__114235_114291 = inst_114006;
var G__114235_114292__$1 = (((G__114235_114291 instanceof cljs.core.Keyword))?G__114235_114291.fqn:null);
switch (G__114235_114292__$1) {
case "or":
var statearr_114236_114294 = state_114181__$1;
(statearr_114236_114294[(1)] = (42));


break;
case "and":
var statearr_114237_114295 = state_114181__$1;
(statearr_114237_114295[(1)] = (43));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__114235_114292__$1)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114182 === (42))){
var inst_114154 = (state_114181[(15)]);
var inst_114022 = (state_114181[(16)]);
var inst_114155 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_114022,inst_114154);
var state_114181__$1 = state_114181;
var statearr_114238_114296 = state_114181__$1;
(statearr_114238_114296[(2)] = inst_114155);

(statearr_114238_114296[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114182 === (37))){
var inst_114036 = (state_114181[(12)]);
var inst_114038 = (state_114181[(13)]);
var inst_114130 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114131 = [inst_114036];
var inst_114132 = (new cljs.core.PersistentVector(null,1,(5),inst_114130,inst_114131,null));
var inst_114133 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114134 = [inst_114036,inst_114038];
var inst_114135 = (new cljs.core.PersistentVector(null,2,(5),inst_114133,inst_114134,null));
var inst_114136 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_114132,cljs.core._LT__EQ_,inst_114135);
var state_114181__$1 = state_114181;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_114181__$1,(40),inst_114136);
} else {
if((state_val_114182 === (8))){
var inst_114028 = (state_114181[(17)]);
var inst_114021 = (state_114181[(19)]);
var inst_114027 = cljs.core.seq(inst_114021);
var inst_114028__$1 = cljs.core.first(inst_114027);
var inst_114029 = cljs.core.next(inst_114027);
var inst_114030 = cljs.core.not(inst_114028__$1);
var state_114181__$1 = (function (){var statearr_114239 = state_114181;
(statearr_114239[(17)] = inst_114028__$1);

(statearr_114239[(21)] = inst_114029);

return statearr_114239;
})();
if(inst_114030){
var statearr_114240_114297 = state_114181__$1;
(statearr_114240_114297[(1)] = (10));

} else {
var statearr_114241_114298 = state_114181__$1;
(statearr_114241_114298[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__100742__auto__ = null;
var fluree$db$query$fql$state_machine__100742__auto____0 = (function (){
var statearr_114242 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_114242[(0)] = fluree$db$query$fql$state_machine__100742__auto__);

(statearr_114242[(1)] = (1));

return statearr_114242;
});
var fluree$db$query$fql$state_machine__100742__auto____1 = (function (state_114181){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_114181);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e114243){if((e114243 instanceof Object)){
var ex__100745__auto__ = e114243;
var statearr_114244_114299 = state_114181;
(statearr_114244_114299[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_114181);

return cljs.core.cst$kw$recur;
} else {
throw e114243;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__114300 = state_114181;
state_114181 = G__114300;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__100742__auto__ = function(state_114181){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__100742__auto____1.call(this,state_114181);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__100742__auto____0;
fluree$db$query$fql$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__100742__auto____1;
return fluree$db$query$fql$state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_114245 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_114245[(6)] = c__100848__auto__);

return statearr_114245;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
}));

(fluree.db.query.fql.where_filter.cljs$lang$maxFixedArity = 3);

/**
 * Order By can be:
 *  - Single variable, ?favNums
 *  - Two-tuple,  [ASC, ?favNums]
 */
fluree.db.query.fql.order_offset_and_limit_results = (function fluree$db$query$fql$order_offset_and_limit_results(orderBy,p__114302,offset,limit){
var map__114303 = p__114302;
var map__114303__$1 = (((((!((map__114303 == null))))?(((((map__114303.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__114303.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__114303):map__114303);
var res = map__114303__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__114303__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__114303__$1,cljs.core.cst$kw$tuples);
var vec__114305 = orderBy;
var order = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__114305,(0),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__114305,(1),null);
var indexOfFind = (function (){var or__4126__auto__ = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(var$));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (-1);
}
})();
var tuples__$1 = ((((0) <= indexOfFind))?(function (){var G__114308 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((function (p1__114301_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__114301_SHARP_,indexOfFind);
}),fluree.db.query.fql.compare_fn,tuples);
var G__114308__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",order))?cljs.core.reverse(G__114308):G__114308);
var G__114308__$2 = (cljs.core.truth_(offset)?cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,G__114308__$1):G__114308__$1);
if(cljs.core.truth_(limit)){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,G__114308__$2);
} else {
return G__114308__$2;
}
})():tuples);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$tuples,tuples__$1], null);
});
fluree.db.query.fql.parse_map = (function fluree$db$query$fql$parse_map(x,valid_var){
var _ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(cljs.core.keys(x))))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
var var_as_symbol = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.keys(x)));
var ___$1 = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(var_as_symbol) : valid_var.call(null,var_as_symbol)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$variable,var_as_symbol,cljs.core.cst$kw$selection,cljs.core.first(cljs.core.vals(x))], null);
});
fluree.db.query.fql.parse_select = (function fluree$db$query$fql$parse_select(vars,interim_vars,select_smt){
var _ = (function (){var or__4126__auto__ = cljs.core.every_QMARK_((function (p1__114309_SHARP_){
return ((typeof p1__114309_SHARP_ === 'string') || (cljs.core.map_QMARK_(p1__114309_SHARP_)));
}),select_smt);
if(or__4126__auto__){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select statement. Every selection must be a string or map. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select_smt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var vars__$1 = cljs.core.set(vars);
var all_vars = cljs.core.set(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(vars__$1,cljs.core.keys(interim_vars)));
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select){
var var_symbol = ((cljs.core.map_QMARK_(select))?null:cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(select));
if(cljs.core.truth_((vars__$1.cljs$core$IFn$_invoke$arity$1 ? vars__$1.cljs$core$IFn$_invoke$arity$1(var_symbol) : vars__$1.call(null,var_symbol)))){
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$variable,var_symbol], null);
} else {
if(cljs.core.truth_(fluree.db.query.analytical.aggregate_QMARK_(select))){
return fluree.db.query.analytical.parse_aggregate(select,vars__$1);
} else {
if(cljs.core.map_QMARK_(select)){
return fluree.db.query.fql.parse_map(select,all_vars);
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$value,cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol)], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select in statement, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));

}
}
}
}
}),select_smt);
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select__$1){
if(cljs.core.truth_(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies(vars);
if(cljs.core.every_QMARK_((function (p1__114310_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__114310_SHARP_);
}),cljs.core.vals(freqs))){
return vars;
} else {
var G__114314 = vars;
var vec__114315 = G__114314;
var seq__114316 = cljs.core.seq(vec__114315);
var first__114317 = cljs.core.first(seq__114316);
var seq__114316__$1 = cljs.core.next(seq__114316);
var var$ = first__114317;
var r = seq__114316__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__114314__$1 = G__114314;
var all_vars__$1 = all_vars;
while(true){
var vec__114322 = G__114314__$1;
var seq__114323 = cljs.core.seq(vec__114322);
var first__114324 = cljs.core.first(seq__114323);
var seq__114323__$1 = cljs.core.next(seq__114323);
var var$__$1 = first__114324;
var r__$1 = seq__114323__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not(var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_((function (){var fexpr__114325 = cljs.core.set(all_vars__$2);
return (fexpr__114325.cljs$core$IFn$_invoke$arity$1 ? fexpr__114325.cljs$core$IFn$_invoke$arity$1(var$__$1) : fexpr__114325.call(null,var$__$1));
})())){
var G__114326 = r__$1;
var G__114327 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(all_vars__$2))].join(''));
G__114314__$1 = G__114326;
all_vars__$1 = G__114327;
continue;
} else {
var G__114328 = r__$1;
var G__114329 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,var$__$1);
G__114314__$1 = G__114328;
all_vars__$1 = G__114329;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.format_tuple = (function fluree$db$query$fql$format_tuple(functionArray,tuple){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_114363){
var state_val_114364 = (state_114363[(1)]);
if((state_val_114364 === (1))){
var inst_114337 = cljs.core.seq(functionArray);
var inst_114338 = cljs.core.first(inst_114337);
var inst_114339 = cljs.core.next(inst_114337);
var inst_114340 = cljs.core.PersistentVector.EMPTY;
var inst_114341 = functionArray;
var inst_114342 = inst_114340;
var state_114363__$1 = (function (){var statearr_114365 = state_114363;
(statearr_114365[(7)] = inst_114338);

(statearr_114365[(8)] = inst_114341);

(statearr_114365[(9)] = inst_114339);

(statearr_114365[(10)] = inst_114342);

return statearr_114365;
})();
var statearr_114366_114378 = state_114363__$1;
(statearr_114366_114378[(2)] = null);

(statearr_114366_114378[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114364 === (2))){
var inst_114341 = (state_114363[(8)]);
var inst_114348 = (state_114363[(11)]);
var inst_114347 = cljs.core.seq(inst_114341);
var inst_114348__$1 = cljs.core.first(inst_114347);
var inst_114349 = cljs.core.next(inst_114347);
var state_114363__$1 = (function (){var statearr_114367 = state_114363;
(statearr_114367[(11)] = inst_114348__$1);

(statearr_114367[(12)] = inst_114349);

return statearr_114367;
})();
if(cljs.core.truth_(inst_114348__$1)){
var statearr_114368_114379 = state_114363__$1;
(statearr_114368_114379[(1)] = (4));

} else {
var statearr_114369_114380 = state_114363__$1;
(statearr_114369_114380[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114364 === (3))){
var inst_114361 = (state_114363[(2)]);
var state_114363__$1 = state_114363;
return cljs.core.async.impl.ioc_helpers.return_chan(state_114363__$1,inst_114361);
} else {
if((state_val_114364 === (4))){
var inst_114348 = (state_114363[(11)]);
var inst_114351 = (inst_114348.cljs$core$IFn$_invoke$arity$1 ? inst_114348.cljs$core$IFn$_invoke$arity$1(tuple) : inst_114348.call(null,tuple));
var state_114363__$1 = state_114363;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_114363__$1,(7),inst_114351);
} else {
if((state_val_114364 === (5))){
var inst_114342 = (state_114363[(10)]);
var state_114363__$1 = state_114363;
var statearr_114370_114381 = state_114363__$1;
(statearr_114370_114381[(2)] = inst_114342);

(statearr_114370_114381[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114364 === (6))){
var inst_114359 = (state_114363[(2)]);
var state_114363__$1 = state_114363;
var statearr_114371_114382 = state_114363__$1;
(statearr_114371_114382[(2)] = inst_114359);

(statearr_114371_114382[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114364 === (7))){
var inst_114342 = (state_114363[(10)]);
var inst_114349 = (state_114363[(12)]);
var inst_114353 = (state_114363[(2)]);
var inst_114354 = fluree.db.util.async.throw_err(inst_114353);
var inst_114355 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_114342,inst_114354);
var inst_114341 = inst_114349;
var inst_114342__$1 = inst_114355;
var state_114363__$1 = (function (){var statearr_114372 = state_114363;
(statearr_114372[(8)] = inst_114341);

(statearr_114372[(10)] = inst_114342__$1);

return statearr_114372;
})();
var statearr_114373_114383 = state_114363__$1;
(statearr_114373_114383[(2)] = null);

(statearr_114373_114383[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_tuple_$_state_machine__100742__auto__ = null;
var fluree$db$query$fql$format_tuple_$_state_machine__100742__auto____0 = (function (){
var statearr_114374 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_114374[(0)] = fluree$db$query$fql$format_tuple_$_state_machine__100742__auto__);

(statearr_114374[(1)] = (1));

return statearr_114374;
});
var fluree$db$query$fql$format_tuple_$_state_machine__100742__auto____1 = (function (state_114363){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_114363);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e114375){if((e114375 instanceof Object)){
var ex__100745__auto__ = e114375;
var statearr_114376_114384 = state_114363;
(statearr_114376_114384[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_114363);

return cljs.core.cst$kw$recur;
} else {
throw e114375;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__114385 = state_114363;
state_114363 = G__114385;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$query$fql$format_tuple_$_state_machine__100742__auto__ = function(state_114363){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_tuple_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_tuple_$_state_machine__100742__auto____1.call(this,state_114363);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_tuple_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_tuple_$_state_machine__100742__auto____0;
fluree$db$query$fql$format_tuple_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_tuple_$_state_machine__100742__auto____1;
return fluree$db$query$fql$format_tuple_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_114377 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_114377[(6)] = c__100848__auto__);

return statearr_114377;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
fluree.db.query.fql.format_filter_tuples = (function fluree$db$query$fql$format_filter_tuples(db,tuples,p__114387,headers,vars,opts){
var map__114388 = p__114387;
var map__114388__$1 = (((((!((map__114388 == null))))?(((((map__114388.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__114388.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__114388):map__114388);
var select_spec = map__114388__$1;
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__114388__$1,cljs.core.cst$kw$prettyPrint);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__114388__$1,cljs.core.cst$kw$select);
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__114388__$1,cljs.core.cst$kw$inVector_QMARK_);
var expandMaps_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__114388__$1,cljs.core.cst$kw$expandMaps_QMARK_);
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_114471){
var state_val_114472 = (state_114471[(1)]);
if((state_val_114472 === (7))){
var inst_114398 = (state_114471[(2)]);
var state_114471__$1 = (function (){var statearr_114473 = state_114471;
(statearr_114473[(7)] = inst_114398);

return statearr_114473;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_114474_114588 = state_114471__$1;
(statearr_114474_114588[(1)] = (8));

} else {
var statearr_114475_114589 = state_114471__$1;
(statearr_114475_114589[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114472 === (1))){
var state_114471__$1 = state_114471;
var statearr_114476_114590 = state_114471__$1;
(statearr_114476_114590[(2)] = null);

(statearr_114476_114590[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114472 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_114471,(3),Error,null,(2));
var state_114471__$1 = state_114471;
if(cljs.core.truth_(prettyPrint)){
var statearr_114477_114591 = state_114471__$1;
(statearr_114477_114591[(1)] = (5));

} else {
var statearr_114478_114592 = state_114471__$1;
(statearr_114478_114592[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114472 === (13))){
var inst_114467 = (state_114471[(2)]);
var state_114471__$1 = state_114471;
var statearr_114479_114593 = state_114471__$1;
(statearr_114479_114593[(2)] = inst_114467);


cljs.core.async.impl.ioc_helpers.process_exception(state_114471__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_114472 === (6))){
var state_114471__$1 = state_114471;
var statearr_114480_114594 = state_114471__$1;
(statearr_114480_114594[(2)] = null);

(statearr_114480_114594[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114472 === (3))){
var inst_114390 = (state_114471[(2)]);
var state_114471__$1 = state_114471;
var statearr_114481_114595 = state_114471__$1;
(statearr_114481_114595[(2)] = inst_114390);


cljs.core.async.impl.ioc_helpers.process_exception(state_114471__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_114472 === (12))){
var inst_114398 = (state_114471[(7)]);
var inst_114406 = (state_114471[(8)]);
var inst_114464 = (function (){var pp = inst_114398;
var functionArray = inst_114406;
return (function (tuple){
var tuple_res = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__114386_SHARP_){
return (p1__114386_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__114386_SHARP_.cljs$core$IFn$_invoke$arity$1(tuple) : p1__114386_SHARP_.call(null,tuple));
}),functionArray);
if(cljs.core.truth_(pp)){
return cljs.core.zipmap(pp,tuple_res);
} else {
if(cljs.core.truth_(inVector_QMARK_)){
return tuple_res;
} else {
return cljs.core.first(tuple_res);

}
}
});
})();
var inst_114465 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_114464,tuples);
var state_114471__$1 = state_114471;
var statearr_114482_114596 = state_114471__$1;
(statearr_114482_114596[(2)] = inst_114465);

(statearr_114482_114596[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114472 === (2))){
var inst_114469 = (state_114471[(2)]);
var state_114471__$1 = state_114471;
return cljs.core.async.impl.ioc_helpers.return_chan(state_114471__$1,inst_114469);
} else {
if((state_val_114472 === (11))){
var inst_114398 = (state_114471[(7)]);
var inst_114406 = (state_114471[(8)]);
var inst_114457 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_114458 = (function (){var pp = inst_114398;
var functionArray = inst_114406;
var c__100848__auto____$1 = inst_114457;
return (function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_114455){
var state_val_114456 = (state_114455[(1)]);
if((state_val_114456 === (7))){
var inst_114431 = (state_114455[(2)]);
var inst_114432 = fluree.db.util.async.throw_err(inst_114431);
var state_114455__$1 = (function (){var statearr_114483 = state_114455;
(statearr_114483[(7)] = inst_114432);

return statearr_114483;
})();
if(cljs.core.truth_(pp)){
var statearr_114484_114597 = state_114455__$1;
(statearr_114484_114597[(1)] = (8));

} else {
var statearr_114485_114598 = state_114455__$1;
(statearr_114485_114598[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114456 === (1))){
var inst_114415 = cljs.core.seq(tuples);
var inst_114416 = cljs.core.first(inst_114415);
var inst_114417 = cljs.core.next(inst_114415);
var inst_114418 = cljs.core.PersistentVector.EMPTY;
var inst_114419 = tuples;
var inst_114420 = inst_114418;
var state_114455__$1 = (function (){var statearr_114486 = state_114455;
(statearr_114486[(8)] = inst_114419);

(statearr_114486[(9)] = inst_114420);

(statearr_114486[(10)] = inst_114416);

(statearr_114486[(11)] = inst_114417);

return statearr_114486;
})();
var statearr_114487_114599 = state_114455__$1;
(statearr_114487_114599[(2)] = null);

(statearr_114487_114599[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114456 === (4))){
var inst_114426 = (state_114455[(12)]);
var inst_114429 = fluree.db.query.fql.format_tuple(functionArray,inst_114426);
var state_114455__$1 = state_114455;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_114455__$1,(7),inst_114429);
} else {
if((state_val_114456 === (15))){
var state_114455__$1 = state_114455;
var statearr_114488_114600 = state_114455__$1;
(statearr_114488_114600[(2)] = null);

(statearr_114488_114600[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114456 === (13))){
var inst_114444 = (state_114455[(2)]);
var state_114455__$1 = state_114455;
var statearr_114489_114601 = state_114455__$1;
(statearr_114489_114601[(2)] = inst_114444);

(statearr_114489_114601[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114456 === (6))){
var inst_114451 = (state_114455[(2)]);
var state_114455__$1 = state_114455;
var statearr_114490_114602 = state_114455__$1;
(statearr_114490_114602[(2)] = inst_114451);

(statearr_114490_114602[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114456 === (3))){
var inst_114453 = (state_114455[(2)]);
var state_114455__$1 = state_114455;
return cljs.core.async.impl.ioc_helpers.return_chan(state_114455__$1,inst_114453);
} else {
if((state_val_114456 === (12))){
var state_114455__$1 = state_114455;
var statearr_114491_114603 = state_114455__$1;
(statearr_114491_114603[(1)] = (14));



return cljs.core.cst$kw$recur;
} else {
if((state_val_114456 === (2))){
var inst_114419 = (state_114455[(8)]);
var inst_114426 = (state_114455[(12)]);
var inst_114425 = cljs.core.seq(inst_114419);
var inst_114426__$1 = cljs.core.first(inst_114425);
var inst_114427 = cljs.core.next(inst_114425);
var state_114455__$1 = (function (){var statearr_114493 = state_114455;
(statearr_114493[(12)] = inst_114426__$1);

(statearr_114493[(13)] = inst_114427);

return statearr_114493;
})();
if(cljs.core.truth_(inst_114426__$1)){
var statearr_114494_114604 = state_114455__$1;
(statearr_114494_114604[(1)] = (4));

} else {
var statearr_114495_114605 = state_114455__$1;
(statearr_114495_114605[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114456 === (11))){
var inst_114432 = (state_114455[(7)]);
var state_114455__$1 = state_114455;
var statearr_114496_114606 = state_114455__$1;
(statearr_114496_114606[(2)] = inst_114432);

(statearr_114496_114606[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114456 === (9))){
var state_114455__$1 = state_114455;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_114497_114607 = state_114455__$1;
(statearr_114497_114607[(1)] = (11));

} else {
var statearr_114498_114608 = state_114455__$1;
(statearr_114498_114608[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114456 === (5))){
var inst_114420 = (state_114455[(9)]);
var state_114455__$1 = state_114455;
var statearr_114499_114609 = state_114455__$1;
(statearr_114499_114609[(2)] = inst_114420);

(statearr_114499_114609[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114456 === (14))){
var inst_114432 = (state_114455[(7)]);
var inst_114439 = cljs.core.first(inst_114432);
var state_114455__$1 = state_114455;
var statearr_114500_114610 = state_114455__$1;
(statearr_114500_114610[(2)] = inst_114439);

(statearr_114500_114610[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114456 === (16))){
var inst_114442 = (state_114455[(2)]);
var state_114455__$1 = state_114455;
var statearr_114501_114611 = state_114455__$1;
(statearr_114501_114611[(2)] = inst_114442);

(statearr_114501_114611[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114456 === (10))){
var inst_114420 = (state_114455[(9)]);
var inst_114427 = (state_114455[(13)]);
var inst_114446 = (state_114455[(2)]);
var inst_114447 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_114420,inst_114446);
var inst_114419 = inst_114427;
var inst_114420__$1 = inst_114447;
var state_114455__$1 = (function (){var statearr_114502 = state_114455;
(statearr_114502[(8)] = inst_114419);

(statearr_114502[(9)] = inst_114420__$1);

return statearr_114502;
})();
var statearr_114503_114612 = state_114455__$1;
(statearr_114503_114612[(2)] = null);

(statearr_114503_114612[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114456 === (8))){
var inst_114432 = (state_114455[(7)]);
var inst_114434 = cljs.core.zipmap(pp,inst_114432);
var state_114455__$1 = state_114455;
var statearr_114504_114613 = state_114455__$1;
(statearr_114504_114613[(2)] = inst_114434);

(statearr_114504_114613[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__100742__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__100742__auto____0 = (function (){
var statearr_114505 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_114505[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__100742__auto__);

(statearr_114505[(1)] = (1));

return statearr_114505;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__100742__auto____1 = (function (state_114455){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_114455);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e114506){if((e114506 instanceof Object)){
var ex__100745__auto__ = e114506;
var statearr_114507_114614 = state_114455;
(statearr_114507_114614[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_114455);

return cljs.core.cst$kw$recur;
} else {
throw e114506;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__114615 = state_114455;
state_114455 = G__114615;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__100742__auto__ = function(state_114455){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__100742__auto____1.call(this,state_114455);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__100742__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__100742__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_114508 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_114508[(6)] = c__100848__auto____$1);

return statearr_114508;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
});
})();
var inst_114459 = cljs.core.async.impl.dispatch.run(inst_114458);
var state_114471__$1 = (function (){var statearr_114509 = state_114471;
(statearr_114509[(9)] = inst_114459);

return statearr_114509;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_114471__$1,(14),inst_114457);
} else {
if((state_val_114472 === (9))){
var inst_114398 = (state_114471[(7)]);
var inst_114403 = (function (){var pp = inst_114398;
return (function (select__$1){
var temp__5733__auto__ = cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(select__$1);
if(cljs.core.truth_(temp__5733__auto__)){
var val = temp__5733__auto__;
return (function (x){
return val;
});
} else {
var idx = fluree.db.query.fql.get_header_idx(headers,select__$1);
return (function (tuple){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,idx);
});
}
});
})();
var inst_114404 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_114403,select);
var state_114471__$1 = state_114471;
var statearr_114510_114616 = state_114471__$1;
(statearr_114510_114616[(2)] = inst_114404);

(statearr_114510_114616[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114472 === (5))){
var inst_114395 = fluree.db.query.fql.get_pretty_print_keys(select);
var state_114471__$1 = state_114471;
var statearr_114511_114617 = state_114471__$1;
(statearr_114511_114617[(2)] = inst_114395);

(statearr_114511_114617[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114472 === (14))){
var inst_114461 = (state_114471[(2)]);
var inst_114462 = fluree.db.util.async.throw_err(inst_114461);
var state_114471__$1 = state_114471;
var statearr_114512_114618 = state_114471__$1;
(statearr_114512_114618[(2)] = inst_114462);

(statearr_114512_114618[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114472 === (10))){
var inst_114406 = (state_114471[(2)]);
var state_114471__$1 = (function (){var statearr_114513 = state_114471;
(statearr_114513[(8)] = inst_114406);

return statearr_114513;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_114514_114619 = state_114471__$1;
(statearr_114514_114619[(1)] = (11));

} else {
var statearr_114515_114620 = state_114471__$1;
(statearr_114515_114620[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114472 === (8))){
var inst_114398 = (state_114471[(7)]);
var inst_114400 = (function (){var pp = inst_114398;
return (function (select__$1){
var select_val = (function (){var or__4126__auto__ = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select__$1);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select__$1);
}
})();
var idx = (cljs.core.truth_(select_val)?fluree.db.util.core.index_of(headers,select_val):null);
var select_fn = (cljs.core.truth_(idx)?(function (tuple){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,idx);
}):(cljs.core.truth_(cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(select__$1))?(function (tuple){
return cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(select__$1);
}):(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val))?(function (tuple){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val);
}):null)));
if(cljs.core.truth_(cljs.core.cst$kw$selection.cljs$core$IFn$_invoke$arity$1(select__$1))){
return (function (tuple){
var c__100848__auto____$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_114548){
var state_val_114549 = (state_114548[(1)]);
if((state_val_114549 === (7))){
var inst_114544 = (state_114548[(2)]);
var state_114548__$1 = state_114548;
var statearr_114550_114621 = state_114548__$1;
(statearr_114550_114621[(2)] = inst_114544);


cljs.core.async.impl.ioc_helpers.process_exception(state_114548__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_114549 === (1))){
var state_114548__$1 = state_114548;
var statearr_114551_114622 = state_114548__$1;
(statearr_114551_114622[(2)] = null);

(statearr_114551_114622[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114549 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_114548,(3),Error,null,(2));
var inst_114520 = (select_fn.cljs$core$IFn$_invoke$arity$1 ? select_fn.cljs$core$IFn$_invoke$arity$1(tuple) : select_fn.call(null,tuple));
var state_114548__$1 = state_114548;
if(cljs.core.truth_(inst_114520)){
var statearr_114552_114623 = state_114548__$1;
(statearr_114552_114623[(1)] = (5));

} else {
var statearr_114553_114624 = state_114548__$1;
(statearr_114553_114624[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114549 === (6))){
var state_114548__$1 = state_114548;
var statearr_114554_114625 = state_114548__$1;
(statearr_114554_114625[(2)] = null);

(statearr_114554_114625[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114549 === (3))){
var inst_114516 = (state_114548[(2)]);
var state_114548__$1 = state_114548;
var statearr_114555_114626 = state_114548__$1;
(statearr_114555_114626[(2)] = inst_114516);


cljs.core.async.impl.ioc_helpers.process_exception(state_114548__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_114549 === (2))){
var inst_114546 = (state_114548[(2)]);
var state_114548__$1 = state_114548;
return cljs.core.async.impl.ioc_helpers.return_chan(state_114548__$1,inst_114546);
} else {
if((state_val_114549 === (11))){
var inst_114541 = (state_114548[(2)]);
var state_114548__$1 = state_114548;
var statearr_114556_114627 = state_114548__$1;
(statearr_114556_114627[(2)] = inst_114541);

(statearr_114556_114627[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114549 === (9))){
var inst_114533 = (state_114548[(7)]);
var state_114548__$1 = state_114548;
var statearr_114557_114628 = state_114548__$1;
(statearr_114557_114628[(2)] = inst_114533);

(statearr_114557_114628[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114549 === (5))){
var inst_114525 = [cljs.core.cst$kw$selectOne,cljs.core.cst$kw$from];
var inst_114526 = cljs.core.cst$kw$selection.cljs$core$IFn$_invoke$arity$1(select__$1);
var inst_114527 = (select_fn.cljs$core$IFn$_invoke$arity$1 ? select_fn.cljs$core$IFn$_invoke$arity$1(tuple) : select_fn.call(null,tuple));
var inst_114528 = [inst_114526,inst_114527];
var inst_114529 = cljs.core.PersistentHashMap.fromArrays(inst_114525,inst_114528);
var inst_114530 = (fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$3 ? fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$3(db,inst_114529,opts) : fluree.db.query.fql.query.call(null,db,inst_114529,opts));
var state_114548__$1 = state_114548;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_114548__$1,(8),inst_114530);
} else {
if((state_val_114549 === (10))){
var inst_114536 = [cljs.core.cst$kw$_id];
var inst_114537 = (select_fn.cljs$core$IFn$_invoke$arity$1 ? select_fn.cljs$core$IFn$_invoke$arity$1(tuple) : select_fn.call(null,tuple));
var inst_114538 = [inst_114537];
var inst_114539 = cljs.core.PersistentHashMap.fromArrays(inst_114536,inst_114538);
var state_114548__$1 = state_114548;
var statearr_114558_114629 = state_114548__$1;
(statearr_114558_114629[(2)] = inst_114539);

(statearr_114558_114629[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114549 === (8))){
var inst_114533 = (state_114548[(7)]);
var inst_114532 = (state_114548[(2)]);
var inst_114533__$1 = fluree.db.util.async.throw_err(inst_114532);
var state_114548__$1 = (function (){var statearr_114559 = state_114548;
(statearr_114559[(7)] = inst_114533__$1);

return statearr_114559;
})();
if(cljs.core.truth_(inst_114533__$1)){
var statearr_114560_114630 = state_114548__$1;
(statearr_114560_114630[(1)] = (9));

} else {
var statearr_114561_114631 = state_114548__$1;
(statearr_114561_114631[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__100742__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__100742__auto____0 = (function (){
var statearr_114562 = [null,null,null,null,null,null,null,null];
(statearr_114562[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__100742__auto__);

(statearr_114562[(1)] = (1));

return statearr_114562;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__100742__auto____1 = (function (state_114548){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_114548);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e114563){if((e114563 instanceof Object)){
var ex__100745__auto__ = e114563;
var statearr_114564_114632 = state_114548;
(statearr_114564_114632[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_114548);

return cljs.core.cst$kw$recur;
} else {
throw e114563;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__114633 = state_114548;
state_114548 = G__114633;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__100742__auto__ = function(state_114548){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__100742__auto____1.call(this,state_114548);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__100742__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__100742__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_114565 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_114565[(6)] = c__100848__auto____$1);

return statearr_114565;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto____$1;
});
} else {
return (function (tuple){
var c__100848__auto____$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_114574){
var state_val_114575 = (state_114574[(1)]);
if((state_val_114575 === (1))){
var state_114574__$1 = state_114574;
var statearr_114576_114634 = state_114574__$1;
(statearr_114576_114634[(2)] = null);

(statearr_114576_114634[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114575 === (2))){
var inst_114572 = (state_114574[(2)]);
var state_114574__$1 = state_114574;
return cljs.core.async.impl.ioc_helpers.return_chan(state_114574__$1,inst_114572);
} else {
if((state_val_114575 === (3))){
var inst_114566 = (state_114574[(2)]);
var state_114574__$1 = state_114574;
var statearr_114577_114635 = state_114574__$1;
(statearr_114577_114635[(2)] = inst_114566);


cljs.core.async.impl.ioc_helpers.process_exception(state_114574__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_114575 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_114574,(3),Error,null,(2));
var inst_114570 = (select_fn.cljs$core$IFn$_invoke$arity$1 ? select_fn.cljs$core$IFn$_invoke$arity$1(tuple) : select_fn.call(null,tuple));
var state_114574__$1 = state_114574;
var statearr_114578_114636 = state_114574__$1;
(statearr_114578_114636[(2)] = inst_114570);


cljs.core.async.impl.ioc_helpers.process_exception(state_114574__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__100742__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__100742__auto____0 = (function (){
var statearr_114579 = [null,null,null,null,null,null,null];
(statearr_114579[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__100742__auto__);

(statearr_114579[(1)] = (1));

return statearr_114579;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__100742__auto____1 = (function (state_114574){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_114574);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e114580){if((e114580 instanceof Object)){
var ex__100745__auto__ = e114580;
var statearr_114581_114637 = state_114574;
(statearr_114581_114637[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_114574);

return cljs.core.cst$kw$recur;
} else {
throw e114580;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__114638 = state_114574;
state_114574 = G__114638;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__100742__auto__ = function(state_114574){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__100742__auto____1.call(this,state_114574);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__100742__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__100742__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_114582 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_114582[(6)] = c__100848__auto____$1);

return statearr_114582;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto____$1;
});
}
});
})();
var inst_114401 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_114400,select);
var state_114471__$1 = state_114471;
var statearr_114583_114639 = state_114471__$1;
(statearr_114583_114639[(2)] = inst_114401);

(statearr_114583_114639[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__100742__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__100742__auto____0 = (function (){
var statearr_114584 = [null,null,null,null,null,null,null,null,null,null];
(statearr_114584[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__100742__auto__);

(statearr_114584[(1)] = (1));

return statearr_114584;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__100742__auto____1 = (function (state_114471){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_114471);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e114585){if((e114585 instanceof Object)){
var ex__100745__auto__ = e114585;
var statearr_114586_114640 = state_114471;
(statearr_114586_114640[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_114471);

return cljs.core.cst$kw$recur;
} else {
throw e114585;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__114641 = state_114471;
state_114471 = G__114641;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__100742__auto__ = function(state_114471){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__100742__auto____1.call(this,state_114471);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__100742__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__100742__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_114587 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_114587[(6)] = c__100848__auto__);

return statearr_114587;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__114643 = arguments.length;
switch (G__114643) {
case 4:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$4 = (function (db,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5(db,res,select_spec,null,opts);
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5 = (function (db,p__114644,p__114645,group_limit,opts){
var map__114646 = p__114644;
var map__114646__$1 = (((((!((map__114646 == null))))?(((((map__114646.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__114646.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__114646):map__114646);
var res = map__114646__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__114646__$1,cljs.core.cst$kw$vars);
var map__114647 = p__114645;
var map__114647__$1 = (((((!((map__114647 == null))))?(((((map__114647.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__114647.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__114647):map__114647);
var select_spec = map__114647__$1;
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__114647__$1,cljs.core.cst$kw$inVector_QMARK_);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__114647__$1,cljs.core.cst$kw$select);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__114647__$1,cljs.core.cst$kw$orderBy);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__114647__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__114647__$1,cljs.core.cst$kw$offset);
var aggregates = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__114647__$1,cljs.core.cst$kw$aggregates);
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__114647__$1,cljs.core.cst$kw$prettyPrint);
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__114647__$1,cljs.core.cst$kw$selectDistinct_QMARK_);
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__114647__$1,cljs.core.cst$kw$groupBy);
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_114754){
var state_val_114755 = (state_114754[(1)]);
if((state_val_114755 === (7))){
var inst_114659 = (state_114754[(2)]);
var state_114754__$1 = state_114754;
if(cljs.core.truth_(inst_114659)){
var statearr_114756_114827 = state_114754__$1;
(statearr_114756_114827[(1)] = (8));

} else {
var statearr_114757_114828 = state_114754__$1;
(statearr_114757_114828[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114755 === (20))){
var state_114754__$1 = state_114754;
var statearr_114758_114829 = state_114754__$1;
(statearr_114758_114829[(2)] = (0));

(statearr_114758_114829[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114755 === (27))){
var state_114754__$1 = state_114754;
var statearr_114759_114830 = state_114754__$1;
(statearr_114759_114830[(2)] = false);

(statearr_114759_114830[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114755 === (1))){
var state_114754__$1 = state_114754;
var statearr_114760_114831 = state_114754__$1;
(statearr_114760_114831[(2)] = null);

(statearr_114760_114831[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114755 === (24))){
var inst_114688 = (state_114754[(7)]);
var state_114754__$1 = state_114754;
var statearr_114761_114832 = state_114754__$1;
(statearr_114761_114832[(2)] = inst_114688);

(statearr_114761_114832[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114755 === (39))){
var inst_114692 = (state_114754[(8)]);
var state_114754__$1 = state_114754;
var statearr_114762_114833 = state_114754__$1;
(statearr_114762_114833[(2)] = inst_114692);

(statearr_114762_114833[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114755 === (46))){
var inst_114740 = (state_114754[(9)]);
var state_114754__$1 = state_114754;
var statearr_114763_114834 = state_114754__$1;
(statearr_114763_114834[(2)] = inst_114740);

(statearr_114763_114834[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114755 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_114754,(3),Error,null,(2));
var state_114754__$1 = state_114754;
if(cljs.core.truth_(aggregates)){
var statearr_114764_114835 = state_114754__$1;
(statearr_114764_114835[(1)] = (5));

} else {
var statearr_114765_114836 = state_114754__$1;
(statearr_114765_114836[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114755 === (15))){
var inst_114674 = (state_114754[(10)]);
var state_114754__$1 = state_114754;
var statearr_114766_114837 = state_114754__$1;
(statearr_114766_114837[(2)] = inst_114674);

(statearr_114766_114837[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114755 === (21))){
var state_114754__$1 = state_114754;
var statearr_114767_114838 = state_114754__$1;
(statearr_114767_114838[(2)] = offset);

(statearr_114767_114838[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114755 === (31))){
var inst_114710 = (state_114754[(2)]);
var state_114754__$1 = state_114754;
var statearr_114768_114839 = state_114754__$1;
(statearr_114768_114839[(2)] = inst_114710);

(statearr_114768_114839[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114755 === (32))){
var inst_114697 = (state_114754[(11)]);
var inst_114715 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_114697);
var state_114754__$1 = state_114754;
var statearr_114769_114840 = state_114754__$1;
(statearr_114769_114840[(2)] = inst_114715);

(statearr_114769_114840[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114755 === (40))){
var inst_114726 = (state_114754[(2)]);
var state_114754__$1 = state_114754;
var statearr_114770_114841 = state_114754__$1;
(statearr_114770_114841[(2)] = inst_114726);

(statearr_114770_114841[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114755 === (33))){
var inst_114697 = (state_114754[(11)]);
var state_114754__$1 = state_114754;
var statearr_114771_114842 = state_114754__$1;
(statearr_114771_114842[(2)] = inst_114697);

(statearr_114771_114842[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114755 === (13))){
var inst_114674 = (state_114754[(2)]);
var state_114754__$1 = (function (){var statearr_114772 = state_114754;
(statearr_114772[(10)] = inst_114674);

return statearr_114772;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_114773_114843 = state_114754__$1;
(statearr_114773_114843[(1)] = (14));

} else {
var statearr_114774_114844 = state_114754__$1;
(statearr_114774_114844[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114755 === (22))){
var inst_114692 = (state_114754[(2)]);
var state_114754__$1 = (function (){var statearr_114775 = state_114754;
(statearr_114775[(8)] = inst_114692);

return statearr_114775;
})();
if(cljs.core.truth_(orderBy)){
var statearr_114776_114845 = state_114754__$1;
(statearr_114776_114845[(1)] = (23));

} else {
var statearr_114777_114846 = state_114754__$1;
(statearr_114777_114846[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114755 === (36))){
var state_114754__$1 = state_114754;
var statearr_114778_114847 = state_114754__$1;
(statearr_114778_114847[(2)] = false);

(statearr_114778_114847[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114755 === (41))){
var inst_114692 = (state_114754[(8)]);
var inst_114720 = (state_114754[(12)]);
var inst_114731 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_114692,inst_114720);
var inst_114732 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,inst_114731);
var state_114754__$1 = state_114754;
var statearr_114779_114848 = state_114754__$1;
(statearr_114779_114848[(2)] = inst_114732);

(statearr_114779_114848[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114755 === (43))){
var inst_114719 = (state_114754[(13)]);
var inst_114735 = (state_114754[(2)]);
var inst_114736 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.cst$kw$limit,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$offset,cljs.core.cst$kw$orderBy,cljs.core.cst$kw$groupBy], 0));
var inst_114737 = fluree.db.query.fql.format_filter_tuples(db,inst_114735,select_spec,inst_114719,vars,inst_114736);
var state_114754__$1 = state_114754;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_114754__$1,(44),inst_114737);
} else {
if((state_val_114755 === (29))){
var state_114754__$1 = state_114754;
var statearr_114780_114849 = state_114754__$1;
(statearr_114780_114849[(2)] = true);

(statearr_114780_114849[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114755 === (44))){
var inst_114739 = (state_114754[(2)]);
var inst_114740 = fluree.db.util.async.throw_err(inst_114739);
var state_114754__$1 = (function (){var statearr_114781 = state_114754;
(statearr_114781[(9)] = inst_114740);

return statearr_114781;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_114782_114850 = state_114754__$1;
(statearr_114782_114850[(1)] = (45));

} else {
var statearr_114783_114851 = state_114754__$1;
(statearr_114783_114851[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114755 === (6))){
var state_114754__$1 = state_114754;
var statearr_114784_114852 = state_114754__$1;
(statearr_114784_114852[(2)] = aggregates);

(statearr_114784_114852[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114755 === (28))){
var inst_114713 = (state_114754[(2)]);
var state_114754__$1 = state_114754;
if(cljs.core.truth_(inst_114713)){
var statearr_114785_114853 = state_114754__$1;
(statearr_114785_114853[(1)] = (32));

} else {
var statearr_114786_114854 = state_114754__$1;
(statearr_114786_114854[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114755 === (25))){
var inst_114697 = (state_114754[(11)]);
var inst_114697__$1 = (state_114754[(2)]);
var inst_114699 = (inst_114697__$1 == null);
var inst_114700 = cljs.core.not(inst_114699);
var state_114754__$1 = (function (){var statearr_114787 = state_114754;
(statearr_114787[(11)] = inst_114697__$1);

return statearr_114787;
})();
if(inst_114700){
var statearr_114788_114855 = state_114754__$1;
(statearr_114788_114855[(1)] = (26));

} else {
var statearr_114789_114856 = state_114754__$1;
(statearr_114789_114856[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114755 === (34))){
var inst_114718 = (state_114754[(2)]);
var inst_114719 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_114718,cljs.core.cst$kw$headers);
var inst_114720 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_114718,cljs.core.cst$kw$tuples);
var inst_114721 = cljs.core.not(orderBy);
var state_114754__$1 = (function (){var statearr_114790 = state_114754;
(statearr_114790[(13)] = inst_114719);

(statearr_114790[(12)] = inst_114720);

return statearr_114790;
})();
if(inst_114721){
var statearr_114791_114857 = state_114754__$1;
(statearr_114791_114857[(1)] = (35));

} else {
var statearr_114792_114858 = state_114754__$1;
(statearr_114792_114858[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114755 === (17))){
var inst_114685 = fluree.db.query.analytical.add_aggregate_cols(res,aggregates);
var state_114754__$1 = state_114754;
var statearr_114793_114859 = state_114754__$1;
(statearr_114793_114859[(2)] = inst_114685);

(statearr_114793_114859[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114755 === (3))){
var inst_114650 = (state_114754[(2)]);
var state_114754__$1 = state_114754;
var statearr_114794_114860 = state_114754__$1;
(statearr_114794_114860[(2)] = inst_114650);


cljs.core.async.impl.ioc_helpers.process_exception(state_114754__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_114755 === (12))){
var inst_114663 = (state_114754[(14)]);
var state_114754__$1 = state_114754;
var statearr_114795_114861 = state_114754__$1;
(statearr_114795_114861[(2)] = inst_114663);

(statearr_114795_114861[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114755 === (2))){
var inst_114752 = (state_114754[(2)]);
var state_114754__$1 = state_114754;
return cljs.core.async.impl.ioc_helpers.return_chan(state_114754__$1,inst_114752);
} else {
if((state_val_114755 === (23))){
var inst_114692 = (state_114754[(8)]);
var inst_114688 = (state_114754[(7)]);
var inst_114694 = fluree.db.query.fql.order_offset_and_limit_results(orderBy,inst_114688,inst_114692,group_limit);
var state_114754__$1 = state_114754;
var statearr_114796_114862 = state_114754__$1;
(statearr_114796_114862[(2)] = inst_114694);

(statearr_114796_114862[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114755 === (47))){
var inst_114748 = (state_114754[(2)]);
var state_114754__$1 = state_114754;
var statearr_114797_114863 = state_114754__$1;
(statearr_114797_114863[(2)] = inst_114748);

(statearr_114797_114863[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114755 === (35))){
var state_114754__$1 = state_114754;
if(cljs.core.truth_(limit)){
var statearr_114798_114864 = state_114754__$1;
(statearr_114798_114864[(1)] = (38));

} else {
var statearr_114799_114865 = state_114754__$1;
(statearr_114799_114865[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114755 === (19))){
var inst_114688 = (state_114754[(2)]);
var state_114754__$1 = (function (){var statearr_114800 = state_114754;
(statearr_114800[(7)] = inst_114688);

return statearr_114800;
})();
if(cljs.core.truth_(groupBy)){
var statearr_114801_114866 = state_114754__$1;
(statearr_114801_114866[(1)] = (20));

} else {
var statearr_114802_114867 = state_114754__$1;
(statearr_114802_114867[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114755 === (11))){
var inst_114663 = (state_114754[(14)]);
var inst_114665 = cljs.core.first(select);
var inst_114666 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(inst_114665);
var inst_114667 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_114666);
var inst_114668 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_114667,(1));
var inst_114669 = [inst_114668];
var inst_114670 = [inst_114663];
var inst_114671 = cljs.core.PersistentHashMap.fromArrays(inst_114669,inst_114670);
var state_114754__$1 = state_114754;
var statearr_114803_114868 = state_114754__$1;
(statearr_114803_114868[(2)] = inst_114671);

(statearr_114803_114868[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114755 === (9))){
var state_114754__$1 = state_114754;
if(cljs.core.truth_(aggregates)){
var statearr_114804_114869 = state_114754__$1;
(statearr_114804_114869[(1)] = (17));

} else {
var statearr_114805_114870 = state_114754__$1;
(statearr_114805_114870[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114755 === (5))){
var inst_114655 = cljs.core.count(select);
var inst_114656 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_114655);
var state_114754__$1 = state_114754;
var statearr_114806_114871 = state_114754__$1;
(statearr_114806_114871[(2)] = inst_114656);

(statearr_114806_114871[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114755 === (14))){
var inst_114674 = (state_114754[(10)]);
var inst_114676 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114677 = [inst_114674];
var inst_114678 = (new cljs.core.PersistentVector(null,1,(5),inst_114676,inst_114677,null));
var state_114754__$1 = state_114754;
var statearr_114807_114872 = state_114754__$1;
(statearr_114807_114872[(2)] = inst_114678);

(statearr_114807_114872[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114755 === (45))){
var inst_114740 = (state_114754[(9)]);
var inst_114742 = cljs.core.PersistentVector.EMPTY;
var inst_114743 = cljs.core.PersistentHashSet.EMPTY;
var inst_114744 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_114743,inst_114740);
var inst_114745 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_114742,inst_114744);
var state_114754__$1 = state_114754;
var statearr_114808_114873 = state_114754__$1;
(statearr_114808_114873[(2)] = inst_114745);

(statearr_114808_114873[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114755 === (26))){
var inst_114697 = (state_114754[(11)]);
var inst_114702 = inst_114697.cljs$lang$protocol_mask$partition0$;
var inst_114703 = (inst_114702 & (64));
var inst_114704 = inst_114697.cljs$core$ISeq$;
var inst_114705 = (cljs.core.PROTOCOL_SENTINEL === inst_114704);
var inst_114706 = ((inst_114703) || (inst_114705));
var state_114754__$1 = state_114754;
if(cljs.core.truth_(inst_114706)){
var statearr_114809_114874 = state_114754__$1;
(statearr_114809_114874[(1)] = (29));

} else {
var statearr_114810_114875 = state_114754__$1;
(statearr_114810_114875[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114755 === (16))){
var inst_114681 = (state_114754[(2)]);
var state_114754__$1 = state_114754;
var statearr_114811_114876 = state_114754__$1;
(statearr_114811_114876[(2)] = inst_114681);

(statearr_114811_114876[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114755 === (38))){
var state_114754__$1 = state_114754;
var statearr_114812_114877 = state_114754__$1;
(statearr_114812_114877[(2)] = limit);

(statearr_114812_114877[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114755 === (30))){
var state_114754__$1 = state_114754;
var statearr_114813_114878 = state_114754__$1;
(statearr_114813_114878[(2)] = false);

(statearr_114813_114878[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114755 === (10))){
var inst_114750 = (state_114754[(2)]);
var state_114754__$1 = state_114754;
var statearr_114814_114879 = state_114754__$1;
(statearr_114814_114879[(2)] = inst_114750);


cljs.core.async.impl.ioc_helpers.process_exception(state_114754__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_114755 === (18))){
var state_114754__$1 = state_114754;
var statearr_114815_114880 = state_114754__$1;
(statearr_114815_114880[(2)] = res);

(statearr_114815_114880[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114755 === (42))){
var inst_114720 = (state_114754[(12)]);
var state_114754__$1 = state_114754;
var statearr_114816_114881 = state_114754__$1;
(statearr_114816_114881[(2)] = inst_114720);

(statearr_114816_114881[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114755 === (37))){
var inst_114729 = (state_114754[(2)]);
var state_114754__$1 = state_114754;
if(cljs.core.truth_(inst_114729)){
var statearr_114817_114882 = state_114754__$1;
(statearr_114817_114882[(1)] = (41));

} else {
var statearr_114818_114883 = state_114754__$1;
(statearr_114818_114883[(1)] = (42));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114755 === (8))){
var inst_114661 = cljs.core.first(aggregates);
var inst_114662 = fluree.db.query.analytical.calculate_aggregate(res,inst_114661);
var inst_114663 = cljs.core.second(inst_114662);
var state_114754__$1 = (function (){var statearr_114819 = state_114754;
(statearr_114819[(14)] = inst_114663);

return statearr_114819;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_114820_114884 = state_114754__$1;
(statearr_114820_114884[(1)] = (11));

} else {
var statearr_114821_114885 = state_114754__$1;
(statearr_114821_114885[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__100742__auto__ = null;
var fluree$db$query$fql$state_machine__100742__auto____0 = (function (){
var statearr_114822 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_114822[(0)] = fluree$db$query$fql$state_machine__100742__auto__);

(statearr_114822[(1)] = (1));

return statearr_114822;
});
var fluree$db$query$fql$state_machine__100742__auto____1 = (function (state_114754){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_114754);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e114823){if((e114823 instanceof Object)){
var ex__100745__auto__ = e114823;
var statearr_114824_114886 = state_114754;
(statearr_114824_114886[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_114754);

return cljs.core.cst$kw$recur;
} else {
throw e114823;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__114887 = state_114754;
state_114754 = G__114887;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__100742__auto__ = function(state_114754){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__100742__auto____1.call(this,state_114754);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__100742__auto____0;
fluree$db$query$fql$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__100742__auto____1;
return fluree$db$query$fql$state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_114825 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_114825[(6)] = c__100848__auto__);

return statearr_114825;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 5);

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__114890,groupBy){
var map__114891 = p__114890;
var map__114891__$1 = (((((!((map__114891 == null))))?(((((map__114891.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__114891.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__114891):map__114891);
var res = map__114891__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__114891__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__114891__$1,cljs.core.cst$kw$tuples);
var vec__114893 = ((cljs.core.vector_QMARK_(groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(groupBy)], null)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})()
));
var inVector_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__114893,(0),null);
var groupBy__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__114893,(1),null);
var group_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__114888_SHARP_){
return fluree.db.util.core.index_of(headers,p1__114888_SHARP_);
}),groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some(cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,tuple){
var k = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__114889_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__114889_SHARP_);
}),group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,k):cljs.core.first(k));
var v = tuple;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
}),cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,p__114896,p__114897,opts){
var map__114898 = p__114896;
var map__114898__$1 = (((((!((map__114898 == null))))?(((((map__114898.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__114898.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__114898):map__114898);
var res = map__114898__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__114898__$1,cljs.core.cst$kw$headers);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__114898__$1,cljs.core.cst$kw$vars);
var map__114899 = p__114897;
var map__114899__$1 = (((((!((map__114899 == null))))?(((((map__114899.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__114899.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__114899):map__114899);
var select_spec = map__114899__$1;
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__114899__$1,cljs.core.cst$kw$groupBy);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__114899__$1,cljs.core.cst$kw$orderBy);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__114899__$1,cljs.core.cst$kw$limit);
var selectOne_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__114899__$1,cljs.core.cst$kw$selectOne_QMARK_);
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__114899__$1,cljs.core.cst$kw$selectDistinct_QMARK_);
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__114899__$1,cljs.core.cst$kw$inVector_QMARK_);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__114899__$1,cljs.core.cst$kw$offset);
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_115118){
var state_val_115119 = (state_115118[(1)]);
if((state_val_115119 === (65))){
var inst_115085 = (state_115118[(7)]);
var inst_115084 = (state_115118[(2)]);
var inst_115085__$1 = fluree.db.util.async.throw_err(inst_115084);
var inst_115086 = cljs.core.coll_QMARK_(inst_115085__$1);
var inst_115087 = (!(inst_115086));
var state_115118__$1 = (function (){var statearr_115120 = state_115118;
(statearr_115120[(7)] = inst_115085__$1);

return statearr_115120;
})();
if(inst_115087){
var statearr_115121_115235 = state_115118__$1;
(statearr_115121_115235[(1)] = (66));

} else {
var statearr_115122_115236 = state_115118__$1;
(statearr_115122_115236[(1)] = (67));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (70))){
var inst_115085 = (state_115118[(7)]);
var state_115118__$1 = state_115118;
var statearr_115123_115237 = state_115118__$1;
(statearr_115123_115237[(2)] = inst_115085);

(statearr_115123_115237[(1)] = (71));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (62))){
var state_115118__$1 = state_115118;
var statearr_115124_115238 = state_115118__$1;
(statearr_115124_115238[(2)] = (1));

(statearr_115124_115238[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (74))){
var inst_115110 = (state_115118[(2)]);
var state_115118__$1 = state_115118;
var statearr_115125_115239 = state_115118__$1;
(statearr_115125_115239[(2)] = inst_115110);

(statearr_115125_115239[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (7))){
var inst_115114 = (state_115118[(2)]);
var state_115118__$1 = state_115118;
var statearr_115126_115240 = state_115118__$1;
(statearr_115126_115240[(2)] = inst_115114);


cljs.core.async.impl.ioc_helpers.process_exception(state_115118__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (59))){
var inst_114954 = (state_115118[(8)]);
var inst_115068 = (state_115118[(9)]);
var inst_115070 = cljs.core.sorted_map_by(inst_114954);
var inst_115071 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_115070,inst_115068);
var state_115118__$1 = state_115118;
var statearr_115127_115241 = state_115118__$1;
(statearr_115127_115241[(2)] = inst_115071);

(statearr_115127_115241[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (20))){
var inst_114927 = cljs.core.set(groupBy);
var inst_114928 = cljs.core.second(orderBy);
var inst_114929 = (inst_114927.cljs$core$IFn$_invoke$arity$1 ? inst_114927.cljs$core$IFn$_invoke$arity$1(inst_114928) : inst_114927.call(null,inst_114928));
var state_115118__$1 = state_115118;
var statearr_115128_115242 = state_115118__$1;
(statearr_115128_115242[(2)] = inst_114929);

(statearr_115128_115242[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (72))){
var inst_115085 = (state_115118[(7)]);
var inst_115098 = cljs.core.first(inst_115085);
var state_115118__$1 = state_115118;
var statearr_115129_115243 = state_115118__$1;
(statearr_115129_115243[(2)] = inst_115098);

(statearr_115129_115243[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (58))){
var inst_114998 = (state_115118[(10)]);
var inst_115007 = (state_115118[(11)]);
var inst_115050 = (state_115118[(2)]);
var inst_115051 = fluree.db.util.async.throw_err(inst_115050);
var inst_115052 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_114998,inst_115007,inst_115051);
var state_115118__$1 = state_115118;
var statearr_115130_115244 = state_115118__$1;
(statearr_115130_115244[(2)] = inst_115052);

(statearr_115130_115244[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (60))){
var inst_115068 = (state_115118[(9)]);
var state_115118__$1 = state_115118;
var statearr_115131_115245 = state_115118__$1;
(statearr_115131_115245[(2)] = inst_115068);

(statearr_115131_115245[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (27))){
var inst_114936 = (state_115118[(12)]);
var inst_114935 = (state_115118[(13)]);
var inst_114907 = (state_115118[(14)]);
var inst_114941 = (function (){var group_map = inst_114907;
var orderByIdx = inst_114935;
var orderDirection = inst_114936;
return (function (x,y){
return fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx));
});
})();
var state_115118__$1 = state_115118;
var statearr_115132_115246 = state_115118__$1;
(statearr_115132_115246[(2)] = inst_114941);

(statearr_115132_115246[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (1))){
var state_115118__$1 = state_115118;
var statearr_115133_115247 = state_115118__$1;
(statearr_115133_115247[(2)] = null);

(statearr_115133_115247[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (69))){
var inst_115085 = (state_115118[(7)]);
var inst_115090 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115091 = [inst_115085];
var inst_115092 = (new cljs.core.PersistentVector(null,1,(5),inst_115090,inst_115091,null));
var state_115118__$1 = state_115118;
var statearr_115134_115248 = state_115118__$1;
(statearr_115134_115248[(2)] = inst_115092);

(statearr_115134_115248[(1)] = (71));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (24))){
var state_115118__$1 = state_115118;
var statearr_115135_115249 = state_115118__$1;
(statearr_115135_115249[(1)] = (29));



return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (55))){
var inst_115022 = (state_115118[(15)]);
var inst_115010 = (state_115118[(16)]);
var inst_115025 = (state_115118[(17)]);
var inst_115045 = cljs.core.count(inst_115010);
var inst_115046 = (inst_115022 - limit);
var inst_115047 = (inst_115045 - inst_115046);
var inst_115048 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5(db,inst_115025,select_spec,inst_115047,opts);
var state_115118__$1 = state_115118;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_115118__$1,(58),inst_115048);
} else {
if((state_val_115119 === (39))){
var inst_114997 = (state_115118[(18)]);
var inst_115015 = (inst_114997 > (0));
var state_115118__$1 = state_115118;
if(cljs.core.truth_(inst_115015)){
var statearr_115137_115250 = state_115118__$1;
(statearr_115137_115250[(1)] = (41));

} else {
var statearr_115138_115251 = state_115118__$1;
(statearr_115138_115251[(1)] = (42));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (46))){
var inst_115062 = (state_115118[(2)]);
var state_115118__$1 = state_115118;
var statearr_115139_115252 = state_115118__$1;
(statearr_115139_115252[(2)] = inst_115062);

(statearr_115139_115252[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_115118,(3),Error,null,(2));
var state_115118__$1 = state_115118;
if(cljs.core.truth_(groupBy)){
var statearr_115140_115253 = state_115118__$1;
(statearr_115140_115253[(1)] = (5));

} else {
var statearr_115141_115254 = state_115118__$1;
(statearr_115141_115254[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (77))){
var inst_115108 = (state_115118[(2)]);
var state_115118__$1 = state_115118;
var statearr_115142_115255 = state_115118__$1;
(statearr_115142_115255[(2)] = inst_115108);

(statearr_115142_115255[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (54))){
var inst_114998 = (state_115118[(10)]);
var inst_115007 = (state_115118[(11)]);
var inst_115039 = (state_115118[(2)]);
var inst_115040 = fluree.db.util.async.throw_err(inst_115039);
var inst_115041 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_114998,inst_115007,inst_115040);
var state_115118__$1 = state_115118;
var statearr_115143_115256 = state_115118__$1;
(statearr_115143_115256[(2)] = inst_115041);

(statearr_115143_115256[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (15))){
var state_115118__$1 = state_115118;
var statearr_115145_115257 = state_115118__$1;
(statearr_115145_115257[(2)] = fluree.db.query.fql.compare_fn);

(statearr_115145_115257[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (48))){
var inst_115022 = (state_115118[(15)]);
var inst_115035 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(limit,inst_115022);
var state_115118__$1 = state_115118;
if(inst_115035){
var statearr_115146_115258 = state_115118__$1;
(statearr_115146_115258[(1)] = (51));

} else {
var statearr_115147_115259 = state_115118__$1;
(statearr_115147_115259[(1)] = (52));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (50))){
var inst_115022 = (state_115118[(15)]);
var inst_114998 = (state_115118[(10)]);
var inst_115007 = (state_115118[(11)]);
var inst_115008 = (state_115118[(19)]);
var inst_114997 = (state_115118[(18)]);
var inst_115011 = (state_115118[(20)]);
var inst_115030 = (state_115118[(2)]);
var inst_115031 = fluree.db.util.async.throw_err(inst_115030);
var inst_115032 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_114998,inst_115007,inst_115031);
var tmp115144 = inst_114997;
var inst_114994 = inst_115008;
var inst_114995 = inst_115011;
var inst_114996 = inst_115022;
var inst_114997__$1 = tmp115144;
var inst_114998__$1 = inst_115032;
var state_115118__$1 = (function (){var statearr_115148 = state_115118;
(statearr_115148[(21)] = inst_114996);

(statearr_115148[(10)] = inst_114998__$1);

(statearr_115148[(22)] = inst_114994);

(statearr_115148[(18)] = inst_114997__$1);

(statearr_115148[(23)] = inst_114995);

return statearr_115148;
})();
var statearr_115149_115260 = state_115118__$1;
(statearr_115149_115260[(2)] = null);

(statearr_115149_115260[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (75))){
var inst_115085 = (state_115118[(7)]);
var inst_115101 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(inst_115085);
var state_115118__$1 = state_115118;
var statearr_115150_115261 = state_115118__$1;
(statearr_115150_115261[(2)] = inst_115101);

(statearr_115150_115261[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (21))){
var state_115118__$1 = state_115118;
var statearr_115151_115262 = state_115118__$1;
(statearr_115151_115262[(2)] = orderBy);

(statearr_115151_115262[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (31))){
var inst_114948 = (state_115118[(2)]);
var state_115118__$1 = state_115118;
var statearr_115152_115263 = state_115118__$1;
(statearr_115152_115263[(2)] = inst_114948);

(statearr_115152_115263[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (32))){
var inst_114907 = (state_115118[(14)]);
var inst_114956 = cljs.core.keys(inst_114907);
var inst_114957 = cljs.core.first(inst_114956);
var inst_114958 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_114959 = cljs.core.vals(inst_114907);
var inst_114960 = cljs.core.first(inst_114959);
var inst_114961 = [headers,vars,inst_114960];
var inst_114962 = cljs.core.PersistentHashMap.fromArrays(inst_114958,inst_114961);
var inst_114963 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5(db,inst_114962,select_spec,limit,opts);
var state_115118__$1 = (function (){var statearr_115153 = state_115118;
(statearr_115153[(24)] = inst_114957);

return statearr_115153;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_115118__$1,(35),inst_114963);
} else {
if((state_val_115119 === (40))){
var inst_115066 = (state_115118[(2)]);
var state_115118__$1 = state_115118;
var statearr_115154_115264 = state_115118__$1;
(statearr_115154_115264[(2)] = inst_115066);

(statearr_115154_115264[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (56))){
var state_115118__$1 = state_115118;
var statearr_115155_115265 = state_115118__$1;
(statearr_115155_115265[(2)] = null);

(statearr_115155_115265[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (33))){
var inst_114907 = (state_115118[(14)]);
var inst_114985 = cljs.core.keys(inst_114907);
var inst_114986 = cljs.core.seq(inst_114985);
var inst_114987 = cljs.core.first(inst_114986);
var inst_114988 = cljs.core.next(inst_114986);
var inst_114989 = cljs.core.vals(inst_114907);
var inst_114990 = cljs.core.seq(inst_114989);
var inst_114991 = cljs.core.first(inst_114990);
var inst_114992 = cljs.core.next(inst_114990);
var inst_114993 = cljs.core.PersistentHashMap.EMPTY;
var inst_114994 = inst_114985;
var inst_114995 = inst_114989;
var inst_114996 = (0);
var inst_114997 = offset;
var inst_114998 = inst_114993;
var state_115118__$1 = (function (){var statearr_115156 = state_115118;
(statearr_115156[(25)] = inst_114992);

(statearr_115156[(21)] = inst_114996);

(statearr_115156[(10)] = inst_114998);

(statearr_115156[(26)] = inst_114991);

(statearr_115156[(22)] = inst_114994);

(statearr_115156[(18)] = inst_114997);

(statearr_115156[(27)] = inst_114987);

(statearr_115156[(23)] = inst_114995);

(statearr_115156[(28)] = inst_114988);

return statearr_115156;
})();
var statearr_115157_115266 = state_115118__$1;
(statearr_115157_115266[(2)] = null);

(statearr_115157_115266[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (13))){
var inst_114954 = (state_115118[(2)]);
var state_115118__$1 = (function (){var statearr_115158 = state_115118;
(statearr_115158[(8)] = inst_114954);

return statearr_115158;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_115159_115267 = state_115118__$1;
(statearr_115159_115267[(1)] = (32));

} else {
var statearr_115160_115268 = state_115118__$1;
(statearr_115160_115268[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (22))){
var inst_114932 = (state_115118[(2)]);
var state_115118__$1 = state_115118;
if(cljs.core.truth_(inst_114932)){
var statearr_115163_115269 = state_115118__$1;
(statearr_115163_115269[(1)] = (23));

} else {
var statearr_115164_115270 = state_115118__$1;
(statearr_115164_115270[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (36))){
var inst_115010 = (state_115118[(16)]);
var inst_114994 = (state_115118[(22)]);
var inst_114995 = (state_115118[(23)]);
var inst_115006 = cljs.core.seq(inst_114994);
var inst_115007 = cljs.core.first(inst_115006);
var inst_115008 = cljs.core.next(inst_115006);
var inst_115009 = cljs.core.seq(inst_114995);
var inst_115010__$1 = cljs.core.first(inst_115009);
var inst_115011 = cljs.core.next(inst_115009);
var inst_115012 = (inst_115010__$1 == null);
var state_115118__$1 = (function (){var statearr_115165 = state_115118;
(statearr_115165[(16)] = inst_115010__$1);

(statearr_115165[(11)] = inst_115007);

(statearr_115165[(19)] = inst_115008);

(statearr_115165[(20)] = inst_115011);

return statearr_115165;
})();
if(cljs.core.truth_(inst_115012)){
var statearr_115166_115271 = state_115118__$1;
(statearr_115166_115271[(1)] = (38));

} else {
var statearr_115167_115272 = state_115118__$1;
(statearr_115167_115272[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (41))){
var inst_114996 = (state_115118[(21)]);
var inst_114998 = (state_115118[(10)]);
var inst_115008 = (state_115118[(19)]);
var inst_114997 = (state_115118[(18)]);
var inst_115011 = (state_115118[(20)]);
var inst_115017 = (inst_114997 - (1));
var tmp115161 = inst_114996;
var tmp115162 = inst_114998;
var inst_114994 = inst_115008;
var inst_114995 = inst_115011;
var inst_114996__$1 = tmp115161;
var inst_114997__$1 = inst_115017;
var inst_114998__$1 = tmp115162;
var state_115118__$1 = (function (){var statearr_115168 = state_115118;
(statearr_115168[(21)] = inst_114996__$1);

(statearr_115168[(10)] = inst_114998__$1);

(statearr_115168[(22)] = inst_114994);

(statearr_115168[(18)] = inst_114997__$1);

(statearr_115168[(23)] = inst_114995);

return statearr_115168;
})();
var statearr_115169_115273 = state_115118__$1;
(statearr_115169_115273[(2)] = null);

(statearr_115169_115273[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (43))){
var inst_115064 = (state_115118[(2)]);
var state_115118__$1 = state_115118;
var statearr_115170_115274 = state_115118__$1;
(statearr_115170_115274[(2)] = inst_115064);

(statearr_115170_115274[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (61))){
var inst_115074 = (state_115118[(2)]);
var state_115118__$1 = state_115118;
var statearr_115171_115275 = state_115118__$1;
(statearr_115171_115275[(2)] = inst_115074);

(statearr_115171_115275[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (29))){
var state_115118__$1 = state_115118;
var statearr_115172_115276 = state_115118__$1;
(statearr_115172_115276[(2)] = null);

(statearr_115172_115276[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (44))){
var inst_114996 = (state_115118[(21)]);
var inst_115022 = (state_115118[(15)]);
var inst_115010 = (state_115118[(16)]);
var inst_115021 = cljs.core.count(inst_115010);
var inst_115022__$1 = (inst_114996 + inst_115021);
var inst_115023 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_115024 = [headers,vars,inst_115010];
var inst_115025 = cljs.core.PersistentHashMap.fromArrays(inst_115023,inst_115024);
var inst_115026 = (limit > inst_115022__$1);
var state_115118__$1 = (function (){var statearr_115173 = state_115118;
(statearr_115173[(15)] = inst_115022__$1);

(statearr_115173[(17)] = inst_115025);

return statearr_115173;
})();
if(cljs.core.truth_(inst_115026)){
var statearr_115174_115277 = state_115118__$1;
(statearr_115174_115277[(1)] = (47));

} else {
var statearr_115175_115278 = state_115118__$1;
(statearr_115175_115278[(1)] = (48));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (6))){
var state_115118__$1 = state_115118;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_115176_115279 = state_115118__$1;
(statearr_115176_115279[(1)] = (62));

} else {
var statearr_115177_115280 = state_115118__$1;
(statearr_115177_115280[(1)] = (63));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (28))){
var inst_114943 = (state_115118[(2)]);
var state_115118__$1 = state_115118;
var statearr_115178_115281 = state_115118__$1;
(statearr_115178_115281[(2)] = inst_114943);

(statearr_115178_115281[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (64))){
var inst_115081 = (state_115118[(2)]);
var inst_115082 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5(db,res,select_spec,inst_115081,opts);
var state_115118__$1 = state_115118;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_115118__$1,(65),inst_115082);
} else {
if((state_val_115119 === (51))){
var inst_115025 = (state_115118[(17)]);
var inst_115037 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$4(db,inst_115025,select_spec,opts);
var state_115118__$1 = state_115118;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_115118__$1,(54),inst_115037);
} else {
if((state_val_115119 === (25))){
var inst_114950 = (state_115118[(2)]);
var state_115118__$1 = state_115118;
var statearr_115179_115282 = state_115118__$1;
(statearr_115179_115282[(2)] = inst_114950);

(statearr_115179_115282[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (34))){
var inst_115076 = (state_115118[(2)]);
var state_115118__$1 = state_115118;
var statearr_115180_115283 = state_115118__$1;
(statearr_115180_115283[(2)] = inst_115076);

(statearr_115180_115283[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (17))){
var state_115118__$1 = state_115118;
var statearr_115181_115284 = state_115118__$1;
(statearr_115181_115284[(2)] = null);

(statearr_115181_115284[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (3))){
var inst_114902 = (state_115118[(2)]);
var state_115118__$1 = state_115118;
var statearr_115182_115285 = state_115118__$1;
(statearr_115182_115285[(2)] = inst_114902);


cljs.core.async.impl.ioc_helpers.process_exception(state_115118__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (12))){
var inst_114923 = cljs.core.not(orderBy);
var state_115118__$1 = state_115118;
if(inst_114923){
var statearr_115183_115286 = state_115118__$1;
(statearr_115183_115286[(1)] = (17));

} else {
var statearr_115184_115287 = state_115118__$1;
(statearr_115184_115287[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (2))){
var inst_115116 = (state_115118[(2)]);
var state_115118__$1 = state_115118;
return cljs.core.async.impl.ioc_helpers.return_chan(state_115118__$1,inst_115116);
} else {
if((state_val_115119 === (66))){
var state_115118__$1 = state_115118;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_115185_115288 = state_115118__$1;
(statearr_115185_115288[(1)] = (69));

} else {
var statearr_115186_115289 = state_115118__$1;
(statearr_115186_115289[(1)] = (70));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (23))){
var inst_114936 = (state_115118[(12)]);
var inst_114934 = cljs.core.second(orderBy);
var inst_114935 = fluree.db.util.core.index_of(groupBy,inst_114934);
var inst_114936__$1 = cljs.core.first(orderBy);
var inst_114937 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",inst_114936__$1);
var state_115118__$1 = (function (){var statearr_115187 = state_115118;
(statearr_115187[(12)] = inst_114936__$1);

(statearr_115187[(13)] = inst_114935);

return statearr_115187;
})();
if(inst_114937){
var statearr_115188_115290 = state_115118__$1;
(statearr_115188_115290[(1)] = (26));

} else {
var statearr_115189_115291 = state_115118__$1;
(statearr_115189_115291[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (47))){
var inst_115025 = (state_115118[(17)]);
var inst_115028 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$4(db,inst_115025,select_spec,opts);
var state_115118__$1 = state_115118;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_115118__$1,(50),inst_115028);
} else {
if((state_val_115119 === (35))){
var inst_114957 = (state_115118[(24)]);
var inst_114965 = (state_115118[(2)]);
var inst_114966 = fluree.db.util.async.throw_err(inst_114965);
var inst_114967 = [inst_114957];
var inst_114968 = [inst_114966];
var inst_114969 = cljs.core.PersistentHashMap.fromArrays(inst_114967,inst_114968);
var state_115118__$1 = state_115118;
var statearr_115190_115292 = state_115118__$1;
(statearr_115190_115292[(2)] = inst_114969);

(statearr_115190_115292[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (76))){
var state_115118__$1 = state_115118;
var statearr_115191_115293 = state_115118__$1;
(statearr_115191_115293[(1)] = (78));



return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (19))){
var inst_114952 = (state_115118[(2)]);
var state_115118__$1 = state_115118;
var statearr_115193_115294 = state_115118__$1;
(statearr_115193_115294[(2)] = inst_114952);

(statearr_115193_115294[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (57))){
var inst_115055 = (state_115118[(2)]);
var state_115118__$1 = state_115118;
var statearr_115194_115295 = state_115118__$1;
(statearr_115194_115295[(2)] = inst_115055);

(statearr_115194_115295[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (68))){
var inst_115112 = (state_115118[(2)]);
var state_115118__$1 = state_115118;
var statearr_115195_115296 = state_115118__$1;
(statearr_115195_115296[(2)] = inst_115112);

(statearr_115195_115296[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (11))){
var inst_114915 = cljs.core.first(orderBy);
var inst_114916 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_114915,"DESC");
var state_115118__$1 = state_115118;
if(inst_114916){
var statearr_115196_115297 = state_115118__$1;
(statearr_115196_115297[(1)] = (14));

} else {
var statearr_115197_115298 = state_115118__$1;
(statearr_115197_115298[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (9))){
var state_115118__$1 = state_115118;
var statearr_115198_115299 = state_115118__$1;
(statearr_115198_115299[(2)] = orderBy);

(statearr_115198_115299[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (5))){
var inst_114907 = fluree.db.query.fql.ad_hoc_group_by(res,groupBy);
var state_115118__$1 = (function (){var statearr_115199 = state_115118;
(statearr_115199[(14)] = inst_114907);

return statearr_115199;
})();
if(cljs.core.truth_(orderBy)){
var statearr_115200_115300 = state_115118__$1;
(statearr_115200_115300[(1)] = (8));

} else {
var statearr_115201_115301 = state_115118__$1;
(statearr_115201_115301[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (14))){
var inst_114907 = (state_115118[(14)]);
var inst_114918 = (function (){var group_map = inst_114907;
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(x,y));
});
})();
var state_115118__$1 = state_115118;
var statearr_115202_115302 = state_115118__$1;
(statearr_115202_115302[(2)] = inst_114918);

(statearr_115202_115302[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (45))){
var state_115118__$1 = state_115118;
var statearr_115203_115303 = state_115118__$1;
(statearr_115203_115303[(2)] = null);

(statearr_115203_115303[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (53))){
var inst_115057 = (state_115118[(2)]);
var state_115118__$1 = state_115118;
var statearr_115204_115304 = state_115118__$1;
(statearr_115204_115304[(2)] = inst_115057);

(statearr_115204_115304[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (78))){
var inst_115085 = (state_115118[(7)]);
var state_115118__$1 = state_115118;
var statearr_115205_115305 = state_115118__$1;
(statearr_115205_115305[(2)] = inst_115085);

(statearr_115205_115305[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (26))){
var inst_114936 = (state_115118[(12)]);
var inst_114935 = (state_115118[(13)]);
var inst_114907 = (state_115118[(14)]);
var inst_114939 = (function (){var group_map = inst_114907;
var orderByIdx = inst_114935;
var orderDirection = inst_114936;
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx)));
});
})();
var state_115118__$1 = state_115118;
var statearr_115206_115306 = state_115118__$1;
(statearr_115206_115306[(2)] = inst_114939);

(statearr_115206_115306[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (16))){
var inst_114921 = (state_115118[(2)]);
var state_115118__$1 = state_115118;
var statearr_115207_115307 = state_115118__$1;
(statearr_115207_115307[(2)] = inst_114921);

(statearr_115207_115307[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (79))){
var state_115118__$1 = state_115118;
var statearr_115208_115308 = state_115118__$1;
(statearr_115208_115308[(2)] = null);

(statearr_115208_115308[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (38))){
var inst_114998 = (state_115118[(10)]);
var state_115118__$1 = state_115118;
var statearr_115209_115309 = state_115118__$1;
(statearr_115209_115309[(2)] = inst_114998);

(statearr_115209_115309[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (30))){
var state_115118__$1 = state_115118;
var statearr_115210_115310 = state_115118__$1;
(statearr_115210_115310[(2)] = null);

(statearr_115210_115310[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (73))){
var state_115118__$1 = state_115118;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_115211_115311 = state_115118__$1;
(statearr_115211_115311[(1)] = (75));

} else {
var statearr_115212_115312 = state_115118__$1;
(statearr_115212_115312[(1)] = (76));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (10))){
var inst_114913 = (state_115118[(2)]);
var state_115118__$1 = state_115118;
if(cljs.core.truth_(inst_114913)){
var statearr_115213_115313 = state_115118__$1;
(statearr_115213_115313[(1)] = (11));

} else {
var statearr_115214_115314 = state_115118__$1;
(statearr_115214_115314[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (18))){
var state_115118__$1 = state_115118;
if(cljs.core.truth_(orderBy)){
var statearr_115215_115315 = state_115118__$1;
(statearr_115215_115315[(1)] = (20));

} else {
var statearr_115216_115316 = state_115118__$1;
(statearr_115216_115316[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (52))){
var inst_115022 = (state_115118[(15)]);
var inst_115043 = (limit < inst_115022);
var state_115118__$1 = state_115118;
if(cljs.core.truth_(inst_115043)){
var statearr_115217_115317 = state_115118__$1;
(statearr_115217_115317[(1)] = (55));

} else {
var statearr_115218_115318 = state_115118__$1;
(statearr_115218_115318[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (67))){
var state_115118__$1 = state_115118;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_115219_115319 = state_115118__$1;
(statearr_115219_115319[(1)] = (72));

} else {
var statearr_115220_115320 = state_115118__$1;
(statearr_115220_115320[(1)] = (73));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (71))){
var inst_115095 = (state_115118[(2)]);
var state_115118__$1 = state_115118;
var statearr_115221_115321 = state_115118__$1;
(statearr_115221_115321[(2)] = inst_115095);

(statearr_115221_115321[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (42))){
var state_115118__$1 = state_115118;
var statearr_115222_115322 = state_115118__$1;
(statearr_115222_115322[(1)] = (44));



return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (80))){
var inst_115106 = (state_115118[(2)]);
var state_115118__$1 = state_115118;
var statearr_115224_115323 = state_115118__$1;
(statearr_115224_115323[(2)] = inst_115106);

(statearr_115224_115323[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (37))){
var inst_114954 = (state_115118[(8)]);
var inst_115068 = (state_115118[(2)]);
var state_115118__$1 = (function (){var statearr_115225 = state_115118;
(statearr_115225[(9)] = inst_115068);

return statearr_115225;
})();
if(cljs.core.truth_(inst_114954)){
var statearr_115226_115324 = state_115118__$1;
(statearr_115226_115324[(1)] = (59));

} else {
var statearr_115227_115325 = state_115118__$1;
(statearr_115227_115325[(1)] = (60));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (63))){
var state_115118__$1 = state_115118;
var statearr_115228_115326 = state_115118__$1;
(statearr_115228_115326[(2)] = limit);

(statearr_115228_115326[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (8))){
var inst_114909 = cljs.core.second(orderBy);
var inst_114910 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_114909,groupBy);
var state_115118__$1 = state_115118;
var statearr_115229_115327 = state_115118__$1;
(statearr_115229_115327[(2)] = inst_114910);

(statearr_115229_115327[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115119 === (49))){
var inst_115059 = (state_115118[(2)]);
var state_115118__$1 = state_115118;
var statearr_115230_115328 = state_115118__$1;
(statearr_115230_115328[(2)] = inst_115059);

(statearr_115230_115328[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__100742__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__100742__auto____0 = (function (){
var statearr_115231 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_115231[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__100742__auto__);

(statearr_115231[(1)] = (1));

return statearr_115231;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__100742__auto____1 = (function (state_115118){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_115118);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e115232){if((e115232 instanceof Object)){
var ex__100745__auto__ = e115232;
var statearr_115233_115329 = state_115118;
(statearr_115233_115329[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_115118);

return cljs.core.cst$kw$recur;
} else {
throw e115232;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__115330 = state_115118;
state_115118 = G__115330;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__100742__auto__ = function(state_115118){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__100742__auto____1.call(this,state_115118);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__100742__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__100742__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_115234 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_115234[(6)] = c__100848__auto__);

return statearr_115234;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
fluree.db.query.fql.get_ad_hoc_select_spec = (function fluree$db$query$fql$get_ad_hoc_select_spec(headers,vars,p__115333,opts){
var map__115334 = p__115333;
var map__115334__$1 = (((((!((map__115334 == null))))?(((((map__115334.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__115334.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__115334):map__115334);
var query_map = map__115334__$1;
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__115334__$1,cljs.core.cst$kw$select);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__115334__$1,cljs.core.cst$kw$orderBy);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__115334__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__115334__$1,cljs.core.cst$kw$offset);
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__115334__$1,cljs.core.cst$kw$selectDistinct);
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__115334__$1,cljs.core.cst$kw$prettyPrint);
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__115334__$1,cljs.core.cst$kw$selectOne);
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__115334__$1,cljs.core.cst$kw$groupBy);
var selectReduced = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__115334__$1,cljs.core.cst$kw$selectReduced);
var select_smt = (function (){var or__4126__auto__ = selectOne;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = select;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
var or__4126__auto____$2 = selectDistinct;
if(cljs.core.truth_(or__4126__auto____$2)){
return or__4126__auto____$2;
} else {
return selectReduced;
}
}
}
})();
var inVector_QMARK_ = cljs.core.vector_QMARK_(select_smt);
var select_smt__$1 = ((inVector_QMARK_)?select_smt:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [select_smt], null));
var parsed_select = fluree.db.query.fql.parse_select(headers,vars,select_smt__$1);
var aggregates = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__115331_SHARP_){
return cljs.core.contains_QMARK_(p1__115331_SHARP_,cljs.core.cst$kw$code);
}),parsed_select);
var expandMap_QMARK_ = cljs.core.some((function (p1__115332_SHARP_){
return cljs.core.contains_QMARK_(p1__115332_SHARP_,cljs.core.cst$kw$selection);
}),parsed_select);
var aggregates__$1 = ((cljs.core.empty_QMARK_(aggregates))?null:aggregates);
var orderBy__$1 = (function (){var temp__5735__auto__ = cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5735__auto__)){
var orderBy__$1 = temp__5735__auto__;
if(cljs.core.truth_((function (){var or__4126__auto__ = typeof orderBy__$1 === 'string';
if(or__4126__auto__){
return or__4126__auto__;
} else {
if(cljs.core.vector_QMARK_(orderBy__$1)){
var G__115343 = cljs.core.first(orderBy__$1);
var fexpr__115342 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["DESC",null,"ASC",null], null), null);
return (fexpr__115342.cljs$core$IFn$_invoke$arity$1 ? fexpr__115342.cljs$core$IFn$_invoke$arity$1(G__115343) : fexpr__115342.call(null,G__115343));
} else {
return false;
}
}
})())){
if(cljs.core.vector_QMARK_(orderBy__$1)){
return orderBy__$1;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",orderBy__$1], null);
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid orderBy clause, must by variable or two-tuple formatted ['ASC' or 'DESC', var]. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orderBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
} else {
return null;
}
})();
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$expandMaps_QMARK_,cljs.core.cst$kw$limit,cljs.core.cst$kw$offset,cljs.core.cst$kw$aggregates,cljs.core.cst$kw$selectOne_QMARK_,cljs.core.cst$kw$prettyPrint,cljs.core.cst$kw$groupBy,cljs.core.cst$kw$selectDistinct_QMARK_,cljs.core.cst$kw$select,cljs.core.cst$kw$orderBy,cljs.core.cst$kw$inVector_QMARK_],[expandMap_QMARK_,(function (){var or__4126__auto__ = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (100);
}
})(),(function (){var or__4126__auto__ = cljs.core.cst$kw$offset.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})(),aggregates__$1,cljs.core.boolean$(selectOne),(function (){var or__4126__auto__ = cljs.core.cst$kw$prettyPrint.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return false;
}
})(),cljs.core.cst$kw$groupBy.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.boolean$((function (){var or__4126__auto__ = selectDistinct;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return selectReduced;
}
})()),parsed_select,orderBy__$1,inVector_QMARK_]);
});
fluree.db.query.fql.construct_triples = (function fluree$db$query$fql$construct_triples(p__115344,p__115345){
var map__115346 = p__115344;
var map__115346__$1 = (((((!((map__115346 == null))))?(((((map__115346.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__115346.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__115346):map__115346);
var query_map = map__115346__$1;
var construct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__115346__$1,cljs.core.cst$kw$construct);
var map__115347 = p__115345;
var map__115347__$1 = (((((!((map__115347 == null))))?(((((map__115347.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__115347.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__115347):map__115347);
var where_result = map__115347__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__115347__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__115347__$1,cljs.core.cst$kw$tuples);
var vec__115350 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (construct_item){
var temp__5733__auto__ = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(construct_item));
if(cljs.core.truth_(temp__5733__auto__)){
var index_of = temp__5733__auto__;
return (function (row){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(row,index_of);
});
} else {
return (function (row){
return construct_item;
});
}
}),construct);
var fn1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__115350,(0),null);
var fn2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__115350,(1),null);
var fn3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__115350,(2),null);
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(res) : fn1.call(null,res)),(fn2.cljs$core$IFn$_invoke$arity$1 ? fn2.cljs$core$IFn$_invoke$arity$1(res) : fn2.call(null,res)),(fn3.cljs$core$IFn$_invoke$arity$1 ? fn3.cljs$core$IFn$_invoke$arity$1(res) : fn3.call(null,res))], null);
}),tuples);
});
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,fuel,max_fuel,query_map,opts){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_115380){
var state_val_115381 = (state_115380[(1)]);
if((state_val_115381 === (7))){
var state_115380__$1 = state_115380;
var statearr_115382_115398 = state_115380__$1;
(statearr_115382_115398[(1)] = (9));



return cljs.core.cst$kw$recur;
} else {
if((state_val_115381 === (1))){
var state_115380__$1 = state_115380;
var statearr_115384_115399 = state_115380__$1;
(statearr_115384_115399[(2)] = null);

(statearr_115384_115399[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115381 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_115380,(3),Error,null,(2));
var inst_115357 = fluree.db.query.analytical.q(query_map,fuel,max_fuel,db,opts);
var state_115380__$1 = state_115380;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_115380__$1,(5),inst_115357);
} else {
if((state_val_115381 === (6))){
var inst_115360 = (state_115380[(7)]);
var state_115380__$1 = state_115380;
var statearr_115385_115400 = state_115380__$1;
(statearr_115385_115400[(2)] = inst_115360);

(statearr_115385_115400[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115381 === (3))){
var inst_115353 = (state_115380[(2)]);
var state_115380__$1 = state_115380;
var statearr_115386_115401 = state_115380__$1;
(statearr_115386_115401[(2)] = inst_115353);


cljs.core.async.impl.ioc_helpers.process_exception(state_115380__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_115381 === (12))){
var inst_115370 = (state_115380[(2)]);
var inst_115371 = fluree.db.util.async.throw_err(inst_115370);
var state_115380__$1 = state_115380;
var statearr_115387_115402 = state_115380__$1;
(statearr_115387_115402[(2)] = inst_115371);

(statearr_115387_115402[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115381 === (2))){
var inst_115378 = (state_115380[(2)]);
var state_115380__$1 = state_115380;
return cljs.core.async.impl.ioc_helpers.return_chan(state_115380__$1,inst_115378);
} else {
if((state_val_115381 === (11))){
var inst_115374 = (state_115380[(2)]);
var state_115380__$1 = state_115380;
var statearr_115388_115403 = state_115380__$1;
(statearr_115388_115403[(2)] = inst_115374);

(statearr_115388_115403[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115381 === (9))){
var inst_115360 = (state_115380[(7)]);
var inst_115365 = cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(inst_115360);
var inst_115366 = cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(inst_115360);
var inst_115367 = fluree.db.query.fql.get_ad_hoc_select_spec(inst_115365,inst_115366,query_map,opts);
var inst_115368 = fluree.db.query.fql.process_ad_hoc_res(db,inst_115360,inst_115367,opts);
var state_115380__$1 = state_115380;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_115380__$1,(12),inst_115368);
} else {
if((state_val_115381 === (5))){
var inst_115360 = (state_115380[(7)]);
var inst_115359 = (state_115380[(2)]);
var inst_115360__$1 = fluree.db.util.async.throw_err(inst_115359);
var inst_115361 = fluree.db.util.core.exception_QMARK_(inst_115360__$1);
var state_115380__$1 = (function (){var statearr_115389 = state_115380;
(statearr_115389[(7)] = inst_115360__$1);

return statearr_115389;
})();
if(inst_115361){
var statearr_115390_115404 = state_115380__$1;
(statearr_115390_115404[(1)] = (6));

} else {
var statearr_115391_115405 = state_115380__$1;
(statearr_115391_115405[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115381 === (10))){
var state_115380__$1 = state_115380;
var statearr_115392_115406 = state_115380__$1;
(statearr_115392_115406[(2)] = null);

(statearr_115392_115406[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115381 === (8))){
var inst_115376 = (state_115380[(2)]);
var state_115380__$1 = state_115380;
var statearr_115393_115407 = state_115380__$1;
(statearr_115393_115407[(2)] = inst_115376);


cljs.core.async.impl.ioc_helpers.process_exception(state_115380__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$ad_hoc_query_$_state_machine__100742__auto__ = null;
var fluree$db$query$fql$ad_hoc_query_$_state_machine__100742__auto____0 = (function (){
var statearr_115394 = [null,null,null,null,null,null,null,null];
(statearr_115394[(0)] = fluree$db$query$fql$ad_hoc_query_$_state_machine__100742__auto__);

(statearr_115394[(1)] = (1));

return statearr_115394;
});
var fluree$db$query$fql$ad_hoc_query_$_state_machine__100742__auto____1 = (function (state_115380){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_115380);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e115395){if((e115395 instanceof Object)){
var ex__100745__auto__ = e115395;
var statearr_115396_115408 = state_115380;
(statearr_115396_115408[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_115380);

return cljs.core.cst$kw$recur;
} else {
throw e115395;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__115409 = state_115380;
state_115380 = G__115409;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$query$fql$ad_hoc_query_$_state_machine__100742__auto__ = function(state_115380){
switch(arguments.length){
case 0:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__100742__auto____1.call(this,state_115380);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$ad_hoc_query_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$ad_hoc_query_$_state_machine__100742__auto____0;
fluree$db$query$fql$ad_hoc_query_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$ad_hoc_query_$_state_machine__100742__auto____1;
return fluree$db$query$fql$ad_hoc_query_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_115397 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_115397[(6)] = c__100848__auto__);

return statearr_115397;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
/**
 * Returns core async channel with results
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(var_args){
var G__115411 = arguments.length;
switch (G__115411) {
case 2:
return fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
return fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$3(db,query_map,null);
}));

(fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$3 = (function (db,query_map,opts){
var map__115412 = query_map;
var map__115412__$1 = (((((!((map__115412 == null))))?(((((map__115412.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__115412.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__115412):map__115412);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__115412__$1,cljs.core.cst$kw$select);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__115412__$1,cljs.core.cst$kw$orderBy);
var where = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__115412__$1,cljs.core.cst$kw$where);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__115412__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__115412__$1,cljs.core.cst$kw$offset);
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__115412__$1,cljs.core.cst$kw$component);
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__115412__$1,cljs.core.cst$kw$selectDistinct);
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__115412__$1,cljs.core.cst$kw$prettyPrint);
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__115412__$1,cljs.core.cst$kw$selectOne);
var from = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__115412__$1,cljs.core.cst$kw$from);
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__115412__$1,cljs.core.cst$kw$groupBy);
var opts_SINGLEQUOTE_ = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$limit,limit,cljs.core.cst$kw$offset,(function (){var or__4126__auto__ = offset;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})(),cljs.core.cst$kw$component,component,cljs.core.cst$kw$orderBy,orderBy,cljs.core.cst$kw$groupBy,groupBy,cljs.core.cst$kw$prettyPrint,prettyPrint], null),opts,cljs.core.cst$kw$opts.cljs$core$IFn$_invoke$arity$1(query_map)], 0));
var opts_SINGLEQUOTE__SINGLEQUOTE_ = (cljs.core.truth_(selectOne)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts_SINGLEQUOTE_,cljs.core.cst$kw$limit,(1)):opts_SINGLEQUOTE_);
var opts_STAR_ = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(opts_SINGLEQUOTE__SINGLEQUOTE_,cljs.core.cst$kw$cache);
if(cljs.core.truth_(cljs.core.cst$kw$cache.cljs$core$IFn$_invoke$arity$1(opts_STAR_))){
var oc = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$object_DASH_cache], null));
var G__115414 = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query,cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(db),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(query_map,cljs.core.cst$kw$opts),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(opts_SINGLEQUOTE__SINGLEQUOTE_,cljs.core.cst$kw$fuel),cljs.core.cst$kw$auth.cljs$core$IFn$_invoke$arity$1(db)], null);
var G__115415 = (function (_){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__100848__auto___115950 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_115425){
var state_val_115426 = (state_115425[(1)]);
if((state_val_115426 === (1))){
var inst_115416 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115417 = [cljs.core.cst$kw$opts,cljs.core.cst$kw$cache];
var inst_115418 = (new cljs.core.PersistentVector(null,2,(5),inst_115416,inst_115417,null));
var inst_115419 = cljs.core.assoc_in(query_map,inst_115418,false);
var inst_115420 = fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$3(db,inst_115419,opts);
var state_115425__$1 = state_115425;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_115425__$1,(2),inst_115420);
} else {
if((state_val_115426 === (2))){
var inst_115422 = (state_115425[(2)]);
var inst_115423 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_115422);
var state_115425__$1 = state_115425;
return cljs.core.async.impl.ioc_helpers.return_chan(state_115425__$1,inst_115423);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__100742__auto__ = null;
var fluree$db$query$fql$state_machine__100742__auto____0 = (function (){
var statearr_115427 = [null,null,null,null,null,null,null];
(statearr_115427[(0)] = fluree$db$query$fql$state_machine__100742__auto__);

(statearr_115427[(1)] = (1));

return statearr_115427;
});
var fluree$db$query$fql$state_machine__100742__auto____1 = (function (state_115425){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_115425);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e115428){if((e115428 instanceof Object)){
var ex__100745__auto__ = e115428;
var statearr_115429_115951 = state_115425;
(statearr_115429_115951[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_115425);

return cljs.core.cst$kw$recur;
} else {
throw e115428;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__115952 = state_115425;
state_115425 = G__115952;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__100742__auto__ = function(state_115425){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__100742__auto____1.call(this,state_115425);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__100742__auto____0;
fluree$db$query$fql$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__100742__auto____1;
return fluree$db$query$fql$state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_115430 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_115430[(6)] = c__100848__auto___115950);

return statearr_115430;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));


return pc;
});
return (oc.cljs$core$IFn$_invoke$arity$2 ? oc.cljs$core$IFn$_invoke$arity$2(G__115414,G__115415) : oc.call(null,G__115414,G__115415));
} else {
var max_fuel = cljs.core.cst$kw$max_DASH_fuel.cljs$core$IFn$_invoke$arity$1(opts_STAR_);
var fuel = (function (){var or__4126__auto__ = cljs.core.cst$kw$fuel.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.truth_((function (){var or__4126__auto____$1 = max_fuel;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return cljs.core.cst$kw$meta.cljs$core$IFn$_invoke$arity$1(opts);
}
})())){
return cljs.core.volatile_BANG_((0));
} else {
return null;
}
}
})();
if(cljs.core.sequential_QMARK_(where)){
return fluree.db.query.fql.ad_hoc_query(db,fuel,max_fuel,query_map,opts_STAR_);
} else {
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_115770){
var state_val_115771 = (state_115770[(1)]);
if((state_val_115771 === (121))){
var inst_115480 = (state_115770[(7)]);
var inst_115524 = (state_115770[(8)]);
var inst_115523 = (state_115770[(9)]);
var inst_115748 = (state_115770[(10)]);
var inst_115478 = (state_115770[(11)]);
var inst_115750 = fluree.db.query.fql.sort_offset_and_limit_res(inst_115523,inst_115524,inst_115480,inst_115478,inst_115748);
var state_115770__$1 = state_115770;
var statearr_115772_115953 = state_115770__$1;
(statearr_115772_115953[(2)] = inst_115750);

(statearr_115772_115953[(1)] = (123));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (65))){
var inst_115586 = (state_115770[(2)]);
var inst_115587 = fluree.db.util.async.throw_err(inst_115586);
var state_115770__$1 = state_115770;
var statearr_115773_115954 = state_115770__$1;
(statearr_115773_115954[(2)] = inst_115587);

(statearr_115773_115954[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (70))){
var inst_115617 = typeof from === 'string';
var state_115770__$1 = state_115770;
if(cljs.core.truth_(inst_115617)){
var statearr_115774_115955 = state_115770__$1;
(statearr_115774_115955[(1)] = (77));

} else {
var statearr_115775_115956 = state_115770__$1;
(statearr_115775_115956[(1)] = (78));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (62))){
var inst_115480 = (state_115770[(7)]);
var inst_115478 = (state_115770[(11)]);
var inst_115571 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_115572 = [inst_115478,inst_115480];
var inst_115573 = cljs.core.PersistentHashMap.fromArrays(inst_115571,inst_115572);
var state_115770__$1 = state_115770;
var statearr_115776_115957 = state_115770__$1;
(statearr_115776_115957[(2)] = inst_115573);

(statearr_115776_115957[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (74))){
var inst_115607 = (state_115770[(2)]);
var inst_115608 = fluree.db.query.range._block_or_tx_collection(db,inst_115607);
var state_115770__$1 = state_115770;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_115770__$1,(75),inst_115608);
} else {
if((state_val_115771 === (110))){
var inst_115702 = (state_115770[(2)]);
var inst_115703 = fluree.db.util.async.throw_err(inst_115702);
var state_115770__$1 = state_115770;
var statearr_115777_115958 = state_115770__$1;
(statearr_115777_115958[(2)] = inst_115703);

(statearr_115777_115958[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (128))){
var inst_115753 = (state_115770[(12)]);
var state_115770__$1 = state_115770;
var statearr_115778_115959 = state_115770__$1;
(statearr_115778_115959[(2)] = inst_115753);

(statearr_115778_115959[(1)] = (129));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (7))){
var inst_115455 = (state_115770[(2)]);
var inst_115457 = (opts_STAR_ == null);
var inst_115458 = cljs.core.not(inst_115457);
var state_115770__$1 = (function (){var statearr_115779 = state_115770;
(statearr_115779[(13)] = inst_115455);

return statearr_115779;
})();
if(inst_115458){
var statearr_115780_115960 = state_115770__$1;
(statearr_115780_115960[(1)] = (14));

} else {
var statearr_115781_115961 = state_115770__$1;
(statearr_115781_115961[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (59))){
var inst_115561 = (state_115770[(14)]);
var state_115770__$1 = state_115770;
var statearr_115782_115962 = state_115770__$1;
(statearr_115782_115962[(2)] = inst_115561);

(statearr_115782_115962[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (86))){
var inst_115663 = cljs.core.sequential_QMARK_(from);
var inst_115664 = cljs.core.every_QMARK_(fluree.db.util.core.subj_ident_QMARK_,from);
var inst_115665 = ((inst_115663) && (inst_115664));
var state_115770__$1 = state_115770;
if(cljs.core.truth_(inst_115665)){
var statearr_115783_115963 = state_115770__$1;
(statearr_115783_115963[(1)] = (96));

} else {
var statearr_115784_115964 = state_115770__$1;
(statearr_115784_115964[(1)] = (97));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (20))){
var inst_115473 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,opts_STAR_);
var state_115770__$1 = state_115770;
var statearr_115785_115965 = state_115770__$1;
(statearr_115785_115965[(2)] = inst_115473);

(statearr_115785_115965[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (72))){
var inst_115601 = cljs.core.PersistentHashMap.EMPTY;
var state_115770__$1 = state_115770;
var statearr_115786_115966 = state_115770__$1;
(statearr_115786_115966[(2)] = inst_115601);

(statearr_115786_115966[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (58))){
var inst_115561 = (state_115770[(14)]);
var inst_115563 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_115564 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_115561,inst_115563);
var state_115770__$1 = state_115770;
var statearr_115787_115967 = state_115770__$1;
(statearr_115787_115967[(2)] = inst_115564);

(statearr_115787_115967[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (60))){
var inst_115477 = (state_115770[(15)]);
var inst_115567 = (state_115770[(2)]);
var state_115770__$1 = (function (){var statearr_115788 = state_115770;
(statearr_115788[(16)] = inst_115567);

return statearr_115788;
})();
if(cljs.core.truth_(inst_115477)){
var statearr_115789_115968 = state_115770__$1;
(statearr_115789_115968[(1)] = (61));

} else {
var statearr_115790_115969 = state_115770__$1;
(statearr_115790_115969[(1)] = (62));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (27))){
var inst_115518 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115519 = [null,null];
var inst_115520 = (new cljs.core.PersistentVector(null,2,(5),inst_115518,inst_115519,null));
var state_115770__$1 = state_115770;
var statearr_115791_115970 = state_115770__$1;
(statearr_115791_115970[(2)] = inst_115520);

(statearr_115791_115970[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (1))){
var state_115770__$1 = state_115770;
var statearr_115792_115971 = state_115770__$1;
(statearr_115792_115971[(2)] = null);

(statearr_115792_115971[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (69))){
var inst_115477 = (state_115770[(15)]);
var state_115770__$1 = state_115770;
if(cljs.core.truth_(inst_115477)){
var statearr_115793_115972 = state_115770__$1;
(statearr_115793_115972[(1)] = (72));

} else {
var statearr_115794_115973 = state_115770__$1;
(statearr_115794_115973[(1)] = (73));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (101))){
var inst_115679 = (state_115770[(17)]);
var state_115770__$1 = state_115770;
var statearr_115795_115974 = state_115770__$1;
(statearr_115795_115974[(2)] = inst_115679);

(statearr_115795_115974[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (24))){
var inst_115481 = (state_115770[(18)]);
var state_115770__$1 = state_115770;
var statearr_115796_115975 = state_115770__$1;
(statearr_115796_115975[(2)] = inst_115481);

(statearr_115796_115975[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (102))){
var inst_115685 = (state_115770[(19)]);
var inst_115690 = cljs.core.int_QMARK_(inst_115685);
var state_115770__$1 = state_115770;
if(inst_115690){
var statearr_115797_115976 = state_115770__$1;
(statearr_115797_115976[(1)] = (104));

} else {
var statearr_115798_115977 = state_115770__$1;
(statearr_115798_115977[(1)] = (105));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (55))){
var inst_115555 = (state_115770[(20)]);
var inst_115557 = fluree.db.query.fql.fuel_flake_transducer(fuel,max_fuel);
var inst_115558 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_115555,inst_115557);
var state_115770__$1 = state_115770;
var statearr_115799_115978 = state_115770__$1;
(statearr_115799_115978[(2)] = inst_115558);

(statearr_115799_115978[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (85))){
var inst_115639 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,from,false);
var state_115770__$1 = state_115770;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_115770__$1,(88),inst_115639);
} else {
if((state_val_115771 === (39))){
var inst_115549 = typeof from === 'string';
var inst_115550 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(from);
var inst_115551 = clojure.string.includes_QMARK_(inst_115550,"/");
var inst_115552 = ((inst_115549) && (inst_115551));
var state_115770__$1 = state_115770;
if(cljs.core.truth_(inst_115552)){
var statearr_115800_115979 = state_115770__$1;
(statearr_115800_115979[(1)] = (52));

} else {
var statearr_115801_115980 = state_115770__$1;
(statearr_115801_115980[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (88))){
var inst_115642 = (state_115770[(21)]);
var inst_115641 = (state_115770[(2)]);
var inst_115642__$1 = fluree.db.util.async.throw_err(inst_115641);
var inst_115643 = (inst_115642__$1 == null);
var state_115770__$1 = (function (){var statearr_115802 = state_115770;
(statearr_115802[(21)] = inst_115642__$1);

return statearr_115802;
})();
if(cljs.core.truth_(inst_115643)){
var statearr_115803_115981 = state_115770__$1;
(statearr_115803_115981[(1)] = (89));

} else {
var statearr_115804_115982 = state_115770__$1;
(statearr_115804_115982[(1)] = (90));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (46))){
var state_115770__$1 = state_115770;
var statearr_115805_115983 = state_115770__$1;
(statearr_115805_115983[(2)] = null);

(statearr_115805_115983[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_115770,(3),Error,null,(2));
var state_115770__$1 = state_115770;
if(cljs.core.truth_(select)){
var statearr_115806_115984 = state_115770__$1;
(statearr_115806_115984[(1)] = (5));

} else {
var statearr_115807_115985 = state_115770__$1;
(statearr_115807_115985[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (77))){
var inst_115477 = (state_115770[(15)]);
var state_115770__$1 = state_115770;
if(cljs.core.truth_(inst_115477)){
var statearr_115808_115986 = state_115770__$1;
(statearr_115808_115986[(1)] = (80));

} else {
var statearr_115809_115987 = state_115770__$1;
(statearr_115809_115987[(1)] = (81));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (106))){
var inst_115705 = (state_115770[(22)]);
var inst_115705__$1 = (state_115770[(2)]);
var state_115770__$1 = (function (){var statearr_115810 = state_115770;
(statearr_115810[(22)] = inst_115705__$1);

return statearr_115810;
})();
if(cljs.core.truth_(inst_115705__$1)){
var statearr_115811_115988 = state_115770__$1;
(statearr_115811_115988[(1)] = (111));

} else {
var statearr_115812_115989 = state_115770__$1;
(statearr_115812_115989[(1)] = (112));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (119))){
var state_115770__$1 = state_115770;
var statearr_115813_115990 = state_115770__$1;
(statearr_115813_115990[(2)] = null);

(statearr_115813_115990[(1)] = (120));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (95))){
var inst_115654 = (state_115770[(23)]);
var inst_115661 = (state_115770[(2)]);
var state_115770__$1 = (function (){var statearr_115814 = state_115770;
(statearr_115814[(24)] = inst_115661);

return statearr_115814;
})();
var statearr_115815_115991 = state_115770__$1;
(statearr_115815_115991[(2)] = inst_115654);

(statearr_115815_115991[(1)] = (87));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (54))){
var inst_115746 = (state_115770[(2)]);
var state_115770__$1 = state_115770;
var statearr_115816_115992 = state_115770__$1;
(statearr_115816_115992[(2)] = inst_115746);

(statearr_115816_115992[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (92))){
var inst_115653 = (state_115770[(2)]);
var inst_115654 = fluree.db.util.async.throw_err(inst_115653);
var state_115770__$1 = (function (){var statearr_115817 = state_115770;
(statearr_115817[(23)] = inst_115654);

return statearr_115817;
})();
if(cljs.core.truth_(fuel)){
var statearr_115818_115993 = state_115770__$1;
(statearr_115818_115993[(1)] = (93));

} else {
var statearr_115819_115994 = state_115770__$1;
(statearr_115819_115994[(1)] = (94));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (104))){
var inst_115685 = (state_115770[(19)]);
var state_115770__$1 = state_115770;
var statearr_115820_115995 = state_115770__$1;
(statearr_115820_115995[(2)] = inst_115685);

(statearr_115820_115995[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (15))){
var state_115770__$1 = state_115770;
var statearr_115821_115996 = state_115770__$1;
(statearr_115821_115996[(2)] = false);

(statearr_115821_115996[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (48))){
var inst_115477 = (state_115770[(15)]);
var inst_115539 = (state_115770[(2)]);
var state_115770__$1 = (function (){var statearr_115822 = state_115770;
(statearr_115822[(25)] = inst_115539);

return statearr_115822;
})();
if(cljs.core.truth_(inst_115477)){
var statearr_115823_115997 = state_115770__$1;
(statearr_115823_115997[(1)] = (49));

} else {
var statearr_115824_115998 = state_115770__$1;
(statearr_115824_115998[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (50))){
var inst_115480 = (state_115770[(7)]);
var state_115770__$1 = state_115770;
var statearr_115825_115999 = state_115770__$1;
(statearr_115825_115999[(2)] = inst_115480);

(statearr_115825_115999[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (116))){
var inst_115478 = (state_115770[(11)]);
var state_115770__$1 = state_115770;
var statearr_115826_116000 = state_115770__$1;
(statearr_115826_116000[(2)] = inst_115478);

(statearr_115826_116000[(1)] = (117));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (75))){
var inst_115488 = (state_115770[(26)]);
var inst_115490 = (state_115770[(27)]);
var inst_115610 = (state_115770[(2)]);
var inst_115611 = fluree.db.util.async.throw_err(inst_115610);
var inst_115612 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_115490,fuel,max_fuel,inst_115488,inst_115611);
var state_115770__$1 = state_115770;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_115770__$1,(76),inst_115612);
} else {
if((state_val_115771 === (99))){
var inst_115678 = (state_115770[(28)]);
var inst_115685 = (state_115770[(19)]);
var inst_115684 = cljs.core.seq(inst_115678);
var inst_115685__$1 = cljs.core.first(inst_115684);
var inst_115686 = cljs.core.next(inst_115684);
var inst_115687 = cljs.core.not(inst_115685__$1);
var state_115770__$1 = (function (){var statearr_115827 = state_115770;
(statearr_115827[(29)] = inst_115686);

(statearr_115827[(19)] = inst_115685__$1);

return statearr_115827;
})();
if(inst_115687){
var statearr_115828_116001 = state_115770__$1;
(statearr_115828_116001[(1)] = (101));

} else {
var statearr_115829_116002 = state_115770__$1;
(statearr_115829_116002[(1)] = (102));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (21))){
var state_115770__$1 = state_115770;
var statearr_115830_116003 = state_115770__$1;
(statearr_115830_116003[(2)] = opts_STAR_);

(statearr_115830_116003[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (31))){
var inst_115516 = (state_115770[(2)]);
var state_115770__$1 = state_115770;
var statearr_115831_116004 = state_115770__$1;
(statearr_115831_116004[(2)] = inst_115516);

(statearr_115831_116004[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (113))){
var inst_115686 = (state_115770[(29)]);
var inst_115710 = (state_115770[(2)]);
var inst_115678 = inst_115686;
var inst_115679 = inst_115710;
var state_115770__$1 = (function (){var statearr_115832 = state_115770;
(statearr_115832[(28)] = inst_115678);

(statearr_115832[(17)] = inst_115679);

return statearr_115832;
})();
var statearr_115833_116005 = state_115770__$1;
(statearr_115833_116005[(2)] = null);

(statearr_115833_116005[(1)] = (99));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (32))){
var inst_115477 = (state_115770[(15)]);
var inst_115502 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115503 = [inst_115477,"ASC"];
var inst_115504 = (new cljs.core.PersistentVector(null,2,(5),inst_115502,inst_115503,null));
var state_115770__$1 = state_115770;
var statearr_115834_116006 = state_115770__$1;
(statearr_115834_116006[(2)] = inst_115504);

(statearr_115834_116006[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (40))){
var inst_115523 = (state_115770[(9)]);
var inst_115748 = (state_115770[(2)]);
var state_115770__$1 = (function (){var statearr_115835 = state_115770;
(statearr_115835[(10)] = inst_115748);

return statearr_115835;
})();
if(cljs.core.truth_(inst_115523)){
var statearr_115836_116007 = state_115770__$1;
(statearr_115836_116007[(1)] = (121));

} else {
var statearr_115837_116008 = state_115770__$1;
(statearr_115837_116008[(1)] = (122));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (129))){
var inst_115766 = (state_115770[(2)]);
var state_115770__$1 = state_115770;
var statearr_115838_116009 = state_115770__$1;
(statearr_115838_116009[(2)] = inst_115766);


cljs.core.async.impl.ioc_helpers.process_exception(state_115770__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (91))){
var inst_115480 = (state_115770[(7)]);
var inst_115488 = (state_115770[(26)]);
var inst_115490 = (state_115770[(27)]);
var inst_115478 = (state_115770[(11)]);
var inst_115650 = (state_115770[(2)]);
var inst_115651 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_115490,fuel,max_fuel,inst_115488,inst_115650,inst_115478,inst_115480);
var state_115770__$1 = state_115770;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_115770__$1,(92),inst_115651);
} else {
if((state_val_115771 === (117))){
var inst_115480 = (state_115770[(7)]);
var inst_115717 = (state_115770[(30)]);
var inst_115488 = (state_115770[(26)]);
var inst_115490 = (state_115770[(27)]);
var inst_115721 = (state_115770[(2)]);
var inst_115722 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_115490,fuel,max_fuel,inst_115488,inst_115717,inst_115721,inst_115480);
var state_115770__$1 = state_115770;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_115770__$1,(114),inst_115722);
} else {
if((state_val_115771 === (108))){
var state_115770__$1 = state_115770;
var statearr_115839_116010 = state_115770__$1;
(statearr_115839_116010[(2)] = null);

(statearr_115839_116010[(1)] = (109));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (56))){
var inst_115555 = (state_115770[(20)]);
var state_115770__$1 = state_115770;
var statearr_115840_116011 = state_115770__$1;
(statearr_115840_116011[(2)] = inst_115555);

(statearr_115840_116011[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (33))){
var state_115770__$1 = state_115770;
var statearr_115841_116012 = state_115770__$1;
(statearr_115841_116012[(1)] = (35));



return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (13))){
var inst_115451 = (state_115770[(2)]);
var state_115770__$1 = state_115770;
var statearr_115843_116013 = state_115770__$1;
(statearr_115843_116013[(2)] = inst_115451);

(statearr_115843_116013[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (22))){
var inst_115455 = (state_115770[(13)]);
var inst_115479 = (state_115770[(31)]);
var inst_115476 = (state_115770[(2)]);
var inst_115477 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_115476,cljs.core.cst$kw$orderBy);
var inst_115478 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_115476,cljs.core.cst$kw$limit);
var inst_115479__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_115476,cljs.core.cst$kw$component);
var inst_115480 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_115476,cljs.core.cst$kw$offset);
var inst_115481 = fluree.db.query.fql_parser.parse_db(db,inst_115455,opts_STAR_);
var inst_115482 = (inst_115479__$1 == null);
var inst_115483 = cljs.core.not(inst_115482);
var state_115770__$1 = (function (){var statearr_115844 = state_115770;
(statearr_115844[(7)] = inst_115480);

(statearr_115844[(15)] = inst_115477);

(statearr_115844[(31)] = inst_115479__$1);

(statearr_115844[(11)] = inst_115478);

(statearr_115844[(18)] = inst_115481);

return statearr_115844;
})();
if(inst_115483){
var statearr_115845_116014 = state_115770__$1;
(statearr_115845_116014[(1)] = (23));

} else {
var statearr_115846_116015 = state_115770__$1;
(statearr_115846_116015[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (90))){
var inst_115642 = (state_115770[(21)]);
var inst_115646 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115647 = [inst_115642];
var inst_115648 = (new cljs.core.PersistentVector(null,1,(5),inst_115646,inst_115647,null));
var state_115770__$1 = state_115770;
var statearr_115847_116016 = state_115770__$1;
(statearr_115847_116016[(2)] = inst_115648);

(statearr_115847_116016[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (109))){
var inst_115685 = (state_115770[(19)]);
var inst_115699 = (state_115770[(2)]);
var inst_115700 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,inst_115685,false);
var state_115770__$1 = (function (){var statearr_115848 = state_115770;
(statearr_115848[(32)] = inst_115699);

return statearr_115848;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_115770__$1,(110),inst_115700);
} else {
if((state_val_115771 === (36))){
var state_115770__$1 = state_115770;
var statearr_115849_116017 = state_115770__$1;
(statearr_115849_116017[(2)] = null);

(statearr_115849_116017[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (41))){
var state_115770__$1 = state_115770;
var statearr_115850_116018 = state_115770__$1;
(statearr_115850_116018[(2)] = from);

(statearr_115850_116018[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (118))){
var inst_115728 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_115729 = ["Invalid 'from' in query:",inst_115728].join('');
var inst_115730 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_115731 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_115732 = cljs.core.PersistentHashMap.fromArrays(inst_115730,inst_115731);
var inst_115733 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_115729,inst_115732);
var state_115770__$1 = state_115770;
var statearr_115851_116019 = state_115770__$1;
(statearr_115851_116019[(2)] = inst_115733);

(statearr_115851_116019[(1)] = (120));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (89))){
var state_115770__$1 = state_115770;
var statearr_115852_116020 = state_115770__$1;
(statearr_115852_116020[(2)] = null);

(statearr_115852_116020[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (100))){
var inst_115477 = (state_115770[(15)]);
var inst_115715 = (state_115770[(2)]);
var inst_115716 = cljs.core.PersistentVector.EMPTY;
var inst_115717 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_115716,inst_115715);
var state_115770__$1 = (function (){var statearr_115853 = state_115770;
(statearr_115853[(30)] = inst_115717);

return statearr_115853;
})();
if(cljs.core.truth_(inst_115477)){
var statearr_115854_116021 = state_115770__$1;
(statearr_115854_116021[(1)] = (115));

} else {
var statearr_115855_116022 = state_115770__$1;
(statearr_115855_116022[(1)] = (116));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (122))){
var inst_115748 = (state_115770[(10)]);
var state_115770__$1 = state_115770;
var statearr_115856_116023 = state_115770__$1;
(statearr_115856_116023[(2)] = inst_115748);

(statearr_115856_116023[(1)] = (123));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (43))){
var inst_115531 = (state_115770[(2)]);
var inst_115532 = fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3(db,where,inst_115531);
var state_115770__$1 = state_115770;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_115770__$1,(44),inst_115532);
} else {
if((state_val_115771 === (61))){
var inst_115569 = cljs.core.PersistentHashMap.EMPTY;
var state_115770__$1 = state_115770;
var statearr_115857_116024 = state_115770__$1;
(statearr_115857_116024[(2)] = inst_115569);

(statearr_115857_116024[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (29))){
var inst_115477 = (state_115770[(15)]);
var inst_115494 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115495 = cljs.core.second(inst_115477);
var inst_115496 = cljs.core.first(inst_115477);
var inst_115497 = [inst_115495,inst_115496];
var inst_115498 = (new cljs.core.PersistentVector(null,2,(5),inst_115494,inst_115497,null));
var state_115770__$1 = state_115770;
var statearr_115858_116025 = state_115770__$1;
(statearr_115858_116025[(2)] = inst_115498);

(statearr_115858_116025[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (44))){
var inst_115477 = (state_115770[(15)]);
var inst_115534 = (state_115770[(2)]);
var inst_115535 = fluree.db.util.async.throw_err(inst_115534);
var state_115770__$1 = (function (){var statearr_115859 = state_115770;
(statearr_115859[(33)] = inst_115535);

return statearr_115859;
})();
if(cljs.core.truth_(inst_115477)){
var statearr_115860_116026 = state_115770__$1;
(statearr_115860_116026[(1)] = (46));

} else {
var statearr_115861_116027 = state_115770__$1;
(statearr_115861_116027[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (93))){
var inst_115656 = cljs.core._deref(fuel);
var inst_115657 = (inst_115656 + (1));
var inst_115658 = cljs.core._vreset_BANG_(fuel,inst_115657);
var state_115770__$1 = state_115770;
var statearr_115862_116028 = state_115770__$1;
(statearr_115862_116028[(2)] = inst_115658);

(statearr_115862_116028[(1)] = (95));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (6))){
var state_115770__$1 = state_115770;
if(cljs.core.truth_(selectOne)){
var statearr_115863_116029 = state_115770__$1;
(statearr_115863_116029[(1)] = (8));

} else {
var statearr_115864_116030 = state_115770__$1;
(statearr_115864_116030[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (111))){
var inst_115705 = (state_115770[(22)]);
var inst_115679 = (state_115770[(17)]);
var inst_115707 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_115679,inst_115705);
var state_115770__$1 = state_115770;
var statearr_115865_116031 = state_115770__$1;
(statearr_115865_116031[(2)] = inst_115707);

(statearr_115865_116031[(1)] = (113));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (28))){
var inst_115522 = (state_115770[(2)]);
var inst_115523 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_115522,(0),null);
var inst_115524 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_115522,(1),null);
var inst_115525 = typeof where === 'string';
var state_115770__$1 = (function (){var statearr_115866 = state_115770;
(statearr_115866[(8)] = inst_115524);

(statearr_115866[(9)] = inst_115523);

return statearr_115866;
})();
if(cljs.core.truth_(inst_115525)){
var statearr_115867_116032 = state_115770__$1;
(statearr_115867_116032[(1)] = (38));

} else {
var statearr_115868_116033 = state_115770__$1;
(statearr_115868_116033[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (64))){
var inst_115567 = (state_115770[(16)]);
var inst_115488 = (state_115770[(26)]);
var inst_115490 = (state_115770[(27)]);
var inst_115478 = (state_115770[(11)]);
var inst_115581 = (state_115770[(2)]);
var inst_115582 = fluree.db.util.async.throw_err(inst_115581);
var inst_115583 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_115567,inst_115582);
var inst_115584 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7(db,inst_115490,fuel,max_fuel,inst_115488,inst_115583,inst_115478);
var state_115770__$1 = state_115770;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_115770__$1,(65),inst_115584);
} else {
if((state_val_115771 === (103))){
var inst_115713 = (state_115770[(2)]);
var state_115770__$1 = state_115770;
var statearr_115869_116034 = state_115770__$1;
(statearr_115869_116034[(2)] = inst_115713);

(statearr_115869_116034[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (51))){
var inst_115535 = (state_115770[(33)]);
var inst_115488 = (state_115770[(26)]);
var inst_115490 = (state_115770[(27)]);
var inst_115539 = (state_115770[(25)]);
var inst_115543 = (state_115770[(2)]);
var inst_115544 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_115490,fuel,max_fuel,inst_115488,inst_115535,inst_115539,inst_115543);
var state_115770__$1 = state_115770;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_115770__$1,(45),inst_115544);
} else {
if((state_val_115771 === (25))){
var inst_115477 = (state_115770[(15)]);
var inst_115488 = (state_115770[(2)]);
var inst_115489 = cljs.core.PersistentHashMap.EMPTY;
var inst_115490 = cljs.core.volatile_BANG_(inst_115489);
var state_115770__$1 = (function (){var statearr_115870 = state_115770;
(statearr_115870[(26)] = inst_115488);

(statearr_115870[(27)] = inst_115490);

return statearr_115870;
})();
if(cljs.core.truth_(inst_115477)){
var statearr_115871_116035 = state_115770__$1;
(statearr_115871_116035[(1)] = (26));

} else {
var statearr_115872_116036 = state_115770__$1;
(statearr_115872_116036[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (34))){
var inst_115514 = (state_115770[(2)]);
var state_115770__$1 = state_115770;
var statearr_115873_116037 = state_115770__$1;
(statearr_115873_116037[(2)] = inst_115514);

(statearr_115873_116037[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (125))){
var state_115770__$1 = state_115770;
var statearr_115874_116038 = state_115770__$1;
(statearr_115874_116038[(2)] = selectOne);

(statearr_115874_116038[(1)] = (126));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (17))){
var state_115770__$1 = state_115770;
var statearr_115875_116039 = state_115770__$1;
(statearr_115875_116039[(2)] = true);

(statearr_115875_116039[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (3))){
var inst_115431 = (state_115770[(2)]);
var state_115770__$1 = state_115770;
var statearr_115876_116040 = state_115770__$1;
(statearr_115876_116040[(2)] = inst_115431);


cljs.core.async.impl.ioc_helpers.process_exception(state_115770__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (12))){
var inst_115445 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_115446 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_115447 = cljs.core.PersistentHashMap.fromArrays(inst_115445,inst_115446);
var inst_115448 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Query missing :select or :selectOne.",inst_115447);
var inst_115449 = (function(){throw inst_115448})();
var state_115770__$1 = state_115770;
var statearr_115877_116041 = state_115770__$1;
(statearr_115877_116041[(2)] = inst_115449);

(statearr_115877_116041[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (2))){
var inst_115768 = (state_115770[(2)]);
var state_115770__$1 = state_115770;
return cljs.core.async.impl.ioc_helpers.return_chan(state_115770__$1,inst_115768);
} else {
if((state_val_115771 === (66))){
var inst_115592 = ["_tx",null,"_block",null];
var inst_115593 = (new cljs.core.PersistentArrayMap(null,2,inst_115592,null));
var inst_115594 = (new cljs.core.PersistentHashSet(null,inst_115593,null));
var inst_115595 = (inst_115594.cljs$core$IFn$_invoke$arity$1 ? inst_115594.cljs$core$IFn$_invoke$arity$1(from) : inst_115594.call(null,from));
var state_115770__$1 = state_115770;
var statearr_115878_116042 = state_115770__$1;
(statearr_115878_116042[(2)] = inst_115595);

(statearr_115878_116042[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (107))){
var inst_115694 = cljs.core._deref(fuel);
var inst_115695 = (inst_115694 + (1));
var inst_115696 = cljs.core._vreset_BANG_(fuel,inst_115695);
var state_115770__$1 = state_115770;
var statearr_115879_116043 = state_115770__$1;
(statearr_115879_116043[(2)] = inst_115696);

(statearr_115879_116043[(1)] = (109));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (23))){
var inst_115479 = (state_115770[(31)]);
var inst_115481 = (state_115770[(18)]);
var inst_115485 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_115481,cljs.core.cst$kw$componentFollow_QMARK_,inst_115479);
var state_115770__$1 = state_115770;
var statearr_115880_116044 = state_115770__$1;
(statearr_115880_116044[(2)] = inst_115485);

(statearr_115880_116044[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (47))){
var inst_115478 = (state_115770[(11)]);
var state_115770__$1 = state_115770;
var statearr_115881_116045 = state_115770__$1;
(statearr_115881_116045[(2)] = inst_115478);

(statearr_115881_116045[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (35))){
var inst_115507 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115508 = [null,null];
var inst_115509 = (new cljs.core.PersistentVector(null,2,(5),inst_115507,inst_115508,null));
var state_115770__$1 = state_115770;
var statearr_115882_116046 = state_115770__$1;
(statearr_115882_116046[(2)] = inst_115509);

(statearr_115882_116046[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (127))){
var inst_115753 = (state_115770[(12)]);
var inst_115763 = cljs.core.first(inst_115753);
var state_115770__$1 = state_115770;
var statearr_115883_116047 = state_115770__$1;
(statearr_115883_116047[(2)] = inst_115763);

(statearr_115883_116047[(1)] = (129));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (82))){
var inst_115626 = (state_115770[(2)]);
var inst_115627 = fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,from,inst_115626);
var state_115770__$1 = state_115770;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_115770__$1,(83),inst_115627);
} else {
if((state_val_115771 === (76))){
var inst_115614 = (state_115770[(2)]);
var inst_115615 = fluree.db.util.async.throw_err(inst_115614);
var state_115770__$1 = state_115770;
var statearr_115884_116048 = state_115770__$1;
(statearr_115884_116048[(2)] = inst_115615);

(statearr_115884_116048[(1)] = (71));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (97))){
var state_115770__$1 = state_115770;
var statearr_115885_116049 = state_115770__$1;
(statearr_115885_116049[(1)] = (118));



return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (19))){
var inst_115468 = (state_115770[(2)]);
var state_115770__$1 = state_115770;
var statearr_115887_116050 = state_115770__$1;
(statearr_115887_116050[(2)] = inst_115468);

(statearr_115887_116050[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (57))){
var inst_115561 = (state_115770[(2)]);
var state_115770__$1 = (function (){var statearr_115888 = state_115770;
(statearr_115888[(14)] = inst_115561);

return statearr_115888;
})();
var statearr_115889_116051 = state_115770__$1;
(statearr_115889_116051[(1)] = (58));



return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (68))){
var inst_115598 = (state_115770[(2)]);
var state_115770__$1 = state_115770;
if(cljs.core.truth_(inst_115598)){
var statearr_115891_116052 = state_115770__$1;
(statearr_115891_116052[(1)] = (69));

} else {
var statearr_115892_116053 = state_115770__$1;
(statearr_115892_116053[(1)] = (70));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (11))){
var state_115770__$1 = state_115770;
var statearr_115893_116054 = state_115770__$1;
(statearr_115893_116054[(2)] = selectDistinct);

(statearr_115893_116054[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (115))){
var state_115770__$1 = state_115770;
var statearr_115894_116055 = state_115770__$1;
(statearr_115894_116055[(2)] = null);

(statearr_115894_116055[(1)] = (117));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (9))){
var state_115770__$1 = state_115770;
if(cljs.core.truth_(selectDistinct)){
var statearr_115895_116056 = state_115770__$1;
(statearr_115895_116056[(1)] = (11));

} else {
var statearr_115896_116057 = state_115770__$1;
(statearr_115896_116057[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (5))){
var state_115770__$1 = state_115770;
var statearr_115897_116058 = state_115770__$1;
(statearr_115897_116058[(2)] = select);

(statearr_115897_116058[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (112))){
var inst_115679 = (state_115770[(17)]);
var state_115770__$1 = state_115770;
var statearr_115898_116059 = state_115770__$1;
(statearr_115898_116059[(2)] = inst_115679);

(statearr_115898_116059[(1)] = (113));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (83))){
var inst_115488 = (state_115770[(26)]);
var inst_115490 = (state_115770[(27)]);
var inst_115629 = (state_115770[(2)]);
var inst_115630 = fluree.db.util.async.throw_err(inst_115629);
var inst_115631 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_115490,fuel,max_fuel,inst_115488,inst_115630);
var state_115770__$1 = state_115770;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_115770__$1,(84),inst_115631);
} else {
if((state_val_115771 === (14))){
var inst_115460 = opts_STAR_.cljs$lang$protocol_mask$partition0$;
var inst_115461 = (inst_115460 & (64));
var inst_115462 = opts_STAR_.cljs$core$ISeq$;
var inst_115463 = (cljs.core.PROTOCOL_SENTINEL === inst_115462);
var inst_115464 = ((inst_115461) || (inst_115463));
var state_115770__$1 = state_115770;
if(cljs.core.truth_(inst_115464)){
var statearr_115899_116060 = state_115770__$1;
(statearr_115899_116060[(1)] = (17));

} else {
var statearr_115900_116061 = state_115770__$1;
(statearr_115900_116061[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (45))){
var inst_115546 = (state_115770[(2)]);
var inst_115547 = fluree.db.util.async.throw_err(inst_115546);
var state_115770__$1 = state_115770;
var statearr_115901_116062 = state_115770__$1;
(statearr_115901_116062[(2)] = inst_115547);

(statearr_115901_116062[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (53))){
var inst_115590 = typeof from === 'string';
var state_115770__$1 = state_115770;
if(cljs.core.truth_(inst_115590)){
var statearr_115902_116063 = state_115770__$1;
(statearr_115902_116063[(1)] = (66));

} else {
var statearr_115903_116064 = state_115770__$1;
(statearr_115903_116064[(1)] = (67));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (78))){
var inst_115636 = fluree.db.util.core.subj_ident_QMARK_(from);
var state_115770__$1 = state_115770;
if(inst_115636){
var statearr_115904_116065 = state_115770__$1;
(statearr_115904_116065[(1)] = (85));

} else {
var statearr_115905_116066 = state_115770__$1;
(statearr_115905_116066[(1)] = (86));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (26))){
var inst_115477 = (state_115770[(15)]);
var inst_115492 = cljs.core.vector_QMARK_(inst_115477);
var state_115770__$1 = state_115770;
if(inst_115492){
var statearr_115906_116067 = state_115770__$1;
(statearr_115906_116067[(1)] = (29));

} else {
var statearr_115907_116068 = state_115770__$1;
(statearr_115907_116068[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (123))){
var inst_115753 = (state_115770[(2)]);
var state_115770__$1 = (function (){var statearr_115908 = state_115770;
(statearr_115908[(12)] = inst_115753);

return statearr_115908;
})();
if(cljs.core.truth_(selectOne)){
var statearr_115909_116069 = state_115770__$1;
(statearr_115909_116069[(1)] = (124));

} else {
var statearr_115910_116070 = state_115770__$1;
(statearr_115910_116070[(1)] = (125));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (16))){
var inst_115471 = (state_115770[(2)]);
var state_115770__$1 = state_115770;
if(cljs.core.truth_(inst_115471)){
var statearr_115911_116071 = state_115770__$1;
(statearr_115911_116071[(1)] = (20));

} else {
var statearr_115912_116072 = state_115770__$1;
(statearr_115912_116072[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (81))){
var inst_115480 = (state_115770[(7)]);
var inst_115478 = (state_115770[(11)]);
var inst_115622 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_115623 = [inst_115478,inst_115480];
var inst_115624 = cljs.core.PersistentHashMap.fromArrays(inst_115622,inst_115623);
var state_115770__$1 = state_115770;
var statearr_115913_116073 = state_115770__$1;
(statearr_115913_116073[(2)] = inst_115624);

(statearr_115913_116073[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (120))){
var inst_115736 = (state_115770[(2)]);
var state_115770__$1 = state_115770;
var statearr_115914_116074 = state_115770__$1;
(statearr_115914_116074[(2)] = inst_115736);

(statearr_115914_116074[(1)] = (98));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (79))){
var inst_115742 = (state_115770[(2)]);
var state_115770__$1 = state_115770;
var statearr_115915_116075 = state_115770__$1;
(statearr_115915_116075[(2)] = inst_115742);

(statearr_115915_116075[(1)] = (71));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (38))){
var inst_115527 = typeof from === 'string';
var state_115770__$1 = state_115770;
if(cljs.core.truth_(inst_115527)){
var statearr_115916_116076 = state_115770__$1;
(statearr_115916_116076[(1)] = (41));

} else {
var statearr_115917_116077 = state_115770__$1;
(statearr_115917_116077[(1)] = (42));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (126))){
var inst_115761 = (state_115770[(2)]);
var state_115770__$1 = state_115770;
if(cljs.core.truth_(inst_115761)){
var statearr_115918_116078 = state_115770__$1;
(statearr_115918_116078[(1)] = (127));

} else {
var statearr_115919_116079 = state_115770__$1;
(statearr_115919_116079[(1)] = (128));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (98))){
var inst_115738 = (state_115770[(2)]);
var state_115770__$1 = state_115770;
var statearr_115920_116080 = state_115770__$1;
(statearr_115920_116080[(2)] = inst_115738);

(statearr_115920_116080[(1)] = (87));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (124))){
var inst_115753 = (state_115770[(12)]);
var inst_115755 = cljs.core.coll_QMARK_(inst_115753);
var inst_115756 = fluree.db.util.core.exception_QMARK_(inst_115753);
var inst_115757 = (!(inst_115756));
var inst_115758 = ((inst_115755) && (inst_115757));
var state_115770__$1 = state_115770;
var statearr_115921_116081 = state_115770__$1;
(statearr_115921_116081[(2)] = inst_115758);

(statearr_115921_116081[(1)] = (126));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (87))){
var inst_115740 = (state_115770[(2)]);
var state_115770__$1 = state_115770;
var statearr_115922_116082 = state_115770__$1;
(statearr_115922_116082[(2)] = inst_115740);

(statearr_115922_116082[(1)] = (79));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (30))){
var inst_115477 = (state_115770[(15)]);
var inst_115500 = typeof inst_115477 === 'string';
var state_115770__$1 = state_115770;
if(cljs.core.truth_(inst_115500)){
var statearr_115923_116083 = state_115770__$1;
(statearr_115923_116083[(1)] = (32));

} else {
var statearr_115924_116084 = state_115770__$1;
(statearr_115924_116084[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (73))){
var inst_115480 = (state_115770[(7)]);
var inst_115478 = (state_115770[(11)]);
var inst_115603 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_115604 = [inst_115478,inst_115480];
var inst_115605 = cljs.core.PersistentHashMap.fromArrays(inst_115603,inst_115604);
var state_115770__$1 = state_115770;
var statearr_115925_116085 = state_115770__$1;
(statearr_115925_116085[(2)] = inst_115605);

(statearr_115925_116085[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (96))){
var inst_115674 = cljs.core.seq(from);
var inst_115675 = cljs.core.first(inst_115674);
var inst_115676 = cljs.core.next(inst_115674);
var inst_115677 = cljs.core.PersistentVector.EMPTY;
var inst_115678 = from;
var inst_115679 = inst_115677;
var state_115770__$1 = (function (){var statearr_115926 = state_115770;
(statearr_115926[(34)] = inst_115676);

(statearr_115926[(35)] = inst_115675);

(statearr_115926[(28)] = inst_115678);

(statearr_115926[(17)] = inst_115679);

return statearr_115926;
})();
var statearr_115927_116086 = state_115770__$1;
(statearr_115927_116086[(2)] = null);

(statearr_115927_116086[(1)] = (99));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (10))){
var inst_115453 = (state_115770[(2)]);
var state_115770__$1 = state_115770;
var statearr_115928_116087 = state_115770__$1;
(statearr_115928_116087[(2)] = inst_115453);

(statearr_115928_116087[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (18))){
var state_115770__$1 = state_115770;
var statearr_115929_116088 = state_115770__$1;
(statearr_115929_116088[(2)] = false);

(statearr_115929_116088[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (105))){
var state_115770__$1 = state_115770;
if(cljs.core.truth_(fuel)){
var statearr_115930_116089 = state_115770__$1;
(statearr_115930_116089[(1)] = (107));

} else {
var statearr_115931_116090 = state_115770__$1;
(statearr_115931_116090[(1)] = (108));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (52))){
var inst_115555 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_115770__$1 = (function (){var statearr_115932 = state_115770;
(statearr_115932[(20)] = inst_115555);

return statearr_115932;
})();
if(cljs.core.truth_(fuel)){
var statearr_115933_116091 = state_115770__$1;
(statearr_115933_116091[(1)] = (55));

} else {
var statearr_115934_116092 = state_115770__$1;
(statearr_115934_116092[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (114))){
var inst_115724 = (state_115770[(2)]);
var inst_115725 = fluree.db.util.async.throw_err(inst_115724);
var state_115770__$1 = state_115770;
var statearr_115935_116093 = state_115770__$1;
(statearr_115935_116093[(2)] = inst_115725);

(statearr_115935_116093[(1)] = (98));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (67))){
var state_115770__$1 = state_115770;
var statearr_115936_116094 = state_115770__$1;
(statearr_115936_116094[(2)] = false);

(statearr_115936_116094[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (71))){
var inst_115744 = (state_115770[(2)]);
var state_115770__$1 = state_115770;
var statearr_115937_116095 = state_115770__$1;
(statearr_115937_116095[(2)] = inst_115744);

(statearr_115937_116095[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (42))){
var state_115770__$1 = state_115770;
var statearr_115938_116096 = state_115770__$1;
(statearr_115938_116096[(2)] = null);

(statearr_115938_116096[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (80))){
var inst_115620 = cljs.core.PersistentHashMap.EMPTY;
var state_115770__$1 = state_115770;
var statearr_115939_116097 = state_115770__$1;
(statearr_115939_116097[(2)] = inst_115620);

(statearr_115939_116097[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (37))){
var inst_115512 = (state_115770[(2)]);
var state_115770__$1 = state_115770;
var statearr_115940_116098 = state_115770__$1;
(statearr_115940_116098[(2)] = inst_115512);

(statearr_115940_116098[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (63))){
var inst_115575 = (state_115770[(2)]);
var inst_115576 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115577 = [from];
var inst_115578 = (new cljs.core.PersistentVector(null,1,(5),inst_115576,inst_115577,null));
var inst_115579 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_115578,inst_115575);
var state_115770__$1 = state_115770;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_115770__$1,(64),inst_115579);
} else {
if((state_val_115771 === (94))){
var state_115770__$1 = state_115770;
var statearr_115941_116099 = state_115770__$1;
(statearr_115941_116099[(2)] = null);

(statearr_115941_116099[(1)] = (95));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (8))){
var state_115770__$1 = state_115770;
var statearr_115942_116100 = state_115770__$1;
(statearr_115942_116100[(2)] = selectOne);

(statearr_115942_116100[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (49))){
var state_115770__$1 = state_115770;
var statearr_115943_116101 = state_115770__$1;
(statearr_115943_116101[(2)] = null);

(statearr_115943_116101[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115771 === (84))){
var inst_115633 = (state_115770[(2)]);
var inst_115634 = fluree.db.util.async.throw_err(inst_115633);
var state_115770__$1 = state_115770;
var statearr_115944_116102 = state_115770__$1;
(statearr_115944_116102[(2)] = inst_115634);

(statearr_115944_116102[(1)] = (79));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__100742__auto__ = null;
var fluree$db$query$fql$state_machine__100742__auto____0 = (function (){
var statearr_115945 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_115945[(0)] = fluree$db$query$fql$state_machine__100742__auto__);

(statearr_115945[(1)] = (1));

return statearr_115945;
});
var fluree$db$query$fql$state_machine__100742__auto____1 = (function (state_115770){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_115770);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e115946){if((e115946 instanceof Object)){
var ex__100745__auto__ = e115946;
var statearr_115947_116103 = state_115770;
(statearr_115947_116103[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_115770);

return cljs.core.cst$kw$recur;
} else {
throw e115946;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__116104 = state_115770;
state_115770 = G__116104;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__100742__auto__ = function(state_115770){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__100742__auto____1.call(this,state_115770);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__100742__auto____0;
fluree$db$query$fql$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__100742__auto____1;
return fluree$db$query$fql$state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_115948 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_115948[(6)] = c__100848__auto__);

return statearr_115948;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
}
}
}));

(fluree.db.query.fql.query.cljs$lang$maxFixedArity = 3);

