// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true}
goog.provide('fluree.db.query.analytical');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.set');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.analytical_wikidata');
goog.require('fluree.db.query.analytical_filter');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
goog.require('fluree.db.dbproto');
fluree.db.query.analytical.variable_QMARK_ = (function fluree$db$query$analytical$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.internal_filter_QMARK_ = (function fluree$db$query$analytical$internal_filter_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"#")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.second(cljs.core.name(form)),"(")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.escaped_string_QMARK_ = (function fluree$db$query$analytical$escaped_string_QMARK_(form){
return ((typeof form === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"\"")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.last(cljs.core.name(form)),"\"")));
});
fluree.db.query.analytical.safe_read_string = (function fluree$db$query$analytical$safe_read_string(string){
try{return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(string);
}catch (e109817){var e = e109817;
return string;
}});
fluree.db.query.analytical.get_vars = (function fluree$db$query$analytical$get_vars(filter_code){
return cljs.core.some((function (p1__109818_SHARP_){
var or__4126__auto__ = fluree.db.query.analytical.variable_QMARK_(p1__109818_SHARP_);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.coll_QMARK_(p1__109818_SHARP_)){
return (fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1(p1__109818_SHARP_) : fluree.db.query.analytical.get_vars.call(null,p1__109818_SHARP_));
} else {
return null;
}
}
}),filter_code);
});
/**
 * Given any interm-vars, such as {?article 351843720901583}
 *   and an fdb clause, such as  ["?article", "articles/leadInstitutionOrg", "?org"],
 * 
 * 
 *   Returns a map with the following keys:
 * 
 *   - search - a vector that will be passed to query-range/search, i.e. [ nil "articles/leadInstitutionOrg" nil ]
 *   - rel - a map with any variables (that are not present in interm-vars) and their idx, i.e. {?org 2}
 *   - opts - search opts, currently recur, if the predicate is recurred, and object-fn, if there is an object function.
 *  
 */
fluree.db.query.analytical.clause__GT_rel = (function fluree$db$query$analytical$clause__GT_rel(db,interm_vars,clause){
return cljs.core.reduce_kv((function (acc,idx,key){
var key_as_var = fluree.db.query.analytical.variable_QMARK_(key);
var static_value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(interm_vars,key_as_var);
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1))) && (cljs.core.not(key_as_var)) && (cljs.core.not(fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,cljs.core.re_find(/[_a-zA-Z0-9\/]*/,key)))))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
} else {
}

if(cljs.core.truth_(static_value)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__109819_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__109819_SHARP_,static_value);
}));
} else {
if(cljs.core.truth_(key_as_var)){
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__109820_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__109820_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rel,key_as_var], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = fluree.db.query.analytical.internal_filter_QMARK_(key);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(2));
} else {
return and__4115__auto__;
}
})())){
var filter_code = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(key,(1)));
var var$ = (function (){var or__4126__auto__ = fluree.db.query.analytical.get_vars(filter_code);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var vec__109825 = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code,cljs.core.PersistentHashSet.createAsIfByAssoc([var$]));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__109825,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__109825,(1),null);
var filter_fn = fluree.db.query.analytical_filter.get_internal_filter_fn(var$,fun);
return cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__109821_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__109821_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$object_DASH_fn], null),filter_fn),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rel,var$], null),idx);
} else {
if(cljs.core.truth_(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1)))?cljs.core.re_find(/\+/,key):false))){
var vec__109828 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(key,/\+/);
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__109828,(0),null);
var recur_amt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__109828,(1),null);
var recur_amt__$1 = (cljs.core.truth_(recur_amt)?(function (){var or__4126__auto__ = fluree.db.query.analytical.safe_read_string(recur_amt);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (100);
}
})():(100));
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__109822_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__109822_SHARP_,pred);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$recur], null),recur_amt__$1);
} else {
if(fluree.db.query.analytical.escaped_string_QMARK_(key)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__109823_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__109823_SHARP_,fluree.db.query.analytical.safe_read_string(key));
}));
} else {
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__109824_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__109824_SHARP_,key);
}));

}
}
}
}
}
}),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$search,cljs.core.PersistentVector.EMPTY,cljs.core.cst$kw$rel,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$opts,cljs.core.PersistentArrayMap.EMPTY], null),clause);
});
fluree.db.query.analytical.get_ns_arrays = (function fluree$db$query$analytical$get_ns_arrays(ns,arrays){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (array){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__109831_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(array,p1__109831_SHARP_);
}),ns);
}),arrays);
});
fluree.db.query.analytical.clause__GT_keys = (function fluree$db$query$analytical$clause__GT_keys(clause){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var$){
var temp__5733__auto__ = fluree.db.query.analytical.variable_QMARK_(var$);
if(cljs.core.truth_(temp__5733__auto__)){
var var$__$1 = temp__5733__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,var$__$1);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause);
});
fluree.db.query.analytical.intersecting_keys_tuples_clause = (function fluree$db$query$analytical$intersecting_keys_tuples_clause(tuples,clause){
var rel_keys = cljs.core.set(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(tuples));
var clause_keys = fluree.db.query.analytical.clause__GT_keys(clause);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((rel_keys.cljs$core$IFn$_invoke$arity$1 ? rel_keys.cljs$core$IFn$_invoke$arity$1(key) : rel_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause_keys);
});
fluree.db.query.analytical.intersecting_keys_tuples = (function fluree$db$query$analytical$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((a_keys.cljs$core$IFn$_invoke$arity$1 ? a_keys.cljs$core$IFn$_invoke$arity$1(key) : a_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,b_keys);
});
fluree.db.query.analytical.select_from_tuples = (function fluree$db$query$analytical$select_from_tuples(vars,tuples){
var ns = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var_smt){
var temp__5733__auto__ = (function (){var or__4126__auto__ = fluree.db.query.analytical.variable_QMARK_(var_smt);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(var_smt);
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var var$ = temp__5733__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(tuples),var$));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_smt)," cannot be retrieved from the results. Check that it is declared in your where clause."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
}),cljs.core.PersistentVector.EMPTY,vars);
return fluree.db.query.analytical.get_ns_arrays(ns,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(tuples));
});
fluree.db.query.analytical.add_fuel = (function fluree$db$query$analytical$add_fuel(add_amount,fuel,max_fuel){
if(cljs.core.truth_((function (){var and__4115__auto__ = max_fuel;
if(cljs.core.truth_(and__4115__auto__)){
return (add_amount > max_fuel);
} else {
return and__4115__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query fuel exceeded: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = fuel;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.volatile_QMARK_(fuel);
} else {
return and__4115__auto__;
}
})())){
return cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + add_amount));
} else {
return null;
}
}
});
fluree.db.query.analytical.replace_vars_wikidata = (function fluree$db$query$analytical$replace_vars_wikidata(all_wd,intersecting_vars,vars){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause_item){
var temp__5733__auto__ = (function (){var G__109832 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(clause_item);
return (intersecting_vars.cljs$core$IFn$_invoke$arity$1 ? intersecting_vars.cljs$core$IFn$_invoke$arity$1(G__109832) : intersecting_vars.call(null,G__109832));
})();
if(cljs.core.truth_(temp__5733__auto__)){
var key_replace = temp__5733__auto__;
var replacement = cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,key_replace);
var replacement_SINGLEQUOTE_ = ((typeof cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(replacement) === 'number')?replacement:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(replacement),"\""].join(''));
return replacement_SINGLEQUOTE_;
} else {
return clause_item;
}
}),clause);
}),all_wd);
});
fluree.db.query.analytical.wikidata__GT_tuples = (function fluree$db$query$analytical$wikidata__GT_tuples(q_map,clause,r,p__109835,optional_QMARK_,fuel,max_fuel){
var map__109836 = p__109835;
var map__109836__$1 = (((((!((map__109836 == null))))?(((((map__109836.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__109836.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__109836):map__109836);
var res = map__109836__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__109836__$1,cljs.core.cst$kw$vars);
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_109899){
var state_val_109900 = (state_109899[(1)]);
if((state_val_109900 === (7))){
var inst_109895 = (state_109899[(2)]);
var state_109899__$1 = state_109899;
var statearr_109901_109922 = state_109899__$1;
(statearr_109901_109922[(2)] = inst_109895);


cljs.core.async.impl.ioc_helpers.process_exception(state_109899__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_109900 === (1))){
var state_109899__$1 = state_109899;
var statearr_109902_109923 = state_109899__$1;
(statearr_109902_109923[(2)] = null);

(statearr_109902_109923[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109900 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_109899,(3),Error,null,(2));
var inst_109842 = (r == null);
var state_109899__$1 = state_109899;
if(cljs.core.truth_(inst_109842)){
var statearr_109903_109924 = state_109899__$1;
(statearr_109903_109924[(1)] = (5));

} else {
var statearr_109904_109925 = state_109899__$1;
(statearr_109904_109925[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_109900 === (13))){
var inst_109887 = (state_109899[(2)]);
var state_109899__$1 = state_109899;
var statearr_109905_109926 = state_109899__$1;
(statearr_109905_109926[(2)] = inst_109887);

(statearr_109905_109926[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109900 === (6))){
var inst_109889 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_109890 = fluree.db.query.analytical_wikidata.drop_all_wd_clauses(r);
var inst_109891 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_109890,clause);
var inst_109892 = [null,inst_109891];
var inst_109893 = (new cljs.core.PersistentVector(null,2,(5),inst_109889,inst_109892,null));
var state_109899__$1 = state_109899;
var statearr_109906_109927 = state_109899__$1;
(statearr_109906_109927[(2)] = inst_109893);

(statearr_109906_109927[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109900 === (3))){
var inst_109838 = (state_109899[(2)]);
var state_109899__$1 = state_109899;
var statearr_109907_109928 = state_109899__$1;
(statearr_109907_109928[(2)] = inst_109838);


cljs.core.async.impl.ioc_helpers.process_exception(state_109899__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_109900 === (12))){
var inst_109845 = (state_109899[(7)]);
var inst_109857 = cljs.core.cst$kw$optional.cljs$core$IFn$_invoke$arity$1(q_map);
var inst_109858 = fluree.db.query.analytical_wikidata.get_all_wd_clauses(inst_109857);
var inst_109859 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_109845);
var inst_109860 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_109859);
var inst_109861 = cljs.core.set(inst_109860);
var inst_109862 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_109858);
var inst_109863 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_109862);
var inst_109864 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_109861,inst_109863);
var inst_109865 = (function (){var all_wd = inst_109845;
var optional = inst_109858;
var all_wd_vars = inst_109861;
var all_vars = inst_109864;
return (function (p1__109833_SHARP_){
return (all_vars.cljs$core$IFn$_invoke$arity$1 ? all_vars.cljs$core$IFn$_invoke$arity$1(p1__109833_SHARP_) : all_vars.call(null,p1__109833_SHARP_));
});
})();
var inst_109866 = cljs.core.keys(vars);
var inst_109867 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_109865,inst_109866);
var inst_109868 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_109867);
var inst_109869 = cljs.core.set(inst_109868);
var inst_109870 = (function (){var all_wd = inst_109845;
var optional = inst_109858;
var all_wd_vars = inst_109861;
var all_vars = inst_109864;
var intersecting_vars = inst_109869;
return (function (p1__109834_SHARP_){
return fluree.db.query.analytical.intersecting_keys_tuples_clause(res,p1__109834_SHARP_);
});
})();
var inst_109871 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_109870,inst_109845);
var inst_109872 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_109871);
var inst_109873 = fluree.db.query.analytical.select_from_tuples(inst_109872,res);
var inst_109874 = fluree.db.query.analytical.replace_vars_wikidata(inst_109845,inst_109869,vars);
var inst_109875 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(inst_109869,inst_109864);
var inst_109876 = fluree.db.query.analytical_wikidata.get_wikidata_tuples(q_map,inst_109874,inst_109872,inst_109873,inst_109875,inst_109858);
var state_109899__$1 = state_109899;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_109899__$1,(14),inst_109876);
} else {
if((state_val_109900 === (2))){
var inst_109897 = (state_109899[(2)]);
var state_109899__$1 = state_109899;
return cljs.core.async.impl.ioc_helpers.return_chan(state_109899__$1,inst_109897);
} else {
if((state_val_109900 === (11))){
var inst_109853 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_109854 = [null,r];
var inst_109855 = (new cljs.core.PersistentVector(null,2,(5),inst_109853,inst_109854,null));
var state_109899__$1 = state_109899;
var statearr_109908_109929 = state_109899__$1;
(statearr_109908_109929[(2)] = inst_109855);

(statearr_109908_109929[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109900 === (9))){
var state_109899__$1 = state_109899;
var statearr_109909_109930 = state_109899__$1;
(statearr_109909_109930[(2)] = optional_QMARK_);

(statearr_109909_109930[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109900 === (5))){
var inst_109844 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(q_map);
var inst_109845 = fluree.db.query.analytical_wikidata.get_all_wd_clauses(inst_109844);
var state_109899__$1 = (function (){var statearr_109910 = state_109899;
(statearr_109910[(7)] = inst_109845);

return statearr_109910;
})();
if(cljs.core.truth_(optional_QMARK_)){
var statearr_109911_109931 = state_109899__$1;
(statearr_109911_109931[(1)] = (8));

} else {
var statearr_109912_109932 = state_109899__$1;
(statearr_109912_109932[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_109900 === (14))){
var inst_109878 = (state_109899[(2)]);
var inst_109879 = fluree.db.util.async.throw_err(inst_109878);
var inst_109880 = cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(inst_109879);
var inst_109881 = cljs.core.count(inst_109880);
var inst_109882 = fluree.db.query.analytical.add_fuel(inst_109881,fuel,max_fuel);
var inst_109883 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_109884 = [inst_109879,r];
var inst_109885 = (new cljs.core.PersistentVector(null,2,(5),inst_109883,inst_109884,null));
var state_109899__$1 = (function (){var statearr_109913 = state_109899;
(statearr_109913[(8)] = inst_109882);

return statearr_109913;
})();
var statearr_109914_109933 = state_109899__$1;
(statearr_109914_109933[(2)] = inst_109885);

(statearr_109914_109933[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109900 === (10))){
var inst_109851 = (state_109899[(2)]);
var state_109899__$1 = state_109899;
if(cljs.core.truth_(inst_109851)){
var statearr_109915_109934 = state_109899__$1;
(statearr_109915_109934[(1)] = (11));

} else {
var statearr_109916_109935 = state_109899__$1;
(statearr_109916_109935[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_109900 === (8))){
var inst_109845 = (state_109899[(7)]);
var inst_109847 = cljs.core.empty_QMARK_(inst_109845);
var inst_109848 = (!(inst_109847));
var state_109899__$1 = state_109899;
var statearr_109917_109936 = state_109899__$1;
(statearr_109917_109936[(2)] = inst_109848);

(statearr_109917_109936[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__100742__auto__ = null;
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__100742__auto____0 = (function (){
var statearr_109918 = [null,null,null,null,null,null,null,null,null];
(statearr_109918[(0)] = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__100742__auto__);

(statearr_109918[(1)] = (1));

return statearr_109918;
});
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__100742__auto____1 = (function (state_109899){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_109899);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e109919){if((e109919 instanceof Object)){
var ex__100745__auto__ = e109919;
var statearr_109920_109937 = state_109899;
(statearr_109920_109937[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_109899);

return cljs.core.cst$kw$recur;
} else {
throw e109919;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__109938 = state_109899;
state_109899 = G__109938;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__100742__auto__ = function(state_109899){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__100742__auto____1.call(this,state_109899);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__100742__auto____0;
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__100742__auto____1;
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_109921 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_109921[(6)] = c__100848__auto__);

return statearr_109921;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
fluree.db.query.analytical.db_ident_QMARK_ = (function fluree$db$query$analytical$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.query.analytical.parse_block_from_source = (function fluree$db$query$analytical$parse_block_from_source(block){
var block_SINGLEQUOTE_ = fluree.db.query.analytical.safe_read_string(block);
if(cljs.core.int_QMARK_(block_SINGLEQUOTE_)){
return block_SINGLEQUOTE_;
} else {
return block;
}
});
fluree.db.query.analytical.isolate_source_name = (function fluree$db$query$analytical$isolate_source_name(dbid){
return cljs.core.re_find(/[a-z]+/,dbid);
});
fluree.db.query.analytical.isolate_source_block = (function fluree$db$query$analytical$isolate_source_block(dbid){
return cljs.core.re_find(/[A-Z0-9]+/,dbid);
});
fluree.db.query.analytical.get_source_clause = (function fluree$db$query$analytical$get_source_clause(var_args){
var G__109940 = arguments.length;
switch (G__109940) {
case 2:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2 = (function (db,clause){
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4 = (function (db,clause,prefixes,opts){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_110031){
var state_val_110032 = (state_110031[(1)]);
if((state_val_110032 === (7))){
var inst_110027 = (state_110031[(2)]);
var state_110031__$1 = state_110031;
var statearr_110033_110075 = state_110031__$1;
(statearr_110033_110075[(2)] = inst_110027);


cljs.core.async.impl.ioc_helpers.process_exception(state_110031__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_110032 === (20))){
var inst_110021 = (state_110031[(2)]);
var state_110031__$1 = state_110031;
var statearr_110034_110076 = state_110031__$1;
(statearr_110034_110076[(2)] = inst_110021);

(statearr_110034_110076[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110032 === (27))){
var inst_110003 = (state_110031[(2)]);
var inst_110004 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_110005 = cljs.core.PersistentVector.EMPTY;
var inst_110006 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_110007 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_110005,inst_110006);
var inst_110008 = [inst_110003,inst_110007];
var inst_110009 = (new cljs.core.PersistentVector(null,2,(5),inst_110004,inst_110008,null));
var state_110031__$1 = state_110031;
var statearr_110035_110077 = state_110031__$1;
(statearr_110035_110077[(2)] = inst_110009);

(statearr_110035_110077[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110032 === (1))){
var state_110031__$1 = state_110031;
var statearr_110036_110078 = state_110031__$1;
(statearr_110036_110078[(2)] = null);

(statearr_110036_110078[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110032 === (24))){
var inst_109988 = (state_110031[(7)]);
var inst_109994 = (state_110031[(2)]);
var inst_109995 = fluree.db.util.async.throw_err(inst_109994);
var state_110031__$1 = (function (){var statearr_110037 = state_110031;
(statearr_110037[(8)] = inst_109995);

return statearr_110037;
})();
if(cljs.core.truth_(inst_109988)){
var statearr_110038_110079 = state_110031__$1;
(statearr_110038_110079[(1)] = (25));

} else {
var statearr_110039_110080 = state_110031__$1;
(statearr_110039_110080[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110032 === (4))){
var inst_109945 = (state_110031[(9)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_110031,(3),Error,null,(2));
var inst_109945__$1 = cljs.core.first(clause);
var inst_109946 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$fdb",inst_109945__$1);
var state_110031__$1 = (function (){var statearr_110040 = state_110031;
(statearr_110040[(9)] = inst_109945__$1);

return statearr_110040;
})();
if(inst_109946){
var statearr_110041_110081 = state_110031__$1;
(statearr_110041_110081[(1)] = (5));

} else {
var statearr_110042_110082 = state_110031__$1;
(statearr_110042_110082[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110032 === (15))){
var inst_109978 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_109979 = ["$wd",clause];
var inst_109980 = (new cljs.core.PersistentVector(null,2,(5),inst_109978,inst_109979,null));
var state_110031__$1 = state_110031;
var statearr_110043_110083 = state_110031__$1;
(statearr_110043_110083[(2)] = inst_109980);

(statearr_110043_110083[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110032 === (21))){
var inst_109986 = (state_110031[(10)]);
var inst_109984 = (state_110031[(11)]);
var inst_109988 = fluree.db.query.analytical.parse_block_from_source(inst_109984);
var inst_109989 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_109990 = [cljs.core.cst$kw$sources,inst_109986];
var inst_109991 = (new cljs.core.PersistentVector(null,2,(5),inst_109989,inst_109990,null));
var inst_109992 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,inst_109991);
var state_110031__$1 = (function (){var statearr_110044 = state_110031;
(statearr_110044[(7)] = inst_109988);

return statearr_110044;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_110031__$1,(24),inst_109992);
} else {
if((state_val_110032 === (13))){
var state_110031__$1 = state_110031;
var statearr_110045_110084 = state_110031__$1;
(statearr_110045_110084[(2)] = null);

(statearr_110045_110084[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110032 === (22))){
var inst_109945 = (state_110031[(9)]);
var inst_110011 = ["The data source: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_109945)," is not supported in Fluree"].join('');
var inst_110012 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_110013 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_110014 = cljs.core.PersistentHashMap.fromArrays(inst_110012,inst_110013);
var inst_110015 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_110011,inst_110014);
var inst_110016 = (function(){throw inst_110015})();
var state_110031__$1 = state_110031;
var statearr_110046_110085 = state_110031__$1;
(statearr_110046_110085[(2)] = inst_110016);

(statearr_110046_110085[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110032 === (6))){
var inst_109945 = (state_110031[(9)]);
var inst_109955 = clojure.string.starts_with_QMARK_(inst_109945,"$fdb");
var state_110031__$1 = state_110031;
if(inst_109955){
var statearr_110047_110086 = state_110031__$1;
(statearr_110047_110086[(1)] = (8));

} else {
var statearr_110048_110087 = state_110031__$1;
(statearr_110048_110087[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110032 === (28))){
var inst_109999 = (state_110031[(2)]);
var inst_110000 = fluree.db.util.async.throw_err(inst_109999);
var state_110031__$1 = state_110031;
var statearr_110049_110088 = state_110031__$1;
(statearr_110049_110088[(2)] = inst_110000);

(statearr_110049_110088[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110032 === (25))){
var inst_109995 = (state_110031[(8)]);
var inst_109988 = (state_110031[(7)]);
var inst_109997 = fluree.db.time_travel.as_of_block(inst_109995,inst_109988);
var state_110031__$1 = state_110031;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_110031__$1,(28),inst_109997);
} else {
if((state_val_110032 === (17))){
var inst_110023 = (state_110031[(2)]);
var state_110031__$1 = state_110031;
var statearr_110050_110089 = state_110031__$1;
(statearr_110050_110089[(2)] = inst_110023);

(statearr_110050_110089[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110032 === (3))){
var inst_109941 = (state_110031[(2)]);
var state_110031__$1 = state_110031;
var statearr_110051_110090 = state_110031__$1;
(statearr_110051_110090[(2)] = inst_109941);


cljs.core.async.impl.ioc_helpers.process_exception(state_110031__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_110032 === (12))){
var inst_109962 = (state_110031[(12)]);
var inst_109965 = (function(){throw inst_109962})();
var state_110031__$1 = state_110031;
var statearr_110052_110091 = state_110031__$1;
(statearr_110052_110091[(2)] = inst_109965);

(statearr_110052_110091[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110032 === (2))){
var inst_110029 = (state_110031[(2)]);
var state_110031__$1 = state_110031;
return cljs.core.async.impl.ioc_helpers.return_chan(state_110031__$1,inst_110029);
} else {
if((state_val_110032 === (23))){
var inst_110018 = (state_110031[(2)]);
var state_110031__$1 = state_110031;
var statearr_110053_110092 = state_110031__$1;
(statearr_110053_110092[(2)] = inst_110018);

(statearr_110053_110092[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110032 === (19))){
var state_110031__$1 = state_110031;
var statearr_110054_110093 = state_110031__$1;
(statearr_110054_110093[(2)] = null);

(statearr_110054_110093[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110032 === (11))){
var inst_109962 = (state_110031[(12)]);
var inst_109961 = (state_110031[(2)]);
var inst_109962__$1 = fluree.db.util.async.throw_err(inst_109961);
var inst_109963 = fluree.db.util.core.exception_QMARK_(inst_109962__$1);
var state_110031__$1 = (function (){var statearr_110055 = state_110031;
(statearr_110055[(12)] = inst_109962__$1);

return statearr_110055;
})();
if(inst_109963){
var statearr_110056_110094 = state_110031__$1;
(statearr_110056_110094[(1)] = (12));

} else {
var statearr_110057_110095 = state_110031__$1;
(statearr_110057_110095[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110032 === (9))){
var inst_109945 = (state_110031[(9)]);
var inst_109976 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_109945);
var state_110031__$1 = state_110031;
if(inst_109976){
var statearr_110058_110096 = state_110031__$1;
(statearr_110058_110096[(1)] = (15));

} else {
var statearr_110059_110097 = state_110031__$1;
(statearr_110059_110097[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110032 === (5))){
var inst_109948 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_109949 = cljs.core.PersistentVector.EMPTY;
var inst_109950 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_109951 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_109949,inst_109950);
var inst_109952 = [db,inst_109951];
var inst_109953 = (new cljs.core.PersistentVector(null,2,(5),inst_109948,inst_109952,null));
var state_110031__$1 = state_110031;
var statearr_110060_110098 = state_110031__$1;
(statearr_110060_110098[(2)] = inst_109953);

(statearr_110060_110098[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110032 === (14))){
var inst_109962 = (state_110031[(12)]);
var inst_109968 = (state_110031[(2)]);
var inst_109969 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_109970 = cljs.core.PersistentVector.EMPTY;
var inst_109971 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_109972 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_109970,inst_109971);
var inst_109973 = [inst_109962,inst_109972];
var inst_109974 = (new cljs.core.PersistentVector(null,2,(5),inst_109969,inst_109973,null));
var state_110031__$1 = (function (){var statearr_110061 = state_110031;
(statearr_110061[(13)] = inst_109968);

return statearr_110061;
})();
var statearr_110062_110099 = state_110031__$1;
(statearr_110062_110099[(2)] = inst_109974);

(statearr_110062_110099[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110032 === (26))){
var inst_109995 = (state_110031[(8)]);
var state_110031__$1 = state_110031;
var statearr_110063_110100 = state_110031__$1;
(statearr_110063_110100[(2)] = inst_109995);

(statearr_110063_110100[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110032 === (16))){
var state_110031__$1 = state_110031;
var statearr_110064_110101 = state_110031__$1;
(statearr_110064_110101[(1)] = (18));



return cljs.core.cst$kw$recur;
} else {
if((state_val_110032 === (10))){
var inst_110025 = (state_110031[(2)]);
var state_110031__$1 = state_110031;
var statearr_110066_110102 = state_110031__$1;
(statearr_110066_110102[(2)] = inst_110025);

(statearr_110066_110102[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110032 === (18))){
var inst_109986 = (state_110031[(10)]);
var inst_109945 = (state_110031[(9)]);
var inst_109983 = fluree.db.query.analytical.isolate_source_name(inst_109945);
var inst_109984 = fluree.db.query.analytical.isolate_source_block(inst_109945);
var inst_109985 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_109983);
var inst_109986__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(prefixes,inst_109985);
var state_110031__$1 = (function (){var statearr_110067 = state_110031;
(statearr_110067[(10)] = inst_109986__$1);

(statearr_110067[(11)] = inst_109984);

return statearr_110067;
})();
if(cljs.core.truth_(inst_109986__$1)){
var statearr_110068_110103 = state_110031__$1;
(statearr_110068_110103[(1)] = (21));

} else {
var statearr_110069_110104 = state_110031__$1;
(statearr_110069_110104[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110032 === (8))){
var inst_109945 = (state_110031[(9)]);
var inst_109957 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_109945,(4));
var inst_109958 = fluree.db.query.analytical.parse_block_from_source(inst_109957);
var inst_109959 = fluree.db.time_travel.as_of_block(db,inst_109958);
var state_110031__$1 = state_110031;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_110031__$1,(11),inst_109959);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__100742__auto__ = null;
var fluree$db$query$analytical$state_machine__100742__auto____0 = (function (){
var statearr_110070 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_110070[(0)] = fluree$db$query$analytical$state_machine__100742__auto__);

(statearr_110070[(1)] = (1));

return statearr_110070;
});
var fluree$db$query$analytical$state_machine__100742__auto____1 = (function (state_110031){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_110031);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e110071){if((e110071 instanceof Object)){
var ex__100745__auto__ = e110071;
var statearr_110072_110105 = state_110031;
(statearr_110072_110105[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_110031);

return cljs.core.cst$kw$recur;
} else {
throw e110071;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__110106 = state_110031;
state_110031 = G__110106;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__100742__auto__ = function(state_110031){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__100742__auto____1.call(this,state_110031);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__100742__auto____0;
fluree$db$query$analytical$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__100742__auto____1;
return fluree$db$query$analytical$state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_110073 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_110073[(6)] = c__100848__auto__);

return statearr_110073;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
}));

(fluree.db.query.analytical.get_source_clause.cljs$lang$maxFixedArity = 4);

fluree.db.query.analytical.tuples__GT_map = (function fluree$db$query$analytical$tuples__GT_map(start_map,tuples){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__110107){
var vec__110108 = p__110107;
var sub = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__110108,(0),null);
var obj = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__110108,(1),null);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,sub,cljs.core.conj,obj);
}),start_map,tuples);
});
fluree.db.query.analytical.expand_map = (function fluree$db$query$analytical$expand_map(tuple_map){
return cljs.core.zipmap(cljs.core.keys(tuple_map),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__110111_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$done,cljs.core.cst$kw$followed,cljs.core.cst$kw$all],[false,cljs.core.PersistentHashSet.EMPTY,cljs.core.set(p1__110111_SHARP_)]);
}),cljs.core.vals(tuple_map)));
});
fluree.db.query.analytical.follow_all_original_subject_paths = (function fluree$db$query$analytical$follow_all_original_subject_paths(subjects,tuple_map){
var expanded_map = fluree.db.query.analytical.expand_map(tuple_map);
var G__110115 = subjects;
var vec__110116 = G__110115;
var seq__110117 = cljs.core.seq(vec__110116);
var first__110118 = cljs.core.first(seq__110117);
var seq__110117__$1 = cljs.core.next(seq__110117);
var subject = first__110118;
var r = seq__110117__$1;
var acc = expanded_map;
var G__110115__$1 = G__110115;
var acc__$1 = acc;
while(true){
var vec__110122 = G__110115__$1;
var seq__110123 = cljs.core.seq(vec__110122);
var first__110124 = cljs.core.first(seq__110123);
var seq__110123__$1 = cljs.core.next(seq__110123);
var subject__$1 = first__110124;
var r__$1 = seq__110123__$1;
var acc__$2 = acc__$1;
if(cljs.core.not(subject__$1)){
return acc__$2;
} else {
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$done], null)))){
var G__110125 = r__$1;
var G__110126 = acc__$2;
G__110115__$1 = G__110125;
acc__$1 = G__110126;
continue;
} else {
var subject_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$all], null));
var subject_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null));
var subjects_to_follow = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(subject_all,subject_followed);
var acc_STAR_ = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__110115__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__110122,seq__110123,first__110124,seq__110123__$1,subject__$1,r__$1,acc__$2,G__110115,vec__110116,seq__110117,first__110118,seq__110117__$1,subject,r,acc,expanded_map){
return (function (acc__$3,subject_to_follow){
var all_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null));
var self_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject__$1,subject_to_follow);
var already_followed_QMARK_ = ((self_QMARK_)?false:(all_followed.cljs$core$IFn$_invoke$arity$1 ? all_followed.cljs$core$IFn$_invoke$arity$1(subject_to_follow) : all_followed.call(null,subject_to_follow)));
var acc_SINGLEQUOTE_ = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null),cljs.core.conj,subject_to_follow);
if(cljs.core.truth_((function (){var or__4126__auto__ = already_followed_QMARK_;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return self_QMARK_;
}
})())){
return acc_SINGLEQUOTE_;
} else {
var subject_to_follow_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,cljs.core.cst$kw$all], null));
var acc_SINGLEQUOTE___$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$all], null),((function (G__110115__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__110122,seq__110123,first__110124,seq__110123__$1,subject__$1,r__$1,acc__$2,G__110115,vec__110116,seq__110117,first__110118,seq__110117__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__110115__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__110122,seq__110123,first__110124,seq__110123__$1,subject__$1,r__$1,acc__$2,G__110115,vec__110116,seq__110117,first__110118,seq__110117__$1,subject,r,acc,expanded_map))
);
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,cljs.core.cst$kw$done], null)))){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null),((function (G__110115__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__110122,seq__110123,first__110124,seq__110123__$1,subject__$1,r__$1,acc__$2,G__110115,vec__110116,seq__110117,first__110118,seq__110117__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__110115__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__110122,seq__110123,first__110124,seq__110123__$1,subject__$1,r__$1,acc__$2,G__110115,vec__110116,seq__110117,first__110118,seq__110117__$1,subject,r,acc,expanded_map))
);
} else {
return acc_SINGLEQUOTE___$1;
}
}
});})(G__110115__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__110122,seq__110123,first__110124,seq__110123__$1,subject__$1,r__$1,acc__$2,G__110115,vec__110116,seq__110117,first__110118,seq__110117__$1,subject,r,acc,expanded_map))
,acc__$2,subjects_to_follow);
var subject_followed_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null));
var subject_all_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$all], null));
var subject_done_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject_followed_count,subject_all_count);
if(subject_done_QMARK_){
var G__110127 = r__$1;
var G__110128 = cljs.core.assoc_in(acc_STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$done], null),true);
G__110115__$1 = G__110127;
acc__$1 = G__110128;
continue;
} else {
var G__110129 = subjects;
var G__110130 = acc_STAR_;
G__110115__$1 = G__110129;
acc__$1 = G__110130;
continue;
}

}
}
break;
}
});
fluree.db.query.analytical.recur_map__GT_tuples = (function fluree$db$query$analytical$recur_map__GT_tuples(subjects,recur_map){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,subject){
var subject_vals = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(recur_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,cljs.core.cst$kw$followed], null));
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__110131_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,p1__110131_SHARP_],null));
}),subject_vals));
}),cljs.core.PersistentVector.EMPTY,subjects);
});
fluree.db.query.analytical.tuples__GT_recur = (function fluree$db$query$analytical$tuples__GT_recur(db,predicate,recur_map,depth,var_first_QMARK_){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_110217){
var state_val_110218 = (state_110217[(1)]);
if((state_val_110218 === (7))){
var inst_110140 = (state_110217[(2)]);
var inst_110141 = recur_map;
var inst_110142 = (1);
var state_110217__$1 = (function (){var statearr_110219 = state_110217;
(statearr_110219[(7)] = inst_110141);

(statearr_110219[(8)] = inst_110140);

(statearr_110219[(9)] = inst_110142);

return statearr_110219;
})();
var statearr_110220_110257 = state_110217__$1;
(statearr_110220_110257[(2)] = null);

(statearr_110220_110257[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110218 === (20))){
var inst_110188 = (state_110217[(2)]);
var state_110217__$1 = state_110217;
var statearr_110221_110258 = state_110217__$1;
(statearr_110221_110258[(2)] = inst_110188);

(statearr_110221_110258[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110218 === (1))){
var state_110217__$1 = state_110217;
var statearr_110222_110259 = state_110217__$1;
(statearr_110222_110259[(2)] = null);

(statearr_110222_110259[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110218 === (24))){
var inst_110213 = (state_110217[(2)]);
var state_110217__$1 = state_110217;
var statearr_110223_110260 = state_110217__$1;
(statearr_110223_110260[(2)] = inst_110213);


cljs.core.async.impl.ioc_helpers.process_exception(state_110217__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_110218 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_110217,(3),Error,null,(2));
var state_110217__$1 = state_110217;
if(cljs.core.truth_(depth)){
var statearr_110224_110261 = state_110217__$1;
(statearr_110224_110261[(1)] = (5));

} else {
var statearr_110225_110262 = state_110217__$1;
(statearr_110225_110262[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110218 === (15))){
var inst_110199 = (state_110217[(2)]);
var state_110217__$1 = state_110217;
var statearr_110226_110263 = state_110217__$1;
(statearr_110226_110263[(2)] = inst_110199);

(statearr_110226_110263[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110218 === (21))){
var inst_110175 = (state_110217[(10)]);
var inst_110167 = (state_110217[(11)]);
var inst_110182 = (state_110217[(2)]);
var inst_110183 = fluree.db.util.async.throw_err(inst_110182);
var inst_110184 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_110167,inst_110183);
var inst_110167__$1 = inst_110184;
var inst_110168 = inst_110175;
var state_110217__$1 = (function (){var statearr_110227 = state_110217;
(statearr_110227[(12)] = inst_110168);

(statearr_110227[(11)] = inst_110167__$1);

return statearr_110227;
})();
var statearr_110228_110264 = state_110217__$1;
(statearr_110228_110264[(2)] = null);

(statearr_110228_110264[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110218 === (13))){
var inst_110141 = (state_110217[(7)]);
var state_110217__$1 = state_110217;
var statearr_110229_110265 = state_110217__$1;
(statearr_110229_110265[(2)] = inst_110141);

(statearr_110229_110265[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110218 === (22))){
var inst_110206 = (state_110217[(13)]);
var state_110217__$1 = state_110217;
var statearr_110230_110266 = state_110217__$1;
(statearr_110230_110266[(2)] = inst_110206);

(statearr_110230_110266[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110218 === (6))){
var state_110217__$1 = state_110217;
var statearr_110231_110267 = state_110217__$1;
(statearr_110231_110267[(2)] = (100));

(statearr_110231_110267[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110218 === (17))){
var inst_110141 = (state_110217[(7)]);
var inst_110142 = (state_110217[(9)]);
var inst_110190 = (state_110217[(2)]);
var inst_110191 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_110192 = [(0),(2)];
var inst_110193 = (new cljs.core.PersistentVector(null,2,(5),inst_110191,inst_110192,null));
var inst_110194 = fluree.db.query.analytical.get_ns_arrays(inst_110193,inst_110190);
var inst_110195 = fluree.db.query.analytical.tuples__GT_map(inst_110141,inst_110194);
var inst_110196 = (inst_110142 + (1));
var inst_110141__$1 = inst_110195;
var inst_110142__$1 = inst_110196;
var state_110217__$1 = (function (){var statearr_110232 = state_110217;
(statearr_110232[(7)] = inst_110141__$1);

(statearr_110232[(9)] = inst_110142__$1);

return statearr_110232;
})();
var statearr_110233_110268 = state_110217__$1;
(statearr_110233_110268[(2)] = null);

(statearr_110233_110268[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110218 === (3))){
var inst_110133 = (state_110217[(2)]);
var state_110217__$1 = state_110217;
var statearr_110234_110269 = state_110217__$1;
(statearr_110234_110269[(2)] = inst_110133);


cljs.core.async.impl.ioc_helpers.process_exception(state_110217__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_110218 === (12))){
var inst_110201 = (state_110217[(2)]);
var state_110217__$1 = state_110217;
var statearr_110235_110270 = state_110217__$1;
(statearr_110235_110270[(2)] = inst_110201);

(statearr_110235_110270[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110218 === (2))){
var inst_110215 = (state_110217[(2)]);
var state_110217__$1 = state_110217;
return cljs.core.async.impl.ioc_helpers.return_chan(state_110217__$1,inst_110215);
} else {
if((state_val_110218 === (23))){
var inst_110205 = (state_110217[(14)]);
var inst_110206 = (state_110217[(13)]);
var inst_110204 = (state_110217[(15)]);
var inst_110140 = (state_110217[(8)]);
var inst_110209 = (function (){var max_depth = inst_110140;
var recur_map__$1 = inst_110205;
var subjects = inst_110204;
var tuples = inst_110206;
return (function (p1__110132_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second(p1__110132_SHARP_)],null));
});
})();
var inst_110210 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_110209,inst_110206);
var inst_110211 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(inst_110210);
var state_110217__$1 = state_110217;
var statearr_110236_110271 = state_110217__$1;
(statearr_110236_110271[(2)] = inst_110211);

(statearr_110236_110271[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110218 === (19))){
var inst_110167 = (state_110217[(11)]);
var state_110217__$1 = state_110217;
var statearr_110237_110272 = state_110217__$1;
(statearr_110237_110272[(2)] = inst_110167);

(statearr_110237_110272[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110218 === (11))){
var inst_110141 = (state_110217[(7)]);
var inst_110152 = (state_110217[(16)]);
var inst_110147 = cljs.core.vals(inst_110141);
var inst_110148 = cljs.core.flatten(inst_110147);
var inst_110149 = cljs.core.set(inst_110148);
var inst_110150 = cljs.core.keys(inst_110141);
var inst_110151 = cljs.core.set(inst_110150);
var inst_110152__$1 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(inst_110149,inst_110151);
var inst_110153 = cljs.core.empty_QMARK_(inst_110152__$1);
var state_110217__$1 = (function (){var statearr_110238 = state_110217;
(statearr_110238[(16)] = inst_110152__$1);

return statearr_110238;
})();
if(inst_110153){
var statearr_110239_110273 = state_110217__$1;
(statearr_110239_110273[(1)] = (13));

} else {
var statearr_110240_110274 = state_110217__$1;
(statearr_110240_110274[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110218 === (9))){
var inst_110205 = (state_110217[(14)]);
var inst_110204 = (state_110217[(15)]);
var inst_110203 = (state_110217[(2)]);
var inst_110204__$1 = cljs.core.keys(inst_110203);
var inst_110205__$1 = fluree.db.query.analytical.follow_all_original_subject_paths(inst_110204__$1,inst_110203);
var inst_110206 = fluree.db.query.analytical.recur_map__GT_tuples(inst_110204__$1,inst_110205__$1);
var state_110217__$1 = (function (){var statearr_110241 = state_110217;
(statearr_110241[(14)] = inst_110205__$1);

(statearr_110241[(13)] = inst_110206);

(statearr_110241[(15)] = inst_110204__$1);

return statearr_110241;
})();
if(cljs.core.truth_(var_first_QMARK_)){
var statearr_110242_110275 = state_110217__$1;
(statearr_110242_110275[(1)] = (22));

} else {
var statearr_110243_110276 = state_110217__$1;
(statearr_110243_110276[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110218 === (5))){
var state_110217__$1 = state_110217;
var statearr_110244_110277 = state_110217__$1;
(statearr_110244_110277[(2)] = depth);

(statearr_110244_110277[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110218 === (14))){
var inst_110152 = (state_110217[(16)]);
var inst_110163 = cljs.core.PersistentVector.EMPTY;
var inst_110164 = cljs.core.seq(inst_110152);
var inst_110165 = cljs.core.first(inst_110164);
var inst_110166 = cljs.core.next(inst_110164);
var inst_110167 = inst_110163;
var inst_110168 = inst_110152;
var state_110217__$1 = (function (){var statearr_110245 = state_110217;
(statearr_110245[(12)] = inst_110168);

(statearr_110245[(17)] = inst_110166);

(statearr_110245[(18)] = inst_110165);

(statearr_110245[(11)] = inst_110167);

return statearr_110245;
})();
var statearr_110246_110278 = state_110217__$1;
(statearr_110246_110278[(2)] = null);

(statearr_110246_110278[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110218 === (16))){
var inst_110168 = (state_110217[(12)]);
var inst_110174 = (state_110217[(19)]);
var inst_110173 = cljs.core.seq(inst_110168);
var inst_110174__$1 = cljs.core.first(inst_110173);
var inst_110175 = cljs.core.next(inst_110173);
var state_110217__$1 = (function (){var statearr_110247 = state_110217;
(statearr_110247[(10)] = inst_110175);

(statearr_110247[(19)] = inst_110174__$1);

return statearr_110247;
})();
if(cljs.core.truth_(inst_110174__$1)){
var statearr_110248_110279 = state_110217__$1;
(statearr_110248_110279[(1)] = (18));

} else {
var statearr_110249_110280 = state_110217__$1;
(statearr_110249_110280[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110218 === (10))){
var inst_110141 = (state_110217[(7)]);
var state_110217__$1 = state_110217;
var statearr_110250_110281 = state_110217__$1;
(statearr_110250_110281[(2)] = inst_110141);

(statearr_110250_110281[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110218 === (18))){
var inst_110174 = (state_110217[(19)]);
var inst_110177 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_110178 = [inst_110174,predicate];
var inst_110179 = (new cljs.core.PersistentVector(null,2,(5),inst_110177,inst_110178,null));
var inst_110180 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_110179);
var state_110217__$1 = state_110217;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_110217__$1,(21),inst_110180);
} else {
if((state_val_110218 === (8))){
var inst_110140 = (state_110217[(8)]);
var inst_110142 = (state_110217[(9)]);
var inst_110144 = (inst_110142 >= inst_110140);
var state_110217__$1 = state_110217;
if(cljs.core.truth_(inst_110144)){
var statearr_110251_110282 = state_110217__$1;
(statearr_110251_110282[(1)] = (10));

} else {
var statearr_110252_110283 = state_110217__$1;
(statearr_110252_110283[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__100742__auto__ = null;
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__100742__auto____0 = (function (){
var statearr_110253 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_110253[(0)] = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__100742__auto__);

(statearr_110253[(1)] = (1));

return statearr_110253;
});
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__100742__auto____1 = (function (state_110217){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_110217);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e110254){if((e110254 instanceof Object)){
var ex__100745__auto__ = e110254;
var statearr_110255_110284 = state_110217;
(statearr_110255_110284[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_110217);

return cljs.core.cst$kw$recur;
} else {
throw e110254;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__110285 = state_110217;
state_110217 = G__110285;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__100742__auto__ = function(state_110217){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__100742__auto____1.call(this,state_110217);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__100742__auto____0;
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__100742__auto____1;
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_110256 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_110256[(6)] = c__100848__auto__);

return statearr_110256;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
fluree.db.query.analytical.fdb_clause__GT_tuples = (function fluree$db$query$analytical$fdb_clause__GT_tuples(db,p__110286,clause,fuel,max_fuel){
var map__110287 = p__110286;
var map__110287__$1 = (((((!((map__110287 == null))))?(((((map__110287.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__110287.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__110287):map__110287);
var res = map__110287__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__110287__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__110287__$1,cljs.core.cst$kw$tuples);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__110287__$1,cljs.core.cst$kw$vars);
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_110416){
var state_val_110417 = (state_110416[(1)]);
if((state_val_110417 === (7))){
var inst_110313 = (state_110416[(2)]);
var state_110416__$1 = state_110416;
if(cljs.core.truth_(inst_110313)){
var statearr_110418_110477 = state_110416__$1;
(statearr_110418_110477[(1)] = (11));

} else {
var statearr_110419_110478 = state_110416__$1;
(statearr_110419_110478[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110417 === (20))){
var inst_110320 = (state_110416[(7)]);
var inst_110408 = (state_110416[(2)]);
var inst_110409 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_110410 = cljs.core.keys(inst_110320);
var inst_110411 = [inst_110410,vars,inst_110408];
var inst_110412 = cljs.core.PersistentHashMap.fromArrays(inst_110409,inst_110411);
var state_110416__$1 = state_110416;
var statearr_110420_110479 = state_110416__$1;
(statearr_110420_110479[(2)] = inst_110412);


cljs.core.async.impl.ioc_helpers.process_exception(state_110416__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_110417 === (27))){
var inst_110349 = (state_110416[(8)]);
var inst_110379 = cljs.core.PersistentHashMap.EMPTY;
var inst_110380 = fluree.db.query.analytical.tuples__GT_map(inst_110379,inst_110349);
var state_110416__$1 = state_110416;
var statearr_110421_110480 = state_110416__$1;
(statearr_110421_110480[(2)] = inst_110380);

(statearr_110421_110480[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110417 === (1))){
var state_110416__$1 = state_110416;
var statearr_110422_110481 = state_110416__$1;
(statearr_110422_110481[(2)] = null);

(statearr_110422_110481[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110417 === (24))){
var state_110416__$1 = state_110416;
var statearr_110423_110482 = state_110416__$1;
(statearr_110423_110482[(2)] = null);

(statearr_110423_110482[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110417 === (4))){
var inst_110297 = (state_110416[(9)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_110416,(3),Error,null,(2));
var inst_110297__$1 = fluree.db.query.analytical.clause__GT_rel(db,vars,clause);
var inst_110299 = (inst_110297__$1 == null);
var inst_110300 = cljs.core.not(inst_110299);
var state_110416__$1 = (function (){var statearr_110424 = state_110416;
(statearr_110424[(9)] = inst_110297__$1);

return statearr_110424;
})();
if(inst_110300){
var statearr_110425_110483 = state_110416__$1;
(statearr_110425_110483[(1)] = (5));

} else {
var statearr_110426_110484 = state_110416__$1;
(statearr_110426_110484[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110417 === (15))){
var inst_110323 = (state_110416[(10)]);
var state_110416__$1 = state_110416;
var statearr_110427_110485 = state_110416__$1;
(statearr_110427_110485[(2)] = inst_110323);

(statearr_110427_110485[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110417 === (21))){
var inst_110333 = (state_110416[(11)]);
var inst_110357 = ["Cannot use predicate recursion when predicate is variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_110333)].join('');
var inst_110358 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_110359 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_110360 = cljs.core.PersistentHashMap.fromArrays(inst_110358,inst_110359);
var inst_110361 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_110357,inst_110360);
var inst_110362 = (function(){throw inst_110361})();
var state_110416__$1 = state_110416;
var statearr_110428_110486 = state_110416__$1;
(statearr_110428_110486[(2)] = inst_110362);

(statearr_110428_110486[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110417 === (31))){
var inst_110351 = (state_110416[(12)]);
var inst_110388 = cljs.core.coll_QMARK_(inst_110351);
var state_110416__$1 = state_110416;
if(inst_110388){
var statearr_110429_110487 = state_110416__$1;
(statearr_110429_110487[(1)] = (33));

} else {
var statearr_110430_110488 = state_110416__$1;
(statearr_110430_110488[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110417 === (32))){
var inst_110399 = (state_110416[(2)]);
var state_110416__$1 = state_110416;
var statearr_110431_110489 = state_110416__$1;
(statearr_110431_110489[(2)] = inst_110399);

(statearr_110431_110489[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110417 === (33))){
var inst_110345 = (state_110416[(13)]);
var inst_110349 = (state_110416[(8)]);
var inst_110390 = cljs.core.PersistentHashMap.EMPTY;
var inst_110391 = cljs.core.first(inst_110345);
var inst_110392 = cljs.core.first(inst_110391);
var inst_110393 = cljs.core.flatten(inst_110349);
var inst_110394 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_110390,inst_110392,inst_110393);
var state_110416__$1 = state_110416;
var statearr_110432_110490 = state_110416__$1;
(statearr_110432_110490[(2)] = inst_110394);

(statearr_110432_110490[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110417 === (13))){
var inst_110324 = (state_110416[(14)]);
var inst_110320 = (state_110416[(7)]);
var inst_110323 = (state_110416[(10)]);
var inst_110335 = (state_110416[(15)]);
var inst_110318 = (state_110416[(2)]);
var inst_110319 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_110318,cljs.core.cst$kw$search);
var inst_110320__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_110318,cljs.core.cst$kw$rel);
var inst_110321 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_110318,cljs.core.cst$kw$opts);
var inst_110322 = fluree.db.query.analytical.intersecting_keys_tuples_clause(res,clause);
var inst_110323__$1 = cljs.core.cst$kw$object_DASH_fn.cljs$core$IFn$_invoke$arity$1(inst_110321);
var inst_110324__$1 = cljs.core.cst$kw$recur.cljs$core$IFn$_invoke$arity$1(inst_110321);
var inst_110326 = (function (){var map__110293 = inst_110318;
var search = inst_110319;
var rel = inst_110320__$1;
var opts = inst_110321;
var common_keys = inst_110322;
var object_fn = inst_110323__$1;
var recur_depth = inst_110324__$1;
return (function (p__110325,common_key){
var vec__110433 = p__110325;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__110433,(0),null);
var clause_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__110433,(1),null);
var idx_of = fluree.db.util.core.index_of(clause,cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_key));
var k = (function (){var pred__110436 = cljs.core._EQ_;
var expr__110437 = idx_of;
if(cljs.core.truth_((pred__110436.cljs$core$IFn$_invoke$arity$2 ? pred__110436.cljs$core$IFn$_invoke$arity$2((0),expr__110437) : pred__110436.call(null,(0),expr__110437)))){
return cljs.core.cst$kw$subject_DASH_fn;
} else {
if(cljs.core.truth_((pred__110436.cljs$core$IFn$_invoke$arity$2 ? pred__110436.cljs$core$IFn$_invoke$arity$2((1),expr__110437) : pred__110436.call(null,(1),expr__110437)))){
return cljs.core.cst$kw$predicate_DASH_fn;
} else {
if(cljs.core.truth_((pred__110436.cljs$core$IFn$_invoke$arity$2 ? pred__110436.cljs$core$IFn$_invoke$arity$2((2),expr__110437) : pred__110436.call(null,(2),expr__110437)))){
return cljs.core.cst$kw$object_DASH_fn;
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__110437)].join('')));
}
}
}
})();
var res_idx = fluree.db.util.core.index_of(headers,common_key);
var v = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,fluree.db.query.analytical.get_ns_arrays(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res_idx], null),tuples)));
var single_v_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(v));
var v__$1 = (cljs.core.truth_((((!(single_v_QMARK_)))?(function (){var and__4115__auto__ = object_fn;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,object_fn);
} else {
return and__4115__auto__;
}
})():false))?cljs.core.comp.cljs$core$IFn$_invoke$arity$2(v,object_fn):v);
if(single_v_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(clause_SINGLEQUOTE_,idx_of,cljs.core.first(v__$1))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,k,v__$1),clause_SINGLEQUOTE_], null);
}
});
})();
var inst_110327 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_110328 = cljs.core.PersistentHashMap.EMPTY;
var inst_110329 = [inst_110328,inst_110319];
var inst_110330 = (new cljs.core.PersistentVector(null,2,(5),inst_110327,inst_110329,null));
var inst_110331 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_110326,inst_110330,inst_110322);
var inst_110332 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_110331,(0),null);
var inst_110333 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_110331,(1),null);
var inst_110334 = [cljs.core.cst$kw$object_DASH_fn];
var inst_110335__$1 = cljs.core.cst$kw$object_DASH_fn.cljs$core$IFn$_invoke$arity$1(inst_110332);
var state_110416__$1 = (function (){var statearr_110439 = state_110416;
(statearr_110439[(14)] = inst_110324__$1);

(statearr_110439[(16)] = inst_110334);

(statearr_110439[(7)] = inst_110320__$1);

(statearr_110439[(10)] = inst_110323__$1);

(statearr_110439[(15)] = inst_110335__$1);

(statearr_110439[(11)] = inst_110333);

return statearr_110439;
})();
if(cljs.core.truth_(inst_110335__$1)){
var statearr_110440_110491 = state_110416__$1;
(statearr_110440_110491[(1)] = (14));

} else {
var statearr_110441_110492 = state_110416__$1;
(statearr_110441_110492[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110417 === (22))){
var state_110416__$1 = state_110416;
var statearr_110442_110493 = state_110416__$1;
(statearr_110442_110493[(2)] = null);

(statearr_110442_110493[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110417 === (36))){
var inst_110404 = (state_110416[(2)]);
var inst_110405 = fluree.db.util.async.throw_err(inst_110404);
var state_110416__$1 = state_110416;
var statearr_110443_110494 = state_110416__$1;
(statearr_110443_110494[(2)] = inst_110405);

(statearr_110443_110494[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110417 === (29))){
var inst_110324 = (state_110416[(14)]);
var inst_110353 = (state_110416[(17)]);
var inst_110354 = (state_110416[(18)]);
var inst_110401 = (state_110416[(2)]);
var inst_110402 = fluree.db.query.analytical.tuples__GT_recur(db,inst_110354,inst_110401,inst_110324,inst_110353);
var state_110416__$1 = state_110416;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_110416__$1,(36),inst_110402);
} else {
if((state_val_110417 === (6))){
var state_110416__$1 = state_110416;
var statearr_110444_110495 = state_110416__$1;
(statearr_110444_110495[(2)] = false);

(statearr_110444_110495[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110417 === (28))){
var inst_110351 = (state_110416[(12)]);
var inst_110382 = typeof inst_110351 === 'number';
var state_110416__$1 = state_110416;
if(cljs.core.truth_(inst_110382)){
var statearr_110445_110496 = state_110416__$1;
(statearr_110445_110496[(1)] = (30));

} else {
var statearr_110446_110497 = state_110416__$1;
(statearr_110446_110497[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110417 === (25))){
var inst_110333 = (state_110416[(11)]);
var inst_110370 = ["Cannot use predicate recursion when object is not a variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_110333)].join('');
var inst_110371 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_110372 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_110373 = cljs.core.PersistentHashMap.fromArrays(inst_110371,inst_110372);
var inst_110374 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_110370,inst_110373);
var inst_110375 = (function(){throw inst_110374})();
var state_110416__$1 = state_110416;
var statearr_110447_110498 = state_110416__$1;
(statearr_110447_110498[(2)] = inst_110375);

(statearr_110447_110498[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110417 === (34))){
var state_110416__$1 = state_110416;
var statearr_110448_110499 = state_110416__$1;
(statearr_110448_110499[(2)] = null);

(statearr_110448_110499[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110417 === (17))){
var inst_110324 = (state_110416[(14)]);
var inst_110345 = (state_110416[(13)]);
var inst_110320 = (state_110416[(7)]);
var inst_110344 = (state_110416[(2)]);
var inst_110345__$1 = fluree.db.util.async.throw_err(inst_110344);
var inst_110346 = cljs.core.count(inst_110345__$1);
var inst_110347 = fluree.db.query.analytical.add_fuel(inst_110346,fuel,max_fuel);
var inst_110348 = cljs.core.vals(inst_110320);
var inst_110349 = fluree.db.query.analytical.get_ns_arrays(inst_110348,inst_110345__$1);
var state_110416__$1 = (function (){var statearr_110449 = state_110416;
(statearr_110449[(13)] = inst_110345__$1);

(statearr_110449[(8)] = inst_110349);

(statearr_110449[(19)] = inst_110347);

return statearr_110449;
})();
if(cljs.core.truth_(inst_110324)){
var statearr_110450_110500 = state_110416__$1;
(statearr_110450_110500[(1)] = (18));

} else {
var statearr_110451_110501 = state_110416__$1;
(statearr_110451_110501[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110417 === (3))){
var inst_110289 = (state_110416[(2)]);
var state_110416__$1 = state_110416;
var statearr_110452_110502 = state_110416__$1;
(statearr_110452_110502[(2)] = inst_110289);


cljs.core.async.impl.ioc_helpers.process_exception(state_110416__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_110417 === (12))){
var inst_110297 = (state_110416[(9)]);
var state_110416__$1 = state_110416;
var statearr_110453_110503 = state_110416__$1;
(statearr_110453_110503[(2)] = inst_110297);

(statearr_110453_110503[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110417 === (2))){
var inst_110414 = (state_110416[(2)]);
var state_110416__$1 = state_110416;
return cljs.core.async.impl.ioc_helpers.return_chan(state_110416__$1,inst_110414);
} else {
if((state_val_110417 === (23))){
var inst_110365 = (state_110416[(2)]);
var inst_110366 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,(2));
var inst_110367 = fluree.db.query.analytical.variable_QMARK_(inst_110366);
var state_110416__$1 = (function (){var statearr_110454 = state_110416;
(statearr_110454[(20)] = inst_110365);

return statearr_110454;
})();
if(cljs.core.truth_(inst_110367)){
var statearr_110455_110504 = state_110416__$1;
(statearr_110455_110504[(1)] = (24));

} else {
var statearr_110456_110505 = state_110416__$1;
(statearr_110456_110505[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110417 === (35))){
var inst_110397 = (state_110416[(2)]);
var state_110416__$1 = state_110416;
var statearr_110457_110506 = state_110416__$1;
(statearr_110457_110506[(2)] = inst_110397);

(statearr_110457_110506[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110417 === (19))){
var inst_110349 = (state_110416[(8)]);
var state_110416__$1 = state_110416;
var statearr_110458_110507 = state_110416__$1;
(statearr_110458_110507[(2)] = inst_110349);

(statearr_110458_110507[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110417 === (11))){
var inst_110297 = (state_110416[(9)]);
var inst_110315 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_110297);
var state_110416__$1 = state_110416;
var statearr_110459_110508 = state_110416__$1;
(statearr_110459_110508[(2)] = inst_110315);

(statearr_110459_110508[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110417 === (9))){
var state_110416__$1 = state_110416;
var statearr_110460_110509 = state_110416__$1;
(statearr_110460_110509[(2)] = false);

(statearr_110460_110509[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110417 === (5))){
var inst_110297 = (state_110416[(9)]);
var inst_110302 = inst_110297.cljs$lang$protocol_mask$partition0$;
var inst_110303 = (inst_110302 & (64));
var inst_110304 = inst_110297.cljs$core$ISeq$;
var inst_110305 = (cljs.core.PROTOCOL_SENTINEL === inst_110304);
var inst_110306 = ((inst_110303) || (inst_110305));
var state_110416__$1 = state_110416;
if(cljs.core.truth_(inst_110306)){
var statearr_110461_110510 = state_110416__$1;
(statearr_110461_110510[(1)] = (8));

} else {
var statearr_110462_110511 = state_110416__$1;
(statearr_110462_110511[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110417 === (14))){
var inst_110335 = (state_110416[(15)]);
var state_110416__$1 = state_110416;
var statearr_110463_110512 = state_110416__$1;
(statearr_110463_110512[(2)] = inst_110335);

(statearr_110463_110512[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110417 === (26))){
var inst_110353 = (state_110416[(17)]);
var inst_110377 = (state_110416[(2)]);
var state_110416__$1 = (function (){var statearr_110464 = state_110416;
(statearr_110464[(21)] = inst_110377);

return statearr_110464;
})();
if(cljs.core.truth_(inst_110353)){
var statearr_110465_110513 = state_110416__$1;
(statearr_110465_110513[(1)] = (27));

} else {
var statearr_110466_110514 = state_110416__$1;
(statearr_110466_110514[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110417 === (16))){
var inst_110334 = (state_110416[(16)]);
var inst_110333 = (state_110416[(11)]);
var inst_110339 = (state_110416[(2)]);
var inst_110340 = [inst_110339];
var inst_110341 = cljs.core.PersistentHashMap.fromArrays(inst_110334,inst_110340);
var inst_110342 = fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,inst_110333,inst_110341);
var state_110416__$1 = state_110416;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_110416__$1,(17),inst_110342);
} else {
if((state_val_110417 === (30))){
var inst_110349 = (state_110416[(8)]);
var inst_110351 = (state_110416[(12)]);
var inst_110384 = cljs.core.PersistentHashMap.EMPTY;
var inst_110385 = cljs.core.flatten(inst_110349);
var inst_110386 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_110384,inst_110351,inst_110385);
var state_110416__$1 = state_110416;
var statearr_110467_110515 = state_110416__$1;
(statearr_110467_110515[(2)] = inst_110386);

(statearr_110467_110515[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110417 === (10))){
var inst_110310 = (state_110416[(2)]);
var state_110416__$1 = state_110416;
var statearr_110468_110516 = state_110416__$1;
(statearr_110468_110516[(2)] = inst_110310);

(statearr_110468_110516[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110417 === (18))){
var inst_110333 = (state_110416[(11)]);
var inst_110354 = (state_110416[(18)]);
var inst_110351 = cljs.core.first(inst_110333);
var inst_110352 = cljs.core.first(clause);
var inst_110353 = fluree.db.query.analytical.variable_QMARK_(inst_110352);
var inst_110354__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(inst_110333,(1));
var inst_110355 = fluree.db.query.analytical.variable_QMARK_(inst_110354__$1);
var state_110416__$1 = (function (){var statearr_110469 = state_110416;
(statearr_110469[(17)] = inst_110353);

(statearr_110469[(12)] = inst_110351);

(statearr_110469[(18)] = inst_110354__$1);

return statearr_110469;
})();
if(cljs.core.truth_(inst_110355)){
var statearr_110470_110517 = state_110416__$1;
(statearr_110470_110517[(1)] = (21));

} else {
var statearr_110471_110518 = state_110416__$1;
(statearr_110471_110518[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110417 === (8))){
var state_110416__$1 = state_110416;
var statearr_110472_110519 = state_110416__$1;
(statearr_110472_110519[(2)] = true);

(statearr_110472_110519[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__100742__auto__ = null;
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__100742__auto____0 = (function (){
var statearr_110473 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_110473[(0)] = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__100742__auto__);

(statearr_110473[(1)] = (1));

return statearr_110473;
});
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__100742__auto____1 = (function (state_110416){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_110416);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e110474){if((e110474 instanceof Object)){
var ex__100745__auto__ = e110474;
var statearr_110475_110520 = state_110416;
(statearr_110475_110520[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_110416);

return cljs.core.cst$kw$recur;
} else {
throw e110474;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__110521 = state_110416;
state_110416 = G__110521;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__100742__auto__ = function(state_110416){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__100742__auto____1.call(this,state_110416);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__100742__auto____0;
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__100742__auto____1;
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_110476 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_110476[(6)] = c__100848__auto__);

return statearr_110476;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
fluree.db.query.analytical.full_text__GT_tuples = (function fluree$db$query$analytical$full_text__GT_tuples(db,res,clause){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Full text search is not supported in JS",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
});
fluree.db.query.analytical.collection__GT_tuples = (function fluree$db$query$analytical$collection__GT_tuples(db,res,clause){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_110617){
var state_val_110618 = (state_110617[(1)]);
if((state_val_110618 === (7))){
var inst_110535 = (state_110617[(2)]);
var state_110617__$1 = state_110617;
if(cljs.core.truth_(inst_110535)){
var statearr_110619_110652 = state_110617__$1;
(statearr_110619_110652[(1)] = (8));

} else {
var statearr_110620_110653 = state_110617__$1;
(statearr_110620_110653[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110618 === (20))){
var inst_110582 = (state_110617[(7)]);
var state_110617__$1 = state_110617;
var statearr_110621_110654 = state_110617__$1;
(statearr_110621_110654[(2)] = inst_110582);

(statearr_110621_110654[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110618 === (1))){
var state_110617__$1 = state_110617;
var statearr_110622_110655 = state_110617__$1;
(statearr_110622_110655[(2)] = null);

(statearr_110622_110655[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110618 === (4))){
var inst_110529 = (state_110617[(8)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_110617,(3),Error,null,(2));
var inst_110528 = cljs.core.first(clause);
var inst_110529__$1 = fluree.db.query.analytical.variable_QMARK_(inst_110528);
var inst_110530 = cljs.core.last(clause);
var inst_110531 = fluree.db.query.analytical.variable_QMARK_(inst_110530);
var state_110617__$1 = (function (){var statearr_110623 = state_110617;
(statearr_110623[(8)] = inst_110529__$1);

(statearr_110623[(9)] = inst_110531);

return statearr_110623;
})();
if(cljs.core.truth_(inst_110529__$1)){
var statearr_110624_110656 = state_110617__$1;
(statearr_110624_110656[(1)] = (5));

} else {
var statearr_110625_110657 = state_110617__$1;
(statearr_110625_110657[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110618 === (15))){
var inst_110529 = (state_110617[(8)]);
var inst_110531 = (state_110617[(9)]);
var inst_110562 = cljs.core.last(clause);
var inst_110563 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$id,inst_110562);
var inst_110564 = cljs.core.cst$kw$ecount.cljs$core$IFn$_invoke$arity$1(db);
var inst_110565 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_110564,inst_110563);
var inst_110566 = fluree.db.flake.min_subject_id(inst_110563);
var inst_110567 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$tuples,cljs.core.cst$kw$vars];
var inst_110568 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_110569 = [inst_110529];
var inst_110570 = (new cljs.core.PersistentVector(null,1,(5),inst_110568,inst_110569,null));
var inst_110571 = (function (){var subject_var = inst_110529;
var object_var = inst_110531;
var cid = inst_110563;
var max_sid = inst_110565;
var min_sid = inst_110566;
return (function (p1__110523_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__110523_SHARP_);
});
})();
var inst_110572 = (inst_110565 + (1));
var inst_110573 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_110566,inst_110572);
var inst_110574 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_110571,inst_110573);
var inst_110575 = cljs.core.PersistentHashMap.EMPTY;
var inst_110576 = [inst_110570,inst_110574,inst_110575];
var inst_110577 = cljs.core.PersistentHashMap.fromArrays(inst_110567,inst_110576);
var state_110617__$1 = state_110617;
var statearr_110626_110658 = state_110617__$1;
(statearr_110626_110658[(2)] = inst_110577);

(statearr_110626_110658[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110618 === (21))){
var inst_110582 = (state_110617[(7)]);
var inst_110586 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_110582);
var state_110617__$1 = state_110617;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_110617__$1,(23),inst_110586);
} else {
if((state_val_110618 === (13))){
var inst_110611 = (state_110617[(2)]);
var state_110617__$1 = state_110617;
var statearr_110627_110659 = state_110617__$1;
(statearr_110627_110659[(2)] = inst_110611);

(statearr_110627_110659[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110618 === (22))){
var inst_110531 = (state_110617[(9)]);
var inst_110591 = (state_110617[(2)]);
var inst_110592 = fluree.db.flake.sid__GT_cid(inst_110591);
var inst_110593 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$name,inst_110592);
var inst_110594 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$tuples,cljs.core.cst$kw$vars];
var inst_110595 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_110596 = [inst_110531];
var inst_110597 = (new cljs.core.PersistentVector(null,1,(5),inst_110595,inst_110596,null));
var inst_110598 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_110599 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_110600 = [inst_110593];
var inst_110601 = (new cljs.core.PersistentVector(null,1,(5),inst_110599,inst_110600,null));
var inst_110602 = [inst_110601];
var inst_110603 = (new cljs.core.PersistentVector(null,1,(5),inst_110598,inst_110602,null));
var inst_110604 = cljs.core.PersistentHashMap.EMPTY;
var inst_110605 = [inst_110597,inst_110603,inst_110604];
var inst_110606 = cljs.core.PersistentHashMap.fromArrays(inst_110594,inst_110605);
var state_110617__$1 = state_110617;
var statearr_110628_110660 = state_110617__$1;
(statearr_110628_110660[(2)] = inst_110606);

(statearr_110628_110660[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110618 === (6))){
var inst_110529 = (state_110617[(8)]);
var state_110617__$1 = state_110617;
var statearr_110629_110661 = state_110617__$1;
(statearr_110629_110661[(2)] = inst_110529);

(statearr_110629_110661[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110618 === (17))){
var inst_110582 = (state_110617[(7)]);
var inst_110582__$1 = cljs.core.first(clause);
var inst_110583 = typeof inst_110582__$1 === 'number';
var state_110617__$1 = (function (){var statearr_110630 = state_110617;
(statearr_110630[(7)] = inst_110582__$1);

return statearr_110630;
})();
if(cljs.core.truth_(inst_110583)){
var statearr_110631_110662 = state_110617__$1;
(statearr_110631_110662[(1)] = (20));

} else {
var statearr_110632_110663 = state_110617__$1;
(statearr_110632_110663[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110618 === (3))){
var inst_110524 = (state_110617[(2)]);
var state_110617__$1 = state_110617;
var statearr_110633_110664 = state_110617__$1;
(statearr_110633_110664[(2)] = inst_110524);


cljs.core.async.impl.ioc_helpers.process_exception(state_110617__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_110618 === (12))){
var inst_110531 = (state_110617[(9)]);
var state_110617__$1 = state_110617;
if(cljs.core.truth_(inst_110531)){
var statearr_110634_110665 = state_110617__$1;
(statearr_110634_110665[(1)] = (17));

} else {
var statearr_110635_110666 = state_110617__$1;
(statearr_110635_110666[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110618 === (2))){
var inst_110615 = (state_110617[(2)]);
var state_110617__$1 = state_110617;
return cljs.core.async.impl.ioc_helpers.return_chan(state_110617__$1,inst_110615);
} else {
if((state_val_110618 === (23))){
var inst_110588 = (state_110617[(2)]);
var inst_110589 = fluree.db.util.async.throw_err(inst_110588);
var state_110617__$1 = state_110617;
var statearr_110636_110667 = state_110617__$1;
(statearr_110636_110667[(2)] = inst_110589);

(statearr_110636_110667[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110618 === (19))){
var inst_110609 = (state_110617[(2)]);
var state_110617__$1 = state_110617;
var statearr_110637_110668 = state_110617__$1;
(statearr_110637_110668[(2)] = inst_110609);

(statearr_110637_110668[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110618 === (11))){
var inst_110544 = ["_tx",null,"_block",null];
var inst_110545 = (new cljs.core.PersistentArrayMap(null,2,inst_110544,null));
var inst_110546 = (new cljs.core.PersistentHashSet(null,inst_110545,null));
var inst_110547 = cljs.core.last(clause);
var inst_110548 = (inst_110546.cljs$core$IFn$_invoke$arity$1 ? inst_110546.cljs$core$IFn$_invoke$arity$1(inst_110547) : inst_110546.call(null,inst_110547));
var state_110617__$1 = state_110617;
if(cljs.core.truth_(inst_110548)){
var statearr_110638_110669 = state_110617__$1;
(statearr_110638_110669[(1)] = (14));

} else {
var statearr_110639_110670 = state_110617__$1;
(statearr_110639_110670[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110618 === (9))){
var inst_110529 = (state_110617[(8)]);
var state_110617__$1 = state_110617;
if(cljs.core.truth_(inst_110529)){
var statearr_110640_110671 = state_110617__$1;
(statearr_110640_110671[(1)] = (11));

} else {
var statearr_110641_110672 = state_110617__$1;
(statearr_110641_110672[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110618 === (5))){
var inst_110531 = (state_110617[(9)]);
var state_110617__$1 = state_110617;
var statearr_110642_110673 = state_110617__$1;
(statearr_110642_110673[(2)] = inst_110531);

(statearr_110642_110673[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110618 === (14))){
var inst_110529 = (state_110617[(8)]);
var inst_110531 = (state_110617[(9)]);
var inst_110550 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_110551 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$tuples,cljs.core.cst$kw$vars];
var inst_110552 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_110553 = [inst_110529];
var inst_110554 = (new cljs.core.PersistentVector(null,1,(5),inst_110552,inst_110553,null));
var inst_110555 = (function (){var subject_var = inst_110529;
var object_var = inst_110531;
var min_sid = inst_110550;
var max_sid = (0);
return (function (p1__110522_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__110522_SHARP_);
});
})();
var inst_110556 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_110550,(0));
var inst_110557 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_110555,inst_110556);
var inst_110558 = cljs.core.PersistentHashMap.EMPTY;
var inst_110559 = [inst_110554,inst_110557,inst_110558];
var inst_110560 = cljs.core.PersistentHashMap.fromArrays(inst_110551,inst_110559);
var state_110617__$1 = state_110617;
var statearr_110643_110674 = state_110617__$1;
(statearr_110643_110674[(2)] = inst_110560);

(statearr_110643_110674[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110618 === (16))){
var inst_110579 = (state_110617[(2)]);
var state_110617__$1 = state_110617;
var statearr_110644_110675 = state_110617__$1;
(statearr_110644_110675[(2)] = inst_110579);

(statearr_110644_110675[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110618 === (10))){
var inst_110613 = (state_110617[(2)]);
var state_110617__$1 = state_110617;
var statearr_110645_110676 = state_110617__$1;
(statearr_110645_110676[(2)] = inst_110613);


cljs.core.async.impl.ioc_helpers.process_exception(state_110617__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_110618 === (18))){
var state_110617__$1 = state_110617;
var statearr_110646_110677 = state_110617__$1;
(statearr_110646_110677[(2)] = null);

(statearr_110646_110677[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110618 === (8))){
var inst_110537 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_110538 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_110539 = cljs.core.PersistentHashMap.fromArrays(inst_110537,inst_110538);
var inst_110540 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("When using rdf:type, either a subject or a type (collection) must be specified.",inst_110539);
var inst_110541 = (function(){throw inst_110540})();
var state_110617__$1 = state_110617;
var statearr_110647_110678 = state_110617__$1;
(statearr_110647_110678[(2)] = inst_110541);

(statearr_110647_110678[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__100742__auto__ = null;
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__100742__auto____0 = (function (){
var statearr_110648 = [null,null,null,null,null,null,null,null,null,null];
(statearr_110648[(0)] = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__100742__auto__);

(statearr_110648[(1)] = (1));

return statearr_110648;
});
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__100742__auto____1 = (function (state_110617){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_110617);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e110649){if((e110649 instanceof Object)){
var ex__100745__auto__ = e110649;
var statearr_110650_110679 = state_110617;
(statearr_110650_110679[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_110617);

return cljs.core.cst$kw$recur;
} else {
throw e110649;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__110680 = state_110617;
state_110617 = G__110680;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__100742__auto__ = function(state_110617){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__100742__auto____1.call(this,state_110617);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__100742__auto____0;
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__100742__auto____1;
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_110651 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_110651[(6)] = c__100848__auto__);

return statearr_110651;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
fluree.db.query.analytical.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 41, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"isNUMERIC",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null], null), null);
fluree.db.query.analytical.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical$sum(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical$avg(coll){
return (sum(coll) / cljs.core.count(coll));
});
var median = (function fluree$db$query$analytical$median(coll){
var terms = cljs.core.sort.cljs$core$IFn$_invoke$arity$1(coll);
var size = cljs.core.count(coll);
var med = (size >> (1));
var G__110687 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,med);
if(cljs.core.even_QMARK_(size)){
return ((G__110687 + cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,(med - (1)))) / (2));
} else {
return G__110687;
}
});
var variance = (function fluree$db$query$analytical$variance(coll){
var mean = avg(coll);
var sum__$1 = sum((function (){var iter__4529__auto__ = (function fluree$db$query$analytical$variance_$_iter__110688(s__110689){
return (new cljs.core.LazySeq(null,(function (){
var s__110689__$1 = s__110689;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__110689__$1);
if(temp__5735__auto__){
var s__110689__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s__110689__$2)){
var c__4527__auto__ = cljs.core.chunk_first(s__110689__$2);
var size__4528__auto__ = cljs.core.count(c__4527__auto__);
var b__110691 = cljs.core.chunk_buffer(size__4528__auto__);
if((function (){var i__110690 = (0);
while(true){
if((i__110690 < size__4528__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4527__auto__,i__110690);
var delta = (x - mean);
cljs.core.chunk_append(b__110691,(delta * delta));

var G__110693 = (i__110690 + (1));
i__110690 = G__110693;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__110691),fluree$db$query$analytical$variance_$_iter__110688(cljs.core.chunk_rest(s__110689__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__110691),null);
}
} else {
var x = cljs.core.first(s__110689__$2);
var delta = (x - mean);
return cljs.core.cons((delta * delta),fluree$db$query$analytical$variance_$_iter__110688(cljs.core.rest(s__110689__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__(coll);
})());
return (sum__$1 / cljs.core.count(coll));
});
var stddev = (function fluree$db$query$analytical$stddev(coll){
var G__110692 = variance(coll);
return Math.sqrt(G__110692);
});
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$sym$variance,cljs.core.cst$sym$count,cljs.core.cst$sym$median,cljs.core.cst$sym$groupconcat,cljs.core.cst$sym$sum,cljs.core.cst$sym$abs,cljs.core.cst$sym$min,cljs.core.cst$sym$ceil,cljs.core.cst$sym$max,cljs.core.cst$sym$count_DASH_distinct,cljs.core.cst$sym$avg,cljs.core.cst$sym$floor,cljs.core.cst$sym$str,cljs.core.cst$sym$stddev,cljs.core.cst$sym$rand,cljs.core.cst$sym$sample],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__4214__auto__ = n;
var y__4215__auto__ = (- n);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
}),(function() {
var G__110694 = null;
var G__110694__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__110694__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.last(acc)) < (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__110694 = function(n,coll){
switch(arguments.length){
case 1:
return G__110694__1.call(this,n);
case 2:
return G__110694__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__110694.cljs$core$IFn$_invoke$arity$1 = G__110694__1;
G__110694.cljs$core$IFn$_invoke$arity$2 = G__110694__2;
return G__110694;
})()
,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__110695 = null;
var G__110695__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__110695__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.first(acc)) > (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.next(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__110695 = function(n,coll){
switch(arguments.length){
case 1:
return G__110695__1.call(this,n);
case 2:
return G__110695__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__110695.cljs$core$IFn$_invoke$arity$1 = G__110695__1;
G__110695.cljs$core$IFn$_invoke$arity$2 = G__110695__2;
return G__110695;
})()
,(function (coll){
return cljs.core.count(cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll));
}),avg,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__110696 = null;
var G__110696__1 = (function (coll){
return cljs.core.rand_nth(coll);
});
var G__110696__2 = (function (n,coll){
return cljs.core.vec(cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2(n,(function (){
return cljs.core.rand_nth(coll);
})));
});
G__110696 = function(n,coll){
switch(arguments.length){
case 1:
return G__110696__1.call(this,n);
case 2:
return G__110696__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__110696.cljs$core$IFn$_invoke$arity$1 = G__110696__1;
G__110696.cljs$core$IFn$_invoke$arity$2 = G__110696__2;
return G__110696;
})()
,(function (n,coll){
return cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.shuffle(coll)));
})]);
})();
fluree.db.query.analytical.aggregate_QMARK_ = (function fluree$db$query$analytical$aggregate_QMARK_(x){
if(typeof x === 'string'){
return cljs.core.re_matches(/^\(.+\)$/,x);
} else {
return false;
}
});
fluree.db.query.analytical.interm_aggregate_QMARK_ = (function fluree$db$query$analytical$interm_aggregate_QMARK_(x){
if(typeof x === 'string'){
return cljs.core.re_matches(/^#\(.+\)$/,x);
} else {
return false;
}
});
fluree.db.query.analytical.parse_aggregate = (function fluree$db$query$analytical$parse_aggregate(x,valid_var){
var list_agg = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(x);
var as_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$as,cljs.core.first(list_agg));
var as = ((as_QMARK_)?cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last(list_agg))].join('')):cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(list_agg)].join('')));
var func_list = ((as_QMARK_)?(function (){var func_list = cljs.core.second(list_agg);
if(cljs.core.coll_QMARK_(func_list)){
return func_list;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})():list_agg);
var list_count = cljs.core.count(func_list);
var vec__110697 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),cljs.core.second(func_list),cljs.core.last(func_list)], null):((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$sample,cljs.core.first(func_list)))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),null,cljs.core.last(func_list)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})()
)));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__110697,(0),null);
var arg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__110697,(1),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__110697,(2),null);
var agg_fn = (function (){var temp__5733__auto__ = (fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1(fun) : fluree.db.query.analytical.built_in_aggregates.call(null,fun));
if(cljs.core.truth_(temp__5733__auto__)){
var agg_fn = temp__5733__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return (agg_fn.cljs$core$IFn$_invoke$arity$2 ? agg_fn.cljs$core$IFn$_invoke$arity$2(arg,coll) : agg_fn.call(null,arg,coll));
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection function, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var vec__110700 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_(var$)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(var$),cljs.core.cst$sym$distinct)));
var variable = ((distinct_QMARK_)?cljs.core.second(var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
var G__110703 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll);
return (agg_fn.cljs$core$IFn$_invoke$arity$1 ? agg_fn.cljs$core$IFn$_invoke$arity$1(G__110703) : agg_fn.call(null,G__110703));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__110700,(0),null);
var variable = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__110700,(1),null);
var _ = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(variable) : valid_var.call(null,variable)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$variable,variable,cljs.core.cst$kw$as,as,cljs.core.cst$kw$code,agg_fn__$1], null);
});
fluree.db.query.analytical.calculate_aggregate = (function fluree$db$query$analytical$calculate_aggregate(res,agg){
var map__110704 = agg;
var map__110704__$1 = (((((!((map__110704 == null))))?(((((map__110704.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__110704.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__110704):map__110704);
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__110704__$1,cljs.core.cst$kw$variable);
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__110704__$1,cljs.core.cst$kw$as);
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__110704__$1,cljs.core.cst$kw$code);
var agg_params = cljs.core.flatten(fluree.db.query.analytical.select_from_tuples(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [variable], null),res));
var agg_result = (code.cljs$core$IFn$_invoke$arity$1 ? code.cljs$core$IFn$_invoke$arity$1(agg_params) : code.call(null,agg_params));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [as,agg_result], null);
});
fluree.db.query.analytical.add_aggregate_cols = (function fluree$db$query$analytical$add_aggregate_cols(res,aggregate){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,agg){
var vec__110707 = fluree.db.query.analytical.calculate_aggregate(res__$1,agg);
var as = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__110707,(0),null);
var agg_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__110707,(1),null);
var map__110710 = res__$1;
var map__110710__$1 = (((((!((map__110710 == null))))?(((((map__110710.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__110710.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__110710):map__110710);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__110710__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__110710__$1,cljs.core.cst$kw$tuples);
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__110706_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(p1__110706_SHARP_),agg_result);
}),tuples);
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(headers),as);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$headers,headers_SINGLEQUOTE_,cljs.core.cst$kw$tuples,tuples_SINGLEQUOTE_], null);
}),res,aggregate);
});
fluree.db.query.analytical.symbolize_keys = (function fluree$db$query$analytical$symbolize_keys(q_map){
var keys = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,cljs.core.keys(q_map));
var vals = cljs.core.vals(q_map);
return cljs.core.zipmap(keys,vals);
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 */
fluree.db.query.analytical.find_match = (function fluree$db$query$analytical$find_match(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__110712_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__110712_SHARP_);
}),a_idxs);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,b_tuple){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a_tuple_part,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__110713_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__110713_SHARP_);
}),b_idxs))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__4126__auto__ = acc;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__110714_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__110714_SHARP_);
}),b_not_idxs)));
} else {
return acc;
}
}),null,b_tuples);
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.analytical.find_match_PLUS_row_nums = (function fluree$db$query$analytical$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__110715_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__110715_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv((function (p__110718,row,b_tuple){
var vec__110719 = p__110718;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__110719,(0),null);
var b_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__110719,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a_tuple_part,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__110716_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__110716_SHARP_);
}),b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__4126__auto__ = acc;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__110717_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__110717_SHARP_);
}),b_not_idxs))),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,b_tuples));
});
fluree.db.query.analytical.inner_join = (function fluree$db$query$analytical$inner_join(a_res,b_res){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_res,b_res);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__110722_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_res),p1__110722_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__110723_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_res),p1__110723_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__110728 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__110730 = cljs.core.count(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_res));
var fexpr__110729 = (function (p1__110724_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__110724_SHARP_);
});
return fexpr__110729(G__110730);
})()),cljs.core.set(b_idxs));
var fexpr__110727 = (function (p1__110725_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__110725_SHARP_);
});
return fexpr__110727(G__110728);
})();
var c_tuples = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (a_tuple){
return fluree.db.query.analytical.find_match(a_tuple,a_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_res),b_idxs,b_not_idxs);
}),cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(a_res)));
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__110726_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_res),p1__110726_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,c_headers,cljs.core.cst$kw$vars,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(b_res)], 0)),cljs.core.cst$kw$tuples,c_tuples], null);
});
/**
 * OPTIONAL clause is equivalent to a left outer join. If there are no matches in the b-tuples,
 *   we just return a 'match' where each element of the match from b-tuple is nil.
 */
fluree.db.query.analytical.left_outer_join = (function fluree$db$query$analytical$left_outer_join(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_tuples,b_tuples);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__110731_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),p1__110731_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__110732_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__110732_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__110737 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__110739 = cljs.core.count(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples));
var fexpr__110738 = (function (p1__110733_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__110733_SHARP_);
});
return fexpr__110738(G__110739);
})()),cljs.core.set(b_idxs));
var fexpr__110736 = (function (p1__110734_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__110734_SHARP_);
});
return fexpr__110736(G__110737);
})();
var c_tuples = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (a_tuple){
var matches = fluree.db.query.analytical.find_match(a_tuple,a_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples),b_idxs,b_not_idxs);
var or__4126__auto__ = matches;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.count(b_not_idxs),null))], null);
}
}),cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(a_tuples)));
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__110735_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__110735_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,c_headers,cljs.core.cst$kw$vars,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(b_tuples)], 0)),cljs.core.cst$kw$tuples,c_tuples], null);
});
/**
 * UNION clause takes a left-hand side, which is inner-joined, and a right-hand side, which is inner-joined.
 *   Any tuples unbound by the other set are included.
 */
fluree.db.query.analytical.outer_union = (function fluree$db$query$analytical$outer_union(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_tuples,b_tuples);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__110740_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),p1__110740_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__110741_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__110741_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__110750 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__110752 = cljs.core.count(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples));
var fexpr__110751 = (function (p1__110742_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__110742_SHARP_);
});
return fexpr__110751(G__110752);
})()),cljs.core.set(b_idxs));
var fexpr__110749 = (function (p1__110743_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__110743_SHARP_);
});
return fexpr__110749(G__110750);
})();
var vec__110746 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__110753,a_tuple){
var vec__110754 = p__110753;
var c_tuples = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__110754,(0),null);
var b_matched_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__110754,(1),null);
var vec__110757 = fluree.db.query.analytical.find_match_PLUS_row_nums(a_tuple,a_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples),b_idxs,b_not_idxs);
var matches = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__110757,(0),null);
var matched_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__110757,(1),null);
var matches__$1 = (function (){var or__4126__auto__ = matches;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.count(b_not_idxs),null))], null);
}
})();
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.cljs$core$IFn$_invoke$arity$2(c_tuples,matches__$1),clojure.set.union.cljs$core$IFn$_invoke$arity$2(b_matched_rows,matched_rows)], null);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(a_tuples));
var c_tuples = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__110746,(0),null);
var b_matched_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__110746,(1),null);
var b_unmatched_rows = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(b_matched_rows,cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),cljs.core.count(cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples))));
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__110744_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__110744_SHARP_);
}),b_not_idxs));
var b_idxs__GT_c_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__110745_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__110745_SHARP_);
}),c_headers);
var c_from_unmatched_b_tuples = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (b_row){
var b_tuple = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples),b_row));
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (c_idx){
if((c_idx == null)){
return null;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(b_tuple,c_idx);
}
}),b_idxs__GT_c_idxs);
}),b_unmatched_rows);
var c_tuples__$1 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(c_tuples,c_from_unmatched_b_tuples);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,c_headers,cljs.core.cst$kw$vars,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(b_tuples)], 0)),cljs.core.cst$kw$tuples,c_tuples__$1], null);
});
fluree.db.query.analytical.tuples__GT_filter_required = (function fluree$db$query$analytical$tuples__GT_filter_required(headers,tuples,valid_vars,filter_code_req){
var filter_code_req_str = ["(and ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",filter_code_req),")"].join('');
var vec__110761 = (function (){var or__4126__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code_req_str,valid_vars);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid required filters, provided: ",filter_code_req_str].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var filter_code_req_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__110761,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__110761,(1),null);
var filter_code_req_str_STAR_ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_code_req_STAR_);
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__110760_SHARP_){
return fluree.db.query.analytical_filter.filter_row(headers,p1__110760_SHARP_,filter_code_req_str_STAR_);
}),tuples);
});
fluree.db.query.analytical.tuples__GT_filter_optional = (function fluree$db$query$analytical$tuples__GT_filter_optional(headers,tuples,valid_vars,filter_code_opts){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (tuples__$1,filt){
var var_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY);
var vec__110766 = (function (){var or__4126__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$3(filt,valid_vars,var_atom);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid filter, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var filt_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__110766,(0),null);
var filt_vars = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__110766,(1),null);
var filt_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt_STAR_);
var filt_vars_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__110764_SHARP_){
return fluree.db.util.core.index_of(headers,p1__110764_SHARP_);
}),cljs.core.deref(filt_vars));
var filtered_tuples = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,clause){
if(cljs.core.every_QMARK_((function (p1__110765_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,p1__110765_SHARP_);
}),filt_vars_idxs)){
if(cljs.core.truth_(fluree.db.query.analytical_filter.filter_row(headers,clause,filt_str))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
} else {
return acc;
}
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
}
}),cljs.core.PersistentVector.EMPTY,tuples__$1);
return filtered_tuples;
}),tuples,filter_code_opts);
});
fluree.db.query.analytical.tuples__GT_filtered = (function fluree$db$query$analytical$tuples__GT_filtered(p__110769,filters,optional_QMARK_){
var map__110770 = p__110769;
var map__110770__$1 = (((((!((map__110770 == null))))?(((((map__110770.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__110770.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__110770):map__110770);
var tuple_map = map__110770__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__110770__$1,cljs.core.cst$kw$headers);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__110770__$1,cljs.core.cst$kw$vars);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__110770__$1,cljs.core.cst$kw$tuples);
var valid_vars = cljs.core.set(headers);
var header_vec = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,headers);
var _ = ((typeof filters === 'string')?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter must be enclosed in square brackets. Provided: ",filters].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():null);
if(cljs.core.truth_(optional_QMARK_)){
var res = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$vars,vars,cljs.core.cst$kw$tuples,fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples,valid_vars,filters)], null);
return res;
} else {
var filter_code_req = fluree.db.query.analytical_filter.get_filters(filters,false);
var tuples__$1 = (cljs.core.truth_(cljs.core.not_empty(filter_code_req))?fluree.db.query.analytical.tuples__GT_filter_required(header_vec,tuples,valid_vars,filter_code_req):tuples);
var filter_code_opt = fluree.db.query.analytical_filter.get_filters(filters,true);
var tuples__$2 = (cljs.core.truth_(cljs.core.not_empty(filter_code_opt))?fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples__$1,valid_vars,filter_code_opt):tuples__$1);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$vars,vars,cljs.core.cst$kw$tuples,tuples__$2], null);
}
});
fluree.db.query.analytical.bind_clause__GT_vars = (function fluree$db$query$analytical$bind_clause__GT_vars(res,clause){
var vec__110772 = clause;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__110772,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__110772,(1),null);
var k__$1 = fluree.db.query.analytical.variable_QMARK_(k);
var _ = (cljs.core.truth_(k__$1)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid intermediate aggregate value. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
var map__110775 = res;
var map__110775__$1 = (((((!((map__110775 == null))))?(((((map__110775.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__110775.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__110775):map__110775);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__110775__$1,cljs.core.cst$kw$headers);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__110775__$1,cljs.core.cst$kw$vars);
var var_value = (cljs.core.truth_(fluree.db.query.analytical.interm_aggregate_QMARK_(v))?cljs.core.second(fluree.db.query.analytical.calculate_aggregate(res,fluree.db.query.analytical.parse_aggregate(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(v,(1)),cljs.core.set((function (){var temp__5733__auto__ = cljs.core.keys(vars);
if(cljs.core.truth_(temp__5733__auto__)){
var valid_var = temp__5733__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(headers,valid_var);
} else {
return headers;
}
})())))):v);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k__$1,var_value]);
});
fluree.db.query.analytical.optional__GT_left_outer_joins = (function fluree$db$query$analytical$optional__GT_left_outer_joins(db,q_map,optional_clauses,where_tuples,fuel,max_fuel,opts){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_110830){
var state_val_110831 = (state_110830[(1)]);
if((state_val_110831 === (7))){
var inst_110804 = (state_110830[(7)]);
var inst_110802 = (state_110830[(2)]);
var inst_110803 = fluree.db.util.async.throw_err(inst_110802);
var inst_110804__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_110803,(0),null);
var inst_110805 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_110803,(1),null);
var inst_110806 = (inst_110804__$1 == null);
var state_110830__$1 = (function (){var statearr_110832 = state_110830;
(statearr_110832[(8)] = inst_110805);

(statearr_110832[(7)] = inst_110804__$1);

return statearr_110832;
})();
if(cljs.core.truth_(inst_110806)){
var statearr_110833_110861 = state_110830__$1;
(statearr_110833_110861[(1)] = (8));

} else {
var statearr_110834_110862 = state_110830__$1;
(statearr_110834_110862[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110831 === (1))){
var inst_110784 = cljs.core.seq(optional_clauses);
var inst_110785 = cljs.core.first(inst_110784);
var inst_110786 = cljs.core.next(inst_110784);
var inst_110787 = optional_clauses;
var inst_110788 = where_tuples;
var state_110830__$1 = (function (){var statearr_110835 = state_110830;
(statearr_110835[(9)] = inst_110786);

(statearr_110835[(10)] = inst_110785);

(statearr_110835[(11)] = inst_110788);

(statearr_110835[(12)] = inst_110787);

return statearr_110835;
})();
var statearr_110836_110863 = state_110830__$1;
(statearr_110836_110863[(2)] = null);

(statearr_110836_110863[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110831 === (4))){
var inst_110794 = (state_110830[(13)]);
var inst_110788 = (state_110830[(11)]);
var inst_110795 = (state_110830[(14)]);
var inst_110800 = (fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9 ? fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9(db,q_map,inst_110788,inst_110794,inst_110795,true,fuel,max_fuel,opts) : fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_110788,inst_110794,inst_110795,true,fuel,max_fuel,opts));
var state_110830__$1 = state_110830;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_110830__$1,(7),inst_110800);
} else {
if((state_val_110831 === (15))){
var state_110830__$1 = state_110830;
var statearr_110837_110864 = state_110830__$1;
(statearr_110837_110864[(2)] = null);

(statearr_110837_110864[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110831 === (13))){
var inst_110821 = (state_110830[(2)]);
var state_110830__$1 = state_110830;
var statearr_110838_110865 = state_110830__$1;
(statearr_110838_110865[(2)] = inst_110821);

(statearr_110838_110865[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110831 === (6))){
var inst_110826 = (state_110830[(2)]);
var state_110830__$1 = state_110830;
var statearr_110839_110866 = state_110830__$1;
(statearr_110839_110866[(2)] = inst_110826);

(statearr_110839_110866[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110831 === (3))){
var inst_110828 = (state_110830[(2)]);
var state_110830__$1 = state_110830;
return cljs.core.async.impl.ioc_helpers.return_chan(state_110830__$1,inst_110828);
} else {
if((state_val_110831 === (12))){
var state_110830__$1 = state_110830;
var statearr_110840_110867 = state_110830__$1;
(statearr_110840_110867[(1)] = (14));



return cljs.core.cst$kw$recur;
} else {
if((state_val_110831 === (2))){
var inst_110794 = (state_110830[(13)]);
var inst_110787 = (state_110830[(12)]);
var inst_110793 = cljs.core.seq(inst_110787);
var inst_110794__$1 = cljs.core.first(inst_110793);
var inst_110795 = cljs.core.next(inst_110793);
var state_110830__$1 = (function (){var statearr_110842 = state_110830;
(statearr_110842[(13)] = inst_110794__$1);

(statearr_110842[(14)] = inst_110795);

return statearr_110842;
})();
if(cljs.core.truth_(inst_110794__$1)){
var statearr_110843_110868 = state_110830__$1;
(statearr_110843_110868[(1)] = (4));

} else {
var statearr_110844_110869 = state_110830__$1;
(statearr_110844_110869[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110831 === (11))){
var inst_110805 = (state_110830[(8)]);
var inst_110804 = (state_110830[(7)]);
var inst_110787 = inst_110805;
var inst_110788 = inst_110804;
var state_110830__$1 = (function (){var statearr_110845 = state_110830;
(statearr_110845[(11)] = inst_110788);

(statearr_110845[(12)] = inst_110787);

return statearr_110845;
})();
var statearr_110846_110870 = state_110830__$1;
(statearr_110846_110870[(2)] = null);

(statearr_110846_110870[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110831 === (9))){
var inst_110794 = (state_110830[(13)]);
var inst_110810 = cljs.core.cst$kw$filter.cljs$core$IFn$_invoke$arity$1(inst_110794);
var state_110830__$1 = state_110830;
if(cljs.core.truth_(inst_110810)){
var statearr_110847_110871 = state_110830__$1;
(statearr_110847_110871[(1)] = (11));

} else {
var statearr_110848_110872 = state_110830__$1;
(statearr_110848_110872[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110831 === (5))){
var inst_110788 = (state_110830[(11)]);
var state_110830__$1 = state_110830;
var statearr_110849_110873 = state_110830__$1;
(statearr_110849_110873[(2)] = inst_110788);

(statearr_110849_110873[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110831 === (14))){
var inst_110805 = (state_110830[(8)]);
var inst_110788 = (state_110830[(11)]);
var inst_110804 = (state_110830[(7)]);
var inst_110815 = fluree.db.query.analytical.left_outer_join(inst_110788,inst_110804);
var inst_110787 = inst_110805;
var inst_110788__$1 = inst_110815;
var state_110830__$1 = (function (){var statearr_110850 = state_110830;
(statearr_110850[(11)] = inst_110788__$1);

(statearr_110850[(12)] = inst_110787);

return statearr_110850;
})();
var statearr_110851_110874 = state_110830__$1;
(statearr_110851_110874[(2)] = null);

(statearr_110851_110874[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110831 === (16))){
var inst_110819 = (state_110830[(2)]);
var state_110830__$1 = state_110830;
var statearr_110853_110875 = state_110830__$1;
(statearr_110853_110875[(2)] = inst_110819);

(statearr_110853_110875[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110831 === (10))){
var inst_110823 = (state_110830[(2)]);
var state_110830__$1 = state_110830;
var statearr_110854_110876 = state_110830__$1;
(statearr_110854_110876[(2)] = inst_110823);

(statearr_110854_110876[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110831 === (8))){
var inst_110805 = (state_110830[(8)]);
var inst_110788 = (state_110830[(11)]);
var tmp110852 = inst_110788;
var inst_110787 = inst_110805;
var inst_110788__$1 = tmp110852;
var state_110830__$1 = (function (){var statearr_110855 = state_110830;
(statearr_110855[(11)] = inst_110788__$1);

(statearr_110855[(12)] = inst_110787);

return statearr_110855;
})();
var statearr_110856_110877 = state_110830__$1;
(statearr_110856_110877[(2)] = null);

(statearr_110856_110877[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__100742__auto__ = null;
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__100742__auto____0 = (function (){
var statearr_110857 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_110857[(0)] = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__100742__auto__);

(statearr_110857[(1)] = (1));

return statearr_110857;
});
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__100742__auto____1 = (function (state_110830){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_110830);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e110858){if((e110858 instanceof Object)){
var ex__100745__auto__ = e110858;
var statearr_110859_110878 = state_110830;
(statearr_110859_110878[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_110830);

return cljs.core.cst$kw$recur;
} else {
throw e110858;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__110879 = state_110830;
state_110830 = G__110879;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__100742__auto__ = function(state_110830){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__100742__auto____1.call(this,state_110830);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__100742__auto____0;
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__100742__auto____1;
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_110860 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_110860[(6)] = c__100848__auto__);

return statearr_110860;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
fluree.db.query.analytical.res_absorb_vars = (function fluree$db$query$analytical$res_absorb_vars(res){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__110881){
var vec__110882 = p__110881;
var var_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__110882,(0),null);
var var_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__110882,(1),null);
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__110880_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__110880_SHARP_,var_val);
}),cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(res));
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(res),var_name);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tuples,tuples_SINGLEQUOTE_,cljs.core.cst$kw$headers,headers_SINGLEQUOTE_], null);
}),res,cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(res));
});
/**
 * Tuples and optional? are only used for Wikidata, because need to both limit calls to Wikidata,
 *   and ensure that returned results are as limited as possible (but still relevant).
 */
fluree.db.query.analytical.clause__GT_tuples = (function fluree$db$query$analytical$clause__GT_tuples(db,p__110886,p__110887,clause,r,optional_QMARK_,fuel,max_fuel,opts){
var map__110888 = p__110886;
var map__110888__$1 = (((((!((map__110888 == null))))?(((((map__110888.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__110888.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__110888):map__110888);
var q_map = map__110888__$1;
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__110888__$1,cljs.core.cst$kw$prefixes);
var map__110889 = p__110887;
var map__110889__$1 = (((((!((map__110889 == null))))?(((((map__110889.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__110889.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__110889):map__110889);
var res = map__110889__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__110889__$1,cljs.core.cst$kw$vars);
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_111094){
var state_val_111095 = (state_111094[(1)]);
if((state_val_111095 === (7))){
var inst_111090 = (state_111094[(2)]);
var state_111094__$1 = state_111094;
var statearr_111096_111176 = state_111094__$1;
(statearr_111096_111176[(2)] = inst_111090);


cljs.core.async.impl.ioc_helpers.process_exception(state_111094__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_111095 === (20))){
var inst_110899 = (state_111094[(7)]);
var inst_110935 = (state_111094[(8)]);
var inst_110934 = (state_111094[(9)]);
var inst_110926 = (state_111094[(10)]);
var inst_110927 = (state_111094[(11)]);
var inst_110928 = (state_111094[(12)]);
var inst_110923 = (state_111094[(13)]);
var inst_110925 = (state_111094[(14)]);
var inst_110939 = (state_111094[(2)]);
var inst_110940 = fluree.db.util.async.throw_err(inst_110939);
var inst_110941 = (function (){var seq__110931 = inst_110935;
var G__110919 = inst_110927;
var new_res = inst_110940;
var rest = inst_110935;
var tuples = inst_110928;
var first__110932 = inst_110934;
var seq__110921 = inst_110926;
var vec__110920 = inst_110923;
var expr__110901 = inst_110899;
var first__110922 = inst_110925;
var segment_type = inst_110899;
var vec__110930 = inst_110927;
var pred__110900 = cljs.core._EQ_;
var clause_group = inst_110934;
return (function (res__$1,var$){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(new_res,cljs.core.cst$kw$var,cljs.core.dissoc,var$);
});
})();
var inst_110942 = cljs.core.keys(vars);
var inst_110943 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_110941,inst_110940,inst_110942);
var inst_110944 = fluree.db.query.analytical.res_absorb_vars(inst_110943);
var state_111094__$1 = (function (){var statearr_111097 = state_111094;
(statearr_111097[(15)] = inst_110944);

return statearr_111097;
})();
if(cljs.core.truth_(inst_110928)){
var statearr_111098_111177 = state_111094__$1;
(statearr_111098_111177[(1)] = (21));

} else {
var statearr_111099_111178 = state_111094__$1;
(statearr_111099_111178[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111095 === (58))){
var inst_111064 = (state_111094[(16)]);
var inst_111067 = (state_111094[(2)]);
var inst_111068 = fluree.db.util.async.throw_err(inst_111067);
var inst_111069 = [inst_111068,r];
var inst_111070 = (new cljs.core.PersistentVector(null,2,(5),inst_111064,inst_111069,null));
var state_111094__$1 = state_111094;
var statearr_111100_111179 = state_111094__$1;
(statearr_111100_111179[(2)] = inst_111070);

(statearr_111100_111179[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111095 === (27))){
var inst_110975 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_110976 = cljs.core.cst$kw$filter.cljs$core$IFn$_invoke$arity$1(clause);
var inst_110977 = fluree.db.query.analytical.tuples__GT_filtered(res,inst_110976,optional_QMARK_);
var inst_110978 = [inst_110977,r];
var inst_110979 = (new cljs.core.PersistentVector(null,2,(5),inst_110975,inst_110978,null));
var state_111094__$1 = state_111094;
var statearr_111101_111180 = state_111094__$1;
(statearr_111101_111180[(2)] = inst_110979);

(statearr_111101_111180[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111095 === (1))){
var state_111094__$1 = state_111094;
var statearr_111102_111181 = state_111094__$1;
(statearr_111102_111181[(2)] = null);

(statearr_111102_111181[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111095 === (24))){
var inst_110899 = (state_111094[(7)]);
var inst_110963 = cljs.core.cst$kw$bind.cljs$core$IFn$_invoke$arity$1(clause);
var inst_110964 = (function (){var segment_type = inst_110899;
var pred__110900 = cljs.core._EQ_;
var expr__110901 = inst_110899;
var bindings = inst_110963;
return (function (p1__110885_SHARP_){
return fluree.db.query.analytical.bind_clause__GT_vars(res,p1__110885_SHARP_);
});
})();
var inst_110965 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_110964,inst_110963);
var inst_110966 = cljs.core.PersistentHashMap.EMPTY;
var inst_110967 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_110966,inst_110965);
var inst_110968 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_110969 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,cljs.core.cst$kw$vars,cljs.core.merge,inst_110967);
var inst_110970 = [inst_110969,r];
var inst_110971 = (new cljs.core.PersistentVector(null,2,(5),inst_110968,inst_110970,null));
var state_111094__$1 = state_111094;
var statearr_111103_111182 = state_111094__$1;
(statearr_111103_111182[(2)] = inst_110971);

(statearr_111103_111182[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111095 === (55))){
var inst_111047 = (state_111094[(17)]);
var inst_111046 = (state_111094[(18)]);
var inst_111064 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_111065 = fluree.db.query.analytical.fdb_clause__GT_tuples(inst_111046,res,inst_111047,fuel,max_fuel);
var state_111094__$1 = (function (){var statearr_111104 = state_111094;
(statearr_111104[(16)] = inst_111064);

return statearr_111104;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_111094__$1,(58),inst_111065);
} else {
if((state_val_111095 === (39))){
var inst_111084 = (state_111094[(2)]);
var state_111094__$1 = state_111094;
var statearr_111105_111183 = state_111094__$1;
(statearr_111105_111183[(2)] = inst_111084);

(statearr_111105_111183[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111095 === (46))){
var inst_111080 = (state_111094[(2)]);
var state_111094__$1 = state_111094;
var statearr_111106_111184 = state_111094__$1;
(statearr_111106_111184[(2)] = inst_111080);

(statearr_111106_111184[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111095 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_111094,(3),Error,null,(2));
var inst_110896 = cljs.core.map_QMARK_(clause);
var state_111094__$1 = state_111094;
if(inst_110896){
var statearr_111107_111185 = state_111094__$1;
(statearr_111107_111185[(1)] = (5));

} else {
var statearr_111108_111186 = state_111094__$1;
(statearr_111108_111186[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111095 === (54))){
var inst_111075 = (state_111094[(2)]);
var state_111094__$1 = state_111094;
var statearr_111109_111187 = state_111094__$1;
(statearr_111109_111187[(2)] = inst_111075);

(statearr_111109_111187[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111095 === (15))){
var inst_110934 = (state_111094[(9)]);
var inst_110927 = (state_111094[(11)]);
var inst_110933 = cljs.core.seq(inst_110927);
var inst_110934__$1 = cljs.core.first(inst_110933);
var inst_110935 = cljs.core.next(inst_110933);
var state_111094__$1 = (function (){var statearr_111110 = state_111094;
(statearr_111110[(8)] = inst_110935);

(statearr_111110[(9)] = inst_110934__$1);

return statearr_111110;
})();
if(cljs.core.truth_(inst_110934__$1)){
var statearr_111111_111188 = state_111094__$1;
(statearr_111111_111188[(1)] = (17));

} else {
var statearr_111112_111189 = state_111094__$1;
(statearr_111112_111189[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111095 === (48))){
var inst_111047 = (state_111094[(17)]);
var inst_111050 = fluree.db.query.analytical.wikidata__GT_tuples(q_map,inst_111047,r,res,optional_QMARK_,fuel,max_fuel);
var state_111094__$1 = state_111094;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_111094__$1,(51),inst_111050);
} else {
if((state_val_111095 === (50))){
var inst_111077 = (state_111094[(2)]);
var state_111094__$1 = state_111094;
var statearr_111113_111190 = state_111094__$1;
(statearr_111113_111190[(2)] = inst_111077);

(statearr_111113_111190[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111095 === (21))){
var inst_110935 = (state_111094[(8)]);
var inst_110928 = (state_111094[(12)]);
var inst_110944 = (state_111094[(15)]);
var inst_110946 = fluree.db.query.analytical.outer_union(inst_110928,inst_110944);
var inst_110927 = inst_110935;
var inst_110928__$1 = inst_110946;
var state_111094__$1 = (function (){var statearr_111114 = state_111094;
(statearr_111114[(11)] = inst_110927);

(statearr_111114[(12)] = inst_110928__$1);

return statearr_111114;
})();
var statearr_111115_111191 = state_111094__$1;
(statearr_111115_111191[(2)] = null);

(statearr_111115_111191[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111095 === (31))){
var inst_111004 = cljs.core.count(clause);
var inst_111005 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_111004);
var inst_111006 = cljs.core.second(clause);
var inst_111007 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_111006,"rdf:type");
var inst_111008 = ((inst_111005) && (inst_111007));
var state_111094__$1 = state_111094;
if(cljs.core.truth_(inst_111008)){
var statearr_111116_111192 = state_111094__$1;
(statearr_111116_111192[(1)] = (33));

} else {
var statearr_111117_111193 = state_111094__$1;
(statearr_111117_111193[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111095 === (32))){
var inst_111088 = (state_111094[(2)]);
var state_111094__$1 = state_111094;
var statearr_111118_111194 = state_111094__$1;
(statearr_111118_111194[(2)] = inst_111088);

(statearr_111118_111194[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111095 === (40))){
var inst_111021 = (state_111094[(19)]);
var inst_111024 = (state_111094[(2)]);
var inst_111025 = fluree.db.util.async.throw_err(inst_111024);
var inst_111026 = [inst_111025,r];
var inst_111027 = (new cljs.core.PersistentVector(null,2,(5),inst_111021,inst_111026,null));
var state_111094__$1 = state_111094;
var statearr_111119_111195 = state_111094__$1;
(statearr_111119_111195[(2)] = inst_111027);

(statearr_111119_111195[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111095 === (56))){
var state_111094__$1 = state_111094;
var statearr_111120_111196 = state_111094__$1;
(statearr_111120_111196[(2)] = null);

(statearr_111120_111196[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111095 === (33))){
var inst_111010 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_111011 = fluree.db.query.analytical.collection__GT_tuples(db,res,clause);
var state_111094__$1 = (function (){var statearr_111121 = state_111094;
(statearr_111121[(20)] = inst_111010);

return statearr_111121;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_111094__$1,(36),inst_111011);
} else {
if((state_val_111095 === (13))){
var inst_110899 = (state_111094[(7)]);
var inst_110961 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$bind,inst_110899);
var state_111094__$1 = state_111094;
if(inst_110961){
var statearr_111122_111197 = state_111094__$1;
(statearr_111122_111197[(1)] = (24));

} else {
var statearr_111123_111198 = state_111094__$1;
(statearr_111123_111198[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111095 === (22))){
var inst_110935 = (state_111094[(8)]);
var inst_110944 = (state_111094[(15)]);
var inst_110927 = inst_110935;
var inst_110928 = inst_110944;
var state_111094__$1 = (function (){var statearr_111124 = state_111094;
(statearr_111124[(11)] = inst_110927);

(statearr_111124[(12)] = inst_110928);

return statearr_111124;
})();
var statearr_111125_111199 = state_111094__$1;
(statearr_111125_111199[(2)] = null);

(statearr_111125_111199[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111095 === (36))){
var inst_111010 = (state_111094[(20)]);
var inst_111013 = (state_111094[(2)]);
var inst_111014 = fluree.db.util.async.throw_err(inst_111013);
var inst_111015 = [inst_111014,r];
var inst_111016 = (new cljs.core.PersistentVector(null,2,(5),inst_111010,inst_111015,null));
var state_111094__$1 = state_111094;
var statearr_111126_111200 = state_111094__$1;
(statearr_111126_111200[(2)] = inst_111016);

(statearr_111126_111200[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111095 === (41))){
var inst_111032 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_111033 = fluree.db.query.analytical.bind_clause__GT_vars(res,clause);
var inst_111034 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,cljs.core.cst$kw$vars,cljs.core.merge,inst_111033);
var inst_111035 = [inst_111034,r];
var inst_111036 = (new cljs.core.PersistentVector(null,2,(5),inst_111032,inst_111035,null));
var state_111094__$1 = state_111094;
var statearr_111127_111201 = state_111094__$1;
(statearr_111127_111201[(2)] = inst_111036);

(statearr_111127_111201[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111095 === (43))){
var inst_111082 = (state_111094[(2)]);
var state_111094__$1 = state_111094;
var statearr_111128_111202 = state_111094__$1;
(statearr_111128_111202[(2)] = inst_111082);

(statearr_111128_111202[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111095 === (29))){
var inst_110985 = (state_111094[(2)]);
var state_111094__$1 = state_111094;
var statearr_111129_111203 = state_111094__$1;
(statearr_111129_111203[(2)] = inst_110985);

(statearr_111129_111203[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111095 === (44))){
var inst_111042 = fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,prefixes,opts);
var state_111094__$1 = state_111094;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_111094__$1,(47),inst_111042);
} else {
if((state_val_111095 === (6))){
var inst_110993 = cljs.core.count(clause);
var inst_110994 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_110993);
var inst_110995 = cljs.core.second(clause);
var inst_110996 = clojure.string.starts_with_QMARK_(inst_110995,"fullText:");
var inst_110997 = ((inst_110994) && (inst_110996));
var state_111094__$1 = state_111094;
if(cljs.core.truth_(inst_110997)){
var statearr_111130_111204 = state_111094__$1;
(statearr_111130_111204[(1)] = (30));

} else {
var statearr_111131_111205 = state_111094__$1;
(statearr_111131_111205[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111095 === (28))){
var inst_110899 = (state_111094[(7)]);
var inst_110981 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_110899)].join('');
var inst_110982 = (new Error(inst_110981));
var inst_110983 = (function(){throw inst_110982})();
var state_111094__$1 = state_111094;
var statearr_111132_111206 = state_111094__$1;
(statearr_111132_111206[(2)] = inst_110983);

(statearr_111132_111206[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111095 === (51))){
var inst_111052 = (state_111094[(2)]);
var inst_111053 = fluree.db.util.async.throw_err(inst_111052);
var state_111094__$1 = state_111094;
var statearr_111133_111207 = state_111094__$1;
(statearr_111133_111207[(2)] = inst_111053);

(statearr_111133_111207[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111095 === (25))){
var inst_110899 = (state_111094[(7)]);
var inst_110973 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$filter,inst_110899);
var state_111094__$1 = state_111094;
if(inst_110973){
var statearr_111134_111208 = state_111094__$1;
(statearr_111134_111208[(1)] = (27));

} else {
var statearr_111135_111209 = state_111094__$1;
(statearr_111135_111209[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111095 === (34))){
var inst_111018 = cljs.core.count(clause);
var inst_111019 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_111018);
var state_111094__$1 = state_111094;
if(inst_111019){
var statearr_111136_111210 = state_111094__$1;
(statearr_111136_111210[(1)] = (37));

} else {
var statearr_111137_111211 = state_111094__$1;
(statearr_111137_111211[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111095 === (17))){
var inst_110934 = (state_111094[(9)]);
var inst_110937 = (fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 ? fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_110934,q_map,vars,fuel,max_fuel,opts) : fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_110934,q_map,vars,fuel,max_fuel,opts));
var state_111094__$1 = state_111094;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_111094__$1,(20),inst_110937);
} else {
if((state_val_111095 === (3))){
var inst_110892 = (state_111094[(2)]);
var state_111094__$1 = state_111094;
var statearr_111138_111212 = state_111094__$1;
(statearr_111138_111212[(2)] = inst_110892);


cljs.core.async.impl.ioc_helpers.process_exception(state_111094__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_111095 === (12))){
var inst_110923 = (state_111094[(13)]);
var inst_110923__$1 = cljs.core.cst$kw$union.cljs$core$IFn$_invoke$arity$1(clause);
var inst_110924 = cljs.core.seq(inst_110923__$1);
var inst_110925 = cljs.core.first(inst_110924);
var inst_110926 = cljs.core.next(inst_110924);
var inst_110927 = inst_110923__$1;
var inst_110928 = null;
var state_111094__$1 = (function (){var statearr_111139 = state_111094;
(statearr_111139[(10)] = inst_110926);

(statearr_111139[(11)] = inst_110927);

(statearr_111139[(12)] = inst_110928);

(statearr_111139[(13)] = inst_110923__$1);

(statearr_111139[(14)] = inst_110925);

return statearr_111139;
})();
var statearr_111140_111213 = state_111094__$1;
(statearr_111140_111213[(2)] = null);

(statearr_111140_111213[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111095 === (2))){
var inst_111092 = (state_111094[(2)]);
var state_111094__$1 = state_111094;
return cljs.core.async.impl.ioc_helpers.return_chan(state_111094__$1,inst_111092);
} else {
if((state_val_111095 === (23))){
var inst_110951 = (state_111094[(2)]);
var state_111094__$1 = state_111094;
var statearr_111141_111214 = state_111094__$1;
(statearr_111141_111214[(2)] = inst_110951);

(statearr_111141_111214[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111095 === (47))){
var inst_111046 = (state_111094[(18)]);
var inst_111044 = (state_111094[(2)]);
var inst_111045 = fluree.db.util.async.throw_err(inst_111044);
var inst_111046__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_111045,(0),null);
var inst_111047 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_111045,(1),null);
var inst_111048 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_111046__$1);
var state_111094__$1 = (function (){var statearr_111142 = state_111094;
(statearr_111142[(17)] = inst_111047);

(statearr_111142[(18)] = inst_111046__$1);

return statearr_111142;
})();
if(inst_111048){
var statearr_111143_111215 = state_111094__$1;
(statearr_111143_111215[(1)] = (48));

} else {
var statearr_111144_111216 = state_111094__$1;
(statearr_111144_111216[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111095 === (35))){
var inst_111086 = (state_111094[(2)]);
var state_111094__$1 = state_111094;
var statearr_111145_111217 = state_111094__$1;
(statearr_111145_111217[(2)] = inst_111086);

(statearr_111145_111217[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111095 === (19))){
var inst_110957 = (state_111094[(2)]);
var state_111094__$1 = state_111094;
var statearr_111146_111218 = state_111094__$1;
(statearr_111146_111218[(2)] = inst_110957);

(statearr_111146_111218[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111095 === (57))){
var inst_111073 = (state_111094[(2)]);
var state_111094__$1 = state_111094;
var statearr_111147_111219 = state_111094__$1;
(statearr_111147_111219[(2)] = inst_111073);

(statearr_111147_111219[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111095 === (11))){
var inst_110905 = (state_111094[(21)]);
var inst_110909 = (state_111094[(2)]);
var inst_110910 = fluree.db.util.async.throw_err(inst_110909);
var inst_110911 = [inst_110910,r];
var inst_110912 = (new cljs.core.PersistentVector(null,2,(5),inst_110905,inst_110911,null));
var state_111094__$1 = state_111094;
var statearr_111148_111220 = state_111094__$1;
(statearr_111148_111220[(2)] = inst_110912);

(statearr_111148_111220[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111095 === (9))){
var inst_110899 = (state_111094[(7)]);
var inst_110914 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$union,inst_110899);
var state_111094__$1 = state_111094;
if(inst_110914){
var statearr_111149_111221 = state_111094__$1;
(statearr_111149_111221[(1)] = (12));

} else {
var statearr_111150_111222 = state_111094__$1;
(statearr_111150_111222[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111095 === (5))){
var inst_110899 = (state_111094[(7)]);
var inst_110898 = cljs.core.keys(clause);
var inst_110899__$1 = cljs.core.first(inst_110898);
var inst_110903 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$optional,inst_110899__$1);
var state_111094__$1 = (function (){var statearr_111151 = state_111094;
(statearr_111151[(7)] = inst_110899__$1);

return statearr_111151;
})();
if(inst_110903){
var statearr_111152_111223 = state_111094__$1;
(statearr_111152_111223[(1)] = (8));

} else {
var statearr_111153_111224 = state_111094__$1;
(statearr_111153_111224[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111095 === (14))){
var inst_110989 = (state_111094[(2)]);
var state_111094__$1 = state_111094;
var statearr_111154_111225 = state_111094__$1;
(statearr_111154_111225[(2)] = inst_110989);

(statearr_111154_111225[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111095 === (45))){
var state_111094__$1 = state_111094;
var statearr_111155_111226 = state_111094__$1;
(statearr_111155_111226[(2)] = null);

(statearr_111155_111226[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111095 === (53))){
var state_111094__$1 = state_111094;
var statearr_111156_111227 = state_111094__$1;
(statearr_111156_111227[(1)] = (55));



return cljs.core.cst$kw$recur;
} else {
if((state_val_111095 === (26))){
var inst_110987 = (state_111094[(2)]);
var state_111094__$1 = state_111094;
var statearr_111158_111228 = state_111094__$1;
(statearr_111158_111228[(2)] = inst_110987);

(statearr_111158_111228[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111095 === (16))){
var inst_110959 = (state_111094[(2)]);
var state_111094__$1 = state_111094;
var statearr_111159_111229 = state_111094__$1;
(statearr_111159_111229[(2)] = inst_110959);

(statearr_111159_111229[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111095 === (38))){
var inst_111029 = cljs.core.count(clause);
var inst_111030 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_111029);
var state_111094__$1 = state_111094;
if(inst_111030){
var statearr_111160_111230 = state_111094__$1;
(statearr_111160_111230[(1)] = (41));

} else {
var statearr_111161_111231 = state_111094__$1;
(statearr_111161_111231[(1)] = (42));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111095 === (30))){
var inst_110999 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_111000 = fluree.db.query.analytical.full_text__GT_tuples(db,res,clause);
var inst_111001 = [inst_111000,r];
var inst_111002 = (new cljs.core.PersistentVector(null,2,(5),inst_110999,inst_111001,null));
var state_111094__$1 = state_111094;
var statearr_111162_111232 = state_111094__$1;
(statearr_111162_111232[(2)] = inst_111002);

(statearr_111162_111232[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111095 === (10))){
var inst_110991 = (state_111094[(2)]);
var state_111094__$1 = state_111094;
var statearr_111163_111233 = state_111094__$1;
(statearr_111163_111233[(2)] = inst_110991);

(statearr_111163_111233[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111095 === (18))){
var inst_110928 = (state_111094[(12)]);
var inst_110953 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_110954 = [inst_110928,r];
var inst_110955 = (new cljs.core.PersistentVector(null,2,(5),inst_110953,inst_110954,null));
var state_111094__$1 = state_111094;
var statearr_111164_111234 = state_111094__$1;
(statearr_111164_111234[(2)] = inst_110955);

(statearr_111164_111234[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111095 === (52))){
var inst_111047 = (state_111094[(17)]);
var inst_111046 = (state_111094[(18)]);
var inst_111058 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_111059 = fluree.db.query.analytical.full_text__GT_tuples(inst_111046,res,inst_111047);
var inst_111060 = [inst_111059,r];
var inst_111061 = (new cljs.core.PersistentVector(null,2,(5),inst_111058,inst_111060,null));
var state_111094__$1 = state_111094;
var statearr_111165_111235 = state_111094__$1;
(statearr_111165_111235[(2)] = inst_111061);

(statearr_111165_111235[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111095 === (42))){
var state_111094__$1 = state_111094;
var statearr_111166_111236 = state_111094__$1;
(statearr_111166_111236[(1)] = (44));



return cljs.core.cst$kw$recur;
} else {
if((state_val_111095 === (37))){
var inst_111021 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_111022 = fluree.db.query.analytical.fdb_clause__GT_tuples(db,res,clause,fuel,max_fuel);
var state_111094__$1 = (function (){var statearr_111168 = state_111094;
(statearr_111168[(19)] = inst_111021);

return statearr_111168;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_111094__$1,(40),inst_111022);
} else {
if((state_val_111095 === (8))){
var inst_110905 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_110906 = cljs.core.cst$kw$optional.cljs$core$IFn$_invoke$arity$1(clause);
var inst_110907 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_110906,res,fuel,max_fuel,opts);
var state_111094__$1 = (function (){var statearr_111169 = state_111094;
(statearr_111169[(21)] = inst_110905);

return statearr_111169;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_111094__$1,(11),inst_110907);
} else {
if((state_val_111095 === (49))){
var inst_111047 = (state_111094[(17)]);
var inst_111055 = cljs.core.second(inst_111047);
var inst_111056 = clojure.string.starts_with_QMARK_(inst_111055,"fullText:");
var state_111094__$1 = state_111094;
if(inst_111056){
var statearr_111170_111237 = state_111094__$1;
(statearr_111170_111237[(1)] = (52));

} else {
var statearr_111171_111238 = state_111094__$1;
(statearr_111171_111238[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__100742__auto__ = null;
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__100742__auto____0 = (function (){
var statearr_111172 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_111172[(0)] = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__100742__auto__);

(statearr_111172[(1)] = (1));

return statearr_111172;
});
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__100742__auto____1 = (function (state_111094){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_111094);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e111173){if((e111173 instanceof Object)){
var ex__100745__auto__ = e111173;
var statearr_111174_111239 = state_111094;
(statearr_111174_111239[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_111094);

return cljs.core.cst$kw$recur;
} else {
throw e111173;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__111240 = state_111094;
state_111094 = G__111240;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__100742__auto__ = function(state_111094){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__100742__auto____1.call(this,state_111094);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__100742__auto____0;
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__100742__auto____1;
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_111175 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_111175[(6)] = c__100848__auto__);

return statearr_111175;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
fluree.db.query.analytical.resolve_where_clause = (function fluree$db$query$analytical$resolve_where_clause(var_args){
var G__111242 = arguments.length;
switch (G__111242) {
case 6:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6 = (function (db,where,q_map,vars,fuel,max_fuel){
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,where,q_map,vars,fuel,max_fuel,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 = (function (db,where,q_map,vars,fuel,max_fuel,opts){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_111318){
var state_val_111319 = (state_111318[(1)]);
if((state_val_111319 === (7))){
var inst_111269 = (state_111318[(7)]);
var inst_111268 = (state_111318[(8)]);
var inst_111262 = (state_111318[(9)]);
var inst_111274 = fluree.db.query.analytical.clause__GT_tuples(db,q_map,inst_111262,inst_111268,inst_111269,false,fuel,max_fuel,opts);
var state_111318__$1 = state_111318;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_111318__$1,(10),inst_111274);
} else {
if((state_val_111319 === (20))){
var inst_111262 = (state_111318[(9)]);
var inst_111279 = (state_111318[(10)]);
var tmp111320 = inst_111262;
var inst_111261 = inst_111279;
var inst_111262__$1 = tmp111320;
var state_111318__$1 = (function (){var statearr_111321 = state_111318;
(statearr_111321[(11)] = inst_111261);

(statearr_111321[(9)] = inst_111262__$1);

return statearr_111321;
})();
var statearr_111322_111362 = state_111318__$1;
(statearr_111322_111362[(2)] = null);

(statearr_111322_111362[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111319 === (1))){
var state_111318__$1 = state_111318;
var statearr_111323_111363 = state_111318__$1;
(statearr_111323_111363[(2)] = null);

(statearr_111323_111363[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111319 === (24))){
var state_111318__$1 = state_111318;
var statearr_111324_111364 = state_111318__$1;
(statearr_111324_111364[(2)] = null);

(statearr_111324_111364[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111319 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_111318,(3),Error,null,(2));
var inst_111254 = cljs.core.seq(where);
var inst_111255 = cljs.core.first(inst_111254);
var inst_111256 = cljs.core.next(inst_111254);
var inst_111257 = [cljs.core.cst$kw$vars];
var inst_111258 = fluree.db.query.analytical.symbolize_keys(vars);
var inst_111259 = [inst_111258];
var inst_111260 = cljs.core.PersistentHashMap.fromArrays(inst_111257,inst_111259);
var inst_111261 = where;
var inst_111262 = inst_111260;
var state_111318__$1 = (function (){var statearr_111325 = state_111318;
(statearr_111325[(12)] = inst_111256);

(statearr_111325[(13)] = inst_111255);

(statearr_111325[(11)] = inst_111261);

(statearr_111325[(9)] = inst_111262);

return statearr_111325;
})();
var statearr_111326_111365 = state_111318__$1;
(statearr_111326_111365[(2)] = null);

(statearr_111326_111365[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111319 === (15))){
var inst_111278 = (state_111318[(14)]);
var inst_111294 = (inst_111278 == null);
var state_111318__$1 = state_111318;
if(cljs.core.truth_(inst_111294)){
var statearr_111327_111366 = state_111318__$1;
(statearr_111327_111366[(1)] = (20));

} else {
var statearr_111328_111367 = state_111318__$1;
(statearr_111328_111367[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111319 === (21))){
var state_111318__$1 = state_111318;
var statearr_111329_111368 = state_111318__$1;
(statearr_111329_111368[(1)] = (23));



return cljs.core.cst$kw$recur;
} else {
if((state_val_111319 === (13))){
var inst_111309 = (state_111318[(2)]);
var state_111318__$1 = state_111318;
var statearr_111331_111369 = state_111318__$1;
(statearr_111331_111369[(2)] = inst_111309);

(statearr_111331_111369[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111319 === (22))){
var inst_111305 = (state_111318[(2)]);
var state_111318__$1 = state_111318;
var statearr_111332_111370 = state_111318__$1;
(statearr_111332_111370[(2)] = inst_111305);

(statearr_111332_111370[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111319 === (6))){
var inst_111314 = (state_111318[(2)]);
var state_111318__$1 = state_111318;
var statearr_111333_111371 = state_111318__$1;
(statearr_111333_111371[(2)] = inst_111314);


cljs.core.async.impl.ioc_helpers.process_exception(state_111318__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_111319 === (25))){
var inst_111303 = (state_111318[(2)]);
var state_111318__$1 = state_111318;
var statearr_111334_111372 = state_111318__$1;
(statearr_111334_111372[(2)] = inst_111303);

(statearr_111334_111372[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111319 === (17))){
var inst_111278 = (state_111318[(14)]);
var state_111318__$1 = state_111318;
var statearr_111335_111373 = state_111318__$1;
(statearr_111335_111373[(2)] = inst_111278);

(statearr_111335_111373[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111319 === (3))){
var inst_111243 = (state_111318[(2)]);
var state_111318__$1 = state_111318;
var statearr_111336_111374 = state_111318__$1;
(statearr_111336_111374[(2)] = inst_111243);


cljs.core.async.impl.ioc_helpers.process_exception(state_111318__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_111319 === (12))){
var inst_111262 = (state_111318[(9)]);
var inst_111285 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(inst_111262,cljs.core.cst$kw$vars);
var inst_111286 = cljs.core.empty_QMARK_(inst_111285);
var state_111318__$1 = state_111318;
if(inst_111286){
var statearr_111337_111375 = state_111318__$1;
(statearr_111337_111375[(1)] = (14));

} else {
var statearr_111338_111376 = state_111318__$1;
(statearr_111338_111376[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111319 === (2))){
var inst_111316 = (state_111318[(2)]);
var state_111318__$1 = state_111318;
return cljs.core.async.impl.ioc_helpers.return_chan(state_111318__$1,inst_111316);
} else {
if((state_val_111319 === (23))){
var inst_111262 = (state_111318[(9)]);
var inst_111279 = (state_111318[(10)]);
var inst_111278 = (state_111318[(14)]);
var inst_111299 = fluree.db.query.analytical.inner_join(inst_111262,inst_111278);
var inst_111261 = inst_111279;
var inst_111262__$1 = inst_111299;
var state_111318__$1 = (function (){var statearr_111339 = state_111318;
(statearr_111339[(11)] = inst_111261);

(statearr_111339[(9)] = inst_111262__$1);

return statearr_111339;
})();
var statearr_111340_111377 = state_111318__$1;
(statearr_111340_111377[(2)] = null);

(statearr_111340_111377[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111319 === (19))){
var inst_111279 = (state_111318[(10)]);
var inst_111291 = (state_111318[(2)]);
var inst_111261 = inst_111279;
var inst_111262 = inst_111291;
var state_111318__$1 = (function (){var statearr_111341 = state_111318;
(statearr_111341[(11)] = inst_111261);

(statearr_111341[(9)] = inst_111262);

return statearr_111341;
})();
var statearr_111342_111378 = state_111318__$1;
(statearr_111342_111378[(2)] = null);

(statearr_111342_111378[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111319 === (11))){
var inst_111279 = (state_111318[(10)]);
var inst_111278 = (state_111318[(14)]);
var inst_111261 = inst_111279;
var inst_111262 = inst_111278;
var state_111318__$1 = (function (){var statearr_111343 = state_111318;
(statearr_111343[(11)] = inst_111261);

(statearr_111343[(9)] = inst_111262);

return statearr_111343;
})();
var statearr_111344_111379 = state_111318__$1;
(statearr_111344_111379[(2)] = null);

(statearr_111344_111379[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111319 === (9))){
var inst_111312 = (state_111318[(2)]);
var state_111318__$1 = state_111318;
var statearr_111345_111380 = state_111318__$1;
(statearr_111345_111380[(2)] = inst_111312);

(statearr_111345_111380[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111319 === (5))){
var inst_111261 = (state_111318[(11)]);
var inst_111268 = (state_111318[(8)]);
var inst_111267 = cljs.core.seq(inst_111261);
var inst_111268__$1 = cljs.core.first(inst_111267);
var inst_111269 = cljs.core.next(inst_111267);
var state_111318__$1 = (function (){var statearr_111346 = state_111318;
(statearr_111346[(7)] = inst_111269);

(statearr_111346[(8)] = inst_111268__$1);

return statearr_111346;
})();
if(cljs.core.truth_(inst_111268__$1)){
var statearr_111347_111381 = state_111318__$1;
(statearr_111347_111381[(1)] = (7));

} else {
var statearr_111348_111382 = state_111318__$1;
(statearr_111348_111382[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111319 === (14))){
var inst_111278 = (state_111318[(14)]);
var state_111318__$1 = state_111318;
if(cljs.core.truth_(inst_111278)){
var statearr_111349_111383 = state_111318__$1;
(statearr_111349_111383[(1)] = (17));

} else {
var statearr_111350_111384 = state_111318__$1;
(statearr_111350_111384[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111319 === (16))){
var inst_111307 = (state_111318[(2)]);
var state_111318__$1 = state_111318;
var statearr_111351_111385 = state_111318__$1;
(statearr_111351_111385[(2)] = inst_111307);

(statearr_111351_111385[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111319 === (10))){
var inst_111268 = (state_111318[(8)]);
var inst_111276 = (state_111318[(2)]);
var inst_111277 = fluree.db.util.async.throw_err(inst_111276);
var inst_111278 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_111277,(0),null);
var inst_111279 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_111277,(1),null);
var inst_111280 = cljs.core.count(inst_111268);
var inst_111281 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_111280);
var state_111318__$1 = (function (){var statearr_111352 = state_111318;
(statearr_111352[(10)] = inst_111279);

(statearr_111352[(14)] = inst_111278);

return statearr_111352;
})();
if(inst_111281){
var statearr_111353_111386 = state_111318__$1;
(statearr_111353_111386[(1)] = (11));

} else {
var statearr_111354_111387 = state_111318__$1;
(statearr_111354_111387[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111319 === (18))){
var inst_111262 = (state_111318[(9)]);
var state_111318__$1 = state_111318;
var statearr_111355_111388 = state_111318__$1;
(statearr_111355_111388[(2)] = inst_111262);

(statearr_111355_111388[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111319 === (8))){
var inst_111262 = (state_111318[(9)]);
var state_111318__$1 = state_111318;
var statearr_111356_111389 = state_111318__$1;
(statearr_111356_111389[(2)] = inst_111262);

(statearr_111356_111389[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__100742__auto__ = null;
var fluree$db$query$analytical$state_machine__100742__auto____0 = (function (){
var statearr_111357 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_111357[(0)] = fluree$db$query$analytical$state_machine__100742__auto__);

(statearr_111357[(1)] = (1));

return statearr_111357;
});
var fluree$db$query$analytical$state_machine__100742__auto____1 = (function (state_111318){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_111318);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e111358){if((e111358 instanceof Object)){
var ex__100745__auto__ = e111358;
var statearr_111359_111390 = state_111318;
(statearr_111359_111390[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_111318);

return cljs.core.cst$kw$recur;
} else {
throw e111358;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__111391 = state_111318;
state_111318 = G__111391;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__100742__auto__ = function(state_111318){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__100742__auto____1.call(this,state_111318);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__100742__auto____0;
fluree$db$query$analytical$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__100742__auto____1;
return fluree$db$query$analytical$state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_111360 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_111360[(6)] = c__100848__auto__);

return statearr_111360;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$lang$maxFixedArity = 7);

fluree.db.query.analytical.q = (function fluree$db$query$analytical$q(q_map,fuel,max_fuel,db,opts){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_111442){
var state_val_111443 = (state_111442[(1)]);
if((state_val_111443 === (7))){
var inst_111412 = (state_111442[(2)]);
var state_111442__$1 = state_111442;
if(cljs.core.truth_(inst_111412)){
var statearr_111444_111474 = state_111442__$1;
(statearr_111444_111474[(1)] = (11));

} else {
var statearr_111445_111475 = state_111442__$1;
(statearr_111445_111475[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111443 === (20))){
var inst_111433 = (state_111442[(7)]);
var state_111442__$1 = state_111442;
var statearr_111446_111476 = state_111442__$1;
(statearr_111446_111476[(2)] = inst_111433);

(statearr_111446_111476[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111443 === (1))){
var state_111442__$1 = state_111442;
var statearr_111447_111477 = state_111442__$1;
(statearr_111447_111477[(2)] = null);

(statearr_111447_111477[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111443 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_111442,(3),Error,null,(2));
var inst_111398 = (q_map == null);
var inst_111399 = cljs.core.not(inst_111398);
var state_111442__$1 = state_111442;
if(inst_111399){
var statearr_111448_111478 = state_111442__$1;
(statearr_111448_111478[(1)] = (5));

} else {
var statearr_111449_111479 = state_111442__$1;
(statearr_111449_111479[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111443 === (15))){
var inst_111425 = (state_111442[(8)]);
var inst_111420 = (state_111442[(9)]);
var inst_111427 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_111420,inst_111425,fuel,max_fuel,opts);
var state_111442__$1 = state_111442;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_111442__$1,(18),inst_111427);
} else {
if((state_val_111443 === (21))){
var inst_111438 = (state_111442[(2)]);
var state_111442__$1 = state_111442;
var statearr_111450_111480 = state_111442__$1;
(statearr_111450_111480[(2)] = inst_111438);


cljs.core.async.impl.ioc_helpers.process_exception(state_111442__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_111443 === (13))){
var inst_111417 = (state_111442[(2)]);
var inst_111418 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_111417,cljs.core.cst$kw$vars);
var inst_111419 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_111417,cljs.core.cst$kw$where);
var inst_111420 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_111417,cljs.core.cst$kw$optional);
var inst_111421 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_111417,cljs.core.cst$kw$filter);
var inst_111422 = fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_111419,q_map,inst_111418,fuel,max_fuel,opts);
var state_111442__$1 = (function (){var statearr_111451 = state_111442;
(statearr_111451[(10)] = inst_111421);

(statearr_111451[(9)] = inst_111420);

return statearr_111451;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_111442__$1,(14),inst_111422);
} else {
if((state_val_111443 === (6))){
var state_111442__$1 = state_111442;
var statearr_111452_111481 = state_111442__$1;
(statearr_111452_111481[(2)] = false);

(statearr_111452_111481[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111443 === (17))){
var inst_111421 = (state_111442[(10)]);
var inst_111433 = (state_111442[(2)]);
var state_111442__$1 = (function (){var statearr_111453 = state_111442;
(statearr_111453[(7)] = inst_111433);

return statearr_111453;
})();
if(cljs.core.truth_(inst_111421)){
var statearr_111454_111482 = state_111442__$1;
(statearr_111454_111482[(1)] = (19));

} else {
var statearr_111455_111483 = state_111442__$1;
(statearr_111455_111483[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111443 === (3))){
var inst_111392 = (state_111442[(2)]);
var state_111442__$1 = state_111442;
var statearr_111456_111484 = state_111442__$1;
(statearr_111456_111484[(2)] = inst_111392);


cljs.core.async.impl.ioc_helpers.process_exception(state_111442__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_111443 === (12))){
var state_111442__$1 = state_111442;
var statearr_111457_111485 = state_111442__$1;
(statearr_111457_111485[(2)] = q_map);

(statearr_111457_111485[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111443 === (2))){
var inst_111440 = (state_111442[(2)]);
var state_111442__$1 = state_111442;
return cljs.core.async.impl.ioc_helpers.return_chan(state_111442__$1,inst_111440);
} else {
if((state_val_111443 === (19))){
var inst_111433 = (state_111442[(7)]);
var inst_111421 = (state_111442[(10)]);
var inst_111435 = fluree.db.query.analytical.tuples__GT_filtered(inst_111433,inst_111421,null);
var state_111442__$1 = state_111442;
var statearr_111458_111486 = state_111442__$1;
(statearr_111458_111486[(2)] = inst_111435);

(statearr_111458_111486[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111443 === (11))){
var inst_111414 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,q_map);
var state_111442__$1 = state_111442;
var statearr_111459_111487 = state_111442__$1;
(statearr_111459_111487[(2)] = inst_111414);

(statearr_111459_111487[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111443 === (9))){
var state_111442__$1 = state_111442;
var statearr_111460_111488 = state_111442__$1;
(statearr_111460_111488[(2)] = false);

(statearr_111460_111488[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111443 === (5))){
var inst_111401 = q_map.cljs$lang$protocol_mask$partition0$;
var inst_111402 = (inst_111401 & (64));
var inst_111403 = q_map.cljs$core$ISeq$;
var inst_111404 = (cljs.core.PROTOCOL_SENTINEL === inst_111403);
var inst_111405 = ((inst_111402) || (inst_111404));
var state_111442__$1 = state_111442;
if(cljs.core.truth_(inst_111405)){
var statearr_111461_111489 = state_111442__$1;
(statearr_111461_111489[(1)] = (8));

} else {
var statearr_111462_111490 = state_111442__$1;
(statearr_111462_111490[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111443 === (14))){
var inst_111420 = (state_111442[(9)]);
var inst_111424 = (state_111442[(2)]);
var inst_111425 = fluree.db.util.async.throw_err(inst_111424);
var state_111442__$1 = (function (){var statearr_111463 = state_111442;
(statearr_111463[(8)] = inst_111425);

return statearr_111463;
})();
if(cljs.core.truth_(inst_111420)){
var statearr_111464_111491 = state_111442__$1;
(statearr_111464_111491[(1)] = (15));

} else {
var statearr_111465_111492 = state_111442__$1;
(statearr_111465_111492[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111443 === (16))){
var inst_111425 = (state_111442[(8)]);
var state_111442__$1 = state_111442;
var statearr_111466_111493 = state_111442__$1;
(statearr_111466_111493[(2)] = inst_111425);

(statearr_111466_111493[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111443 === (10))){
var inst_111409 = (state_111442[(2)]);
var state_111442__$1 = state_111442;
var statearr_111467_111494 = state_111442__$1;
(statearr_111467_111494[(2)] = inst_111409);

(statearr_111467_111494[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111443 === (18))){
var inst_111429 = (state_111442[(2)]);
var inst_111430 = fluree.db.util.async.throw_err(inst_111429);
var state_111442__$1 = state_111442;
var statearr_111468_111495 = state_111442__$1;
(statearr_111468_111495[(2)] = inst_111430);

(statearr_111468_111495[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111443 === (8))){
var state_111442__$1 = state_111442;
var statearr_111469_111496 = state_111442__$1;
(statearr_111469_111496[(2)] = true);

(statearr_111469_111496[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$q_$_state_machine__100742__auto__ = null;
var fluree$db$query$analytical$q_$_state_machine__100742__auto____0 = (function (){
var statearr_111470 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_111470[(0)] = fluree$db$query$analytical$q_$_state_machine__100742__auto__);

(statearr_111470[(1)] = (1));

return statearr_111470;
});
var fluree$db$query$analytical$q_$_state_machine__100742__auto____1 = (function (state_111442){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_111442);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e111471){if((e111471 instanceof Object)){
var ex__100745__auto__ = e111471;
var statearr_111472_111497 = state_111442;
(statearr_111472_111497[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_111442);

return cljs.core.cst$kw$recur;
} else {
throw e111471;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__111498 = state_111442;
state_111442 = G__111498;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$query$analytical$q_$_state_machine__100742__auto__ = function(state_111442){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$q_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$query$analytical$q_$_state_machine__100742__auto____1.call(this,state_111442);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$q_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$q_$_state_machine__100742__auto____0;
fluree$db$query$analytical$q_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$q_$_state_machine__100742__auto____1;
return fluree$db$query$analytical$q_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_111473 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_111473[(6)] = c__100848__auto__);

return statearr_111473;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
