// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true}
goog.provide('fluree.db.index');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.data.avl');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.log');

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.IndexConfig = (function (index_type,comparator,historyComparator,__meta,__extmap,__hash){
this.index_type = index_type;
this.comparator = comparator;
this.historyComparator = historyComparator;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.IndexConfig.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k106346,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__106350 = k106346;
var G__106350__$1 = (((G__106350 instanceof cljs.core.Keyword))?G__106350.fqn:null);
switch (G__106350__$1) {
case "index-type":
return self__.index_type;

break;
case "comparator":
return self__.comparator;

break;
case "historyComparator":
return self__.historyComparator;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k106346,else__4383__auto__);

}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__106351){
var vec__106352 = p__106351;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106352,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106352,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#fluree.db.index.IndexConfig{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$index_DASH_type,self__.index_type],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$comparator,self__.comparator],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$historyComparator,self__.historyComparator],null))], null),self__.__extmap));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__106345){
var self__ = this;
var G__106345__$1 = this;
return (new cljs.core.RecordIter((0),G__106345__$1,3,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$comparator,cljs.core.cst$kw$historyComparator], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (3 + cljs.core.count(self__.__extmap));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (){var fexpr__106355 = (function (coll__4377__auto__){
return (1512230614 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
});
return fexpr__106355(this__4376__auto____$1);
})();
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this106347,other106348){
var self__ = this;
var this106347__$1 = this;
return (((!((other106348 == null)))) && ((this106347__$1.constructor === other106348.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this106347__$1.index_type,other106348.index_type)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this106347__$1.comparator,other106348.comparator)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this106347__$1.historyComparator,other106348.historyComparator)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this106347__$1.__extmap,other106348.__extmap)));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$historyComparator,null,cljs.core.cst$kw$comparator,null,cljs.core.cst$kw$index_DASH_type,null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__106345){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__106356 = cljs.core.keyword_identical_QMARK_;
var expr__106357 = k__4388__auto__;
if(cljs.core.truth_((function (){var G__106359 = cljs.core.cst$kw$index_DASH_type;
var G__106360 = expr__106357;
return (pred__106356.cljs$core$IFn$_invoke$arity$2 ? pred__106356.cljs$core$IFn$_invoke$arity$2(G__106359,G__106360) : pred__106356.call(null,G__106359,G__106360));
})())){
return (new fluree.db.index.IndexConfig(G__106345,self__.comparator,self__.historyComparator,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__106361 = cljs.core.cst$kw$comparator;
var G__106362 = expr__106357;
return (pred__106356.cljs$core$IFn$_invoke$arity$2 ? pred__106356.cljs$core$IFn$_invoke$arity$2(G__106361,G__106362) : pred__106356.call(null,G__106361,G__106362));
})())){
return (new fluree.db.index.IndexConfig(self__.index_type,G__106345,self__.historyComparator,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__106363 = cljs.core.cst$kw$historyComparator;
var G__106364 = expr__106357;
return (pred__106356.cljs$core$IFn$_invoke$arity$2 ? pred__106356.cljs$core$IFn$_invoke$arity$2(G__106363,G__106364) : pred__106356.call(null,G__106363,G__106364));
})())){
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,G__106345,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__106345),null));
}
}
}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$index_DASH_type,self__.index_type,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$comparator,self__.comparator,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$historyComparator,self__.historyComparator,null))], null),self__.__extmap));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__106345){
var self__ = this;
var this__4379__auto____$1 = this;
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,G__106345,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4386__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(fluree.db.index.IndexConfig.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$index_DASH_type,cljs.core.cst$sym$comparator,cljs.core.cst$sym$historyComparator], null);
}));

(fluree.db.index.IndexConfig.cljs$lang$type = true);

(fluree.db.index.IndexConfig.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"fluree.db.index/IndexConfig",null,(1),null));
}));

(fluree.db.index.IndexConfig.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"fluree.db.index/IndexConfig");
}));

/**
 * Positional factory function for fluree.db.index/IndexConfig.
 */
fluree.db.index.__GT_IndexConfig = (function fluree$db$index$__GT_IndexConfig(index_type,comparator,historyComparator){
return (new fluree.db.index.IndexConfig(index_type,comparator,historyComparator,null,null,null));
});

/**
 * Factory function for fluree.db.index/IndexConfig, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_IndexConfig = (function fluree$db$index$map__GT_IndexConfig(G__106349){
var extmap__4419__auto__ = (function (){var G__106365 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__106349,cljs.core.cst$kw$index_DASH_type,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$comparator,cljs.core.cst$kw$historyComparator], 0));
if(cljs.core.record_QMARK_(G__106349)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__106365);
} else {
return G__106365;
}
})();
return (new fluree.db.index.IndexConfig(cljs.core.cst$kw$index_DASH_type.cljs$core$IFn$_invoke$arity$1(G__106349),cljs.core.cst$kw$comparator.cljs$core$IFn$_invoke$arity$1(G__106349),cljs.core.cst$kw$historyComparator.cljs$core$IFn$_invoke$arity$1(G__106349),null,cljs.core.not_empty(extmap__4419__auto__),null));
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {fluree.db.dbproto.INode}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.IndexNode = (function (block,t,rhs,children,config,leftmost_QMARK_,__meta,__extmap,__hash){
this.block = block;
this.t = t;
this.rhs = rhs;
this.children = children;
this.config = config;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.IndexNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k106368,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__106372 = k106368;
var G__106372__$1 = (((G__106372 instanceof cljs.core.Keyword))?G__106372.fqn:null);
switch (G__106372__$1) {
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "rhs":
return self__.rhs;

break;
case "children":
return self__.children;

break;
case "config":
return self__.config;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k106368,else__4383__auto__);

}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__106373){
var vec__106374 = p__106373;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106374,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106374,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#fluree.db.index.IndexNode{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$block,self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$t,self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$rhs,self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$children,self__.children],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$config,self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$leftmost_QMARK_,self__.leftmost_QMARK_],null))], null),self__.__extmap));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__106367){
var self__ = this;
var G__106367__$1 = this;
return (new cljs.core.RecordIter((0),G__106367__$1,6,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$rhs,cljs.core.cst$kw$children,cljs.core.cst$kw$config,cljs.core.cst$kw$leftmost_QMARK_], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_106378){
var state_val_106379 = (state_106378[(1)]);
if((state_val_106379 === (1))){
var state_106378__$1 = state_106378;
return cljs.core.async.impl.ioc_helpers.return_chan(state_106378__$1,this$__$1);
} else {
return null;
}
});
return (function() {
var fluree$db$index$state_machine__100742__auto__ = null;
var fluree$db$index$state_machine__100742__auto____0 = (function (){
var statearr_106380 = [null,null,null,null,null,null,null];
(statearr_106380[(0)] = fluree$db$index$state_machine__100742__auto__);

(statearr_106380[(1)] = (1));

return statearr_106380;
});
var fluree$db$index$state_machine__100742__auto____1 = (function (state_106378){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_106378);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e106381){if((e106381 instanceof Object)){
var ex__100745__auto__ = e106381;
var statearr_106382_106472 = state_106378;
(statearr_106382_106472[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_106378);

return cljs.core.cst$kw$recur;
} else {
throw e106381;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__106473 = state_106378;
state_106378 = G__106473;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$index$state_machine__100742__auto__ = function(state_106378){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__100742__auto____1.call(this,state_106378);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__100742__auto____0;
fluree$db$index$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__100742__auto____1;
return fluree$db$index$state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_106383 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_106383[(6)] = c__100848__auto__);

return statearr_106383;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.key(cljs.core.first(self__.children));
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (6 + cljs.core.count(self__.__extmap));
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
return cljs.core.val((function (){var or__4126__auto__ = clojure.data.avl.nearest(self__.children,cljs.core._LT__EQ_,flake);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.first(self__.children);
}
})());
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_after$arity$2 = (function (_,flake){
var self__ = this;
var ___$1 = this;
return cljs.core.val((function (){var or__4126__auto__ = clojure.data.avl.nearest(self__.children,cljs.core._GT_,flake);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.last(self__.children);
}
})());
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_leaf$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_106405){
var state_val_106406 = (state_106405[(1)]);
if((state_val_106406 === (7))){
var inst_106401 = (state_106405[(2)]);
var state_106405__$1 = state_106405;
var statearr_106407_106474 = state_106405__$1;
(statearr_106407_106474[(2)] = inst_106401);


cljs.core.async.impl.ioc_helpers.process_exception(state_106405__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_106406 === (1))){
var state_106405__$1 = state_106405;
var statearr_106408_106475 = state_106405__$1;
(statearr_106408_106475[(2)] = null);

(statearr_106408_106475[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106406 === (4))){
var inst_106388 = (state_106405[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_106405,(3),Error,null,(2));
var inst_106388__$1 = this$__$1.fluree$db$dbproto$INode$_lookup$arity$2(null,flake);
var inst_106389 = cljs.core.cst$kw$leaf.cljs$core$IFn$_invoke$arity$1(inst_106388__$1);
var state_106405__$1 = (function (){var statearr_106409 = state_106405;
(statearr_106409[(7)] = inst_106388__$1);

return statearr_106409;
})();
if(cljs.core.truth_(inst_106389)){
var statearr_106410_106476 = state_106405__$1;
(statearr_106410_106476[(1)] = (5));

} else {
var statearr_106411_106477 = state_106405__$1;
(statearr_106411_106477[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_106406 === (6))){
var inst_106388 = (state_106405[(7)]);
var inst_106392 = fluree.db.dbproto._resolve(inst_106388);
var state_106405__$1 = state_106405;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_106405__$1,(9),inst_106392);
} else {
if((state_val_106406 === (3))){
var inst_106384 = (state_106405[(2)]);
var state_106405__$1 = state_106405;
var statearr_106412_106478 = state_106405__$1;
(statearr_106412_106478[(2)] = inst_106384);


cljs.core.async.impl.ioc_helpers.process_exception(state_106405__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_106406 === (2))){
var inst_106403 = (state_106405[(2)]);
var state_106405__$1 = state_106405;
return cljs.core.async.impl.ioc_helpers.return_chan(state_106405__$1,inst_106403);
} else {
if((state_val_106406 === (9))){
var inst_106394 = (state_106405[(2)]);
var inst_106395 = fluree.db.util.async.throw_err(inst_106394);
var inst_106396 = fluree.db.dbproto._lookup_leaf(inst_106395,flake);
var state_106405__$1 = state_106405;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_106405__$1,(8),inst_106396);
} else {
if((state_val_106406 === (5))){
var inst_106388 = (state_106405[(7)]);
var state_106405__$1 = state_106405;
var statearr_106413_106479 = state_106405__$1;
(statearr_106413_106479[(2)] = inst_106388);

(statearr_106413_106479[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106406 === (8))){
var inst_106398 = (state_106405[(2)]);
var inst_106399 = fluree.db.util.async.throw_err(inst_106398);
var state_106405__$1 = state_106405;
var statearr_106414_106480 = state_106405__$1;
(statearr_106414_106480[(2)] = inst_106399);

(statearr_106414_106480[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$state_machine__100742__auto__ = null;
var fluree$db$index$state_machine__100742__auto____0 = (function (){
var statearr_106415 = [null,null,null,null,null,null,null,null];
(statearr_106415[(0)] = fluree$db$index$state_machine__100742__auto__);

(statearr_106415[(1)] = (1));

return statearr_106415;
});
var fluree$db$index$state_machine__100742__auto____1 = (function (state_106405){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_106405);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e106416){if((e106416 instanceof Object)){
var ex__100745__auto__ = e106416;
var statearr_106417_106481 = state_106405;
(statearr_106417_106481[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_106405);

return cljs.core.cst$kw$recur;
} else {
throw e106416;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__106482 = state_106405;
state_106405 = G__106482;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$index$state_machine__100742__auto__ = function(state_106405){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__100742__auto____1.call(this,state_106405);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__100742__auto____0;
fluree$db$index$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__100742__auto____1;
return fluree$db$index$state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_106418 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_106418[(6)] = c__100848__auto__);

return statearr_106418;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_leaf_after$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_106440){
var state_val_106441 = (state_106440[(1)]);
if((state_val_106441 === (7))){
var inst_106436 = (state_106440[(2)]);
var state_106440__$1 = state_106440;
var statearr_106442_106483 = state_106440__$1;
(statearr_106442_106483[(2)] = inst_106436);


cljs.core.async.impl.ioc_helpers.process_exception(state_106440__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_106441 === (1))){
var state_106440__$1 = state_106440;
var statearr_106443_106484 = state_106440__$1;
(statearr_106443_106484[(2)] = null);

(statearr_106443_106484[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106441 === (4))){
var inst_106423 = (state_106440[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_106440,(3),Error,null,(2));
var inst_106423__$1 = this$__$1.fluree$db$dbproto$INode$_lookup_after$arity$2(null,flake);
var inst_106424 = cljs.core.cst$kw$leaf.cljs$core$IFn$_invoke$arity$1(inst_106423__$1);
var state_106440__$1 = (function (){var statearr_106444 = state_106440;
(statearr_106444[(7)] = inst_106423__$1);

return statearr_106444;
})();
if(cljs.core.truth_(inst_106424)){
var statearr_106445_106485 = state_106440__$1;
(statearr_106445_106485[(1)] = (5));

} else {
var statearr_106446_106486 = state_106440__$1;
(statearr_106446_106486[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_106441 === (6))){
var inst_106423 = (state_106440[(7)]);
var inst_106427 = fluree.db.dbproto._resolve(inst_106423);
var state_106440__$1 = state_106440;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_106440__$1,(9),inst_106427);
} else {
if((state_val_106441 === (3))){
var inst_106419 = (state_106440[(2)]);
var state_106440__$1 = state_106440;
var statearr_106447_106487 = state_106440__$1;
(statearr_106447_106487[(2)] = inst_106419);


cljs.core.async.impl.ioc_helpers.process_exception(state_106440__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_106441 === (2))){
var inst_106438 = (state_106440[(2)]);
var state_106440__$1 = state_106440;
return cljs.core.async.impl.ioc_helpers.return_chan(state_106440__$1,inst_106438);
} else {
if((state_val_106441 === (9))){
var inst_106429 = (state_106440[(2)]);
var inst_106430 = fluree.db.util.async.throw_err(inst_106429);
var inst_106431 = fluree.db.dbproto._lookup_leaf_after(inst_106430,flake);
var state_106440__$1 = state_106440;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_106440__$1,(8),inst_106431);
} else {
if((state_val_106441 === (5))){
var inst_106423 = (state_106440[(7)]);
var state_106440__$1 = state_106440;
var statearr_106448_106488 = state_106440__$1;
(statearr_106448_106488[(2)] = inst_106423);

(statearr_106448_106488[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106441 === (8))){
var inst_106433 = (state_106440[(2)]);
var inst_106434 = fluree.db.util.async.throw_err(inst_106433);
var state_106440__$1 = state_106440;
var statearr_106449_106489 = state_106440__$1;
(statearr_106449_106489[(2)] = inst_106434);

(statearr_106449_106489[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$state_machine__100742__auto__ = null;
var fluree$db$index$state_machine__100742__auto____0 = (function (){
var statearr_106450 = [null,null,null,null,null,null,null,null];
(statearr_106450[(0)] = fluree$db$index$state_machine__100742__auto__);

(statearr_106450[(1)] = (1));

return statearr_106450;
});
var fluree$db$index$state_machine__100742__auto____1 = (function (state_106440){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_106440);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e106451){if((e106451 instanceof Object)){
var ex__100745__auto__ = e106451;
var statearr_106452_106490 = state_106440;
(statearr_106452_106490[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_106440);

return cljs.core.cst$kw$recur;
} else {
throw e106451;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__106491 = state_106440;
state_106440 = G__106491;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$index$state_machine__100742__auto__ = function(state_106440){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__100742__auto____1.call(this,state_106440);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__100742__auto____0;
fluree$db$index$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__100742__auto____1;
return fluree$db$index$state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_106453 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_106453[(6)] = c__100848__auto__);

return statearr_106453;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (){var fexpr__106454 = (function (coll__4377__auto__){
return (659789215 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
});
return fexpr__106454(this__4376__auto____$1);
})();
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this106369,other106370){
var self__ = this;
var this106369__$1 = this;
return (((!((other106370 == null)))) && ((this106369__$1.constructor === other106370.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this106369__$1.block,other106370.block)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this106369__$1.t,other106370.t)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this106369__$1.rhs,other106370.rhs)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this106369__$1.children,other106370.children)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this106369__$1.config,other106370.config)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this106369__$1.leftmost_QMARK_,other106370.leftmost_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this106369__$1.__extmap,other106370.__extmap)));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$children,null,cljs.core.cst$kw$block,null,cljs.core.cst$kw$config,null,cljs.core.cst$kw$leftmost_QMARK_,null,cljs.core.cst$kw$t,null,cljs.core.cst$kw$rhs,null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__106367){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__106455 = cljs.core.keyword_identical_QMARK_;
var expr__106456 = k__4388__auto__;
if(cljs.core.truth_((function (){var G__106458 = cljs.core.cst$kw$block;
var G__106459 = expr__106456;
return (pred__106455.cljs$core$IFn$_invoke$arity$2 ? pred__106455.cljs$core$IFn$_invoke$arity$2(G__106458,G__106459) : pred__106455.call(null,G__106458,G__106459));
})())){
return (new fluree.db.index.IndexNode(G__106367,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__106460 = cljs.core.cst$kw$t;
var G__106461 = expr__106456;
return (pred__106455.cljs$core$IFn$_invoke$arity$2 ? pred__106455.cljs$core$IFn$_invoke$arity$2(G__106460,G__106461) : pred__106455.call(null,G__106460,G__106461));
})())){
return (new fluree.db.index.IndexNode(self__.block,G__106367,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__106462 = cljs.core.cst$kw$rhs;
var G__106463 = expr__106456;
return (pred__106455.cljs$core$IFn$_invoke$arity$2 ? pred__106455.cljs$core$IFn$_invoke$arity$2(G__106462,G__106463) : pred__106455.call(null,G__106462,G__106463));
})())){
return (new fluree.db.index.IndexNode(self__.block,self__.t,G__106367,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__106464 = cljs.core.cst$kw$children;
var G__106465 = expr__106456;
return (pred__106455.cljs$core$IFn$_invoke$arity$2 ? pred__106455.cljs$core$IFn$_invoke$arity$2(G__106464,G__106465) : pred__106455.call(null,G__106464,G__106465));
})())){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,G__106367,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__106466 = cljs.core.cst$kw$config;
var G__106467 = expr__106456;
return (pred__106455.cljs$core$IFn$_invoke$arity$2 ? pred__106455.cljs$core$IFn$_invoke$arity$2(G__106466,G__106467) : pred__106455.call(null,G__106466,G__106467));
})())){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,G__106367,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__106468 = cljs.core.cst$kw$leftmost_QMARK_;
var G__106469 = expr__106456;
return (pred__106455.cljs$core$IFn$_invoke$arity$2 ? pred__106455.cljs$core$IFn$_invoke$arity$2(G__106468,G__106469) : pred__106455.call(null,G__106468,G__106469));
})())){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,G__106367,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__106367),null));
}
}
}
}
}
}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$block,self__.block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$t,self__.t,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$rhs,self__.rhs,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$children,self__.children,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$config,self__.config,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$leftmost_QMARK_,self__.leftmost_QMARK_,null))], null),self__.__extmap));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__106367){
var self__ = this;
var this__4379__auto____$1 = this;
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,G__106367,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4386__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(fluree.db.index.IndexNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$block,cljs.core.cst$sym$t,cljs.core.cst$sym$rhs,cljs.core.cst$sym$children,cljs.core.cst$sym$config,cljs.core.cst$sym$leftmost_QMARK_], null);
}));

(fluree.db.index.IndexNode.cljs$lang$type = true);

(fluree.db.index.IndexNode.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"fluree.db.index/IndexNode",null,(1),null));
}));

(fluree.db.index.IndexNode.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"fluree.db.index/IndexNode");
}));

/**
 * Positional factory function for fluree.db.index/IndexNode.
 */
fluree.db.index.__GT_IndexNode = (function fluree$db$index$__GT_IndexNode(block,t,rhs,children,config,leftmost_QMARK_){
return (new fluree.db.index.IndexNode(block,t,rhs,children,config,leftmost_QMARK_,null,null,null));
});

/**
 * Factory function for fluree.db.index/IndexNode, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_IndexNode = (function fluree$db$index$map__GT_IndexNode(G__106371){
var extmap__4419__auto__ = (function (){var G__106470 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__106371,cljs.core.cst$kw$block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$t,cljs.core.cst$kw$rhs,cljs.core.cst$kw$children,cljs.core.cst$kw$config,cljs.core.cst$kw$leftmost_QMARK_], 0));
if(cljs.core.record_QMARK_(G__106371)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__106470);
} else {
return G__106470;
}
})();
return (new fluree.db.index.IndexNode(cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(G__106371),cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(G__106371),cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(G__106371),cljs.core.cst$kw$children.cljs$core$IFn$_invoke$arity$1(G__106371),cljs.core.cst$kw$config.cljs$core$IFn$_invoke$arity$1(G__106371),cljs.core.cst$kw$leftmost_QMARK_.cljs$core$IFn$_invoke$arity$1(G__106371),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

fluree.db.index.index_node_QMARK_ = (function fluree$db$index$index_node_QMARK_(node){
return (node instanceof fluree.db.index.IndexNode);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {fluree.db.dbproto.INode}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.DataNode = (function (block,t,flakes,rhs,config,__meta,__extmap,__hash){
this.block = block;
this.t = t;
this.flakes = flakes;
this.rhs = rhs;
this.config = config;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.DataNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(fluree.db.index.DataNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k106493,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__106497 = k106493;
var G__106497__$1 = (((G__106497 instanceof cljs.core.Keyword))?G__106497.fqn:null);
switch (G__106497__$1) {
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "flakes":
return self__.flakes;

break;
case "rhs":
return self__.rhs;

break;
case "config":
return self__.config;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k106493,else__4383__auto__);

}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__106498){
var vec__106499 = p__106498;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106499,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106499,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(fluree.db.index.DataNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#fluree.db.index.DataNode{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$block,self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$t,self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$flakes,self__.flakes],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$rhs,self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$config,self__.config],null))], null),self__.__extmap));
}));

(fluree.db.index.DataNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__106492){
var self__ = this;
var G__106492__$1 = this;
return (new cljs.core.RecordIter((0),G__106492__$1,5,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$flakes,cljs.core.cst$kw$rhs,cljs.core.cst$kw$config], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_106503){
var state_val_106504 = (state_106503[(1)]);
if((state_val_106504 === (1))){
var state_106503__$1 = state_106503;
return cljs.core.async.impl.ioc_helpers.return_chan(state_106503__$1,this$__$1);
} else {
return null;
}
});
return (function() {
var fluree$db$index$state_machine__100742__auto__ = null;
var fluree$db$index$state_machine__100742__auto____0 = (function (){
var statearr_106505 = [null,null,null,null,null,null,null];
(statearr_106505[(0)] = fluree$db$index$state_machine__100742__auto__);

(statearr_106505[(1)] = (1));

return statearr_106505;
});
var fluree$db$index$state_machine__100742__auto____1 = (function (state_106503){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_106503);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e106506){if((e106506 instanceof Object)){
var ex__100745__auto__ = e106506;
var statearr_106507_106536 = state_106503;
(statearr_106507_106536[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_106503);

return cljs.core.cst$kw$recur;
} else {
throw e106506;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__106537 = state_106503;
state_106503 = G__106537;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$index$state_machine__100742__auto__ = function(state_106503){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__100742__auto____1.call(this,state_106503);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__100742__auto____0;
fluree$db$index$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__100742__auto____1;
return fluree$db$index$state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_106508 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_106508[(6)] = c__100848__auto__);

return statearr_106508;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-resolve-history called on DATA NODE!!!",cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.first(self__.flakes);
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.index.DataNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.DataNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.DataNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (5 + cljs.core.count(self__.__extmap));
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$_lookup$arity$2 = (function (root,flake){
var self__ = this;
var root__$1 = this;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-lookup was called on a data node, which shouldn't happen!",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null));
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$_lookup_leaf$arity$2 = (function (root,flake){
var self__ = this;
var root__$1 = this;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["-lookup-leaf was called on a data node, which shouldn't happen!"], 0));

var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_106514){
var state_val_106515 = (state_106514[(1)]);
if((state_val_106515 === (1))){
var inst_106509 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_106510 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_106511 = cljs.core.PersistentHashMap.fromArrays(inst_106509,inst_106510);
var inst_106512 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-lookup-leaf was called on a data node, which shouldn't happen!",inst_106511);
var state_106514__$1 = state_106514;
return cljs.core.async.impl.ioc_helpers.return_chan(state_106514__$1,inst_106512);
} else {
return null;
}
});
return (function() {
var fluree$db$index$state_machine__100742__auto__ = null;
var fluree$db$index$state_machine__100742__auto____0 = (function (){
var statearr_106516 = [null,null,null,null,null,null,null];
(statearr_106516[(0)] = fluree$db$index$state_machine__100742__auto__);

(statearr_106516[(1)] = (1));

return statearr_106516;
});
var fluree$db$index$state_machine__100742__auto____1 = (function (state_106514){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_106514);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e106517){if((e106517 instanceof Object)){
var ex__100745__auto__ = e106517;
var statearr_106518_106538 = state_106514;
(statearr_106518_106538[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_106514);

return cljs.core.cst$kw$recur;
} else {
throw e106517;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__106539 = state_106514;
state_106514 = G__106539;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$index$state_machine__100742__auto__ = function(state_106514){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__100742__auto____1.call(this,state_106514);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__100742__auto____0;
fluree$db$index$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__100742__auto____1;
return fluree$db$index$state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_106519 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_106519[(6)] = c__100848__auto__);

return statearr_106519;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
}));

(fluree.db.index.DataNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (){var fexpr__106520 = (function (coll__4377__auto__){
return (1312629141 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
});
return fexpr__106520(this__4376__auto____$1);
})();
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this106494,other106495){
var self__ = this;
var this106494__$1 = this;
return (((!((other106495 == null)))) && ((this106494__$1.constructor === other106495.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this106494__$1.block,other106495.block)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this106494__$1.t,other106495.t)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this106494__$1.flakes,other106495.flakes)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this106494__$1.rhs,other106495.rhs)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this106494__$1.config,other106495.config)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this106494__$1.__extmap,other106495.__extmap)));
}));

(fluree.db.index.DataNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$block,null,cljs.core.cst$kw$config,null,cljs.core.cst$kw$t,null,cljs.core.cst$kw$flakes,null,cljs.core.cst$kw$rhs,null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__106492){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__106521 = cljs.core.keyword_identical_QMARK_;
var expr__106522 = k__4388__auto__;
if(cljs.core.truth_((function (){var G__106524 = cljs.core.cst$kw$block;
var G__106525 = expr__106522;
return (pred__106521.cljs$core$IFn$_invoke$arity$2 ? pred__106521.cljs$core$IFn$_invoke$arity$2(G__106524,G__106525) : pred__106521.call(null,G__106524,G__106525));
})())){
return (new fluree.db.index.DataNode(G__106492,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__106526 = cljs.core.cst$kw$t;
var G__106527 = expr__106522;
return (pred__106521.cljs$core$IFn$_invoke$arity$2 ? pred__106521.cljs$core$IFn$_invoke$arity$2(G__106526,G__106527) : pred__106521.call(null,G__106526,G__106527));
})())){
return (new fluree.db.index.DataNode(self__.block,G__106492,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__106528 = cljs.core.cst$kw$flakes;
var G__106529 = expr__106522;
return (pred__106521.cljs$core$IFn$_invoke$arity$2 ? pred__106521.cljs$core$IFn$_invoke$arity$2(G__106528,G__106529) : pred__106521.call(null,G__106528,G__106529));
})())){
return (new fluree.db.index.DataNode(self__.block,self__.t,G__106492,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__106530 = cljs.core.cst$kw$rhs;
var G__106531 = expr__106522;
return (pred__106521.cljs$core$IFn$_invoke$arity$2 ? pred__106521.cljs$core$IFn$_invoke$arity$2(G__106530,G__106531) : pred__106521.call(null,G__106530,G__106531));
})())){
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,G__106492,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__106532 = cljs.core.cst$kw$config;
var G__106533 = expr__106522;
return (pred__106521.cljs$core$IFn$_invoke$arity$2 ? pred__106521.cljs$core$IFn$_invoke$arity$2(G__106532,G__106533) : pred__106521.call(null,G__106532,G__106533));
})())){
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,G__106492,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__106492),null));
}
}
}
}
}
}));

(fluree.db.index.DataNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$block,self__.block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$t,self__.t,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$flakes,self__.flakes,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$rhs,self__.rhs,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$config,self__.config,null))], null),self__.__extmap));
}));

(fluree.db.index.DataNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__106492){
var self__ = this;
var this__4379__auto____$1 = this;
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,G__106492,self__.__extmap,self__.__hash));
}));

(fluree.db.index.DataNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4386__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(fluree.db.index.DataNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$block,cljs.core.cst$sym$t,cljs.core.cst$sym$flakes,cljs.core.cst$sym$rhs,cljs.core.cst$sym$config], null);
}));

(fluree.db.index.DataNode.cljs$lang$type = true);

(fluree.db.index.DataNode.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"fluree.db.index/DataNode",null,(1),null));
}));

(fluree.db.index.DataNode.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"fluree.db.index/DataNode");
}));

/**
 * Positional factory function for fluree.db.index/DataNode.
 */
fluree.db.index.__GT_DataNode = (function fluree$db$index$__GT_DataNode(block,t,flakes,rhs,config){
return (new fluree.db.index.DataNode(block,t,flakes,rhs,config,null,null,null));
});

/**
 * Factory function for fluree.db.index/DataNode, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_DataNode = (function fluree$db$index$map__GT_DataNode(G__106496){
var extmap__4419__auto__ = (function (){var G__106534 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__106496,cljs.core.cst$kw$block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$t,cljs.core.cst$kw$flakes,cljs.core.cst$kw$rhs,cljs.core.cst$kw$config], 0));
if(cljs.core.record_QMARK_(G__106496)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__106534);
} else {
return G__106534;
}
})();
return (new fluree.db.index.DataNode(cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(G__106496),cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(G__106496),cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(G__106496),cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(G__106496),cljs.core.cst$kw$config.cljs$core$IFn$_invoke$arity$1(G__106496),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

/**
 * Creates a new data node
 */
fluree.db.index.data_node = (function fluree$db$index$data_node(block_id,t,flakes,rhs,config){
return fluree.db.index.__GT_DataNode(block_id,t,flakes,rhs,config);
});
fluree.db.index.data_node_QMARK_ = (function fluree$db$index$data_node_QMARK_(node){
return (node instanceof fluree.db.index.DataNode);
});
