// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__100908 = arguments.length;
switch (G__100908) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async100909 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async100909 = (function (f,blockable,meta100910){
this.f = f;
this.blockable = blockable;
this.meta100910 = meta100910;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async100909.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_100911,meta100910__$1){
var self__ = this;
var _100911__$1 = this;
return (new cljs.core.async.t_cljs$core$async100909(self__.f,self__.blockable,meta100910__$1));
}));

(cljs.core.async.t_cljs$core$async100909.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_100911){
var self__ = this;
var _100911__$1 = this;
return self__.meta100910;
}));

(cljs.core.async.t_cljs$core$async100909.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async100909.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async100909.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async100909.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async100909.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$blockable,cljs.core.cst$sym$meta100910], null);
}));

(cljs.core.async.t_cljs$core$async100909.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async100909.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async100909");

(cljs.core.async.t_cljs$core$async100909.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async100909");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async100909.
 */
cljs.core.async.__GT_t_cljs$core$async100909 = (function cljs$core$async$__GT_t_cljs$core$async100909(f__$1,blockable__$1,meta100910){
return (new cljs.core.async.t_cljs$core$async100909(f__$1,blockable__$1,meta100910));
});

}

return (new cljs.core.async.t_cljs$core$async100909(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__100915 = arguments.length;
switch (G__100915) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__100918 = arguments.length;
switch (G__100918) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__100921 = arguments.length;
switch (G__100921) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_100923 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_100923) : fn1.call(null,val_100923));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_100923) : fn1.call(null,val_100923));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__100925 = arguments.length;
switch (G__100925) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5733__auto__)){
var ret = temp__5733__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5733__auto__)){
var retb = temp__5733__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4613__auto___100927 = n;
var x_100928 = (0);
while(true){
if((x_100928 < n__4613__auto___100927)){
(a[x_100928] = (0));

var G__100929 = (x_100928 + (1));
x_100928 = G__100929;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,n)){
return a;
} else {
var j = cljs.core.rand_int(i);
(a[i] = (a[j]));

(a[j] = i);

var G__100930 = (i + (1));
i = G__100930;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async100931 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async100931 = (function (flag,meta100932){
this.flag = flag;
this.meta100932 = meta100932;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async100931.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_100933,meta100932__$1){
var self__ = this;
var _100933__$1 = this;
return (new cljs.core.async.t_cljs$core$async100931(self__.flag,meta100932__$1));
}));

(cljs.core.async.t_cljs$core$async100931.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_100933){
var self__ = this;
var _100933__$1 = this;
return self__.meta100932;
}));

(cljs.core.async.t_cljs$core$async100931.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async100931.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async100931.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async100931.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async100931.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$meta100932], null);
}));

(cljs.core.async.t_cljs$core$async100931.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async100931.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async100931");

(cljs.core.async.t_cljs$core$async100931.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async100931");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async100931.
 */
cljs.core.async.__GT_t_cljs$core$async100931 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async100931(flag__$1,meta100932){
return (new cljs.core.async.t_cljs$core$async100931(flag__$1,meta100932));
});

}

return (new cljs.core.async.t_cljs$core$async100931(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async100934 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async100934 = (function (flag,cb,meta100935){
this.flag = flag;
this.cb = cb;
this.meta100935 = meta100935;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async100934.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_100936,meta100935__$1){
var self__ = this;
var _100936__$1 = this;
return (new cljs.core.async.t_cljs$core$async100934(self__.flag,self__.cb,meta100935__$1));
}));

(cljs.core.async.t_cljs$core$async100934.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_100936){
var self__ = this;
var _100936__$1 = this;
return self__.meta100935;
}));

(cljs.core.async.t_cljs$core$async100934.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async100934.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async100934.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async100934.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async100934.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$cb,cljs.core.cst$sym$meta100935], null);
}));

(cljs.core.async.t_cljs$core$async100934.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async100934.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async100934");

(cljs.core.async.t_cljs$core$async100934.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async100934");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async100934.
 */
cljs.core.async.__GT_t_cljs$core$async100934 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async100934(flag__$1,cb__$1,meta100935){
return (new cljs.core.async.t_cljs$core$async100934(flag__$1,cb__$1,meta100935));
});

}

return (new cljs.core.async.t_cljs$core$async100934(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.cst$kw$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__100937_SHARP_){
var G__100939 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__100937_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__100939) : fret.call(null,G__100939));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__100938_SHARP_){
var G__100940 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__100938_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__100940) : fret.call(null,G__100940));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4126__auto__ = wport;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return port;
}
})()], null));
} else {
var G__100941 = (i + (1));
i = G__100941;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4126__auto__ = ret;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$default)){
var temp__5735__auto__ = (function (){var and__4115__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4115__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(temp__5735__auto__)){
var got = temp__5735__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___100947 = arguments.length;
var i__4737__auto___100948 = (0);
while(true){
if((i__4737__auto___100948 < len__4736__auto___100947)){
args__4742__auto__.push((arguments[i__4737__auto___100948]));

var G__100949 = (i__4737__auto___100948 + (1));
i__4737__auto___100948 = G__100949;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__100944){
var map__100945 = p__100944;
var map__100945__$1 = (((((!((map__100945 == null))))?(((((map__100945.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__100945.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__100945):map__100945);
var opts = map__100945__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq100942){
var G__100943 = cljs.core.first(seq100942);
var seq100942__$1 = cljs.core.next(seq100942);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__100943,seq100942__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__100951 = arguments.length;
switch (G__100951) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__100848__auto___100997 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_100975){
var state_val_100976 = (state_100975[(1)]);
if((state_val_100976 === (7))){
var inst_100971 = (state_100975[(2)]);
var state_100975__$1 = state_100975;
var statearr_100977_100998 = state_100975__$1;
(statearr_100977_100998[(2)] = inst_100971);

(statearr_100977_100998[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100976 === (1))){
var state_100975__$1 = state_100975;
var statearr_100978_100999 = state_100975__$1;
(statearr_100978_100999[(2)] = null);

(statearr_100978_100999[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100976 === (4))){
var inst_100954 = (state_100975[(7)]);
var inst_100954__$1 = (state_100975[(2)]);
var inst_100955 = (inst_100954__$1 == null);
var state_100975__$1 = (function (){var statearr_100979 = state_100975;
(statearr_100979[(7)] = inst_100954__$1);

return statearr_100979;
})();
if(cljs.core.truth_(inst_100955)){
var statearr_100980_101000 = state_100975__$1;
(statearr_100980_101000[(1)] = (5));

} else {
var statearr_100981_101001 = state_100975__$1;
(statearr_100981_101001[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100976 === (13))){
var state_100975__$1 = state_100975;
var statearr_100982_101002 = state_100975__$1;
(statearr_100982_101002[(2)] = null);

(statearr_100982_101002[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100976 === (6))){
var inst_100954 = (state_100975[(7)]);
var state_100975__$1 = state_100975;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_100975__$1,(11),to,inst_100954);
} else {
if((state_val_100976 === (3))){
var inst_100973 = (state_100975[(2)]);
var state_100975__$1 = state_100975;
return cljs.core.async.impl.ioc_helpers.return_chan(state_100975__$1,inst_100973);
} else {
if((state_val_100976 === (12))){
var state_100975__$1 = state_100975;
var statearr_100983_101003 = state_100975__$1;
(statearr_100983_101003[(2)] = null);

(statearr_100983_101003[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100976 === (2))){
var state_100975__$1 = state_100975;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_100975__$1,(4),from);
} else {
if((state_val_100976 === (11))){
var inst_100964 = (state_100975[(2)]);
var state_100975__$1 = state_100975;
if(cljs.core.truth_(inst_100964)){
var statearr_100984_101004 = state_100975__$1;
(statearr_100984_101004[(1)] = (12));

} else {
var statearr_100985_101005 = state_100975__$1;
(statearr_100985_101005[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100976 === (9))){
var state_100975__$1 = state_100975;
var statearr_100986_101006 = state_100975__$1;
(statearr_100986_101006[(2)] = null);

(statearr_100986_101006[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100976 === (5))){
var state_100975__$1 = state_100975;
if(cljs.core.truth_(close_QMARK_)){
var statearr_100987_101007 = state_100975__$1;
(statearr_100987_101007[(1)] = (8));

} else {
var statearr_100988_101008 = state_100975__$1;
(statearr_100988_101008[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100976 === (14))){
var inst_100969 = (state_100975[(2)]);
var state_100975__$1 = state_100975;
var statearr_100989_101009 = state_100975__$1;
(statearr_100989_101009[(2)] = inst_100969);

(statearr_100989_101009[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100976 === (10))){
var inst_100961 = (state_100975[(2)]);
var state_100975__$1 = state_100975;
var statearr_100990_101010 = state_100975__$1;
(statearr_100990_101010[(2)] = inst_100961);

(statearr_100990_101010[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100976 === (8))){
var inst_100958 = cljs.core.async.close_BANG_(to);
var state_100975__$1 = state_100975;
var statearr_100991_101011 = state_100975__$1;
(statearr_100991_101011[(2)] = inst_100958);

(statearr_100991_101011[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__100742__auto__ = null;
var cljs$core$async$state_machine__100742__auto____0 = (function (){
var statearr_100992 = [null,null,null,null,null,null,null,null];
(statearr_100992[(0)] = cljs$core$async$state_machine__100742__auto__);

(statearr_100992[(1)] = (1));

return statearr_100992;
});
var cljs$core$async$state_machine__100742__auto____1 = (function (state_100975){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_100975);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e100993){if((e100993 instanceof Object)){
var ex__100745__auto__ = e100993;
var statearr_100994_101012 = state_100975;
(statearr_100994_101012[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_100975);

return cljs.core.cst$kw$recur;
} else {
throw e100993;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__101013 = state_100975;
state_100975 = G__101013;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
cljs$core$async$state_machine__100742__auto__ = function(state_100975){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__100742__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__100742__auto____1.call(this,state_100975);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__100742__auto____0;
cljs$core$async$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__100742__auto____1;
return cljs$core$async$state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_100995 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_100995[(6)] = c__100848__auto___100997);

return statearr_100995;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__101014){
var vec__101015 = p__101014;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__101015,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__101015,(1),null);
var job = vec__101015;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__100848__auto___101186 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_101022){
var state_val_101023 = (state_101022[(1)]);
if((state_val_101023 === (1))){
var state_101022__$1 = state_101022;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_101022__$1,(2),res,v);
} else {
if((state_val_101023 === (2))){
var inst_101019 = (state_101022[(2)]);
var inst_101020 = cljs.core.async.close_BANG_(res);
var state_101022__$1 = (function (){var statearr_101024 = state_101022;
(statearr_101024[(7)] = inst_101019);

return statearr_101024;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_101022__$1,inst_101020);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__100742__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__100742__auto____0 = (function (){
var statearr_101025 = [null,null,null,null,null,null,null,null];
(statearr_101025[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__100742__auto__);

(statearr_101025[(1)] = (1));

return statearr_101025;
});
var cljs$core$async$pipeline_STAR__$_state_machine__100742__auto____1 = (function (state_101022){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_101022);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e101026){if((e101026 instanceof Object)){
var ex__100745__auto__ = e101026;
var statearr_101027_101187 = state_101022;
(statearr_101027_101187[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_101022);

return cljs.core.cst$kw$recur;
} else {
throw e101026;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__101188 = state_101022;
state_101022 = G__101188;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__100742__auto__ = function(state_101022){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__100742__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__100742__auto____1.call(this,state_101022);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__100742__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__100742__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_101028 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_101028[(6)] = c__100848__auto___101186);

return statearr_101028;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__101029){
var vec__101030 = p__101029;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__101030,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__101030,(1),null);
var job = vec__101030;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4613__auto___101189 = n;
var __101190 = (0);
while(true){
if((__101190 < n__4613__auto___101189)){
var G__101033_101191 = type;
var G__101033_101192__$1 = (((G__101033_101191 instanceof cljs.core.Keyword))?G__101033_101191.fqn:null);
switch (G__101033_101192__$1) {
case "compute":
var c__100848__auto___101194 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__101190,c__100848__auto___101194,G__101033_101191,G__101033_101192__$1,n__4613__auto___101189,jobs,results,process,async){
return (function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = ((function (__101190,c__100848__auto___101194,G__101033_101191,G__101033_101192__$1,n__4613__auto___101189,jobs,results,process,async){
return (function (state_101046){
var state_val_101047 = (state_101046[(1)]);
if((state_val_101047 === (1))){
var state_101046__$1 = state_101046;
var statearr_101048_101195 = state_101046__$1;
(statearr_101048_101195[(2)] = null);

(statearr_101048_101195[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101047 === (2))){
var state_101046__$1 = state_101046;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_101046__$1,(4),jobs);
} else {
if((state_val_101047 === (3))){
var inst_101044 = (state_101046[(2)]);
var state_101046__$1 = state_101046;
return cljs.core.async.impl.ioc_helpers.return_chan(state_101046__$1,inst_101044);
} else {
if((state_val_101047 === (4))){
var inst_101036 = (state_101046[(2)]);
var inst_101037 = process(inst_101036);
var state_101046__$1 = state_101046;
if(cljs.core.truth_(inst_101037)){
var statearr_101049_101196 = state_101046__$1;
(statearr_101049_101196[(1)] = (5));

} else {
var statearr_101050_101197 = state_101046__$1;
(statearr_101050_101197[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101047 === (5))){
var state_101046__$1 = state_101046;
var statearr_101051_101198 = state_101046__$1;
(statearr_101051_101198[(2)] = null);

(statearr_101051_101198[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101047 === (6))){
var state_101046__$1 = state_101046;
var statearr_101052_101199 = state_101046__$1;
(statearr_101052_101199[(2)] = null);

(statearr_101052_101199[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101047 === (7))){
var inst_101042 = (state_101046[(2)]);
var state_101046__$1 = state_101046;
var statearr_101053_101200 = state_101046__$1;
(statearr_101053_101200[(2)] = inst_101042);

(statearr_101053_101200[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__101190,c__100848__auto___101194,G__101033_101191,G__101033_101192__$1,n__4613__auto___101189,jobs,results,process,async))
;
return ((function (__101190,switch__100741__auto__,c__100848__auto___101194,G__101033_101191,G__101033_101192__$1,n__4613__auto___101189,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__100742__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__100742__auto____0 = (function (){
var statearr_101054 = [null,null,null,null,null,null,null];
(statearr_101054[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__100742__auto__);

(statearr_101054[(1)] = (1));

return statearr_101054;
});
var cljs$core$async$pipeline_STAR__$_state_machine__100742__auto____1 = (function (state_101046){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_101046);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e101055){if((e101055 instanceof Object)){
var ex__100745__auto__ = e101055;
var statearr_101056_101201 = state_101046;
(statearr_101056_101201[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_101046);

return cljs.core.cst$kw$recur;
} else {
throw e101055;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__101202 = state_101046;
state_101046 = G__101202;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__100742__auto__ = function(state_101046){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__100742__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__100742__auto____1.call(this,state_101046);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__100742__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__100742__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__100742__auto__;
})()
;})(__101190,switch__100741__auto__,c__100848__auto___101194,G__101033_101191,G__101033_101192__$1,n__4613__auto___101189,jobs,results,process,async))
})();
var state__100850__auto__ = (function (){var statearr_101057 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_101057[(6)] = c__100848__auto___101194);

return statearr_101057;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
});})(__101190,c__100848__auto___101194,G__101033_101191,G__101033_101192__$1,n__4613__auto___101189,jobs,results,process,async))
);


break;
case "async":
var c__100848__auto___101203 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__101190,c__100848__auto___101203,G__101033_101191,G__101033_101192__$1,n__4613__auto___101189,jobs,results,process,async){
return (function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = ((function (__101190,c__100848__auto___101203,G__101033_101191,G__101033_101192__$1,n__4613__auto___101189,jobs,results,process,async){
return (function (state_101070){
var state_val_101071 = (state_101070[(1)]);
if((state_val_101071 === (1))){
var state_101070__$1 = state_101070;
var statearr_101072_101204 = state_101070__$1;
(statearr_101072_101204[(2)] = null);

(statearr_101072_101204[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101071 === (2))){
var state_101070__$1 = state_101070;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_101070__$1,(4),jobs);
} else {
if((state_val_101071 === (3))){
var inst_101068 = (state_101070[(2)]);
var state_101070__$1 = state_101070;
return cljs.core.async.impl.ioc_helpers.return_chan(state_101070__$1,inst_101068);
} else {
if((state_val_101071 === (4))){
var inst_101060 = (state_101070[(2)]);
var inst_101061 = async(inst_101060);
var state_101070__$1 = state_101070;
if(cljs.core.truth_(inst_101061)){
var statearr_101073_101205 = state_101070__$1;
(statearr_101073_101205[(1)] = (5));

} else {
var statearr_101074_101206 = state_101070__$1;
(statearr_101074_101206[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101071 === (5))){
var state_101070__$1 = state_101070;
var statearr_101075_101207 = state_101070__$1;
(statearr_101075_101207[(2)] = null);

(statearr_101075_101207[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101071 === (6))){
var state_101070__$1 = state_101070;
var statearr_101076_101208 = state_101070__$1;
(statearr_101076_101208[(2)] = null);

(statearr_101076_101208[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101071 === (7))){
var inst_101066 = (state_101070[(2)]);
var state_101070__$1 = state_101070;
var statearr_101077_101209 = state_101070__$1;
(statearr_101077_101209[(2)] = inst_101066);

(statearr_101077_101209[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__101190,c__100848__auto___101203,G__101033_101191,G__101033_101192__$1,n__4613__auto___101189,jobs,results,process,async))
;
return ((function (__101190,switch__100741__auto__,c__100848__auto___101203,G__101033_101191,G__101033_101192__$1,n__4613__auto___101189,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__100742__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__100742__auto____0 = (function (){
var statearr_101078 = [null,null,null,null,null,null,null];
(statearr_101078[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__100742__auto__);

(statearr_101078[(1)] = (1));

return statearr_101078;
});
var cljs$core$async$pipeline_STAR__$_state_machine__100742__auto____1 = (function (state_101070){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_101070);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e101079){if((e101079 instanceof Object)){
var ex__100745__auto__ = e101079;
var statearr_101080_101210 = state_101070;
(statearr_101080_101210[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_101070);

return cljs.core.cst$kw$recur;
} else {
throw e101079;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__101211 = state_101070;
state_101070 = G__101211;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__100742__auto__ = function(state_101070){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__100742__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__100742__auto____1.call(this,state_101070);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__100742__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__100742__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__100742__auto__;
})()
;})(__101190,switch__100741__auto__,c__100848__auto___101203,G__101033_101191,G__101033_101192__$1,n__4613__auto___101189,jobs,results,process,async))
})();
var state__100850__auto__ = (function (){var statearr_101081 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_101081[(6)] = c__100848__auto___101203);

return statearr_101081;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
});})(__101190,c__100848__auto___101203,G__101033_101191,G__101033_101192__$1,n__4613__auto___101189,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__101033_101192__$1)].join('')));

}

var G__101212 = (__101190 + (1));
__101190 = G__101212;
continue;
} else {
}
break;
}

var c__100848__auto___101213 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_101103){
var state_val_101104 = (state_101103[(1)]);
if((state_val_101104 === (7))){
var inst_101099 = (state_101103[(2)]);
var state_101103__$1 = state_101103;
var statearr_101105_101214 = state_101103__$1;
(statearr_101105_101214[(2)] = inst_101099);

(statearr_101105_101214[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101104 === (1))){
var state_101103__$1 = state_101103;
var statearr_101106_101215 = state_101103__$1;
(statearr_101106_101215[(2)] = null);

(statearr_101106_101215[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101104 === (4))){
var inst_101084 = (state_101103[(7)]);
var inst_101084__$1 = (state_101103[(2)]);
var inst_101085 = (inst_101084__$1 == null);
var state_101103__$1 = (function (){var statearr_101107 = state_101103;
(statearr_101107[(7)] = inst_101084__$1);

return statearr_101107;
})();
if(cljs.core.truth_(inst_101085)){
var statearr_101108_101216 = state_101103__$1;
(statearr_101108_101216[(1)] = (5));

} else {
var statearr_101109_101217 = state_101103__$1;
(statearr_101109_101217[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101104 === (6))){
var inst_101084 = (state_101103[(7)]);
var inst_101089 = (state_101103[(8)]);
var inst_101089__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_101090 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_101091 = [inst_101084,inst_101089__$1];
var inst_101092 = (new cljs.core.PersistentVector(null,2,(5),inst_101090,inst_101091,null));
var state_101103__$1 = (function (){var statearr_101110 = state_101103;
(statearr_101110[(8)] = inst_101089__$1);

return statearr_101110;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_101103__$1,(8),jobs,inst_101092);
} else {
if((state_val_101104 === (3))){
var inst_101101 = (state_101103[(2)]);
var state_101103__$1 = state_101103;
return cljs.core.async.impl.ioc_helpers.return_chan(state_101103__$1,inst_101101);
} else {
if((state_val_101104 === (2))){
var state_101103__$1 = state_101103;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_101103__$1,(4),from);
} else {
if((state_val_101104 === (9))){
var inst_101096 = (state_101103[(2)]);
var state_101103__$1 = (function (){var statearr_101111 = state_101103;
(statearr_101111[(9)] = inst_101096);

return statearr_101111;
})();
var statearr_101112_101218 = state_101103__$1;
(statearr_101112_101218[(2)] = null);

(statearr_101112_101218[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101104 === (5))){
var inst_101087 = cljs.core.async.close_BANG_(jobs);
var state_101103__$1 = state_101103;
var statearr_101113_101219 = state_101103__$1;
(statearr_101113_101219[(2)] = inst_101087);

(statearr_101113_101219[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101104 === (8))){
var inst_101089 = (state_101103[(8)]);
var inst_101094 = (state_101103[(2)]);
var state_101103__$1 = (function (){var statearr_101114 = state_101103;
(statearr_101114[(10)] = inst_101094);

return statearr_101114;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_101103__$1,(9),results,inst_101089);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__100742__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__100742__auto____0 = (function (){
var statearr_101115 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_101115[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__100742__auto__);

(statearr_101115[(1)] = (1));

return statearr_101115;
});
var cljs$core$async$pipeline_STAR__$_state_machine__100742__auto____1 = (function (state_101103){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_101103);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e101116){if((e101116 instanceof Object)){
var ex__100745__auto__ = e101116;
var statearr_101117_101220 = state_101103;
(statearr_101117_101220[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_101103);

return cljs.core.cst$kw$recur;
} else {
throw e101116;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__101221 = state_101103;
state_101103 = G__101221;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__100742__auto__ = function(state_101103){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__100742__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__100742__auto____1.call(this,state_101103);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__100742__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__100742__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_101118 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_101118[(6)] = c__100848__auto___101213);

return statearr_101118;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));


var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_101156){
var state_val_101157 = (state_101156[(1)]);
if((state_val_101157 === (7))){
var inst_101152 = (state_101156[(2)]);
var state_101156__$1 = state_101156;
var statearr_101158_101222 = state_101156__$1;
(statearr_101158_101222[(2)] = inst_101152);

(statearr_101158_101222[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101157 === (20))){
var state_101156__$1 = state_101156;
var statearr_101159_101223 = state_101156__$1;
(statearr_101159_101223[(2)] = null);

(statearr_101159_101223[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101157 === (1))){
var state_101156__$1 = state_101156;
var statearr_101160_101224 = state_101156__$1;
(statearr_101160_101224[(2)] = null);

(statearr_101160_101224[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101157 === (4))){
var inst_101121 = (state_101156[(7)]);
var inst_101121__$1 = (state_101156[(2)]);
var inst_101122 = (inst_101121__$1 == null);
var state_101156__$1 = (function (){var statearr_101161 = state_101156;
(statearr_101161[(7)] = inst_101121__$1);

return statearr_101161;
})();
if(cljs.core.truth_(inst_101122)){
var statearr_101162_101225 = state_101156__$1;
(statearr_101162_101225[(1)] = (5));

} else {
var statearr_101163_101226 = state_101156__$1;
(statearr_101163_101226[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101157 === (15))){
var inst_101134 = (state_101156[(8)]);
var state_101156__$1 = state_101156;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_101156__$1,(18),to,inst_101134);
} else {
if((state_val_101157 === (21))){
var inst_101147 = (state_101156[(2)]);
var state_101156__$1 = state_101156;
var statearr_101164_101227 = state_101156__$1;
(statearr_101164_101227[(2)] = inst_101147);

(statearr_101164_101227[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101157 === (13))){
var inst_101149 = (state_101156[(2)]);
var state_101156__$1 = (function (){var statearr_101165 = state_101156;
(statearr_101165[(9)] = inst_101149);

return statearr_101165;
})();
var statearr_101166_101228 = state_101156__$1;
(statearr_101166_101228[(2)] = null);

(statearr_101166_101228[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101157 === (6))){
var inst_101121 = (state_101156[(7)]);
var state_101156__$1 = state_101156;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_101156__$1,(11),inst_101121);
} else {
if((state_val_101157 === (17))){
var inst_101142 = (state_101156[(2)]);
var state_101156__$1 = state_101156;
if(cljs.core.truth_(inst_101142)){
var statearr_101167_101229 = state_101156__$1;
(statearr_101167_101229[(1)] = (19));

} else {
var statearr_101168_101230 = state_101156__$1;
(statearr_101168_101230[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101157 === (3))){
var inst_101154 = (state_101156[(2)]);
var state_101156__$1 = state_101156;
return cljs.core.async.impl.ioc_helpers.return_chan(state_101156__$1,inst_101154);
} else {
if((state_val_101157 === (12))){
var inst_101131 = (state_101156[(10)]);
var state_101156__$1 = state_101156;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_101156__$1,(14),inst_101131);
} else {
if((state_val_101157 === (2))){
var state_101156__$1 = state_101156;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_101156__$1,(4),results);
} else {
if((state_val_101157 === (19))){
var state_101156__$1 = state_101156;
var statearr_101169_101231 = state_101156__$1;
(statearr_101169_101231[(2)] = null);

(statearr_101169_101231[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101157 === (11))){
var inst_101131 = (state_101156[(2)]);
var state_101156__$1 = (function (){var statearr_101170 = state_101156;
(statearr_101170[(10)] = inst_101131);

return statearr_101170;
})();
var statearr_101171_101232 = state_101156__$1;
(statearr_101171_101232[(2)] = null);

(statearr_101171_101232[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101157 === (9))){
var state_101156__$1 = state_101156;
var statearr_101172_101233 = state_101156__$1;
(statearr_101172_101233[(2)] = null);

(statearr_101172_101233[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101157 === (5))){
var state_101156__$1 = state_101156;
if(cljs.core.truth_(close_QMARK_)){
var statearr_101173_101234 = state_101156__$1;
(statearr_101173_101234[(1)] = (8));

} else {
var statearr_101174_101235 = state_101156__$1;
(statearr_101174_101235[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101157 === (14))){
var inst_101134 = (state_101156[(8)]);
var inst_101134__$1 = (state_101156[(2)]);
var inst_101135 = (inst_101134__$1 == null);
var inst_101136 = cljs.core.not(inst_101135);
var state_101156__$1 = (function (){var statearr_101175 = state_101156;
(statearr_101175[(8)] = inst_101134__$1);

return statearr_101175;
})();
if(inst_101136){
var statearr_101176_101236 = state_101156__$1;
(statearr_101176_101236[(1)] = (15));

} else {
var statearr_101177_101237 = state_101156__$1;
(statearr_101177_101237[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101157 === (16))){
var state_101156__$1 = state_101156;
var statearr_101178_101238 = state_101156__$1;
(statearr_101178_101238[(2)] = false);

(statearr_101178_101238[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101157 === (10))){
var inst_101128 = (state_101156[(2)]);
var state_101156__$1 = state_101156;
var statearr_101179_101239 = state_101156__$1;
(statearr_101179_101239[(2)] = inst_101128);

(statearr_101179_101239[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101157 === (18))){
var inst_101139 = (state_101156[(2)]);
var state_101156__$1 = state_101156;
var statearr_101180_101240 = state_101156__$1;
(statearr_101180_101240[(2)] = inst_101139);

(statearr_101180_101240[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101157 === (8))){
var inst_101125 = cljs.core.async.close_BANG_(to);
var state_101156__$1 = state_101156;
var statearr_101181_101241 = state_101156__$1;
(statearr_101181_101241[(2)] = inst_101125);

(statearr_101181_101241[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__100742__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__100742__auto____0 = (function (){
var statearr_101182 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_101182[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__100742__auto__);

(statearr_101182[(1)] = (1));

return statearr_101182;
});
var cljs$core$async$pipeline_STAR__$_state_machine__100742__auto____1 = (function (state_101156){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_101156);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e101183){if((e101183 instanceof Object)){
var ex__100745__auto__ = e101183;
var statearr_101184_101242 = state_101156;
(statearr_101184_101242[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_101156);

return cljs.core.cst$kw$recur;
} else {
throw e101183;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__101243 = state_101156;
state_101156 = G__101243;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__100742__auto__ = function(state_101156){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__100742__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__100742__auto____1.call(this,state_101156);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__100742__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__100742__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_101185 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_101185[(6)] = c__100848__auto__);

return statearr_101185;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__101245 = arguments.length;
switch (G__101245) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.cst$kw$async);
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__101248 = arguments.length;
switch (G__101248) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.cst$kw$compute);
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__101251 = arguments.length;
switch (G__101251) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__100848__auto___101300 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_101277){
var state_val_101278 = (state_101277[(1)]);
if((state_val_101278 === (7))){
var inst_101273 = (state_101277[(2)]);
var state_101277__$1 = state_101277;
var statearr_101279_101301 = state_101277__$1;
(statearr_101279_101301[(2)] = inst_101273);

(statearr_101279_101301[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101278 === (1))){
var state_101277__$1 = state_101277;
var statearr_101280_101302 = state_101277__$1;
(statearr_101280_101302[(2)] = null);

(statearr_101280_101302[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101278 === (4))){
var inst_101254 = (state_101277[(7)]);
var inst_101254__$1 = (state_101277[(2)]);
var inst_101255 = (inst_101254__$1 == null);
var state_101277__$1 = (function (){var statearr_101281 = state_101277;
(statearr_101281[(7)] = inst_101254__$1);

return statearr_101281;
})();
if(cljs.core.truth_(inst_101255)){
var statearr_101282_101303 = state_101277__$1;
(statearr_101282_101303[(1)] = (5));

} else {
var statearr_101283_101304 = state_101277__$1;
(statearr_101283_101304[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101278 === (13))){
var state_101277__$1 = state_101277;
var statearr_101284_101305 = state_101277__$1;
(statearr_101284_101305[(2)] = null);

(statearr_101284_101305[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101278 === (6))){
var inst_101254 = (state_101277[(7)]);
var inst_101260 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_101254) : p.call(null,inst_101254));
var state_101277__$1 = state_101277;
if(cljs.core.truth_(inst_101260)){
var statearr_101285_101306 = state_101277__$1;
(statearr_101285_101306[(1)] = (9));

} else {
var statearr_101286_101307 = state_101277__$1;
(statearr_101286_101307[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101278 === (3))){
var inst_101275 = (state_101277[(2)]);
var state_101277__$1 = state_101277;
return cljs.core.async.impl.ioc_helpers.return_chan(state_101277__$1,inst_101275);
} else {
if((state_val_101278 === (12))){
var state_101277__$1 = state_101277;
var statearr_101287_101308 = state_101277__$1;
(statearr_101287_101308[(2)] = null);

(statearr_101287_101308[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101278 === (2))){
var state_101277__$1 = state_101277;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_101277__$1,(4),ch);
} else {
if((state_val_101278 === (11))){
var inst_101254 = (state_101277[(7)]);
var inst_101264 = (state_101277[(2)]);
var state_101277__$1 = state_101277;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_101277__$1,(8),inst_101264,inst_101254);
} else {
if((state_val_101278 === (9))){
var state_101277__$1 = state_101277;
var statearr_101288_101309 = state_101277__$1;
(statearr_101288_101309[(2)] = tc);

(statearr_101288_101309[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101278 === (5))){
var inst_101257 = cljs.core.async.close_BANG_(tc);
var inst_101258 = cljs.core.async.close_BANG_(fc);
var state_101277__$1 = (function (){var statearr_101289 = state_101277;
(statearr_101289[(8)] = inst_101257);

return statearr_101289;
})();
var statearr_101290_101310 = state_101277__$1;
(statearr_101290_101310[(2)] = inst_101258);

(statearr_101290_101310[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101278 === (14))){
var inst_101271 = (state_101277[(2)]);
var state_101277__$1 = state_101277;
var statearr_101291_101311 = state_101277__$1;
(statearr_101291_101311[(2)] = inst_101271);

(statearr_101291_101311[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101278 === (10))){
var state_101277__$1 = state_101277;
var statearr_101292_101312 = state_101277__$1;
(statearr_101292_101312[(2)] = fc);

(statearr_101292_101312[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101278 === (8))){
var inst_101266 = (state_101277[(2)]);
var state_101277__$1 = state_101277;
if(cljs.core.truth_(inst_101266)){
var statearr_101293_101313 = state_101277__$1;
(statearr_101293_101313[(1)] = (12));

} else {
var statearr_101294_101314 = state_101277__$1;
(statearr_101294_101314[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__100742__auto__ = null;
var cljs$core$async$state_machine__100742__auto____0 = (function (){
var statearr_101295 = [null,null,null,null,null,null,null,null,null];
(statearr_101295[(0)] = cljs$core$async$state_machine__100742__auto__);

(statearr_101295[(1)] = (1));

return statearr_101295;
});
var cljs$core$async$state_machine__100742__auto____1 = (function (state_101277){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_101277);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e101296){if((e101296 instanceof Object)){
var ex__100745__auto__ = e101296;
var statearr_101297_101315 = state_101277;
(statearr_101297_101315[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_101277);

return cljs.core.cst$kw$recur;
} else {
throw e101296;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__101316 = state_101277;
state_101277 = G__101316;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
cljs$core$async$state_machine__100742__auto__ = function(state_101277){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__100742__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__100742__auto____1.call(this,state_101277);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__100742__auto____0;
cljs$core$async$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__100742__auto____1;
return cljs$core$async$state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_101298 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_101298[(6)] = c__100848__auto___101300);

return statearr_101298;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_101337){
var state_val_101338 = (state_101337[(1)]);
if((state_val_101338 === (7))){
var inst_101333 = (state_101337[(2)]);
var state_101337__$1 = state_101337;
var statearr_101339_101357 = state_101337__$1;
(statearr_101339_101357[(2)] = inst_101333);

(statearr_101339_101357[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101338 === (1))){
var inst_101317 = init;
var state_101337__$1 = (function (){var statearr_101340 = state_101337;
(statearr_101340[(7)] = inst_101317);

return statearr_101340;
})();
var statearr_101341_101358 = state_101337__$1;
(statearr_101341_101358[(2)] = null);

(statearr_101341_101358[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101338 === (4))){
var inst_101320 = (state_101337[(8)]);
var inst_101320__$1 = (state_101337[(2)]);
var inst_101321 = (inst_101320__$1 == null);
var state_101337__$1 = (function (){var statearr_101342 = state_101337;
(statearr_101342[(8)] = inst_101320__$1);

return statearr_101342;
})();
if(cljs.core.truth_(inst_101321)){
var statearr_101343_101359 = state_101337__$1;
(statearr_101343_101359[(1)] = (5));

} else {
var statearr_101344_101360 = state_101337__$1;
(statearr_101344_101360[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101338 === (6))){
var inst_101317 = (state_101337[(7)]);
var inst_101324 = (state_101337[(9)]);
var inst_101320 = (state_101337[(8)]);
var inst_101324__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_101317,inst_101320) : f.call(null,inst_101317,inst_101320));
var inst_101325 = cljs.core.reduced_QMARK_(inst_101324__$1);
var state_101337__$1 = (function (){var statearr_101345 = state_101337;
(statearr_101345[(9)] = inst_101324__$1);

return statearr_101345;
})();
if(inst_101325){
var statearr_101346_101361 = state_101337__$1;
(statearr_101346_101361[(1)] = (8));

} else {
var statearr_101347_101362 = state_101337__$1;
(statearr_101347_101362[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101338 === (3))){
var inst_101335 = (state_101337[(2)]);
var state_101337__$1 = state_101337;
return cljs.core.async.impl.ioc_helpers.return_chan(state_101337__$1,inst_101335);
} else {
if((state_val_101338 === (2))){
var state_101337__$1 = state_101337;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_101337__$1,(4),ch);
} else {
if((state_val_101338 === (9))){
var inst_101324 = (state_101337[(9)]);
var inst_101317 = inst_101324;
var state_101337__$1 = (function (){var statearr_101348 = state_101337;
(statearr_101348[(7)] = inst_101317);

return statearr_101348;
})();
var statearr_101349_101363 = state_101337__$1;
(statearr_101349_101363[(2)] = null);

(statearr_101349_101363[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101338 === (5))){
var inst_101317 = (state_101337[(7)]);
var state_101337__$1 = state_101337;
var statearr_101350_101364 = state_101337__$1;
(statearr_101350_101364[(2)] = inst_101317);

(statearr_101350_101364[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101338 === (10))){
var inst_101331 = (state_101337[(2)]);
var state_101337__$1 = state_101337;
var statearr_101351_101365 = state_101337__$1;
(statearr_101351_101365[(2)] = inst_101331);

(statearr_101351_101365[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101338 === (8))){
var inst_101324 = (state_101337[(9)]);
var inst_101327 = cljs.core.deref(inst_101324);
var state_101337__$1 = state_101337;
var statearr_101352_101366 = state_101337__$1;
(statearr_101352_101366[(2)] = inst_101327);

(statearr_101352_101366[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__100742__auto__ = null;
var cljs$core$async$reduce_$_state_machine__100742__auto____0 = (function (){
var statearr_101353 = [null,null,null,null,null,null,null,null,null,null];
(statearr_101353[(0)] = cljs$core$async$reduce_$_state_machine__100742__auto__);

(statearr_101353[(1)] = (1));

return statearr_101353;
});
var cljs$core$async$reduce_$_state_machine__100742__auto____1 = (function (state_101337){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_101337);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e101354){if((e101354 instanceof Object)){
var ex__100745__auto__ = e101354;
var statearr_101355_101367 = state_101337;
(statearr_101355_101367[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_101337);

return cljs.core.cst$kw$recur;
} else {
throw e101354;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__101368 = state_101337;
state_101337 = G__101368;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__100742__auto__ = function(state_101337){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__100742__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__100742__auto____1.call(this,state_101337);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__100742__auto____0;
cljs$core$async$reduce_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__100742__auto____1;
return cljs$core$async$reduce_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_101356 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_101356[(6)] = c__100848__auto__);

return statearr_101356;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_101374){
var state_val_101375 = (state_101374[(1)]);
if((state_val_101375 === (1))){
var inst_101369 = cljs.core.async.reduce(f__$1,init,ch);
var state_101374__$1 = state_101374;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_101374__$1,(2),inst_101369);
} else {
if((state_val_101375 === (2))){
var inst_101371 = (state_101374[(2)]);
var inst_101372 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_101371) : f__$1.call(null,inst_101371));
var state_101374__$1 = state_101374;
return cljs.core.async.impl.ioc_helpers.return_chan(state_101374__$1,inst_101372);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__100742__auto__ = null;
var cljs$core$async$transduce_$_state_machine__100742__auto____0 = (function (){
var statearr_101376 = [null,null,null,null,null,null,null];
(statearr_101376[(0)] = cljs$core$async$transduce_$_state_machine__100742__auto__);

(statearr_101376[(1)] = (1));

return statearr_101376;
});
var cljs$core$async$transduce_$_state_machine__100742__auto____1 = (function (state_101374){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_101374);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e101377){if((e101377 instanceof Object)){
var ex__100745__auto__ = e101377;
var statearr_101378_101380 = state_101374;
(statearr_101378_101380[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_101374);

return cljs.core.cst$kw$recur;
} else {
throw e101377;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__101381 = state_101374;
state_101374 = G__101381;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__100742__auto__ = function(state_101374){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__100742__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__100742__auto____1.call(this,state_101374);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__100742__auto____0;
cljs$core$async$transduce_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__100742__auto____1;
return cljs$core$async$transduce_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_101379 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_101379[(6)] = c__100848__auto__);

return statearr_101379;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__101383 = arguments.length;
switch (G__101383) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_101408){
var state_val_101409 = (state_101408[(1)]);
if((state_val_101409 === (7))){
var inst_101390 = (state_101408[(2)]);
var state_101408__$1 = state_101408;
var statearr_101410_101431 = state_101408__$1;
(statearr_101410_101431[(2)] = inst_101390);

(statearr_101410_101431[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101409 === (1))){
var inst_101384 = cljs.core.seq(coll);
var inst_101385 = inst_101384;
var state_101408__$1 = (function (){var statearr_101411 = state_101408;
(statearr_101411[(7)] = inst_101385);

return statearr_101411;
})();
var statearr_101412_101432 = state_101408__$1;
(statearr_101412_101432[(2)] = null);

(statearr_101412_101432[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101409 === (4))){
var inst_101385 = (state_101408[(7)]);
var inst_101388 = cljs.core.first(inst_101385);
var state_101408__$1 = state_101408;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_101408__$1,(7),ch,inst_101388);
} else {
if((state_val_101409 === (13))){
var inst_101402 = (state_101408[(2)]);
var state_101408__$1 = state_101408;
var statearr_101413_101433 = state_101408__$1;
(statearr_101413_101433[(2)] = inst_101402);

(statearr_101413_101433[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101409 === (6))){
var inst_101393 = (state_101408[(2)]);
var state_101408__$1 = state_101408;
if(cljs.core.truth_(inst_101393)){
var statearr_101414_101434 = state_101408__$1;
(statearr_101414_101434[(1)] = (8));

} else {
var statearr_101415_101435 = state_101408__$1;
(statearr_101415_101435[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101409 === (3))){
var inst_101406 = (state_101408[(2)]);
var state_101408__$1 = state_101408;
return cljs.core.async.impl.ioc_helpers.return_chan(state_101408__$1,inst_101406);
} else {
if((state_val_101409 === (12))){
var state_101408__$1 = state_101408;
var statearr_101416_101436 = state_101408__$1;
(statearr_101416_101436[(2)] = null);

(statearr_101416_101436[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101409 === (2))){
var inst_101385 = (state_101408[(7)]);
var state_101408__$1 = state_101408;
if(cljs.core.truth_(inst_101385)){
var statearr_101417_101437 = state_101408__$1;
(statearr_101417_101437[(1)] = (4));

} else {
var statearr_101418_101438 = state_101408__$1;
(statearr_101418_101438[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101409 === (11))){
var inst_101399 = cljs.core.async.close_BANG_(ch);
var state_101408__$1 = state_101408;
var statearr_101419_101439 = state_101408__$1;
(statearr_101419_101439[(2)] = inst_101399);

(statearr_101419_101439[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101409 === (9))){
var state_101408__$1 = state_101408;
if(cljs.core.truth_(close_QMARK_)){
var statearr_101420_101440 = state_101408__$1;
(statearr_101420_101440[(1)] = (11));

} else {
var statearr_101421_101441 = state_101408__$1;
(statearr_101421_101441[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101409 === (5))){
var inst_101385 = (state_101408[(7)]);
var state_101408__$1 = state_101408;
var statearr_101422_101442 = state_101408__$1;
(statearr_101422_101442[(2)] = inst_101385);

(statearr_101422_101442[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101409 === (10))){
var inst_101404 = (state_101408[(2)]);
var state_101408__$1 = state_101408;
var statearr_101423_101443 = state_101408__$1;
(statearr_101423_101443[(2)] = inst_101404);

(statearr_101423_101443[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101409 === (8))){
var inst_101385 = (state_101408[(7)]);
var inst_101395 = cljs.core.next(inst_101385);
var inst_101385__$1 = inst_101395;
var state_101408__$1 = (function (){var statearr_101424 = state_101408;
(statearr_101424[(7)] = inst_101385__$1);

return statearr_101424;
})();
var statearr_101425_101444 = state_101408__$1;
(statearr_101425_101444[(2)] = null);

(statearr_101425_101444[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__100742__auto__ = null;
var cljs$core$async$state_machine__100742__auto____0 = (function (){
var statearr_101426 = [null,null,null,null,null,null,null,null];
(statearr_101426[(0)] = cljs$core$async$state_machine__100742__auto__);

(statearr_101426[(1)] = (1));

return statearr_101426;
});
var cljs$core$async$state_machine__100742__auto____1 = (function (state_101408){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_101408);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e101427){if((e101427 instanceof Object)){
var ex__100745__auto__ = e101427;
var statearr_101428_101445 = state_101408;
(statearr_101428_101445[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_101408);

return cljs.core.cst$kw$recur;
} else {
throw e101427;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__101446 = state_101408;
state_101408 = G__101446;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
cljs$core$async$state_machine__100742__auto__ = function(state_101408){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__100742__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__100742__auto____1.call(this,state_101408);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__100742__auto____0;
cljs$core$async$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__100742__auto____1;
return cljs$core$async$state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_101429 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_101429[(6)] = c__100848__auto__);

return statearr_101429;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_101447 = (function (_){
var x__4428__auto__ = (((_ == null))?null:_);
var m__4429__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4429__auto__.call(null,_));
} else {
var m__4426__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4426__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_101447(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_101448 = (function (m,ch,close_QMARK_){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4429__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4426__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_101448(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_101449 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_101449(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_101450 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_101450(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async101451 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async101451 = (function (ch,cs,meta101452){
this.ch = ch;
this.cs = cs;
this.meta101452 = meta101452;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async101451.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_101453,meta101452__$1){
var self__ = this;
var _101453__$1 = this;
return (new cljs.core.async.t_cljs$core$async101451(self__.ch,self__.cs,meta101452__$1));
}));

(cljs.core.async.t_cljs$core$async101451.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_101453){
var self__ = this;
var _101453__$1 = this;
return self__.meta101452;
}));

(cljs.core.async.t_cljs$core$async101451.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async101451.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async101451.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async101451.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async101451.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async101451.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async101451.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$cs,cljs.core.cst$sym$meta101452], null);
}));

(cljs.core.async.t_cljs$core$async101451.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async101451.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async101451");

(cljs.core.async.t_cljs$core$async101451.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async101451");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async101451.
 */
cljs.core.async.__GT_t_cljs$core$async101451 = (function cljs$core$async$mult_$___GT_t_cljs$core$async101451(ch__$1,cs__$1,meta101452){
return (new cljs.core.async.t_cljs$core$async101451(ch__$1,cs__$1,meta101452));
});

}

return (new cljs.core.async.t_cljs$core$async101451(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__100848__auto___101673 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_101588){
var state_val_101589 = (state_101588[(1)]);
if((state_val_101589 === (7))){
var inst_101584 = (state_101588[(2)]);
var state_101588__$1 = state_101588;
var statearr_101590_101674 = state_101588__$1;
(statearr_101590_101674[(2)] = inst_101584);

(statearr_101590_101674[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101589 === (20))){
var inst_101487 = (state_101588[(7)]);
var inst_101499 = cljs.core.first(inst_101487);
var inst_101500 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_101499,(0),null);
var inst_101501 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_101499,(1),null);
var state_101588__$1 = (function (){var statearr_101591 = state_101588;
(statearr_101591[(8)] = inst_101500);

return statearr_101591;
})();
if(cljs.core.truth_(inst_101501)){
var statearr_101592_101675 = state_101588__$1;
(statearr_101592_101675[(1)] = (22));

} else {
var statearr_101593_101676 = state_101588__$1;
(statearr_101593_101676[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101589 === (27))){
var inst_101529 = (state_101588[(9)]);
var inst_101531 = (state_101588[(10)]);
var inst_101536 = (state_101588[(11)]);
var inst_101456 = (state_101588[(12)]);
var inst_101536__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_101529,inst_101531);
var inst_101537 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_101536__$1,inst_101456,done);
var state_101588__$1 = (function (){var statearr_101594 = state_101588;
(statearr_101594[(11)] = inst_101536__$1);

return statearr_101594;
})();
if(cljs.core.truth_(inst_101537)){
var statearr_101595_101677 = state_101588__$1;
(statearr_101595_101677[(1)] = (30));

} else {
var statearr_101596_101678 = state_101588__$1;
(statearr_101596_101678[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101589 === (1))){
var state_101588__$1 = state_101588;
var statearr_101597_101679 = state_101588__$1;
(statearr_101597_101679[(2)] = null);

(statearr_101597_101679[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101589 === (24))){
var inst_101487 = (state_101588[(7)]);
var inst_101506 = (state_101588[(2)]);
var inst_101507 = cljs.core.next(inst_101487);
var inst_101465 = inst_101507;
var inst_101466 = null;
var inst_101467 = (0);
var inst_101468 = (0);
var state_101588__$1 = (function (){var statearr_101598 = state_101588;
(statearr_101598[(13)] = inst_101468);

(statearr_101598[(14)] = inst_101466);

(statearr_101598[(15)] = inst_101506);

(statearr_101598[(16)] = inst_101467);

(statearr_101598[(17)] = inst_101465);

return statearr_101598;
})();
var statearr_101599_101680 = state_101588__$1;
(statearr_101599_101680[(2)] = null);

(statearr_101599_101680[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101589 === (39))){
var state_101588__$1 = state_101588;
var statearr_101603_101681 = state_101588__$1;
(statearr_101603_101681[(2)] = null);

(statearr_101603_101681[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101589 === (4))){
var inst_101456 = (state_101588[(12)]);
var inst_101456__$1 = (state_101588[(2)]);
var inst_101457 = (inst_101456__$1 == null);
var state_101588__$1 = (function (){var statearr_101604 = state_101588;
(statearr_101604[(12)] = inst_101456__$1);

return statearr_101604;
})();
if(cljs.core.truth_(inst_101457)){
var statearr_101605_101682 = state_101588__$1;
(statearr_101605_101682[(1)] = (5));

} else {
var statearr_101606_101683 = state_101588__$1;
(statearr_101606_101683[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101589 === (15))){
var inst_101468 = (state_101588[(13)]);
var inst_101466 = (state_101588[(14)]);
var inst_101467 = (state_101588[(16)]);
var inst_101465 = (state_101588[(17)]);
var inst_101483 = (state_101588[(2)]);
var inst_101484 = (inst_101468 + (1));
var tmp101600 = inst_101466;
var tmp101601 = inst_101467;
var tmp101602 = inst_101465;
var inst_101465__$1 = tmp101602;
var inst_101466__$1 = tmp101600;
var inst_101467__$1 = tmp101601;
var inst_101468__$1 = inst_101484;
var state_101588__$1 = (function (){var statearr_101607 = state_101588;
(statearr_101607[(13)] = inst_101468__$1);

(statearr_101607[(18)] = inst_101483);

(statearr_101607[(14)] = inst_101466__$1);

(statearr_101607[(16)] = inst_101467__$1);

(statearr_101607[(17)] = inst_101465__$1);

return statearr_101607;
})();
var statearr_101608_101684 = state_101588__$1;
(statearr_101608_101684[(2)] = null);

(statearr_101608_101684[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101589 === (21))){
var inst_101510 = (state_101588[(2)]);
var state_101588__$1 = state_101588;
var statearr_101612_101685 = state_101588__$1;
(statearr_101612_101685[(2)] = inst_101510);

(statearr_101612_101685[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101589 === (31))){
var inst_101536 = (state_101588[(11)]);
var inst_101540 = done(null);
var inst_101541 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_101536);
var state_101588__$1 = (function (){var statearr_101613 = state_101588;
(statearr_101613[(19)] = inst_101540);

return statearr_101613;
})();
var statearr_101614_101686 = state_101588__$1;
(statearr_101614_101686[(2)] = inst_101541);

(statearr_101614_101686[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101589 === (32))){
var inst_101529 = (state_101588[(9)]);
var inst_101531 = (state_101588[(10)]);
var inst_101528 = (state_101588[(20)]);
var inst_101530 = (state_101588[(21)]);
var inst_101543 = (state_101588[(2)]);
var inst_101544 = (inst_101531 + (1));
var tmp101609 = inst_101529;
var tmp101610 = inst_101528;
var tmp101611 = inst_101530;
var inst_101528__$1 = tmp101610;
var inst_101529__$1 = tmp101609;
var inst_101530__$1 = tmp101611;
var inst_101531__$1 = inst_101544;
var state_101588__$1 = (function (){var statearr_101615 = state_101588;
(statearr_101615[(9)] = inst_101529__$1);

(statearr_101615[(10)] = inst_101531__$1);

(statearr_101615[(22)] = inst_101543);

(statearr_101615[(20)] = inst_101528__$1);

(statearr_101615[(21)] = inst_101530__$1);

return statearr_101615;
})();
var statearr_101616_101687 = state_101588__$1;
(statearr_101616_101687[(2)] = null);

(statearr_101616_101687[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101589 === (40))){
var inst_101556 = (state_101588[(23)]);
var inst_101560 = done(null);
var inst_101561 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_101556);
var state_101588__$1 = (function (){var statearr_101617 = state_101588;
(statearr_101617[(24)] = inst_101560);

return statearr_101617;
})();
var statearr_101618_101688 = state_101588__$1;
(statearr_101618_101688[(2)] = inst_101561);

(statearr_101618_101688[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101589 === (33))){
var inst_101547 = (state_101588[(25)]);
var inst_101549 = cljs.core.chunked_seq_QMARK_(inst_101547);
var state_101588__$1 = state_101588;
if(inst_101549){
var statearr_101619_101689 = state_101588__$1;
(statearr_101619_101689[(1)] = (36));

} else {
var statearr_101620_101690 = state_101588__$1;
(statearr_101620_101690[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101589 === (13))){
var inst_101477 = (state_101588[(26)]);
var inst_101480 = cljs.core.async.close_BANG_(inst_101477);
var state_101588__$1 = state_101588;
var statearr_101621_101691 = state_101588__$1;
(statearr_101621_101691[(2)] = inst_101480);

(statearr_101621_101691[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101589 === (22))){
var inst_101500 = (state_101588[(8)]);
var inst_101503 = cljs.core.async.close_BANG_(inst_101500);
var state_101588__$1 = state_101588;
var statearr_101622_101692 = state_101588__$1;
(statearr_101622_101692[(2)] = inst_101503);

(statearr_101622_101692[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101589 === (36))){
var inst_101547 = (state_101588[(25)]);
var inst_101551 = cljs.core.chunk_first(inst_101547);
var inst_101552 = cljs.core.chunk_rest(inst_101547);
var inst_101553 = cljs.core.count(inst_101551);
var inst_101528 = inst_101552;
var inst_101529 = inst_101551;
var inst_101530 = inst_101553;
var inst_101531 = (0);
var state_101588__$1 = (function (){var statearr_101623 = state_101588;
(statearr_101623[(9)] = inst_101529);

(statearr_101623[(10)] = inst_101531);

(statearr_101623[(20)] = inst_101528);

(statearr_101623[(21)] = inst_101530);

return statearr_101623;
})();
var statearr_101624_101693 = state_101588__$1;
(statearr_101624_101693[(2)] = null);

(statearr_101624_101693[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101589 === (41))){
var inst_101547 = (state_101588[(25)]);
var inst_101563 = (state_101588[(2)]);
var inst_101564 = cljs.core.next(inst_101547);
var inst_101528 = inst_101564;
var inst_101529 = null;
var inst_101530 = (0);
var inst_101531 = (0);
var state_101588__$1 = (function (){var statearr_101625 = state_101588;
(statearr_101625[(9)] = inst_101529);

(statearr_101625[(27)] = inst_101563);

(statearr_101625[(10)] = inst_101531);

(statearr_101625[(20)] = inst_101528);

(statearr_101625[(21)] = inst_101530);

return statearr_101625;
})();
var statearr_101626_101694 = state_101588__$1;
(statearr_101626_101694[(2)] = null);

(statearr_101626_101694[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101589 === (43))){
var state_101588__$1 = state_101588;
var statearr_101627_101695 = state_101588__$1;
(statearr_101627_101695[(2)] = null);

(statearr_101627_101695[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101589 === (29))){
var inst_101572 = (state_101588[(2)]);
var state_101588__$1 = state_101588;
var statearr_101628_101696 = state_101588__$1;
(statearr_101628_101696[(2)] = inst_101572);

(statearr_101628_101696[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101589 === (44))){
var inst_101581 = (state_101588[(2)]);
var state_101588__$1 = (function (){var statearr_101629 = state_101588;
(statearr_101629[(28)] = inst_101581);

return statearr_101629;
})();
var statearr_101630_101697 = state_101588__$1;
(statearr_101630_101697[(2)] = null);

(statearr_101630_101697[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101589 === (6))){
var inst_101520 = (state_101588[(29)]);
var inst_101519 = cljs.core.deref(cs);
var inst_101520__$1 = cljs.core.keys(inst_101519);
var inst_101521 = cljs.core.count(inst_101520__$1);
var inst_101522 = cljs.core.reset_BANG_(dctr,inst_101521);
var inst_101527 = cljs.core.seq(inst_101520__$1);
var inst_101528 = inst_101527;
var inst_101529 = null;
var inst_101530 = (0);
var inst_101531 = (0);
var state_101588__$1 = (function (){var statearr_101631 = state_101588;
(statearr_101631[(30)] = inst_101522);

(statearr_101631[(29)] = inst_101520__$1);

(statearr_101631[(9)] = inst_101529);

(statearr_101631[(10)] = inst_101531);

(statearr_101631[(20)] = inst_101528);

(statearr_101631[(21)] = inst_101530);

return statearr_101631;
})();
var statearr_101632_101698 = state_101588__$1;
(statearr_101632_101698[(2)] = null);

(statearr_101632_101698[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101589 === (28))){
var inst_101547 = (state_101588[(25)]);
var inst_101528 = (state_101588[(20)]);
var inst_101547__$1 = cljs.core.seq(inst_101528);
var state_101588__$1 = (function (){var statearr_101633 = state_101588;
(statearr_101633[(25)] = inst_101547__$1);

return statearr_101633;
})();
if(inst_101547__$1){
var statearr_101634_101699 = state_101588__$1;
(statearr_101634_101699[(1)] = (33));

} else {
var statearr_101635_101700 = state_101588__$1;
(statearr_101635_101700[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101589 === (25))){
var inst_101531 = (state_101588[(10)]);
var inst_101530 = (state_101588[(21)]);
var inst_101533 = (inst_101531 < inst_101530);
var inst_101534 = inst_101533;
var state_101588__$1 = state_101588;
if(cljs.core.truth_(inst_101534)){
var statearr_101636_101701 = state_101588__$1;
(statearr_101636_101701[(1)] = (27));

} else {
var statearr_101637_101702 = state_101588__$1;
(statearr_101637_101702[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101589 === (34))){
var state_101588__$1 = state_101588;
var statearr_101638_101703 = state_101588__$1;
(statearr_101638_101703[(2)] = null);

(statearr_101638_101703[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101589 === (17))){
var state_101588__$1 = state_101588;
var statearr_101639_101704 = state_101588__$1;
(statearr_101639_101704[(2)] = null);

(statearr_101639_101704[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101589 === (3))){
var inst_101586 = (state_101588[(2)]);
var state_101588__$1 = state_101588;
return cljs.core.async.impl.ioc_helpers.return_chan(state_101588__$1,inst_101586);
} else {
if((state_val_101589 === (12))){
var inst_101515 = (state_101588[(2)]);
var state_101588__$1 = state_101588;
var statearr_101640_101705 = state_101588__$1;
(statearr_101640_101705[(2)] = inst_101515);

(statearr_101640_101705[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101589 === (2))){
var state_101588__$1 = state_101588;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_101588__$1,(4),ch);
} else {
if((state_val_101589 === (23))){
var state_101588__$1 = state_101588;
var statearr_101641_101706 = state_101588__$1;
(statearr_101641_101706[(2)] = null);

(statearr_101641_101706[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101589 === (35))){
var inst_101570 = (state_101588[(2)]);
var state_101588__$1 = state_101588;
var statearr_101642_101707 = state_101588__$1;
(statearr_101642_101707[(2)] = inst_101570);

(statearr_101642_101707[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101589 === (19))){
var inst_101487 = (state_101588[(7)]);
var inst_101491 = cljs.core.chunk_first(inst_101487);
var inst_101492 = cljs.core.chunk_rest(inst_101487);
var inst_101493 = cljs.core.count(inst_101491);
var inst_101465 = inst_101492;
var inst_101466 = inst_101491;
var inst_101467 = inst_101493;
var inst_101468 = (0);
var state_101588__$1 = (function (){var statearr_101643 = state_101588;
(statearr_101643[(13)] = inst_101468);

(statearr_101643[(14)] = inst_101466);

(statearr_101643[(16)] = inst_101467);

(statearr_101643[(17)] = inst_101465);

return statearr_101643;
})();
var statearr_101644_101708 = state_101588__$1;
(statearr_101644_101708[(2)] = null);

(statearr_101644_101708[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101589 === (11))){
var inst_101465 = (state_101588[(17)]);
var inst_101487 = (state_101588[(7)]);
var inst_101487__$1 = cljs.core.seq(inst_101465);
var state_101588__$1 = (function (){var statearr_101645 = state_101588;
(statearr_101645[(7)] = inst_101487__$1);

return statearr_101645;
})();
if(inst_101487__$1){
var statearr_101646_101709 = state_101588__$1;
(statearr_101646_101709[(1)] = (16));

} else {
var statearr_101647_101710 = state_101588__$1;
(statearr_101647_101710[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101589 === (9))){
var inst_101517 = (state_101588[(2)]);
var state_101588__$1 = state_101588;
var statearr_101648_101711 = state_101588__$1;
(statearr_101648_101711[(2)] = inst_101517);

(statearr_101648_101711[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101589 === (5))){
var inst_101463 = cljs.core.deref(cs);
var inst_101464 = cljs.core.seq(inst_101463);
var inst_101465 = inst_101464;
var inst_101466 = null;
var inst_101467 = (0);
var inst_101468 = (0);
var state_101588__$1 = (function (){var statearr_101649 = state_101588;
(statearr_101649[(13)] = inst_101468);

(statearr_101649[(14)] = inst_101466);

(statearr_101649[(16)] = inst_101467);

(statearr_101649[(17)] = inst_101465);

return statearr_101649;
})();
var statearr_101650_101712 = state_101588__$1;
(statearr_101650_101712[(2)] = null);

(statearr_101650_101712[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101589 === (14))){
var state_101588__$1 = state_101588;
var statearr_101651_101713 = state_101588__$1;
(statearr_101651_101713[(2)] = null);

(statearr_101651_101713[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101589 === (45))){
var inst_101578 = (state_101588[(2)]);
var state_101588__$1 = state_101588;
var statearr_101652_101714 = state_101588__$1;
(statearr_101652_101714[(2)] = inst_101578);

(statearr_101652_101714[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101589 === (26))){
var inst_101520 = (state_101588[(29)]);
var inst_101574 = (state_101588[(2)]);
var inst_101575 = cljs.core.seq(inst_101520);
var state_101588__$1 = (function (){var statearr_101653 = state_101588;
(statearr_101653[(31)] = inst_101574);

return statearr_101653;
})();
if(inst_101575){
var statearr_101654_101715 = state_101588__$1;
(statearr_101654_101715[(1)] = (42));

} else {
var statearr_101655_101716 = state_101588__$1;
(statearr_101655_101716[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101589 === (16))){
var inst_101487 = (state_101588[(7)]);
var inst_101489 = cljs.core.chunked_seq_QMARK_(inst_101487);
var state_101588__$1 = state_101588;
if(inst_101489){
var statearr_101656_101717 = state_101588__$1;
(statearr_101656_101717[(1)] = (19));

} else {
var statearr_101657_101718 = state_101588__$1;
(statearr_101657_101718[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101589 === (38))){
var inst_101567 = (state_101588[(2)]);
var state_101588__$1 = state_101588;
var statearr_101658_101719 = state_101588__$1;
(statearr_101658_101719[(2)] = inst_101567);

(statearr_101658_101719[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101589 === (30))){
var state_101588__$1 = state_101588;
var statearr_101659_101720 = state_101588__$1;
(statearr_101659_101720[(2)] = null);

(statearr_101659_101720[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101589 === (10))){
var inst_101468 = (state_101588[(13)]);
var inst_101466 = (state_101588[(14)]);
var inst_101476 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_101466,inst_101468);
var inst_101477 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_101476,(0),null);
var inst_101478 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_101476,(1),null);
var state_101588__$1 = (function (){var statearr_101660 = state_101588;
(statearr_101660[(26)] = inst_101477);

return statearr_101660;
})();
if(cljs.core.truth_(inst_101478)){
var statearr_101661_101721 = state_101588__$1;
(statearr_101661_101721[(1)] = (13));

} else {
var statearr_101662_101722 = state_101588__$1;
(statearr_101662_101722[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101589 === (18))){
var inst_101513 = (state_101588[(2)]);
var state_101588__$1 = state_101588;
var statearr_101663_101723 = state_101588__$1;
(statearr_101663_101723[(2)] = inst_101513);

(statearr_101663_101723[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101589 === (42))){
var state_101588__$1 = state_101588;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_101588__$1,(45),dchan);
} else {
if((state_val_101589 === (37))){
var inst_101556 = (state_101588[(23)]);
var inst_101547 = (state_101588[(25)]);
var inst_101456 = (state_101588[(12)]);
var inst_101556__$1 = cljs.core.first(inst_101547);
var inst_101557 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_101556__$1,inst_101456,done);
var state_101588__$1 = (function (){var statearr_101664 = state_101588;
(statearr_101664[(23)] = inst_101556__$1);

return statearr_101664;
})();
if(cljs.core.truth_(inst_101557)){
var statearr_101665_101724 = state_101588__$1;
(statearr_101665_101724[(1)] = (39));

} else {
var statearr_101666_101725 = state_101588__$1;
(statearr_101666_101725[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101589 === (8))){
var inst_101468 = (state_101588[(13)]);
var inst_101467 = (state_101588[(16)]);
var inst_101470 = (inst_101468 < inst_101467);
var inst_101471 = inst_101470;
var state_101588__$1 = state_101588;
if(cljs.core.truth_(inst_101471)){
var statearr_101667_101726 = state_101588__$1;
(statearr_101667_101726[(1)] = (10));

} else {
var statearr_101668_101727 = state_101588__$1;
(statearr_101668_101727[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__100742__auto__ = null;
var cljs$core$async$mult_$_state_machine__100742__auto____0 = (function (){
var statearr_101669 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_101669[(0)] = cljs$core$async$mult_$_state_machine__100742__auto__);

(statearr_101669[(1)] = (1));

return statearr_101669;
});
var cljs$core$async$mult_$_state_machine__100742__auto____1 = (function (state_101588){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_101588);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e101670){if((e101670 instanceof Object)){
var ex__100745__auto__ = e101670;
var statearr_101671_101728 = state_101588;
(statearr_101671_101728[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_101588);

return cljs.core.cst$kw$recur;
} else {
throw e101670;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__101729 = state_101588;
state_101588 = G__101729;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__100742__auto__ = function(state_101588){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__100742__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__100742__auto____1.call(this,state_101588);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__100742__auto____0;
cljs$core$async$mult_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__100742__auto____1;
return cljs$core$async$mult_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_101672 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_101672[(6)] = c__100848__auto___101673);

return statearr_101672;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__101731 = arguments.length;
switch (G__101731) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_101733 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_101733(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_101734 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_101734(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_101735 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_101735(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_101736 = (function (m,state_map){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4429__auto__.call(null,m,state_map));
} else {
var m__4426__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4426__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_101736(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_101737 = (function (m,mode){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4429__auto__.call(null,m,mode));
} else {
var m__4426__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4426__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_101737(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___101748 = arguments.length;
var i__4737__auto___101749 = (0);
while(true){
if((i__4737__auto___101749 < len__4736__auto___101748)){
args__4742__auto__.push((arguments[i__4737__auto___101749]));

var G__101750 = (i__4737__auto___101749 + (1));
i__4737__auto___101749 = G__101750;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__101742){
var map__101743 = p__101742;
var map__101743__$1 = (((((!((map__101743 == null))))?(((((map__101743.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__101743.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__101743):map__101743);
var opts = map__101743__$1;
var statearr_101745_101751 = state;
(statearr_101745_101751[(1)] = cont_block);


var temp__5735__auto__ = cljs.core.async.do_alts((function (val){
var statearr_101746_101752 = state;
(statearr_101746_101752[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5735__auto__)){
var cb = temp__5735__auto__;
var statearr_101747_101753 = state;
(statearr_101747_101753[(2)] = cljs.core.deref(cb));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq101738){
var G__101739 = cljs.core.first(seq101738);
var seq101738__$1 = cljs.core.next(seq101738);
var G__101740 = cljs.core.first(seq101738__$1);
var seq101738__$2 = cljs.core.next(seq101738__$1);
var G__101741 = cljs.core.first(seq101738__$2);
var seq101738__$3 = cljs.core.next(seq101738__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__101739,G__101740,G__101741,seq101738__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$pause,null,cljs.core.cst$kw$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.cst$kw$solo);
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$mute);
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(cljs.core.cst$kw$solo,chs);
var pauses = pick(cljs.core.cst$kw$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$solos,solos,cljs.core.cst$kw$mutes,pick(cljs.core.cst$kw$mute,chs),cljs.core.cst$kw$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$pause)) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async101754 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async101754 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta101755){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta101755 = meta101755;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async101754.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_101756,meta101755__$1){
var self__ = this;
var _101756__$1 = this;
return (new cljs.core.async.t_cljs$core$async101754(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta101755__$1));
}));

(cljs.core.async.t_cljs$core$async101754.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_101756){
var self__ = this;
var _101756__$1 = this;
return self__.meta101755;
}));

(cljs.core.async.t_cljs$core$async101754.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async101754.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async101754.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async101754.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async101754.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async101754.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async101754.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async101754.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async101754.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$change,cljs.core.cst$sym$solo_DASH_mode,cljs.core.cst$sym$pick,cljs.core.cst$sym$cs,cljs.core.cst$sym$calc_DASH_state,cljs.core.cst$sym$out,cljs.core.cst$sym$changed,cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$attrs,cljs.core.cst$sym$meta101755], null);
}));

(cljs.core.async.t_cljs$core$async101754.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async101754.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async101754");

(cljs.core.async.t_cljs$core$async101754.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async101754");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async101754.
 */
cljs.core.async.__GT_t_cljs$core$async101754 = (function cljs$core$async$mix_$___GT_t_cljs$core$async101754(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta101755){
return (new cljs.core.async.t_cljs$core$async101754(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta101755));
});

}

return (new cljs.core.async.t_cljs$core$async101754(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__100848__auto___101918 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_101858){
var state_val_101859 = (state_101858[(1)]);
if((state_val_101859 === (7))){
var inst_101773 = (state_101858[(2)]);
var state_101858__$1 = state_101858;
var statearr_101860_101919 = state_101858__$1;
(statearr_101860_101919[(2)] = inst_101773);

(statearr_101860_101919[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101859 === (20))){
var inst_101785 = (state_101858[(7)]);
var state_101858__$1 = state_101858;
var statearr_101861_101920 = state_101858__$1;
(statearr_101861_101920[(2)] = inst_101785);

(statearr_101861_101920[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101859 === (27))){
var state_101858__$1 = state_101858;
var statearr_101862_101921 = state_101858__$1;
(statearr_101862_101921[(2)] = null);

(statearr_101862_101921[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101859 === (1))){
var inst_101760 = (state_101858[(8)]);
var inst_101760__$1 = calc_state();
var inst_101762 = (inst_101760__$1 == null);
var inst_101763 = cljs.core.not(inst_101762);
var state_101858__$1 = (function (){var statearr_101863 = state_101858;
(statearr_101863[(8)] = inst_101760__$1);

return statearr_101863;
})();
if(inst_101763){
var statearr_101864_101922 = state_101858__$1;
(statearr_101864_101922[(1)] = (2));

} else {
var statearr_101865_101923 = state_101858__$1;
(statearr_101865_101923[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101859 === (24))){
var inst_101809 = (state_101858[(9)]);
var inst_101832 = (state_101858[(10)]);
var inst_101818 = (state_101858[(11)]);
var inst_101832__$1 = (inst_101809.cljs$core$IFn$_invoke$arity$1 ? inst_101809.cljs$core$IFn$_invoke$arity$1(inst_101818) : inst_101809.call(null,inst_101818));
var state_101858__$1 = (function (){var statearr_101866 = state_101858;
(statearr_101866[(10)] = inst_101832__$1);

return statearr_101866;
})();
if(cljs.core.truth_(inst_101832__$1)){
var statearr_101867_101924 = state_101858__$1;
(statearr_101867_101924[(1)] = (29));

} else {
var statearr_101868_101925 = state_101858__$1;
(statearr_101868_101925[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101859 === (4))){
var inst_101776 = (state_101858[(2)]);
var state_101858__$1 = state_101858;
if(cljs.core.truth_(inst_101776)){
var statearr_101869_101926 = state_101858__$1;
(statearr_101869_101926[(1)] = (8));

} else {
var statearr_101870_101927 = state_101858__$1;
(statearr_101870_101927[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101859 === (15))){
var inst_101803 = (state_101858[(2)]);
var state_101858__$1 = state_101858;
if(cljs.core.truth_(inst_101803)){
var statearr_101871_101928 = state_101858__$1;
(statearr_101871_101928[(1)] = (19));

} else {
var statearr_101872_101929 = state_101858__$1;
(statearr_101872_101929[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101859 === (21))){
var inst_101808 = (state_101858[(12)]);
var inst_101808__$1 = (state_101858[(2)]);
var inst_101809 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_101808__$1,cljs.core.cst$kw$solos);
var inst_101810 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_101808__$1,cljs.core.cst$kw$mutes);
var inst_101811 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_101808__$1,cljs.core.cst$kw$reads);
var state_101858__$1 = (function (){var statearr_101873 = state_101858;
(statearr_101873[(9)] = inst_101809);

(statearr_101873[(12)] = inst_101808__$1);

(statearr_101873[(13)] = inst_101810);

return statearr_101873;
})();
return cljs.core.async.ioc_alts_BANG_(state_101858__$1,(22),inst_101811);
} else {
if((state_val_101859 === (31))){
var inst_101840 = (state_101858[(2)]);
var state_101858__$1 = state_101858;
if(cljs.core.truth_(inst_101840)){
var statearr_101874_101930 = state_101858__$1;
(statearr_101874_101930[(1)] = (32));

} else {
var statearr_101875_101931 = state_101858__$1;
(statearr_101875_101931[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101859 === (32))){
var inst_101817 = (state_101858[(14)]);
var state_101858__$1 = state_101858;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_101858__$1,(35),out,inst_101817);
} else {
if((state_val_101859 === (33))){
var inst_101808 = (state_101858[(12)]);
var inst_101785 = inst_101808;
var state_101858__$1 = (function (){var statearr_101876 = state_101858;
(statearr_101876[(7)] = inst_101785);

return statearr_101876;
})();
var statearr_101877_101932 = state_101858__$1;
(statearr_101877_101932[(2)] = null);

(statearr_101877_101932[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101859 === (13))){
var inst_101785 = (state_101858[(7)]);
var inst_101792 = inst_101785.cljs$lang$protocol_mask$partition0$;
var inst_101793 = (inst_101792 & (64));
var inst_101794 = inst_101785.cljs$core$ISeq$;
var inst_101795 = (cljs.core.PROTOCOL_SENTINEL === inst_101794);
var inst_101796 = ((inst_101793) || (inst_101795));
var state_101858__$1 = state_101858;
if(cljs.core.truth_(inst_101796)){
var statearr_101878_101933 = state_101858__$1;
(statearr_101878_101933[(1)] = (16));

} else {
var statearr_101879_101934 = state_101858__$1;
(statearr_101879_101934[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101859 === (22))){
var inst_101817 = (state_101858[(14)]);
var inst_101818 = (state_101858[(11)]);
var inst_101816 = (state_101858[(2)]);
var inst_101817__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_101816,(0),null);
var inst_101818__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_101816,(1),null);
var inst_101819 = (inst_101817__$1 == null);
var inst_101820 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_101818__$1,change);
var inst_101821 = ((inst_101819) || (inst_101820));
var state_101858__$1 = (function (){var statearr_101880 = state_101858;
(statearr_101880[(14)] = inst_101817__$1);

(statearr_101880[(11)] = inst_101818__$1);

return statearr_101880;
})();
if(cljs.core.truth_(inst_101821)){
var statearr_101881_101935 = state_101858__$1;
(statearr_101881_101935[(1)] = (23));

} else {
var statearr_101882_101936 = state_101858__$1;
(statearr_101882_101936[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101859 === (36))){
var inst_101808 = (state_101858[(12)]);
var inst_101785 = inst_101808;
var state_101858__$1 = (function (){var statearr_101883 = state_101858;
(statearr_101883[(7)] = inst_101785);

return statearr_101883;
})();
var statearr_101884_101937 = state_101858__$1;
(statearr_101884_101937[(2)] = null);

(statearr_101884_101937[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101859 === (29))){
var inst_101832 = (state_101858[(10)]);
var state_101858__$1 = state_101858;
var statearr_101885_101938 = state_101858__$1;
(statearr_101885_101938[(2)] = inst_101832);

(statearr_101885_101938[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101859 === (6))){
var state_101858__$1 = state_101858;
var statearr_101886_101939 = state_101858__$1;
(statearr_101886_101939[(2)] = false);

(statearr_101886_101939[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101859 === (28))){
var inst_101828 = (state_101858[(2)]);
var inst_101829 = calc_state();
var inst_101785 = inst_101829;
var state_101858__$1 = (function (){var statearr_101887 = state_101858;
(statearr_101887[(15)] = inst_101828);

(statearr_101887[(7)] = inst_101785);

return statearr_101887;
})();
var statearr_101888_101940 = state_101858__$1;
(statearr_101888_101940[(2)] = null);

(statearr_101888_101940[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101859 === (25))){
var inst_101854 = (state_101858[(2)]);
var state_101858__$1 = state_101858;
var statearr_101889_101941 = state_101858__$1;
(statearr_101889_101941[(2)] = inst_101854);

(statearr_101889_101941[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101859 === (34))){
var inst_101852 = (state_101858[(2)]);
var state_101858__$1 = state_101858;
var statearr_101890_101942 = state_101858__$1;
(statearr_101890_101942[(2)] = inst_101852);

(statearr_101890_101942[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101859 === (17))){
var state_101858__$1 = state_101858;
var statearr_101891_101943 = state_101858__$1;
(statearr_101891_101943[(2)] = false);

(statearr_101891_101943[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101859 === (3))){
var state_101858__$1 = state_101858;
var statearr_101892_101944 = state_101858__$1;
(statearr_101892_101944[(2)] = false);

(statearr_101892_101944[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101859 === (12))){
var inst_101856 = (state_101858[(2)]);
var state_101858__$1 = state_101858;
return cljs.core.async.impl.ioc_helpers.return_chan(state_101858__$1,inst_101856);
} else {
if((state_val_101859 === (2))){
var inst_101760 = (state_101858[(8)]);
var inst_101765 = inst_101760.cljs$lang$protocol_mask$partition0$;
var inst_101766 = (inst_101765 & (64));
var inst_101767 = inst_101760.cljs$core$ISeq$;
var inst_101768 = (cljs.core.PROTOCOL_SENTINEL === inst_101767);
var inst_101769 = ((inst_101766) || (inst_101768));
var state_101858__$1 = state_101858;
if(cljs.core.truth_(inst_101769)){
var statearr_101893_101945 = state_101858__$1;
(statearr_101893_101945[(1)] = (5));

} else {
var statearr_101894_101946 = state_101858__$1;
(statearr_101894_101946[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101859 === (23))){
var inst_101817 = (state_101858[(14)]);
var inst_101823 = (inst_101817 == null);
var state_101858__$1 = state_101858;
if(cljs.core.truth_(inst_101823)){
var statearr_101895_101947 = state_101858__$1;
(statearr_101895_101947[(1)] = (26));

} else {
var statearr_101896_101948 = state_101858__$1;
(statearr_101896_101948[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101859 === (35))){
var inst_101843 = (state_101858[(2)]);
var state_101858__$1 = state_101858;
if(cljs.core.truth_(inst_101843)){
var statearr_101897_101949 = state_101858__$1;
(statearr_101897_101949[(1)] = (36));

} else {
var statearr_101898_101950 = state_101858__$1;
(statearr_101898_101950[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101859 === (19))){
var inst_101785 = (state_101858[(7)]);
var inst_101805 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_101785);
var state_101858__$1 = state_101858;
var statearr_101899_101951 = state_101858__$1;
(statearr_101899_101951[(2)] = inst_101805);

(statearr_101899_101951[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101859 === (11))){
var inst_101785 = (state_101858[(7)]);
var inst_101789 = (inst_101785 == null);
var inst_101790 = cljs.core.not(inst_101789);
var state_101858__$1 = state_101858;
if(inst_101790){
var statearr_101900_101952 = state_101858__$1;
(statearr_101900_101952[(1)] = (13));

} else {
var statearr_101901_101953 = state_101858__$1;
(statearr_101901_101953[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101859 === (9))){
var inst_101760 = (state_101858[(8)]);
var state_101858__$1 = state_101858;
var statearr_101902_101954 = state_101858__$1;
(statearr_101902_101954[(2)] = inst_101760);

(statearr_101902_101954[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101859 === (5))){
var state_101858__$1 = state_101858;
var statearr_101903_101955 = state_101858__$1;
(statearr_101903_101955[(2)] = true);

(statearr_101903_101955[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101859 === (14))){
var state_101858__$1 = state_101858;
var statearr_101904_101956 = state_101858__$1;
(statearr_101904_101956[(2)] = false);

(statearr_101904_101956[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101859 === (26))){
var inst_101818 = (state_101858[(11)]);
var inst_101825 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_101818);
var state_101858__$1 = state_101858;
var statearr_101905_101957 = state_101858__$1;
(statearr_101905_101957[(2)] = inst_101825);

(statearr_101905_101957[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101859 === (16))){
var state_101858__$1 = state_101858;
var statearr_101906_101958 = state_101858__$1;
(statearr_101906_101958[(2)] = true);

(statearr_101906_101958[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101859 === (38))){
var inst_101848 = (state_101858[(2)]);
var state_101858__$1 = state_101858;
var statearr_101907_101959 = state_101858__$1;
(statearr_101907_101959[(2)] = inst_101848);

(statearr_101907_101959[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101859 === (30))){
var inst_101809 = (state_101858[(9)]);
var inst_101818 = (state_101858[(11)]);
var inst_101810 = (state_101858[(13)]);
var inst_101835 = cljs.core.empty_QMARK_(inst_101809);
var inst_101836 = (inst_101810.cljs$core$IFn$_invoke$arity$1 ? inst_101810.cljs$core$IFn$_invoke$arity$1(inst_101818) : inst_101810.call(null,inst_101818));
var inst_101837 = cljs.core.not(inst_101836);
var inst_101838 = ((inst_101835) && (inst_101837));
var state_101858__$1 = state_101858;
var statearr_101908_101960 = state_101858__$1;
(statearr_101908_101960[(2)] = inst_101838);

(statearr_101908_101960[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101859 === (10))){
var inst_101760 = (state_101858[(8)]);
var inst_101781 = (state_101858[(2)]);
var inst_101782 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_101781,cljs.core.cst$kw$solos);
var inst_101783 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_101781,cljs.core.cst$kw$mutes);
var inst_101784 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_101781,cljs.core.cst$kw$reads);
var inst_101785 = inst_101760;
var state_101858__$1 = (function (){var statearr_101909 = state_101858;
(statearr_101909[(16)] = inst_101784);

(statearr_101909[(17)] = inst_101783);

(statearr_101909[(7)] = inst_101785);

(statearr_101909[(18)] = inst_101782);

return statearr_101909;
})();
var statearr_101910_101961 = state_101858__$1;
(statearr_101910_101961[(2)] = null);

(statearr_101910_101961[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101859 === (18))){
var inst_101800 = (state_101858[(2)]);
var state_101858__$1 = state_101858;
var statearr_101911_101962 = state_101858__$1;
(statearr_101911_101962[(2)] = inst_101800);

(statearr_101911_101962[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101859 === (37))){
var state_101858__$1 = state_101858;
var statearr_101912_101963 = state_101858__$1;
(statearr_101912_101963[(2)] = null);

(statearr_101912_101963[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101859 === (8))){
var inst_101760 = (state_101858[(8)]);
var inst_101778 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_101760);
var state_101858__$1 = state_101858;
var statearr_101913_101964 = state_101858__$1;
(statearr_101913_101964[(2)] = inst_101778);

(statearr_101913_101964[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__100742__auto__ = null;
var cljs$core$async$mix_$_state_machine__100742__auto____0 = (function (){
var statearr_101914 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_101914[(0)] = cljs$core$async$mix_$_state_machine__100742__auto__);

(statearr_101914[(1)] = (1));

return statearr_101914;
});
var cljs$core$async$mix_$_state_machine__100742__auto____1 = (function (state_101858){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_101858);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e101915){if((e101915 instanceof Object)){
var ex__100745__auto__ = e101915;
var statearr_101916_101965 = state_101858;
(statearr_101916_101965[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_101858);

return cljs.core.cst$kw$recur;
} else {
throw e101915;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__101966 = state_101858;
state_101858 = G__101966;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__100742__auto__ = function(state_101858){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__100742__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__100742__auto____1.call(this,state_101858);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__100742__auto____0;
cljs$core$async$mix_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__100742__auto____1;
return cljs$core$async$mix_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_101917 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_101917[(6)] = c__100848__auto___101918);

return statearr_101917;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_101969 = (function (p,v,ch,close_QMARK_){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4429__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4426__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_101969(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_101970 = (function (p,v,ch){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4429__auto__.call(null,p,v,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4426__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_101970(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_101971 = (function() {
var G__101972 = null;
var G__101972__1 = (function (p){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4429__auto__.call(null,p));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4426__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__101972__2 = (function (p,v){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4429__auto__.call(null,p,v));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4426__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__101972 = function(p,v){
switch(arguments.length){
case 1:
return G__101972__1.call(this,p);
case 2:
return G__101972__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__101972.cljs$core$IFn$_invoke$arity$1 = G__101972__1;
G__101972.cljs$core$IFn$_invoke$arity$2 = G__101972__2;
return G__101972;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__101968 = arguments.length;
switch (G__101968) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_101971.cljs$core$IFn$_invoke$arity$1(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_101971.cljs$core$IFn$_invoke$arity$2(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__101976 = arguments.length;
switch (G__101976) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__101974_SHARP_){
if(cljs.core.truth_((p1__101974_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__101974_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__101974_SHARP_.call(null,topic)))){
return p1__101974_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__101974_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async101977 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async101977 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta101978){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta101978 = meta101978;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async101977.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_101979,meta101978__$1){
var self__ = this;
var _101979__$1 = this;
return (new cljs.core.async.t_cljs$core$async101977(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta101978__$1));
}));

(cljs.core.async.t_cljs$core$async101977.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_101979){
var self__ = this;
var _101979__$1 = this;
return self__.meta101978;
}));

(cljs.core.async.t_cljs$core$async101977.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async101977.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async101977.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async101977.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async101977.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5735__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5735__auto__)){
var m = temp__5735__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async101977.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async101977.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async101977.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$topic_DASH_fn,cljs.core.cst$sym$buf_DASH_fn,cljs.core.cst$sym$mults,cljs.core.cst$sym$ensure_DASH_mult,cljs.core.cst$sym$meta101978], null);
}));

(cljs.core.async.t_cljs$core$async101977.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async101977.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async101977");

(cljs.core.async.t_cljs$core$async101977.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async101977");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async101977.
 */
cljs.core.async.__GT_t_cljs$core$async101977 = (function cljs$core$async$__GT_t_cljs$core$async101977(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta101978){
return (new cljs.core.async.t_cljs$core$async101977(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta101978));
});

}

return (new cljs.core.async.t_cljs$core$async101977(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__100848__auto___102097 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_102051){
var state_val_102052 = (state_102051[(1)]);
if((state_val_102052 === (7))){
var inst_102047 = (state_102051[(2)]);
var state_102051__$1 = state_102051;
var statearr_102053_102098 = state_102051__$1;
(statearr_102053_102098[(2)] = inst_102047);

(statearr_102053_102098[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102052 === (20))){
var state_102051__$1 = state_102051;
var statearr_102054_102099 = state_102051__$1;
(statearr_102054_102099[(2)] = null);

(statearr_102054_102099[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102052 === (1))){
var state_102051__$1 = state_102051;
var statearr_102055_102100 = state_102051__$1;
(statearr_102055_102100[(2)] = null);

(statearr_102055_102100[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102052 === (24))){
var inst_102030 = (state_102051[(7)]);
var inst_102039 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_102030);
var state_102051__$1 = state_102051;
var statearr_102056_102101 = state_102051__$1;
(statearr_102056_102101[(2)] = inst_102039);

(statearr_102056_102101[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102052 === (4))){
var inst_101982 = (state_102051[(8)]);
var inst_101982__$1 = (state_102051[(2)]);
var inst_101983 = (inst_101982__$1 == null);
var state_102051__$1 = (function (){var statearr_102057 = state_102051;
(statearr_102057[(8)] = inst_101982__$1);

return statearr_102057;
})();
if(cljs.core.truth_(inst_101983)){
var statearr_102058_102102 = state_102051__$1;
(statearr_102058_102102[(1)] = (5));

} else {
var statearr_102059_102103 = state_102051__$1;
(statearr_102059_102103[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_102052 === (15))){
var inst_102024 = (state_102051[(2)]);
var state_102051__$1 = state_102051;
var statearr_102060_102104 = state_102051__$1;
(statearr_102060_102104[(2)] = inst_102024);

(statearr_102060_102104[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102052 === (21))){
var inst_102044 = (state_102051[(2)]);
var state_102051__$1 = (function (){var statearr_102061 = state_102051;
(statearr_102061[(9)] = inst_102044);

return statearr_102061;
})();
var statearr_102062_102105 = state_102051__$1;
(statearr_102062_102105[(2)] = null);

(statearr_102062_102105[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102052 === (13))){
var inst_102006 = (state_102051[(10)]);
var inst_102008 = cljs.core.chunked_seq_QMARK_(inst_102006);
var state_102051__$1 = state_102051;
if(inst_102008){
var statearr_102063_102106 = state_102051__$1;
(statearr_102063_102106[(1)] = (16));

} else {
var statearr_102064_102107 = state_102051__$1;
(statearr_102064_102107[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_102052 === (22))){
var inst_102036 = (state_102051[(2)]);
var state_102051__$1 = state_102051;
if(cljs.core.truth_(inst_102036)){
var statearr_102065_102108 = state_102051__$1;
(statearr_102065_102108[(1)] = (23));

} else {
var statearr_102066_102109 = state_102051__$1;
(statearr_102066_102109[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_102052 === (6))){
var inst_102032 = (state_102051[(11)]);
var inst_102030 = (state_102051[(7)]);
var inst_101982 = (state_102051[(8)]);
var inst_102030__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_101982) : topic_fn.call(null,inst_101982));
var inst_102031 = cljs.core.deref(mults);
var inst_102032__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_102031,inst_102030__$1);
var state_102051__$1 = (function (){var statearr_102067 = state_102051;
(statearr_102067[(11)] = inst_102032__$1);

(statearr_102067[(7)] = inst_102030__$1);

return statearr_102067;
})();
if(cljs.core.truth_(inst_102032__$1)){
var statearr_102068_102110 = state_102051__$1;
(statearr_102068_102110[(1)] = (19));

} else {
var statearr_102069_102111 = state_102051__$1;
(statearr_102069_102111[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_102052 === (25))){
var inst_102041 = (state_102051[(2)]);
var state_102051__$1 = state_102051;
var statearr_102070_102112 = state_102051__$1;
(statearr_102070_102112[(2)] = inst_102041);

(statearr_102070_102112[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102052 === (17))){
var inst_102006 = (state_102051[(10)]);
var inst_102015 = cljs.core.first(inst_102006);
var inst_102016 = cljs.core.async.muxch_STAR_(inst_102015);
var inst_102017 = cljs.core.async.close_BANG_(inst_102016);
var inst_102018 = cljs.core.next(inst_102006);
var inst_101992 = inst_102018;
var inst_101993 = null;
var inst_101994 = (0);
var inst_101995 = (0);
var state_102051__$1 = (function (){var statearr_102071 = state_102051;
(statearr_102071[(12)] = inst_101992);

(statearr_102071[(13)] = inst_101993);

(statearr_102071[(14)] = inst_101995);

(statearr_102071[(15)] = inst_102017);

(statearr_102071[(16)] = inst_101994);

return statearr_102071;
})();
var statearr_102072_102113 = state_102051__$1;
(statearr_102072_102113[(2)] = null);

(statearr_102072_102113[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102052 === (3))){
var inst_102049 = (state_102051[(2)]);
var state_102051__$1 = state_102051;
return cljs.core.async.impl.ioc_helpers.return_chan(state_102051__$1,inst_102049);
} else {
if((state_val_102052 === (12))){
var inst_102026 = (state_102051[(2)]);
var state_102051__$1 = state_102051;
var statearr_102073_102114 = state_102051__$1;
(statearr_102073_102114[(2)] = inst_102026);

(statearr_102073_102114[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102052 === (2))){
var state_102051__$1 = state_102051;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_102051__$1,(4),ch);
} else {
if((state_val_102052 === (23))){
var state_102051__$1 = state_102051;
var statearr_102074_102115 = state_102051__$1;
(statearr_102074_102115[(2)] = null);

(statearr_102074_102115[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102052 === (19))){
var inst_102032 = (state_102051[(11)]);
var inst_101982 = (state_102051[(8)]);
var inst_102034 = cljs.core.async.muxch_STAR_(inst_102032);
var state_102051__$1 = state_102051;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_102051__$1,(22),inst_102034,inst_101982);
} else {
if((state_val_102052 === (11))){
var inst_101992 = (state_102051[(12)]);
var inst_102006 = (state_102051[(10)]);
var inst_102006__$1 = cljs.core.seq(inst_101992);
var state_102051__$1 = (function (){var statearr_102075 = state_102051;
(statearr_102075[(10)] = inst_102006__$1);

return statearr_102075;
})();
if(inst_102006__$1){
var statearr_102076_102116 = state_102051__$1;
(statearr_102076_102116[(1)] = (13));

} else {
var statearr_102077_102117 = state_102051__$1;
(statearr_102077_102117[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_102052 === (9))){
var inst_102028 = (state_102051[(2)]);
var state_102051__$1 = state_102051;
var statearr_102078_102118 = state_102051__$1;
(statearr_102078_102118[(2)] = inst_102028);

(statearr_102078_102118[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102052 === (5))){
var inst_101989 = cljs.core.deref(mults);
var inst_101990 = cljs.core.vals(inst_101989);
var inst_101991 = cljs.core.seq(inst_101990);
var inst_101992 = inst_101991;
var inst_101993 = null;
var inst_101994 = (0);
var inst_101995 = (0);
var state_102051__$1 = (function (){var statearr_102079 = state_102051;
(statearr_102079[(12)] = inst_101992);

(statearr_102079[(13)] = inst_101993);

(statearr_102079[(14)] = inst_101995);

(statearr_102079[(16)] = inst_101994);

return statearr_102079;
})();
var statearr_102080_102119 = state_102051__$1;
(statearr_102080_102119[(2)] = null);

(statearr_102080_102119[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102052 === (14))){
var state_102051__$1 = state_102051;
var statearr_102084_102120 = state_102051__$1;
(statearr_102084_102120[(2)] = null);

(statearr_102084_102120[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102052 === (16))){
var inst_102006 = (state_102051[(10)]);
var inst_102010 = cljs.core.chunk_first(inst_102006);
var inst_102011 = cljs.core.chunk_rest(inst_102006);
var inst_102012 = cljs.core.count(inst_102010);
var inst_101992 = inst_102011;
var inst_101993 = inst_102010;
var inst_101994 = inst_102012;
var inst_101995 = (0);
var state_102051__$1 = (function (){var statearr_102085 = state_102051;
(statearr_102085[(12)] = inst_101992);

(statearr_102085[(13)] = inst_101993);

(statearr_102085[(14)] = inst_101995);

(statearr_102085[(16)] = inst_101994);

return statearr_102085;
})();
var statearr_102086_102121 = state_102051__$1;
(statearr_102086_102121[(2)] = null);

(statearr_102086_102121[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102052 === (10))){
var inst_101992 = (state_102051[(12)]);
var inst_101993 = (state_102051[(13)]);
var inst_101995 = (state_102051[(14)]);
var inst_101994 = (state_102051[(16)]);
var inst_102000 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_101993,inst_101995);
var inst_102001 = cljs.core.async.muxch_STAR_(inst_102000);
var inst_102002 = cljs.core.async.close_BANG_(inst_102001);
var inst_102003 = (inst_101995 + (1));
var tmp102081 = inst_101992;
var tmp102082 = inst_101993;
var tmp102083 = inst_101994;
var inst_101992__$1 = tmp102081;
var inst_101993__$1 = tmp102082;
var inst_101994__$1 = tmp102083;
var inst_101995__$1 = inst_102003;
var state_102051__$1 = (function (){var statearr_102087 = state_102051;
(statearr_102087[(12)] = inst_101992__$1);

(statearr_102087[(13)] = inst_101993__$1);

(statearr_102087[(17)] = inst_102002);

(statearr_102087[(14)] = inst_101995__$1);

(statearr_102087[(16)] = inst_101994__$1);

return statearr_102087;
})();
var statearr_102088_102122 = state_102051__$1;
(statearr_102088_102122[(2)] = null);

(statearr_102088_102122[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102052 === (18))){
var inst_102021 = (state_102051[(2)]);
var state_102051__$1 = state_102051;
var statearr_102089_102123 = state_102051__$1;
(statearr_102089_102123[(2)] = inst_102021);

(statearr_102089_102123[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102052 === (8))){
var inst_101995 = (state_102051[(14)]);
var inst_101994 = (state_102051[(16)]);
var inst_101997 = (inst_101995 < inst_101994);
var inst_101998 = inst_101997;
var state_102051__$1 = state_102051;
if(cljs.core.truth_(inst_101998)){
var statearr_102090_102124 = state_102051__$1;
(statearr_102090_102124[(1)] = (10));

} else {
var statearr_102091_102125 = state_102051__$1;
(statearr_102091_102125[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__100742__auto__ = null;
var cljs$core$async$state_machine__100742__auto____0 = (function (){
var statearr_102092 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_102092[(0)] = cljs$core$async$state_machine__100742__auto__);

(statearr_102092[(1)] = (1));

return statearr_102092;
});
var cljs$core$async$state_machine__100742__auto____1 = (function (state_102051){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_102051);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e102093){if((e102093 instanceof Object)){
var ex__100745__auto__ = e102093;
var statearr_102094_102126 = state_102051;
(statearr_102094_102126[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_102051);

return cljs.core.cst$kw$recur;
} else {
throw e102093;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__102127 = state_102051;
state_102051 = G__102127;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
cljs$core$async$state_machine__100742__auto__ = function(state_102051){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__100742__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__100742__auto____1.call(this,state_102051);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__100742__auto____0;
cljs$core$async$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__100742__auto____1;
return cljs$core$async$state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_102095 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_102095[(6)] = c__100848__auto___102097);

return statearr_102095;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__102129 = arguments.length;
switch (G__102129) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__102132 = arguments.length;
switch (G__102132) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__102135 = arguments.length;
switch (G__102135) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__100848__auto___102202 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_102174){
var state_val_102175 = (state_102174[(1)]);
if((state_val_102175 === (7))){
var state_102174__$1 = state_102174;
var statearr_102176_102203 = state_102174__$1;
(statearr_102176_102203[(2)] = null);

(statearr_102176_102203[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102175 === (1))){
var state_102174__$1 = state_102174;
var statearr_102177_102204 = state_102174__$1;
(statearr_102177_102204[(2)] = null);

(statearr_102177_102204[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102175 === (4))){
var inst_102138 = (state_102174[(7)]);
var inst_102140 = (inst_102138 < cnt);
var state_102174__$1 = state_102174;
if(cljs.core.truth_(inst_102140)){
var statearr_102178_102205 = state_102174__$1;
(statearr_102178_102205[(1)] = (6));

} else {
var statearr_102179_102206 = state_102174__$1;
(statearr_102179_102206[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_102175 === (15))){
var inst_102170 = (state_102174[(2)]);
var state_102174__$1 = state_102174;
var statearr_102180_102207 = state_102174__$1;
(statearr_102180_102207[(2)] = inst_102170);

(statearr_102180_102207[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102175 === (13))){
var inst_102163 = cljs.core.async.close_BANG_(out);
var state_102174__$1 = state_102174;
var statearr_102181_102208 = state_102174__$1;
(statearr_102181_102208[(2)] = inst_102163);

(statearr_102181_102208[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102175 === (6))){
var state_102174__$1 = state_102174;
var statearr_102182_102209 = state_102174__$1;
(statearr_102182_102209[(2)] = null);

(statearr_102182_102209[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102175 === (3))){
var inst_102172 = (state_102174[(2)]);
var state_102174__$1 = state_102174;
return cljs.core.async.impl.ioc_helpers.return_chan(state_102174__$1,inst_102172);
} else {
if((state_val_102175 === (12))){
var inst_102160 = (state_102174[(8)]);
var inst_102160__$1 = (state_102174[(2)]);
var inst_102161 = cljs.core.some(cljs.core.nil_QMARK_,inst_102160__$1);
var state_102174__$1 = (function (){var statearr_102183 = state_102174;
(statearr_102183[(8)] = inst_102160__$1);

return statearr_102183;
})();
if(cljs.core.truth_(inst_102161)){
var statearr_102184_102210 = state_102174__$1;
(statearr_102184_102210[(1)] = (13));

} else {
var statearr_102185_102211 = state_102174__$1;
(statearr_102185_102211[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_102175 === (2))){
var inst_102137 = cljs.core.reset_BANG_(dctr,cnt);
var inst_102138 = (0);
var state_102174__$1 = (function (){var statearr_102186 = state_102174;
(statearr_102186[(9)] = inst_102137);

(statearr_102186[(7)] = inst_102138);

return statearr_102186;
})();
var statearr_102187_102212 = state_102174__$1;
(statearr_102187_102212[(2)] = null);

(statearr_102187_102212[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102175 === (11))){
var inst_102138 = (state_102174[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_102174,(10),Object,null,(9));
var inst_102147 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_102138) : chs__$1.call(null,inst_102138));
var inst_102148 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_102138) : done.call(null,inst_102138));
var inst_102149 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_102147,inst_102148);
var state_102174__$1 = state_102174;
var statearr_102188_102213 = state_102174__$1;
(statearr_102188_102213[(2)] = inst_102149);


cljs.core.async.impl.ioc_helpers.process_exception(state_102174__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_102175 === (9))){
var inst_102138 = (state_102174[(7)]);
var inst_102151 = (state_102174[(2)]);
var inst_102152 = (inst_102138 + (1));
var inst_102138__$1 = inst_102152;
var state_102174__$1 = (function (){var statearr_102189 = state_102174;
(statearr_102189[(10)] = inst_102151);

(statearr_102189[(7)] = inst_102138__$1);

return statearr_102189;
})();
var statearr_102190_102214 = state_102174__$1;
(statearr_102190_102214[(2)] = null);

(statearr_102190_102214[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102175 === (5))){
var inst_102158 = (state_102174[(2)]);
var state_102174__$1 = (function (){var statearr_102191 = state_102174;
(statearr_102191[(11)] = inst_102158);

return statearr_102191;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_102174__$1,(12),dchan);
} else {
if((state_val_102175 === (14))){
var inst_102160 = (state_102174[(8)]);
var inst_102165 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_102160);
var state_102174__$1 = state_102174;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_102174__$1,(16),out,inst_102165);
} else {
if((state_val_102175 === (16))){
var inst_102167 = (state_102174[(2)]);
var state_102174__$1 = (function (){var statearr_102192 = state_102174;
(statearr_102192[(12)] = inst_102167);

return statearr_102192;
})();
var statearr_102193_102215 = state_102174__$1;
(statearr_102193_102215[(2)] = null);

(statearr_102193_102215[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102175 === (10))){
var inst_102142 = (state_102174[(2)]);
var inst_102143 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_102174__$1 = (function (){var statearr_102194 = state_102174;
(statearr_102194[(13)] = inst_102142);

return statearr_102194;
})();
var statearr_102195_102216 = state_102174__$1;
(statearr_102195_102216[(2)] = inst_102143);


cljs.core.async.impl.ioc_helpers.process_exception(state_102174__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_102175 === (8))){
var inst_102156 = (state_102174[(2)]);
var state_102174__$1 = state_102174;
var statearr_102196_102217 = state_102174__$1;
(statearr_102196_102217[(2)] = inst_102156);

(statearr_102196_102217[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__100742__auto__ = null;
var cljs$core$async$state_machine__100742__auto____0 = (function (){
var statearr_102197 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_102197[(0)] = cljs$core$async$state_machine__100742__auto__);

(statearr_102197[(1)] = (1));

return statearr_102197;
});
var cljs$core$async$state_machine__100742__auto____1 = (function (state_102174){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_102174);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e102198){if((e102198 instanceof Object)){
var ex__100745__auto__ = e102198;
var statearr_102199_102218 = state_102174;
(statearr_102199_102218[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_102174);

return cljs.core.cst$kw$recur;
} else {
throw e102198;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__102219 = state_102174;
state_102174 = G__102219;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
cljs$core$async$state_machine__100742__auto__ = function(state_102174){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__100742__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__100742__auto____1.call(this,state_102174);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__100742__auto____0;
cljs$core$async$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__100742__auto____1;
return cljs$core$async$state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_102200 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_102200[(6)] = c__100848__auto___102202);

return statearr_102200;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__102222 = arguments.length;
switch (G__102222) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__100848__auto___102276 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_102254){
var state_val_102255 = (state_102254[(1)]);
if((state_val_102255 === (7))){
var inst_102233 = (state_102254[(7)]);
var inst_102234 = (state_102254[(8)]);
var inst_102233__$1 = (state_102254[(2)]);
var inst_102234__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_102233__$1,(0),null);
var inst_102235 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_102233__$1,(1),null);
var inst_102236 = (inst_102234__$1 == null);
var state_102254__$1 = (function (){var statearr_102256 = state_102254;
(statearr_102256[(9)] = inst_102235);

(statearr_102256[(7)] = inst_102233__$1);

(statearr_102256[(8)] = inst_102234__$1);

return statearr_102256;
})();
if(cljs.core.truth_(inst_102236)){
var statearr_102257_102277 = state_102254__$1;
(statearr_102257_102277[(1)] = (8));

} else {
var statearr_102258_102278 = state_102254__$1;
(statearr_102258_102278[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_102255 === (1))){
var inst_102223 = cljs.core.vec(chs);
var inst_102224 = inst_102223;
var state_102254__$1 = (function (){var statearr_102259 = state_102254;
(statearr_102259[(10)] = inst_102224);

return statearr_102259;
})();
var statearr_102260_102279 = state_102254__$1;
(statearr_102260_102279[(2)] = null);

(statearr_102260_102279[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102255 === (4))){
var inst_102224 = (state_102254[(10)]);
var state_102254__$1 = state_102254;
return cljs.core.async.ioc_alts_BANG_(state_102254__$1,(7),inst_102224);
} else {
if((state_val_102255 === (6))){
var inst_102250 = (state_102254[(2)]);
var state_102254__$1 = state_102254;
var statearr_102261_102280 = state_102254__$1;
(statearr_102261_102280[(2)] = inst_102250);

(statearr_102261_102280[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102255 === (3))){
var inst_102252 = (state_102254[(2)]);
var state_102254__$1 = state_102254;
return cljs.core.async.impl.ioc_helpers.return_chan(state_102254__$1,inst_102252);
} else {
if((state_val_102255 === (2))){
var inst_102224 = (state_102254[(10)]);
var inst_102226 = cljs.core.count(inst_102224);
var inst_102227 = (inst_102226 > (0));
var state_102254__$1 = state_102254;
if(cljs.core.truth_(inst_102227)){
var statearr_102263_102281 = state_102254__$1;
(statearr_102263_102281[(1)] = (4));

} else {
var statearr_102264_102282 = state_102254__$1;
(statearr_102264_102282[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_102255 === (11))){
var inst_102224 = (state_102254[(10)]);
var inst_102243 = (state_102254[(2)]);
var tmp102262 = inst_102224;
var inst_102224__$1 = tmp102262;
var state_102254__$1 = (function (){var statearr_102265 = state_102254;
(statearr_102265[(10)] = inst_102224__$1);

(statearr_102265[(11)] = inst_102243);

return statearr_102265;
})();
var statearr_102266_102283 = state_102254__$1;
(statearr_102266_102283[(2)] = null);

(statearr_102266_102283[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102255 === (9))){
var inst_102234 = (state_102254[(8)]);
var state_102254__$1 = state_102254;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_102254__$1,(11),out,inst_102234);
} else {
if((state_val_102255 === (5))){
var inst_102248 = cljs.core.async.close_BANG_(out);
var state_102254__$1 = state_102254;
var statearr_102267_102284 = state_102254__$1;
(statearr_102267_102284[(2)] = inst_102248);

(statearr_102267_102284[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102255 === (10))){
var inst_102246 = (state_102254[(2)]);
var state_102254__$1 = state_102254;
var statearr_102268_102285 = state_102254__$1;
(statearr_102268_102285[(2)] = inst_102246);

(statearr_102268_102285[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102255 === (8))){
var inst_102224 = (state_102254[(10)]);
var inst_102235 = (state_102254[(9)]);
var inst_102233 = (state_102254[(7)]);
var inst_102234 = (state_102254[(8)]);
var inst_102238 = (function (){var cs = inst_102224;
var vec__102229 = inst_102233;
var v = inst_102234;
var c = inst_102235;
return (function (p1__102220_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__102220_SHARP_);
});
})();
var inst_102239 = cljs.core.filterv(inst_102238,inst_102224);
var inst_102224__$1 = inst_102239;
var state_102254__$1 = (function (){var statearr_102269 = state_102254;
(statearr_102269[(10)] = inst_102224__$1);

return statearr_102269;
})();
var statearr_102270_102286 = state_102254__$1;
(statearr_102270_102286[(2)] = null);

(statearr_102270_102286[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__100742__auto__ = null;
var cljs$core$async$state_machine__100742__auto____0 = (function (){
var statearr_102271 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_102271[(0)] = cljs$core$async$state_machine__100742__auto__);

(statearr_102271[(1)] = (1));

return statearr_102271;
});
var cljs$core$async$state_machine__100742__auto____1 = (function (state_102254){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_102254);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e102272){if((e102272 instanceof Object)){
var ex__100745__auto__ = e102272;
var statearr_102273_102287 = state_102254;
(statearr_102273_102287[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_102254);

return cljs.core.cst$kw$recur;
} else {
throw e102272;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__102288 = state_102254;
state_102254 = G__102288;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
cljs$core$async$state_machine__100742__auto__ = function(state_102254){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__100742__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__100742__auto____1.call(this,state_102254);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__100742__auto____0;
cljs$core$async$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__100742__auto____1;
return cljs$core$async$state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_102274 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_102274[(6)] = c__100848__auto___102276);

return statearr_102274;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__102290 = arguments.length;
switch (G__102290) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__100848__auto___102335 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_102314){
var state_val_102315 = (state_102314[(1)]);
if((state_val_102315 === (7))){
var inst_102296 = (state_102314[(7)]);
var inst_102296__$1 = (state_102314[(2)]);
var inst_102297 = (inst_102296__$1 == null);
var inst_102298 = cljs.core.not(inst_102297);
var state_102314__$1 = (function (){var statearr_102316 = state_102314;
(statearr_102316[(7)] = inst_102296__$1);

return statearr_102316;
})();
if(inst_102298){
var statearr_102317_102336 = state_102314__$1;
(statearr_102317_102336[(1)] = (8));

} else {
var statearr_102318_102337 = state_102314__$1;
(statearr_102318_102337[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_102315 === (1))){
var inst_102291 = (0);
var state_102314__$1 = (function (){var statearr_102319 = state_102314;
(statearr_102319[(8)] = inst_102291);

return statearr_102319;
})();
var statearr_102320_102338 = state_102314__$1;
(statearr_102320_102338[(2)] = null);

(statearr_102320_102338[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102315 === (4))){
var state_102314__$1 = state_102314;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_102314__$1,(7),ch);
} else {
if((state_val_102315 === (6))){
var inst_102309 = (state_102314[(2)]);
var state_102314__$1 = state_102314;
var statearr_102321_102339 = state_102314__$1;
(statearr_102321_102339[(2)] = inst_102309);

(statearr_102321_102339[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102315 === (3))){
var inst_102311 = (state_102314[(2)]);
var inst_102312 = cljs.core.async.close_BANG_(out);
var state_102314__$1 = (function (){var statearr_102322 = state_102314;
(statearr_102322[(9)] = inst_102311);

return statearr_102322;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_102314__$1,inst_102312);
} else {
if((state_val_102315 === (2))){
var inst_102291 = (state_102314[(8)]);
var inst_102293 = (inst_102291 < n);
var state_102314__$1 = state_102314;
if(cljs.core.truth_(inst_102293)){
var statearr_102323_102340 = state_102314__$1;
(statearr_102323_102340[(1)] = (4));

} else {
var statearr_102324_102341 = state_102314__$1;
(statearr_102324_102341[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_102315 === (11))){
var inst_102291 = (state_102314[(8)]);
var inst_102301 = (state_102314[(2)]);
var inst_102302 = (inst_102291 + (1));
var inst_102291__$1 = inst_102302;
var state_102314__$1 = (function (){var statearr_102325 = state_102314;
(statearr_102325[(8)] = inst_102291__$1);

(statearr_102325[(10)] = inst_102301);

return statearr_102325;
})();
var statearr_102326_102342 = state_102314__$1;
(statearr_102326_102342[(2)] = null);

(statearr_102326_102342[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102315 === (9))){
var state_102314__$1 = state_102314;
var statearr_102327_102343 = state_102314__$1;
(statearr_102327_102343[(2)] = null);

(statearr_102327_102343[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102315 === (5))){
var state_102314__$1 = state_102314;
var statearr_102328_102344 = state_102314__$1;
(statearr_102328_102344[(2)] = null);

(statearr_102328_102344[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102315 === (10))){
var inst_102306 = (state_102314[(2)]);
var state_102314__$1 = state_102314;
var statearr_102329_102345 = state_102314__$1;
(statearr_102329_102345[(2)] = inst_102306);

(statearr_102329_102345[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102315 === (8))){
var inst_102296 = (state_102314[(7)]);
var state_102314__$1 = state_102314;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_102314__$1,(11),out,inst_102296);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__100742__auto__ = null;
var cljs$core$async$state_machine__100742__auto____0 = (function (){
var statearr_102330 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_102330[(0)] = cljs$core$async$state_machine__100742__auto__);

(statearr_102330[(1)] = (1));

return statearr_102330;
});
var cljs$core$async$state_machine__100742__auto____1 = (function (state_102314){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_102314);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e102331){if((e102331 instanceof Object)){
var ex__100745__auto__ = e102331;
var statearr_102332_102346 = state_102314;
(statearr_102332_102346[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_102314);

return cljs.core.cst$kw$recur;
} else {
throw e102331;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__102347 = state_102314;
state_102314 = G__102347;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
cljs$core$async$state_machine__100742__auto__ = function(state_102314){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__100742__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__100742__auto____1.call(this,state_102314);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__100742__auto____0;
cljs$core$async$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__100742__auto____1;
return cljs$core$async$state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_102333 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_102333[(6)] = c__100848__auto___102335);

return statearr_102333;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async102349 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async102349 = (function (f,ch,meta102350){
this.f = f;
this.ch = ch;
this.meta102350 = meta102350;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async102349.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_102351,meta102350__$1){
var self__ = this;
var _102351__$1 = this;
return (new cljs.core.async.t_cljs$core$async102349(self__.f,self__.ch,meta102350__$1));
}));

(cljs.core.async.t_cljs$core$async102349.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_102351){
var self__ = this;
var _102351__$1 = this;
return self__.meta102350;
}));

(cljs.core.async.t_cljs$core$async102349.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async102349.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async102349.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async102349.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async102349.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async102352 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async102352 = (function (f,ch,meta102350,_,fn1,meta102353){
this.f = f;
this.ch = ch;
this.meta102350 = meta102350;
this._ = _;
this.fn1 = fn1;
this.meta102353 = meta102353;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async102352.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_102354,meta102353__$1){
var self__ = this;
var _102354__$1 = this;
return (new cljs.core.async.t_cljs$core$async102352(self__.f,self__.ch,self__.meta102350,self__._,self__.fn1,meta102353__$1));
}));

(cljs.core.async.t_cljs$core$async102352.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_102354){
var self__ = this;
var _102354__$1 = this;
return self__.meta102353;
}));

(cljs.core.async.t_cljs$core$async102352.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async102352.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async102352.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async102352.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__102348_SHARP_){
var G__102355 = (((p1__102348_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__102348_SHARP_) : self__.f.call(null,p1__102348_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__102355) : f1.call(null,G__102355));
});
}));

(cljs.core.async.t_cljs$core$async102352.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta102350,cljs.core.with_meta(cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core$async_SLASH_t_cljs$core$async102349], null)),cljs.core.cst$sym$fn1,cljs.core.cst$sym$meta102353], null);
}));

(cljs.core.async.t_cljs$core$async102352.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async102352.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async102352");

(cljs.core.async.t_cljs$core$async102352.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async102352");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async102352.
 */
cljs.core.async.__GT_t_cljs$core$async102352 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async102352(f__$1,ch__$1,meta102350__$1,___$2,fn1__$1,meta102353){
return (new cljs.core.async.t_cljs$core$async102352(f__$1,ch__$1,meta102350__$1,___$2,fn1__$1,meta102353));
});

}

return (new cljs.core.async.t_cljs$core$async102352(self__.f,self__.ch,self__.meta102350,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4115__auto__ = ret;
if(cljs.core.truth_(and__4115__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4115__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__102356 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__102356) : self__.f.call(null,G__102356));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async102349.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async102349.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async102349.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta102350], null);
}));

(cljs.core.async.t_cljs$core$async102349.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async102349.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async102349");

(cljs.core.async.t_cljs$core$async102349.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async102349");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async102349.
 */
cljs.core.async.__GT_t_cljs$core$async102349 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async102349(f__$1,ch__$1,meta102350){
return (new cljs.core.async.t_cljs$core$async102349(f__$1,ch__$1,meta102350));
});

}

return (new cljs.core.async.t_cljs$core$async102349(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async102357 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async102357 = (function (f,ch,meta102358){
this.f = f;
this.ch = ch;
this.meta102358 = meta102358;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async102357.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_102359,meta102358__$1){
var self__ = this;
var _102359__$1 = this;
return (new cljs.core.async.t_cljs$core$async102357(self__.f,self__.ch,meta102358__$1));
}));

(cljs.core.async.t_cljs$core$async102357.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_102359){
var self__ = this;
var _102359__$1 = this;
return self__.meta102358;
}));

(cljs.core.async.t_cljs$core$async102357.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async102357.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async102357.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async102357.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async102357.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async102357.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async102357.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta102358], null);
}));

(cljs.core.async.t_cljs$core$async102357.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async102357.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async102357");

(cljs.core.async.t_cljs$core$async102357.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async102357");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async102357.
 */
cljs.core.async.__GT_t_cljs$core$async102357 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async102357(f__$1,ch__$1,meta102358){
return (new cljs.core.async.t_cljs$core$async102357(f__$1,ch__$1,meta102358));
});

}

return (new cljs.core.async.t_cljs$core$async102357(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async102360 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async102360 = (function (p,ch,meta102361){
this.p = p;
this.ch = ch;
this.meta102361 = meta102361;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async102360.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_102362,meta102361__$1){
var self__ = this;
var _102362__$1 = this;
return (new cljs.core.async.t_cljs$core$async102360(self__.p,self__.ch,meta102361__$1));
}));

(cljs.core.async.t_cljs$core$async102360.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_102362){
var self__ = this;
var _102362__$1 = this;
return self__.meta102361;
}));

(cljs.core.async.t_cljs$core$async102360.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async102360.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async102360.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async102360.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async102360.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async102360.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async102360.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async102360.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta102361], null);
}));

(cljs.core.async.t_cljs$core$async102360.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async102360.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async102360");

(cljs.core.async.t_cljs$core$async102360.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async102360");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async102360.
 */
cljs.core.async.__GT_t_cljs$core$async102360 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async102360(p__$1,ch__$1,meta102361){
return (new cljs.core.async.t_cljs$core$async102360(p__$1,ch__$1,meta102361));
});

}

return (new cljs.core.async.t_cljs$core$async102360(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__102364 = arguments.length;
switch (G__102364) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__100848__auto___102404 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_102385){
var state_val_102386 = (state_102385[(1)]);
if((state_val_102386 === (7))){
var inst_102381 = (state_102385[(2)]);
var state_102385__$1 = state_102385;
var statearr_102387_102405 = state_102385__$1;
(statearr_102387_102405[(2)] = inst_102381);

(statearr_102387_102405[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102386 === (1))){
var state_102385__$1 = state_102385;
var statearr_102388_102406 = state_102385__$1;
(statearr_102388_102406[(2)] = null);

(statearr_102388_102406[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102386 === (4))){
var inst_102367 = (state_102385[(7)]);
var inst_102367__$1 = (state_102385[(2)]);
var inst_102368 = (inst_102367__$1 == null);
var state_102385__$1 = (function (){var statearr_102389 = state_102385;
(statearr_102389[(7)] = inst_102367__$1);

return statearr_102389;
})();
if(cljs.core.truth_(inst_102368)){
var statearr_102390_102407 = state_102385__$1;
(statearr_102390_102407[(1)] = (5));

} else {
var statearr_102391_102408 = state_102385__$1;
(statearr_102391_102408[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_102386 === (6))){
var inst_102367 = (state_102385[(7)]);
var inst_102372 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_102367) : p.call(null,inst_102367));
var state_102385__$1 = state_102385;
if(cljs.core.truth_(inst_102372)){
var statearr_102392_102409 = state_102385__$1;
(statearr_102392_102409[(1)] = (8));

} else {
var statearr_102393_102410 = state_102385__$1;
(statearr_102393_102410[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_102386 === (3))){
var inst_102383 = (state_102385[(2)]);
var state_102385__$1 = state_102385;
return cljs.core.async.impl.ioc_helpers.return_chan(state_102385__$1,inst_102383);
} else {
if((state_val_102386 === (2))){
var state_102385__$1 = state_102385;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_102385__$1,(4),ch);
} else {
if((state_val_102386 === (11))){
var inst_102375 = (state_102385[(2)]);
var state_102385__$1 = state_102385;
var statearr_102394_102411 = state_102385__$1;
(statearr_102394_102411[(2)] = inst_102375);

(statearr_102394_102411[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102386 === (9))){
var state_102385__$1 = state_102385;
var statearr_102395_102412 = state_102385__$1;
(statearr_102395_102412[(2)] = null);

(statearr_102395_102412[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102386 === (5))){
var inst_102370 = cljs.core.async.close_BANG_(out);
var state_102385__$1 = state_102385;
var statearr_102396_102413 = state_102385__$1;
(statearr_102396_102413[(2)] = inst_102370);

(statearr_102396_102413[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102386 === (10))){
var inst_102378 = (state_102385[(2)]);
var state_102385__$1 = (function (){var statearr_102397 = state_102385;
(statearr_102397[(8)] = inst_102378);

return statearr_102397;
})();
var statearr_102398_102414 = state_102385__$1;
(statearr_102398_102414[(2)] = null);

(statearr_102398_102414[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102386 === (8))){
var inst_102367 = (state_102385[(7)]);
var state_102385__$1 = state_102385;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_102385__$1,(11),out,inst_102367);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__100742__auto__ = null;
var cljs$core$async$state_machine__100742__auto____0 = (function (){
var statearr_102399 = [null,null,null,null,null,null,null,null,null];
(statearr_102399[(0)] = cljs$core$async$state_machine__100742__auto__);

(statearr_102399[(1)] = (1));

return statearr_102399;
});
var cljs$core$async$state_machine__100742__auto____1 = (function (state_102385){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_102385);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e102400){if((e102400 instanceof Object)){
var ex__100745__auto__ = e102400;
var statearr_102401_102415 = state_102385;
(statearr_102401_102415[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_102385);

return cljs.core.cst$kw$recur;
} else {
throw e102400;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__102416 = state_102385;
state_102385 = G__102416;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
cljs$core$async$state_machine__100742__auto__ = function(state_102385){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__100742__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__100742__auto____1.call(this,state_102385);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__100742__auto____0;
cljs$core$async$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__100742__auto____1;
return cljs$core$async$state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_102402 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_102402[(6)] = c__100848__auto___102404);

return statearr_102402;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__102418 = arguments.length;
switch (G__102418) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_102481){
var state_val_102482 = (state_102481[(1)]);
if((state_val_102482 === (7))){
var inst_102477 = (state_102481[(2)]);
var state_102481__$1 = state_102481;
var statearr_102483_102521 = state_102481__$1;
(statearr_102483_102521[(2)] = inst_102477);

(statearr_102483_102521[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102482 === (20))){
var inst_102447 = (state_102481[(7)]);
var inst_102458 = (state_102481[(2)]);
var inst_102459 = cljs.core.next(inst_102447);
var inst_102433 = inst_102459;
var inst_102434 = null;
var inst_102435 = (0);
var inst_102436 = (0);
var state_102481__$1 = (function (){var statearr_102484 = state_102481;
(statearr_102484[(8)] = inst_102458);

(statearr_102484[(9)] = inst_102434);

(statearr_102484[(10)] = inst_102433);

(statearr_102484[(11)] = inst_102436);

(statearr_102484[(12)] = inst_102435);

return statearr_102484;
})();
var statearr_102485_102522 = state_102481__$1;
(statearr_102485_102522[(2)] = null);

(statearr_102485_102522[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102482 === (1))){
var state_102481__$1 = state_102481;
var statearr_102486_102523 = state_102481__$1;
(statearr_102486_102523[(2)] = null);

(statearr_102486_102523[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102482 === (4))){
var inst_102422 = (state_102481[(13)]);
var inst_102422__$1 = (state_102481[(2)]);
var inst_102423 = (inst_102422__$1 == null);
var state_102481__$1 = (function (){var statearr_102487 = state_102481;
(statearr_102487[(13)] = inst_102422__$1);

return statearr_102487;
})();
if(cljs.core.truth_(inst_102423)){
var statearr_102488_102524 = state_102481__$1;
(statearr_102488_102524[(1)] = (5));

} else {
var statearr_102489_102525 = state_102481__$1;
(statearr_102489_102525[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_102482 === (15))){
var state_102481__$1 = state_102481;
var statearr_102493_102526 = state_102481__$1;
(statearr_102493_102526[(2)] = null);

(statearr_102493_102526[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102482 === (21))){
var state_102481__$1 = state_102481;
var statearr_102494_102527 = state_102481__$1;
(statearr_102494_102527[(2)] = null);

(statearr_102494_102527[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102482 === (13))){
var inst_102434 = (state_102481[(9)]);
var inst_102433 = (state_102481[(10)]);
var inst_102436 = (state_102481[(11)]);
var inst_102435 = (state_102481[(12)]);
var inst_102443 = (state_102481[(2)]);
var inst_102444 = (inst_102436 + (1));
var tmp102490 = inst_102434;
var tmp102491 = inst_102433;
var tmp102492 = inst_102435;
var inst_102433__$1 = tmp102491;
var inst_102434__$1 = tmp102490;
var inst_102435__$1 = tmp102492;
var inst_102436__$1 = inst_102444;
var state_102481__$1 = (function (){var statearr_102495 = state_102481;
(statearr_102495[(9)] = inst_102434__$1);

(statearr_102495[(14)] = inst_102443);

(statearr_102495[(10)] = inst_102433__$1);

(statearr_102495[(11)] = inst_102436__$1);

(statearr_102495[(12)] = inst_102435__$1);

return statearr_102495;
})();
var statearr_102496_102528 = state_102481__$1;
(statearr_102496_102528[(2)] = null);

(statearr_102496_102528[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102482 === (22))){
var state_102481__$1 = state_102481;
var statearr_102497_102529 = state_102481__$1;
(statearr_102497_102529[(2)] = null);

(statearr_102497_102529[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102482 === (6))){
var inst_102422 = (state_102481[(13)]);
var inst_102431 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_102422) : f.call(null,inst_102422));
var inst_102432 = cljs.core.seq(inst_102431);
var inst_102433 = inst_102432;
var inst_102434 = null;
var inst_102435 = (0);
var inst_102436 = (0);
var state_102481__$1 = (function (){var statearr_102498 = state_102481;
(statearr_102498[(9)] = inst_102434);

(statearr_102498[(10)] = inst_102433);

(statearr_102498[(11)] = inst_102436);

(statearr_102498[(12)] = inst_102435);

return statearr_102498;
})();
var statearr_102499_102530 = state_102481__$1;
(statearr_102499_102530[(2)] = null);

(statearr_102499_102530[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102482 === (17))){
var inst_102447 = (state_102481[(7)]);
var inst_102451 = cljs.core.chunk_first(inst_102447);
var inst_102452 = cljs.core.chunk_rest(inst_102447);
var inst_102453 = cljs.core.count(inst_102451);
var inst_102433 = inst_102452;
var inst_102434 = inst_102451;
var inst_102435 = inst_102453;
var inst_102436 = (0);
var state_102481__$1 = (function (){var statearr_102500 = state_102481;
(statearr_102500[(9)] = inst_102434);

(statearr_102500[(10)] = inst_102433);

(statearr_102500[(11)] = inst_102436);

(statearr_102500[(12)] = inst_102435);

return statearr_102500;
})();
var statearr_102501_102531 = state_102481__$1;
(statearr_102501_102531[(2)] = null);

(statearr_102501_102531[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102482 === (3))){
var inst_102479 = (state_102481[(2)]);
var state_102481__$1 = state_102481;
return cljs.core.async.impl.ioc_helpers.return_chan(state_102481__$1,inst_102479);
} else {
if((state_val_102482 === (12))){
var inst_102467 = (state_102481[(2)]);
var state_102481__$1 = state_102481;
var statearr_102502_102532 = state_102481__$1;
(statearr_102502_102532[(2)] = inst_102467);

(statearr_102502_102532[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102482 === (2))){
var state_102481__$1 = state_102481;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_102481__$1,(4),in$);
} else {
if((state_val_102482 === (23))){
var inst_102475 = (state_102481[(2)]);
var state_102481__$1 = state_102481;
var statearr_102503_102533 = state_102481__$1;
(statearr_102503_102533[(2)] = inst_102475);

(statearr_102503_102533[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102482 === (19))){
var inst_102462 = (state_102481[(2)]);
var state_102481__$1 = state_102481;
var statearr_102504_102534 = state_102481__$1;
(statearr_102504_102534[(2)] = inst_102462);

(statearr_102504_102534[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102482 === (11))){
var inst_102447 = (state_102481[(7)]);
var inst_102433 = (state_102481[(10)]);
var inst_102447__$1 = cljs.core.seq(inst_102433);
var state_102481__$1 = (function (){var statearr_102505 = state_102481;
(statearr_102505[(7)] = inst_102447__$1);

return statearr_102505;
})();
if(inst_102447__$1){
var statearr_102506_102535 = state_102481__$1;
(statearr_102506_102535[(1)] = (14));

} else {
var statearr_102507_102536 = state_102481__$1;
(statearr_102507_102536[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_102482 === (9))){
var inst_102469 = (state_102481[(2)]);
var inst_102470 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_102481__$1 = (function (){var statearr_102508 = state_102481;
(statearr_102508[(15)] = inst_102469);

return statearr_102508;
})();
if(cljs.core.truth_(inst_102470)){
var statearr_102509_102537 = state_102481__$1;
(statearr_102509_102537[(1)] = (21));

} else {
var statearr_102510_102538 = state_102481__$1;
(statearr_102510_102538[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_102482 === (5))){
var inst_102425 = cljs.core.async.close_BANG_(out);
var state_102481__$1 = state_102481;
var statearr_102511_102539 = state_102481__$1;
(statearr_102511_102539[(2)] = inst_102425);

(statearr_102511_102539[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102482 === (14))){
var inst_102447 = (state_102481[(7)]);
var inst_102449 = cljs.core.chunked_seq_QMARK_(inst_102447);
var state_102481__$1 = state_102481;
if(inst_102449){
var statearr_102512_102540 = state_102481__$1;
(statearr_102512_102540[(1)] = (17));

} else {
var statearr_102513_102541 = state_102481__$1;
(statearr_102513_102541[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_102482 === (16))){
var inst_102465 = (state_102481[(2)]);
var state_102481__$1 = state_102481;
var statearr_102514_102542 = state_102481__$1;
(statearr_102514_102542[(2)] = inst_102465);

(statearr_102514_102542[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102482 === (10))){
var inst_102434 = (state_102481[(9)]);
var inst_102436 = (state_102481[(11)]);
var inst_102441 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_102434,inst_102436);
var state_102481__$1 = state_102481;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_102481__$1,(13),out,inst_102441);
} else {
if((state_val_102482 === (18))){
var inst_102447 = (state_102481[(7)]);
var inst_102456 = cljs.core.first(inst_102447);
var state_102481__$1 = state_102481;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_102481__$1,(20),out,inst_102456);
} else {
if((state_val_102482 === (8))){
var inst_102436 = (state_102481[(11)]);
var inst_102435 = (state_102481[(12)]);
var inst_102438 = (inst_102436 < inst_102435);
var inst_102439 = inst_102438;
var state_102481__$1 = state_102481;
if(cljs.core.truth_(inst_102439)){
var statearr_102515_102543 = state_102481__$1;
(statearr_102515_102543[(1)] = (10));

} else {
var statearr_102516_102544 = state_102481__$1;
(statearr_102516_102544[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__100742__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__100742__auto____0 = (function (){
var statearr_102517 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_102517[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__100742__auto__);

(statearr_102517[(1)] = (1));

return statearr_102517;
});
var cljs$core$async$mapcat_STAR__$_state_machine__100742__auto____1 = (function (state_102481){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_102481);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e102518){if((e102518 instanceof Object)){
var ex__100745__auto__ = e102518;
var statearr_102519_102545 = state_102481;
(statearr_102519_102545[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_102481);

return cljs.core.cst$kw$recur;
} else {
throw e102518;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__102546 = state_102481;
state_102481 = G__102546;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__100742__auto__ = function(state_102481){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__100742__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__100742__auto____1.call(this,state_102481);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__100742__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__100742__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_102520 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_102520[(6)] = c__100848__auto__);

return statearr_102520;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__102548 = arguments.length;
switch (G__102548) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__102551 = arguments.length;
switch (G__102551) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__102554 = arguments.length;
switch (G__102554) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__100848__auto___102601 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_102578){
var state_val_102579 = (state_102578[(1)]);
if((state_val_102579 === (7))){
var inst_102573 = (state_102578[(2)]);
var state_102578__$1 = state_102578;
var statearr_102580_102602 = state_102578__$1;
(statearr_102580_102602[(2)] = inst_102573);

(statearr_102580_102602[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102579 === (1))){
var inst_102555 = null;
var state_102578__$1 = (function (){var statearr_102581 = state_102578;
(statearr_102581[(7)] = inst_102555);

return statearr_102581;
})();
var statearr_102582_102603 = state_102578__$1;
(statearr_102582_102603[(2)] = null);

(statearr_102582_102603[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102579 === (4))){
var inst_102558 = (state_102578[(8)]);
var inst_102558__$1 = (state_102578[(2)]);
var inst_102559 = (inst_102558__$1 == null);
var inst_102560 = cljs.core.not(inst_102559);
var state_102578__$1 = (function (){var statearr_102583 = state_102578;
(statearr_102583[(8)] = inst_102558__$1);

return statearr_102583;
})();
if(inst_102560){
var statearr_102584_102604 = state_102578__$1;
(statearr_102584_102604[(1)] = (5));

} else {
var statearr_102585_102605 = state_102578__$1;
(statearr_102585_102605[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_102579 === (6))){
var state_102578__$1 = state_102578;
var statearr_102586_102606 = state_102578__$1;
(statearr_102586_102606[(2)] = null);

(statearr_102586_102606[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102579 === (3))){
var inst_102575 = (state_102578[(2)]);
var inst_102576 = cljs.core.async.close_BANG_(out);
var state_102578__$1 = (function (){var statearr_102587 = state_102578;
(statearr_102587[(9)] = inst_102575);

return statearr_102587;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_102578__$1,inst_102576);
} else {
if((state_val_102579 === (2))){
var state_102578__$1 = state_102578;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_102578__$1,(4),ch);
} else {
if((state_val_102579 === (11))){
var inst_102558 = (state_102578[(8)]);
var inst_102567 = (state_102578[(2)]);
var inst_102555 = inst_102558;
var state_102578__$1 = (function (){var statearr_102588 = state_102578;
(statearr_102588[(7)] = inst_102555);

(statearr_102588[(10)] = inst_102567);

return statearr_102588;
})();
var statearr_102589_102607 = state_102578__$1;
(statearr_102589_102607[(2)] = null);

(statearr_102589_102607[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102579 === (9))){
var inst_102558 = (state_102578[(8)]);
var state_102578__$1 = state_102578;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_102578__$1,(11),out,inst_102558);
} else {
if((state_val_102579 === (5))){
var inst_102555 = (state_102578[(7)]);
var inst_102558 = (state_102578[(8)]);
var inst_102562 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_102558,inst_102555);
var state_102578__$1 = state_102578;
if(inst_102562){
var statearr_102591_102608 = state_102578__$1;
(statearr_102591_102608[(1)] = (8));

} else {
var statearr_102592_102609 = state_102578__$1;
(statearr_102592_102609[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_102579 === (10))){
var inst_102570 = (state_102578[(2)]);
var state_102578__$1 = state_102578;
var statearr_102593_102610 = state_102578__$1;
(statearr_102593_102610[(2)] = inst_102570);

(statearr_102593_102610[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102579 === (8))){
var inst_102555 = (state_102578[(7)]);
var tmp102590 = inst_102555;
var inst_102555__$1 = tmp102590;
var state_102578__$1 = (function (){var statearr_102594 = state_102578;
(statearr_102594[(7)] = inst_102555__$1);

return statearr_102594;
})();
var statearr_102595_102611 = state_102578__$1;
(statearr_102595_102611[(2)] = null);

(statearr_102595_102611[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__100742__auto__ = null;
var cljs$core$async$state_machine__100742__auto____0 = (function (){
var statearr_102596 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_102596[(0)] = cljs$core$async$state_machine__100742__auto__);

(statearr_102596[(1)] = (1));

return statearr_102596;
});
var cljs$core$async$state_machine__100742__auto____1 = (function (state_102578){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_102578);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e102597){if((e102597 instanceof Object)){
var ex__100745__auto__ = e102597;
var statearr_102598_102612 = state_102578;
(statearr_102598_102612[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_102578);

return cljs.core.cst$kw$recur;
} else {
throw e102597;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__102613 = state_102578;
state_102578 = G__102613;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
cljs$core$async$state_machine__100742__auto__ = function(state_102578){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__100742__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__100742__auto____1.call(this,state_102578);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__100742__auto____0;
cljs$core$async$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__100742__auto____1;
return cljs$core$async$state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_102599 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_102599[(6)] = c__100848__auto___102601);

return statearr_102599;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__102615 = arguments.length;
switch (G__102615) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__100848__auto___102681 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_102653){
var state_val_102654 = (state_102653[(1)]);
if((state_val_102654 === (7))){
var inst_102649 = (state_102653[(2)]);
var state_102653__$1 = state_102653;
var statearr_102655_102682 = state_102653__$1;
(statearr_102655_102682[(2)] = inst_102649);

(statearr_102655_102682[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102654 === (1))){
var inst_102616 = (new Array(n));
var inst_102617 = inst_102616;
var inst_102618 = (0);
var state_102653__$1 = (function (){var statearr_102656 = state_102653;
(statearr_102656[(7)] = inst_102618);

(statearr_102656[(8)] = inst_102617);

return statearr_102656;
})();
var statearr_102657_102683 = state_102653__$1;
(statearr_102657_102683[(2)] = null);

(statearr_102657_102683[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102654 === (4))){
var inst_102621 = (state_102653[(9)]);
var inst_102621__$1 = (state_102653[(2)]);
var inst_102622 = (inst_102621__$1 == null);
var inst_102623 = cljs.core.not(inst_102622);
var state_102653__$1 = (function (){var statearr_102658 = state_102653;
(statearr_102658[(9)] = inst_102621__$1);

return statearr_102658;
})();
if(inst_102623){
var statearr_102659_102684 = state_102653__$1;
(statearr_102659_102684[(1)] = (5));

} else {
var statearr_102660_102685 = state_102653__$1;
(statearr_102660_102685[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_102654 === (15))){
var inst_102643 = (state_102653[(2)]);
var state_102653__$1 = state_102653;
var statearr_102661_102686 = state_102653__$1;
(statearr_102661_102686[(2)] = inst_102643);

(statearr_102661_102686[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102654 === (13))){
var state_102653__$1 = state_102653;
var statearr_102662_102687 = state_102653__$1;
(statearr_102662_102687[(2)] = null);

(statearr_102662_102687[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102654 === (6))){
var inst_102618 = (state_102653[(7)]);
var inst_102639 = (inst_102618 > (0));
var state_102653__$1 = state_102653;
if(cljs.core.truth_(inst_102639)){
var statearr_102663_102688 = state_102653__$1;
(statearr_102663_102688[(1)] = (12));

} else {
var statearr_102664_102689 = state_102653__$1;
(statearr_102664_102689[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_102654 === (3))){
var inst_102651 = (state_102653[(2)]);
var state_102653__$1 = state_102653;
return cljs.core.async.impl.ioc_helpers.return_chan(state_102653__$1,inst_102651);
} else {
if((state_val_102654 === (12))){
var inst_102617 = (state_102653[(8)]);
var inst_102641 = cljs.core.vec(inst_102617);
var state_102653__$1 = state_102653;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_102653__$1,(15),out,inst_102641);
} else {
if((state_val_102654 === (2))){
var state_102653__$1 = state_102653;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_102653__$1,(4),ch);
} else {
if((state_val_102654 === (11))){
var inst_102633 = (state_102653[(2)]);
var inst_102634 = (new Array(n));
var inst_102617 = inst_102634;
var inst_102618 = (0);
var state_102653__$1 = (function (){var statearr_102665 = state_102653;
(statearr_102665[(10)] = inst_102633);

(statearr_102665[(7)] = inst_102618);

(statearr_102665[(8)] = inst_102617);

return statearr_102665;
})();
var statearr_102666_102690 = state_102653__$1;
(statearr_102666_102690[(2)] = null);

(statearr_102666_102690[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102654 === (9))){
var inst_102617 = (state_102653[(8)]);
var inst_102631 = cljs.core.vec(inst_102617);
var state_102653__$1 = state_102653;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_102653__$1,(11),out,inst_102631);
} else {
if((state_val_102654 === (5))){
var inst_102618 = (state_102653[(7)]);
var inst_102617 = (state_102653[(8)]);
var inst_102621 = (state_102653[(9)]);
var inst_102626 = (state_102653[(11)]);
var inst_102625 = (inst_102617[inst_102618] = inst_102621);
var inst_102626__$1 = (inst_102618 + (1));
var inst_102627 = (inst_102626__$1 < n);
var state_102653__$1 = (function (){var statearr_102667 = state_102653;
(statearr_102667[(11)] = inst_102626__$1);

(statearr_102667[(12)] = inst_102625);

return statearr_102667;
})();
if(cljs.core.truth_(inst_102627)){
var statearr_102668_102691 = state_102653__$1;
(statearr_102668_102691[(1)] = (8));

} else {
var statearr_102669_102692 = state_102653__$1;
(statearr_102669_102692[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_102654 === (14))){
var inst_102646 = (state_102653[(2)]);
var inst_102647 = cljs.core.async.close_BANG_(out);
var state_102653__$1 = (function (){var statearr_102671 = state_102653;
(statearr_102671[(13)] = inst_102646);

return statearr_102671;
})();
var statearr_102672_102693 = state_102653__$1;
(statearr_102672_102693[(2)] = inst_102647);

(statearr_102672_102693[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102654 === (10))){
var inst_102637 = (state_102653[(2)]);
var state_102653__$1 = state_102653;
var statearr_102673_102694 = state_102653__$1;
(statearr_102673_102694[(2)] = inst_102637);

(statearr_102673_102694[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102654 === (8))){
var inst_102617 = (state_102653[(8)]);
var inst_102626 = (state_102653[(11)]);
var tmp102670 = inst_102617;
var inst_102617__$1 = tmp102670;
var inst_102618 = inst_102626;
var state_102653__$1 = (function (){var statearr_102674 = state_102653;
(statearr_102674[(7)] = inst_102618);

(statearr_102674[(8)] = inst_102617__$1);

return statearr_102674;
})();
var statearr_102675_102695 = state_102653__$1;
(statearr_102675_102695[(2)] = null);

(statearr_102675_102695[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__100742__auto__ = null;
var cljs$core$async$state_machine__100742__auto____0 = (function (){
var statearr_102676 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_102676[(0)] = cljs$core$async$state_machine__100742__auto__);

(statearr_102676[(1)] = (1));

return statearr_102676;
});
var cljs$core$async$state_machine__100742__auto____1 = (function (state_102653){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_102653);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e102677){if((e102677 instanceof Object)){
var ex__100745__auto__ = e102677;
var statearr_102678_102696 = state_102653;
(statearr_102678_102696[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_102653);

return cljs.core.cst$kw$recur;
} else {
throw e102677;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__102697 = state_102653;
state_102653 = G__102697;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
cljs$core$async$state_machine__100742__auto__ = function(state_102653){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__100742__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__100742__auto____1.call(this,state_102653);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__100742__auto____0;
cljs$core$async$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__100742__auto____1;
return cljs$core$async$state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_102679 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_102679[(6)] = c__100848__auto___102681);

return statearr_102679;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__102699 = arguments.length;
switch (G__102699) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__100848__auto___102769 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_102741){
var state_val_102742 = (state_102741[(1)]);
if((state_val_102742 === (7))){
var inst_102737 = (state_102741[(2)]);
var state_102741__$1 = state_102741;
var statearr_102743_102770 = state_102741__$1;
(statearr_102743_102770[(2)] = inst_102737);

(statearr_102743_102770[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102742 === (1))){
var inst_102700 = [];
var inst_102701 = inst_102700;
var inst_102702 = cljs.core.cst$kw$cljs$core$async_SLASH_nothing;
var state_102741__$1 = (function (){var statearr_102744 = state_102741;
(statearr_102744[(7)] = inst_102701);

(statearr_102744[(8)] = inst_102702);

return statearr_102744;
})();
var statearr_102745_102771 = state_102741__$1;
(statearr_102745_102771[(2)] = null);

(statearr_102745_102771[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102742 === (4))){
var inst_102705 = (state_102741[(9)]);
var inst_102705__$1 = (state_102741[(2)]);
var inst_102706 = (inst_102705__$1 == null);
var inst_102707 = cljs.core.not(inst_102706);
var state_102741__$1 = (function (){var statearr_102746 = state_102741;
(statearr_102746[(9)] = inst_102705__$1);

return statearr_102746;
})();
if(inst_102707){
var statearr_102747_102772 = state_102741__$1;
(statearr_102747_102772[(1)] = (5));

} else {
var statearr_102748_102773 = state_102741__$1;
(statearr_102748_102773[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_102742 === (15))){
var inst_102731 = (state_102741[(2)]);
var state_102741__$1 = state_102741;
var statearr_102749_102774 = state_102741__$1;
(statearr_102749_102774[(2)] = inst_102731);

(statearr_102749_102774[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102742 === (13))){
var state_102741__$1 = state_102741;
var statearr_102750_102775 = state_102741__$1;
(statearr_102750_102775[(2)] = null);

(statearr_102750_102775[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102742 === (6))){
var inst_102701 = (state_102741[(7)]);
var inst_102726 = inst_102701.length;
var inst_102727 = (inst_102726 > (0));
var state_102741__$1 = state_102741;
if(cljs.core.truth_(inst_102727)){
var statearr_102751_102776 = state_102741__$1;
(statearr_102751_102776[(1)] = (12));

} else {
var statearr_102752_102777 = state_102741__$1;
(statearr_102752_102777[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_102742 === (3))){
var inst_102739 = (state_102741[(2)]);
var state_102741__$1 = state_102741;
return cljs.core.async.impl.ioc_helpers.return_chan(state_102741__$1,inst_102739);
} else {
if((state_val_102742 === (12))){
var inst_102701 = (state_102741[(7)]);
var inst_102729 = cljs.core.vec(inst_102701);
var state_102741__$1 = state_102741;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_102741__$1,(15),out,inst_102729);
} else {
if((state_val_102742 === (2))){
var state_102741__$1 = state_102741;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_102741__$1,(4),ch);
} else {
if((state_val_102742 === (11))){
var inst_102705 = (state_102741[(9)]);
var inst_102709 = (state_102741[(10)]);
var inst_102719 = (state_102741[(2)]);
var inst_102720 = [];
var inst_102721 = inst_102720.push(inst_102705);
var inst_102701 = inst_102720;
var inst_102702 = inst_102709;
var state_102741__$1 = (function (){var statearr_102753 = state_102741;
(statearr_102753[(7)] = inst_102701);

(statearr_102753[(11)] = inst_102721);

(statearr_102753[(8)] = inst_102702);

(statearr_102753[(12)] = inst_102719);

return statearr_102753;
})();
var statearr_102754_102778 = state_102741__$1;
(statearr_102754_102778[(2)] = null);

(statearr_102754_102778[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102742 === (9))){
var inst_102701 = (state_102741[(7)]);
var inst_102717 = cljs.core.vec(inst_102701);
var state_102741__$1 = state_102741;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_102741__$1,(11),out,inst_102717);
} else {
if((state_val_102742 === (5))){
var inst_102702 = (state_102741[(8)]);
var inst_102705 = (state_102741[(9)]);
var inst_102709 = (state_102741[(10)]);
var inst_102709__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_102705) : f.call(null,inst_102705));
var inst_102710 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_102709__$1,inst_102702);
var inst_102711 = cljs.core.keyword_identical_QMARK_(inst_102702,cljs.core.cst$kw$cljs$core$async_SLASH_nothing);
var inst_102712 = ((inst_102710) || (inst_102711));
var state_102741__$1 = (function (){var statearr_102755 = state_102741;
(statearr_102755[(10)] = inst_102709__$1);

return statearr_102755;
})();
if(cljs.core.truth_(inst_102712)){
var statearr_102756_102779 = state_102741__$1;
(statearr_102756_102779[(1)] = (8));

} else {
var statearr_102757_102780 = state_102741__$1;
(statearr_102757_102780[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_102742 === (14))){
var inst_102734 = (state_102741[(2)]);
var inst_102735 = cljs.core.async.close_BANG_(out);
var state_102741__$1 = (function (){var statearr_102759 = state_102741;
(statearr_102759[(13)] = inst_102734);

return statearr_102759;
})();
var statearr_102760_102781 = state_102741__$1;
(statearr_102760_102781[(2)] = inst_102735);

(statearr_102760_102781[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102742 === (10))){
var inst_102724 = (state_102741[(2)]);
var state_102741__$1 = state_102741;
var statearr_102761_102782 = state_102741__$1;
(statearr_102761_102782[(2)] = inst_102724);

(statearr_102761_102782[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102742 === (8))){
var inst_102701 = (state_102741[(7)]);
var inst_102705 = (state_102741[(9)]);
var inst_102709 = (state_102741[(10)]);
var inst_102714 = inst_102701.push(inst_102705);
var tmp102758 = inst_102701;
var inst_102701__$1 = tmp102758;
var inst_102702 = inst_102709;
var state_102741__$1 = (function (){var statearr_102762 = state_102741;
(statearr_102762[(7)] = inst_102701__$1);

(statearr_102762[(14)] = inst_102714);

(statearr_102762[(8)] = inst_102702);

return statearr_102762;
})();
var statearr_102763_102783 = state_102741__$1;
(statearr_102763_102783[(2)] = null);

(statearr_102763_102783[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__100742__auto__ = null;
var cljs$core$async$state_machine__100742__auto____0 = (function (){
var statearr_102764 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_102764[(0)] = cljs$core$async$state_machine__100742__auto__);

(statearr_102764[(1)] = (1));

return statearr_102764;
});
var cljs$core$async$state_machine__100742__auto____1 = (function (state_102741){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_102741);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e102765){if((e102765 instanceof Object)){
var ex__100745__auto__ = e102765;
var statearr_102766_102784 = state_102741;
(statearr_102766_102784[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_102741);

return cljs.core.cst$kw$recur;
} else {
throw e102765;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__102785 = state_102741;
state_102741 = G__102785;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
cljs$core$async$state_machine__100742__auto__ = function(state_102741){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__100742__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__100742__auto____1.call(this,state_102741);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__100742__auto____0;
cljs$core$async$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__100742__auto____1;
return cljs$core$async$state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_102767 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_102767[(6)] = c__100848__auto___102769);

return statearr_102767;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);

