// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.util.async');
goog.require('cljs.core');
goog.require('cljs.core.async');
fluree.db.util.async.throw_err = (function fluree$db$util$async$throw_err(e){
if((e instanceof Error)){
throw e;
} else {
}

return e;
});
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
fluree.db.util.async.throw_if_exception = (function fluree$db$util$async$throw_if_exception(x){
if((x instanceof Error)){
throw cljs.core.ex_info.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),(function (){var or__4126__auto__ = cljs.core.ex_data.call(null,x);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
/**
 * Takes a sequence of single-value chans and returns the conjoined into collection.
 *   Realizes entire channel sequence first, and if an error value exists returns just the exception.
 */
fluree.db.util.async.merge_into_QMARK_ = (function fluree$db$util$async$merge_into_QMARK_(coll,chs){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_102376){
var state_val_102377 = (state_102376[(1)]);
if((state_val_102377 === (7))){
var inst_102353 = (state_102376[(7)]);
var state_102376__$1 = state_102376;
var statearr_102378_102394 = state_102376__$1;
(statearr_102378_102394[(2)] = inst_102353);

(statearr_102378_102394[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102377 === (1))){
var state_102376__$1 = state_102376;
var statearr_102379_102395 = state_102376__$1;
(statearr_102379_102395[(2)] = null);

(statearr_102379_102395[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102377 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_102376,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var inst_102349 = cljs.core.seq.call(null,chs);
var inst_102350 = cljs.core.first.call(null,inst_102349);
var inst_102351 = cljs.core.next.call(null,inst_102349);
var inst_102352 = chs;
var inst_102353 = coll;
var state_102376__$1 = (function (){var statearr_102380 = state_102376;
(statearr_102380[(8)] = inst_102352);

(statearr_102380[(9)] = inst_102350);

(statearr_102380[(7)] = inst_102353);

(statearr_102380[(10)] = inst_102351);

return statearr_102380;
})();
var statearr_102381_102396 = state_102376__$1;
(statearr_102381_102396[(2)] = null);

(statearr_102381_102396[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102377 === (6))){
var inst_102372 = (state_102376[(2)]);
var state_102376__$1 = state_102376;
var statearr_102382_102397 = state_102376__$1;
(statearr_102382_102397[(2)] = inst_102372);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_102376__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102377 === (3))){
var inst_102338 = (state_102376[(2)]);
var state_102376__$1 = state_102376;
var statearr_102383_102398 = state_102376__$1;
(statearr_102383_102398[(2)] = inst_102338);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_102376__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102377 === (2))){
var inst_102374 = (state_102376[(2)]);
var state_102376__$1 = state_102376;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_102376__$1,inst_102374);
} else {
if((state_val_102377 === (9))){
var inst_102370 = (state_102376[(2)]);
var state_102376__$1 = state_102376;
var statearr_102384_102399 = state_102376__$1;
(statearr_102384_102399[(2)] = inst_102370);

(statearr_102384_102399[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102377 === (5))){
var inst_102352 = (state_102376[(8)]);
var inst_102359 = (state_102376[(11)]);
var inst_102358 = cljs.core.seq.call(null,inst_102352);
var inst_102359__$1 = cljs.core.first.call(null,inst_102358);
var inst_102360 = cljs.core.next.call(null,inst_102358);
var inst_102361 = cljs.core.not.call(null,inst_102359__$1);
var state_102376__$1 = (function (){var statearr_102385 = state_102376;
(statearr_102385[(11)] = inst_102359__$1);

(statearr_102385[(12)] = inst_102360);

return statearr_102385;
})();
if(inst_102361){
var statearr_102386_102400 = state_102376__$1;
(statearr_102386_102400[(1)] = (7));

} else {
var statearr_102387_102401 = state_102376__$1;
(statearr_102387_102401[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102377 === (10))){
var inst_102353 = (state_102376[(7)]);
var inst_102360 = (state_102376[(12)]);
var inst_102365 = (state_102376[(2)]);
var inst_102366 = fluree.db.util.async.throw_err.call(null,inst_102365);
var inst_102367 = cljs.core.conj.call(null,inst_102353,inst_102366);
var inst_102352 = inst_102360;
var inst_102353__$1 = inst_102367;
var state_102376__$1 = (function (){var statearr_102388 = state_102376;
(statearr_102388[(8)] = inst_102352);

(statearr_102388[(7)] = inst_102353__$1);

return statearr_102388;
})();
var statearr_102389_102402 = state_102376__$1;
(statearr_102389_102402[(2)] = null);

(statearr_102389_102402[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102377 === (8))){
var inst_102359 = (state_102376[(11)]);
var state_102376__$1 = state_102376;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_102376__$1,(10),inst_102359);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$merge_into_QMARK__$_state_machine__99975__auto__ = null;
var fluree$db$util$async$merge_into_QMARK__$_state_machine__99975__auto____0 = (function (){
var statearr_102390 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_102390[(0)] = fluree$db$util$async$merge_into_QMARK__$_state_machine__99975__auto__);

(statearr_102390[(1)] = (1));

return statearr_102390;
});
var fluree$db$util$async$merge_into_QMARK__$_state_machine__99975__auto____1 = (function (state_102376){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_102376);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e102391){if((e102391 instanceof Object)){
var ex__99978__auto__ = e102391;
var statearr_102392_102403 = state_102376;
(statearr_102392_102403[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_102376);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e102391;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__102404 = state_102376;
state_102376 = G__102404;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$util$async$merge_into_QMARK__$_state_machine__99975__auto__ = function(state_102376){
switch(arguments.length){
case 0:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__99975__auto____1.call(this,state_102376);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$merge_into_QMARK__$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$merge_into_QMARK__$_state_machine__99975__auto____0;
fluree$db$util$async$merge_into_QMARK__$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$merge_into_QMARK__$_state_machine__99975__auto____1;
return fluree$db$util$async$merge_into_QMARK__$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_102393 = f__100070__auto__.call(null);
(statearr_102393[(6)] = c__100069__auto__);

return statearr_102393;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Like async/into, but checks each item for an error response and returns exception
 *   onto the response channel insted of results if thee is one.
 */
fluree.db.util.async.into_QMARK_ = (function fluree$db$util$async$into_QMARK_(coll,chan){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_102426){
var state_val_102427 = (state_102426[(1)]);
if((state_val_102427 === (7))){
var inst_102413 = (state_102426[(7)]);
var inst_102412 = (state_102426[(2)]);
var inst_102413__$1 = fluree.db.util.async.throw_err.call(null,inst_102412);
var inst_102414 = (inst_102413__$1 == null);
var state_102426__$1 = (function (){var statearr_102428 = state_102426;
(statearr_102428[(7)] = inst_102413__$1);

return statearr_102428;
})();
if(cljs.core.truth_(inst_102414)){
var statearr_102429_102444 = state_102426__$1;
(statearr_102429_102444[(1)] = (8));

} else {
var statearr_102430_102445 = state_102426__$1;
(statearr_102430_102445[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102427 === (1))){
var state_102426__$1 = state_102426;
var statearr_102431_102446 = state_102426__$1;
(statearr_102431_102446[(2)] = null);

(statearr_102431_102446[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102427 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_102426,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var inst_102409 = coll;
var state_102426__$1 = (function (){var statearr_102432 = state_102426;
(statearr_102432[(8)] = inst_102409);

return statearr_102432;
})();
var statearr_102433_102447 = state_102426__$1;
(statearr_102433_102447[(2)] = null);

(statearr_102433_102447[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102427 === (6))){
var inst_102422 = (state_102426[(2)]);
var state_102426__$1 = state_102426;
var statearr_102434_102448 = state_102426__$1;
(statearr_102434_102448[(2)] = inst_102422);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_102426__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102427 === (3))){
var inst_102405 = (state_102426[(2)]);
var state_102426__$1 = state_102426;
var statearr_102435_102449 = state_102426__$1;
(statearr_102435_102449[(2)] = inst_102405);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_102426__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102427 === (2))){
var inst_102424 = (state_102426[(2)]);
var state_102426__$1 = state_102426;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_102426__$1,inst_102424);
} else {
if((state_val_102427 === (9))){
var inst_102409 = (state_102426[(8)]);
var inst_102413 = (state_102426[(7)]);
var inst_102417 = cljs.core.conj.call(null,inst_102409,inst_102413);
var inst_102409__$1 = inst_102417;
var state_102426__$1 = (function (){var statearr_102436 = state_102426;
(statearr_102436[(8)] = inst_102409__$1);

return statearr_102436;
})();
var statearr_102437_102450 = state_102426__$1;
(statearr_102437_102450[(2)] = null);

(statearr_102437_102450[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102427 === (5))){
var state_102426__$1 = state_102426;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_102426__$1,(7),chan);
} else {
if((state_val_102427 === (10))){
var inst_102420 = (state_102426[(2)]);
var state_102426__$1 = state_102426;
var statearr_102438_102451 = state_102426__$1;
(statearr_102438_102451[(2)] = inst_102420);

(statearr_102438_102451[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102427 === (8))){
var inst_102409 = (state_102426[(8)]);
var state_102426__$1 = state_102426;
var statearr_102439_102452 = state_102426__$1;
(statearr_102439_102452[(2)] = inst_102409);

(statearr_102439_102452[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$into_QMARK__$_state_machine__99975__auto__ = null;
var fluree$db$util$async$into_QMARK__$_state_machine__99975__auto____0 = (function (){
var statearr_102440 = [null,null,null,null,null,null,null,null,null];
(statearr_102440[(0)] = fluree$db$util$async$into_QMARK__$_state_machine__99975__auto__);

(statearr_102440[(1)] = (1));

return statearr_102440;
});
var fluree$db$util$async$into_QMARK__$_state_machine__99975__auto____1 = (function (state_102426){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_102426);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e102441){if((e102441 instanceof Object)){
var ex__99978__auto__ = e102441;
var statearr_102442_102453 = state_102426;
(statearr_102442_102453[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_102426);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e102441;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__102454 = state_102426;
state_102426 = G__102454;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$util$async$into_QMARK__$_state_machine__99975__auto__ = function(state_102426){
switch(arguments.length){
case 0:
return fluree$db$util$async$into_QMARK__$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$util$async$into_QMARK__$_state_machine__99975__auto____1.call(this,state_102426);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$into_QMARK__$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$into_QMARK__$_state_machine__99975__auto____0;
fluree$db$util$async$into_QMARK__$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$into_QMARK__$_state_machine__99975__auto____1;
return fluree$db$util$async$into_QMARK__$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_102443 = f__100070__auto__.call(null);
(statearr_102443[(6)] = c__100069__auto__);

return statearr_102443;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Returns true if core async channel.
 */
fluree.db.util.async.channel_QMARK_ = (function fluree$db$util$async$channel_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$Channel$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.Channel,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.Channel,x);
}
});
