// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.storage.core');
goog.require('cljs.core');
goog.require('fluree.db.serde.protocol');
goog.require('fluree.db.flake');
goog.require('clojure.data.avl');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
/**
 * Returns truthy if the provided key exists in storage.
 */
fluree.db.storage.core.storage_exists_QMARK_ = (function fluree$db$storage$core$storage_exists_QMARK_(conn,key){
var storage_exists_fn = new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075).cljs$core$IFn$_invoke$arity$1(conn);
return storage_exists_fn.call(null,key);
});
/**
 * Reads raw bytes from storage based on provided key.
 *   Returns core async channel with eventual response
 */
fluree.db.storage.core.storage_read = (function fluree$db$storage$core$storage_read(conn,key){
var storage_read_fn = new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(conn);
return storage_read_fn.call(null,key);
});
/**
 * Writes raw bytes to storage based with provided key.
 */
fluree.db.storage.core.storage_write = (function fluree$db$storage$core$storage_write(conn,key,val){
var storage_write_fn = new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(conn);
return storage_write_fn.call(null,key,val);
});
/**
 * Returns serializer from connection.
 */
fluree.db.storage.core.serde = (function fluree$db$storage$core$serde(conn){
return new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(conn);
});
fluree.db.storage.core.ledger_root_key = (function fluree$db$storage$core$ledger_root_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_root_",fluree.db.util.core.zero_pad.call(null,block,(15))].join('');
});
fluree.db.storage.core.ledger_garbage_key = (function fluree$db$storage$core$ledger_garbage_key(network,ledger_key,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_key),"_garbage_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join('');
});
fluree.db.storage.core.ledger_node_key = (function fluree$db$storage$core$ledger_node_key(network,ledger_id,idx_type,base_id,node_type){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_",cljs.core.name.call(null,idx_type),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(base_id),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_type)].join('');
});
fluree.db.storage.core.ledger_block_key = (function fluree$db$storage$core$ledger_block_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_block_",fluree.db.util.core.zero_pad.call(null,block,(15))].join('');
});
fluree.db.storage.core.ledger_block_file_path = (function fluree$db$storage$core$ledger_block_file_path(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"/block/",fluree.db.util.core.zero_pad.call(null,block,(15))].join('');
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block = (function fluree$db$storage$core$read_block(conn,network,ledger_id,block){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_105769){
var state_val_105770 = (state_105769[(1)]);
if((state_val_105770 === (1))){
var state_105769__$1 = state_105769;
var statearr_105771_105783 = state_105769__$1;
(statearr_105771_105783[(2)] = null);

(statearr_105771_105783[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105770 === (2))){
var inst_105767 = (state_105769[(2)]);
var state_105769__$1 = state_105769;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_105769__$1,inst_105767);
} else {
if((state_val_105770 === (3))){
var inst_105751 = (state_105769[(2)]);
var state_105769__$1 = state_105769;
var statearr_105772_105784 = state_105769__$1;
(statearr_105772_105784[(2)] = inst_105751);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_105769__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105770 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_105769,(3),Error,null,(2));
var inst_105755 = fluree.db.storage.core.ledger_block_key.call(null,network,ledger_id,block);
var inst_105756 = fluree.db.storage.core.storage_read.call(null,conn,inst_105755);
var state_105769__$1 = state_105769;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_105769__$1,(5),inst_105756);
} else {
if((state_val_105770 === (5))){
var inst_105759 = (state_105769[(7)]);
var inst_105758 = (state_105769[(2)]);
var inst_105759__$1 = fluree.db.util.async.throw_err.call(null,inst_105758);
var state_105769__$1 = (function (){var statearr_105773 = state_105769;
(statearr_105773[(7)] = inst_105759__$1);

return statearr_105773;
})();
if(cljs.core.truth_(inst_105759__$1)){
var statearr_105774_105785 = state_105769__$1;
(statearr_105774_105785[(1)] = (6));

} else {
var statearr_105775_105786 = state_105769__$1;
(statearr_105775_105786[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105770 === (6))){
var inst_105759 = (state_105769[(7)]);
var inst_105761 = fluree.db.storage.core.serde.call(null,conn);
var inst_105762 = fluree.db.serde.protocol._deserialize_block.call(null,inst_105761,inst_105759);
var state_105769__$1 = state_105769;
var statearr_105776_105787 = state_105769__$1;
(statearr_105776_105787[(2)] = inst_105762);

(statearr_105776_105787[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105770 === (7))){
var state_105769__$1 = state_105769;
var statearr_105777_105788 = state_105769__$1;
(statearr_105777_105788[(2)] = null);

(statearr_105777_105788[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105770 === (8))){
var inst_105765 = (state_105769[(2)]);
var state_105769__$1 = state_105769;
var statearr_105778_105789 = state_105769__$1;
(statearr_105778_105789[(2)] = inst_105765);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_105769__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_$_state_machine__99975__auto__ = null;
var fluree$db$storage$core$read_block_$_state_machine__99975__auto____0 = (function (){
var statearr_105779 = [null,null,null,null,null,null,null,null];
(statearr_105779[(0)] = fluree$db$storage$core$read_block_$_state_machine__99975__auto__);

(statearr_105779[(1)] = (1));

return statearr_105779;
});
var fluree$db$storage$core$read_block_$_state_machine__99975__auto____1 = (function (state_105769){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_105769);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e105780){if((e105780 instanceof Object)){
var ex__99978__auto__ = e105780;
var statearr_105781_105790 = state_105769;
(statearr_105781_105790[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_105769);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e105780;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__105791 = state_105769;
state_105769 = G__105791;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_$_state_machine__99975__auto__ = function(state_105769){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_$_state_machine__99975__auto____1.call(this,state_105769);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_$_state_machine__99975__auto____0;
fluree$db$storage$core$read_block_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_$_state_machine__99975__auto____1;
return fluree$db$storage$core$read_block_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_105782 = f__100070__auto__.call(null);
(statearr_105782[(6)] = c__100069__auto__);

return statearr_105782;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block_version = (function fluree$db$storage$core$read_block_version(conn,network,ledger_id,block,version){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_105811){
var state_val_105812 = (state_105811[(1)]);
if((state_val_105812 === (1))){
var state_105811__$1 = state_105811;
var statearr_105813_105825 = state_105811__$1;
(statearr_105813_105825[(2)] = null);

(statearr_105813_105825[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105812 === (2))){
var inst_105809 = (state_105811[(2)]);
var state_105811__$1 = state_105811;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_105811__$1,inst_105809);
} else {
if((state_val_105812 === (3))){
var inst_105792 = (state_105811[(2)]);
var state_105811__$1 = state_105811;
var statearr_105814_105826 = state_105811__$1;
(statearr_105814_105826[(2)] = inst_105792);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_105811__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105812 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_105811,(3),Error,null,(2));
var inst_105796 = fluree.db.storage.core.ledger_block_key.call(null,network,ledger_id,block);
var inst_105797 = [inst_105796,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_105798 = fluree.db.storage.core.storage_read.call(null,conn,inst_105797);
var state_105811__$1 = state_105811;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_105811__$1,(5),inst_105798);
} else {
if((state_val_105812 === (5))){
var inst_105801 = (state_105811[(7)]);
var inst_105800 = (state_105811[(2)]);
var inst_105801__$1 = fluree.db.util.async.throw_err.call(null,inst_105800);
var state_105811__$1 = (function (){var statearr_105815 = state_105811;
(statearr_105815[(7)] = inst_105801__$1);

return statearr_105815;
})();
if(cljs.core.truth_(inst_105801__$1)){
var statearr_105816_105827 = state_105811__$1;
(statearr_105816_105827[(1)] = (6));

} else {
var statearr_105817_105828 = state_105811__$1;
(statearr_105817_105828[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105812 === (6))){
var inst_105801 = (state_105811[(7)]);
var inst_105803 = fluree.db.storage.core.serde.call(null,conn);
var inst_105804 = fluree.db.serde.protocol._deserialize_block.call(null,inst_105803,inst_105801);
var state_105811__$1 = state_105811;
var statearr_105818_105829 = state_105811__$1;
(statearr_105818_105829[(2)] = inst_105804);

(statearr_105818_105829[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105812 === (7))){
var state_105811__$1 = state_105811;
var statearr_105819_105830 = state_105811__$1;
(statearr_105819_105830[(2)] = null);

(statearr_105819_105830[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105812 === (8))){
var inst_105807 = (state_105811[(2)]);
var state_105811__$1 = state_105811;
var statearr_105820_105831 = state_105811__$1;
(statearr_105820_105831[(2)] = inst_105807);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_105811__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_version_$_state_machine__99975__auto__ = null;
var fluree$db$storage$core$read_block_version_$_state_machine__99975__auto____0 = (function (){
var statearr_105821 = [null,null,null,null,null,null,null,null];
(statearr_105821[(0)] = fluree$db$storage$core$read_block_version_$_state_machine__99975__auto__);

(statearr_105821[(1)] = (1));

return statearr_105821;
});
var fluree$db$storage$core$read_block_version_$_state_machine__99975__auto____1 = (function (state_105811){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_105811);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e105822){if((e105822 instanceof Object)){
var ex__99978__auto__ = e105822;
var statearr_105823_105832 = state_105811;
(statearr_105823_105832[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_105811);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e105822;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__105833 = state_105811;
state_105811 = G__105833;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_version_$_state_machine__99975__auto__ = function(state_105811){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_version_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_version_$_state_machine__99975__auto____1.call(this,state_105811);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_version_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_version_$_state_machine__99975__auto____0;
fluree$db$storage$core$read_block_version_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_version_$_state_machine__99975__auto____1;
return fluree$db$storage$core$read_block_version_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_105824 = f__100070__auto__.call(null);
(statearr_105824[(6)] = c__100069__auto__);

return statearr_105824;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block_version = (function fluree$db$storage$core$write_block_version(conn,network,dbid,block_data,version){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_105854){
var state_val_105855 = (state_105854[(1)]);
if((state_val_105855 === (1))){
var state_105854__$1 = state_105854;
var statearr_105856_105863 = state_105854__$1;
(statearr_105856_105863[(2)] = null);

(statearr_105856_105863[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105855 === (2))){
var inst_105852 = (state_105854[(2)]);
var state_105854__$1 = state_105854;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_105854__$1,inst_105852);
} else {
if((state_val_105855 === (3))){
var inst_105834 = (state_105854[(2)]);
var state_105854__$1 = state_105854;
var statearr_105857_105864 = state_105854__$1;
(statearr_105857_105864[(2)] = inst_105834);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_105854__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105855 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_105854,(3),Error,null,(2));
var inst_105838 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_105839 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_105840 = (new cljs.core.PersistentVector(null,3,(5),inst_105838,inst_105839,null));
var inst_105841 = cljs.core.select_keys.call(null,block_data,inst_105840);
var inst_105842 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_105841);
var inst_105843 = fluree.db.storage.core.ledger_block_key.call(null,network,dbid,inst_105842);
var inst_105844 = [inst_105843,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_105845 = fluree.db.storage.core.serde.call(null,conn);
var inst_105846 = fluree.db.serde.protocol._serialize_block.call(null,inst_105845,inst_105841);
var inst_105847 = fluree.db.storage.core.storage_write.call(null,conn,inst_105844,inst_105846);
var state_105854__$1 = state_105854;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_105854__$1,(5),inst_105847);
} else {
if((state_val_105855 === (5))){
var inst_105849 = (state_105854[(2)]);
var inst_105850 = fluree.db.util.async.throw_err.call(null,inst_105849);
var state_105854__$1 = state_105854;
var statearr_105858_105865 = state_105854__$1;
(statearr_105858_105865[(2)] = inst_105850);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_105854__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_version_$_state_machine__99975__auto__ = null;
var fluree$db$storage$core$write_block_version_$_state_machine__99975__auto____0 = (function (){
var statearr_105859 = [null,null,null,null,null,null,null];
(statearr_105859[(0)] = fluree$db$storage$core$write_block_version_$_state_machine__99975__auto__);

(statearr_105859[(1)] = (1));

return statearr_105859;
});
var fluree$db$storage$core$write_block_version_$_state_machine__99975__auto____1 = (function (state_105854){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_105854);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e105860){if((e105860 instanceof Object)){
var ex__99978__auto__ = e105860;
var statearr_105861_105866 = state_105854;
(statearr_105861_105866[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_105854);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e105860;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__105867 = state_105854;
state_105854 = G__105867;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_version_$_state_machine__99975__auto__ = function(state_105854){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_version_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_version_$_state_machine__99975__auto____1.call(this,state_105854);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_version_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_version_$_state_machine__99975__auto____0;
fluree$db$storage$core$write_block_version_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_version_$_state_machine__99975__auto____1;
return fluree$db$storage$core$write_block_version_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_105862 = f__100070__auto__.call(null);
(statearr_105862[(6)] = c__100069__auto__);

return statearr_105862;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block = (function fluree$db$storage$core$write_block(conn,network,dbid,block_data){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_105887){
var state_val_105888 = (state_105887[(1)]);
if((state_val_105888 === (1))){
var state_105887__$1 = state_105887;
var statearr_105889_105896 = state_105887__$1;
(statearr_105889_105896[(2)] = null);

(statearr_105889_105896[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105888 === (2))){
var inst_105885 = (state_105887[(2)]);
var state_105887__$1 = state_105887;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_105887__$1,inst_105885);
} else {
if((state_val_105888 === (3))){
var inst_105868 = (state_105887[(2)]);
var state_105887__$1 = state_105887;
var statearr_105890_105897 = state_105887__$1;
(statearr_105890_105897[(2)] = inst_105868);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_105887__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105888 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_105887,(3),Error,null,(2));
var inst_105872 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_105873 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_105874 = (new cljs.core.PersistentVector(null,3,(5),inst_105872,inst_105873,null));
var inst_105875 = cljs.core.select_keys.call(null,block_data,inst_105874);
var inst_105876 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_105875);
var inst_105877 = fluree.db.storage.core.ledger_block_key.call(null,network,dbid,inst_105876);
var inst_105878 = fluree.db.storage.core.serde.call(null,conn);
var inst_105879 = fluree.db.serde.protocol._serialize_block.call(null,inst_105878,inst_105875);
var inst_105880 = fluree.db.storage.core.storage_write.call(null,conn,inst_105877,inst_105879);
var state_105887__$1 = state_105887;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_105887__$1,(5),inst_105880);
} else {
if((state_val_105888 === (5))){
var inst_105882 = (state_105887[(2)]);
var inst_105883 = fluree.db.util.async.throw_err.call(null,inst_105882);
var state_105887__$1 = state_105887;
var statearr_105891_105898 = state_105887__$1;
(statearr_105891_105898[(2)] = inst_105883);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_105887__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_$_state_machine__99975__auto__ = null;
var fluree$db$storage$core$write_block_$_state_machine__99975__auto____0 = (function (){
var statearr_105892 = [null,null,null,null,null,null,null];
(statearr_105892[(0)] = fluree$db$storage$core$write_block_$_state_machine__99975__auto__);

(statearr_105892[(1)] = (1));

return statearr_105892;
});
var fluree$db$storage$core$write_block_$_state_machine__99975__auto____1 = (function (state_105887){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_105887);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e105893){if((e105893 instanceof Object)){
var ex__99978__auto__ = e105893;
var statearr_105894_105899 = state_105887;
(statearr_105894_105899[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_105887);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e105893;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__105900 = state_105887;
state_105887 = G__105900;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_$_state_machine__99975__auto__ = function(state_105887){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_$_state_machine__99975__auto____1.call(this,state_105887);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_$_state_machine__99975__auto____0;
fluree$db$storage$core$write_block_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_$_state_machine__99975__auto____1;
return fluree$db$storage$core$write_block_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_105895 = f__100070__auto__.call(null);
(statearr_105895[(6)] = c__100069__auto__);

return statearr_105895;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Given a child, unresolved node, extracts just the data that will go into storage.
 */
fluree.db.storage.core.child_data = (function fluree$db$storage$core$child_data(child){
return cljs.core.select_keys.call(null,child,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007)], null));
});
fluree.db.storage.core.write_history = (function fluree$db$storage$core$write_history(conn,history,his_key,next_his_key){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_105917){
var state_val_105918 = (state_105917[(1)]);
if((state_val_105918 === (1))){
var state_105917__$1 = state_105917;
var statearr_105919_105926 = state_105917__$1;
(statearr_105919_105926[(2)] = null);

(statearr_105919_105926[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105918 === (2))){
var inst_105915 = (state_105917[(2)]);
var state_105917__$1 = state_105917;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_105917__$1,inst_105915);
} else {
if((state_val_105918 === (3))){
var inst_105901 = (state_105917[(2)]);
var state_105917__$1 = state_105917;
var statearr_105920_105927 = state_105917__$1;
(statearr_105920_105927[(2)] = inst_105901);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_105917__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105918 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_105917,(3),Error,null,(2));
var inst_105905 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"his","his",-1294347076)];
var inst_105906 = [history,next_his_key];
var inst_105907 = cljs.core.PersistentHashMap.fromArrays(inst_105905,inst_105906);
var inst_105908 = fluree.db.storage.core.serde.call(null,conn);
var inst_105909 = fluree.db.serde.protocol._serialize_leaf.call(null,inst_105908,inst_105907);
var inst_105910 = fluree.db.storage.core.storage_write.call(null,conn,his_key,inst_105909);
var state_105917__$1 = state_105917;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_105917__$1,(5),inst_105910);
} else {
if((state_val_105918 === (5))){
var inst_105912 = (state_105917[(2)]);
var inst_105913 = fluree.db.util.async.throw_err.call(null,inst_105912);
var state_105917__$1 = state_105917;
var statearr_105921_105928 = state_105917__$1;
(statearr_105921_105928[(2)] = inst_105913);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_105917__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_history_$_state_machine__99975__auto__ = null;
var fluree$db$storage$core$write_history_$_state_machine__99975__auto____0 = (function (){
var statearr_105922 = [null,null,null,null,null,null,null];
(statearr_105922[(0)] = fluree$db$storage$core$write_history_$_state_machine__99975__auto__);

(statearr_105922[(1)] = (1));

return statearr_105922;
});
var fluree$db$storage$core$write_history_$_state_machine__99975__auto____1 = (function (state_105917){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_105917);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e105923){if((e105923 instanceof Object)){
var ex__99978__auto__ = e105923;
var statearr_105924_105929 = state_105917;
(statearr_105924_105929[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_105917);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e105923;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__105930 = state_105917;
state_105917 = G__105930;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$storage$core$write_history_$_state_machine__99975__auto__ = function(state_105917){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_history_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_history_$_state_machine__99975__auto____1.call(this,state_105917);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_history_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_history_$_state_machine__99975__auto____0;
fluree$db$storage$core$write_history_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_history_$_state_machine__99975__auto____1;
return fluree$db$storage$core$write_history_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_105925 = f__100070__auto__.call(null);
(statearr_105925[(6)] = c__100069__auto__);

return statearr_105925;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Writes a leaf plus its history.
 * 
 *   Writes history first, and only on successful history write then writes leaf.
 * 
 *   Returns leaf's key
 */
fluree.db.storage.core.write_leaf = (function fluree$db$storage$core$write_leaf(conn,network,dbid,idx_type,id,flakes,history){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_105953){
var state_val_105954 = (state_105953[(1)]);
if((state_val_105954 === (1))){
var state_105953__$1 = state_105953;
var statearr_105955_105965 = state_105953__$1;
(statearr_105955_105965[(2)] = null);

(statearr_105955_105965[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105954 === (2))){
var inst_105951 = (state_105953[(2)]);
var state_105953__$1 = state_105953;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_105953__$1,inst_105951);
} else {
if((state_val_105954 === (3))){
var inst_105931 = (state_105953[(2)]);
var state_105953__$1 = state_105953;
var statearr_105956_105966 = state_105953__$1;
(statearr_105956_105966[(2)] = inst_105931);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_105953__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105954 === (4))){
var inst_105935 = (state_105953[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_105953,(3),Error,null,(2));
var inst_105935__$1 = fluree.db.storage.core.ledger_node_key.call(null,network,dbid,idx_type,id,"l");
var inst_105936 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_105935__$1),"-his"].join('');
var inst_105937 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"his","his",-1294347076)];
var inst_105938 = [flakes,inst_105936];
var inst_105939 = cljs.core.PersistentHashMap.fromArrays(inst_105937,inst_105938);
var inst_105940 = fluree.db.storage.core.serde.call(null,conn);
var inst_105941 = fluree.db.serde.protocol._serialize_leaf.call(null,inst_105940,inst_105939);
var inst_105942 = fluree.db.storage.core.write_history.call(null,conn,history,inst_105936,null);
var inst_105943 = fluree.db.storage.core.storage_write.call(null,conn,inst_105935__$1,inst_105941);
var state_105953__$1 = (function (){var statearr_105957 = state_105953;
(statearr_105957[(7)] = inst_105935__$1);

(statearr_105957[(8)] = inst_105943);

return statearr_105957;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_105953__$1,(5),inst_105942);
} else {
if((state_val_105954 === (5))){
var inst_105943 = (state_105953[(8)]);
var inst_105945 = (state_105953[(2)]);
var inst_105946 = fluree.db.util.async.throw_err.call(null,inst_105945);
var state_105953__$1 = (function (){var statearr_105958 = state_105953;
(statearr_105958[(9)] = inst_105946);

return statearr_105958;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_105953__$1,(6),inst_105943);
} else {
if((state_val_105954 === (6))){
var inst_105935 = (state_105953[(7)]);
var inst_105948 = (state_105953[(2)]);
var inst_105949 = fluree.db.util.async.throw_err.call(null,inst_105948);
var state_105953__$1 = (function (){var statearr_105959 = state_105953;
(statearr_105959[(10)] = inst_105949);

return statearr_105959;
})();
var statearr_105960_105967 = state_105953__$1;
(statearr_105960_105967[(2)] = inst_105935);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_105953__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_leaf_$_state_machine__99975__auto__ = null;
var fluree$db$storage$core$write_leaf_$_state_machine__99975__auto____0 = (function (){
var statearr_105961 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_105961[(0)] = fluree$db$storage$core$write_leaf_$_state_machine__99975__auto__);

(statearr_105961[(1)] = (1));

return statearr_105961;
});
var fluree$db$storage$core$write_leaf_$_state_machine__99975__auto____1 = (function (state_105953){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_105953);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e105962){if((e105962 instanceof Object)){
var ex__99978__auto__ = e105962;
var statearr_105963_105968 = state_105953;
(statearr_105963_105968[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_105953);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e105962;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__105969 = state_105953;
state_105953 = G__105969;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$storage$core$write_leaf_$_state_machine__99975__auto__ = function(state_105953){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_leaf_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_leaf_$_state_machine__99975__auto____1.call(this,state_105953);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_leaf_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_leaf_$_state_machine__99975__auto____0;
fluree$db$storage$core$write_leaf_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_leaf_$_state_machine__99975__auto____1;
return fluree$db$storage$core$write_leaf_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_105964 = f__100070__auto__.call(null);
(statearr_105964[(6)] = c__100069__auto__);

return statearr_105964;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Serializes final data for branch and writes it to provided key
 */
fluree.db.storage.core.write_branch_data = (function fluree$db$storage$core$write_branch_data(conn,key,data){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_105983){
var state_val_105984 = (state_105983[(1)]);
if((state_val_105984 === (1))){
var state_105983__$1 = state_105983;
var statearr_105985_105993 = state_105983__$1;
(statearr_105985_105993[(2)] = null);

(statearr_105985_105993[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105984 === (2))){
var inst_105981 = (state_105983[(2)]);
var state_105983__$1 = state_105983;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_105983__$1,inst_105981);
} else {
if((state_val_105984 === (3))){
var inst_105970 = (state_105983[(2)]);
var state_105983__$1 = state_105983;
var statearr_105986_105994 = state_105983__$1;
(statearr_105986_105994[(2)] = inst_105970);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_105983__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105984 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_105983,(3),Error,null,(2));
var inst_105974 = fluree.db.storage.core.serde.call(null,conn);
var inst_105975 = fluree.db.serde.protocol._serialize_branch.call(null,inst_105974,data);
var inst_105976 = fluree.db.storage.core.storage_write.call(null,conn,key,inst_105975);
var state_105983__$1 = state_105983;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_105983__$1,(5),inst_105976);
} else {
if((state_val_105984 === (5))){
var inst_105978 = (state_105983[(2)]);
var inst_105979 = fluree.db.util.async.throw_err.call(null,inst_105978);
var state_105983__$1 = (function (){var statearr_105987 = state_105983;
(statearr_105987[(7)] = inst_105979);

return statearr_105987;
})();
var statearr_105988_105995 = state_105983__$1;
(statearr_105988_105995[(2)] = key);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_105983__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_branch_data_$_state_machine__99975__auto__ = null;
var fluree$db$storage$core$write_branch_data_$_state_machine__99975__auto____0 = (function (){
var statearr_105989 = [null,null,null,null,null,null,null,null];
(statearr_105989[(0)] = fluree$db$storage$core$write_branch_data_$_state_machine__99975__auto__);

(statearr_105989[(1)] = (1));

return statearr_105989;
});
var fluree$db$storage$core$write_branch_data_$_state_machine__99975__auto____1 = (function (state_105983){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_105983);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e105990){if((e105990 instanceof Object)){
var ex__99978__auto__ = e105990;
var statearr_105991_105996 = state_105983;
(statearr_105991_105996[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_105983);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e105990;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__105997 = state_105983;
state_105983 = G__105997;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$storage$core$write_branch_data_$_state_machine__99975__auto__ = function(state_105983){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_branch_data_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_branch_data_$_state_machine__99975__auto____1.call(this,state_105983);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_branch_data_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_branch_data_$_state_machine__99975__auto____0;
fluree$db$storage$core$write_branch_data_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_branch_data_$_state_machine__99975__auto____1;
return fluree$db$storage$core$write_branch_data_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_105992 = f__100070__auto__.call(null);
(statearr_105992[(6)] = c__100069__auto__);

return statearr_105992;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Returns core async channel with index key
 */
fluree.db.storage.core.write_branch = (function fluree$db$storage$core$write_branch(conn,network,dbid,idx_type,id,children){
var branch_key = fluree.db.storage.core.ledger_node_key.call(null,network,dbid,idx_type,id,"b");
var child_vals = cljs.core.mapv.call(null,(function (p1__105998_SHARP_){
return fluree.db.storage.core.child_data.call(null,cljs.core.val.call(null,p1__105998_SHARP_));
}),children);
var rhs = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(cljs.core.last.call(null,child_vals));
var data = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"children","children",-940561982),child_vals,new cljs.core.Keyword(null,"rhs","rhs",-229356739),rhs], null);
return fluree.db.storage.core.write_branch_data.call(null,conn,branch_key,data);
});
/**
 * Writes garbage record out for latest index.
 */
fluree.db.storage.core.write_garbage = (function fluree$db$storage$core$write_garbage(db,p__105999){
var map__106000 = p__105999;
var map__106000__$1 = (((((!((map__106000 == null))))?(((((map__106000.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__106000.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__106000):map__106000);
var progress = map__106000__$1;
var garbage = cljs.core.get.call(null,map__106000__$1,new cljs.core.Keyword(null,"garbage","garbage",-2063107600));
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_106045){
var state_val_106046 = (state_106045[(1)]);
if((state_val_106046 === (7))){
var inst_106022 = (state_106045[(2)]);
var state_106045__$1 = state_106045;
if(cljs.core.truth_(inst_106022)){
var statearr_106047_106068 = state_106045__$1;
(statearr_106047_106068[(1)] = (11));

} else {
var statearr_106048_106069 = state_106045__$1;
(statearr_106048_106069[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106046 === (1))){
var state_106045__$1 = state_106045;
var statearr_106049_106070 = state_106045__$1;
(statearr_106049_106070[(2)] = null);

(statearr_106049_106070[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106046 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_106045,(3),Error,null,(2));
var inst_106008 = (db == null);
var inst_106009 = cljs.core.not.call(null,inst_106008);
var state_106045__$1 = state_106045;
if(inst_106009){
var statearr_106050_106071 = state_106045__$1;
(statearr_106050_106071[(1)] = (5));

} else {
var statearr_106051_106072 = state_106045__$1;
(statearr_106051_106072[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106046 === (13))){
var inst_106032 = (state_106045[(7)]);
var inst_106027 = (state_106045[(2)]);
var inst_106028 = cljs.core.get.call(null,inst_106027,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_106029 = cljs.core.get.call(null,inst_106027,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_106030 = cljs.core.get.call(null,inst_106027,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_106031 = cljs.core.get.call(null,inst_106027,new cljs.core.Keyword(null,"block","block",664686210));
var inst_106032__$1 = fluree.db.storage.core.ledger_garbage_key.call(null,inst_106029,inst_106030,inst_106031);
var inst_106033 = [new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"garbage","garbage",-2063107600)];
var inst_106034 = [inst_106030,inst_106031,garbage];
var inst_106035 = cljs.core.PersistentHashMap.fromArrays(inst_106033,inst_106034);
var inst_106036 = fluree.db.storage.core.serde.call(null,inst_106028);
var inst_106037 = fluree.db.serde.protocol._serialize_garbage.call(null,inst_106036,inst_106035);
var inst_106038 = fluree.db.storage.core.storage_write.call(null,inst_106028,inst_106032__$1,inst_106037);
var state_106045__$1 = (function (){var statearr_106052 = state_106045;
(statearr_106052[(7)] = inst_106032__$1);

return statearr_106052;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_106045__$1,(14),inst_106038);
} else {
if((state_val_106046 === (6))){
var state_106045__$1 = state_106045;
var statearr_106053_106073 = state_106045__$1;
(statearr_106053_106073[(2)] = false);

(statearr_106053_106073[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106046 === (3))){
var inst_106002 = (state_106045[(2)]);
var state_106045__$1 = state_106045;
var statearr_106054_106074 = state_106045__$1;
(statearr_106054_106074[(2)] = inst_106002);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_106045__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106046 === (12))){
var state_106045__$1 = state_106045;
var statearr_106055_106075 = state_106045__$1;
(statearr_106055_106075[(2)] = db);

(statearr_106055_106075[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106046 === (2))){
var inst_106043 = (state_106045[(2)]);
var state_106045__$1 = state_106045;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_106045__$1,inst_106043);
} else {
if((state_val_106046 === (11))){
var inst_106024 = cljs.core.apply.call(null,cljs.core.hash_map,db);
var state_106045__$1 = state_106045;
var statearr_106056_106076 = state_106045__$1;
(statearr_106056_106076[(2)] = inst_106024);

(statearr_106056_106076[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106046 === (9))){
var state_106045__$1 = state_106045;
var statearr_106057_106077 = state_106045__$1;
(statearr_106057_106077[(2)] = false);

(statearr_106057_106077[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106046 === (5))){
var inst_106011 = db.cljs$lang$protocol_mask$partition0$;
var inst_106012 = (inst_106011 & (64));
var inst_106013 = db.cljs$core$ISeq$;
var inst_106014 = (cljs.core.PROTOCOL_SENTINEL === inst_106013);
var inst_106015 = ((inst_106012) || (inst_106014));
var state_106045__$1 = state_106045;
if(cljs.core.truth_(inst_106015)){
var statearr_106058_106078 = state_106045__$1;
(statearr_106058_106078[(1)] = (8));

} else {
var statearr_106059_106079 = state_106045__$1;
(statearr_106059_106079[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106046 === (14))){
var inst_106032 = (state_106045[(7)]);
var inst_106040 = (state_106045[(2)]);
var inst_106041 = fluree.db.util.async.throw_err.call(null,inst_106040);
var state_106045__$1 = (function (){var statearr_106060 = state_106045;
(statearr_106060[(8)] = inst_106041);

return statearr_106060;
})();
var statearr_106061_106080 = state_106045__$1;
(statearr_106061_106080[(2)] = inst_106032);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_106045__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106046 === (10))){
var inst_106019 = (state_106045[(2)]);
var state_106045__$1 = state_106045;
var statearr_106062_106081 = state_106045__$1;
(statearr_106062_106081[(2)] = inst_106019);

(statearr_106062_106081[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106046 === (8))){
var state_106045__$1 = state_106045;
var statearr_106063_106082 = state_106045__$1;
(statearr_106063_106082[(2)] = true);

(statearr_106063_106082[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_garbage_$_state_machine__99975__auto__ = null;
var fluree$db$storage$core$write_garbage_$_state_machine__99975__auto____0 = (function (){
var statearr_106064 = [null,null,null,null,null,null,null,null,null];
(statearr_106064[(0)] = fluree$db$storage$core$write_garbage_$_state_machine__99975__auto__);

(statearr_106064[(1)] = (1));

return statearr_106064;
});
var fluree$db$storage$core$write_garbage_$_state_machine__99975__auto____1 = (function (state_106045){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_106045);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e106065){if((e106065 instanceof Object)){
var ex__99978__auto__ = e106065;
var statearr_106066_106083 = state_106045;
(statearr_106066_106083[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_106045);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e106065;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__106084 = state_106045;
state_106045 = G__106084;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$storage$core$write_garbage_$_state_machine__99975__auto__ = function(state_106045){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_garbage_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_garbage_$_state_machine__99975__auto____1.call(this,state_106045);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_garbage_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_garbage_$_state_machine__99975__auto____0;
fluree$db$storage$core$write_garbage_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_garbage_$_state_machine__99975__auto____1;
return fluree$db$storage$core$write_garbage_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_106067 = f__100070__auto__.call(null);
(statearr_106067[(6)] = c__100069__auto__);

return statearr_106067;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
fluree.db.storage.core.write_db_root = (function fluree$db$storage$core$write_db_root(var_args){
var G__106086 = arguments.length;
switch (G__106086) {
case 1:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1 = (function (db){
return fluree.db.storage.core.write_db_root.call(null,db,null);
}));

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2 = (function (db,custom_ecount){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_106157){
var state_val_106158 = (state_106157[(1)]);
if((state_val_106158 === (7))){
var inst_106107 = (state_106157[(2)]);
var state_106157__$1 = state_106157;
if(cljs.core.truth_(inst_106107)){
var statearr_106159_106190 = state_106157__$1;
(statearr_106159_106190[(1)] = (11));

} else {
var statearr_106160_106191 = state_106157__$1;
(statearr_106160_106191[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106158 === (20))){
var inst_106126 = (state_106157[(7)]);
var inst_106152 = (state_106157[(2)]);
var inst_106153 = fluree.db.util.async.throw_err.call(null,inst_106152);
var state_106157__$1 = (function (){var statearr_106161 = state_106157;
(statearr_106161[(8)] = inst_106153);

return statearr_106161;
})();
var statearr_106162_106192 = state_106157__$1;
(statearr_106162_106192[(2)] = inst_106126);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_106157__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106158 === (1))){
var state_106157__$1 = state_106157;
var statearr_106163_106193 = state_106157__$1;
(statearr_106163_106193[(2)] = null);

(statearr_106163_106193[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106158 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_106157,(3),Error,null,(2));
var inst_106093 = (db == null);
var inst_106094 = cljs.core.not.call(null,inst_106093);
var state_106157__$1 = state_106157;
if(inst_106094){
var statearr_106164_106194 = state_106157__$1;
(statearr_106164_106194[(1)] = (5));

} else {
var statearr_106165_106195 = state_106157__$1;
(statearr_106165_106195[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106158 === (15))){
var state_106157__$1 = state_106157;
var statearr_106166_106196 = state_106157__$1;
(statearr_106166_106196[(2)] = (0));

(statearr_106166_106196[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106158 === (13))){
var inst_106121 = (state_106157[(9)]);
var inst_106129 = (state_106157[(10)]);
var inst_106119 = (state_106157[(11)]);
var inst_106117 = (state_106157[(12)]);
var inst_106112 = (state_106157[(2)]);
var inst_106113 = cljs.core.get.call(null,inst_106112,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_106114 = cljs.core.get.call(null,inst_106112,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_106115 = cljs.core.get.call(null,inst_106112,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_106116 = cljs.core.get.call(null,inst_106112,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var inst_106117__$1 = cljs.core.get.call(null,inst_106112,new cljs.core.Keyword(null,"stats","stats",-85643011));
var inst_106118 = cljs.core.get.call(null,inst_106112,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_106119__$1 = cljs.core.get.call(null,inst_106112,new cljs.core.Keyword(null,"block","block",664686210));
var inst_106120 = cljs.core.get.call(null,inst_106112,new cljs.core.Keyword(null,"psot","psot",2111653059));
var inst_106121__$1 = cljs.core.get.call(null,inst_106112,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_106122 = cljs.core.get.call(null,inst_106112,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var inst_106123 = cljs.core.get.call(null,inst_106112,new cljs.core.Keyword(null,"opst","opst",1213963058));
var inst_106124 = cljs.core.get.call(null,inst_106112,new cljs.core.Keyword(null,"fork-block","fork-block",178387923));
var inst_106125 = cljs.core.get.call(null,inst_106112,new cljs.core.Keyword(null,"post","post",269697687));
var inst_106126 = fluree.db.storage.core.ledger_root_key.call(null,inst_106113,inst_106121__$1,inst_106119__$1);
var inst_106127 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"prevIndex","prevIndex",-331425114),new cljs.core.Keyword(null,"ecount","ecount",-879380887),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"timestamp","timestamp",579478971),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_106128 = fluree.db.storage.core.child_data.call(null,inst_106120);
var inst_106129__$1 = new cljs.core.Keyword(null,"indexed","indexed",390758624).cljs$core$IFn$_invoke$arity$1(inst_106117__$1);
var state_106157__$1 = (function (){var statearr_106167 = state_106157;
(statearr_106167[(9)] = inst_106121__$1);

(statearr_106167[(13)] = inst_106115);

(statearr_106167[(10)] = inst_106129__$1);

(statearr_106167[(14)] = inst_106124);

(statearr_106167[(15)] = inst_106128);

(statearr_106167[(7)] = inst_106126);

(statearr_106167[(16)] = inst_106122);

(statearr_106167[(17)] = inst_106118);

(statearr_106167[(18)] = inst_106114);

(statearr_106167[(11)] = inst_106119__$1);

(statearr_106167[(19)] = inst_106125);

(statearr_106167[(12)] = inst_106117__$1);

(statearr_106167[(20)] = inst_106127);

(statearr_106167[(21)] = inst_106123);

(statearr_106167[(22)] = inst_106116);

return statearr_106167;
})();
if(cljs.core.truth_(inst_106129__$1)){
var statearr_106168_106197 = state_106157__$1;
(statearr_106168_106197[(1)] = (14));

} else {
var statearr_106169_106198 = state_106157__$1;
(statearr_106169_106198[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106158 === (6))){
var state_106157__$1 = state_106157;
var statearr_106170_106199 = state_106157__$1;
(statearr_106170_106199[(2)] = false);

(statearr_106170_106199[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106158 === (17))){
var state_106157__$1 = state_106157;
var statearr_106171_106200 = state_106157__$1;
(statearr_106171_106200[(2)] = custom_ecount);

(statearr_106171_106200[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106158 === (3))){
var inst_106087 = (state_106157[(2)]);
var state_106157__$1 = state_106157;
var statearr_106172_106201 = state_106157__$1;
(statearr_106172_106201[(2)] = inst_106087);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_106157__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106158 === (12))){
var state_106157__$1 = state_106157;
var statearr_106173_106202 = state_106157__$1;
(statearr_106173_106202[(2)] = db);

(statearr_106173_106202[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106158 === (2))){
var inst_106155 = (state_106157[(2)]);
var state_106157__$1 = state_106157;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_106157__$1,inst_106155);
} else {
if((state_val_106158 === (19))){
var inst_106121 = (state_106157[(9)]);
var inst_106115 = (state_106157[(13)]);
var inst_106124 = (state_106157[(14)]);
var inst_106128 = (state_106157[(15)]);
var inst_106126 = (state_106157[(7)]);
var inst_106118 = (state_106157[(17)]);
var inst_106114 = (state_106157[(18)]);
var inst_106119 = (state_106157[(11)]);
var inst_106125 = (state_106157[(19)]);
var inst_106117 = (state_106157[(12)]);
var inst_106127 = (state_106157[(20)]);
var inst_106123 = (state_106157[(21)]);
var inst_106133 = (state_106157[(23)]);
var inst_106116 = (state_106157[(22)]);
var inst_106137 = (state_106157[(2)]);
var inst_106138 = fluree.db.storage.core.child_data.call(null,inst_106123);
var inst_106139 = fluree.db.storage.core.child_data.call(null,inst_106125);
var inst_106140 = fluree.db.util.core.current_time_millis.call(null);
var inst_106141 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_106142 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_106143 = (new cljs.core.PersistentVector(null,2,(5),inst_106141,inst_106142,null));
var inst_106144 = cljs.core.select_keys.call(null,inst_106117,inst_106143);
var inst_106145 = fluree.db.storage.core.child_data.call(null,inst_106116);
var inst_106146 = [inst_106119,inst_106128,inst_106121,inst_106133,inst_106137,inst_106138,inst_106139,inst_106114,inst_106140,inst_106115,inst_106124,inst_106144,inst_106145];
var inst_106147 = cljs.core.PersistentHashMap.fromArrays(inst_106127,inst_106146);
var inst_106148 = fluree.db.storage.core.serde.call(null,inst_106118);
var inst_106149 = fluree.db.serde.protocol._serialize_db_root.call(null,inst_106148,inst_106147);
var inst_106150 = fluree.db.storage.core.storage_write.call(null,inst_106118,inst_106126,inst_106149);
var state_106157__$1 = state_106157;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_106157__$1,(20),inst_106150);
} else {
if((state_val_106158 === (11))){
var inst_106109 = cljs.core.apply.call(null,cljs.core.hash_map,db);
var state_106157__$1 = state_106157;
var statearr_106174_106203 = state_106157__$1;
(statearr_106174_106203[(2)] = inst_106109);

(statearr_106174_106203[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106158 === (9))){
var state_106157__$1 = state_106157;
var statearr_106175_106204 = state_106157__$1;
(statearr_106175_106204[(2)] = false);

(statearr_106175_106204[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106158 === (5))){
var inst_106096 = db.cljs$lang$protocol_mask$partition0$;
var inst_106097 = (inst_106096 & (64));
var inst_106098 = db.cljs$core$ISeq$;
var inst_106099 = (cljs.core.PROTOCOL_SENTINEL === inst_106098);
var inst_106100 = ((inst_106097) || (inst_106099));
var state_106157__$1 = state_106157;
if(cljs.core.truth_(inst_106100)){
var statearr_106176_106205 = state_106157__$1;
(statearr_106176_106205[(1)] = (8));

} else {
var statearr_106177_106206 = state_106157__$1;
(statearr_106177_106206[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106158 === (14))){
var inst_106129 = (state_106157[(10)]);
var state_106157__$1 = state_106157;
var statearr_106178_106207 = state_106157__$1;
(statearr_106178_106207[(2)] = inst_106129);

(statearr_106178_106207[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106158 === (16))){
var inst_106133 = (state_106157[(2)]);
var state_106157__$1 = (function (){var statearr_106179 = state_106157;
(statearr_106179[(23)] = inst_106133);

return statearr_106179;
})();
if(cljs.core.truth_(custom_ecount)){
var statearr_106180_106208 = state_106157__$1;
(statearr_106180_106208[(1)] = (17));

} else {
var statearr_106181_106209 = state_106157__$1;
(statearr_106181_106209[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106158 === (10))){
var inst_106104 = (state_106157[(2)]);
var state_106157__$1 = state_106157;
var statearr_106182_106210 = state_106157__$1;
(statearr_106182_106210[(2)] = inst_106104);

(statearr_106182_106210[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106158 === (18))){
var inst_106122 = (state_106157[(16)]);
var state_106157__$1 = state_106157;
var statearr_106183_106211 = state_106157__$1;
(statearr_106183_106211[(2)] = inst_106122);

(statearr_106183_106211[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106158 === (8))){
var state_106157__$1 = state_106157;
var statearr_106184_106212 = state_106157__$1;
(statearr_106184_106212[(2)] = true);

(statearr_106184_106212[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__99975__auto__ = null;
var fluree$db$storage$core$state_machine__99975__auto____0 = (function (){
var statearr_106185 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_106185[(0)] = fluree$db$storage$core$state_machine__99975__auto__);

(statearr_106185[(1)] = (1));

return statearr_106185;
});
var fluree$db$storage$core$state_machine__99975__auto____1 = (function (state_106157){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_106157);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e106186){if((e106186 instanceof Object)){
var ex__99978__auto__ = e106186;
var statearr_106187_106213 = state_106157;
(statearr_106187_106213[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_106157);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e106186;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__106214 = state_106157;
state_106157 = G__106214;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__99975__auto__ = function(state_106157){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__99975__auto____1.call(this,state_106157);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__99975__auto____0;
fluree$db$storage$core$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__99975__auto____1;
return fluree$db$storage$core$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_106188 = f__100070__auto__.call(null);
(statearr_106188[(6)] = c__100069__auto__);

return statearr_106188;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.storage.core.write_db_root.cljs$lang$maxFixedArity = 2);

fluree.db.storage.core.reify_history = (function fluree$db$storage$core$reify_history(conn,key,error_fn){
var return_ch = cljs.core.async.promise_chan.call(null);
var c__100069__auto___106256 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_106241){
var state_val_106242 = (state_106241[(1)]);
if((state_val_106242 === (1))){
var state_106241__$1 = state_106241;
var statearr_106243_106257 = state_106241__$1;
(statearr_106243_106257[(2)] = null);

(statearr_106243_106257[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106242 === (2))){
var inst_106239 = (state_106241[(2)]);
var state_106241__$1 = state_106241;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_106241__$1,inst_106239);
} else {
if((state_val_106242 === (3))){
var inst_106215 = (state_106241[(2)]);
var inst_106216 = error_fn.call(null);
var inst_106217 = cljs.core.async.put_BANG_.call(null,return_ch,inst_106215);
var inst_106218 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_106241__$1 = (function (){var statearr_106244 = state_106241;
(statearr_106244[(7)] = inst_106217);

(statearr_106244[(8)] = inst_106216);

return statearr_106244;
})();
var statearr_106245_106258 = state_106241__$1;
(statearr_106245_106258[(2)] = inst_106218);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_106241__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106242 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_106241,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var inst_106222 = fluree.db.storage.core.storage_read.call(null,conn,key);
var state_106241__$1 = state_106241;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_106241__$1,(5),inst_106222);
} else {
if((state_val_106242 === (5))){
var inst_106224 = (state_106241[(9)]);
var inst_106224__$1 = (state_106241[(2)]);
var inst_106225 = (inst_106224__$1 == null);
var inst_106226 = (inst_106224__$1 instanceof Error);
var inst_106227 = ((inst_106225) || (inst_106226));
var state_106241__$1 = (function (){var statearr_106246 = state_106241;
(statearr_106246[(9)] = inst_106224__$1);

return statearr_106246;
})();
if(cljs.core.truth_(inst_106227)){
var statearr_106247_106259 = state_106241__$1;
(statearr_106247_106259[(1)] = (6));

} else {
var statearr_106248_106260 = state_106241__$1;
(statearr_106248_106260[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106242 === (6))){
var inst_106229 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_106241__$1 = state_106241;
var statearr_106249_106261 = state_106241__$1;
(statearr_106249_106261[(2)] = inst_106229);

(statearr_106249_106261[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106242 === (7))){
var inst_106224 = (state_106241[(9)]);
var inst_106231 = fluree.db.storage.core.serde.call(null,conn);
var inst_106232 = fluree.db.serde.protocol._deserialize_leaf.call(null,inst_106231,inst_106224);
var inst_106233 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_106232);
var inst_106234 = cljs.core.sort.call(null,fluree.db.flake.cmp_flakes_history,inst_106233);
var inst_106235 = cljs.core.async.put_BANG_.call(null,return_ch,inst_106234);
var state_106241__$1 = state_106241;
var statearr_106250_106262 = state_106241__$1;
(statearr_106250_106262[(2)] = inst_106235);

(statearr_106250_106262[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106242 === (8))){
var inst_106237 = (state_106241[(2)]);
var state_106241__$1 = state_106241;
var statearr_106251_106263 = state_106241__$1;
(statearr_106251_106263[(2)] = inst_106237);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_106241__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_history_$_state_machine__99975__auto__ = null;
var fluree$db$storage$core$reify_history_$_state_machine__99975__auto____0 = (function (){
var statearr_106252 = [null,null,null,null,null,null,null,null,null,null];
(statearr_106252[(0)] = fluree$db$storage$core$reify_history_$_state_machine__99975__auto__);

(statearr_106252[(1)] = (1));

return statearr_106252;
});
var fluree$db$storage$core$reify_history_$_state_machine__99975__auto____1 = (function (state_106241){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_106241);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e106253){if((e106253 instanceof Object)){
var ex__99978__auto__ = e106253;
var statearr_106254_106264 = state_106241;
(statearr_106254_106264[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_106241);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e106253;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__106265 = state_106241;
state_106241 = G__106265;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$storage$core$reify_history_$_state_machine__99975__auto__ = function(state_106241){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_history_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_history_$_state_machine__99975__auto____1.call(this,state_106241);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_history_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_history_$_state_machine__99975__auto____0;
fluree$db$storage$core$reify_history_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_history_$_state_machine__99975__auto____1;
return fluree$db$storage$core$reify_history_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_106255 = f__100070__auto__.call(null);
(statearr_106255[(6)] = c__100069__auto___106256);

return statearr_106255;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));


return return_ch;
});
/**
 * Given a novelty set, a first-flake and rhs flake boundary,
 *   returns novelty subrange as a collection.
 * 
 *   If through-t is specified, will return novelty only through the
 *   specified t.
 */
fluree.db.storage.core.source_novelty_t = (function fluree$db$storage$core$source_novelty_t(var_args){
var G__106267 = arguments.length;
switch (G__106267) {
case 4:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4 = (function (novelty,first_flake,rhs,leftmost_QMARK_){
return fluree.db.storage.core.source_novelty_t.call(null,novelty,first_flake,rhs,leftmost_QMARK_,null);
}));

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5 = (function (novelty,first_flake,rhs,leftmost_QMARK_,through_t){
var novelty_subrange = (cljs.core.truth_((function (){var and__4115__auto__ = rhs;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.not.call(null,leftmost_QMARK_);
} else {
return and__4115__auto__;
}
})())?clojure.data.avl.subrange.call(null,novelty,cljs.core._GT_,first_flake,cljs.core._LT__EQ_,rhs):(cljs.core.truth_((function (){var and__4115__auto__ = rhs;
if(cljs.core.truth_(and__4115__auto__)){
return leftmost_QMARK_;
} else {
return and__4115__auto__;
}
})())?clojure.data.avl.subrange.call(null,novelty,cljs.core._LT__EQ_,rhs):(((((rhs == null)) && (cljs.core.not.call(null,leftmost_QMARK_))))?clojure.data.avl.subrange.call(null,novelty,cljs.core._GT_,first_flake):(cljs.core.truth_((((rhs == null))?leftmost_QMARK_:false))?novelty:null))));
if(cljs.core.truth_(through_t)){
return cljs.core.reduce.call(null,(function (novelty_set,f){
if((f.t < through_t)){
return cljs.core.disj.call(null,novelty_set,f);
} else {
return novelty_set;
}
}),novelty_subrange,novelty_subrange);
} else {
return novelty_subrange;
}
}));

(fluree.db.storage.core.source_novelty_t.cljs$lang$maxFixedArity = 5);

fluree.db.storage.core.resolve_t = (function fluree$db$storage$core$resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,error_fn){
var result_ch = cljs.core.async.promise_chan.call(null);
var c__100069__auto___106367 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_106327){
var state_val_106328 = (state_106327[(1)]);
if((state_val_106328 === (7))){
var inst_106282 = (state_106327[(7)]);
var inst_106286 = (inst_106282 < t);
var state_106327__$1 = state_106327;
if(cljs.core.truth_(inst_106286)){
var statearr_106329_106368 = state_106327__$1;
(statearr_106329_106368[(1)] = (9));

} else {
var statearr_106330_106369 = state_106327__$1;
(statearr_106330_106369[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106328 === (20))){
var inst_106281 = (state_106327[(8)]);
var inst_106280 = (state_106327[(9)]);
var inst_106310 = (state_106327[(10)]);
var inst_106297 = (state_106327[(11)]);
var inst_106282 = (state_106327[(7)]);
var inst_106317 = (state_106327[(2)]);
var inst_106318 = (function (){var base_node = inst_106280;
var first_flake = inst_106281;
var node_t = inst_106282;
var source = inst_106297;
var coll = inst_106310;
var conj_QMARK_ = inst_106317;
return (function (acc,f){
if(cljs.core.truth_((function (){var or__4126__auto__ = remove_preds;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})().call(null,f.p))){
return cljs.core.disj.call(null,acc,f);
} else {
if(cljs.core.truth_(conj_QMARK_.call(null,f))){
return cljs.core.conj.call(null,acc,f);
} else {
return cljs.core.disj.call(null,acc,f);

}
}
});
})();
var inst_106319 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_106280);
var inst_106320 = cljs.core.reduce.call(null,inst_106318,inst_106319,inst_106310);
var inst_106321 = cljs.core.doall.call(null,inst_106320);
var inst_106322 = cljs.core.assoc.call(null,inst_106280,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_106321);
var inst_106323 = cljs.core.async.put_BANG_.call(null,result_ch,inst_106322);
var state_106327__$1 = state_106327;
var statearr_106331_106370 = state_106327__$1;
(statearr_106331_106370[(2)] = inst_106323);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_106327__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106328 === (1))){
var state_106327__$1 = state_106327;
var statearr_106332_106371 = state_106327__$1;
(statearr_106332_106371[(2)] = null);

(statearr_106332_106371[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106328 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_106327,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var inst_106277 = fluree.db.dbproto._resolve.call(null,node);
var state_106327__$1 = state_106327;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_106327__$1,(5),inst_106277);
} else {
if((state_val_106328 === (15))){
var inst_106297 = (state_106327[(11)]);
var inst_106310 = (state_106327[(2)]);
var state_106327__$1 = (function (){var statearr_106333 = state_106327;
(statearr_106333[(10)] = inst_106310);

return statearr_106333;
})();
var G__106334_106372 = inst_106297;
var G__106334_106373__$1 = (((G__106334_106372 instanceof cljs.core.Keyword))?G__106334_106372.fqn:null);
switch (G__106334_106373__$1) {
case "novelty":
var statearr_106335_106375 = state_106327__$1;
(statearr_106335_106375[(1)] = (21));


break;
case "history":
var statearr_106336_106376 = state_106327__$1;
(statearr_106336_106376[(1)] = (22));


break;
case "none":
var statearr_106337_106377 = state_106327__$1;
(statearr_106337_106377[(1)] = (23));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__106334_106373__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106328 === (21))){
var inst_106281 = (state_106327[(8)]);
var inst_106280 = (state_106327[(9)]);
var inst_106310 = (state_106327[(10)]);
var inst_106297 = (state_106327[(11)]);
var inst_106282 = (state_106327[(7)]);
var inst_106311 = (function (){var base_node = inst_106280;
var first_flake = inst_106281;
var node_t = inst_106282;
var source = inst_106297;
var coll = inst_106310;
return (function (f){
return f.op === true;
});
})();
var state_106327__$1 = state_106327;
var statearr_106338_106378 = state_106327__$1;
(statearr_106338_106378[(2)] = inst_106311);

(statearr_106338_106378[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106328 === (13))){
var state_106327__$1 = state_106327;
var statearr_106339_106379 = state_106327__$1;
(statearr_106339_106379[(2)] = null);

(statearr_106339_106379[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106328 === (22))){
var inst_106281 = (state_106327[(8)]);
var inst_106280 = (state_106327[(9)]);
var inst_106310 = (state_106327[(10)]);
var inst_106297 = (state_106327[(11)]);
var inst_106282 = (state_106327[(7)]);
var inst_106313 = (function (){var base_node = inst_106280;
var first_flake = inst_106281;
var node_t = inst_106282;
var source = inst_106297;
var coll = inst_106310;
return (function (f){
return f.op === false;
});
})();
var state_106327__$1 = state_106327;
var statearr_106340_106380 = state_106327__$1;
(statearr_106340_106380[(2)] = inst_106313);

(statearr_106340_106380[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106328 === (6))){
var state_106327__$1 = state_106327;
var statearr_106341_106381 = state_106327__$1;
(statearr_106341_106381[(2)] = new cljs.core.Keyword(null,"novelty","novelty",-1590246024));

(statearr_106341_106381[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106328 === (17))){
var inst_106281 = (state_106327[(8)]);
var inst_106280 = (state_106327[(9)]);
var inst_106297 = (state_106327[(11)]);
var inst_106282 = (state_106327[(7)]);
var inst_106300 = (function (){var base_node = inst_106280;
var first_flake = inst_106281;
var node_t = inst_106282;
var source = inst_106297;
return (function (p1__106269_SHARP_){
return (p1__106269_SHARP_.t <= t);
});
})();
var inst_106301 = fluree.db.dbproto._resolve_history.call(null,node);
var state_106327__$1 = (function (){var statearr_106342 = state_106327;
(statearr_106342[(12)] = inst_106300);

return statearr_106342;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_106327__$1,(18),inst_106301);
} else {
if((state_val_106328 === (3))){
var inst_106270 = (state_106327[(2)]);
var inst_106271 = error_fn.call(null);
var inst_106272 = cljs.core.async.put_BANG_.call(null,result_ch,inst_106270);
var inst_106273 = cljs.core.async.close_BANG_.call(null,result_ch);
var state_106327__$1 = (function (){var statearr_106343 = state_106327;
(statearr_106343[(13)] = inst_106272);

(statearr_106343[(14)] = inst_106271);

return statearr_106343;
})();
var statearr_106344_106382 = state_106327__$1;
(statearr_106344_106382[(2)] = inst_106273);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_106327__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106328 === (12))){
var state_106327__$1 = state_106327;
var statearr_106345_106383 = state_106327__$1;
(statearr_106345_106383[(2)] = new cljs.core.Keyword(null,"none","none",1333468478));

(statearr_106345_106383[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106328 === (2))){
var inst_106325 = (state_106327[(2)]);
var state_106327__$1 = state_106327;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_106327__$1,inst_106325);
} else {
if((state_val_106328 === (23))){
var state_106327__$1 = state_106327;
var statearr_106346_106384 = state_106327__$1;
(statearr_106346_106384[(2)] = null);

(statearr_106346_106384[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106328 === (19))){
var inst_106307 = cljs.core.PersistentVector.EMPTY;
var state_106327__$1 = state_106327;
var statearr_106347_106385 = state_106327__$1;
(statearr_106347_106385[(2)] = inst_106307);

(statearr_106347_106385[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106328 === (11))){
var inst_106295 = (state_106327[(2)]);
var state_106327__$1 = state_106327;
var statearr_106348_106386 = state_106327__$1;
(statearr_106348_106386[(2)] = inst_106295);

(statearr_106348_106386[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106328 === (9))){
var state_106327__$1 = state_106327;
var statearr_106349_106387 = state_106327__$1;
(statearr_106349_106387[(2)] = new cljs.core.Keyword(null,"history","history",-247395220));

(statearr_106349_106387[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106328 === (5))){
var inst_106280 = (state_106327[(9)]);
var inst_106282 = (state_106327[(7)]);
var inst_106279 = (state_106327[(2)]);
var inst_106280__$1 = fluree.db.util.async.throw_err.call(null,inst_106279);
var inst_106281 = fluree.db.dbproto._first_flake.call(null,inst_106280__$1);
var inst_106282__$1 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_106280__$1);
var inst_106283 = (inst_106282__$1 > t);
var state_106327__$1 = (function (){var statearr_106350 = state_106327;
(statearr_106350[(8)] = inst_106281);

(statearr_106350[(9)] = inst_106280__$1);

(statearr_106350[(7)] = inst_106282__$1);

return statearr_106350;
})();
if(cljs.core.truth_(inst_106283)){
var statearr_106351_106388 = state_106327__$1;
(statearr_106351_106388[(1)] = (6));

} else {
var statearr_106352_106389 = state_106327__$1;
(statearr_106352_106389[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106328 === (14))){
var inst_106293 = (state_106327[(2)]);
var state_106327__$1 = state_106327;
var statearr_106353_106390 = state_106327__$1;
(statearr_106353_106390[(2)] = inst_106293);

(statearr_106353_106390[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106328 === (16))){
var inst_106281 = (state_106327[(8)]);
var inst_106298 = fluree.db.storage.core.source_novelty_t.call(null,idx_novelty,inst_106281,rhs,leftmost_QMARK_,t);
var state_106327__$1 = state_106327;
var statearr_106354_106391 = state_106327__$1;
(statearr_106354_106391[(2)] = inst_106298);

(statearr_106354_106391[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106328 === (10))){
var inst_106282 = (state_106327[(7)]);
var inst_106289 = cljs.core._EQ_.call(null,inst_106282,t);
var state_106327__$1 = state_106327;
if(inst_106289){
var statearr_106355_106392 = state_106327__$1;
(statearr_106355_106392[(1)] = (12));

} else {
var statearr_106356_106393 = state_106327__$1;
(statearr_106356_106393[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106328 === (18))){
var inst_106300 = (state_106327[(12)]);
var inst_106303 = (state_106327[(2)]);
var inst_106304 = fluree.db.util.async.throw_err.call(null,inst_106303);
var inst_106305 = cljs.core.take_while.call(null,inst_106300,inst_106304);
var state_106327__$1 = state_106327;
var statearr_106357_106394 = state_106327__$1;
(statearr_106357_106394[(2)] = inst_106305);

(statearr_106357_106394[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106328 === (8))){
var inst_106297 = (state_106327[(11)]);
var inst_106297__$1 = (state_106327[(2)]);
var state_106327__$1 = (function (){var statearr_106358 = state_106327;
(statearr_106358[(11)] = inst_106297__$1);

return statearr_106358;
})();
var G__106359_106395 = inst_106297__$1;
var G__106359_106396__$1 = (((G__106359_106395 instanceof cljs.core.Keyword))?G__106359_106395.fqn:null);
switch (G__106359_106396__$1) {
case "novelty":
var statearr_106360_106398 = state_106327__$1;
(statearr_106360_106398[(1)] = (16));


break;
case "history":
var statearr_106361_106399 = state_106327__$1;
(statearr_106361_106399[(1)] = (17));


break;
case "none":
var statearr_106362_106400 = state_106327__$1;
(statearr_106362_106400[(1)] = (19));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__106359_106396__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_t_$_state_machine__99975__auto__ = null;
var fluree$db$storage$core$resolve_t_$_state_machine__99975__auto____0 = (function (){
var statearr_106363 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_106363[(0)] = fluree$db$storage$core$resolve_t_$_state_machine__99975__auto__);

(statearr_106363[(1)] = (1));

return statearr_106363;
});
var fluree$db$storage$core$resolve_t_$_state_machine__99975__auto____1 = (function (state_106327){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_106327);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e106364){if((e106364 instanceof Object)){
var ex__99978__auto__ = e106364;
var statearr_106365_106401 = state_106327;
(statearr_106365_106401[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_106327);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e106364;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__106402 = state_106327;
state_106327 = G__106402;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_t_$_state_machine__99975__auto__ = function(state_106327){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_t_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_t_$_state_machine__99975__auto____1.call(this,state_106327);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_t_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_t_$_state_machine__99975__auto____0;
fluree$db$storage$core$resolve_t_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_t_$_state_machine__99975__auto____1;
return fluree$db$storage$core$resolve_t_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_106366 = f__100070__auto__.call(null);
(statearr_106366[(6)] = c__100069__auto___106367);

return statearr_106366;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));


return result_ch;
});
/**
 * Gets a history slice of a node with the oldest 't' from-t, to the
 *   most recent 't', to-t.
 * 
 *   Returns sorted set in novelty's sort order (spot, psot, post, or opst)
 */
fluree.db.storage.core.resolve_history_range = (function fluree$db$storage$core$resolve_history_range(node,from_t,to_t,idx_novelty,leftmost_QMARK_){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_106456){
var state_val_106457 = (state_106456[(1)]);
if((state_val_106457 === (7))){
var inst_106436 = (state_106456[(2)]);
var inst_106437 = fluree.db.dbproto._first_flake.call(null,node);
var inst_106438 = fluree.db.dbproto._rhs.call(null,node);
var inst_106439 = new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(node);
var state_106456__$1 = (function (){var statearr_106458 = state_106456;
(statearr_106458[(7)] = inst_106438);

(statearr_106458[(8)] = inst_106437);

(statearr_106458[(9)] = inst_106436);

return statearr_106458;
})();
if(cljs.core.truth_(inst_106439)){
var statearr_106459_106487 = state_106456__$1;
(statearr_106459_106487[(1)] = (15));

} else {
var statearr_106460_106488 = state_106456__$1;
(statearr_106460_106488[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106457 === (1))){
var state_106456__$1 = state_106456;
var statearr_106461_106489 = state_106456__$1;
(statearr_106461_106489[(2)] = null);

(statearr_106461_106489[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106457 === (4))){
var inst_106411 = (state_106456[(10)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_106456,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var inst_106411__$1 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(node);
var inst_106412 = (from_t == null);
var inst_106413 = (inst_106411__$1 <= from_t);
var inst_106414 = ((inst_106412) || (inst_106413));
var state_106456__$1 = (function (){var statearr_106462 = state_106456;
(statearr_106462[(10)] = inst_106411__$1);

return statearr_106462;
})();
if(cljs.core.truth_(inst_106414)){
var statearr_106463_106490 = state_106456__$1;
(statearr_106463_106490[(1)] = (5));

} else {
var statearr_106464_106491 = state_106456__$1;
(statearr_106464_106491[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106457 === (15))){
var state_106456__$1 = state_106456;
var statearr_106465_106492 = state_106456__$1;
(statearr_106465_106492[(2)] = null);

(statearr_106465_106492[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106457 === (13))){
var inst_106427 = (state_106456[(11)]);
var state_106456__$1 = state_106456;
var statearr_106466_106493 = state_106456__$1;
(statearr_106466_106493[(2)] = inst_106427);

(statearr_106466_106493[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106457 === (6))){
var state_106456__$1 = state_106456;
var statearr_106467_106494 = state_106456__$1;
(statearr_106467_106494[(2)] = null);

(statearr_106467_106494[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106457 === (17))){
var inst_106438 = (state_106456[(7)]);
var inst_106437 = (state_106456[(8)]);
var inst_106436 = (state_106456[(9)]);
var inst_106450 = (state_106456[(2)]);
var inst_106451 = fluree.db.storage.core.source_novelty_t.call(null,idx_novelty,inst_106437,inst_106438,leftmost_QMARK_,to_t);
var inst_106452 = cljs.core.into.call(null,inst_106451,inst_106436);
var state_106456__$1 = (function (){var statearr_106468 = state_106456;
(statearr_106468[(12)] = inst_106450);

return statearr_106468;
})();
var statearr_106469_106495 = state_106456__$1;
(statearr_106469_106495[(2)] = inst_106452);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_106456__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106457 === (3))){
var inst_106405 = (state_106456[(2)]);
var inst_106406 = fluree.db.util.log.error.call(null,inst_106405);
var inst_106407 = (function(){throw inst_106405})();
var state_106456__$1 = (function (){var statearr_106470 = state_106456;
(statearr_106470[(13)] = inst_106406);

return statearr_106470;
})();
var statearr_106471_106496 = state_106456__$1;
(statearr_106471_106496[(2)] = inst_106407);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_106456__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106457 === (12))){
var inst_106427 = (state_106456[(11)]);
var inst_106411 = (state_106456[(10)]);
var inst_106429 = (function (){var node_t = inst_106411;
var G__106416 = inst_106427;
return (function (p1__106404_SHARP_){
return (p1__106404_SHARP_.t <= from_t);
});
})();
var inst_106430 = cljs.core.take_while.call(null,inst_106429,inst_106427);
var state_106456__$1 = state_106456;
var statearr_106472_106497 = state_106456__$1;
(statearr_106472_106497[(2)] = inst_106430);

(statearr_106472_106497[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106457 === (2))){
var inst_106454 = (state_106456[(2)]);
var state_106456__$1 = state_106456;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_106456__$1,inst_106454);
} else {
if((state_val_106457 === (11))){
var inst_106427 = (state_106456[(2)]);
var state_106456__$1 = (function (){var statearr_106473 = state_106456;
(statearr_106473[(11)] = inst_106427);

return statearr_106473;
})();
if(cljs.core.truth_(from_t)){
var statearr_106474_106498 = state_106456__$1;
(statearr_106474_106498[(1)] = (12));

} else {
var statearr_106475_106499 = state_106456__$1;
(statearr_106475_106499[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106457 === (9))){
var inst_106420 = (state_106456[(14)]);
var inst_106411 = (state_106456[(10)]);
var inst_106423 = (function (){var node_t = inst_106411;
var G__106416 = inst_106420;
return (function (p1__106403_SHARP_){
return (p1__106403_SHARP_.t < to_t);
});
})();
var inst_106424 = cljs.core.drop_while.call(null,inst_106423,inst_106420);
var state_106456__$1 = state_106456;
var statearr_106476_106500 = state_106456__$1;
(statearr_106476_106500[(2)] = inst_106424);

(statearr_106476_106500[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106457 === (5))){
var inst_106417 = fluree.db.dbproto._resolve_history.call(null,node);
var state_106456__$1 = state_106456;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_106456__$1,(8),inst_106417);
} else {
if((state_val_106457 === (14))){
var inst_106433 = (state_106456[(2)]);
var state_106456__$1 = state_106456;
var statearr_106477_106501 = state_106456__$1;
(statearr_106477_106501[(2)] = inst_106433);

(statearr_106477_106501[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106457 === (16))){
var inst_106442 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(node);
var inst_106443 = ["resolve-history-range called on index node: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_106442)].join('');
var inst_106444 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_106445 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_106446 = cljs.core.PersistentHashMap.fromArrays(inst_106444,inst_106445);
var inst_106447 = cljs.core.ex_info.call(null,inst_106443,inst_106446);
var inst_106448 = (function(){throw inst_106447})();
var state_106456__$1 = state_106456;
var statearr_106478_106502 = state_106456__$1;
(statearr_106478_106502[(2)] = inst_106448);

(statearr_106478_106502[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106457 === (10))){
var inst_106420 = (state_106456[(14)]);
var state_106456__$1 = state_106456;
var statearr_106479_106503 = state_106456__$1;
(statearr_106479_106503[(2)] = inst_106420);

(statearr_106479_106503[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106457 === (8))){
var inst_106411 = (state_106456[(10)]);
var inst_106419 = (state_106456[(2)]);
var inst_106420 = fluree.db.util.async.throw_err.call(null,inst_106419);
var inst_106421 = (to_t > inst_106411);
var state_106456__$1 = (function (){var statearr_106480 = state_106456;
(statearr_106480[(14)] = inst_106420);

return statearr_106480;
})();
if(cljs.core.truth_(inst_106421)){
var statearr_106481_106504 = state_106456__$1;
(statearr_106481_106504[(1)] = (9));

} else {
var statearr_106482_106505 = state_106456__$1;
(statearr_106482_106505[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_history_range_$_state_machine__99975__auto__ = null;
var fluree$db$storage$core$resolve_history_range_$_state_machine__99975__auto____0 = (function (){
var statearr_106483 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_106483[(0)] = fluree$db$storage$core$resolve_history_range_$_state_machine__99975__auto__);

(statearr_106483[(1)] = (1));

return statearr_106483;
});
var fluree$db$storage$core$resolve_history_range_$_state_machine__99975__auto____1 = (function (state_106456){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_106456);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e106484){if((e106484 instanceof Object)){
var ex__99978__auto__ = e106484;
var statearr_106485_106506 = state_106456;
(statearr_106485_106506[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_106456);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e106484;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__106507 = state_106456;
state_106456 = G__106507;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_history_range_$_state_machine__99975__auto__ = function(state_106456){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_history_range_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_history_range_$_state_machine__99975__auto____1.call(this,state_106456);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_history_range_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_history_range_$_state_machine__99975__auto____0;
fluree$db$storage$core$resolve_history_range_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_history_range_$_state_machine__99975__auto____1;
return fluree$db$storage$core$resolve_history_range_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_106486 = f__100070__auto__.call(null);
(statearr_106486[(6)] = c__100069__auto__);

return statearr_106486;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
fluree.db.storage.core.resolve_to_t = (function fluree$db$storage$core$resolve_to_t(node,id,tempid,rhs,leftmost_QMARK_,t,tt_id,idx_novelty,conn,fast_foward_db_QMARK_,remove_preds){
if(cljs.core.truth_((function (){var or__4126__auto__ = fast_foward_db_QMARK_;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"empty","empty",767870958),id);
}
})())){
return fluree.db.storage.core.resolve_t.call(null,node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,null);
} else {
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(conn);
if((!(cljs.core.empty_QMARK_.call(null,remove_preds)))){
object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),null);

return object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),(function (_){
return fluree.db.storage.core.resolve_t.call(null,node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
return object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),null);
}));
}));
} else {
return object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),(function (_){
return fluree.db.storage.core.resolve_t.call(null,node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
return object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),null);
}));
}));
}
}
});
/**
 * Reads and deserializes branch node.
 */
fluree.db.storage.core.read_branch = (function fluree$db$storage$core$read_branch(conn,key){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_106525){
var state_val_106526 = (state_106525[(1)]);
if((state_val_106526 === (1))){
var state_106525__$1 = state_106525;
var statearr_106527_106540 = state_106525__$1;
(statearr_106527_106540[(2)] = null);

(statearr_106527_106540[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106526 === (2))){
var inst_106523 = (state_106525[(2)]);
var state_106525__$1 = state_106525;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_106525__$1,inst_106523);
} else {
if((state_val_106526 === (3))){
var inst_106508 = (state_106525[(2)]);
var state_106525__$1 = state_106525;
var statearr_106528_106541 = state_106525__$1;
(statearr_106528_106541[(2)] = inst_106508);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_106525__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106526 === (4))){
var inst_106512 = (state_106525[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_106525,(3),Error,null,(2));
var inst_106512__$1 = fluree.db.storage.core.storage_read.call(null,conn,key);
var state_106525__$1 = (function (){var statearr_106529 = state_106525;
(statearr_106529[(7)] = inst_106512__$1);

return statearr_106529;
})();
if(cljs.core.truth_(inst_106512__$1)){
var statearr_106530_106542 = state_106525__$1;
(statearr_106530_106542[(1)] = (5));

} else {
var statearr_106531_106543 = state_106525__$1;
(statearr_106531_106543[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106526 === (5))){
var inst_106512 = (state_106525[(7)]);
var inst_106514 = fluree.db.storage.core.serde.call(null,conn);
var state_106525__$1 = (function (){var statearr_106532 = state_106525;
(statearr_106532[(8)] = inst_106514);

return statearr_106532;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_106525__$1,(8),inst_106512);
} else {
if((state_val_106526 === (6))){
var state_106525__$1 = state_106525;
var statearr_106533_106544 = state_106525__$1;
(statearr_106533_106544[(2)] = null);

(statearr_106533_106544[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106526 === (7))){
var inst_106521 = (state_106525[(2)]);
var state_106525__$1 = state_106525;
var statearr_106534_106545 = state_106525__$1;
(statearr_106534_106545[(2)] = inst_106521);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_106525__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106526 === (8))){
var inst_106514 = (state_106525[(8)]);
var inst_106516 = (state_106525[(2)]);
var inst_106517 = fluree.db.util.async.throw_err.call(null,inst_106516);
var inst_106518 = fluree.db.serde.protocol._deserialize_branch.call(null,inst_106514,inst_106517);
var state_106525__$1 = state_106525;
var statearr_106535_106546 = state_106525__$1;
(statearr_106535_106546[(2)] = inst_106518);

(statearr_106535_106546[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_branch_$_state_machine__99975__auto__ = null;
var fluree$db$storage$core$read_branch_$_state_machine__99975__auto____0 = (function (){
var statearr_106536 = [null,null,null,null,null,null,null,null,null];
(statearr_106536[(0)] = fluree$db$storage$core$read_branch_$_state_machine__99975__auto__);

(statearr_106536[(1)] = (1));

return statearr_106536;
});
var fluree$db$storage$core$read_branch_$_state_machine__99975__auto____1 = (function (state_106525){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_106525);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e106537){if((e106537 instanceof Object)){
var ex__99978__auto__ = e106537;
var statearr_106538_106547 = state_106525;
(statearr_106538_106547[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_106525);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e106537;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__106548 = state_106525;
state_106525 = G__106548;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$storage$core$read_branch_$_state_machine__99975__auto__ = function(state_106525){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_branch_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_branch_$_state_machine__99975__auto____1.call(this,state_106525);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_branch_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_branch_$_state_machine__99975__auto____0;
fluree$db$storage$core$read_branch_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_branch_$_state_machine__99975__auto____1;
return fluree$db$storage$core$read_branch_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_106539 = f__100070__auto__.call(null);
(statearr_106539[(6)] = c__100069__auto__);

return statearr_106539;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_branch = (function fluree$db$storage$core$reify_branch(conn,config,network,dbid,key,block,t,tt_id,leftmost_QMARK_,tempid,error_fn){
var return_ch = cljs.core.async.promise_chan.call(null);
var c__100069__auto___106683 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_106635){
var state_val_106636 = (state_106635[(1)]);
if((state_val_106636 === (7))){
var state_106635__$1 = state_106635;
var statearr_106637_106684 = state_106635__$1;
(statearr_106637_106684[(2)] = null);

(statearr_106637_106684[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106636 === (20))){
var inst_106599 = (state_106635[(7)]);
var inst_106599__$1 = (state_106635[(2)]);
var inst_106600 = cljs.core.get.call(null,inst_106599__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var inst_106601 = cljs.core.get.call(null,inst_106599__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var inst_106603 = (config == null);
var inst_106604 = cljs.core.not.call(null,inst_106603);
var state_106635__$1 = (function (){var statearr_106638 = state_106635;
(statearr_106638[(8)] = inst_106601);

(statearr_106638[(9)] = inst_106600);

(statearr_106638[(7)] = inst_106599__$1);

return statearr_106638;
})();
if(inst_106604){
var statearr_106639_106685 = state_106635__$1;
(statearr_106639_106685[(1)] = (21));

} else {
var statearr_106640_106686 = state_106635__$1;
(statearr_106640_106686[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106636 === (27))){
var inst_106619 = cljs.core.apply.call(null,cljs.core.hash_map,config);
var state_106635__$1 = state_106635;
var statearr_106641_106687 = state_106635__$1;
(statearr_106641_106687[(2)] = inst_106619);

(statearr_106641_106687[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106636 === (1))){
var state_106635__$1 = state_106635;
var statearr_106642_106688 = state_106635__$1;
(statearr_106642_106688[(2)] = null);

(statearr_106642_106688[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106636 === (24))){
var state_106635__$1 = state_106635;
var statearr_106643_106689 = state_106635__$1;
(statearr_106643_106689[(2)] = true);

(statearr_106643_106689[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106636 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_106635,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var inst_106558 = fluree.db.storage.core.read_branch.call(null,conn,key);
var state_106635__$1 = state_106635;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_106635__$1,(5),inst_106558);
} else {
if((state_val_106636 === (15))){
var state_106635__$1 = state_106635;
var statearr_106644_106690 = state_106635__$1;
(statearr_106644_106690[(2)] = true);

(statearr_106644_106690[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106636 === (21))){
var inst_106606 = config.cljs$lang$protocol_mask$partition0$;
var inst_106607 = (inst_106606 & (64));
var inst_106608 = config.cljs$core$ISeq$;
var inst_106609 = (cljs.core.PROTOCOL_SENTINEL === inst_106608);
var inst_106610 = ((inst_106607) || (inst_106609));
var state_106635__$1 = state_106635;
if(cljs.core.truth_(inst_106610)){
var statearr_106645_106691 = state_106635__$1;
(statearr_106645_106691[(1)] = (24));

} else {
var statearr_106646_106692 = state_106635__$1;
(statearr_106646_106692[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106636 === (13))){
var state_106635__$1 = state_106635;
var statearr_106647_106693 = state_106635__$1;
(statearr_106647_106693[(2)] = false);

(statearr_106647_106693[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106636 === (22))){
var state_106635__$1 = state_106635;
var statearr_106648_106694 = state_106635__$1;
(statearr_106648_106694[(2)] = false);

(statearr_106648_106694[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106636 === (29))){
var inst_106561 = (state_106635[(10)]);
var inst_106578 = (state_106635[(11)]);
var inst_106601 = (state_106635[(8)]);
var inst_106600 = (state_106635[(9)]);
var inst_106599 = (state_106635[(7)]);
var inst_106622 = (state_106635[(2)]);
var inst_106623 = cljs.core.get.call(null,inst_106622,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var inst_106625 = (function (){var data = inst_106561;
var _ = inst_106578;
var map__106556 = inst_106599;
var children = inst_106600;
var rhs = inst_106601;
var map__106557 = inst_106622;
var comparator = inst_106623;
return (function (idx,p__106624){
var map__106649 = p__106624;
var map__106649__$1 = (((((!((map__106649 == null))))?(((((map__106649.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__106649.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__106649):map__106649);
var child = map__106649__$1;
var id = cljs.core.get.call(null,map__106649__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var leaf = cljs.core.get.call(null,map__106649__$1,new cljs.core.Keyword(null,"leaf","leaf",1306118732));
var first = cljs.core.get.call(null,map__106649__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var rhs__$1 = cljs.core.get.call(null,map__106649__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var size = cljs.core.get.call(null,map__106649__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var at_leftmost_QMARK_ = (function (){var and__4115__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(and__4115__auto__)){
return (idx === (0));
} else {
return and__4115__auto__;
}
})();
return fluree.db.storage.core.__GT_UnresolvedNode.call(null,conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid);
});
})();
var inst_106626 = cljs.core.map_indexed.call(null,inst_106625,inst_106600);
var inst_106627 = cljs.core.map.call(null,new cljs.core.Keyword(null,"first","first",-644103046),inst_106626);
var inst_106628 = cljs.core.interleave.call(null,inst_106627,inst_106626);
var inst_106629 = cljs.core.apply.call(null,clojure.data.avl.sorted_map_by,inst_106623,inst_106628);
var inst_106630 = fluree.db.index.__GT_IndexNode.call(null,block,t,inst_106601,inst_106629,config,leftmost_QMARK_);
var inst_106631 = cljs.core.async.put_BANG_.call(null,return_ch,inst_106630);
var state_106635__$1 = state_106635;
var statearr_106651_106695 = state_106635__$1;
(statearr_106651_106695[(2)] = inst_106631);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_106635__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106636 === (6))){
var inst_106564 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_106565 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_106566 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_106567 = cljs.core.PersistentHashMap.fromArrays(inst_106565,inst_106566);
var inst_106568 = cljs.core.ex_info.call(null,inst_106564,inst_106567);
var inst_106569 = (function(){throw inst_106568})();
var state_106635__$1 = state_106635;
var statearr_106652_106696 = state_106635__$1;
(statearr_106652_106696[(2)] = inst_106569);

(statearr_106652_106696[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106636 === (28))){
var state_106635__$1 = state_106635;
var statearr_106653_106697 = state_106635__$1;
(statearr_106653_106697[(2)] = config);

(statearr_106653_106697[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106636 === (25))){
var state_106635__$1 = state_106635;
var statearr_106654_106698 = state_106635__$1;
(statearr_106654_106698[(2)] = false);

(statearr_106654_106698[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106636 === (17))){
var inst_106591 = (state_106635[(2)]);
var state_106635__$1 = state_106635;
var statearr_106655_106699 = state_106635__$1;
(statearr_106655_106699[(2)] = inst_106591);

(statearr_106655_106699[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106636 === (3))){
var inst_106549 = (state_106635[(2)]);
var inst_106550 = error_fn.call(null);
var inst_106551 = cljs.core.async.put_BANG_.call(null,return_ch,inst_106549);
var inst_106552 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_106635__$1 = (function (){var statearr_106656 = state_106635;
(statearr_106656[(12)] = inst_106551);

(statearr_106656[(13)] = inst_106550);

return statearr_106656;
})();
var statearr_106657_106700 = state_106635__$1;
(statearr_106657_106700[(2)] = inst_106552);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_106635__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106636 === (12))){
var inst_106561 = (state_106635[(10)]);
var inst_106583 = inst_106561.cljs$lang$protocol_mask$partition0$;
var inst_106584 = (inst_106583 & (64));
var inst_106585 = inst_106561.cljs$core$ISeq$;
var inst_106586 = (cljs.core.PROTOCOL_SENTINEL === inst_106585);
var inst_106587 = ((inst_106584) || (inst_106586));
var state_106635__$1 = state_106635;
if(cljs.core.truth_(inst_106587)){
var statearr_106658_106701 = state_106635__$1;
(statearr_106658_106701[(1)] = (15));

} else {
var statearr_106659_106702 = state_106635__$1;
(statearr_106659_106702[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106636 === (2))){
var inst_106633 = (state_106635[(2)]);
var state_106635__$1 = state_106635;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_106635__$1,inst_106633);
} else {
if((state_val_106636 === (23))){
var inst_106617 = (state_106635[(2)]);
var state_106635__$1 = state_106635;
if(cljs.core.truth_(inst_106617)){
var statearr_106660_106703 = state_106635__$1;
(statearr_106660_106703[(1)] = (27));

} else {
var statearr_106661_106704 = state_106635__$1;
(statearr_106661_106704[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106636 === (19))){
var inst_106561 = (state_106635[(10)]);
var state_106635__$1 = state_106635;
var statearr_106662_106705 = state_106635__$1;
(statearr_106662_106705[(2)] = inst_106561);

(statearr_106662_106705[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106636 === (11))){
var inst_106561 = (state_106635[(10)]);
var inst_106578 = (state_106635[(2)]);
var inst_106580 = (inst_106561 == null);
var inst_106581 = cljs.core.not.call(null,inst_106580);
var state_106635__$1 = (function (){var statearr_106663 = state_106635;
(statearr_106663[(11)] = inst_106578);

return statearr_106663;
})();
if(inst_106581){
var statearr_106664_106706 = state_106635__$1;
(statearr_106664_106706[(1)] = (12));

} else {
var statearr_106665_106707 = state_106635__$1;
(statearr_106665_106707[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106636 === (9))){
var inst_106561 = (state_106635[(10)]);
var inst_106575 = (function(){throw inst_106561})();
var state_106635__$1 = state_106635;
var statearr_106666_106708 = state_106635__$1;
(statearr_106666_106708[(2)] = inst_106575);

(statearr_106666_106708[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106636 === (5))){
var inst_106561 = (state_106635[(10)]);
var inst_106560 = (state_106635[(2)]);
var inst_106561__$1 = fluree.db.util.async.throw_err.call(null,inst_106560);
var inst_106562 = (inst_106561__$1 == null);
var state_106635__$1 = (function (){var statearr_106667 = state_106635;
(statearr_106667[(10)] = inst_106561__$1);

return statearr_106667;
})();
if(cljs.core.truth_(inst_106562)){
var statearr_106668_106709 = state_106635__$1;
(statearr_106668_106709[(1)] = (6));

} else {
var statearr_106669_106710 = state_106635__$1;
(statearr_106669_106710[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106636 === (14))){
var inst_106594 = (state_106635[(2)]);
var state_106635__$1 = state_106635;
if(cljs.core.truth_(inst_106594)){
var statearr_106670_106711 = state_106635__$1;
(statearr_106670_106711[(1)] = (18));

} else {
var statearr_106671_106712 = state_106635__$1;
(statearr_106671_106712[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106636 === (26))){
var inst_106614 = (state_106635[(2)]);
var state_106635__$1 = state_106635;
var statearr_106672_106713 = state_106635__$1;
(statearr_106672_106713[(2)] = inst_106614);

(statearr_106672_106713[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106636 === (16))){
var state_106635__$1 = state_106635;
var statearr_106673_106714 = state_106635__$1;
(statearr_106673_106714[(2)] = false);

(statearr_106673_106714[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106636 === (10))){
var state_106635__$1 = state_106635;
var statearr_106674_106715 = state_106635__$1;
(statearr_106674_106715[(2)] = null);

(statearr_106674_106715[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106636 === (18))){
var inst_106561 = (state_106635[(10)]);
var inst_106596 = cljs.core.apply.call(null,cljs.core.hash_map,inst_106561);
var state_106635__$1 = state_106635;
var statearr_106675_106716 = state_106635__$1;
(statearr_106675_106716[(2)] = inst_106596);

(statearr_106675_106716[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106636 === (8))){
var inst_106561 = (state_106635[(10)]);
var inst_106572 = (state_106635[(2)]);
var inst_106573 = fluree.db.util.core.exception_QMARK_.call(null,inst_106561);
var state_106635__$1 = (function (){var statearr_106676 = state_106635;
(statearr_106676[(14)] = inst_106572);

return statearr_106676;
})();
if(inst_106573){
var statearr_106677_106717 = state_106635__$1;
(statearr_106677_106717[(1)] = (9));

} else {
var statearr_106678_106718 = state_106635__$1;
(statearr_106678_106718[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_branch_$_state_machine__99975__auto__ = null;
var fluree$db$storage$core$reify_branch_$_state_machine__99975__auto____0 = (function (){
var statearr_106679 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_106679[(0)] = fluree$db$storage$core$reify_branch_$_state_machine__99975__auto__);

(statearr_106679[(1)] = (1));

return statearr_106679;
});
var fluree$db$storage$core$reify_branch_$_state_machine__99975__auto____1 = (function (state_106635){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_106635);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e106680){if((e106680 instanceof Object)){
var ex__99978__auto__ = e106680;
var statearr_106681_106719 = state_106635;
(statearr_106681_106719[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_106635);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e106680;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__106720 = state_106635;
state_106635 = G__106720;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$storage$core$reify_branch_$_state_machine__99975__auto__ = function(state_106635){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_branch_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_branch_$_state_machine__99975__auto____1.call(this,state_106635);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_branch_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_branch_$_state_machine__99975__auto____0;
fluree$db$storage$core$reify_branch_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_branch_$_state_machine__99975__auto____1;
return fluree$db$storage$core$reify_branch_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_106682 = f__100070__auto__.call(null);
(statearr_106682[(6)] = c__100069__auto___106683);

return statearr_106682;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));


return return_ch;
});
/**
 * Reads and deserializes a leaf node
 */
fluree.db.storage.core.read_leaf = (function fluree$db$storage$core$read_leaf(conn,key){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_106738){
var state_val_106739 = (state_106738[(1)]);
if((state_val_106739 === (1))){
var state_106738__$1 = state_106738;
var statearr_106740_106753 = state_106738__$1;
(statearr_106740_106753[(2)] = null);

(statearr_106740_106753[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106739 === (2))){
var inst_106736 = (state_106738[(2)]);
var state_106738__$1 = state_106738;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_106738__$1,inst_106736);
} else {
if((state_val_106739 === (3))){
var inst_106721 = (state_106738[(2)]);
var state_106738__$1 = state_106738;
var statearr_106741_106754 = state_106738__$1;
(statearr_106741_106754[(2)] = inst_106721);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_106738__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106739 === (4))){
var inst_106725 = (state_106738[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_106738,(3),Error,null,(2));
var inst_106725__$1 = fluree.db.storage.core.storage_read.call(null,conn,key);
var state_106738__$1 = (function (){var statearr_106742 = state_106738;
(statearr_106742[(7)] = inst_106725__$1);

return statearr_106742;
})();
if(cljs.core.truth_(inst_106725__$1)){
var statearr_106743_106755 = state_106738__$1;
(statearr_106743_106755[(1)] = (5));

} else {
var statearr_106744_106756 = state_106738__$1;
(statearr_106744_106756[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106739 === (5))){
var inst_106725 = (state_106738[(7)]);
var inst_106727 = fluree.db.storage.core.serde.call(null,conn);
var state_106738__$1 = (function (){var statearr_106745 = state_106738;
(statearr_106745[(8)] = inst_106727);

return statearr_106745;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_106738__$1,(8),inst_106725);
} else {
if((state_val_106739 === (6))){
var state_106738__$1 = state_106738;
var statearr_106746_106757 = state_106738__$1;
(statearr_106746_106757[(2)] = null);

(statearr_106746_106757[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106739 === (7))){
var inst_106734 = (state_106738[(2)]);
var state_106738__$1 = state_106738;
var statearr_106747_106758 = state_106738__$1;
(statearr_106747_106758[(2)] = inst_106734);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_106738__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106739 === (8))){
var inst_106727 = (state_106738[(8)]);
var inst_106729 = (state_106738[(2)]);
var inst_106730 = fluree.db.util.async.throw_err.call(null,inst_106729);
var inst_106731 = fluree.db.serde.protocol._deserialize_leaf.call(null,inst_106727,inst_106730);
var state_106738__$1 = state_106738;
var statearr_106748_106759 = state_106738__$1;
(statearr_106748_106759[(2)] = inst_106731);

(statearr_106748_106759[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_leaf_$_state_machine__99975__auto__ = null;
var fluree$db$storage$core$read_leaf_$_state_machine__99975__auto____0 = (function (){
var statearr_106749 = [null,null,null,null,null,null,null,null,null];
(statearr_106749[(0)] = fluree$db$storage$core$read_leaf_$_state_machine__99975__auto__);

(statearr_106749[(1)] = (1));

return statearr_106749;
});
var fluree$db$storage$core$read_leaf_$_state_machine__99975__auto____1 = (function (state_106738){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_106738);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e106750){if((e106750 instanceof Object)){
var ex__99978__auto__ = e106750;
var statearr_106751_106760 = state_106738;
(statearr_106751_106760[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_106738);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e106750;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__106761 = state_106738;
state_106738 = G__106761;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$storage$core$read_leaf_$_state_machine__99975__auto__ = function(state_106738){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_leaf_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_leaf_$_state_machine__99975__auto____1.call(this,state_106738);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_leaf_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_leaf_$_state_machine__99975__auto____0;
fluree$db$storage$core$read_leaf_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_leaf_$_state_machine__99975__auto____1;
return fluree$db$storage$core$read_leaf_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_106752 = f__100070__auto__.call(null);
(statearr_106752[(6)] = c__100069__auto__);

return statearr_106752;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_leaf = (function fluree$db$storage$core$reify_leaf(conn,config,key,block,t,rhs,error_fn){
if(cljs.core.truth_(new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(config))){
} else {
throw (new Error(["Assert failed: ",["Cannot reify leaf, config does not have a comparator. Config: ",cljs.core.pr_str.call(null,config)].join(''),"\n","(:comparator config)"].join('')));
}

var return_ch = cljs.core.async.promise_chan.call(null);
var c__100069__auto___106888 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_106842){
var state_val_106843 = (state_106842[(1)]);
if((state_val_106843 === (7))){
var state_106842__$1 = state_106842;
var statearr_106844_106889 = state_106842__$1;
(statearr_106844_106889[(2)] = null);

(statearr_106844_106889[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106843 === (20))){
var inst_106811 = (state_106842[(2)]);
var inst_106812 = cljs.core.get.call(null,inst_106811,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_106813 = cljs.core.get.call(null,inst_106811,new cljs.core.Keyword(null,"his","his",-1294347076));
var inst_106815 = (config == null);
var inst_106816 = cljs.core.not.call(null,inst_106815);
var state_106842__$1 = (function (){var statearr_106845 = state_106842;
(statearr_106845[(7)] = inst_106812);

(statearr_106845[(8)] = inst_106813);

return statearr_106845;
})();
if(inst_106816){
var statearr_106846_106890 = state_106842__$1;
(statearr_106846_106890[(1)] = (21));

} else {
var statearr_106847_106891 = state_106842__$1;
(statearr_106847_106891[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106843 === (27))){
var inst_106831 = cljs.core.apply.call(null,cljs.core.hash_map,config);
var state_106842__$1 = state_106842;
var statearr_106848_106892 = state_106842__$1;
(statearr_106848_106892[(2)] = inst_106831);

(statearr_106848_106892[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106843 === (1))){
var state_106842__$1 = state_106842;
var statearr_106849_106893 = state_106842__$1;
(statearr_106849_106893[(2)] = null);

(statearr_106849_106893[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106843 === (24))){
var state_106842__$1 = state_106842;
var statearr_106850_106894 = state_106842__$1;
(statearr_106850_106894[(2)] = true);

(statearr_106850_106894[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106843 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_106842,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var inst_106771 = fluree.db.storage.core.read_leaf.call(null,conn,key);
var state_106842__$1 = state_106842;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_106842__$1,(5),inst_106771);
} else {
if((state_val_106843 === (15))){
var state_106842__$1 = state_106842;
var statearr_106851_106895 = state_106842__$1;
(statearr_106851_106895[(2)] = true);

(statearr_106851_106895[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106843 === (21))){
var inst_106818 = config.cljs$lang$protocol_mask$partition0$;
var inst_106819 = (inst_106818 & (64));
var inst_106820 = config.cljs$core$ISeq$;
var inst_106821 = (cljs.core.PROTOCOL_SENTINEL === inst_106820);
var inst_106822 = ((inst_106819) || (inst_106821));
var state_106842__$1 = state_106842;
if(cljs.core.truth_(inst_106822)){
var statearr_106852_106896 = state_106842__$1;
(statearr_106852_106896[(1)] = (24));

} else {
var statearr_106853_106897 = state_106842__$1;
(statearr_106853_106897[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106843 === (13))){
var state_106842__$1 = state_106842;
var statearr_106854_106898 = state_106842__$1;
(statearr_106854_106898[(2)] = false);

(statearr_106854_106898[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106843 === (22))){
var state_106842__$1 = state_106842;
var statearr_106855_106899 = state_106842__$1;
(statearr_106855_106899[(2)] = false);

(statearr_106855_106899[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106843 === (29))){
var inst_106812 = (state_106842[(7)]);
var inst_106834 = (state_106842[(2)]);
var inst_106835 = cljs.core.get.call(null,inst_106834,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var inst_106836 = cljs.core.apply.call(null,fluree.db.flake.sorted_set_by,inst_106835,inst_106812);
var inst_106837 = fluree.db.index.data_node.call(null,block,t,inst_106836,rhs,config);
var inst_106838 = cljs.core.async.put_BANG_.call(null,return_ch,inst_106837);
var state_106842__$1 = state_106842;
var statearr_106856_106900 = state_106842__$1;
(statearr_106856_106900[(2)] = inst_106838);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_106842__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106843 === (6))){
var inst_106776 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_106777 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_106778 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_106779 = cljs.core.PersistentHashMap.fromArrays(inst_106777,inst_106778);
var inst_106780 = cljs.core.ex_info.call(null,inst_106776,inst_106779);
var inst_106781 = (function(){throw inst_106780})();
var state_106842__$1 = state_106842;
var statearr_106857_106901 = state_106842__$1;
(statearr_106857_106901[(2)] = inst_106781);

(statearr_106857_106901[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106843 === (28))){
var state_106842__$1 = state_106842;
var statearr_106858_106902 = state_106842__$1;
(statearr_106858_106902[(2)] = config);

(statearr_106858_106902[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106843 === (25))){
var state_106842__$1 = state_106842;
var statearr_106859_106903 = state_106842__$1;
(statearr_106859_106903[(2)] = false);

(statearr_106859_106903[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106843 === (17))){
var inst_106803 = (state_106842[(2)]);
var state_106842__$1 = state_106842;
var statearr_106860_106904 = state_106842__$1;
(statearr_106860_106904[(2)] = inst_106803);

(statearr_106860_106904[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106843 === (3))){
var inst_106762 = (state_106842[(2)]);
var inst_106763 = error_fn.call(null);
var inst_106764 = cljs.core.async.put_BANG_.call(null,return_ch,inst_106762);
var inst_106765 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_106842__$1 = (function (){var statearr_106861 = state_106842;
(statearr_106861[(9)] = inst_106764);

(statearr_106861[(10)] = inst_106763);

return statearr_106861;
})();
var statearr_106862_106905 = state_106842__$1;
(statearr_106862_106905[(2)] = inst_106765);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_106842__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106843 === (12))){
var inst_106773 = (state_106842[(11)]);
var inst_106795 = inst_106773.cljs$lang$protocol_mask$partition0$;
var inst_106796 = (inst_106795 & (64));
var inst_106797 = inst_106773.cljs$core$ISeq$;
var inst_106798 = (cljs.core.PROTOCOL_SENTINEL === inst_106797);
var inst_106799 = ((inst_106796) || (inst_106798));
var state_106842__$1 = state_106842;
if(cljs.core.truth_(inst_106799)){
var statearr_106863_106906 = state_106842__$1;
(statearr_106863_106906[(1)] = (15));

} else {
var statearr_106864_106907 = state_106842__$1;
(statearr_106864_106907[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106843 === (2))){
var inst_106840 = (state_106842[(2)]);
var state_106842__$1 = state_106842;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_106842__$1,inst_106840);
} else {
if((state_val_106843 === (23))){
var inst_106829 = (state_106842[(2)]);
var state_106842__$1 = state_106842;
if(cljs.core.truth_(inst_106829)){
var statearr_106865_106908 = state_106842__$1;
(statearr_106865_106908[(1)] = (27));

} else {
var statearr_106866_106909 = state_106842__$1;
(statearr_106866_106909[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106843 === (19))){
var inst_106773 = (state_106842[(11)]);
var state_106842__$1 = state_106842;
var statearr_106867_106910 = state_106842__$1;
(statearr_106867_106910[(2)] = inst_106773);

(statearr_106867_106910[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106843 === (11))){
var inst_106773 = (state_106842[(11)]);
var inst_106790 = (state_106842[(2)]);
var inst_106792 = (inst_106773 == null);
var inst_106793 = cljs.core.not.call(null,inst_106792);
var state_106842__$1 = (function (){var statearr_106868 = state_106842;
(statearr_106868[(12)] = inst_106790);

return statearr_106868;
})();
if(inst_106793){
var statearr_106869_106911 = state_106842__$1;
(statearr_106869_106911[(1)] = (12));

} else {
var statearr_106870_106912 = state_106842__$1;
(statearr_106870_106912[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106843 === (9))){
var inst_106773 = (state_106842[(11)]);
var inst_106787 = (function(){throw inst_106773})();
var state_106842__$1 = state_106842;
var statearr_106871_106913 = state_106842__$1;
(statearr_106871_106913[(2)] = inst_106787);

(statearr_106871_106913[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106843 === (5))){
var inst_106773 = (state_106842[(11)]);
var inst_106773__$1 = (state_106842[(2)]);
var inst_106774 = (inst_106773__$1 == null);
var state_106842__$1 = (function (){var statearr_106872 = state_106842;
(statearr_106872[(11)] = inst_106773__$1);

return statearr_106872;
})();
if(cljs.core.truth_(inst_106774)){
var statearr_106873_106914 = state_106842__$1;
(statearr_106873_106914[(1)] = (6));

} else {
var statearr_106874_106915 = state_106842__$1;
(statearr_106874_106915[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106843 === (14))){
var inst_106806 = (state_106842[(2)]);
var state_106842__$1 = state_106842;
if(cljs.core.truth_(inst_106806)){
var statearr_106875_106916 = state_106842__$1;
(statearr_106875_106916[(1)] = (18));

} else {
var statearr_106876_106917 = state_106842__$1;
(statearr_106876_106917[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106843 === (26))){
var inst_106826 = (state_106842[(2)]);
var state_106842__$1 = state_106842;
var statearr_106877_106918 = state_106842__$1;
(statearr_106877_106918[(2)] = inst_106826);

(statearr_106877_106918[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106843 === (16))){
var state_106842__$1 = state_106842;
var statearr_106878_106919 = state_106842__$1;
(statearr_106878_106919[(2)] = false);

(statearr_106878_106919[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106843 === (10))){
var state_106842__$1 = state_106842;
var statearr_106879_106920 = state_106842__$1;
(statearr_106879_106920[(2)] = null);

(statearr_106879_106920[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106843 === (18))){
var inst_106773 = (state_106842[(11)]);
var inst_106808 = cljs.core.apply.call(null,cljs.core.hash_map,inst_106773);
var state_106842__$1 = state_106842;
var statearr_106880_106921 = state_106842__$1;
(statearr_106880_106921[(2)] = inst_106808);

(statearr_106880_106921[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106843 === (8))){
var inst_106773 = (state_106842[(11)]);
var inst_106784 = (state_106842[(2)]);
var inst_106785 = fluree.db.util.core.exception_QMARK_.call(null,inst_106773);
var state_106842__$1 = (function (){var statearr_106881 = state_106842;
(statearr_106881[(13)] = inst_106784);

return statearr_106881;
})();
if(inst_106785){
var statearr_106882_106922 = state_106842__$1;
(statearr_106882_106922[(1)] = (9));

} else {
var statearr_106883_106923 = state_106842__$1;
(statearr_106883_106923[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_leaf_$_state_machine__99975__auto__ = null;
var fluree$db$storage$core$reify_leaf_$_state_machine__99975__auto____0 = (function (){
var statearr_106884 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_106884[(0)] = fluree$db$storage$core$reify_leaf_$_state_machine__99975__auto__);

(statearr_106884[(1)] = (1));

return statearr_106884;
});
var fluree$db$storage$core$reify_leaf_$_state_machine__99975__auto____1 = (function (state_106842){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_106842);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e106885){if((e106885 instanceof Object)){
var ex__99978__auto__ = e106885;
var statearr_106886_106924 = state_106842;
(statearr_106886_106924[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_106842);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e106885;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__106925 = state_106842;
state_106842 = G__106925;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$storage$core$reify_leaf_$_state_machine__99975__auto__ = function(state_106842){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_leaf_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_leaf_$_state_machine__99975__auto____1.call(this,state_106842);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_leaf_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_leaf_$_state_machine__99975__auto____0;
fluree$db$storage$core$reify_leaf_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_leaf_$_state_machine__99975__auto____1;
return fluree$db$storage$core$reify_leaf_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_106887 = f__100070__auto__.call(null);
(statearr_106887[(6)] = c__100069__auto___106888);

return statearr_106887;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));


return return_ch;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.storage.core.UnresolvedNode = (function (conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,__meta,__extmap,__hash){
this.conn = conn;
this.config = config;
this.network = network;
this.dbid = dbid;
this.id = id;
this.leaf = leaf;
this.first = first;
this.rhs = rhs;
this.size = size;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.tempid = tempid;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k106927,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__106931 = k106927;
var G__106931__$1 = (((G__106931 instanceof cljs.core.Keyword))?G__106931.fqn:null);
switch (G__106931__$1) {
case "conn":
return self__.conn;

break;
case "config":
return self__.config;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "id":
return self__.id;

break;
case "leaf":
return self__.leaf;

break;
case "first":
return self__.first;

break;
case "rhs":
return self__.rhs;

break;
case "size":
return self__.size;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
case "tempid":
return self__.tempid;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k106927,else__4383__auto__);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4402__auto__,p__106932){
var vec__106933 = p__106932;
var k__4403__auto__ = cljs.core.nth.call(null,vec__106933,(0),null);
var v__4404__auto__ = cljs.core.nth.call(null,vec__106933,(1),null);
return f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__);
}),init__4401__auto__,this__4399__auto____$1);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,pr_pair__4397__auto__,"#fluree.db.storage.core.UnresolvedNode{",", ","}",opts__4396__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"config","config",994861415),self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leaf","leaf",1306118732),self__.leaf],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"first","first",-644103046),self__.first],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"size","size",1098693007),self__.size],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tempid","tempid",1427663222),self__.tempid],null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__106926){
var self__ = this;
var G__106926__$1 = this;
return (new cljs.core.RecordIter((0),G__106926__$1,14,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"tempid","tempid",1427663222)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.first;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"empty","empty",767870958),self__.id)){
var pc = cljs.core.async.promise_chan.call(null);
cljs.core.async.put_BANG_.call(null,pc,fluree.db.index.data_node.call(null,(0),(0),fluree.db.flake.sorted_set_by.call(null,new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(self__.config)),null,self__.config));

return pc;
} else {
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(self__.conn);
return object_cache.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null),(function (___$2){
if(cljs.core.truth_(self__.leaf)){
return fluree.db.storage.core.reify_leaf.call(null,self__.conn,self__.config,self__.id,self__.block,self__.t,self__.rhs,(function (){
return object_cache.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null),null);
}));
} else {
return fluree.db.storage.core.reify_branch.call(null,self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,(function (){
return object_cache.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null),null);
}));
}
}));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var history_id = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.id),"-his"].join('');
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(self__.conn);
var error_fn = (function (){
return object_cache.call(null,history_id,null);
});
return object_cache.call(null,history_id,(function (___$2){
return fluree.db.storage.core.reify_history.call(null,self__.conn,history_id,error_fn);
}));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$3 = (function (this$,to_t,idx_novelty){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t.call(null,this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,false,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$4 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t.call(null,this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$5 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_,remove_preds){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t.call(null,this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,remove_preds);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$3 = (function (node,from_t,to_t){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range.call(null,node__$1,from_t,to_t,null,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$4 = (function (node,from_t,to_t,idx_novelty){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range.call(null,node__$1,from_t,to_t,idx_novelty,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (14 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (502391120 ^ cljs.core.hash_unordered_coll.call(null,coll__4377__auto__));
}).call(null,this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this106928,other106929){
var self__ = this;
var this106928__$1 = this;
return (((!((other106929 == null)))) && ((this106928__$1.constructor === other106929.constructor)) && (cljs.core._EQ_.call(null,this106928__$1.conn,other106929.conn)) && (cljs.core._EQ_.call(null,this106928__$1.config,other106929.config)) && (cljs.core._EQ_.call(null,this106928__$1.network,other106929.network)) && (cljs.core._EQ_.call(null,this106928__$1.dbid,other106929.dbid)) && (cljs.core._EQ_.call(null,this106928__$1.id,other106929.id)) && (cljs.core._EQ_.call(null,this106928__$1.leaf,other106929.leaf)) && (cljs.core._EQ_.call(null,this106928__$1.first,other106929.first)) && (cljs.core._EQ_.call(null,this106928__$1.rhs,other106929.rhs)) && (cljs.core._EQ_.call(null,this106928__$1.size,other106929.size)) && (cljs.core._EQ_.call(null,this106928__$1.block,other106929.block)) && (cljs.core._EQ_.call(null,this106928__$1.t,other106929.t)) && (cljs.core._EQ_.call(null,this106928__$1.tt_id,other106929.tt_id)) && (cljs.core._EQ_.call(null,this106928__$1.leftmost_QMARK_,other106929.leftmost_QMARK_)) && (cljs.core._EQ_.call(null,this106928__$1.tempid,other106929.tempid)) && (cljs.core._EQ_.call(null,this106928__$1.__extmap,other106929.__extmap)));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"config","config",994861415),null,new cljs.core.Keyword(null,"leaf","leaf",1306118732),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"tempid","tempid",1427663222),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"first","first",-644103046),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4390__auto__)),null));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__106926){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__106936 = cljs.core.keyword_identical_QMARK_;
var expr__106937 = k__4388__auto__;
if(cljs.core.truth_(pred__106936.call(null,new cljs.core.Keyword(null,"conn","conn",278309663),expr__106937))){
return (new fluree.db.storage.core.UnresolvedNode(G__106926,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__106936.call(null,new cljs.core.Keyword(null,"config","config",994861415),expr__106937))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,G__106926,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__106936.call(null,new cljs.core.Keyword(null,"network","network",2050004697),expr__106937))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,G__106926,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__106936.call(null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),expr__106937))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,G__106926,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__106936.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__106937))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,G__106926,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__106936.call(null,new cljs.core.Keyword(null,"leaf","leaf",1306118732),expr__106937))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,G__106926,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__106936.call(null,new cljs.core.Keyword(null,"first","first",-644103046),expr__106937))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,G__106926,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__106936.call(null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),expr__106937))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,G__106926,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__106936.call(null,new cljs.core.Keyword(null,"size","size",1098693007),expr__106937))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,G__106926,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__106936.call(null,new cljs.core.Keyword(null,"block","block",664686210),expr__106937))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,G__106926,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__106936.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),expr__106937))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,G__106926,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__106936.call(null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),expr__106937))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,G__106926,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__106936.call(null,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),expr__106937))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,G__106926,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__106936.call(null,new cljs.core.Keyword(null,"tempid","tempid",1427663222),expr__106937))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,G__106926,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4388__auto__,G__106926),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"config","config",994861415),self__.config,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leaf","leaf",1306118732),self__.leaf,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"first","first",-644103046),self__.first,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"size","size",1098693007),self__.size,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tempid","tempid",1427663222),self__.tempid,null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__106926){
var self__ = this;
var this__4379__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,G__106926,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4386__auto__,(0)),cljs.core._nth.call(null,entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(fluree.db.storage.core.UnresolvedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"config","config",-1659574354,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"leaf","leaf",-1348317037,null),new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"rhs","rhs",1411174788,null),new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"leftmost?","leftmost?",-31657032,null),new cljs.core.Symbol(null,"tempid","tempid",-1226772547,null)], null);
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$type = true);

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"fluree.db.storage.core/UnresolvedNode",null,(1),null));
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write.call(null,writer__4424__auto__,"fluree.db.storage.core/UnresolvedNode");
}));

/**
 * Positional factory function for fluree.db.storage.core/UnresolvedNode.
 */
fluree.db.storage.core.__GT_UnresolvedNode = (function fluree$db$storage$core$__GT_UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid){
return (new fluree.db.storage.core.UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,null,null,null));
});

/**
 * Factory function for fluree.db.storage.core/UnresolvedNode, taking a map of keywords to field values.
 */
fluree.db.storage.core.map__GT_UnresolvedNode = (function fluree$db$storage$core$map__GT_UnresolvedNode(G__106930){
var extmap__4419__auto__ = (function (){var G__106939 = cljs.core.dissoc.call(null,G__106930,new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"tempid","tempid",1427663222));
if(cljs.core.record_QMARK_.call(null,G__106930)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__106939);
} else {
return G__106939;
}
})();
return (new fluree.db.storage.core.UnresolvedNode(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__106930),new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(G__106930),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__106930),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__106930),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__106930),new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(G__106930),new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(G__106930),new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(G__106930),new cljs.core.Keyword(null,"size","size",1098693007).cljs$core$IFn$_invoke$arity$1(G__106930),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__106930),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__106930),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__106930),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559).cljs$core$IFn$_invoke$arity$1(G__106930),new cljs.core.Keyword(null,"tempid","tempid",1427663222).cljs$core$IFn$_invoke$arity$1(G__106930),null,cljs.core.not_empty.call(null,extmap__4419__auto__),null));
});

/**
 * Turns each index root node into an unresolved node.
 */
fluree.db.storage.core.reify_index_root = (function fluree$db$storage$core$reify_index_root(conn,index_configs,network,dbid,index,index_data,block,t){
var cfg = (function (){var or__4126__auto__ = cljs.core.get.call(null,index_configs,index);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.call(null,["Internal error reifying db root index: ",cljs.core.pr_str.call(null,index)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null));
}
})();
return fluree.db.storage.core.map__GT_UnresolvedNode.call(null,cljs.core.assoc.call(null,index_data,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"config","config",994861415),cfg,new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),dbid,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),true));
});
/**
 * Constructs db from blank-db, and ensure index roots have proper config as unresolved nodes.
 */
fluree.db.storage.core.reify_db_root = (function fluree$db$storage$core$reify_db_root(conn,blank_db,root_data){
var map__106941 = blank_db;
var map__106941__$1 = (((((!((map__106941 == null))))?(((((map__106941.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__106941.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__106941):map__106941);
var network = cljs.core.get.call(null,map__106941__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__106941__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var index_configs = cljs.core.get.call(null,map__106941__$1,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280));
var map__106942 = root_data;
var map__106942__$1 = (((((!((map__106942 == null))))?(((((map__106942.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__106942.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__106942):map__106942);
var block = cljs.core.get.call(null,map__106942__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__106942__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var ecount = cljs.core.get.call(null,map__106942__$1,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var stats = cljs.core.get.call(null,map__106942__$1,new cljs.core.Keyword(null,"stats","stats",-85643011));
var db_STAR_ = cljs.core.assoc.call(null,blank_db,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"ecount","ecount",-879380887),ecount,new cljs.core.Keyword(null,"stats","stats",-85643011),cljs.core.assoc.call(null,stats,new cljs.core.Keyword(null,"indexed","indexed",390758624),block));
return cljs.core.reduce.call(null,(function (db,idx){
return cljs.core.assoc.call(null,db,idx,fluree.db.storage.core.reify_index_root.call(null,conn,index_configs,network,dbid,idx,cljs.core.get.call(null,root_data,idx),block,t));
}),db_STAR_,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)], null));
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_garbage = (function fluree$db$storage$core$read_garbage(conn,network,dbid,block){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_106963){
var state_val_106964 = (state_106963[(1)]);
if((state_val_106964 === (1))){
var state_106963__$1 = state_106963;
var statearr_106965_106978 = state_106963__$1;
(statearr_106965_106978[(2)] = null);

(statearr_106965_106978[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106964 === (2))){
var inst_106961 = (state_106963[(2)]);
var state_106963__$1 = state_106963;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_106963__$1,inst_106961);
} else {
if((state_val_106964 === (3))){
var inst_106945 = (state_106963[(2)]);
var state_106963__$1 = state_106963;
var statearr_106966_106979 = state_106963__$1;
(statearr_106966_106979[(2)] = inst_106945);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_106963__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106964 === (4))){
var inst_106950 = (state_106963[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_106963,(3),Error,null,(2));
var inst_106949 = fluree.db.storage.core.ledger_garbage_key.call(null,network,dbid,block);
var inst_106950__$1 = fluree.db.storage.core.storage_read.call(null,conn,inst_106949);
var state_106963__$1 = (function (){var statearr_106967 = state_106963;
(statearr_106967[(7)] = inst_106950__$1);

return statearr_106967;
})();
if(cljs.core.truth_(inst_106950__$1)){
var statearr_106968_106980 = state_106963__$1;
(statearr_106968_106980[(1)] = (5));

} else {
var statearr_106969_106981 = state_106963__$1;
(statearr_106969_106981[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106964 === (5))){
var inst_106950 = (state_106963[(7)]);
var inst_106952 = fluree.db.storage.core.serde.call(null,conn);
var state_106963__$1 = (function (){var statearr_106970 = state_106963;
(statearr_106970[(8)] = inst_106952);

return statearr_106970;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_106963__$1,(8),inst_106950);
} else {
if((state_val_106964 === (6))){
var state_106963__$1 = state_106963;
var statearr_106971_106982 = state_106963__$1;
(statearr_106971_106982[(2)] = null);

(statearr_106971_106982[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106964 === (7))){
var inst_106959 = (state_106963[(2)]);
var state_106963__$1 = state_106963;
var statearr_106972_106983 = state_106963__$1;
(statearr_106972_106983[(2)] = inst_106959);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_106963__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106964 === (8))){
var inst_106952 = (state_106963[(8)]);
var inst_106954 = (state_106963[(2)]);
var inst_106955 = fluree.db.util.async.throw_err.call(null,inst_106954);
var inst_106956 = fluree.db.serde.protocol._deserialize_garbage.call(null,inst_106952,inst_106955);
var state_106963__$1 = state_106963;
var statearr_106973_106984 = state_106963__$1;
(statearr_106973_106984[(2)] = inst_106956);

(statearr_106973_106984[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_garbage_$_state_machine__99975__auto__ = null;
var fluree$db$storage$core$read_garbage_$_state_machine__99975__auto____0 = (function (){
var statearr_106974 = [null,null,null,null,null,null,null,null,null];
(statearr_106974[(0)] = fluree$db$storage$core$read_garbage_$_state_machine__99975__auto__);

(statearr_106974[(1)] = (1));

return statearr_106974;
});
var fluree$db$storage$core$read_garbage_$_state_machine__99975__auto____1 = (function (state_106963){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_106963);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e106975){if((e106975 instanceof Object)){
var ex__99978__auto__ = e106975;
var statearr_106976_106985 = state_106963;
(statearr_106976_106985[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_106963);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e106975;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__106986 = state_106963;
state_106963 = G__106986;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$storage$core$read_garbage_$_state_machine__99975__auto__ = function(state_106963){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_garbage_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_garbage_$_state_machine__99975__auto____1.call(this,state_106963);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_garbage_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_garbage_$_state_machine__99975__auto____0;
fluree$db$storage$core$read_garbage_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_garbage_$_state_machine__99975__auto____1;
return fluree$db$storage$core$read_garbage_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_106977 = f__100070__auto__.call(null);
(statearr_106977[(6)] = c__100069__auto__);

return statearr_106977;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_db_root = (function fluree$db$storage$core$read_db_root(conn,network,dbid,block){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_107005){
var state_val_107006 = (state_107005[(1)]);
if((state_val_107006 === (1))){
var state_107005__$1 = state_107005;
var statearr_107007_107020 = state_107005__$1;
(statearr_107007_107020[(2)] = null);

(statearr_107007_107020[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107006 === (2))){
var inst_107003 = (state_107005[(2)]);
var state_107005__$1 = state_107005;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_107005__$1,inst_107003);
} else {
if((state_val_107006 === (3))){
var inst_106987 = (state_107005[(2)]);
var state_107005__$1 = state_107005;
var statearr_107008_107021 = state_107005__$1;
(statearr_107008_107021[(2)] = inst_106987);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_107005__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107006 === (4))){
var inst_106992 = (state_107005[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_107005,(3),Error,null,(2));
var inst_106991 = fluree.db.storage.core.ledger_root_key.call(null,network,dbid,block);
var inst_106992__$1 = fluree.db.storage.core.storage_read.call(null,conn,inst_106991);
var state_107005__$1 = (function (){var statearr_107009 = state_107005;
(statearr_107009[(7)] = inst_106992__$1);

return statearr_107009;
})();
if(cljs.core.truth_(inst_106992__$1)){
var statearr_107010_107022 = state_107005__$1;
(statearr_107010_107022[(1)] = (5));

} else {
var statearr_107011_107023 = state_107005__$1;
(statearr_107011_107023[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107006 === (5))){
var inst_106992 = (state_107005[(7)]);
var inst_106994 = fluree.db.storage.core.serde.call(null,conn);
var state_107005__$1 = (function (){var statearr_107012 = state_107005;
(statearr_107012[(8)] = inst_106994);

return statearr_107012;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_107005__$1,(8),inst_106992);
} else {
if((state_val_107006 === (6))){
var state_107005__$1 = state_107005;
var statearr_107013_107024 = state_107005__$1;
(statearr_107013_107024[(2)] = null);

(statearr_107013_107024[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107006 === (7))){
var inst_107001 = (state_107005[(2)]);
var state_107005__$1 = state_107005;
var statearr_107014_107025 = state_107005__$1;
(statearr_107014_107025[(2)] = inst_107001);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_107005__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107006 === (8))){
var inst_106994 = (state_107005[(8)]);
var inst_106996 = (state_107005[(2)]);
var inst_106997 = fluree.db.util.async.throw_err.call(null,inst_106996);
var inst_106998 = fluree.db.serde.protocol._deserialize_db_root.call(null,inst_106994,inst_106997);
var state_107005__$1 = state_107005;
var statearr_107015_107026 = state_107005__$1;
(statearr_107015_107026[(2)] = inst_106998);

(statearr_107015_107026[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_db_root_$_state_machine__99975__auto__ = null;
var fluree$db$storage$core$read_db_root_$_state_machine__99975__auto____0 = (function (){
var statearr_107016 = [null,null,null,null,null,null,null,null,null];
(statearr_107016[(0)] = fluree$db$storage$core$read_db_root_$_state_machine__99975__auto__);

(statearr_107016[(1)] = (1));

return statearr_107016;
});
var fluree$db$storage$core$read_db_root_$_state_machine__99975__auto____1 = (function (state_107005){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_107005);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e107017){if((e107017 instanceof Object)){
var ex__99978__auto__ = e107017;
var statearr_107018_107027 = state_107005;
(statearr_107018_107027[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_107005);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e107017;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__107028 = state_107005;
state_107005 = G__107028;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$storage$core$read_db_root_$_state_machine__99975__auto__ = function(state_107005){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_db_root_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_db_root_$_state_machine__99975__auto____1.call(this,state_107005);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_db_root_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_db_root_$_state_machine__99975__auto____0;
fluree$db$storage$core$read_db_root_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_db_root_$_state_machine__99975__auto____1;
return fluree$db$storage$core$read_db_root_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_107019 = f__100070__auto__.call(null);
(statearr_107019[(6)] = c__100069__auto__);

return statearr_107019;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Reifies db at specified index point. If unable to read db-root at index, throws.
 */
fluree.db.storage.core.reify_db = (function fluree$db$storage$core$reify_db(conn,network,dbid,blank_db,index){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_107061){
var state_val_107062 = (state_107061[(1)]);
if((state_val_107062 === (7))){
var inst_107033 = (state_107061[(7)]);
var inst_107043 = (state_107061[(2)]);
var state_107061__$1 = (function (){var statearr_107063 = state_107061;
(statearr_107063[(8)] = inst_107043);

return statearr_107063;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_107061__$1,(8),inst_107033);
} else {
if((state_val_107062 === (1))){
var state_107061__$1 = state_107061;
var statearr_107064_107078 = state_107061__$1;
(statearr_107064_107078[(2)] = null);

(statearr_107064_107078[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107062 === (4))){
var inst_107033 = (state_107061[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_107061,(3),Error,null,(2));
var inst_107033__$1 = fluree.db.storage.core.read_db_root.call(null,conn,network,dbid,index);
var state_107061__$1 = (function (){var statearr_107065 = state_107061;
(statearr_107065[(7)] = inst_107033__$1);

return statearr_107065;
})();
if(cljs.core.truth_(inst_107033__$1)){
var statearr_107066_107079 = state_107061__$1;
(statearr_107066_107079[(1)] = (5));

} else {
var statearr_107067_107080 = state_107061__$1;
(statearr_107067_107080[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107062 === (6))){
var inst_107036 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)," could not be loaded at index point: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(index),"."].join('');
var inst_107037 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_107038 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_107039 = cljs.core.PersistentHashMap.fromArrays(inst_107037,inst_107038);
var inst_107040 = cljs.core.ex_info.call(null,inst_107036,inst_107039);
var inst_107041 = (function(){throw inst_107040})();
var state_107061__$1 = state_107061;
var statearr_107068_107081 = state_107061__$1;
(statearr_107068_107081[(2)] = inst_107041);

(statearr_107068_107081[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107062 === (3))){
var inst_107029 = (state_107061[(2)]);
var state_107061__$1 = state_107061;
var statearr_107069_107082 = state_107061__$1;
(statearr_107069_107082[(2)] = inst_107029);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_107061__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107062 === (2))){
var inst_107059 = (state_107061[(2)]);
var state_107061__$1 = state_107061;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_107061__$1,inst_107059);
} else {
if((state_val_107062 === (9))){
var inst_107052 = (state_107061[(9)]);
var inst_107047 = (state_107061[(10)]);
var inst_107050 = (state_107061[(2)]);
var inst_107051 = fluree.db.util.async.throw_err.call(null,inst_107050);
var inst_107052__$1 = cljs.core.assoc.call(null,inst_107047,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_107051);
var inst_107053 = fluree.db.query.schema.setting_map.call(null,inst_107052__$1);
var state_107061__$1 = (function (){var statearr_107070 = state_107061;
(statearr_107070[(9)] = inst_107052__$1);

return statearr_107070;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_107061__$1,(10),inst_107053);
} else {
if((state_val_107062 === (5))){
var state_107061__$1 = state_107061;
var statearr_107071_107083 = state_107061__$1;
(statearr_107071_107083[(2)] = null);

(statearr_107071_107083[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107062 === (10))){
var inst_107052 = (state_107061[(9)]);
var inst_107055 = (state_107061[(2)]);
var inst_107056 = fluree.db.util.async.throw_err.call(null,inst_107055);
var inst_107057 = cljs.core.assoc.call(null,inst_107052,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_107056);
var state_107061__$1 = state_107061;
var statearr_107072_107084 = state_107061__$1;
(statearr_107072_107084[(2)] = inst_107057);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_107061__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107062 === (8))){
var inst_107047 = (state_107061[(10)]);
var inst_107045 = (state_107061[(2)]);
var inst_107046 = fluree.db.util.async.throw_err.call(null,inst_107045);
var inst_107047__$1 = fluree.db.storage.core.reify_db_root.call(null,conn,blank_db,inst_107046);
var inst_107048 = fluree.db.query.schema.schema_map.call(null,inst_107047__$1);
var state_107061__$1 = (function (){var statearr_107073 = state_107061;
(statearr_107073[(10)] = inst_107047__$1);

return statearr_107073;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_107061__$1,(9),inst_107048);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_db_$_state_machine__99975__auto__ = null;
var fluree$db$storage$core$reify_db_$_state_machine__99975__auto____0 = (function (){
var statearr_107074 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_107074[(0)] = fluree$db$storage$core$reify_db_$_state_machine__99975__auto__);

(statearr_107074[(1)] = (1));

return statearr_107074;
});
var fluree$db$storage$core$reify_db_$_state_machine__99975__auto____1 = (function (state_107061){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_107061);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e107075){if((e107075 instanceof Object)){
var ex__99978__auto__ = e107075;
var statearr_107076_107085 = state_107061;
(statearr_107076_107085[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_107061);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e107075;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__107086 = state_107061;
state_107061 = G__107086;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$storage$core$reify_db_$_state_machine__99975__auto__ = function(state_107061){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_db_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_db_$_state_machine__99975__auto____1.call(this,state_107061);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_db_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_db_$_state_machine__99975__auto____0;
fluree$db$storage$core$reify_db_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_db_$_state_machine__99975__auto____1;
return fluree$db$storage$core$reify_db_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_107077 = f__100070__auto__.call(null);
(statearr_107077[(6)] = c__100069__auto__);

return statearr_107077;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Returns a channel that will contains blocks in specified range.
 */
fluree.db.storage.core.block_range = (function fluree$db$storage$core$block_range(var_args){
var G__107088 = arguments.length;
switch (G__107088) {
case 4:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,network,dbid,start){
return fluree.db.storage.core.block_range.call(null,conn,network,dbid,start,null);
}));

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,dbid,start,end){
fluree.db.util.log.trace.call(null,"Block-range request: ",network,dbid,start,end);

var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_107134){
var state_val_107135 = (state_107134[(1)]);
if((state_val_107135 === (7))){
var inst_107100 = (state_107134[(2)]);
var inst_107101 = new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(conn);
var inst_107102 = cljs.core.PersistentVector.EMPTY;
var inst_107103 = start;
var inst_107104 = inst_107102;
var state_107134__$1 = (function (){var statearr_107136 = state_107134;
(statearr_107136[(7)] = inst_107103);

(statearr_107136[(8)] = inst_107104);

(statearr_107136[(9)] = inst_107101);

(statearr_107136[(10)] = inst_107100);

return statearr_107136;
})();
var statearr_107137_107165 = state_107134__$1;
(statearr_107137_107165[(2)] = null);

(statearr_107137_107165[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107135 === (1))){
var state_107134__$1 = state_107134;
var statearr_107138_107166 = state_107134__$1;
(statearr_107138_107166[(2)] = null);

(statearr_107138_107166[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107135 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_107134,(3),Error,null,(2));
var inst_107093 = (end >= start);
var state_107134__$1 = state_107134;
if(cljs.core.truth_(inst_107093)){
var statearr_107139_107167 = state_107134__$1;
(statearr_107139_107167[(1)] = (5));

} else {
var statearr_107140_107168 = state_107134__$1;
(statearr_107140_107168[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107135 === (15))){
var state_107134__$1 = state_107134;
var statearr_107141_107169 = state_107134__$1;
(statearr_107141_107169[(1)] = (17));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107135 === (13))){
var inst_107128 = (state_107134[(2)]);
var state_107134__$1 = state_107134;
var statearr_107143_107170 = state_107134__$1;
(statearr_107143_107170[(2)] = inst_107128);

(statearr_107143_107170[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107135 === (6))){
var inst_107096 = ["Assert failed: ","Block range should be in ascending order, from earliest (smallest) block to most recent (largest) block.","\n","(>= end start)"].join('');
var inst_107097 = (new Error(inst_107096));
var inst_107098 = (function(){throw inst_107097})();
var state_107134__$1 = state_107134;
var statearr_107144_107171 = state_107134__$1;
(statearr_107144_107171[(2)] = inst_107098);

(statearr_107144_107171[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107135 === (17))){
var inst_107108 = (state_107134[(11)]);
var inst_107103 = (state_107134[(7)]);
var inst_107104 = (state_107134[(8)]);
var inst_107119 = (inst_107103 + (1));
var inst_107120 = cljs.core.conj.call(null,inst_107104,inst_107108);
var inst_107103__$1 = inst_107119;
var inst_107104__$1 = inst_107120;
var state_107134__$1 = (function (){var statearr_107145 = state_107134;
(statearr_107145[(7)] = inst_107103__$1);

(statearr_107145[(8)] = inst_107104__$1);

return statearr_107145;
})();
var statearr_107146_107172 = state_107134__$1;
(statearr_107146_107172[(2)] = null);

(statearr_107146_107172[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107135 === (3))){
var inst_107089 = (state_107134[(2)]);
var state_107134__$1 = state_107134;
var statearr_107147_107173 = state_107134__$1;
(statearr_107147_107173[(2)] = inst_107089);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_107134__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107135 === (12))){
var inst_107103 = (state_107134[(7)]);
var inst_107114 = cljs.core._EQ_.call(null,inst_107103,end);
var state_107134__$1 = state_107134;
if(inst_107114){
var statearr_107148_107174 = state_107134__$1;
(statearr_107148_107174[(1)] = (14));

} else {
var statearr_107149_107175 = state_107134__$1;
(statearr_107149_107175[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107135 === (2))){
var inst_107132 = (state_107134[(2)]);
var state_107134__$1 = state_107134;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_107134__$1,inst_107132);
} else {
if((state_val_107135 === (19))){
var inst_107124 = (state_107134[(2)]);
var state_107134__$1 = state_107134;
var statearr_107150_107176 = state_107134__$1;
(statearr_107150_107176[(2)] = inst_107124);

(statearr_107150_107176[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107135 === (11))){
var inst_107104 = (state_107134[(8)]);
var state_107134__$1 = state_107134;
var statearr_107151_107177 = state_107134__$1;
(statearr_107151_107177[(2)] = inst_107104);

(statearr_107151_107177[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107135 === (9))){
var inst_107130 = (state_107134[(2)]);
var state_107134__$1 = state_107134;
var statearr_107152_107178 = state_107134__$1;
(statearr_107152_107178[(2)] = inst_107130);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_107134__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107135 === (5))){
var state_107134__$1 = state_107134;
var statearr_107153_107179 = state_107134__$1;
(statearr_107153_107179[(2)] = null);

(statearr_107153_107179[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107135 === (14))){
var inst_107108 = (state_107134[(11)]);
var inst_107104 = (state_107134[(8)]);
var inst_107116 = cljs.core.conj.call(null,inst_107104,inst_107108);
var state_107134__$1 = state_107134;
var statearr_107154_107180 = state_107134__$1;
(statearr_107154_107180[(2)] = inst_107116);

(statearr_107154_107180[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107135 === (16))){
var inst_107126 = (state_107134[(2)]);
var state_107134__$1 = state_107134;
var statearr_107155_107181 = state_107134__$1;
(statearr_107155_107181[(2)] = inst_107126);

(statearr_107155_107181[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107135 === (10))){
var inst_107108 = (state_107134[(11)]);
var inst_107108__$1 = (state_107134[(2)]);
var inst_107109 = (inst_107108__$1 == null);
var inst_107110 = (inst_107108__$1 instanceof Error);
var inst_107111 = ((inst_107109) || (inst_107110));
var state_107134__$1 = (function (){var statearr_107156 = state_107134;
(statearr_107156[(11)] = inst_107108__$1);

return statearr_107156;
})();
if(cljs.core.truth_(inst_107111)){
var statearr_107157_107182 = state_107134__$1;
(statearr_107157_107182[(1)] = (11));

} else {
var statearr_107158_107183 = state_107134__$1;
(statearr_107158_107183[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107135 === (18))){
var state_107134__$1 = state_107134;
var statearr_107159_107184 = state_107134__$1;
(statearr_107159_107184[(2)] = null);

(statearr_107159_107184[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107135 === (8))){
var inst_107103 = (state_107134[(7)]);
var inst_107106 = fluree.db.storage.core.read_block.call(null,conn,network,dbid,inst_107103);
var state_107134__$1 = state_107134;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_107134__$1,(10),inst_107106);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__99975__auto__ = null;
var fluree$db$storage$core$state_machine__99975__auto____0 = (function (){
var statearr_107160 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_107160[(0)] = fluree$db$storage$core$state_machine__99975__auto__);

(statearr_107160[(1)] = (1));

return statearr_107160;
});
var fluree$db$storage$core$state_machine__99975__auto____1 = (function (state_107134){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_107134);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e107161){if((e107161 instanceof Object)){
var ex__99978__auto__ = e107161;
var statearr_107162_107185 = state_107134;
(statearr_107162_107185[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_107134);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e107161;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__107186 = state_107134;
state_107134 = G__107186;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__99975__auto__ = function(state_107134){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__99975__auto____1.call(this,state_107134);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__99975__auto____0;
fluree$db$storage$core$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__99975__auto____1;
return fluree$db$storage$core$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_107163 = f__100070__auto__.call(null);
(statearr_107163[(6)] = c__100069__auto__);

return statearr_107163;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.storage.core.block_range.cljs$lang$maxFixedArity = 5);

/**
 * Reads a single block from storage
 */
fluree.db.storage.core.block = (function fluree$db$storage$core$block(conn,network,dbid,block){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_107199){
var state_val_107200 = (state_107199[(1)]);
if((state_val_107200 === (1))){
var state_107199__$1 = state_107199;
var statearr_107201_107208 = state_107199__$1;
(statearr_107201_107208[(2)] = null);

(statearr_107201_107208[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107200 === (2))){
var inst_107197 = (state_107199[(2)]);
var state_107199__$1 = state_107199;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_107199__$1,inst_107197);
} else {
if((state_val_107200 === (3))){
var inst_107187 = (state_107199[(2)]);
var state_107199__$1 = state_107199;
var statearr_107202_107209 = state_107199__$1;
(statearr_107202_107209[(2)] = inst_107187);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_107199__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107200 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_107199,(3),Error,null,(2));
var inst_107191 = fluree.db.storage.core.block_range.call(null,conn,network,dbid,block,block);
var state_107199__$1 = state_107199;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_107199__$1,(5),inst_107191);
} else {
if((state_val_107200 === (5))){
var inst_107193 = (state_107199[(2)]);
var inst_107194 = fluree.db.util.async.throw_err.call(null,inst_107193);
var inst_107195 = cljs.core.first.call(null,inst_107194);
var state_107199__$1 = state_107199;
var statearr_107203_107210 = state_107199__$1;
(statearr_107203_107210[(2)] = inst_107195);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_107199__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$block_$_state_machine__99975__auto__ = null;
var fluree$db$storage$core$block_$_state_machine__99975__auto____0 = (function (){
var statearr_107204 = [null,null,null,null,null,null,null];
(statearr_107204[(0)] = fluree$db$storage$core$block_$_state_machine__99975__auto__);

(statearr_107204[(1)] = (1));

return statearr_107204;
});
var fluree$db$storage$core$block_$_state_machine__99975__auto____1 = (function (state_107199){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_107199);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e107205){if((e107205 instanceof Object)){
var ex__99978__auto__ = e107205;
var statearr_107206_107211 = state_107199;
(statearr_107206_107211[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_107199);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e107205;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__107212 = state_107199;
state_107199 = G__107212;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$storage$core$block_$_state_machine__99975__auto__ = function(state_107199){
switch(arguments.length){
case 0:
return fluree$db$storage$core$block_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$storage$core$block_$_state_machine__99975__auto____1.call(this,state_107199);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$block_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$block_$_state_machine__99975__auto____0;
fluree$db$storage$core$block_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$block_$_state_machine__99975__auto____1;
return fluree$db$storage$core$block_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_107207 = f__100070__auto__.call(null);
(statearr_107207[(6)] = c__100069__auto__);

return statearr_107207;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
