// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.query.range');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
/**
 * Checks whether an index range is :spot, starts with [s1 -1 o1] and ends with [s1 int/max p1]
 */
fluree.db.query.range.value_with_nil_pred = (function fluree$db$query$range$value_with_nil_pred(idx,start_flake,end_flake){
return ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"spot","spot",-1706962147),idx)) && ((!((start_flake.o == null)))) && (cljs.core._EQ_.call(null,start_flake.o,end_flake.o)) && (cljs.core._EQ_.call(null,(-1),start_flake.p)) && (cljs.core._EQ_.call(null,fluree.db.flake.MAX_PREDICATE_ID,end_flake.p)));
});
/**
 * Will throw if predicate doesn't exist.
 */
fluree.db.query.range.pred_id_strict = (function fluree$db$query$range$pred_id_strict(db,p){
if(cljs.core.truth_(p)){
var or__4126__auto__ = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid predicate, does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
return null;
}
});
/**
 * Takes a match from index-range, and based on the index
 *   returns flake-ordered components of [s p o t op m].
 *   Coerces idents and string predicate names.
 */
fluree.db.query.range.match__GT_flake_parts = (function fluree$db$query$range$match__GT_flake_parts(db,idx,match){
var vec__102712 = match;
var p1 = cljs.core.nth.call(null,vec__102712,(0),null);
var p2 = cljs.core.nth.call(null,vec__102712,(1),null);
var p3 = cljs.core.nth.call(null,vec__102712,(2),null);
var t = cljs.core.nth.call(null,vec__102712,(3),null);
var op = cljs.core.nth.call(null,vec__102712,(4),null);
var m = cljs.core.nth.call(null,vec__102712,(5),null);
var G__102715 = idx;
var G__102715__$1 = (((G__102715 instanceof cljs.core.Keyword))?G__102715.fqn:null);
switch (G__102715__$1) {
case "spot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p2),p3,t,op,m], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p1),p3,t,op,m], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p1),p2,t,op,m], null);

break;
case "opst":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p2),p1,t,op,m], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__102715__$1)].join('')));

}
});
fluree.db.query.range.subject_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.max_long], null);
fluree.db.query.range.subject_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null);
fluree.db.query.range.pred_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
fluree.db.query.range.pred_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.MAX_PREDICATE_ID], null);
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.min_match = (function fluree$db$query$range$min_match(idx){
var G__102717 = idx;
var G__102717__$1 = (((G__102717 instanceof cljs.core.Keyword))?G__102717.fqn:null);
switch (G__102717__$1) {
case "spot":
return fluree.db.query.range.subject_min_match;

break;
case "psot":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "opst":
return fluree.db.query.range.subject_min_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__102717__$1)].join('')));

}
});
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.max_match = (function fluree$db$query$range$max_match(idx){
var G__102719 = idx;
var G__102719__$1 = (((G__102719 instanceof cljs.core.Keyword))?G__102719.fqn:null);
switch (G__102719__$1) {
case "spot":
return fluree.db.query.range.subject_max_match;

break;
case "psot":
return fluree.db.query.range.pred_max_match;

break;
case "post":
return fluree.db.query.range.pred_max_match;

break;
case "opst":
return fluree.db.query.range.subject_max_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__102719__$1)].join('')));

}
});
/**
 * Range query across an index.
 * 
 *   Uses a DB, but in the future support supplying a connection and db name, as we don't need a 't'
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :from-t - start transaction (transaction 't' is negative, so smallest number is most recent). Defaults to db's t
 *   :to-t - stop transaction - can be null, which pulls full history
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.time_range = (function fluree$db$query$range$time_range(var_args){
var G__102722 = arguments.length;
switch (G__102722) {
case 2:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.time_range.call(null,db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.time_range.call(null,db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx),opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.time_range.call(null,db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__102723 = (function (){var pred__102726 = cljs.core.identical_QMARK_;
var expr__102727 = test;
if(cljs.core.truth_(pred__102726.call(null,cljs.core._EQ_,expr__102727))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__102726.call(null,cljs.core._LT_,expr__102727))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_(pred__102726.call(null,cljs.core._LT__EQ_,expr__102727))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__102726.call(null,cljs.core._GT_,expr__102727))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
if(cljs.core.truth_(pred__102726.call(null,cljs.core._GT__EQ_,expr__102727))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__102727)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.call(null,vec__102723,(0),null);
var start_match = cljs.core.nth.call(null,vec__102723,(1),null);
var end_test = cljs.core.nth.call(null,vec__102723,(2),null);
var end_match = cljs.core.nth.call(null,vec__102723,(3),null);
return fluree.db.query.range.time_range.call(null,db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.time_range.call(null,db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_102937){
var state_val_102938 = (state_102937[(1)]);
if((state_val_102938 === (65))){
var inst_102898 = (state_102937[(7)]);
var inst_102891 = (state_102937[(8)]);
var inst_102890 = (state_102937[(9)]);
var inst_102905 = (inst_102890 + (1));
var tmp102939 = inst_102891;
var inst_102889 = inst_102898;
var inst_102890__$1 = inst_102905;
var inst_102891__$1 = tmp102939;
var state_102937__$1 = (function (){var statearr_102940 = state_102937;
(statearr_102940[(10)] = inst_102889);

(statearr_102940[(8)] = inst_102891__$1);

(statearr_102940[(9)] = inst_102890__$1);

return statearr_102940;
})();
var statearr_102941_103048 = state_102937__$1;
(statearr_102941_103048[(2)] = null);

(statearr_102941_103048[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (70))){
var inst_102912 = (state_102937[(11)]);
var state_102937__$1 = state_102937;
var statearr_102942_103049 = state_102937__$1;
(statearr_102942_103049[(2)] = inst_102912);

(statearr_102942_103049[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (62))){
var inst_102831 = (state_102937[(12)]);
var inst_102889 = (state_102937[(10)]);
var inst_102890 = (state_102937[(9)]);
var inst_102896 = cljs.core.seq.call(null,inst_102889);
var inst_102897 = cljs.core.first.call(null,inst_102896);
var inst_102898 = cljs.core.next.call(null,inst_102896);
var inst_102899 = (inst_102897 == null);
var inst_102900 = (inst_102890 > inst_102831);
var inst_102901 = ((inst_102899) || (inst_102900));
var state_102937__$1 = (function (){var statearr_102943 = state_102937;
(statearr_102943[(7)] = inst_102898);

return statearr_102943;
})();
if(cljs.core.truth_(inst_102901)){
var statearr_102944_103050 = state_102937__$1;
(statearr_102944_103050[(1)] = (64));

} else {
var statearr_102945_103051 = state_102937__$1;
(statearr_102945_103051[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (7))){
var inst_102747 = (state_102937[(13)]);
var inst_102761 = (state_102937[(2)]);
var inst_102762 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_102747);
var state_102937__$1 = (function (){var statearr_102946 = state_102937;
(statearr_102946[(14)] = inst_102761);

return statearr_102946;
})();
if(inst_102762){
var statearr_102947_103052 = state_102937__$1;
(statearr_102947_103052[(1)] = (9));

} else {
var statearr_102948_103053 = state_102937__$1;
(statearr_102948_103053[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (59))){
var inst_102831 = (state_102937[(12)]);
var inst_102872 = (state_102937[(15)]);
var inst_102859 = (state_102937[(16)]);
var inst_102858 = (state_102937[(17)]);
var inst_102875 = (inst_102831 - inst_102858);
var inst_102876 = fluree.db.flake.take.call(null,inst_102875,inst_102872);
var inst_102877 = cljs.core.into.call(null,inst_102876,inst_102859);
var state_102937__$1 = state_102937;
var statearr_102949_103054 = state_102937__$1;
(statearr_102949_103054[(2)] = inst_102877);

(statearr_102949_103054[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (20))){
var inst_102784 = (state_102937[(2)]);
var inst_102785 = fluree.db.util.async.throw_err.call(null,inst_102784);
var state_102937__$1 = state_102937;
var statearr_102950_103055 = state_102937__$1;
(statearr_102950_103055[(2)] = inst_102785);

(statearr_102950_103055[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (72))){
var inst_102931 = (state_102937[(2)]);
var state_102937__$1 = state_102937;
var statearr_102951_103056 = state_102937__$1;
(statearr_102951_103056[(2)] = inst_102931);

(statearr_102951_103056[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (58))){
var inst_102857 = (state_102937[(18)]);
var inst_102872 = (state_102937[(2)]);
var inst_102873 = fluree.db.dbproto._rhs.call(null,inst_102857);
var state_102937__$1 = (function (){var statearr_102952 = state_102937;
(statearr_102952[(15)] = inst_102872);

(statearr_102952[(19)] = inst_102873);

return statearr_102952;
})();
var statearr_102953_103057 = state_102937__$1;
(statearr_102953_103057[(1)] = (59));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (60))){
var inst_102872 = (state_102937[(15)]);
var inst_102858 = (state_102937[(17)]);
var inst_102886 = cljs.core.seq.call(null,inst_102872);
var inst_102887 = cljs.core.first.call(null,inst_102886);
var inst_102888 = cljs.core.next.call(null,inst_102886);
var inst_102889 = inst_102872;
var inst_102890 = inst_102858;
var inst_102891 = inst_102872;
var state_102937__$1 = (function (){var statearr_102955 = state_102937;
(statearr_102955[(10)] = inst_102889);

(statearr_102955[(8)] = inst_102891);

(statearr_102955[(9)] = inst_102890);

(statearr_102955[(20)] = inst_102888);

(statearr_102955[(21)] = inst_102887);

return statearr_102955;
})();
var statearr_102956_103058 = state_102937__$1;
(statearr_102956_103058[(2)] = null);

(statearr_102956_103058[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (27))){
var inst_102788 = (state_102937[(22)]);
var state_102937__$1 = state_102937;
var statearr_102957_103059 = state_102937__$1;
(statearr_102957_103059[(2)] = inst_102788);

(statearr_102957_103059[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (1))){
var state_102937__$1 = state_102937;
var statearr_102958_103060 = state_102937__$1;
(statearr_102958_103060[(2)] = null);

(statearr_102958_103060[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (69))){
var inst_102921 = (state_102937[(2)]);
var inst_102922 = cljs.core.not.call(null,inst_102921);
var state_102937__$1 = state_102937;
if(inst_102922){
var statearr_102959_103061 = state_102937__$1;
(statearr_102959_103061[(1)] = (70));

} else {
var statearr_102960_103062 = state_102937__$1;
(statearr_102960_103062[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (24))){
var state_102937__$1 = state_102937;
var statearr_102961_103063 = state_102937__$1;
(statearr_102961_103063[(2)] = (-1));

(statearr_102961_103063[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (55))){
var inst_102826 = (state_102937[(23)]);
var inst_102864 = (state_102937[(24)]);
var inst_102825 = (state_102937[(25)]);
var inst_102863 = (state_102937[(2)]);
var inst_102864__$1 = fluree.db.util.async.throw_err.call(null,inst_102863);
var inst_102865 = fluree.db.flake.subrange.call(null,inst_102864__$1,start_test,inst_102825,end_test,inst_102826);
var inst_102866 = fluree.db.query.range.value_with_nil_pred.call(null,idx,inst_102825,inst_102826);
var state_102937__$1 = (function (){var statearr_102962 = state_102937;
(statearr_102962[(26)] = inst_102865);

(statearr_102962[(24)] = inst_102864__$1);

return statearr_102962;
})();
if(inst_102866){
var statearr_102963_103064 = state_102937__$1;
(statearr_102963_103064[(1)] = (56));

} else {
var statearr_102964_103065 = state_102937__$1;
(statearr_102964_103065[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (39))){
var inst_102752 = (state_102937[(27)]);
var state_102937__$1 = state_102937;
var statearr_102965_103066 = state_102937__$1;
(statearr_102965_103066[(2)] = inst_102752);

(statearr_102965_103066[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (46))){
var state_102937__$1 = state_102937;
var statearr_102966_103067 = state_102937__$1;
(statearr_102966_103067[(2)] = fluree.db.util.core.max_long);

(statearr_102966_103067[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (4))){
var inst_102740 = (state_102937[(28)]);
var inst_102739 = (state_102937[(29)]);
var inst_102746 = (state_102937[(30)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_102937,(3),Error,null,(2));
var inst_102739__$1 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,start_match);
var inst_102740__$1 = cljs.core.nth.call(null,inst_102739__$1,(0),null);
var inst_102741 = cljs.core.nth.call(null,inst_102739__$1,(1),null);
var inst_102742 = cljs.core.nth.call(null,inst_102739__$1,(2),null);
var inst_102743 = cljs.core.nth.call(null,inst_102739__$1,(3),null);
var inst_102744 = cljs.core.nth.call(null,inst_102739__$1,(4),null);
var inst_102745 = cljs.core.nth.call(null,inst_102739__$1,(5),null);
var inst_102746__$1 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,end_match);
var inst_102747 = cljs.core.nth.call(null,inst_102746__$1,(0),null);
var inst_102748 = cljs.core.nth.call(null,inst_102746__$1,(1),null);
var inst_102749 = cljs.core.nth.call(null,inst_102746__$1,(2),null);
var inst_102750 = cljs.core.nth.call(null,inst_102746__$1,(3),null);
var inst_102751 = cljs.core.nth.call(null,inst_102746__$1,(4),null);
var inst_102752 = cljs.core.nth.call(null,inst_102746__$1,(5),null);
var inst_102753 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_102740__$1);
var state_102937__$1 = (function (){var statearr_102967 = state_102937;
(statearr_102967[(31)] = inst_102742);

(statearr_102967[(28)] = inst_102740__$1);

(statearr_102967[(32)] = inst_102749);

(statearr_102967[(33)] = inst_102750);

(statearr_102967[(34)] = inst_102743);

(statearr_102967[(35)] = inst_102748);

(statearr_102967[(13)] = inst_102747);

(statearr_102967[(36)] = inst_102751);

(statearr_102967[(29)] = inst_102739__$1);

(statearr_102967[(30)] = inst_102746__$1);

(statearr_102967[(27)] = inst_102752);

(statearr_102967[(37)] = inst_102741);

(statearr_102967[(38)] = inst_102744);

(statearr_102967[(39)] = inst_102745);

return statearr_102967;
})();
if(inst_102753){
var statearr_102968_103068 = state_102937__$1;
(statearr_102968_103068[(1)] = (5));

} else {
var statearr_102969_103069 = state_102937__$1;
(statearr_102969_103069[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (54))){
var inst_102933 = (state_102937[(2)]);
var state_102937__$1 = state_102937;
var statearr_102970_103070 = state_102937__$1;
(statearr_102970_103070[(2)] = inst_102933);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_102937__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (15))){
var inst_102749 = (state_102937[(32)]);
var inst_102779 = (state_102937[(2)]);
var inst_102780 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_102749);
var state_102937__$1 = (function (){var statearr_102971 = state_102937;
(statearr_102971[(40)] = inst_102779);

return statearr_102971;
})();
if(inst_102780){
var statearr_102972_103071 = state_102937__$1;
(statearr_102972_103071[(1)] = (17));

} else {
var statearr_102973_103072 = state_102937__$1;
(statearr_102973_103072[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (48))){
var inst_102837 = (state_102937[(41)]);
var state_102937__$1 = state_102937;
var statearr_102974_103073 = state_102937__$1;
(statearr_102974_103073[(2)] = inst_102837);

(statearr_102974_103073[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (50))){
var inst_102842 = (state_102937[(2)]);
var inst_102843 = new cljs.core.Keyword(null,"to-t","to-t",569467359).cljs$core$IFn$_invoke$arity$1(opts);
var inst_102844 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_102845 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx];
var inst_102846 = (new cljs.core.PersistentVector(null,2,(5),inst_102844,inst_102845,null));
var inst_102847 = cljs.core.get_in.call(null,db,inst_102846);
var inst_102848 = cljs.core.get.call(null,db,idx);
var inst_102849 = fluree.db.dbproto._resolve.call(null,inst_102848);
var state_102937__$1 = (function (){var statearr_102975 = state_102937;
(statearr_102975[(42)] = inst_102843);

(statearr_102975[(43)] = inst_102842);

(statearr_102975[(44)] = inst_102847);

return statearr_102975;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_102937__$1,(51),inst_102849);
} else {
if((state_val_102938 === (21))){
var inst_102779 = (state_102937[(40)]);
var state_102937__$1 = state_102937;
var statearr_102976_103074 = state_102937__$1;
(statearr_102976_103074[(2)] = inst_102779);

(statearr_102976_103074[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (31))){
var inst_102748 = (state_102937[(35)]);
var state_102937__$1 = state_102937;
var statearr_102977_103075 = state_102937__$1;
(statearr_102977_103075[(2)] = inst_102748);

(statearr_102977_103075[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (32))){
var inst_102745 = (state_102937[(39)]);
var inst_102806 = (state_102937[(2)]);
var state_102937__$1 = (function (){var statearr_102978 = state_102937;
(statearr_102978[(45)] = inst_102806);

return statearr_102978;
})();
if(cljs.core.truth_(inst_102745)){
var statearr_102979_103076 = state_102937__$1;
(statearr_102979_103076[(1)] = (33));

} else {
var statearr_102980_103077 = state_102937__$1;
(statearr_102980_103077[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (40))){
var inst_102818 = (cljs.core._LT__EQ_ === end_test);
var state_102937__$1 = state_102937;
if(cljs.core.truth_(inst_102818)){
var statearr_102981_103078 = state_102937__$1;
(statearr_102981_103078[(1)] = (42));

} else {
var statearr_102982_103079 = state_102937__$1;
(statearr_102982_103079[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (56))){
var inst_102831 = (state_102937[(12)]);
var inst_102750 = (state_102937[(33)]);
var inst_102836 = (state_102937[(46)]);
var inst_102843 = (state_102937[(42)]);
var inst_102743 = (state_102937[(34)]);
var inst_102859 = (state_102937[(16)]);
var inst_102806 = (state_102937[(45)]);
var inst_102826 = (state_102937[(23)]);
var inst_102857 = (state_102937[(18)]);
var inst_102842 = (state_102937[(43)]);
var inst_102751 = (state_102937[(36)]);
var inst_102770 = (state_102937[(47)]);
var inst_102739 = (state_102937[(29)]);
var inst_102746 = (state_102937[(30)]);
var inst_102865 = (state_102937[(26)]);
var inst_102832 = (state_102937[(48)]);
var inst_102864 = (state_102937[(24)]);
var inst_102744 = (state_102937[(38)]);
var inst_102761 = (state_102937[(14)]);
var inst_102824 = (state_102937[(49)]);
var inst_102788 = (state_102937[(22)]);
var inst_102852 = (state_102937[(50)]);
var inst_102847 = (state_102937[(44)]);
var inst_102825 = (state_102937[(25)]);
var inst_102797 = (state_102937[(51)]);
var inst_102815 = (state_102937[(52)]);
var inst_102858 = (state_102937[(17)]);
var inst_102779 = (state_102937[(40)]);
var inst_102868 = (function (){var no_filter_QMARK_ = true;
var vec__102733 = inst_102739;
var next_node = inst_102857;
var vec__102736 = inst_102746;
var flakes = inst_102864;
var s1 = inst_102761;
var o2 = inst_102788;
var t1 = inst_102743;
var i = inst_102858;
var m1 = inst_102815;
var root_node = inst_102852;
var to_t = inst_102843;
var s2 = inst_102770;
var p2 = inst_102806;
var permissions = inst_102832;
var limit = inst_102831;
var start_flake = inst_102825;
var acc = inst_102859;
var t2 = inst_102750;
var op1 = inst_102744;
var o1 = inst_102779;
var end_flake = inst_102826;
var base_result = inst_102865;
var p1 = inst_102797;
var idx_compare = inst_102836;
var op2 = inst_102751;
var from_t = inst_102842;
var m2 = inst_102824;
var novelty = inst_102847;
return (function (filtered_result,f){
if(cljs.core._EQ_.call(null,f.o,start_flake.o)){
return filtered_result;
} else {
return cljs.core.disj.call(null,filtered_result,f);
}
});
})();
var inst_102869 = cljs.core.reduce.call(null,inst_102868,inst_102865,inst_102865);
var state_102937__$1 = state_102937;
var statearr_102983_103080 = state_102937__$1;
(statearr_102983_103080[(2)] = inst_102869);

(statearr_102983_103080[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (33))){
var inst_102745 = (state_102937[(39)]);
var state_102937__$1 = state_102937;
var statearr_102984_103081 = state_102937__$1;
(statearr_102984_103081[(2)] = inst_102745);

(statearr_102984_103081[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (13))){
var inst_102742 = (state_102937[(31)]);
var inst_102773 = fluree.db.dbproto._subid.call(null,db,inst_102742);
var state_102937__$1 = state_102937;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_102937__$1,(16),inst_102773);
} else {
if((state_val_102938 === (22))){
var state_102937__$1 = state_102937;
var statearr_102985_103082 = state_102937__$1;
(statearr_102985_103082[(2)] = false);

(statearr_102985_103082[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (36))){
var state_102937__$1 = state_102937;
var statearr_102986_103083 = state_102937__$1;
(statearr_102986_103083[(2)] = fluree.db.util.core.min_integer);

(statearr_102986_103083[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (41))){
var inst_102750 = (state_102937[(33)]);
var inst_102743 = (state_102937[(34)]);
var inst_102806 = (state_102937[(45)]);
var inst_102827 = (state_102937[(53)]);
var inst_102751 = (state_102937[(36)]);
var inst_102770 = (state_102937[(47)]);
var inst_102744 = (state_102937[(38)]);
var inst_102761 = (state_102937[(14)]);
var inst_102824 = (state_102937[(49)]);
var inst_102788 = (state_102937[(22)]);
var inst_102797 = (state_102937[(51)]);
var inst_102815 = (state_102937[(52)]);
var inst_102779 = (state_102937[(40)]);
var inst_102824__$1 = (state_102937[(2)]);
var inst_102825 = fluree.db.flake.__GT_Flake.call(null,inst_102761,inst_102797,inst_102779,inst_102743,inst_102744,inst_102815);
var inst_102826 = fluree.db.flake.__GT_Flake.call(null,inst_102770,inst_102806,inst_102788,inst_102750,inst_102751,inst_102824__$1);
var inst_102827__$1 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(opts);
var state_102937__$1 = (function (){var statearr_102987 = state_102937;
(statearr_102987[(23)] = inst_102826);

(statearr_102987[(53)] = inst_102827__$1);

(statearr_102987[(49)] = inst_102824__$1);

(statearr_102987[(25)] = inst_102825);

return statearr_102987;
})();
if(cljs.core.truth_(inst_102827__$1)){
var statearr_102988_103084 = state_102937__$1;
(statearr_102988_103084[(1)] = (45));

} else {
var statearr_102989_103085 = state_102937__$1;
(statearr_102989_103085[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (43))){
var state_102937__$1 = state_102937;
var statearr_102990_103086 = state_102937__$1;
(statearr_102990_103086[(2)] = fluree.db.util.core.min_integer);

(statearr_102990_103086[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (61))){
var inst_102873 = (state_102937[(19)]);
var inst_102912 = (state_102937[(11)]);
var inst_102912__$1 = (state_102937[(2)]);
var inst_102913 = cljs.core.count.call(null,inst_102912__$1);
var state_102937__$1 = (function (){var statearr_102991 = state_102937;
(statearr_102991[(11)] = inst_102912__$1);

(statearr_102991[(54)] = inst_102913);

return statearr_102991;
})();
if(cljs.core.truth_(inst_102873)){
var statearr_102992_103087 = state_102937__$1;
(statearr_102992_103087[(1)] = (67));

} else {
var statearr_102993_103088 = state_102937__$1;
(statearr_102993_103088[(1)] = (68));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (29))){
var inst_102802 = (state_102937[(2)]);
var state_102937__$1 = state_102937;
if(cljs.core.truth_(inst_102802)){
var statearr_102994_103089 = state_102937__$1;
(statearr_102994_103089[(1)] = (30));

} else {
var statearr_102995_103090 = state_102937__$1;
(statearr_102995_103090[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (44))){
var inst_102822 = (state_102937[(2)]);
var state_102937__$1 = state_102937;
var statearr_102996_103091 = state_102937__$1;
(statearr_102996_103091[(2)] = inst_102822);

(statearr_102996_103091[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (6))){
var inst_102740 = (state_102937[(28)]);
var state_102937__$1 = state_102937;
var statearr_102997_103092 = state_102937__$1;
(statearr_102997_103092[(2)] = inst_102740);

(statearr_102997_103092[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (28))){
var state_102937__$1 = state_102937;
var statearr_102998_103093 = state_102937__$1;
(statearr_102998_103093[(2)] = false);

(statearr_102998_103093[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (64))){
var inst_102859 = (state_102937[(16)]);
var inst_102891 = (state_102937[(8)]);
var inst_102903 = cljs.core.into.call(null,inst_102891,inst_102859);
var state_102937__$1 = state_102937;
var statearr_102999_103094 = state_102937__$1;
(statearr_102999_103094[(2)] = inst_102903);

(statearr_102999_103094[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (51))){
var inst_102852 = (state_102937[(50)]);
var inst_102825 = (state_102937[(25)]);
var inst_102851 = (state_102937[(2)]);
var inst_102852__$1 = fluree.db.util.async.throw_err.call(null,inst_102851);
var inst_102853 = fluree.db.dbproto._lookup_leaf.call(null,inst_102852__$1,inst_102825);
var state_102937__$1 = (function (){var statearr_103000 = state_102937;
(statearr_103000[(50)] = inst_102852__$1);

return statearr_103000;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_102937__$1,(52),inst_102853);
} else {
if((state_val_102938 === (25))){
var inst_102741 = (state_102937[(37)]);
var state_102937__$1 = state_102937;
var statearr_103001_103095 = state_102937__$1;
(statearr_103001_103095[(2)] = inst_102741);

(statearr_103001_103095[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (34))){
var inst_102809 = (cljs.core._GT__EQ_ === start_test);
var state_102937__$1 = state_102937;
if(cljs.core.truth_(inst_102809)){
var statearr_103002_103096 = state_102937__$1;
(statearr_103002_103096[(1)] = (36));

} else {
var statearr_103003_103097 = state_102937__$1;
(statearr_103003_103097[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (17))){
var inst_102749 = (state_102937[(32)]);
var inst_102782 = fluree.db.dbproto._subid.call(null,db,inst_102749);
var state_102937__$1 = state_102937;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_102937__$1,(20),inst_102782);
} else {
if((state_val_102938 === (3))){
var inst_102729 = (state_102937[(2)]);
var state_102937__$1 = state_102937;
var statearr_103004_103098 = state_102937__$1;
(statearr_103004_103098[(2)] = inst_102729);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_102937__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (12))){
var inst_102766 = (state_102937[(2)]);
var inst_102767 = fluree.db.util.async.throw_err.call(null,inst_102766);
var state_102937__$1 = state_102937;
var statearr_103005_103099 = state_102937__$1;
(statearr_103005_103099[(2)] = inst_102767);

(statearr_103005_103099[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (2))){
var inst_102935 = (state_102937[(2)]);
var state_102937__$1 = state_102937;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_102937__$1,inst_102935);
} else {
if((state_val_102938 === (66))){
var inst_102908 = (state_102937[(2)]);
var state_102937__$1 = state_102937;
var statearr_103006_103100 = state_102937__$1;
(statearr_103006_103100[(2)] = inst_102908);

(statearr_103006_103100[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (23))){
var inst_102793 = (state_102937[(2)]);
var state_102937__$1 = state_102937;
if(cljs.core.truth_(inst_102793)){
var statearr_103007_103101 = state_102937__$1;
(statearr_103007_103101[(1)] = (24));

} else {
var statearr_103008_103102 = state_102937__$1;
(statearr_103008_103102[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (47))){
var inst_102837 = (state_102937[(41)]);
var inst_102831 = (state_102937[(2)]);
var inst_102832 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_102833 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_102834 = [new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),idx,new cljs.core.Keyword(null,"comparator","comparator",2144896662)];
var inst_102835 = (new cljs.core.PersistentVector(null,3,(5),inst_102833,inst_102834,null));
var inst_102836 = cljs.core.get_in.call(null,db,inst_102835);
var inst_102837__$1 = new cljs.core.Keyword(null,"from-t","from-t",1730913525).cljs$core$IFn$_invoke$arity$1(opts);
var state_102937__$1 = (function (){var statearr_103009 = state_102937;
(statearr_103009[(12)] = inst_102831);

(statearr_103009[(46)] = inst_102836);

(statearr_103009[(48)] = inst_102832);

(statearr_103009[(41)] = inst_102837__$1);

return statearr_103009;
})();
if(cljs.core.truth_(inst_102837__$1)){
var statearr_103010_103103 = state_102937__$1;
(statearr_103010_103103[(1)] = (48));

} else {
var statearr_103011_103104 = state_102937__$1;
(statearr_103011_103104[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (35))){
var inst_102752 = (state_102937[(27)]);
var inst_102815 = (state_102937[(2)]);
var state_102937__$1 = (function (){var statearr_103012 = state_102937;
(statearr_103012[(52)] = inst_102815);

return statearr_103012;
})();
if(cljs.core.truth_(inst_102752)){
var statearr_103013_103105 = state_102937__$1;
(statearr_103013_103105[(1)] = (39));

} else {
var statearr_103014_103106 = state_102937__$1;
(statearr_103014_103106[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (19))){
var inst_102741 = (state_102937[(37)]);
var inst_102788 = (state_102937[(2)]);
var inst_102789 = (inst_102741 == null);
var state_102937__$1 = (function (){var statearr_103015 = state_102937;
(statearr_103015[(22)] = inst_102788);

return statearr_103015;
})();
if(cljs.core.truth_(inst_102789)){
var statearr_103016_103107 = state_102937__$1;
(statearr_103016_103107[(1)] = (21));

} else {
var statearr_103017_103108 = state_102937__$1;
(statearr_103017_103108[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (57))){
var inst_102865 = (state_102937[(26)]);
var state_102937__$1 = state_102937;
var statearr_103018_103109 = state_102937__$1;
(statearr_103018_103109[(2)] = inst_102865);

(statearr_103018_103109[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (68))){
var inst_102873 = (state_102937[(19)]);
var state_102937__$1 = state_102937;
var statearr_103019_103110 = state_102937__$1;
(statearr_103019_103110[(2)] = inst_102873);

(statearr_103019_103110[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (11))){
var inst_102742 = (state_102937[(31)]);
var inst_102770 = (state_102937[(2)]);
var inst_102771 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_102742);
var state_102937__$1 = (function (){var statearr_103020 = state_102937;
(statearr_103020[(47)] = inst_102770);

return statearr_103020;
})();
if(inst_102771){
var statearr_103021_103111 = state_102937__$1;
(statearr_103021_103111[(1)] = (13));

} else {
var statearr_103022_103112 = state_102937__$1;
(statearr_103022_103112[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (9))){
var inst_102747 = (state_102937[(13)]);
var inst_102764 = fluree.db.dbproto._subid.call(null,db,inst_102747);
var state_102937__$1 = state_102937;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_102937__$1,(12),inst_102764);
} else {
if((state_val_102938 === (5))){
var inst_102740 = (state_102937[(28)]);
var inst_102755 = fluree.db.dbproto._subid.call(null,db,inst_102740);
var state_102937__$1 = state_102937;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_102937__$1,(8),inst_102755);
} else {
if((state_val_102938 === (14))){
var inst_102742 = (state_102937[(31)]);
var state_102937__$1 = state_102937;
var statearr_103023_103113 = state_102937__$1;
(statearr_103023_103113[(2)] = inst_102742);

(statearr_103023_103113[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (45))){
var inst_102827 = (state_102937[(53)]);
var state_102937__$1 = state_102937;
var statearr_103024_103114 = state_102937__$1;
(statearr_103024_103114[(2)] = inst_102827);

(statearr_103024_103114[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (53))){
var inst_102843 = (state_102937[(42)]);
var inst_102857 = (state_102937[(18)]);
var inst_102842 = (state_102937[(43)]);
var inst_102847 = (state_102937[(44)]);
var inst_102861 = fluree.db.dbproto._resolve_history_range.call(null,inst_102857,inst_102842,inst_102843,inst_102847);
var state_102937__$1 = state_102937;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_102937__$1,(55),inst_102861);
} else {
if((state_val_102938 === (26))){
var inst_102748 = (state_102937[(35)]);
var inst_102797 = (state_102937[(2)]);
var inst_102798 = (inst_102748 == null);
var state_102937__$1 = (function (){var statearr_103025 = state_102937;
(statearr_103025[(51)] = inst_102797);

return statearr_103025;
})();
if(cljs.core.truth_(inst_102798)){
var statearr_103026_103115 = state_102937__$1;
(statearr_103026_103115[(1)] = (27));

} else {
var statearr_103027_103116 = state_102937__$1;
(statearr_103027_103116[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (16))){
var inst_102775 = (state_102937[(2)]);
var inst_102776 = fluree.db.util.async.throw_err.call(null,inst_102775);
var state_102937__$1 = state_102937;
var statearr_103028_103117 = state_102937__$1;
(statearr_103028_103117[(2)] = inst_102776);

(statearr_103028_103117[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (38))){
var inst_102813 = (state_102937[(2)]);
var state_102937__$1 = state_102937;
var statearr_103029_103118 = state_102937__$1;
(statearr_103029_103118[(2)] = inst_102813);

(statearr_103029_103118[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (30))){
var state_102937__$1 = state_102937;
var statearr_103030_103119 = state_102937__$1;
(statearr_103030_103119[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_103030_103119[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (73))){
var inst_102912 = (state_102937[(11)]);
var inst_102913 = (state_102937[(54)]);
var inst_102927 = (state_102937[(2)]);
var inst_102928 = fluree.db.util.async.throw_err.call(null,inst_102927);
var inst_102857 = inst_102928;
var inst_102858 = inst_102913;
var inst_102859 = inst_102912;
var state_102937__$1 = (function (){var statearr_103031 = state_102937;
(statearr_103031[(16)] = inst_102859);

(statearr_103031[(18)] = inst_102857);

(statearr_103031[(17)] = inst_102858);

return statearr_103031;
})();
var statearr_103032_103120 = state_102937__$1;
(statearr_103032_103120[(2)] = null);

(statearr_103032_103120[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (10))){
var inst_102747 = (state_102937[(13)]);
var state_102937__$1 = state_102937;
var statearr_103033_103121 = state_102937__$1;
(statearr_103033_103121[(2)] = inst_102747);

(statearr_103033_103121[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (18))){
var inst_102749 = (state_102937[(32)]);
var state_102937__$1 = state_102937;
var statearr_103034_103122 = state_102937__$1;
(statearr_103034_103122[(2)] = inst_102749);

(statearr_103034_103122[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (52))){
var inst_102855 = (state_102937[(2)]);
var inst_102856 = fluree.db.util.async.throw_err.call(null,inst_102855);
var inst_102857 = inst_102856;
var inst_102858 = (0);
var inst_102859 = null;
var state_102937__$1 = (function (){var statearr_103035 = state_102937;
(statearr_103035[(16)] = inst_102859);

(statearr_103035[(18)] = inst_102857);

(statearr_103035[(17)] = inst_102858);

return statearr_103035;
})();
var statearr_103036_103123 = state_102937__$1;
(statearr_103036_103123[(2)] = null);

(statearr_103036_103123[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (67))){
var inst_102831 = (state_102937[(12)]);
var inst_102836 = (state_102937[(46)]);
var inst_102826 = (state_102937[(23)]);
var inst_102873 = (state_102937[(19)]);
var inst_102913 = (state_102937[(54)]);
var inst_102915 = inst_102836.call(null,inst_102873,inst_102826);
var inst_102916 = (inst_102915 < (0));
var inst_102917 = (inst_102913 < inst_102831);
var inst_102918 = ((inst_102916) && (inst_102917));
var state_102937__$1 = state_102937;
var statearr_103037_103124 = state_102937__$1;
(statearr_103037_103124[(2)] = inst_102918);

(statearr_103037_103124[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (71))){
var inst_102873 = (state_102937[(19)]);
var inst_102852 = (state_102937[(50)]);
var inst_102925 = fluree.db.dbproto._lookup_leaf.call(null,inst_102852,inst_102873);
var state_102937__$1 = state_102937;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_102937__$1,(73),inst_102925);
} else {
if((state_val_102938 === (42))){
var state_102937__$1 = state_102937;
var statearr_103038_103125 = state_102937__$1;
(statearr_103038_103125[(2)] = (2147483647));

(statearr_103038_103125[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (37))){
var state_102937__$1 = state_102937;
var statearr_103039_103126 = state_102937__$1;
(statearr_103039_103126[(2)] = (2147483647));

(statearr_103039_103126[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (63))){
var inst_102910 = (state_102937[(2)]);
var state_102937__$1 = state_102937;
var statearr_103040_103127 = state_102937__$1;
(statearr_103040_103127[(2)] = inst_102910);

(statearr_103040_103127[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (8))){
var inst_102757 = (state_102937[(2)]);
var inst_102758 = fluree.db.util.async.throw_err.call(null,inst_102757);
var state_102937__$1 = state_102937;
var statearr_103041_103128 = state_102937__$1;
(statearr_103041_103128[(2)] = inst_102758);

(statearr_103041_103128[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102938 === (49))){
var inst_102840 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var state_102937__$1 = state_102937;
var statearr_103042_103129 = state_102937__$1;
(statearr_103042_103129[(2)] = inst_102840);

(statearr_103042_103129[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__99975__auto__ = null;
var fluree$db$query$range$state_machine__99975__auto____0 = (function (){
var statearr_103043 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_103043[(0)] = fluree$db$query$range$state_machine__99975__auto__);

(statearr_103043[(1)] = (1));

return statearr_103043;
});
var fluree$db$query$range$state_machine__99975__auto____1 = (function (state_102937){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_102937);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e103044){if((e103044 instanceof Object)){
var ex__99978__auto__ = e103044;
var statearr_103045_103130 = state_102937;
(statearr_103045_103130[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_102937);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e103044;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__103131 = state_102937;
state_102937 = G__103131;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__99975__auto__ = function(state_102937){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__99975__auto____1.call(this,state_102937);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__99975__auto____0;
fluree$db$query$range$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__99975__auto____1;
return fluree$db$query$range$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_103046 = f__100070__auto__.call(null);
(statearr_103046[(6)] = c__100069__auto__);

return statearr_103046;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.query.range.time_range.cljs$lang$maxFixedArity = 7);

/**
 * Starting with flakes grouped by subject id, filters the flakes until
 *   either flake-limit or subject-limit reached.
 */
fluree.db.query.range.subject_groups__GT_allow_flakes = (function fluree$db$query$range$subject_groups__GT_allow_flakes(db,subject_groups,flake_start,subject_start,flake_limit,subject_limit){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_103178){
var state_val_103179 = (state_103178[(1)]);
if((state_val_103179 === (7))){
var state_103178__$1 = state_103178;
var statearr_103180_103198 = state_103178__$1;
(statearr_103180_103198[(2)] = (0));

(statearr_103180_103198[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103179 === (1))){
var inst_103139 = cljs.core.seq.call(null,subject_groups);
var inst_103140 = cljs.core.first.call(null,inst_103139);
var inst_103141 = cljs.core.next.call(null,inst_103139);
var inst_103142 = cljs.core.PersistentVector.EMPTY;
var inst_103143 = subject_groups;
var inst_103144 = flake_start;
var inst_103145 = subject_start;
var inst_103146 = inst_103142;
var state_103178__$1 = (function (){var statearr_103181 = state_103178;
(statearr_103181[(7)] = inst_103145);

(statearr_103181[(8)] = inst_103141);

(statearr_103181[(9)] = inst_103143);

(statearr_103181[(10)] = inst_103140);

(statearr_103181[(11)] = inst_103144);

(statearr_103181[(12)] = inst_103146);

return statearr_103181;
})();
var statearr_103182_103199 = state_103178__$1;
(statearr_103182_103199[(2)] = null);

(statearr_103182_103199[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103179 === (4))){
var inst_103145 = (state_103178[(7)]);
var inst_103144 = (state_103178[(11)]);
var inst_103146 = (state_103178[(12)]);
var inst_103159 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_103160 = [inst_103144,inst_103145,inst_103146];
var inst_103161 = (new cljs.core.PersistentVector(null,3,(5),inst_103159,inst_103160,null));
var state_103178__$1 = state_103178;
var statearr_103183_103200 = state_103178__$1;
(statearr_103183_103200[(2)] = inst_103161);

(statearr_103183_103200[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103179 === (6))){
var inst_103174 = (state_103178[(2)]);
var state_103178__$1 = state_103178;
var statearr_103184_103201 = state_103178__$1;
(statearr_103184_103201[(2)] = inst_103174);

(statearr_103184_103201[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103179 === (3))){
var inst_103176 = (state_103178[(2)]);
var state_103178__$1 = state_103178;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_103178__$1,inst_103176);
} else {
if((state_val_103179 === (2))){
var inst_103145 = (state_103178[(7)]);
var inst_103152 = (state_103178[(13)]);
var inst_103143 = (state_103178[(9)]);
var inst_103144 = (state_103178[(11)]);
var inst_103151 = cljs.core.seq.call(null,inst_103143);
var inst_103152__$1 = cljs.core.first.call(null,inst_103151);
var inst_103153 = cljs.core.next.call(null,inst_103151);
var inst_103154 = (inst_103152__$1 == null);
var inst_103155 = (inst_103144 >= flake_limit);
var inst_103156 = (inst_103145 >= subject_limit);
var inst_103157 = ((inst_103154) || (inst_103155) || (inst_103156));
var state_103178__$1 = (function (){var statearr_103185 = state_103178;
(statearr_103185[(13)] = inst_103152__$1);

(statearr_103185[(14)] = inst_103153);

return statearr_103185;
})();
if(cljs.core.truth_(inst_103157)){
var statearr_103186_103202 = state_103178__$1;
(statearr_103186_103202[(1)] = (4));

} else {
var statearr_103187_103203 = state_103178__$1;
(statearr_103187_103203[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103179 === (9))){
var inst_103145 = (state_103178[(7)]);
var inst_103152 = (state_103178[(13)]);
var inst_103153 = (state_103178[(14)]);
var inst_103144 = (state_103178[(11)]);
var inst_103163 = (state_103178[(15)]);
var inst_103146 = (state_103178[(12)]);
var inst_103168 = (state_103178[(2)]);
var inst_103169 = (inst_103144 + inst_103163);
var inst_103170 = (inst_103145 + inst_103168);
var inst_103171 = cljs.core.into.call(null,inst_103146,inst_103152);
var inst_103143 = inst_103153;
var inst_103144__$1 = inst_103169;
var inst_103145__$1 = inst_103170;
var inst_103146__$1 = inst_103171;
var state_103178__$1 = (function (){var statearr_103188 = state_103178;
(statearr_103188[(7)] = inst_103145__$1);

(statearr_103188[(9)] = inst_103143);

(statearr_103188[(11)] = inst_103144__$1);

(statearr_103188[(12)] = inst_103146__$1);

return statearr_103188;
})();
var statearr_103189_103204 = state_103178__$1;
(statearr_103189_103204[(2)] = null);

(statearr_103189_103204[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103179 === (5))){
var inst_103152 = (state_103178[(13)]);
var inst_103163 = (state_103178[(15)]);
var inst_103163__$1 = cljs.core.count.call(null,inst_103152);
var inst_103164 = cljs.core._EQ_.call(null,(0),inst_103163__$1);
var state_103178__$1 = (function (){var statearr_103190 = state_103178;
(statearr_103190[(15)] = inst_103163__$1);

return statearr_103190;
})();
if(inst_103164){
var statearr_103191_103205 = state_103178__$1;
(statearr_103191_103205[(1)] = (7));

} else {
var statearr_103192_103206 = state_103178__$1;
(statearr_103192_103206[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103179 === (8))){
var state_103178__$1 = state_103178;
var statearr_103193_103207 = state_103178__$1;
(statearr_103193_103207[(2)] = (1));

(statearr_103193_103207[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__99975__auto__ = null;
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__99975__auto____0 = (function (){
var statearr_103194 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_103194[(0)] = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__99975__auto__);

(statearr_103194[(1)] = (1));

return statearr_103194;
});
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__99975__auto____1 = (function (state_103178){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_103178);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e103195){if((e103195 instanceof Object)){
var ex__99978__auto__ = e103195;
var statearr_103196_103208 = state_103178;
(statearr_103196_103208[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_103178);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e103195;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__103209 = state_103178;
state_103178 = G__103209;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__99975__auto__ = function(state_103178){
switch(arguments.length){
case 0:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__99975__auto____1.call(this,state_103178);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__99975__auto____0;
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__99975__auto____1;
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_103197 = f__100070__auto__.call(null);
(statearr_103197[(6)] = c__100069__auto__);

return statearr_103197;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
fluree.db.query.range.find_next_valid_node = (function fluree$db$query$range$find_next_valid_node(root_node,rhs,t,novelty,fast_forward_db_QMARK_){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_103249){
var state_val_103250 = (state_103249[(1)]);
if((state_val_103250 === (7))){
var inst_103245 = (state_103249[(2)]);
var state_103249__$1 = state_103249;
var statearr_103251_103276 = state_103249__$1;
(statearr_103251_103276[(2)] = inst_103245);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_103249__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103250 === (1))){
var state_103249__$1 = state_103249;
var statearr_103252_103277 = state_103249__$1;
(statearr_103252_103277[(2)] = null);

(statearr_103252_103277[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103250 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_103249,(3),Error,null,(2));
var inst_103214 = fluree.db.dbproto._lookup_leaf.call(null,root_node,rhs);
var state_103249__$1 = state_103249;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_103249__$1,(5),inst_103214);
} else {
if((state_val_103250 === (15))){
var inst_103232 = (state_103249[(7)]);
var inst_103234 = fluree.db.dbproto._lookup_leaf.call(null,root_node,inst_103232);
var state_103249__$1 = state_103249;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_103249__$1,(18),inst_103234);
} else {
if((state_val_103250 === (13))){
var inst_103218 = (state_103249[(8)]);
var inst_103232 = (state_103249[(7)]);
var inst_103232__$1 = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(inst_103218);
var state_103249__$1 = (function (){var statearr_103253 = state_103249;
(statearr_103253[(7)] = inst_103232__$1);

return statearr_103253;
})();
if(cljs.core.truth_(inst_103232__$1)){
var statearr_103254_103278 = state_103249__$1;
(statearr_103254_103278[(1)] = (15));

} else {
var statearr_103255_103279 = state_103249__$1;
(statearr_103255_103279[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103250 === (6))){
var state_103249__$1 = state_103249;
var statearr_103256_103280 = state_103249__$1;
(statearr_103256_103280[(2)] = null);

(statearr_103256_103280[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103250 === (17))){
var inst_103241 = (state_103249[(2)]);
var state_103249__$1 = state_103249;
var statearr_103257_103281 = state_103249__$1;
(statearr_103257_103281[(2)] = inst_103241);

(statearr_103257_103281[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103250 === (3))){
var inst_103210 = (state_103249[(2)]);
var state_103249__$1 = state_103249;
var statearr_103258_103282 = state_103249__$1;
(statearr_103258_103282[(2)] = inst_103210);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_103249__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103250 === (12))){
var inst_103229 = (state_103249[(9)]);
var state_103249__$1 = state_103249;
var statearr_103259_103283 = state_103249__$1;
(statearr_103259_103283[(2)] = inst_103229);

(statearr_103259_103283[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103250 === (2))){
var inst_103247 = (state_103249[(2)]);
var state_103249__$1 = state_103249;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_103249__$1,inst_103247);
} else {
if((state_val_103250 === (11))){
var inst_103226 = (state_103249[(2)]);
var inst_103227 = fluree.db.util.async.throw_err.call(null,inst_103226);
var state_103249__$1 = state_103249;
var statearr_103260_103284 = state_103249__$1;
(statearr_103260_103284[(2)] = inst_103227);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_103249__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103250 === (9))){
var inst_103220 = (state_103249[(2)]);
var state_103249__$1 = (function (){var statearr_103261 = state_103249;
(statearr_103261[(10)] = inst_103220);

return statearr_103261;
})();
var statearr_103262_103285 = state_103249__$1;
(statearr_103262_103285[(2)] = null);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_103249__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103250 === (5))){
var inst_103216 = (state_103249[(2)]);
var inst_103217 = fluree.db.util.async.throw_err.call(null,inst_103216);
var inst_103218 = inst_103217;
var state_103249__$1 = (function (){var statearr_103263 = state_103249;
(statearr_103263[(8)] = inst_103218);

return statearr_103263;
})();
var statearr_103264_103286 = state_103249__$1;
(statearr_103264_103286[(2)] = null);

(statearr_103264_103286[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103250 === (14))){
var inst_103243 = (state_103249[(2)]);
var state_103249__$1 = state_103249;
var statearr_103265_103287 = state_103249__$1;
(statearr_103265_103287[(2)] = inst_103243);

(statearr_103265_103287[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103250 === (16))){
var state_103249__$1 = state_103249;
var statearr_103266_103288 = state_103249__$1;
(statearr_103266_103288[(2)] = null);

(statearr_103266_103288[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103250 === (10))){
var inst_103218 = (state_103249[(8)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_103249,(9),new cljs.core.Keyword(null,"default","default",-1987822328),null,(8));
var inst_103224 = fluree.db.dbproto._resolve_to_t.call(null,inst_103218,t,novelty,fast_forward_db_QMARK_);
var state_103249__$1 = state_103249;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_103249__$1,(11),inst_103224);
} else {
if((state_val_103250 === (18))){
var inst_103236 = (state_103249[(2)]);
var inst_103237 = fluree.db.util.async.throw_err.call(null,inst_103236);
var inst_103218 = inst_103237;
var state_103249__$1 = (function (){var statearr_103267 = state_103249;
(statearr_103267[(8)] = inst_103218);

return statearr_103267;
})();
var statearr_103268_103289 = state_103249__$1;
(statearr_103268_103289[(2)] = null);

(statearr_103268_103289[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103250 === (8))){
var inst_103229 = (state_103249[(9)]);
var inst_103229__$1 = (state_103249[(2)]);
var state_103249__$1 = (function (){var statearr_103269 = state_103249;
(statearr_103269[(9)] = inst_103229__$1);

return statearr_103269;
})();
if(cljs.core.truth_(inst_103229__$1)){
var statearr_103270_103290 = state_103249__$1;
(statearr_103270_103290[(1)] = (12));

} else {
var statearr_103271_103291 = state_103249__$1;
(statearr_103271_103291[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$find_next_valid_node_$_state_machine__99975__auto__ = null;
var fluree$db$query$range$find_next_valid_node_$_state_machine__99975__auto____0 = (function (){
var statearr_103272 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_103272[(0)] = fluree$db$query$range$find_next_valid_node_$_state_machine__99975__auto__);

(statearr_103272[(1)] = (1));

return statearr_103272;
});
var fluree$db$query$range$find_next_valid_node_$_state_machine__99975__auto____1 = (function (state_103249){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_103249);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e103273){if((e103273 instanceof Object)){
var ex__99978__auto__ = e103273;
var statearr_103274_103292 = state_103249;
(statearr_103274_103292[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_103249);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e103273;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__103293 = state_103249;
state_103249 = G__103293;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$range$find_next_valid_node_$_state_machine__99975__auto__ = function(state_103249){
switch(arguments.length){
case 0:
return fluree$db$query$range$find_next_valid_node_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$range$find_next_valid_node_$_state_machine__99975__auto____1.call(this,state_103249);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$find_next_valid_node_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$find_next_valid_node_$_state_machine__99975__auto____0;
fluree$db$query$range$find_next_valid_node_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$find_next_valid_node_$_state_machine__99975__auto____1;
return fluree$db$query$range$find_next_valid_node_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_103275 = f__100070__auto__.call(null);
(statearr_103275[(6)] = c__100069__auto__);

return statearr_103275;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Range query across an index as of a 't' defined by the db.
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.index_range = (function fluree$db$query$range$index_range(var_args){
var G__103300 = arguments.length;
switch (G__103300) {
case 2:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.index_range.call(null,db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.index_range.call(null,db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx),opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.index_range.call(null,db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__103301 = (function (){var pred__103304 = cljs.core.identical_QMARK_;
var expr__103305 = test;
if(cljs.core.truth_(pred__103304.call(null,cljs.core._EQ_,expr__103305))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__103304.call(null,cljs.core._LT_,expr__103305))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_(pred__103304.call(null,cljs.core._LT__EQ_,expr__103305))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__103304.call(null,cljs.core._GT_,expr__103305))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
if(cljs.core.truth_(pred__103304.call(null,cljs.core._GT__EQ_,expr__103305))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__103305)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.call(null,vec__103301,(0),null);
var start_match = cljs.core.nth.call(null,vec__103301,(1),null);
var end_test = cljs.core.nth.call(null,vec__103301,(2),null);
var end_match = cljs.core.nth.call(null,vec__103301,(3),null);
return fluree.db.query.range.index_range.call(null,db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.index_range.call(null,db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_103698){
var state_val_103699 = (state_103698[(1)]);
if((state_val_103699 === (121))){
var inst_103671 = (state_103698[(7)]);
var inst_103671__$1 = (state_103698[(2)]);
var state_103698__$1 = (function (){var statearr_103700 = state_103698;
(statearr_103700[(7)] = inst_103671__$1);

return statearr_103700;
})();
if(cljs.core.truth_(inst_103671__$1)){
var statearr_103701_103896 = state_103698__$1;
(statearr_103701_103896[(1)] = (122));

} else {
var statearr_103702_103897 = state_103698__$1;
(statearr_103702_103897[(1)] = (123));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (65))){
var inst_103467 = (state_103698[(2)]);
var state_103698__$1 = state_103698;
var statearr_103703_103898 = state_103698__$1;
(statearr_103703_103898[(2)] = inst_103467);

(statearr_103703_103898[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (70))){
var state_103698__$1 = state_103698;
var statearr_103704_103899 = state_103698__$1;
(statearr_103704_103899[(2)] = false);

(statearr_103704_103899[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (62))){
var inst_103329 = (state_103698[(8)]);
var inst_103330 = (state_103698[(9)]);
var inst_103469 = (state_103698[(10)]);
var inst_103424 = (state_103698[(11)]);
var inst_103336 = (state_103698[(12)]);
var inst_103337 = (state_103698[(13)]);
var inst_103380 = (state_103698[(14)]);
var inst_103460 = (state_103698[(15)]);
var inst_103433 = (state_103698[(16)]);
var inst_103371 = (state_103698[(17)]);
var inst_103442 = (state_103698[(18)]);
var inst_103451 = (state_103698[(19)]);
var inst_103469__$1 = (state_103698[(2)]);
var inst_103470 = fluree.db.flake.__GT_Flake.call(null,inst_103371,inst_103442,inst_103424,inst_103329,inst_103330,inst_103460);
var inst_103471 = fluree.db.flake.__GT_Flake.call(null,inst_103380,inst_103451,inst_103433,inst_103336,inst_103337,inst_103469__$1);
var inst_103473 = (opts == null);
var inst_103474 = cljs.core.not.call(null,inst_103473);
var state_103698__$1 = (function (){var statearr_103705 = state_103698;
(statearr_103705[(10)] = inst_103469__$1);

(statearr_103705[(20)] = inst_103470);

(statearr_103705[(21)] = inst_103471);

return statearr_103705;
})();
if(inst_103474){
var statearr_103706_103900 = state_103698__$1;
(statearr_103706_103900[(1)] = (66));

} else {
var statearr_103707_103901 = state_103698__$1;
(statearr_103707_103901[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (74))){
var inst_103494 = (state_103698[(22)]);
var inst_103492 = (state_103698[(23)]);
var inst_103492__$1 = (state_103698[(2)]);
var inst_103493 = cljs.core.get.call(null,inst_103492__$1,new cljs.core.Keyword(null,"flake-limit","flake-limit",-1060039961),fluree.db.util.core.max_long);
var inst_103494__$1 = cljs.core.get.call(null,inst_103492__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_103495 = cljs.core.get.call(null,inst_103492__$1,new cljs.core.Keyword(null,"offset","offset",296498311),(0));
var state_103698__$1 = (function (){var statearr_103708 = state_103698;
(statearr_103708[(22)] = inst_103494__$1);

(statearr_103708[(24)] = inst_103493);

(statearr_103708[(23)] = inst_103492__$1);

(statearr_103708[(25)] = inst_103495);

return statearr_103708;
})();
if(cljs.core.truth_(inst_103494__$1)){
var statearr_103709_103902 = state_103698__$1;
(statearr_103709_103902[(1)] = (75));

} else {
var statearr_103710_103903 = state_103698__$1;
(statearr_103710_103903[(1)] = (76));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (110))){
var inst_103493 = (state_103698[(24)]);
var inst_103499 = (state_103698[(26)]);
var inst_103593 = (state_103698[(27)]);
var inst_103526 = (state_103698[(28)]);
var inst_103525 = (state_103698[(29)]);
var inst_103642 = fluree.db.query.range.subject_groups__GT_allow_flakes.call(null,db,inst_103593,inst_103525,inst_103526,inst_103493,inst_103499);
var state_103698__$1 = state_103698;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_103698__$1,(118),inst_103642);
} else {
if((state_val_103699 === (130))){
var inst_103659 = (state_103698[(30)]);
var inst_103662 = (state_103698[(31)]);
var inst_103679 = (state_103698[(32)]);
var inst_103661 = (state_103698[(33)]);
var inst_103660 = (state_103698[(34)]);
var inst_103523 = inst_103679;
var inst_103524 = inst_103659;
var inst_103525 = inst_103660;
var inst_103526 = inst_103661;
var inst_103527 = inst_103662;
var state_103698__$1 = (function (){var statearr_103711 = state_103698;
(statearr_103711[(35)] = inst_103523);

(statearr_103711[(28)] = inst_103526);

(statearr_103711[(36)] = inst_103527);

(statearr_103711[(29)] = inst_103525);

(statearr_103711[(37)] = inst_103524);

return statearr_103711;
})();
var statearr_103712_103904 = state_103698__$1;
(statearr_103712_103904[(2)] = null);

(statearr_103712_103904[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (128))){
var inst_103683 = (state_103698[(2)]);
var inst_103684 = cljs.core.not.call(null,inst_103683);
var state_103698__$1 = state_103698;
if(inst_103684){
var statearr_103713_103905 = state_103698__$1;
(statearr_103713_103905[(1)] = (129));

} else {
var statearr_103714_103906 = state_103698__$1;
(statearr_103714_103906[(1)] = (130));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (7))){
var inst_103354 = (state_103698[(2)]);
var state_103698__$1 = state_103698;
if(cljs.core.truth_(inst_103354)){
var statearr_103715_103907 = state_103698__$1;
(statearr_103715_103907[(1)] = (11));

} else {
var statearr_103716_103908 = state_103698__$1;
(statearr_103716_103908[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (59))){
var inst_103458 = (state_103698[(2)]);
var state_103698__$1 = state_103698;
var statearr_103717_103909 = state_103698__$1;
(statearr_103717_103909[(2)] = inst_103458);

(statearr_103717_103909[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (86))){
var inst_103533 = (state_103698[(38)]);
var state_103698__$1 = state_103698;
var statearr_103718_103910 = state_103698__$1;
(statearr_103718_103910[(2)] = inst_103533);

(statearr_103718_103910[(1)] = (87));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (20))){
var inst_103328 = (state_103698[(39)]);
var inst_103380 = (state_103698[(2)]);
var inst_103381 = cljs.core.boolean_QMARK_.call(null,inst_103328);
var state_103698__$1 = (function (){var statearr_103719 = state_103698;
(statearr_103719[(14)] = inst_103380);

return statearr_103719;
})();
if(inst_103381){
var statearr_103720_103911 = state_103698__$1;
(statearr_103720_103911[(1)] = (22));

} else {
var statearr_103721_103912 = state_103698__$1;
(statearr_103721_103912[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (72))){
var inst_103489 = cljs.core.apply.call(null,cljs.core.hash_map,opts);
var state_103698__$1 = state_103698;
var statearr_103722_103913 = state_103698__$1;
(statearr_103722_103913[(2)] = inst_103489);

(statearr_103722_103913[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (58))){
var state_103698__$1 = state_103698;
var statearr_103723_103914 = state_103698__$1;
(statearr_103723_103914[(2)] = (2147483647));

(statearr_103723_103914[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (60))){
var inst_103338 = (state_103698[(40)]);
var state_103698__$1 = state_103698;
var statearr_103724_103915 = state_103698__$1;
(statearr_103724_103915[(2)] = inst_103338);

(statearr_103724_103915[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (27))){
var inst_103392 = (state_103698[(2)]);
var state_103698__$1 = state_103698;
var statearr_103725_103916 = state_103698__$1;
(statearr_103725_103916[(2)] = inst_103392);

(statearr_103725_103916[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (1))){
var state_103698__$1 = state_103698;
var statearr_103726_103917 = state_103698__$1;
(statearr_103726_103917[(2)] = null);

(statearr_103726_103917[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (69))){
var state_103698__$1 = state_103698;
var statearr_103727_103918 = state_103698__$1;
(statearr_103727_103918[(2)] = true);

(statearr_103727_103918[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (101))){
var state_103698__$1 = state_103698;
var statearr_103728_103919 = state_103698__$1;
(statearr_103728_103919[(2)] = false);

(statearr_103728_103919[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (24))){
var inst_103394 = (state_103698[(41)]);
var inst_103394__$1 = (state_103698[(2)]);
var state_103698__$1 = (function (){var statearr_103729 = state_103698;
(statearr_103729[(41)] = inst_103394__$1);

return statearr_103729;
})();
if(cljs.core.truth_(inst_103394__$1)){
var statearr_103730_103920 = state_103698__$1;
(statearr_103730_103920[(1)] = (31));

} else {
var statearr_103731_103921 = state_103698__$1;
(statearr_103731_103921[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (102))){
var inst_103566 = (state_103698[(2)]);
var state_103698__$1 = state_103698;
var statearr_103732_103922 = state_103698__$1;
(statearr_103732_103922[(2)] = inst_103566);

(statearr_103732_103922[(1)] = (99));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (55))){
var inst_103454 = (cljs.core._GT__EQ_ === start_test);
var state_103698__$1 = state_103698;
if(cljs.core.truth_(inst_103454)){
var statearr_103733_103923 = state_103698__$1;
(statearr_103733_103923[(1)] = (57));

} else {
var statearr_103734_103924 = state_103698__$1;
(statearr_103734_103924[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (85))){
var inst_103523 = (state_103698[(35)]);
var inst_103516 = (state_103698[(42)]);
var inst_103329 = (state_103698[(8)]);
var inst_103330 = (state_103698[(9)]);
var inst_103505 = (state_103698[(43)]);
var inst_103506 = (state_103698[(44)]);
var inst_103493 = (state_103698[(24)]);
var inst_103415 = (state_103698[(45)]);
var inst_103360 = (state_103698[(46)]);
var inst_103469 = (state_103698[(10)]);
var inst_103424 = (state_103698[(11)]);
var inst_103336 = (state_103698[(12)]);
var inst_103359 = (state_103698[(47)]);
var inst_103470 = (state_103698[(20)]);
var inst_103499 = (state_103698[(26)]);
var inst_103337 = (state_103698[(13)]);
var inst_103332 = (state_103698[(48)]);
var inst_103380 = (state_103698[(14)]);
var inst_103500 = (state_103698[(49)]);
var inst_103460 = (state_103698[(15)]);
var inst_103533 = (state_103698[(38)]);
var inst_103471 = (state_103698[(21)]);
var inst_103433 = (state_103698[(16)]);
var inst_103526 = (state_103698[(28)]);
var inst_103510 = (state_103698[(50)]);
var inst_103527 = (state_103698[(36)]);
var inst_103501 = (state_103698[(51)]);
var inst_103325 = (state_103698[(52)]);
var inst_103371 = (state_103698[(17)]);
var inst_103525 = (state_103698[(29)]);
var inst_103442 = (state_103698[(18)]);
var inst_103411 = (state_103698[(53)]);
var inst_103451 = (state_103698[(19)]);
var inst_103412 = (state_103698[(54)]);
var inst_103492 = (state_103698[(23)]);
var inst_103520 = (state_103698[(55)]);
var inst_103361 = (state_103698[(56)]);
var inst_103524 = (state_103698[(37)]);
var inst_103511 = (state_103698[(57)]);
var inst_103537 = (function (){var no_filter_QMARK_ = true;
var t = inst_103506;
var max_limit_QMARK_ = inst_103500;
var next_node = inst_103523;
var fast_forward_db_QMARK_ = inst_103511;
var vec__103314 = inst_103332;
var s1 = inst_103371;
var o2 = inst_103433;
var t1 = inst_103329;
var predicate_fn = inst_103361;
var i = inst_103525;
var m1 = inst_103460;
var root_node = inst_103516;
var s2 = inst_103380;
var G__103534 = inst_103533;
var p2 = inst_103451;
var permissions = inst_103501;
var limit = inst_103499;
var map__103317 = inst_103359;
var start_flake = inst_103470;
var flake_limit = inst_103493;
var offset = inst_103524;
var acc = inst_103527;
var t2 = inst_103336;
var vec__103311 = inst_103325;
var op1 = inst_103330;
var o1 = inst_103424;
var end_flake = inst_103471;
var base_result = inst_103533;
var s = inst_103526;
var node_start = inst_103520;
var p1 = inst_103442;
var vec__103318 = inst_103411;
var subject_fn = inst_103360;
var object_fn = inst_103415;
var idx_compare = inst_103505;
var op2 = inst_103337;
var m2 = inst_103469;
var map__103324 = inst_103492;
var vec__103321 = inst_103412;
var novelty = inst_103510;
return (function (p1__103294_SHARP_){
return cljs.core._EQ_.call(null,p1__103294_SHARP_.o,start_flake.o);
});
})();
var inst_103538 = cljs.core.filter.call(null,inst_103537,inst_103533);
var state_103698__$1 = state_103698;
var statearr_103735_103925 = state_103698__$1;
(statearr_103735_103925[(2)] = inst_103538);

(statearr_103735_103925[(1)] = (87));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (39))){
var inst_103414 = (state_103698[(58)]);
var state_103698__$1 = state_103698;
var statearr_103736_103926 = state_103698__$1;
(statearr_103736_103926[(2)] = inst_103414);

(statearr_103736_103926[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (88))){
var inst_103523 = (state_103698[(35)]);
var inst_103516 = (state_103698[(42)]);
var inst_103329 = (state_103698[(8)]);
var inst_103330 = (state_103698[(9)]);
var inst_103505 = (state_103698[(43)]);
var inst_103506 = (state_103698[(44)]);
var inst_103493 = (state_103698[(24)]);
var inst_103415 = (state_103698[(45)]);
var inst_103360 = (state_103698[(46)]);
var inst_103469 = (state_103698[(10)]);
var inst_103424 = (state_103698[(11)]);
var inst_103336 = (state_103698[(12)]);
var inst_103359 = (state_103698[(47)]);
var inst_103470 = (state_103698[(20)]);
var inst_103499 = (state_103698[(26)]);
var inst_103337 = (state_103698[(13)]);
var inst_103332 = (state_103698[(48)]);
var inst_103380 = (state_103698[(14)]);
var inst_103500 = (state_103698[(49)]);
var inst_103460 = (state_103698[(15)]);
var inst_103533 = (state_103698[(38)]);
var inst_103471 = (state_103698[(21)]);
var inst_103433 = (state_103698[(16)]);
var inst_103526 = (state_103698[(28)]);
var inst_103510 = (state_103698[(50)]);
var inst_103527 = (state_103698[(36)]);
var inst_103501 = (state_103698[(51)]);
var inst_103325 = (state_103698[(52)]);
var inst_103371 = (state_103698[(17)]);
var inst_103525 = (state_103698[(29)]);
var inst_103442 = (state_103698[(18)]);
var inst_103541 = (state_103698[(59)]);
var inst_103411 = (state_103698[(53)]);
var inst_103451 = (state_103698[(19)]);
var inst_103412 = (state_103698[(54)]);
var inst_103492 = (state_103698[(23)]);
var inst_103520 = (state_103698[(55)]);
var inst_103361 = (state_103698[(56)]);
var inst_103524 = (state_103698[(37)]);
var inst_103511 = (state_103698[(57)]);
var inst_103543 = (function (){var no_filter_QMARK_ = true;
var t = inst_103506;
var max_limit_QMARK_ = inst_103500;
var next_node = inst_103523;
var fast_forward_db_QMARK_ = inst_103511;
var vec__103314 = inst_103332;
var s1 = inst_103371;
var o2 = inst_103433;
var t1 = inst_103329;
var predicate_fn = inst_103361;
var i = inst_103525;
var m1 = inst_103460;
var root_node = inst_103516;
var s2 = inst_103380;
var G__103534 = inst_103541;
var p2 = inst_103451;
var permissions = inst_103501;
var limit = inst_103499;
var map__103317 = inst_103359;
var start_flake = inst_103470;
var flake_limit = inst_103493;
var offset = inst_103524;
var acc = inst_103527;
var t2 = inst_103336;
var vec__103311 = inst_103325;
var op1 = inst_103330;
var o1 = inst_103424;
var end_flake = inst_103471;
var base_result = inst_103533;
var s = inst_103526;
var node_start = inst_103520;
var p1 = inst_103442;
var vec__103318 = inst_103411;
var subject_fn = inst_103360;
var object_fn = inst_103415;
var idx_compare = inst_103505;
var op2 = inst_103337;
var m2 = inst_103469;
var map__103324 = inst_103492;
var vec__103321 = inst_103412;
var novelty = inst_103510;
return (function (p1__103295_SHARP_){
return subject_fn.call(null,p1__103295_SHARP_.s);
});
})();
var inst_103544 = cljs.core.filter.call(null,inst_103543,inst_103541);
var state_103698__$1 = state_103698;
var statearr_103737_103927 = state_103698__$1;
(statearr_103737_103927[(2)] = inst_103544);

(statearr_103737_103927[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (46))){
var inst_103327 = (state_103698[(60)]);
var state_103698__$1 = state_103698;
var statearr_103738_103928 = state_103698__$1;
(statearr_103738_103928[(2)] = inst_103327);

(statearr_103738_103928[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (4))){
var inst_103332 = (state_103698[(48)]);
var inst_103325 = (state_103698[(52)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_103698,(3),Error,null,(2));
var inst_103325__$1 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,start_match);
var inst_103326 = cljs.core.nth.call(null,inst_103325__$1,(0),null);
var inst_103327 = cljs.core.nth.call(null,inst_103325__$1,(1),null);
var inst_103328 = cljs.core.nth.call(null,inst_103325__$1,(2),null);
var inst_103329 = cljs.core.nth.call(null,inst_103325__$1,(3),null);
var inst_103330 = cljs.core.nth.call(null,inst_103325__$1,(4),null);
var inst_103331 = cljs.core.nth.call(null,inst_103325__$1,(5),null);
var inst_103332__$1 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,end_match);
var inst_103333 = cljs.core.nth.call(null,inst_103332__$1,(0),null);
var inst_103334 = cljs.core.nth.call(null,inst_103332__$1,(1),null);
var inst_103335 = cljs.core.nth.call(null,inst_103332__$1,(2),null);
var inst_103336 = cljs.core.nth.call(null,inst_103332__$1,(3),null);
var inst_103337 = cljs.core.nth.call(null,inst_103332__$1,(4),null);
var inst_103338 = cljs.core.nth.call(null,inst_103332__$1,(5),null);
var inst_103340 = (opts == null);
var inst_103341 = cljs.core.not.call(null,inst_103340);
var state_103698__$1 = (function (){var statearr_103739 = state_103698;
(statearr_103739[(61)] = inst_103326);

(statearr_103739[(62)] = inst_103334);

(statearr_103739[(8)] = inst_103329);

(statearr_103739[(63)] = inst_103335);

(statearr_103739[(9)] = inst_103330);

(statearr_103739[(64)] = inst_103331);

(statearr_103739[(12)] = inst_103336);

(statearr_103739[(13)] = inst_103337);

(statearr_103739[(48)] = inst_103332__$1);

(statearr_103739[(60)] = inst_103327);

(statearr_103739[(65)] = inst_103333);

(statearr_103739[(52)] = inst_103325__$1);

(statearr_103739[(39)] = inst_103328);

(statearr_103739[(40)] = inst_103338);

return statearr_103739;
})();
if(inst_103341){
var statearr_103740_103929 = state_103698__$1;
(statearr_103740_103929[(1)] = (5));

} else {
var statearr_103741_103930 = state_103698__$1;
(statearr_103741_103930[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (77))){
var inst_103499 = (state_103698[(26)]);
var inst_103499__$1 = (state_103698[(2)]);
var inst_103500 = cljs.core._EQ_.call(null,inst_103499__$1,fluree.db.util.core.max_long);
var inst_103501 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_103502 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_103503 = [new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),idx,new cljs.core.Keyword(null,"comparator","comparator",2144896662)];
var inst_103504 = (new cljs.core.PersistentVector(null,3,(5),inst_103502,inst_103503,null));
var inst_103505 = cljs.core.get_in.call(null,db,inst_103504);
var inst_103506 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_103507 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_103508 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx];
var inst_103509 = (new cljs.core.PersistentVector(null,2,(5),inst_103507,inst_103508,null));
var inst_103510 = cljs.core.get_in.call(null,db,inst_103509);
var inst_103511 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db);
var inst_103512 = cljs.core.get.call(null,db,idx);
var inst_103513 = fluree.db.dbproto._resolve.call(null,inst_103512);
var state_103698__$1 = (function (){var statearr_103742 = state_103698;
(statearr_103742[(43)] = inst_103505);

(statearr_103742[(44)] = inst_103506);

(statearr_103742[(26)] = inst_103499__$1);

(statearr_103742[(49)] = inst_103500);

(statearr_103742[(50)] = inst_103510);

(statearr_103742[(51)] = inst_103501);

(statearr_103742[(57)] = inst_103511);

return statearr_103742;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_103698__$1,(78),inst_103513);
} else {
if((state_val_103699 === (106))){
var inst_103582 = (state_103698[(66)]);
var inst_103526 = (state_103698[(28)]);
var inst_103527 = (state_103698[(36)]);
var inst_103525 = (state_103698[(29)]);
var inst_103524 = (state_103698[(37)]);
var inst_103585 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_103586 = (inst_103524 - inst_103582);
var inst_103587 = [inst_103586,inst_103525,inst_103526,inst_103527];
var inst_103588 = (new cljs.core.PersistentVector(null,4,(5),inst_103585,inst_103587,null));
var state_103698__$1 = state_103698;
var statearr_103743_103931 = state_103698__$1;
(statearr_103743_103931[(2)] = inst_103588);

(statearr_103743_103931[(1)] = (108));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (119))){
var inst_103505 = (state_103698[(43)]);
var inst_103493 = (state_103698[(24)]);
var inst_103499 = (state_103698[(26)]);
var inst_103560 = (state_103698[(67)]);
var inst_103471 = (state_103698[(21)]);
var inst_103661 = (state_103698[(33)]);
var inst_103660 = (state_103698[(34)]);
var inst_103664 = inst_103505.call(null,inst_103560,inst_103471);
var inst_103665 = (inst_103664 < (0));
var inst_103666 = (inst_103660 < inst_103493);
var inst_103667 = (inst_103661 < inst_103499);
var inst_103668 = ((inst_103665) && (inst_103666) && (inst_103667));
var state_103698__$1 = state_103698;
var statearr_103744_103932 = state_103698__$1;
(statearr_103744_103932[(2)] = inst_103668);

(statearr_103744_103932[(1)] = (121));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (95))){
var inst_103553 = (state_103698[(68)]);
var state_103698__$1 = state_103698;
var statearr_103745_103933 = state_103698__$1;
(statearr_103745_103933[(2)] = inst_103553);

(statearr_103745_103933[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (54))){
var inst_103331 = (state_103698[(64)]);
var state_103698__$1 = state_103698;
var statearr_103746_103934 = state_103698__$1;
(statearr_103746_103934[(2)] = inst_103331);

(statearr_103746_103934[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (92))){
var inst_103547 = (state_103698[(69)]);
var state_103698__$1 = state_103698;
var statearr_103747_103935 = state_103698__$1;
(statearr_103747_103935[(2)] = inst_103547);

(statearr_103747_103935[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (104))){
var inst_103523 = (state_103698[(35)]);
var inst_103516 = (state_103698[(42)]);
var inst_103582 = (state_103698[(66)]);
var inst_103559 = (state_103698[(70)]);
var inst_103329 = (state_103698[(8)]);
var inst_103581 = (state_103698[(71)]);
var inst_103330 = (state_103698[(9)]);
var inst_103505 = (state_103698[(43)]);
var inst_103506 = (state_103698[(44)]);
var inst_103493 = (state_103698[(24)]);
var inst_103415 = (state_103698[(45)]);
var inst_103360 = (state_103698[(46)]);
var inst_103469 = (state_103698[(10)]);
var inst_103424 = (state_103698[(11)]);
var inst_103336 = (state_103698[(12)]);
var inst_103359 = (state_103698[(47)]);
var inst_103470 = (state_103698[(20)]);
var inst_103499 = (state_103698[(26)]);
var inst_103560 = (state_103698[(67)]);
var inst_103337 = (state_103698[(13)]);
var inst_103332 = (state_103698[(48)]);
var inst_103380 = (state_103698[(14)]);
var inst_103500 = (state_103698[(49)]);
var inst_103460 = (state_103698[(15)]);
var inst_103533 = (state_103698[(38)]);
var inst_103471 = (state_103698[(21)]);
var inst_103433 = (state_103698[(16)]);
var inst_103526 = (state_103698[(28)]);
var inst_103510 = (state_103698[(50)]);
var inst_103527 = (state_103698[(36)]);
var inst_103501 = (state_103698[(51)]);
var inst_103325 = (state_103698[(52)]);
var inst_103371 = (state_103698[(17)]);
var inst_103525 = (state_103698[(29)]);
var inst_103442 = (state_103698[(18)]);
var inst_103411 = (state_103698[(53)]);
var inst_103451 = (state_103698[(19)]);
var inst_103412 = (state_103698[(54)]);
var inst_103492 = (state_103698[(23)]);
var inst_103520 = (state_103698[(55)]);
var inst_103361 = (state_103698[(56)]);
var inst_103524 = (state_103698[(37)]);
var inst_103511 = (state_103698[(57)]);
var inst_103580 = (function (){var no_filter_QMARK_ = true;
var base_result_SINGLEQUOTE_ = inst_103559;
var t = inst_103506;
var max_limit_QMARK_ = inst_103500;
var next_node = inst_103523;
var fast_forward_db_QMARK_ = inst_103511;
var vec__103314 = inst_103332;
var s1 = inst_103371;
var o2 = inst_103433;
var t1 = inst_103329;
var predicate_fn = inst_103361;
var i = inst_103525;
var rhs = inst_103560;
var m1 = inst_103460;
var root_node = inst_103516;
var s2 = inst_103380;
var p2 = inst_103451;
var permissions = inst_103501;
var limit = inst_103499;
var map__103317 = inst_103359;
var start_flake = inst_103470;
var flake_limit = inst_103493;
var offset = inst_103524;
var acc = inst_103527;
var t2 = inst_103336;
var vec__103311 = inst_103325;
var op1 = inst_103330;
var o1 = inst_103424;
var end_flake = inst_103471;
var base_result = inst_103533;
var s = inst_103526;
var node_start = inst_103520;
var p1 = inst_103442;
var vec__103318 = inst_103411;
var subject_fn = inst_103360;
var object_fn = inst_103415;
var idx_compare = inst_103505;
var op2 = inst_103337;
var m2 = inst_103469;
var map__103324 = inst_103492;
var vec__103321 = inst_103412;
var novelty = inst_103510;
return (function (p1__103298_SHARP_){
return p1__103298_SHARP_.s;
});
})();
var inst_103581__$1 = cljs.core.partition_by.call(null,inst_103580,inst_103559);
var inst_103582__$1 = cljs.core.count.call(null,inst_103581__$1);
var inst_103583 = (inst_103524 > inst_103582__$1);
var state_103698__$1 = (function (){var statearr_103748 = state_103698;
(statearr_103748[(66)] = inst_103582__$1);

(statearr_103748[(71)] = inst_103581__$1);

return statearr_103748;
})();
if(cljs.core.truth_(inst_103583)){
var statearr_103749_103936 = state_103698__$1;
(statearr_103749_103936[(1)] = (106));

} else {
var statearr_103750_103937 = state_103698__$1;
(statearr_103750_103937[(1)] = (107));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (15))){
var inst_103326 = (state_103698[(61)]);
var state_103698__$1 = state_103698;
var statearr_103751_103938 = state_103698__$1;
(statearr_103751_103938[(2)] = inst_103326);

(statearr_103751_103938[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (48))){
var inst_103433 = (state_103698[(16)]);
var state_103698__$1 = state_103698;
var statearr_103752_103939 = state_103698__$1;
(statearr_103752_103939[(2)] = inst_103433);

(statearr_103752_103939[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (50))){
var inst_103447 = (state_103698[(2)]);
var state_103698__$1 = state_103698;
if(cljs.core.truth_(inst_103447)){
var statearr_103753_103940 = state_103698__$1;
(statearr_103753_103940[(1)] = (51));

} else {
var statearr_103754_103941 = state_103698__$1;
(statearr_103754_103941[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (116))){
var inst_103621 = (state_103698[(72)]);
var inst_103619 = (state_103698[(73)]);
var inst_103631 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_103632 = [inst_103621,inst_103619];
var inst_103633 = (new cljs.core.PersistentVector(null,2,(5),inst_103631,inst_103632,null));
var state_103698__$1 = state_103698;
var statearr_103755_103942 = state_103698__$1;
(statearr_103755_103942[(2)] = inst_103633);

(statearr_103755_103942[(1)] = (117));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (75))){
var inst_103494 = (state_103698[(22)]);
var state_103698__$1 = state_103698;
var statearr_103756_103943 = state_103698__$1;
(statearr_103756_103943[(2)] = inst_103494);

(statearr_103756_103943[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (99))){
var inst_103569 = (state_103698[(2)]);
var state_103698__$1 = state_103698;
if(cljs.core.truth_(inst_103569)){
var statearr_103757_103944 = state_103698__$1;
(statearr_103757_103944[(1)] = (103));

} else {
var statearr_103758_103945 = state_103698__$1;
(statearr_103758_103945[(1)] = (104));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (21))){
var inst_103376 = (state_103698[(2)]);
var inst_103377 = fluree.db.util.async.throw_err.call(null,inst_103376);
var state_103698__$1 = state_103698;
var statearr_103759_103946 = state_103698__$1;
(statearr_103759_103946[(2)] = inst_103377);

(statearr_103759_103946[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (31))){
var inst_103334 = (state_103698[(62)]);
var inst_103329 = (state_103698[(8)]);
var inst_103335 = (state_103698[(63)]);
var inst_103330 = (state_103698[(9)]);
var inst_103360 = (state_103698[(46)]);
var inst_103331 = (state_103698[(64)]);
var inst_103394 = (state_103698[(41)]);
var inst_103336 = (state_103698[(12)]);
var inst_103359 = (state_103698[(47)]);
var inst_103337 = (state_103698[(13)]);
var inst_103332 = (state_103698[(48)]);
var inst_103380 = (state_103698[(14)]);
var inst_103327 = (state_103698[(60)]);
var inst_103325 = (state_103698[(52)]);
var inst_103371 = (state_103698[(17)]);
var inst_103362 = (state_103698[(74)]);
var inst_103361 = (state_103698[(56)]);
var inst_103328 = (state_103698[(39)]);
var inst_103338 = (state_103698[(40)]);
var inst_103396 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_103397 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_103398 = [null,null];
var inst_103399 = (new cljs.core.PersistentVector(null,2,(5),inst_103397,inst_103398,null));
var inst_103400 = (function (){var bool = inst_103394;
var temp__5733__auto__ = inst_103394;
var vec__103314 = inst_103332;
var s1 = inst_103371;
var o2 = inst_103335;
var t1 = inst_103329;
var predicate_fn = inst_103361;
var m1 = inst_103331;
var s2 = inst_103380;
var p2 = inst_103334;
var map__103317 = inst_103359;
var t2 = inst_103336;
var vec__103311 = inst_103325;
var op1 = inst_103330;
var o1 = inst_103328;
var p1 = inst_103327;
var subject_fn = inst_103360;
var object_fn = inst_103362;
var op2 = inst_103337;
var m2 = inst_103338;
return (function (o){
return cljs.core._EQ_.call(null,o,bool);
});
})();
var inst_103401 = [inst_103399,inst_103400];
var inst_103402 = (new cljs.core.PersistentVector(null,2,(5),inst_103396,inst_103401,null));
var state_103698__$1 = state_103698;
var statearr_103760_103947 = state_103698__$1;
(statearr_103760_103947[(2)] = inst_103402);

(statearr_103760_103947[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (113))){
var inst_103602 = (state_103698[(75)]);
var inst_103611 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_103612 = [inst_103602,inst_103602];
var inst_103613 = (new cljs.core.PersistentVector(null,2,(5),inst_103611,inst_103612,null));
var state_103698__$1 = state_103698;
var statearr_103761_103948 = state_103698__$1;
(statearr_103761_103948[(2)] = inst_103613);

(statearr_103761_103948[(1)] = (114));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (32))){
var inst_103335 = (state_103698[(63)]);
var inst_103362 = (state_103698[(74)]);
var inst_103328 = (state_103698[(39)]);
var inst_103404 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_103405 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_103406 = [inst_103328,inst_103335];
var inst_103407 = (new cljs.core.PersistentVector(null,2,(5),inst_103405,inst_103406,null));
var inst_103408 = [inst_103407,inst_103362];
var inst_103409 = (new cljs.core.PersistentVector(null,2,(5),inst_103404,inst_103408,null));
var state_103698__$1 = state_103698;
var statearr_103762_103949 = state_103698__$1;
(statearr_103762_103949[(2)] = inst_103409);

(statearr_103762_103949[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (40))){
var inst_103327 = (state_103698[(60)]);
var inst_103433 = (state_103698[(2)]);
var inst_103434 = (inst_103327 == null);
var state_103698__$1 = (function (){var statearr_103763 = state_103698;
(statearr_103763[(16)] = inst_103433);

return statearr_103763;
})();
if(cljs.core.truth_(inst_103434)){
var statearr_103764_103950 = state_103698__$1;
(statearr_103764_103950[(1)] = (42));

} else {
var statearr_103765_103951 = state_103698__$1;
(statearr_103765_103951[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (129))){
var inst_103662 = (state_103698[(31)]);
var state_103698__$1 = state_103698;
var statearr_103766_103952 = state_103698__$1;
(statearr_103766_103952[(2)] = inst_103662);

(statearr_103766_103952[(1)] = (131));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (91))){
var inst_103523 = (state_103698[(35)]);
var inst_103516 = (state_103698[(42)]);
var inst_103329 = (state_103698[(8)]);
var inst_103330 = (state_103698[(9)]);
var inst_103505 = (state_103698[(43)]);
var inst_103506 = (state_103698[(44)]);
var inst_103493 = (state_103698[(24)]);
var inst_103415 = (state_103698[(45)]);
var inst_103360 = (state_103698[(46)]);
var inst_103469 = (state_103698[(10)]);
var inst_103547 = (state_103698[(69)]);
var inst_103424 = (state_103698[(11)]);
var inst_103336 = (state_103698[(12)]);
var inst_103359 = (state_103698[(47)]);
var inst_103470 = (state_103698[(20)]);
var inst_103499 = (state_103698[(26)]);
var inst_103337 = (state_103698[(13)]);
var inst_103332 = (state_103698[(48)]);
var inst_103380 = (state_103698[(14)]);
var inst_103500 = (state_103698[(49)]);
var inst_103460 = (state_103698[(15)]);
var inst_103533 = (state_103698[(38)]);
var inst_103471 = (state_103698[(21)]);
var inst_103433 = (state_103698[(16)]);
var inst_103526 = (state_103698[(28)]);
var inst_103510 = (state_103698[(50)]);
var inst_103527 = (state_103698[(36)]);
var inst_103501 = (state_103698[(51)]);
var inst_103325 = (state_103698[(52)]);
var inst_103371 = (state_103698[(17)]);
var inst_103525 = (state_103698[(29)]);
var inst_103442 = (state_103698[(18)]);
var inst_103411 = (state_103698[(53)]);
var inst_103451 = (state_103698[(19)]);
var inst_103412 = (state_103698[(54)]);
var inst_103492 = (state_103698[(23)]);
var inst_103520 = (state_103698[(55)]);
var inst_103361 = (state_103698[(56)]);
var inst_103524 = (state_103698[(37)]);
var inst_103511 = (state_103698[(57)]);
var inst_103549 = (function (){var no_filter_QMARK_ = true;
var t = inst_103506;
var max_limit_QMARK_ = inst_103500;
var next_node = inst_103523;
var fast_forward_db_QMARK_ = inst_103511;
var vec__103314 = inst_103332;
var s1 = inst_103371;
var o2 = inst_103433;
var t1 = inst_103329;
var predicate_fn = inst_103361;
var i = inst_103525;
var m1 = inst_103460;
var root_node = inst_103516;
var s2 = inst_103380;
var G__103534 = inst_103547;
var p2 = inst_103451;
var permissions = inst_103501;
var limit = inst_103499;
var map__103317 = inst_103359;
var start_flake = inst_103470;
var flake_limit = inst_103493;
var offset = inst_103524;
var acc = inst_103527;
var t2 = inst_103336;
var vec__103311 = inst_103325;
var op1 = inst_103330;
var o1 = inst_103424;
var end_flake = inst_103471;
var base_result = inst_103533;
var s = inst_103526;
var node_start = inst_103520;
var p1 = inst_103442;
var vec__103318 = inst_103411;
var subject_fn = inst_103360;
var object_fn = inst_103415;
var idx_compare = inst_103505;
var op2 = inst_103337;
var m2 = inst_103469;
var map__103324 = inst_103492;
var vec__103321 = inst_103412;
var novelty = inst_103510;
return (function (p1__103296_SHARP_){
return predicate_fn.call(null,p1__103296_SHARP_.p);
});
})();
var inst_103550 = cljs.core.filter.call(null,inst_103549,inst_103547);
var state_103698__$1 = state_103698;
var statearr_103767_103953 = state_103698__$1;
(statearr_103767_103953[(2)] = inst_103550);

(statearr_103767_103953[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (117))){
var inst_103616 = (state_103698[(76)]);
var inst_103635 = (state_103698[(2)]);
var inst_103636 = cljs.core.nth.call(null,inst_103635,(0),null);
var inst_103637 = cljs.core.nth.call(null,inst_103635,(1),null);
var inst_103638 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_103639 = [inst_103636,inst_103616,inst_103637];
var inst_103640 = (new cljs.core.PersistentVector(null,3,(5),inst_103638,inst_103639,null));
var state_103698__$1 = state_103698;
var statearr_103768_103954 = state_103698__$1;
(statearr_103768_103954[(2)] = inst_103640);

(statearr_103768_103954[(1)] = (111));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (108))){
var inst_103656 = (state_103698[(2)]);
var state_103698__$1 = state_103698;
var statearr_103769_103955 = state_103698__$1;
(statearr_103769_103955[(2)] = inst_103656);

(statearr_103769_103955[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (56))){
var inst_103338 = (state_103698[(40)]);
var inst_103460 = (state_103698[(2)]);
var state_103698__$1 = (function (){var statearr_103770 = state_103698;
(statearr_103770[(15)] = inst_103460);

return statearr_103770;
})();
if(cljs.core.truth_(inst_103338)){
var statearr_103771_103956 = state_103698__$1;
(statearr_103771_103956[(1)] = (60));

} else {
var statearr_103772_103957 = state_103698__$1;
(statearr_103772_103957[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (33))){
var inst_103413 = (state_103698[(77)]);
var inst_103411 = (state_103698[(53)]);
var inst_103412 = (state_103698[(54)]);
var inst_103411__$1 = (state_103698[(2)]);
var inst_103412__$1 = cljs.core.nth.call(null,inst_103411__$1,(0),null);
var inst_103413__$1 = cljs.core.nth.call(null,inst_103412__$1,(0),null);
var inst_103414 = cljs.core.nth.call(null,inst_103412__$1,(1),null);
var inst_103415 = cljs.core.nth.call(null,inst_103411__$1,(1),null);
var inst_103416 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_103413__$1);
var state_103698__$1 = (function (){var statearr_103773 = state_103698;
(statearr_103773[(77)] = inst_103413__$1);

(statearr_103773[(45)] = inst_103415);

(statearr_103773[(58)] = inst_103414);

(statearr_103773[(53)] = inst_103411__$1);

(statearr_103773[(54)] = inst_103412__$1);

return statearr_103773;
})();
if(inst_103416){
var statearr_103774_103958 = state_103698__$1;
(statearr_103774_103958[(1)] = (34));

} else {
var statearr_103775_103959 = state_103698__$1;
(statearr_103775_103959[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (13))){
var inst_103326 = (state_103698[(61)]);
var inst_103359 = (state_103698[(47)]);
var inst_103359__$1 = (state_103698[(2)]);
var inst_103360 = cljs.core.get.call(null,inst_103359__$1,new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441));
var inst_103361 = cljs.core.get.call(null,inst_103359__$1,new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845));
var inst_103362 = cljs.core.get.call(null,inst_103359__$1,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481));
var inst_103363 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_103326);
var state_103698__$1 = (function (){var statearr_103776 = state_103698;
(statearr_103776[(46)] = inst_103360);

(statearr_103776[(47)] = inst_103359__$1);

(statearr_103776[(74)] = inst_103362);

(statearr_103776[(56)] = inst_103361);

return statearr_103776;
})();
if(inst_103363){
var statearr_103777_103960 = state_103698__$1;
(statearr_103777_103960[(1)] = (14));

} else {
var statearr_103778_103961 = state_103698__$1;
(statearr_103778_103961[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (22))){
var inst_103328 = (state_103698[(39)]);
var state_103698__$1 = state_103698;
var statearr_103779_103962 = state_103698__$1;
(statearr_103779_103962[(2)] = inst_103328);

(statearr_103779_103962[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (90))){
var inst_103361 = (state_103698[(56)]);
var inst_103547 = (state_103698[(2)]);
var state_103698__$1 = (function (){var statearr_103780 = state_103698;
(statearr_103780[(69)] = inst_103547);

return statearr_103780;
})();
if(cljs.core.truth_(inst_103361)){
var statearr_103781_103963 = state_103698__$1;
(statearr_103781_103963[(1)] = (91));

} else {
var statearr_103782_103964 = state_103698__$1;
(statearr_103782_103964[(1)] = (92));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (109))){
var inst_103602 = (state_103698[(75)]);
var inst_103499 = (state_103698[(26)]);
var inst_103593 = (state_103698[(27)]);
var inst_103603 = (state_103698[(78)]);
var inst_103601 = (state_103698[(79)]);
var inst_103526 = (state_103698[(28)]);
var inst_103601__$1 = cljs.core.count.call(null,inst_103593);
var inst_103602__$1 = (inst_103526 + inst_103601__$1);
var inst_103603__$1 = (inst_103602__$1 - inst_103499);
var inst_103604 = cljs.core.pos_int_QMARK_.call(null,inst_103603__$1);
var state_103698__$1 = (function (){var statearr_103783 = state_103698;
(statearr_103783[(75)] = inst_103602__$1);

(statearr_103783[(78)] = inst_103603__$1);

(statearr_103783[(79)] = inst_103601__$1);

return statearr_103783;
})();
if(inst_103604){
var statearr_103784_103965 = state_103698__$1;
(statearr_103784_103965[(1)] = (112));

} else {
var statearr_103785_103966 = state_103698__$1;
(statearr_103785_103966[(1)] = (113));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (36))){
var inst_103414 = (state_103698[(58)]);
var inst_103424 = (state_103698[(2)]);
var inst_103425 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_103414);
var state_103698__$1 = (function (){var statearr_103786 = state_103698;
(statearr_103786[(11)] = inst_103424);

return statearr_103786;
})();
if(inst_103425){
var statearr_103787_103967 = state_103698__$1;
(statearr_103787_103967[(1)] = (38));

} else {
var statearr_103788_103968 = state_103698__$1;
(statearr_103788_103968[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (41))){
var inst_103429 = (state_103698[(2)]);
var inst_103430 = fluree.db.util.async.throw_err.call(null,inst_103429);
var state_103698__$1 = state_103698;
var statearr_103789_103969 = state_103698__$1;
(statearr_103789_103969[(2)] = inst_103430);

(statearr_103789_103969[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (118))){
var inst_103644 = (state_103698[(2)]);
var inst_103645 = fluree.db.util.async.throw_err.call(null,inst_103644);
var state_103698__$1 = state_103698;
var statearr_103790_103970 = state_103698__$1;
(statearr_103790_103970[(2)] = inst_103645);

(statearr_103790_103970[(1)] = (111));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (89))){
var inst_103541 = (state_103698[(59)]);
var state_103698__$1 = state_103698;
var statearr_103791_103971 = state_103698__$1;
(statearr_103791_103971[(2)] = inst_103541);

(statearr_103791_103971[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (100))){
var state_103698__$1 = state_103698;
var statearr_103792_103972 = state_103698__$1;
(statearr_103792_103972[(2)] = true);

(statearr_103792_103972[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (131))){
var inst_103689 = (state_103698[(2)]);
var state_103698__$1 = state_103698;
var statearr_103793_103973 = state_103698__$1;
(statearr_103793_103973[(2)] = inst_103689);

(statearr_103793_103973[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (122))){
var inst_103516 = (state_103698[(42)]);
var inst_103506 = (state_103698[(44)]);
var inst_103560 = (state_103698[(67)]);
var inst_103510 = (state_103698[(50)]);
var inst_103511 = (state_103698[(57)]);
var inst_103673 = fluree.db.query.range.find_next_valid_node.call(null,inst_103516,inst_103560,inst_103506,inst_103510,inst_103511);
var state_103698__$1 = state_103698;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_103698__$1,(125),inst_103673);
} else {
if((state_val_103699 === (43))){
var state_103698__$1 = state_103698;
var statearr_103794_103974 = state_103698__$1;
(statearr_103794_103974[(2)] = false);

(statearr_103794_103974[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (61))){
var inst_103463 = (cljs.core._LT__EQ_ === end_test);
var state_103698__$1 = state_103698;
if(cljs.core.truth_(inst_103463)){
var statearr_103795_103975 = state_103698__$1;
(statearr_103795_103975[(1)] = (63));

} else {
var statearr_103796_103976 = state_103698__$1;
(statearr_103796_103976[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (29))){
var state_103698__$1 = state_103698;
var statearr_103797_103977 = state_103698__$1;
(statearr_103797_103977[(2)] = null);

(statearr_103797_103977[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (44))){
var inst_103438 = (state_103698[(2)]);
var state_103698__$1 = state_103698;
if(cljs.core.truth_(inst_103438)){
var statearr_103798_103978 = state_103698__$1;
(statearr_103798_103978[(1)] = (45));

} else {
var statearr_103799_103979 = state_103698__$1;
(statearr_103799_103979[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (93))){
var inst_103415 = (state_103698[(45)]);
var inst_103553 = (state_103698[(2)]);
var state_103698__$1 = (function (){var statearr_103800 = state_103698;
(statearr_103800[(68)] = inst_103553);

return statearr_103800;
})();
if(cljs.core.truth_(inst_103415)){
var statearr_103801_103980 = state_103698__$1;
(statearr_103801_103980[(1)] = (94));

} else {
var statearr_103802_103981 = state_103698__$1;
(statearr_103802_103981[(1)] = (95));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (6))){
var state_103698__$1 = state_103698;
var statearr_103803_103982 = state_103698__$1;
(statearr_103803_103982[(2)] = false);

(statearr_103803_103982[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (111))){
var inst_103527 = (state_103698[(36)]);
var inst_103647 = (state_103698[(2)]);
var inst_103648 = cljs.core.nth.call(null,inst_103647,(0),null);
var inst_103649 = cljs.core.nth.call(null,inst_103647,(1),null);
var inst_103650 = cljs.core.nth.call(null,inst_103647,(2),null);
var inst_103651 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_103652 = cljs.core.into.call(null,inst_103527,inst_103650);
var inst_103653 = [(0),inst_103648,inst_103649,inst_103652];
var inst_103654 = (new cljs.core.PersistentVector(null,4,(5),inst_103651,inst_103653,null));
var state_103698__$1 = state_103698;
var statearr_103804_103983 = state_103698__$1;
(statearr_103804_103983[(2)] = inst_103654);

(statearr_103804_103983[(1)] = (108));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (28))){
var state_103698__$1 = state_103698;
var statearr_103805_103984 = state_103698__$1;
(statearr_103805_103984[(2)] = null);

(statearr_103805_103984[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (64))){
var state_103698__$1 = state_103698;
var statearr_103806_103985 = state_103698__$1;
(statearr_103806_103985[(2)] = fluree.db.util.core.min_integer);

(statearr_103806_103985[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (103))){
var inst_103559 = (state_103698[(70)]);
var inst_103493 = (state_103698[(24)]);
var inst_103526 = (state_103698[(28)]);
var inst_103527 = (state_103698[(36)]);
var inst_103525 = (state_103698[(29)]);
var inst_103571 = cljs.core.count.call(null,inst_103559);
var inst_103572 = (inst_103493 - inst_103525);
var inst_103573 = cljs.core.take.call(null,inst_103572,inst_103559);
var inst_103574 = cljs.core.into.call(null,inst_103527,inst_103573);
var inst_103575 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_103576 = (inst_103525 + inst_103571);
var inst_103577 = [(0),inst_103576,inst_103526,inst_103574];
var inst_103578 = (new cljs.core.PersistentVector(null,4,(5),inst_103575,inst_103577,null));
var state_103698__$1 = state_103698;
var statearr_103807_103986 = state_103698__$1;
(statearr_103807_103986[(2)] = inst_103578);

(statearr_103807_103986[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (51))){
var state_103698__$1 = state_103698;
var statearr_103808_103987 = state_103698__$1;
(statearr_103808_103987[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_103808_103987[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (25))){
var inst_103335 = (state_103698[(63)]);
var state_103698__$1 = state_103698;
var statearr_103809_103988 = state_103698__$1;
(statearr_103809_103988[(2)] = inst_103335);

(statearr_103809_103988[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (34))){
var inst_103413 = (state_103698[(77)]);
var inst_103418 = fluree.db.dbproto._subid.call(null,db,inst_103413);
var state_103698__$1 = state_103698;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_103698__$1,(37),inst_103418);
} else {
if((state_val_103699 === (125))){
var inst_103675 = (state_103698[(2)]);
var inst_103676 = fluree.db.util.async.throw_err.call(null,inst_103675);
var state_103698__$1 = state_103698;
var statearr_103810_103989 = state_103698__$1;
(statearr_103810_103989[(2)] = inst_103676);

(statearr_103810_103989[(1)] = (124));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (17))){
var inst_103367 = (state_103698[(2)]);
var inst_103368 = fluree.db.util.async.throw_err.call(null,inst_103367);
var state_103698__$1 = state_103698;
var statearr_103811_103990 = state_103698__$1;
(statearr_103811_103990[(2)] = inst_103368);

(statearr_103811_103990[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (3))){
var inst_103307 = (state_103698[(2)]);
var state_103698__$1 = state_103698;
var statearr_103812_103991 = state_103698__$1;
(statearr_103812_103991[(2)] = inst_103307);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_103698__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (12))){
var state_103698__$1 = state_103698;
var statearr_103813_103992 = state_103698__$1;
(statearr_103813_103992[(2)] = opts);

(statearr_103813_103992[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (2))){
var inst_103696 = (state_103698[(2)]);
var state_103698__$1 = state_103698;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_103698__$1,inst_103696);
} else {
if((state_val_103699 === (66))){
var inst_103476 = opts.cljs$lang$protocol_mask$partition0$;
var inst_103477 = (inst_103476 & (64));
var inst_103478 = opts.cljs$core$ISeq$;
var inst_103479 = (cljs.core.PROTOCOL_SENTINEL === inst_103478);
var inst_103480 = ((inst_103477) || (inst_103479));
var state_103698__$1 = state_103698;
if(cljs.core.truth_(inst_103480)){
var statearr_103814_103993 = state_103698__$1;
(statearr_103814_103993[(1)] = (69));

} else {
var statearr_103815_103994 = state_103698__$1;
(statearr_103815_103994[(1)] = (70));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (107))){
var inst_103581 = (state_103698[(71)]);
var inst_103524 = (state_103698[(37)]);
var inst_103593 = cljs.core.drop.call(null,inst_103524,inst_103581);
var state_103698__$1 = (function (){var statearr_103816 = state_103698;
(statearr_103816[(27)] = inst_103593);

return statearr_103816;
})();
var statearr_103817_103995 = state_103698__$1;
(statearr_103817_103995[(1)] = (109));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (23))){
var inst_103335 = (state_103698[(63)]);
var inst_103384 = cljs.core.boolean_QMARK_.call(null,inst_103335);
var state_103698__$1 = state_103698;
if(inst_103384){
var statearr_103819_103996 = state_103698__$1;
(statearr_103819_103996[(1)] = (25));

} else {
var statearr_103820_103997 = state_103698__$1;
(statearr_103820_103997[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (47))){
var inst_103334 = (state_103698[(62)]);
var inst_103442 = (state_103698[(2)]);
var inst_103443 = (inst_103334 == null);
var state_103698__$1 = (function (){var statearr_103821 = state_103698;
(statearr_103821[(18)] = inst_103442);

return statearr_103821;
})();
if(cljs.core.truth_(inst_103443)){
var statearr_103822_103998 = state_103698__$1;
(statearr_103822_103998[(1)] = (48));

} else {
var statearr_103823_103999 = state_103698__$1;
(statearr_103823_103999[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (35))){
var inst_103413 = (state_103698[(77)]);
var state_103698__$1 = state_103698;
var statearr_103824_104000 = state_103698__$1;
(statearr_103824_104000[(2)] = inst_103413);

(statearr_103824_104000[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (127))){
var inst_103671 = (state_103698[(7)]);
var state_103698__$1 = state_103698;
var statearr_103825_104001 = state_103698__$1;
(statearr_103825_104001[(2)] = inst_103671);

(statearr_103825_104001[(1)] = (128));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (82))){
var inst_103694 = (state_103698[(2)]);
var state_103698__$1 = state_103698;
var statearr_103826_104002 = state_103698__$1;
(statearr_103826_104002[(2)] = inst_103694);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_103698__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (76))){
var state_103698__$1 = state_103698;
var statearr_103827_104003 = state_103698__$1;
(statearr_103827_104003[(2)] = fluree.db.util.core.max_long);

(statearr_103827_104003[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (97))){
var inst_103524 = (state_103698[(37)]);
var inst_103562 = cljs.core._EQ_.call(null,(0),inst_103524);
var state_103698__$1 = state_103698;
if(inst_103562){
var statearr_103828_104004 = state_103698__$1;
(statearr_103828_104004[(1)] = (100));

} else {
var statearr_103829_104005 = state_103698__$1;
(statearr_103829_104005[(1)] = (101));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (19))){
var inst_103333 = (state_103698[(65)]);
var state_103698__$1 = state_103698;
var statearr_103830_104006 = state_103698__$1;
(statearr_103830_104006[(2)] = inst_103333);

(statearr_103830_104006[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (57))){
var state_103698__$1 = state_103698;
var statearr_103831_104007 = state_103698__$1;
(statearr_103831_104007[(2)] = fluree.db.util.core.min_integer);

(statearr_103831_104007[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (68))){
var inst_103487 = (state_103698[(2)]);
var state_103698__$1 = state_103698;
if(cljs.core.truth_(inst_103487)){
var statearr_103832_104008 = state_103698__$1;
(statearr_103832_104008[(1)] = (72));

} else {
var statearr_103833_104009 = state_103698__$1;
(statearr_103833_104009[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (11))){
var inst_103356 = cljs.core.apply.call(null,cljs.core.hash_map,opts);
var state_103698__$1 = state_103698;
var statearr_103834_104010 = state_103698__$1;
(statearr_103834_104010[(2)] = inst_103356);

(statearr_103834_104010[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (115))){
var inst_103493 = (state_103698[(24)]);
var inst_103620 = (state_103698[(80)]);
var inst_103621 = (state_103698[(72)]);
var inst_103619 = (state_103698[(73)]);
var inst_103624 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_103625 = (inst_103621 - inst_103493);
var inst_103626 = (inst_103620 - inst_103625);
var inst_103627 = cljs.core.take.call(null,inst_103626,inst_103619);
var inst_103628 = [inst_103493,inst_103627];
var inst_103629 = (new cljs.core.PersistentVector(null,2,(5),inst_103624,inst_103628,null));
var state_103698__$1 = state_103698;
var statearr_103835_104011 = state_103698__$1;
(statearr_103835_104011[(2)] = inst_103629);

(statearr_103835_104011[(1)] = (117));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (9))){
var state_103698__$1 = state_103698;
var statearr_103836_104012 = state_103698__$1;
(statearr_103836_104012[(2)] = false);

(statearr_103836_104012[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (5))){
var inst_103343 = opts.cljs$lang$protocol_mask$partition0$;
var inst_103344 = (inst_103343 & (64));
var inst_103345 = opts.cljs$core$ISeq$;
var inst_103346 = (cljs.core.PROTOCOL_SENTINEL === inst_103345);
var inst_103347 = ((inst_103344) || (inst_103346));
var state_103698__$1 = state_103698;
if(cljs.core.truth_(inst_103347)){
var statearr_103837_104013 = state_103698__$1;
(statearr_103837_104013[(1)] = (8));

} else {
var statearr_103838_104014 = state_103698__$1;
(statearr_103838_104014[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (112))){
var inst_103499 = (state_103698[(26)]);
var inst_103603 = (state_103698[(78)]);
var inst_103601 = (state_103698[(79)]);
var inst_103606 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_103607 = (inst_103601 - inst_103603);
var inst_103608 = [inst_103499,inst_103607];
var inst_103609 = (new cljs.core.PersistentVector(null,2,(5),inst_103606,inst_103608,null));
var state_103698__$1 = state_103698;
var statearr_103839_104015 = state_103698__$1;
(statearr_103839_104015[(2)] = inst_103609);

(statearr_103839_104015[(1)] = (114));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (83))){
var inst_103523 = (state_103698[(35)]);
var inst_103470 = (state_103698[(20)]);
var inst_103471 = (state_103698[(21)]);
var inst_103532 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_103523);
var inst_103533 = fluree.db.flake.subrange.call(null,inst_103532,start_test,inst_103470,end_test,inst_103471);
var inst_103535 = fluree.db.query.range.value_with_nil_pred.call(null,idx,inst_103470,inst_103471);
var state_103698__$1 = (function (){var statearr_103840 = state_103698;
(statearr_103840[(38)] = inst_103533);

return statearr_103840;
})();
if(inst_103535){
var statearr_103841_104016 = state_103698__$1;
(statearr_103841_104016[(1)] = (85));

} else {
var statearr_103842_104017 = state_103698__$1;
(statearr_103842_104017[(1)] = (86));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (14))){
var inst_103326 = (state_103698[(61)]);
var inst_103365 = fluree.db.dbproto._subid.call(null,db,inst_103326);
var state_103698__$1 = state_103698;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_103698__$1,(17),inst_103365);
} else {
if((state_val_103699 === (45))){
var state_103698__$1 = state_103698;
var statearr_103843_104018 = state_103698__$1;
(statearr_103843_104018[(2)] = (-1));

(statearr_103843_104018[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (53))){
var inst_103331 = (state_103698[(64)]);
var inst_103451 = (state_103698[(2)]);
var state_103698__$1 = (function (){var statearr_103844 = state_103698;
(statearr_103844[(19)] = inst_103451);

return statearr_103844;
})();
if(cljs.core.truth_(inst_103331)){
var statearr_103845_104019 = state_103698__$1;
(statearr_103845_104019[(1)] = (54));

} else {
var statearr_103846_104020 = state_103698__$1;
(statearr_103846_104020[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (78))){
var inst_103516 = (state_103698[(42)]);
var inst_103506 = (state_103698[(44)]);
var inst_103470 = (state_103698[(20)]);
var inst_103510 = (state_103698[(50)]);
var inst_103511 = (state_103698[(57)]);
var inst_103515 = (state_103698[(2)]);
var inst_103516__$1 = fluree.db.util.async.throw_err.call(null,inst_103515);
var inst_103517 = fluree.db.query.range.find_next_valid_node.call(null,inst_103516__$1,inst_103470,inst_103506,inst_103510,inst_103511);
var state_103698__$1 = (function (){var statearr_103847 = state_103698;
(statearr_103847[(42)] = inst_103516__$1);

return statearr_103847;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_103698__$1,(79),inst_103517);
} else {
if((state_val_103699 === (26))){
var state_103698__$1 = state_103698;
var statearr_103848_104021 = state_103698__$1;
(statearr_103848_104021[(1)] = (28));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (123))){
var state_103698__$1 = state_103698;
var statearr_103850_104022 = state_103698__$1;
(statearr_103850_104022[(2)] = null);

(statearr_103850_104022[(1)] = (124));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (16))){
var inst_103333 = (state_103698[(65)]);
var inst_103371 = (state_103698[(2)]);
var inst_103372 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_103333);
var state_103698__$1 = (function (){var statearr_103851 = state_103698;
(statearr_103851[(17)] = inst_103371);

return statearr_103851;
})();
if(inst_103372){
var statearr_103852_104023 = state_103698__$1;
(statearr_103852_104023[(1)] = (18));

} else {
var statearr_103853_104024 = state_103698__$1;
(statearr_103853_104024[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (81))){
var state_103698__$1 = state_103698;
var statearr_103854_104025 = state_103698__$1;
(statearr_103854_104025[(2)] = null);

(statearr_103854_104025[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (120))){
var inst_103560 = (state_103698[(67)]);
var state_103698__$1 = state_103698;
var statearr_103855_104026 = state_103698__$1;
(statearr_103855_104026[(2)] = inst_103560);

(statearr_103855_104026[(1)] = (121));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (79))){
var inst_103520 = (state_103698[(55)]);
var inst_103519 = (state_103698[(2)]);
var inst_103520__$1 = fluree.db.util.async.throw_err.call(null,inst_103519);
var state_103698__$1 = (function (){var statearr_103856 = state_103698;
(statearr_103856[(55)] = inst_103520__$1);

return statearr_103856;
})();
if(cljs.core.truth_(inst_103520__$1)){
var statearr_103857_104027 = state_103698__$1;
(statearr_103857_104027[(1)] = (80));

} else {
var statearr_103858_104028 = state_103698__$1;
(statearr_103858_104028[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (38))){
var inst_103414 = (state_103698[(58)]);
var inst_103427 = fluree.db.dbproto._subid.call(null,db,inst_103414);
var state_103698__$1 = state_103698;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_103698__$1,(41),inst_103427);
} else {
if((state_val_103699 === (126))){
var inst_103679 = (state_103698[(32)]);
var state_103698__$1 = state_103698;
var statearr_103859_104029 = state_103698__$1;
(statearr_103859_104029[(2)] = inst_103679);

(statearr_103859_104029[(1)] = (128));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (98))){
var inst_103500 = (state_103698[(49)]);
var state_103698__$1 = state_103698;
var statearr_103860_104030 = state_103698__$1;
(statearr_103860_104030[(2)] = inst_103500);

(statearr_103860_104030[(1)] = (99));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (124))){
var inst_103671 = (state_103698[(7)]);
var inst_103679 = (state_103698[(2)]);
var state_103698__$1 = (function (){var statearr_103861 = state_103698;
(statearr_103861[(32)] = inst_103679);

return statearr_103861;
})();
if(cljs.core.truth_(inst_103671)){
var statearr_103862_104031 = state_103698__$1;
(statearr_103862_104031[(1)] = (126));

} else {
var statearr_103863_104032 = state_103698__$1;
(statearr_103863_104032[(1)] = (127));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (87))){
var inst_103360 = (state_103698[(46)]);
var inst_103541 = (state_103698[(2)]);
var state_103698__$1 = (function (){var statearr_103864 = state_103698;
(statearr_103864[(59)] = inst_103541);

return statearr_103864;
})();
if(cljs.core.truth_(inst_103360)){
var statearr_103865_104033 = state_103698__$1;
(statearr_103865_104033[(1)] = (88));

} else {
var statearr_103866_104034 = state_103698__$1;
(statearr_103866_104034[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (30))){
var inst_103390 = (state_103698[(2)]);
var state_103698__$1 = state_103698;
var statearr_103867_104035 = state_103698__$1;
(statearr_103867_104035[(2)] = inst_103390);

(statearr_103867_104035[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (73))){
var state_103698__$1 = state_103698;
var statearr_103868_104036 = state_103698__$1;
(statearr_103868_104036[(2)] = opts);

(statearr_103868_104036[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (96))){
var inst_103523 = (state_103698[(35)]);
var inst_103500 = (state_103698[(49)]);
var inst_103559 = (state_103698[(2)]);
var inst_103560 = fluree.db.dbproto._rhs.call(null,inst_103523);
var state_103698__$1 = (function (){var statearr_103869 = state_103698;
(statearr_103869[(70)] = inst_103559);

(statearr_103869[(67)] = inst_103560);

return statearr_103869;
})();
if(cljs.core.truth_(inst_103500)){
var statearr_103870_104037 = state_103698__$1;
(statearr_103870_104037[(1)] = (97));

} else {
var statearr_103871_104038 = state_103698__$1;
(statearr_103871_104038[(1)] = (98));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (10))){
var inst_103351 = (state_103698[(2)]);
var state_103698__$1 = state_103698;
var statearr_103872_104039 = state_103698__$1;
(statearr_103872_104039[(2)] = inst_103351);

(statearr_103872_104039[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (18))){
var inst_103333 = (state_103698[(65)]);
var inst_103374 = fluree.db.dbproto._subid.call(null,db,inst_103333);
var state_103698__$1 = state_103698;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_103698__$1,(21),inst_103374);
} else {
if((state_val_103699 === (105))){
var inst_103560 = (state_103698[(67)]);
var inst_103658 = (state_103698[(2)]);
var inst_103659 = cljs.core.nth.call(null,inst_103658,(0),null);
var inst_103660 = cljs.core.nth.call(null,inst_103658,(1),null);
var inst_103661 = cljs.core.nth.call(null,inst_103658,(2),null);
var inst_103662 = cljs.core.nth.call(null,inst_103658,(3),null);
var state_103698__$1 = (function (){var statearr_103873 = state_103698;
(statearr_103873[(30)] = inst_103659);

(statearr_103873[(31)] = inst_103662);

(statearr_103873[(33)] = inst_103661);

(statearr_103873[(34)] = inst_103660);

return statearr_103873;
})();
if(cljs.core.truth_(inst_103560)){
var statearr_103874_104040 = state_103698__$1;
(statearr_103874_104040[(1)] = (119));

} else {
var statearr_103875_104041 = state_103698__$1;
(statearr_103875_104041[(1)] = (120));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (52))){
var inst_103334 = (state_103698[(62)]);
var state_103698__$1 = state_103698;
var statearr_103876_104042 = state_103698__$1;
(statearr_103876_104042[(2)] = inst_103334);

(statearr_103876_104042[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (114))){
var inst_103493 = (state_103698[(24)]);
var inst_103593 = (state_103698[(27)]);
var inst_103620 = (state_103698[(80)]);
var inst_103525 = (state_103698[(29)]);
var inst_103621 = (state_103698[(72)]);
var inst_103619 = (state_103698[(73)]);
var inst_103615 = (state_103698[(2)]);
var inst_103616 = cljs.core.nth.call(null,inst_103615,(0),null);
var inst_103617 = cljs.core.nth.call(null,inst_103615,(1),null);
var inst_103618 = cljs.core.take.call(null,inst_103617,inst_103593);
var inst_103619__$1 = cljs.core.apply.call(null,cljs.core.concat,inst_103618);
var inst_103620__$1 = cljs.core.count.call(null,inst_103619__$1);
var inst_103621__$1 = (inst_103525 + inst_103620__$1);
var inst_103622 = (inst_103621__$1 > inst_103493);
var state_103698__$1 = (function (){var statearr_103877 = state_103698;
(statearr_103877[(80)] = inst_103620__$1);

(statearr_103877[(76)] = inst_103616);

(statearr_103877[(72)] = inst_103621__$1);

(statearr_103877[(73)] = inst_103619__$1);

return statearr_103877;
})();
if(cljs.core.truth_(inst_103622)){
var statearr_103878_104043 = state_103698__$1;
(statearr_103878_104043[(1)] = (115));

} else {
var statearr_103879_104044 = state_103698__$1;
(statearr_103879_104044[(1)] = (116));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (67))){
var state_103698__$1 = state_103698;
var statearr_103880_104045 = state_103698__$1;
(statearr_103880_104045[(2)] = false);

(statearr_103880_104045[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (71))){
var inst_103484 = (state_103698[(2)]);
var state_103698__$1 = state_103698;
var statearr_103881_104046 = state_103698__$1;
(statearr_103881_104046[(2)] = inst_103484);

(statearr_103881_104046[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (42))){
var inst_103424 = (state_103698[(11)]);
var state_103698__$1 = state_103698;
var statearr_103882_104047 = state_103698__$1;
(statearr_103882_104047[(2)] = inst_103424);

(statearr_103882_104047[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (80))){
var inst_103520 = (state_103698[(55)]);
var inst_103495 = (state_103698[(25)]);
var inst_103522 = cljs.core.PersistentVector.EMPTY;
var inst_103523 = inst_103520;
var inst_103524 = inst_103495;
var inst_103525 = (0);
var inst_103526 = (0);
var inst_103527 = inst_103522;
var state_103698__$1 = (function (){var statearr_103883 = state_103698;
(statearr_103883[(35)] = inst_103523);

(statearr_103883[(28)] = inst_103526);

(statearr_103883[(36)] = inst_103527);

(statearr_103883[(29)] = inst_103525);

(statearr_103883[(37)] = inst_103524);

return statearr_103883;
})();
var statearr_103884_104048 = state_103698__$1;
(statearr_103884_104048[(2)] = null);

(statearr_103884_104048[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (37))){
var inst_103420 = (state_103698[(2)]);
var inst_103421 = fluree.db.util.async.throw_err.call(null,inst_103420);
var state_103698__$1 = state_103698;
var statearr_103885_104049 = state_103698__$1;
(statearr_103885_104049[(2)] = inst_103421);

(statearr_103885_104049[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (63))){
var state_103698__$1 = state_103698;
var statearr_103886_104050 = state_103698__$1;
(statearr_103886_104050[(2)] = (2147483647));

(statearr_103886_104050[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (94))){
var inst_103523 = (state_103698[(35)]);
var inst_103516 = (state_103698[(42)]);
var inst_103329 = (state_103698[(8)]);
var inst_103330 = (state_103698[(9)]);
var inst_103505 = (state_103698[(43)]);
var inst_103506 = (state_103698[(44)]);
var inst_103493 = (state_103698[(24)]);
var inst_103415 = (state_103698[(45)]);
var inst_103360 = (state_103698[(46)]);
var inst_103469 = (state_103698[(10)]);
var inst_103424 = (state_103698[(11)]);
var inst_103336 = (state_103698[(12)]);
var inst_103359 = (state_103698[(47)]);
var inst_103470 = (state_103698[(20)]);
var inst_103499 = (state_103698[(26)]);
var inst_103337 = (state_103698[(13)]);
var inst_103332 = (state_103698[(48)]);
var inst_103380 = (state_103698[(14)]);
var inst_103500 = (state_103698[(49)]);
var inst_103460 = (state_103698[(15)]);
var inst_103533 = (state_103698[(38)]);
var inst_103471 = (state_103698[(21)]);
var inst_103433 = (state_103698[(16)]);
var inst_103526 = (state_103698[(28)]);
var inst_103510 = (state_103698[(50)]);
var inst_103527 = (state_103698[(36)]);
var inst_103501 = (state_103698[(51)]);
var inst_103325 = (state_103698[(52)]);
var inst_103371 = (state_103698[(17)]);
var inst_103525 = (state_103698[(29)]);
var inst_103442 = (state_103698[(18)]);
var inst_103411 = (state_103698[(53)]);
var inst_103451 = (state_103698[(19)]);
var inst_103412 = (state_103698[(54)]);
var inst_103492 = (state_103698[(23)]);
var inst_103553 = (state_103698[(68)]);
var inst_103520 = (state_103698[(55)]);
var inst_103361 = (state_103698[(56)]);
var inst_103524 = (state_103698[(37)]);
var inst_103511 = (state_103698[(57)]);
var inst_103555 = (function (){var no_filter_QMARK_ = true;
var t = inst_103506;
var max_limit_QMARK_ = inst_103500;
var next_node = inst_103523;
var fast_forward_db_QMARK_ = inst_103511;
var vec__103314 = inst_103332;
var s1 = inst_103371;
var o2 = inst_103433;
var t1 = inst_103329;
var predicate_fn = inst_103361;
var i = inst_103525;
var m1 = inst_103460;
var root_node = inst_103516;
var s2 = inst_103380;
var G__103534 = inst_103553;
var p2 = inst_103451;
var permissions = inst_103501;
var limit = inst_103499;
var map__103317 = inst_103359;
var start_flake = inst_103470;
var flake_limit = inst_103493;
var offset = inst_103524;
var acc = inst_103527;
var t2 = inst_103336;
var vec__103311 = inst_103325;
var op1 = inst_103330;
var o1 = inst_103424;
var end_flake = inst_103471;
var base_result = inst_103533;
var s = inst_103526;
var node_start = inst_103520;
var p1 = inst_103442;
var vec__103318 = inst_103411;
var subject_fn = inst_103360;
var object_fn = inst_103415;
var idx_compare = inst_103505;
var op2 = inst_103337;
var m2 = inst_103469;
var map__103324 = inst_103492;
var vec__103321 = inst_103412;
var novelty = inst_103510;
return (function (p1__103297_SHARP_){
return object_fn.call(null,p1__103297_SHARP_.o);
});
})();
var inst_103556 = cljs.core.filter.call(null,inst_103555,inst_103553);
var state_103698__$1 = state_103698;
var statearr_103887_104051 = state_103698__$1;
(statearr_103887_104051[(2)] = inst_103556);

(statearr_103887_104051[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (8))){
var state_103698__$1 = state_103698;
var statearr_103888_104052 = state_103698__$1;
(statearr_103888_104052[(2)] = true);

(statearr_103888_104052[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (49))){
var state_103698__$1 = state_103698;
var statearr_103889_104053 = state_103698__$1;
(statearr_103889_104053[(2)] = false);

(statearr_103889_104053[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103699 === (84))){
var inst_103691 = (state_103698[(2)]);
var state_103698__$1 = state_103698;
var statearr_103890_104054 = state_103698__$1;
(statearr_103890_104054[(2)] = inst_103691);

(statearr_103890_104054[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__99975__auto__ = null;
var fluree$db$query$range$state_machine__99975__auto____0 = (function (){
var statearr_103891 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_103891[(0)] = fluree$db$query$range$state_machine__99975__auto__);

(statearr_103891[(1)] = (1));

return statearr_103891;
});
var fluree$db$query$range$state_machine__99975__auto____1 = (function (state_103698){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_103698);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e103892){if((e103892 instanceof Object)){
var ex__99978__auto__ = e103892;
var statearr_103893_104055 = state_103698;
(statearr_103893_104055[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_103698);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e103892;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__104056 = state_103698;
state_103698 = G__104056;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__99975__auto__ = function(state_103698){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__99975__auto____1.call(this,state_103698);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__99975__auto____0;
fluree$db$query$range$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__99975__auto____1;
return fluree$db$query$range$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_103894 = f__100070__auto__.call(null);
(statearr_103894[(6)] = c__100069__auto__);

return statearr_103894;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.query.range.index_range.cljs$lang$maxFixedArity = 7);

fluree.db.query.range.non_nil_non_boolean_QMARK_ = (function fluree$db$query$range$non_nil_non_boolean_QMARK_(o){
return (((!((o == null)))) && ((!(cljs.core.boolean_QMARK_.call(null,o)))));
});
fluree.db.query.range.tag_string_QMARK_ = (function fluree$db$query$range$tag_string_QMARK_(possible_tag){
return cljs.core.re_find.call(null,/^[a-zA-Z0-9-_]*\/[a-zA-Z0-9-_]*:[a-zA-Z0-9-]*$/,possible_tag);
});
fluree.db.query.range.tag_sid_start = fluree.db.flake.min_subject_id.call(null,(3));
fluree.db.query.range.tag_sid_end = fluree.db.flake.max_subject_id.call(null,(3));
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.query.range.is_tag_flake_QMARK_ = (function fluree$db$query$range$is_tag_flake_QMARK_(f){
return (((fluree.db.query.range.tag_sid_start <= f.o)) && ((f.o <= fluree.db.query.range.tag_sid_end)));
});
fluree.db.query.range.coerce_tag_flakes = (function fluree$db$query$range$coerce_tag_flakes(db,flakes){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_104111){
var state_val_104112 = (state_104111[(1)]);
if((state_val_104112 === (7))){
var inst_104075 = (state_104111[(7)]);
var inst_104085 = (state_104111[(8)]);
var inst_104083 = fluree.db.flake.Flake__GT_parts.call(null,inst_104075);
var inst_104084 = cljs.core.nth.call(null,inst_104083,(0),null);
var inst_104085__$1 = cljs.core.nth.call(null,inst_104083,(1),null);
var inst_104086 = cljs.core.nth.call(null,inst_104083,(2),null);
var inst_104087 = cljs.core.nth.call(null,inst_104083,(3),null);
var inst_104088 = cljs.core.nth.call(null,inst_104083,(4),null);
var inst_104089 = cljs.core.nth.call(null,inst_104083,(5),null);
var inst_104090 = fluree.db.dbproto._tag.call(null,db,inst_104086,inst_104085__$1);
var state_104111__$1 = (function (){var statearr_104113 = state_104111;
(statearr_104113[(9)] = inst_104087);

(statearr_104113[(10)] = inst_104084);

(statearr_104113[(11)] = inst_104088);

(statearr_104113[(8)] = inst_104085__$1);

(statearr_104113[(12)] = inst_104089);

return statearr_104113;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_104111__$1,(10),inst_104090);
} else {
if((state_val_104112 === (1))){
var inst_104064 = cljs.core.seq.call(null,flakes);
var inst_104065 = cljs.core.first.call(null,inst_104064);
var inst_104066 = cljs.core.next.call(null,inst_104064);
var inst_104067 = cljs.core.PersistentVector.EMPTY;
var inst_104068 = flakes;
var inst_104069 = inst_104067;
var state_104111__$1 = (function (){var statearr_104114 = state_104111;
(statearr_104114[(13)] = inst_104066);

(statearr_104114[(14)] = inst_104065);

(statearr_104114[(15)] = inst_104068);

(statearr_104114[(16)] = inst_104069);

return statearr_104114;
})();
var statearr_104115_104132 = state_104111__$1;
(statearr_104115_104132[(2)] = null);

(statearr_104115_104132[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104112 === (4))){
var inst_104075 = (state_104111[(7)]);
var inst_104078 = fluree.db.query.range.is_tag_flake_QMARK_.call(null,inst_104075);
var state_104111__$1 = state_104111;
if(inst_104078){
var statearr_104116_104133 = state_104111__$1;
(statearr_104116_104133[(1)] = (7));

} else {
var statearr_104117_104134 = state_104111__$1;
(statearr_104117_104134[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104112 === (6))){
var inst_104107 = (state_104111[(2)]);
var state_104111__$1 = state_104111;
var statearr_104118_104135 = state_104111__$1;
(statearr_104118_104135[(2)] = inst_104107);

(statearr_104118_104135[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104112 === (3))){
var inst_104109 = (state_104111[(2)]);
var state_104111__$1 = state_104111;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_104111__$1,inst_104109);
} else {
if((state_val_104112 === (2))){
var inst_104075 = (state_104111[(7)]);
var inst_104068 = (state_104111[(15)]);
var inst_104074 = cljs.core.seq.call(null,inst_104068);
var inst_104075__$1 = cljs.core.first.call(null,inst_104074);
var inst_104076 = cljs.core.next.call(null,inst_104074);
var state_104111__$1 = (function (){var statearr_104119 = state_104111;
(statearr_104119[(7)] = inst_104075__$1);

(statearr_104119[(17)] = inst_104076);

return statearr_104119;
})();
if(cljs.core.truth_(inst_104075__$1)){
var statearr_104120_104136 = state_104111__$1;
(statearr_104120_104136[(1)] = (4));

} else {
var statearr_104121_104137 = state_104111__$1;
(statearr_104121_104137[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104112 === (9))){
var inst_104104 = (state_104111[(2)]);
var state_104111__$1 = state_104111;
var statearr_104122_104138 = state_104111__$1;
(statearr_104122_104138[(2)] = inst_104104);

(statearr_104122_104138[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104112 === (5))){
var inst_104069 = (state_104111[(16)]);
var state_104111__$1 = state_104111;
var statearr_104123_104139 = state_104111__$1;
(statearr_104123_104139[(2)] = inst_104069);

(statearr_104123_104139[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104112 === (10))){
var inst_104087 = (state_104111[(9)]);
var inst_104084 = (state_104111[(10)]);
var inst_104088 = (state_104111[(11)]);
var inst_104076 = (state_104111[(17)]);
var inst_104085 = (state_104111[(8)]);
var inst_104069 = (state_104111[(16)]);
var inst_104089 = (state_104111[(12)]);
var inst_104092 = (state_104111[(2)]);
var inst_104093 = fluree.db.util.async.throw_err.call(null,inst_104092);
var inst_104094 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_104095 = [inst_104084,inst_104085,inst_104093,inst_104087,inst_104088,inst_104089];
var inst_104096 = (new cljs.core.PersistentVector(null,6,(5),inst_104094,inst_104095,null));
var inst_104097 = fluree.db.flake.parts__GT_Flake.call(null,inst_104096);
var inst_104098 = cljs.core.conj.call(null,inst_104069,inst_104097);
var inst_104068 = inst_104076;
var inst_104069__$1 = inst_104098;
var state_104111__$1 = (function (){var statearr_104124 = state_104111;
(statearr_104124[(15)] = inst_104068);

(statearr_104124[(16)] = inst_104069__$1);

return statearr_104124;
})();
var statearr_104125_104140 = state_104111__$1;
(statearr_104125_104140[(2)] = null);

(statearr_104125_104140[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104112 === (8))){
var inst_104075 = (state_104111[(7)]);
var inst_104076 = (state_104111[(17)]);
var inst_104069 = (state_104111[(16)]);
var inst_104101 = cljs.core.conj.call(null,inst_104069,inst_104075);
var inst_104068 = inst_104076;
var inst_104069__$1 = inst_104101;
var state_104111__$1 = (function (){var statearr_104126 = state_104111;
(statearr_104126[(15)] = inst_104068);

(statearr_104126[(16)] = inst_104069__$1);

return statearr_104126;
})();
var statearr_104127_104141 = state_104111__$1;
(statearr_104127_104141[(2)] = null);

(statearr_104127_104141[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__99975__auto__ = null;
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__99975__auto____0 = (function (){
var statearr_104128 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_104128[(0)] = fluree$db$query$range$coerce_tag_flakes_$_state_machine__99975__auto__);

(statearr_104128[(1)] = (1));

return statearr_104128;
});
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__99975__auto____1 = (function (state_104111){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_104111);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e104129){if((e104129 instanceof Object)){
var ex__99978__auto__ = e104129;
var statearr_104130_104142 = state_104111;
(statearr_104130_104142[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_104111);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e104129;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__104143 = state_104111;
state_104111 = G__104143;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$range$coerce_tag_flakes_$_state_machine__99975__auto__ = function(state_104111){
switch(arguments.length){
case 0:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__99975__auto____1.call(this,state_104111);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$coerce_tag_flakes_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__99975__auto____0;
fluree$db$query$range$coerce_tag_flakes_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__99975__auto____1;
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_104131 = f__100070__auto__.call(null);
(statearr_104131[(6)] = c__100069__auto__);

return statearr_104131;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
fluree.db.query.range.search = (function fluree$db$query$range$search(var_args){
var G__104145 = arguments.length;
switch (G__104145) {
case 2:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2 = (function (db,fparts){
return fluree.db.query.range.search.call(null,db,fparts,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3 = (function (db,fparts,opts){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_104292){
var state_val_104293 = (state_104292[(1)]);
if((state_val_104293 === (62))){
var inst_104288 = (state_104292[(2)]);
var state_104292__$1 = state_104292;
var statearr_104294_104376 = state_104292__$1;
(statearr_104294_104376[(2)] = inst_104288);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_104292__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104293 === (7))){
var inst_104163 = (state_104292[(7)]);
var inst_104163__$1 = (state_104292[(2)]);
var state_104292__$1 = (function (){var statearr_104295 = state_104292;
(statearr_104295[(7)] = inst_104163__$1);

return statearr_104295;
})();
if(cljs.core.truth_(inst_104163__$1)){
var statearr_104296_104377 = state_104292__$1;
(statearr_104296_104377[(1)] = (8));

} else {
var statearr_104297_104378 = state_104292__$1;
(statearr_104297_104378[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104293 === (59))){
var inst_104268 = (state_104292[(2)]);
var inst_104269 = fluree.db.util.async.throw_err.call(null,inst_104268);
var state_104292__$1 = state_104292;
var statearr_104298_104379 = state_104292__$1;
(statearr_104298_104379[(2)] = inst_104269);

(statearr_104298_104379[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104293 === (20))){
var inst_104189 = (state_104292[(2)]);
var state_104292__$1 = state_104292;
var statearr_104299_104380 = state_104292__$1;
(statearr_104299_104380[(2)] = inst_104189);

(statearr_104299_104380[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104293 === (58))){
var inst_104272 = (state_104292[(2)]);
var state_104292__$1 = state_104292;
var statearr_104300_104381 = state_104292__$1;
(statearr_104300_104381[(2)] = inst_104272);

(statearr_104300_104381[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104293 === (60))){
var inst_104280 = (state_104292[(8)]);
var inst_104282 = fluree.db.query.range.coerce_tag_flakes.call(null,db,inst_104280);
var state_104292__$1 = state_104292;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_104292__$1,(63),inst_104282);
} else {
if((state_val_104293 === (27))){
var inst_104154 = (state_104292[(9)]);
var state_104292__$1 = state_104292;
var statearr_104301_104382 = state_104292__$1;
(statearr_104301_104382[(2)] = inst_104154);

(statearr_104301_104382[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104293 === (1))){
var state_104292__$1 = state_104292;
var statearr_104302_104383 = state_104292__$1;
(statearr_104302_104383[(2)] = null);

(statearr_104302_104383[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104293 === (24))){
var inst_104163 = (state_104292[(7)]);
var inst_104280 = (state_104292[(2)]);
var state_104292__$1 = (function (){var statearr_104303 = state_104292;
(statearr_104303[(8)] = inst_104280);

return statearr_104303;
})();
if(cljs.core.truth_(inst_104163)){
var statearr_104304_104384 = state_104292__$1;
(statearr_104304_104384[(1)] = (60));

} else {
var statearr_104305_104385 = state_104292__$1;
(statearr_104305_104385[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104293 === (55))){
var inst_104259 = (state_104292[(2)]);
var inst_104260 = fluree.db.util.async.throw_err.call(null,inst_104259);
var state_104292__$1 = state_104292;
var statearr_104306_104386 = state_104292__$1;
(statearr_104306_104386[(2)] = inst_104260);

(statearr_104306_104386[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104293 === (39))){
var inst_104157 = (state_104292[(10)]);
var inst_104228 = cljs.core.not.call(null,inst_104157);
var state_104292__$1 = state_104292;
if(inst_104228){
var statearr_104307_104387 = state_104292__$1;
(statearr_104307_104387[(1)] = (42));

} else {
var statearr_104308_104388 = state_104292__$1;
(statearr_104308_104388[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104293 === (46))){
var inst_104154 = (state_104292[(9)]);
var state_104292__$1 = state_104292;
if(cljs.core.truth_(inst_104154)){
var statearr_104309_104389 = state_104292__$1;
(statearr_104309_104389[(1)] = (52));

} else {
var statearr_104310_104390 = state_104292__$1;
(statearr_104310_104390[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104293 === (4))){
var inst_104154 = (state_104292[(9)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_104292,(3),Error,null,(2));
var inst_104153 = cljs.core.nth.call(null,fparts,(0),null);
var inst_104154__$1 = cljs.core.nth.call(null,fparts,(1),null);
var inst_104155 = cljs.core.nth.call(null,fparts,(2),null);
var inst_104156 = cljs.core.nth.call(null,fparts,(3),null);
var inst_104157 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),inst_104154__$1);
var state_104292__$1 = (function (){var statearr_104311 = state_104292;
(statearr_104311[(11)] = inst_104155);

(statearr_104311[(12)] = inst_104153);

(statearr_104311[(10)] = inst_104157);

(statearr_104311[(9)] = inst_104154__$1);

(statearr_104311[(13)] = inst_104156);

return statearr_104311;
})();
if(cljs.core.truth_(inst_104154__$1)){
var statearr_104312_104391 = state_104292__$1;
(statearr_104312_104391[(1)] = (5));

} else {
var statearr_104313_104392 = state_104292__$1;
(statearr_104313_104392[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104293 === (54))){
var inst_104274 = (state_104292[(2)]);
var state_104292__$1 = state_104292;
var statearr_104314_104393 = state_104292__$1;
(statearr_104314_104393[(2)] = inst_104274);

(statearr_104314_104393[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104293 === (15))){
var inst_104155 = (state_104292[(11)]);
var inst_104179 = typeof inst_104155 === 'string';
var state_104292__$1 = state_104292;
if(cljs.core.truth_(inst_104179)){
var statearr_104315_104394 = state_104292__$1;
(statearr_104315_104394[(1)] = (18));

} else {
var statearr_104316_104395 = state_104292__$1;
(statearr_104316_104395[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104293 === (48))){
var inst_104168 = (state_104292[(14)]);
var inst_104193 = (state_104292[(15)]);
var inst_104153 = (state_104292[(12)]);
var inst_104163 = (state_104292[(7)]);
var inst_104157 = (state_104292[(10)]);
var inst_104237 = (state_104292[(16)]);
var inst_104154 = (state_104292[(9)]);
var inst_104156 = (state_104292[(13)]);
var inst_104239 = (function (){var obj_fn = inst_104237;
var t = inst_104156;
var temp__5733__auto__ = inst_104237;
var p = inst_104154;
var idx_predicate_QMARK_ = inst_104157;
var o = inst_104193;
var vec__104150 = fparts;
var tag_predicate_QMARK_ = inst_104163;
var s = inst_104153;
var o_coerce_QMARK_ = inst_104168;
return (function (x){
var and__4115__auto__ = obj_fn.call(null,x);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.call(null,x,o);
} else {
return and__4115__auto__;
}
});
})();
var state_104292__$1 = state_104292;
var statearr_104317_104396 = state_104292__$1;
(statearr_104317_104396[(2)] = inst_104239);

(statearr_104317_104396[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104293 === (50))){
var inst_104153 = (state_104292[(12)]);
var inst_104154 = (state_104292[(9)]);
var inst_104156 = (state_104292[(13)]);
var inst_104243 = (state_104292[(2)]);
var inst_104244 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_104245 = [inst_104154,inst_104153,null,inst_104156];
var inst_104246 = (new cljs.core.PersistentVector(null,4,(5),inst_104244,inst_104245,null));
var inst_104247 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481),inst_104243);
var inst_104248 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_104246,inst_104247);
var state_104292__$1 = state_104292;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_104292__$1,(51),inst_104248);
} else {
if((state_val_104293 === (21))){
var inst_104185 = (state_104292[(2)]);
var inst_104186 = fluree.db.util.async.throw_err.call(null,inst_104185);
var state_104292__$1 = state_104292;
var statearr_104318_104397 = state_104292__$1;
(statearr_104318_104397[(2)] = inst_104186);

(statearr_104318_104397[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104293 === (31))){
var inst_104214 = (state_104292[(2)]);
var state_104292__$1 = state_104292;
var statearr_104319_104398 = state_104292__$1;
(statearr_104319_104398[(2)] = inst_104214);

(statearr_104319_104398[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104293 === (32))){
var inst_104193 = (state_104292[(15)]);
var inst_104207 = cljs.core.fn_QMARK_.call(null,inst_104193);
var inst_104208 = (!(inst_104207));
var state_104292__$1 = state_104292;
var statearr_104320_104399 = state_104292__$1;
(statearr_104320_104399[(2)] = inst_104208);

(statearr_104320_104399[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104293 === (40))){
var inst_104154 = (state_104292[(9)]);
var state_104292__$1 = state_104292;
var statearr_104321_104400 = state_104292__$1;
(statearr_104321_104400[(2)] = inst_104154);

(statearr_104321_104400[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104293 === (56))){
var inst_104193 = (state_104292[(15)]);
var inst_104153 = (state_104292[(12)]);
var inst_104154 = (state_104292[(9)]);
var inst_104156 = (state_104292[(13)]);
var inst_104263 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_104264 = [inst_104193,inst_104154,inst_104153,inst_104156];
var inst_104265 = (new cljs.core.PersistentVector(null,4,(5),inst_104263,inst_104264,null));
var inst_104266 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_104265,opts);
var state_104292__$1 = state_104292;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_104292__$1,(59),inst_104266);
} else {
if((state_val_104293 === (33))){
var inst_104157 = (state_104292[(10)]);
var state_104292__$1 = state_104292;
var statearr_104322_104401 = state_104292__$1;
(statearr_104322_104401[(2)] = inst_104157);

(statearr_104322_104401[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104293 === (13))){
var inst_104153 = (state_104292[(12)]);
var inst_104193 = (state_104292[(2)]);
var state_104292__$1 = (function (){var statearr_104323 = state_104292;
(statearr_104323[(15)] = inst_104193);

return statearr_104323;
})();
if(cljs.core.truth_(inst_104153)){
var statearr_104324_104402 = state_104292__$1;
(statearr_104324_104402[(1)] = (22));

} else {
var statearr_104325_104403 = state_104292__$1;
(statearr_104325_104403[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104293 === (22))){
var inst_104193 = (state_104292[(15)]);
var inst_104153 = (state_104292[(12)]);
var inst_104154 = (state_104292[(9)]);
var inst_104156 = (state_104292[(13)]);
var inst_104195 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_104196 = [inst_104153,inst_104154,inst_104193,inst_104156];
var inst_104197 = (new cljs.core.PersistentVector(null,4,(5),inst_104195,inst_104196,null));
var inst_104198 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_104197,opts);
var state_104292__$1 = state_104292;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_104292__$1,(25),inst_104198);
} else {
if((state_val_104293 === (36))){
var inst_104154 = (state_104292[(9)]);
var state_104292__$1 = state_104292;
if(cljs.core.truth_(inst_104154)){
var statearr_104326_104404 = state_104292__$1;
(statearr_104326_104404[(1)] = (39));

} else {
var statearr_104327_104405 = state_104292__$1;
(statearr_104327_104405[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104293 === (41))){
var inst_104235 = (state_104292[(2)]);
var state_104292__$1 = state_104292;
if(cljs.core.truth_(inst_104235)){
var statearr_104328_104406 = state_104292__$1;
(statearr_104328_104406[(1)] = (45));

} else {
var statearr_104329_104407 = state_104292__$1;
(statearr_104329_104407[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104293 === (43))){
var state_104292__$1 = state_104292;
var statearr_104330_104408 = state_104292__$1;
(statearr_104330_104408[(2)] = false);

(statearr_104330_104408[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104293 === (61))){
var inst_104280 = (state_104292[(8)]);
var state_104292__$1 = state_104292;
var statearr_104331_104409 = state_104292__$1;
(statearr_104331_104409[(2)] = inst_104280);

(statearr_104331_104409[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104293 === (29))){
var inst_104157 = (state_104292[(10)]);
var state_104292__$1 = state_104292;
if(cljs.core.truth_(inst_104157)){
var statearr_104332_104410 = state_104292__$1;
(statearr_104332_104410[(1)] = (32));

} else {
var statearr_104333_104411 = state_104292__$1;
(statearr_104333_104411[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104293 === (44))){
var inst_104232 = (state_104292[(2)]);
var state_104292__$1 = state_104292;
var statearr_104334_104412 = state_104292__$1;
(statearr_104334_104412[(2)] = inst_104232);

(statearr_104334_104412[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104293 === (6))){
var state_104292__$1 = state_104292;
var statearr_104335_104413 = state_104292__$1;
(statearr_104335_104413[(2)] = false);

(statearr_104335_104413[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104293 === (28))){
var inst_104217 = (state_104292[(2)]);
var state_104292__$1 = state_104292;
if(cljs.core.truth_(inst_104217)){
var statearr_104336_104414 = state_104292__$1;
(statearr_104336_104414[(1)] = (35));

} else {
var statearr_104337_104415 = state_104292__$1;
(statearr_104337_104415[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104293 === (51))){
var inst_104250 = (state_104292[(2)]);
var inst_104251 = fluree.db.util.async.throw_err.call(null,inst_104250);
var state_104292__$1 = state_104292;
var statearr_104338_104416 = state_104292__$1;
(statearr_104338_104416[(2)] = inst_104251);

(statearr_104338_104416[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104293 === (25))){
var inst_104200 = (state_104292[(2)]);
var inst_104201 = fluree.db.util.async.throw_err.call(null,inst_104200);
var state_104292__$1 = state_104292;
var statearr_104339_104417 = state_104292__$1;
(statearr_104339_104417[(2)] = inst_104201);

(statearr_104339_104417[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104293 === (34))){
var inst_104211 = (state_104292[(2)]);
var state_104292__$1 = state_104292;
var statearr_104340_104418 = state_104292__$1;
(statearr_104340_104418[(2)] = inst_104211);

(statearr_104340_104418[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104293 === (17))){
var inst_104176 = (state_104292[(2)]);
var inst_104177 = fluree.db.util.async.throw_err.call(null,inst_104176);
var state_104292__$1 = state_104292;
var statearr_104341_104419 = state_104292__$1;
(statearr_104341_104419[(2)] = inst_104177);

(statearr_104341_104419[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104293 === (3))){
var inst_104146 = (state_104292[(2)]);
var state_104292__$1 = state_104292;
var statearr_104342_104420 = state_104292__$1;
(statearr_104342_104420[(2)] = inst_104146);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_104292__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104293 === (12))){
var inst_104155 = (state_104292[(11)]);
var inst_104172 = fluree.db.query.range.tag_string_QMARK_.call(null,inst_104155);
var state_104292__$1 = state_104292;
if(cljs.core.truth_(inst_104172)){
var statearr_104343_104421 = state_104292__$1;
(statearr_104343_104421[(1)] = (14));

} else {
var statearr_104344_104422 = state_104292__$1;
(statearr_104344_104422[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104293 === (2))){
var inst_104290 = (state_104292[(2)]);
var state_104292__$1 = state_104292;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_104292__$1,inst_104290);
} else {
if((state_val_104293 === (23))){
var inst_104154 = (state_104292[(9)]);
var state_104292__$1 = state_104292;
if(cljs.core.truth_(inst_104154)){
var statearr_104345_104423 = state_104292__$1;
(statearr_104345_104423[(1)] = (26));

} else {
var statearr_104346_104424 = state_104292__$1;
(statearr_104346_104424[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104293 === (47))){
var inst_104276 = (state_104292[(2)]);
var state_104292__$1 = state_104292;
var statearr_104347_104425 = state_104292__$1;
(statearr_104347_104425[(2)] = inst_104276);

(statearr_104347_104425[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104293 === (35))){
var inst_104193 = (state_104292[(15)]);
var inst_104153 = (state_104292[(12)]);
var inst_104154 = (state_104292[(9)]);
var inst_104156 = (state_104292[(13)]);
var inst_104219 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_104220 = [inst_104154,inst_104193,inst_104153,inst_104156];
var inst_104221 = (new cljs.core.PersistentVector(null,4,(5),inst_104219,inst_104220,null));
var inst_104222 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_104221,opts);
var state_104292__$1 = state_104292;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_104292__$1,(38),inst_104222);
} else {
if((state_val_104293 === (19))){
var state_104292__$1 = state_104292;
var statearr_104348_104426 = state_104292__$1;
(statearr_104348_104426[(2)] = null);

(statearr_104348_104426[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104293 === (57))){
var state_104292__$1 = state_104292;
var statearr_104349_104427 = state_104292__$1;
(statearr_104349_104427[(2)] = null);

(statearr_104349_104427[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104293 === (11))){
var inst_104155 = (state_104292[(11)]);
var state_104292__$1 = state_104292;
var statearr_104350_104428 = state_104292__$1;
(statearr_104350_104428[(2)] = inst_104155);

(statearr_104350_104428[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104293 === (9))){
var inst_104163 = (state_104292[(7)]);
var state_104292__$1 = state_104292;
var statearr_104351_104429 = state_104292__$1;
(statearr_104351_104429[(2)] = inst_104163);

(statearr_104351_104429[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104293 === (5))){
var inst_104154 = (state_104292[(9)]);
var inst_104159 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"type","type",1174270348),inst_104154);
var inst_104160 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"tag","tag",-1290361223),inst_104159);
var state_104292__$1 = state_104292;
var statearr_104352_104430 = state_104292__$1;
(statearr_104352_104430[(2)] = inst_104160);

(statearr_104352_104430[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104293 === (14))){
var inst_104155 = (state_104292[(11)]);
var inst_104174 = fluree.db.dbproto._tag_id.call(null,db,inst_104155);
var state_104292__$1 = state_104292;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_104292__$1,(17),inst_104174);
} else {
if((state_val_104293 === (45))){
var inst_104237 = (state_104292[(16)]);
var inst_104237__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(opts);
var state_104292__$1 = (function (){var statearr_104353 = state_104292;
(statearr_104353[(16)] = inst_104237__$1);

return statearr_104353;
})();
if(cljs.core.truth_(inst_104237__$1)){
var statearr_104354_104431 = state_104292__$1;
(statearr_104354_104431[(1)] = (48));

} else {
var statearr_104355_104432 = state_104292__$1;
(statearr_104355_104432[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104293 === (53))){
var inst_104193 = (state_104292[(15)]);
var state_104292__$1 = state_104292;
if(cljs.core.truth_(inst_104193)){
var statearr_104356_104433 = state_104292__$1;
(statearr_104356_104433[(1)] = (56));

} else {
var statearr_104357_104434 = state_104292__$1;
(statearr_104357_104434[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104293 === (26))){
var inst_104193 = (state_104292[(15)]);
var inst_104204 = fluree.db.query.range.non_nil_non_boolean_QMARK_.call(null,inst_104193);
var state_104292__$1 = state_104292;
if(inst_104204){
var statearr_104358_104435 = state_104292__$1;
(statearr_104358_104435[(1)] = (29));

} else {
var statearr_104359_104436 = state_104292__$1;
(statearr_104359_104436[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104293 === (16))){
var inst_104191 = (state_104292[(2)]);
var state_104292__$1 = state_104292;
var statearr_104360_104437 = state_104292__$1;
(statearr_104360_104437[(2)] = inst_104191);

(statearr_104360_104437[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104293 === (38))){
var inst_104224 = (state_104292[(2)]);
var inst_104225 = fluree.db.util.async.throw_err.call(null,inst_104224);
var state_104292__$1 = state_104292;
var statearr_104361_104438 = state_104292__$1;
(statearr_104361_104438[(2)] = inst_104225);

(statearr_104361_104438[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104293 === (30))){
var state_104292__$1 = state_104292;
var statearr_104362_104439 = state_104292__$1;
(statearr_104362_104439[(2)] = false);

(statearr_104362_104439[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104293 === (10))){
var inst_104168 = (state_104292[(14)]);
var inst_104168__$1 = (state_104292[(2)]);
var inst_104169 = cljs.core.not.call(null,inst_104168__$1);
var state_104292__$1 = (function (){var statearr_104363 = state_104292;
(statearr_104363[(14)] = inst_104168__$1);

return statearr_104363;
})();
if(inst_104169){
var statearr_104364_104440 = state_104292__$1;
(statearr_104364_104440[(1)] = (11));

} else {
var statearr_104365_104441 = state_104292__$1;
(statearr_104365_104441[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104293 === (18))){
var inst_104155 = (state_104292[(11)]);
var inst_104154 = (state_104292[(9)]);
var inst_104181 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_104154);
var inst_104182 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_104181),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_104155)].join('');
var inst_104183 = fluree.db.dbproto._tag_id.call(null,db,inst_104182);
var state_104292__$1 = state_104292;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_104292__$1,(21),inst_104183);
} else {
if((state_val_104293 === (52))){
var inst_104193 = (state_104292[(15)]);
var inst_104153 = (state_104292[(12)]);
var inst_104154 = (state_104292[(9)]);
var inst_104156 = (state_104292[(13)]);
var inst_104254 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_104255 = [inst_104154,inst_104153,inst_104193,inst_104156];
var inst_104256 = (new cljs.core.PersistentVector(null,4,(5),inst_104254,inst_104255,null));
var inst_104257 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_104256,opts);
var state_104292__$1 = state_104292;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_104292__$1,(55),inst_104257);
} else {
if((state_val_104293 === (42))){
var inst_104193 = (state_104292[(15)]);
var state_104292__$1 = state_104292;
var statearr_104366_104442 = state_104292__$1;
(statearr_104366_104442[(2)] = inst_104193);

(statearr_104366_104442[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104293 === (37))){
var inst_104278 = (state_104292[(2)]);
var state_104292__$1 = state_104292;
var statearr_104367_104443 = state_104292__$1;
(statearr_104367_104443[(2)] = inst_104278);

(statearr_104367_104443[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104293 === (63))){
var inst_104284 = (state_104292[(2)]);
var inst_104285 = fluree.db.util.async.throw_err.call(null,inst_104284);
var state_104292__$1 = state_104292;
var statearr_104368_104444 = state_104292__$1;
(statearr_104368_104444[(2)] = inst_104285);

(statearr_104368_104444[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104293 === (8))){
var inst_104155 = (state_104292[(11)]);
var inst_104165 = typeof inst_104155 === 'string';
var state_104292__$1 = state_104292;
var statearr_104369_104445 = state_104292__$1;
(statearr_104369_104445[(2)] = inst_104165);

(statearr_104369_104445[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104293 === (49))){
var inst_104168 = (state_104292[(14)]);
var inst_104193 = (state_104292[(15)]);
var inst_104153 = (state_104292[(12)]);
var inst_104163 = (state_104292[(7)]);
var inst_104157 = (state_104292[(10)]);
var inst_104237 = (state_104292[(16)]);
var inst_104154 = (state_104292[(9)]);
var inst_104156 = (state_104292[(13)]);
var inst_104241 = (function (){var t = inst_104156;
var temp__5733__auto__ = inst_104237;
var p = inst_104154;
var idx_predicate_QMARK_ = inst_104157;
var o = inst_104193;
var vec__104150 = fparts;
var tag_predicate_QMARK_ = inst_104163;
var s = inst_104153;
var o_coerce_QMARK_ = inst_104168;
return (function (x){
return cljs.core._EQ_.call(null,x,o);
});
})();
var state_104292__$1 = state_104292;
var statearr_104370_104446 = state_104292__$1;
(statearr_104370_104446[(2)] = inst_104241);

(statearr_104370_104446[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__99975__auto__ = null;
var fluree$db$query$range$state_machine__99975__auto____0 = (function (){
var statearr_104371 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_104371[(0)] = fluree$db$query$range$state_machine__99975__auto__);

(statearr_104371[(1)] = (1));

return statearr_104371;
});
var fluree$db$query$range$state_machine__99975__auto____1 = (function (state_104292){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_104292);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e104372){if((e104372 instanceof Object)){
var ex__99978__auto__ = e104372;
var statearr_104373_104447 = state_104292;
(statearr_104373_104447[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_104292);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e104372;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__104448 = state_104292;
state_104292 = G__104448;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__99975__auto__ = function(state_104292){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__99975__auto____1.call(this,state_104292);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__99975__auto____0;
fluree$db$query$range$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__99975__auto____1;
return fluree$db$query$range$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_104374 = f__100070__auto__.call(null);
(statearr_104374[(6)] = c__100069__auto__);

return statearr_104374;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.query.range.search.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range.collection = (function fluree$db$query$range$collection(var_args){
var G__104450 = arguments.length;
switch (G__104450) {
case 2:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2 = (function (db,name){
return fluree.db.query.range.collection.call(null,db,name,null);
}));

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3 = (function (db,name,opts){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_104482){
var state_val_104483 = (state_104482[(1)]);
if((state_val_104483 === (1))){
var state_104482__$1 = state_104482;
var statearr_104484_104497 = state_104482__$1;
(statearr_104484_104497[(2)] = null);

(statearr_104484_104497[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104483 === (2))){
var inst_104480 = (state_104482[(2)]);
var state_104482__$1 = state_104482;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_104482__$1,inst_104480);
} else {
if((state_val_104483 === (3))){
var inst_104451 = (state_104482[(2)]);
var state_104482__$1 = state_104482;
var statearr_104485_104498 = state_104482__$1;
(statearr_104485_104498[(2)] = inst_104451);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_104482__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104483 === (4))){
var inst_104455 = (state_104482[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_104482,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var inst_104455__$1 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),name);
var state_104482__$1 = (function (){var statearr_104486 = state_104482;
(statearr_104486[(7)] = inst_104455__$1);

return statearr_104486;
})();
if(cljs.core.truth_(inst_104455__$1)){
var statearr_104487_104499 = state_104482__$1;
(statearr_104487_104499[(1)] = (5));

} else {
var statearr_104488_104500 = state_104482__$1;
(statearr_104488_104500[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104483 === (5))){
var inst_104455 = (state_104482[(7)]);
var inst_104457 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_104458 = fluree.db.flake.max_subject_id.call(null,inst_104455);
var inst_104459 = [inst_104458];
var inst_104460 = (new cljs.core.PersistentVector(null,1,(5),inst_104457,inst_104459,null));
var inst_104461 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_104462 = fluree.db.flake.min_subject_id.call(null,inst_104455);
var inst_104463 = [inst_104462];
var inst_104464 = (new cljs.core.PersistentVector(null,1,(5),inst_104461,inst_104463,null));
var inst_104465 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_104460,cljs.core._LT__EQ_,inst_104464,opts);
var state_104482__$1 = state_104482;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_104482__$1,(8),inst_104465);
} else {
if((state_val_104483 === (6))){
var inst_104470 = cljs.core.pr_str.call(null,name);
var inst_104471 = ["Invalid collection name: ",inst_104470].join('');
var inst_104472 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_104473 = [(400),new cljs.core.Keyword("db","invalid-collection","db/invalid-collection",1742380218)];
var inst_104474 = cljs.core.PersistentHashMap.fromArrays(inst_104472,inst_104473);
var inst_104475 = cljs.core.ex_info.call(null,inst_104471,inst_104474);
var inst_104476 = (function(){throw inst_104475})();
var state_104482__$1 = state_104482;
var statearr_104489_104501 = state_104482__$1;
(statearr_104489_104501[(2)] = inst_104476);

(statearr_104489_104501[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104483 === (7))){
var inst_104478 = (state_104482[(2)]);
var state_104482__$1 = state_104482;
var statearr_104490_104502 = state_104482__$1;
(statearr_104490_104502[(2)] = inst_104478);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_104482__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104483 === (8))){
var inst_104467 = (state_104482[(2)]);
var inst_104468 = fluree.db.util.async.throw_err.call(null,inst_104467);
var state_104482__$1 = state_104482;
var statearr_104491_104503 = state_104482__$1;
(statearr_104491_104503[(2)] = inst_104468);

(statearr_104491_104503[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__99975__auto__ = null;
var fluree$db$query$range$state_machine__99975__auto____0 = (function (){
var statearr_104492 = [null,null,null,null,null,null,null,null];
(statearr_104492[(0)] = fluree$db$query$range$state_machine__99975__auto__);

(statearr_104492[(1)] = (1));

return statearr_104492;
});
var fluree$db$query$range$state_machine__99975__auto____1 = (function (state_104482){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_104482);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e104493){if((e104493 instanceof Object)){
var ex__99978__auto__ = e104493;
var statearr_104494_104504 = state_104482;
(statearr_104494_104504[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_104482);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e104493;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__104505 = state_104482;
state_104482 = G__104505;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__99975__auto__ = function(state_104482){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__99975__auto____1.call(this,state_104482);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__99975__auto____0;
fluree$db$query$range$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__99975__auto____1;
return fluree$db$query$range$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_104495 = f__100070__auto__.call(null);
(statearr_104495[(6)] = c__100069__auto__);

return statearr_104495;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.query.range.collection.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range._block_or_tx_collection = (function fluree$db$query$range$_block_or_tx_collection(db,opts){
return fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cljs.core._LT__EQ_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null),opts);
});
/**
 * Returns vector of transactions from a set of flakes.
 * Each transaction is a map with the following keys:
 * 1. db - the associated ledger
 * 2. tx - a map containing all transaction data in the original cmd
 * 3. nonce - the nonce
 * 4. auth - the authority that submitted the transaction
 * 5. expire - expiration
 */
fluree.db.query.range.txn_from_flakes = (function fluree$db$query$range$txn_from_flakes(flakes){
var G__104509 = flakes;
var vec__104510 = G__104509;
var seq__104511 = cljs.core.seq.call(null,vec__104510);
var first__104512 = cljs.core.first.call(null,seq__104511);
var seq__104511__$1 = cljs.core.next.call(null,seq__104511);
var flake_SINGLEQUOTE_ = first__104512;
var r = seq__104511__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__104509__$1 = G__104509;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__104519 = G__104509__$1;
var seq__104520 = cljs.core.seq.call(null,vec__104519);
var first__104521 = cljs.core.first.call(null,seq__104520);
var seq__104520__$1 = cljs.core.next.call(null,seq__104520);
var flake_SINGLEQUOTE___$1 = first__104521;
var r__$1 = seq__104520__$1;
var result_STAR___$2 = result_STAR___$1;
if((flake_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var obj = flake_SINGLEQUOTE___$1.o;
var cmd_map = (function (){try{return fluree.db.util.json.parse.call(null,obj);
}catch (e104523){var e = e104523;
return null;
}})();
var map__104522 = cmd_map;
var map__104522__$1 = (((((!((map__104522 == null))))?(((((map__104522.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__104522.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__104522):map__104522);
var type = cljs.core.get.call(null,map__104522__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var db = cljs.core.get.call(null,map__104522__$1,new cljs.core.Keyword(null,"db","db",993250759));
var tx = cljs.core.get.call(null,map__104522__$1,new cljs.core.Keyword(null,"tx","tx",466630418));
var nonce = cljs.core.get.call(null,map__104522__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var auth = cljs.core.get.call(null,map__104522__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.call(null,map__104522__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var G__104525 = r__$1;
var G__104526 = ((cljs.core._EQ_.call(null,type,"tx"))?cljs.core.conj.call(null,result_STAR___$2,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"tx","tx",466630418),tx,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"expire","expire",-70657108),expire], null)):result_STAR___$2);
G__104509__$1 = G__104525;
result_STAR___$1 = G__104526;
continue;
}
break;
}
});
/**
 * Returns block data as a map, with the following keys:
 *   1. block - block number
 *   2. t - fluree "time" since ledger creation
 *   3. sigs - List of transactor signatures that signed this block
 *   4. instant - instant this block was created, per the transactor.
 *   5. hash - hash of current block
 *   6. prev-hash - hash of previous block, if relevant
 *   7. flakes - list of flakes comprising block
 *   8. txn - list of transactions in block
 *   
 */
fluree.db.query.range.block_with_tx_data = (function fluree$db$query$range$block_with_tx_data(blocks){
var G__104535 = blocks;
var vec__104536 = G__104535;
var seq__104537 = cljs.core.seq.call(null,vec__104536);
var first__104538 = cljs.core.first.call(null,seq__104537);
var seq__104537__$1 = cljs.core.next.call(null,seq__104537);
var block_SINGLEQUOTE_ = first__104538;
var r = seq__104537__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__104535__$1 = G__104535;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__104544 = G__104535__$1;
var seq__104545 = cljs.core.seq.call(null,vec__104544);
var first__104546 = cljs.core.first.call(null,seq__104545);
var seq__104545__$1 = cljs.core.next.call(null,seq__104545);
var block_SINGLEQUOTE___$1 = first__104546;
var r__$1 = seq__104545__$1;
var result_STAR___$2 = result_STAR___$1;
if((block_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var map__104547 = block_SINGLEQUOTE___$1;
var map__104547__$1 = (((((!((map__104547 == null))))?(((((map__104547.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__104547.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__104547):map__104547);
var block = cljs.core.get.call(null,map__104547__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__104547__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.call(null,map__104547__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var prev_hash = cljs.core.some.call(null,((function (G__104535__$1,result_STAR___$1,map__104547,map__104547__$1,block,t,flakes,vec__104544,seq__104545,first__104546,seq__104545__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__104535,vec__104536,seq__104537,first__104538,seq__104537__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__104527_SHARP_){
if(cljs.core._EQ_.call(null,p1__104527_SHARP_.p,(2))){
return p1__104527_SHARP_.o;
} else {
return null;
}
});})(G__104535__$1,result_STAR___$1,map__104547,map__104547__$1,block,t,flakes,vec__104544,seq__104545,first__104546,seq__104545__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__104535,vec__104536,seq__104537,first__104538,seq__104537__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var hash = cljs.core.some.call(null,((function (G__104535__$1,result_STAR___$1,map__104547,map__104547__$1,block,t,flakes,prev_hash,vec__104544,seq__104545,first__104546,seq__104545__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__104535,vec__104536,seq__104537,first__104538,seq__104537__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__104528_SHARP_){
if(cljs.core._EQ_.call(null,p1__104528_SHARP_.p,(1))){
return p1__104528_SHARP_.o;
} else {
return null;
}
});})(G__104535__$1,result_STAR___$1,map__104547,map__104547__$1,block,t,flakes,prev_hash,vec__104544,seq__104545,first__104546,seq__104545__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__104535,vec__104536,seq__104537,first__104538,seq__104537__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var instant = cljs.core.some.call(null,((function (G__104535__$1,result_STAR___$1,map__104547,map__104547__$1,block,t,flakes,prev_hash,hash,vec__104544,seq__104545,first__104546,seq__104545__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__104535,vec__104536,seq__104537,first__104538,seq__104537__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__104529_SHARP_){
if(cljs.core._EQ_.call(null,p1__104529_SHARP_.p,(5))){
return p1__104529_SHARP_.o;
} else {
return null;
}
});})(G__104535__$1,result_STAR___$1,map__104547,map__104547__$1,block,t,flakes,prev_hash,hash,vec__104544,seq__104545,first__104546,seq__104545__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__104535,vec__104536,seq__104537,first__104538,seq__104537__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var sigs = cljs.core.some.call(null,((function (G__104535__$1,result_STAR___$1,map__104547,map__104547__$1,block,t,flakes,prev_hash,hash,instant,vec__104544,seq__104545,first__104546,seq__104545__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__104535,vec__104536,seq__104537,first__104538,seq__104537__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__104530_SHARP_){
if(cljs.core._EQ_.call(null,p1__104530_SHARP_.p,(7))){
return p1__104530_SHARP_.o;
} else {
return null;
}
});})(G__104535__$1,result_STAR___$1,map__104547,map__104547__$1,block,t,flakes,prev_hash,hash,instant,vec__104544,seq__104545,first__104546,seq__104545__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__104535,vec__104536,seq__104537,first__104538,seq__104537__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes = cljs.core.filter.call(null,((function (G__104535__$1,result_STAR___$1,map__104547,map__104547__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__104544,seq__104545,first__104546,seq__104545__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__104535,vec__104536,seq__104537,first__104538,seq__104537__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__104531_SHARP_){
return cljs.core._EQ_.call(null,p1__104531_SHARP_.p,(106));
});})(G__104535__$1,result_STAR___$1,map__104547,map__104547__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__104544,seq__104545,first__104546,seq__104545__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__104535,vec__104536,seq__104537,first__104538,seq__104537__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes_SINGLEQUOTE_ = fluree.db.query.range.txn_from_flakes.call(null,txn_flakes);
var G__104549 = r__$1;
var G__104550 = cljs.core.conj.call(null,result_STAR___$2,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"prev-hash","prev-hash",209337330),prev_hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"sigs","sigs",-1653119622),sigs,new cljs.core.Keyword(null,"flakes","flakes",1977895739),flakes,new cljs.core.Keyword(null,"txn","txn",-469204789),txn_flakes_SINGLEQUOTE_], null));
G__104535__$1 = G__104549;
result_STAR___$1 = G__104550;
continue;
}
break;
}
});
