// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');

/**
 * Can sit in a flake pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__110660 = null;
var G__110660__0 = (function (){
return xf.call(null);
});
var G__110660__1 = (function (result){
return xf.call(null,result);
});
var G__110660__2 = (function (result,flake){
cljs.core._vreset_BANG_.call(null,fuel,(cljs.core._deref.call(null,fuel) + (1)));

if(cljs.core.truth_((function (){var and__4115__auto__ = max_fuel;
if(cljs.core.truth_(and__4115__auto__)){
return (cljs.core.deref.call(null,fuel) > max_fuel);
} else {
return and__4115__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return xf.call(null,result,flake);
});
G__110660 = function(result,flake){
switch(arguments.length){
case 0:
return G__110660__0.call(this);
case 1:
return G__110660__1.call(this,result);
case 2:
return G__110660__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__110660.cljs$core$IFn$_invoke$arity$0 = G__110660__0;
G__110660.cljs$core$IFn$_invoke$arity$1 = G__110660__1;
G__110660.cljs$core$IFn$_invoke$arity$2 = G__110660__2;
return G__110660;
})()
});
});
/**
 * Can sit in a flake group pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Supply with a volatile!
 * 
 *   To get final count, just deref volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flakes_transducer = (function fluree$db$query$fql$fuel_flakes_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__110661 = null;
var G__110661__0 = (function (){
return xf.call(null);
});
var G__110661__1 = (function (result){
return xf.call(null,result);
});
var G__110661__2 = (function (result,flakes){
cljs.core._vreset_BANG_.call(null,fuel,(cljs.core._deref.call(null,fuel) + cljs.core.count.call(null,flakes)));

return xf.call(null,result,flakes);
});
G__110661 = function(result,flakes){
switch(arguments.length){
case 0:
return G__110661__0.call(this);
case 1:
return G__110661__1.call(this,result);
case 2:
return G__110661__2.call(this,result,flakes);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__110661.cljs$core$IFn$_invoke$arity$0 = G__110661__0;
G__110661.cljs$core$IFn$_invoke$arity$1 = G__110661__1;
G__110661.cljs$core$IFn$_invoke$arity$2 = G__110661__2;
return G__110661;
})()
});
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql.add_fuel = (function fluree$db$query$fql$add_fuel(fuel,n,max_fuel){
cljs.core._vreset_BANG_.call(null,fuel,(cljs.core._deref.call(null,fuel) + n));

if(cljs.core.truth_((function (){var and__4115__auto__ = max_fuel;
if(cljs.core.truth_(and__4115__auto__)){
return (cljs.core.deref.call(null,fuel) > max_fuel);
} else {
return and__4115__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
return null;
}
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql.wildcard_pred_spec = (function fluree$db$query$fql$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__4126__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config.call(null,db,p,compact_QMARK_);
cljs.core._vreset_BANG_.call(null,cache,cljs.core.assoc_in.call(null,cljs.core._deref.call(null,cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map));

return p_map;
}
});
fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare.call(null,clojure.string.upper_case.call(null,a),clojure.string.upper_case.call(null,b));
if(cljs.core._EQ_.call(null,res,(0))){
return ((-1) * cljs.core.compare.call(null,a,b));
} else {
return res;
}
} else {
return cljs.core.compare.call(null,a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql.sort_offset_and_limit_res = (function fluree$db$query$fql$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_.call(null,res)){
var G__110663 = res;
var G__110663__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.call(null,(function (p1__110662_SHARP_){
return cljs.core.get.call(null,p1__110662_SHARP_,sortPred);
}),fluree.db.query.fql.compare_fn,G__110663):G__110663);
var G__110663__$2 = ((cljs.core._EQ_.call(null,"DESC",sortOrder))?cljs.core.reverse.call(null,G__110663__$1):G__110663__$1);
var G__110663__$3 = (cljs.core.truth_(offset)?cljs.core.drop.call(null,offset,G__110663__$2):G__110663__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.call(null,limit,G__110663__$3);
} else {
return G__110663__$3;
}
} else {
return res;
}
});
fluree.db.query.fql.add_pred = (function fluree$db$query$fql$add_pred(var_args){
var G__110665 = arguments.length;
switch (G__110665) {
case 9:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_){
return fluree.db.query.fql.add_pred.call(null,db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_,offset_map){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_110964){
var state_val_110965 = (state_110964[(1)]);
if((state_val_110965 === (65))){
var state_110964__$1 = state_110964;
if(cljs.core.truth_(componentFollow_QMARK_)){
var statearr_110966_111119 = state_110964__$1;
(statearr_110966_111119[(1)] = (71));

} else {
var statearr_110967_111120 = state_110964__$1;
(statearr_110967_111120[(1)] = (72));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (70))){
var inst_110693 = (state_110964[(7)]);
var inst_110831 = (state_110964[(2)]);
var inst_110832 = fluree.db.util.async.throw_err.call(null,inst_110831);
var inst_110833 = cljs.core._deref.call(null,cache);
var inst_110834 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_110835 = flake.o;
var inst_110836 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_110693);
var inst_110837 = [inst_110835,inst_110836];
var inst_110838 = (new cljs.core.PersistentVector(null,2,(5),inst_110834,inst_110837,null));
var inst_110839 = cljs.core.assoc.call(null,inst_110833,inst_110838,inst_110832);
var inst_110840 = cljs.core._vreset_BANG_.call(null,cache,inst_110839);
var state_110964__$1 = (function (){var statearr_110968 = state_110964;
(statearr_110968[(8)] = inst_110840);

return statearr_110968;
})();
var statearr_110969_111121 = state_110964__$1;
(statearr_110969_111121[(2)] = inst_110832);

(statearr_110969_111121[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (62))){
var inst_110802 = (state_110964[(9)]);
var state_110964__$1 = state_110964;
var statearr_110970_111122 = state_110964__$1;
(statearr_110970_111122[(2)] = inst_110802);

(statearr_110970_111122[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (74))){
var inst_110693 = (state_110964[(7)]);
var inst_110852 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_110853 = flake.o;
var inst_110854 = [inst_110853];
var inst_110855 = (new cljs.core.PersistentVector(null,1,(5),inst_110852,inst_110854,null));
var inst_110856 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_110857 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(inst_110693);
var inst_110858 = [inst_110857];
var inst_110859 = cljs.core.PersistentHashMap.fromArrays(inst_110856,inst_110858);
var inst_110860 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_110855,inst_110859);
var state_110964__$1 = state_110964;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_110964__$1,(77),inst_110860);
} else {
if((state_val_110965 === (7))){
var inst_110680 = (state_110964[(2)]);
var state_110964__$1 = state_110964;
if(cljs.core.truth_(inst_110680)){
var statearr_110971_111123 = state_110964__$1;
(statearr_110971_111123[(1)] = (8));

} else {
var statearr_110972_111124 = state_110964__$1;
(statearr_110972_111124[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (59))){
var inst_110796 = (state_110964[(10)]);
var state_110964__$1 = state_110964;
var statearr_110973_111125 = state_110964__$1;
(statearr_110973_111125[(2)] = inst_110796);

(statearr_110973_111125[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (86))){
var inst_110881 = (state_110964[(11)]);
var state_110964__$1 = state_110964;
var statearr_110974_111126 = state_110964__$1;
(statearr_110974_111126[(2)] = inst_110881);

(statearr_110974_111126[(1)] = (87));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (20))){
var inst_110693 = (state_110964[(7)]);
var inst_110709 = inst_110693.cljs$lang$protocol_mask$partition0$;
var inst_110710 = (inst_110709 & (64));
var inst_110711 = inst_110693.cljs$core$ISeq$;
var inst_110712 = (cljs.core.PROTOCOL_SENTINEL === inst_110711);
var inst_110713 = ((inst_110710) || (inst_110712));
var state_110964__$1 = state_110964;
if(cljs.core.truth_(inst_110713)){
var statearr_110975_111127 = state_110964__$1;
(statearr_110975_111127[(1)] = (23));

} else {
var statearr_110976_111128 = state_110964__$1;
(statearr_110976_111128[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (72))){
var state_110964__$1 = state_110964;
var statearr_110977_111129 = state_110964__$1;
(statearr_110977_111129[(2)] = componentFollow_QMARK_);

(statearr_110977_111129[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (58))){
var inst_110796 = (state_110964[(10)]);
var inst_110798 = fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel);
var inst_110799 = cljs.core.sequence.call(null,inst_110798,inst_110796);
var state_110964__$1 = state_110964;
var statearr_110978_111130 = state_110964__$1;
(statearr_110978_111130[(2)] = inst_110799);

(statearr_110978_111130[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (60))){
var inst_110802 = (state_110964[(2)]);
var state_110964__$1 = (function (){var statearr_110979 = state_110964;
(statearr_110979[(9)] = inst_110802);

return statearr_110979;
})();
var statearr_110980_111131 = state_110964__$1;
(statearr_110980_111131[(1)] = (61));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (27))){
var inst_110693 = (state_110964[(7)]);
var state_110964__$1 = state_110964;
var statearr_110982_111132 = state_110964__$1;
(statearr_110982_111132[(2)] = inst_110693);

(statearr_110982_111132[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (1))){
var state_110964__$1 = state_110964;
var statearr_110983_111133 = state_110964__$1;
(statearr_110983_111133[(2)] = null);

(statearr_110983_111133[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (69))){
var inst_110817 = (state_110964[(12)]);
var inst_110842 = (state_110964[(2)]);
var inst_110843 = [inst_110842,offset_map];
var inst_110844 = (new cljs.core.PersistentVector(null,2,(5),inst_110817,inst_110843,null));
var state_110964__$1 = state_110964;
var statearr_110984_111134 = state_110964__$1;
(statearr_110984_111134[(2)] = inst_110844);

(statearr_110984_111134[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (101))){
var state_110964__$1 = state_110964;
var statearr_110985_111135 = state_110964__$1;
(statearr_110985_111135[(1)] = (103));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (24))){
var state_110964__$1 = state_110964;
var statearr_110987_111136 = state_110964__$1;
(statearr_110987_111136[(2)] = false);

(statearr_110987_111136[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (102))){
var inst_110958 = (state_110964[(2)]);
var state_110964__$1 = state_110964;
var statearr_110988_111137 = state_110964__$1;
(statearr_110988_111137[(2)] = inst_110958);

(statearr_110988_111137[(1)] = (99));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (55))){
var inst_110920 = (state_110964[(2)]);
var state_110964__$1 = state_110964;
var statearr_110989_111138 = state_110964__$1;
(statearr_110989_111138[(2)] = inst_110920);

(statearr_110989_111138[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (85))){
var inst_110730 = (state_110964[(13)]);
var inst_110704 = (state_110964[(14)]);
var inst_110693 = (state_110964[(7)]);
var inst_110729 = (state_110964[(15)]);
var inst_110725 = (state_110964[(16)]);
var inst_110881 = (state_110964[(11)]);
var inst_110863 = (state_110964[(17)]);
var inst_110731 = (state_110964[(18)]);
var inst_110726 = (state_110964[(19)]);
var inst_110728 = (state_110964[(20)]);
var inst_110727 = (state_110964[(21)]);
var inst_110687 = (state_110964[(22)]);
var inst_110883 = (function (){var G__110875 = inst_110881;
var p = inst_110731;
var pred_spec__$1 = inst_110687;
var orderBy = inst_110729;
var map__110670 = inst_110725;
var children = inst_110863;
var multi_QMARK_ = inst_110726;
var limit = inst_110728;
var offset = inst_110730;
var k = inst_110704;
var pred_spec_SINGLEQUOTE_ = inst_110693;
var ref_QMARK_ = inst_110727;
return (function (n){
return fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),true], null),n);
});
})();
var inst_110884 = inst_110883.call(null,inst_110881);
var state_110964__$1 = state_110964;
var statearr_110990_111139 = state_110964__$1;
(statearr_110990_111139[(2)] = inst_110884);

(statearr_110990_111139[(1)] = (87));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (39))){
var inst_110730 = (state_110964[(13)]);
var inst_110731 = (state_110964[(18)]);
var inst_110750 = (inst_110730 - (1));
var inst_110751 = cljs.core.assoc.call(null,offset_map,inst_110731,inst_110750);
var state_110964__$1 = state_110964;
var statearr_110991_111140 = state_110964__$1;
(statearr_110991_111140[(2)] = inst_110751);

(statearr_110991_111140[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (88))){
var inst_110897 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_110898 = ["_id"];
var inst_110899 = flake.o;
var inst_110900 = [inst_110899];
var inst_110901 = cljs.core.PersistentHashMap.fromArrays(inst_110898,inst_110900);
var inst_110902 = [inst_110901,offset_map];
var inst_110903 = (new cljs.core.PersistentVector(null,2,(5),inst_110897,inst_110902,null));
var state_110964__$1 = state_110964;
var statearr_110992_111141 = state_110964__$1;
(statearr_110992_111141[(2)] = inst_110903);

(statearr_110992_111141[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (46))){
var inst_110922 = (state_110964[(2)]);
var state_110964__$1 = state_110964;
var statearr_110993_111142 = state_110964__$1;
(statearr_110993_111142[(2)] = inst_110922);

(statearr_110993_111142[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (4))){
var inst_110674 = (state_110964[(23)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_110964,(3),Error,null,(2));
var inst_110674__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_110964__$1 = (function (){var statearr_110994 = state_110964;
(statearr_110994[(23)] = inst_110674__$1);

return statearr_110994;
})();
if(cljs.core.truth_(inst_110674__$1)){
var statearr_110995_111143 = state_110964__$1;
(statearr_110995_111143[(1)] = (5));

} else {
var statearr_110996_111144 = state_110964__$1;
(statearr_110996_111144[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (77))){
var inst_110863 = (state_110964[(17)]);
var inst_110862 = (state_110964[(2)]);
var inst_110863__$1 = fluree.db.util.async.throw_err.call(null,inst_110862);
var inst_110864 = cljs.core.empty_QMARK_.call(null,inst_110863__$1);
var state_110964__$1 = (function (){var statearr_110997 = state_110964;
(statearr_110997[(17)] = inst_110863__$1);

return statearr_110997;
})();
if(inst_110864){
var statearr_110998_111145 = state_110964__$1;
(statearr_110998_111145[(1)] = (78));

} else {
var statearr_110999_111146 = state_110964__$1;
(statearr_110999_111146[(1)] = (79));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (95))){
var state_110964__$1 = state_110964;
var statearr_111000_111147 = state_110964__$1;
(statearr_111000_111147[(2)] = false);

(statearr_111000_111147[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (54))){
var inst_110693 = (state_110964[(7)]);
var inst_110815 = new cljs.core.Keyword(null,"tag?","tag?",1714008252).cljs$core$IFn$_invoke$arity$1(inst_110693);
var state_110964__$1 = state_110964;
if(cljs.core.truth_(inst_110815)){
var statearr_111001_111148 = state_110964__$1;
(statearr_111001_111148[(1)] = (64));

} else {
var statearr_111002_111149 = state_110964__$1;
(statearr_111002_111149[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (92))){
var state_110964__$1 = state_110964;
var statearr_111003_111150 = state_110964__$1;
(statearr_111003_111150[(2)] = null);

(statearr_111003_111150[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (104))){
var state_110964__$1 = state_110964;
var statearr_111004_111151 = state_110964__$1;
(statearr_111004_111151[(2)] = null);

(statearr_111004_111151[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (15))){
var inst_110693 = (state_110964[(7)]);
var inst_110697 = (state_110964[(24)]);
var inst_110697__$1 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_110693);
var state_110964__$1 = (function (){var statearr_111005 = state_110964;
(statearr_111005[(24)] = inst_110697__$1);

return statearr_111005;
})();
if(cljs.core.truth_(inst_110697__$1)){
var statearr_111006_111152 = state_110964__$1;
(statearr_111006_111152[(1)] = (17));

} else {
var statearr_111007_111153 = state_110964__$1;
(statearr_111007_111153[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (48))){
var state_110964__$1 = state_110964;
var statearr_111008_111154 = state_110964__$1;
(statearr_111008_111154[(2)] = false);

(statearr_111008_111154[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (50))){
var inst_110773 = (state_110964[(25)]);
var state_110964__$1 = state_110964;
var statearr_111009_111155 = state_110964__$1;
(statearr_111009_111155[(2)] = inst_110773);

(statearr_111009_111155[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (75))){
var inst_110727 = (state_110964[(21)]);
var state_110964__$1 = state_110964;
if(cljs.core.truth_(inst_110727)){
var statearr_111010_111156 = state_110964__$1;
(statearr_111010_111156[(1)] = (88));

} else {
var statearr_111011_111157 = state_110964__$1;
(statearr_111011_111157[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (99))){
var inst_110960 = (state_110964[(2)]);
var state_110964__$1 = state_110964;
var statearr_111012_111158 = state_110964__$1;
(statearr_111012_111158[(2)] = inst_110960);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_110964__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (21))){
var state_110964__$1 = state_110964;
var statearr_111013_111159 = state_110964__$1;
(statearr_111013_111159[(2)] = false);

(statearr_111013_111159[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (31))){
var inst_110743 = (state_110964[(2)]);
var state_110964__$1 = state_110964;
if(cljs.core.truth_(inst_110743)){
var statearr_111014_111160 = state_110964__$1;
(statearr_111014_111160[(1)] = (35));

} else {
var statearr_111015_111161 = state_110964__$1;
(statearr_111015_111161[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (32))){
var inst_110730 = (state_110964[(13)]);
var inst_110731 = (state_110964[(18)]);
var inst_110734 = cljs.core.not_EQ_.call(null,(0),inst_110730);
var inst_110735 = cljs.core.get.call(null,offset_map,inst_110731);
var inst_110736 = cljs.core.not_EQ_.call(null,(0),inst_110735);
var inst_110737 = ((inst_110734) && (inst_110736));
var state_110964__$1 = state_110964;
var statearr_111016_111162 = state_110964__$1;
(statearr_111016_111162[(2)] = inst_110737);

(statearr_111016_111162[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (40))){
var inst_110745 = (state_110964[(26)]);
var inst_110753 = (state_110964[(2)]);
var inst_110754 = [null,inst_110753];
var inst_110755 = (new cljs.core.PersistentVector(null,2,(5),inst_110745,inst_110754,null));
var state_110964__$1 = state_110964;
var statearr_111017_111163 = state_110964__$1;
(statearr_111017_111163[(2)] = inst_110755);

(statearr_111017_111163[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (91))){
var inst_110906 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_110907 = flake.o;
var inst_110908 = [inst_110907,offset_map];
var inst_110909 = (new cljs.core.PersistentVector(null,2,(5),inst_110906,inst_110908,null));
var state_110964__$1 = state_110964;
var statearr_111018_111164 = state_110964__$1;
(statearr_111018_111164[(2)] = inst_110909);

(statearr_111018_111164[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (56))){
var inst_110787 = (state_110964[(27)]);
var inst_110810 = (state_110964[(2)]);
var inst_110811 = fluree.db.util.async.throw_err.call(null,inst_110810);
var inst_110812 = [inst_110811,offset_map];
var inst_110813 = (new cljs.core.PersistentVector(null,2,(5),inst_110787,inst_110812,null));
var state_110964__$1 = state_110964;
var statearr_111019_111165 = state_110964__$1;
(statearr_111019_111165[(2)] = inst_110813);

(statearr_111019_111165[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (33))){
var inst_110730 = (state_110964[(13)]);
var state_110964__$1 = state_110964;
var statearr_111020_111166 = state_110964__$1;
(statearr_111020_111166[(2)] = inst_110730);

(statearr_111020_111166[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (13))){
var inst_110693 = (state_110964[(7)]);
var inst_110694 = (state_110964[(28)]);
var inst_110693__$1 = (state_110964[(2)]);
var inst_110694__$1 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_110693__$1);
var state_110964__$1 = (function (){var statearr_111021 = state_110964;
(statearr_111021[(7)] = inst_110693__$1);

(statearr_111021[(28)] = inst_110694__$1);

return statearr_111021;
})();
if(cljs.core.truth_(inst_110694__$1)){
var statearr_111022_111167 = state_110964__$1;
(statearr_111022_111167[(1)] = (14));

} else {
var statearr_111023_111168 = state_110964__$1;
(statearr_111023_111168[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (22))){
var inst_110720 = (state_110964[(2)]);
var state_110964__$1 = state_110964;
if(cljs.core.truth_(inst_110720)){
var statearr_111024_111169 = state_110964__$1;
(statearr_111024_111169[(1)] = (26));

} else {
var statearr_111025_111170 = state_110964__$1;
(statearr_111025_111170[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (90))){
var inst_110914 = (state_110964[(2)]);
var state_110964__$1 = state_110964;
var statearr_111026_111171 = state_110964__$1;
(statearr_111026_111171[(2)] = inst_110914);

(statearr_111026_111171[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (36))){
var inst_110726 = (state_110964[(19)]);
var state_110964__$1 = state_110964;
if(cljs.core.truth_(inst_110726)){
var statearr_111027_111172 = state_110964__$1;
(statearr_111027_111172[(1)] = (41));

} else {
var statearr_111028_111173 = state_110964__$1;
(statearr_111028_111173[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (41))){
var inst_110704 = (state_110964[(14)]);
var inst_110729 = (state_110964[(15)]);
var inst_110728 = (state_110964[(20)]);
var inst_110758 = cljs.core.not.call(null,inst_110729);
var inst_110759 = cljs.core.get.call(null,acc,inst_110704);
var inst_110760 = cljs.core.count.call(null,inst_110759);
var inst_110761 = (inst_110760 >= inst_110728);
var inst_110762 = ((inst_110758) && (inst_110761));
var state_110964__$1 = state_110964;
var statearr_111029_111174 = state_110964__$1;
(statearr_111029_111174[(2)] = inst_110762);

(statearr_111029_111174[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (89))){
var state_110964__$1 = state_110964;
var statearr_111030_111175 = state_110964__$1;
(statearr_111030_111175[(1)] = (91));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (100))){
var inst_110704 = (state_110964[(14)]);
var inst_110926 = (state_110964[(29)]);
var inst_110925 = (state_110964[(30)]);
var inst_110945 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_110946 = cljs.core.assoc.call(null,acc,inst_110704,inst_110925);
var inst_110947 = [inst_110946,inst_110926];
var inst_110948 = (new cljs.core.PersistentVector(null,2,(5),inst_110945,inst_110947,null));
var state_110964__$1 = state_110964;
var statearr_111032_111176 = state_110964__$1;
(statearr_111032_111176[(2)] = inst_110948);

(statearr_111032_111176[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (43))){
var inst_110765 = (state_110964[(2)]);
var state_110964__$1 = state_110964;
if(cljs.core.truth_(inst_110765)){
var statearr_111033_111177 = state_110964__$1;
(statearr_111033_111177[(1)] = (44));

} else {
var statearr_111034_111178 = state_110964__$1;
(statearr_111034_111178[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (61))){
var inst_110730 = (state_110964[(13)]);
var inst_110786 = (state_110964[(31)]);
var inst_110802 = (state_110964[(9)]);
var inst_110704 = (state_110964[(14)]);
var inst_110693 = (state_110964[(7)]);
var inst_110729 = (state_110964[(15)]);
var inst_110725 = (state_110964[(16)]);
var inst_110731 = (state_110964[(18)]);
var inst_110726 = (state_110964[(19)]);
var inst_110728 = (state_110964[(20)]);
var inst_110727 = (state_110964[(21)]);
var inst_110687 = (state_110964[(22)]);
var inst_110804 = (function (){var p = inst_110731;
var pred_spec__$1 = inst_110687;
var orderBy = inst_110729;
var map__110670 = inst_110725;
var nested_select_spec = inst_110786;
var multi_QMARK_ = inst_110726;
var limit = inst_110728;
var offset = inst_110730;
var k = inst_110704;
var G__110788 = inst_110802;
var pred_spec_SINGLEQUOTE_ = inst_110693;
var ref_QMARK_ = inst_110727;
return (function (n){
return fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,nested_select_spec,n);
});
})();
var inst_110805 = inst_110804.call(null,inst_110802);
var state_110964__$1 = state_110964;
var statearr_111035_111179 = state_110964__$1;
(statearr_111035_111179[(2)] = inst_110805);

(statearr_111035_111179[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (29))){
var inst_110730 = (state_110964[(13)]);
var state_110964__$1 = state_110964;
if(cljs.core.truth_(inst_110730)){
var statearr_111036_111180 = state_110964__$1;
(statearr_111036_111180[(1)] = (32));

} else {
var statearr_111037_111181 = state_110964__$1;
(statearr_111037_111181[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (44))){
var inst_110767 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_110768 = [null,offset_map];
var inst_110769 = (new cljs.core.PersistentVector(null,2,(5),inst_110767,inst_110768,null));
var state_110964__$1 = state_110964;
var statearr_111038_111182 = state_110964__$1;
(statearr_111038_111182[(2)] = inst_110769);

(statearr_111038_111182[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (93))){
var inst_110912 = (state_110964[(2)]);
var state_110964__$1 = state_110964;
var statearr_111039_111183 = state_110964__$1;
(statearr_111039_111183[(2)] = inst_110912);

(statearr_111039_111183[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (6))){
var inst_110674 = (state_110964[(23)]);
var state_110964__$1 = state_110964;
var statearr_111040_111184 = state_110964__$1;
(statearr_111040_111184[(2)] = inst_110674);

(statearr_111040_111184[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (28))){
var inst_110725 = (state_110964[(16)]);
var inst_110726 = (state_110964[(19)]);
var inst_110725__$1 = (state_110964[(2)]);
var inst_110726__$1 = cljs.core.get.call(null,inst_110725__$1,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_110727 = cljs.core.get.call(null,inst_110725__$1,new cljs.core.Keyword(null,"ref?","ref?",1932693720));
var inst_110728 = cljs.core.get.call(null,inst_110725__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_110729 = cljs.core.get.call(null,inst_110725__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_110730 = cljs.core.get.call(null,inst_110725__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_110731 = cljs.core.get.call(null,inst_110725__$1,new cljs.core.Keyword(null,"p","p",151049309));
var state_110964__$1 = (function (){var statearr_111041 = state_110964;
(statearr_111041[(13)] = inst_110730);

(statearr_111041[(15)] = inst_110729);

(statearr_111041[(16)] = inst_110725__$1);

(statearr_111041[(18)] = inst_110731);

(statearr_111041[(19)] = inst_110726__$1);

(statearr_111041[(20)] = inst_110728);

(statearr_111041[(21)] = inst_110727);

return statearr_111041;
})();
if(cljs.core.truth_(inst_110726__$1)){
var statearr_111042_111185 = state_110964__$1;
(statearr_111042_111185[(1)] = (29));

} else {
var statearr_111043_111186 = state_110964__$1;
(statearr_111043_111186[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (64))){
var inst_110693 = (state_110964[(7)]);
var inst_110824 = (state_110964[(32)]);
var inst_110817 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_110818 = cljs.core.deref.call(null,cache);
var inst_110819 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_110820 = flake.o;
var inst_110821 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_110693);
var inst_110822 = [inst_110820,inst_110821];
var inst_110823 = (new cljs.core.PersistentVector(null,2,(5),inst_110819,inst_110822,null));
var inst_110824__$1 = cljs.core.get.call(null,inst_110818,inst_110823);
var state_110964__$1 = (function (){var statearr_111044 = state_110964;
(statearr_111044[(12)] = inst_110817);

(statearr_111044[(32)] = inst_110824__$1);

return statearr_111044;
})();
if(cljs.core.truth_(inst_110824__$1)){
var statearr_111045_111187 = state_110964__$1;
(statearr_111045_111187[(1)] = (67));

} else {
var statearr_111046_111188 = state_110964__$1;
(statearr_111046_111188[(1)] = (68));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (103))){
var inst_110926 = (state_110964[(29)]);
var inst_110951 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_110952 = [acc,inst_110926];
var inst_110953 = (new cljs.core.PersistentVector(null,2,(5),inst_110951,inst_110952,null));
var state_110964__$1 = state_110964;
var statearr_111047_111189 = state_110964__$1;
(statearr_111047_111189[(2)] = inst_110953);

(statearr_111047_111189[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (51))){
var inst_110693 = (state_110964[(7)]);
var inst_110776 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_110693);
var state_110964__$1 = state_110964;
var statearr_111048_111190 = state_110964__$1;
(statearr_111048_111190[(2)] = inst_110776);

(statearr_111048_111190[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (25))){
var inst_110717 = (state_110964[(2)]);
var state_110964__$1 = state_110964;
var statearr_111049_111191 = state_110964__$1;
(statearr_111049_111191[(2)] = inst_110717);

(statearr_111049_111191[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (34))){
var inst_110740 = (state_110964[(2)]);
var state_110964__$1 = state_110964;
var statearr_111050_111192 = state_110964__$1;
(statearr_111050_111192[(2)] = inst_110740);

(statearr_111050_111192[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (17))){
var inst_110697 = (state_110964[(24)]);
var state_110964__$1 = state_110964;
var statearr_111051_111193 = state_110964__$1;
(statearr_111051_111193[(2)] = inst_110697);

(statearr_111051_111193[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (3))){
var inst_110666 = (state_110964[(2)]);
var state_110964__$1 = state_110964;
var statearr_111052_111194 = state_110964__$1;
(statearr_111052_111194[(2)] = inst_110666);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_110964__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (12))){
var inst_110687 = (state_110964[(22)]);
var inst_110691 = cljs.core.assoc.call(null,inst_110687,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),componentFollow_QMARK_);
var state_110964__$1 = state_110964;
var statearr_111053_111195 = state_110964__$1;
(statearr_111053_111195[(2)] = inst_110691);

(statearr_111053_111195[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (2))){
var inst_110962 = (state_110964[(2)]);
var state_110964__$1 = state_110964;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_110964__$1,inst_110962);
} else {
if((state_val_110965 === (66))){
var inst_110918 = (state_110964[(2)]);
var state_110964__$1 = state_110964;
var statearr_111054_111196 = state_110964__$1;
(statearr_111054_111196[(2)] = inst_110918);

(statearr_111054_111196[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (23))){
var state_110964__$1 = state_110964;
var statearr_111055_111197 = state_110964__$1;
(statearr_111055_111197[(2)] = true);

(statearr_111055_111197[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (47))){
var inst_110693 = (state_110964[(7)]);
var inst_110773 = (state_110964[(25)]);
var inst_110773__$1 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_110693);
var state_110964__$1 = (function (){var statearr_111056 = state_110964;
(statearr_111056[(25)] = inst_110773__$1);

return statearr_111056;
})();
if(cljs.core.truth_(inst_110773__$1)){
var statearr_111057_111198 = state_110964__$1;
(statearr_111057_111198[(1)] = (50));

} else {
var statearr_111058_111199 = state_110964__$1;
(statearr_111058_111199[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (35))){
var inst_110731 = (state_110964[(18)]);
var inst_110745 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_110746 = cljs.core.get.call(null,offset_map,inst_110731);
var state_110964__$1 = (function (){var statearr_111059 = state_110964;
(statearr_111059[(26)] = inst_110745);

return statearr_111059;
})();
if(cljs.core.truth_(inst_110746)){
var statearr_111060_111200 = state_110964__$1;
(statearr_111060_111200[(1)] = (38));

} else {
var statearr_111061_111201 = state_110964__$1;
(statearr_111061_111201[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (82))){
var inst_110863 = (state_110964[(17)]);
var inst_110877 = fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel);
var inst_110878 = cljs.core.sequence.call(null,inst_110877,inst_110863);
var state_110964__$1 = state_110964;
var statearr_111062_111202 = state_110964__$1;
(statearr_111062_111202[(2)] = inst_110878);

(statearr_111062_111202[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (76))){
var inst_110916 = (state_110964[(2)]);
var state_110964__$1 = state_110964;
var statearr_111063_111203 = state_110964__$1;
(statearr_111063_111203[(2)] = inst_110916);

(statearr_111063_111203[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (97))){
var inst_110704 = (state_110964[(14)]);
var inst_110926 = (state_110964[(29)]);
var inst_110925 = (state_110964[(30)]);
var inst_110934 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_110935 = cljs.core.PersistentVector.EMPTY;
var inst_110936 = cljs.core.get.call(null,acc,inst_110704,inst_110935);
var inst_110937 = cljs.core.conj.call(null,inst_110936,inst_110925);
var inst_110938 = cljs.core.assoc.call(null,acc,inst_110704,inst_110937);
var inst_110939 = [inst_110938,inst_110926];
var inst_110940 = (new cljs.core.PersistentVector(null,2,(5),inst_110934,inst_110939,null));
var state_110964__$1 = state_110964;
var statearr_111064_111204 = state_110964__$1;
(statearr_111064_111204[(2)] = inst_110940);

(statearr_111064_111204[(1)] = (99));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (19))){
var inst_110702 = (state_110964[(2)]);
var state_110964__$1 = state_110964;
var statearr_111065_111205 = state_110964__$1;
(statearr_111065_111205[(2)] = inst_110702);

(statearr_111065_111205[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (57))){
var inst_110795 = (state_110964[(2)]);
var inst_110796 = fluree.db.util.async.throw_err.call(null,inst_110795);
var state_110964__$1 = (function (){var statearr_111066 = state_110964;
(statearr_111066[(10)] = inst_110796);

return statearr_111066;
})();
if(cljs.core.truth_(fuel)){
var statearr_111067_111206 = state_110964__$1;
(statearr_111067_111206[(1)] = (58));

} else {
var statearr_111068_111207 = state_110964__$1;
(statearr_111068_111207[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (68))){
var inst_110693 = (state_110964[(7)]);
var inst_110827 = flake.o;
var inst_110828 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_110693);
var inst_110829 = fluree.db.dbproto._tag.call(null,db,inst_110827,inst_110828);
var state_110964__$1 = state_110964;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_110964__$1,(70),inst_110829);
} else {
if((state_val_110965 === (11))){
var inst_110687 = (state_110964[(22)]);
var state_110964__$1 = state_110964;
var statearr_111069_111208 = state_110964__$1;
(statearr_111069_111208[(2)] = inst_110687);

(statearr_111069_111208[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (9))){
var state_110964__$1 = state_110964;
var statearr_111070_111209 = state_110964__$1;
(statearr_111070_111209[(2)] = pred_spec);

(statearr_111070_111209[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (5))){
var inst_110676 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_110677 = (inst_110676 == null);
var state_110964__$1 = state_110964;
var statearr_111071_111210 = state_110964__$1;
(statearr_111071_111210[(2)] = inst_110677);

(statearr_111071_111210[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (83))){
var inst_110863 = (state_110964[(17)]);
var state_110964__$1 = state_110964;
var statearr_111072_111211 = state_110964__$1;
(statearr_111072_111211[(2)] = inst_110863);

(statearr_111072_111211[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (14))){
var inst_110694 = (state_110964[(28)]);
var state_110964__$1 = state_110964;
var statearr_111073_111212 = state_110964__$1;
(statearr_111073_111212[(2)] = inst_110694);

(statearr_111073_111212[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (45))){
var inst_110771 = cljs.core.not.call(null,recur_QMARK_);
var state_110964__$1 = state_110964;
if(inst_110771){
var statearr_111074_111213 = state_110964__$1;
(statearr_111074_111213[(1)] = (47));

} else {
var statearr_111075_111214 = state_110964__$1;
(statearr_111075_111214[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (53))){
var inst_110693 = (state_110964[(7)]);
var inst_110783 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_110784 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_110785 = (new cljs.core.PersistentVector(null,3,(5),inst_110783,inst_110784,null));
var inst_110786 = cljs.core.select_keys.call(null,inst_110693,inst_110785);
var inst_110787 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_110789 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_110790 = flake.o;
var inst_110791 = [inst_110790];
var inst_110792 = (new cljs.core.PersistentVector(null,1,(5),inst_110789,inst_110791,null));
var inst_110793 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_110792);
var state_110964__$1 = (function (){var statearr_111076 = state_110964;
(statearr_111076[(31)] = inst_110786);

(statearr_111076[(27)] = inst_110787);

return statearr_111076;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_110964__$1,(57),inst_110793);
} else {
if((state_val_110965 === (78))){
var inst_110866 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_110867 = ["_id"];
var inst_110868 = flake.o;
var inst_110869 = [inst_110868];
var inst_110870 = cljs.core.PersistentHashMap.fromArrays(inst_110867,inst_110869);
var inst_110871 = [inst_110870,offset_map];
var inst_110872 = (new cljs.core.PersistentVector(null,2,(5),inst_110866,inst_110871,null));
var state_110964__$1 = state_110964;
var statearr_111077_111215 = state_110964__$1;
(statearr_111077_111215[(2)] = inst_110872);

(statearr_111077_111215[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (26))){
var inst_110693 = (state_110964[(7)]);
var inst_110722 = cljs.core.apply.call(null,cljs.core.hash_map,inst_110693);
var state_110964__$1 = state_110964;
var statearr_111078_111216 = state_110964__$1;
(statearr_111078_111216[(2)] = inst_110722);

(statearr_111078_111216[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (16))){
var inst_110693 = (state_110964[(7)]);
var inst_110704 = (state_110964[(2)]);
var inst_110706 = (inst_110693 == null);
var inst_110707 = cljs.core.not.call(null,inst_110706);
var state_110964__$1 = (function (){var statearr_111079 = state_110964;
(statearr_111079[(14)] = inst_110704);

return statearr_111079;
})();
if(inst_110707){
var statearr_111080_111217 = state_110964__$1;
(statearr_111080_111217[(1)] = (20));

} else {
var statearr_111081_111218 = state_110964__$1;
(statearr_111081_111218[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (81))){
var inst_110874 = (state_110964[(33)]);
var inst_110889 = (state_110964[(2)]);
var inst_110890 = fluree.db.util.async.throw_err.call(null,inst_110889);
var inst_110891 = [inst_110890,offset_map];
var inst_110892 = (new cljs.core.PersistentVector(null,2,(5),inst_110874,inst_110891,null));
var state_110964__$1 = state_110964;
var statearr_111082_111219 = state_110964__$1;
(statearr_111082_111219[(2)] = inst_110892);

(statearr_111082_111219[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (79))){
var inst_110874 = cljs.core.PersistentVector.EMPTY_NODE;
var state_110964__$1 = (function (){var statearr_111083 = state_110964;
(statearr_111083[(33)] = inst_110874);

return statearr_111083;
})();
if(cljs.core.truth_(fuel)){
var statearr_111084_111220 = state_110964__$1;
(statearr_111084_111220[(1)] = (82));

} else {
var statearr_111085_111221 = state_110964__$1;
(statearr_111085_111221[(1)] = (83));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (38))){
var inst_110731 = (state_110964[(18)]);
var inst_110748 = cljs.core.update.call(null,offset_map,inst_110731,cljs.core.dec);
var state_110964__$1 = state_110964;
var statearr_111086_111222 = state_110964__$1;
(statearr_111086_111222[(2)] = inst_110748);

(statearr_111086_111222[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (98))){
var inst_110925 = (state_110964[(30)]);
var inst_110942 = (inst_110925 == null);
var inst_110943 = cljs.core.not.call(null,inst_110942);
var state_110964__$1 = state_110964;
if(inst_110943){
var statearr_111087_111223 = state_110964__$1;
(statearr_111087_111223[(1)] = (100));

} else {
var statearr_111088_111224 = state_110964__$1;
(statearr_111088_111224[(1)] = (101));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (87))){
var inst_110887 = (state_110964[(2)]);
var state_110964__$1 = state_110964;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_110964__$1,(81),inst_110887);
} else {
if((state_val_110965 === (30))){
var inst_110726 = (state_110964[(19)]);
var state_110964__$1 = state_110964;
var statearr_111089_111225 = state_110964__$1;
(statearr_111089_111225[(2)] = inst_110726);

(statearr_111089_111225[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (73))){
var inst_110850 = (state_110964[(2)]);
var state_110964__$1 = state_110964;
if(cljs.core.truth_(inst_110850)){
var statearr_111090_111226 = state_110964__$1;
(statearr_111090_111226[(1)] = (74));

} else {
var statearr_111091_111227 = state_110964__$1;
(statearr_111091_111227[(1)] = (75));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (96))){
var inst_110932 = (state_110964[(2)]);
var state_110964__$1 = state_110964;
if(cljs.core.truth_(inst_110932)){
var statearr_111092_111228 = state_110964__$1;
(statearr_111092_111228[(1)] = (97));

} else {
var statearr_111093_111229 = state_110964__$1;
(statearr_111093_111229[(1)] = (98));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (10))){
var inst_110687 = (state_110964[(22)]);
var inst_110687__$1 = (state_110964[(2)]);
var inst_110688 = cljs.core.contains_QMARK_.call(null,inst_110687__$1,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651));
var state_110964__$1 = (function (){var statearr_111094 = state_110964;
(statearr_111094[(22)] = inst_110687__$1);

return statearr_111094;
})();
if(inst_110688){
var statearr_111095_111230 = state_110964__$1;
(statearr_111095_111230[(1)] = (11));

} else {
var statearr_111096_111231 = state_110964__$1;
(statearr_111096_111231[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (18))){
var inst_110693 = (state_110964[(7)]);
var inst_110700 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_110693);
var state_110964__$1 = state_110964;
var statearr_111097_111232 = state_110964__$1;
(statearr_111097_111232[(2)] = inst_110700);

(statearr_111097_111232[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (105))){
var inst_110956 = (state_110964[(2)]);
var state_110964__$1 = state_110964;
var statearr_111098_111233 = state_110964__$1;
(statearr_111098_111233[(2)] = inst_110956);

(statearr_111098_111233[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (52))){
var inst_110778 = (state_110964[(2)]);
var state_110964__$1 = state_110964;
var statearr_111099_111234 = state_110964__$1;
(statearr_111099_111234[(2)] = inst_110778);

(statearr_111099_111234[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (67))){
var inst_110824 = (state_110964[(32)]);
var state_110964__$1 = state_110964;
var statearr_111100_111235 = state_110964__$1;
(statearr_111100_111235[(2)] = inst_110824);

(statearr_111100_111235[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (71))){
var inst_110693 = (state_110964[(7)]);
var inst_110847 = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(inst_110693);
var state_110964__$1 = state_110964;
var statearr_111101_111236 = state_110964__$1;
(statearr_111101_111236[(2)] = inst_110847);

(statearr_111101_111236[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (42))){
var inst_110726 = (state_110964[(19)]);
var state_110964__$1 = state_110964;
var statearr_111102_111237 = state_110964__$1;
(statearr_111102_111237[(2)] = inst_110726);

(statearr_111102_111237[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (80))){
var inst_110894 = (state_110964[(2)]);
var state_110964__$1 = state_110964;
var statearr_111103_111238 = state_110964__$1;
(statearr_111103_111238[(2)] = inst_110894);

(statearr_111103_111238[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (37))){
var inst_110925 = (state_110964[(30)]);
var inst_110924 = (state_110964[(2)]);
var inst_110925__$1 = cljs.core.nth.call(null,inst_110924,(0),null);
var inst_110926 = cljs.core.nth.call(null,inst_110924,(1),null);
var inst_110927 = (inst_110925__$1 == null);
var inst_110928 = cljs.core.not.call(null,inst_110927);
var state_110964__$1 = (function (){var statearr_111104 = state_110964;
(statearr_111104[(29)] = inst_110926);

(statearr_111104[(30)] = inst_110925__$1);

return statearr_111104;
})();
if(inst_110928){
var statearr_111105_111239 = state_110964__$1;
(statearr_111105_111239[(1)] = (94));

} else {
var statearr_111106_111240 = state_110964__$1;
(statearr_111106_111240[(1)] = (95));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (63))){
var inst_110808 = (state_110964[(2)]);
var state_110964__$1 = state_110964;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_110964__$1,(56),inst_110808);
} else {
if((state_val_110965 === (94))){
var inst_110726 = (state_110964[(19)]);
var state_110964__$1 = state_110964;
var statearr_111107_111241 = state_110964__$1;
(statearr_111107_111241[(2)] = inst_110726);

(statearr_111107_111241[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (8))){
var inst_110682 = flake.p;
var inst_110683 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_110684 = fluree.db.query.fql.wildcard_pred_spec.call(null,db,cache,inst_110682,inst_110683);
var state_110964__$1 = state_110964;
var statearr_111108_111242 = state_110964__$1;
(statearr_111108_111242[(2)] = inst_110684);

(statearr_111108_111242[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (49))){
var inst_110781 = (state_110964[(2)]);
var state_110964__$1 = state_110964;
if(cljs.core.truth_(inst_110781)){
var statearr_111109_111243 = state_110964__$1;
(statearr_111109_111243[(1)] = (53));

} else {
var statearr_111110_111244 = state_110964__$1;
(statearr_111110_111244[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110965 === (84))){
var inst_110881 = (state_110964[(2)]);
var state_110964__$1 = (function (){var statearr_111111 = state_110964;
(statearr_111111[(11)] = inst_110881);

return statearr_111111;
})();
var statearr_111112_111245 = state_110964__$1;
(statearr_111112_111245[(1)] = (85));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__99975__auto__ = null;
var fluree$db$query$fql$state_machine__99975__auto____0 = (function (){
var statearr_111114 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_111114[(0)] = fluree$db$query$fql$state_machine__99975__auto__);

(statearr_111114[(1)] = (1));

return statearr_111114;
});
var fluree$db$query$fql$state_machine__99975__auto____1 = (function (state_110964){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_110964);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e111115){if((e111115 instanceof Object)){
var ex__99978__auto__ = e111115;
var statearr_111116_111246 = state_110964;
(statearr_111116_111246[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_110964);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e111115;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__111247 = state_110964;
state_110964 = G__111247;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__99975__auto__ = function(state_110964){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__99975__auto____1.call(this,state_110964);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__99975__auto____0;
fluree$db$query$fql$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__99975__auto____1;
return fluree$db$query$fql$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_111117 = f__100070__auto__.call(null);
(statearr_111117[(6)] = c__100069__auto__);

return statearr_111117;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.query.fql.add_pred.cljs$lang$maxFixedArity = 10);

/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql.full_select_spec = (function fluree$db$query$fql$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid.call(null,subject_id);
var or__4126__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec.call(null,db,coll_id,cljs.core.get_in.call(null,base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null)));
var updated_spec = cljs.core.update.call(null,base_pred_spec,new cljs.core.Keyword(null,"select","select",1147833503),(function (sel){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,sel,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),cljs.core.merge.call(null,lookup_specs,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(sel))),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767));
}));
cljs.core._vreset_BANG_.call(null,cache,cljs.core.assoc.call(null,cljs.core._deref.call(null,cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec));

return updated_spec;
}
});
/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql.has_ns_lookups_QMARK_ = (function fluree$db$query$fql$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.call(null,select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null));
});
fluree.db.query.fql.s = (function fluree$db$query$fql$s(f){
return f.s;
});
fluree.db.query.fql.o = (function fluree$db$query$fql$o(f){
return f.o;
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql.resolve_reverse_refs = (function fluree$db$query$fql$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,reverse_refs_specs){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_111423){
var state_val_111424 = (state_111423[(1)]);
if((state_val_111424 === (7))){
var inst_111263 = (state_111423[(7)]);
var state_111423__$1 = state_111423;
var statearr_111425_111514 = state_111423__$1;
(statearr_111425_111514[(2)] = inst_111263);

(statearr_111425_111514[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111424 === (59))){
var inst_111411 = (state_111423[(2)]);
var state_111423__$1 = state_111423;
var statearr_111426_111515 = state_111423__$1;
(statearr_111426_111515[(2)] = inst_111411);

(statearr_111426_111515[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111424 === (20))){
var state_111423__$1 = state_111423;
var statearr_111427_111516 = state_111423__$1;
(statearr_111427_111516[(2)] = fuel);

(statearr_111427_111516[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111424 === (58))){
var inst_111305 = (state_111423[(8)]);
var state_111423__$1 = state_111423;
var statearr_111428_111517 = state_111423__$1;
(statearr_111428_111517[(2)] = inst_111305);

(statearr_111428_111517[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111424 === (27))){
var inst_111303 = (state_111423[(9)]);
var inst_111405 = (state_111423[(2)]);
var state_111423__$1 = (function (){var statearr_111429 = state_111423;
(statearr_111429[(10)] = inst_111405);

return statearr_111429;
})();
if(cljs.core.truth_(inst_111303)){
var statearr_111430_111518 = state_111423__$1;
(statearr_111430_111518[(1)] = (54));

} else {
var statearr_111431_111519 = state_111423__$1;
(statearr_111431_111519[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111424 === (1))){
var state_111423__$1 = state_111423;
var statearr_111432_111520 = state_111423__$1;
(statearr_111432_111520[(2)] = null);

(statearr_111432_111520[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111424 === (24))){
var state_111423__$1 = state_111423;
var statearr_111433_111521 = state_111423__$1;
(statearr_111433_111521[(2)] = null);

(statearr_111433_111521[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111424 === (55))){
var inst_111304 = (state_111423[(11)]);
var state_111423__$1 = state_111423;
if(cljs.core.truth_(inst_111304)){
var statearr_111434_111522 = state_111423__$1;
(statearr_111434_111522[(1)] = (57));

} else {
var statearr_111435_111523 = state_111423__$1;
(statearr_111435_111523[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111424 === (39))){
var inst_111362 = (state_111423[(2)]);
var state_111423__$1 = state_111423;
if(cljs.core.truth_(inst_111362)){
var statearr_111436_111524 = state_111423__$1;
(statearr_111436_111524[(1)] = (40));

} else {
var statearr_111437_111525 = state_111423__$1;
(statearr_111437_111525[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111424 === (46))){
var inst_111374 = (state_111423[(12)]);
var inst_111279 = (state_111423[(13)]);
var inst_111373 = (state_111423[(2)]);
var inst_111374__$1 = fluree.db.util.async.throw_err.call(null,inst_111373);
var inst_111375 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_111376 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_111377 = (new cljs.core.PersistentVector(null,4,(5),inst_111375,inst_111376,null));
var inst_111378 = cljs.core.select_keys.call(null,inst_111279,inst_111377);
var inst_111379 = cljs.core.empty_QMARK_.call(null,inst_111374__$1);
var state_111423__$1 = (function (){var statearr_111438 = state_111423;
(statearr_111438[(12)] = inst_111374__$1);

(statearr_111438[(14)] = inst_111378);

return statearr_111438;
})();
if(inst_111379){
var statearr_111439_111526 = state_111423__$1;
(statearr_111439_111526[(1)] = (47));

} else {
var statearr_111440_111527 = state_111423__$1;
(statearr_111440_111527[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111424 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_111423,(3),Error,null,(2));
var inst_111259 = cljs.core.seq.call(null,reverse_refs_specs);
var inst_111260 = cljs.core.first.call(null,inst_111259);
var inst_111261 = cljs.core.next.call(null,inst_111259);
var inst_111262 = reverse_refs_specs;
var inst_111263 = null;
var state_111423__$1 = (function (){var statearr_111441 = state_111423;
(statearr_111441[(15)] = inst_111261);

(statearr_111441[(7)] = inst_111263);

(statearr_111441[(16)] = inst_111262);

(statearr_111441[(17)] = inst_111260);

return statearr_111441;
})();
var statearr_111442_111528 = state_111423__$1;
(statearr_111442_111528[(2)] = null);

(statearr_111442_111528[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111424 === (54))){
var inst_111303 = (state_111423[(9)]);
var state_111423__$1 = state_111423;
var statearr_111443_111529 = state_111423__$1;
(statearr_111443_111529[(2)] = inst_111303);

(statearr_111443_111529[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111424 === (15))){
var inst_111292 = (state_111423[(2)]);
var state_111423__$1 = state_111423;
var statearr_111444_111530 = state_111423__$1;
(statearr_111444_111530[(2)] = inst_111292);

(statearr_111444_111530[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111424 === (48))){
var state_111423__$1 = state_111423;
if(cljs.core.truth_(fuel)){
var statearr_111445_111531 = state_111423__$1;
(statearr_111445_111531[(1)] = (50));

} else {
var statearr_111446_111532 = state_111423__$1;
(statearr_111446_111532[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111424 === (50))){
var inst_111374 = (state_111423[(12)]);
var inst_111383 = cljs.core.count.call(null,inst_111374);
var inst_111384 = fluree.db.query.fql.add_fuel.call(null,fuel,inst_111383,max_fuel);
var state_111423__$1 = state_111423;
var statearr_111447_111533 = state_111423__$1;
(statearr_111447_111533[(2)] = inst_111384);

(statearr_111447_111533[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111424 === (21))){
var inst_111314 = (state_111423[(18)]);
var state_111423__$1 = state_111423;
var statearr_111448_111534 = state_111423__$1;
(statearr_111448_111534[(2)] = inst_111314);

(statearr_111448_111534[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111424 === (31))){
var inst_111302 = (state_111423[(19)]);
var inst_111337 = (state_111423[(20)]);
var inst_111350 = (inst_111337 >= inst_111302);
var state_111423__$1 = state_111423;
var statearr_111450_111535 = state_111423__$1;
(statearr_111450_111535[(2)] = inst_111350);

(statearr_111450_111535[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111424 === (32))){
var inst_111302 = (state_111423[(19)]);
var state_111423__$1 = state_111423;
var statearr_111451_111536 = state_111423__$1;
(statearr_111451_111536[(2)] = inst_111302);

(statearr_111451_111536[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111424 === (40))){
var inst_111345 = (state_111423[(21)]);
var inst_111337 = (state_111423[(20)]);
var inst_111338 = (state_111423[(22)]);
var inst_111364 = (inst_111337 + (1));
var tmp111449 = inst_111338;
var inst_111336 = inst_111345;
var inst_111337__$1 = inst_111364;
var inst_111338__$1 = tmp111449;
var state_111423__$1 = (function (){var statearr_111452 = state_111423;
(statearr_111452[(23)] = inst_111336);

(statearr_111452[(20)] = inst_111337__$1);

(statearr_111452[(22)] = inst_111338__$1);

return statearr_111452;
})();
var statearr_111453_111537 = state_111423__$1;
(statearr_111453_111537[(2)] = null);

(statearr_111453_111537[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111424 === (56))){
var inst_111405 = (state_111423[(10)]);
var inst_111263 = (state_111423[(7)]);
var inst_111270 = (state_111423[(24)]);
var inst_111413 = (state_111423[(2)]);
var inst_111414 = cljs.core.assoc.call(null,inst_111263,inst_111413,inst_111405);
var inst_111262 = inst_111270;
var inst_111263__$1 = inst_111414;
var state_111423__$1 = (function (){var statearr_111454 = state_111423;
(statearr_111454[(7)] = inst_111263__$1);

(statearr_111454[(16)] = inst_111262);

return statearr_111454;
})();
var statearr_111455_111538 = state_111423__$1;
(statearr_111455_111538[(2)] = null);

(statearr_111455_111538[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111424 === (33))){
var inst_111353 = (state_111423[(2)]);
var state_111423__$1 = state_111423;
var statearr_111456_111539 = state_111423__$1;
(statearr_111456_111539[(2)] = inst_111353);

(statearr_111456_111539[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111424 === (13))){
var state_111423__$1 = state_111423;
var statearr_111457_111540 = state_111423__$1;
(statearr_111457_111540[(2)] = true);

(statearr_111457_111540[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111424 === (22))){
var inst_111318 = (state_111423[(2)]);
var state_111423__$1 = state_111423;
if(cljs.core.truth_(inst_111318)){
var statearr_111458_111541 = state_111423__$1;
(statearr_111458_111541[(1)] = (23));

} else {
var statearr_111459_111542 = state_111423__$1;
(statearr_111459_111542[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111424 === (36))){
var inst_111403 = (state_111423[(2)]);
var state_111423__$1 = state_111423;
var statearr_111460_111543 = state_111423__$1;
(statearr_111460_111543[(2)] = inst_111403);

(statearr_111460_111543[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111424 === (41))){
var state_111423__$1 = state_111423;
var statearr_111461_111544 = state_111423__$1;
(statearr_111461_111544[(1)] = (43));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111424 === (43))){
var inst_111344 = (state_111423[(25)]);
var inst_111368 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_111369 = [inst_111344];
var inst_111370 = (new cljs.core.PersistentVector(null,1,(5),inst_111368,inst_111369,null));
var inst_111371 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_111370);
var state_111423__$1 = state_111423;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_111423__$1,(46),inst_111371);
} else {
if((state_val_111424 === (29))){
var inst_111302 = (state_111423[(19)]);
var state_111423__$1 = state_111423;
if(cljs.core.truth_(inst_111302)){
var statearr_111463_111545 = state_111423__$1;
(statearr_111463_111545[(1)] = (31));

} else {
var statearr_111464_111546 = state_111423__$1;
(statearr_111464_111546[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111424 === (44))){
var state_111423__$1 = state_111423;
var statearr_111465_111547 = state_111423__$1;
(statearr_111465_111547[(2)] = null);

(statearr_111465_111547[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111424 === (6))){
var inst_111419 = (state_111423[(2)]);
var state_111423__$1 = state_111423;
var statearr_111466_111548 = state_111423__$1;
(statearr_111466_111548[(2)] = inst_111419);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_111423__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111424 === (28))){
var inst_111346 = (state_111423[(26)]);
var state_111423__$1 = state_111423;
var statearr_111467_111549 = state_111423__$1;
(statearr_111467_111549[(2)] = inst_111346);

(statearr_111467_111549[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111424 === (51))){
var state_111423__$1 = state_111423;
var statearr_111468_111550 = state_111423__$1;
(statearr_111468_111550[(2)] = null);

(statearr_111468_111550[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111424 === (25))){
var inst_111314 = (state_111423[(18)]);
var inst_111324 = (state_111423[(2)]);
var inst_111332 = cljs.core.seq.call(null,inst_111314);
var inst_111333 = cljs.core.first.call(null,inst_111332);
var inst_111334 = cljs.core.next.call(null,inst_111332);
var inst_111335 = cljs.core.PersistentVector.EMPTY;
var inst_111336 = inst_111314;
var inst_111337 = (0);
var inst_111338 = inst_111335;
var state_111423__$1 = (function (){var statearr_111469 = state_111423;
(statearr_111469[(27)] = inst_111334);

(statearr_111469[(28)] = inst_111324);

(statearr_111469[(23)] = inst_111336);

(statearr_111469[(20)] = inst_111337);

(statearr_111469[(22)] = inst_111338);

(statearr_111469[(29)] = inst_111333);

return statearr_111469;
})();
var statearr_111470_111551 = state_111423__$1;
(statearr_111470_111551[(2)] = null);

(statearr_111470_111551[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111424 === (34))){
var inst_111338 = (state_111423[(22)]);
var state_111423__$1 = state_111423;
var statearr_111471_111552 = state_111423__$1;
(statearr_111471_111552[(2)] = inst_111338);

(statearr_111471_111552[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111424 === (17))){
var inst_111279 = (state_111423[(13)]);
var state_111423__$1 = state_111423;
var statearr_111472_111553 = state_111423__$1;
(statearr_111472_111553[(2)] = inst_111279);

(statearr_111472_111553[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111424 === (3))){
var inst_111248 = (state_111423[(2)]);
var state_111423__$1 = state_111423;
var statearr_111473_111554 = state_111423__$1;
(statearr_111473_111554[(2)] = inst_111248);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_111423__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111424 === (12))){
var inst_111295 = (state_111423[(2)]);
var state_111423__$1 = state_111423;
if(cljs.core.truth_(inst_111295)){
var statearr_111474_111555 = state_111423__$1;
(statearr_111474_111555[(1)] = (16));

} else {
var statearr_111475_111556 = state_111423__$1;
(statearr_111475_111556[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111424 === (2))){
var inst_111421 = (state_111423[(2)]);
var state_111423__$1 = state_111423;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_111423__$1,inst_111421);
} else {
if((state_val_111424 === (23))){
var inst_111314 = (state_111423[(18)]);
var inst_111320 = cljs.core.count.call(null,inst_111314);
var inst_111321 = fluree.db.query.fql.add_fuel.call(null,fuel,inst_111320,max_fuel);
var state_111423__$1 = state_111423;
var statearr_111476_111557 = state_111423__$1;
(statearr_111476_111557[(2)] = inst_111321);

(statearr_111476_111557[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111424 === (47))){
var inst_111338 = (state_111423[(22)]);
var state_111423__$1 = state_111423;
var statearr_111477_111558 = state_111423__$1;
(statearr_111477_111558[(2)] = inst_111338);

(statearr_111477_111558[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111424 === (35))){
var inst_111301 = (state_111423[(30)]);
var state_111423__$1 = state_111423;
if(cljs.core.truth_(inst_111301)){
var statearr_111478_111559 = state_111423__$1;
(statearr_111478_111559[(1)] = (37));

} else {
var statearr_111479_111560 = state_111423__$1;
(statearr_111479_111560[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111424 === (19))){
var inst_111314 = (state_111423[(18)]);
var inst_111311 = (state_111423[(2)]);
var inst_111312 = fluree.db.util.async.throw_err.call(null,inst_111311);
var inst_111313 = cljs.core.map.call(null,fluree.db.query.fql.s,inst_111312);
var inst_111314__$1 = cljs.core.not_empty.call(null,inst_111313);
var state_111423__$1 = (function (){var statearr_111480 = state_111423;
(statearr_111480[(18)] = inst_111314__$1);

return statearr_111480;
})();
if(cljs.core.truth_(inst_111314__$1)){
var statearr_111481_111561 = state_111423__$1;
(statearr_111481_111561[(1)] = (20));

} else {
var statearr_111482_111562 = state_111423__$1;
(statearr_111482_111562[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111424 === (57))){
var inst_111304 = (state_111423[(11)]);
var state_111423__$1 = state_111423;
var statearr_111483_111563 = state_111423__$1;
(statearr_111483_111563[(2)] = inst_111304);

(statearr_111483_111563[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111424 === (11))){
var state_111423__$1 = state_111423;
var statearr_111484_111564 = state_111423__$1;
(statearr_111484_111564[(2)] = false);

(statearr_111484_111564[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111424 === (9))){
var inst_111417 = (state_111423[(2)]);
var state_111423__$1 = state_111423;
var statearr_111485_111565 = state_111423__$1;
(statearr_111485_111565[(2)] = inst_111417);

(statearr_111485_111565[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111424 === (5))){
var inst_111269 = (state_111423[(31)]);
var inst_111262 = (state_111423[(16)]);
var inst_111268 = cljs.core.seq.call(null,inst_111262);
var inst_111269__$1 = cljs.core.first.call(null,inst_111268);
var inst_111270 = cljs.core.next.call(null,inst_111268);
var inst_111271 = cljs.core.not.call(null,inst_111269__$1);
var state_111423__$1 = (function (){var statearr_111486 = state_111423;
(statearr_111486[(31)] = inst_111269__$1);

(statearr_111486[(24)] = inst_111270);

return statearr_111486;
})();
if(inst_111271){
var statearr_111487_111566 = state_111423__$1;
(statearr_111487_111566[(1)] = (7));

} else {
var statearr_111488_111567 = state_111423__$1;
(statearr_111488_111567[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111424 === (14))){
var state_111423__$1 = state_111423;
var statearr_111489_111568 = state_111423__$1;
(statearr_111489_111568[(2)] = false);

(statearr_111489_111568[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111424 === (45))){
var inst_111399 = (state_111423[(2)]);
var state_111423__$1 = state_111423;
var statearr_111490_111569 = state_111423__$1;
(statearr_111490_111569[(2)] = inst_111399);

(statearr_111490_111569[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111424 === (53))){
var inst_111338 = (state_111423[(22)]);
var inst_111390 = (state_111423[(2)]);
var inst_111391 = fluree.db.util.async.throw_err.call(null,inst_111390);
var inst_111392 = cljs.core.conj.call(null,inst_111338,inst_111391);
var state_111423__$1 = state_111423;
var statearr_111491_111570 = state_111423__$1;
(statearr_111491_111570[(2)] = inst_111392);

(statearr_111491_111570[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111424 === (26))){
var inst_111344 = (state_111423[(25)]);
var inst_111336 = (state_111423[(23)]);
var inst_111346 = (state_111423[(26)]);
var inst_111343 = cljs.core.seq.call(null,inst_111336);
var inst_111344__$1 = cljs.core.first.call(null,inst_111343);
var inst_111345 = cljs.core.next.call(null,inst_111343);
var inst_111346__$1 = cljs.core.not.call(null,inst_111344__$1);
var state_111423__$1 = (function (){var statearr_111492 = state_111423;
(statearr_111492[(21)] = inst_111345);

(statearr_111492[(25)] = inst_111344__$1);

(statearr_111492[(26)] = inst_111346__$1);

return statearr_111492;
})();
if(inst_111346__$1){
var statearr_111493_111571 = state_111423__$1;
(statearr_111493_111571[(1)] = (28));

} else {
var statearr_111494_111572 = state_111423__$1;
(statearr_111494_111572[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111424 === (16))){
var inst_111279 = (state_111423[(13)]);
var inst_111297 = cljs.core.apply.call(null,cljs.core.hash_map,inst_111279);
var state_111423__$1 = state_111423;
var statearr_111495_111573 = state_111423__$1;
(statearr_111495_111573[(2)] = inst_111297);

(statearr_111495_111573[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111424 === (38))){
var inst_111301 = (state_111423[(30)]);
var state_111423__$1 = state_111423;
var statearr_111496_111574 = state_111423__$1;
(statearr_111496_111574[(2)] = inst_111301);

(statearr_111496_111574[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111424 === (30))){
var inst_111355 = (state_111423[(2)]);
var state_111423__$1 = state_111423;
if(cljs.core.truth_(inst_111355)){
var statearr_111497_111575 = state_111423__$1;
(statearr_111497_111575[(1)] = (34));

} else {
var statearr_111498_111576 = state_111423__$1;
(statearr_111498_111576[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111424 === (10))){
var inst_111279 = (state_111423[(13)]);
var inst_111284 = inst_111279.cljs$lang$protocol_mask$partition0$;
var inst_111285 = (inst_111284 & (64));
var inst_111286 = inst_111279.cljs$core$ISeq$;
var inst_111287 = (cljs.core.PROTOCOL_SENTINEL === inst_111286);
var inst_111288 = ((inst_111285) || (inst_111287));
var state_111423__$1 = state_111423;
if(cljs.core.truth_(inst_111288)){
var statearr_111499_111577 = state_111423__$1;
(statearr_111499_111577[(1)] = (13));

} else {
var statearr_111500_111578 = state_111423__$1;
(statearr_111500_111578[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111424 === (18))){
var inst_111278 = (state_111423[(32)]);
var inst_111300 = (state_111423[(2)]);
var inst_111301 = cljs.core.get.call(null,inst_111300,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_111302 = cljs.core.get.call(null,inst_111300,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_111303 = cljs.core.get.call(null,inst_111300,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_111304 = cljs.core.get.call(null,inst_111300,new cljs.core.Keyword(null,"name","name",1843675177));
var inst_111305 = cljs.core.get.call(null,inst_111300,new cljs.core.Keyword(null,"p","p",151049309));
var inst_111306 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_111307 = [subject_id,inst_111278];
var inst_111308 = (new cljs.core.PersistentVector(null,2,(5),inst_111306,inst_111307,null));
var inst_111309 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_111308);
var state_111423__$1 = (function (){var statearr_111501 = state_111423;
(statearr_111501[(19)] = inst_111302);

(statearr_111501[(9)] = inst_111303);

(statearr_111501[(30)] = inst_111301);

(statearr_111501[(11)] = inst_111304);

(statearr_111501[(8)] = inst_111305);

return statearr_111501;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_111423__$1,(19),inst_111309);
} else {
if((state_val_111424 === (52))){
var inst_111374 = (state_111423[(12)]);
var inst_111378 = (state_111423[(14)]);
var inst_111387 = (state_111423[(2)]);
var inst_111388 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_111378,inst_111374);
var state_111423__$1 = (function (){var statearr_111502 = state_111423;
(statearr_111502[(33)] = inst_111387);

return statearr_111502;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_111423__$1,(53),inst_111388);
} else {
if((state_val_111424 === (42))){
var inst_111401 = (state_111423[(2)]);
var state_111423__$1 = state_111423;
var statearr_111503_111579 = state_111423__$1;
(statearr_111503_111579[(2)] = inst_111401);

(statearr_111503_111579[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111424 === (37))){
var inst_111337 = (state_111423[(20)]);
var inst_111301 = (state_111423[(30)]);
var inst_111359 = (inst_111337 < inst_111301);
var state_111423__$1 = state_111423;
var statearr_111504_111580 = state_111423__$1;
(statearr_111504_111580[(2)] = inst_111359);

(statearr_111504_111580[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111424 === (8))){
var inst_111269 = (state_111423[(31)]);
var inst_111279 = (state_111423[(13)]);
var inst_111278 = cljs.core.nth.call(null,inst_111269,(0),null);
var inst_111279__$1 = cljs.core.nth.call(null,inst_111269,(1),null);
var inst_111281 = (inst_111279__$1 == null);
var inst_111282 = cljs.core.not.call(null,inst_111281);
var state_111423__$1 = (function (){var statearr_111505 = state_111423;
(statearr_111505[(13)] = inst_111279__$1);

(statearr_111505[(32)] = inst_111278);

return statearr_111505;
})();
if(inst_111282){
var statearr_111506_111581 = state_111423__$1;
(statearr_111506_111581[(1)] = (10));

} else {
var statearr_111507_111582 = state_111423__$1;
(statearr_111507_111582[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111424 === (49))){
var inst_111345 = (state_111423[(21)]);
var inst_111337 = (state_111423[(20)]);
var inst_111394 = (state_111423[(2)]);
var inst_111395 = (inst_111337 + (1));
var inst_111336 = inst_111345;
var inst_111337__$1 = inst_111395;
var inst_111338 = inst_111394;
var state_111423__$1 = (function (){var statearr_111508 = state_111423;
(statearr_111508[(23)] = inst_111336);

(statearr_111508[(20)] = inst_111337__$1);

(statearr_111508[(22)] = inst_111338);

return statearr_111508;
})();
var statearr_111509_111583 = state_111423__$1;
(statearr_111509_111583[(2)] = null);

(statearr_111509_111583[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__99975__auto__ = null;
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__99975__auto____0 = (function (){
var statearr_111510 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_111510[(0)] = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__99975__auto__);

(statearr_111510[(1)] = (1));

return statearr_111510;
});
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__99975__auto____1 = (function (state_111423){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_111423);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e111511){if((e111511 instanceof Object)){
var ex__99978__auto__ = e111511;
var statearr_111512_111584 = state_111423;
(statearr_111512_111584[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_111423);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e111511;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__111585 = state_111423;
state_111423 = G__111585;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__99975__auto__ = function(state_111423){
switch(arguments.length){
case 0:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__99975__auto____1.call(this,state_111423);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__99975__auto____0;
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__99975__auto____1;
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_111513 = f__100070__auto__.call(null);
(statearr_111513[(6)] = c__100069__auto__);

return statearr_111513;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
fluree.db.query.fql.component_follow_QMARK_ = (function fluree$db$query$fql$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_.call(null,pred_spec,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__4126__auto__ = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
fluree.db.query.fql.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.call(null,(function (acc,spec){
var key_spec = cljs.core.key.call(null,spec);
var val_spec = (((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(cljs.core.val.call(null,spec)) == null))?cljs.core.assoc.call(null,cljs.core.val.call(null,spec),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val.call(null,spec));
return cljs.core.assoc.call(null,acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.call(null,select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)], null)));
});
fluree.db.query.fql.get_recursion_map_multi = (function fluree$db$query$fql$get_recursion_map_multi(recursion_map,k,f,full_select_spec,seen_QMARK_){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.query.fql.o.call(null,f)], null)], null),cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,recursion_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,fluree.db.query.fql.o.call(null,f)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.query.fql.o.call(null,f)], null)], null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,new cljs.core.Keyword(null,"depth","depth",1768663640)], null),(0)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pred-ids","pred-ids",-1902141555),k], null),f.p),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select-specs","select-specs",-681748023),f.p], null),full_select_spec),true], null);
});
fluree.db.query.fql.add_in_multi_flakes = (function fluree$db$query$fql$add_in_multi_flakes(acc,new_child_paths,k,f,db,cache,fuel,max_fuel,pred_spec,component_follow_QMARK_,parent_exists){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_111699){
var state_val_111700 = (state_111699[(1)]);
if((state_val_111700 === (7))){
var inst_111602 = (state_111699[(7)]);
var state_111699__$1 = state_111699;
var statearr_111701_111750 = state_111699__$1;
(statearr_111701_111750[(2)] = inst_111602);

(statearr_111701_111750[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111700 === (20))){
var inst_111646 = (state_111699[(2)]);
var state_111699__$1 = state_111699;
var statearr_111702_111751 = state_111699__$1;
(statearr_111702_111751[(2)] = inst_111646);

(statearr_111702_111751[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111700 === (27))){
var inst_111669 = (state_111699[(2)]);
var inst_111670 = fluree.db.util.async.throw_err.call(null,inst_111669);
var state_111699__$1 = state_111699;
var statearr_111703_111752 = state_111699__$1;
(statearr_111703_111752[(2)] = inst_111670);

(statearr_111703_111752[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111700 === (1))){
var state_111699__$1 = state_111699;
var statearr_111704_111753 = state_111699__$1;
(statearr_111704_111753[(2)] = null);

(statearr_111704_111753[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111700 === (24))){
var inst_111602 = (state_111699[(7)]);
var inst_111667 = fluree.db.query.fql.add_pred.call(null,db,cache,fuel,max_fuel,inst_111602,pred_spec,f,component_follow_QMARK_,true);
var state_111699__$1 = state_111699;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_111699__$1,(27),inst_111667);
} else {
if((state_val_111700 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_111699,(3),Error,null,(2));
var inst_111598 = cljs.core.seq.call(null,new_child_paths);
var inst_111599 = cljs.core.first.call(null,inst_111598);
var inst_111600 = cljs.core.next.call(null,inst_111598);
var inst_111601 = new_child_paths;
var inst_111602 = acc;
var state_111699__$1 = (function (){var statearr_111705 = state_111699;
(statearr_111705[(8)] = inst_111601);

(statearr_111705[(9)] = inst_111600);

(statearr_111705[(10)] = inst_111599);

(statearr_111705[(7)] = inst_111602);

return statearr_111705;
})();
var statearr_111706_111754 = state_111699__$1;
(statearr_111706_111754[(2)] = null);

(statearr_111706_111754[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111700 === (15))){
var inst_111651 = (state_111699[(11)]);
var inst_111651__$1 = (state_111699[(2)]);
var inst_111652 = cljs.core.count.call(null,inst_111651__$1);
var inst_111653 = (inst_111652 > (1));
var state_111699__$1 = (function (){var statearr_111707 = state_111699;
(statearr_111707[(11)] = inst_111651__$1);

return statearr_111707;
})();
if(cljs.core.truth_(inst_111653)){
var statearr_111708_111755 = state_111699__$1;
(statearr_111708_111755[(1)] = (21));

} else {
var statearr_111709_111756 = state_111699__$1;
(statearr_111709_111756[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111700 === (21))){
var inst_111651 = (state_111699[(11)]);
var inst_111655 = cljs.core.drop_last.call(null,inst_111651);
var state_111699__$1 = state_111699;
var statearr_111710_111757 = state_111699__$1;
(statearr_111710_111757[(2)] = inst_111655);

(statearr_111710_111757[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111700 === (31))){
var inst_111609 = (state_111699[(12)]);
var inst_111602 = (state_111699[(7)]);
var inst_111689 = (state_111699[(2)]);
var inst_111690 = cljs.core.conj.call(null,inst_111602,inst_111689);
var inst_111601 = inst_111609;
var inst_111602__$1 = inst_111690;
var state_111699__$1 = (function (){var statearr_111711 = state_111699;
(statearr_111711[(8)] = inst_111601);

(statearr_111711[(7)] = inst_111602__$1);

return statearr_111711;
})();
var statearr_111712_111758 = state_111699__$1;
(statearr_111712_111758[(2)] = null);

(statearr_111712_111758[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111700 === (13))){
var inst_111620 = (state_111699[(13)]);
var inst_111617 = (state_111699[(14)]);
var inst_111628 = inst_111617;
var inst_111629 = inst_111620;
var state_111699__$1 = (function (){var statearr_111713 = state_111699;
(statearr_111713[(15)] = inst_111628);

(statearr_111713[(16)] = inst_111629);

return statearr_111713;
})();
var statearr_111714_111759 = state_111699__$1;
(statearr_111714_111759[(2)] = null);

(statearr_111714_111759[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111700 === (22))){
var inst_111651 = (state_111699[(11)]);
var state_111699__$1 = state_111699;
var statearr_111715_111760 = state_111699__$1;
(statearr_111715_111760[(2)] = inst_111651);

(statearr_111715_111760[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111700 === (29))){
var inst_111678 = (state_111699[(17)]);
var state_111699__$1 = state_111699;
var statearr_111716_111761 = state_111699__$1;
(statearr_111716_111761[(2)] = inst_111678);

(statearr_111716_111761[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111700 === (6))){
var inst_111695 = (state_111699[(2)]);
var state_111699__$1 = state_111699;
var statearr_111717_111762 = state_111699__$1;
(statearr_111717_111762[(2)] = inst_111695);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_111699__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111700 === (28))){
var inst_111674 = (state_111699[(2)]);
var inst_111675 = fluree.db.util.async.throw_err.call(null,inst_111674);
var state_111699__$1 = state_111699;
var statearr_111718_111763 = state_111699__$1;
(statearr_111718_111763[(2)] = inst_111675);

(statearr_111718_111763[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111700 === (25))){
var inst_111659 = (state_111699[(18)]);
var inst_111672 = fluree.db.query.fql.add_pred.call(null,db,cache,fuel,max_fuel,inst_111659,pred_spec,f,component_follow_QMARK_,true);
var state_111699__$1 = state_111699;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_111699__$1,(28),inst_111672);
} else {
if((state_val_111700 === (17))){
var inst_111648 = (state_111699[(2)]);
var state_111699__$1 = state_111699;
var statearr_111719_111764 = state_111699__$1;
(statearr_111719_111764[(2)] = inst_111648);

(statearr_111719_111764[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111700 === (3))){
var inst_111587 = (state_111699[(2)]);
var state_111699__$1 = state_111699;
var statearr_111720_111765 = state_111699__$1;
(statearr_111720_111765[(2)] = inst_111587);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_111699__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111700 === (12))){
var inst_111617 = (state_111699[(14)]);
var inst_111602 = (state_111699[(7)]);
var inst_111617__$1 = (state_111699[(2)]);
var inst_111618 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_111619 = [k];
var inst_111620 = (new cljs.core.PersistentVector(null,1,(5),inst_111618,inst_111619,null));
var inst_111621 = new cljs.core.Keyword(null,"_id","_id",-789960287).cljs$core$IFn$_invoke$arity$1(inst_111602);
var inst_111622 = fluree.db.query.fql.s.call(null,f);
var inst_111623 = cljs.core.not_EQ_.call(null,inst_111621,inst_111622);
var inst_111624 = cljs.core.empty_QMARK_.call(null,inst_111617__$1);
var inst_111625 = (!(inst_111624));
var inst_111626 = ((inst_111623) && (inst_111625));
var state_111699__$1 = (function (){var statearr_111721 = state_111699;
(statearr_111721[(13)] = inst_111620);

(statearr_111721[(14)] = inst_111617__$1);

return statearr_111721;
})();
if(cljs.core.truth_(inst_111626)){
var statearr_111722_111766 = state_111699__$1;
(statearr_111722_111766[(1)] = (13));

} else {
var statearr_111723_111767 = state_111699__$1;
(statearr_111723_111767[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111700 === (2))){
var inst_111697 = (state_111699[(2)]);
var state_111699__$1 = state_111699;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_111699__$1,inst_111697);
} else {
if((state_val_111700 === (23))){
var inst_111658 = (state_111699[(19)]);
var inst_111602 = (state_111699[(7)]);
var inst_111658__$1 = (state_111699[(2)]);
var inst_111659 = cljs.core.get_in.call(null,inst_111602,inst_111658__$1);
var inst_111663 = new cljs.core.Keyword(null,"_id","_id",-789960287).cljs$core$IFn$_invoke$arity$1(inst_111602);
var inst_111664 = fluree.db.query.fql.s.call(null,f);
var inst_111665 = cljs.core._EQ_.call(null,inst_111663,inst_111664);
var state_111699__$1 = (function (){var statearr_111724 = state_111699;
(statearr_111724[(19)] = inst_111658__$1);

(statearr_111724[(18)] = inst_111659);

return statearr_111724;
})();
if(inst_111665){
var statearr_111725_111768 = state_111699__$1;
(statearr_111725_111768[(1)] = (24));

} else {
var statearr_111726_111769 = state_111699__$1;
(statearr_111726_111769[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111700 === (19))){
var inst_111637 = (state_111699[(20)]);
var state_111699__$1 = state_111699;
var statearr_111727_111770 = state_111699__$1;
(statearr_111727_111770[(2)] = inst_111637);

(statearr_111727_111770[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111700 === (11))){
var inst_111608 = (state_111699[(21)]);
var inst_111615 = cljs.core.drop_last.call(null,inst_111608);
var state_111699__$1 = state_111699;
var statearr_111728_111771 = state_111699__$1;
(statearr_111728_111771[(2)] = inst_111615);

(statearr_111728_111771[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111700 === (9))){
var inst_111693 = (state_111699[(2)]);
var state_111699__$1 = state_111699;
var statearr_111729_111772 = state_111699__$1;
(statearr_111729_111772[(2)] = inst_111693);

(statearr_111729_111772[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111700 === (5))){
var inst_111601 = (state_111699[(8)]);
var inst_111608 = (state_111699[(21)]);
var inst_111607 = cljs.core.seq.call(null,inst_111601);
var inst_111608__$1 = cljs.core.first.call(null,inst_111607);
var inst_111609 = cljs.core.next.call(null,inst_111607);
var inst_111610 = cljs.core.not.call(null,inst_111608__$1);
var state_111699__$1 = (function (){var statearr_111730 = state_111699;
(statearr_111730[(12)] = inst_111609);

(statearr_111730[(21)] = inst_111608__$1);

return statearr_111730;
})();
if(inst_111610){
var statearr_111731_111773 = state_111699__$1;
(statearr_111731_111773[(1)] = (7));

} else {
var statearr_111732_111774 = state_111699__$1;
(statearr_111732_111774[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111700 === (14))){
var inst_111620 = (state_111699[(13)]);
var state_111699__$1 = state_111699;
var statearr_111733_111775 = state_111699__$1;
(statearr_111733_111775[(2)] = inst_111620);

(statearr_111733_111775[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111700 === (26))){
var inst_111658 = (state_111699[(19)]);
var inst_111602 = (state_111699[(7)]);
var inst_111677 = (state_111699[(2)]);
var inst_111678 = cljs.core.nth.call(null,inst_111677,(0),null);
var inst_111679 = cljs.core.nth.call(null,inst_111677,(1),null);
var inst_111680 = new cljs.core.Keyword(null,"_id","_id",-789960287).cljs$core$IFn$_invoke$arity$1(inst_111602);
var inst_111681 = fluree.db.query.fql.s.call(null,f);
var inst_111682 = cljs.core._EQ_.call(null,inst_111680,inst_111681);
var inst_111683 = cljs.core.empty_QMARK_.call(null,inst_111658);
var inst_111684 = ((inst_111682) || (inst_111683));
var state_111699__$1 = (function (){var statearr_111734 = state_111699;
(statearr_111734[(22)] = inst_111679);

(statearr_111734[(17)] = inst_111678);

return statearr_111734;
})();
if(cljs.core.truth_(inst_111684)){
var statearr_111735_111776 = state_111699__$1;
(statearr_111735_111776[(1)] = (29));

} else {
var statearr_111736_111777 = state_111699__$1;
(statearr_111736_111777[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111700 === (16))){
var inst_111628 = (state_111699[(15)]);
var inst_111601 = (state_111699[(8)]);
var inst_111600 = (state_111699[(9)]);
var inst_111609 = (state_111699[(12)]);
var inst_111629 = (state_111699[(16)]);
var inst_111599 = (state_111699[(10)]);
var inst_111608 = (state_111699[(21)]);
var inst_111602 = (state_111699[(7)]);
var inst_111631 = cljs.core.get_in.call(null,inst_111602,inst_111629);
var inst_111632 = (function (){var seq__111596 = inst_111600;
var first__111597 = inst_111599;
var seq__111605 = inst_111609;
var vec__111604 = inst_111601;
var keys_SINGLEQUOTE_ = inst_111629;
var r = inst_111609;
var G__111594 = inst_111601;
var child_path = inst_111628;
var acc__$1 = inst_111602;
var value = inst_111631;
var first__111606 = inst_111608;
var vec__111595 = new_child_paths;
return (function (p1__111586_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"_id","_id",-789960287).cljs$core$IFn$_invoke$arity$1(p1__111586_SHARP_),cljs.core.first.call(null,child_path));
});
})();
var inst_111633 = cljs.core.filter.call(null,inst_111632,inst_111631);
var inst_111634 = cljs.core.first.call(null,inst_111633);
var inst_111635 = inst_111631.indexOf(inst_111634);
var inst_111636 = cljs.core.conj.call(null,inst_111629,inst_111635);
var inst_111637 = cljs.core.conj.call(null,inst_111636,k);
var inst_111638 = cljs.core.rest.call(null,inst_111628);
var inst_111639 = cljs.core.count.call(null,inst_111638);
var inst_111640 = (inst_111639 > (0));
var state_111699__$1 = (function (){var statearr_111737 = state_111699;
(statearr_111737[(20)] = inst_111637);

return statearr_111737;
})();
if(cljs.core.truth_(inst_111640)){
var statearr_111738_111778 = state_111699__$1;
(statearr_111738_111778[(1)] = (18));

} else {
var statearr_111739_111779 = state_111699__$1;
(statearr_111739_111779[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111700 === (30))){
var inst_111658 = (state_111699[(19)]);
var inst_111678 = (state_111699[(17)]);
var inst_111602 = (state_111699[(7)]);
var inst_111687 = cljs.core.assoc_in.call(null,inst_111602,inst_111658,inst_111678);
var state_111699__$1 = state_111699;
var statearr_111740_111780 = state_111699__$1;
(statearr_111740_111780[(2)] = inst_111687);

(statearr_111740_111780[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111700 === (10))){
var inst_111608 = (state_111699[(21)]);
var state_111699__$1 = state_111699;
var statearr_111741_111781 = state_111699__$1;
(statearr_111741_111781[(2)] = inst_111608);

(statearr_111741_111781[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111700 === (18))){
var inst_111628 = (state_111699[(15)]);
var inst_111637 = (state_111699[(20)]);
var inst_111642 = cljs.core.rest.call(null,inst_111628);
var inst_111628__$1 = inst_111642;
var inst_111629 = inst_111637;
var state_111699__$1 = (function (){var statearr_111742 = state_111699;
(statearr_111742[(15)] = inst_111628__$1);

(statearr_111742[(16)] = inst_111629);

return statearr_111742;
})();
var statearr_111743_111782 = state_111699__$1;
(statearr_111743_111782[(2)] = null);

(statearr_111743_111782[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111700 === (8))){
var state_111699__$1 = state_111699;
if(cljs.core.truth_(parent_exists)){
var statearr_111744_111783 = state_111699__$1;
(statearr_111744_111783[(1)] = (10));

} else {
var statearr_111745_111784 = state_111699__$1;
(statearr_111745_111784[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$add_in_multi_flakes_$_state_machine__99975__auto__ = null;
var fluree$db$query$fql$add_in_multi_flakes_$_state_machine__99975__auto____0 = (function (){
var statearr_111746 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_111746[(0)] = fluree$db$query$fql$add_in_multi_flakes_$_state_machine__99975__auto__);

(statearr_111746[(1)] = (1));

return statearr_111746;
});
var fluree$db$query$fql$add_in_multi_flakes_$_state_machine__99975__auto____1 = (function (state_111699){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_111699);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e111747){if((e111747 instanceof Object)){
var ex__99978__auto__ = e111747;
var statearr_111748_111785 = state_111699;
(statearr_111748_111785[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_111699);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e111747;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__111786 = state_111699;
state_111699 = G__111786;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$fql$add_in_multi_flakes_$_state_machine__99975__auto__ = function(state_111699){
switch(arguments.length){
case 0:
return fluree$db$query$fql$add_in_multi_flakes_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$fql$add_in_multi_flakes_$_state_machine__99975__auto____1.call(this,state_111699);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$add_in_multi_flakes_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$add_in_multi_flakes_$_state_machine__99975__auto____0;
fluree$db$query$fql$add_in_multi_flakes_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$add_in_multi_flakes_$_state_machine__99975__auto____1;
return fluree$db$query$fql$add_in_multi_flakes_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_111749 = f__100070__auto__.call(null);
(statearr_111749[(6)] = c__100069__auto__);

return statearr_111749;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
fluree.db.query.fql.flake__GT_recur_multi = (function fluree$db$query$fql$flake__GT_recur_multi(db,f,pred_spec,recursion_map,flakes,acc,fuel,max_fuel,select_spec,cache,component_follow_QMARK_){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_111896){
var state_val_111897 = (state_111896[(1)]);
if((state_val_111897 === (7))){
var inst_111811 = (state_111896[(7)]);
var inst_111796 = (state_111896[(8)]);
var inst_111807 = (state_111896[(9)]);
var inst_111807__$1 = (state_111896[(2)]);
var inst_111808 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_111809 = [inst_111807__$1,inst_111796];
var inst_111810 = (new cljs.core.PersistentVector(null,2,(5),inst_111808,inst_111809,null));
var inst_111811__$1 = cljs.core.get_in.call(null,recursion_map,inst_111810);
var state_111896__$1 = (function (){var statearr_111898 = state_111896;
(statearr_111898[(7)] = inst_111811__$1);

(statearr_111898[(9)] = inst_111807__$1);

return statearr_111898;
})();
if(cljs.core.truth_(inst_111811__$1)){
var statearr_111899_111958 = state_111896__$1;
(statearr_111899_111958[(1)] = (11));

} else {
var statearr_111900_111959 = state_111896__$1;
(statearr_111900_111959[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111897 === (20))){
var inst_111838 = (state_111896[(10)]);
var inst_111840 = f.o;
var inst_111841 = fluree.db.query.fql.resolve_reverse_refs.call(null,db,cache,fuel,max_fuel,inst_111840,inst_111838);
var state_111896__$1 = state_111896;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_111896__$1,(23),inst_111841);
} else {
if((state_val_111897 === (27))){
var inst_111858 = (state_111896[(2)]);
var state_111896__$1 = state_111896;
if(cljs.core.truth_(inst_111858)){
var statearr_111901_111960 = state_111896__$1;
(statearr_111901_111960[(1)] = (28));

} else {
var statearr_111902_111961 = state_111896__$1;
(statearr_111902_111961[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111897 === (1))){
var state_111896__$1 = state_111896;
var statearr_111903_111962 = state_111896__$1;
(statearr_111903_111962[(2)] = null);

(statearr_111903_111962[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111897 === (24))){
var inst_111825 = (state_111896[(11)]);
var inst_111852 = (state_111896[(2)]);
var inst_111853 = fluree.db.util.async.throw_err.call(null,inst_111852);
var state_111896__$1 = (function (){var statearr_111904 = state_111896;
(statearr_111904[(12)] = inst_111853);

return statearr_111904;
})();
if(cljs.core.truth_(inst_111825)){
var statearr_111905_111963 = state_111896__$1;
(statearr_111905_111963[(1)] = (25));

} else {
var statearr_111906_111964 = state_111896__$1;
(statearr_111906_111964[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111897 === (39))){
var inst_111875 = (state_111896[(13)]);
var state_111896__$1 = state_111896;
var statearr_111907_111965 = state_111896__$1;
(statearr_111907_111965[(2)] = inst_111875);

(statearr_111907_111965[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111897 === (4))){
var inst_111797 = (state_111896[(14)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_111896,(3),Error,null,(2));
var inst_111794 = fluree.db.query.fql.s.call(null,f);
var inst_111795 = cljs.core.assoc.call(null,acc,new cljs.core.Keyword(null,"_id","_id",-789960287),inst_111794);
var inst_111796 = fluree.db.query.fql.o.call(null,f);
var inst_111797__$1 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_111896__$1 = (function (){var statearr_111908 = state_111896;
(statearr_111908[(8)] = inst_111796);

(statearr_111908[(15)] = inst_111795);

(statearr_111908[(14)] = inst_111797__$1);

return statearr_111908;
})();
if(cljs.core.truth_(inst_111797__$1)){
var statearr_111909_111966 = state_111896__$1;
(statearr_111909_111966[(1)] = (5));

} else {
var statearr_111910_111967 = state_111896__$1;
(statearr_111910_111967[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111897 === (15))){
var inst_111819 = (state_111896[(16)]);
var inst_111828 = cljs.core.not.call(null,inst_111819);
var state_111896__$1 = state_111896;
var statearr_111911_111968 = state_111896__$1;
(statearr_111911_111968[(2)] = inst_111828);

(statearr_111911_111968[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111897 === (21))){
var state_111896__$1 = state_111896;
var statearr_111912_111969 = state_111896__$1;
(statearr_111912_111969[(2)] = null);

(statearr_111912_111969[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111897 === (31))){
var inst_111849 = (state_111896[(17)]);
var inst_111863 = cljs.core.rest.call(null,flakes);
var inst_111864 = cljs.core.concat.call(null,inst_111863,inst_111849);
var state_111896__$1 = state_111896;
var statearr_111913_111970 = state_111896__$1;
(statearr_111913_111970[(2)] = inst_111864);

(statearr_111913_111970[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111897 === (32))){
var state_111896__$1 = state_111896;
var statearr_111914_111971 = state_111896__$1;
(statearr_111914_111971[(1)] = (34));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111897 === (40))){
var inst_111867 = (state_111896[(18)]);
var inst_111881 = (state_111896[(2)]);
var inst_111882 = cljs.core.concat.call(null,inst_111867,inst_111881);
var state_111896__$1 = state_111896;
var statearr_111916_111972 = state_111896__$1;
(statearr_111916_111972[(2)] = inst_111882);

(statearr_111916_111972[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111897 === (33))){
var inst_111887 = (state_111896[(2)]);
var state_111896__$1 = state_111896;
var statearr_111917_111973 = state_111896__$1;
(statearr_111917_111973[(2)] = inst_111887);

(statearr_111917_111973[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111897 === (13))){
var inst_111818 = (state_111896[(19)]);
var inst_111825 = (state_111896[(11)]);
var inst_111807 = (state_111896[(9)]);
var inst_111815 = (state_111896[(2)]);
var inst_111816 = fluree.db.query.fql.get_recursion_map_multi.call(null,recursion_map,inst_111807,f,select_spec,inst_111815);
var inst_111817 = cljs.core.nth.call(null,inst_111816,(0),null);
var inst_111818__$1 = cljs.core.nth.call(null,inst_111816,(1),null);
var inst_111819 = cljs.core.nth.call(null,inst_111816,(2),null);
var inst_111820 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_111821 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_111822 = [inst_111807,new cljs.core.Keyword(null,"depth","depth",1768663640)];
var inst_111823 = (new cljs.core.PersistentVector(null,2,(5),inst_111821,inst_111822,null));
var inst_111824 = cljs.core.get_in.call(null,inst_111818__$1,inst_111823);
var inst_111825__$1 = (inst_111820 < inst_111824);
var state_111896__$1 = (function (){var statearr_111918 = state_111896;
(statearr_111918[(19)] = inst_111818__$1);

(statearr_111918[(11)] = inst_111825__$1);

(statearr_111918[(20)] = inst_111817);

(statearr_111918[(16)] = inst_111819);

return statearr_111918;
})();
if(cljs.core.truth_(inst_111825__$1)){
var statearr_111919_111974 = state_111896__$1;
(statearr_111919_111974[(1)] = (14));

} else {
var statearr_111920_111975 = state_111896__$1;
(statearr_111920_111975[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111897 === (22))){
var inst_111847 = (state_111896[(2)]);
var state_111896__$1 = state_111896;
var statearr_111921_111976 = state_111896__$1;
(statearr_111921_111976[(2)] = inst_111847);

(statearr_111921_111976[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111897 === (36))){
var inst_111885 = (state_111896[(2)]);
var state_111896__$1 = state_111896;
var statearr_111922_111977 = state_111896__$1;
(statearr_111922_111977[(2)] = inst_111885);

(statearr_111922_111977[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111897 === (29))){
var inst_111849 = (state_111896[(17)]);
var state_111896__$1 = state_111896;
if(cljs.core.truth_(inst_111849)){
var statearr_111923_111978 = state_111896__$1;
(statearr_111923_111978[(1)] = (31));

} else {
var statearr_111924_111979 = state_111896__$1;
(statearr_111924_111979[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111897 === (6))){
var inst_111800 = (state_111896[(21)]);
var inst_111800__$1 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_111896__$1 = (function (){var statearr_111925 = state_111896;
(statearr_111925[(21)] = inst_111800__$1);

return statearr_111925;
})();
if(cljs.core.truth_(inst_111800__$1)){
var statearr_111926_111980 = state_111896__$1;
(statearr_111926_111980[(1)] = (8));

} else {
var statearr_111927_111981 = state_111896__$1;
(statearr_111927_111981[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111897 === (28))){
var inst_111860 = cljs.core.rest.call(null,flakes);
var state_111896__$1 = state_111896;
var statearr_111928_111982 = state_111896__$1;
(statearr_111928_111982[(2)] = inst_111860);

(statearr_111928_111982[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111897 === (25))){
var inst_111825 = (state_111896[(11)]);
var state_111896__$1 = state_111896;
var statearr_111929_111983 = state_111896__$1;
(statearr_111929_111983[(2)] = inst_111825);

(statearr_111929_111983[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111897 === (34))){
var inst_111796 = (state_111896[(8)]);
var inst_111867 = cljs.core.rest.call(null,flakes);
var inst_111869 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_111870 = [inst_111796];
var inst_111871 = (new cljs.core.PersistentVector(null,1,(5),inst_111869,inst_111870,null));
var inst_111872 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_111871);
var state_111896__$1 = (function (){var statearr_111930 = state_111896;
(statearr_111930[(18)] = inst_111867);

return statearr_111930;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_111896__$1,(37),inst_111872);
} else {
if((state_val_111897 === (17))){
var state_111896__$1 = state_111896;
var statearr_111931_111984 = state_111896__$1;
(statearr_111931_111984[(2)] = null);

(statearr_111931_111984[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111897 === (3))){
var inst_111787 = (state_111896[(2)]);
var state_111896__$1 = state_111896;
var statearr_111932_111985 = state_111896__$1;
(statearr_111932_111985[(2)] = inst_111787);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_111896__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111897 === (12))){
var state_111896__$1 = state_111896;
var statearr_111933_111986 = state_111896__$1;
(statearr_111933_111986[(2)] = false);

(statearr_111933_111986[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111897 === (2))){
var inst_111894 = (state_111896[(2)]);
var state_111896__$1 = state_111896;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_111896__$1,inst_111894);
} else {
if((state_val_111897 === (23))){
var inst_111843 = (state_111896[(2)]);
var inst_111844 = fluree.db.util.async.throw_err.call(null,inst_111843);
var state_111896__$1 = state_111896;
var statearr_111934_111987 = state_111896__$1;
(statearr_111934_111987[(2)] = inst_111844);

(statearr_111934_111987[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111897 === (35))){
var state_111896__$1 = state_111896;
var statearr_111935_111988 = state_111896__$1;
(statearr_111935_111988[(2)] = null);

(statearr_111935_111988[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111897 === (19))){
var inst_111817 = (state_111896[(20)]);
var inst_111795 = (state_111896[(15)]);
var inst_111807 = (state_111896[(9)]);
var inst_111849 = (state_111896[(2)]);
var inst_111850 = fluree.db.query.fql.add_in_multi_flakes.call(null,inst_111795,inst_111817,inst_111807,f,db,cache,fuel,max_fuel,pred_spec,component_follow_QMARK_,false);
var state_111896__$1 = (function (){var statearr_111936 = state_111896;
(statearr_111936[(17)] = inst_111849);

return statearr_111936;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_111896__$1,(24),inst_111850);
} else {
if((state_val_111897 === (11))){
var inst_111811 = (state_111896[(7)]);
var state_111896__$1 = state_111896;
var statearr_111937_111989 = state_111896__$1;
(statearr_111937_111989[(2)] = inst_111811);

(statearr_111937_111989[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111897 === (9))){
var inst_111803 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_111896__$1 = state_111896;
var statearr_111938_111990 = state_111896__$1;
(statearr_111938_111990[(2)] = inst_111803);

(statearr_111938_111990[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111897 === (5))){
var inst_111797 = (state_111896[(14)]);
var state_111896__$1 = state_111896;
var statearr_111939_111991 = state_111896__$1;
(statearr_111939_111991[(2)] = inst_111797);

(statearr_111939_111991[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111897 === (14))){
var inst_111825 = (state_111896[(11)]);
var state_111896__$1 = state_111896;
var statearr_111940_111992 = state_111896__$1;
(statearr_111940_111992[(2)] = inst_111825);

(statearr_111940_111992[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111897 === (26))){
var inst_111819 = (state_111896[(16)]);
var inst_111856 = cljs.core.not.call(null,inst_111819);
var state_111896__$1 = state_111896;
var statearr_111941_111993 = state_111896__$1;
(statearr_111941_111993[(2)] = inst_111856);

(statearr_111941_111993[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111897 === (16))){
var inst_111830 = (state_111896[(2)]);
var state_111896__$1 = state_111896;
if(cljs.core.truth_(inst_111830)){
var statearr_111942_111994 = state_111896__$1;
(statearr_111942_111994[(1)] = (17));

} else {
var statearr_111943_111995 = state_111896__$1;
(statearr_111943_111995[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111897 === (38))){
var inst_111875 = (state_111896[(13)]);
var inst_111877 = fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel);
var inst_111878 = cljs.core.sequence.call(null,inst_111877,inst_111875);
var state_111896__$1 = state_111896;
var statearr_111944_111996 = state_111896__$1;
(statearr_111944_111996[(2)] = inst_111878);

(statearr_111944_111996[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111897 === (30))){
var inst_111818 = (state_111896[(19)]);
var inst_111853 = (state_111896[(12)]);
var inst_111889 = (state_111896[(2)]);
var inst_111890 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_111891 = [inst_111853,inst_111889,inst_111818];
var inst_111892 = (new cljs.core.PersistentVector(null,3,(5),inst_111890,inst_111891,null));
var state_111896__$1 = state_111896;
var statearr_111945_111997 = state_111896__$1;
(statearr_111945_111997[(2)] = inst_111892);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_111896__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111897 === (10))){
var inst_111805 = (state_111896[(2)]);
var state_111896__$1 = state_111896;
var statearr_111946_111998 = state_111896__$1;
(statearr_111946_111998[(2)] = inst_111805);

(statearr_111946_111998[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111897 === (18))){
var inst_111838 = (state_111896[(10)]);
var inst_111818 = (state_111896[(19)]);
var inst_111833 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_111834 = f.p;
var inst_111835 = [new cljs.core.Keyword(null,"select-specs","select-specs",-681748023),inst_111834];
var inst_111836 = (new cljs.core.PersistentVector(null,2,(5),inst_111833,inst_111835,null));
var inst_111837 = cljs.core.get_in.call(null,inst_111818,inst_111836);
var inst_111838__$1 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs.call(null,inst_111837);
var state_111896__$1 = (function (){var statearr_111947 = state_111896;
(statearr_111947[(10)] = inst_111838__$1);

return statearr_111947;
})();
if(cljs.core.truth_(inst_111838__$1)){
var statearr_111948_111999 = state_111896__$1;
(statearr_111948_111999[(1)] = (20));

} else {
var statearr_111949_112000 = state_111896__$1;
(statearr_111949_112000[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111897 === (37))){
var inst_111874 = (state_111896[(2)]);
var inst_111875 = fluree.db.util.async.throw_err.call(null,inst_111874);
var state_111896__$1 = (function (){var statearr_111950 = state_111896;
(statearr_111950[(13)] = inst_111875);

return statearr_111950;
})();
if(cljs.core.truth_(fuel)){
var statearr_111951_112001 = state_111896__$1;
(statearr_111951_112001[(1)] = (38));

} else {
var statearr_111952_112002 = state_111896__$1;
(statearr_111952_112002[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_111897 === (8))){
var inst_111800 = (state_111896[(21)]);
var state_111896__$1 = state_111896;
var statearr_111953_112003 = state_111896__$1;
(statearr_111953_112003[(2)] = inst_111800);

(statearr_111953_112003[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__99975__auto__ = null;
var fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__99975__auto____0 = (function (){
var statearr_111954 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_111954[(0)] = fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__99975__auto__);

(statearr_111954[(1)] = (1));

return statearr_111954;
});
var fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__99975__auto____1 = (function (state_111896){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_111896);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e111955){if((e111955 instanceof Object)){
var ex__99978__auto__ = e111955;
var statearr_111956_112004 = state_111896;
(statearr_111956_112004[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_111896);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e111955;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__112005 = state_111896;
state_111896 = G__112005;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__99975__auto__ = function(state_111896){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__99975__auto____1.call(this,state_111896);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__99975__auto____0;
fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__99975__auto____1;
return fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_111957 = f__100070__auto__.call(null);
(statearr_111957[(6)] = c__100069__auto__);

return statearr_111957;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
fluree.db.query.fql.get_recursion_map = (function fluree$db$query$fql$get_recursion_map(db,recursion_map,select_spec,cache,k,f){
var select_spec__$1 = cljs.core.get_in.call(null,select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),f.p], null));
var full_select_spec = (cljs.core.truth_(fluree.db.query.fql.has_ns_lookups_QMARK_.call(null,select_spec__$1))?fluree.db.query.fql.full_select_spec.call(null,db,cache,select_spec__$1,fluree.db.query.fql.s.call(null,f)):select_spec__$1);
return cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,recursion_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,fluree.db.query.fql.s.call(null,f)], null),(0)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pred-ids","pred-ids",-1902141555),k], null),f.p),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select-specs","select-specs",-681748023),f.p], null),full_select_spec);
});
fluree.db.query.fql.flake__GT_recur = (function fluree$db$query$fql$flake__GT_recur(db,f,pred_spec,recursion_map,flakes,acc,fuel,max_fuel,select_spec,cache){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_112165){
var state_val_112166 = (state_112165[(1)]);
if((state_val_112166 === (7))){
var inst_112030 = (state_112165[(7)]);
var inst_112022 = (state_112165[(8)]);
var inst_112010 = (state_112165[(9)]);
var inst_112022__$1 = (state_112165[(2)]);
var inst_112023 = cljs.core.PersistentVector.EMPTY;
var inst_112024 = cljs.core.repeat.call(null,(0),inst_112022__$1);
var inst_112025 = cljs.core.into.call(null,inst_112023,inst_112024);
var inst_112026 = cljs.core.get_in.call(null,acc,inst_112025);
var inst_112027 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_112028 = [inst_112022__$1,inst_112010];
var inst_112029 = (new cljs.core.PersistentVector(null,2,(5),inst_112027,inst_112028,null));
var inst_112030__$1 = cljs.core.get_in.call(null,recursion_map,inst_112029);
var state_112165__$1 = (function (){var statearr_112167 = state_112165;
(statearr_112167[(7)] = inst_112030__$1);

(statearr_112167[(8)] = inst_112022__$1);

(statearr_112167[(10)] = inst_112026);

return statearr_112167;
})();
if(cljs.core.truth_(inst_112030__$1)){
var statearr_112168_112259 = state_112165__$1;
(statearr_112168_112259[(1)] = (11));

} else {
var statearr_112169_112260 = state_112165__$1;
(statearr_112169_112260[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112166 === (59))){
var inst_112147 = (state_112165[(11)]);
var state_112165__$1 = state_112165;
var statearr_112170_112261 = state_112165__$1;
(statearr_112170_112261[(2)] = inst_112147);

(statearr_112170_112261[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112166 === (20))){
var inst_112054 = (state_112165[(12)]);
var state_112165__$1 = state_112165;
var statearr_112171_112262 = state_112165__$1;
(statearr_112171_112262[(2)] = inst_112054);

(statearr_112171_112262[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112166 === (58))){
var inst_112147 = (state_112165[(11)]);
var inst_112149 = fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel);
var inst_112150 = cljs.core.sequence.call(null,inst_112149,inst_112147);
var state_112165__$1 = state_112165;
var statearr_112172_112263 = state_112165__$1;
(statearr_112172_112263[(2)] = inst_112150);

(statearr_112172_112263[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112166 === (60))){
var inst_112139 = (state_112165[(13)]);
var inst_112153 = (state_112165[(2)]);
var inst_112154 = cljs.core.concat.call(null,inst_112139,inst_112153);
var state_112165__$1 = state_112165;
var statearr_112173_112264 = state_112165__$1;
(statearr_112173_112264[(2)] = inst_112154);

(statearr_112173_112264[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112166 === (27))){
var state_112165__$1 = state_112165;
var statearr_112174_112265 = state_112165__$1;
(statearr_112174_112265[(2)] = null);

(statearr_112174_112265[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112166 === (1))){
var state_112165__$1 = state_112165;
var statearr_112175_112266 = state_112165__$1;
(statearr_112175_112266[(2)] = null);

(statearr_112175_112266[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112166 === (24))){
var inst_112066 = (state_112165[(14)]);
var inst_112049 = (state_112165[(15)]);
var inst_112061 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_112062 = f.p;
var inst_112063 = [new cljs.core.Keyword(null,"select-specs","select-specs",-681748023),inst_112062];
var inst_112064 = (new cljs.core.PersistentVector(null,2,(5),inst_112061,inst_112063,null));
var inst_112065 = cljs.core.get_in.call(null,inst_112049,inst_112064);
var inst_112066__$1 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs.call(null,inst_112065);
var state_112165__$1 = (function (){var statearr_112176 = state_112165;
(statearr_112176[(14)] = inst_112066__$1);

return statearr_112176;
})();
if(cljs.core.truth_(inst_112066__$1)){
var statearr_112177_112267 = state_112165__$1;
(statearr_112177_112267[(1)] = (26));

} else {
var statearr_112178_112268 = state_112165__$1;
(statearr_112178_112268[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112166 === (55))){
var inst_112010 = (state_112165[(9)]);
var inst_112139 = cljs.core.rest.call(null,flakes);
var inst_112141 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_112142 = [inst_112010];
var inst_112143 = (new cljs.core.PersistentVector(null,1,(5),inst_112141,inst_112142,null));
var inst_112144 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_112143);
var state_112165__$1 = (function (){var statearr_112179 = state_112165;
(statearr_112179[(13)] = inst_112139);

return statearr_112179;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_112165__$1,(57),inst_112144);
} else {
if((state_val_112166 === (39))){
var inst_112077 = (state_112165[(16)]);
var inst_112107 = (state_112165[(17)]);
var inst_112022 = (state_112165[(8)]);
var inst_112109 = cljs.core.get.call(null,inst_112107,inst_112022);
var inst_112110 = cljs.core.merge.call(null,inst_112109,inst_112077);
var inst_112111 = cljs.core.assoc.call(null,inst_112107,inst_112022,inst_112110);
var state_112165__$1 = state_112165;
var statearr_112180_112269 = state_112165__$1;
(statearr_112180_112269[(2)] = inst_112111);

(statearr_112180_112269[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112166 === (46))){
var state_112165__$1 = state_112165;
var statearr_112181_112270 = state_112165__$1;
(statearr_112181_112270[(1)] = (48));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112166 === (4))){
var inst_112012 = (state_112165[(18)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_112165,(3),Error,null,(2));
var inst_112010 = f.o;
var inst_112011 = new cljs.core.Keyword(null,"multi?","multi?",-749311069).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_112012__$1 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_112165__$1 = (function (){var statearr_112183 = state_112165;
(statearr_112183[(18)] = inst_112012__$1);

(statearr_112183[(19)] = inst_112011);

(statearr_112183[(9)] = inst_112010);

return statearr_112183;
})();
if(cljs.core.truth_(inst_112012__$1)){
var statearr_112184_112271 = state_112165__$1;
(statearr_112184_112271[(1)] = (5));

} else {
var statearr_112185_112272 = state_112165__$1;
(statearr_112185_112272[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112166 === (54))){
var inst_112137 = cljs.core.rest.call(null,flakes);
var state_112165__$1 = state_112165;
var statearr_112186_112273 = state_112165__$1;
(statearr_112186_112273[(2)] = inst_112137);

(statearr_112186_112273[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112166 === (15))){
var state_112165__$1 = state_112165;
var statearr_112187_112274 = state_112165__$1;
(statearr_112187_112274[(2)] = recursion_map);

(statearr_112187_112274[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112166 === (48))){
var inst_112114 = (state_112165[(20)]);
var inst_112022 = (state_112165[(8)]);
var inst_112121 = cljs.core.PersistentVector.EMPTY;
var inst_112122 = cljs.core.repeat.call(null,(0),inst_112022);
var inst_112123 = cljs.core.into.call(null,inst_112121,inst_112122);
var inst_112124 = cljs.core.assoc_in.call(null,acc,inst_112123,inst_112114);
var state_112165__$1 = state_112165;
var statearr_112188_112275 = state_112165__$1;
(statearr_112188_112275[(2)] = inst_112124);

(statearr_112188_112275[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112166 === (50))){
var inst_112127 = (state_112165[(2)]);
var state_112165__$1 = state_112165;
var statearr_112189_112276 = state_112165__$1;
(statearr_112189_112276[(2)] = inst_112127);

(statearr_112189_112276[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112166 === (21))){
var inst_112034 = (state_112165[(21)]);
var state_112165__$1 = state_112165;
var statearr_112190_112277 = state_112165__$1;
(statearr_112190_112277[(2)] = inst_112034);

(statearr_112190_112277[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112166 === (31))){
var inst_112011 = (state_112165[(19)]);
var state_112165__$1 = state_112165;
var statearr_112191_112278 = state_112165__$1;
(statearr_112191_112278[(2)] = inst_112011);

(statearr_112191_112278[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112166 === (32))){
var inst_112085 = (state_112165[(2)]);
var state_112165__$1 = state_112165;
if(cljs.core.truth_(inst_112085)){
var statearr_112192_112279 = state_112165__$1;
(statearr_112192_112279[(1)] = (33));

} else {
var statearr_112193_112280 = state_112165__$1;
(statearr_112193_112280[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112166 === (40))){
var inst_112107 = (state_112165[(17)]);
var state_112165__$1 = state_112165;
var statearr_112194_112281 = state_112165__$1;
(statearr_112194_112281[(2)] = inst_112107);

(statearr_112194_112281[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112166 === (56))){
var inst_112131 = (state_112165[(22)]);
var inst_112049 = (state_112165[(15)]);
var inst_112156 = (state_112165[(2)]);
var inst_112157 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_112158 = [inst_112131,inst_112156,inst_112049];
var inst_112159 = (new cljs.core.PersistentVector(null,3,(5),inst_112157,inst_112158,null));
var state_112165__$1 = state_112165;
var statearr_112195_112282 = state_112165__$1;
(statearr_112195_112282[(2)] = inst_112159);

(statearr_112195_112282[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112166 === (33))){
var inst_112049 = (state_112165[(15)]);
var inst_112087 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_112088 = cljs.core.rest.call(null,flakes);
var inst_112089 = [acc,inst_112088,inst_112049];
var inst_112090 = (new cljs.core.PersistentVector(null,3,(5),inst_112087,inst_112089,null));
var state_112165__$1 = state_112165;
var statearr_112196_112283 = state_112165__$1;
(statearr_112196_112283[(2)] = inst_112090);

(statearr_112196_112283[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112166 === (13))){
var inst_112034 = (state_112165[(21)]);
var inst_112034__$1 = (state_112165[(2)]);
var inst_112035 = cljs.core.not.call(null,inst_112034__$1);
var state_112165__$1 = (function (){var statearr_112197 = state_112165;
(statearr_112197[(21)] = inst_112034__$1);

return statearr_112197;
})();
if(inst_112035){
var statearr_112198_112284 = state_112165__$1;
(statearr_112198_112284[(1)] = (14));

} else {
var statearr_112199_112285 = state_112165__$1;
(statearr_112199_112285[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112166 === (22))){
var inst_112058 = (state_112165[(2)]);
var state_112165__$1 = state_112165;
if(cljs.core.truth_(inst_112058)){
var statearr_112200_112286 = state_112165__$1;
(statearr_112200_112286[(1)] = (23));

} else {
var statearr_112201_112287 = state_112165__$1;
(statearr_112201_112287[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112166 === (36))){
var inst_112022 = (state_112165[(8)]);
var inst_112026 = (state_112165[(10)]);
var inst_112010 = (state_112165[(9)]);
var inst_112093 = cljs.core.PersistentVector.EMPTY;
var inst_112094 = cljs.core.get.call(null,inst_112026,inst_112022);
var inst_112095 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_112096 = [inst_112010];
var inst_112097 = cljs.core.PersistentHashMap.fromArrays(inst_112095,inst_112096);
var inst_112098 = cljs.core.conj.call(null,inst_112094,inst_112097);
var inst_112099 = cljs.core.into.call(null,inst_112093,inst_112098);
var inst_112100 = cljs.core.assoc.call(null,inst_112026,inst_112022,inst_112099);
var state_112165__$1 = state_112165;
var statearr_112202_112288 = state_112165__$1;
(statearr_112202_112288[(2)] = inst_112100);

(statearr_112202_112288[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112166 === (41))){
var inst_112034 = (state_112165[(21)]);
var inst_112114 = (state_112165[(2)]);
var inst_112115 = cljs.core.not.call(null,inst_112034);
var state_112165__$1 = (function (){var statearr_112203 = state_112165;
(statearr_112203[(20)] = inst_112114);

return statearr_112203;
})();
if(inst_112115){
var statearr_112204_112289 = state_112165__$1;
(statearr_112204_112289[(1)] = (42));

} else {
var statearr_112205_112290 = state_112165__$1;
(statearr_112205_112290[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112166 === (43))){
var inst_112034 = (state_112165[(21)]);
var state_112165__$1 = state_112165;
if(cljs.core.truth_(inst_112034)){
var statearr_112206_112291 = state_112165__$1;
(statearr_112206_112291[(1)] = (45));

} else {
var statearr_112207_112292 = state_112165__$1;
(statearr_112207_112292[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112166 === (29))){
var inst_112071 = (state_112165[(2)]);
var inst_112072 = fluree.db.util.async.throw_err.call(null,inst_112071);
var state_112165__$1 = state_112165;
var statearr_112208_112293 = state_112165__$1;
(statearr_112208_112293[(2)] = inst_112072);

(statearr_112208_112293[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112166 === (44))){
var inst_112054 = (state_112165[(12)]);
var inst_112131 = (state_112165[(2)]);
var state_112165__$1 = (function (){var statearr_112209 = state_112165;
(statearr_112209[(22)] = inst_112131);

return statearr_112209;
})();
if(cljs.core.truth_(inst_112054)){
var statearr_112210_112294 = state_112165__$1;
(statearr_112210_112294[(1)] = (51));

} else {
var statearr_112211_112295 = state_112165__$1;
(statearr_112211_112295[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112166 === (6))){
var inst_112015 = (state_112165[(23)]);
var inst_112015__$1 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_112165__$1 = (function (){var statearr_112212 = state_112165;
(statearr_112212[(23)] = inst_112015__$1);

return statearr_112212;
})();
if(cljs.core.truth_(inst_112015__$1)){
var statearr_112213_112296 = state_112165__$1;
(statearr_112213_112296[(1)] = (8));

} else {
var statearr_112214_112297 = state_112165__$1;
(statearr_112214_112297[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112166 === (28))){
var inst_112075 = (state_112165[(2)]);
var state_112165__$1 = state_112165;
var statearr_112215_112298 = state_112165__$1;
(statearr_112215_112298[(2)] = inst_112075);

(statearr_112215_112298[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112166 === (51))){
var inst_112054 = (state_112165[(12)]);
var state_112165__$1 = state_112165;
var statearr_112216_112299 = state_112165__$1;
(statearr_112216_112299[(2)] = inst_112054);

(statearr_112216_112299[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112166 === (25))){
var inst_112011 = (state_112165[(19)]);
var inst_112077 = (state_112165[(2)]);
var state_112165__$1 = (function (){var statearr_112217 = state_112165;
(statearr_112217[(16)] = inst_112077);

return statearr_112217;
})();
if(cljs.core.truth_(inst_112011)){
var statearr_112218_112300 = state_112165__$1;
(statearr_112218_112300[(1)] = (30));

} else {
var statearr_112219_112301 = state_112165__$1;
(statearr_112219_112301[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112166 === (34))){
var inst_112011 = (state_112165[(19)]);
var state_112165__$1 = state_112165;
if(cljs.core.truth_(inst_112011)){
var statearr_112220_112302 = state_112165__$1;
(statearr_112220_112302[(1)] = (36));

} else {
var statearr_112221_112303 = state_112165__$1;
(statearr_112221_112303[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112166 === (17))){
var inst_112040 = (state_112165[(24)]);
var state_112165__$1 = state_112165;
var statearr_112222_112304 = state_112165__$1;
(statearr_112222_112304[(2)] = inst_112040);

(statearr_112222_112304[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112166 === (3))){
var inst_112006 = (state_112165[(2)]);
var state_112165__$1 = state_112165;
var statearr_112223_112305 = state_112165__$1;
(statearr_112223_112305[(2)] = inst_112006);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_112165__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112166 === (12))){
var state_112165__$1 = state_112165;
var statearr_112224_112306 = state_112165__$1;
(statearr_112224_112306[(2)] = false);

(statearr_112224_112306[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112166 === (2))){
var inst_112163 = (state_112165[(2)]);
var state_112165__$1 = state_112165;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_112165__$1,inst_112163);
} else {
if((state_val_112166 === (23))){
var state_112165__$1 = state_112165;
var statearr_112225_112307 = state_112165__$1;
(statearr_112225_112307[(2)] = null);

(statearr_112225_112307[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112166 === (47))){
var inst_112129 = (state_112165[(2)]);
var state_112165__$1 = state_112165;
var statearr_112226_112308 = state_112165__$1;
(statearr_112226_112308[(2)] = inst_112129);

(statearr_112226_112308[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112166 === (35))){
var inst_112161 = (state_112165[(2)]);
var state_112165__$1 = state_112165;
var statearr_112227_112309 = state_112165__$1;
(statearr_112227_112309[(2)] = inst_112161);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_112165__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112166 === (19))){
var inst_112054 = (state_112165[(12)]);
var inst_112049 = (state_112165[(15)]);
var inst_112022 = (state_112165[(8)]);
var inst_112049__$1 = (state_112165[(2)]);
var inst_112050 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_112051 = cljs.core.get.call(null,inst_112049__$1,inst_112022);
var inst_112052 = cljs.core.vals.call(null,inst_112051);
var inst_112053 = cljs.core.apply.call(null,cljs.core.max,inst_112052);
var inst_112054__$1 = (inst_112050 < inst_112053);
var state_112165__$1 = (function (){var statearr_112228 = state_112165;
(statearr_112228[(12)] = inst_112054__$1);

(statearr_112228[(15)] = inst_112049__$1);

return statearr_112228;
})();
if(cljs.core.truth_(inst_112054__$1)){
var statearr_112229_112310 = state_112165__$1;
(statearr_112229_112310[(1)] = (20));

} else {
var statearr_112230_112311 = state_112165__$1;
(statearr_112230_112311[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112166 === (57))){
var inst_112146 = (state_112165[(2)]);
var inst_112147 = fluree.db.util.async.throw_err.call(null,inst_112146);
var state_112165__$1 = (function (){var statearr_112231 = state_112165;
(statearr_112231[(11)] = inst_112147);

return statearr_112231;
})();
if(cljs.core.truth_(fuel)){
var statearr_112232_112312 = state_112165__$1;
(statearr_112232_112312[(1)] = (58));

} else {
var statearr_112233_112313 = state_112165__$1;
(statearr_112233_112313[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112166 === (11))){
var inst_112030 = (state_112165[(7)]);
var state_112165__$1 = state_112165;
var statearr_112234_112314 = state_112165__$1;
(statearr_112234_112314[(2)] = inst_112030);

(statearr_112234_112314[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112166 === (9))){
var inst_112018 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_112165__$1 = state_112165;
var statearr_112235_112315 = state_112165__$1;
(statearr_112235_112315[(2)] = inst_112018);

(statearr_112235_112315[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112166 === (5))){
var inst_112012 = (state_112165[(18)]);
var state_112165__$1 = state_112165;
var statearr_112236_112316 = state_112165__$1;
(statearr_112236_112316[(2)] = inst_112012);

(statearr_112236_112316[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112166 === (14))){
var inst_112022 = (state_112165[(8)]);
var inst_112037 = fluree.db.query.fql.get_recursion_map.call(null,db,recursion_map,select_spec,cache,inst_112022,f);
var state_112165__$1 = state_112165;
var statearr_112237_112317 = state_112165__$1;
(statearr_112237_112317[(2)] = inst_112037);

(statearr_112237_112317[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112166 === (45))){
var state_112165__$1 = state_112165;
var statearr_112238_112318 = state_112165__$1;
(statearr_112238_112318[(2)] = acc);

(statearr_112238_112318[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112166 === (53))){
var inst_112135 = (state_112165[(2)]);
var state_112165__$1 = state_112165;
if(cljs.core.truth_(inst_112135)){
var statearr_112239_112319 = state_112165__$1;
(statearr_112239_112319[(1)] = (54));

} else {
var statearr_112240_112320 = state_112165__$1;
(statearr_112240_112320[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112166 === (26))){
var inst_112066 = (state_112165[(14)]);
var inst_112068 = f.o;
var inst_112069 = fluree.db.query.fql.resolve_reverse_refs.call(null,db,cache,fuel,max_fuel,inst_112068,inst_112066);
var state_112165__$1 = state_112165;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_112165__$1,(29),inst_112069);
} else {
if((state_val_112166 === (16))){
var inst_112034 = (state_112165[(21)]);
var inst_112040 = (state_112165[(2)]);
var state_112165__$1 = (function (){var statearr_112241 = state_112165;
(statearr_112241[(24)] = inst_112040);

return statearr_112241;
})();
if(cljs.core.truth_(inst_112034)){
var statearr_112242_112321 = state_112165__$1;
(statearr_112242_112321[(1)] = (17));

} else {
var statearr_112243_112322 = state_112165__$1;
(statearr_112243_112322[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112166 === (38))){
var inst_112077 = (state_112165[(16)]);
var inst_112107 = (state_112165[(2)]);
var state_112165__$1 = (function (){var statearr_112244 = state_112165;
(statearr_112244[(17)] = inst_112107);

return statearr_112244;
})();
if(cljs.core.truth_(inst_112077)){
var statearr_112245_112323 = state_112165__$1;
(statearr_112245_112323[(1)] = (39));

} else {
var statearr_112246_112324 = state_112165__$1;
(statearr_112246_112324[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112166 === (30))){
var inst_112022 = (state_112165[(8)]);
var inst_112026 = (state_112165[(10)]);
var inst_112079 = cljs.core.get.call(null,inst_112026,inst_112022);
var inst_112080 = cljs.core.count.call(null,inst_112079);
var inst_112081 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_112082 = (inst_112080 > inst_112081);
var state_112165__$1 = state_112165;
var statearr_112247_112325 = state_112165__$1;
(statearr_112247_112325[(2)] = inst_112082);

(statearr_112247_112325[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112166 === (10))){
var inst_112020 = (state_112165[(2)]);
var state_112165__$1 = state_112165;
var statearr_112248_112326 = state_112165__$1;
(statearr_112248_112326[(2)] = inst_112020);

(statearr_112248_112326[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112166 === (18))){
var inst_112040 = (state_112165[(24)]);
var inst_112022 = (state_112165[(8)]);
var inst_112010 = (state_112165[(9)]);
var inst_112043 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_112044 = [inst_112022,inst_112010];
var inst_112045 = (new cljs.core.PersistentVector(null,2,(5),inst_112043,inst_112044,null));
var inst_112046 = ((0) + (1));
var inst_112047 = cljs.core.assoc_in.call(null,inst_112040,inst_112045,inst_112046);
var state_112165__$1 = state_112165;
var statearr_112249_112327 = state_112165__$1;
(statearr_112249_112327[(2)] = inst_112047);

(statearr_112249_112327[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112166 === (52))){
var inst_112034 = (state_112165[(21)]);
var state_112165__$1 = state_112165;
var statearr_112250_112328 = state_112165__$1;
(statearr_112250_112328[(2)] = inst_112034);

(statearr_112250_112328[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112166 === (42))){
var inst_112114 = (state_112165[(20)]);
var state_112165__$1 = state_112165;
var statearr_112251_112329 = state_112165__$1;
(statearr_112251_112329[(2)] = inst_112114);

(statearr_112251_112329[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112166 === (37))){
var inst_112022 = (state_112165[(8)]);
var inst_112026 = (state_112165[(10)]);
var inst_112010 = (state_112165[(9)]);
var inst_112102 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_112103 = [inst_112022,new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_112104 = (new cljs.core.PersistentVector(null,2,(5),inst_112102,inst_112103,null));
var inst_112105 = cljs.core.assoc_in.call(null,inst_112026,inst_112104,inst_112010);
var state_112165__$1 = state_112165;
var statearr_112252_112330 = state_112165__$1;
(statearr_112252_112330[(2)] = inst_112105);

(statearr_112252_112330[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112166 === (8))){
var inst_112015 = (state_112165[(23)]);
var state_112165__$1 = state_112165;
var statearr_112253_112331 = state_112165__$1;
(statearr_112253_112331[(2)] = inst_112015);

(statearr_112253_112331[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112166 === (49))){
var state_112165__$1 = state_112165;
var statearr_112254_112332 = state_112165__$1;
(statearr_112254_112332[(2)] = null);

(statearr_112254_112332[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flake__GT_recur_$_state_machine__99975__auto__ = null;
var fluree$db$query$fql$flake__GT_recur_$_state_machine__99975__auto____0 = (function (){
var statearr_112255 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_112255[(0)] = fluree$db$query$fql$flake__GT_recur_$_state_machine__99975__auto__);

(statearr_112255[(1)] = (1));

return statearr_112255;
});
var fluree$db$query$fql$flake__GT_recur_$_state_machine__99975__auto____1 = (function (state_112165){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_112165);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e112256){if((e112256 instanceof Object)){
var ex__99978__auto__ = e112256;
var statearr_112257_112333 = state_112165;
(statearr_112257_112333[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_112165);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e112256;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__112334 = state_112165;
state_112165 = G__112334;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$fql$flake__GT_recur_$_state_machine__99975__auto__ = function(state_112165){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__99975__auto____1.call(this,state_112165);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flake__GT_recur_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flake__GT_recur_$_state_machine__99975__auto____0;
fluree$db$query$fql$flake__GT_recur_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flake__GT_recur_$_state_machine__99975__auto____1;
return fluree$db$query$fql$flake__GT_recur_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_112258 = f__100070__auto__.call(null);
(statearr_112258[(6)] = c__100069__auto__);

return statearr_112258;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql.flakes__GT_res = (function fluree$db$query$fql$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,flakes){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_112518){
var state_val_112519 = (state_112518[(1)]);
if((state_val_112519 === (7))){
var inst_112514 = (state_112518[(2)]);
var state_112518__$1 = state_112518;
var statearr_112520_112599 = state_112518__$1;
(statearr_112520_112599[(2)] = inst_112514);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_112518__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112519 === (20))){
var inst_112356 = (state_112518[(7)]);
var inst_112376 = cljs.core.first.call(null,flakes);
var inst_112377 = fluree.db.query.fql.s.call(null,inst_112376);
var inst_112378 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs.call(null,inst_112356);
var inst_112379 = fluree.db.query.fql.resolve_reverse_refs.call(null,db,cache,fuel,max_fuel,inst_112377,inst_112378);
var state_112518__$1 = state_112518;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_112518__$1,(23),inst_112379);
} else {
if((state_val_112519 === (27))){
var inst_112405 = (state_112518[(8)]);
var inst_112389 = (state_112518[(9)]);
var inst_112356 = (state_112518[(7)]);
var inst_112400 = (state_112518[(10)]);
var inst_112407 = (state_112518[(11)]);
var inst_112400__$1 = cljs.core.first.call(null,inst_112389);
var inst_112401 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_112402 = inst_112400__$1.p;
var inst_112403 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),inst_112402];
var inst_112404 = (new cljs.core.PersistentVector(null,3,(5),inst_112401,inst_112403,null));
var inst_112405__$1 = cljs.core.get_in.call(null,inst_112356,inst_112404);
var inst_112406 = fluree.db.query.fql.component_follow_QMARK_.call(null,inst_112405__$1,inst_112356);
var inst_112407__$1 = new cljs.core.Keyword(null,"multi?","multi?",-749311069).cljs$core$IFn$_invoke$arity$1(inst_112405__$1);
var state_112518__$1 = (function (){var statearr_112521 = state_112518;
(statearr_112521[(8)] = inst_112405__$1);

(statearr_112521[(10)] = inst_112400__$1);

(statearr_112521[(12)] = inst_112406);

(statearr_112521[(11)] = inst_112407__$1);

return statearr_112521;
})();
if(cljs.core.truth_(inst_112407__$1)){
var statearr_112522_112600 = state_112518__$1;
(statearr_112522_112600[(1)] = (29));

} else {
var statearr_112523_112601 = state_112518__$1;
(statearr_112523_112601[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112519 === (1))){
var state_112518__$1 = state_112518;
var statearr_112524_112602 = state_112518__$1;
(statearr_112524_112602[(2)] = null);

(statearr_112524_112602[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112519 === (24))){
var inst_112389 = (state_112518[(9)]);
var inst_112394 = cljs.core.empty_QMARK_.call(null,inst_112389);
var state_112518__$1 = state_112518;
if(inst_112394){
var statearr_112525_112603 = state_112518__$1;
(statearr_112525_112603[(1)] = (26));

} else {
var statearr_112526_112604 = state_112518__$1;
(statearr_112526_112604[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112519 === (55))){
var state_112518__$1 = state_112518;
var statearr_112527_112605 = state_112518__$1;
(statearr_112527_112605[(2)] = null);

(statearr_112527_112605[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112519 === (39))){
var inst_112423 = (state_112518[(2)]);
var inst_112424 = fluree.db.util.async.throw_err.call(null,inst_112423);
var state_112518__$1 = state_112518;
var statearr_112528_112606 = state_112518__$1;
(statearr_112528_112606[(2)] = inst_112424);

(statearr_112528_112606[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112519 === (46))){
var inst_112481 = (state_112518[(2)]);
var state_112518__$1 = state_112518;
var statearr_112529_112607 = state_112518__$1;
(statearr_112529_112607[(2)] = inst_112481);

(statearr_112529_112607[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112519 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_112518,(3),Error,null,(2));
var inst_112339 = cljs.core.not_empty.call(null,flakes);
var state_112518__$1 = state_112518;
if(cljs.core.truth_(inst_112339)){
var statearr_112530_112608 = state_112518__$1;
(statearr_112530_112608[(1)] = (5));

} else {
var statearr_112531_112609 = state_112518__$1;
(statearr_112531_112609[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112519 === (54))){
var inst_112390 = (state_112518[(13)]);
var inst_112389 = (state_112518[(9)]);
var inst_112391 = (state_112518[(14)]);
var inst_112392 = (state_112518[(15)]);
var inst_112471 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_112472 = cljs.core.rest.call(null,inst_112389);
var inst_112473 = [inst_112390,inst_112472,inst_112391,inst_112392];
var inst_112474 = (new cljs.core.PersistentVector(null,4,(5),inst_112471,inst_112473,null));
var state_112518__$1 = state_112518;
var statearr_112532_112610 = state_112518__$1;
(statearr_112532_112610[(2)] = inst_112474);

(statearr_112532_112610[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112519 === (15))){
var inst_112356 = (state_112518[(7)]);
var inst_112360 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_112356);
var state_112518__$1 = state_112518;
var statearr_112533_112611 = state_112518__$1;
(statearr_112533_112611[(2)] = inst_112360);

(statearr_112533_112611[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112519 === (48))){
var inst_112356 = (state_112518[(7)]);
var inst_112456 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_112356);
var state_112518__$1 = state_112518;
var statearr_112534_112612 = state_112518__$1;
(statearr_112534_112612[(2)] = inst_112456);

(statearr_112534_112612[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112519 === (50))){
var inst_112459 = (state_112518[(2)]);
var state_112518__$1 = state_112518;
if(cljs.core.truth_(inst_112459)){
var statearr_112535_112613 = state_112518__$1;
(statearr_112535_112613[(1)] = (51));

} else {
var statearr_112536_112614 = state_112518__$1;
(statearr_112536_112614[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112519 === (21))){
var inst_112370 = (state_112518[(16)]);
var state_112518__$1 = state_112518;
var statearr_112537_112615 = state_112518__$1;
(statearr_112537_112615[(2)] = inst_112370);

(statearr_112537_112615[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112519 === (31))){
var inst_112412 = (state_112518[(2)]);
var state_112518__$1 = state_112518;
if(cljs.core.truth_(inst_112412)){
var statearr_112538_112616 = state_112518__$1;
(statearr_112538_112616[(1)] = (32));

} else {
var statearr_112539_112617 = state_112518__$1;
(statearr_112539_112617[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112519 === (32))){
var inst_112390 = (state_112518[(13)]);
var inst_112405 = (state_112518[(8)]);
var inst_112389 = (state_112518[(9)]);
var inst_112356 = (state_112518[(7)]);
var inst_112391 = (state_112518[(14)]);
var inst_112400 = (state_112518[(10)]);
var inst_112414 = fluree.db.query.fql.flake__GT_recur_multi.call(null,db,inst_112400,inst_112405,inst_112391,inst_112389,inst_112390,fuel,max_fuel,inst_112356,cache,fluree.db.query.fql.component_follow_QMARK_);
var state_112518__$1 = state_112518;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_112518__$1,(35),inst_112414);
} else {
if((state_val_112519 === (40))){
var inst_112390 = (state_112518[(13)]);
var inst_112405 = (state_112518[(8)]);
var inst_112400 = (state_112518[(10)]);
var inst_112406 = (state_112518[(12)]);
var inst_112392 = (state_112518[(15)]);
var inst_112430 = fluree.db.query.fql.add_pred.call(null,db,cache,fuel,max_fuel,inst_112390,inst_112405,inst_112400,inst_112406,false,inst_112392);
var state_112518__$1 = state_112518;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_112518__$1,(43),inst_112430);
} else {
if((state_val_112519 === (56))){
var inst_112477 = (state_112518[(2)]);
var state_112518__$1 = state_112518;
var statearr_112540_112618 = state_112518__$1;
(statearr_112540_112618[(2)] = inst_112477);

(statearr_112540_112618[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112519 === (33))){
var inst_112405 = (state_112518[(8)]);
var inst_112419 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_112405);
var state_112518__$1 = state_112518;
if(cljs.core.truth_(inst_112419)){
var statearr_112541_112619 = state_112518__$1;
(statearr_112541_112619[(1)] = (36));

} else {
var statearr_112542_112620 = state_112518__$1;
(statearr_112542_112620[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112519 === (13))){
var inst_112356 = (state_112518[(7)]);
var inst_112357 = (state_112518[(17)]);
var inst_112356__$1 = (state_112518[(2)]);
var inst_112357__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_112356__$1);
var state_112518__$1 = (function (){var statearr_112543 = state_112518;
(statearr_112543[(7)] = inst_112356__$1);

(statearr_112543[(17)] = inst_112357__$1);

return statearr_112543;
})();
if(cljs.core.truth_(inst_112357__$1)){
var statearr_112544_112621 = state_112518__$1;
(statearr_112544_112621[(1)] = (14));

} else {
var statearr_112545_112622 = state_112518__$1;
(statearr_112545_112622[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112519 === (22))){
var inst_112386 = (state_112518[(18)]);
var inst_112386__$1 = (state_112518[(2)]);
var inst_112387 = cljs.core.PersistentHashMap.EMPTY;
var inst_112388 = cljs.core.PersistentHashMap.EMPTY;
var inst_112389 = flakes;
var inst_112390 = inst_112386__$1;
var inst_112391 = inst_112387;
var inst_112392 = inst_112388;
var state_112518__$1 = (function (){var statearr_112546 = state_112518;
(statearr_112546[(13)] = inst_112390);

(statearr_112546[(18)] = inst_112386__$1);

(statearr_112546[(9)] = inst_112389);

(statearr_112546[(14)] = inst_112391);

(statearr_112546[(15)] = inst_112392);

return statearr_112546;
})();
var statearr_112547_112623 = state_112518__$1;
(statearr_112547_112623[(2)] = null);

(statearr_112547_112623[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112519 === (36))){
var inst_112390 = (state_112518[(13)]);
var inst_112405 = (state_112518[(8)]);
var inst_112389 = (state_112518[(9)]);
var inst_112356 = (state_112518[(7)]);
var inst_112391 = (state_112518[(14)]);
var inst_112400 = (state_112518[(10)]);
var inst_112421 = fluree.db.query.fql.flake__GT_recur.call(null,db,inst_112400,inst_112405,inst_112391,inst_112389,inst_112390,fuel,max_fuel,inst_112356,cache);
var state_112518__$1 = state_112518;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_112518__$1,(39),inst_112421);
} else {
if((state_val_112519 === (41))){
var inst_112356 = (state_112518[(7)]);
var inst_112441 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_112356);
var state_112518__$1 = state_112518;
if(cljs.core.truth_(inst_112441)){
var statearr_112548_112624 = state_112518__$1;
(statearr_112548_112624[(1)] = (44));

} else {
var statearr_112549_112625 = state_112518__$1;
(statearr_112549_112625[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112519 === (43))){
var inst_112389 = (state_112518[(9)]);
var inst_112391 = (state_112518[(14)]);
var inst_112432 = (state_112518[(2)]);
var inst_112433 = fluree.db.util.async.throw_err.call(null,inst_112432);
var inst_112434 = cljs.core.nth.call(null,inst_112433,(0),null);
var inst_112435 = cljs.core.nth.call(null,inst_112433,(1),null);
var inst_112436 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_112437 = cljs.core.rest.call(null,inst_112389);
var inst_112438 = [inst_112434,inst_112437,inst_112391,inst_112435];
var inst_112439 = (new cljs.core.PersistentVector(null,4,(5),inst_112436,inst_112438,null));
var state_112518__$1 = state_112518;
var statearr_112550_112626 = state_112518__$1;
(statearr_112550_112626[(2)] = inst_112439);

(statearr_112550_112626[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112519 === (29))){
var inst_112405 = (state_112518[(8)]);
var inst_112409 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_112405);
var state_112518__$1 = state_112518;
var statearr_112551_112627 = state_112518__$1;
(statearr_112551_112627[(2)] = inst_112409);

(statearr_112551_112627[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112519 === (44))){
var inst_112390 = (state_112518[(13)]);
var inst_112356 = (state_112518[(7)]);
var inst_112400 = (state_112518[(10)]);
var inst_112406 = (state_112518[(12)]);
var inst_112443 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_112444 = fluree.db.query.fql.add_pred.call(null,db,cache,fuel,max_fuel,inst_112390,inst_112356,inst_112400,inst_112406,false);
var state_112518__$1 = (function (){var statearr_112552 = state_112518;
(statearr_112552[(19)] = inst_112443);

return statearr_112552;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_112518__$1,(47),inst_112444);
} else {
if((state_val_112519 === (6))){
var state_112518__$1 = state_112518;
var statearr_112553_112628 = state_112518__$1;
(statearr_112553_112628[(2)] = null);

(statearr_112553_112628[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112519 === (28))){
var inst_112496 = (state_112518[(2)]);
var state_112518__$1 = state_112518;
var statearr_112554_112629 = state_112518__$1;
(statearr_112554_112629[(2)] = inst_112496);

(statearr_112554_112629[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112519 === (51))){
var inst_112389 = (state_112518[(9)]);
var inst_112391 = (state_112518[(14)]);
var inst_112400 = (state_112518[(10)]);
var inst_112392 = (state_112518[(15)]);
var inst_112461 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_112462 = ["_id"];
var inst_112463 = inst_112400.s;
var inst_112464 = [inst_112463];
var inst_112465 = cljs.core.PersistentHashMap.fromArrays(inst_112462,inst_112464);
var inst_112466 = cljs.core.rest.call(null,inst_112389);
var inst_112467 = [inst_112465,inst_112466,inst_112391,inst_112392];
var inst_112468 = (new cljs.core.PersistentVector(null,4,(5),inst_112461,inst_112467,null));
var state_112518__$1 = state_112518;
var statearr_112555_112630 = state_112518__$1;
(statearr_112555_112630[(2)] = inst_112468);

(statearr_112555_112630[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112519 === (25))){
var inst_112386 = (state_112518[(18)]);
var inst_112356 = (state_112518[(7)]);
var inst_112350 = (state_112518[(20)]);
var inst_112370 = (state_112518[(16)]);
var inst_112498 = (state_112518[(2)]);
var inst_112499 = (function (){var top_level_subject = inst_112350;
var select_spec = inst_112356;
var base_acc = inst_112370;
var acc_PLUS_refs = inst_112386;
var result = inst_112498;
return (function (acc,spec){
if(cljs.core.truth_((function (){var or__4126__auto__ = (function (){var and__4115__auto__ = new cljs.core.Keyword(null,"multi?","multi?",-749311069).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4115__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var and__4115__auto__ = new cljs.core.Keyword(null,"reverse?","reverse?",-1672868474).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4115__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4115__auto__;
}
}
})())){
return cljs.core.conj.call(null,acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(spec),new cljs.core.Keyword(null,"order","order",-1254677256).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"predicate","predicate",-1742501860).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
})();
var inst_112500 = cljs.core.PersistentVector.EMPTY;
var inst_112501 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_112356);
var inst_112502 = new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(inst_112501);
var inst_112503 = cljs.core.vals.call(null,inst_112502);
var inst_112504 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_112356);
var inst_112505 = new cljs.core.Keyword(null,"reverse","reverse",-888455266).cljs$core$IFn$_invoke$arity$1(inst_112504);
var inst_112506 = cljs.core.vals.call(null,inst_112505);
var inst_112507 = cljs.core.concat.call(null,inst_112503,inst_112506);
var inst_112508 = cljs.core.reduce.call(null,inst_112499,inst_112500,inst_112507);
var inst_112510 = (function (){var top_level_subject = inst_112350;
var select_spec = inst_112356;
var base_acc = inst_112370;
var acc_PLUS_refs = inst_112386;
var result = inst_112498;
var sort_preds = inst_112508;
return (function (acc,p__112509){
var vec__112556 = p__112509;
var selectPred = cljs.core.nth.call(null,vec__112556,(0),null);
var sortOrder = cljs.core.nth.call(null,vec__112556,(1),null);
var sortPred = cljs.core.nth.call(null,vec__112556,(2),null);
var limit = cljs.core.nth.call(null,vec__112556,(3),null);
return cljs.core.assoc.call(null,acc,selectPred,fluree.db.query.fql.sort_offset_and_limit_res.call(null,sortPred,sortOrder,(0),limit,cljs.core.get.call(null,acc,selectPred)));
});
})();
var inst_112511 = cljs.core.reduce.call(null,inst_112510,inst_112498,inst_112508);
var state_112518__$1 = state_112518;
var statearr_112559_112631 = state_112518__$1;
(statearr_112559_112631[(2)] = inst_112511);

(statearr_112559_112631[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112519 === (34))){
var inst_112400 = (state_112518[(10)]);
var inst_112487 = (state_112518[(2)]);
var inst_112488 = cljs.core.nth.call(null,inst_112487,(0),null);
var inst_112489 = cljs.core.nth.call(null,inst_112487,(1),null);
var inst_112490 = cljs.core.nth.call(null,inst_112487,(2),null);
var inst_112491 = cljs.core.nth.call(null,inst_112487,(3),null);
var inst_112492 = inst_112400.s;
var inst_112493 = cljs.core.assoc.call(null,inst_112488,new cljs.core.Keyword(null,"_id","_id",-789960287),inst_112492);
var inst_112389 = inst_112489;
var inst_112390 = inst_112493;
var inst_112391 = inst_112490;
var inst_112392 = inst_112491;
var state_112518__$1 = (function (){var statearr_112560 = state_112518;
(statearr_112560[(13)] = inst_112390);

(statearr_112560[(9)] = inst_112389);

(statearr_112560[(14)] = inst_112391);

(statearr_112560[(15)] = inst_112392);

return statearr_112560;
})();
var statearr_112561_112632 = state_112518__$1;
(statearr_112561_112632[(2)] = null);

(statearr_112561_112632[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112519 === (17))){
var inst_112350 = (state_112518[(20)]);
var inst_112364 = ["_id"];
var inst_112365 = [inst_112350];
var inst_112366 = cljs.core.PersistentHashMap.fromArrays(inst_112364,inst_112365);
var state_112518__$1 = state_112518;
var statearr_112562_112633 = state_112518__$1;
(statearr_112562_112633[(2)] = inst_112366);

(statearr_112562_112633[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112519 === (3))){
var inst_112335 = (state_112518[(2)]);
var state_112518__$1 = state_112518;
var statearr_112563_112634 = state_112518__$1;
(statearr_112563_112634[(2)] = inst_112335);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_112518__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112519 === (12))){
var state_112518__$1 = state_112518;
var statearr_112564_112635 = state_112518__$1;
(statearr_112564_112635[(2)] = base_select_spec);

(statearr_112564_112635[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112519 === (2))){
var inst_112516 = (state_112518[(2)]);
var state_112518__$1 = state_112518;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_112518__$1,inst_112516);
} else {
if((state_val_112519 === (23))){
var inst_112370 = (state_112518[(16)]);
var inst_112381 = (state_112518[(2)]);
var inst_112382 = fluree.db.util.async.throw_err.call(null,inst_112381);
var inst_112383 = cljs.core.merge.call(null,inst_112370,inst_112382);
var state_112518__$1 = state_112518;
var statearr_112565_112636 = state_112518__$1;
(statearr_112565_112636[(2)] = inst_112383);

(statearr_112565_112636[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112519 === (47))){
var inst_112389 = (state_112518[(9)]);
var inst_112443 = (state_112518[(19)]);
var inst_112391 = (state_112518[(14)]);
var inst_112392 = (state_112518[(15)]);
var inst_112446 = (state_112518[(2)]);
var inst_112447 = fluree.db.util.async.throw_err.call(null,inst_112446);
var inst_112448 = cljs.core.first.call(null,inst_112447);
var inst_112449 = cljs.core.rest.call(null,inst_112389);
var inst_112450 = [inst_112448,inst_112449,inst_112391,inst_112392];
var inst_112451 = (new cljs.core.PersistentVector(null,4,(5),inst_112443,inst_112450,null));
var state_112518__$1 = state_112518;
var statearr_112566_112637 = state_112518__$1;
(statearr_112566_112637[(2)] = inst_112451);

(statearr_112566_112637[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112519 === (35))){
var inst_112416 = (state_112518[(2)]);
var inst_112417 = fluree.db.util.async.throw_err.call(null,inst_112416);
var state_112518__$1 = state_112518;
var statearr_112567_112638 = state_112518__$1;
(statearr_112567_112638[(2)] = inst_112417);

(statearr_112567_112638[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112519 === (19))){
var inst_112356 = (state_112518[(7)]);
var inst_112370 = (state_112518[(2)]);
var inst_112371 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_112372 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)];
var inst_112373 = (new cljs.core.PersistentVector(null,2,(5),inst_112371,inst_112372,null));
var inst_112374 = cljs.core.get_in.call(null,inst_112356,inst_112373);
var state_112518__$1 = (function (){var statearr_112568 = state_112518;
(statearr_112568[(16)] = inst_112370);

return statearr_112568;
})();
if(cljs.core.truth_(inst_112374)){
var statearr_112569_112639 = state_112518__$1;
(statearr_112569_112639[(1)] = (20));

} else {
var statearr_112570_112640 = state_112518__$1;
(statearr_112570_112640[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112519 === (11))){
var inst_112350 = (state_112518[(20)]);
var inst_112353 = fluree.db.query.fql.full_select_spec.call(null,db,cache,base_select_spec,inst_112350);
var state_112518__$1 = state_112518;
var statearr_112571_112641 = state_112518__$1;
(statearr_112571_112641[(2)] = inst_112353);

(statearr_112571_112641[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112519 === (9))){
var inst_112341 = (state_112518[(2)]);
var inst_112342 = fluree.db.util.log.error.call(null,inst_112341);
var inst_112343 = (function(){throw inst_112341})();
var state_112518__$1 = (function (){var statearr_112572 = state_112518;
(statearr_112572[(21)] = inst_112342);

return statearr_112572;
})();
var statearr_112573_112642 = state_112518__$1;
(statearr_112573_112642[(2)] = inst_112343);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_112518__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112519 === (5))){
var state_112518__$1 = state_112518;
var statearr_112574_112643 = state_112518__$1;
(statearr_112574_112643[(2)] = null);

(statearr_112574_112643[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112519 === (14))){
var inst_112357 = (state_112518[(17)]);
var state_112518__$1 = state_112518;
var statearr_112575_112644 = state_112518__$1;
(statearr_112575_112644[(2)] = inst_112357);

(statearr_112575_112644[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112519 === (45))){
var inst_112356 = (state_112518[(7)]);
var inst_112453 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_112356);
var inst_112454 = cljs.core.empty_QMARK_.call(null,inst_112453);
var state_112518__$1 = state_112518;
if(inst_112454){
var statearr_112576_112645 = state_112518__$1;
(statearr_112576_112645[(1)] = (48));

} else {
var statearr_112577_112646 = state_112518__$1;
(statearr_112577_112646[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112519 === (53))){
var inst_112479 = (state_112518[(2)]);
var state_112518__$1 = state_112518;
var statearr_112578_112647 = state_112518__$1;
(statearr_112578_112647[(2)] = inst_112479);

(statearr_112578_112647[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112519 === (26))){
var inst_112390 = (state_112518[(13)]);
var state_112518__$1 = state_112518;
var statearr_112579_112648 = state_112518__$1;
(statearr_112579_112648[(2)] = inst_112390);

(statearr_112579_112648[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112519 === (16))){
var inst_112362 = (state_112518[(2)]);
var state_112518__$1 = state_112518;
if(cljs.core.truth_(inst_112362)){
var statearr_112580_112649 = state_112518__$1;
(statearr_112580_112649[(1)] = (17));

} else {
var statearr_112581_112650 = state_112518__$1;
(statearr_112581_112650[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112519 === (38))){
var inst_112485 = (state_112518[(2)]);
var state_112518__$1 = state_112518;
var statearr_112582_112651 = state_112518__$1;
(statearr_112582_112651[(2)] = inst_112485);

(statearr_112582_112651[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112519 === (30))){
var inst_112407 = (state_112518[(11)]);
var state_112518__$1 = state_112518;
var statearr_112583_112652 = state_112518__$1;
(statearr_112583_112652[(2)] = inst_112407);

(statearr_112583_112652[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112519 === (10))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_112518,(9),new cljs.core.Keyword(null,"default","default",-1987822328),null,(8));
var inst_112347 = cljs.core.first.call(null,flakes);
var inst_112348 = fluree.db.query.fql.s.call(null,inst_112347);
var state_112518__$1 = state_112518;
var statearr_112584_112653 = state_112518__$1;
(statearr_112584_112653[(2)] = inst_112348);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_112518__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112519 === (18))){
var inst_112368 = cljs.core.PersistentHashMap.EMPTY;
var state_112518__$1 = state_112518;
var statearr_112585_112654 = state_112518__$1;
(statearr_112585_112654[(2)] = inst_112368);

(statearr_112585_112654[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112519 === (52))){
var state_112518__$1 = state_112518;
var statearr_112586_112655 = state_112518__$1;
(statearr_112586_112655[(1)] = (54));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112519 === (42))){
var inst_112483 = (state_112518[(2)]);
var state_112518__$1 = state_112518;
var statearr_112588_112656 = state_112518__$1;
(statearr_112588_112656[(2)] = inst_112483);

(statearr_112588_112656[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112519 === (37))){
var inst_112405 = (state_112518[(8)]);
var state_112518__$1 = state_112518;
if(cljs.core.truth_(inst_112405)){
var statearr_112589_112657 = state_112518__$1;
(statearr_112589_112657[(1)] = (40));

} else {
var statearr_112590_112658 = state_112518__$1;
(statearr_112590_112658[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112519 === (8))){
var inst_112350 = (state_112518[(2)]);
var inst_112351 = fluree.db.query.fql.has_ns_lookups_QMARK_.call(null,base_select_spec);
var state_112518__$1 = (function (){var statearr_112591 = state_112518;
(statearr_112591[(20)] = inst_112350);

return statearr_112591;
})();
if(cljs.core.truth_(inst_112351)){
var statearr_112592_112659 = state_112518__$1;
(statearr_112592_112659[(1)] = (11));

} else {
var statearr_112593_112660 = state_112518__$1;
(statearr_112593_112660[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112519 === (49))){
var state_112518__$1 = state_112518;
var statearr_112594_112661 = state_112518__$1;
(statearr_112594_112661[(2)] = false);

(statearr_112594_112661[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flakes__GT_res_$_state_machine__99975__auto__ = null;
var fluree$db$query$fql$flakes__GT_res_$_state_machine__99975__auto____0 = (function (){
var statearr_112595 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_112595[(0)] = fluree$db$query$fql$flakes__GT_res_$_state_machine__99975__auto__);

(statearr_112595[(1)] = (1));

return statearr_112595;
});
var fluree$db$query$fql$flakes__GT_res_$_state_machine__99975__auto____1 = (function (state_112518){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_112518);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e112596){if((e112596 instanceof Object)){
var ex__99978__auto__ = e112596;
var statearr_112597_112662 = state_112518;
(statearr_112597_112662[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_112518);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e112596;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__112663 = state_112518;
state_112518 = G__112663;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$fql$flakes__GT_res_$_state_machine__99975__auto__ = function(state_112518){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__99975__auto____1.call(this,state_112518);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flakes__GT_res_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flakes__GT_res_$_state_machine__99975__auto____0;
fluree$db$query$fql$flakes__GT_res_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flakes__GT_res_$_state_machine__99975__auto____1;
return fluree$db$query$fql$flakes__GT_res_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_112598 = f__100070__auto__.call(null);
(statearr_112598[(6)] = c__100069__auto__);

return statearr_112598;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Runs a select statement based on a sequence of flakes.
 */
fluree.db.query.fql.flake_select = (function fluree$db$query$fql$flake_select(var_args){
var G__112666 = arguments.length;
switch (G__112666) {
case 6:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,flakes){
return fluree.db.query.fql.flake_select.call(null,db,cache,fuel,max_fuel,select_spec,flakes,null,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit){
return fluree.db.query.fql.flake_select.call(null,db,cache,fuel,max_fuel,select_spec,flakes,limit,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit,offset){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_112705){
var state_val_112706 = (state_112705[(1)]);
if((state_val_112706 === (7))){
var inst_112678 = (state_112705[(2)]);
var state_112705__$1 = (function (){var statearr_112707 = state_112705;
(statearr_112707[(7)] = inst_112678);

return statearr_112707;
})();
if(cljs.core.truth_(offset)){
var statearr_112708_112730 = state_112705__$1;
(statearr_112708_112730[(1)] = (8));

} else {
var statearr_112709_112731 = state_112705__$1;
(statearr_112709_112731[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112706 === (1))){
var state_112705__$1 = state_112705;
var statearr_112710_112732 = state_112705__$1;
(statearr_112710_112732[(2)] = null);

(statearr_112710_112732[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112706 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_112705,(3),Error,null,(2));
var inst_112672 = cljs.core.partition_by.call(null,fluree.db.query.fql.s);
var state_112705__$1 = (function (){var statearr_112711 = state_112705;
(statearr_112711[(8)] = inst_112672);

return statearr_112711;
})();
if(cljs.core.truth_(fuel)){
var statearr_112712_112733 = state_112705__$1;
(statearr_112712_112733[(1)] = (5));

} else {
var statearr_112713_112734 = state_112705__$1;
(statearr_112713_112734[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112706 === (13))){
var inst_112690 = (state_112705[(2)]);
var inst_112691 = (function (){return (function (x){
var and__4115__auto__ = max_fuel;
if(cljs.core.truth_(and__4115__auto__)){
return (cljs.core.deref.call(null,fuel) >= max_fuel);
} else {
return and__4115__auto__;
}
});
})();
var inst_112692 = cljs.core.halt_when.call(null,inst_112691);
var inst_112693 = cljs.core.comp.call(null,inst_112690,inst_112692);
var inst_112694 = cljs.core.sequence.call(null,inst_112693,flakes);
var inst_112695 = cljs.core.PersistentVector.EMPTY;
var inst_112696 = (function (){var xf = inst_112693;
var flakes_by_sub = inst_112694;
return (function (p1__112664_SHARP_){
return fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,select_spec,p1__112664_SHARP_);
});
})();
var inst_112697 = cljs.core.map.call(null,inst_112696,inst_112694);
var inst_112698 = fluree.db.util.async.merge_into_QMARK_.call(null,inst_112695,inst_112697);
var state_112705__$1 = state_112705;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_112705__$1,(14),inst_112698);
} else {
if((state_val_112706 === (6))){
var inst_112672 = (state_112705[(8)]);
var state_112705__$1 = state_112705;
var statearr_112714_112735 = state_112705__$1;
(statearr_112714_112735[(2)] = inst_112672);

(statearr_112714_112735[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112706 === (3))){
var inst_112667 = (state_112705[(2)]);
var state_112705__$1 = state_112705;
var statearr_112715_112736 = state_112705__$1;
(statearr_112715_112736[(2)] = inst_112667);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_112705__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112706 === (12))){
var inst_112684 = (state_112705[(9)]);
var state_112705__$1 = state_112705;
var statearr_112716_112737 = state_112705__$1;
(statearr_112716_112737[(2)] = inst_112684);

(statearr_112716_112737[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112706 === (2))){
var inst_112703 = (state_112705[(2)]);
var state_112705__$1 = state_112705;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_112705__$1,inst_112703);
} else {
if((state_val_112706 === (11))){
var inst_112684 = (state_112705[(9)]);
var inst_112686 = cljs.core.take.call(null,limit);
var inst_112687 = cljs.core.comp.call(null,inst_112684,inst_112686);
var state_112705__$1 = state_112705;
var statearr_112717_112738 = state_112705__$1;
(statearr_112717_112738[(2)] = inst_112687);

(statearr_112717_112738[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112706 === (9))){
var inst_112678 = (state_112705[(7)]);
var state_112705__$1 = state_112705;
var statearr_112718_112739 = state_112705__$1;
(statearr_112718_112739[(2)] = inst_112678);

(statearr_112718_112739[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112706 === (5))){
var inst_112672 = (state_112705[(8)]);
var inst_112674 = fluree.db.query.fql.fuel_flakes_transducer.call(null,fuel,max_fuel);
var inst_112675 = cljs.core.comp.call(null,inst_112672,inst_112674);
var state_112705__$1 = state_112705;
var statearr_112719_112740 = state_112705__$1;
(statearr_112719_112740[(2)] = inst_112675);

(statearr_112719_112740[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112706 === (14))){
var inst_112700 = (state_112705[(2)]);
var inst_112701 = fluree.db.util.async.throw_err.call(null,inst_112700);
var state_112705__$1 = state_112705;
var statearr_112720_112741 = state_112705__$1;
(statearr_112720_112741[(2)] = inst_112701);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_112705__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112706 === (10))){
var inst_112684 = (state_112705[(2)]);
var state_112705__$1 = (function (){var statearr_112721 = state_112705;
(statearr_112721[(9)] = inst_112684);

return statearr_112721;
})();
if(cljs.core.truth_(limit)){
var statearr_112722_112742 = state_112705__$1;
(statearr_112722_112742[(1)] = (11));

} else {
var statearr_112723_112743 = state_112705__$1;
(statearr_112723_112743[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112706 === (8))){
var inst_112678 = (state_112705[(7)]);
var inst_112680 = cljs.core.drop.call(null,offset);
var inst_112681 = cljs.core.comp.call(null,inst_112678,inst_112680);
var state_112705__$1 = state_112705;
var statearr_112724_112744 = state_112705__$1;
(statearr_112724_112744[(2)] = inst_112681);

(statearr_112724_112744[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__99975__auto__ = null;
var fluree$db$query$fql$state_machine__99975__auto____0 = (function (){
var statearr_112725 = [null,null,null,null,null,null,null,null,null,null];
(statearr_112725[(0)] = fluree$db$query$fql$state_machine__99975__auto__);

(statearr_112725[(1)] = (1));

return statearr_112725;
});
var fluree$db$query$fql$state_machine__99975__auto____1 = (function (state_112705){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_112705);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e112726){if((e112726 instanceof Object)){
var ex__99978__auto__ = e112726;
var statearr_112727_112745 = state_112705;
(statearr_112727_112745[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_112705);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e112726;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__112746 = state_112705;
state_112705 = G__112746;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__99975__auto__ = function(state_112705){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__99975__auto____1.call(this,state_112705);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__99975__auto____0;
fluree$db$query$fql$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__99975__auto____1;
return fluree$db$query$fql$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_112728 = f__100070__auto__.call(null);
(statearr_112728[(6)] = c__100069__auto__);

return statearr_112728;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.query.fql.flake_select.cljs$lang$maxFixedArity = 8);

/**
 * Like flake select, but takes a collection of subject ids which we
 *   then find collections of flakes for.
 */
fluree.db.query.fql.subject_select = (function fluree$db$query$fql$subject_select(var_args){
var G__112748 = arguments.length;
switch (G__112748) {
case 6:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,subjects){
return fluree.db.query.fql.subject_select.call(null,db,cache,fuel,max_fuel,select_spec,subjects,null,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit){
return fluree.db.query.fql.subject_select.call(null,db,cache,fuel,max_fuel,select_spec,subjects,limit,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit,offset){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_112826){
var state_val_112827 = (state_112826[(1)]);
if((state_val_112827 === (7))){
var inst_112774 = (state_112826[(7)]);
var state_112826__$1 = state_112826;
var statearr_112828_112868 = state_112826__$1;
(statearr_112828_112868[(2)] = inst_112774);

(statearr_112828_112868[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112827 === (20))){
var state_112826__$1 = state_112826;
var statearr_112829_112869 = state_112826__$1;
(statearr_112829_112869[(1)] = (22));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112827 === (1))){
var state_112826__$1 = state_112826;
var statearr_112831_112870 = state_112826__$1;
(statearr_112831_112870[(2)] = null);

(statearr_112831_112870[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112827 === (24))){
var inst_112816 = (state_112826[(2)]);
var state_112826__$1 = state_112826;
var statearr_112832_112871 = state_112826__$1;
(statearr_112832_112871[(2)] = inst_112816);

(statearr_112832_112871[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112827 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_112826,(3),Error,null,(2));
var inst_112760 = cljs.core.seq.call(null,subjects);
var inst_112761 = cljs.core.first.call(null,inst_112760);
var inst_112762 = cljs.core.next.call(null,inst_112760);
var inst_112763 = cljs.core.PersistentVector.EMPTY;
var inst_112764 = subjects;
var inst_112765 = (0);
var inst_112766 = inst_112763;
var state_112826__$1 = (function (){var statearr_112833 = state_112826;
(statearr_112833[(8)] = inst_112761);

(statearr_112833[(9)] = inst_112764);

(statearr_112833[(10)] = inst_112766);

(statearr_112833[(11)] = inst_112765);

(statearr_112833[(12)] = inst_112762);

return statearr_112833;
})();
var statearr_112834_112872 = state_112826__$1;
(statearr_112834_112872[(2)] = null);

(statearr_112834_112872[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112827 === (15))){
var inst_112820 = (state_112826[(2)]);
var state_112826__$1 = state_112826;
var statearr_112835_112873 = state_112826__$1;
(statearr_112835_112873[(2)] = inst_112820);

(statearr_112835_112873[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112827 === (21))){
var inst_112818 = (state_112826[(2)]);
var state_112826__$1 = state_112826;
var statearr_112836_112874 = state_112826__$1;
(statearr_112836_112874[(2)] = inst_112818);

(statearr_112836_112874[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112827 === (13))){
var inst_112766 = (state_112826[(10)]);
var state_112826__$1 = state_112826;
var statearr_112837_112875 = state_112826__$1;
(statearr_112837_112875[(2)] = inst_112766);

(statearr_112837_112875[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112827 === (22))){
var inst_112761 = (state_112826[(8)]);
var inst_112764 = (state_112826[(9)]);
var inst_112772 = (state_112826[(13)]);
var inst_112773 = (state_112826[(14)]);
var inst_112766 = (state_112826[(10)]);
var inst_112765 = (state_112826[(11)]);
var inst_112762 = (state_112826[(12)]);
var inst_112796 = (inst_112765 + (1));
var inst_112797 = (function (){var seq__112758 = inst_112762;
var r = inst_112773;
var vec__112768 = inst_112764;
var acc = inst_112766;
var n = inst_112765;
var s = inst_112772;
var G__112756 = inst_112764;
var seq__112769 = inst_112773;
var first__112770 = inst_112772;
var vec__112757 = subjects;
var first__112759 = inst_112761;
return (function (n__$1){
return fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,select_spec,n__$1);
});
})();
var inst_112798 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_112799 = [inst_112772];
var inst_112800 = (new cljs.core.PersistentVector(null,1,(5),inst_112798,inst_112799,null));
var inst_112801 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_112802 = [limit];
var inst_112803 = cljs.core.PersistentHashMap.fromArrays(inst_112801,inst_112802);
var inst_112804 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_112800,inst_112803);
var state_112826__$1 = (function (){var statearr_112838 = state_112826;
(statearr_112838[(15)] = inst_112797);

(statearr_112838[(16)] = inst_112796);

return statearr_112838;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_112826__$1,(26),inst_112804);
} else {
if((state_val_112827 === (6))){
var inst_112822 = (state_112826[(2)]);
var state_112826__$1 = state_112826;
var statearr_112839_112876 = state_112826__$1;
(statearr_112839_112876[(2)] = inst_112822);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_112826__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112827 === (25))){
var inst_112773 = (state_112826[(14)]);
var inst_112766 = (state_112826[(10)]);
var inst_112796 = (state_112826[(16)]);
var inst_112810 = (state_112826[(2)]);
var inst_112811 = fluree.db.util.async.throw_err.call(null,inst_112810);
var inst_112812 = cljs.core.conj.call(null,inst_112766,inst_112811);
var inst_112764 = inst_112773;
var inst_112765 = inst_112796;
var inst_112766__$1 = inst_112812;
var state_112826__$1 = (function (){var statearr_112840 = state_112826;
(statearr_112840[(9)] = inst_112764);

(statearr_112840[(10)] = inst_112766__$1);

(statearr_112840[(11)] = inst_112765);

return statearr_112840;
})();
var statearr_112841_112877 = state_112826__$1;
(statearr_112841_112877[(2)] = null);

(statearr_112841_112877[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112827 === (17))){
var state_112826__$1 = state_112826;
var statearr_112842_112878 = state_112826__$1;
(statearr_112842_112878[(2)] = offset);

(statearr_112842_112878[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112827 === (3))){
var inst_112749 = (state_112826[(2)]);
var state_112826__$1 = state_112826;
var statearr_112843_112879 = state_112826__$1;
(statearr_112843_112879[(2)] = inst_112749);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_112826__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112827 === (12))){
var inst_112781 = (state_112826[(2)]);
var state_112826__$1 = state_112826;
var statearr_112844_112880 = state_112826__$1;
(statearr_112844_112880[(2)] = inst_112781);

(statearr_112844_112880[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112827 === (2))){
var inst_112824 = (state_112826[(2)]);
var state_112826__$1 = state_112826;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_112826__$1,inst_112824);
} else {
if((state_val_112827 === (23))){
var state_112826__$1 = state_112826;
var statearr_112846_112881 = state_112826__$1;
(statearr_112846_112881[(2)] = null);

(statearr_112846_112881[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112827 === (19))){
var inst_112773 = (state_112826[(14)]);
var inst_112766 = (state_112826[(10)]);
var inst_112765 = (state_112826[(11)]);
var inst_112792 = (inst_112765 + (1));
var tmp112845 = inst_112766;
var inst_112764 = inst_112773;
var inst_112765__$1 = inst_112792;
var inst_112766__$1 = tmp112845;
var state_112826__$1 = (function (){var statearr_112847 = state_112826;
(statearr_112847[(9)] = inst_112764);

(statearr_112847[(10)] = inst_112766__$1);

(statearr_112847[(11)] = inst_112765__$1);

return statearr_112847;
})();
var statearr_112848_112882 = state_112826__$1;
(statearr_112848_112882[(2)] = null);

(statearr_112848_112882[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112827 === (11))){
var state_112826__$1 = state_112826;
var statearr_112849_112883 = state_112826__$1;
(statearr_112849_112883[(2)] = limit);

(statearr_112849_112883[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112827 === (9))){
var inst_112783 = (state_112826[(2)]);
var state_112826__$1 = state_112826;
if(cljs.core.truth_(inst_112783)){
var statearr_112850_112884 = state_112826__$1;
(statearr_112850_112884[(1)] = (13));

} else {
var statearr_112851_112885 = state_112826__$1;
(statearr_112851_112885[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112827 === (5))){
var inst_112764 = (state_112826[(9)]);
var inst_112772 = (state_112826[(13)]);
var inst_112774 = (state_112826[(7)]);
var inst_112771 = cljs.core.seq.call(null,inst_112764);
var inst_112772__$1 = cljs.core.first.call(null,inst_112771);
var inst_112773 = cljs.core.next.call(null,inst_112771);
var inst_112774__$1 = (inst_112772__$1 == null);
var state_112826__$1 = (function (){var statearr_112852 = state_112826;
(statearr_112852[(13)] = inst_112772__$1);

(statearr_112852[(7)] = inst_112774__$1);

(statearr_112852[(14)] = inst_112773);

return statearr_112852;
})();
if(cljs.core.truth_(inst_112774__$1)){
var statearr_112853_112886 = state_112826__$1;
(statearr_112853_112886[(1)] = (7));

} else {
var statearr_112854_112887 = state_112826__$1;
(statearr_112854_112887[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112827 === (14))){
var state_112826__$1 = state_112826;
if(cljs.core.truth_(offset)){
var statearr_112855_112888 = state_112826__$1;
(statearr_112855_112888[(1)] = (16));

} else {
var statearr_112856_112889 = state_112826__$1;
(statearr_112856_112889[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112827 === (26))){
var inst_112797 = (state_112826[(15)]);
var inst_112806 = (state_112826[(2)]);
var inst_112807 = fluree.db.util.async.throw_err.call(null,inst_112806);
var inst_112808 = inst_112797.call(null,inst_112807);
var state_112826__$1 = state_112826;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_112826__$1,(25),inst_112808);
} else {
if((state_val_112827 === (16))){
var inst_112765 = (state_112826[(11)]);
var inst_112787 = (inst_112765 < offset);
var state_112826__$1 = state_112826;
var statearr_112857_112890 = state_112826__$1;
(statearr_112857_112890[(2)] = inst_112787);

(statearr_112857_112890[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112827 === (10))){
var inst_112765 = (state_112826[(11)]);
var inst_112778 = (inst_112765 > limit);
var state_112826__$1 = state_112826;
var statearr_112858_112891 = state_112826__$1;
(statearr_112858_112891[(2)] = inst_112778);

(statearr_112858_112891[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112827 === (18))){
var inst_112790 = (state_112826[(2)]);
var state_112826__$1 = state_112826;
if(cljs.core.truth_(inst_112790)){
var statearr_112859_112892 = state_112826__$1;
(statearr_112859_112892[(1)] = (19));

} else {
var statearr_112860_112893 = state_112826__$1;
(statearr_112860_112893[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_112827 === (8))){
var state_112826__$1 = state_112826;
if(cljs.core.truth_(limit)){
var statearr_112861_112894 = state_112826__$1;
(statearr_112861_112894[(1)] = (10));

} else {
var statearr_112862_112895 = state_112826__$1;
(statearr_112862_112895[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__99975__auto__ = null;
var fluree$db$query$fql$state_machine__99975__auto____0 = (function (){
var statearr_112863 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_112863[(0)] = fluree$db$query$fql$state_machine__99975__auto__);

(statearr_112863[(1)] = (1));

return statearr_112863;
});
var fluree$db$query$fql$state_machine__99975__auto____1 = (function (state_112826){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_112826);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e112864){if((e112864 instanceof Object)){
var ex__99978__auto__ = e112864;
var statearr_112865_112896 = state_112826;
(statearr_112865_112896[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_112826);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e112864;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__112897 = state_112826;
state_112826 = G__112897;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__99975__auto__ = function(state_112826){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__99975__auto____1.call(this,state_112826);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__99975__auto____0;
fluree$db$query$fql$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__99975__auto____1;
return fluree$db$query$fql$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_112866 = f__100070__auto__.call(null);
(statearr_112866[(6)] = c__100069__auto__);

return statearr_112866;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.query.fql.subject_select.cljs$lang$maxFixedArity = 8);

fluree.db.query.fql.valid_where_predicate_QMARK_ = (function fluree$db$query$fql$valid_where_predicate_QMARK_(db,p){
var or__4126__auto__ = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p);
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"tag","tag",-1290361223),fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"type","type",1174270348),p));
}
}
});
/**
 * Takes a where clause and returns subjects that match.
 */
fluree.db.query.fql.where_filter = (function fluree$db$query$fql$where_filter(var_args){
var G__112899 = arguments.length;
switch (G__112899) {
case 2:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2 = (function (db,where_clause){
return fluree.db.query.fql.where_filter.call(null,db,where_clause,null);
}));

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3 = (function (db,where_clause,default_collection){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_113083){
var state_val_113084 = (state_113083[(1)]);
if((state_val_113084 === (7))){
var inst_113079 = (state_113083[(2)]);
var state_113083__$1 = state_113083;
var statearr_113085_113149 = state_113083__$1;
(statearr_113085_113149[(2)] = inst_113079);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_113083__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113084 === (20))){
var inst_112968 = (state_113083[(7)]);
var inst_112977 = (state_113083[(2)]);
var inst_112978 = fluree.db.util.async.throw_err.call(null,inst_112977);
var inst_112979 = cljs.core.concat.call(null,inst_112968,inst_112978);
var state_113083__$1 = state_113083;
var statearr_113086_113150 = state_113083__$1;
(statearr_113086_113150[(2)] = inst_112979);

(statearr_113086_113150[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113084 === (27))){
var inst_113051 = (state_113083[(2)]);
var state_113083__$1 = state_113083;
var statearr_113087_113151 = state_113083__$1;
(statearr_113087_113151[(2)] = inst_113051);

(statearr_113087_113151[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113084 === (1))){
var state_113083__$1 = state_113083;
var statearr_113088_113152 = state_113083__$1;
(statearr_113088_113152[(2)] = null);

(statearr_113088_113152[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113084 === (24))){
var inst_112988 = (state_113083[(2)]);
var inst_112989 = fluree.db.util.async.throw_err.call(null,inst_112988);
var state_113083__$1 = state_113083;
var statearr_113089_113153 = state_113083__$1;
(statearr_113089_113153[(2)] = inst_112989);

(statearr_113089_113153[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113084 === (39))){
var inst_113045 = (state_113083[(2)]);
var state_113083__$1 = state_113083;
var statearr_113090_113154 = state_113083__$1;
(statearr_113090_113154[(2)] = inst_113045);

(statearr_113090_113154[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113084 === (46))){
var inst_113072 = (state_113083[(2)]);
var state_113083__$1 = state_113083;
var statearr_113091_113155 = state_113083__$1;
(statearr_113091_113155[(2)] = inst_113072);

(statearr_113091_113155[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113084 === (4))){
var inst_112909 = (state_113083[(8)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_113083,(3),Error,null,(2));
var inst_112907 = fluree.db.query.fql_parser.parse_where.call(null,db,where_clause,default_collection);
var inst_112908 = cljs.core.nth.call(null,inst_112907,(0),null);
var inst_112909__$1 = cljs.core.nth.call(null,inst_112907,(1),null);
var inst_112910 = cljs.core.not_empty.call(null,inst_112909__$1);
var state_113083__$1 = (function (){var statearr_113092 = state_113083;
(statearr_113092[(8)] = inst_112909__$1);

(statearr_113092[(9)] = inst_112908);

return statearr_113092;
})();
if(cljs.core.truth_(inst_112910)){
var statearr_113093_113156 = state_113083__$1;
(statearr_113093_113156[(1)] = (5));

} else {
var statearr_113094_113157 = state_113083__$1;
(statearr_113094_113157[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113084 === (15))){
var inst_112939 = (state_113083[(10)]);
var inst_112953 = (state_113083[(2)]);
var inst_112957 = (cljs.core.not_EQ_ === inst_112939);
var state_113083__$1 = (function (){var statearr_113095 = state_113083;
(statearr_113095[(11)] = inst_112953);

return statearr_113095;
})();
if(inst_112957){
var statearr_113096_113158 = state_113083__$1;
(statearr_113096_113158[(1)] = (16));

} else {
var statearr_113097_113159 = state_113083__$1;
(statearr_113097_113159[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113084 === (21))){
var inst_112940 = (state_113083[(12)]);
var inst_112938 = (state_113083[(13)]);
var inst_112983 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_112984 = [inst_112938,inst_112940];
var inst_112985 = (new cljs.core.PersistentVector(null,2,(5),inst_112983,inst_112984,null));
var inst_112986 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_112985);
var state_113083__$1 = state_113083;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_113083__$1,(24),inst_112986);
} else {
if((state_val_113084 === (31))){
var inst_113049 = (state_113083[(2)]);
var state_113083__$1 = state_113083;
var statearr_113098_113160 = state_113083__$1;
(statearr_113098_113160[(2)] = inst_113049);

(statearr_113098_113160[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113084 === (32))){
var inst_113014 = (state_113083[(2)]);
var inst_113015 = fluree.db.util.async.throw_err.call(null,inst_113014);
var state_113083__$1 = state_113083;
var statearr_113099_113161 = state_113083__$1;
(statearr_113099_113161[(2)] = inst_113015);

(statearr_113099_113161[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113084 === (40))){
var inst_113040 = (state_113083[(2)]);
var inst_113041 = fluree.db.util.async.throw_err.call(null,inst_113040);
var state_113083__$1 = state_113083;
var statearr_113100_113162 = state_113083__$1;
(statearr_113100_113162[(2)] = inst_113041);

(statearr_113100_113162[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113084 === (33))){
var inst_112940 = (state_113083[(12)]);
var inst_112938 = (state_113083[(13)]);
var inst_113019 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_113020 = [inst_112938];
var inst_113021 = (new cljs.core.PersistentVector(null,1,(5),inst_113019,inst_113020,null));
var inst_113022 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_113023 = [inst_112938,inst_112940];
var inst_113024 = (new cljs.core.PersistentVector(null,2,(5),inst_113022,inst_113023,null));
var inst_113025 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_113021,cljs.core._LT_,inst_113024);
var state_113083__$1 = state_113083;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_113083__$1,(36),inst_113025);
} else {
if((state_val_113084 === (13))){
var inst_112938 = (state_113083[(13)]);
var inst_112944 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_112938);
var inst_112945 = ["Non-indexed predicates are not valid in where clause statements. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_112944)].join('');
var inst_112946 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_112947 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_112948 = cljs.core.PersistentHashMap.fromArrays(inst_112946,inst_112947);
var inst_112949 = cljs.core.ex_info.call(null,inst_112945,inst_112948);
var inst_112950 = (function(){throw inst_112949})();
var state_113083__$1 = state_113083;
var statearr_113101_113163 = state_113083__$1;
(statearr_113101_113163[(2)] = inst_112950);

(statearr_113101_113163[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113084 === (22))){
var inst_112939 = (state_113083[(10)]);
var inst_112991 = (cljs.core._GT_ === inst_112939);
var state_113083__$1 = state_113083;
if(inst_112991){
var statearr_113102_113164 = state_113083__$1;
(statearr_113102_113164[(1)] = (25));

} else {
var statearr_113103_113165 = state_113083__$1;
(statearr_113103_113165[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113084 === (36))){
var inst_113027 = (state_113083[(2)]);
var inst_113028 = fluree.db.util.async.throw_err.call(null,inst_113027);
var state_113083__$1 = state_113083;
var statearr_113104_113166 = state_113083__$1;
(statearr_113104_113166[(2)] = inst_113028);

(statearr_113104_113166[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113084 === (41))){
var inst_113064 = (state_113083[(14)]);
var inst_112908 = (state_113083[(9)]);
var inst_113064__$1 = (state_113083[(2)]);
var inst_113065 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"and","and",-971899817),inst_112908);
var inst_113066 = cljs.core.empty_QMARK_.call(null,inst_113064__$1);
var inst_113067 = ((inst_113065) && (inst_113066));
var state_113083__$1 = (function (){var statearr_113105 = state_113083;
(statearr_113105[(14)] = inst_113064__$1);

return statearr_113105;
})();
if(cljs.core.truth_(inst_113067)){
var statearr_113106_113167 = state_113083__$1;
(statearr_113106_113167[(1)] = (44));

} else {
var statearr_113107_113168 = state_113083__$1;
(statearr_113107_113168[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113084 === (43))){
var inst_112924 = (state_113083[(15)]);
var inst_113056 = (state_113083[(16)]);
var inst_113059 = cljs.core.PersistentHashSet.EMPTY;
var inst_113060 = cljs.core.into.call(null,inst_113059,inst_113056);
var inst_113061 = clojure.set.intersection.call(null,inst_112924,inst_113060);
var state_113083__$1 = state_113083;
var statearr_113108_113169 = state_113083__$1;
(statearr_113108_113169[(2)] = inst_113061);

(statearr_113108_113169[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113084 === (29))){
var inst_112940 = (state_113083[(12)]);
var inst_112938 = (state_113083[(13)]);
var inst_113006 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_113007 = [inst_112938,inst_112940];
var inst_113008 = (new cljs.core.PersistentVector(null,2,(5),inst_113006,inst_113007,null));
var inst_113009 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_113010 = [inst_112938];
var inst_113011 = (new cljs.core.PersistentVector(null,1,(5),inst_113009,inst_113010,null));
var inst_113012 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_113008,cljs.core._LT__EQ_,inst_113011);
var state_113083__$1 = state_113083;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_113083__$1,(32),inst_113012);
} else {
if((state_val_113084 === (44))){
var inst_113064 = (state_113083[(14)]);
var state_113083__$1 = state_113083;
var statearr_113109_113170 = state_113083__$1;
(statearr_113109_113170[(2)] = inst_113064);

(statearr_113109_113170[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113084 === (6))){
var state_113083__$1 = state_113083;
var statearr_113110_113171 = state_113083__$1;
(statearr_113110_113171[(2)] = null);

(statearr_113110_113171[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113084 === (28))){
var inst_113001 = (state_113083[(2)]);
var inst_113002 = fluree.db.util.async.throw_err.call(null,inst_113001);
var state_113083__$1 = state_113083;
var statearr_113111_113172 = state_113083__$1;
(statearr_113111_113172[(2)] = inst_113002);

(statearr_113111_113172[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113084 === (25))){
var inst_112940 = (state_113083[(12)]);
var inst_112938 = (state_113083[(13)]);
var inst_112993 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_112994 = [inst_112938,inst_112940];
var inst_112995 = (new cljs.core.PersistentVector(null,2,(5),inst_112993,inst_112994,null));
var inst_112996 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_112997 = [inst_112938];
var inst_112998 = (new cljs.core.PersistentVector(null,1,(5),inst_112996,inst_112997,null));
var inst_112999 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT_,inst_112995,cljs.core._LT__EQ_,inst_112998);
var state_113083__$1 = state_113083;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_113083__$1,(28),inst_112999);
} else {
if((state_val_113084 === (34))){
var inst_112939 = (state_113083[(10)]);
var inst_113030 = (cljs.core._LT__EQ_ === inst_112939);
var state_113083__$1 = state_113083;
if(inst_113030){
var statearr_113112_113173 = state_113083__$1;
(statearr_113112_113173[(1)] = (37));

} else {
var statearr_113113_113174 = state_113083__$1;
(statearr_113113_113174[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113084 === (17))){
var inst_112939 = (state_113083[(10)]);
var inst_112981 = (cljs.core._EQ_ === inst_112939);
var state_113083__$1 = state_113083;
if(inst_112981){
var statearr_113114_113175 = state_113083__$1;
(statearr_113114_113175[(1)] = (21));

} else {
var statearr_113115_113176 = state_113083__$1;
(statearr_113115_113176[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113084 === (3))){
var inst_112900 = (state_113083[(2)]);
var state_113083__$1 = state_113083;
var statearr_113116_113177 = state_113083__$1;
(statearr_113116_113177[(2)] = inst_112900);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_113083__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113084 === (12))){
var inst_113074 = (state_113083[(2)]);
var state_113083__$1 = state_113083;
var statearr_113117_113178 = state_113083__$1;
(statearr_113117_113178[(2)] = inst_113074);

(statearr_113117_113178[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113084 === (2))){
var inst_113081 = (state_113083[(2)]);
var state_113083__$1 = state_113083;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_113083__$1,inst_113081);
} else {
if((state_val_113084 === (23))){
var inst_113053 = (state_113083[(2)]);
var state_113083__$1 = state_113083;
var statearr_113118_113179 = state_113083__$1;
(statearr_113118_113179[(2)] = inst_113053);

(statearr_113118_113179[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113084 === (35))){
var inst_113047 = (state_113083[(2)]);
var state_113083__$1 = state_113083;
var statearr_113119_113180 = state_113083__$1;
(statearr_113119_113180[(2)] = inst_113047);

(statearr_113119_113180[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113084 === (19))){
var inst_112940 = (state_113083[(12)]);
var inst_112938 = (state_113083[(13)]);
var inst_112967 = (state_113083[(2)]);
var inst_112968 = fluree.db.util.async.throw_err.call(null,inst_112967);
var inst_112969 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_112970 = [inst_112938];
var inst_112971 = (new cljs.core.PersistentVector(null,1,(5),inst_112969,inst_112970,null));
var inst_112972 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_112973 = [inst_112938,inst_112940];
var inst_112974 = (new cljs.core.PersistentVector(null,2,(5),inst_112972,inst_112973,null));
var inst_112975 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_112971,cljs.core._LT_,inst_112974);
var state_113083__$1 = (function (){var statearr_113120 = state_113083;
(statearr_113120[(7)] = inst_112968);

return statearr_113120;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_113083__$1,(20),inst_112975);
} else {
if((state_val_113084 === (11))){
var inst_112930 = (state_113083[(17)]);
var inst_112938 = (state_113083[(13)]);
var inst_112938__$1 = cljs.core.nth.call(null,inst_112930,(0),null);
var inst_112939 = cljs.core.nth.call(null,inst_112930,(1),null);
var inst_112940 = cljs.core.nth.call(null,inst_112930,(2),null);
var inst_112941 = fluree.db.query.fql.valid_where_predicate_QMARK_.call(null,db,inst_112938__$1);
var inst_112942 = cljs.core.not.call(null,inst_112941);
var state_113083__$1 = (function (){var statearr_113121 = state_113083;
(statearr_113121[(10)] = inst_112939);

(statearr_113121[(12)] = inst_112940);

(statearr_113121[(13)] = inst_112938__$1);

return statearr_113121;
})();
if(inst_112942){
var statearr_113122_113181 = state_113083__$1;
(statearr_113122_113181[(1)] = (13));

} else {
var statearr_113123_113182 = state_113083__$1;
(statearr_113123_113182[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113084 === (9))){
var inst_113076 = (state_113083[(2)]);
var state_113083__$1 = state_113083;
var statearr_113124_113183 = state_113083__$1;
(statearr_113124_113183[(2)] = inst_113076);

(statearr_113124_113183[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113084 === (5))){
var inst_112909 = (state_113083[(8)]);
var inst_112919 = cljs.core.seq.call(null,inst_112909);
var inst_112920 = cljs.core.first.call(null,inst_112919);
var inst_112921 = cljs.core.next.call(null,inst_112919);
var inst_112922 = cljs.core.PersistentHashSet.EMPTY;
var inst_112923 = inst_112909;
var inst_112924 = inst_112922;
var state_113083__$1 = (function (){var statearr_113125 = state_113083;
(statearr_113125[(18)] = inst_112921);

(statearr_113125[(19)] = inst_112923);

(statearr_113125[(15)] = inst_112924);

(statearr_113125[(20)] = inst_112920);

return statearr_113125;
})();
var statearr_113126_113184 = state_113083__$1;
(statearr_113126_113184[(2)] = null);

(statearr_113126_113184[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113084 === (14))){
var state_113083__$1 = state_113083;
var statearr_113127_113185 = state_113083__$1;
(statearr_113127_113185[(2)] = null);

(statearr_113127_113185[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113084 === (45))){
var inst_112931 = (state_113083[(21)]);
var inst_113064 = (state_113083[(14)]);
var inst_112923 = inst_112931;
var inst_112924 = inst_113064;
var state_113083__$1 = (function (){var statearr_113128 = state_113083;
(statearr_113128[(19)] = inst_112923);

(statearr_113128[(15)] = inst_112924);

return statearr_113128;
})();
var statearr_113129_113186 = state_113083__$1;
(statearr_113129_113186[(2)] = null);

(statearr_113129_113186[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113084 === (26))){
var inst_112939 = (state_113083[(10)]);
var inst_113004 = (cljs.core._GT__EQ_ === inst_112939);
var state_113083__$1 = state_113083;
if(inst_113004){
var statearr_113130_113187 = state_113083__$1;
(statearr_113130_113187[(1)] = (29));

} else {
var statearr_113131_113188 = state_113083__$1;
(statearr_113131_113188[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113084 === (16))){
var inst_112940 = (state_113083[(12)]);
var inst_112938 = (state_113083[(13)]);
var inst_112959 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_112960 = [inst_112938,inst_112940];
var inst_112961 = (new cljs.core.PersistentVector(null,2,(5),inst_112959,inst_112960,null));
var inst_112962 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_112963 = [inst_112938];
var inst_112964 = (new cljs.core.PersistentVector(null,1,(5),inst_112962,inst_112963,null));
var inst_112965 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT_,inst_112961,cljs.core._LT__EQ_,inst_112964);
var state_113083__$1 = state_113083;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_113083__$1,(19),inst_112965);
} else {
if((state_val_113084 === (38))){
var inst_113043 = null;
var state_113083__$1 = state_113083;
var statearr_113132_113189 = state_113083__$1;
(statearr_113132_113189[(2)] = inst_113043);

(statearr_113132_113189[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113084 === (30))){
var inst_112939 = (state_113083[(10)]);
var inst_113017 = (cljs.core._LT_ === inst_112939);
var state_113083__$1 = state_113083;
if(inst_113017){
var statearr_113133_113190 = state_113083__$1;
(statearr_113133_113190[(1)] = (33));

} else {
var statearr_113134_113191 = state_113083__$1;
(statearr_113134_113191[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113084 === (10))){
var inst_112924 = (state_113083[(15)]);
var state_113083__$1 = state_113083;
var statearr_113135_113192 = state_113083__$1;
(statearr_113135_113192[(2)] = inst_112924);

(statearr_113135_113192[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113084 === (18))){
var inst_112908 = (state_113083[(9)]);
var inst_113055 = (state_113083[(2)]);
var inst_113056 = cljs.core.map.call(null,fluree.db.query.fql.s,inst_113055);
var state_113083__$1 = (function (){var statearr_113136 = state_113083;
(statearr_113136[(16)] = inst_113056);

return statearr_113136;
})();
var G__113137_113193 = inst_112908;
var G__113137_113194__$1 = (((G__113137_113193 instanceof cljs.core.Keyword))?G__113137_113193.fqn:null);
switch (G__113137_113194__$1) {
case "or":
var statearr_113138_113196 = state_113083__$1;
(statearr_113138_113196[(1)] = (42));


break;
case "and":
var statearr_113139_113197 = state_113083__$1;
(statearr_113139_113197[(1)] = (43));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__113137_113194__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113084 === (42))){
var inst_112924 = (state_113083[(15)]);
var inst_113056 = (state_113083[(16)]);
var inst_113057 = cljs.core.into.call(null,inst_112924,inst_113056);
var state_113083__$1 = state_113083;
var statearr_113140_113198 = state_113083__$1;
(statearr_113140_113198[(2)] = inst_113057);

(statearr_113140_113198[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113084 === (37))){
var inst_112940 = (state_113083[(12)]);
var inst_112938 = (state_113083[(13)]);
var inst_113032 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_113033 = [inst_112938];
var inst_113034 = (new cljs.core.PersistentVector(null,1,(5),inst_113032,inst_113033,null));
var inst_113035 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_113036 = [inst_112938,inst_112940];
var inst_113037 = (new cljs.core.PersistentVector(null,2,(5),inst_113035,inst_113036,null));
var inst_113038 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_113034,cljs.core._LT__EQ_,inst_113037);
var state_113083__$1 = state_113083;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_113083__$1,(40),inst_113038);
} else {
if((state_val_113084 === (8))){
var inst_112930 = (state_113083[(17)]);
var inst_112923 = (state_113083[(19)]);
var inst_112929 = cljs.core.seq.call(null,inst_112923);
var inst_112930__$1 = cljs.core.first.call(null,inst_112929);
var inst_112931 = cljs.core.next.call(null,inst_112929);
var inst_112932 = cljs.core.not.call(null,inst_112930__$1);
var state_113083__$1 = (function (){var statearr_113141 = state_113083;
(statearr_113141[(17)] = inst_112930__$1);

(statearr_113141[(21)] = inst_112931);

return statearr_113141;
})();
if(inst_112932){
var statearr_113142_113199 = state_113083__$1;
(statearr_113142_113199[(1)] = (10));

} else {
var statearr_113143_113200 = state_113083__$1;
(statearr_113143_113200[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__99975__auto__ = null;
var fluree$db$query$fql$state_machine__99975__auto____0 = (function (){
var statearr_113144 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_113144[(0)] = fluree$db$query$fql$state_machine__99975__auto__);

(statearr_113144[(1)] = (1));

return statearr_113144;
});
var fluree$db$query$fql$state_machine__99975__auto____1 = (function (state_113083){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_113083);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e113145){if((e113145 instanceof Object)){
var ex__99978__auto__ = e113145;
var statearr_113146_113201 = state_113083;
(statearr_113146_113201[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_113083);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e113145;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__113202 = state_113083;
state_113083 = G__113202;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__99975__auto__ = function(state_113083){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__99975__auto____1.call(this,state_113083);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__99975__auto____0;
fluree$db$query$fql$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__99975__auto____1;
return fluree$db$query$fql$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_113147 = f__100070__auto__.call(null);
(statearr_113147[(6)] = c__100069__auto__);

return statearr_113147;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.query.fql.where_filter.cljs$lang$maxFixedArity = 3);

/**
 * Order By can be:
 *  - Single variable, ?favNums
 *  - Two-tuple,  [ASC, ?favNums]
 */
fluree.db.query.fql.order_offset_and_limit_results = (function fluree$db$query$fql$order_offset_and_limit_results(orderBy,p__113204,offset,limit){
var map__113205 = p__113204;
var map__113205__$1 = (((((!((map__113205 == null))))?(((((map__113205.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__113205.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__113205):map__113205);
var res = map__113205__$1;
var headers = cljs.core.get.call(null,map__113205__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__113205__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__113207 = orderBy;
var order = cljs.core.nth.call(null,vec__113207,(0),null);
var var$ = cljs.core.nth.call(null,vec__113207,(1),null);
var indexOfFind = (function (){var or__4126__auto__ = fluree.db.util.core.index_of.call(null,headers,cljs.core.symbol.call(null,var$));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (-1);
}
})();
var tuples__$1 = ((((0) <= indexOfFind))?(function (){var G__113210 = cljs.core.sort_by.call(null,(function (p1__113203_SHARP_){
return cljs.core.nth.call(null,p1__113203_SHARP_,indexOfFind);
}),fluree.db.query.fql.compare_fn,tuples);
var G__113210__$1 = ((cljs.core._EQ_.call(null,"DESC",order))?cljs.core.reverse.call(null,G__113210):G__113210);
var G__113210__$2 = (cljs.core.truth_(offset)?cljs.core.drop.call(null,offset,G__113210__$1):G__113210__$1);
if(cljs.core.truth_(limit)){
return cljs.core.take.call(null,limit,G__113210__$2);
} else {
return G__113210__$2;
}
})():tuples);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples__$1], null);
});
fluree.db.query.fql.parse_map = (function fluree$db$query$fql$parse_map(x,valid_var){
var _ = ((cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,cljs.core.keys.call(null,x))))?null:(function(){throw cljs.core.ex_info.call(null,["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var var_as_symbol = cljs.core.symbol.call(null,cljs.core.first.call(null,cljs.core.keys.call(null,x)));
var ___$1 = (cljs.core.truth_(valid_var.call(null,var_as_symbol))?null:(function(){throw cljs.core.ex_info.call(null,["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"variable","variable",-281346492),var_as_symbol,new cljs.core.Keyword(null,"selection","selection",975998651),cljs.core.first.call(null,cljs.core.vals.call(null,x))], null);
});
fluree.db.query.fql.parse_select = (function fluree$db$query$fql$parse_select(vars,interim_vars,select_smt){
var _ = (function (){var or__4126__auto__ = cljs.core.every_QMARK_.call(null,(function (p1__113211_SHARP_){
return ((typeof p1__113211_SHARP_ === 'string') || (cljs.core.map_QMARK_.call(null,p1__113211_SHARP_)));
}),select_smt);
if(or__4126__auto__){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid select statement. Every selection must be a string or map. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select_smt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vars__$1 = cljs.core.set.call(null,vars);
var all_vars = cljs.core.set.call(null,cljs.core.concat.call(null,vars__$1,cljs.core.keys.call(null,interim_vars)));
return cljs.core.map.call(null,(function (select){
var var_symbol = ((cljs.core.map_QMARK_.call(null,select))?null:cljs.core.symbol.call(null,select));
if(cljs.core.truth_(vars__$1.call(null,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"variable","variable",-281346492),var_symbol], null);
} else {
if(cljs.core.truth_(fluree.db.query.analytical.aggregate_QMARK_.call(null,select))){
return fluree.db.query.analytical.parse_aggregate.call(null,select,vars__$1);
} else {
if(cljs.core.map_QMARK_.call(null,select)){
return fluree.db.query.fql.parse_map.call(null,select,all_vars);
} else {
if(cljs.core.truth_(cljs.core.get.call(null,interim_vars,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),cljs.core.get.call(null,interim_vars,var_symbol)], null);
} else {
throw cljs.core.ex_info.call(null,["Invalid select in statement, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));

}
}
}
}
}),select_smt);
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.call(null,(function (select__$1){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies.call(null,vars);
if(cljs.core.every_QMARK_.call(null,(function (p1__113212_SHARP_){
return cljs.core._EQ_.call(null,(1),p1__113212_SHARP_);
}),cljs.core.vals.call(null,freqs))){
return vars;
} else {
var G__113216 = vars;
var vec__113217 = G__113216;
var seq__113218 = cljs.core.seq.call(null,vec__113217);
var first__113219 = cljs.core.first.call(null,seq__113218);
var seq__113218__$1 = cljs.core.next.call(null,seq__113218);
var var$ = first__113219;
var r = seq__113218__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__113216__$1 = G__113216;
var all_vars__$1 = all_vars;
while(true){
var vec__113223 = G__113216__$1;
var seq__113224 = cljs.core.seq.call(null,vec__113223);
var first__113225 = cljs.core.first.call(null,seq__113224);
var seq__113224__$1 = cljs.core.next.call(null,seq__113224);
var var$__$1 = first__113225;
var r__$1 = seq__113224__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not.call(null,var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_(cljs.core.set.call(null,all_vars__$2).call(null,var$__$1))){
var G__113226 = r__$1;
var G__113227 = cljs.core.conj.call(null,all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,all_vars__$2))].join(''));
G__113216__$1 = G__113226;
all_vars__$1 = G__113227;
continue;
} else {
var G__113228 = r__$1;
var G__113229 = cljs.core.conj.call(null,all_vars__$2,var$__$1);
G__113216__$1 = G__113228;
all_vars__$1 = G__113229;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.format_tuple = (function fluree$db$query$fql$format_tuple(functionArray,tuple){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_113263){
var state_val_113264 = (state_113263[(1)]);
if((state_val_113264 === (1))){
var inst_113237 = cljs.core.seq.call(null,functionArray);
var inst_113238 = cljs.core.first.call(null,inst_113237);
var inst_113239 = cljs.core.next.call(null,inst_113237);
var inst_113240 = cljs.core.PersistentVector.EMPTY;
var inst_113241 = functionArray;
var inst_113242 = inst_113240;
var state_113263__$1 = (function (){var statearr_113265 = state_113263;
(statearr_113265[(7)] = inst_113239);

(statearr_113265[(8)] = inst_113241);

(statearr_113265[(9)] = inst_113238);

(statearr_113265[(10)] = inst_113242);

return statearr_113265;
})();
var statearr_113266_113278 = state_113263__$1;
(statearr_113266_113278[(2)] = null);

(statearr_113266_113278[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113264 === (2))){
var inst_113241 = (state_113263[(8)]);
var inst_113248 = (state_113263[(11)]);
var inst_113247 = cljs.core.seq.call(null,inst_113241);
var inst_113248__$1 = cljs.core.first.call(null,inst_113247);
var inst_113249 = cljs.core.next.call(null,inst_113247);
var state_113263__$1 = (function (){var statearr_113267 = state_113263;
(statearr_113267[(11)] = inst_113248__$1);

(statearr_113267[(12)] = inst_113249);

return statearr_113267;
})();
if(cljs.core.truth_(inst_113248__$1)){
var statearr_113268_113279 = state_113263__$1;
(statearr_113268_113279[(1)] = (4));

} else {
var statearr_113269_113280 = state_113263__$1;
(statearr_113269_113280[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113264 === (3))){
var inst_113261 = (state_113263[(2)]);
var state_113263__$1 = state_113263;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_113263__$1,inst_113261);
} else {
if((state_val_113264 === (4))){
var inst_113248 = (state_113263[(11)]);
var inst_113251 = inst_113248.call(null,tuple);
var state_113263__$1 = state_113263;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_113263__$1,(7),inst_113251);
} else {
if((state_val_113264 === (5))){
var inst_113242 = (state_113263[(10)]);
var state_113263__$1 = state_113263;
var statearr_113270_113281 = state_113263__$1;
(statearr_113270_113281[(2)] = inst_113242);

(statearr_113270_113281[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113264 === (6))){
var inst_113259 = (state_113263[(2)]);
var state_113263__$1 = state_113263;
var statearr_113271_113282 = state_113263__$1;
(statearr_113271_113282[(2)] = inst_113259);

(statearr_113271_113282[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113264 === (7))){
var inst_113242 = (state_113263[(10)]);
var inst_113249 = (state_113263[(12)]);
var inst_113253 = (state_113263[(2)]);
var inst_113254 = fluree.db.util.async.throw_err.call(null,inst_113253);
var inst_113255 = cljs.core.conj.call(null,inst_113242,inst_113254);
var inst_113241 = inst_113249;
var inst_113242__$1 = inst_113255;
var state_113263__$1 = (function (){var statearr_113272 = state_113263;
(statearr_113272[(8)] = inst_113241);

(statearr_113272[(10)] = inst_113242__$1);

return statearr_113272;
})();
var statearr_113273_113283 = state_113263__$1;
(statearr_113273_113283[(2)] = null);

(statearr_113273_113283[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_tuple_$_state_machine__99975__auto__ = null;
var fluree$db$query$fql$format_tuple_$_state_machine__99975__auto____0 = (function (){
var statearr_113274 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_113274[(0)] = fluree$db$query$fql$format_tuple_$_state_machine__99975__auto__);

(statearr_113274[(1)] = (1));

return statearr_113274;
});
var fluree$db$query$fql$format_tuple_$_state_machine__99975__auto____1 = (function (state_113263){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_113263);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e113275){if((e113275 instanceof Object)){
var ex__99978__auto__ = e113275;
var statearr_113276_113284 = state_113263;
(statearr_113276_113284[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_113263);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e113275;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__113285 = state_113263;
state_113263 = G__113285;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$fql$format_tuple_$_state_machine__99975__auto__ = function(state_113263){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_tuple_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_tuple_$_state_machine__99975__auto____1.call(this,state_113263);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_tuple_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_tuple_$_state_machine__99975__auto____0;
fluree$db$query$fql$format_tuple_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_tuple_$_state_machine__99975__auto____1;
return fluree$db$query$fql$format_tuple_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_113277 = f__100070__auto__.call(null);
(statearr_113277[(6)] = c__100069__auto__);

return statearr_113277;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,headers,new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,cljs.core.map.call(null,cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,headers,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
fluree.db.query.fql.format_filter_tuples = (function fluree$db$query$fql$format_filter_tuples(db,tuples,p__113287,headers,vars,opts){
var map__113288 = p__113287;
var map__113288__$1 = (((((!((map__113288 == null))))?(((((map__113288.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__113288.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__113288):map__113288);
var select_spec = map__113288__$1;
var prettyPrint = cljs.core.get.call(null,map__113288__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var select = cljs.core.get.call(null,map__113288__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var inVector_QMARK_ = cljs.core.get.call(null,map__113288__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var expandMaps_QMARK_ = cljs.core.get.call(null,map__113288__$1,new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444));
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_113371){
var state_val_113372 = (state_113371[(1)]);
if((state_val_113372 === (7))){
var inst_113298 = (state_113371[(2)]);
var state_113371__$1 = (function (){var statearr_113373 = state_113371;
(statearr_113373[(7)] = inst_113298);

return statearr_113373;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_113374_113485 = state_113371__$1;
(statearr_113374_113485[(1)] = (8));

} else {
var statearr_113375_113486 = state_113371__$1;
(statearr_113375_113486[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113372 === (1))){
var state_113371__$1 = state_113371;
var statearr_113376_113487 = state_113371__$1;
(statearr_113376_113487[(2)] = null);

(statearr_113376_113487[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113372 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_113371,(3),Error,null,(2));
var state_113371__$1 = state_113371;
if(cljs.core.truth_(prettyPrint)){
var statearr_113377_113488 = state_113371__$1;
(statearr_113377_113488[(1)] = (5));

} else {
var statearr_113378_113489 = state_113371__$1;
(statearr_113378_113489[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113372 === (13))){
var inst_113367 = (state_113371[(2)]);
var state_113371__$1 = state_113371;
var statearr_113379_113490 = state_113371__$1;
(statearr_113379_113490[(2)] = inst_113367);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_113371__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113372 === (6))){
var state_113371__$1 = state_113371;
var statearr_113380_113491 = state_113371__$1;
(statearr_113380_113491[(2)] = null);

(statearr_113380_113491[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113372 === (3))){
var inst_113290 = (state_113371[(2)]);
var state_113371__$1 = state_113371;
var statearr_113381_113492 = state_113371__$1;
(statearr_113381_113492[(2)] = inst_113290);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_113371__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113372 === (12))){
var inst_113306 = (state_113371[(8)]);
var inst_113298 = (state_113371[(7)]);
var inst_113364 = (function (){var pp = inst_113298;
var functionArray = inst_113306;
return (function (tuple){
var tuple_res = cljs.core.map.call(null,(function (p1__113286_SHARP_){
return p1__113286_SHARP_.call(null,tuple);
}),functionArray);
if(cljs.core.truth_(pp)){
return cljs.core.zipmap.call(null,pp,tuple_res);
} else {
if(cljs.core.truth_(inVector_QMARK_)){
return tuple_res;
} else {
return cljs.core.first.call(null,tuple_res);

}
}
});
})();
var inst_113365 = cljs.core.map.call(null,inst_113364,tuples);
var state_113371__$1 = state_113371;
var statearr_113382_113493 = state_113371__$1;
(statearr_113382_113493[(2)] = inst_113365);

(statearr_113382_113493[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113372 === (2))){
var inst_113369 = (state_113371[(2)]);
var state_113371__$1 = state_113371;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_113371__$1,inst_113369);
} else {
if((state_val_113372 === (11))){
var inst_113306 = (state_113371[(8)]);
var inst_113298 = (state_113371[(7)]);
var inst_113357 = cljs.core.async.chan.call(null,(1));
var inst_113358 = (function (){var pp = inst_113298;
var functionArray = inst_113306;
var c__100069__auto____$1 = inst_113357;
return (function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_113355){
var state_val_113356 = (state_113355[(1)]);
if((state_val_113356 === (7))){
var inst_113331 = (state_113355[(2)]);
var inst_113332 = fluree.db.util.async.throw_err.call(null,inst_113331);
var state_113355__$1 = (function (){var statearr_113383 = state_113355;
(statearr_113383[(7)] = inst_113332);

return statearr_113383;
})();
if(cljs.core.truth_(pp)){
var statearr_113384_113494 = state_113355__$1;
(statearr_113384_113494[(1)] = (8));

} else {
var statearr_113385_113495 = state_113355__$1;
(statearr_113385_113495[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113356 === (1))){
var inst_113315 = cljs.core.seq.call(null,tuples);
var inst_113316 = cljs.core.first.call(null,inst_113315);
var inst_113317 = cljs.core.next.call(null,inst_113315);
var inst_113318 = cljs.core.PersistentVector.EMPTY;
var inst_113319 = tuples;
var inst_113320 = inst_113318;
var state_113355__$1 = (function (){var statearr_113386 = state_113355;
(statearr_113386[(8)] = inst_113316);

(statearr_113386[(9)] = inst_113317);

(statearr_113386[(10)] = inst_113320);

(statearr_113386[(11)] = inst_113319);

return statearr_113386;
})();
var statearr_113387_113496 = state_113355__$1;
(statearr_113387_113496[(2)] = null);

(statearr_113387_113496[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113356 === (4))){
var inst_113326 = (state_113355[(12)]);
var inst_113329 = fluree.db.query.fql.format_tuple.call(null,functionArray,inst_113326);
var state_113355__$1 = state_113355;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_113355__$1,(7),inst_113329);
} else {
if((state_val_113356 === (15))){
var state_113355__$1 = state_113355;
var statearr_113388_113497 = state_113355__$1;
(statearr_113388_113497[(2)] = null);

(statearr_113388_113497[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113356 === (13))){
var inst_113344 = (state_113355[(2)]);
var state_113355__$1 = state_113355;
var statearr_113389_113498 = state_113355__$1;
(statearr_113389_113498[(2)] = inst_113344);

(statearr_113389_113498[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113356 === (6))){
var inst_113351 = (state_113355[(2)]);
var state_113355__$1 = state_113355;
var statearr_113390_113499 = state_113355__$1;
(statearr_113390_113499[(2)] = inst_113351);

(statearr_113390_113499[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113356 === (3))){
var inst_113353 = (state_113355[(2)]);
var state_113355__$1 = state_113355;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_113355__$1,inst_113353);
} else {
if((state_val_113356 === (12))){
var state_113355__$1 = state_113355;
var statearr_113391_113500 = state_113355__$1;
(statearr_113391_113500[(1)] = (14));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113356 === (2))){
var inst_113326 = (state_113355[(12)]);
var inst_113319 = (state_113355[(11)]);
var inst_113325 = cljs.core.seq.call(null,inst_113319);
var inst_113326__$1 = cljs.core.first.call(null,inst_113325);
var inst_113327 = cljs.core.next.call(null,inst_113325);
var state_113355__$1 = (function (){var statearr_113393 = state_113355;
(statearr_113393[(13)] = inst_113327);

(statearr_113393[(12)] = inst_113326__$1);

return statearr_113393;
})();
if(cljs.core.truth_(inst_113326__$1)){
var statearr_113394_113501 = state_113355__$1;
(statearr_113394_113501[(1)] = (4));

} else {
var statearr_113395_113502 = state_113355__$1;
(statearr_113395_113502[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113356 === (11))){
var inst_113332 = (state_113355[(7)]);
var state_113355__$1 = state_113355;
var statearr_113396_113503 = state_113355__$1;
(statearr_113396_113503[(2)] = inst_113332);

(statearr_113396_113503[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113356 === (9))){
var state_113355__$1 = state_113355;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_113397_113504 = state_113355__$1;
(statearr_113397_113504[(1)] = (11));

} else {
var statearr_113398_113505 = state_113355__$1;
(statearr_113398_113505[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113356 === (5))){
var inst_113320 = (state_113355[(10)]);
var state_113355__$1 = state_113355;
var statearr_113399_113506 = state_113355__$1;
(statearr_113399_113506[(2)] = inst_113320);

(statearr_113399_113506[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113356 === (14))){
var inst_113332 = (state_113355[(7)]);
var inst_113339 = cljs.core.first.call(null,inst_113332);
var state_113355__$1 = state_113355;
var statearr_113400_113507 = state_113355__$1;
(statearr_113400_113507[(2)] = inst_113339);

(statearr_113400_113507[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113356 === (16))){
var inst_113342 = (state_113355[(2)]);
var state_113355__$1 = state_113355;
var statearr_113401_113508 = state_113355__$1;
(statearr_113401_113508[(2)] = inst_113342);

(statearr_113401_113508[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113356 === (10))){
var inst_113327 = (state_113355[(13)]);
var inst_113320 = (state_113355[(10)]);
var inst_113346 = (state_113355[(2)]);
var inst_113347 = cljs.core.conj.call(null,inst_113320,inst_113346);
var inst_113319 = inst_113327;
var inst_113320__$1 = inst_113347;
var state_113355__$1 = (function (){var statearr_113402 = state_113355;
(statearr_113402[(10)] = inst_113320__$1);

(statearr_113402[(11)] = inst_113319);

return statearr_113402;
})();
var statearr_113403_113509 = state_113355__$1;
(statearr_113403_113509[(2)] = null);

(statearr_113403_113509[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113356 === (8))){
var inst_113332 = (state_113355[(7)]);
var inst_113334 = cljs.core.zipmap.call(null,pp,inst_113332);
var state_113355__$1 = state_113355;
var statearr_113404_113510 = state_113355__$1;
(statearr_113404_113510[(2)] = inst_113334);

(statearr_113404_113510[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__99975__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__99975__auto____0 = (function (){
var statearr_113405 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_113405[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__99975__auto__);

(statearr_113405[(1)] = (1));

return statearr_113405;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__99975__auto____1 = (function (state_113355){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_113355);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e113406){if((e113406 instanceof Object)){
var ex__99978__auto__ = e113406;
var statearr_113407_113511 = state_113355;
(statearr_113407_113511[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_113355);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e113406;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__113512 = state_113355;
state_113355 = G__113512;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__99975__auto__ = function(state_113355){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__99975__auto____1.call(this,state_113355);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__99975__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__99975__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_113408 = f__100070__auto__.call(null);
(statearr_113408[(6)] = c__100069__auto____$1);

return statearr_113408;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
});
})();
var inst_113359 = cljs.core.async.impl.dispatch.run.call(null,inst_113358);
var state_113371__$1 = (function (){var statearr_113409 = state_113371;
(statearr_113409[(9)] = inst_113359);

return statearr_113409;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_113371__$1,(14),inst_113357);
} else {
if((state_val_113372 === (9))){
var inst_113298 = (state_113371[(7)]);
var inst_113303 = (function (){var pp = inst_113298;
return (function (select__$1){
var temp__5733__auto__ = new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(select__$1);
if(cljs.core.truth_(temp__5733__auto__)){
var val = temp__5733__auto__;
return (function (x){
return val;
});
} else {
var idx = fluree.db.query.fql.get_header_idx.call(null,headers,select__$1);
return (function (tuple){
return cljs.core.nth.call(null,tuple,idx);
});
}
});
})();
var inst_113304 = cljs.core.map.call(null,inst_113303,select);
var state_113371__$1 = state_113371;
var statearr_113410_113513 = state_113371__$1;
(statearr_113410_113513[(2)] = inst_113304);

(statearr_113410_113513[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113372 === (5))){
var inst_113295 = fluree.db.query.fql.get_pretty_print_keys.call(null,select);
var state_113371__$1 = state_113371;
var statearr_113411_113514 = state_113371__$1;
(statearr_113411_113514[(2)] = inst_113295);

(statearr_113411_113514[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113372 === (14))){
var inst_113361 = (state_113371[(2)]);
var inst_113362 = fluree.db.util.async.throw_err.call(null,inst_113361);
var state_113371__$1 = state_113371;
var statearr_113412_113515 = state_113371__$1;
(statearr_113412_113515[(2)] = inst_113362);

(statearr_113412_113515[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113372 === (10))){
var inst_113306 = (state_113371[(2)]);
var state_113371__$1 = (function (){var statearr_113413 = state_113371;
(statearr_113413[(8)] = inst_113306);

return statearr_113413;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_113414_113516 = state_113371__$1;
(statearr_113414_113516[(1)] = (11));

} else {
var statearr_113415_113517 = state_113371__$1;
(statearr_113415_113517[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113372 === (8))){
var inst_113298 = (state_113371[(7)]);
var inst_113300 = (function (){var pp = inst_113298;
return (function (select__$1){
var select_val = (function (){var or__4126__auto__ = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1);
}
})();
var idx = (cljs.core.truth_(select_val)?fluree.db.util.core.index_of.call(null,headers,select_val):null);
var select_fn = (cljs.core.truth_(idx)?(function (tuple){
return cljs.core.nth.call(null,tuple,idx);
}):(cljs.core.truth_(new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(select__$1))?(function (tuple){
return new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(select__$1);
}):(cljs.core.truth_(cljs.core.get.call(null,vars,select_val))?(function (tuple){
return cljs.core.get.call(null,vars,select_val);
}):null)));
if(cljs.core.truth_(new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(select__$1))){
return (function (tuple){
var c__100069__auto____$1 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_113445){
var state_val_113446 = (state_113445[(1)]);
if((state_val_113446 === (7))){
var inst_113441 = (state_113445[(2)]);
var state_113445__$1 = state_113445;
var statearr_113447_113518 = state_113445__$1;
(statearr_113447_113518[(2)] = inst_113441);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_113445__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113446 === (1))){
var state_113445__$1 = state_113445;
var statearr_113448_113519 = state_113445__$1;
(statearr_113448_113519[(2)] = null);

(statearr_113448_113519[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113446 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_113445,(3),Error,null,(2));
var inst_113420 = select_fn.call(null,tuple);
var state_113445__$1 = state_113445;
if(cljs.core.truth_(inst_113420)){
var statearr_113449_113520 = state_113445__$1;
(statearr_113449_113520[(1)] = (5));

} else {
var statearr_113450_113521 = state_113445__$1;
(statearr_113450_113521[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113446 === (6))){
var state_113445__$1 = state_113445;
var statearr_113451_113522 = state_113445__$1;
(statearr_113451_113522[(2)] = null);

(statearr_113451_113522[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113446 === (3))){
var inst_113416 = (state_113445[(2)]);
var state_113445__$1 = state_113445;
var statearr_113452_113523 = state_113445__$1;
(statearr_113452_113523[(2)] = inst_113416);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_113445__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113446 === (2))){
var inst_113443 = (state_113445[(2)]);
var state_113445__$1 = state_113445;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_113445__$1,inst_113443);
} else {
if((state_val_113446 === (11))){
var inst_113438 = (state_113445[(2)]);
var state_113445__$1 = state_113445;
var statearr_113453_113524 = state_113445__$1;
(statearr_113453_113524[(2)] = inst_113438);

(statearr_113453_113524[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113446 === (9))){
var inst_113430 = (state_113445[(7)]);
var state_113445__$1 = state_113445;
var statearr_113454_113525 = state_113445__$1;
(statearr_113454_113525[(2)] = inst_113430);

(statearr_113454_113525[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113446 === (5))){
var inst_113422 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044)];
var inst_113423 = new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(select__$1);
var inst_113424 = select_fn.call(null,tuple);
var inst_113425 = [inst_113423,inst_113424];
var inst_113426 = cljs.core.PersistentHashMap.fromArrays(inst_113422,inst_113425);
var inst_113427 = fluree.db.query.fql.query.call(null,db,inst_113426,opts);
var state_113445__$1 = state_113445;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_113445__$1,(8),inst_113427);
} else {
if((state_val_113446 === (10))){
var inst_113433 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_113434 = select_fn.call(null,tuple);
var inst_113435 = [inst_113434];
var inst_113436 = cljs.core.PersistentHashMap.fromArrays(inst_113433,inst_113435);
var state_113445__$1 = state_113445;
var statearr_113455_113526 = state_113445__$1;
(statearr_113455_113526[(2)] = inst_113436);

(statearr_113455_113526[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113446 === (8))){
var inst_113430 = (state_113445[(7)]);
var inst_113429 = (state_113445[(2)]);
var inst_113430__$1 = fluree.db.util.async.throw_err.call(null,inst_113429);
var state_113445__$1 = (function (){var statearr_113456 = state_113445;
(statearr_113456[(7)] = inst_113430__$1);

return statearr_113456;
})();
if(cljs.core.truth_(inst_113430__$1)){
var statearr_113457_113527 = state_113445__$1;
(statearr_113457_113527[(1)] = (9));

} else {
var statearr_113458_113528 = state_113445__$1;
(statearr_113458_113528[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__99975__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__99975__auto____0 = (function (){
var statearr_113459 = [null,null,null,null,null,null,null,null];
(statearr_113459[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__99975__auto__);

(statearr_113459[(1)] = (1));

return statearr_113459;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__99975__auto____1 = (function (state_113445){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_113445);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e113460){if((e113460 instanceof Object)){
var ex__99978__auto__ = e113460;
var statearr_113461_113529 = state_113445;
(statearr_113461_113529[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_113445);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e113460;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__113530 = state_113445;
state_113445 = G__113530;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__99975__auto__ = function(state_113445){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__99975__auto____1.call(this,state_113445);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__99975__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__99975__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_113462 = f__100070__auto__.call(null);
(statearr_113462[(6)] = c__100069__auto____$1);

return statearr_113462;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto____$1;
});
} else {
return (function (tuple){
var c__100069__auto____$1 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_113471){
var state_val_113472 = (state_113471[(1)]);
if((state_val_113472 === (1))){
var state_113471__$1 = state_113471;
var statearr_113473_113531 = state_113471__$1;
(statearr_113473_113531[(2)] = null);

(statearr_113473_113531[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113472 === (2))){
var inst_113469 = (state_113471[(2)]);
var state_113471__$1 = state_113471;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_113471__$1,inst_113469);
} else {
if((state_val_113472 === (3))){
var inst_113463 = (state_113471[(2)]);
var state_113471__$1 = state_113471;
var statearr_113474_113532 = state_113471__$1;
(statearr_113474_113532[(2)] = inst_113463);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_113471__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113472 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_113471,(3),Error,null,(2));
var inst_113467 = select_fn.call(null,tuple);
var state_113471__$1 = state_113471;
var statearr_113475_113533 = state_113471__$1;
(statearr_113475_113533[(2)] = inst_113467);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_113471__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__99975__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__99975__auto____0 = (function (){
var statearr_113476 = [null,null,null,null,null,null,null];
(statearr_113476[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__99975__auto__);

(statearr_113476[(1)] = (1));

return statearr_113476;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__99975__auto____1 = (function (state_113471){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_113471);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e113477){if((e113477 instanceof Object)){
var ex__99978__auto__ = e113477;
var statearr_113478_113534 = state_113471;
(statearr_113478_113534[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_113471);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e113477;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__113535 = state_113471;
state_113471 = G__113535;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__99975__auto__ = function(state_113471){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__99975__auto____1.call(this,state_113471);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__99975__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__99975__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_113479 = f__100070__auto__.call(null);
(statearr_113479[(6)] = c__100069__auto____$1);

return statearr_113479;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto____$1;
});
}
});
})();
var inst_113301 = cljs.core.map.call(null,inst_113300,select);
var state_113371__$1 = state_113371;
var statearr_113480_113536 = state_113371__$1;
(statearr_113480_113536[(2)] = inst_113301);

(statearr_113480_113536[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__99975__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__99975__auto____0 = (function (){
var statearr_113481 = [null,null,null,null,null,null,null,null,null,null];
(statearr_113481[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__99975__auto__);

(statearr_113481[(1)] = (1));

return statearr_113481;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__99975__auto____1 = (function (state_113371){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_113371);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e113482){if((e113482 instanceof Object)){
var ex__99978__auto__ = e113482;
var statearr_113483_113537 = state_113371;
(statearr_113483_113537[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_113371);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e113482;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__113538 = state_113371;
state_113371 = G__113538;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__99975__auto__ = function(state_113371){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__99975__auto____1.call(this,state_113371);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__99975__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__99975__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_113484 = f__100070__auto__.call(null);
(statearr_113484[(6)] = c__100069__auto__);

return statearr_113484;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__113540 = arguments.length;
switch (G__113540) {
case 4:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$4 = (function (db,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.call(null,db,res,select_spec,null,opts);
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5 = (function (db,p__113541,p__113542,group_limit,opts){
var map__113543 = p__113541;
var map__113543__$1 = (((((!((map__113543 == null))))?(((((map__113543.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__113543.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__113543):map__113543);
var res = map__113543__$1;
var vars = cljs.core.get.call(null,map__113543__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__113544 = p__113542;
var map__113544__$1 = (((((!((map__113544 == null))))?(((((map__113544.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__113544.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__113544):map__113544);
var select_spec = map__113544__$1;
var inVector_QMARK_ = cljs.core.get.call(null,map__113544__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var select = cljs.core.get.call(null,map__113544__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.call(null,map__113544__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var limit = cljs.core.get.call(null,map__113544__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__113544__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var aggregates = cljs.core.get.call(null,map__113544__$1,new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289));
var prettyPrint = cljs.core.get.call(null,map__113544__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectDistinct_QMARK_ = cljs.core.get.call(null,map__113544__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var groupBy = cljs.core.get.call(null,map__113544__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_113651){
var state_val_113652 = (state_113651[(1)]);
if((state_val_113652 === (7))){
var inst_113556 = (state_113651[(2)]);
var state_113651__$1 = state_113651;
if(cljs.core.truth_(inst_113556)){
var statearr_113653_113724 = state_113651__$1;
(statearr_113653_113724[(1)] = (8));

} else {
var statearr_113654_113725 = state_113651__$1;
(statearr_113654_113725[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113652 === (20))){
var state_113651__$1 = state_113651;
var statearr_113655_113726 = state_113651__$1;
(statearr_113655_113726[(2)] = (0));

(statearr_113655_113726[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113652 === (27))){
var state_113651__$1 = state_113651;
var statearr_113656_113727 = state_113651__$1;
(statearr_113656_113727[(2)] = false);

(statearr_113656_113727[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113652 === (1))){
var state_113651__$1 = state_113651;
var statearr_113657_113728 = state_113651__$1;
(statearr_113657_113728[(2)] = null);

(statearr_113657_113728[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113652 === (24))){
var inst_113585 = (state_113651[(7)]);
var state_113651__$1 = state_113651;
var statearr_113658_113729 = state_113651__$1;
(statearr_113658_113729[(2)] = inst_113585);

(statearr_113658_113729[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113652 === (39))){
var inst_113589 = (state_113651[(8)]);
var state_113651__$1 = state_113651;
var statearr_113659_113730 = state_113651__$1;
(statearr_113659_113730[(2)] = inst_113589);

(statearr_113659_113730[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113652 === (46))){
var inst_113637 = (state_113651[(9)]);
var state_113651__$1 = state_113651;
var statearr_113660_113731 = state_113651__$1;
(statearr_113660_113731[(2)] = inst_113637);

(statearr_113660_113731[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113652 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_113651,(3),Error,null,(2));
var state_113651__$1 = state_113651;
if(cljs.core.truth_(aggregates)){
var statearr_113661_113732 = state_113651__$1;
(statearr_113661_113732[(1)] = (5));

} else {
var statearr_113662_113733 = state_113651__$1;
(statearr_113662_113733[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113652 === (15))){
var inst_113571 = (state_113651[(10)]);
var state_113651__$1 = state_113651;
var statearr_113663_113734 = state_113651__$1;
(statearr_113663_113734[(2)] = inst_113571);

(statearr_113663_113734[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113652 === (21))){
var state_113651__$1 = state_113651;
var statearr_113664_113735 = state_113651__$1;
(statearr_113664_113735[(2)] = offset);

(statearr_113664_113735[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113652 === (31))){
var inst_113607 = (state_113651[(2)]);
var state_113651__$1 = state_113651;
var statearr_113665_113736 = state_113651__$1;
(statearr_113665_113736[(2)] = inst_113607);

(statearr_113665_113736[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113652 === (32))){
var inst_113594 = (state_113651[(11)]);
var inst_113612 = cljs.core.apply.call(null,cljs.core.hash_map,inst_113594);
var state_113651__$1 = state_113651;
var statearr_113666_113737 = state_113651__$1;
(statearr_113666_113737[(2)] = inst_113612);

(statearr_113666_113737[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113652 === (40))){
var inst_113623 = (state_113651[(2)]);
var state_113651__$1 = state_113651;
var statearr_113667_113738 = state_113651__$1;
(statearr_113667_113738[(2)] = inst_113623);

(statearr_113667_113738[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113652 === (33))){
var inst_113594 = (state_113651[(11)]);
var state_113651__$1 = state_113651;
var statearr_113668_113739 = state_113651__$1;
(statearr_113668_113739[(2)] = inst_113594);

(statearr_113668_113739[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113652 === (13))){
var inst_113571 = (state_113651[(2)]);
var state_113651__$1 = (function (){var statearr_113669 = state_113651;
(statearr_113669[(10)] = inst_113571);

return statearr_113669;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_113670_113740 = state_113651__$1;
(statearr_113670_113740[(1)] = (14));

} else {
var statearr_113671_113741 = state_113651__$1;
(statearr_113671_113741[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113652 === (22))){
var inst_113589 = (state_113651[(2)]);
var state_113651__$1 = (function (){var statearr_113672 = state_113651;
(statearr_113672[(8)] = inst_113589);

return statearr_113672;
})();
if(cljs.core.truth_(orderBy)){
var statearr_113673_113742 = state_113651__$1;
(statearr_113673_113742[(1)] = (23));

} else {
var statearr_113674_113743 = state_113651__$1;
(statearr_113674_113743[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113652 === (36))){
var state_113651__$1 = state_113651;
var statearr_113675_113744 = state_113651__$1;
(statearr_113675_113744[(2)] = false);

(statearr_113675_113744[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113652 === (41))){
var inst_113617 = (state_113651[(12)]);
var inst_113589 = (state_113651[(8)]);
var inst_113628 = cljs.core.drop.call(null,inst_113589,inst_113617);
var inst_113629 = cljs.core.take.call(null,limit,inst_113628);
var state_113651__$1 = state_113651;
var statearr_113676_113745 = state_113651__$1;
(statearr_113676_113745[(2)] = inst_113629);

(statearr_113676_113745[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113652 === (43))){
var inst_113616 = (state_113651[(13)]);
var inst_113632 = (state_113651[(2)]);
var inst_113633 = cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var inst_113634 = fluree.db.query.fql.format_filter_tuples.call(null,db,inst_113632,select_spec,inst_113616,vars,inst_113633);
var state_113651__$1 = state_113651;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_113651__$1,(44),inst_113634);
} else {
if((state_val_113652 === (29))){
var state_113651__$1 = state_113651;
var statearr_113677_113746 = state_113651__$1;
(statearr_113677_113746[(2)] = true);

(statearr_113677_113746[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113652 === (44))){
var inst_113636 = (state_113651[(2)]);
var inst_113637 = fluree.db.util.async.throw_err.call(null,inst_113636);
var state_113651__$1 = (function (){var statearr_113678 = state_113651;
(statearr_113678[(9)] = inst_113637);

return statearr_113678;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_113679_113747 = state_113651__$1;
(statearr_113679_113747[(1)] = (45));

} else {
var statearr_113680_113748 = state_113651__$1;
(statearr_113680_113748[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113652 === (6))){
var state_113651__$1 = state_113651;
var statearr_113681_113749 = state_113651__$1;
(statearr_113681_113749[(2)] = aggregates);

(statearr_113681_113749[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113652 === (28))){
var inst_113610 = (state_113651[(2)]);
var state_113651__$1 = state_113651;
if(cljs.core.truth_(inst_113610)){
var statearr_113682_113750 = state_113651__$1;
(statearr_113682_113750[(1)] = (32));

} else {
var statearr_113683_113751 = state_113651__$1;
(statearr_113683_113751[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113652 === (25))){
var inst_113594 = (state_113651[(11)]);
var inst_113594__$1 = (state_113651[(2)]);
var inst_113596 = (inst_113594__$1 == null);
var inst_113597 = cljs.core.not.call(null,inst_113596);
var state_113651__$1 = (function (){var statearr_113684 = state_113651;
(statearr_113684[(11)] = inst_113594__$1);

return statearr_113684;
})();
if(inst_113597){
var statearr_113685_113752 = state_113651__$1;
(statearr_113685_113752[(1)] = (26));

} else {
var statearr_113686_113753 = state_113651__$1;
(statearr_113686_113753[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113652 === (34))){
var inst_113615 = (state_113651[(2)]);
var inst_113616 = cljs.core.get.call(null,inst_113615,new cljs.core.Keyword(null,"headers","headers",-835030129));
var inst_113617 = cljs.core.get.call(null,inst_113615,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var inst_113618 = cljs.core.not.call(null,orderBy);
var state_113651__$1 = (function (){var statearr_113687 = state_113651;
(statearr_113687[(12)] = inst_113617);

(statearr_113687[(13)] = inst_113616);

return statearr_113687;
})();
if(inst_113618){
var statearr_113688_113754 = state_113651__$1;
(statearr_113688_113754[(1)] = (35));

} else {
var statearr_113689_113755 = state_113651__$1;
(statearr_113689_113755[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113652 === (17))){
var inst_113582 = fluree.db.query.analytical.add_aggregate_cols.call(null,res,aggregates);
var state_113651__$1 = state_113651;
var statearr_113690_113756 = state_113651__$1;
(statearr_113690_113756[(2)] = inst_113582);

(statearr_113690_113756[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113652 === (3))){
var inst_113547 = (state_113651[(2)]);
var state_113651__$1 = state_113651;
var statearr_113691_113757 = state_113651__$1;
(statearr_113691_113757[(2)] = inst_113547);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_113651__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113652 === (12))){
var inst_113560 = (state_113651[(14)]);
var state_113651__$1 = state_113651;
var statearr_113692_113758 = state_113651__$1;
(statearr_113692_113758[(2)] = inst_113560);

(statearr_113692_113758[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113652 === (2))){
var inst_113649 = (state_113651[(2)]);
var state_113651__$1 = state_113651;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_113651__$1,inst_113649);
} else {
if((state_val_113652 === (23))){
var inst_113589 = (state_113651[(8)]);
var inst_113585 = (state_113651[(7)]);
var inst_113591 = fluree.db.query.fql.order_offset_and_limit_results.call(null,orderBy,inst_113585,inst_113589,group_limit);
var state_113651__$1 = state_113651;
var statearr_113693_113759 = state_113651__$1;
(statearr_113693_113759[(2)] = inst_113591);

(statearr_113693_113759[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113652 === (47))){
var inst_113645 = (state_113651[(2)]);
var state_113651__$1 = state_113651;
var statearr_113694_113760 = state_113651__$1;
(statearr_113694_113760[(2)] = inst_113645);

(statearr_113694_113760[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113652 === (35))){
var state_113651__$1 = state_113651;
if(cljs.core.truth_(limit)){
var statearr_113695_113761 = state_113651__$1;
(statearr_113695_113761[(1)] = (38));

} else {
var statearr_113696_113762 = state_113651__$1;
(statearr_113696_113762[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113652 === (19))){
var inst_113585 = (state_113651[(2)]);
var state_113651__$1 = (function (){var statearr_113697 = state_113651;
(statearr_113697[(7)] = inst_113585);

return statearr_113697;
})();
if(cljs.core.truth_(groupBy)){
var statearr_113698_113763 = state_113651__$1;
(statearr_113698_113763[(1)] = (20));

} else {
var statearr_113699_113764 = state_113651__$1;
(statearr_113699_113764[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113652 === (11))){
var inst_113560 = (state_113651[(14)]);
var inst_113562 = cljs.core.first.call(null,select);
var inst_113563 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_113562);
var inst_113564 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_113563);
var inst_113565 = cljs.core.subs.call(null,inst_113564,(1));
var inst_113566 = [inst_113565];
var inst_113567 = [inst_113560];
var inst_113568 = cljs.core.PersistentHashMap.fromArrays(inst_113566,inst_113567);
var state_113651__$1 = state_113651;
var statearr_113700_113765 = state_113651__$1;
(statearr_113700_113765[(2)] = inst_113568);

(statearr_113700_113765[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113652 === (9))){
var state_113651__$1 = state_113651;
if(cljs.core.truth_(aggregates)){
var statearr_113701_113766 = state_113651__$1;
(statearr_113701_113766[(1)] = (17));

} else {
var statearr_113702_113767 = state_113651__$1;
(statearr_113702_113767[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113652 === (5))){
var inst_113552 = cljs.core.count.call(null,select);
var inst_113553 = cljs.core._EQ_.call(null,(1),inst_113552);
var state_113651__$1 = state_113651;
var statearr_113703_113768 = state_113651__$1;
(statearr_113703_113768[(2)] = inst_113553);

(statearr_113703_113768[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113652 === (14))){
var inst_113571 = (state_113651[(10)]);
var inst_113573 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_113574 = [inst_113571];
var inst_113575 = (new cljs.core.PersistentVector(null,1,(5),inst_113573,inst_113574,null));
var state_113651__$1 = state_113651;
var statearr_113704_113769 = state_113651__$1;
(statearr_113704_113769[(2)] = inst_113575);

(statearr_113704_113769[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113652 === (45))){
var inst_113637 = (state_113651[(9)]);
var inst_113639 = cljs.core.PersistentVector.EMPTY;
var inst_113640 = cljs.core.PersistentHashSet.EMPTY;
var inst_113641 = cljs.core.into.call(null,inst_113640,inst_113637);
var inst_113642 = cljs.core.into.call(null,inst_113639,inst_113641);
var state_113651__$1 = state_113651;
var statearr_113705_113770 = state_113651__$1;
(statearr_113705_113770[(2)] = inst_113642);

(statearr_113705_113770[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113652 === (26))){
var inst_113594 = (state_113651[(11)]);
var inst_113599 = inst_113594.cljs$lang$protocol_mask$partition0$;
var inst_113600 = (inst_113599 & (64));
var inst_113601 = inst_113594.cljs$core$ISeq$;
var inst_113602 = (cljs.core.PROTOCOL_SENTINEL === inst_113601);
var inst_113603 = ((inst_113600) || (inst_113602));
var state_113651__$1 = state_113651;
if(cljs.core.truth_(inst_113603)){
var statearr_113706_113771 = state_113651__$1;
(statearr_113706_113771[(1)] = (29));

} else {
var statearr_113707_113772 = state_113651__$1;
(statearr_113707_113772[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113652 === (16))){
var inst_113578 = (state_113651[(2)]);
var state_113651__$1 = state_113651;
var statearr_113708_113773 = state_113651__$1;
(statearr_113708_113773[(2)] = inst_113578);

(statearr_113708_113773[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113652 === (38))){
var state_113651__$1 = state_113651;
var statearr_113709_113774 = state_113651__$1;
(statearr_113709_113774[(2)] = limit);

(statearr_113709_113774[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113652 === (30))){
var state_113651__$1 = state_113651;
var statearr_113710_113775 = state_113651__$1;
(statearr_113710_113775[(2)] = false);

(statearr_113710_113775[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113652 === (10))){
var inst_113647 = (state_113651[(2)]);
var state_113651__$1 = state_113651;
var statearr_113711_113776 = state_113651__$1;
(statearr_113711_113776[(2)] = inst_113647);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_113651__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113652 === (18))){
var state_113651__$1 = state_113651;
var statearr_113712_113777 = state_113651__$1;
(statearr_113712_113777[(2)] = res);

(statearr_113712_113777[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113652 === (42))){
var inst_113617 = (state_113651[(12)]);
var state_113651__$1 = state_113651;
var statearr_113713_113778 = state_113651__$1;
(statearr_113713_113778[(2)] = inst_113617);

(statearr_113713_113778[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113652 === (37))){
var inst_113626 = (state_113651[(2)]);
var state_113651__$1 = state_113651;
if(cljs.core.truth_(inst_113626)){
var statearr_113714_113779 = state_113651__$1;
(statearr_113714_113779[(1)] = (41));

} else {
var statearr_113715_113780 = state_113651__$1;
(statearr_113715_113780[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_113652 === (8))){
var inst_113558 = cljs.core.first.call(null,aggregates);
var inst_113559 = fluree.db.query.analytical.calculate_aggregate.call(null,res,inst_113558);
var inst_113560 = cljs.core.second.call(null,inst_113559);
var state_113651__$1 = (function (){var statearr_113716 = state_113651;
(statearr_113716[(14)] = inst_113560);

return statearr_113716;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_113717_113781 = state_113651__$1;
(statearr_113717_113781[(1)] = (11));

} else {
var statearr_113718_113782 = state_113651__$1;
(statearr_113718_113782[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__99975__auto__ = null;
var fluree$db$query$fql$state_machine__99975__auto____0 = (function (){
var statearr_113719 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_113719[(0)] = fluree$db$query$fql$state_machine__99975__auto__);

(statearr_113719[(1)] = (1));

return statearr_113719;
});
var fluree$db$query$fql$state_machine__99975__auto____1 = (function (state_113651){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_113651);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e113720){if((e113720 instanceof Object)){
var ex__99978__auto__ = e113720;
var statearr_113721_113783 = state_113651;
(statearr_113721_113783[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_113651);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e113720;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__113784 = state_113651;
state_113651 = G__113784;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__99975__auto__ = function(state_113651){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__99975__auto____1.call(this,state_113651);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__99975__auto____0;
fluree$db$query$fql$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__99975__auto____1;
return fluree$db$query$fql$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_113722 = f__100070__auto__.call(null);
(statearr_113722[(6)] = c__100069__auto__);

return statearr_113722;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 5);

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__113787,groupBy){
var map__113788 = p__113787;
var map__113788__$1 = (((((!((map__113788 == null))))?(((((map__113788.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__113788.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__113788):map__113788);
var res = map__113788__$1;
var headers = cljs.core.get.call(null,map__113788__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__113788__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__113790 = ((cljs.core.vector_QMARK_.call(null,groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.call(null,cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,groupBy)], null)], null):(function(){throw cljs.core.ex_info.call(null,["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var inVector_QMARK_ = cljs.core.nth.call(null,vec__113790,(0),null);
var groupBy__$1 = cljs.core.nth.call(null,vec__113790,(1),null);
var group_idxs = cljs.core.map.call(null,(function (p1__113785_SHARP_){
return fluree.db.util.core.index_of.call(null,headers,p1__113785_SHARP_);
}),groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some.call(null,cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.call(null,["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
return cljs.core.reduce.call(null,(function (res__$1,tuple){
var k = cljs.core.map.call(null,(function (p1__113786_SHARP_){
return cljs.core.nth.call(null,tuple,p1__113786_SHARP_);
}),group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,k):cljs.core.first.call(null,k));
var v = tuple;
return cljs.core.assoc.call(null,res__$1,k_SINGLEQUOTE_,cljs.core.conj.call(null,cljs.core.get.call(null,res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
}),cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,p__113793,p__113794,opts){
var map__113795 = p__113793;
var map__113795__$1 = (((((!((map__113795 == null))))?(((((map__113795.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__113795.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__113795):map__113795);
var res = map__113795__$1;
var headers = cljs.core.get.call(null,map__113795__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__113795__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__113796 = p__113794;
var map__113796__$1 = (((((!((map__113796 == null))))?(((((map__113796.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__113796.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__113796):map__113796);
var select_spec = map__113796__$1;
var groupBy = cljs.core.get.call(null,map__113796__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var orderBy = cljs.core.get.call(null,map__113796__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var limit = cljs.core.get.call(null,map__113796__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var selectOne_QMARK_ = cljs.core.get.call(null,map__113796__$1,new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472));
var selectDistinct_QMARK_ = cljs.core.get.call(null,map__113796__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var inVector_QMARK_ = cljs.core.get.call(null,map__113796__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var offset = cljs.core.get.call(null,map__113796__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_114015){
var state_val_114016 = (state_114015[(1)]);
if((state_val_114016 === (65))){
var inst_113982 = (state_114015[(7)]);
var inst_113981 = (state_114015[(2)]);
var inst_113982__$1 = fluree.db.util.async.throw_err.call(null,inst_113981);
var inst_113983 = cljs.core.coll_QMARK_.call(null,inst_113982__$1);
var inst_113984 = (!(inst_113983));
var state_114015__$1 = (function (){var statearr_114017 = state_114015;
(statearr_114017[(7)] = inst_113982__$1);

return statearr_114017;
})();
if(inst_113984){
var statearr_114018_114132 = state_114015__$1;
(statearr_114018_114132[(1)] = (66));

} else {
var statearr_114019_114133 = state_114015__$1;
(statearr_114019_114133[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (70))){
var inst_113982 = (state_114015[(7)]);
var state_114015__$1 = state_114015;
var statearr_114020_114134 = state_114015__$1;
(statearr_114020_114134[(2)] = inst_113982);

(statearr_114020_114134[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (62))){
var state_114015__$1 = state_114015;
var statearr_114021_114135 = state_114015__$1;
(statearr_114021_114135[(2)] = (1));

(statearr_114021_114135[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (74))){
var inst_114007 = (state_114015[(2)]);
var state_114015__$1 = state_114015;
var statearr_114022_114136 = state_114015__$1;
(statearr_114022_114136[(2)] = inst_114007);

(statearr_114022_114136[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (7))){
var inst_114011 = (state_114015[(2)]);
var state_114015__$1 = state_114015;
var statearr_114023_114137 = state_114015__$1;
(statearr_114023_114137[(2)] = inst_114011);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_114015__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (59))){
var inst_113965 = (state_114015[(8)]);
var inst_113851 = (state_114015[(9)]);
var inst_113967 = cljs.core.sorted_map_by.call(null,inst_113851);
var inst_113968 = cljs.core.into.call(null,inst_113967,inst_113965);
var state_114015__$1 = state_114015;
var statearr_114024_114138 = state_114015__$1;
(statearr_114024_114138[(2)] = inst_113968);

(statearr_114024_114138[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (20))){
var inst_113824 = cljs.core.set.call(null,groupBy);
var inst_113825 = cljs.core.second.call(null,orderBy);
var inst_113826 = inst_113824.call(null,inst_113825);
var state_114015__$1 = state_114015;
var statearr_114025_114139 = state_114015__$1;
(statearr_114025_114139[(2)] = inst_113826);

(statearr_114025_114139[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (72))){
var inst_113982 = (state_114015[(7)]);
var inst_113995 = cljs.core.first.call(null,inst_113982);
var state_114015__$1 = state_114015;
var statearr_114026_114140 = state_114015__$1;
(statearr_114026_114140[(2)] = inst_113995);

(statearr_114026_114140[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (58))){
var inst_113904 = (state_114015[(10)]);
var inst_113895 = (state_114015[(11)]);
var inst_113947 = (state_114015[(2)]);
var inst_113948 = fluree.db.util.async.throw_err.call(null,inst_113947);
var inst_113949 = cljs.core.assoc.call(null,inst_113895,inst_113904,inst_113948);
var state_114015__$1 = state_114015;
var statearr_114027_114141 = state_114015__$1;
(statearr_114027_114141[(2)] = inst_113949);

(statearr_114027_114141[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (60))){
var inst_113965 = (state_114015[(8)]);
var state_114015__$1 = state_114015;
var statearr_114028_114142 = state_114015__$1;
(statearr_114028_114142[(2)] = inst_113965);

(statearr_114028_114142[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (27))){
var inst_113833 = (state_114015[(12)]);
var inst_113832 = (state_114015[(13)]);
var inst_113804 = (state_114015[(14)]);
var inst_113838 = (function (){var group_map = inst_113804;
var orderByIdx = inst_113832;
var orderDirection = inst_113833;
return (function (x,y){
return fluree.db.query.fql.compare_fn.call(null,cljs.core.nth.call(null,x,orderByIdx),cljs.core.nth.call(null,y,orderByIdx));
});
})();
var state_114015__$1 = state_114015;
var statearr_114029_114143 = state_114015__$1;
(statearr_114029_114143[(2)] = inst_113838);

(statearr_114029_114143[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (1))){
var state_114015__$1 = state_114015;
var statearr_114030_114144 = state_114015__$1;
(statearr_114030_114144[(2)] = null);

(statearr_114030_114144[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (69))){
var inst_113982 = (state_114015[(7)]);
var inst_113987 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_113988 = [inst_113982];
var inst_113989 = (new cljs.core.PersistentVector(null,1,(5),inst_113987,inst_113988,null));
var state_114015__$1 = state_114015;
var statearr_114031_114145 = state_114015__$1;
(statearr_114031_114145[(2)] = inst_113989);

(statearr_114031_114145[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (24))){
var state_114015__$1 = state_114015;
var statearr_114032_114146 = state_114015__$1;
(statearr_114032_114146[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (55))){
var inst_113922 = (state_114015[(15)]);
var inst_113919 = (state_114015[(16)]);
var inst_113907 = (state_114015[(17)]);
var inst_113942 = cljs.core.count.call(null,inst_113907);
var inst_113943 = (inst_113919 - limit);
var inst_113944 = (inst_113942 - inst_113943);
var inst_113945 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,inst_113922,select_spec,inst_113944,opts);
var state_114015__$1 = state_114015;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_114015__$1,(58),inst_113945);
} else {
if((state_val_114016 === (39))){
var inst_113894 = (state_114015[(18)]);
var inst_113912 = (inst_113894 > (0));
var state_114015__$1 = state_114015;
if(cljs.core.truth_(inst_113912)){
var statearr_114034_114147 = state_114015__$1;
(statearr_114034_114147[(1)] = (41));

} else {
var statearr_114035_114148 = state_114015__$1;
(statearr_114035_114148[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (46))){
var inst_113959 = (state_114015[(2)]);
var state_114015__$1 = state_114015;
var statearr_114036_114149 = state_114015__$1;
(statearr_114036_114149[(2)] = inst_113959);

(statearr_114036_114149[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_114015,(3),Error,null,(2));
var state_114015__$1 = state_114015;
if(cljs.core.truth_(groupBy)){
var statearr_114037_114150 = state_114015__$1;
(statearr_114037_114150[(1)] = (5));

} else {
var statearr_114038_114151 = state_114015__$1;
(statearr_114038_114151[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (77))){
var inst_114005 = (state_114015[(2)]);
var state_114015__$1 = state_114015;
var statearr_114039_114152 = state_114015__$1;
(statearr_114039_114152[(2)] = inst_114005);

(statearr_114039_114152[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (54))){
var inst_113904 = (state_114015[(10)]);
var inst_113895 = (state_114015[(11)]);
var inst_113936 = (state_114015[(2)]);
var inst_113937 = fluree.db.util.async.throw_err.call(null,inst_113936);
var inst_113938 = cljs.core.assoc.call(null,inst_113895,inst_113904,inst_113937);
var state_114015__$1 = state_114015;
var statearr_114040_114153 = state_114015__$1;
(statearr_114040_114153[(2)] = inst_113938);

(statearr_114040_114153[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (15))){
var state_114015__$1 = state_114015;
var statearr_114042_114154 = state_114015__$1;
(statearr_114042_114154[(2)] = fluree.db.query.fql.compare_fn);

(statearr_114042_114154[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (48))){
var inst_113919 = (state_114015[(16)]);
var inst_113932 = cljs.core._EQ_.call(null,limit,inst_113919);
var state_114015__$1 = state_114015;
if(inst_113932){
var statearr_114043_114155 = state_114015__$1;
(statearr_114043_114155[(1)] = (51));

} else {
var statearr_114044_114156 = state_114015__$1;
(statearr_114044_114156[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (50))){
var inst_113904 = (state_114015[(10)]);
var inst_113905 = (state_114015[(19)]);
var inst_113895 = (state_114015[(11)]);
var inst_113894 = (state_114015[(18)]);
var inst_113908 = (state_114015[(20)]);
var inst_113919 = (state_114015[(16)]);
var inst_113927 = (state_114015[(2)]);
var inst_113928 = fluree.db.util.async.throw_err.call(null,inst_113927);
var inst_113929 = cljs.core.assoc.call(null,inst_113895,inst_113904,inst_113928);
var tmp114041 = inst_113894;
var inst_113891 = inst_113905;
var inst_113892 = inst_113908;
var inst_113893 = inst_113919;
var inst_113894__$1 = tmp114041;
var inst_113895__$1 = inst_113929;
var state_114015__$1 = (function (){var statearr_114045 = state_114015;
(statearr_114045[(21)] = inst_113891);

(statearr_114045[(11)] = inst_113895__$1);

(statearr_114045[(18)] = inst_113894__$1);

(statearr_114045[(22)] = inst_113892);

(statearr_114045[(23)] = inst_113893);

return statearr_114045;
})();
var statearr_114046_114157 = state_114015__$1;
(statearr_114046_114157[(2)] = null);

(statearr_114046_114157[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (75))){
var inst_113982 = (state_114015[(7)]);
var inst_113998 = cljs.core.distinct.call(null,inst_113982);
var state_114015__$1 = state_114015;
var statearr_114047_114158 = state_114015__$1;
(statearr_114047_114158[(2)] = inst_113998);

(statearr_114047_114158[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (21))){
var state_114015__$1 = state_114015;
var statearr_114048_114159 = state_114015__$1;
(statearr_114048_114159[(2)] = orderBy);

(statearr_114048_114159[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (31))){
var inst_113845 = (state_114015[(2)]);
var state_114015__$1 = state_114015;
var statearr_114049_114160 = state_114015__$1;
(statearr_114049_114160[(2)] = inst_113845);

(statearr_114049_114160[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (32))){
var inst_113804 = (state_114015[(14)]);
var inst_113853 = cljs.core.keys.call(null,inst_113804);
var inst_113854 = cljs.core.first.call(null,inst_113853);
var inst_113855 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_113856 = cljs.core.vals.call(null,inst_113804);
var inst_113857 = cljs.core.first.call(null,inst_113856);
var inst_113858 = [headers,vars,inst_113857];
var inst_113859 = cljs.core.PersistentHashMap.fromArrays(inst_113855,inst_113858);
var inst_113860 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,inst_113859,select_spec,limit,opts);
var state_114015__$1 = (function (){var statearr_114050 = state_114015;
(statearr_114050[(24)] = inst_113854);

return statearr_114050;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_114015__$1,(35),inst_113860);
} else {
if((state_val_114016 === (40))){
var inst_113963 = (state_114015[(2)]);
var state_114015__$1 = state_114015;
var statearr_114051_114161 = state_114015__$1;
(statearr_114051_114161[(2)] = inst_113963);

(statearr_114051_114161[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (56))){
var state_114015__$1 = state_114015;
var statearr_114052_114162 = state_114015__$1;
(statearr_114052_114162[(2)] = null);

(statearr_114052_114162[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (33))){
var inst_113804 = (state_114015[(14)]);
var inst_113882 = cljs.core.keys.call(null,inst_113804);
var inst_113883 = cljs.core.seq.call(null,inst_113882);
var inst_113884 = cljs.core.first.call(null,inst_113883);
var inst_113885 = cljs.core.next.call(null,inst_113883);
var inst_113886 = cljs.core.vals.call(null,inst_113804);
var inst_113887 = cljs.core.seq.call(null,inst_113886);
var inst_113888 = cljs.core.first.call(null,inst_113887);
var inst_113889 = cljs.core.next.call(null,inst_113887);
var inst_113890 = cljs.core.PersistentHashMap.EMPTY;
var inst_113891 = inst_113882;
var inst_113892 = inst_113886;
var inst_113893 = (0);
var inst_113894 = offset;
var inst_113895 = inst_113890;
var state_114015__$1 = (function (){var statearr_114053 = state_114015;
(statearr_114053[(21)] = inst_113891);

(statearr_114053[(25)] = inst_113889);

(statearr_114053[(11)] = inst_113895);

(statearr_114053[(18)] = inst_113894);

(statearr_114053[(26)] = inst_113888);

(statearr_114053[(22)] = inst_113892);

(statearr_114053[(27)] = inst_113884);

(statearr_114053[(23)] = inst_113893);

(statearr_114053[(28)] = inst_113885);

return statearr_114053;
})();
var statearr_114054_114163 = state_114015__$1;
(statearr_114054_114163[(2)] = null);

(statearr_114054_114163[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (13))){
var inst_113851 = (state_114015[(2)]);
var state_114015__$1 = (function (){var statearr_114055 = state_114015;
(statearr_114055[(9)] = inst_113851);

return statearr_114055;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_114056_114164 = state_114015__$1;
(statearr_114056_114164[(1)] = (32));

} else {
var statearr_114057_114165 = state_114015__$1;
(statearr_114057_114165[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (22))){
var inst_113829 = (state_114015[(2)]);
var state_114015__$1 = state_114015;
if(cljs.core.truth_(inst_113829)){
var statearr_114060_114166 = state_114015__$1;
(statearr_114060_114166[(1)] = (23));

} else {
var statearr_114061_114167 = state_114015__$1;
(statearr_114061_114167[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (36))){
var inst_113891 = (state_114015[(21)]);
var inst_113892 = (state_114015[(22)]);
var inst_113907 = (state_114015[(17)]);
var inst_113903 = cljs.core.seq.call(null,inst_113891);
var inst_113904 = cljs.core.first.call(null,inst_113903);
var inst_113905 = cljs.core.next.call(null,inst_113903);
var inst_113906 = cljs.core.seq.call(null,inst_113892);
var inst_113907__$1 = cljs.core.first.call(null,inst_113906);
var inst_113908 = cljs.core.next.call(null,inst_113906);
var inst_113909 = (inst_113907__$1 == null);
var state_114015__$1 = (function (){var statearr_114062 = state_114015;
(statearr_114062[(10)] = inst_113904);

(statearr_114062[(19)] = inst_113905);

(statearr_114062[(20)] = inst_113908);

(statearr_114062[(17)] = inst_113907__$1);

return statearr_114062;
})();
if(cljs.core.truth_(inst_113909)){
var statearr_114063_114168 = state_114015__$1;
(statearr_114063_114168[(1)] = (38));

} else {
var statearr_114064_114169 = state_114015__$1;
(statearr_114064_114169[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (41))){
var inst_113905 = (state_114015[(19)]);
var inst_113895 = (state_114015[(11)]);
var inst_113894 = (state_114015[(18)]);
var inst_113908 = (state_114015[(20)]);
var inst_113893 = (state_114015[(23)]);
var inst_113914 = (inst_113894 - (1));
var tmp114058 = inst_113895;
var tmp114059 = inst_113893;
var inst_113891 = inst_113905;
var inst_113892 = inst_113908;
var inst_113893__$1 = tmp114059;
var inst_113894__$1 = inst_113914;
var inst_113895__$1 = tmp114058;
var state_114015__$1 = (function (){var statearr_114065 = state_114015;
(statearr_114065[(21)] = inst_113891);

(statearr_114065[(11)] = inst_113895__$1);

(statearr_114065[(18)] = inst_113894__$1);

(statearr_114065[(22)] = inst_113892);

(statearr_114065[(23)] = inst_113893__$1);

return statearr_114065;
})();
var statearr_114066_114170 = state_114015__$1;
(statearr_114066_114170[(2)] = null);

(statearr_114066_114170[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (43))){
var inst_113961 = (state_114015[(2)]);
var state_114015__$1 = state_114015;
var statearr_114067_114171 = state_114015__$1;
(statearr_114067_114171[(2)] = inst_113961);

(statearr_114067_114171[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (61))){
var inst_113971 = (state_114015[(2)]);
var state_114015__$1 = state_114015;
var statearr_114068_114172 = state_114015__$1;
(statearr_114068_114172[(2)] = inst_113971);

(statearr_114068_114172[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (29))){
var state_114015__$1 = state_114015;
var statearr_114069_114173 = state_114015__$1;
(statearr_114069_114173[(2)] = null);

(statearr_114069_114173[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (44))){
var inst_113893 = (state_114015[(23)]);
var inst_113919 = (state_114015[(16)]);
var inst_113907 = (state_114015[(17)]);
var inst_113918 = cljs.core.count.call(null,inst_113907);
var inst_113919__$1 = (inst_113893 + inst_113918);
var inst_113920 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_113921 = [headers,vars,inst_113907];
var inst_113922 = cljs.core.PersistentHashMap.fromArrays(inst_113920,inst_113921);
var inst_113923 = (limit > inst_113919__$1);
var state_114015__$1 = (function (){var statearr_114070 = state_114015;
(statearr_114070[(15)] = inst_113922);

(statearr_114070[(16)] = inst_113919__$1);

return statearr_114070;
})();
if(cljs.core.truth_(inst_113923)){
var statearr_114071_114174 = state_114015__$1;
(statearr_114071_114174[(1)] = (47));

} else {
var statearr_114072_114175 = state_114015__$1;
(statearr_114072_114175[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (6))){
var state_114015__$1 = state_114015;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_114073_114176 = state_114015__$1;
(statearr_114073_114176[(1)] = (62));

} else {
var statearr_114074_114177 = state_114015__$1;
(statearr_114074_114177[(1)] = (63));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (28))){
var inst_113840 = (state_114015[(2)]);
var state_114015__$1 = state_114015;
var statearr_114075_114178 = state_114015__$1;
(statearr_114075_114178[(2)] = inst_113840);

(statearr_114075_114178[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (64))){
var inst_113978 = (state_114015[(2)]);
var inst_113979 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,res,select_spec,inst_113978,opts);
var state_114015__$1 = state_114015;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_114015__$1,(65),inst_113979);
} else {
if((state_val_114016 === (51))){
var inst_113922 = (state_114015[(15)]);
var inst_113934 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,inst_113922,select_spec,opts);
var state_114015__$1 = state_114015;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_114015__$1,(54),inst_113934);
} else {
if((state_val_114016 === (25))){
var inst_113847 = (state_114015[(2)]);
var state_114015__$1 = state_114015;
var statearr_114076_114179 = state_114015__$1;
(statearr_114076_114179[(2)] = inst_113847);

(statearr_114076_114179[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (34))){
var inst_113973 = (state_114015[(2)]);
var state_114015__$1 = state_114015;
var statearr_114077_114180 = state_114015__$1;
(statearr_114077_114180[(2)] = inst_113973);

(statearr_114077_114180[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (17))){
var state_114015__$1 = state_114015;
var statearr_114078_114181 = state_114015__$1;
(statearr_114078_114181[(2)] = null);

(statearr_114078_114181[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (3))){
var inst_113799 = (state_114015[(2)]);
var state_114015__$1 = state_114015;
var statearr_114079_114182 = state_114015__$1;
(statearr_114079_114182[(2)] = inst_113799);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_114015__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (12))){
var inst_113820 = cljs.core.not.call(null,orderBy);
var state_114015__$1 = state_114015;
if(inst_113820){
var statearr_114080_114183 = state_114015__$1;
(statearr_114080_114183[(1)] = (17));

} else {
var statearr_114081_114184 = state_114015__$1;
(statearr_114081_114184[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (2))){
var inst_114013 = (state_114015[(2)]);
var state_114015__$1 = state_114015;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_114015__$1,inst_114013);
} else {
if((state_val_114016 === (66))){
var state_114015__$1 = state_114015;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_114082_114185 = state_114015__$1;
(statearr_114082_114185[(1)] = (69));

} else {
var statearr_114083_114186 = state_114015__$1;
(statearr_114083_114186[(1)] = (70));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (23))){
var inst_113833 = (state_114015[(12)]);
var inst_113831 = cljs.core.second.call(null,orderBy);
var inst_113832 = fluree.db.util.core.index_of.call(null,groupBy,inst_113831);
var inst_113833__$1 = cljs.core.first.call(null,orderBy);
var inst_113834 = cljs.core._EQ_.call(null,"DESC",inst_113833__$1);
var state_114015__$1 = (function (){var statearr_114084 = state_114015;
(statearr_114084[(12)] = inst_113833__$1);

(statearr_114084[(13)] = inst_113832);

return statearr_114084;
})();
if(inst_113834){
var statearr_114085_114187 = state_114015__$1;
(statearr_114085_114187[(1)] = (26));

} else {
var statearr_114086_114188 = state_114015__$1;
(statearr_114086_114188[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (47))){
var inst_113922 = (state_114015[(15)]);
var inst_113925 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,inst_113922,select_spec,opts);
var state_114015__$1 = state_114015;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_114015__$1,(50),inst_113925);
} else {
if((state_val_114016 === (35))){
var inst_113854 = (state_114015[(24)]);
var inst_113862 = (state_114015[(2)]);
var inst_113863 = fluree.db.util.async.throw_err.call(null,inst_113862);
var inst_113864 = [inst_113854];
var inst_113865 = [inst_113863];
var inst_113866 = cljs.core.PersistentHashMap.fromArrays(inst_113864,inst_113865);
var state_114015__$1 = state_114015;
var statearr_114087_114189 = state_114015__$1;
(statearr_114087_114189[(2)] = inst_113866);

(statearr_114087_114189[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (76))){
var state_114015__$1 = state_114015;
var statearr_114088_114190 = state_114015__$1;
(statearr_114088_114190[(1)] = (78));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (19))){
var inst_113849 = (state_114015[(2)]);
var state_114015__$1 = state_114015;
var statearr_114090_114191 = state_114015__$1;
(statearr_114090_114191[(2)] = inst_113849);

(statearr_114090_114191[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (57))){
var inst_113952 = (state_114015[(2)]);
var state_114015__$1 = state_114015;
var statearr_114091_114192 = state_114015__$1;
(statearr_114091_114192[(2)] = inst_113952);

(statearr_114091_114192[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (68))){
var inst_114009 = (state_114015[(2)]);
var state_114015__$1 = state_114015;
var statearr_114092_114193 = state_114015__$1;
(statearr_114092_114193[(2)] = inst_114009);

(statearr_114092_114193[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (11))){
var inst_113812 = cljs.core.first.call(null,orderBy);
var inst_113813 = cljs.core._EQ_.call(null,inst_113812,"DESC");
var state_114015__$1 = state_114015;
if(inst_113813){
var statearr_114093_114194 = state_114015__$1;
(statearr_114093_114194[(1)] = (14));

} else {
var statearr_114094_114195 = state_114015__$1;
(statearr_114094_114195[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (9))){
var state_114015__$1 = state_114015;
var statearr_114095_114196 = state_114015__$1;
(statearr_114095_114196[(2)] = orderBy);

(statearr_114095_114196[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (5))){
var inst_113804 = fluree.db.query.fql.ad_hoc_group_by.call(null,res,groupBy);
var state_114015__$1 = (function (){var statearr_114096 = state_114015;
(statearr_114096[(14)] = inst_113804);

return statearr_114096;
})();
if(cljs.core.truth_(orderBy)){
var statearr_114097_114197 = state_114015__$1;
(statearr_114097_114197[(1)] = (8));

} else {
var statearr_114098_114198 = state_114015__$1;
(statearr_114098_114198[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (14))){
var inst_113804 = (state_114015[(14)]);
var inst_113815 = (function (){var group_map = inst_113804;
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn.call(null,x,y));
});
})();
var state_114015__$1 = state_114015;
var statearr_114099_114199 = state_114015__$1;
(statearr_114099_114199[(2)] = inst_113815);

(statearr_114099_114199[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (45))){
var state_114015__$1 = state_114015;
var statearr_114100_114200 = state_114015__$1;
(statearr_114100_114200[(2)] = null);

(statearr_114100_114200[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (53))){
var inst_113954 = (state_114015[(2)]);
var state_114015__$1 = state_114015;
var statearr_114101_114201 = state_114015__$1;
(statearr_114101_114201[(2)] = inst_113954);

(statearr_114101_114201[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (78))){
var inst_113982 = (state_114015[(7)]);
var state_114015__$1 = state_114015;
var statearr_114102_114202 = state_114015__$1;
(statearr_114102_114202[(2)] = inst_113982);

(statearr_114102_114202[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (26))){
var inst_113833 = (state_114015[(12)]);
var inst_113832 = (state_114015[(13)]);
var inst_113804 = (state_114015[(14)]);
var inst_113836 = (function (){var group_map = inst_113804;
var orderByIdx = inst_113832;
var orderDirection = inst_113833;
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn.call(null,cljs.core.nth.call(null,x,orderByIdx),cljs.core.nth.call(null,y,orderByIdx)));
});
})();
var state_114015__$1 = state_114015;
var statearr_114103_114203 = state_114015__$1;
(statearr_114103_114203[(2)] = inst_113836);

(statearr_114103_114203[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (16))){
var inst_113818 = (state_114015[(2)]);
var state_114015__$1 = state_114015;
var statearr_114104_114204 = state_114015__$1;
(statearr_114104_114204[(2)] = inst_113818);

(statearr_114104_114204[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (79))){
var state_114015__$1 = state_114015;
var statearr_114105_114205 = state_114015__$1;
(statearr_114105_114205[(2)] = null);

(statearr_114105_114205[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (38))){
var inst_113895 = (state_114015[(11)]);
var state_114015__$1 = state_114015;
var statearr_114106_114206 = state_114015__$1;
(statearr_114106_114206[(2)] = inst_113895);

(statearr_114106_114206[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (30))){
var state_114015__$1 = state_114015;
var statearr_114107_114207 = state_114015__$1;
(statearr_114107_114207[(2)] = null);

(statearr_114107_114207[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (73))){
var state_114015__$1 = state_114015;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_114108_114208 = state_114015__$1;
(statearr_114108_114208[(1)] = (75));

} else {
var statearr_114109_114209 = state_114015__$1;
(statearr_114109_114209[(1)] = (76));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (10))){
var inst_113810 = (state_114015[(2)]);
var state_114015__$1 = state_114015;
if(cljs.core.truth_(inst_113810)){
var statearr_114110_114210 = state_114015__$1;
(statearr_114110_114210[(1)] = (11));

} else {
var statearr_114111_114211 = state_114015__$1;
(statearr_114111_114211[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (18))){
var state_114015__$1 = state_114015;
if(cljs.core.truth_(orderBy)){
var statearr_114112_114212 = state_114015__$1;
(statearr_114112_114212[(1)] = (20));

} else {
var statearr_114113_114213 = state_114015__$1;
(statearr_114113_114213[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (52))){
var inst_113919 = (state_114015[(16)]);
var inst_113940 = (limit < inst_113919);
var state_114015__$1 = state_114015;
if(cljs.core.truth_(inst_113940)){
var statearr_114114_114214 = state_114015__$1;
(statearr_114114_114214[(1)] = (55));

} else {
var statearr_114115_114215 = state_114015__$1;
(statearr_114115_114215[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (67))){
var state_114015__$1 = state_114015;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_114116_114216 = state_114015__$1;
(statearr_114116_114216[(1)] = (72));

} else {
var statearr_114117_114217 = state_114015__$1;
(statearr_114117_114217[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (71))){
var inst_113992 = (state_114015[(2)]);
var state_114015__$1 = state_114015;
var statearr_114118_114218 = state_114015__$1;
(statearr_114118_114218[(2)] = inst_113992);

(statearr_114118_114218[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (42))){
var state_114015__$1 = state_114015;
var statearr_114119_114219 = state_114015__$1;
(statearr_114119_114219[(1)] = (44));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (80))){
var inst_114003 = (state_114015[(2)]);
var state_114015__$1 = state_114015;
var statearr_114121_114220 = state_114015__$1;
(statearr_114121_114220[(2)] = inst_114003);

(statearr_114121_114220[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (37))){
var inst_113851 = (state_114015[(9)]);
var inst_113965 = (state_114015[(2)]);
var state_114015__$1 = (function (){var statearr_114122 = state_114015;
(statearr_114122[(8)] = inst_113965);

return statearr_114122;
})();
if(cljs.core.truth_(inst_113851)){
var statearr_114123_114221 = state_114015__$1;
(statearr_114123_114221[(1)] = (59));

} else {
var statearr_114124_114222 = state_114015__$1;
(statearr_114124_114222[(1)] = (60));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (63))){
var state_114015__$1 = state_114015;
var statearr_114125_114223 = state_114015__$1;
(statearr_114125_114223[(2)] = limit);

(statearr_114125_114223[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (8))){
var inst_113806 = cljs.core.second.call(null,orderBy);
var inst_113807 = cljs.core._EQ_.call(null,inst_113806,groupBy);
var state_114015__$1 = state_114015;
var statearr_114126_114224 = state_114015__$1;
(statearr_114126_114224[(2)] = inst_113807);

(statearr_114126_114224[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114016 === (49))){
var inst_113956 = (state_114015[(2)]);
var state_114015__$1 = state_114015;
var statearr_114127_114225 = state_114015__$1;
(statearr_114127_114225[(2)] = inst_113956);

(statearr_114127_114225[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__99975__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__99975__auto____0 = (function (){
var statearr_114128 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_114128[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__99975__auto__);

(statearr_114128[(1)] = (1));

return statearr_114128;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__99975__auto____1 = (function (state_114015){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_114015);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e114129){if((e114129 instanceof Object)){
var ex__99978__auto__ = e114129;
var statearr_114130_114226 = state_114015;
(statearr_114130_114226[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_114015);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e114129;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__114227 = state_114015;
state_114015 = G__114227;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__99975__auto__ = function(state_114015){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__99975__auto____1.call(this,state_114015);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__99975__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__99975__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_114131 = f__100070__auto__.call(null);
(statearr_114131[(6)] = c__100069__auto__);

return statearr_114131;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
fluree.db.query.fql.get_ad_hoc_select_spec = (function fluree$db$query$fql$get_ad_hoc_select_spec(headers,vars,p__114230,opts){
var map__114231 = p__114230;
var map__114231__$1 = (((((!((map__114231 == null))))?(((((map__114231.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__114231.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__114231):map__114231);
var query_map = map__114231__$1;
var select = cljs.core.get.call(null,map__114231__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.call(null,map__114231__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var limit = cljs.core.get.call(null,map__114231__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__114231__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var selectDistinct = cljs.core.get.call(null,map__114231__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var prettyPrint = cljs.core.get.call(null,map__114231__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectOne = cljs.core.get.call(null,map__114231__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var groupBy = cljs.core.get.call(null,map__114231__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var selectReduced = cljs.core.get.call(null,map__114231__$1,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var _ = (cljs.core.truth_((function (){var or__4126__auto__ = orderBy;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = groupBy;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
var or__4126__auto____$2 = limit;
if(cljs.core.truth_(or__4126__auto____$2)){
return or__4126__auto____$2;
} else {
var or__4126__auto____$3 = offset;
if(cljs.core.truth_(or__4126__auto____$3)){
return or__4126__auto____$3;
} else {
return prettyPrint;
}
}
}
}
})())?fluree.db.util.log.warn.call(null,["The query options: limit, offset, groupBy, prettyPrint, and orderBy should be included in the opts map. Top-level options are being deprecated. Provided: ",cljs.core.pr_str.call(null,query_map)].join('')):null);
var select_smt = (function (){var or__4126__auto__ = selectOne;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = select;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
var or__4126__auto____$2 = selectDistinct;
if(cljs.core.truth_(or__4126__auto____$2)){
return or__4126__auto____$2;
} else {
return selectReduced;
}
}
}
})();
var inVector_QMARK_ = cljs.core.vector_QMARK_.call(null,select_smt);
var select_smt__$1 = ((inVector_QMARK_)?select_smt:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [select_smt], null));
var parsed_select = fluree.db.query.fql.parse_select.call(null,headers,vars,select_smt__$1);
var aggregates = cljs.core.filter.call(null,(function (p1__114228_SHARP_){
return cljs.core.contains_QMARK_.call(null,p1__114228_SHARP_,new cljs.core.Keyword(null,"code","code",1586293142));
}),parsed_select);
var expandMap_QMARK_ = cljs.core.some.call(null,(function (p1__114229_SHARP_){
return cljs.core.contains_QMARK_.call(null,p1__114229_SHARP_,new cljs.core.Keyword(null,"selection","selection",975998651));
}),parsed_select);
var aggregates__$1 = ((cljs.core.empty_QMARK_.call(null,aggregates))?null:aggregates);
var orderBy__$1 = (function (){var temp__5735__auto__ = new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5735__auto__)){
var orderBy__$1 = temp__5735__auto__;
if(cljs.core.truth_((function (){var or__4126__auto__ = typeof orderBy__$1 === 'string';
if(or__4126__auto__){
return or__4126__auto__;
} else {
if(cljs.core.vector_QMARK_.call(null,orderBy__$1)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["DESC",null,"ASC",null], null), null).call(null,cljs.core.first.call(null,orderBy__$1));
} else {
return false;
}
}
})())){
if(cljs.core.vector_QMARK_.call(null,orderBy__$1)){
return orderBy__$1;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",orderBy__$1], null);
}
} else {
throw cljs.core.ex_info.call(null,["Invalid orderBy clause, must by variable or two-tuple formatted ['ASC' or 'DESC', var]. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orderBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
} else {
return null;
}
})();
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289),new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"inVector?","inVector?",1948069375)],[expandMap_QMARK_,(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (100);
}
})(),(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"offset","offset",296498311).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})(),aggregates__$1,cljs.core.boolean$.call(null,selectOne),(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return false;
}
})(),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667).cljs$core$IFn$_invoke$arity$1(opts),cljs.core.boolean$.call(null,(function (){var or__4126__auto__ = selectDistinct;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return selectReduced;
}
})()),parsed_select,orderBy__$1,inVector_QMARK_]);
});
fluree.db.query.fql.construct_triples = (function fluree$db$query$fql$construct_triples(p__114233,p__114234){
var map__114235 = p__114233;
var map__114235__$1 = (((((!((map__114235 == null))))?(((((map__114235.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__114235.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__114235):map__114235);
var query_map = map__114235__$1;
var construct = cljs.core.get.call(null,map__114235__$1,new cljs.core.Keyword(null,"construct","construct",692547932));
var map__114236 = p__114234;
var map__114236__$1 = (((((!((map__114236 == null))))?(((((map__114236.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__114236.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__114236):map__114236);
var where_result = map__114236__$1;
var headers = cljs.core.get.call(null,map__114236__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__114236__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__114239 = cljs.core.map.call(null,(function (construct_item){
var temp__5733__auto__ = fluree.db.util.core.index_of.call(null,headers,cljs.core.symbol.call(null,construct_item));
if(cljs.core.truth_(temp__5733__auto__)){
var index_of = temp__5733__auto__;
return (function (row){
return cljs.core.nth.call(null,row,index_of);
});
} else {
return (function (row){
return construct_item;
});
}
}),construct);
var fn1 = cljs.core.nth.call(null,vec__114239,(0),null);
var fn2 = cljs.core.nth.call(null,vec__114239,(1),null);
var fn3 = cljs.core.nth.call(null,vec__114239,(2),null);
return cljs.core.map.call(null,(function (res){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fn1.call(null,res),fn2.call(null,res),fn3.call(null,res)], null);
}),tuples);
});
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,fuel,max_fuel,query_map,opts){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_114269){
var state_val_114270 = (state_114269[(1)]);
if((state_val_114270 === (7))){
var state_114269__$1 = state_114269;
var statearr_114271_114287 = state_114269__$1;
(statearr_114271_114287[(1)] = (9));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114270 === (1))){
var state_114269__$1 = state_114269;
var statearr_114273_114288 = state_114269__$1;
(statearr_114273_114288[(2)] = null);

(statearr_114273_114288[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114270 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_114269,(3),Error,null,(2));
var inst_114246 = fluree.db.query.analytical.q.call(null,query_map,fuel,max_fuel,db,opts);
var state_114269__$1 = state_114269;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_114269__$1,(5),inst_114246);
} else {
if((state_val_114270 === (6))){
var inst_114249 = (state_114269[(7)]);
var state_114269__$1 = state_114269;
var statearr_114274_114289 = state_114269__$1;
(statearr_114274_114289[(2)] = inst_114249);

(statearr_114274_114289[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114270 === (3))){
var inst_114242 = (state_114269[(2)]);
var state_114269__$1 = state_114269;
var statearr_114275_114290 = state_114269__$1;
(statearr_114275_114290[(2)] = inst_114242);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_114269__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114270 === (12))){
var inst_114259 = (state_114269[(2)]);
var inst_114260 = fluree.db.util.async.throw_err.call(null,inst_114259);
var state_114269__$1 = state_114269;
var statearr_114276_114291 = state_114269__$1;
(statearr_114276_114291[(2)] = inst_114260);

(statearr_114276_114291[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114270 === (2))){
var inst_114267 = (state_114269[(2)]);
var state_114269__$1 = state_114269;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_114269__$1,inst_114267);
} else {
if((state_val_114270 === (11))){
var inst_114263 = (state_114269[(2)]);
var state_114269__$1 = state_114269;
var statearr_114277_114292 = state_114269__$1;
(statearr_114277_114292[(2)] = inst_114263);

(statearr_114277_114292[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114270 === (9))){
var inst_114249 = (state_114269[(7)]);
var inst_114254 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_114249);
var inst_114255 = new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(inst_114249);
var inst_114256 = fluree.db.query.fql.get_ad_hoc_select_spec.call(null,inst_114254,inst_114255,query_map,opts);
var inst_114257 = fluree.db.query.fql.process_ad_hoc_res.call(null,db,inst_114249,inst_114256,opts);
var state_114269__$1 = state_114269;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_114269__$1,(12),inst_114257);
} else {
if((state_val_114270 === (5))){
var inst_114249 = (state_114269[(7)]);
var inst_114248 = (state_114269[(2)]);
var inst_114249__$1 = fluree.db.util.async.throw_err.call(null,inst_114248);
var inst_114250 = fluree.db.util.core.exception_QMARK_.call(null,inst_114249__$1);
var state_114269__$1 = (function (){var statearr_114278 = state_114269;
(statearr_114278[(7)] = inst_114249__$1);

return statearr_114278;
})();
if(inst_114250){
var statearr_114279_114293 = state_114269__$1;
(statearr_114279_114293[(1)] = (6));

} else {
var statearr_114280_114294 = state_114269__$1;
(statearr_114280_114294[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114270 === (10))){
var state_114269__$1 = state_114269;
var statearr_114281_114295 = state_114269__$1;
(statearr_114281_114295[(2)] = null);

(statearr_114281_114295[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114270 === (8))){
var inst_114265 = (state_114269[(2)]);
var state_114269__$1 = state_114269;
var statearr_114282_114296 = state_114269__$1;
(statearr_114282_114296[(2)] = inst_114265);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_114269__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$ad_hoc_query_$_state_machine__99975__auto__ = null;
var fluree$db$query$fql$ad_hoc_query_$_state_machine__99975__auto____0 = (function (){
var statearr_114283 = [null,null,null,null,null,null,null,null];
(statearr_114283[(0)] = fluree$db$query$fql$ad_hoc_query_$_state_machine__99975__auto__);

(statearr_114283[(1)] = (1));

return statearr_114283;
});
var fluree$db$query$fql$ad_hoc_query_$_state_machine__99975__auto____1 = (function (state_114269){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_114269);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e114284){if((e114284 instanceof Object)){
var ex__99978__auto__ = e114284;
var statearr_114285_114297 = state_114269;
(statearr_114285_114297[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_114269);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e114284;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__114298 = state_114269;
state_114269 = G__114298;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$fql$ad_hoc_query_$_state_machine__99975__auto__ = function(state_114269){
switch(arguments.length){
case 0:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__99975__auto____1.call(this,state_114269);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$ad_hoc_query_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$ad_hoc_query_$_state_machine__99975__auto____0;
fluree$db$query$fql$ad_hoc_query_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$ad_hoc_query_$_state_machine__99975__auto____1;
return fluree$db$query$fql$ad_hoc_query_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_114286 = f__100070__auto__.call(null);
(statearr_114286[(6)] = c__100069__auto__);

return statearr_114286;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Returns core async channel with results
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(var_args){
var G__114300 = arguments.length;
switch (G__114300) {
case 2:
return fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
return fluree.db.query.fql.query.call(null,db,query_map,null);
}));

(fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$3 = (function (db,query_map,opts){
var map__114301 = query_map;
var map__114301__$1 = (((((!((map__114301 == null))))?(((((map__114301.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__114301.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__114301):map__114301);
var select = cljs.core.get.call(null,map__114301__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.call(null,map__114301__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var where = cljs.core.get.call(null,map__114301__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var limit = cljs.core.get.call(null,map__114301__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__114301__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var component = cljs.core.get.call(null,map__114301__$1,new cljs.core.Keyword(null,"component","component",1555936782));
var selectDistinct = cljs.core.get.call(null,map__114301__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var prettyPrint = cljs.core.get.call(null,map__114301__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectOne = cljs.core.get.call(null,map__114301__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var from = cljs.core.get.call(null,map__114301__$1,new cljs.core.Keyword(null,"from","from",1815293044));
var groupBy = cljs.core.get.call(null,map__114301__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var opts_SINGLEQUOTE_ = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"limit","limit",-1355822363),limit,new cljs.core.Keyword(null,"offset","offset",296498311),(function (){var or__4126__auto__ = offset;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})(),new cljs.core.Keyword(null,"component","component",1555936782),component,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),orderBy,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),groupBy,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),prettyPrint], null),opts,new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query_map));
var opts_SINGLEQUOTE__SINGLEQUOTE_ = (cljs.core.truth_(selectOne)?cljs.core.assoc.call(null,opts_SINGLEQUOTE_,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1)):opts_SINGLEQUOTE_);
var opts_STAR_ = cljs.core.dissoc.call(null,opts_SINGLEQUOTE__SINGLEQUOTE_,new cljs.core.Keyword(null,"cache","cache",-1237023054));
if(cljs.core.truth_(new cljs.core.Keyword(null,"cache","cache",-1237023054).cljs$core$IFn$_invoke$arity$1(opts_STAR_))){
var oc = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287)], null));
return oc.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"query","query",-1288509510),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db),query_map,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"fuel","fuel",10405485)),new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(db)], null),(function (_){
var pc = cljs.core.async.promise_chan.call(null);
var c__100069__auto___114833 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_114309){
var state_val_114310 = (state_114309[(1)]);
if((state_val_114310 === (1))){
var inst_114303 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"cache","cache",-1237023054),false);
var inst_114304 = fluree.db.query.fql.query.call(null,db,query_map,inst_114303);
var state_114309__$1 = state_114309;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_114309__$1,(2),inst_114304);
} else {
if((state_val_114310 === (2))){
var inst_114306 = (state_114309[(2)]);
var inst_114307 = cljs.core.async.put_BANG_.call(null,pc,inst_114306);
var state_114309__$1 = state_114309;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_114309__$1,inst_114307);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__99975__auto__ = null;
var fluree$db$query$fql$state_machine__99975__auto____0 = (function (){
var statearr_114311 = [null,null,null,null,null,null,null];
(statearr_114311[(0)] = fluree$db$query$fql$state_machine__99975__auto__);

(statearr_114311[(1)] = (1));

return statearr_114311;
});
var fluree$db$query$fql$state_machine__99975__auto____1 = (function (state_114309){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_114309);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e114312){if((e114312 instanceof Object)){
var ex__99978__auto__ = e114312;
var statearr_114313_114834 = state_114309;
(statearr_114313_114834[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_114309);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e114312;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__114835 = state_114309;
state_114309 = G__114835;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__99975__auto__ = function(state_114309){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__99975__auto____1.call(this,state_114309);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__99975__auto____0;
fluree$db$query$fql$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__99975__auto____1;
return fluree$db$query$fql$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_114314 = f__100070__auto__.call(null);
(statearr_114314[(6)] = c__100069__auto___114833);

return statearr_114314;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));


return pc;
}));
} else {
var max_fuel = new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012).cljs$core$IFn$_invoke$arity$1(opts_STAR_);
var fuel = (function (){var or__4126__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.truth_((function (){var or__4126__auto____$1 = max_fuel;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
}
})())){
return cljs.core.volatile_BANG_.call(null,(0));
} else {
return null;
}
}
})();
if(cljs.core.sequential_QMARK_.call(null,where)){
return fluree.db.query.fql.ad_hoc_query.call(null,db,fuel,max_fuel,query_map,opts_STAR_);
} else {
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_114653){
var state_val_114654 = (state_114653[(1)]);
if((state_val_114654 === (121))){
var inst_114408 = (state_114653[(7)]);
var inst_114631 = (state_114653[(8)]);
var inst_114364 = (state_114653[(9)]);
var inst_114362 = (state_114653[(10)]);
var inst_114407 = (state_114653[(11)]);
var inst_114633 = fluree.db.query.fql.sort_offset_and_limit_res.call(null,inst_114407,inst_114408,inst_114364,inst_114362,inst_114631);
var state_114653__$1 = state_114653;
var statearr_114655_114836 = state_114653__$1;
(statearr_114655_114836[(2)] = inst_114633);

(statearr_114655_114836[(1)] = (123));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (65))){
var inst_114470 = (state_114653[(2)]);
var inst_114471 = fluree.db.util.async.throw_err.call(null,inst_114470);
var state_114653__$1 = state_114653;
var statearr_114656_114837 = state_114653__$1;
(statearr_114656_114837[(2)] = inst_114471);

(statearr_114656_114837[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (70))){
var inst_114500 = typeof from === 'string';
var state_114653__$1 = state_114653;
if(cljs.core.truth_(inst_114500)){
var statearr_114657_114838 = state_114653__$1;
(statearr_114657_114838[(1)] = (77));

} else {
var statearr_114658_114839 = state_114653__$1;
(statearr_114658_114839[(1)] = (78));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (62))){
var inst_114364 = (state_114653[(9)]);
var inst_114362 = (state_114653[(10)]);
var inst_114455 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_114456 = [inst_114362,inst_114364];
var inst_114457 = cljs.core.PersistentHashMap.fromArrays(inst_114455,inst_114456);
var state_114653__$1 = state_114653;
var statearr_114659_114840 = state_114653__$1;
(statearr_114659_114840[(2)] = inst_114457);

(statearr_114659_114840[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (74))){
var inst_114490 = (state_114653[(2)]);
var inst_114491 = fluree.db.query.range._block_or_tx_collection.call(null,db,inst_114490);
var state_114653__$1 = state_114653;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_114653__$1,(75),inst_114491);
} else {
if((state_val_114654 === (110))){
var inst_114585 = (state_114653[(2)]);
var inst_114586 = fluree.db.util.async.throw_err.call(null,inst_114585);
var state_114653__$1 = state_114653;
var statearr_114660_114841 = state_114653__$1;
(statearr_114660_114841[(2)] = inst_114586);

(statearr_114660_114841[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (128))){
var inst_114636 = (state_114653[(12)]);
var state_114653__$1 = state_114653;
var statearr_114661_114842 = state_114653__$1;
(statearr_114661_114842[(2)] = inst_114636);

(statearr_114661_114842[(1)] = (129));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (7))){
var inst_114339 = (state_114653[(2)]);
var inst_114341 = (opts_STAR_ == null);
var inst_114342 = cljs.core.not.call(null,inst_114341);
var state_114653__$1 = (function (){var statearr_114662 = state_114653;
(statearr_114662[(13)] = inst_114339);

return statearr_114662;
})();
if(inst_114342){
var statearr_114663_114843 = state_114653__$1;
(statearr_114663_114843[(1)] = (14));

} else {
var statearr_114664_114844 = state_114653__$1;
(statearr_114664_114844[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (59))){
var inst_114445 = (state_114653[(14)]);
var state_114653__$1 = state_114653;
var statearr_114665_114845 = state_114653__$1;
(statearr_114665_114845[(2)] = inst_114445);

(statearr_114665_114845[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (86))){
var inst_114546 = cljs.core.sequential_QMARK_.call(null,from);
var inst_114547 = cljs.core.every_QMARK_.call(null,fluree.db.util.core.subj_ident_QMARK_,from);
var inst_114548 = ((inst_114546) && (inst_114547));
var state_114653__$1 = state_114653;
if(cljs.core.truth_(inst_114548)){
var statearr_114666_114846 = state_114653__$1;
(statearr_114666_114846[(1)] = (96));

} else {
var statearr_114667_114847 = state_114653__$1;
(statearr_114667_114847[(1)] = (97));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (20))){
var inst_114357 = cljs.core.apply.call(null,cljs.core.hash_map,opts_STAR_);
var state_114653__$1 = state_114653;
var statearr_114668_114848 = state_114653__$1;
(statearr_114668_114848[(2)] = inst_114357);

(statearr_114668_114848[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (72))){
var inst_114484 = cljs.core.PersistentHashMap.EMPTY;
var state_114653__$1 = state_114653;
var statearr_114669_114849 = state_114653__$1;
(statearr_114669_114849[(2)] = inst_114484);

(statearr_114669_114849[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (58))){
var inst_114445 = (state_114653[(14)]);
var inst_114447 = cljs.core.distinct.call(null);
var inst_114448 = cljs.core.comp.call(null,inst_114445,inst_114447);
var state_114653__$1 = state_114653;
var statearr_114670_114850 = state_114653__$1;
(statearr_114670_114850[(2)] = inst_114448);

(statearr_114670_114850[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (60))){
var inst_114361 = (state_114653[(15)]);
var inst_114451 = (state_114653[(2)]);
var state_114653__$1 = (function (){var statearr_114671 = state_114653;
(statearr_114671[(16)] = inst_114451);

return statearr_114671;
})();
if(cljs.core.truth_(inst_114361)){
var statearr_114672_114851 = state_114653__$1;
(statearr_114672_114851[(1)] = (61));

} else {
var statearr_114673_114852 = state_114653__$1;
(statearr_114673_114852[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (27))){
var inst_114402 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114403 = [null,null];
var inst_114404 = (new cljs.core.PersistentVector(null,2,(5),inst_114402,inst_114403,null));
var state_114653__$1 = state_114653;
var statearr_114674_114853 = state_114653__$1;
(statearr_114674_114853[(2)] = inst_114404);

(statearr_114674_114853[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (1))){
var state_114653__$1 = state_114653;
var statearr_114675_114854 = state_114653__$1;
(statearr_114675_114854[(2)] = null);

(statearr_114675_114854[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (69))){
var inst_114361 = (state_114653[(15)]);
var state_114653__$1 = state_114653;
if(cljs.core.truth_(inst_114361)){
var statearr_114676_114855 = state_114653__$1;
(statearr_114676_114855[(1)] = (72));

} else {
var statearr_114677_114856 = state_114653__$1;
(statearr_114677_114856[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (101))){
var inst_114562 = (state_114653[(17)]);
var state_114653__$1 = state_114653;
var statearr_114678_114857 = state_114653__$1;
(statearr_114678_114857[(2)] = inst_114562);

(statearr_114678_114857[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (24))){
var inst_114365 = (state_114653[(18)]);
var state_114653__$1 = state_114653;
var statearr_114679_114858 = state_114653__$1;
(statearr_114679_114858[(2)] = inst_114365);

(statearr_114679_114858[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (102))){
var inst_114568 = (state_114653[(19)]);
var inst_114573 = cljs.core.int_QMARK_.call(null,inst_114568);
var state_114653__$1 = state_114653;
if(inst_114573){
var statearr_114680_114859 = state_114653__$1;
(statearr_114680_114859[(1)] = (104));

} else {
var statearr_114681_114860 = state_114653__$1;
(statearr_114681_114860[(1)] = (105));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (55))){
var inst_114439 = (state_114653[(20)]);
var inst_114441 = fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel);
var inst_114442 = cljs.core.comp.call(null,inst_114439,inst_114441);
var state_114653__$1 = state_114653;
var statearr_114682_114861 = state_114653__$1;
(statearr_114682_114861[(2)] = inst_114442);

(statearr_114682_114861[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (85))){
var inst_114522 = fluree.db.dbproto._subid.call(null,db,from,false);
var state_114653__$1 = state_114653;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_114653__$1,(88),inst_114522);
} else {
if((state_val_114654 === (39))){
var inst_114433 = typeof from === 'string';
var inst_114434 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(from);
var inst_114435 = clojure.string.includes_QMARK_.call(null,inst_114434,"/");
var inst_114436 = ((inst_114433) && (inst_114435));
var state_114653__$1 = state_114653;
if(cljs.core.truth_(inst_114436)){
var statearr_114683_114862 = state_114653__$1;
(statearr_114683_114862[(1)] = (52));

} else {
var statearr_114684_114863 = state_114653__$1;
(statearr_114684_114863[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (88))){
var inst_114525 = (state_114653[(21)]);
var inst_114524 = (state_114653[(2)]);
var inst_114525__$1 = fluree.db.util.async.throw_err.call(null,inst_114524);
var inst_114526 = (inst_114525__$1 == null);
var state_114653__$1 = (function (){var statearr_114685 = state_114653;
(statearr_114685[(21)] = inst_114525__$1);

return statearr_114685;
})();
if(cljs.core.truth_(inst_114526)){
var statearr_114686_114864 = state_114653__$1;
(statearr_114686_114864[(1)] = (89));

} else {
var statearr_114687_114865 = state_114653__$1;
(statearr_114687_114865[(1)] = (90));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (46))){
var state_114653__$1 = state_114653;
var statearr_114688_114866 = state_114653__$1;
(statearr_114688_114866[(2)] = null);

(statearr_114688_114866[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_114653,(3),Error,null,(2));
var state_114653__$1 = state_114653;
if(cljs.core.truth_(select)){
var statearr_114689_114867 = state_114653__$1;
(statearr_114689_114867[(1)] = (5));

} else {
var statearr_114690_114868 = state_114653__$1;
(statearr_114690_114868[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (77))){
var inst_114361 = (state_114653[(15)]);
var state_114653__$1 = state_114653;
if(cljs.core.truth_(inst_114361)){
var statearr_114691_114869 = state_114653__$1;
(statearr_114691_114869[(1)] = (80));

} else {
var statearr_114692_114870 = state_114653__$1;
(statearr_114692_114870[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (106))){
var inst_114588 = (state_114653[(22)]);
var inst_114588__$1 = (state_114653[(2)]);
var state_114653__$1 = (function (){var statearr_114693 = state_114653;
(statearr_114693[(22)] = inst_114588__$1);

return statearr_114693;
})();
if(cljs.core.truth_(inst_114588__$1)){
var statearr_114694_114871 = state_114653__$1;
(statearr_114694_114871[(1)] = (111));

} else {
var statearr_114695_114872 = state_114653__$1;
(statearr_114695_114872[(1)] = (112));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (119))){
var state_114653__$1 = state_114653;
var statearr_114696_114873 = state_114653__$1;
(statearr_114696_114873[(2)] = null);

(statearr_114696_114873[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (95))){
var inst_114537 = (state_114653[(23)]);
var inst_114544 = (state_114653[(2)]);
var state_114653__$1 = (function (){var statearr_114697 = state_114653;
(statearr_114697[(24)] = inst_114544);

return statearr_114697;
})();
var statearr_114698_114874 = state_114653__$1;
(statearr_114698_114874[(2)] = inst_114537);

(statearr_114698_114874[(1)] = (87));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (54))){
var inst_114629 = (state_114653[(2)]);
var state_114653__$1 = state_114653;
var statearr_114699_114875 = state_114653__$1;
(statearr_114699_114875[(2)] = inst_114629);

(statearr_114699_114875[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (92))){
var inst_114536 = (state_114653[(2)]);
var inst_114537 = fluree.db.util.async.throw_err.call(null,inst_114536);
var state_114653__$1 = (function (){var statearr_114700 = state_114653;
(statearr_114700[(23)] = inst_114537);

return statearr_114700;
})();
if(cljs.core.truth_(fuel)){
var statearr_114701_114876 = state_114653__$1;
(statearr_114701_114876[(1)] = (93));

} else {
var statearr_114702_114877 = state_114653__$1;
(statearr_114702_114877[(1)] = (94));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (104))){
var inst_114568 = (state_114653[(19)]);
var state_114653__$1 = state_114653;
var statearr_114703_114878 = state_114653__$1;
(statearr_114703_114878[(2)] = inst_114568);

(statearr_114703_114878[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (15))){
var state_114653__$1 = state_114653;
var statearr_114704_114879 = state_114653__$1;
(statearr_114704_114879[(2)] = false);

(statearr_114704_114879[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (48))){
var inst_114361 = (state_114653[(15)]);
var inst_114423 = (state_114653[(2)]);
var state_114653__$1 = (function (){var statearr_114705 = state_114653;
(statearr_114705[(25)] = inst_114423);

return statearr_114705;
})();
if(cljs.core.truth_(inst_114361)){
var statearr_114706_114880 = state_114653__$1;
(statearr_114706_114880[(1)] = (49));

} else {
var statearr_114707_114881 = state_114653__$1;
(statearr_114707_114881[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (50))){
var inst_114364 = (state_114653[(9)]);
var state_114653__$1 = state_114653;
var statearr_114708_114882 = state_114653__$1;
(statearr_114708_114882[(2)] = inst_114364);

(statearr_114708_114882[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (116))){
var inst_114362 = (state_114653[(10)]);
var state_114653__$1 = state_114653;
var statearr_114709_114883 = state_114653__$1;
(statearr_114709_114883[(2)] = inst_114362);

(statearr_114709_114883[(1)] = (117));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (75))){
var inst_114372 = (state_114653[(26)]);
var inst_114374 = (state_114653[(27)]);
var inst_114493 = (state_114653[(2)]);
var inst_114494 = fluree.db.util.async.throw_err.call(null,inst_114493);
var inst_114495 = fluree.db.query.fql.flake_select.call(null,db,inst_114374,fuel,max_fuel,inst_114372,inst_114494);
var state_114653__$1 = state_114653;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_114653__$1,(76),inst_114495);
} else {
if((state_val_114654 === (99))){
var inst_114561 = (state_114653[(28)]);
var inst_114568 = (state_114653[(19)]);
var inst_114567 = cljs.core.seq.call(null,inst_114561);
var inst_114568__$1 = cljs.core.first.call(null,inst_114567);
var inst_114569 = cljs.core.next.call(null,inst_114567);
var inst_114570 = cljs.core.not.call(null,inst_114568__$1);
var state_114653__$1 = (function (){var statearr_114710 = state_114653;
(statearr_114710[(29)] = inst_114569);

(statearr_114710[(19)] = inst_114568__$1);

return statearr_114710;
})();
if(inst_114570){
var statearr_114711_114884 = state_114653__$1;
(statearr_114711_114884[(1)] = (101));

} else {
var statearr_114712_114885 = state_114653__$1;
(statearr_114712_114885[(1)] = (102));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (21))){
var state_114653__$1 = state_114653;
var statearr_114713_114886 = state_114653__$1;
(statearr_114713_114886[(2)] = opts_STAR_);

(statearr_114713_114886[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (31))){
var inst_114400 = (state_114653[(2)]);
var state_114653__$1 = state_114653;
var statearr_114714_114887 = state_114653__$1;
(statearr_114714_114887[(2)] = inst_114400);

(statearr_114714_114887[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (113))){
var inst_114569 = (state_114653[(29)]);
var inst_114593 = (state_114653[(2)]);
var inst_114561 = inst_114569;
var inst_114562 = inst_114593;
var state_114653__$1 = (function (){var statearr_114715 = state_114653;
(statearr_114715[(28)] = inst_114561);

(statearr_114715[(17)] = inst_114562);

return statearr_114715;
})();
var statearr_114716_114888 = state_114653__$1;
(statearr_114716_114888[(2)] = null);

(statearr_114716_114888[(1)] = (99));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (32))){
var inst_114361 = (state_114653[(15)]);
var inst_114386 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114387 = [inst_114361,"ASC"];
var inst_114388 = (new cljs.core.PersistentVector(null,2,(5),inst_114386,inst_114387,null));
var state_114653__$1 = state_114653;
var statearr_114717_114889 = state_114653__$1;
(statearr_114717_114889[(2)] = inst_114388);

(statearr_114717_114889[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (40))){
var inst_114407 = (state_114653[(11)]);
var inst_114631 = (state_114653[(2)]);
var state_114653__$1 = (function (){var statearr_114718 = state_114653;
(statearr_114718[(8)] = inst_114631);

return statearr_114718;
})();
if(cljs.core.truth_(inst_114407)){
var statearr_114719_114890 = state_114653__$1;
(statearr_114719_114890[(1)] = (121));

} else {
var statearr_114720_114891 = state_114653__$1;
(statearr_114720_114891[(1)] = (122));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (129))){
var inst_114649 = (state_114653[(2)]);
var state_114653__$1 = state_114653;
var statearr_114721_114892 = state_114653__$1;
(statearr_114721_114892[(2)] = inst_114649);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_114653__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (91))){
var inst_114364 = (state_114653[(9)]);
var inst_114372 = (state_114653[(26)]);
var inst_114362 = (state_114653[(10)]);
var inst_114374 = (state_114653[(27)]);
var inst_114533 = (state_114653[(2)]);
var inst_114534 = fluree.db.query.fql.subject_select.call(null,db,inst_114374,fuel,max_fuel,inst_114372,inst_114533,inst_114362,inst_114364);
var state_114653__$1 = state_114653;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_114653__$1,(92),inst_114534);
} else {
if((state_val_114654 === (117))){
var inst_114364 = (state_114653[(9)]);
var inst_114600 = (state_114653[(30)]);
var inst_114372 = (state_114653[(26)]);
var inst_114374 = (state_114653[(27)]);
var inst_114604 = (state_114653[(2)]);
var inst_114605 = fluree.db.query.fql.subject_select.call(null,db,inst_114374,fuel,max_fuel,inst_114372,inst_114600,inst_114604,inst_114364);
var state_114653__$1 = state_114653;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_114653__$1,(114),inst_114605);
} else {
if((state_val_114654 === (108))){
var state_114653__$1 = state_114653;
var statearr_114722_114893 = state_114653__$1;
(statearr_114722_114893[(2)] = null);

(statearr_114722_114893[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (56))){
var inst_114439 = (state_114653[(20)]);
var state_114653__$1 = state_114653;
var statearr_114723_114894 = state_114653__$1;
(statearr_114723_114894[(2)] = inst_114439);

(statearr_114723_114894[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (33))){
var state_114653__$1 = state_114653;
var statearr_114724_114895 = state_114653__$1;
(statearr_114724_114895[(1)] = (35));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (13))){
var inst_114335 = (state_114653[(2)]);
var state_114653__$1 = state_114653;
var statearr_114726_114896 = state_114653__$1;
(statearr_114726_114896[(2)] = inst_114335);

(statearr_114726_114896[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (22))){
var inst_114363 = (state_114653[(31)]);
var inst_114339 = (state_114653[(13)]);
var inst_114360 = (state_114653[(2)]);
var inst_114361 = cljs.core.get.call(null,inst_114360,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_114362 = cljs.core.get.call(null,inst_114360,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_114363__$1 = cljs.core.get.call(null,inst_114360,new cljs.core.Keyword(null,"component","component",1555936782));
var inst_114364 = cljs.core.get.call(null,inst_114360,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_114365 = fluree.db.query.fql_parser.parse_db.call(null,db,inst_114339,opts_STAR_);
var inst_114366 = (inst_114363__$1 == null);
var inst_114367 = cljs.core.not.call(null,inst_114366);
var state_114653__$1 = (function (){var statearr_114727 = state_114653;
(statearr_114727[(9)] = inst_114364);

(statearr_114727[(31)] = inst_114363__$1);

(statearr_114727[(10)] = inst_114362);

(statearr_114727[(18)] = inst_114365);

(statearr_114727[(15)] = inst_114361);

return statearr_114727;
})();
if(inst_114367){
var statearr_114728_114897 = state_114653__$1;
(statearr_114728_114897[(1)] = (23));

} else {
var statearr_114729_114898 = state_114653__$1;
(statearr_114729_114898[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (90))){
var inst_114525 = (state_114653[(21)]);
var inst_114529 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114530 = [inst_114525];
var inst_114531 = (new cljs.core.PersistentVector(null,1,(5),inst_114529,inst_114530,null));
var state_114653__$1 = state_114653;
var statearr_114730_114899 = state_114653__$1;
(statearr_114730_114899[(2)] = inst_114531);

(statearr_114730_114899[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (109))){
var inst_114568 = (state_114653[(19)]);
var inst_114582 = (state_114653[(2)]);
var inst_114583 = fluree.db.dbproto._subid.call(null,db,inst_114568,false);
var state_114653__$1 = (function (){var statearr_114731 = state_114653;
(statearr_114731[(32)] = inst_114582);

return statearr_114731;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_114653__$1,(110),inst_114583);
} else {
if((state_val_114654 === (36))){
var state_114653__$1 = state_114653;
var statearr_114732_114900 = state_114653__$1;
(statearr_114732_114900[(2)] = null);

(statearr_114732_114900[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (41))){
var state_114653__$1 = state_114653;
var statearr_114733_114901 = state_114653__$1;
(statearr_114733_114901[(2)] = from);

(statearr_114733_114901[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (118))){
var inst_114611 = cljs.core.pr_str.call(null,query_map);
var inst_114612 = ["Invalid 'from' in query:",inst_114611].join('');
var inst_114613 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_114614 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_114615 = cljs.core.PersistentHashMap.fromArrays(inst_114613,inst_114614);
var inst_114616 = cljs.core.ex_info.call(null,inst_114612,inst_114615);
var state_114653__$1 = state_114653;
var statearr_114734_114902 = state_114653__$1;
(statearr_114734_114902[(2)] = inst_114616);

(statearr_114734_114902[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (89))){
var state_114653__$1 = state_114653;
var statearr_114735_114903 = state_114653__$1;
(statearr_114735_114903[(2)] = null);

(statearr_114735_114903[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (100))){
var inst_114361 = (state_114653[(15)]);
var inst_114598 = (state_114653[(2)]);
var inst_114599 = cljs.core.PersistentVector.EMPTY;
var inst_114600 = cljs.core.into.call(null,inst_114599,inst_114598);
var state_114653__$1 = (function (){var statearr_114736 = state_114653;
(statearr_114736[(30)] = inst_114600);

return statearr_114736;
})();
if(cljs.core.truth_(inst_114361)){
var statearr_114737_114904 = state_114653__$1;
(statearr_114737_114904[(1)] = (115));

} else {
var statearr_114738_114905 = state_114653__$1;
(statearr_114738_114905[(1)] = (116));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (122))){
var inst_114631 = (state_114653[(8)]);
var state_114653__$1 = state_114653;
var statearr_114739_114906 = state_114653__$1;
(statearr_114739_114906[(2)] = inst_114631);

(statearr_114739_114906[(1)] = (123));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (43))){
var inst_114415 = (state_114653[(2)]);
var inst_114416 = fluree.db.query.fql.where_filter.call(null,db,where,inst_114415);
var state_114653__$1 = state_114653;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_114653__$1,(44),inst_114416);
} else {
if((state_val_114654 === (61))){
var inst_114453 = cljs.core.PersistentHashMap.EMPTY;
var state_114653__$1 = state_114653;
var statearr_114740_114907 = state_114653__$1;
(statearr_114740_114907[(2)] = inst_114453);

(statearr_114740_114907[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (29))){
var inst_114361 = (state_114653[(15)]);
var inst_114378 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114379 = cljs.core.second.call(null,inst_114361);
var inst_114380 = cljs.core.first.call(null,inst_114361);
var inst_114381 = [inst_114379,inst_114380];
var inst_114382 = (new cljs.core.PersistentVector(null,2,(5),inst_114378,inst_114381,null));
var state_114653__$1 = state_114653;
var statearr_114741_114908 = state_114653__$1;
(statearr_114741_114908[(2)] = inst_114382);

(statearr_114741_114908[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (44))){
var inst_114361 = (state_114653[(15)]);
var inst_114418 = (state_114653[(2)]);
var inst_114419 = fluree.db.util.async.throw_err.call(null,inst_114418);
var state_114653__$1 = (function (){var statearr_114742 = state_114653;
(statearr_114742[(33)] = inst_114419);

return statearr_114742;
})();
if(cljs.core.truth_(inst_114361)){
var statearr_114743_114909 = state_114653__$1;
(statearr_114743_114909[(1)] = (46));

} else {
var statearr_114744_114910 = state_114653__$1;
(statearr_114744_114910[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (93))){
var inst_114539 = cljs.core._deref.call(null,fuel);
var inst_114540 = (inst_114539 + (1));
var inst_114541 = cljs.core._vreset_BANG_.call(null,fuel,inst_114540);
var state_114653__$1 = state_114653;
var statearr_114745_114911 = state_114653__$1;
(statearr_114745_114911[(2)] = inst_114541);

(statearr_114745_114911[(1)] = (95));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (6))){
var state_114653__$1 = state_114653;
if(cljs.core.truth_(selectOne)){
var statearr_114746_114912 = state_114653__$1;
(statearr_114746_114912[(1)] = (8));

} else {
var statearr_114747_114913 = state_114653__$1;
(statearr_114747_114913[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (111))){
var inst_114588 = (state_114653[(22)]);
var inst_114562 = (state_114653[(17)]);
var inst_114590 = cljs.core.conj.call(null,inst_114562,inst_114588);
var state_114653__$1 = state_114653;
var statearr_114748_114914 = state_114653__$1;
(statearr_114748_114914[(2)] = inst_114590);

(statearr_114748_114914[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (28))){
var inst_114406 = (state_114653[(2)]);
var inst_114407 = cljs.core.nth.call(null,inst_114406,(0),null);
var inst_114408 = cljs.core.nth.call(null,inst_114406,(1),null);
var inst_114409 = typeof where === 'string';
var state_114653__$1 = (function (){var statearr_114749 = state_114653;
(statearr_114749[(7)] = inst_114408);

(statearr_114749[(11)] = inst_114407);

return statearr_114749;
})();
if(cljs.core.truth_(inst_114409)){
var statearr_114750_114915 = state_114653__$1;
(statearr_114750_114915[(1)] = (38));

} else {
var statearr_114751_114916 = state_114653__$1;
(statearr_114751_114916[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (64))){
var inst_114451 = (state_114653[(16)]);
var inst_114372 = (state_114653[(26)]);
var inst_114362 = (state_114653[(10)]);
var inst_114374 = (state_114653[(27)]);
var inst_114465 = (state_114653[(2)]);
var inst_114466 = fluree.db.util.async.throw_err.call(null,inst_114465);
var inst_114467 = cljs.core.sequence.call(null,inst_114451,inst_114466);
var inst_114468 = fluree.db.query.fql.subject_select.call(null,db,inst_114374,fuel,max_fuel,inst_114372,inst_114467,inst_114362);
var state_114653__$1 = state_114653;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_114653__$1,(65),inst_114468);
} else {
if((state_val_114654 === (103))){
var inst_114596 = (state_114653[(2)]);
var state_114653__$1 = state_114653;
var statearr_114752_114917 = state_114653__$1;
(statearr_114752_114917[(2)] = inst_114596);

(statearr_114752_114917[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (51))){
var inst_114419 = (state_114653[(33)]);
var inst_114372 = (state_114653[(26)]);
var inst_114423 = (state_114653[(25)]);
var inst_114374 = (state_114653[(27)]);
var inst_114427 = (state_114653[(2)]);
var inst_114428 = fluree.db.query.fql.subject_select.call(null,db,inst_114374,fuel,max_fuel,inst_114372,inst_114419,inst_114423,inst_114427);
var state_114653__$1 = state_114653;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_114653__$1,(45),inst_114428);
} else {
if((state_val_114654 === (25))){
var inst_114361 = (state_114653[(15)]);
var inst_114372 = (state_114653[(2)]);
var inst_114373 = cljs.core.PersistentHashMap.EMPTY;
var inst_114374 = cljs.core.volatile_BANG_.call(null,inst_114373);
var state_114653__$1 = (function (){var statearr_114753 = state_114653;
(statearr_114753[(26)] = inst_114372);

(statearr_114753[(27)] = inst_114374);

return statearr_114753;
})();
if(cljs.core.truth_(inst_114361)){
var statearr_114754_114918 = state_114653__$1;
(statearr_114754_114918[(1)] = (26));

} else {
var statearr_114755_114919 = state_114653__$1;
(statearr_114755_114919[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (34))){
var inst_114398 = (state_114653[(2)]);
var state_114653__$1 = state_114653;
var statearr_114756_114920 = state_114653__$1;
(statearr_114756_114920[(2)] = inst_114398);

(statearr_114756_114920[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (125))){
var state_114653__$1 = state_114653;
var statearr_114757_114921 = state_114653__$1;
(statearr_114757_114921[(2)] = selectOne);

(statearr_114757_114921[(1)] = (126));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (17))){
var state_114653__$1 = state_114653;
var statearr_114758_114922 = state_114653__$1;
(statearr_114758_114922[(2)] = true);

(statearr_114758_114922[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (3))){
var inst_114315 = (state_114653[(2)]);
var state_114653__$1 = state_114653;
var statearr_114759_114923 = state_114653__$1;
(statearr_114759_114923[(2)] = inst_114315);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_114653__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (12))){
var inst_114329 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_114330 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_114331 = cljs.core.PersistentHashMap.fromArrays(inst_114329,inst_114330);
var inst_114332 = cljs.core.ex_info.call(null,"Query missing :select or :selectOne.",inst_114331);
var inst_114333 = (function(){throw inst_114332})();
var state_114653__$1 = state_114653;
var statearr_114760_114924 = state_114653__$1;
(statearr_114760_114924[(2)] = inst_114333);

(statearr_114760_114924[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (2))){
var inst_114651 = (state_114653[(2)]);
var state_114653__$1 = state_114653;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_114653__$1,inst_114651);
} else {
if((state_val_114654 === (66))){
var inst_114475 = ["_tx",null,"_block",null];
var inst_114476 = (new cljs.core.PersistentArrayMap(null,2,inst_114475,null));
var inst_114477 = (new cljs.core.PersistentHashSet(null,inst_114476,null));
var inst_114478 = inst_114477.call(null,from);
var state_114653__$1 = state_114653;
var statearr_114761_114925 = state_114653__$1;
(statearr_114761_114925[(2)] = inst_114478);

(statearr_114761_114925[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (107))){
var inst_114577 = cljs.core._deref.call(null,fuel);
var inst_114578 = (inst_114577 + (1));
var inst_114579 = cljs.core._vreset_BANG_.call(null,fuel,inst_114578);
var state_114653__$1 = state_114653;
var statearr_114762_114926 = state_114653__$1;
(statearr_114762_114926[(2)] = inst_114579);

(statearr_114762_114926[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (23))){
var inst_114363 = (state_114653[(31)]);
var inst_114365 = (state_114653[(18)]);
var inst_114369 = cljs.core.assoc.call(null,inst_114365,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),inst_114363);
var state_114653__$1 = state_114653;
var statearr_114763_114927 = state_114653__$1;
(statearr_114763_114927[(2)] = inst_114369);

(statearr_114763_114927[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (47))){
var inst_114362 = (state_114653[(10)]);
var state_114653__$1 = state_114653;
var statearr_114764_114928 = state_114653__$1;
(statearr_114764_114928[(2)] = inst_114362);

(statearr_114764_114928[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (35))){
var inst_114391 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114392 = [null,null];
var inst_114393 = (new cljs.core.PersistentVector(null,2,(5),inst_114391,inst_114392,null));
var state_114653__$1 = state_114653;
var statearr_114765_114929 = state_114653__$1;
(statearr_114765_114929[(2)] = inst_114393);

(statearr_114765_114929[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (127))){
var inst_114636 = (state_114653[(12)]);
var inst_114646 = cljs.core.first.call(null,inst_114636);
var state_114653__$1 = state_114653;
var statearr_114766_114930 = state_114653__$1;
(statearr_114766_114930[(2)] = inst_114646);

(statearr_114766_114930[(1)] = (129));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (82))){
var inst_114509 = (state_114653[(2)]);
var inst_114510 = fluree.db.query.range.collection.call(null,db,from,inst_114509);
var state_114653__$1 = state_114653;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_114653__$1,(83),inst_114510);
} else {
if((state_val_114654 === (76))){
var inst_114497 = (state_114653[(2)]);
var inst_114498 = fluree.db.util.async.throw_err.call(null,inst_114497);
var state_114653__$1 = state_114653;
var statearr_114767_114931 = state_114653__$1;
(statearr_114767_114931[(2)] = inst_114498);

(statearr_114767_114931[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (97))){
var state_114653__$1 = state_114653;
var statearr_114768_114932 = state_114653__$1;
(statearr_114768_114932[(1)] = (118));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (19))){
var inst_114352 = (state_114653[(2)]);
var state_114653__$1 = state_114653;
var statearr_114770_114933 = state_114653__$1;
(statearr_114770_114933[(2)] = inst_114352);

(statearr_114770_114933[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (57))){
var inst_114445 = (state_114653[(2)]);
var state_114653__$1 = (function (){var statearr_114771 = state_114653;
(statearr_114771[(14)] = inst_114445);

return statearr_114771;
})();
var statearr_114772_114934 = state_114653__$1;
(statearr_114772_114934[(1)] = (58));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (68))){
var inst_114481 = (state_114653[(2)]);
var state_114653__$1 = state_114653;
if(cljs.core.truth_(inst_114481)){
var statearr_114774_114935 = state_114653__$1;
(statearr_114774_114935[(1)] = (69));

} else {
var statearr_114775_114936 = state_114653__$1;
(statearr_114775_114936[(1)] = (70));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (11))){
var state_114653__$1 = state_114653;
var statearr_114776_114937 = state_114653__$1;
(statearr_114776_114937[(2)] = selectDistinct);

(statearr_114776_114937[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (115))){
var state_114653__$1 = state_114653;
var statearr_114777_114938 = state_114653__$1;
(statearr_114777_114938[(2)] = null);

(statearr_114777_114938[(1)] = (117));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (9))){
var state_114653__$1 = state_114653;
if(cljs.core.truth_(selectDistinct)){
var statearr_114778_114939 = state_114653__$1;
(statearr_114778_114939[(1)] = (11));

} else {
var statearr_114779_114940 = state_114653__$1;
(statearr_114779_114940[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (5))){
var state_114653__$1 = state_114653;
var statearr_114780_114941 = state_114653__$1;
(statearr_114780_114941[(2)] = select);

(statearr_114780_114941[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (112))){
var inst_114562 = (state_114653[(17)]);
var state_114653__$1 = state_114653;
var statearr_114781_114942 = state_114653__$1;
(statearr_114781_114942[(2)] = inst_114562);

(statearr_114781_114942[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (83))){
var inst_114372 = (state_114653[(26)]);
var inst_114374 = (state_114653[(27)]);
var inst_114512 = (state_114653[(2)]);
var inst_114513 = fluree.db.util.async.throw_err.call(null,inst_114512);
var inst_114514 = fluree.db.query.fql.flake_select.call(null,db,inst_114374,fuel,max_fuel,inst_114372,inst_114513);
var state_114653__$1 = state_114653;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_114653__$1,(84),inst_114514);
} else {
if((state_val_114654 === (14))){
var inst_114344 = opts_STAR_.cljs$lang$protocol_mask$partition0$;
var inst_114345 = (inst_114344 & (64));
var inst_114346 = opts_STAR_.cljs$core$ISeq$;
var inst_114347 = (cljs.core.PROTOCOL_SENTINEL === inst_114346);
var inst_114348 = ((inst_114345) || (inst_114347));
var state_114653__$1 = state_114653;
if(cljs.core.truth_(inst_114348)){
var statearr_114782_114943 = state_114653__$1;
(statearr_114782_114943[(1)] = (17));

} else {
var statearr_114783_114944 = state_114653__$1;
(statearr_114783_114944[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (45))){
var inst_114430 = (state_114653[(2)]);
var inst_114431 = fluree.db.util.async.throw_err.call(null,inst_114430);
var state_114653__$1 = state_114653;
var statearr_114784_114945 = state_114653__$1;
(statearr_114784_114945[(2)] = inst_114431);

(statearr_114784_114945[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (53))){
var inst_114473 = typeof from === 'string';
var state_114653__$1 = state_114653;
if(cljs.core.truth_(inst_114473)){
var statearr_114785_114946 = state_114653__$1;
(statearr_114785_114946[(1)] = (66));

} else {
var statearr_114786_114947 = state_114653__$1;
(statearr_114786_114947[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (78))){
var inst_114519 = fluree.db.util.core.subj_ident_QMARK_.call(null,from);
var state_114653__$1 = state_114653;
if(inst_114519){
var statearr_114787_114948 = state_114653__$1;
(statearr_114787_114948[(1)] = (85));

} else {
var statearr_114788_114949 = state_114653__$1;
(statearr_114788_114949[(1)] = (86));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (26))){
var inst_114361 = (state_114653[(15)]);
var inst_114376 = cljs.core.vector_QMARK_.call(null,inst_114361);
var state_114653__$1 = state_114653;
if(inst_114376){
var statearr_114789_114950 = state_114653__$1;
(statearr_114789_114950[(1)] = (29));

} else {
var statearr_114790_114951 = state_114653__$1;
(statearr_114790_114951[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (123))){
var inst_114636 = (state_114653[(2)]);
var state_114653__$1 = (function (){var statearr_114791 = state_114653;
(statearr_114791[(12)] = inst_114636);

return statearr_114791;
})();
if(cljs.core.truth_(selectOne)){
var statearr_114792_114952 = state_114653__$1;
(statearr_114792_114952[(1)] = (124));

} else {
var statearr_114793_114953 = state_114653__$1;
(statearr_114793_114953[(1)] = (125));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (16))){
var inst_114355 = (state_114653[(2)]);
var state_114653__$1 = state_114653;
if(cljs.core.truth_(inst_114355)){
var statearr_114794_114954 = state_114653__$1;
(statearr_114794_114954[(1)] = (20));

} else {
var statearr_114795_114955 = state_114653__$1;
(statearr_114795_114955[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (81))){
var inst_114364 = (state_114653[(9)]);
var inst_114362 = (state_114653[(10)]);
var inst_114505 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_114506 = [inst_114362,inst_114364];
var inst_114507 = cljs.core.PersistentHashMap.fromArrays(inst_114505,inst_114506);
var state_114653__$1 = state_114653;
var statearr_114796_114956 = state_114653__$1;
(statearr_114796_114956[(2)] = inst_114507);

(statearr_114796_114956[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (120))){
var inst_114619 = (state_114653[(2)]);
var state_114653__$1 = state_114653;
var statearr_114797_114957 = state_114653__$1;
(statearr_114797_114957[(2)] = inst_114619);

(statearr_114797_114957[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (79))){
var inst_114625 = (state_114653[(2)]);
var state_114653__$1 = state_114653;
var statearr_114798_114958 = state_114653__$1;
(statearr_114798_114958[(2)] = inst_114625);

(statearr_114798_114958[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (38))){
var inst_114411 = typeof from === 'string';
var state_114653__$1 = state_114653;
if(cljs.core.truth_(inst_114411)){
var statearr_114799_114959 = state_114653__$1;
(statearr_114799_114959[(1)] = (41));

} else {
var statearr_114800_114960 = state_114653__$1;
(statearr_114800_114960[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (126))){
var inst_114644 = (state_114653[(2)]);
var state_114653__$1 = state_114653;
if(cljs.core.truth_(inst_114644)){
var statearr_114801_114961 = state_114653__$1;
(statearr_114801_114961[(1)] = (127));

} else {
var statearr_114802_114962 = state_114653__$1;
(statearr_114802_114962[(1)] = (128));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (98))){
var inst_114621 = (state_114653[(2)]);
var state_114653__$1 = state_114653;
var statearr_114803_114963 = state_114653__$1;
(statearr_114803_114963[(2)] = inst_114621);

(statearr_114803_114963[(1)] = (87));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (124))){
var inst_114636 = (state_114653[(12)]);
var inst_114638 = cljs.core.coll_QMARK_.call(null,inst_114636);
var inst_114639 = fluree.db.util.core.exception_QMARK_.call(null,inst_114636);
var inst_114640 = (!(inst_114639));
var inst_114641 = ((inst_114638) && (inst_114640));
var state_114653__$1 = state_114653;
var statearr_114804_114964 = state_114653__$1;
(statearr_114804_114964[(2)] = inst_114641);

(statearr_114804_114964[(1)] = (126));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (87))){
var inst_114623 = (state_114653[(2)]);
var state_114653__$1 = state_114653;
var statearr_114805_114965 = state_114653__$1;
(statearr_114805_114965[(2)] = inst_114623);

(statearr_114805_114965[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (30))){
var inst_114361 = (state_114653[(15)]);
var inst_114384 = typeof inst_114361 === 'string';
var state_114653__$1 = state_114653;
if(cljs.core.truth_(inst_114384)){
var statearr_114806_114966 = state_114653__$1;
(statearr_114806_114966[(1)] = (32));

} else {
var statearr_114807_114967 = state_114653__$1;
(statearr_114807_114967[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (73))){
var inst_114364 = (state_114653[(9)]);
var inst_114362 = (state_114653[(10)]);
var inst_114486 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_114487 = [inst_114362,inst_114364];
var inst_114488 = cljs.core.PersistentHashMap.fromArrays(inst_114486,inst_114487);
var state_114653__$1 = state_114653;
var statearr_114808_114968 = state_114653__$1;
(statearr_114808_114968[(2)] = inst_114488);

(statearr_114808_114968[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (96))){
var inst_114557 = cljs.core.seq.call(null,from);
var inst_114558 = cljs.core.first.call(null,inst_114557);
var inst_114559 = cljs.core.next.call(null,inst_114557);
var inst_114560 = cljs.core.PersistentVector.EMPTY;
var inst_114561 = from;
var inst_114562 = inst_114560;
var state_114653__$1 = (function (){var statearr_114809 = state_114653;
(statearr_114809[(34)] = inst_114558);

(statearr_114809[(35)] = inst_114559);

(statearr_114809[(28)] = inst_114561);

(statearr_114809[(17)] = inst_114562);

return statearr_114809;
})();
var statearr_114810_114969 = state_114653__$1;
(statearr_114810_114969[(2)] = null);

(statearr_114810_114969[(1)] = (99));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (10))){
var inst_114337 = (state_114653[(2)]);
var state_114653__$1 = state_114653;
var statearr_114811_114970 = state_114653__$1;
(statearr_114811_114970[(2)] = inst_114337);

(statearr_114811_114970[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (18))){
var state_114653__$1 = state_114653;
var statearr_114812_114971 = state_114653__$1;
(statearr_114812_114971[(2)] = false);

(statearr_114812_114971[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (105))){
var state_114653__$1 = state_114653;
if(cljs.core.truth_(fuel)){
var statearr_114813_114972 = state_114653__$1;
(statearr_114813_114972[(1)] = (107));

} else {
var statearr_114814_114973 = state_114653__$1;
(statearr_114814_114973[(1)] = (108));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (52))){
var inst_114439 = cljs.core.map.call(null,fluree.db.query.fql.s);
var state_114653__$1 = (function (){var statearr_114815 = state_114653;
(statearr_114815[(20)] = inst_114439);

return statearr_114815;
})();
if(cljs.core.truth_(fuel)){
var statearr_114816_114974 = state_114653__$1;
(statearr_114816_114974[(1)] = (55));

} else {
var statearr_114817_114975 = state_114653__$1;
(statearr_114817_114975[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (114))){
var inst_114607 = (state_114653[(2)]);
var inst_114608 = fluree.db.util.async.throw_err.call(null,inst_114607);
var state_114653__$1 = state_114653;
var statearr_114818_114976 = state_114653__$1;
(statearr_114818_114976[(2)] = inst_114608);

(statearr_114818_114976[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (67))){
var state_114653__$1 = state_114653;
var statearr_114819_114977 = state_114653__$1;
(statearr_114819_114977[(2)] = false);

(statearr_114819_114977[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (71))){
var inst_114627 = (state_114653[(2)]);
var state_114653__$1 = state_114653;
var statearr_114820_114978 = state_114653__$1;
(statearr_114820_114978[(2)] = inst_114627);

(statearr_114820_114978[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (42))){
var state_114653__$1 = state_114653;
var statearr_114821_114979 = state_114653__$1;
(statearr_114821_114979[(2)] = null);

(statearr_114821_114979[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (80))){
var inst_114503 = cljs.core.PersistentHashMap.EMPTY;
var state_114653__$1 = state_114653;
var statearr_114822_114980 = state_114653__$1;
(statearr_114822_114980[(2)] = inst_114503);

(statearr_114822_114980[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (37))){
var inst_114396 = (state_114653[(2)]);
var state_114653__$1 = state_114653;
var statearr_114823_114981 = state_114653__$1;
(statearr_114823_114981[(2)] = inst_114396);

(statearr_114823_114981[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (63))){
var inst_114459 = (state_114653[(2)]);
var inst_114460 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114461 = [from];
var inst_114462 = (new cljs.core.PersistentVector(null,1,(5),inst_114460,inst_114461,null));
var inst_114463 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_114462,inst_114459);
var state_114653__$1 = state_114653;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_114653__$1,(64),inst_114463);
} else {
if((state_val_114654 === (94))){
var state_114653__$1 = state_114653;
var statearr_114824_114982 = state_114653__$1;
(statearr_114824_114982[(2)] = null);

(statearr_114824_114982[(1)] = (95));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (8))){
var state_114653__$1 = state_114653;
var statearr_114825_114983 = state_114653__$1;
(statearr_114825_114983[(2)] = selectOne);

(statearr_114825_114983[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (49))){
var state_114653__$1 = state_114653;
var statearr_114826_114984 = state_114653__$1;
(statearr_114826_114984[(2)] = null);

(statearr_114826_114984[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_114654 === (84))){
var inst_114516 = (state_114653[(2)]);
var inst_114517 = fluree.db.util.async.throw_err.call(null,inst_114516);
var state_114653__$1 = state_114653;
var statearr_114827_114985 = state_114653__$1;
(statearr_114827_114985[(2)] = inst_114517);

(statearr_114827_114985[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__99975__auto__ = null;
var fluree$db$query$fql$state_machine__99975__auto____0 = (function (){
var statearr_114828 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_114828[(0)] = fluree$db$query$fql$state_machine__99975__auto__);

(statearr_114828[(1)] = (1));

return statearr_114828;
});
var fluree$db$query$fql$state_machine__99975__auto____1 = (function (state_114653){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_114653);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e114829){if((e114829 instanceof Object)){
var ex__99978__auto__ = e114829;
var statearr_114830_114986 = state_114653;
(statearr_114830_114986[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_114653);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e114829;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__114987 = state_114653;
state_114653 = G__114987;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__99975__auto__ = function(state_114653){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__99975__auto____1.call(this,state_114653);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__99975__auto____0;
fluree$db$query$fql$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__99975__auto____1;
return fluree$db$query$fql$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_114831 = f__100070__auto__.call(null);
(statearr_114831[(6)] = c__100069__auto__);

return statearr_114831;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}
}
}));

(fluree.db.query.fql.query.cljs$lang$maxFixedArity = 3);

