// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.index');
goog.require('cljs.core');
goog.require('clojure.data.avl');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.log');

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.IndexConfig = (function (index_type,comparator,historyComparator,__meta,__extmap,__hash){
this.index_type = index_type;
this.comparator = comparator;
this.historyComparator = historyComparator;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.IndexConfig.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k105586,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__105590 = k105586;
var G__105590__$1 = (((G__105590 instanceof cljs.core.Keyword))?G__105590.fqn:null);
switch (G__105590__$1) {
case "index-type":
return self__.index_type;

break;
case "comparator":
return self__.comparator;

break;
case "historyComparator":
return self__.historyComparator;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k105586,else__4383__auto__);

}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4402__auto__,p__105591){
var vec__105592 = p__105591;
var k__4403__auto__ = cljs.core.nth.call(null,vec__105592,(0),null);
var v__4404__auto__ = cljs.core.nth.call(null,vec__105592,(1),null);
return f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__);
}),init__4401__auto__,this__4399__auto____$1);
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,pr_pair__4397__auto__,"#fluree.db.index.IndexConfig{",", ","}",opts__4396__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"index-type","index-type",500383962),self__.index_type],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"comparator","comparator",2144896662),self__.comparator],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),self__.historyComparator],null))], null),self__.__extmap));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__105585){
var self__ = this;
var G__105585__$1 = this;
return (new cljs.core.RecordIter((0),G__105585__$1,3,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"comparator","comparator",2144896662),new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (3 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (1512230614 ^ cljs.core.hash_unordered_coll.call(null,coll__4377__auto__));
}).call(null,this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this105587,other105588){
var self__ = this;
var this105587__$1 = this;
return (((!((other105588 == null)))) && ((this105587__$1.constructor === other105588.constructor)) && (cljs.core._EQ_.call(null,this105587__$1.index_type,other105588.index_type)) && (cljs.core._EQ_.call(null,this105587__$1.comparator,other105588.comparator)) && (cljs.core._EQ_.call(null,this105587__$1.historyComparator,other105588.historyComparator)) && (cljs.core._EQ_.call(null,this105587__$1.__extmap,other105588.__extmap)));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),null,new cljs.core.Keyword(null,"comparator","comparator",2144896662),null,new cljs.core.Keyword(null,"index-type","index-type",500383962),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4390__auto__)),null));
}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__105585){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__105595 = cljs.core.keyword_identical_QMARK_;
var expr__105596 = k__4388__auto__;
if(cljs.core.truth_(pred__105595.call(null,new cljs.core.Keyword(null,"index-type","index-type",500383962),expr__105596))){
return (new fluree.db.index.IndexConfig(G__105585,self__.comparator,self__.historyComparator,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__105595.call(null,new cljs.core.Keyword(null,"comparator","comparator",2144896662),expr__105596))){
return (new fluree.db.index.IndexConfig(self__.index_type,G__105585,self__.historyComparator,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__105595.call(null,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),expr__105596))){
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,G__105585,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4388__auto__,G__105585),null));
}
}
}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"index-type","index-type",500383962),self__.index_type,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"comparator","comparator",2144896662),self__.comparator,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),self__.historyComparator,null))], null),self__.__extmap));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__105585){
var self__ = this;
var this__4379__auto____$1 = this;
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,G__105585,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4386__auto__,(0)),cljs.core._nth.call(null,entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(fluree.db.index.IndexConfig.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"index-type","index-type",2140915489,null),new cljs.core.Symbol(null,"comparator","comparator",-509539107,null),new cljs.core.Symbol(null,"historyComparator","historyComparator",236913869,null)], null);
}));

(fluree.db.index.IndexConfig.cljs$lang$type = true);

(fluree.db.index.IndexConfig.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"fluree.db.index/IndexConfig",null,(1),null));
}));

(fluree.db.index.IndexConfig.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write.call(null,writer__4424__auto__,"fluree.db.index/IndexConfig");
}));

/**
 * Positional factory function for fluree.db.index/IndexConfig.
 */
fluree.db.index.__GT_IndexConfig = (function fluree$db$index$__GT_IndexConfig(index_type,comparator,historyComparator){
return (new fluree.db.index.IndexConfig(index_type,comparator,historyComparator,null,null,null));
});

/**
 * Factory function for fluree.db.index/IndexConfig, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_IndexConfig = (function fluree$db$index$map__GT_IndexConfig(G__105589){
var extmap__4419__auto__ = (function (){var G__105598 = cljs.core.dissoc.call(null,G__105589,new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"comparator","comparator",2144896662),new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658));
if(cljs.core.record_QMARK_.call(null,G__105589)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__105598);
} else {
return G__105598;
}
})();
return (new fluree.db.index.IndexConfig(new cljs.core.Keyword(null,"index-type","index-type",500383962).cljs$core$IFn$_invoke$arity$1(G__105589),new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(G__105589),new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658).cljs$core$IFn$_invoke$arity$1(G__105589),null,cljs.core.not_empty.call(null,extmap__4419__auto__),null));
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {fluree.db.dbproto.INode}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.IndexNode = (function (block,t,rhs,children,config,leftmost_QMARK_,__meta,__extmap,__hash){
this.block = block;
this.t = t;
this.rhs = rhs;
this.children = children;
this.config = config;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.IndexNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k105601,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__105605 = k105601;
var G__105605__$1 = (((G__105605 instanceof cljs.core.Keyword))?G__105605.fqn:null);
switch (G__105605__$1) {
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "rhs":
return self__.rhs;

break;
case "children":
return self__.children;

break;
case "config":
return self__.config;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k105601,else__4383__auto__);

}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4402__auto__,p__105606){
var vec__105607 = p__105606;
var k__4403__auto__ = cljs.core.nth.call(null,vec__105607,(0),null);
var v__4404__auto__ = cljs.core.nth.call(null,vec__105607,(1),null);
return f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__);
}),init__4401__auto__,this__4399__auto____$1);
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,pr_pair__4397__auto__,"#fluree.db.index.IndexNode{",", ","}",opts__4396__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"children","children",-940561982),self__.children],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"config","config",994861415),self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_],null))], null),self__.__extmap));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__105600){
var self__ = this;
var G__105600__$1 = this;
return (new cljs.core.RecordIter((0),G__105600__$1,6,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"children","children",-940561982),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_105611){
var state_val_105612 = (state_105611[(1)]);
if((state_val_105612 === (1))){
var state_105611__$1 = state_105611;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_105611__$1,this$__$1);
} else {
return null;
}
});
return (function() {
var fluree$db$index$state_machine__99975__auto__ = null;
var fluree$db$index$state_machine__99975__auto____0 = (function (){
var statearr_105613 = [null,null,null,null,null,null,null];
(statearr_105613[(0)] = fluree$db$index$state_machine__99975__auto__);

(statearr_105613[(1)] = (1));

return statearr_105613;
});
var fluree$db$index$state_machine__99975__auto____1 = (function (state_105611){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_105611);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e105614){if((e105614 instanceof Object)){
var ex__99978__auto__ = e105614;
var statearr_105615_105692 = state_105611;
(statearr_105615_105692[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_105611);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e105614;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__105693 = state_105611;
state_105611 = G__105693;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$index$state_machine__99975__auto__ = function(state_105611){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__99975__auto____1.call(this,state_105611);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__99975__auto____0;
fluree$db$index$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__99975__auto____1;
return fluree$db$index$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_105616 = f__100070__auto__.call(null);
(statearr_105616[(6)] = c__100069__auto__);

return statearr_105616;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.key.call(null,cljs.core.first.call(null,self__.children));
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (6 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
return cljs.core.val.call(null,(function (){var or__4126__auto__ = clojure.data.avl.nearest.call(null,self__.children,cljs.core._LT__EQ_,flake);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.first.call(null,self__.children);
}
})());
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_after$arity$2 = (function (_,flake){
var self__ = this;
var ___$1 = this;
return cljs.core.val.call(null,(function (){var or__4126__auto__ = clojure.data.avl.nearest.call(null,self__.children,cljs.core._GT_,flake);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.last.call(null,self__.children);
}
})());
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_leaf$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_105638){
var state_val_105639 = (state_105638[(1)]);
if((state_val_105639 === (7))){
var inst_105634 = (state_105638[(2)]);
var state_105638__$1 = state_105638;
var statearr_105640_105694 = state_105638__$1;
(statearr_105640_105694[(2)] = inst_105634);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_105638__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105639 === (1))){
var state_105638__$1 = state_105638;
var statearr_105641_105695 = state_105638__$1;
(statearr_105641_105695[(2)] = null);

(statearr_105641_105695[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105639 === (4))){
var inst_105621 = (state_105638[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_105638,(3),Error,null,(2));
var inst_105621__$1 = fluree.db.dbproto._lookup.call(null,this$__$1,flake);
var inst_105622 = new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(inst_105621__$1);
var state_105638__$1 = (function (){var statearr_105642 = state_105638;
(statearr_105642[(7)] = inst_105621__$1);

return statearr_105642;
})();
if(cljs.core.truth_(inst_105622)){
var statearr_105643_105696 = state_105638__$1;
(statearr_105643_105696[(1)] = (5));

} else {
var statearr_105644_105697 = state_105638__$1;
(statearr_105644_105697[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105639 === (6))){
var inst_105621 = (state_105638[(7)]);
var inst_105625 = fluree.db.dbproto._resolve.call(null,inst_105621);
var state_105638__$1 = state_105638;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_105638__$1,(9),inst_105625);
} else {
if((state_val_105639 === (3))){
var inst_105617 = (state_105638[(2)]);
var state_105638__$1 = state_105638;
var statearr_105645_105698 = state_105638__$1;
(statearr_105645_105698[(2)] = inst_105617);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_105638__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105639 === (2))){
var inst_105636 = (state_105638[(2)]);
var state_105638__$1 = state_105638;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_105638__$1,inst_105636);
} else {
if((state_val_105639 === (9))){
var inst_105627 = (state_105638[(2)]);
var inst_105628 = fluree.db.util.async.throw_err.call(null,inst_105627);
var inst_105629 = fluree.db.dbproto._lookup_leaf.call(null,inst_105628,flake);
var state_105638__$1 = state_105638;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_105638__$1,(8),inst_105629);
} else {
if((state_val_105639 === (5))){
var inst_105621 = (state_105638[(7)]);
var state_105638__$1 = state_105638;
var statearr_105646_105699 = state_105638__$1;
(statearr_105646_105699[(2)] = inst_105621);

(statearr_105646_105699[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105639 === (8))){
var inst_105631 = (state_105638[(2)]);
var inst_105632 = fluree.db.util.async.throw_err.call(null,inst_105631);
var state_105638__$1 = state_105638;
var statearr_105647_105700 = state_105638__$1;
(statearr_105647_105700[(2)] = inst_105632);

(statearr_105647_105700[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$state_machine__99975__auto__ = null;
var fluree$db$index$state_machine__99975__auto____0 = (function (){
var statearr_105648 = [null,null,null,null,null,null,null,null];
(statearr_105648[(0)] = fluree$db$index$state_machine__99975__auto__);

(statearr_105648[(1)] = (1));

return statearr_105648;
});
var fluree$db$index$state_machine__99975__auto____1 = (function (state_105638){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_105638);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e105649){if((e105649 instanceof Object)){
var ex__99978__auto__ = e105649;
var statearr_105650_105701 = state_105638;
(statearr_105650_105701[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_105638);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e105649;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__105702 = state_105638;
state_105638 = G__105702;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$index$state_machine__99975__auto__ = function(state_105638){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__99975__auto____1.call(this,state_105638);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__99975__auto____0;
fluree$db$index$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__99975__auto____1;
return fluree$db$index$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_105651 = f__100070__auto__.call(null);
(statearr_105651[(6)] = c__100069__auto__);

return statearr_105651;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_leaf_after$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_105673){
var state_val_105674 = (state_105673[(1)]);
if((state_val_105674 === (7))){
var inst_105669 = (state_105673[(2)]);
var state_105673__$1 = state_105673;
var statearr_105675_105703 = state_105673__$1;
(statearr_105675_105703[(2)] = inst_105669);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_105673__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105674 === (1))){
var state_105673__$1 = state_105673;
var statearr_105676_105704 = state_105673__$1;
(statearr_105676_105704[(2)] = null);

(statearr_105676_105704[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105674 === (4))){
var inst_105656 = (state_105673[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_105673,(3),Error,null,(2));
var inst_105656__$1 = fluree.db.dbproto._lookup_after.call(null,this$__$1,flake);
var inst_105657 = new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(inst_105656__$1);
var state_105673__$1 = (function (){var statearr_105677 = state_105673;
(statearr_105677[(7)] = inst_105656__$1);

return statearr_105677;
})();
if(cljs.core.truth_(inst_105657)){
var statearr_105678_105705 = state_105673__$1;
(statearr_105678_105705[(1)] = (5));

} else {
var statearr_105679_105706 = state_105673__$1;
(statearr_105679_105706[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105674 === (6))){
var inst_105656 = (state_105673[(7)]);
var inst_105660 = fluree.db.dbproto._resolve.call(null,inst_105656);
var state_105673__$1 = state_105673;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_105673__$1,(9),inst_105660);
} else {
if((state_val_105674 === (3))){
var inst_105652 = (state_105673[(2)]);
var state_105673__$1 = state_105673;
var statearr_105680_105707 = state_105673__$1;
(statearr_105680_105707[(2)] = inst_105652);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_105673__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105674 === (2))){
var inst_105671 = (state_105673[(2)]);
var state_105673__$1 = state_105673;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_105673__$1,inst_105671);
} else {
if((state_val_105674 === (9))){
var inst_105662 = (state_105673[(2)]);
var inst_105663 = fluree.db.util.async.throw_err.call(null,inst_105662);
var inst_105664 = fluree.db.dbproto._lookup_leaf_after.call(null,inst_105663,flake);
var state_105673__$1 = state_105673;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_105673__$1,(8),inst_105664);
} else {
if((state_val_105674 === (5))){
var inst_105656 = (state_105673[(7)]);
var state_105673__$1 = state_105673;
var statearr_105681_105708 = state_105673__$1;
(statearr_105681_105708[(2)] = inst_105656);

(statearr_105681_105708[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105674 === (8))){
var inst_105666 = (state_105673[(2)]);
var inst_105667 = fluree.db.util.async.throw_err.call(null,inst_105666);
var state_105673__$1 = state_105673;
var statearr_105682_105709 = state_105673__$1;
(statearr_105682_105709[(2)] = inst_105667);

(statearr_105682_105709[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$state_machine__99975__auto__ = null;
var fluree$db$index$state_machine__99975__auto____0 = (function (){
var statearr_105683 = [null,null,null,null,null,null,null,null];
(statearr_105683[(0)] = fluree$db$index$state_machine__99975__auto__);

(statearr_105683[(1)] = (1));

return statearr_105683;
});
var fluree$db$index$state_machine__99975__auto____1 = (function (state_105673){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_105673);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e105684){if((e105684 instanceof Object)){
var ex__99978__auto__ = e105684;
var statearr_105685_105710 = state_105673;
(statearr_105685_105710[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_105673);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e105684;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__105711 = state_105673;
state_105673 = G__105711;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$index$state_machine__99975__auto__ = function(state_105673){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__99975__auto____1.call(this,state_105673);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__99975__auto____0;
fluree$db$index$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__99975__auto____1;
return fluree$db$index$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_105686 = f__100070__auto__.call(null);
(statearr_105686[(6)] = c__100069__auto__);

return statearr_105686;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (659789215 ^ cljs.core.hash_unordered_coll.call(null,coll__4377__auto__));
}).call(null,this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this105602,other105603){
var self__ = this;
var this105602__$1 = this;
return (((!((other105603 == null)))) && ((this105602__$1.constructor === other105603.constructor)) && (cljs.core._EQ_.call(null,this105602__$1.block,other105603.block)) && (cljs.core._EQ_.call(null,this105602__$1.t,other105603.t)) && (cljs.core._EQ_.call(null,this105602__$1.rhs,other105603.rhs)) && (cljs.core._EQ_.call(null,this105602__$1.children,other105603.children)) && (cljs.core._EQ_.call(null,this105602__$1.config,other105603.config)) && (cljs.core._EQ_.call(null,this105602__$1.leftmost_QMARK_,other105603.leftmost_QMARK_)) && (cljs.core._EQ_.call(null,this105602__$1.__extmap,other105603.__extmap)));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"config","config",994861415),null,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4390__auto__)),null));
}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__105600){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__105687 = cljs.core.keyword_identical_QMARK_;
var expr__105688 = k__4388__auto__;
if(cljs.core.truth_(pred__105687.call(null,new cljs.core.Keyword(null,"block","block",664686210),expr__105688))){
return (new fluree.db.index.IndexNode(G__105600,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__105687.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),expr__105688))){
return (new fluree.db.index.IndexNode(self__.block,G__105600,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__105687.call(null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),expr__105688))){
return (new fluree.db.index.IndexNode(self__.block,self__.t,G__105600,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__105687.call(null,new cljs.core.Keyword(null,"children","children",-940561982),expr__105688))){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,G__105600,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__105687.call(null,new cljs.core.Keyword(null,"config","config",994861415),expr__105688))){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,G__105600,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__105687.call(null,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),expr__105688))){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,G__105600,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4388__auto__,G__105600),null));
}
}
}
}
}
}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"children","children",-940561982),self__.children,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"config","config",994861415),self__.config,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_,null))], null),self__.__extmap));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__105600){
var self__ = this;
var this__4379__auto____$1 = this;
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,G__105600,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4386__auto__,(0)),cljs.core._nth.call(null,entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(fluree.db.index.IndexNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"rhs","rhs",1411174788,null),new cljs.core.Symbol(null,"children","children",699969545,null),new cljs.core.Symbol(null,"config","config",-1659574354,null),new cljs.core.Symbol(null,"leftmost?","leftmost?",-31657032,null)], null);
}));

(fluree.db.index.IndexNode.cljs$lang$type = true);

(fluree.db.index.IndexNode.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"fluree.db.index/IndexNode",null,(1),null));
}));

(fluree.db.index.IndexNode.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write.call(null,writer__4424__auto__,"fluree.db.index/IndexNode");
}));

/**
 * Positional factory function for fluree.db.index/IndexNode.
 */
fluree.db.index.__GT_IndexNode = (function fluree$db$index$__GT_IndexNode(block,t,rhs,children,config,leftmost_QMARK_){
return (new fluree.db.index.IndexNode(block,t,rhs,children,config,leftmost_QMARK_,null,null,null));
});

/**
 * Factory function for fluree.db.index/IndexNode, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_IndexNode = (function fluree$db$index$map__GT_IndexNode(G__105604){
var extmap__4419__auto__ = (function (){var G__105690 = cljs.core.dissoc.call(null,G__105604,new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"children","children",-940561982),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559));
if(cljs.core.record_QMARK_.call(null,G__105604)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__105690);
} else {
return G__105690;
}
})();
return (new fluree.db.index.IndexNode(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__105604),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__105604),new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(G__105604),new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(G__105604),new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(G__105604),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559).cljs$core$IFn$_invoke$arity$1(G__105604),null,cljs.core.not_empty.call(null,extmap__4419__auto__),null));
});

fluree.db.index.index_node_QMARK_ = (function fluree$db$index$index_node_QMARK_(node){
return (node instanceof fluree.db.index.IndexNode);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {fluree.db.dbproto.INode}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.DataNode = (function (block,t,flakes,rhs,config,__meta,__extmap,__hash){
this.block = block;
this.t = t;
this.flakes = flakes;
this.rhs = rhs;
this.config = config;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.DataNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(fluree.db.index.DataNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k105713,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__105717 = k105713;
var G__105717__$1 = (((G__105717 instanceof cljs.core.Keyword))?G__105717.fqn:null);
switch (G__105717__$1) {
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "flakes":
return self__.flakes;

break;
case "rhs":
return self__.rhs;

break;
case "config":
return self__.config;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k105713,else__4383__auto__);

}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4402__auto__,p__105718){
var vec__105719 = p__105718;
var k__4403__auto__ = cljs.core.nth.call(null,vec__105719,(0),null);
var v__4404__auto__ = cljs.core.nth.call(null,vec__105719,(1),null);
return f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__);
}),init__4401__auto__,this__4399__auto____$1);
}));

(fluree.db.index.DataNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,pr_pair__4397__auto__,"#fluree.db.index.DataNode{",", ","}",opts__4396__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"flakes","flakes",1977895739),self__.flakes],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"config","config",994861415),self__.config],null))], null),self__.__extmap));
}));

(fluree.db.index.DataNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__105712){
var self__ = this;
var G__105712__$1 = this;
return (new cljs.core.RecordIter((0),G__105712__$1,5,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"config","config",994861415)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_105723){
var state_val_105724 = (state_105723[(1)]);
if((state_val_105724 === (1))){
var state_105723__$1 = state_105723;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_105723__$1,this$__$1);
} else {
return null;
}
});
return (function() {
var fluree$db$index$state_machine__99975__auto__ = null;
var fluree$db$index$state_machine__99975__auto____0 = (function (){
var statearr_105725 = [null,null,null,null,null,null,null];
(statearr_105725[(0)] = fluree$db$index$state_machine__99975__auto__);

(statearr_105725[(1)] = (1));

return statearr_105725;
});
var fluree$db$index$state_machine__99975__auto____1 = (function (state_105723){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_105723);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e105726){if((e105726 instanceof Object)){
var ex__99978__auto__ = e105726;
var statearr_105727_105745 = state_105723;
(statearr_105727_105745[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_105723);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e105726;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__105746 = state_105723;
state_105723 = G__105746;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$index$state_machine__99975__auto__ = function(state_105723){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__99975__auto____1.call(this,state_105723);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__99975__auto____0;
fluree$db$index$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__99975__auto____1;
return fluree$db$index$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_105728 = f__100070__auto__.call(null);
(statearr_105728[(6)] = c__100069__auto__);

return statearr_105728;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
throw cljs.core.ex_info.call(null,"-resolve-history called on DATA NODE!!!",cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.first.call(null,self__.flakes);
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.index.DataNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.DataNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.DataNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (5 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$_lookup$arity$2 = (function (root,flake){
var self__ = this;
var root__$1 = this;
throw cljs.core.ex_info.call(null,"-lookup was called on a data node, which shouldn't happen!",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null));
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$_lookup_leaf$arity$2 = (function (root,flake){
var self__ = this;
var root__$1 = this;
fluree.db.util.log.error.call(null,"-lookup-leaf was called on a data node, which shouldn't happen!");

var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_105734){
var state_val_105735 = (state_105734[(1)]);
if((state_val_105735 === (1))){
var inst_105729 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_105730 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_105731 = cljs.core.PersistentHashMap.fromArrays(inst_105729,inst_105730);
var inst_105732 = cljs.core.ex_info.call(null,"-lookup-leaf was called on a data node, which shouldn't happen!",inst_105731);
var state_105734__$1 = state_105734;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_105734__$1,inst_105732);
} else {
return null;
}
});
return (function() {
var fluree$db$index$state_machine__99975__auto__ = null;
var fluree$db$index$state_machine__99975__auto____0 = (function (){
var statearr_105736 = [null,null,null,null,null,null,null];
(statearr_105736[(0)] = fluree$db$index$state_machine__99975__auto__);

(statearr_105736[(1)] = (1));

return statearr_105736;
});
var fluree$db$index$state_machine__99975__auto____1 = (function (state_105734){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_105734);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e105737){if((e105737 instanceof Object)){
var ex__99978__auto__ = e105737;
var statearr_105738_105747 = state_105734;
(statearr_105738_105747[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_105734);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e105737;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__105748 = state_105734;
state_105734 = G__105748;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$index$state_machine__99975__auto__ = function(state_105734){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__99975__auto____1.call(this,state_105734);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__99975__auto____0;
fluree$db$index$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__99975__auto____1;
return fluree$db$index$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_105739 = f__100070__auto__.call(null);
(statearr_105739[(6)] = c__100069__auto__);

return statearr_105739;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.index.DataNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (1312629141 ^ cljs.core.hash_unordered_coll.call(null,coll__4377__auto__));
}).call(null,this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this105714,other105715){
var self__ = this;
var this105714__$1 = this;
return (((!((other105715 == null)))) && ((this105714__$1.constructor === other105715.constructor)) && (cljs.core._EQ_.call(null,this105714__$1.block,other105715.block)) && (cljs.core._EQ_.call(null,this105714__$1.t,other105715.t)) && (cljs.core._EQ_.call(null,this105714__$1.flakes,other105715.flakes)) && (cljs.core._EQ_.call(null,this105714__$1.rhs,other105715.rhs)) && (cljs.core._EQ_.call(null,this105714__$1.config,other105715.config)) && (cljs.core._EQ_.call(null,this105714__$1.__extmap,other105715.__extmap)));
}));

(fluree.db.index.DataNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"config","config",994861415),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"flakes","flakes",1977895739),null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4390__auto__)),null));
}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__105712){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__105740 = cljs.core.keyword_identical_QMARK_;
var expr__105741 = k__4388__auto__;
if(cljs.core.truth_(pred__105740.call(null,new cljs.core.Keyword(null,"block","block",664686210),expr__105741))){
return (new fluree.db.index.DataNode(G__105712,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__105740.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),expr__105741))){
return (new fluree.db.index.DataNode(self__.block,G__105712,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__105740.call(null,new cljs.core.Keyword(null,"flakes","flakes",1977895739),expr__105741))){
return (new fluree.db.index.DataNode(self__.block,self__.t,G__105712,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__105740.call(null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),expr__105741))){
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,G__105712,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__105740.call(null,new cljs.core.Keyword(null,"config","config",994861415),expr__105741))){
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,G__105712,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4388__auto__,G__105712),null));
}
}
}
}
}
}));

(fluree.db.index.DataNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"flakes","flakes",1977895739),self__.flakes,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"config","config",994861415),self__.config,null))], null),self__.__extmap));
}));

(fluree.db.index.DataNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__105712){
var self__ = this;
var this__4379__auto____$1 = this;
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,G__105712,self__.__extmap,self__.__hash));
}));

(fluree.db.index.DataNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4386__auto__,(0)),cljs.core._nth.call(null,entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(fluree.db.index.DataNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"flakes","flakes",-676540030,null),new cljs.core.Symbol(null,"rhs","rhs",1411174788,null),new cljs.core.Symbol(null,"config","config",-1659574354,null)], null);
}));

(fluree.db.index.DataNode.cljs$lang$type = true);

(fluree.db.index.DataNode.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"fluree.db.index/DataNode",null,(1),null));
}));

(fluree.db.index.DataNode.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write.call(null,writer__4424__auto__,"fluree.db.index/DataNode");
}));

/**
 * Positional factory function for fluree.db.index/DataNode.
 */
fluree.db.index.__GT_DataNode = (function fluree$db$index$__GT_DataNode(block,t,flakes,rhs,config){
return (new fluree.db.index.DataNode(block,t,flakes,rhs,config,null,null,null));
});

/**
 * Factory function for fluree.db.index/DataNode, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_DataNode = (function fluree$db$index$map__GT_DataNode(G__105716){
var extmap__4419__auto__ = (function (){var G__105743 = cljs.core.dissoc.call(null,G__105716,new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"config","config",994861415));
if(cljs.core.record_QMARK_.call(null,G__105716)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__105743);
} else {
return G__105743;
}
})();
return (new fluree.db.index.DataNode(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__105716),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__105716),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(G__105716),new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(G__105716),new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(G__105716),null,cljs.core.not_empty.call(null,extmap__4419__auto__),null));
});

/**
 * Creates a new data node
 */
fluree.db.index.data_node = (function fluree$db$index$data_node(block_id,t,flakes,rhs,config){
return fluree.db.index.__GT_DataNode.call(null,block_id,t,flakes,rhs,config);
});
fluree.db.index.data_node_QMARK_ = (function fluree$db$index$data_node_QMARK_(node){
return (node instanceof fluree.db.index.DataNode);
});
