// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.api_js');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.crypto');
goog.require('fluree.db.flake');
goog.require('fluree.db.operations');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.session');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('goog.string.format');
goog.require('fluree.db.connection_js');
/**
 * Returns a queryable database from the connection.
 * No permissions applied - assumes root
 */
fluree.db.api_js.db = (function fluree$db$api_js$db(var_args){
var args__4742__auto__ = [];
var len__4736__auto___122669 = arguments.length;
var i__4737__auto___122670 = (0);
while(true){
if((i__4737__auto___122670 < len__4736__auto___122669)){
args__4742__auto__.push((arguments[i__4737__auto___122670]));

var G__122671 = (i__4737__auto___122670 + (1));
i__4737__auto___122670 = G__122671;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__122580){
var vec__122581 = p__122580;
var opts = cljs.core.nth.call(null,vec__122581,(0),null);
var pc = cljs.core.async.promise_chan.call(null);
var c__100069__auto___122672 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_122641){
var state_val_122642 = (state_122641[(1)]);
if((state_val_122642 === (7))){
var inst_122610 = (state_122641[(2)]);
var state_122641__$1 = state_122641;
if(cljs.core.truth_(inst_122610)){
var statearr_122643_122673 = state_122641__$1;
(statearr_122643_122673[(1)] = (11));

} else {
var statearr_122644_122674 = state_122641__$1;
(statearr_122644_122674[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122642 === (1))){
var state_122641__$1 = state_122641;
var statearr_122645_122675 = state_122641__$1;
(statearr_122645_122675[(2)] = null);

(statearr_122645_122675[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122642 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_122641,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var inst_122596 = (opts == null);
var inst_122597 = cljs.core.not.call(null,inst_122596);
var state_122641__$1 = state_122641;
if(inst_122597){
var statearr_122646_122676 = state_122641__$1;
(statearr_122646_122676[(1)] = (5));

} else {
var statearr_122647_122677 = state_122641__$1;
(statearr_122647_122677[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122642 === (15))){
var inst_122619 = (state_122641[(7)]);
var inst_122628 = (state_122641[(8)]);
var inst_122630 = fluree.db.time_travel.as_of_block.call(null,inst_122628,inst_122619);
var state_122641__$1 = state_122641;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_122641__$1,(18),inst_122630);
} else {
if((state_val_122642 === (13))){
var inst_122615 = (state_122641[(2)]);
var inst_122616 = cljs.core.get.call(null,inst_122615,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_122617 = cljs.core.get.call(null,inst_122615,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_122618 = cljs.core.get.call(null,inst_122615,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_122619 = cljs.core.get.call(null,inst_122615,new cljs.core.Keyword(null,"block","block",664686210));
var inst_122620 = fluree.db.connection_js.check_connection.call(null,conn,opts);
var inst_122621 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var inst_122622 = cljs.core.nth.call(null,inst_122621,(0),null);
var inst_122623 = cljs.core.nth.call(null,inst_122621,(1),null);
var inst_122624 = fluree.db.session.db.call(null,conn,ledger,opts);
var state_122641__$1 = (function (){var statearr_122648 = state_122641;
(statearr_122648[(9)] = inst_122616);

(statearr_122648[(7)] = inst_122619);

(statearr_122648[(10)] = inst_122620);

(statearr_122648[(11)] = inst_122622);

(statearr_122648[(12)] = inst_122618);

(statearr_122648[(13)] = inst_122623);

(statearr_122648[(14)] = inst_122617);

return statearr_122648;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_122641__$1,(14),inst_122624);
} else {
if((state_val_122642 === (6))){
var state_122641__$1 = state_122641;
var statearr_122649_122678 = state_122641__$1;
(statearr_122649_122678[(2)] = false);

(statearr_122649_122678[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122642 === (17))){
var inst_122636 = (state_122641[(2)]);
var inst_122637 = cljs.core.async.put_BANG_.call(null,pc,inst_122636);
var state_122641__$1 = state_122641;
var statearr_122650_122679 = state_122641__$1;
(statearr_122650_122679[(2)] = inst_122637);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_122641__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122642 === (3))){
var inst_122584 = (state_122641[(2)]);
var inst_122585 = fluree.db.util.log.error.call(null,inst_122584);
var inst_122586 = cljs.core.async.put_BANG_.call(null,pc,inst_122584);
var inst_122587 = cljs.core.async.close_BANG_.call(null,pc);
var state_122641__$1 = (function (){var statearr_122651 = state_122641;
(statearr_122651[(15)] = inst_122585);

(statearr_122651[(16)] = inst_122586);

return statearr_122651;
})();
var statearr_122652_122680 = state_122641__$1;
(statearr_122652_122680[(2)] = inst_122587);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_122641__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122642 === (12))){
var state_122641__$1 = state_122641;
var statearr_122653_122681 = state_122641__$1;
(statearr_122653_122681[(2)] = opts);

(statearr_122653_122681[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122642 === (2))){
var inst_122639 = (state_122641[(2)]);
var state_122641__$1 = state_122641;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_122641__$1,inst_122639);
} else {
if((state_val_122642 === (11))){
var inst_122612 = cljs.core.apply.call(null,cljs.core.hash_map,opts);
var state_122641__$1 = state_122641;
var statearr_122654_122682 = state_122641__$1;
(statearr_122654_122682[(2)] = inst_122612);

(statearr_122654_122682[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122642 === (9))){
var state_122641__$1 = state_122641;
var statearr_122655_122683 = state_122641__$1;
(statearr_122655_122683[(2)] = false);

(statearr_122655_122683[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122642 === (5))){
var inst_122599 = opts.cljs$lang$protocol_mask$partition0$;
var inst_122600 = (inst_122599 & (64));
var inst_122601 = opts.cljs$core$ISeq$;
var inst_122602 = (cljs.core.PROTOCOL_SENTINEL === inst_122601);
var inst_122603 = ((inst_122600) || (inst_122602));
var state_122641__$1 = state_122641;
if(cljs.core.truth_(inst_122603)){
var statearr_122656_122684 = state_122641__$1;
(statearr_122656_122684[(1)] = (8));

} else {
var statearr_122657_122685 = state_122641__$1;
(statearr_122657_122685[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122642 === (14))){
var inst_122619 = (state_122641[(7)]);
var inst_122622 = (state_122641[(11)]);
var inst_122623 = (state_122641[(13)]);
var inst_122626 = (state_122641[(2)]);
var inst_122627 = fluree.db.util.async.throw_err.call(null,inst_122626);
var inst_122628 = cljs.core.assoc.call(null,inst_122627,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"network","network",2050004697),inst_122622,new cljs.core.Keyword(null,"dbid","dbid",-196647356),inst_122623);
var state_122641__$1 = (function (){var statearr_122658 = state_122641;
(statearr_122658[(8)] = inst_122628);

return statearr_122658;
})();
if(cljs.core.truth_(inst_122619)){
var statearr_122659_122686 = state_122641__$1;
(statearr_122659_122686[(1)] = (15));

} else {
var statearr_122660_122687 = state_122641__$1;
(statearr_122660_122687[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122642 === (16))){
var inst_122628 = (state_122641[(8)]);
var state_122641__$1 = state_122641;
var statearr_122661_122688 = state_122641__$1;
(statearr_122661_122688[(2)] = inst_122628);

(statearr_122661_122688[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122642 === (10))){
var inst_122607 = (state_122641[(2)]);
var state_122641__$1 = state_122641;
var statearr_122662_122689 = state_122641__$1;
(statearr_122662_122689[(2)] = inst_122607);

(statearr_122662_122689[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122642 === (18))){
var inst_122632 = (state_122641[(2)]);
var inst_122633 = fluree.db.util.async.throw_err.call(null,inst_122632);
var state_122641__$1 = state_122641;
var statearr_122663_122690 = state_122641__$1;
(statearr_122663_122690[(2)] = inst_122633);

(statearr_122663_122690[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122642 === (8))){
var state_122641__$1 = state_122641;
var statearr_122664_122691 = state_122641__$1;
(statearr_122664_122691[(2)] = true);

(statearr_122664_122691[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__99975__auto__ = null;
var fluree$db$api_js$state_machine__99975__auto____0 = (function (){
var statearr_122665 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_122665[(0)] = fluree$db$api_js$state_machine__99975__auto__);

(statearr_122665[(1)] = (1));

return statearr_122665;
});
var fluree$db$api_js$state_machine__99975__auto____1 = (function (state_122641){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_122641);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e122666){if((e122666 instanceof Object)){
var ex__99978__auto__ = e122666;
var statearr_122667_122692 = state_122641;
(statearr_122667_122692[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_122641);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e122666;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__122693 = state_122641;
state_122641 = G__122693;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__99975__auto__ = function(state_122641){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__99975__auto____1.call(this,state_122641);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__99975__auto____0;
fluree$db$api_js$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__99975__auto____1;
return fluree$db$api_js$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_122668 = f__100070__auto__.call(null);
(statearr_122668[(6)] = c__100069__auto___122672);

return statearr_122668;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));


return pc;
}));

(fluree.db.api_js.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.api_js.db.cljs$lang$applyTo = (function (seq122577){
var G__122578 = cljs.core.first.call(null,seq122577);
var seq122577__$1 = cljs.core.next.call(null,seq122577);
var G__122579 = cljs.core.first.call(null,seq122577__$1);
var seq122577__$2 = cljs.core.next.call(null,seq122577__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__122578,G__122579,seq122577__$2);
}));

fluree.db.api_js.db_ident_QMARK_ = (function fluree$db$api_js$db_ident_QMARK_(source){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,clojure.string.split.call(null,source,/\//)),(2));
});
fluree.db.api_js.isolate_ledger_id = (function fluree$db$api_js$isolate_ledger_id(dbid){
return cljs.core.re_find.call(null,/[a-z0-9]+\/[a-z0-9]+/,dbid);
});
/**
 * Validates & returns the query sources.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.get_sources = (function fluree$db$api_js$get_sources(conn,network,open_api,auth,prefixes,db_fn){
return cljs.core.reduce_kv.call(null,(function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches.call(null,/[a-z]+/,fluree.db.util.core.keyword__GT_str.call(null,key)))){
} else {
throw cljs.core.ex_info.call(null,["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str.call(null,key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

if(cljs.core.truth_(((fluree.db.api_js.db_ident_QMARK_.call(null,val))?(function (){var and__4115__auto__ = open_api;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.call(null,network,cljs.core.first.call(null,clojure.string.split.call(null,val,/\//)));
} else {
return and__4115__auto__;
}
})():false))){
var db_id = fluree.db.api_js.isolate_ledger_id.call(null,val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var ledger = cljs.core.apply.call(null,db_fn,conn,db_id,opts);
return cljs.core.assoc.call(null,acc,val,ledger);
} else {
if(cljs.core.truth_(((fluree.db.api_js.db_ident_QMARK_.call(null,val))?open_api:false))){
throw cljs.core.ex_info.call(null,"When attempting to query across multiple databases in different networks, you must be using a closed API.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
if(cljs.core.truth_(((fluree.db.api_js.db_ident_QMARK_.call(null,val))?auth:false))){
var db_id = fluree.db.api_js.isolate_ledger_id.call(null,val);
var ledger = cljs.core.apply.call(null,db_fn,conn,db_id,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null));
return cljs.core.assoc.call(null,acc,val,ledger);
} else {
return acc;

}
}
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
/**
 * Execute an unsigned query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns a channel, where the results are eventually put.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.query_async = (function fluree$db$api_js$query_async(var_args){
var G__122696 = arguments.length;
switch (G__122696) {
case 2:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.query_async.call(null,sources,query_map,null,fluree.db.api_js.db);
}));

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,opts){
return fluree.db.api_js.query_async.call(null,sources,query_map,opts,fluree.db.api_js.db);
}));

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$4 = (function (sources,query_map,opts,db_fn){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_122853){
var state_val_122854 = (state_122853[(1)]);
if((state_val_122854 === (65))){
var inst_122842 = [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_122843 = ["Invalid query.",(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_122844 = cljs.core.PersistentHashMap.fromArrays(inst_122842,inst_122843);
var state_122853__$1 = state_122853;
var statearr_122855_122954 = state_122853__$1;
(statearr_122855_122954[(2)] = inst_122844);

(statearr_122855_122954[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (62))){
var inst_122804 = (state_122853[(7)]);
var state_122853__$1 = state_122853;
var statearr_122856_122955 = state_122853__$1;
(statearr_122856_122955[(2)] = inst_122804);

(statearr_122856_122955[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (7))){
var inst_122721 = (state_122853[(2)]);
var state_122853__$1 = state_122853;
if(cljs.core.truth_(inst_122721)){
var statearr_122857_122956 = state_122853__$1;
(statearr_122857_122956[(1)] = (11));

} else {
var statearr_122858_122957 = state_122853__$1;
(statearr_122858_122957[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (59))){
var inst_122804 = (state_122853[(7)]);
var inst_122818 = cljs.core.doall.call(null,inst_122804);
var state_122853__$1 = state_122853;
var statearr_122859_122958 = state_122853__$1;
(statearr_122859_122958[(2)] = inst_122818);

(statearr_122859_122958[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (20))){
var inst_122755 = cljs.core.PersistentHashMap.EMPTY;
var state_122853__$1 = state_122853;
var statearr_122860_122959 = state_122853__$1;
(statearr_122860_122959[(2)] = inst_122755);

(statearr_122860_122959[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (58))){
var inst_122837 = (state_122853[(2)]);
var state_122853__$1 = state_122853;
var statearr_122861_122960 = state_122853__$1;
(statearr_122861_122960[(2)] = inst_122837);

(statearr_122861_122960[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (60))){
var inst_122804 = (state_122853[(7)]);
var state_122853__$1 = state_122853;
var statearr_122862_122961 = state_122853__$1;
(statearr_122862_122961[(2)] = inst_122804);

(statearr_122862_122961[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (27))){
var inst_122772 = (state_122853[(2)]);
var state_122853__$1 = state_122853;
var statearr_122863_122962 = state_122853__$1;
(statearr_122863_122962[(2)] = inst_122772);

(statearr_122863_122962[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (1))){
var state_122853__$1 = state_122853;
var statearr_122864_122963 = state_122853__$1;
(statearr_122864_122963[(2)] = null);

(statearr_122864_122963[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (24))){
var inst_122774 = (state_122853[(8)]);
var inst_122774__$1 = (state_122853[(2)]);
var state_122853__$1 = (function (){var statearr_122865 = state_122853;
(statearr_122865[(8)] = inst_122774__$1);

return statearr_122865;
})();
if(cljs.core.truth_(inst_122774__$1)){
var statearr_122866_122964 = state_122853__$1;
(statearr_122866_122964[(1)] = (34));

} else {
var statearr_122867_122965 = state_122853__$1;
(statearr_122867_122965[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (55))){
var inst_122839 = (state_122853[(2)]);
var state_122853__$1 = state_122853;
var statearr_122868_122966 = state_122853__$1;
(statearr_122868_122966[(2)] = inst_122839);

(statearr_122868_122966[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (39))){
var inst_122779 = (state_122853[(2)]);
var state_122853__$1 = state_122853;
var statearr_122869_122967 = state_122853__$1;
(statearr_122869_122967[(2)] = inst_122779);

(statearr_122869_122967[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (46))){
var inst_122789 = (state_122853[(9)]);
var state_122853__$1 = state_122853;
var statearr_122870_122968 = state_122853__$1;
(statearr_122870_122968[(2)] = inst_122789);

(statearr_122870_122968[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_122853,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var inst_122707 = (query_map == null);
var inst_122708 = cljs.core.not.call(null,inst_122707);
var state_122853__$1 = state_122853;
if(inst_122708){
var statearr_122871_122969 = state_122853__$1;
(statearr_122871_122969[(1)] = (5));

} else {
var statearr_122872_122970 = state_122853__$1;
(statearr_122872_122970[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (54))){
var inst_122784 = (state_122853[(10)]);
var state_122853__$1 = state_122853;
if(cljs.core.truth_(inst_122784)){
var statearr_122873_122971 = state_122853__$1;
(statearr_122873_122971[(1)] = (56));

} else {
var statearr_122874_122972 = state_122853__$1;
(statearr_122874_122972[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (15))){
var inst_122729 = (state_122853[(11)]);
var inst_122739 = (state_122853[(12)]);
var inst_122741 = fluree.db.time_travel.as_of_block.call(null,inst_122739,inst_122729);
var state_122853__$1 = state_122853;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_122853__$1,(18),inst_122741);
} else {
if((state_val_122854 === (48))){
var inst_122793 = (state_122853[(2)]);
var state_122853__$1 = state_122853;
if(cljs.core.truth_(inst_122793)){
var statearr_122875_122973 = state_122853__$1;
(statearr_122875_122973[(1)] = (49));

} else {
var statearr_122876_122974 = state_122853__$1;
(statearr_122876_122974[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (50))){
var state_122853__$1 = state_122853;
var statearr_122877_122975 = state_122853__$1;
(statearr_122877_122975[(2)] = null);

(statearr_122877_122975[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (21))){
var inst_122728 = (state_122853[(13)]);
var inst_122757 = (state_122853[(14)]);
var inst_122757__$1 = (state_122853[(2)]);
var inst_122758 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_122757__$1);
var state_122853__$1 = (function (){var statearr_122878 = state_122853;
(statearr_122878[(15)] = inst_122758);

(statearr_122878[(14)] = inst_122757__$1);

return statearr_122878;
})();
if(cljs.core.truth_(inst_122728)){
var statearr_122879_122976 = state_122853__$1;
(statearr_122879_122976[(1)] = (22));

} else {
var statearr_122880_122977 = state_122853__$1;
(statearr_122880_122977[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (31))){
var inst_122736 = (state_122853[(16)]);
var state_122853__$1 = state_122853;
var statearr_122881_122978 = state_122853__$1;
(statearr_122881_122978[(2)] = inst_122736);

(statearr_122881_122978[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (32))){
var inst_122727 = (state_122853[(17)]);
var state_122853__$1 = state_122853;
var statearr_122882_122979 = state_122853__$1;
(statearr_122882_122979[(2)] = inst_122727);

(statearr_122882_122979[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (40))){
var inst_122758 = (state_122853[(15)]);
var inst_122785 = (state_122853[(18)]);
var inst_122784 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_122758);
var inst_122785__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_122758);
var state_122853__$1 = (function (){var statearr_122883 = state_122853;
(statearr_122883[(18)] = inst_122785__$1);

(statearr_122883[(10)] = inst_122784);

return statearr_122883;
})();
if(cljs.core.truth_(inst_122785__$1)){
var statearr_122884_122980 = state_122853__$1;
(statearr_122884_122980[(1)] = (43));

} else {
var statearr_122885_122981 = state_122853__$1;
(statearr_122885_122981[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (56))){
var inst_122804 = (state_122853[(7)]);
var inst_122815 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_122816 = cljs.core.sequential_QMARK_.call(null,inst_122804);
var state_122853__$1 = (function (){var statearr_122886 = state_122853;
(statearr_122886[(19)] = inst_122815);

return statearr_122886;
})();
if(inst_122816){
var statearr_122887_122982 = state_122853__$1;
(statearr_122887_122982[(1)] = (59));

} else {
var statearr_122888_122983 = state_122853__$1;
(statearr_122888_122983[(1)] = (60));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (33))){
var inst_122768 = (state_122853[(2)]);
var state_122853__$1 = state_122853;
var statearr_122889_122984 = state_122853__$1;
(statearr_122889_122984[(2)] = inst_122768);

(statearr_122889_122984[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (13))){
var inst_122726 = (state_122853[(20)]);
var inst_122726__$1 = (state_122853[(2)]);
var inst_122727 = cljs.core.get.call(null,inst_122726__$1,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_122728 = cljs.core.get.call(null,inst_122726__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_122729 = cljs.core.get.call(null,inst_122726__$1,new cljs.core.Keyword(null,"block","block",664686210));
var inst_122730 = cljs.core.get.call(null,inst_122726__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_122731 = cljs.core.get.call(null,inst_122726__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_122732 = cljs.core.get.call(null,inst_122726__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_122733 = cljs.core.get.call(null,inst_122726__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_122734 = cljs.core.get.call(null,inst_122726__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_122735 = cljs.core.get.call(null,inst_122726__$1,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_122736 = cljs.core.get.call(null,inst_122726__$1,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var state_122853__$1 = (function (){var statearr_122890 = state_122853;
(statearr_122890[(20)] = inst_122726__$1);

(statearr_122890[(11)] = inst_122729);

(statearr_122890[(16)] = inst_122736);

(statearr_122890[(21)] = inst_122733);

(statearr_122890[(22)] = inst_122731);

(statearr_122890[(13)] = inst_122728);

(statearr_122890[(23)] = inst_122735);

(statearr_122890[(24)] = inst_122734);

(statearr_122890[(25)] = inst_122730);

(statearr_122890[(17)] = inst_122727);

(statearr_122890[(26)] = inst_122732);

return statearr_122890;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_122853__$1,(14),sources);
} else {
if((state_val_122854 === (22))){
var inst_122728 = (state_122853[(13)]);
var state_122853__$1 = state_122853;
var statearr_122891_122985 = state_122853__$1;
(statearr_122891_122985[(2)] = inst_122728);

(statearr_122891_122985[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (36))){
var inst_122782 = (state_122853[(2)]);
var state_122853__$1 = state_122853;
if(cljs.core.truth_(inst_122782)){
var statearr_122892_122986 = state_122853__$1;
(statearr_122892_122986[(1)] = (40));

} else {
var statearr_122893_122987 = state_122853__$1;
(statearr_122893_122987[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (41))){
var state_122853__$1 = state_122853;
var statearr_122894_122988 = state_122853__$1;
(statearr_122894_122988[(1)] = (65));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (43))){
var inst_122785 = (state_122853[(18)]);
var state_122853__$1 = state_122853;
var statearr_122896_122989 = state_122853__$1;
(statearr_122896_122989[(2)] = inst_122785);

(statearr_122896_122989[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (61))){
var inst_122726 = (state_122853[(20)]);
var inst_122799 = (state_122853[(27)]);
var inst_122805 = (state_122853[(28)]);
var inst_122804 = (state_122853[(7)]);
var inst_122798 = (state_122853[(29)]);
var inst_122758 = (state_122853[(15)]);
var inst_122729 = (state_122853[(11)]);
var inst_122747 = (state_122853[(30)]);
var inst_122736 = (state_122853[(16)]);
var inst_122733 = (state_122853[(21)]);
var inst_122731 = (state_122853[(22)]);
var inst_122728 = (state_122853[(13)]);
var inst_122735 = (state_122853[(23)]);
var inst_122734 = (state_122853[(24)]);
var inst_122730 = (state_122853[(25)]);
var inst_122784 = (state_122853[(10)]);
var inst_122727 = (state_122853[(17)]);
var inst_122789 = (state_122853[(9)]);
var inst_122732 = (state_122853[(26)]);
var inst_122748 = (state_122853[(31)]);
var inst_122815 = (state_122853[(19)]);
var inst_122757 = (state_122853[(14)]);
var inst_122739 = (state_122853[(12)]);
var inst_122821 = (state_122853[(2)]);
var inst_122822 = cljs.core.deref.call(null,inst_122798);
var inst_122823 = (function (){var error_QMARK_ = inst_122805;
var map__122705 = inst_122726;
var construct = inst_122727;
var result_STAR_ = inst_122804;
var conn = inst_122748;
var select = inst_122728;
var block = inst_122729;
var where = inst_122730;
var prefixes = inst_122731;
var limit = inst_122732;
var db = inst_122739;
var meta_QMARK_ = inst_122784;
var source_opts = inst_122757;
var fuel = inst_122798;
var db_STAR_ = inst_122747;
var selectDistinct = inst_122733;
var start_ms = inst_122799;
var selectOne = inst_122734;
var from = inst_122735;
var max_fuel = inst_122789;
var opts__$1 = inst_122758;
var selectReduced = inst_122736;
return (function (p1__122694_SHARP_){
return goog.string.format("%.2fms",p1__122694_SHARP_);
});
})();
var inst_122824 = fluree.db.util.core.current_time_millis.call(null);
var inst_122825 = (inst_122824 - inst_122799);
var inst_122826 = (inst_122825 / (1000000));
var inst_122827 = inst_122823.call(null,inst_122826);
var inst_122828 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_122747);
var inst_122829 = [(200),inst_122821,inst_122822,inst_122827,inst_122828];
var inst_122830 = cljs.core.PersistentHashMap.fromArrays(inst_122815,inst_122829);
var state_122853__$1 = state_122853;
var statearr_122897_122990 = state_122853__$1;
(statearr_122897_122990[(2)] = inst_122830);

(statearr_122897_122990[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (29))){
var inst_122736 = (state_122853[(16)]);
var state_122853__$1 = state_122853;
if(cljs.core.truth_(inst_122736)){
var statearr_122898_122991 = state_122853__$1;
(statearr_122898_122991[(1)] = (31));

} else {
var statearr_122899_122992 = state_122853__$1;
(statearr_122899_122992[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (44))){
var state_122853__$1 = state_122853;
var statearr_122900_122993 = state_122853__$1;
(statearr_122900_122993[(2)] = (1000000));

(statearr_122900_122993[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (6))){
var state_122853__$1 = state_122853;
var statearr_122901_122994 = state_122853__$1;
(statearr_122901_122994[(2)] = false);

(statearr_122901_122994[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (28))){
var inst_122733 = (state_122853[(21)]);
var state_122853__$1 = state_122853;
var statearr_122902_122995 = state_122853__$1;
(statearr_122902_122995[(2)] = inst_122733);

(statearr_122902_122995[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (64))){
var inst_122835 = (state_122853[(2)]);
var state_122853__$1 = state_122853;
var statearr_122903_122996 = state_122853__$1;
(statearr_122903_122996[(2)] = inst_122835);

(statearr_122903_122996[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (51))){
var inst_122798 = (state_122853[(29)]);
var inst_122758 = (state_122853[(15)]);
var inst_122747 = (state_122853[(30)]);
var inst_122789 = (state_122853[(9)]);
var inst_122798__$1 = (state_122853[(2)]);
var inst_122799 = fluree.db.util.core.current_time_millis.call(null);
var inst_122800 = cljs.core.assoc.call(null,inst_122758,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_122798__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_122789);
var inst_122801 = fluree.db.query.fql.query.call(null,inst_122747,query_map,inst_122800);
var state_122853__$1 = (function (){var statearr_122904 = state_122853;
(statearr_122904[(27)] = inst_122799);

(statearr_122904[(29)] = inst_122798__$1);

return statearr_122904;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_122853__$1,(52),inst_122801);
} else {
if((state_val_122854 === (25))){
var inst_122734 = (state_122853[(24)]);
var state_122853__$1 = state_122853;
var statearr_122905_122997 = state_122853__$1;
(statearr_122905_122997[(2)] = inst_122734);

(statearr_122905_122997[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (34))){
var inst_122735 = (state_122853[(23)]);
var state_122853__$1 = state_122853;
if(cljs.core.truth_(inst_122735)){
var statearr_122906_122998 = state_122853__$1;
(statearr_122906_122998[(1)] = (37));

} else {
var statearr_122907_122999 = state_122853__$1;
(statearr_122907_122999[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (17))){
var inst_122747 = (state_122853[(30)]);
var inst_122731 = (state_122853[(22)]);
var inst_122747__$1 = (state_122853[(2)]);
var inst_122748 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_122747__$1);
var state_122853__$1 = (function (){var statearr_122908 = state_122853;
(statearr_122908[(30)] = inst_122747__$1);

(statearr_122908[(31)] = inst_122748);

return statearr_122908;
})();
if(cljs.core.truth_(inst_122731)){
var statearr_122909_123000 = state_122853__$1;
(statearr_122909_123000[(1)] = (19));

} else {
var statearr_122910_123001 = state_122853__$1;
(statearr_122910_123001[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (3))){
var inst_122697 = (state_122853[(2)]);
var inst_122698 = fluree.db.util.log.error.call(null,inst_122697);
var inst_122699 = cljs.core.ex_data.call(null,inst_122697);
var inst_122700 = cljs.core.ex_message.call(null,inst_122697);
var inst_122701 = cljs.core.assoc.call(null,inst_122699,new cljs.core.Keyword(null,"message","message",-406056002),inst_122700);
var state_122853__$1 = (function (){var statearr_122911 = state_122853;
(statearr_122911[(32)] = inst_122698);

return statearr_122911;
})();
var statearr_122912_123002 = state_122853__$1;
(statearr_122912_123002[(2)] = inst_122701);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_122853__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (12))){
var state_122853__$1 = state_122853;
var statearr_122913_123003 = state_122853__$1;
(statearr_122913_123003[(2)] = query_map);

(statearr_122913_123003[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (2))){
var inst_122851 = (state_122853[(2)]);
var state_122853__$1 = state_122853;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_122853__$1,inst_122851);
} else {
if((state_val_122854 === (66))){
var state_122853__$1 = state_122853;
var statearr_122914_123004 = state_122853__$1;
(statearr_122914_123004[(2)] = null);

(statearr_122914_123004[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (23))){
var inst_122734 = (state_122853[(24)]);
var state_122853__$1 = state_122853;
if(cljs.core.truth_(inst_122734)){
var statearr_122915_123005 = state_122853__$1;
(statearr_122915_123005[(1)] = (25));

} else {
var statearr_122916_123006 = state_122853__$1;
(statearr_122916_123006[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (47))){
var inst_122784 = (state_122853[(10)]);
var state_122853__$1 = state_122853;
var statearr_122917_123007 = state_122853__$1;
(statearr_122917_123007[(2)] = inst_122784);

(statearr_122917_123007[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (35))){
var inst_122774 = (state_122853[(8)]);
var state_122853__$1 = state_122853;
var statearr_122918_123008 = state_122853__$1;
(statearr_122918_123008[(2)] = inst_122774);

(statearr_122918_123008[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (19))){
var inst_122747 = (state_122853[(30)]);
var inst_122731 = (state_122853[(22)]);
var inst_122748 = (state_122853[(31)]);
var inst_122750 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_122747);
var inst_122751 = fluree.db.connection_js.open_api_QMARK_.call(null,inst_122748);
var inst_122752 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_122747);
var inst_122753 = fluree.db.api_js.get_sources.call(null,inst_122748,inst_122750,inst_122751,inst_122752,inst_122731,db_fn);
var state_122853__$1 = state_122853;
var statearr_122919_123009 = state_122853__$1;
(statearr_122919_123009[(2)] = inst_122753);

(statearr_122919_123009[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (57))){
var state_122853__$1 = state_122853;
var statearr_122920_123010 = state_122853__$1;
(statearr_122920_123010[(1)] = (62));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (11))){
var inst_122723 = cljs.core.apply.call(null,cljs.core.hash_map,query_map);
var state_122853__$1 = state_122853;
var statearr_122922_123011 = state_122853__$1;
(statearr_122922_123011[(2)] = inst_122723);

(statearr_122922_123011[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (9))){
var state_122853__$1 = state_122853;
var statearr_122923_123012 = state_122853__$1;
(statearr_122923_123012[(2)] = false);

(statearr_122923_123012[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (5))){
var inst_122710 = query_map.cljs$lang$protocol_mask$partition0$;
var inst_122711 = (inst_122710 & (64));
var inst_122712 = query_map.cljs$core$ISeq$;
var inst_122713 = (cljs.core.PROTOCOL_SENTINEL === inst_122712);
var inst_122714 = ((inst_122711) || (inst_122713));
var state_122853__$1 = state_122853;
if(cljs.core.truth_(inst_122714)){
var statearr_122924_123013 = state_122853__$1;
(statearr_122924_123013[(1)] = (8));

} else {
var statearr_122925_123014 = state_122853__$1;
(statearr_122925_123014[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (14))){
var inst_122729 = (state_122853[(11)]);
var inst_122738 = (state_122853[(2)]);
var inst_122739 = fluree.db.util.async.throw_err.call(null,inst_122738);
var state_122853__$1 = (function (){var statearr_122926 = state_122853;
(statearr_122926[(12)] = inst_122739);

return statearr_122926;
})();
if(cljs.core.truth_(inst_122729)){
var statearr_122927_123015 = state_122853__$1;
(statearr_122927_123015[(1)] = (15));

} else {
var statearr_122928_123016 = state_122853__$1;
(statearr_122928_123016[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (45))){
var inst_122789 = (state_122853[(9)]);
var inst_122789__$1 = (state_122853[(2)]);
var state_122853__$1 = (function (){var statearr_122929 = state_122853;
(statearr_122929[(9)] = inst_122789__$1);

return statearr_122929;
})();
if(cljs.core.truth_(inst_122789__$1)){
var statearr_122930_123017 = state_122853__$1;
(statearr_122930_123017[(1)] = (46));

} else {
var statearr_122931_123018 = state_122853__$1;
(statearr_122931_123018[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (53))){
var inst_122804 = (state_122853[(7)]);
var inst_122807 = cljs.core.ex_data.call(null,inst_122804);
var inst_122808 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_122809 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_122807);
var inst_122810 = cljs.core.ex_message.call(null,inst_122804);
var inst_122811 = [inst_122809,inst_122810,new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_122812 = cljs.core.PersistentHashMap.fromArrays(inst_122808,inst_122811);
var state_122853__$1 = state_122853;
var statearr_122932_123019 = state_122853__$1;
(statearr_122932_123019[(2)] = inst_122812);

(statearr_122932_123019[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (26))){
var inst_122733 = (state_122853[(21)]);
var state_122853__$1 = state_122853;
if(cljs.core.truth_(inst_122733)){
var statearr_122933_123020 = state_122853__$1;
(statearr_122933_123020[(1)] = (28));

} else {
var statearr_122934_123021 = state_122853__$1;
(statearr_122934_123021[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (16))){
var inst_122739 = (state_122853[(12)]);
var state_122853__$1 = state_122853;
var statearr_122935_123022 = state_122853__$1;
(statearr_122935_123022[(2)] = inst_122739);

(statearr_122935_123022[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (38))){
var inst_122730 = (state_122853[(25)]);
var state_122853__$1 = state_122853;
var statearr_122936_123023 = state_122853__$1;
(statearr_122936_123023[(2)] = inst_122730);

(statearr_122936_123023[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (30))){
var inst_122770 = (state_122853[(2)]);
var state_122853__$1 = state_122853;
var statearr_122937_123024 = state_122853__$1;
(statearr_122937_123024[(2)] = inst_122770);

(statearr_122937_123024[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (10))){
var inst_122718 = (state_122853[(2)]);
var state_122853__$1 = state_122853;
var statearr_122938_123025 = state_122853__$1;
(statearr_122938_123025[(2)] = inst_122718);

(statearr_122938_123025[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (18))){
var inst_122743 = (state_122853[(2)]);
var inst_122744 = fluree.db.util.async.throw_err.call(null,inst_122743);
var state_122853__$1 = state_122853;
var statearr_122939_123026 = state_122853__$1;
(statearr_122939_123026[(2)] = inst_122744);

(statearr_122939_123026[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (52))){
var inst_122805 = (state_122853[(28)]);
var inst_122804 = (state_122853[(7)]);
var inst_122803 = (state_122853[(2)]);
var inst_122804__$1 = fluree.db.util.async.throw_err.call(null,inst_122803);
var inst_122805__$1 = (inst_122804__$1 instanceof cljs.core.ExceptionInfo);
var state_122853__$1 = (function (){var statearr_122940 = state_122853;
(statearr_122940[(28)] = inst_122805__$1);

(statearr_122940[(7)] = inst_122804__$1);

return statearr_122940;
})();
if(cljs.core.truth_(inst_122805__$1)){
var statearr_122941_123027 = state_122853__$1;
(statearr_122941_123027[(1)] = (53));

} else {
var statearr_122942_123028 = state_122853__$1;
(statearr_122942_123028[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (67))){
var inst_122847 = (state_122853[(2)]);
var state_122853__$1 = state_122853;
var statearr_122943_123029 = state_122853__$1;
(statearr_122943_123029[(2)] = inst_122847);

(statearr_122943_123029[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (42))){
var inst_122849 = (state_122853[(2)]);
var state_122853__$1 = state_122853;
var statearr_122944_123030 = state_122853__$1;
(statearr_122944_123030[(2)] = inst_122849);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_122853__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (37))){
var inst_122735 = (state_122853[(23)]);
var state_122853__$1 = state_122853;
var statearr_122945_123031 = state_122853__$1;
(statearr_122945_123031[(2)] = inst_122735);

(statearr_122945_123031[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (63))){
var state_122853__$1 = state_122853;
var statearr_122946_123032 = state_122853__$1;
(statearr_122946_123032[(2)] = null);

(statearr_122946_123032[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (8))){
var state_122853__$1 = state_122853;
var statearr_122947_123033 = state_122853__$1;
(statearr_122947_123033[(2)] = true);

(statearr_122947_123033[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122854 === (49))){
var inst_122795 = cljs.core.volatile_BANG_.call(null,(0));
var state_122853__$1 = state_122853;
var statearr_122948_123034 = state_122853__$1;
(statearr_122948_123034[(2)] = inst_122795);

(statearr_122948_123034[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__99975__auto__ = null;
var fluree$db$api_js$state_machine__99975__auto____0 = (function (){
var statearr_122949 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_122949[(0)] = fluree$db$api_js$state_machine__99975__auto__);

(statearr_122949[(1)] = (1));

return statearr_122949;
});
var fluree$db$api_js$state_machine__99975__auto____1 = (function (state_122853){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_122853);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e122950){if((e122950 instanceof Object)){
var ex__99978__auto__ = e122950;
var statearr_122951_123035 = state_122853;
(statearr_122951_123035[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_122853);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e122950;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__123036 = state_122853;
state_122853 = G__123036;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__99975__auto__ = function(state_122853){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__99975__auto____1.call(this,state_122853);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__99975__auto____0;
fluree$db$api_js$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__99975__auto____1;
return fluree$db$api_js$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_122952 = f__100070__auto__.call(null);
(statearr_122952[(6)] = c__100069__auto__);

return statearr_122952;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.api_js.query_async.cljs$lang$maxFixedArity = 4);

/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *   Returns a core async channel that will eventually contain a response,
 *   or will close after the timeout has expired.
 * 
 *   Response may contain an exception, if the tx resulted in an exception.
 */
fluree.db.api_js.monitor_tx = (function fluree$db$api_js$monitor_tx(conn,ledger,tid,timeout_ms){
if(cljs.core.int_QMARK_.call(null,timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor-tx requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

var session = fluree.db.session.session.call(null,conn,ledger);
var key = cljs.core.random_uuid.call(null);
var resp_chan = cljs.core.async.chan.call(null);
var timeout_chan = cljs.core.async.timeout.call(null,timeout_ms);
fluree.db.session.monitor_tx.call(null,session,tid,key,(function (p1__123037_SHARP_){
return cljs.core.async.put_BANG_.call(null,resp_chan,p1__123037_SHARP_);
}));

var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_123059){
var state_val_123060 = (state_123059[(1)]);
if((state_val_123060 === (1))){
var inst_123041 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_123042 = [resp_chan,timeout_chan];
var inst_123043 = (new cljs.core.PersistentVector(null,2,(5),inst_123041,inst_123042,null));
var state_123059__$1 = state_123059;
return cljs.core.async.ioc_alts_BANG_.call(null,state_123059__$1,(2),inst_123043);
} else {
if((state_val_123060 === (2))){
var inst_123045 = (state_123059[(2)]);
var inst_123046 = cljs.core.nth.call(null,inst_123045,(0),null);
var inst_123047 = cljs.core.nth.call(null,inst_123045,(1),null);
var inst_123048 = cljs.core._EQ_.call(null,timeout_chan,inst_123047);
var state_123059__$1 = (function (){var statearr_123061 = state_123059;
(statearr_123061[(7)] = inst_123046);

return statearr_123061;
})();
if(inst_123048){
var statearr_123062_123071 = state_123059__$1;
(statearr_123062_123071[(1)] = (3));

} else {
var statearr_123063_123072 = state_123059__$1;
(statearr_123063_123072[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123060 === (3))){
var inst_123050 = fluree.db.session.monitor_tx_remove.call(null,session,tid,key);
var inst_123051 = [new cljs.core.Keyword(null,"txid","txid",1606205478),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_123052 = ["Timeout of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(timeout_ms)," ms for reached without transaction being included in new block. Transaction is still being processed. To view transaction results, issue: {\"select\": [\"*\"], \"from\": [\"_tx/id\", \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"\" ]}"].join('');
var inst_123053 = [tid,(408),inst_123052];
var inst_123054 = cljs.core.PersistentHashMap.fromArrays(inst_123051,inst_123053);
var state_123059__$1 = (function (){var statearr_123064 = state_123059;
(statearr_123064[(8)] = inst_123050);

return statearr_123064;
})();
var statearr_123065_123073 = state_123059__$1;
(statearr_123065_123073[(2)] = inst_123054);

(statearr_123065_123073[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123060 === (4))){
var inst_123046 = (state_123059[(7)]);
var state_123059__$1 = state_123059;
var statearr_123066_123074 = state_123059__$1;
(statearr_123066_123074[(2)] = inst_123046);

(statearr_123066_123074[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123060 === (5))){
var inst_123057 = (state_123059[(2)]);
var state_123059__$1 = state_123059;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_123059__$1,inst_123057);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$monitor_tx_$_state_machine__99975__auto__ = null;
var fluree$db$api_js$monitor_tx_$_state_machine__99975__auto____0 = (function (){
var statearr_123067 = [null,null,null,null,null,null,null,null,null];
(statearr_123067[(0)] = fluree$db$api_js$monitor_tx_$_state_machine__99975__auto__);

(statearr_123067[(1)] = (1));

return statearr_123067;
});
var fluree$db$api_js$monitor_tx_$_state_machine__99975__auto____1 = (function (state_123059){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_123059);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e123068){if((e123068 instanceof Object)){
var ex__99978__auto__ = e123068;
var statearr_123069_123075 = state_123059;
(statearr_123069_123075[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_123059);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e123068;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__123076 = state_123059;
state_123059 = G__123076;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$api_js$monitor_tx_$_state_machine__99975__auto__ = function(state_123059){
switch(arguments.length){
case 0:
return fluree$db$api_js$monitor_tx_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$api_js$monitor_tx_$_state_machine__99975__auto____1.call(this,state_123059);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$monitor_tx_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$monitor_tx_$_state_machine__99975__auto____0;
fluree$db$api_js$monitor_tx_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$monitor_tx_$_state_machine__99975__auto____1;
return fluree$db$api_js$monitor_tx_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_123070 = f__100070__auto__.call(null);
(statearr_123070[(6)] = c__100069__auto__);

return statearr_123070;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Helper function to fill out the parts of the transaction that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
fluree.db.api_js.tx__GT_command = (function fluree$db$api_js$tx__GT_command(var_args){
var G__123078 = arguments.length;
switch (G__123078) {
case 3:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,txn,private_key){
return fluree.db.api_js.tx__GT_command.call(null,ledger,txn,private_key,null);
}));

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,txn,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.call(null,"Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-transaction","db/invalid-transaction",1706641798)], null));
}

var db_name = ((cljs.core.sequential_QMARK_.call(null,ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,ledger))].join(''):ledger);
var map__123079 = opts;
var map__123079__$1 = (((((!((map__123079 == null))))?(((((map__123079.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__123079.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__123079):map__123079);
var auth = cljs.core.get.call(null,map__123079__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.call(null,map__123079__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.call(null,map__123079__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var deps = cljs.core.get.call(null,map__123079__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
var _ = (cljs.core.truth_(deps)?((cljs.core.sequential_QMARK_.call(null,deps))?null:(function(){throw (new Error(["Assert failed: ","Command/transaction 'deps', when provided, must be a sequential list/array.","\n","(sequential? deps)"].join('')))})()):null);
var key_auth_id = fluree.crypto.account_id_from_private.call(null,private_key);
var vec__123080 = (cljs.core.truth_((function (){var and__4115__auto__ = auth;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.not_EQ_.call(null,auth,key_auth_id);
} else {
return and__4115__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.call(null,vec__123080,(0),null);
var authority = cljs.core.nth.call(null,vec__123080,(1),null);
var timestamp = fluree.db.util.core.current_time_millis.call(null);
var nonce__$1 = (function (){var or__4126__auto__ = nonce;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__4126__auto__ = expire;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify.call(null,fluree.db.util.core.without_nils.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"db","db",993250759),db_name,new cljs.core.Keyword(null,"tx","tx",466630418),txn,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1,new cljs.core.Keyword(null,"deps","deps",1883360319),deps], null)));
}catch (e123084){var e = e123084;

throw cljs.core.ex_info.call(null,"Transaction contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
}})();
var sig = fluree.crypto.sign_message.call(null,cmd,private_key);
var id = fluree.crypto.sha3_256.call(null,cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"db","db",993250759),ledger], null);
}));

(fluree.db.api_js.tx__GT_command.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.transact_async = (function fluree$db$api_js$transact_async(var_args){
var G__123087 = arguments.length;
switch (G__123087) {
case 3:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return fluree.db.api_js.transact_async.call(null,conn,ledger,txn,null);
}));

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_123169){
var state_val_123170 = (state_123169[(1)]);
if((state_val_123170 === (7))){
var inst_123112 = (state_123169[(2)]);
var state_123169__$1 = state_123169;
if(cljs.core.truth_(inst_123112)){
var statearr_123171_123212 = state_123169__$1;
(statearr_123171_123212[(1)] = (11));

} else {
var statearr_123172_123213 = state_123169__$1;
(statearr_123172_123213[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123170 === (20))){
var inst_123135 = (state_123169[(2)]);
var state_123169__$1 = state_123169;
var statearr_123173_123214 = state_123169__$1;
(statearr_123173_123214[(2)] = inst_123135);

(statearr_123173_123214[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123170 === (27))){
var inst_123150 = (state_123169[(7)]);
var state_123169__$1 = state_123169;
var statearr_123174_123215 = state_123169__$1;
(statearr_123174_123215[(2)] = inst_123150);

(statearr_123174_123215[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123170 === (1))){
var state_123169__$1 = state_123169;
var statearr_123175_123216 = state_123169__$1;
(statearr_123175_123216[(2)] = null);

(statearr_123175_123216[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123170 === (24))){
var inst_123163 = (state_123169[(2)]);
var state_123169__$1 = state_123169;
var statearr_123176_123217 = state_123169__$1;
(statearr_123176_123217[(2)] = inst_123163);

(statearr_123176_123217[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123170 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_123169,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var inst_123098 = (opts == null);
var inst_123099 = cljs.core.not.call(null,inst_123098);
var state_123169__$1 = state_123169;
if(inst_123099){
var statearr_123177_123218 = state_123169__$1;
(statearr_123177_123218[(1)] = (5));

} else {
var statearr_123178_123219 = state_123169__$1;
(statearr_123178_123219[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123170 === (15))){
var inst_123123 = (state_123169[(8)]);
var inst_123125 = (state_123169[(9)]);
var inst_123121 = (state_123169[(10)]);
var inst_123126 = (state_123169[(11)]);
var inst_123124 = (state_123169[(12)]);
var inst_123139 = [new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"deps","deps",1883360319),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"jwt","jwt",1504015441)];
var inst_123140 = [ledger,txn,inst_123121,inst_123123,inst_123124,inst_123125,inst_123126];
var inst_123141 = cljs.core.PersistentHashMap.fromArrays(inst_123139,inst_123140);
var inst_123142 = fluree.db.util.core.without_nils.call(null,inst_123141);
var inst_123143 = fluree.db.operations.transact_async.call(null,conn,inst_123142);
var state_123169__$1 = state_123169;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_123169__$1,(21),inst_123143);
} else {
if((state_val_123170 === (21))){
var inst_123119 = (state_123169[(13)]);
var inst_123145 = (state_123169[(2)]);
var state_123169__$1 = (function (){var statearr_123179 = state_123169;
(statearr_123179[(14)] = inst_123145);

return statearr_123179;
})();
if(cljs.core.truth_(inst_123119)){
var statearr_123180_123220 = state_123169__$1;
(statearr_123180_123220[(1)] = (22));

} else {
var statearr_123181_123221 = state_123169__$1;
(statearr_123181_123221[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123170 === (13))){
var inst_123118 = (state_123169[(15)]);
var inst_123117 = (state_123169[(2)]);
var inst_123118__$1 = cljs.core.get.call(null,inst_123117,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_123119 = cljs.core.get.call(null,inst_123117,new cljs.core.Keyword(null,"txid-only","txid-only",1518298509));
var inst_123120 = cljs.core.get.call(null,inst_123117,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_123121 = cljs.core.get.call(null,inst_123117,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_123122 = fluree.db.util.core.current_time_millis.call(null);
var inst_123123 = cljs.core.get.call(null,inst_123117,new cljs.core.Keyword(null,"nonce","nonce",564330331),inst_123122);
var inst_123124 = cljs.core.get.call(null,inst_123117,new cljs.core.Keyword(null,"deps","deps",1883360319));
var inst_123125 = cljs.core.get.call(null,inst_123117,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_123126 = cljs.core.get.call(null,inst_123117,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var state_123169__$1 = (function (){var statearr_123182 = state_123169;
(statearr_123182[(8)] = inst_123123);

(statearr_123182[(13)] = inst_123119);

(statearr_123182[(9)] = inst_123125);

(statearr_123182[(15)] = inst_123118__$1);

(statearr_123182[(10)] = inst_123121);

(statearr_123182[(11)] = inst_123126);

(statearr_123182[(12)] = inst_123124);

(statearr_123182[(16)] = inst_123120);

return statearr_123182;
})();
if(cljs.core.truth_(inst_123118__$1)){
var statearr_123183_123222 = state_123169__$1;
(statearr_123183_123222[(1)] = (14));

} else {
var statearr_123184_123223 = state_123169__$1;
(statearr_123184_123223[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123170 === (22))){
var inst_123145 = (state_123169[(14)]);
var state_123169__$1 = state_123169;
var statearr_123185_123224 = state_123169__$1;
(statearr_123185_123224[(2)] = inst_123145);

(statearr_123185_123224[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123170 === (6))){
var state_123169__$1 = state_123169;
var statearr_123186_123225 = state_123169__$1;
(statearr_123186_123225[(2)] = false);

(statearr_123186_123225[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123170 === (28))){
var inst_123161 = (state_123169[(2)]);
var state_123169__$1 = state_123169;
var statearr_123187_123226 = state_123169__$1;
(statearr_123187_123226[(2)] = inst_123161);

(statearr_123187_123226[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123170 === (25))){
var inst_123150 = (state_123169[(7)]);
var inst_123150__$1 = (state_123169[(2)]);
var inst_123151 = (inst_123150__$1 instanceof cljs.core.ExceptionInfo);
var state_123169__$1 = (function (){var statearr_123188 = state_123169;
(statearr_123188[(7)] = inst_123150__$1);

return statearr_123188;
})();
if(cljs.core.truth_(inst_123151)){
var statearr_123189_123227 = state_123169__$1;
(statearr_123189_123227[(1)] = (26));

} else {
var statearr_123190_123228 = state_123169__$1;
(statearr_123190_123228[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123170 === (17))){
var inst_123130 = (state_123169[(17)]);
var state_123169__$1 = state_123169;
var statearr_123191_123229 = state_123169__$1;
(statearr_123191_123229[(2)] = inst_123130);

(statearr_123191_123229[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123170 === (3))){
var inst_123088 = (state_123169[(2)]);
var inst_123089 = fluree.db.util.log.error.call(null,inst_123088);
var inst_123090 = cljs.core.ex_data.call(null,inst_123088);
var inst_123091 = cljs.core.ex_message.call(null,inst_123088);
var inst_123092 = cljs.core.assoc.call(null,inst_123090,new cljs.core.Keyword(null,"message","message",-406056002),inst_123091);
var state_123169__$1 = (function (){var statearr_123192 = state_123169;
(statearr_123192[(18)] = inst_123089);

return statearr_123192;
})();
var statearr_123193_123230 = state_123169__$1;
(statearr_123193_123230[(2)] = inst_123092);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_123169__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123170 === (12))){
var state_123169__$1 = state_123169;
var statearr_123194_123231 = state_123169__$1;
(statearr_123194_123231[(2)] = opts);

(statearr_123194_123231[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123170 === (2))){
var inst_123167 = (state_123169[(2)]);
var state_123169__$1 = state_123169;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_123169__$1,inst_123167);
} else {
if((state_val_123170 === (23))){
var inst_123145 = (state_123169[(14)]);
var inst_123120 = (state_123169[(16)]);
var inst_123148 = fluree.db.api_js.monitor_tx.call(null,conn,ledger,inst_123145,inst_123120);
var state_123169__$1 = state_123169;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_123169__$1,(25),inst_123148);
} else {
if((state_val_123170 === (19))){
var inst_123137 = (state_123169[(2)]);
var state_123169__$1 = state_123169;
var statearr_123195_123232 = state_123169__$1;
(statearr_123195_123232[(2)] = inst_123137);

(statearr_123195_123232[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123170 === (11))){
var inst_123114 = cljs.core.apply.call(null,cljs.core.hash_map,opts);
var state_123169__$1 = state_123169;
var statearr_123196_123233 = state_123169__$1;
(statearr_123196_123233[(2)] = inst_123114);

(statearr_123196_123233[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123170 === (9))){
var state_123169__$1 = state_123169;
var statearr_123197_123234 = state_123169__$1;
(statearr_123197_123234[(2)] = false);

(statearr_123197_123234[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123170 === (5))){
var inst_123101 = opts.cljs$lang$protocol_mask$partition0$;
var inst_123102 = (inst_123101 & (64));
var inst_123103 = opts.cljs$core$ISeq$;
var inst_123104 = (cljs.core.PROTOCOL_SENTINEL === inst_123103);
var inst_123105 = ((inst_123102) || (inst_123104));
var state_123169__$1 = state_123169;
if(cljs.core.truth_(inst_123105)){
var statearr_123198_123235 = state_123169__$1;
(statearr_123198_123235[(1)] = (8));

} else {
var statearr_123199_123236 = state_123169__$1;
(statearr_123199_123236[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123170 === (14))){
var inst_123119 = (state_123169[(13)]);
var inst_123118 = (state_123169[(15)]);
var inst_123128 = fluree.db.api_js.tx__GT_command.call(null,ledger,txn,inst_123118,opts);
var inst_123129 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(inst_123128);
var inst_123130 = fluree.db.operations.command_async.call(null,conn,inst_123128);
var state_123169__$1 = (function (){var statearr_123200 = state_123169;
(statearr_123200[(19)] = inst_123129);

(statearr_123200[(17)] = inst_123130);

return statearr_123200;
})();
if(cljs.core.truth_(inst_123119)){
var statearr_123201_123237 = state_123169__$1;
(statearr_123201_123237[(1)] = (17));

} else {
var statearr_123202_123238 = state_123169__$1;
(statearr_123202_123238[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123170 === (26))){
var inst_123150 = (state_123169[(7)]);
var inst_123153 = cljs.core.ex_data.call(null,inst_123150);
var inst_123154 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_123155 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_123153);
var inst_123156 = cljs.core.ex_message.call(null,inst_123150);
var inst_123157 = [inst_123155,inst_123156,new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_123158 = cljs.core.PersistentHashMap.fromArrays(inst_123154,inst_123157);
var state_123169__$1 = state_123169;
var statearr_123203_123239 = state_123169__$1;
(statearr_123203_123239[(2)] = inst_123158);

(statearr_123203_123239[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123170 === (16))){
var inst_123165 = (state_123169[(2)]);
var state_123169__$1 = state_123169;
var statearr_123204_123240 = state_123169__$1;
(statearr_123204_123240[(2)] = inst_123165);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_123169__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123170 === (10))){
var inst_123109 = (state_123169[(2)]);
var state_123169__$1 = state_123169;
var statearr_123205_123241 = state_123169__$1;
(statearr_123205_123241[(2)] = inst_123109);

(statearr_123205_123241[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123170 === (18))){
var inst_123129 = (state_123169[(19)]);
var inst_123120 = (state_123169[(16)]);
var inst_123133 = fluree.db.api_js.monitor_tx.call(null,conn,ledger,inst_123129,inst_123120);
var state_123169__$1 = state_123169;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_123169__$1,(20),inst_123133);
} else {
if((state_val_123170 === (8))){
var state_123169__$1 = state_123169;
var statearr_123206_123242 = state_123169__$1;
(statearr_123206_123242[(2)] = true);

(statearr_123206_123242[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__99975__auto__ = null;
var fluree$db$api_js$state_machine__99975__auto____0 = (function (){
var statearr_123207 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_123207[(0)] = fluree$db$api_js$state_machine__99975__auto__);

(statearr_123207[(1)] = (1));

return statearr_123207;
});
var fluree$db$api_js$state_machine__99975__auto____1 = (function (state_123169){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_123169);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e123208){if((e123208 instanceof Object)){
var ex__99978__auto__ = e123208;
var statearr_123209_123243 = state_123169;
(statearr_123209_123243[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_123169);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e123208;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__123244 = state_123169;
state_123169 = G__123244;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__99975__auto__ = function(state_123169){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__99975__auto____1.call(this,state_123169);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__99975__auto____0;
fluree$db$api_js$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__99975__auto____1;
return fluree$db$api_js$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_123210 = f__100070__auto__.call(null);
(statearr_123210[(6)] = c__100069__auto__);

return statearr_123210;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.api_js.transact_async.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.min_safe = (function fluree$db$api_js$min_safe(var_args){
var args__4742__auto__ = [];
var len__4736__auto___123246 = arguments.length;
var i__4737__auto___123247 = (0);
while(true){
if((i__4737__auto___123247 < len__4736__auto___123246)){
args__4742__auto__.push((arguments[i__4737__auto___123247]));

var G__123248 = (i__4737__auto___123247 + (1));
i__4737__auto___123247 = G__123248;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.call(null,cljs.core.min,cljs.core.remove.call(null,cljs.core.nil_QMARK_,args));
}));

(fluree.db.api_js.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api_js.min_safe.cljs$lang$applyTo = (function (seq123245){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq123245));
}));

fluree.db.api_js.format_flake_groups_pretty = (function fluree$db$api_js$format_flake_groups_pretty(db,cache,fuel,flakes){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_123279){
var state_val_123280 = (state_123279[(1)]);
if((state_val_123280 === (1))){
var inst_123249 = cljs.core.first.call(null,flakes);
var inst_123250 = cljs.core.rest.call(null,flakes);
var inst_123251 = cljs.core.PersistentVector.EMPTY;
var inst_123252 = inst_123249;
var inst_123253 = inst_123250;
var inst_123254 = inst_123251;
var state_123279__$1 = (function (){var statearr_123281 = state_123279;
(statearr_123281[(7)] = inst_123254);

(statearr_123281[(8)] = inst_123253);

(statearr_123281[(9)] = inst_123252);

return statearr_123281;
})();
var statearr_123282_123294 = state_123279__$1;
(statearr_123282_123294[(2)] = null);

(statearr_123282_123294[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123280 === (2))){
var inst_123252 = (state_123279[(9)]);
var inst_123256 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_123257 = cljs.core.PersistentHashMap.EMPTY;
var inst_123258 = [true,inst_123257];
var inst_123259 = cljs.core.PersistentHashMap.fromArrays(inst_123256,inst_123258);
var inst_123260 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,(1000000),inst_123259,inst_123252);
var state_123279__$1 = state_123279;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_123279__$1,(4),inst_123260);
} else {
if((state_val_123280 === (3))){
var inst_123277 = (state_123279[(2)]);
var state_123279__$1 = state_123279;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_123279__$1,inst_123277);
} else {
if((state_val_123280 === (4))){
var inst_123254 = (state_123279[(7)]);
var inst_123253 = (state_123279[(8)]);
var inst_123262 = (state_123279[(2)]);
var inst_123263 = fluree.db.util.async.throw_err.call(null,inst_123262);
var inst_123264 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_123265 = [inst_123263];
var inst_123266 = (new cljs.core.PersistentVector(null,1,(5),inst_123264,inst_123265,null));
var inst_123267 = cljs.core.concat.call(null,inst_123254,inst_123266);
var inst_123268 = cljs.core.first.call(null,inst_123253);
var state_123279__$1 = (function (){var statearr_123283 = state_123279;
(statearr_123283[(10)] = inst_123267);

return statearr_123283;
})();
if(cljs.core.truth_(inst_123268)){
var statearr_123284_123295 = state_123279__$1;
(statearr_123284_123295[(1)] = (5));

} else {
var statearr_123285_123296 = state_123279__$1;
(statearr_123285_123296[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123280 === (5))){
var inst_123253 = (state_123279[(8)]);
var inst_123267 = (state_123279[(10)]);
var inst_123270 = cljs.core.first.call(null,inst_123253);
var inst_123271 = cljs.core.rest.call(null,inst_123253);
var inst_123252 = inst_123270;
var inst_123253__$1 = inst_123271;
var inst_123254 = inst_123267;
var state_123279__$1 = (function (){var statearr_123286 = state_123279;
(statearr_123286[(7)] = inst_123254);

(statearr_123286[(8)] = inst_123253__$1);

(statearr_123286[(9)] = inst_123252);

return statearr_123286;
})();
var statearr_123287_123297 = state_123279__$1;
(statearr_123287_123297[(2)] = null);

(statearr_123287_123297[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123280 === (6))){
var inst_123267 = (state_123279[(10)]);
var state_123279__$1 = state_123279;
var statearr_123288_123298 = state_123279__$1;
(statearr_123288_123298[(2)] = inst_123267);

(statearr_123288_123298[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123280 === (7))){
var inst_123275 = (state_123279[(2)]);
var state_123279__$1 = state_123279;
var statearr_123289_123299 = state_123279__$1;
(statearr_123289_123299[(2)] = inst_123275);

(statearr_123289_123299[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__99975__auto__ = null;
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__99975__auto____0 = (function (){
var statearr_123290 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_123290[(0)] = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__99975__auto__);

(statearr_123290[(1)] = (1));

return statearr_123290;
});
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__99975__auto____1 = (function (state_123279){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_123279);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e123291){if((e123291 instanceof Object)){
var ex__99978__auto__ = e123291;
var statearr_123292_123300 = state_123279;
(statearr_123292_123300[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_123279);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e123291;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__123301 = state_123279;
state_123279 = G__123301;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__99975__auto__ = function(state_123279){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__99975__auto____1.call(this,state_123279);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__99975__auto____0;
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__99975__auto____1;
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_123293 = f__100070__auto__.call(null);
(statearr_123293[(6)] = c__100069__auto__);

return statearr_123293;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
fluree.db.api_js.format_block_resp_pretty = (function fluree$db$api_js$format_block_resp_pretty(db,resp){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_123369){
var state_val_123370 = (state_123369[(1)]);
if((state_val_123370 === (7))){
var inst_123329 = (state_123369[(2)]);
var inst_123330 = fluree.db.util.async.throw_err.call(null,inst_123329);
var state_123369__$1 = state_123369;
var statearr_123371_123396 = state_123369__$1;
(statearr_123371_123396[(2)] = inst_123330);

(statearr_123371_123396[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123370 === (1))){
var inst_123306 = cljs.core.volatile_BANG_.call(null,(0));
var inst_123307 = cljs.core.PersistentHashMap.EMPTY;
var inst_123308 = cljs.core.volatile_BANG_.call(null,inst_123307);
var inst_123309 = cljs.core.first.call(null,resp);
var inst_123310 = cljs.core.rest.call(null,resp);
var inst_123311 = cljs.core.PersistentVector.EMPTY;
var inst_123312 = inst_123306;
var inst_123313 = inst_123308;
var inst_123314 = inst_123309;
var inst_123315 = inst_123310;
var inst_123316 = inst_123311;
var state_123369__$1 = (function (){var statearr_123372 = state_123369;
(statearr_123372[(7)] = inst_123313);

(statearr_123372[(8)] = inst_123316);

(statearr_123372[(9)] = inst_123312);

(statearr_123372[(10)] = inst_123314);

(statearr_123372[(11)] = inst_123315);

return statearr_123372;
})();
var statearr_123373_123397 = state_123369__$1;
(statearr_123373_123397[(2)] = null);

(statearr_123373_123397[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123370 === (4))){
var inst_123320 = (state_123369[(12)]);
var inst_123313 = (state_123369[(7)]);
var inst_123316 = (state_123369[(8)]);
var inst_123312 = (state_123369[(9)]);
var inst_123314 = (state_123369[(10)]);
var inst_123315 = (state_123369[(11)]);
var inst_123318 = (state_123369[(13)]);
var inst_123324 = (function (){var fuel = inst_123312;
var cache = inst_123313;
var curr_block = inst_123314;
var rest_blocks = inst_123315;
var acc = inst_123316;
var flakes = inst_123318;
var asserted = inst_123320;
return (function (p1__123303_SHARP_){
return p1__123303_SHARP_.s;
});
})();
var inst_123325 = cljs.core.group_by.call(null,inst_123324,inst_123320);
var inst_123326 = cljs.core.vals.call(null,inst_123325);
var inst_123327 = fluree.db.api_js.format_flake_groups_pretty.call(null,db,inst_123313,inst_123312,inst_123326);
var state_123369__$1 = state_123369;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_123369__$1,(7),inst_123327);
} else {
if((state_val_123370 === (13))){
var inst_123357 = (state_123369[(14)]);
var state_123369__$1 = state_123369;
var statearr_123374_123398 = state_123369__$1;
(statearr_123374_123398[(2)] = inst_123357);

(statearr_123374_123398[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123370 === (6))){
var inst_123320 = (state_123369[(12)]);
var inst_123313 = (state_123369[(7)]);
var inst_123316 = (state_123369[(8)]);
var inst_123312 = (state_123369[(9)]);
var inst_123335 = (state_123369[(15)]);
var inst_123314 = (state_123369[(10)]);
var inst_123315 = (state_123369[(11)]);
var inst_123333 = (state_123369[(16)]);
var inst_123318 = (state_123369[(13)]);
var inst_123333__$1 = (state_123369[(2)]);
var inst_123334 = (function (){var fuel = inst_123312;
var cache = inst_123313;
var curr_block = inst_123314;
var rest_blocks = inst_123315;
var acc = inst_123316;
var flakes = inst_123318;
var asserted = inst_123320;
var asserted_SINGLEQUOTE_ = inst_123333__$1;
return (function (p1__123304_SHARP_){
return p1__123304_SHARP_.op === false;
});
})();
var inst_123335__$1 = cljs.core.filter.call(null,inst_123334,inst_123318);
var inst_123336 = cljs.core.empty_QMARK_.call(null,inst_123335__$1);
var inst_123337 = (!(inst_123336));
var state_123369__$1 = (function (){var statearr_123377 = state_123369;
(statearr_123377[(15)] = inst_123335__$1);

(statearr_123377[(16)] = inst_123333__$1);

return statearr_123377;
})();
if(inst_123337){
var statearr_123378_123399 = state_123369__$1;
(statearr_123378_123399[(1)] = (8));

} else {
var statearr_123379_123400 = state_123369__$1;
(statearr_123379_123400[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123370 === (3))){
var inst_123367 = (state_123369[(2)]);
var state_123369__$1 = state_123369;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_123369__$1,inst_123367);
} else {
if((state_val_123370 === (12))){
var inst_123313 = (state_123369[(7)]);
var inst_123312 = (state_123369[(9)]);
var inst_123357 = (state_123369[(14)]);
var inst_123315 = (state_123369[(11)]);
var inst_123360 = cljs.core.first.call(null,inst_123315);
var inst_123361 = cljs.core.rest.call(null,inst_123315);
var tmp123375 = inst_123313;
var tmp123376 = inst_123312;
var inst_123312__$1 = tmp123376;
var inst_123313__$1 = tmp123375;
var inst_123314 = inst_123360;
var inst_123315__$1 = inst_123361;
var inst_123316 = inst_123357;
var state_123369__$1 = (function (){var statearr_123380 = state_123369;
(statearr_123380[(7)] = inst_123313__$1);

(statearr_123380[(8)] = inst_123316);

(statearr_123380[(9)] = inst_123312__$1);

(statearr_123380[(10)] = inst_123314);

(statearr_123380[(11)] = inst_123315__$1);

return statearr_123380;
})();
var statearr_123381_123401 = state_123369__$1;
(statearr_123381_123401[(2)] = null);

(statearr_123381_123401[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123370 === (2))){
var inst_123320 = (state_123369[(12)]);
var inst_123313 = (state_123369[(7)]);
var inst_123316 = (state_123369[(8)]);
var inst_123312 = (state_123369[(9)]);
var inst_123314 = (state_123369[(10)]);
var inst_123315 = (state_123369[(11)]);
var inst_123318 = (state_123369[(13)]);
var inst_123318__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_123314);
var inst_123319 = (function (){var fuel = inst_123312;
var cache = inst_123313;
var curr_block = inst_123314;
var rest_blocks = inst_123315;
var acc = inst_123316;
var flakes = inst_123318__$1;
return (function (p1__123302_SHARP_){
return p1__123302_SHARP_.op;
});
})();
var inst_123320__$1 = cljs.core.filter.call(null,inst_123319,inst_123318__$1);
var inst_123321 = cljs.core.empty_QMARK_.call(null,inst_123320__$1);
var inst_123322 = (!(inst_123321));
var state_123369__$1 = (function (){var statearr_123382 = state_123369;
(statearr_123382[(12)] = inst_123320__$1);

(statearr_123382[(13)] = inst_123318__$1);

return statearr_123382;
})();
if(inst_123322){
var statearr_123383_123402 = state_123369__$1;
(statearr_123383_123402[(1)] = (4));

} else {
var statearr_123384_123403 = state_123369__$1;
(statearr_123384_123403[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123370 === (11))){
var inst_123345 = (state_123369[(2)]);
var inst_123346 = fluree.db.util.async.throw_err.call(null,inst_123345);
var state_123369__$1 = state_123369;
var statearr_123385_123404 = state_123369__$1;
(statearr_123385_123404[(2)] = inst_123346);

(statearr_123385_123404[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123370 === (9))){
var state_123369__$1 = state_123369;
var statearr_123386_123405 = state_123369__$1;
(statearr_123386_123405[(2)] = null);

(statearr_123386_123405[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123370 === (5))){
var state_123369__$1 = state_123369;
var statearr_123387_123406 = state_123369__$1;
(statearr_123387_123406[(2)] = null);

(statearr_123387_123406[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123370 === (14))){
var inst_123365 = (state_123369[(2)]);
var state_123369__$1 = state_123369;
var statearr_123388_123407 = state_123369__$1;
(statearr_123388_123407[(2)] = inst_123365);

(statearr_123388_123407[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123370 === (10))){
var inst_123316 = (state_123369[(8)]);
var inst_123314 = (state_123369[(10)]);
var inst_123315 = (state_123369[(11)]);
var inst_123333 = (state_123369[(16)]);
var inst_123349 = (state_123369[(2)]);
var inst_123350 = [new cljs.core.Keyword(null,"asserted","asserted",-1558973611),new cljs.core.Keyword(null,"retracted","retracted",-1399687854)];
var inst_123351 = [inst_123333,inst_123349];
var inst_123352 = cljs.core.PersistentHashMap.fromArrays(inst_123350,inst_123351);
var inst_123353 = cljs.core.assoc.call(null,inst_123314,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_123352);
var inst_123354 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_123355 = [inst_123353];
var inst_123356 = (new cljs.core.PersistentVector(null,1,(5),inst_123354,inst_123355,null));
var inst_123357 = cljs.core.concat.call(null,inst_123316,inst_123356);
var inst_123358 = cljs.core.first.call(null,inst_123315);
var state_123369__$1 = (function (){var statearr_123389 = state_123369;
(statearr_123389[(14)] = inst_123357);

return statearr_123389;
})();
if(cljs.core.truth_(inst_123358)){
var statearr_123390_123408 = state_123369__$1;
(statearr_123390_123408[(1)] = (12));

} else {
var statearr_123391_123409 = state_123369__$1;
(statearr_123391_123409[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123370 === (8))){
var inst_123320 = (state_123369[(12)]);
var inst_123313 = (state_123369[(7)]);
var inst_123316 = (state_123369[(8)]);
var inst_123312 = (state_123369[(9)]);
var inst_123335 = (state_123369[(15)]);
var inst_123314 = (state_123369[(10)]);
var inst_123315 = (state_123369[(11)]);
var inst_123333 = (state_123369[(16)]);
var inst_123318 = (state_123369[(13)]);
var inst_123339 = (function (){var flakes = inst_123318;
var rest_blocks = inst_123315;
var curr_block = inst_123314;
var asserted_SINGLEQUOTE_ = inst_123333;
var acc = inst_123316;
var fuel = inst_123312;
var cache = inst_123313;
var retracted = inst_123335;
var asserted = inst_123320;
return (function (p1__123305_SHARP_){
return p1__123305_SHARP_.s;
});
})();
var inst_123340 = cljs.core.map.call(null,fluree.db.flake.flip_flake,inst_123335);
var inst_123341 = cljs.core.group_by.call(null,inst_123339,inst_123340);
var inst_123342 = cljs.core.vals.call(null,inst_123341);
var inst_123343 = fluree.db.api_js.format_flake_groups_pretty.call(null,db,inst_123313,inst_123312,inst_123342);
var state_123369__$1 = state_123369;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_123369__$1,(11),inst_123343);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__99975__auto__ = null;
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__99975__auto____0 = (function (){
var statearr_123392 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_123392[(0)] = fluree$db$api_js$format_block_resp_pretty_$_state_machine__99975__auto__);

(statearr_123392[(1)] = (1));

return statearr_123392;
});
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__99975__auto____1 = (function (state_123369){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_123369);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e123393){if((e123393 instanceof Object)){
var ex__99978__auto__ = e123393;
var statearr_123394_123410 = state_123369;
(statearr_123394_123410[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_123369);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e123393;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__123411 = state_123369;
state_123369 = G__123411;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$api_js$format_block_resp_pretty_$_state_machine__99975__auto__ = function(state_123369){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__99975__auto____1.call(this,state_123369);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_block_resp_pretty_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__99975__auto____0;
fluree$db$api_js$format_block_resp_pretty_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__99975__auto____1;
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_123395 = f__100070__auto__.call(null);
(statearr_123395[(6)] = c__100069__auto__);

return statearr_123395;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
fluree.db.api_js.format_history_resp = (function fluree$db$api_js$format_history_resp(db,resp){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_123506){
var state_val_123507 = (state_123506[(1)]);
if((state_val_123507 === (7))){
var inst_123501 = (state_123506[(2)]);
var inst_123502 = cljs.core.vals.call(null,inst_123501);
var state_123506__$1 = state_123506;
var statearr_123508_123538 = state_123506__$1;
(statearr_123508_123538[(2)] = inst_123502);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_123506__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123507 === (1))){
var state_123506__$1 = state_123506;
var statearr_123509_123539 = state_123506__$1;
(statearr_123509_123539[(2)] = null);

(statearr_123509_123539[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123507 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_123506,(3),Error,null,(2));
var inst_123417 = (function (){return (function (p1__123412_SHARP_){
return p1__123412_SHARP_.t;
});
})();
var inst_123418 = cljs.core.map.call(null,inst_123417,resp);
var inst_123419 = cljs.core.set.call(null,inst_123418);
var inst_123455 = cljs.core.async.chan.call(null,(1));
var inst_123456 = (function (){var ts = inst_123419;
var c__100069__auto____$1 = inst_123455;
return (function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_123453){
var state_val_123454 = (state_123453[(1)]);
if((state_val_123454 === (1))){
var inst_123427 = cljs.core.seq.call(null,ts);
var inst_123428 = cljs.core.first.call(null,inst_123427);
var inst_123429 = cljs.core.next.call(null,inst_123427);
var inst_123430 = cljs.core.PersistentHashMap.EMPTY;
var inst_123431 = ts;
var inst_123432 = inst_123430;
var state_123453__$1 = (function (){var statearr_123510 = state_123453;
(statearr_123510[(7)] = inst_123431);

(statearr_123510[(8)] = inst_123428);

(statearr_123510[(9)] = inst_123429);

(statearr_123510[(10)] = inst_123432);

return statearr_123510;
})();
var statearr_123511_123540 = state_123453__$1;
(statearr_123511_123540[(2)] = null);

(statearr_123511_123540[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123454 === (2))){
var inst_123431 = (state_123453[(7)]);
var inst_123438 = (state_123453[(11)]);
var inst_123437 = cljs.core.seq.call(null,inst_123431);
var inst_123438__$1 = cljs.core.first.call(null,inst_123437);
var inst_123439 = cljs.core.next.call(null,inst_123437);
var state_123453__$1 = (function (){var statearr_123512 = state_123453;
(statearr_123512[(12)] = inst_123439);

(statearr_123512[(11)] = inst_123438__$1);

return statearr_123512;
})();
if(cljs.core.truth_(inst_123438__$1)){
var statearr_123513_123541 = state_123453__$1;
(statearr_123513_123541[(1)] = (4));

} else {
var statearr_123514_123542 = state_123453__$1;
(statearr_123514_123542[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123454 === (3))){
var inst_123451 = (state_123453[(2)]);
var state_123453__$1 = state_123453;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_123453__$1,inst_123451);
} else {
if((state_val_123454 === (4))){
var inst_123438 = (state_123453[(11)]);
var inst_123441 = fluree.db.time_travel.non_border_t_to_block.call(null,db,inst_123438);
var state_123453__$1 = state_123453;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_123453__$1,(7),inst_123441);
} else {
if((state_val_123454 === (5))){
var inst_123432 = (state_123453[(10)]);
var state_123453__$1 = state_123453;
var statearr_123515_123543 = state_123453__$1;
(statearr_123515_123543[(2)] = inst_123432);

(statearr_123515_123543[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123454 === (6))){
var inst_123449 = (state_123453[(2)]);
var state_123453__$1 = state_123453;
var statearr_123516_123544 = state_123453__$1;
(statearr_123516_123544[(2)] = inst_123449);

(statearr_123516_123544[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123454 === (7))){
var inst_123439 = (state_123453[(12)]);
var inst_123432 = (state_123453[(10)]);
var inst_123438 = (state_123453[(11)]);
var inst_123443 = (state_123453[(2)]);
var inst_123444 = fluree.db.util.async.throw_err.call(null,inst_123443);
var inst_123445 = cljs.core.assoc.call(null,inst_123432,inst_123438,inst_123444);
var inst_123431 = inst_123439;
var inst_123432__$1 = inst_123445;
var state_123453__$1 = (function (){var statearr_123517 = state_123453;
(statearr_123517[(7)] = inst_123431);

(statearr_123517[(10)] = inst_123432__$1);

return statearr_123517;
})();
var statearr_123518_123545 = state_123453__$1;
(statearr_123518_123545[(2)] = null);

(statearr_123518_123545[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__99975__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__99975__auto____0 = (function (){
var statearr_123519 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_123519[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__99975__auto__);

(statearr_123519[(1)] = (1));

return statearr_123519;
});
var fluree$db$api_js$format_history_resp_$_state_machine__99975__auto____1 = (function (state_123453){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_123453);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e123520){if((e123520 instanceof Object)){
var ex__99978__auto__ = e123520;
var statearr_123521_123546 = state_123453;
(statearr_123521_123546[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_123453);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e123520;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__123547 = state_123453;
state_123453 = G__123547;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__99975__auto__ = function(state_123453){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__99975__auto____1.call(this,state_123453);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__99975__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__99975__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_123522 = f__100070__auto__.call(null);
(statearr_123522[(6)] = c__100069__auto____$1);

return statearr_123522;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
});
})();
var inst_123457 = cljs.core.async.impl.dispatch.run.call(null,inst_123456);
var state_123506__$1 = (function (){var statearr_123523 = state_123506;
(statearr_123523[(7)] = inst_123457);

return statearr_123523;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_123506__$1,(5),inst_123455);
} else {
if((state_val_123507 === (6))){
var inst_123472 = (state_123506[(8)]);
var inst_123479 = (state_123506[(9)]);
var inst_123478 = cljs.core.seq.call(null,inst_123472);
var inst_123479__$1 = cljs.core.first.call(null,inst_123478);
var inst_123480 = cljs.core.next.call(null,inst_123478);
var state_123506__$1 = (function (){var statearr_123524 = state_123506;
(statearr_123524[(9)] = inst_123479__$1);

(statearr_123524[(10)] = inst_123480);

return statearr_123524;
})();
if(cljs.core.truth_(inst_123479__$1)){
var statearr_123525_123548 = state_123506__$1;
(statearr_123525_123548[(1)] = (8));

} else {
var statearr_123526_123549 = state_123506__$1;
(statearr_123526_123549[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123507 === (3))){
var inst_123413 = (state_123506[(2)]);
var state_123506__$1 = state_123506;
var statearr_123527_123550 = state_123506__$1;
(statearr_123527_123550[(2)] = inst_123413);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_123506__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123507 === (2))){
var inst_123504 = (state_123506[(2)]);
var state_123506__$1 = state_123506;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_123506__$1,inst_123504);
} else {
if((state_val_123507 === (9))){
var inst_123473 = (state_123506[(11)]);
var state_123506__$1 = state_123506;
var statearr_123528_123551 = state_123506__$1;
(statearr_123528_123551[(2)] = inst_123473);

(statearr_123528_123551[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123507 === (5))){
var inst_123459 = (state_123506[(2)]);
var inst_123460 = fluree.db.util.async.throw_err.call(null,inst_123459);
var inst_123468 = cljs.core.seq.call(null,resp);
var inst_123469 = cljs.core.first.call(null,inst_123468);
var inst_123470 = cljs.core.next.call(null,inst_123468);
var inst_123471 = cljs.core.PersistentHashMap.EMPTY;
var inst_123472 = resp;
var inst_123473 = inst_123471;
var state_123506__$1 = (function (){var statearr_123529 = state_123506;
(statearr_123529[(8)] = inst_123472);

(statearr_123529[(12)] = inst_123460);

(statearr_123529[(13)] = inst_123470);

(statearr_123529[(11)] = inst_123473);

(statearr_123529[(14)] = inst_123469);

return statearr_123529;
})();
var statearr_123530_123552 = state_123506__$1;
(statearr_123530_123552[(2)] = null);

(statearr_123530_123552[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123507 === (10))){
var inst_123499 = (state_123506[(2)]);
var state_123506__$1 = state_123506;
var statearr_123531_123553 = state_123506__$1;
(statearr_123531_123553[(2)] = inst_123499);

(statearr_123531_123553[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123507 === (8))){
var inst_123479 = (state_123506[(9)]);
var inst_123460 = (state_123506[(12)]);
var inst_123473 = (state_123506[(11)]);
var inst_123480 = (state_123506[(10)]);
var inst_123482 = inst_123479.t;
var inst_123483 = cljs.core.get.call(null,inst_123460,inst_123482);
var inst_123484 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_123485 = [inst_123483,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_123486 = (new cljs.core.PersistentVector(null,2,(5),inst_123484,inst_123485,null));
var inst_123487 = cljs.core.assoc_in.call(null,inst_123473,inst_123486,inst_123483);
var inst_123488 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_123489 = [inst_123483,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_123490 = (new cljs.core.PersistentVector(null,2,(5),inst_123488,inst_123489,null));
var inst_123491 = cljs.core.update_in.call(null,inst_123487,inst_123490,cljs.core.conj,inst_123479);
var inst_123492 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_123493 = [inst_123483,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_123494 = (new cljs.core.PersistentVector(null,2,(5),inst_123492,inst_123493,null));
var inst_123495 = cljs.core.update_in.call(null,inst_123491,inst_123494,fluree.db.api_js.min_safe,inst_123482);
var inst_123472 = inst_123480;
var inst_123473__$1 = inst_123495;
var state_123506__$1 = (function (){var statearr_123532 = state_123506;
(statearr_123532[(8)] = inst_123472);

(statearr_123532[(11)] = inst_123473__$1);

return statearr_123532;
})();
var statearr_123533_123554 = state_123506__$1;
(statearr_123533_123554[(2)] = null);

(statearr_123533_123554[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__99975__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__99975__auto____0 = (function (){
var statearr_123534 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_123534[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__99975__auto__);

(statearr_123534[(1)] = (1));

return statearr_123534;
});
var fluree$db$api_js$format_history_resp_$_state_machine__99975__auto____1 = (function (state_123506){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_123506);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e123535){if((e123535 instanceof Object)){
var ex__99978__auto__ = e123535;
var statearr_123536_123555 = state_123506;
(statearr_123536_123555[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_123506);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e123535;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__123556 = state_123506;
state_123506 = G__123556;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__99975__auto__ = function(state_123506){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__99975__auto____1.call(this,state_123506);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__99975__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__99975__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_123537 = f__100070__auto__.call(null);
(statearr_123537[(6)] = c__100069__auto__);

return statearr_123537;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Returns an asynchronous channel that eventually contains the start and end block for a query
 *   or an error.
 */
fluree.db.api_js.resolve_block_range = (function fluree$db$api_js$resolve_block_range(db,query_map){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_123695){
var state_val_123696 = (state_123695[(1)]);
if((state_val_123696 === (7))){
var inst_123585 = (state_123695[(7)]);
var inst_123585__$1 = (state_123695[(2)]);
var inst_123586 = cljs.core.some.call(null,cljs.core.string_QMARK_,inst_123585__$1);
var state_123695__$1 = (function (){var statearr_123697 = state_123695;
(statearr_123697[(7)] = inst_123585__$1);

return statearr_123697;
})();
if(cljs.core.truth_(inst_123586)){
var statearr_123698_123757 = state_123695__$1;
(statearr_123698_123757[(1)] = (8));

} else {
var statearr_123699_123758 = state_123695__$1;
(statearr_123699_123758[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123696 === (20))){
var inst_123608 = (state_123695[(8)]);
var state_123695__$1 = state_123695;
var statearr_123700_123759 = state_123695__$1;
(statearr_123700_123759[(2)] = inst_123608);

(statearr_123700_123759[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123696 === (27))){
var inst_123651 = (state_123695[(2)]);
var state_123695__$1 = state_123695;
var statearr_123701_123760 = state_123695__$1;
(statearr_123701_123760[(2)] = inst_123651);

(statearr_123701_123760[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123696 === (1))){
var state_123695__$1 = state_123695;
var statearr_123702_123761 = state_123695__$1;
(statearr_123702_123761[(2)] = null);

(statearr_123702_123761[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123696 === (24))){
var inst_123655 = (state_123695[(9)]);
var inst_123654 = (state_123695[(10)]);
var inst_123653 = (state_123695[(2)]);
var inst_123654__$1 = cljs.core.nth.call(null,inst_123653,(0),null);
var inst_123655__$1 = cljs.core.nth.call(null,inst_123653,(1),null);
var inst_123656 = cljs.core.pos_int_QMARK_.call(null,inst_123654__$1);
var inst_123657 = cljs.core.pos_int_QMARK_.call(null,inst_123655__$1);
var inst_123658 = ((inst_123656) && (inst_123657));
var inst_123659 = cljs.core.not.call(null,inst_123658);
var state_123695__$1 = (function (){var statearr_123703 = state_123695;
(statearr_123703[(9)] = inst_123655__$1);

(statearr_123703[(10)] = inst_123654__$1);

return statearr_123703;
})();
if(inst_123659){
var statearr_123704_123762 = state_123695__$1;
(statearr_123704_123762[(1)] = (31));

} else {
var statearr_123705_123763 = state_123695__$1;
(statearr_123705_123763[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123696 === (39))){
var inst_123682 = (state_123695[(11)]);
var inst_123688 = (state_123695[(2)]);
var inst_123689 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_123690 = [inst_123682,inst_123688];
var inst_123691 = (new cljs.core.PersistentVector(null,2,(5),inst_123689,inst_123690,null));
var state_123695__$1 = state_123695;
var statearr_123706_123764 = state_123695__$1;
(statearr_123706_123764[(2)] = inst_123691);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_123695__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123696 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_123695,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var inst_123574 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_123575 = cljs.core.sequential_QMARK_.call(null,inst_123574);
var state_123695__$1 = state_123695;
if(inst_123575){
var statearr_123707_123765 = state_123695__$1;
(statearr_123707_123765[(1)] = (5));

} else {
var statearr_123708_123766 = state_123695__$1;
(statearr_123708_123766[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123696 === (15))){
var inst_123598 = (state_123695[(2)]);
var inst_123599 = fluree.db.util.async.throw_err.call(null,inst_123598);
var state_123695__$1 = state_123695;
var statearr_123709_123767 = state_123695__$1;
(statearr_123709_123767[(2)] = inst_123599);

(statearr_123709_123767[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123696 === (21))){
var inst_123627 = (state_123695[(2)]);
var state_123695__$1 = state_123695;
if(cljs.core.truth_(inst_123627)){
var statearr_123710_123768 = state_123695__$1;
(statearr_123710_123768[(1)] = (22));

} else {
var statearr_123711_123769 = state_123695__$1;
(statearr_123711_123769[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123696 === (31))){
var inst_123585 = (state_123695[(7)]);
var inst_123661 = cljs.core.pr_str.call(null,inst_123585);
var inst_123662 = ["Invalid block range provided: ",inst_123661].join('');
var inst_123663 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_123664 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_123665 = cljs.core.PersistentHashMap.fromArrays(inst_123663,inst_123664);
var inst_123666 = cljs.core.ex_info.call(null,inst_123662,inst_123665);
var inst_123667 = (function(){throw inst_123666})();
var state_123695__$1 = state_123695;
var statearr_123712_123770 = state_123695__$1;
(statearr_123712_123770[(2)] = inst_123667);

(statearr_123712_123770[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123696 === (32))){
var state_123695__$1 = state_123695;
var statearr_123713_123771 = state_123695__$1;
(statearr_123713_123771[(2)] = null);

(statearr_123713_123771[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123696 === (33))){
var inst_123655 = (state_123695[(9)]);
var inst_123654 = (state_123695[(10)]);
var inst_123670 = (state_123695[(2)]);
var inst_123671 = (inst_123655 < inst_123654);
var state_123695__$1 = (function (){var statearr_123714 = state_123695;
(statearr_123714[(12)] = inst_123670);

return statearr_123714;
})();
if(cljs.core.truth_(inst_123671)){
var statearr_123715_123772 = state_123695__$1;
(statearr_123715_123772[(1)] = (34));

} else {
var statearr_123716_123773 = state_123695__$1;
(statearr_123716_123773[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123696 === (13))){
var state_123695__$1 = state_123695;
var statearr_123717_123774 = state_123695__$1;
(statearr_123717_123774[(2)] = null);

(statearr_123717_123774[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123696 === (22))){
var inst_123608 = (state_123695[(8)]);
var inst_123609 = (state_123695[(13)]);
var inst_123629 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_123630 = [inst_123608,inst_123609];
var inst_123631 = (new cljs.core.PersistentVector(null,2,(5),inst_123629,inst_123630,null));
var state_123695__$1 = state_123695;
var statearr_123718_123775 = state_123695__$1;
(statearr_123718_123775[(2)] = inst_123631);

(statearr_123718_123775[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123696 === (36))){
var inst_123610 = (state_123695[(14)]);
var inst_123683 = (state_123695[(15)]);
var inst_123681 = (state_123695[(2)]);
var inst_123682 = cljs.core.nth.call(null,inst_123681,(0),null);
var inst_123683__$1 = cljs.core.nth.call(null,inst_123681,(1),null);
var inst_123684 = (inst_123683__$1 > inst_123610);
var state_123695__$1 = (function (){var statearr_123719 = state_123695;
(statearr_123719[(11)] = inst_123682);

(statearr_123719[(15)] = inst_123683__$1);

return statearr_123719;
})();
if(cljs.core.truth_(inst_123684)){
var statearr_123720_123776 = state_123695__$1;
(statearr_123720_123776[(1)] = (37));

} else {
var statearr_123721_123777 = state_123695__$1;
(statearr_123721_123777[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123696 === (29))){
var state_123695__$1 = state_123695;
var statearr_123722_123778 = state_123695__$1;
(statearr_123722_123778[(2)] = null);

(statearr_123722_123778[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123696 === (6))){
var inst_123579 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_123580 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_123581 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_123582 = [inst_123580,inst_123581];
var inst_123583 = (new cljs.core.PersistentVector(null,2,(5),inst_123579,inst_123582,null));
var state_123695__$1 = state_123695;
var statearr_123723_123779 = state_123695__$1;
(statearr_123723_123779[(2)] = inst_123583);

(statearr_123723_123779[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123696 === (28))){
var inst_123585 = (state_123695[(7)]);
var inst_123640 = cljs.core.pr_str.call(null,inst_123585);
var inst_123641 = ["Invalid block range provided: ",inst_123640].join('');
var inst_123642 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_123643 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_123644 = cljs.core.PersistentHashMap.fromArrays(inst_123642,inst_123643);
var inst_123645 = cljs.core.ex_info.call(null,inst_123641,inst_123644);
var inst_123646 = (function(){throw inst_123645})();
var state_123695__$1 = state_123695;
var statearr_123724_123780 = state_123695__$1;
(statearr_123724_123780[(2)] = inst_123646);

(statearr_123724_123780[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123696 === (25))){
var inst_123608 = (state_123695[(8)]);
var inst_123634 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_123635 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_123636 = [inst_123608,inst_123635];
var inst_123637 = (new cljs.core.PersistentVector(null,2,(5),inst_123634,inst_123636,null));
var state_123695__$1 = state_123695;
var statearr_123725_123781 = state_123695__$1;
(statearr_123725_123781[(2)] = inst_123637);

(statearr_123725_123781[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123696 === (34))){
var inst_123655 = (state_123695[(9)]);
var inst_123654 = (state_123695[(10)]);
var inst_123673 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_123674 = [inst_123655,inst_123654];
var inst_123675 = (new cljs.core.PersistentVector(null,2,(5),inst_123673,inst_123674,null));
var state_123695__$1 = state_123695;
var statearr_123726_123782 = state_123695__$1;
(statearr_123726_123782[(2)] = inst_123675);

(statearr_123726_123782[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123696 === (17))){
var state_123695__$1 = state_123695;
var statearr_123727_123783 = state_123695__$1;
(statearr_123727_123783[(2)] = null);

(statearr_123727_123783[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123696 === (3))){
var inst_123557 = (state_123695[(2)]);
var inst_123558 = fluree.db.util.log.error.call(null,inst_123557);
var inst_123559 = cljs.core.ex_data.call(null,inst_123557);
var inst_123560 = cljs.core.ex_message.call(null,inst_123557);
var inst_123561 = cljs.core.assoc.call(null,inst_123559,new cljs.core.Keyword(null,"message","message",-406056002),inst_123560);
var state_123695__$1 = (function (){var statearr_123728 = state_123695;
(statearr_123728[(16)] = inst_123558);

return statearr_123728;
})();
var statearr_123729_123784 = state_123695__$1;
(statearr_123729_123784[(2)] = inst_123561);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_123695__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123696 === (12))){
var inst_123594 = (state_123695[(17)]);
var inst_123596 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_123594);
var state_123695__$1 = state_123695;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_123695__$1,(15),inst_123596);
} else {
if((state_val_123696 === (2))){
var inst_123693 = (state_123695[(2)]);
var state_123695__$1 = state_123695;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_123695__$1,inst_123693);
} else {
if((state_val_123696 === (23))){
var inst_123608 = (state_123695[(8)]);
var state_123695__$1 = state_123695;
if(cljs.core.truth_(inst_123608)){
var statearr_123730_123785 = state_123695__$1;
(statearr_123730_123785[(1)] = (25));

} else {
var statearr_123731_123786 = state_123695__$1;
(statearr_123731_123786[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123696 === (35))){
var inst_123655 = (state_123695[(9)]);
var inst_123654 = (state_123695[(10)]);
var inst_123677 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_123678 = [inst_123654,inst_123655];
var inst_123679 = (new cljs.core.PersistentVector(null,2,(5),inst_123677,inst_123678,null));
var state_123695__$1 = state_123695;
var statearr_123732_123787 = state_123695__$1;
(statearr_123732_123787[(2)] = inst_123679);

(statearr_123732_123787[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123696 === (19))){
var inst_123609 = (state_123695[(13)]);
var state_123695__$1 = state_123695;
var statearr_123733_123788 = state_123695__$1;
(statearr_123733_123788[(2)] = inst_123609);

(statearr_123733_123788[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123696 === (11))){
var inst_123585 = (state_123695[(7)]);
var inst_123594 = (state_123695[(17)]);
var inst_123592 = (state_123695[(2)]);
var inst_123593 = fluree.db.util.async.throw_err.call(null,inst_123592);
var inst_123594__$1 = cljs.core.second.call(null,inst_123585);
var state_123695__$1 = (function (){var statearr_123734 = state_123695;
(statearr_123734[(18)] = inst_123593);

(statearr_123734[(17)] = inst_123594__$1);

return statearr_123734;
})();
if(cljs.core.truth_(inst_123594__$1)){
var statearr_123735_123789 = state_123695__$1;
(statearr_123735_123789[(1)] = (12));

} else {
var statearr_123736_123790 = state_123695__$1;
(statearr_123736_123790[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123696 === (9))){
var inst_123585 = (state_123695[(7)]);
var state_123695__$1 = state_123695;
var statearr_123737_123791 = state_123695__$1;
(statearr_123737_123791[(2)] = inst_123585);

(statearr_123737_123791[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123696 === (5))){
var inst_123577 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_123695__$1 = state_123695;
var statearr_123738_123792 = state_123695__$1;
(statearr_123738_123792[(2)] = inst_123577);

(statearr_123738_123792[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123696 === (14))){
var inst_123588 = (state_123695[(19)]);
var inst_123593 = (state_123695[(18)]);
var inst_123602 = (state_123695[(2)]);
var inst_123603 = [inst_123593,inst_123602];
var inst_123604 = (new cljs.core.PersistentVector(null,2,(5),inst_123588,inst_123603,null));
var state_123695__$1 = state_123695;
var statearr_123739_123793 = state_123695__$1;
(statearr_123739_123793[(2)] = inst_123604);

(statearr_123739_123793[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123696 === (26))){
var state_123695__$1 = state_123695;
var statearr_123740_123794 = state_123695__$1;
(statearr_123740_123794[(1)] = (28));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123696 === (16))){
var inst_123608 = (state_123695[(8)]);
var inst_123610 = (state_123695[(14)]);
var inst_123613 = cljs.core.pr_str.call(null,inst_123608);
var inst_123614 = cljs.core.pr_str.call(null,inst_123610);
var inst_123615 = ["Start block is out of range for this ledger. Start block provided: ",inst_123613,". Database block: ",inst_123614].join('');
var inst_123616 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_123617 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_123618 = cljs.core.PersistentHashMap.fromArrays(inst_123616,inst_123617);
var inst_123619 = cljs.core.ex_info.call(null,inst_123615,inst_123618);
var inst_123620 = (function(){throw inst_123619})();
var state_123695__$1 = state_123695;
var statearr_123742_123795 = state_123695__$1;
(statearr_123742_123795[(2)] = inst_123620);

(statearr_123742_123795[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123696 === (38))){
var inst_123683 = (state_123695[(15)]);
var state_123695__$1 = state_123695;
var statearr_123743_123796 = state_123695__$1;
(statearr_123743_123796[(2)] = inst_123683);

(statearr_123743_123796[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123696 === (30))){
var inst_123649 = (state_123695[(2)]);
var state_123695__$1 = state_123695;
var statearr_123744_123797 = state_123695__$1;
(statearr_123744_123797[(2)] = inst_123649);

(statearr_123744_123797[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123696 === (10))){
var inst_123608 = (state_123695[(8)]);
var inst_123610 = (state_123695[(14)]);
var inst_123607 = (state_123695[(2)]);
var inst_123608__$1 = cljs.core.nth.call(null,inst_123607,(0),null);
var inst_123609 = cljs.core.nth.call(null,inst_123607,(1),null);
var inst_123610__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_123611 = (inst_123608__$1 > inst_123610__$1);
var state_123695__$1 = (function (){var statearr_123745 = state_123695;
(statearr_123745[(8)] = inst_123608__$1);

(statearr_123745[(14)] = inst_123610__$1);

(statearr_123745[(13)] = inst_123609);

return statearr_123745;
})();
if(cljs.core.truth_(inst_123611)){
var statearr_123746_123798 = state_123695__$1;
(statearr_123746_123798[(1)] = (16));

} else {
var statearr_123747_123799 = state_123695__$1;
(statearr_123747_123799[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123696 === (18))){
var inst_123608 = (state_123695[(8)]);
var inst_123623 = (state_123695[(2)]);
var state_123695__$1 = (function (){var statearr_123748 = state_123695;
(statearr_123748[(20)] = inst_123623);

return statearr_123748;
})();
if(cljs.core.truth_(inst_123608)){
var statearr_123749_123800 = state_123695__$1;
(statearr_123749_123800[(1)] = (19));

} else {
var statearr_123750_123801 = state_123695__$1;
(statearr_123750_123801[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123696 === (37))){
var inst_123610 = (state_123695[(14)]);
var state_123695__$1 = state_123695;
var statearr_123751_123802 = state_123695__$1;
(statearr_123751_123802[(2)] = inst_123610);

(statearr_123751_123802[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123696 === (8))){
var inst_123585 = (state_123695[(7)]);
var inst_123588 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_123589 = cljs.core.first.call(null,inst_123585);
var inst_123590 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_123589);
var state_123695__$1 = (function (){var statearr_123752 = state_123695;
(statearr_123752[(19)] = inst_123588);

return statearr_123752;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_123695__$1,(11),inst_123590);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$resolve_block_range_$_state_machine__99975__auto__ = null;
var fluree$db$api_js$resolve_block_range_$_state_machine__99975__auto____0 = (function (){
var statearr_123753 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_123753[(0)] = fluree$db$api_js$resolve_block_range_$_state_machine__99975__auto__);

(statearr_123753[(1)] = (1));

return statearr_123753;
});
var fluree$db$api_js$resolve_block_range_$_state_machine__99975__auto____1 = (function (state_123695){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_123695);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e123754){if((e123754 instanceof Object)){
var ex__99978__auto__ = e123754;
var statearr_123755_123803 = state_123695;
(statearr_123755_123803[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_123695);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e123754;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__123804 = state_123695;
state_123695 = G__123804;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$api_js$resolve_block_range_$_state_machine__99975__auto__ = function(state_123695){
switch(arguments.length){
case 0:
return fluree$db$api_js$resolve_block_range_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$api_js$resolve_block_range_$_state_machine__99975__auto____1.call(this,state_123695);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$resolve_block_range_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$resolve_block_range_$_state_machine__99975__auto____0;
fluree$db$api_js$resolve_block_range_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$resolve_block_range_$_state_machine__99975__auto____1;
return fluree$db$api_js$resolve_block_range_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_123756 = f__100070__auto__.call(null);
(statearr_123756[(6)] = c__100069__auto__);

return statearr_123756;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Returns an asynchronous channel that eventually returns the results or an error.
 *   
 */
fluree.db.api_js.block_query_async = (function fluree$db$api_js$block_query_async(var_args){
var G__123807 = arguments.length;
switch (G__123807) {
case 2:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
return fluree.db.api_js.block_query_async.call(null,db,query_map,null);
}));

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3 = (function (db,query_map,opts){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_123918){
var state_val_123919 = (state_123918[(1)]);
if((state_val_123919 === (7))){
var inst_123836 = (state_123918[(2)]);
var state_123918__$1 = state_123918;
if(cljs.core.truth_(inst_123836)){
var statearr_123920_123977 = state_123918__$1;
(statearr_123920_123977[(1)] = (11));

} else {
var statearr_123921_123978 = state_123918__$1;
(statearr_123921_123978[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123919 === (20))){
var inst_123847 = (state_123918[(7)]);
var inst_123865 = (state_123918[(2)]);
var inst_123866 = cljs.core.nth.call(null,inst_123847,(0),null);
var inst_123867 = cljs.core.nth.call(null,inst_123847,(1),null);
var inst_123868 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_123869 = cljs.core.dissoc.call(null,query_map,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_123870 = cljs.core.keys.call(null,inst_123869);
var inst_123871 = cljs.core._EQ_.call(null,inst_123868,inst_123870);
var state_123918__$1 = (function (){var statearr_123922 = state_123918;
(statearr_123922[(8)] = inst_123866);

(statearr_123922[(9)] = inst_123865);

(statearr_123922[(10)] = inst_123867);

return statearr_123922;
})();
if(inst_123871){
var statearr_123923_123979 = state_123918__$1;
(statearr_123923_123979[(1)] = (24));

} else {
var statearr_123924_123980 = state_123918__$1;
(statearr_123924_123980[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123919 === (27))){
var inst_123875 = (state_123918[(2)]);
var inst_123876 = fluree.db.util.async.throw_err.call(null,inst_123875);
var state_123918__$1 = state_123918;
var statearr_123925_123981 = state_123918__$1;
(statearr_123925_123981[(2)] = inst_123876);

(statearr_123925_123981[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123919 === (1))){
var state_123918__$1 = state_123918;
var statearr_123926_123982 = state_123918__$1;
(statearr_123926_123982[(2)] = null);

(statearr_123926_123982[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123919 === (24))){
var inst_123866 = (state_123918[(8)]);
var inst_123867 = (state_123918[(10)]);
var inst_123873 = fluree.db.query.block.block_range.call(null,db,inst_123866,inst_123867,opts);
var state_123918__$1 = state_123918;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_123918__$1,(27),inst_123873);
} else {
if((state_val_123919 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_123918,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var inst_123820 = fluree.db.util.core.current_time_millis.call(null);
var inst_123822 = (db == null);
var inst_123823 = cljs.core.not.call(null,inst_123822);
var state_123918__$1 = (function (){var statearr_123927 = state_123918;
(statearr_123927[(11)] = inst_123820);

return statearr_123927;
})();
if(inst_123823){
var statearr_123928_123983 = state_123918__$1;
(statearr_123928_123983[(1)] = (5));

} else {
var statearr_123929_123984 = state_123918__$1;
(statearr_123929_123984[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123919 === (15))){
var inst_123847 = (state_123918[(7)]);
var inst_123850 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_123847);
var state_123918__$1 = state_123918;
var statearr_123930_123985 = state_123918__$1;
(statearr_123930_123985[(2)] = inst_123850);

(statearr_123930_123985[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123919 === (21))){
var inst_123855 = (state_123918[(12)]);
var state_123918__$1 = state_123918;
var statearr_123931_123986 = state_123918__$1;
(statearr_123931_123986[(2)] = inst_123855);

(statearr_123931_123986[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123919 === (31))){
var inst_123891 = (state_123918[(2)]);
var inst_123892 = fluree.db.util.async.throw_err.call(null,inst_123891);
var state_123918__$1 = state_123918;
var statearr_123932_123987 = state_123918__$1;
(statearr_123932_123987[(2)] = inst_123892);

(statearr_123932_123987[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123919 === (32))){
var inst_123895 = (state_123918[(13)]);
var inst_123898 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_123899 = cljs.core.sequential_QMARK_.call(null,inst_123895);
var state_123918__$1 = (function (){var statearr_123933 = state_123918;
(statearr_123933[(14)] = inst_123898);

return statearr_123933;
})();
if(inst_123899){
var statearr_123934_123988 = state_123918__$1;
(statearr_123934_123988[(1)] = (35));

} else {
var statearr_123935_123989 = state_123918__$1;
(statearr_123935_123989[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123919 === (33))){
var inst_123895 = (state_123918[(13)]);
var state_123918__$1 = state_123918;
var statearr_123936_123990 = state_123918__$1;
(statearr_123936_123990[(2)] = inst_123895);

(statearr_123936_123990[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123919 === (13))){
var inst_123841 = (state_123918[(15)]);
var inst_123841__$1 = (state_123918[(2)]);
var inst_123842 = cljs.core.get.call(null,inst_123841__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_123843 = cljs.core.get.call(null,inst_123841__$1,new cljs.core.Keyword(null,"db-id","db-id",747248515));
var inst_123844 = fluree.db.api_js.resolve_block_range.call(null,db,query_map);
var state_123918__$1 = (function (){var statearr_123937 = state_123918;
(statearr_123937[(16)] = inst_123843);

(statearr_123937[(15)] = inst_123841__$1);

(statearr_123937[(17)] = inst_123842);

return statearr_123937;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_123918__$1,(14),inst_123844);
} else {
if((state_val_123919 === (22))){
var inst_123843 = (state_123918[(16)]);
var inst_123842 = (state_123918[(17)]);
var inst_123858 = ["Unknown error attempting to resolve block range for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_123842),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_123843)].join('');
var state_123918__$1 = state_123918;
var statearr_123938_123991 = state_123918__$1;
(statearr_123938_123991[(2)] = inst_123858);

(statearr_123938_123991[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123919 === (36))){
var inst_123895 = (state_123918[(13)]);
var state_123918__$1 = state_123918;
var statearr_123939_123992 = state_123918__$1;
(statearr_123939_123992[(2)] = inst_123895);

(statearr_123939_123992[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123919 === (29))){
var inst_123886 = (state_123918[(18)]);
var state_123918__$1 = state_123918;
var statearr_123940_123993 = state_123918__$1;
(statearr_123940_123993[(2)] = inst_123886);

(statearr_123940_123993[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123919 === (6))){
var state_123918__$1 = state_123918;
var statearr_123941_123994 = state_123918__$1;
(statearr_123941_123994[(2)] = false);

(statearr_123941_123994[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123919 === (28))){
var inst_123886 = (state_123918[(18)]);
var inst_123889 = fluree.db.api_js.format_block_resp_pretty.call(null,db,inst_123886);
var state_123918__$1 = state_123918;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_123918__$1,(31),inst_123889);
} else {
if((state_val_123919 === (25))){
var inst_123878 = cljs.core.pr_str.call(null,query_map);
var inst_123879 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_123878].join('');
var inst_123880 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_123881 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_123882 = cljs.core.PersistentHashMap.fromArrays(inst_123880,inst_123881);
var inst_123883 = cljs.core.ex_info.call(null,inst_123879,inst_123882);
var inst_123884 = (function(){throw inst_123883})();
var state_123918__$1 = state_123918;
var statearr_123942_123995 = state_123918__$1;
(statearr_123942_123995[(2)] = inst_123884);

(statearr_123942_123995[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123919 === (34))){
var inst_123914 = (state_123918[(2)]);
var state_123918__$1 = state_123918;
var statearr_123943_123996 = state_123918__$1;
(statearr_123943_123996[(2)] = inst_123914);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_123918__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123919 === (17))){
var inst_123853 = (state_123918[(2)]);
var state_123918__$1 = state_123918;
if(cljs.core.truth_(inst_123853)){
var statearr_123944_123997 = state_123918__$1;
(statearr_123944_123997[(1)] = (18));

} else {
var statearr_123945_123998 = state_123918__$1;
(statearr_123945_123998[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123919 === (3))){
var inst_123808 = (state_123918[(2)]);
var inst_123809 = fluree.db.util.log.error.call(null,inst_123808);
var inst_123810 = cljs.core.ex_data.call(null,inst_123808);
var inst_123811 = cljs.core.ex_message.call(null,inst_123808);
var inst_123812 = cljs.core.assoc.call(null,inst_123810,new cljs.core.Keyword(null,"message","message",-406056002),inst_123811);
var state_123918__$1 = (function (){var statearr_123946 = state_123918;
(statearr_123946[(19)] = inst_123809);

return statearr_123946;
})();
var statearr_123947_123999 = state_123918__$1;
(statearr_123947_123999[(2)] = inst_123812);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_123918__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123919 === (12))){
var state_123918__$1 = state_123918;
var statearr_123948_124000 = state_123918__$1;
(statearr_123948_124000[(2)] = db);

(statearr_123948_124000[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123919 === (2))){
var inst_123916 = (state_123918[(2)]);
var state_123918__$1 = state_123918;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_123918__$1,inst_123916);
} else {
if((state_val_123919 === (23))){
var inst_123847 = (state_123918[(7)]);
var inst_123860 = (state_123918[(2)]);
var inst_123861 = cljs.core.ex_info.call(null,inst_123860,inst_123847);
var inst_123862 = (function(){throw inst_123861})();
var state_123918__$1 = state_123918;
var statearr_123949_124001 = state_123918__$1;
(statearr_123949_124001[(2)] = inst_123862);

(statearr_123949_124001[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123919 === (35))){
var inst_123895 = (state_123918[(13)]);
var inst_123901 = cljs.core.doall.call(null,inst_123895);
var state_123918__$1 = state_123918;
var statearr_123950_124002 = state_123918__$1;
(statearr_123950_124002[(2)] = inst_123901);

(statearr_123950_124002[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123919 === (19))){
var state_123918__$1 = state_123918;
var statearr_123951_124003 = state_123918__$1;
(statearr_123951_124003[(2)] = null);

(statearr_123951_124003[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123919 === (11))){
var inst_123838 = cljs.core.apply.call(null,cljs.core.hash_map,db);
var state_123918__$1 = state_123918;
var statearr_123952_124004 = state_123918__$1;
(statearr_123952_124004[(2)] = inst_123838);

(statearr_123952_124004[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123919 === (9))){
var state_123918__$1 = state_123918;
var statearr_123953_124005 = state_123918__$1;
(statearr_123953_124005[(2)] = false);

(statearr_123953_124005[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123919 === (5))){
var inst_123825 = db.cljs$lang$protocol_mask$partition0$;
var inst_123826 = (inst_123825 & (64));
var inst_123827 = db.cljs$core$ISeq$;
var inst_123828 = (cljs.core.PROTOCOL_SENTINEL === inst_123827);
var inst_123829 = ((inst_123826) || (inst_123828));
var state_123918__$1 = state_123918;
if(cljs.core.truth_(inst_123829)){
var statearr_123954_124006 = state_123918__$1;
(statearr_123954_124006[(1)] = (8));

} else {
var statearr_123955_124007 = state_123918__$1;
(statearr_123955_124007[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123919 === (14))){
var inst_123847 = (state_123918[(7)]);
var inst_123846 = (state_123918[(2)]);
var inst_123847__$1 = fluree.db.util.async.throw_err.call(null,inst_123846);
var inst_123848 = cljs.core.map_QMARK_.call(null,inst_123847__$1);
var state_123918__$1 = (function (){var statearr_123956 = state_123918;
(statearr_123956[(7)] = inst_123847__$1);

return statearr_123956;
})();
if(inst_123848){
var statearr_123957_124008 = state_123918__$1;
(statearr_123957_124008[(1)] = (15));

} else {
var statearr_123958_124009 = state_123918__$1;
(statearr_123958_124009[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123919 === (26))){
var inst_123886 = (state_123918[(2)]);
var inst_123887 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(query_map);
var state_123918__$1 = (function (){var statearr_123959 = state_123918;
(statearr_123959[(18)] = inst_123886);

return statearr_123959;
})();
if(cljs.core.truth_(inst_123887)){
var statearr_123960_124010 = state_123918__$1;
(statearr_123960_124010[(1)] = (28));

} else {
var statearr_123961_124011 = state_123918__$1;
(statearr_123961_124011[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123919 === (16))){
var state_123918__$1 = state_123918;
var statearr_123962_124012 = state_123918__$1;
(statearr_123962_124012[(2)] = false);

(statearr_123962_124012[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123919 === (30))){
var inst_123895 = (state_123918[(2)]);
var inst_123896 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_123918__$1 = (function (){var statearr_123963 = state_123918;
(statearr_123963[(13)] = inst_123895);

return statearr_123963;
})();
if(cljs.core.truth_(inst_123896)){
var statearr_123964_124013 = state_123918__$1;
(statearr_123964_124013[(1)] = (32));

} else {
var statearr_123965_124014 = state_123918__$1;
(statearr_123965_124014[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123919 === (10))){
var inst_123833 = (state_123918[(2)]);
var state_123918__$1 = state_123918;
var statearr_123966_124015 = state_123918__$1;
(statearr_123966_124015[(2)] = inst_123833);

(statearr_123966_124015[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123919 === (18))){
var inst_123847 = (state_123918[(7)]);
var inst_123855 = (state_123918[(12)]);
var inst_123855__$1 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_123847);
var state_123918__$1 = (function (){var statearr_123967 = state_123918;
(statearr_123967[(12)] = inst_123855__$1);

return statearr_123967;
})();
if(cljs.core.truth_(inst_123855__$1)){
var statearr_123968_124016 = state_123918__$1;
(statearr_123968_124016[(1)] = (21));

} else {
var statearr_123969_124017 = state_123918__$1;
(statearr_123969_124017[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123919 === (37))){
var inst_123898 = (state_123918[(14)]);
var inst_123866 = (state_123918[(8)]);
var inst_123847 = (state_123918[(7)]);
var inst_123820 = (state_123918[(11)]);
var inst_123886 = (state_123918[(18)]);
var inst_123843 = (state_123918[(16)]);
var inst_123865 = (state_123918[(9)]);
var inst_123867 = (state_123918[(10)]);
var inst_123841 = (state_123918[(15)]);
var inst_123895 = (state_123918[(13)]);
var inst_123842 = (state_123918[(17)]);
var inst_123904 = (state_123918[(2)]);
var inst_123905 = (function (){var network = inst_123842;
var block_start = inst_123866;
var map__123816 = inst_123841;
var block_end = inst_123867;
var range = inst_123847;
var vec__123817 = inst_123847;
var db_id = inst_123843;
var _ = inst_123865;
var start = inst_123820;
var result_SINGLEQUOTE_ = inst_123895;
var result = inst_123886;
return (function (p1__123805_SHARP_){
return goog.string.format("%.2fms",p1__123805_SHARP_);
});
})();
var inst_123906 = fluree.db.util.core.current_time_millis.call(null);
var inst_123907 = (inst_123906 - inst_123820);
var inst_123908 = (inst_123907 / (1000000));
var inst_123909 = inst_123905.call(null,inst_123908);
var inst_123910 = [(200),inst_123904,(100),inst_123909];
var inst_123911 = cljs.core.PersistentHashMap.fromArrays(inst_123898,inst_123910);
var state_123918__$1 = state_123918;
var statearr_123970_124018 = state_123918__$1;
(statearr_123970_124018[(2)] = inst_123911);

(statearr_123970_124018[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_123919 === (8))){
var state_123918__$1 = state_123918;
var statearr_123971_124019 = state_123918__$1;
(statearr_123971_124019[(2)] = true);

(statearr_123971_124019[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__99975__auto__ = null;
var fluree$db$api_js$state_machine__99975__auto____0 = (function (){
var statearr_123972 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_123972[(0)] = fluree$db$api_js$state_machine__99975__auto__);

(statearr_123972[(1)] = (1));

return statearr_123972;
});
var fluree$db$api_js$state_machine__99975__auto____1 = (function (state_123918){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_123918);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e123973){if((e123973 instanceof Object)){
var ex__99978__auto__ = e123973;
var statearr_123974_124020 = state_123918;
(statearr_123974_124020[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_123918);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e123973;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__124021 = state_123918;
state_123918 = G__124021;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__99975__auto__ = function(state_123918){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__99975__auto____1.call(this,state_123918);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__99975__auto____0;
fluree$db$api_js$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__99975__auto____1;
return fluree$db$api_js$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_123975 = f__100070__auto__.call(null);
(statearr_123975[(6)] = c__100069__auto__);

return statearr_123975;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.api_js.block_query_async.cljs$lang$maxFixedArity = 3);

fluree.db.api_js.history_query_async = (function fluree$db$api_js$history_query_async(var_args){
var G__124023 = arguments.length;
switch (G__124023) {
case 2:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.history_query_async.call(null,sources,query_map,null);
}));

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,opts){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_124223){
var state_val_124224 = (state_124223[(1)]);
if((state_val_124224 === (7))){
var inst_124040 = (state_124223[(2)]);
var state_124223__$1 = state_124223;
var statearr_124225_124307 = state_124223__$1;
(statearr_124225_124307[(2)] = inst_124040);

(statearr_124225_124307[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124224 === (59))){
var inst_124221 = (state_124223[(2)]);
var state_124223__$1 = state_124223;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_124223__$1,inst_124221);
} else {
if((state_val_124224 === (20))){
var state_124223__$1 = state_124223;
var statearr_124226_124308 = state_124223__$1;
(statearr_124226_124308[(2)] = (-1));

(statearr_124226_124308[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124224 === (58))){
var inst_124213 = (state_124223[(7)]);
var state_124223__$1 = state_124223;
var statearr_124227_124309 = state_124223__$1;
(statearr_124227_124309[(2)] = inst_124213);

(statearr_124227_124309[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124224 === (27))){
var inst_124050 = (state_124223[(8)]);
var inst_124100 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_124101 = [inst_124050];
var inst_124102 = (new cljs.core.PersistentVector(null,1,(5),inst_124100,inst_124101,null));
var state_124223__$1 = state_124223;
var statearr_124228_124310 = state_124223__$1;
(statearr_124228_124310[(2)] = inst_124102);

(statearr_124228_124310[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124224 === (1))){
var inst_124029 = (query_map == null);
var inst_124030 = cljs.core.not.call(null,inst_124029);
var state_124223__$1 = state_124223;
if(inst_124030){
var statearr_124229_124311 = state_124223__$1;
(statearr_124229_124311[(1)] = (2));

} else {
var statearr_124230_124312 = state_124223__$1;
(statearr_124230_124312[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124224 === (24))){
var inst_124054 = (state_124223[(9)]);
var inst_124095 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_124054);
var state_124223__$1 = state_124223;
var statearr_124231_124313 = state_124223__$1;
(statearr_124231_124313[(2)] = inst_124095);

(statearr_124231_124313[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124224 === (55))){
var inst_124071 = (state_124223[(10)]);
var inst_124213 = (state_124223[(2)]);
var state_124223__$1 = (function (){var statearr_124232 = state_124223;
(statearr_124232[(7)] = inst_124213);

return statearr_124232;
})();
if(cljs.core.truth_(inst_124071)){
var statearr_124233_124314 = state_124223__$1;
(statearr_124233_124314[(1)] = (57));

} else {
var statearr_124234_124315 = state_124223__$1;
(statearr_124234_124315[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124224 === (39))){
var inst_124131 = (state_124223[(11)]);
var inst_124146 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_124147 = [inst_124131,new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_124148 = (new cljs.core.PersistentVector(null,2,(5),inst_124146,inst_124147,null));
var state_124223__$1 = state_124223;
var statearr_124235_124316 = state_124223__$1;
(statearr_124235_124316[(2)] = inst_124148);

(statearr_124235_124316[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124224 === (46))){
var state_124223__$1 = state_124223;
var statearr_124236_124317 = state_124223__$1;
(statearr_124236_124317[(1)] = (48));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124224 === (4))){
var inst_124043 = (state_124223[(2)]);
var state_124223__$1 = state_124223;
if(cljs.core.truth_(inst_124043)){
var statearr_124238_124318 = state_124223__$1;
(statearr_124238_124318[(1)] = (8));

} else {
var statearr_124239_124319 = state_124223__$1;
(statearr_124239_124319[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124224 === (54))){
var inst_124205 = (state_124223[(12)]);
var state_124223__$1 = state_124223;
var statearr_124240_124320 = state_124223__$1;
(statearr_124240_124320[(2)] = inst_124205);

(statearr_124240_124320[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124224 === (15))){
var inst_124058 = (state_124223[(2)]);
var inst_124059 = fluree.db.util.async.throw_err.call(null,inst_124058);
var state_124223__$1 = state_124223;
var statearr_124241_124321 = state_124223__$1;
(statearr_124241_124321[(2)] = inst_124059);

(statearr_124241_124321[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124224 === (48))){
var inst_124050 = (state_124223[(8)]);
var inst_124178 = ["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_124050)].join('');
var inst_124179 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_124180 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_124181 = cljs.core.PersistentHashMap.fromArrays(inst_124179,inst_124180);
var inst_124182 = cljs.core.ex_info.call(null,inst_124178,inst_124181);
var inst_124183 = (function(){throw inst_124182})();
var state_124223__$1 = state_124223;
var statearr_124242_124322 = state_124223__$1;
(statearr_124242_124322[(2)] = inst_124183);

(statearr_124242_124322[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124224 === (50))){
var inst_124186 = (state_124223[(2)]);
var state_124223__$1 = state_124223;
var statearr_124243_124323 = state_124223__$1;
(statearr_124243_124323[(2)] = inst_124186);

(statearr_124243_124323[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124224 === (21))){
var inst_124064 = (state_124223[(13)]);
var inst_124087 = (state_124223[(2)]);
var state_124223__$1 = (function (){var statearr_124244 = state_124223;
(statearr_124244[(14)] = inst_124087);

return statearr_124244;
})();
if(cljs.core.truth_(inst_124064)){
var statearr_124245_124324 = state_124223__$1;
(statearr_124245_124324[(1)] = (23));

} else {
var statearr_124246_124325 = state_124223__$1;
(statearr_124246_124325[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124224 === (31))){
var state_124223__$1 = state_124223;
var statearr_124247_124326 = state_124223__$1;
(statearr_124247_124326[(1)] = (36));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124224 === (32))){
var inst_124129 = (state_124223[(2)]);
var state_124223__$1 = state_124223;
var statearr_124249_124327 = state_124223__$1;
(statearr_124249_124327[(2)] = inst_124129);

(statearr_124249_124327[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124224 === (40))){
var inst_124139 = (state_124223[(15)]);
var inst_124140 = (state_124223[(16)]);
var inst_124141 = (state_124223[(17)]);
var inst_124150 = (inst_124139 == null);
var inst_124151 = (inst_124140 == null);
var inst_124152 = cljs.core.not.call(null,inst_124151);
var inst_124153 = (inst_124141 == null);
var inst_124154 = ((inst_124150) && (inst_124152) && (inst_124153));
var state_124223__$1 = state_124223;
if(cljs.core.truth_(inst_124154)){
var statearr_124250_124328 = state_124223__$1;
(statearr_124250_124328[(1)] = (42));

} else {
var statearr_124251_124329 = state_124223__$1;
(statearr_124251_124329[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124224 === (56))){
var inst_124209 = (state_124223[(2)]);
var inst_124210 = fluree.db.util.async.throw_err.call(null,inst_124209);
var state_124223__$1 = state_124223;
var statearr_124252_124330 = state_124223__$1;
(statearr_124252_124330[(2)] = inst_124210);

(statearr_124252_124330[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124224 === (33))){
var inst_124050 = (state_124223[(8)]);
var inst_124108 = ["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_124050)].join('');
var inst_124109 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_124110 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_124111 = cljs.core.PersistentHashMap.fromArrays(inst_124109,inst_124110);
var inst_124112 = cljs.core.ex_info.call(null,inst_124108,inst_124111);
var inst_124113 = (function(){throw inst_124112})();
var state_124223__$1 = state_124223;
var statearr_124253_124331 = state_124223__$1;
(statearr_124253_124331[(2)] = inst_124113);

(statearr_124253_124331[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124224 === (13))){
var state_124223__$1 = state_124223;
var statearr_124254_124332 = state_124223__$1;
(statearr_124254_124332[(2)] = null);

(statearr_124254_124332[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124224 === (22))){
var inst_124081 = (state_124223[(2)]);
var inst_124082 = fluree.db.util.async.throw_err.call(null,inst_124081);
var inst_124083 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_124082);
var inst_124084 = (inst_124083 - (1));
var state_124223__$1 = state_124223;
var statearr_124255_124333 = state_124223__$1;
(statearr_124255_124333[(2)] = inst_124084);

(statearr_124255_124333[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124224 === (36))){
var inst_124050 = (state_124223[(8)]);
var inst_124119 = ["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_124050)].join('');
var inst_124120 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_124121 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_124122 = cljs.core.PersistentHashMap.fromArrays(inst_124120,inst_124121);
var inst_124123 = cljs.core.ex_info.call(null,inst_124119,inst_124122);
var inst_124124 = (function(){throw inst_124123})();
var state_124223__$1 = state_124223;
var statearr_124256_124334 = state_124223__$1;
(statearr_124256_124334[(2)] = inst_124124);

(statearr_124256_124334[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124224 === (41))){
var inst_124097 = (state_124223[(18)]);
var inst_124087 = (state_124223[(14)]);
var inst_124054 = (state_124223[(9)]);
var inst_124192 = (state_124223[(2)]);
var inst_124193 = cljs.core.nth.call(null,inst_124192,(0),null);
var inst_124194 = cljs.core.nth.call(null,inst_124192,(1),null);
var inst_124195 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_124196 = [inst_124087,inst_124097];
var inst_124197 = cljs.core.PersistentHashMap.fromArrays(inst_124195,inst_124196);
var inst_124198 = fluree.db.query.range.time_range.call(null,inst_124054,inst_124194,cljs.core._EQ_,inst_124193,inst_124197);
var state_124223__$1 = state_124223;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_124223__$1,(51),inst_124198);
} else {
if((state_val_124224 === (43))){
var inst_124139 = (state_124223[(15)]);
var inst_124140 = (state_124223[(16)]);
var inst_124141 = (state_124223[(17)]);
var inst_124163 = (inst_124139 == null);
var inst_124164 = (inst_124140 == null);
var inst_124165 = cljs.core.not.call(null,inst_124164);
var inst_124166 = (inst_124141 == null);
var inst_124167 = cljs.core.not.call(null,inst_124166);
var inst_124168 = ((inst_124163) && (inst_124165) && (inst_124167));
var state_124223__$1 = state_124223;
if(cljs.core.truth_(inst_124168)){
var statearr_124257_124335 = state_124223__$1;
(statearr_124257_124335[(1)] = (45));

} else {
var statearr_124258_124336 = state_124223__$1;
(statearr_124258_124336[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124224 === (29))){
var inst_124139 = (state_124223[(15)]);
var inst_124131 = (state_124223[(11)]);
var inst_124131__$1 = (state_124223[(2)]);
var inst_124132 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_124133 = cljs.core.get.call(null,inst_124131__$1,(0));
var inst_124134 = cljs.core.get.call(null,inst_124131__$1,(1));
var inst_124135 = cljs.core.get.call(null,inst_124131__$1,(2));
var inst_124136 = cljs.core.get.call(null,inst_124131__$1,(3));
var inst_124137 = [inst_124133,inst_124134,inst_124135,inst_124136];
var inst_124138 = (new cljs.core.PersistentVector(null,4,(5),inst_124132,inst_124137,null));
var inst_124139__$1 = cljs.core.nth.call(null,inst_124138,(0),null);
var inst_124140 = cljs.core.nth.call(null,inst_124138,(1),null);
var inst_124141 = cljs.core.nth.call(null,inst_124138,(2),null);
var inst_124142 = cljs.core.nth.call(null,inst_124138,(3),null);
var inst_124143 = (inst_124139__$1 == null);
var inst_124144 = cljs.core.not.call(null,inst_124143);
var state_124223__$1 = (function (){var statearr_124259 = state_124223;
(statearr_124259[(15)] = inst_124139__$1);

(statearr_124259[(11)] = inst_124131__$1);

(statearr_124259[(16)] = inst_124140);

(statearr_124259[(17)] = inst_124141);

(statearr_124259[(19)] = inst_124142);

return statearr_124259;
})();
if(inst_124144){
var statearr_124260_124337 = state_124223__$1;
(statearr_124260_124337[(1)] = (39));

} else {
var statearr_124261_124338 = state_124223__$1;
(statearr_124261_124338[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124224 === (44))){
var inst_124190 = (state_124223[(2)]);
var state_124223__$1 = state_124223;
var statearr_124262_124339 = state_124223__$1;
(statearr_124262_124339[(2)] = inst_124190);

(statearr_124262_124339[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124224 === (6))){
var state_124223__$1 = state_124223;
var statearr_124263_124340 = state_124223__$1;
(statearr_124263_124340[(2)] = false);

(statearr_124263_124340[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124224 === (28))){
var inst_124050 = (state_124223[(8)]);
var inst_124104 = cljs.core.sequential_QMARK_.call(null,inst_124050);
var state_124223__$1 = state_124223;
if(inst_124104){
var statearr_124264_124341 = state_124223__$1;
(statearr_124264_124341[(1)] = (30));

} else {
var statearr_124265_124342 = state_124223__$1;
(statearr_124265_124342[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124224 === (51))){
var inst_124201 = (state_124223[(20)]);
var inst_124054 = (state_124223[(9)]);
var inst_124200 = (state_124223[(2)]);
var inst_124201__$1 = fluree.db.util.async.throw_err.call(null,inst_124200);
var inst_124202 = fluree.db.api_js.format_history_resp.call(null,inst_124054,inst_124201__$1);
var state_124223__$1 = (function (){var statearr_124266 = state_124223;
(statearr_124266[(20)] = inst_124201__$1);

return statearr_124266;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_124223__$1,(52),inst_124202);
} else {
if((state_val_124224 === (25))){
var inst_124050 = (state_124223[(8)]);
var inst_124097 = (state_124223[(2)]);
var inst_124098 = fluree.db.util.core.subj_ident_QMARK_.call(null,inst_124050);
var state_124223__$1 = (function (){var statearr_124267 = state_124223;
(statearr_124267[(18)] = inst_124097);

return statearr_124267;
})();
if(inst_124098){
var statearr_124268_124343 = state_124223__$1;
(statearr_124268_124343[(1)] = (27));

} else {
var statearr_124269_124344 = state_124223__$1;
(statearr_124269_124344[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124224 === (34))){
var inst_124050 = (state_124223[(8)]);
var state_124223__$1 = state_124223;
var statearr_124270_124345 = state_124223__$1;
(statearr_124270_124345[(2)] = inst_124050);

(statearr_124270_124345[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124224 === (17))){
var inst_124063 = (state_124223[(21)]);
var state_124223__$1 = state_124223;
var statearr_124271_124346 = state_124223__$1;
(statearr_124271_124346[(2)] = inst_124063);

(statearr_124271_124346[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124224 === (3))){
var state_124223__$1 = state_124223;
var statearr_124272_124347 = state_124223__$1;
(statearr_124272_124347[(2)] = false);

(statearr_124272_124347[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124224 === (12))){
var inst_124054 = (state_124223[(9)]);
var inst_124056 = fluree.db.api_js.resolve_block_range.call(null,inst_124054,query_map);
var state_124223__$1 = state_124223;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_124223__$1,(15),inst_124056);
} else {
if((state_val_124224 === (2))){
var inst_124032 = query_map.cljs$lang$protocol_mask$partition0$;
var inst_124033 = (inst_124032 & (64));
var inst_124034 = query_map.cljs$core$ISeq$;
var inst_124035 = (cljs.core.PROTOCOL_SENTINEL === inst_124034);
var inst_124036 = ((inst_124033) || (inst_124035));
var state_124223__$1 = state_124223;
if(cljs.core.truth_(inst_124036)){
var statearr_124273_124348 = state_124223__$1;
(statearr_124273_124348[(1)] = (5));

} else {
var statearr_124274_124349 = state_124223__$1;
(statearr_124274_124349[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124224 === (23))){
var inst_124064 = (state_124223[(13)]);
var inst_124054 = (state_124223[(9)]);
var inst_124089 = fluree.db.time_travel.as_of_block.call(null,inst_124054,inst_124064);
var state_124223__$1 = state_124223;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_124223__$1,(26),inst_124089);
} else {
if((state_val_124224 === (47))){
var inst_124188 = (state_124223[(2)]);
var state_124223__$1 = state_124223;
var statearr_124275_124350 = state_124223__$1;
(statearr_124275_124350[(2)] = inst_124188);

(statearr_124275_124350[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124224 === (35))){
var inst_124116 = (state_124223[(2)]);
var state_124223__$1 = state_124223;
var statearr_124276_124351 = state_124223__$1;
(statearr_124276_124351[(2)] = inst_124116);

(statearr_124276_124351[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124224 === (19))){
var inst_124063 = (state_124223[(21)]);
var inst_124054 = (state_124223[(9)]);
var inst_124078 = (inst_124063 - (1));
var inst_124079 = fluree.db.time_travel.as_of_block.call(null,inst_124054,inst_124078);
var state_124223__$1 = state_124223;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_124223__$1,(22),inst_124079);
} else {
if((state_val_124224 === (57))){
var inst_124213 = (state_124223[(7)]);
var inst_124201 = (state_124223[(20)]);
var inst_124215 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_124216 = cljs.core.count.call(null,inst_124201);
var inst_124217 = [inst_124213,inst_124216,(200)];
var inst_124218 = cljs.core.PersistentHashMap.fromArrays(inst_124215,inst_124217);
var state_124223__$1 = state_124223;
var statearr_124277_124352 = state_124223__$1;
(statearr_124277_124352[(2)] = inst_124218);

(statearr_124277_124352[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124224 === (11))){
var inst_124049 = (state_124223[(22)]);
var inst_124053 = (state_124223[(2)]);
var inst_124054 = fluree.db.util.async.throw_err.call(null,inst_124053);
var state_124223__$1 = (function (){var statearr_124278 = state_124223;
(statearr_124278[(9)] = inst_124054);

return statearr_124278;
})();
if(cljs.core.truth_(inst_124049)){
var statearr_124279_124353 = state_124223__$1;
(statearr_124279_124353[(1)] = (12));

} else {
var statearr_124280_124354 = state_124223__$1;
(statearr_124280_124354[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124224 === (9))){
var state_124223__$1 = state_124223;
var statearr_124281_124355 = state_124223__$1;
(statearr_124281_124355[(2)] = query_map);

(statearr_124281_124355[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124224 === (5))){
var state_124223__$1 = state_124223;
var statearr_124282_124356 = state_124223__$1;
(statearr_124282_124356[(2)] = true);

(statearr_124282_124356[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124224 === (14))){
var inst_124063 = (state_124223[(21)]);
var inst_124062 = (state_124223[(2)]);
var inst_124063__$1 = cljs.core.nth.call(null,inst_124062,(0),null);
var inst_124064 = cljs.core.nth.call(null,inst_124062,(1),null);
var inst_124071 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_124223__$1 = (function (){var statearr_124283 = state_124223;
(statearr_124283[(21)] = inst_124063__$1);

(statearr_124283[(10)] = inst_124071);

(statearr_124283[(13)] = inst_124064);

return statearr_124283;
})();
if(cljs.core.truth_(inst_124063__$1)){
var statearr_124284_124357 = state_124223__$1;
(statearr_124284_124357[(1)] = (16));

} else {
var statearr_124285_124358 = state_124223__$1;
(statearr_124285_124358[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124224 === (45))){
var inst_124139 = (state_124223[(15)]);
var inst_124140 = (state_124223[(16)]);
var inst_124141 = (state_124223[(17)]);
var inst_124142 = (state_124223[(19)]);
var inst_124170 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_124171 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_124172 = [inst_124140,inst_124141,inst_124139,inst_124142];
var inst_124173 = (new cljs.core.PersistentVector(null,4,(5),inst_124171,inst_124172,null));
var inst_124174 = [inst_124173,new cljs.core.Keyword(null,"post","post",269697687)];
var inst_124175 = (new cljs.core.PersistentVector(null,2,(5),inst_124170,inst_124174,null));
var state_124223__$1 = state_124223;
var statearr_124286_124359 = state_124223__$1;
(statearr_124286_124359[(2)] = inst_124175);

(statearr_124286_124359[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124224 === (53))){
var inst_124205 = (state_124223[(12)]);
var inst_124054 = (state_124223[(9)]);
var inst_124207 = fluree.db.api_js.format_block_resp_pretty.call(null,inst_124054,inst_124205);
var state_124223__$1 = state_124223;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_124223__$1,(56),inst_124207);
} else {
if((state_val_124224 === (26))){
var inst_124091 = (state_124223[(2)]);
var inst_124092 = fluree.db.util.async.throw_err.call(null,inst_124091);
var inst_124093 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_124092);
var state_124223__$1 = state_124223;
var statearr_124287_124360 = state_124223__$1;
(statearr_124287_124360[(2)] = inst_124093);

(statearr_124287_124360[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124224 === (16))){
var inst_124063 = (state_124223[(21)]);
var inst_124073 = cljs.core.not_EQ_.call(null,(1),inst_124063);
var state_124223__$1 = state_124223;
var statearr_124288_124361 = state_124223__$1;
(statearr_124288_124361[(2)] = inst_124073);

(statearr_124288_124361[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124224 === (38))){
var inst_124127 = (state_124223[(2)]);
var state_124223__$1 = state_124223;
var statearr_124289_124362 = state_124223__$1;
(statearr_124289_124362[(2)] = inst_124127);

(statearr_124289_124362[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124224 === (30))){
var inst_124050 = (state_124223[(8)]);
var inst_124106 = cljs.core.empty_QMARK_.call(null,inst_124050);
var state_124223__$1 = state_124223;
if(inst_124106){
var statearr_124290_124363 = state_124223__$1;
(statearr_124290_124363[(1)] = (33));

} else {
var statearr_124291_124364 = state_124223__$1;
(statearr_124291_124364[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124224 === (10))){
var inst_124048 = (state_124223[(2)]);
var inst_124049 = cljs.core.get.call(null,inst_124048,new cljs.core.Keyword(null,"block","block",664686210));
var inst_124050 = cljs.core.get.call(null,inst_124048,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_124051 = cljs.core.get.call(null,inst_124048,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var state_124223__$1 = (function (){var statearr_124292 = state_124223;
(statearr_124292[(22)] = inst_124049);

(statearr_124292[(23)] = inst_124051);

(statearr_124292[(8)] = inst_124050);

return statearr_124292;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_124223__$1,(11),sources);
} else {
if((state_val_124224 === (18))){
var inst_124076 = (state_124223[(2)]);
var state_124223__$1 = state_124223;
if(cljs.core.truth_(inst_124076)){
var statearr_124293_124365 = state_124223__$1;
(statearr_124293_124365[(1)] = (19));

} else {
var statearr_124294_124366 = state_124223__$1;
(statearr_124294_124366[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124224 === (52))){
var inst_124051 = (state_124223[(23)]);
var inst_124204 = (state_124223[(2)]);
var inst_124205 = fluree.db.util.async.throw_err.call(null,inst_124204);
var state_124223__$1 = (function (){var statearr_124295 = state_124223;
(statearr_124295[(12)] = inst_124205);

return statearr_124295;
})();
if(cljs.core.truth_(inst_124051)){
var statearr_124296_124367 = state_124223__$1;
(statearr_124296_124367[(1)] = (53));

} else {
var statearr_124297_124368 = state_124223__$1;
(statearr_124297_124368[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124224 === (42))){
var inst_124139 = (state_124223[(15)]);
var inst_124140 = (state_124223[(16)]);
var inst_124141 = (state_124223[(17)]);
var inst_124142 = (state_124223[(19)]);
var inst_124156 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_124157 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_124158 = [inst_124140,inst_124139,inst_124141,inst_124142];
var inst_124159 = (new cljs.core.PersistentVector(null,4,(5),inst_124157,inst_124158,null));
var inst_124160 = [inst_124159,new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_124161 = (new cljs.core.PersistentVector(null,2,(5),inst_124156,inst_124160,null));
var state_124223__$1 = state_124223;
var statearr_124298_124369 = state_124223__$1;
(statearr_124298_124369[(2)] = inst_124161);

(statearr_124298_124369[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124224 === (37))){
var state_124223__$1 = state_124223;
var statearr_124299_124370 = state_124223__$1;
(statearr_124299_124370[(2)] = null);

(statearr_124299_124370[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124224 === (8))){
var inst_124045 = cljs.core.apply.call(null,cljs.core.hash_map,query_map);
var state_124223__$1 = state_124223;
var statearr_124300_124371 = state_124223__$1;
(statearr_124300_124371[(2)] = inst_124045);

(statearr_124300_124371[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124224 === (49))){
var state_124223__$1 = state_124223;
var statearr_124301_124372 = state_124223__$1;
(statearr_124301_124372[(2)] = null);

(statearr_124301_124372[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__99975__auto__ = null;
var fluree$db$api_js$state_machine__99975__auto____0 = (function (){
var statearr_124302 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_124302[(0)] = fluree$db$api_js$state_machine__99975__auto__);

(statearr_124302[(1)] = (1));

return statearr_124302;
});
var fluree$db$api_js$state_machine__99975__auto____1 = (function (state_124223){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_124223);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e124303){if((e124303 instanceof Object)){
var ex__99978__auto__ = e124303;
var statearr_124304_124373 = state_124223;
(statearr_124304_124373[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_124223);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e124303;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__124374 = state_124223;
state_124223 = G__124374;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__99975__auto__ = function(state_124223){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__99975__auto____1.call(this,state_124223);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__99975__auto____0;
fluree$db$api_js$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__99975__auto____1;
return fluree$db$api_js$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_124305 = f__100070__auto__.call(null);
(statearr_124305[(6)] = c__100069__auto__);

return statearr_124305;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.api_js.history_query_async.cljs$lang$maxFixedArity = 3);

/**
 * Returns an asynchronous channel that eventually contains the result or an error.
 * 
 *   The db function, required to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.multi_query_async = (function fluree$db$api_js$multi_query_async(var_args){
var G__124382 = arguments.length;
switch (G__124382) {
case 2:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,multi_query_map){
return fluree.db.api_js.multi_query_async.call(null,sources,multi_query_map,null,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,multi_query_map,opts){
return fluree.db.api_js.multi_query_async.call(null,sources,multi_query_map,opts,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4 = (function (sources,multi_query_map,opts,db_fn){
var db = sources;
var block = (function (){var temp__5735__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(multi_query_map);
if(cljs.core.truth_(temp__5735__auto__)){
var block = temp__5735__auto__;
return fluree.db.util.async.throw_err.call(null,cljs.core.async._LT__BANG_.call(null,fluree.db.time_travel.block_to_int_format.call(null,fluree.db.util.async.throw_err.call(null,cljs.core.async._LT__BANG_.call(null,db)),block)));
} else {
return null;
}
})();
var meta_QMARK_ = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var _ = (cljs.core.truth_((function (){var and__4115__auto__ = block;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.map_QMARK_.call(null,block);
} else {
return and__4115__auto__;
}
})())?(function(){throw cljs.core.ex_info.call(null,["Block is a reserved keyword. Please choose another name for your query. ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var ___$1 = (cljs.core.truth_((function (){var and__4115__auto__ = block;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.coll_QMARK_.call(null,block);
} else {
return and__4115__auto__;
}
})())?(function(){throw cljs.core.ex_info.call(null,["Query block must be a string or integer. Block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var multi_query_map_SINGLEQUOTE_ = cljs.core.dissoc.call(null,multi_query_map,new cljs.core.Keyword(null,"block","block",664686210));
var vals_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__124375_SHARP_){
return cljs.core.dissoc.call(null,p1__124375_SHARP_,new cljs.core.Keyword(null,"block","block",664686210));
}),cljs.core.vals.call(null,multi_query_map_SINGLEQUOTE_));
var keys_SINGLEQUOTE_ = cljs.core.keys.call(null,multi_query_map_SINGLEQUOTE_);
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_124468){
var state_val_124469 = (state_124468[(1)]);
if((state_val_124469 === (7))){
var inst_124422 = (state_124468[(7)]);
var inst_124419 = (state_124468[(8)]);
var inst_124425 = (state_124468[(9)]);
var inst_124429 = (state_124468[(10)]);
var inst_124435 = (function (){var responses = inst_124419;
var responses_STAR_ = inst_124422;
var statuses = inst_124425;
var fuel = inst_124429;
return (function (p1__124378_SHARP_){
return cljs.core._EQ_.call(null,(200),p1__124378_SHARP_);
});
})();
var inst_124436 = cljs.core.some.call(null,inst_124435,inst_124425);
var state_124468__$1 = state_124468;
if(cljs.core.truth_(inst_124436)){
var statearr_124470_124516 = state_124468__$1;
(statearr_124470_124516[(1)] = (9));

} else {
var statearr_124471_124517 = state_124468__$1;
(statearr_124471_124517[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124469 === (20))){
var inst_124463 = (state_124468[(2)]);
var state_124468__$1 = state_124468;
var statearr_124472_124518 = state_124468__$1;
(statearr_124472_124518[(2)] = inst_124463);

(statearr_124472_124518[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124469 === (1))){
var inst_124414 = cljs.core.async.chan.call(null,(1));
var inst_124415 = (function (){var c__100069__auto____$1 = inst_124414;
return (function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_124412){
var state_val_124413 = (state_124412[(1)]);
if((state_val_124413 === (1))){
var inst_124383 = cljs.core.first.call(null,keys_SINGLEQUOTE_);
var inst_124384 = cljs.core.first.call(null,vals_SINGLEQUOTE_);
var inst_124385 = cljs.core.assoc.call(null,inst_124384,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_124386 = cljs.core.rest.call(null,keys_SINGLEQUOTE_);
var inst_124387 = cljs.core.rest.call(null,vals_SINGLEQUOTE_);
var inst_124388 = cljs.core.PersistentHashMap.EMPTY;
var inst_124389 = inst_124383;
var inst_124390 = inst_124385;
var inst_124391 = inst_124386;
var inst_124392 = inst_124387;
var inst_124393 = inst_124388;
var state_124412__$1 = (function (){var statearr_124473 = state_124412;
(statearr_124473[(7)] = inst_124392);

(statearr_124473[(8)] = inst_124389);

(statearr_124473[(9)] = inst_124390);

(statearr_124473[(10)] = inst_124391);

(statearr_124473[(11)] = inst_124393);

return statearr_124473;
})();
var statearr_124474_124519 = state_124412__$1;
(statearr_124474_124519[(2)] = null);

(statearr_124474_124519[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124413 === (2))){
var inst_124390 = (state_124412[(9)]);
var inst_124395 = fluree.db.api_js.query_async.call(null,db,inst_124390,opts,db_fn);
var state_124412__$1 = state_124412;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_124412__$1,(4),inst_124395);
} else {
if((state_val_124413 === (3))){
var inst_124410 = (state_124412[(2)]);
var state_124412__$1 = state_124412;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_124412__$1,inst_124410);
} else {
if((state_val_124413 === (4))){
var inst_124389 = (state_124412[(8)]);
var inst_124391 = (state_124412[(10)]);
var inst_124393 = (state_124412[(11)]);
var inst_124397 = (state_124412[(2)]);
var inst_124398 = cljs.core.assoc.call(null,inst_124393,inst_124389,inst_124397);
var inst_124399 = cljs.core.first.call(null,inst_124391);
var state_124412__$1 = (function (){var statearr_124475 = state_124412;
(statearr_124475[(12)] = inst_124398);

return statearr_124475;
})();
if(cljs.core.truth_(inst_124399)){
var statearr_124476_124520 = state_124412__$1;
(statearr_124476_124520[(1)] = (5));

} else {
var statearr_124477_124521 = state_124412__$1;
(statearr_124477_124521[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124413 === (5))){
var inst_124392 = (state_124412[(7)]);
var inst_124398 = (state_124412[(12)]);
var inst_124391 = (state_124412[(10)]);
var inst_124401 = cljs.core.first.call(null,inst_124391);
var inst_124402 = cljs.core.first.call(null,inst_124392);
var inst_124403 = cljs.core.rest.call(null,inst_124391);
var inst_124404 = cljs.core.rest.call(null,inst_124392);
var inst_124389 = inst_124401;
var inst_124390 = inst_124402;
var inst_124391__$1 = inst_124403;
var inst_124392__$1 = inst_124404;
var inst_124393 = inst_124398;
var state_124412__$1 = (function (){var statearr_124478 = state_124412;
(statearr_124478[(7)] = inst_124392__$1);

(statearr_124478[(8)] = inst_124389);

(statearr_124478[(9)] = inst_124390);

(statearr_124478[(10)] = inst_124391__$1);

(statearr_124478[(11)] = inst_124393);

return statearr_124478;
})();
var statearr_124479_124522 = state_124412__$1;
(statearr_124479_124522[(2)] = null);

(statearr_124479_124522[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124413 === (6))){
var inst_124398 = (state_124412[(12)]);
var state_124412__$1 = state_124412;
var statearr_124480_124523 = state_124412__$1;
(statearr_124480_124523[(2)] = inst_124398);

(statearr_124480_124523[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124413 === (7))){
var inst_124408 = (state_124412[(2)]);
var state_124412__$1 = state_124412;
var statearr_124481_124524 = state_124412__$1;
(statearr_124481_124524[(2)] = inst_124408);

(statearr_124481_124524[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__99975__auto__ = null;
var fluree$db$api_js$state_machine__99975__auto____0 = (function (){
var statearr_124482 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_124482[(0)] = fluree$db$api_js$state_machine__99975__auto__);

(statearr_124482[(1)] = (1));

return statearr_124482;
});
var fluree$db$api_js$state_machine__99975__auto____1 = (function (state_124412){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_124412);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e124483){if((e124483 instanceof Object)){
var ex__99978__auto__ = e124483;
var statearr_124484_124525 = state_124412;
(statearr_124484_124525[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_124412);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e124483;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__124526 = state_124412;
state_124412 = G__124526;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__99975__auto__ = function(state_124412){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__99975__auto____1.call(this,state_124412);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__99975__auto____0;
fluree$db$api_js$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__99975__auto____1;
return fluree$db$api_js$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_124485 = f__100070__auto__.call(null);
(statearr_124485[(6)] = c__100069__auto____$1);

return statearr_124485;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
});
})();
var inst_124416 = cljs.core.async.impl.dispatch.run.call(null,inst_124415);
var state_124468__$1 = (function (){var statearr_124486 = state_124468;
(statearr_124486[(11)] = inst_124416);

return statearr_124486;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_124468__$1,(2),inst_124414);
} else {
if((state_val_124469 === (4))){
var inst_124419 = (state_124468[(8)]);
var state_124468__$1 = state_124468;
var statearr_124487_124527 = state_124468__$1;
(statearr_124487_124527[(2)] = inst_124419);

(statearr_124487_124527[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124469 === (15))){
var state_124468__$1 = state_124468;
var statearr_124488_124528 = state_124468__$1;
(statearr_124488_124528[(2)] = (400));

(statearr_124488_124528[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124469 === (13))){
var state_124468__$1 = state_124468;
var statearr_124489_124529 = state_124468__$1;
(statearr_124489_124529[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124469 === (6))){
var inst_124425 = (state_124468[(9)]);
var inst_124433 = cljs.core.first.call(null,inst_124425);
var state_124468__$1 = state_124468;
var statearr_124491_124530 = state_124468__$1;
(statearr_124491_124530[(2)] = inst_124433);

(statearr_124491_124530[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124469 === (17))){
var inst_124446 = (state_124468[(2)]);
var state_124468__$1 = state_124468;
var statearr_124492_124531 = state_124468__$1;
(statearr_124492_124531[(2)] = inst_124446);

(statearr_124492_124531[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124469 === (3))){
var inst_124422 = (state_124468[(7)]);
var inst_124419 = (state_124468[(8)]);
var inst_124425 = (state_124468[(9)]);
var inst_124429 = (state_124468[(10)]);
var inst_124424 = cljs.core.vals.call(null,inst_124419);
var inst_124425__$1 = cljs.core.map.call(null,new cljs.core.Keyword(null,"status","status",-1997798413),inst_124424);
var inst_124426 = (function (){var responses = inst_124419;
var responses_STAR_ = inst_124422;
var statuses = inst_124425__$1;
return (function (p1__124376_SHARP_){
var or__4126__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(p1__124376_SHARP_);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
});
})();
var inst_124427 = cljs.core.vals.call(null,inst_124419);
var inst_124428 = cljs.core.map.call(null,inst_124426,inst_124427);
var inst_124429__$1 = cljs.core.apply.call(null,cljs.core._PLUS_,inst_124428);
var inst_124430 = (function (){var responses = inst_124419;
var responses_STAR_ = inst_124422;
var statuses = inst_124425__$1;
var fuel = inst_124429__$1;
return (function (p1__124377_SHARP_){
return cljs.core._EQ_.call(null,cljs.core.first.call(null,statuses),p1__124377_SHARP_);
});
})();
var inst_124431 = cljs.core.every_QMARK_.call(null,inst_124430,inst_124425__$1);
var state_124468__$1 = (function (){var statearr_124493 = state_124468;
(statearr_124493[(9)] = inst_124425__$1);

(statearr_124493[(10)] = inst_124429__$1);

return statearr_124493;
})();
if(inst_124431){
var statearr_124494_124532 = state_124468__$1;
(statearr_124494_124532[(1)] = (6));

} else {
var statearr_124495_124533 = state_124468__$1;
(statearr_124495_124533[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124469 === (12))){
var state_124468__$1 = state_124468;
var statearr_124496_124534 = state_124468__$1;
(statearr_124496_124534[(2)] = (500));

(statearr_124496_124534[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124469 === (2))){
var inst_124419 = (state_124468[(8)]);
var inst_124418 = (state_124468[(2)]);
var inst_124419__$1 = fluree.db.util.async.throw_err.call(null,inst_124418);
var inst_124420 = (function (){var responses = inst_124419__$1;
return (function (acc,index,response){
var resp = (function (){var or__4126__auto__ = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(response);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return response;
}
})();
if(cljs.core.truth_(meta_QMARK_)){
if(cljs.core._EQ_.call(null,(200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response))){
return cljs.core.assoc_in.call(null,acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"result","result",1415092211),index], null),resp);
} else {
return cljs.core.assoc_in.call(null,acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"errors","errors",-908790718),index], null),new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(response));
}
} else {
return cljs.core.assoc.call(null,acc,index,resp);
}
});
})();
var inst_124421 = cljs.core.PersistentHashMap.EMPTY;
var inst_124422 = cljs.core.reduce_kv.call(null,inst_124420,inst_124421,inst_124419__$1);
var state_124468__$1 = (function (){var statearr_124497 = state_124468;
(statearr_124497[(7)] = inst_124422);

(statearr_124497[(8)] = inst_124419__$1);

return statearr_124497;
})();
if(cljs.core.truth_(meta_QMARK_)){
var statearr_124498_124535 = state_124468__$1;
(statearr_124498_124535[(1)] = (3));

} else {
var statearr_124499_124536 = state_124468__$1;
(statearr_124499_124536[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124469 === (19))){
var inst_124422 = (state_124468[(7)]);
var inst_124452 = (state_124468[(12)]);
var inst_124429 = (state_124468[(10)]);
var inst_124461 = cljs.core.assoc.call(null,inst_124422,new cljs.core.Keyword(null,"status","status",-1997798413),inst_124452,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_124429);
var state_124468__$1 = state_124468;
var statearr_124500_124537 = state_124468__$1;
(statearr_124500_124537[(2)] = inst_124461);

(statearr_124500_124537[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124469 === (11))){
var inst_124450 = (state_124468[(2)]);
var state_124468__$1 = state_124468;
var statearr_124501_124538 = state_124468__$1;
(statearr_124501_124538[(2)] = inst_124450);

(statearr_124501_124538[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124469 === (9))){
var state_124468__$1 = state_124468;
var statearr_124502_124539 = state_124468__$1;
(statearr_124502_124539[(2)] = (207));

(statearr_124502_124539[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124469 === (5))){
var inst_124466 = (state_124468[(2)]);
var state_124468__$1 = state_124468;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_124468__$1,inst_124466);
} else {
if((state_val_124469 === (14))){
var inst_124448 = (state_124468[(2)]);
var state_124468__$1 = state_124468;
var statearr_124503_124540 = state_124468__$1;
(statearr_124503_124540[(2)] = inst_124448);

(statearr_124503_124540[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124469 === (16))){
var state_124468__$1 = state_124468;
var statearr_124504_124541 = state_124468__$1;
(statearr_124504_124541[(2)] = null);

(statearr_124504_124541[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124469 === (10))){
var inst_124422 = (state_124468[(7)]);
var inst_124419 = (state_124468[(8)]);
var inst_124425 = (state_124468[(9)]);
var inst_124429 = (state_124468[(10)]);
var inst_124439 = (function (){var responses = inst_124419;
var responses_STAR_ = inst_124422;
var statuses = inst_124425;
var fuel = inst_124429;
return (function (p1__124379_SHARP_){
return ((499) < p1__124379_SHARP_);
});
})();
var inst_124440 = cljs.core.some.call(null,inst_124439,inst_124425);
var state_124468__$1 = state_124468;
if(cljs.core.truth_(inst_124440)){
var statearr_124505_124542 = state_124468__$1;
(statearr_124505_124542[(1)] = (12));

} else {
var statearr_124506_124543 = state_124468__$1;
(statearr_124506_124543[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124469 === (18))){
var inst_124422 = (state_124468[(7)]);
var inst_124457 = (state_124468[(13)]);
var inst_124452 = (state_124468[(12)]);
var inst_124429 = (state_124468[(10)]);
var inst_124459 = cljs.core.assoc.call(null,inst_124422,new cljs.core.Keyword(null,"status","status",-1997798413),inst_124452,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_124429,new cljs.core.Keyword(null,"block","block",664686210),inst_124457);
var state_124468__$1 = state_124468;
var statearr_124507_124544 = state_124468__$1;
(statearr_124507_124544[(2)] = inst_124459);

(statearr_124507_124544[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124469 === (8))){
var inst_124422 = (state_124468[(7)]);
var inst_124419 = (state_124468[(8)]);
var inst_124457 = (state_124468[(13)]);
var inst_124452 = (state_124468[(12)]);
var inst_124425 = (state_124468[(9)]);
var inst_124429 = (state_124468[(10)]);
var inst_124452__$1 = (state_124468[(2)]);
var inst_124453 = (function (){var responses = inst_124419;
var responses_STAR_ = inst_124422;
var statuses = inst_124425;
var fuel = inst_124429;
var status = inst_124452__$1;
return (function (p1__124380_SHARP_){
return cljs.core._EQ_.call(null,(200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(p1__124380_SHARP_));
});
})();
var inst_124454 = cljs.core.vals.call(null,inst_124419);
var inst_124455 = cljs.core.filter.call(null,inst_124453,inst_124454);
var inst_124456 = cljs.core.first.call(null,inst_124455);
var inst_124457__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_124456);
var state_124468__$1 = (function (){var statearr_124508 = state_124468;
(statearr_124508[(13)] = inst_124457__$1);

(statearr_124508[(12)] = inst_124452__$1);

return statearr_124508;
})();
if(cljs.core.truth_(inst_124457__$1)){
var statearr_124509_124545 = state_124468__$1;
(statearr_124509_124545[(1)] = (18));

} else {
var statearr_124510_124546 = state_124468__$1;
(statearr_124510_124546[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__99975__auto__ = null;
var fluree$db$api_js$state_machine__99975__auto____0 = (function (){
var statearr_124511 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_124511[(0)] = fluree$db$api_js$state_machine__99975__auto__);

(statearr_124511[(1)] = (1));

return statearr_124511;
});
var fluree$db$api_js$state_machine__99975__auto____1 = (function (state_124468){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_124468);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e124512){if((e124512 instanceof Object)){
var ex__99978__auto__ = e124512;
var statearr_124513_124547 = state_124468;
(statearr_124513_124547[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_124468);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e124512;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__124548 = state_124468;
state_124468 = G__124548;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__99975__auto__ = function(state_124468){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__99975__auto____1.call(this,state_124468);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__99975__auto____0;
fluree$db$api_js$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__99975__auto____1;
return fluree$db$api_js$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_124514 = f__100070__auto__.call(null);
(statearr_124514[(6)] = c__100069__auto__);

return statearr_124514;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.api_js.multi_query_async.cljs$lang$maxFixedArity = 4);

/**
 * Helper function to fill out the parts of the query that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
fluree.db.api_js.qry__GT_command = (function fluree$db$api_js$qry__GT_command(var_args){
var G__124550 = arguments.length;
switch (G__124550) {
case 3:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,qry_map,private_key){
return fluree.db.api_js.qry__GT_command.call(null,ledger,qry_map,private_key,null);
}));

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,qry_map,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.call(null,"Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}

var db_name = ((cljs.core.sequential_QMARK_.call(null,ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,ledger))].join(''):ledger);
var map__124551 = opts;
var map__124551__$1 = (((((!((map__124551 == null))))?(((((map__124551.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__124551.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__124551):map__124551);
var auth = cljs.core.get.call(null,map__124551__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.call(null,map__124551__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.call(null,map__124551__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var action = cljs.core.get.call(null,map__124551__$1,new cljs.core.Keyword(null,"action","action",-811238024));
var key_auth_id = fluree.crypto.account_id_from_private.call(null,private_key);
var vec__124552 = (cljs.core.truth_((function (){var and__4115__auto__ = auth;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.not_EQ_.call(null,auth,key_auth_id);
} else {
return and__4115__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.call(null,vec__124552,(0),null);
var authority = cljs.core.nth.call(null,vec__124552,(1),null);
var action__$1 = (function (){var or__4126__auto__ = action;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword(null,"query","query",-1288509510);
}
})();
var timestamp = fluree.db.util.core.current_time_millis.call(null);
var nonce__$1 = (function (){var or__4126__auto__ = nonce;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__4126__auto__ = expire;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify_preserve_namespace.call(null,fluree.db.util.core.without_nils.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"signed-qry","signed-qry",-1632927184),new cljs.core.Keyword(null,"action","action",-811238024),action__$1,new cljs.core.Keyword(null,"db","db",993250759),db_name,new cljs.core.Keyword(null,"qry","qry",-231103548),qry_map,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1], null)));
}catch (e124556){var e = e124556;
throw cljs.core.ex_info.call(null,"Signed query contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}})();
var sig = fluree.crypto.sign_message.call(null,cmd,private_key);
var id = fluree.crypto.sha3_256.call(null,cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"db","db",993250759),ledger], null);
}));

(fluree.db.api_js.qry__GT_command.cljs$lang$maxFixedArity = 4);

/**
 * Execute a signed query against a ledger.
 * 
 *   Returns an asynchronous channel that eventually contains the results.
 */
fluree.db.api_js.signed_query_async = (function fluree$db$api_js$signed_query_async(var_args){
var G__124559 = arguments.length;
switch (G__124559) {
case 3:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return fluree.db.api_js.signed_query_async.call(null,conn,ledger,query_map,null);
}));

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_124587){
var state_val_124588 = (state_124587[(1)]);
if((state_val_124588 === (1))){
var state_124587__$1 = state_124587;
var statearr_124589_124603 = state_124587__$1;
(statearr_124589_124603[(2)] = null);

(statearr_124589_124603[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124588 === (2))){
var inst_124585 = (state_124587[(2)]);
var state_124587__$1 = state_124587;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_124587__$1,inst_124585);
} else {
if((state_val_124588 === (3))){
var inst_124560 = (state_124587[(2)]);
var inst_124561 = fluree.db.util.log.error.call(null,inst_124560);
var inst_124562 = cljs.core.ex_data.call(null,inst_124560);
var inst_124563 = cljs.core.ex_message.call(null,inst_124560);
var inst_124564 = cljs.core.assoc.call(null,inst_124562,new cljs.core.Keyword(null,"message","message",-406056002),inst_124563);
var state_124587__$1 = (function (){var statearr_124590 = state_124587;
(statearr_124590[(7)] = inst_124561);

return statearr_124590;
})();
var statearr_124591_124604 = state_124587__$1;
(statearr_124591_124604[(2)] = inst_124564);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_124587__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124588 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_124587,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var inst_124568 = new cljs.core.Keyword(null,"private-key","private-key",426483388).cljs$core$IFn$_invoke$arity$1(opts);
var inst_124569 = new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(opts);
var inst_124570 = (inst_124569 == null);
var state_124587__$1 = (function (){var statearr_124592 = state_124587;
(statearr_124592[(8)] = inst_124568);

return statearr_124592;
})();
if(cljs.core.truth_(inst_124570)){
var statearr_124593_124605 = state_124587__$1;
(statearr_124593_124605[(1)] = (5));

} else {
var statearr_124594_124606 = state_124587__$1;
(statearr_124594_124606[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124588 === (5))){
var inst_124572 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_124573 = [new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_124574 = (new cljs.core.PersistentVector(null,1,(5),inst_124572,inst_124573,null));
var inst_124575 = cljs.core.assoc_in.call(null,opts,inst_124574,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_124587__$1 = state_124587;
var statearr_124595_124607 = state_124587__$1;
(statearr_124595_124607[(2)] = inst_124575);

(statearr_124595_124607[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124588 === (6))){
var state_124587__$1 = state_124587;
var statearr_124596_124608 = state_124587__$1;
(statearr_124596_124608[(2)] = opts);

(statearr_124596_124608[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_124588 === (7))){
var inst_124568 = (state_124587[(8)]);
var inst_124578 = (state_124587[(2)]);
var inst_124579 = fluree.db.api_js.qry__GT_command.call(null,ledger,query_map,inst_124568,inst_124578);
var inst_124580 = fluree.db.operations.command_async.call(null,conn,inst_124579);
var state_124587__$1 = state_124587;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_124587__$1,(8),inst_124580);
} else {
if((state_val_124588 === (8))){
var inst_124582 = (state_124587[(2)]);
var inst_124583 = fluree.db.util.async.throw_err.call(null,inst_124582);
var state_124587__$1 = state_124587;
var statearr_124597_124609 = state_124587__$1;
(statearr_124597_124609[(2)] = inst_124583);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_124587__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__99975__auto__ = null;
var fluree$db$api_js$state_machine__99975__auto____0 = (function (){
var statearr_124598 = [null,null,null,null,null,null,null,null,null];
(statearr_124598[(0)] = fluree$db$api_js$state_machine__99975__auto__);

(statearr_124598[(1)] = (1));

return statearr_124598;
});
var fluree$db$api_js$state_machine__99975__auto____1 = (function (state_124587){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_124587);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e124599){if((e124599 instanceof Object)){
var ex__99978__auto__ = e124599;
var statearr_124600_124610 = state_124587;
(statearr_124600_124610[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_124587);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e124599;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__124611 = state_124587;
state_124587 = G__124611;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__99975__auto__ = function(state_124587){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__99975__auto____1.call(this,state_124587);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__99975__auto____0;
fluree$db$api_js$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__99975__auto____1;
return fluree$db$api_js$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_124601 = f__100070__auto__.call(null);
(statearr_124601[(6)] = c__100069__auto__);

return statearr_124601;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.api_js.signed_query_async.cljs$lang$maxFixedArity = 4);

