// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.crypto.aes');
goog.require('cljs.core');
goog.require('alphabase.core');
goog.require('fluree.crypto.util');
goog.require('goog.crypt.Aes');
goog.require('goog.crypt.Cbc');
goog.require('fluree.crypto.pkcs7');
fluree.crypto.aes.encrypt_STAR_ = (function fluree$crypto$aes$encrypt_STAR_(iv,key_ba,ba){
var cipher = (new goog.crypt.Aes(key_ba));
var cbc = (new goog.crypt.Cbc(cipher));
var padded = fluree.crypto.pkcs7.encode.call(null,(16),ba);
return cbc.encrypt(padded,cljs.core.clj__GT_js.call(null,iv));
});
/**
 * Encrypts with AES/CBC/PKCS{5/7}Padding by hashing a 256 bit key out
 *   of key (requires Unlimited Strength crypto to be enabled).
 *   You can provide an alternate initial vector of unsigned(!) bytes of size 16 for CBC.
 */
fluree.crypto.aes.encrypt = (function fluree$crypto$aes$encrypt(var_args){
var args__4742__auto__ = [];
var len__4736__auto___120722 = arguments.length;
var i__4737__auto___120723 = (0);
while(true){
if((i__4737__auto___120723 < len__4736__auto___120722)){
args__4742__auto__.push((arguments[i__4737__auto___120723]));

var G__120724 = (i__4737__auto___120723 + (1));
i__4737__auto___120723 = G__120724;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return fluree.crypto.aes.encrypt.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});
goog.exportSymbol('fluree.crypto.aes.encrypt', fluree.crypto.aes.encrypt);

(fluree.crypto.aes.encrypt.cljs$core$IFn$_invoke$arity$variadic = (function (x,key,p__120715){
var vec__120716 = p__120715;
var map__120719 = cljs.core.nth.call(null,vec__120716,(0),null);
var map__120719__$1 = (((((!((map__120719 == null))))?(((((map__120719.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__120719.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__120719):map__120719);
var iv = cljs.core.get.call(null,map__120719__$1,new cljs.core.Keyword(null,"iv","iv",-1550102132),new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, [(6),(224),(71),(170),(241),(204),(115),(21),(30),(8),(46),(223),(106),(207),(55),(42)], null));
var output_format = cljs.core.get.call(null,map__120719__$1,new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"hex","hex",41691346));
var key_ba = ((typeof key === 'string')?fluree.crypto.util.hash_string_key.call(null,key,(32)):key);
var ba = ((typeof x === 'string')?alphabase.core.string__GT_bytes.call(null,x):x);
var encrypted = fluree.crypto.aes.encrypt_STAR_.call(null,iv,key_ba,ba);
var G__120721 = cljs.core.keyword.call(null,output_format);
var G__120721__$1 = (((G__120721 instanceof cljs.core.Keyword))?G__120721.fqn:null);
switch (G__120721__$1) {
case "none":
return encrypted;

break;
case "hex":
return alphabase.core.bytes__GT_hex.call(null,encrypted);

break;
case "base64":
return alphabase.core.bytes__GT_base64.call(null,encrypted);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__120721__$1)].join('')));

}
}));

(fluree.crypto.aes.encrypt.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.crypto.aes.encrypt.cljs$lang$applyTo = (function (seq120712){
var G__120713 = cljs.core.first.call(null,seq120712);
var seq120712__$1 = cljs.core.next.call(null,seq120712);
var G__120714 = cljs.core.first.call(null,seq120712__$1);
var seq120712__$2 = cljs.core.next.call(null,seq120712__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__120713,G__120714,seq120712__$2);
}));

fluree.crypto.aes.decrypt_STAR_ = (function fluree$crypto$aes$decrypt_STAR_(iv,key_ba,x_ba){
var cipher = (new goog.crypt.Aes(key_ba));
var cbc = (new goog.crypt.Cbc(cipher));
return fluree.crypto.pkcs7.decode.call(null,(16),cbc.decrypt(x_ba,cljs.core.clj__GT_js.call(null,iv)));
});
/**
 * Decrypts with AES/CBC/PKCS{5/7}Padding by hashing a 256 bit key out of key.
 *   You can provide an alternate initial vector of unsigned(!) bytes of size 16 for CBC.
 */
fluree.crypto.aes.decrypt = (function fluree$crypto$aes$decrypt(var_args){
var args__4742__auto__ = [];
var len__4736__auto___120738 = arguments.length;
var i__4737__auto___120739 = (0);
while(true){
if((i__4737__auto___120739 < len__4736__auto___120738)){
args__4742__auto__.push((arguments[i__4737__auto___120739]));

var G__120740 = (i__4737__auto___120739 + (1));
i__4737__auto___120739 = G__120740;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return fluree.crypto.aes.decrypt.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});
goog.exportSymbol('fluree.crypto.aes.decrypt', fluree.crypto.aes.decrypt);

(fluree.crypto.aes.decrypt.cljs$core$IFn$_invoke$arity$variadic = (function (x,key,p__120730){
var vec__120731 = p__120730;
var map__120734 = cljs.core.nth.call(null,vec__120731,(0),null);
var map__120734__$1 = (((((!((map__120734 == null))))?(((((map__120734.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__120734.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__120734):map__120734);
var iv = cljs.core.get.call(null,map__120734__$1,new cljs.core.Keyword(null,"iv","iv",-1550102132),new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, [(6),(224),(71),(170),(241),(204),(115),(21),(30),(8),(46),(223),(106),(207),(55),(42)], null));
var input_format = cljs.core.get.call(null,map__120734__$1,new cljs.core.Keyword(null,"input-format","input-format",-422703481),new cljs.core.Keyword(null,"hex","hex",41691346));
var output_format = cljs.core.get.call(null,map__120734__$1,new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"string","string",-1989541586));
var key_ba = ((typeof key === 'string')?fluree.crypto.util.hash_string_key.call(null,key,(32)):key);
var x_ba = ((typeof x === 'string')?(function (){var G__120736 = cljs.core.keyword.call(null,input_format);
var G__120736__$1 = (((G__120736 instanceof cljs.core.Keyword))?G__120736.fqn:null);
switch (G__120736__$1) {
case "hex":
return alphabase.core.hex__GT_bytes.call(null,x);

break;
case "base64":
return alphabase.core.base64__GT_bytes.call(null,x);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__120736__$1)].join('')));

}
})():x);
var decrypt_ba = fluree.crypto.aes.decrypt_STAR_.call(null,iv,key_ba,x_ba);
var G__120737 = cljs.core.keyword.call(null,output_format);
var G__120737__$1 = (((G__120737 instanceof cljs.core.Keyword))?G__120737.fqn:null);
switch (G__120737__$1) {
case "none":
return decrypt_ba;

break;
case "hex":
return alphabase.core.bytes__GT_hex.call(null,decrypt_ba);

break;
case "string":
return alphabase.core.bytes__GT_string.call(null,decrypt_ba);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__120737__$1)].join('')));

}
}));

(fluree.crypto.aes.decrypt.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.crypto.aes.decrypt.cljs$lang$applyTo = (function (seq120727){
var G__120728 = cljs.core.first.call(null,seq120727);
var seq120727__$1 = cljs.core.next.call(null,seq120727);
var G__120729 = cljs.core.first.call(null,seq120727__$1);
var seq120727__$2 = cljs.core.next.call(null,seq120727__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__120728,G__120729,seq120727__$2);
}));

