// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('cljs.compiler');
goog.require('cljs.core');
goog.require('goog.string');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.tools.reader');
goog.require('cljs.env');
goog.require('cljs.analyzer');
goog.require('cljs.source_map');
goog.require('goog.string.StringBuffer');
cljs.compiler.js_reserved = cljs.analyzer.js_reserved;
cljs.compiler.es5_GT__EQ_ = cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.comp.call(null,cljs.core.mapcat.call(null,(function (lang){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lang,cljs.core.keyword.call(null,clojure.string.replace.call(null,cljs.core.name.call(null,lang),/^ecmascript/,"es"))], null);
}))),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ecmascript5","ecmascript5",342717552),new cljs.core.Keyword(null,"ecmascript5-strict","ecmascript5-strict",888234811),new cljs.core.Keyword(null,"ecmascript6","ecmascript6",723864898),new cljs.core.Keyword(null,"ecmascript6-strict","ecmascript6-strict",-786049555),new cljs.core.Keyword(null,"ecmascript-2015","ecmascript-2015",-902254444),new cljs.core.Keyword(null,"ecmascript6-typed","ecmascript6-typed",-1978203054),new cljs.core.Keyword(null,"ecmascript-2016","ecmascript-2016",471574729),new cljs.core.Keyword(null,"ecmascript-2017","ecmascript-2017",620145058),new cljs.core.Keyword(null,"ecmascript-next","ecmascript-next",-1935155962)], null));
cljs.compiler._STAR_recompiled_STAR_ = null;
cljs.compiler._STAR_inputs_STAR_ = null;
cljs.compiler._STAR_source_map_data_STAR_ = null;
cljs.compiler._STAR_source_map_data_gen_col_STAR_ = null;
cljs.compiler._STAR_lexical_renames_STAR_ = cljs.core.PersistentArrayMap.EMPTY;
cljs.compiler.cljs_reserved_file_names = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["deps.cljs",null], null), null);
/**
 * Gets the part up to the first `.` of a namespace.
 * Returns the empty string for nil.
 * Returns the entire string if no `.` in namespace
 */
cljs.compiler.get_first_ns_segment = (function cljs$compiler$get_first_ns_segment(ns){
var ns__$1 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
var idx = ns__$1.indexOf(".");
if(((-1) === idx)){
return ns__$1;
} else {
return cljs.core.subs.call(null,ns__$1,(0),idx);
}
});
cljs.compiler.find_ns_starts_with = (function cljs$compiler$find_ns_starts_with(needle){
return cljs.core.reduce_kv.call(null,(function (xs,ns,_){
if(cljs.core._EQ_.call(null,needle,cljs.compiler.get_first_ns_segment.call(null,ns))){
return cljs.core.reduced.call(null,needle);
} else {
return null;
}
}),null,new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
});
cljs.compiler.shadow_depth = (function cljs$compiler$shadow_depth(s){
var map__119451 = s;
var map__119451__$1 = (((((!((map__119451 == null))))?(((((map__119451.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__119451.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__119451):map__119451);
var name = cljs.core.get.call(null,map__119451__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.call(null,map__119451__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var d = (0);
var G__119454 = info;
var map__119455 = G__119454;
var map__119455__$1 = (((((!((map__119455 == null))))?(((((map__119455.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__119455.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__119455):map__119455);
var shadow = cljs.core.get.call(null,map__119455__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
var d__$1 = d;
var G__119454__$1 = G__119454;
while(true){
var d__$2 = d__$1;
var map__119459 = G__119454__$1;
var map__119459__$1 = (((((!((map__119459 == null))))?(((((map__119459.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__119459.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__119459):map__119459);
var shadow__$1 = cljs.core.get.call(null,map__119459__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
if(cljs.core.truth_(shadow__$1)){
var G__119461 = (d__$2 + (1));
var G__119462 = shadow__$1;
d__$1 = G__119461;
G__119454__$1 = G__119462;
continue;
} else {
if(cljs.core.truth_(cljs.compiler.find_ns_starts_with.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)))){
return (d__$2 + (1));
} else {
return d__$2;

}
}
break;
}
});
cljs.compiler.hash_scope = (function cljs$compiler$hash_scope(s){
return cljs.core.hash_combine.call(null,cljs.core._hash.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(s)),cljs.compiler.shadow_depth.call(null,s));
});
cljs.compiler.fn_self_name = (function cljs$compiler$fn_self_name(p__119463){
var map__119464 = p__119463;
var map__119464__$1 = (((((!((map__119464 == null))))?(((((map__119464.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__119464.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__119464):map__119464);
var name_var = map__119464__$1;
var name = cljs.core.get.call(null,map__119464__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.call(null,map__119464__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var name__$1 = clojure.string.replace.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"..","_DOT__DOT_");
var map__119466 = info;
var map__119466__$1 = (((((!((map__119466 == null))))?(((((map__119466.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__119466.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__119466):map__119466);
var ns = cljs.core.get.call(null,map__119466__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var fn_scope = cljs.core.get.call(null,map__119466__$1,new cljs.core.Keyword(null,"fn-scope","fn-scope",-865664859));
var scoped_name = cljs.core.apply.call(null,cljs.core.str,cljs.core.interpose.call(null,"_$_",cljs.core.concat.call(null,cljs.core.map.call(null,cljs.core.comp.call(null,cljs.core.str,new cljs.core.Keyword(null,"name","name",1843675177)),fn_scope),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [name__$1], null))));
return cljs.core.symbol.call(null,cljs.compiler.munge.call(null,[clojure.string.replace.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),".","$"),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(scoped_name)].join('')));
});
cljs.compiler.munge_reserved = (function cljs$compiler$munge_reserved(reserved){
return (function (s){
if((!((cljs.core.get.call(null,reserved,s) == null)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"$"].join('');
} else {
return s;
}
});
});
cljs.compiler.munge = (function cljs$compiler$munge(var_args){
var G__119469 = arguments.length;
switch (G__119469) {
case 1:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.compiler.munge.call(null,s,cljs.compiler.js_reserved);
}));

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2 = (function (s,reserved){
if(cljs.analyzer.cljs_map_QMARK_.call(null,s)){
var name_var = s;
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(name_var);
var field = new cljs.core.Keyword(null,"field","field",-1302436500).cljs$core$IFn$_invoke$arity$1(name_var);
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(name_var);
if((!((new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531).cljs$core$IFn$_invoke$arity$1(info) == null)))){
return cljs.compiler.fn_self_name.call(null,s);
} else {
var depth = cljs.compiler.shadow_depth.call(null,s);
var code = cljs.compiler.hash_scope.call(null,s);
var renamed = cljs.core.get.call(null,cljs.compiler._STAR_lexical_renames_STAR_,code);
var name__$1 = ((field === true)?["self__.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):(((!((renamed == null))))?renamed:name
));
var munged_name = cljs.compiler.munge.call(null,name__$1,reserved);
if(((field === true) || ((depth === (0))))){
return munged_name;
} else {
return cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(munged_name),"__$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(depth)].join(''));
}
}
} else {
var ss = clojure.string.replace.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"..","_DOT__DOT_");
var ss__$1 = clojure.string.replace.call(null,ss,(new RegExp("\\/(.)")),".$1");
var rf = cljs.compiler.munge_reserved.call(null,reserved);
var ss__$2 = cljs.core.map.call(null,rf,clojure.string.split.call(null,ss__$1,/\./));
var ss__$3 = clojure.string.join.call(null,".",ss__$2);
var ms = new cljs.core.Var(function(){return cljs.core.munge_str;},new cljs.core.Symbol("cljs.core","munge-str","cljs.core/munge-str",-301346665,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[true,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"munge-str","munge-str",-2042069652,null),"cljs/core.cljs",25,1,11501,11501,new cljs.core.Symbol(null,"string","string",-349010059,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"name","name",-810760592,null)], null)),null,(cljs.core.truth_(cljs.core.munge_str)?cljs.core.munge_str.cljs$lang$test:null)])).call(null,ss__$3);
if((s instanceof cljs.core.Symbol)){
return cljs.core.symbol.call(null,ms);
} else {
return ms;
}
}
}));

(cljs.compiler.munge.cljs$lang$maxFixedArity = 2);

cljs.compiler.comma_sep = (function cljs$compiler$comma_sep(xs){
return cljs.core.interpose.call(null,",",xs);
});
cljs.compiler.escape_char = (function cljs$compiler$escape_char(c){
var cp = goog.string.hashCode(c);
var G__119471 = cp;
switch (G__119471) {
case (34):
return "\\\"";

break;
case (92):
return "\\\\";

break;
case (8):
return "\\b";

break;
case (12):
return "\\f";

break;
case (10):
return "\\n";

break;
case (13):
return "\\r";

break;
case (9):
return "\\t";

break;
default:
if(((((31) < cp)) && ((cp < (127))))){
return c;
} else {
var unpadded = cp.toString((16));
var pad = cljs.core.subs.call(null,"0000",unpadded.length);
return ["\\u",pad,cljs.core.str.cljs$core$IFn$_invoke$arity$1(unpadded)].join('');
}

}
});
cljs.compiler.escape_string = (function cljs$compiler$escape_string(s){
var sb = (new goog.string.StringBuffer());
var seq__119473_119477 = cljs.core.seq.call(null,s);
var chunk__119474_119478 = null;
var count__119475_119479 = (0);
var i__119476_119480 = (0);
while(true){
if((i__119476_119480 < count__119475_119479)){
var c_119481 = cljs.core._nth.call(null,chunk__119474_119478,i__119476_119480);
sb.append(cljs.compiler.escape_char.call(null,c_119481));


var G__119482 = seq__119473_119477;
var G__119483 = chunk__119474_119478;
var G__119484 = count__119475_119479;
var G__119485 = (i__119476_119480 + (1));
seq__119473_119477 = G__119482;
chunk__119474_119478 = G__119483;
count__119475_119479 = G__119484;
i__119476_119480 = G__119485;
continue;
} else {
var temp__5735__auto___119486 = cljs.core.seq.call(null,seq__119473_119477);
if(temp__5735__auto___119486){
var seq__119473_119487__$1 = temp__5735__auto___119486;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__119473_119487__$1)){
var c__4556__auto___119488 = cljs.core.chunk_first.call(null,seq__119473_119487__$1);
var G__119489 = cljs.core.chunk_rest.call(null,seq__119473_119487__$1);
var G__119490 = c__4556__auto___119488;
var G__119491 = cljs.core.count.call(null,c__4556__auto___119488);
var G__119492 = (0);
seq__119473_119477 = G__119489;
chunk__119474_119478 = G__119490;
count__119475_119479 = G__119491;
i__119476_119480 = G__119492;
continue;
} else {
var c_119493 = cljs.core.first.call(null,seq__119473_119487__$1);
sb.append(cljs.compiler.escape_char.call(null,c_119493));


var G__119494 = cljs.core.next.call(null,seq__119473_119487__$1);
var G__119495 = null;
var G__119496 = (0);
var G__119497 = (0);
seq__119473_119477 = G__119494;
chunk__119474_119478 = G__119495;
count__119475_119479 = G__119496;
i__119476_119480 = G__119497;
continue;
}
} else {
}
}
break;
}

return sb.toString();
});
cljs.compiler.wrap_in_double_quotes = (function cljs$compiler$wrap_in_double_quotes(x){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"\""].join('');
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_STAR_ = (function (){var method_table__4619__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4620__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4621__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4622__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4623__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"cljs.compiler","emit*"),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4623__auto__,method_table__4619__auto__,prefer_table__4620__auto__,method_cache__4621__auto__,cached_hierarchy__4622__auto__));
})();
}
cljs.compiler.emit = (function cljs$compiler$emit(ast){
if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
var map__119498_119503 = ast;
var map__119498_119504__$1 = (((((!((map__119498_119503 == null))))?(((((map__119498_119503.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__119498_119503.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__119498_119503):map__119498_119503);
var env_119505 = cljs.core.get.call(null,map__119498_119504__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core.truth_(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(env_119505))){
var map__119500_119506 = env_119505;
var map__119500_119507__$1 = (((((!((map__119500_119506 == null))))?(((((map__119500_119506.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__119500_119506.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__119500_119506):map__119500_119506);
var line_119508 = cljs.core.get.call(null,map__119500_119507__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_119509 = cljs.core.get.call(null,map__119500_119507__$1,new cljs.core.Keyword(null,"column","column",2078222095));
cljs.core.swap_BANG_.call(null,cljs.compiler._STAR_source_map_data_STAR_,(function (m){
var minfo = (function (){var G__119502 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gcol","gcol",309250807),new cljs.core.Keyword(null,"gen-col","gen-col",1901918303).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"gline","gline",-1086242431),new cljs.core.Keyword(null,"gen-line","gen-line",589592125).cljs$core$IFn$_invoke$arity$1(m)], null);
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"binding","binding",539932593),null,new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null).call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(ast)))){
return cljs.core.assoc.call(null,G__119502,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(ast))));
} else {
return G__119502;
}
})();
return cljs.core.update_in.call(null,m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"source-map","source-map",1706252311),(line_119508 - (1))], null),cljs.core.fnil.call(null,(function (line__$1){
return cljs.core.update_in.call(null,line__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(column_119509)?(column_119509 - (1)):(0))], null),cljs.core.fnil.call(null,(function (column__$1){
return cljs.core.conj.call(null,column__$1,minfo);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map.call(null)));
}));
} else {
}
} else {
}

return cljs.compiler.emit_STAR_.call(null,ast);
});
cljs.compiler.emits = (function cljs$compiler$emits(var_args){
var G__119518 = arguments.length;
switch (G__119518) {
case 0:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4757__auto__ = [];
var len__4736__auto___119525 = arguments.length;
var i__4737__auto___119526 = (0);
while(true){
if((i__4737__auto___119526 < len__4736__auto___119525)){
args_arr__4757__auto__.push((arguments[i__4737__auto___119526]));

var G__119527 = (i__4737__auto___119526 + (1));
i__4737__auto___119526 = G__119527;
continue;
} else {
}
break;
}

var argseq__4758__auto__ = (new cljs.core.IndexedSeq(args_arr__4757__auto__.slice((5)),(0),null));
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4758__auto__);

}
});

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0 = (function (){
return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1 = (function (a){
if((a == null)){
} else {
if(cljs.analyzer.cljs_map_QMARK_.call(null,a)){
cljs.compiler.emit.call(null,a);
} else {
if(cljs.analyzer.cljs_seq_QMARK_.call(null,a)){
cljs.core.apply.call(null,cljs.compiler.emits,a);
} else {
if(goog.isFunction(a)){
a.call(null);
} else {
var s_119528 = (function (){var G__119519 = a;
if((!(typeof a === 'string'))){
return G__119519.toString();
} else {
return G__119519;
}
})();
var temp__5739__auto___119529 = cljs.compiler._STAR_source_map_data_STAR_;
if((temp__5739__auto___119529 == null)){
} else {
var sm_data_119530 = temp__5739__auto___119529;
cljs.core.swap_BANG_.call(null,sm_data_119530,cljs.core.update,new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(function (p1__119510_SHARP_){
return (p1__119510_SHARP_ + s_119528.length);
}));
}

cljs.core.print.call(null,s_119528);

}
}
}
}

return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.call(null,a);

return cljs.compiler.emits.call(null,b);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

return cljs.compiler.emits.call(null,c);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

return cljs.compiler.emits.call(null,d);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

cljs.compiler.emits.call(null,d);

return cljs.compiler.emits.call(null,e);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

cljs.compiler.emits.call(null,d);

cljs.compiler.emits.call(null,e);

var seq__119520 = cljs.core.seq.call(null,xs);
var chunk__119521 = null;
var count__119522 = (0);
var i__119523 = (0);
while(true){
if((i__119523 < count__119522)){
var x = cljs.core._nth.call(null,chunk__119521,i__119523);
cljs.compiler.emits.call(null,x);


var G__119531 = seq__119520;
var G__119532 = chunk__119521;
var G__119533 = count__119522;
var G__119534 = (i__119523 + (1));
seq__119520 = G__119531;
chunk__119521 = G__119532;
count__119522 = G__119533;
i__119523 = G__119534;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__119520);
if(temp__5735__auto__){
var seq__119520__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__119520__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__119520__$1);
var G__119535 = cljs.core.chunk_rest.call(null,seq__119520__$1);
var G__119536 = c__4556__auto__;
var G__119537 = cljs.core.count.call(null,c__4556__auto__);
var G__119538 = (0);
seq__119520 = G__119535;
chunk__119521 = G__119536;
count__119522 = G__119537;
i__119523 = G__119538;
continue;
} else {
var x = cljs.core.first.call(null,seq__119520__$1);
cljs.compiler.emits.call(null,x);


var G__119539 = cljs.core.next.call(null,seq__119520__$1);
var G__119540 = null;
var G__119541 = (0);
var G__119542 = (0);
seq__119520 = G__119539;
chunk__119521 = G__119540;
count__119522 = G__119541;
i__119523 = G__119542;
continue;
}
} else {
return null;
}
}
break;
}
}));

/** @this {Function} */
(cljs.compiler.emits.cljs$lang$applyTo = (function (seq119512){
var G__119513 = cljs.core.first.call(null,seq119512);
var seq119512__$1 = cljs.core.next.call(null,seq119512);
var G__119514 = cljs.core.first.call(null,seq119512__$1);
var seq119512__$2 = cljs.core.next.call(null,seq119512__$1);
var G__119515 = cljs.core.first.call(null,seq119512__$2);
var seq119512__$3 = cljs.core.next.call(null,seq119512__$2);
var G__119516 = cljs.core.first.call(null,seq119512__$3);
var seq119512__$4 = cljs.core.next.call(null,seq119512__$3);
var G__119517 = cljs.core.first.call(null,seq119512__$4);
var seq119512__$5 = cljs.core.next.call(null,seq119512__$4);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__119513,G__119514,G__119515,G__119516,G__119517,seq119512__$5);
}));

(cljs.compiler.emits.cljs$lang$maxFixedArity = (5));

cljs.compiler._emitln = (function cljs$compiler$_emitln(){
cljs.core.newline.call(null);

if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
cljs.core.swap_BANG_.call(null,cljs.compiler._STAR_source_map_data_STAR_,(function (p__119543){
var map__119544 = p__119543;
var map__119544__$1 = (((((!((map__119544 == null))))?(((((map__119544.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__119544.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__119544):map__119544);
var m = map__119544__$1;
var gen_line = cljs.core.get.call(null,map__119544__$1,new cljs.core.Keyword(null,"gen-line","gen-line",589592125));
return cljs.core.assoc.call(null,m,new cljs.core.Keyword(null,"gen-line","gen-line",589592125),(gen_line + (1)),new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(0));
}));
} else {
}

return null;
});
cljs.compiler.emitln = (function cljs$compiler$emitln(var_args){
var G__119553 = arguments.length;
switch (G__119553) {
case 0:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4757__auto__ = [];
var len__4736__auto___119559 = arguments.length;
var i__4737__auto___119560 = (0);
while(true){
if((i__4737__auto___119560 < len__4736__auto___119559)){
args_arr__4757__auto__.push((arguments[i__4737__auto___119560]));

var G__119561 = (i__4737__auto___119560 + (1));
i__4737__auto___119560 = G__119561;
continue;
} else {
}
break;
}

var argseq__4758__auto__ = (new cljs.core.IndexedSeq(args_arr__4757__auto__.slice((5)),(0),null));
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4758__auto__);

}
});

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1 = (function (a){
cljs.compiler.emits.call(null,a);

return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

cljs.compiler.emits.call(null,d);

return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

cljs.compiler.emits.call(null,d);

cljs.compiler.emits.call(null,e);

return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

cljs.compiler.emits.call(null,d);

cljs.compiler.emits.call(null,e);

var seq__119554_119562 = cljs.core.seq.call(null,xs);
var chunk__119555_119563 = null;
var count__119556_119564 = (0);
var i__119557_119565 = (0);
while(true){
if((i__119557_119565 < count__119556_119564)){
var x_119566 = cljs.core._nth.call(null,chunk__119555_119563,i__119557_119565);
cljs.compiler.emits.call(null,x_119566);


var G__119567 = seq__119554_119562;
var G__119568 = chunk__119555_119563;
var G__119569 = count__119556_119564;
var G__119570 = (i__119557_119565 + (1));
seq__119554_119562 = G__119567;
chunk__119555_119563 = G__119568;
count__119556_119564 = G__119569;
i__119557_119565 = G__119570;
continue;
} else {
var temp__5735__auto___119571 = cljs.core.seq.call(null,seq__119554_119562);
if(temp__5735__auto___119571){
var seq__119554_119572__$1 = temp__5735__auto___119571;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__119554_119572__$1)){
var c__4556__auto___119573 = cljs.core.chunk_first.call(null,seq__119554_119572__$1);
var G__119574 = cljs.core.chunk_rest.call(null,seq__119554_119572__$1);
var G__119575 = c__4556__auto___119573;
var G__119576 = cljs.core.count.call(null,c__4556__auto___119573);
var G__119577 = (0);
seq__119554_119562 = G__119574;
chunk__119555_119563 = G__119575;
count__119556_119564 = G__119576;
i__119557_119565 = G__119577;
continue;
} else {
var x_119578 = cljs.core.first.call(null,seq__119554_119572__$1);
cljs.compiler.emits.call(null,x_119578);


var G__119579 = cljs.core.next.call(null,seq__119554_119572__$1);
var G__119580 = null;
var G__119581 = (0);
var G__119582 = (0);
seq__119554_119562 = G__119579;
chunk__119555_119563 = G__119580;
count__119556_119564 = G__119581;
i__119557_119565 = G__119582;
continue;
}
} else {
}
}
break;
}

return cljs.compiler._emitln.call(null);
}));

/** @this {Function} */
(cljs.compiler.emitln.cljs$lang$applyTo = (function (seq119547){
var G__119548 = cljs.core.first.call(null,seq119547);
var seq119547__$1 = cljs.core.next.call(null,seq119547);
var G__119549 = cljs.core.first.call(null,seq119547__$1);
var seq119547__$2 = cljs.core.next.call(null,seq119547__$1);
var G__119550 = cljs.core.first.call(null,seq119547__$2);
var seq119547__$3 = cljs.core.next.call(null,seq119547__$2);
var G__119551 = cljs.core.first.call(null,seq119547__$3);
var seq119547__$4 = cljs.core.next.call(null,seq119547__$3);
var G__119552 = cljs.core.first.call(null,seq119547__$4);
var seq119547__$5 = cljs.core.next.call(null,seq119547__$4);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__119548,G__119549,G__119550,G__119551,G__119552,seq119547__$5);
}));

(cljs.compiler.emitln.cljs$lang$maxFixedArity = (5));

cljs.compiler.emit_str = (function cljs$compiler$emit_str(expr){
var sb__4667__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__119583_119587 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__119584_119588 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__119585_119589 = true;
var _STAR_print_fn_STAR__temp_val__119586_119590 = (function (x__4668__auto__){
return sb__4667__auto__.append(x__4668__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__119585_119589);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__119586_119590);

try{cljs.compiler.emit.call(null,expr);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__119584_119588);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__119583_119587);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4667__auto__);
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_constant_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_constant_STAR_ = (function (){var method_table__4619__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4620__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4621__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4622__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4623__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"cljs.compiler","emit-constant*"),cljs.core.type,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4623__auto__,method_table__4619__auto__,prefer_table__4620__auto__,method_cache__4621__auto__,cached_hierarchy__4622__auto__));
})();
}









cljs.compiler.all_distinct_QMARK_ = (function cljs$compiler$all_distinct_QMARK_(xs){
return cljs.core.apply.call(null,cljs.core.distinct_QMARK_,xs);
});
cljs.compiler.emit_constant_no_meta = (function cljs$compiler$emit_constant_no_meta(x){
if(cljs.analyzer.cljs_seq_QMARK_.call(null,x)){
return cljs.compiler.emit_list.call(null,x,cljs.compiler.emit_constants_comma_sep);
} else {
if(cljs.core.record_QMARK_.call(null,x)){
var vec__119591 = cljs.analyzer.record_ns_PLUS_name.call(null,x);
var ns = cljs.core.nth.call(null,vec__119591,(0),null);
var name = cljs.core.nth.call(null,vec__119591,(1),null);
return cljs.compiler.emit_record_value.call(null,ns,name,(function (){
return cljs.compiler.emit_constant.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,x));
}));
} else {
if(cljs.analyzer.cljs_map_QMARK_.call(null,x)){
return cljs.compiler.emit_map.call(null,cljs.core.keys.call(null,x),cljs.core.vals.call(null,x),cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_);
} else {
if(cljs.analyzer.cljs_vector_QMARK_.call(null,x)){
return cljs.compiler.emit_vector.call(null,x,cljs.compiler.emit_constants_comma_sep);
} else {
if(cljs.analyzer.cljs_set_QMARK_.call(null,x)){
return cljs.compiler.emit_set.call(null,x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_);
} else {
return cljs.compiler.emit_constant_STAR_.call(null,x);

}
}
}
}
}
});
cljs.compiler.emit_constant = (function cljs$compiler$emit_constant(v){
var m = cljs.analyzer.elide_irrelevant_meta.call(null,cljs.core.meta.call(null,v));
if((!((cljs.core.seq.call(null,m) == null)))){
return cljs.compiler.emit_with_meta.call(null,(function (){
return cljs.compiler.emit_constant_no_meta.call(null,v);
}),(function (){
return cljs.compiler.emit_constant_no_meta.call(null,m);
}));
} else {
return cljs.compiler.emit_constant_no_meta.call(null,v);
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,new cljs.core.Keyword(null,"default","default",-1987822328),(function (x){
throw cljs.core.ex_info.call(null,["failed compiling constant: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"; ",cljs.core.pr_str.call(null,cljs.core.type.call(null,x))," is not a valid ClojureScript constant."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"constant","constant",-379609303),x,new cljs.core.Keyword(null,"type","type",1174270348),cljs.core.type.call(null,x),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,null,(function (x){
return cljs.compiler.emits.call(null,"null");
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,Number,(function (x){
if(cljs.core.truth_(isNaN(x))){
return cljs.compiler.emits.call(null,"NaN");
} else {
if(cljs.core.not.call(null,isFinite(x))){
return cljs.compiler.emits.call(null,(((x > (0)))?"Infinity":"-Infinity"));
} else {
return cljs.compiler.emits.call(null,"(",x,")");

}
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,String,(function (x){
return cljs.compiler.emits.call(null,cljs.compiler.wrap_in_double_quotes.call(null,cljs.compiler.escape_string.call(null,x)));
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,Boolean,(function (x){
return cljs.compiler.emits.call(null,(cljs.core.truth_(x)?"true":"false"));
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,RegExp,(function (x){
if(cljs.core._EQ_.call(null,"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x))){
return cljs.compiler.emits.call(null,"(new RegExp(\"\"))");
} else {
var vec__119594 = cljs.core.re_find.call(null,/^(?:\(\?([idmsux]*)\))?(.*)/,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x));
var _ = cljs.core.nth.call(null,vec__119594,(0),null);
var flags = cljs.core.nth.call(null,vec__119594,(1),null);
var pattern = cljs.core.nth.call(null,vec__119594,(2),null);
return cljs.compiler.emits.call(null,pattern);
}
}));
cljs.compiler.emits_keyword = (function cljs$compiler$emits_keyword(kw){
var ns = cljs.core.namespace.call(null,kw);
var name = cljs.core.name.call(null,kw);
cljs.compiler.emits.call(null,"new cljs.core.Keyword(");

cljs.compiler.emit_constant.call(null,ns);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,name);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,(cljs.core.truth_(ns)?[ns,"/",name].join(''):name));

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,cljs.core.hash.call(null,kw));

return cljs.compiler.emits.call(null,")");
});
cljs.compiler.emits_symbol = (function cljs$compiler$emits_symbol(sym){
var ns = cljs.core.namespace.call(null,sym);
var name = cljs.core.name.call(null,sym);
var symstr = (((!((ns == null))))?[ns,"/",name].join(''):name);
cljs.compiler.emits.call(null,"new cljs.core.Symbol(");

cljs.compiler.emit_constant.call(null,ns);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,name);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,symstr);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,cljs.core.hash.call(null,sym));

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,null);

return cljs.compiler.emits.call(null,")");
});
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,cljs.core.Keyword,(function (x){
var temp__5733__auto__ = (function (){var and__4115__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4115__auto__)){
return x.call(null,new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var value = temp__5733__auto__;
return cljs.compiler.emits.call(null,"cljs.core.",value);
} else {
return cljs.compiler.emits_keyword.call(null,x);
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,cljs.core.Symbol,(function (x){
var temp__5733__auto__ = (function (){var and__4115__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4115__auto__)){
return x.call(null,new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var value = temp__5733__auto__;
return cljs.compiler.emits.call(null,"cljs.core.",value);
} else {
return cljs.compiler.emits_symbol.call(null,x);
}
}));
cljs.compiler.emit_constants_comma_sep = (function cljs$compiler$emit_constants_comma_sep(cs){
return (function (){
return cljs.core.doall.call(null,cljs.core.map_indexed.call(null,(function (i,m){
if(cljs.core.even_QMARK_.call(null,i)){
return cljs.compiler.emit_constant.call(null,m);
} else {
return cljs.compiler.emits.call(null,m);
}
}),cljs.compiler.comma_sep.call(null,cs)));
});
});
cljs.compiler.array_map_threshold = (8);
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,Date,(function (date){
return cljs.compiler.emits.call(null,"new Date(",date.getTime(),")");
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,cljs.core.UUID,(function (uuid){
var uuid_str = uuid.toString();
return cljs.compiler.emits.call(null,"new cljs.core.UUID(\"",uuid_str,"\", ",cljs.core.hash.call(null,uuid_str),")");
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,cljs.tagged_literals.JSValue,(function (v){
var items = v.val;
if(cljs.core.map_QMARK_.call(null,items)){
return cljs.compiler.emit_js_object.call(null,items,(function (p1__119597_SHARP_){
return (function (){
return cljs.compiler.emit_constant.call(null,p1__119597_SHARP_);
});
}));
} else {
return cljs.compiler.emit_js_array.call(null,items,cljs.compiler.emit_constants_comma_sep);
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"no-op","no-op",-93046065),(function (m){
return null;
}));
cljs.compiler.emit_var = (function cljs$compiler$emit_var(p__119599){
var map__119600 = p__119599;
var map__119600__$1 = (((((!((map__119600 == null))))?(((((map__119600.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__119600.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__119600):map__119600);
var ast = map__119600__$1;
var info = cljs.core.get.call(null,map__119600__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var env = cljs.core.get.call(null,map__119600__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var form = cljs.core.get.call(null,map__119600__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var temp__5733__auto__ = new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292).cljs$core$IFn$_invoke$arity$1(ast);
if(cljs.core.truth_(temp__5733__auto__)){
var const_expr = temp__5733__auto__;
return cljs.compiler.emit.call(null,cljs.core.assoc.call(null,const_expr,new cljs.core.Keyword(null,"env","env",-1815813235),env));
} else {
var map__119602 = cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_);
var map__119602__$1 = (((((!((map__119602 == null))))?(((((map__119602.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__119602.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__119602):map__119602);
var cenv = map__119602__$1;
var options = cljs.core.get.call(null,map__119602__$1,new cljs.core.Keyword(null,"options","options",99638489));
var var_name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
var info__$1 = ((cljs.core._EQ_.call(null,cljs.core.namespace.call(null,var_name),"js"))?(function (){var js_module_name = cljs.core.get_in.call(null,cenv,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-module-index","js-module-index",2072061931),cljs.core.name.call(null,var_name),new cljs.core.Keyword(null,"name","name",1843675177)], null));
var or__4126__auto__ = js_module_name;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.name.call(null,var_name);
}
})():info);
if(cljs.core.truth_(new cljs.core.Keyword(null,"binding-form?","binding-form?",1728940169).cljs$core$IFn$_invoke$arity$1(ast))){
return cljs.compiler.emits.call(null,cljs.compiler.munge.call(null,ast));
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var reserved = (function (){var G__119604 = cljs.compiler.js_reserved;
if(cljs.core.truth_((function (){var and__4115__auto__ = cljs.compiler.es5_GT__EQ_.call(null,new cljs.core.Keyword(null,"language-out","language-out",334619882).cljs$core$IFn$_invoke$arity$1(options));
if(cljs.core.truth_(and__4115__auto__)){
return (!((cljs.core.namespace.call(null,var_name) == null)));
} else {
return and__4115__auto__;
}
})())){
return clojure.set.difference.call(null,G__119604,cljs.analyzer.es5_allowed);
} else {
return G__119604;
}
})();
var js_module = cljs.core.get_in.call(null,cenv,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-namespaces","js-namespaces",-471353612),(function (){var or__4126__auto__ = cljs.core.namespace.call(null,var_name);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.name.call(null,var_name);
}
})()], null));
var info__$2 = (function (){var G__119605 = info__$1;
if(cljs.core.not_EQ_.call(null,form,new cljs.core.Symbol("js","-Infinity","js/-Infinity",958706333,null))){
return cljs.compiler.munge.call(null,G__119605,reserved);
} else {
return G__119605;
}
})();
var env__119443__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__119443__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

var G__119606_119607 = new cljs.core.Keyword(null,"module-type","module-type",1392760304).cljs$core$IFn$_invoke$arity$1(js_module);
var G__119606_119608__$1 = (((G__119606_119607 instanceof cljs.core.Keyword))?G__119606_119607.fqn:null);
switch (G__119606_119608__$1) {
case "commonjs":
if(cljs.core.truth_(cljs.core.namespace.call(null,var_name))){
cljs.compiler.emits.call(null,cljs.compiler.munge.call(null,cljs.core.namespace.call(null,var_name),reserved),"[\"default\"].",cljs.compiler.munge.call(null,cljs.core.name.call(null,var_name),reserved));
} else {
cljs.compiler.emits.call(null,cljs.compiler.munge.call(null,cljs.core.name.call(null,var_name),reserved),"[\"default\"]");
}

break;
case "es6":
if(cljs.core.truth_((function (){var and__4115__auto__ = cljs.core.namespace.call(null,var_name);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.call(null,"default",cljs.core.name.call(null,var_name));
} else {
return and__4115__auto__;
}
})())){
cljs.compiler.emits.call(null,cljs.compiler.munge.call(null,cljs.core.namespace.call(null,var_name),reserved),"[\"default\"]");
} else {
cljs.compiler.emits.call(null,info__$2);
}

break;
default:
cljs.compiler.emits.call(null,info__$2);

}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__119443__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}
}
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"var","var",-769682797),(function (expr){
return cljs.compiler.emit_var.call(null,expr);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"binding","binding",539932593),(function (expr){
return cljs.compiler.emit_var.call(null,expr);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),(function (expr){
return cljs.compiler.emit_var.call(null,expr);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"local","local",-1497766724),(function (expr){
return cljs.compiler.emit_var.call(null,expr);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"the-var","the-var",1428415613),(function (p__119610){
var map__119611 = p__119610;
var map__119611__$1 = (((((!((map__119611 == null))))?(((((map__119611.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__119611.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__119611):map__119611);
var arg = map__119611__$1;
var env = cljs.core.get.call(null,map__119611__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var var$ = cljs.core.get.call(null,map__119611__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var sym = cljs.core.get.call(null,map__119611__$1,new cljs.core.Keyword(null,"sym","sym",-1444860305));
var meta = cljs.core.get.call(null,map__119611__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
if(cljs.analyzer.ast_QMARK_.call(null,sym)){
} else {
throw (new Error("Assert failed: (ana/ast? sym)"));
}

if(cljs.analyzer.ast_QMARK_.call(null,meta)){
} else {
throw (new Error("Assert failed: (ana/ast? meta)"));
}

var map__119613 = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(var$);
var map__119613__$1 = (((((!((map__119613 == null))))?(((((map__119613.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__119613.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__119613):map__119613);
var name = cljs.core.get.call(null,map__119613__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env__119443__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__119443__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"new cljs.core.Var(function(){return ",cljs.compiler.munge.call(null,name),";},",sym,",",meta,")");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__119443__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.emit_with_meta = (function cljs$compiler$emit_with_meta(expr,meta){
return cljs.compiler.emits.call(null,"cljs.core.with_meta(",expr,",",meta,")");
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"with-meta","with-meta",-1566856820),(function (p__119615){
var map__119616 = p__119615;
var map__119616__$1 = (((((!((map__119616 == null))))?(((((map__119616.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__119616.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__119616):map__119616);
var expr = cljs.core.get.call(null,map__119616__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var meta = cljs.core.get.call(null,map__119616__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var env = cljs.core.get.call(null,map__119616__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__119443__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__119443__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_with_meta.call(null,expr,meta);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__119443__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.distinct_keys_QMARK_ = (function cljs$compiler$distinct_keys_QMARK_(keys){
var keys__$1 = cljs.core.map.call(null,cljs.analyzer.unwrap_quote,keys);
return ((cljs.core.every_QMARK_.call(null,(function (p1__119618_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__119618_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),keys__$1)) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,keys__$1)),cljs.core.count.call(null,keys__$1))));
});
cljs.compiler.emit_map = (function cljs$compiler$emit_map(keys,vals,comma_sep,distinct_keys_QMARK_){
if((cljs.core.count.call(null,keys) === (0))){
return cljs.compiler.emits.call(null,"cljs.core.PersistentArrayMap.EMPTY");
} else {
if((cljs.core.count.call(null,keys) <= cljs.compiler.array_map_threshold)){
if(cljs.core.truth_(distinct_keys_QMARK_.call(null,keys))){
return cljs.compiler.emits.call(null,"new cljs.core.PersistentArrayMap(null, ",cljs.core.count.call(null,keys),", [",comma_sep.call(null,cljs.core.interleave.call(null,keys,vals)),"], null)");
} else {
return cljs.compiler.emits.call(null,"cljs.core.PersistentArrayMap.createAsIfByAssoc([",comma_sep.call(null,cljs.core.interleave.call(null,keys,vals)),"])");
}
} else {
return cljs.compiler.emits.call(null,"cljs.core.PersistentHashMap.fromArrays([",comma_sep.call(null,keys),"],[",comma_sep.call(null,vals),"])");

}
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"map","map",1371690461),(function (p__119619){
var map__119620 = p__119619;
var map__119620__$1 = (((((!((map__119620 == null))))?(((((map__119620.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__119620.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__119620):map__119620);
var env = cljs.core.get.call(null,map__119620__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var keys = cljs.core.get.call(null,map__119620__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.call(null,map__119620__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env__119443__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__119443__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_map.call(null,keys,vals,cljs.compiler.comma_sep,cljs.compiler.distinct_keys_QMARK_);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__119443__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.emit_list = (function cljs$compiler$emit_list(items,comma_sep){
if(cljs.core.empty_QMARK_.call(null,items)){
return cljs.compiler.emits.call(null,"cljs.core.List.EMPTY");
} else {
return cljs.compiler.emits.call(null,"cljs.core.list(",comma_sep.call(null,items),")");
}
});
cljs.compiler.emit_vector = (function cljs$compiler$emit_vector(items,comma_sep){
if(cljs.core.empty_QMARK_.call(null,items)){
return cljs.compiler.emits.call(null,"cljs.core.PersistentVector.EMPTY");
} else {
var cnt = cljs.core.count.call(null,items);
if((cnt < (32))){
return cljs.compiler.emits.call(null,"new cljs.core.PersistentVector(null, ",cnt,", 5, cljs.core.PersistentVector.EMPTY_NODE, [",comma_sep.call(null,items),"], null)");
} else {
return cljs.compiler.emits.call(null,"cljs.core.PersistentVector.fromArray([",comma_sep.call(null,items),"], true)");
}
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"vector","vector",1902966158),(function (p__119622){
var map__119623 = p__119622;
var map__119623__$1 = (((((!((map__119623 == null))))?(((((map__119623.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__119623.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__119623):map__119623);
var items = cljs.core.get.call(null,map__119623__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.call(null,map__119623__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__119443__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__119443__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_vector.call(null,items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__119443__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.distinct_constants_QMARK_ = (function cljs$compiler$distinct_constants_QMARK_(items){
var items__$1 = cljs.core.map.call(null,cljs.analyzer.unwrap_quote,items);
return ((cljs.core.every_QMARK_.call(null,(function (p1__119625_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__119625_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),items__$1)) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,items__$1)),cljs.core.count.call(null,items__$1))));
});
cljs.compiler.emit_set = (function cljs$compiler$emit_set(items,comma_sep,distinct_constants_QMARK_){
if(cljs.core.empty_QMARK_.call(null,items)){
return cljs.compiler.emits.call(null,"cljs.core.PersistentHashSet.EMPTY");
} else {
if(cljs.core.truth_(distinct_constants_QMARK_.call(null,items))){
return cljs.compiler.emits.call(null,"new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, ",cljs.core.count.call(null,items),", [",comma_sep.call(null,cljs.core.interleave.call(null,items,cljs.core.repeat.call(null,"null"))),"], null), null)");
} else {
return cljs.compiler.emits.call(null,"cljs.core.PersistentHashSet.createAsIfByAssoc([",comma_sep.call(null,items),"])");

}
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"set","set",304602554),(function (p__119626){
var map__119627 = p__119626;
var map__119627__$1 = (((((!((map__119627 == null))))?(((((map__119627.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__119627.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__119627):map__119627);
var items = cljs.core.get.call(null,map__119627__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.call(null,map__119627__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__119443__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__119443__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_set.call(null,items,cljs.compiler.comma_sep,cljs.compiler.distinct_constants_QMARK_);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__119443__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.emit_js_object = (function cljs$compiler$emit_js_object(items,emit_js_object_val){
cljs.compiler.emits.call(null,"({");

var temp__5735__auto___119651 = cljs.core.seq.call(null,items);
if(temp__5735__auto___119651){
var items_119652__$1 = temp__5735__auto___119651;
var vec__119629_119653 = items_119652__$1;
var seq__119630_119654 = cljs.core.seq.call(null,vec__119629_119653);
var first__119631_119655 = cljs.core.first.call(null,seq__119630_119654);
var seq__119630_119656__$1 = cljs.core.next.call(null,seq__119630_119654);
var vec__119632_119657 = first__119631_119655;
var k_119658 = cljs.core.nth.call(null,vec__119632_119657,(0),null);
var v_119659 = cljs.core.nth.call(null,vec__119632_119657,(1),null);
var r_119660 = seq__119630_119656__$1;
cljs.compiler.emits.call(null,"\"",cljs.core.name.call(null,k_119658),"\": ",emit_js_object_val.call(null,v_119659));

var seq__119635_119661 = cljs.core.seq.call(null,r_119660);
var chunk__119636_119662 = null;
var count__119637_119663 = (0);
var i__119638_119664 = (0);
while(true){
if((i__119638_119664 < count__119637_119663)){
var vec__119645_119665 = cljs.core._nth.call(null,chunk__119636_119662,i__119638_119664);
var k_119666__$1 = cljs.core.nth.call(null,vec__119645_119665,(0),null);
var v_119667__$1 = cljs.core.nth.call(null,vec__119645_119665,(1),null);
cljs.compiler.emits.call(null,", \"",cljs.core.name.call(null,k_119666__$1),"\": ",emit_js_object_val.call(null,v_119667__$1));


var G__119668 = seq__119635_119661;
var G__119669 = chunk__119636_119662;
var G__119670 = count__119637_119663;
var G__119671 = (i__119638_119664 + (1));
seq__119635_119661 = G__119668;
chunk__119636_119662 = G__119669;
count__119637_119663 = G__119670;
i__119638_119664 = G__119671;
continue;
} else {
var temp__5735__auto___119672__$1 = cljs.core.seq.call(null,seq__119635_119661);
if(temp__5735__auto___119672__$1){
var seq__119635_119673__$1 = temp__5735__auto___119672__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__119635_119673__$1)){
var c__4556__auto___119674 = cljs.core.chunk_first.call(null,seq__119635_119673__$1);
var G__119675 = cljs.core.chunk_rest.call(null,seq__119635_119673__$1);
var G__119676 = c__4556__auto___119674;
var G__119677 = cljs.core.count.call(null,c__4556__auto___119674);
var G__119678 = (0);
seq__119635_119661 = G__119675;
chunk__119636_119662 = G__119676;
count__119637_119663 = G__119677;
i__119638_119664 = G__119678;
continue;
} else {
var vec__119648_119679 = cljs.core.first.call(null,seq__119635_119673__$1);
var k_119680__$1 = cljs.core.nth.call(null,vec__119648_119679,(0),null);
var v_119681__$1 = cljs.core.nth.call(null,vec__119648_119679,(1),null);
cljs.compiler.emits.call(null,", \"",cljs.core.name.call(null,k_119680__$1),"\": ",emit_js_object_val.call(null,v_119681__$1));


var G__119682 = cljs.core.next.call(null,seq__119635_119673__$1);
var G__119683 = null;
var G__119684 = (0);
var G__119685 = (0);
seq__119635_119661 = G__119682;
chunk__119636_119662 = G__119683;
count__119637_119663 = G__119684;
i__119638_119664 = G__119685;
continue;
}
} else {
}
}
break;
}
} else {
}

return cljs.compiler.emits.call(null,"})");
});
cljs.compiler.emit_js_array = (function cljs$compiler$emit_js_array(items,comma_sep){
return cljs.compiler.emits.call(null,"[",comma_sep.call(null,items),"]");
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"js-object","js-object",1830199158),(function (p__119686){
var map__119687 = p__119686;
var map__119687__$1 = (((((!((map__119687 == null))))?(((((map__119687.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__119687.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__119687):map__119687);
var keys = cljs.core.get.call(null,map__119687__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.call(null,map__119687__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env = cljs.core.get.call(null,map__119687__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__119443__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__119443__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_js_object.call(null,cljs.core.map.call(null,cljs.core.vector,keys,vals),cljs.core.identity);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__119443__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"js-array","js-array",-1210185421),(function (p__119689){
var map__119690 = p__119689;
var map__119690__$1 = (((((!((map__119690 == null))))?(((((map__119690.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__119690.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__119690):map__119690);
var items = cljs.core.get.call(null,map__119690__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.call(null,map__119690__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__119443__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__119443__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_js_array.call(null,items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__119443__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.emit_record_value = (function cljs$compiler$emit_record_value(ns,name,items){
return cljs.compiler.emits.call(null,ns,".map__GT_",name,"(",items,")");
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"quote","quote",-262615245),(function (p__119692){
var map__119693 = p__119692;
var map__119693__$1 = (((((!((map__119693 == null))))?(((((map__119693.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__119693.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__119693):map__119693);
var expr = cljs.core.get.call(null,map__119693__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
return cljs.compiler.emit.call(null,expr);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"const","const",1709929842),(function (p__119695){
var map__119696 = p__119695;
var map__119696__$1 = (((((!((map__119696 == null))))?(((((map__119696.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__119696.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__119696):map__119696);
var form = cljs.core.get.call(null,map__119696__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var env = cljs.core.get.call(null,map__119696__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var env__119443__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__119443__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_constant.call(null,form);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__119443__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}
}));
cljs.compiler.truthy_constant_QMARK_ = (function cljs$compiler$truthy_constant_QMARK_(expr){
var map__119698 = cljs.analyzer.unwrap_quote.call(null,expr);
var map__119698__$1 = (((((!((map__119698 == null))))?(((((map__119698.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__119698.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__119698):map__119698);
var op = cljs.core.get.call(null,map__119698__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.call(null,map__119698__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.call(null,map__119698__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__4126__auto__ = ((cljs.core._EQ_.call(null,op,new cljs.core.Keyword(null,"const","const",1709929842)))?(function (){var and__4115__auto__ = form;
if(cljs.core.truth_(and__4115__auto__)){
return (!(((((typeof form === 'string') && (cljs.core._EQ_.call(null,form,"")))) || (((typeof form === 'number') && ((form === (0))))))));
} else {
return and__4115__auto__;
}
})():false);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if((!((const_expr == null)))){
return cljs.compiler.truthy_constant_QMARK_.call(null,const_expr);
} else {
return false;
}
}
});
cljs.compiler.falsey_constant_QMARK_ = (function cljs$compiler$falsey_constant_QMARK_(expr){
var map__119700 = cljs.analyzer.unwrap_quote.call(null,expr);
var map__119700__$1 = (((((!((map__119700 == null))))?(((((map__119700.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__119700.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__119700):map__119700);
var op = cljs.core.get.call(null,map__119700__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.call(null,map__119700__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.call(null,map__119700__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__4126__auto__ = ((cljs.core._EQ_.call(null,op,new cljs.core.Keyword(null,"const","const",1709929842))) && (((form === false) || ((form == null)))));
if(or__4126__auto__){
return or__4126__auto__;
} else {
if((!((const_expr == null)))){
return cljs.compiler.falsey_constant_QMARK_.call(null,const_expr);
} else {
return false;
}
}
});
cljs.compiler.safe_test_QMARK_ = (function cljs$compiler$safe_test_QMARK_(env,e){
var tag = cljs.analyzer.infer_tag.call(null,env,e);
var or__4126__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"seq","seq",-177272256,null),null,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),null], null), null).call(null,tag);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.compiler.truthy_constant_QMARK_.call(null,e);
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"if","if",-458814265),(function (p__119702){
var map__119703 = p__119702;
var map__119703__$1 = (((((!((map__119703 == null))))?(((((map__119703.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__119703.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__119703):map__119703);
var test = cljs.core.get.call(null,map__119703__$1,new cljs.core.Keyword(null,"test","test",577538877));
var then = cljs.core.get.call(null,map__119703__$1,new cljs.core.Keyword(null,"then","then",460598070));
var else$ = cljs.core.get.call(null,map__119703__$1,new cljs.core.Keyword(null,"else","else",-1508377146));
var env = cljs.core.get.call(null,map__119703__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var unchecked = cljs.core.get.call(null,map__119703__$1,new cljs.core.Keyword(null,"unchecked","unchecked",924418378));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
var checked = cljs.core.not.call(null,(function (){var or__4126__auto__ = unchecked;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.compiler.safe_test_QMARK_.call(null,env,test);
}
})());
if(cljs.core.truth_(cljs.compiler.truthy_constant_QMARK_.call(null,test))){
return cljs.compiler.emitln.call(null,then);
} else {
if(cljs.core.truth_(cljs.compiler.falsey_constant_QMARK_.call(null,test))){
return cljs.compiler.emitln.call(null,else$);
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"(",((checked)?"cljs.core.truth_":null),"(",test,")?",then,":",else$,")");
} else {
if(checked){
cljs.compiler.emitln.call(null,"if(cljs.core.truth_(",test,")){");
} else {
cljs.compiler.emitln.call(null,"if(",test,"){");
}

cljs.compiler.emitln.call(null,then,"} else {");

return cljs.compiler.emitln.call(null,else$,"}");
}

}
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"case","case",1143702196),(function (p__119705){
var map__119706 = p__119705;
var map__119706__$1 = (((((!((map__119706 == null))))?(((((map__119706.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__119706.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__119706):map__119706);
var v = cljs.core.get.call(null,map__119706__$1,new cljs.core.Keyword(null,"test","test",577538877));
var nodes = cljs.core.get.call(null,map__119706__$1,new cljs.core.Keyword(null,"nodes","nodes",-2099585805));
var default$ = cljs.core.get.call(null,map__119706__$1,new cljs.core.Keyword(null,"default","default",-1987822328));
var env = cljs.core.get.call(null,map__119706__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env),new cljs.core.Keyword(null,"expr","expr",745722291))){
cljs.compiler.emitln.call(null,"(function(){");
} else {
}

var gs = cljs.core.gensym.call(null,"caseval__");
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"var ",gs,";");
} else {
}

cljs.compiler.emitln.call(null,"switch (",v,") {");

var seq__119708_119744 = cljs.core.seq.call(null,nodes);
var chunk__119709_119745 = null;
var count__119710_119746 = (0);
var i__119711_119747 = (0);
while(true){
if((i__119711_119747 < count__119710_119746)){
var map__119728_119748 = cljs.core._nth.call(null,chunk__119709_119745,i__119711_119747);
var map__119728_119749__$1 = (((((!((map__119728_119748 == null))))?(((((map__119728_119748.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__119728_119748.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__119728_119748):map__119728_119748);
var ts_119750 = cljs.core.get.call(null,map__119728_119749__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__119729_119751 = cljs.core.get.call(null,map__119728_119749__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__119729_119752__$1 = (((((!((map__119729_119751 == null))))?(((((map__119729_119751.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__119729_119751.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__119729_119751):map__119729_119751);
var then_119753 = cljs.core.get.call(null,map__119729_119752__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__119732_119754 = cljs.core.seq.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"test","test",577538877),ts_119750));
var chunk__119733_119755 = null;
var count__119734_119756 = (0);
var i__119735_119757 = (0);
while(true){
if((i__119735_119757 < count__119734_119756)){
var test_119758 = cljs.core._nth.call(null,chunk__119733_119755,i__119735_119757);
cljs.compiler.emitln.call(null,"case ",test_119758,":");


var G__119759 = seq__119732_119754;
var G__119760 = chunk__119733_119755;
var G__119761 = count__119734_119756;
var G__119762 = (i__119735_119757 + (1));
seq__119732_119754 = G__119759;
chunk__119733_119755 = G__119760;
count__119734_119756 = G__119761;
i__119735_119757 = G__119762;
continue;
} else {
var temp__5735__auto___119763 = cljs.core.seq.call(null,seq__119732_119754);
if(temp__5735__auto___119763){
var seq__119732_119764__$1 = temp__5735__auto___119763;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__119732_119764__$1)){
var c__4556__auto___119765 = cljs.core.chunk_first.call(null,seq__119732_119764__$1);
var G__119766 = cljs.core.chunk_rest.call(null,seq__119732_119764__$1);
var G__119767 = c__4556__auto___119765;
var G__119768 = cljs.core.count.call(null,c__4556__auto___119765);
var G__119769 = (0);
seq__119732_119754 = G__119766;
chunk__119733_119755 = G__119767;
count__119734_119756 = G__119768;
i__119735_119757 = G__119769;
continue;
} else {
var test_119770 = cljs.core.first.call(null,seq__119732_119764__$1);
cljs.compiler.emitln.call(null,"case ",test_119770,":");


var G__119771 = cljs.core.next.call(null,seq__119732_119764__$1);
var G__119772 = null;
var G__119773 = (0);
var G__119774 = (0);
seq__119732_119754 = G__119771;
chunk__119733_119755 = G__119772;
count__119734_119756 = G__119773;
i__119735_119757 = G__119774;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,gs,"=",then_119753);
} else {
cljs.compiler.emitln.call(null,then_119753);
}

cljs.compiler.emitln.call(null,"break;");


var G__119775 = seq__119708_119744;
var G__119776 = chunk__119709_119745;
var G__119777 = count__119710_119746;
var G__119778 = (i__119711_119747 + (1));
seq__119708_119744 = G__119775;
chunk__119709_119745 = G__119776;
count__119710_119746 = G__119777;
i__119711_119747 = G__119778;
continue;
} else {
var temp__5735__auto___119779 = cljs.core.seq.call(null,seq__119708_119744);
if(temp__5735__auto___119779){
var seq__119708_119780__$1 = temp__5735__auto___119779;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__119708_119780__$1)){
var c__4556__auto___119781 = cljs.core.chunk_first.call(null,seq__119708_119780__$1);
var G__119782 = cljs.core.chunk_rest.call(null,seq__119708_119780__$1);
var G__119783 = c__4556__auto___119781;
var G__119784 = cljs.core.count.call(null,c__4556__auto___119781);
var G__119785 = (0);
seq__119708_119744 = G__119782;
chunk__119709_119745 = G__119783;
count__119710_119746 = G__119784;
i__119711_119747 = G__119785;
continue;
} else {
var map__119736_119786 = cljs.core.first.call(null,seq__119708_119780__$1);
var map__119736_119787__$1 = (((((!((map__119736_119786 == null))))?(((((map__119736_119786.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__119736_119786.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__119736_119786):map__119736_119786);
var ts_119788 = cljs.core.get.call(null,map__119736_119787__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__119737_119789 = cljs.core.get.call(null,map__119736_119787__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__119737_119790__$1 = (((((!((map__119737_119789 == null))))?(((((map__119737_119789.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__119737_119789.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__119737_119789):map__119737_119789);
var then_119791 = cljs.core.get.call(null,map__119737_119790__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__119740_119792 = cljs.core.seq.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"test","test",577538877),ts_119788));
var chunk__119741_119793 = null;
var count__119742_119794 = (0);
var i__119743_119795 = (0);
while(true){
if((i__119743_119795 < count__119742_119794)){
var test_119796 = cljs.core._nth.call(null,chunk__119741_119793,i__119743_119795);
cljs.compiler.emitln.call(null,"case ",test_119796,":");


var G__119797 = seq__119740_119792;
var G__119798 = chunk__119741_119793;
var G__119799 = count__119742_119794;
var G__119800 = (i__119743_119795 + (1));
seq__119740_119792 = G__119797;
chunk__119741_119793 = G__119798;
count__119742_119794 = G__119799;
i__119743_119795 = G__119800;
continue;
} else {
var temp__5735__auto___119801__$1 = cljs.core.seq.call(null,seq__119740_119792);
if(temp__5735__auto___119801__$1){
var seq__119740_119802__$1 = temp__5735__auto___119801__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__119740_119802__$1)){
var c__4556__auto___119803 = cljs.core.chunk_first.call(null,seq__119740_119802__$1);
var G__119804 = cljs.core.chunk_rest.call(null,seq__119740_119802__$1);
var G__119805 = c__4556__auto___119803;
var G__119806 = cljs.core.count.call(null,c__4556__auto___119803);
var G__119807 = (0);
seq__119740_119792 = G__119804;
chunk__119741_119793 = G__119805;
count__119742_119794 = G__119806;
i__119743_119795 = G__119807;
continue;
} else {
var test_119808 = cljs.core.first.call(null,seq__119740_119802__$1);
cljs.compiler.emitln.call(null,"case ",test_119808,":");


var G__119809 = cljs.core.next.call(null,seq__119740_119802__$1);
var G__119810 = null;
var G__119811 = (0);
var G__119812 = (0);
seq__119740_119792 = G__119809;
chunk__119741_119793 = G__119810;
count__119742_119794 = G__119811;
i__119743_119795 = G__119812;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,gs,"=",then_119791);
} else {
cljs.compiler.emitln.call(null,then_119791);
}

cljs.compiler.emitln.call(null,"break;");


var G__119813 = cljs.core.next.call(null,seq__119708_119780__$1);
var G__119814 = null;
var G__119815 = (0);
var G__119816 = (0);
seq__119708_119744 = G__119813;
chunk__119709_119745 = G__119814;
count__119710_119746 = G__119815;
i__119711_119747 = G__119816;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(default$)){
cljs.compiler.emitln.call(null,"default:");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,gs,"=",default$);
} else {
cljs.compiler.emitln.call(null,default$);
}
} else {
}

cljs.compiler.emitln.call(null,"}");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.call(null,"return ",gs,";})()");
} else {
return null;
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"throw","throw",-1044625833),(function (p__119817){
var map__119818 = p__119817;
var map__119818__$1 = (((((!((map__119818 == null))))?(((((map__119818.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__119818.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__119818):map__119818);
var throw$ = cljs.core.get.call(null,map__119818__$1,new cljs.core.Keyword(null,"exception","exception",-335277064));
var env = cljs.core.get.call(null,map__119818__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emits.call(null,"(function(){throw ",throw$,"})()");
} else {
return cljs.compiler.emitln.call(null,"throw ",throw$,";");
}
}));
cljs.compiler.base_types = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, ["boolean",null,"object",null,"*",null,"string",null,"Object",null,"Number",null,"null",null,"Date",null,"number",null,"String",null,"RegExp",null,"...*",null,"Array",null,"array",null,"Boolean",null], null), null);
cljs.compiler.mapped_types = new cljs.core.PersistentArrayMap(null, 1, ["nil","null"], null);
cljs.compiler.resolve_type = (function cljs$compiler$resolve_type(env,t){
if(cljs.core.truth_(cljs.core.get.call(null,cljs.compiler.base_types,t))){
return t;
} else {
if(cljs.core.truth_(cljs.core.get.call(null,cljs.compiler.mapped_types,t))){
return cljs.core.get.call(null,cljs.compiler.mapped_types,t);
} else {
if(goog.string.startsWith(t,"!")){
return ["!",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.resolve_type.call(null,env,cljs.core.subs.call(null,t,(1))))].join('');
} else {
if(goog.string.startsWith(t,"{")){
return t;
} else {
if(goog.string.startsWith(t,"function")){
var idx = t.lastIndexOf(":");
var vec__119821 = (((!(((-1) === idx))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.subs.call(null,t,(0),idx),cljs.core.subs.call(null,t,(idx + (1)),cljs.core.count.call(null,t))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [t,null], null));
var fstr = cljs.core.nth.call(null,vec__119821,(0),null);
var rstr = cljs.core.nth.call(null,vec__119821,(1),null);
var ret_t = (cljs.core.truth_(rstr)?cljs.compiler.resolve_type.call(null,env,rstr):null);
var axstr = cljs.core.subs.call(null,fstr,(9),(cljs.core.count.call(null,fstr) - (1)));
var args_ts = ((clojure.string.blank_QMARK_.call(null,axstr))?null:cljs.core.map.call(null,cljs.core.comp.call(null,(function (p1__119820_SHARP_){
return cljs.compiler.resolve_type.call(null,env,p1__119820_SHARP_);
}),clojure.string.trim),clojure.string.split.call(null,axstr,/,/)));
var G__119824 = ["function(",clojure.string.join.call(null,",",args_ts),")"].join('');
if(cljs.core.truth_(ret_t)){
return [G__119824,":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ret_t)].join('');
} else {
return G__119824;
}
} else {
if(goog.string.endsWith(t,"=")){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.resolve_type.call(null,env,cljs.core.subs.call(null,t,(0),(cljs.core.count.call(null,t) - (1))))),"="].join('');
} else {
return cljs.compiler.munge.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.call(null,env,cljs.core.symbol.call(null,t)))));

}
}
}
}
}
}
});
cljs.compiler.resolve_types = (function cljs$compiler$resolve_types(env,ts){
var ts__$1 = cljs.core.subs.call(null,clojure.string.trim.call(null,ts),(1),(cljs.core.count.call(null,ts) - (1)));
var xs = clojure.string.split.call(null,ts__$1,/\|/);
return ["{",clojure.string.join.call(null,"|",cljs.core.map.call(null,(function (p1__119825_SHARP_){
return cljs.compiler.resolve_type.call(null,env,p1__119825_SHARP_);
}),xs)),"}"].join('');
});
cljs.compiler.munge_param_return = (function cljs$compiler$munge_param_return(env,line){
if(cljs.core.truth_(cljs.core.re_find.call(null,/@param/,line))){
var vec__119826 = cljs.core.map.call(null,clojure.string.trim,clojure.string.split.call(null,clojure.string.trim.call(null,line),/ /));
var seq__119827 = cljs.core.seq.call(null,vec__119826);
var first__119828 = cljs.core.first.call(null,seq__119827);
var seq__119827__$1 = cljs.core.next.call(null,seq__119827);
var p = first__119828;
var first__119828__$1 = cljs.core.first.call(null,seq__119827__$1);
var seq__119827__$2 = cljs.core.next.call(null,seq__119827__$1);
var ts = first__119828__$1;
var first__119828__$2 = cljs.core.first.call(null,seq__119827__$2);
var seq__119827__$3 = cljs.core.next.call(null,seq__119827__$2);
var n = first__119828__$2;
var xs = seq__119827__$3;
if(cljs.core.truth_(((cljs.core._EQ_.call(null,"@param",p))?(function (){var and__4115__auto__ = ts;
if(cljs.core.truth_(and__4115__auto__)){
return goog.string.startsWith(ts,"{");
} else {
return and__4115__auto__;
}
})():false))){
return clojure.string.join.call(null," ",cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types.call(null,env,ts),cljs.compiler.munge.call(null,n)], null),xs));
} else {
return line;
}
} else {
if(cljs.core.truth_(cljs.core.re_find.call(null,/@return/,line))){
var vec__119829 = cljs.core.map.call(null,clojure.string.trim,clojure.string.split.call(null,clojure.string.trim.call(null,line),/ /));
var seq__119830 = cljs.core.seq.call(null,vec__119829);
var first__119831 = cljs.core.first.call(null,seq__119830);
var seq__119830__$1 = cljs.core.next.call(null,seq__119830);
var p = first__119831;
var first__119831__$1 = cljs.core.first.call(null,seq__119830__$1);
var seq__119830__$2 = cljs.core.next.call(null,seq__119830__$1);
var ts = first__119831__$1;
var xs = seq__119830__$2;
if(cljs.core.truth_(((cljs.core._EQ_.call(null,"@return",p))?(function (){var and__4115__auto__ = ts;
if(cljs.core.truth_(and__4115__auto__)){
return goog.string.startsWith(ts,"{");
} else {
return and__4115__auto__;
}
})():false))){
return clojure.string.join.call(null," ",cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types.call(null,env,ts)], null),xs));
} else {
return line;
}
} else {
return line;

}
}
});
cljs.compiler.checking_types_QMARK_ = (function cljs$compiler$checking_types_QMARK_(){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"warning","warning",-1685650671),null,new cljs.core.Keyword(null,"error","error",-978969032),null], null), null).call(null,cljs.core.get_in.call(null,cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Keyword(null,"closure-warnings","closure-warnings",1362834211),new cljs.core.Keyword(null,"check-types","check-types",-833794607)], null)));
});
/**
 * Emit a nicely formatted comment string.
 */
cljs.compiler.emit_comment = (function cljs$compiler$emit_comment(var_args){
var G__119834 = arguments.length;
switch (G__119834) {
case 2:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2 = (function (doc,jsdoc){
return cljs.compiler.emit_comment.call(null,null,doc,jsdoc);
}));

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3 = (function (env,doc,jsdoc){
var docs = (cljs.core.truth_(doc)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [doc], null):null);
var docs__$1 = (cljs.core.truth_(jsdoc)?cljs.core.concat.call(null,docs,jsdoc):docs);
var docs__$2 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,docs__$1);
var print_comment_lines = (function cljs$compiler$print_comment_lines(e){
var vec__119842 = cljs.core.map.call(null,(function (p1__119832_SHARP_){
if(cljs.core.truth_(cljs.compiler.checking_types_QMARK_.call(null))){
return cljs.compiler.munge_param_return.call(null,env,p1__119832_SHARP_);
} else {
return p1__119832_SHARP_;
}
}),clojure.string.split_lines.call(null,e));
var seq__119843 = cljs.core.seq.call(null,vec__119842);
var first__119844 = cljs.core.first.call(null,seq__119843);
var seq__119843__$1 = cljs.core.next.call(null,seq__119843);
var x = first__119844;
var ys = seq__119843__$1;
cljs.compiler.emitln.call(null," * ",clojure.string.replace.call(null,x,"*/","* /"));

var seq__119845 = cljs.core.seq.call(null,ys);
var chunk__119846 = null;
var count__119847 = (0);
var i__119848 = (0);
while(true){
if((i__119848 < count__119847)){
var next_line = cljs.core._nth.call(null,chunk__119846,i__119848);
cljs.compiler.emitln.call(null," * ",clojure.string.replace.call(null,clojure.string.replace.call(null,next_line,/^   /,""),"*/","* /"));


var G__119854 = seq__119845;
var G__119855 = chunk__119846;
var G__119856 = count__119847;
var G__119857 = (i__119848 + (1));
seq__119845 = G__119854;
chunk__119846 = G__119855;
count__119847 = G__119856;
i__119848 = G__119857;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__119845);
if(temp__5735__auto__){
var seq__119845__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__119845__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__119845__$1);
var G__119858 = cljs.core.chunk_rest.call(null,seq__119845__$1);
var G__119859 = c__4556__auto__;
var G__119860 = cljs.core.count.call(null,c__4556__auto__);
var G__119861 = (0);
seq__119845 = G__119858;
chunk__119846 = G__119859;
count__119847 = G__119860;
i__119848 = G__119861;
continue;
} else {
var next_line = cljs.core.first.call(null,seq__119845__$1);
cljs.compiler.emitln.call(null," * ",clojure.string.replace.call(null,clojure.string.replace.call(null,next_line,/^   /,""),"*/","* /"));


var G__119862 = cljs.core.next.call(null,seq__119845__$1);
var G__119863 = null;
var G__119864 = (0);
var G__119865 = (0);
seq__119845 = G__119862;
chunk__119846 = G__119863;
count__119847 = G__119864;
i__119848 = G__119865;
continue;
}
} else {
return null;
}
}
break;
}
});
if(cljs.core.seq.call(null,docs__$2)){
cljs.compiler.emitln.call(null,"/**");

var seq__119849_119866 = cljs.core.seq.call(null,docs__$2);
var chunk__119850_119867 = null;
var count__119851_119868 = (0);
var i__119852_119869 = (0);
while(true){
if((i__119852_119869 < count__119851_119868)){
var e_119870 = cljs.core._nth.call(null,chunk__119850_119867,i__119852_119869);
if(cljs.core.truth_(e_119870)){
print_comment_lines.call(null,e_119870);
} else {
}


var G__119871 = seq__119849_119866;
var G__119872 = chunk__119850_119867;
var G__119873 = count__119851_119868;
var G__119874 = (i__119852_119869 + (1));
seq__119849_119866 = G__119871;
chunk__119850_119867 = G__119872;
count__119851_119868 = G__119873;
i__119852_119869 = G__119874;
continue;
} else {
var temp__5735__auto___119875 = cljs.core.seq.call(null,seq__119849_119866);
if(temp__5735__auto___119875){
var seq__119849_119876__$1 = temp__5735__auto___119875;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__119849_119876__$1)){
var c__4556__auto___119877 = cljs.core.chunk_first.call(null,seq__119849_119876__$1);
var G__119878 = cljs.core.chunk_rest.call(null,seq__119849_119876__$1);
var G__119879 = c__4556__auto___119877;
var G__119880 = cljs.core.count.call(null,c__4556__auto___119877);
var G__119881 = (0);
seq__119849_119866 = G__119878;
chunk__119850_119867 = G__119879;
count__119851_119868 = G__119880;
i__119852_119869 = G__119881;
continue;
} else {
var e_119882 = cljs.core.first.call(null,seq__119849_119876__$1);
if(cljs.core.truth_(e_119882)){
print_comment_lines.call(null,e_119882);
} else {
}


var G__119883 = cljs.core.next.call(null,seq__119849_119876__$1);
var G__119884 = null;
var G__119885 = (0);
var G__119886 = (0);
seq__119849_119866 = G__119883;
chunk__119850_119867 = G__119884;
count__119851_119868 = G__119885;
i__119852_119869 = G__119886;
continue;
}
} else {
}
}
break;
}

return cljs.compiler.emitln.call(null," */");
} else {
return null;
}
}));

(cljs.compiler.emit_comment.cljs$lang$maxFixedArity = 3);

cljs.compiler.valid_define_value_QMARK_ = (function cljs$compiler$valid_define_value_QMARK_(x){
return ((typeof x === 'string') || (x === true) || (x === false) || (typeof x === 'number'));
});
cljs.compiler.get_define = (function cljs$compiler$get_define(mname,jsdoc){
var opts = cljs.core.get.call(null,cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_),new cljs.core.Keyword(null,"options","options",99638489));
var and__4115__auto__ = cljs.core.some.call(null,(function (p1__119888_SHARP_){
return goog.string.startsWith(p1__119888_SHARP_,"@define");
}),jsdoc);
if(cljs.core.truth_(and__4115__auto__)){
var and__4115__auto____$1 = opts;
if(cljs.core.truth_(and__4115__auto____$1)){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"none","none",1333468478))){
var define = cljs.core.get_in.call(null,opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"closure-defines","closure-defines",-1213856476),cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname)], null));
if(cljs.compiler.valid_define_value_QMARK_.call(null,define)){
return cljs.core.pr_str.call(null,define);
} else {
return null;
}
} else {
return false;
}
} else {
return and__4115__auto____$1;
}
} else {
return and__4115__auto__;
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"def","def",-1043430536),(function (p__119889){
var map__119890 = p__119889;
var map__119890__$1 = (((((!((map__119890 == null))))?(((((map__119890.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__119890.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__119890):map__119890);
var doc = cljs.core.get.call(null,map__119890__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var jsdoc = cljs.core.get.call(null,map__119890__$1,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516));
var test = cljs.core.get.call(null,map__119890__$1,new cljs.core.Keyword(null,"test","test",577538877));
var goog_define = cljs.core.get.call(null,map__119890__$1,new cljs.core.Keyword(null,"goog-define","goog-define",-1048305441));
var init = cljs.core.get.call(null,map__119890__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
var name = cljs.core.get.call(null,map__119890__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.call(null,map__119890__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var export$ = cljs.core.get.call(null,map__119890__$1,new cljs.core.Keyword(null,"export","export",214356590));
var var$ = cljs.core.get.call(null,map__119890__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var var_ast = cljs.core.get.call(null,map__119890__$1,new cljs.core.Keyword(null,"var-ast","var-ast",1200379319));
if(cljs.core.truth_((function (){var or__4126__auto__ = init;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env);
}
})())){
var mname = cljs.compiler.munge.call(null,name);
cljs.compiler.emit_comment.call(null,env,doc,cljs.core.concat.call(null,(cljs.core.truth_(goog_define)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["@define {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog_define),"}"].join('')], null):null),jsdoc,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516).cljs$core$IFn$_invoke$arity$1(init)));

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"return (");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"(function (){");
} else {
}

cljs.compiler.emits.call(null,var$);

if(cljs.core.truth_(init)){
cljs.compiler.emits.call(null," = ",(function (){var temp__5733__auto__ = cljs.compiler.get_define.call(null,mname,jsdoc);
if(cljs.core.truth_(temp__5733__auto__)){
var define = temp__5733__auto__;
return define;
} else {
return init;
}
})());
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"; return (");

cljs.compiler.emits.call(null,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"the-var","the-var",1428415613),new cljs.core.Keyword(null,"env","env",-1815813235),cljs.core.assoc.call(null,env,new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Keyword(null,"expr","expr",745722291))], null),var_ast));

cljs.compiler.emitln.call(null,");})()");
} else {
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,")");
} else {
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emitln.call(null,";");
}

if(cljs.core.truth_(export$)){
cljs.compiler.emitln.call(null,"goog.exportSymbol('",cljs.compiler.munge.call(null,export$),"', ",mname,");");
} else {
}

if(cljs.core.truth_((function (){var and__4115__auto__ = cljs.analyzer._STAR_load_tests_STAR_;
if(cljs.core.truth_(and__4115__auto__)){
return test;
} else {
return and__4115__auto__;
}
})())){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,";");
} else {
}

return cljs.compiler.emitln.call(null,var$,".cljs$lang$test = ",test,";");
} else {
return null;
}
} else {
return null;
}
}));
cljs.compiler.emit_apply_to = (function cljs$compiler$emit_apply_to(p__119892){
var map__119893 = p__119892;
var map__119893__$1 = (((((!((map__119893 == null))))?(((((map__119893.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__119893.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__119893):map__119893);
var name = cljs.core.get.call(null,map__119893__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.call(null,map__119893__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.call(null,map__119893__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var arglist = cljs.core.gensym.call(null,"arglist__");
var delegate_name = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,name)),"__delegate"].join('');
cljs.compiler.emitln.call(null,"(function (",arglist,"){");

var seq__119895_119919 = cljs.core.seq.call(null,cljs.core.map_indexed.call(null,cljs.core.vector,cljs.core.drop_last.call(null,(2),params)));
var chunk__119896_119920 = null;
var count__119897_119921 = (0);
var i__119898_119922 = (0);
while(true){
if((i__119898_119922 < count__119897_119921)){
var vec__119905_119923 = cljs.core._nth.call(null,chunk__119896_119920,i__119898_119922);
var i_119924 = cljs.core.nth.call(null,vec__119905_119923,(0),null);
var param_119925 = cljs.core.nth.call(null,vec__119905_119923,(1),null);
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,param_119925);

cljs.compiler.emits.call(null," = cljs.core.first(");

cljs.compiler.emitln.call(null,arglist,");");

cljs.compiler.emitln.call(null,arglist," = cljs.core.next(",arglist,");");


var G__119926 = seq__119895_119919;
var G__119927 = chunk__119896_119920;
var G__119928 = count__119897_119921;
var G__119929 = (i__119898_119922 + (1));
seq__119895_119919 = G__119926;
chunk__119896_119920 = G__119927;
count__119897_119921 = G__119928;
i__119898_119922 = G__119929;
continue;
} else {
var temp__5735__auto___119930 = cljs.core.seq.call(null,seq__119895_119919);
if(temp__5735__auto___119930){
var seq__119895_119931__$1 = temp__5735__auto___119930;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__119895_119931__$1)){
var c__4556__auto___119932 = cljs.core.chunk_first.call(null,seq__119895_119931__$1);
var G__119933 = cljs.core.chunk_rest.call(null,seq__119895_119931__$1);
var G__119934 = c__4556__auto___119932;
var G__119935 = cljs.core.count.call(null,c__4556__auto___119932);
var G__119936 = (0);
seq__119895_119919 = G__119933;
chunk__119896_119920 = G__119934;
count__119897_119921 = G__119935;
i__119898_119922 = G__119936;
continue;
} else {
var vec__119908_119937 = cljs.core.first.call(null,seq__119895_119931__$1);
var i_119938 = cljs.core.nth.call(null,vec__119908_119937,(0),null);
var param_119939 = cljs.core.nth.call(null,vec__119908_119937,(1),null);
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,param_119939);

cljs.compiler.emits.call(null," = cljs.core.first(");

cljs.compiler.emitln.call(null,arglist,");");

cljs.compiler.emitln.call(null,arglist," = cljs.core.next(",arglist,");");


var G__119940 = cljs.core.next.call(null,seq__119895_119931__$1);
var G__119941 = null;
var G__119942 = (0);
var G__119943 = (0);
seq__119895_119919 = G__119940;
chunk__119896_119920 = G__119941;
count__119897_119921 = G__119942;
i__119898_119922 = G__119943;
continue;
}
} else {
}
}
break;
}

if(((1) < cljs.core.count.call(null,params))){
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,cljs.core.butlast.call(null,params)));

cljs.compiler.emitln.call(null," = cljs.core.first(",arglist,");");

cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,params));

cljs.compiler.emitln.call(null," = cljs.core.rest(",arglist,");");

cljs.compiler.emits.call(null,"return ",delegate_name,"(");

var seq__119911_119944 = cljs.core.seq.call(null,params);
var chunk__119912_119945 = null;
var count__119913_119946 = (0);
var i__119914_119947 = (0);
while(true){
if((i__119914_119947 < count__119913_119946)){
var param_119948 = cljs.core._nth.call(null,chunk__119912_119945,i__119914_119947);
cljs.compiler.emit.call(null,param_119948);

if(cljs.core._EQ_.call(null,param_119948,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__119949 = seq__119911_119944;
var G__119950 = chunk__119912_119945;
var G__119951 = count__119913_119946;
var G__119952 = (i__119914_119947 + (1));
seq__119911_119944 = G__119949;
chunk__119912_119945 = G__119950;
count__119913_119946 = G__119951;
i__119914_119947 = G__119952;
continue;
} else {
var temp__5735__auto___119953 = cljs.core.seq.call(null,seq__119911_119944);
if(temp__5735__auto___119953){
var seq__119911_119954__$1 = temp__5735__auto___119953;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__119911_119954__$1)){
var c__4556__auto___119955 = cljs.core.chunk_first.call(null,seq__119911_119954__$1);
var G__119956 = cljs.core.chunk_rest.call(null,seq__119911_119954__$1);
var G__119957 = c__4556__auto___119955;
var G__119958 = cljs.core.count.call(null,c__4556__auto___119955);
var G__119959 = (0);
seq__119911_119944 = G__119956;
chunk__119912_119945 = G__119957;
count__119913_119946 = G__119958;
i__119914_119947 = G__119959;
continue;
} else {
var param_119960 = cljs.core.first.call(null,seq__119911_119954__$1);
cljs.compiler.emit.call(null,param_119960);

if(cljs.core._EQ_.call(null,param_119960,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__119961 = cljs.core.next.call(null,seq__119911_119954__$1);
var G__119962 = null;
var G__119963 = (0);
var G__119964 = (0);
seq__119911_119944 = G__119961;
chunk__119912_119945 = G__119962;
count__119913_119946 = G__119963;
i__119914_119947 = G__119964;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,");");
} else {
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,params));

cljs.compiler.emitln.call(null," = cljs.core.seq(",arglist,");");

cljs.compiler.emits.call(null,"return ",delegate_name,"(");

var seq__119915_119965 = cljs.core.seq.call(null,params);
var chunk__119916_119966 = null;
var count__119917_119967 = (0);
var i__119918_119968 = (0);
while(true){
if((i__119918_119968 < count__119917_119967)){
var param_119969 = cljs.core._nth.call(null,chunk__119916_119966,i__119918_119968);
cljs.compiler.emit.call(null,param_119969);

if(cljs.core._EQ_.call(null,param_119969,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__119970 = seq__119915_119965;
var G__119971 = chunk__119916_119966;
var G__119972 = count__119917_119967;
var G__119973 = (i__119918_119968 + (1));
seq__119915_119965 = G__119970;
chunk__119916_119966 = G__119971;
count__119917_119967 = G__119972;
i__119918_119968 = G__119973;
continue;
} else {
var temp__5735__auto___119974 = cljs.core.seq.call(null,seq__119915_119965);
if(temp__5735__auto___119974){
var seq__119915_119975__$1 = temp__5735__auto___119974;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__119915_119975__$1)){
var c__4556__auto___119976 = cljs.core.chunk_first.call(null,seq__119915_119975__$1);
var G__119977 = cljs.core.chunk_rest.call(null,seq__119915_119975__$1);
var G__119978 = c__4556__auto___119976;
var G__119979 = cljs.core.count.call(null,c__4556__auto___119976);
var G__119980 = (0);
seq__119915_119965 = G__119977;
chunk__119916_119966 = G__119978;
count__119917_119967 = G__119979;
i__119918_119968 = G__119980;
continue;
} else {
var param_119981 = cljs.core.first.call(null,seq__119915_119975__$1);
cljs.compiler.emit.call(null,param_119981);

if(cljs.core._EQ_.call(null,param_119981,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__119982 = cljs.core.next.call(null,seq__119915_119975__$1);
var G__119983 = null;
var G__119984 = (0);
var G__119985 = (0);
seq__119915_119965 = G__119982;
chunk__119916_119966 = G__119983;
count__119917_119967 = G__119984;
i__119918_119968 = G__119985;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,");");
}

return cljs.compiler.emits.call(null,"})");
});
cljs.compiler.emit_fn_params = (function cljs$compiler$emit_fn_params(params){
var seq__119986 = cljs.core.seq.call(null,params);
var chunk__119987 = null;
var count__119988 = (0);
var i__119989 = (0);
while(true){
if((i__119989 < count__119988)){
var param = cljs.core._nth.call(null,chunk__119987,i__119989);
cljs.compiler.emit.call(null,param);

if(cljs.core._EQ_.call(null,param,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__119990 = seq__119986;
var G__119991 = chunk__119987;
var G__119992 = count__119988;
var G__119993 = (i__119989 + (1));
seq__119986 = G__119990;
chunk__119987 = G__119991;
count__119988 = G__119992;
i__119989 = G__119993;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__119986);
if(temp__5735__auto__){
var seq__119986__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__119986__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__119986__$1);
var G__119994 = cljs.core.chunk_rest.call(null,seq__119986__$1);
var G__119995 = c__4556__auto__;
var G__119996 = cljs.core.count.call(null,c__4556__auto__);
var G__119997 = (0);
seq__119986 = G__119994;
chunk__119987 = G__119995;
count__119988 = G__119996;
i__119989 = G__119997;
continue;
} else {
var param = cljs.core.first.call(null,seq__119986__$1);
cljs.compiler.emit.call(null,param);

if(cljs.core._EQ_.call(null,param,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__119998 = cljs.core.next.call(null,seq__119986__$1);
var G__119999 = null;
var G__120000 = (0);
var G__120001 = (0);
seq__119986 = G__119998;
chunk__119987 = G__119999;
count__119988 = G__120000;
i__119989 = G__120001;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_fn_method = (function cljs$compiler$emit_fn_method(p__120002){
var map__120003 = p__120002;
var map__120003__$1 = (((((!((map__120003 == null))))?(((((map__120003.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__120003.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__120003):map__120003);
var expr = cljs.core.get.call(null,map__120003__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var type = cljs.core.get.call(null,map__120003__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.call(null,map__120003__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.call(null,map__120003__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.call(null,map__120003__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.call(null,map__120003__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__119443__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__119443__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"(function ",cljs.compiler.munge.call(null,name),"(");

cljs.compiler.emit_fn_params.call(null,params);

cljs.compiler.emitln.call(null,"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.call(null,"var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"while(true){");
} else {
}

cljs.compiler.emits.call(null,expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"break;");

cljs.compiler.emitln.call(null,"}");
} else {
}

cljs.compiler.emits.call(null,"})");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__119443__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
});
/**
 * Emit code that copies function arguments into an array starting at an index.
 *   Returns name of var holding the array.
 */
cljs.compiler.emit_arguments_to_array = (function cljs$compiler$emit_arguments_to_array(startslice){
if((((startslice >= (0))) && (cljs.core.integer_QMARK_.call(null,startslice)))){
} else {
throw (new Error("Assert failed: (and (>= startslice 0) (integer? startslice))"));
}

var mname = cljs.compiler.munge.call(null,cljs.core.gensym.call(null));
var i = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__i"].join('');
var a = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__a"].join('');
cljs.compiler.emitln.call(null,"var ",i," = 0, ",a," = new Array(arguments.length -  ",startslice,");");

cljs.compiler.emitln.call(null,"while (",i," < ",a,".length) {",a,"[",i,"] = arguments[",i," + ",startslice,"]; ++",i,";}");

return a;
});
cljs.compiler.emit_variadic_fn_method = (function cljs$compiler$emit_variadic_fn_method(p__120005){
var map__120006 = p__120005;
var map__120006__$1 = (((((!((map__120006 == null))))?(((((map__120006.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__120006.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__120006):map__120006);
var f = map__120006__$1;
var expr = cljs.core.get.call(null,map__120006__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var max_fixed_arity = cljs.core.get.call(null,map__120006__$1,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869));
var variadic = cljs.core.get.call(null,map__120006__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var type = cljs.core.get.call(null,map__120006__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.call(null,map__120006__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.call(null,map__120006__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.call(null,map__120006__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.call(null,map__120006__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__119443__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__119443__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

var name_120016__$1 = (function (){var or__4126__auto__ = name;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.gensym.call(null);
}
})();
var mname_120017 = cljs.compiler.munge.call(null,name_120016__$1);
var delegate_name_120018 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_120017),"__delegate"].join('');
cljs.compiler.emitln.call(null,"(function() { ");

cljs.compiler.emits.call(null,"var ",delegate_name_120018," = function (");

var seq__120008_120019 = cljs.core.seq.call(null,params);
var chunk__120009_120020 = null;
var count__120010_120021 = (0);
var i__120011_120022 = (0);
while(true){
if((i__120011_120022 < count__120010_120021)){
var param_120023 = cljs.core._nth.call(null,chunk__120009_120020,i__120011_120022);
cljs.compiler.emit.call(null,param_120023);

if(cljs.core._EQ_.call(null,param_120023,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__120024 = seq__120008_120019;
var G__120025 = chunk__120009_120020;
var G__120026 = count__120010_120021;
var G__120027 = (i__120011_120022 + (1));
seq__120008_120019 = G__120024;
chunk__120009_120020 = G__120025;
count__120010_120021 = G__120026;
i__120011_120022 = G__120027;
continue;
} else {
var temp__5735__auto___120028 = cljs.core.seq.call(null,seq__120008_120019);
if(temp__5735__auto___120028){
var seq__120008_120029__$1 = temp__5735__auto___120028;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__120008_120029__$1)){
var c__4556__auto___120030 = cljs.core.chunk_first.call(null,seq__120008_120029__$1);
var G__120031 = cljs.core.chunk_rest.call(null,seq__120008_120029__$1);
var G__120032 = c__4556__auto___120030;
var G__120033 = cljs.core.count.call(null,c__4556__auto___120030);
var G__120034 = (0);
seq__120008_120019 = G__120031;
chunk__120009_120020 = G__120032;
count__120010_120021 = G__120033;
i__120011_120022 = G__120034;
continue;
} else {
var param_120035 = cljs.core.first.call(null,seq__120008_120029__$1);
cljs.compiler.emit.call(null,param_120035);

if(cljs.core._EQ_.call(null,param_120035,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__120036 = cljs.core.next.call(null,seq__120008_120029__$1);
var G__120037 = null;
var G__120038 = (0);
var G__120039 = (0);
seq__120008_120019 = G__120036;
chunk__120009_120020 = G__120037;
count__120010_120021 = G__120038;
i__120011_120022 = G__120039;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.call(null,"var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"while(true){");
} else {
}

cljs.compiler.emits.call(null,expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"break;");

cljs.compiler.emitln.call(null,"}");
} else {
}

cljs.compiler.emitln.call(null,"};");

cljs.compiler.emitln.call(null,"var ",mname_120017," = function (",cljs.compiler.comma_sep.call(null,(cljs.core.truth_(variadic)?cljs.core.concat.call(null,cljs.core.butlast.call(null,params),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):params)),"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.call(null,"var self__ = this;");
} else {
}

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,params));

cljs.compiler.emitln.call(null," = null;");

cljs.compiler.emitln.call(null,"if (arguments.length > ",(cljs.core.count.call(null,params) - (1)),") {");

var a_120040 = cljs.compiler.emit_arguments_to_array.call(null,(cljs.core.count.call(null,params) - (1)));
cljs.compiler.emitln.call(null,"  ",cljs.core.last.call(null,params)," = new cljs.core.IndexedSeq(",a_120040,",0,null);");

cljs.compiler.emitln.call(null,"} ");
} else {
}

cljs.compiler.emits.call(null,"return ",delegate_name_120018,".call(this,");

var seq__120012_120041 = cljs.core.seq.call(null,params);
var chunk__120013_120042 = null;
var count__120014_120043 = (0);
var i__120015_120044 = (0);
while(true){
if((i__120015_120044 < count__120014_120043)){
var param_120045 = cljs.core._nth.call(null,chunk__120013_120042,i__120015_120044);
cljs.compiler.emit.call(null,param_120045);

if(cljs.core._EQ_.call(null,param_120045,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__120046 = seq__120012_120041;
var G__120047 = chunk__120013_120042;
var G__120048 = count__120014_120043;
var G__120049 = (i__120015_120044 + (1));
seq__120012_120041 = G__120046;
chunk__120013_120042 = G__120047;
count__120014_120043 = G__120048;
i__120015_120044 = G__120049;
continue;
} else {
var temp__5735__auto___120050 = cljs.core.seq.call(null,seq__120012_120041);
if(temp__5735__auto___120050){
var seq__120012_120051__$1 = temp__5735__auto___120050;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__120012_120051__$1)){
var c__4556__auto___120052 = cljs.core.chunk_first.call(null,seq__120012_120051__$1);
var G__120053 = cljs.core.chunk_rest.call(null,seq__120012_120051__$1);
var G__120054 = c__4556__auto___120052;
var G__120055 = cljs.core.count.call(null,c__4556__auto___120052);
var G__120056 = (0);
seq__120012_120041 = G__120053;
chunk__120013_120042 = G__120054;
count__120014_120043 = G__120055;
i__120015_120044 = G__120056;
continue;
} else {
var param_120057 = cljs.core.first.call(null,seq__120012_120051__$1);
cljs.compiler.emit.call(null,param_120057);

if(cljs.core._EQ_.call(null,param_120057,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__120058 = cljs.core.next.call(null,seq__120012_120051__$1);
var G__120059 = null;
var G__120060 = (0);
var G__120061 = (0);
seq__120012_120041 = G__120058;
chunk__120013_120042 = G__120059;
count__120014_120043 = G__120060;
i__120015_120044 = G__120061;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.call(null,");");

cljs.compiler.emitln.call(null,"};");

cljs.compiler.emitln.call(null,mname_120017,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emits.call(null,mname_120017,".cljs$lang$applyTo = ");

cljs.compiler.emit_apply_to.call(null,cljs.core.assoc.call(null,f,new cljs.core.Keyword(null,"name","name",1843675177),name_120016__$1));

cljs.compiler.emitln.call(null,";");

cljs.compiler.emitln.call(null,mname_120017,".cljs$core$IFn$_invoke$arity$variadic = ",delegate_name_120018,";");

cljs.compiler.emitln.call(null,"return ",mname_120017,";");

cljs.compiler.emitln.call(null,"})()");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__119443__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"fn","fn",-1175266204),(function (p__120065){
var map__120066 = p__120065;
var map__120066__$1 = (((((!((map__120066 == null))))?(((((map__120066.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__120066.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__120066):map__120066);
var variadic = cljs.core.get.call(null,map__120066__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var name = cljs.core.get.call(null,map__120066__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.call(null,map__120066__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var methods$ = cljs.core.get.call(null,map__120066__$1,new cljs.core.Keyword(null,"methods","methods",453930866));
var max_fixed_arity = cljs.core.get.call(null,map__120066__$1,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543));
var recur_frames = cljs.core.get.call(null,map__120066__$1,new cljs.core.Keyword(null,"recur-frames","recur-frames",-307205196));
var in_loop = cljs.core.get.call(null,map__120066__$1,new cljs.core.Keyword(null,"in-loop","in-loop",-187298246));
var loop_lets = cljs.core.get.call(null,map__120066__$1,new cljs.core.Keyword(null,"loop-lets","loop-lets",2036794185));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var recur_params = cljs.core.mapcat.call(null,new cljs.core.Keyword(null,"params","params",710516235),cljs.core.filter.call(null,(function (p1__120062_SHARP_){
var and__4115__auto__ = p1__120062_SHARP_;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.deref.call(null,new cljs.core.Keyword(null,"flag","flag",1088647881).cljs$core$IFn$_invoke$arity$1(p1__120062_SHARP_));
} else {
return and__4115__auto__;
}
}),recur_frames));
var loop_locals = cljs.core.seq.call(null,cljs.core.map.call(null,cljs.compiler.munge,cljs.core.concat.call(null,recur_params,(cljs.core.truth_((function (){var or__4126__auto__ = in_loop;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.seq.call(null,recur_params);
}
})())?cljs.core.mapcat.call(null,new cljs.core.Keyword(null,"params","params",710516235),loop_lets):null))));
if(loop_locals){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emitln.call(null,"((function (",cljs.compiler.comma_sep.call(null,cljs.core.map.call(null,cljs.compiler.munge,loop_locals)),"){");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emits.call(null,"return ");
}
} else {
}

if(cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,methods$))){
if(cljs.core.truth_(variadic)){
cljs.compiler.emit_variadic_fn_method.call(null,cljs.core.assoc.call(null,cljs.core.first.call(null,methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
} else {
cljs.compiler.emit_fn_method.call(null,cljs.core.assoc.call(null,cljs.core.first.call(null,methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
}
} else {
var name_120119__$1 = (function (){var or__4126__auto__ = name;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.gensym.call(null);
}
})();
var mname_120120 = cljs.compiler.munge.call(null,name_120119__$1);
var maxparams_120121 = cljs.core.apply.call(null,cljs.core.max_key,cljs.core.count,cljs.core.map.call(null,new cljs.core.Keyword(null,"params","params",710516235),methods$));
var mmap_120122 = cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,(function (method){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.compiler.munge.call(null,cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_120120),"__",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(method)))].join(''))),method], null);
}),methods$));
var ms_120123 = cljs.core.sort_by.call(null,(function (p1__120063_SHARP_){
return cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,p1__120063_SHARP_)));
}),cljs.core.seq.call(null,mmap_120122));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emitln.call(null,"(function() {");

cljs.compiler.emitln.call(null,"var ",mname_120120," = null;");

var seq__120068_120124 = cljs.core.seq.call(null,ms_120123);
var chunk__120069_120125 = null;
var count__120070_120126 = (0);
var i__120071_120127 = (0);
while(true){
if((i__120071_120127 < count__120070_120126)){
var vec__120078_120128 = cljs.core._nth.call(null,chunk__120069_120125,i__120071_120127);
var n_120129 = cljs.core.nth.call(null,vec__120078_120128,(0),null);
var meth_120130 = cljs.core.nth.call(null,vec__120078_120128,(1),null);
cljs.compiler.emits.call(null,"var ",n_120129," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_120130))){
cljs.compiler.emit_variadic_fn_method.call(null,meth_120130);
} else {
cljs.compiler.emit_fn_method.call(null,meth_120130);
}

cljs.compiler.emitln.call(null,";");


var G__120131 = seq__120068_120124;
var G__120132 = chunk__120069_120125;
var G__120133 = count__120070_120126;
var G__120134 = (i__120071_120127 + (1));
seq__120068_120124 = G__120131;
chunk__120069_120125 = G__120132;
count__120070_120126 = G__120133;
i__120071_120127 = G__120134;
continue;
} else {
var temp__5735__auto___120135 = cljs.core.seq.call(null,seq__120068_120124);
if(temp__5735__auto___120135){
var seq__120068_120136__$1 = temp__5735__auto___120135;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__120068_120136__$1)){
var c__4556__auto___120137 = cljs.core.chunk_first.call(null,seq__120068_120136__$1);
var G__120138 = cljs.core.chunk_rest.call(null,seq__120068_120136__$1);
var G__120139 = c__4556__auto___120137;
var G__120140 = cljs.core.count.call(null,c__4556__auto___120137);
var G__120141 = (0);
seq__120068_120124 = G__120138;
chunk__120069_120125 = G__120139;
count__120070_120126 = G__120140;
i__120071_120127 = G__120141;
continue;
} else {
var vec__120081_120142 = cljs.core.first.call(null,seq__120068_120136__$1);
var n_120143 = cljs.core.nth.call(null,vec__120081_120142,(0),null);
var meth_120144 = cljs.core.nth.call(null,vec__120081_120142,(1),null);
cljs.compiler.emits.call(null,"var ",n_120143," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_120144))){
cljs.compiler.emit_variadic_fn_method.call(null,meth_120144);
} else {
cljs.compiler.emit_fn_method.call(null,meth_120144);
}

cljs.compiler.emitln.call(null,";");


var G__120145 = cljs.core.next.call(null,seq__120068_120136__$1);
var G__120146 = null;
var G__120147 = (0);
var G__120148 = (0);
seq__120068_120124 = G__120145;
chunk__120069_120125 = G__120146;
count__120070_120126 = G__120147;
i__120071_120127 = G__120148;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,mname_120120," = function(",cljs.compiler.comma_sep.call(null,(cljs.core.truth_(variadic)?cljs.core.concat.call(null,cljs.core.butlast.call(null,maxparams_120121),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):maxparams_120121)),"){");

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,maxparams_120121));

cljs.compiler.emitln.call(null," = var_args;");
} else {
}

cljs.compiler.emitln.call(null,"switch(arguments.length){");

var seq__120084_120149 = cljs.core.seq.call(null,ms_120123);
var chunk__120085_120150 = null;
var count__120086_120151 = (0);
var i__120087_120152 = (0);
while(true){
if((i__120087_120152 < count__120086_120151)){
var vec__120094_120153 = cljs.core._nth.call(null,chunk__120085_120150,i__120087_120152);
var n_120154 = cljs.core.nth.call(null,vec__120094_120153,(0),null);
var meth_120155 = cljs.core.nth.call(null,vec__120094_120153,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_120155))){
cljs.compiler.emitln.call(null,"default:");

var restarg_120156 = cljs.compiler.munge.call(null,cljs.core.gensym.call(null));
cljs.compiler.emitln.call(null,"var ",restarg_120156," = null;");

cljs.compiler.emitln.call(null,"if (arguments.length > ",max_fixed_arity,") {");

var a_120157 = cljs.compiler.emit_arguments_to_array.call(null,max_fixed_arity);
cljs.compiler.emitln.call(null,restarg_120156," = new cljs.core.IndexedSeq(",a_120157,",0,null);");

cljs.compiler.emitln.call(null,"}");

cljs.compiler.emitln.call(null,"return ",n_120154,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep.call(null,cljs.core.butlast.call(null,maxparams_120121)),(((cljs.core.count.call(null,maxparams_120121) > (1)))?", ":null),restarg_120156,");");
} else {
var pcnt_120158 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_120155));
cljs.compiler.emitln.call(null,"case ",pcnt_120158,":");

cljs.compiler.emitln.call(null,"return ",n_120154,".call(this",(((pcnt_120158 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep.call(null,cljs.core.take.call(null,pcnt_120158,maxparams_120121)),null,(1),null)),(2),null))),");");
}


var G__120159 = seq__120084_120149;
var G__120160 = chunk__120085_120150;
var G__120161 = count__120086_120151;
var G__120162 = (i__120087_120152 + (1));
seq__120084_120149 = G__120159;
chunk__120085_120150 = G__120160;
count__120086_120151 = G__120161;
i__120087_120152 = G__120162;
continue;
} else {
var temp__5735__auto___120163 = cljs.core.seq.call(null,seq__120084_120149);
if(temp__5735__auto___120163){
var seq__120084_120164__$1 = temp__5735__auto___120163;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__120084_120164__$1)){
var c__4556__auto___120165 = cljs.core.chunk_first.call(null,seq__120084_120164__$1);
var G__120166 = cljs.core.chunk_rest.call(null,seq__120084_120164__$1);
var G__120167 = c__4556__auto___120165;
var G__120168 = cljs.core.count.call(null,c__4556__auto___120165);
var G__120169 = (0);
seq__120084_120149 = G__120166;
chunk__120085_120150 = G__120167;
count__120086_120151 = G__120168;
i__120087_120152 = G__120169;
continue;
} else {
var vec__120097_120170 = cljs.core.first.call(null,seq__120084_120164__$1);
var n_120171 = cljs.core.nth.call(null,vec__120097_120170,(0),null);
var meth_120172 = cljs.core.nth.call(null,vec__120097_120170,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_120172))){
cljs.compiler.emitln.call(null,"default:");

var restarg_120173 = cljs.compiler.munge.call(null,cljs.core.gensym.call(null));
cljs.compiler.emitln.call(null,"var ",restarg_120173," = null;");

cljs.compiler.emitln.call(null,"if (arguments.length > ",max_fixed_arity,") {");

var a_120174 = cljs.compiler.emit_arguments_to_array.call(null,max_fixed_arity);
cljs.compiler.emitln.call(null,restarg_120173," = new cljs.core.IndexedSeq(",a_120174,",0,null);");

cljs.compiler.emitln.call(null,"}");

cljs.compiler.emitln.call(null,"return ",n_120171,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep.call(null,cljs.core.butlast.call(null,maxparams_120121)),(((cljs.core.count.call(null,maxparams_120121) > (1)))?", ":null),restarg_120173,");");
} else {
var pcnt_120175 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_120172));
cljs.compiler.emitln.call(null,"case ",pcnt_120175,":");

cljs.compiler.emitln.call(null,"return ",n_120171,".call(this",(((pcnt_120175 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep.call(null,cljs.core.take.call(null,pcnt_120175,maxparams_120121)),null,(1),null)),(2),null))),");");
}


var G__120176 = cljs.core.next.call(null,seq__120084_120164__$1);
var G__120177 = null;
var G__120178 = (0);
var G__120179 = (0);
seq__120084_120149 = G__120176;
chunk__120085_120150 = G__120177;
count__120086_120151 = G__120178;
i__120087_120152 = G__120179;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"}");

var arg_count_js_120180 = ((cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"self__","self__",-153190816,null),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.val.call(null,cljs.core.first.call(null,ms_120123)))))))?"(arguments.length - 1)":"arguments.length");
cljs.compiler.emitln.call(null,"throw(new Error('Invalid arity: ' + ",arg_count_js_120180,"));");

cljs.compiler.emitln.call(null,"};");

if(cljs.core.truth_(variadic)){
cljs.compiler.emitln.call(null,mname_120120,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emitln.call(null,mname_120120,".cljs$lang$applyTo = ",cljs.core.some.call(null,(function (p1__120064_SHARP_){
var vec__120100 = p1__120064_SHARP_;
var n = cljs.core.nth.call(null,vec__120100,(0),null);
var m = cljs.core.nth.call(null,vec__120100,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(m))){
return n;
} else {
return null;
}
}),ms_120123),".cljs$lang$applyTo;");
} else {
}

var seq__120103_120181 = cljs.core.seq.call(null,ms_120123);
var chunk__120104_120182 = null;
var count__120105_120183 = (0);
var i__120106_120184 = (0);
while(true){
if((i__120106_120184 < count__120105_120183)){
var vec__120113_120185 = cljs.core._nth.call(null,chunk__120104_120182,i__120106_120184);
var n_120186 = cljs.core.nth.call(null,vec__120113_120185,(0),null);
var meth_120187 = cljs.core.nth.call(null,vec__120113_120185,(1),null);
var c_120188 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_120187));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_120187))){
cljs.compiler.emitln.call(null,mname_120120,".cljs$core$IFn$_invoke$arity$variadic = ",n_120186,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.call(null,mname_120120,".cljs$core$IFn$_invoke$arity$",c_120188," = ",n_120186,";");
}


var G__120189 = seq__120103_120181;
var G__120190 = chunk__120104_120182;
var G__120191 = count__120105_120183;
var G__120192 = (i__120106_120184 + (1));
seq__120103_120181 = G__120189;
chunk__120104_120182 = G__120190;
count__120105_120183 = G__120191;
i__120106_120184 = G__120192;
continue;
} else {
var temp__5735__auto___120193 = cljs.core.seq.call(null,seq__120103_120181);
if(temp__5735__auto___120193){
var seq__120103_120194__$1 = temp__5735__auto___120193;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__120103_120194__$1)){
var c__4556__auto___120195 = cljs.core.chunk_first.call(null,seq__120103_120194__$1);
var G__120196 = cljs.core.chunk_rest.call(null,seq__120103_120194__$1);
var G__120197 = c__4556__auto___120195;
var G__120198 = cljs.core.count.call(null,c__4556__auto___120195);
var G__120199 = (0);
seq__120103_120181 = G__120196;
chunk__120104_120182 = G__120197;
count__120105_120183 = G__120198;
i__120106_120184 = G__120199;
continue;
} else {
var vec__120116_120200 = cljs.core.first.call(null,seq__120103_120194__$1);
var n_120201 = cljs.core.nth.call(null,vec__120116_120200,(0),null);
var meth_120202 = cljs.core.nth.call(null,vec__120116_120200,(1),null);
var c_120203 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_120202));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_120202))){
cljs.compiler.emitln.call(null,mname_120120,".cljs$core$IFn$_invoke$arity$variadic = ",n_120201,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.call(null,mname_120120,".cljs$core$IFn$_invoke$arity$",c_120203," = ",n_120201,";");
}


var G__120204 = cljs.core.next.call(null,seq__120103_120194__$1);
var G__120205 = null;
var G__120206 = (0);
var G__120207 = (0);
seq__120103_120181 = G__120204;
chunk__120104_120182 = G__120205;
count__120105_120183 = G__120206;
i__120106_120184 = G__120207;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"return ",mname_120120,";");

cljs.compiler.emitln.call(null,"})()");
}

if(loop_locals){
return cljs.compiler.emitln.call(null,";})(",cljs.compiler.comma_sep.call(null,loop_locals),"))");
} else {
return null;
}
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"do","do",46310725),(function (p__120208){
var map__120209 = p__120208;
var map__120209__$1 = (((((!((map__120209 == null))))?(((((map__120209.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__120209.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__120209):map__120209);
var statements = cljs.core.get.call(null,map__120209__$1,new cljs.core.Keyword(null,"statements","statements",600349855));
var ret = cljs.core.get.call(null,map__120209__$1,new cljs.core.Keyword(null,"ret","ret",-468222814));
var env = cljs.core.get.call(null,map__120209__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(((cljs.core.seq.call(null,statements)) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
cljs.compiler.emitln.call(null,"(function (){");
} else {
}

var seq__120211_120215 = cljs.core.seq.call(null,statements);
var chunk__120212_120216 = null;
var count__120213_120217 = (0);
var i__120214_120218 = (0);
while(true){
if((i__120214_120218 < count__120213_120217)){
var s_120219 = cljs.core._nth.call(null,chunk__120212_120216,i__120214_120218);
cljs.compiler.emitln.call(null,s_120219);


var G__120220 = seq__120211_120215;
var G__120221 = chunk__120212_120216;
var G__120222 = count__120213_120217;
var G__120223 = (i__120214_120218 + (1));
seq__120211_120215 = G__120220;
chunk__120212_120216 = G__120221;
count__120213_120217 = G__120222;
i__120214_120218 = G__120223;
continue;
} else {
var temp__5735__auto___120224 = cljs.core.seq.call(null,seq__120211_120215);
if(temp__5735__auto___120224){
var seq__120211_120225__$1 = temp__5735__auto___120224;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__120211_120225__$1)){
var c__4556__auto___120226 = cljs.core.chunk_first.call(null,seq__120211_120225__$1);
var G__120227 = cljs.core.chunk_rest.call(null,seq__120211_120225__$1);
var G__120228 = c__4556__auto___120226;
var G__120229 = cljs.core.count.call(null,c__4556__auto___120226);
var G__120230 = (0);
seq__120211_120215 = G__120227;
chunk__120212_120216 = G__120228;
count__120213_120217 = G__120229;
i__120214_120218 = G__120230;
continue;
} else {
var s_120231 = cljs.core.first.call(null,seq__120211_120225__$1);
cljs.compiler.emitln.call(null,s_120231);


var G__120232 = cljs.core.next.call(null,seq__120211_120225__$1);
var G__120233 = null;
var G__120234 = (0);
var G__120235 = (0);
seq__120211_120215 = G__120232;
chunk__120212_120216 = G__120233;
count__120213_120217 = G__120234;
i__120214_120218 = G__120235;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emit.call(null,ret);

if(((cljs.core.seq.call(null,statements)) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
return cljs.compiler.emitln.call(null,"})()");
} else {
return null;
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"try","try",1380742522),(function (p__120236){
var map__120237 = p__120236;
var map__120237__$1 = (((((!((map__120237 == null))))?(((((map__120237.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__120237.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__120237):map__120237);
var try$ = cljs.core.get.call(null,map__120237__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var env = cljs.core.get.call(null,map__120237__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var catch$ = cljs.core.get.call(null,map__120237__$1,new cljs.core.Keyword(null,"catch","catch",1038065524));
var name = cljs.core.get.call(null,map__120237__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var finally$ = cljs.core.get.call(null,map__120237__$1,new cljs.core.Keyword(null,"finally","finally",1589088705));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_((function (){var or__4126__auto__ = name;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return finally$;
}
})())){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.call(null,"(function (){");
} else {
}

cljs.compiler.emits.call(null,"try{",try$,"}");

if(cljs.core.truth_(name)){
cljs.compiler.emits.call(null,"catch (",cljs.compiler.munge.call(null,name),"){",catch$,"}");
} else {
}

if(cljs.core.truth_(finally$)){
if(cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"const","const",1709929842),new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.unwrap_quote.call(null,finally$)))){
} else {
throw (new Error(["Assert failed: ","finally block cannot contain constant","\n","(not= :const (:op (ana/unwrap-quote finally)))"].join('')));
}

cljs.compiler.emits.call(null,"finally {",finally$,"}");
} else {
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"})()");
} else {
return null;
}
} else {
return cljs.compiler.emits.call(null,try$);
}
}));
cljs.compiler.emit_let = (function cljs$compiler$emit_let(p__120239,is_loop){
var map__120240 = p__120239;
var map__120240__$1 = (((((!((map__120240 == null))))?(((((map__120240.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__120240.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__120240):map__120240);
var expr = cljs.core.get.call(null,map__120240__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.call(null,map__120240__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.call(null,map__120240__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.call(null,"(function (){");
} else {
}

var _STAR_lexical_renames_STAR__orig_val__120242_120256 = cljs.compiler._STAR_lexical_renames_STAR_;
var _STAR_lexical_renames_STAR__temp_val__120243_120257 = cljs.core.into.call(null,cljs.compiler._STAR_lexical_renames_STAR_,((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),context))?cljs.core.map.call(null,(function (binding){
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(binding);
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.compiler.hash_scope.call(null,binding),cljs.core.gensym.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"-"].join(''))],null));
}),bindings):null));
(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__temp_val__120243_120257);

try{var seq__120244_120258 = cljs.core.seq.call(null,bindings);
var chunk__120245_120259 = null;
var count__120246_120260 = (0);
var i__120247_120261 = (0);
while(true){
if((i__120247_120261 < count__120246_120260)){
var map__120252_120262 = cljs.core._nth.call(null,chunk__120245_120259,i__120247_120261);
var map__120252_120263__$1 = (((((!((map__120252_120262 == null))))?(((((map__120252_120262.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__120252_120262.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__120252_120262):map__120252_120262);
var binding_120264 = map__120252_120263__$1;
var init_120265 = cljs.core.get.call(null,map__120252_120263__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,binding_120264);

cljs.compiler.emitln.call(null," = ",init_120265,";");


var G__120266 = seq__120244_120258;
var G__120267 = chunk__120245_120259;
var G__120268 = count__120246_120260;
var G__120269 = (i__120247_120261 + (1));
seq__120244_120258 = G__120266;
chunk__120245_120259 = G__120267;
count__120246_120260 = G__120268;
i__120247_120261 = G__120269;
continue;
} else {
var temp__5735__auto___120270 = cljs.core.seq.call(null,seq__120244_120258);
if(temp__5735__auto___120270){
var seq__120244_120271__$1 = temp__5735__auto___120270;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__120244_120271__$1)){
var c__4556__auto___120272 = cljs.core.chunk_first.call(null,seq__120244_120271__$1);
var G__120273 = cljs.core.chunk_rest.call(null,seq__120244_120271__$1);
var G__120274 = c__4556__auto___120272;
var G__120275 = cljs.core.count.call(null,c__4556__auto___120272);
var G__120276 = (0);
seq__120244_120258 = G__120273;
chunk__120245_120259 = G__120274;
count__120246_120260 = G__120275;
i__120247_120261 = G__120276;
continue;
} else {
var map__120254_120277 = cljs.core.first.call(null,seq__120244_120271__$1);
var map__120254_120278__$1 = (((((!((map__120254_120277 == null))))?(((((map__120254_120277.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__120254_120277.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__120254_120277):map__120254_120277);
var binding_120279 = map__120254_120278__$1;
var init_120280 = cljs.core.get.call(null,map__120254_120278__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,binding_120279);

cljs.compiler.emitln.call(null," = ",init_120280,";");


var G__120281 = cljs.core.next.call(null,seq__120244_120271__$1);
var G__120282 = null;
var G__120283 = (0);
var G__120284 = (0);
seq__120244_120258 = G__120281;
chunk__120245_120259 = G__120282;
count__120246_120260 = G__120283;
i__120247_120261 = G__120284;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.call(null,"while(true){");
} else {
}

cljs.compiler.emits.call(null,expr);

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.call(null,"break;");

cljs.compiler.emitln.call(null,"}");
} else {
}
}finally {(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__orig_val__120242_120256);
}
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"})()");
} else {
return null;
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"let","let",-1282412701),(function (ast){
return cljs.compiler.emit_let.call(null,ast,false);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"loop","loop",-395552849),(function (ast){
return cljs.compiler.emit_let.call(null,ast,true);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"recur","recur",-437573268),(function (p__120285){
var map__120286 = p__120285;
var map__120286__$1 = (((((!((map__120286 == null))))?(((((map__120286.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__120286.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__120286):map__120286);
var frame = cljs.core.get.call(null,map__120286__$1,new cljs.core.Keyword(null,"frame","frame",-1711082588));
var exprs = cljs.core.get.call(null,map__120286__$1,new cljs.core.Keyword(null,"exprs","exprs",1795829094));
var env = cljs.core.get.call(null,map__120286__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var temps = cljs.core.vec.call(null,cljs.core.take.call(null,cljs.core.count.call(null,exprs),cljs.core.repeatedly.call(null,cljs.core.gensym)));
var params = new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(frame);
var n__4613__auto___120288 = cljs.core.count.call(null,exprs);
var i_120289 = (0);
while(true){
if((i_120289 < n__4613__auto___120288)){
cljs.compiler.emitln.call(null,"var ",temps.call(null,i_120289)," = ",exprs.call(null,i_120289),";");

var G__120290 = (i_120289 + (1));
i_120289 = G__120290;
continue;
} else {
}
break;
}

var n__4613__auto___120291 = cljs.core.count.call(null,exprs);
var i_120292 = (0);
while(true){
if((i_120292 < n__4613__auto___120291)){
cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,params.call(null,i_120292))," = ",temps.call(null,i_120292),";");

var G__120293 = (i_120292 + (1));
i_120292 = G__120293;
continue;
} else {
}
break;
}

return cljs.compiler.emitln.call(null,"continue;");
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"letfn","letfn",-2121022354),(function (p__120294){
var map__120295 = p__120294;
var map__120295__$1 = (((((!((map__120295 == null))))?(((((map__120295.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__120295.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__120295):map__120295);
var expr = cljs.core.get.call(null,map__120295__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.call(null,map__120295__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.call(null,map__120295__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.call(null,"(function (){");
} else {
}

var seq__120297_120309 = cljs.core.seq.call(null,bindings);
var chunk__120298_120310 = null;
var count__120299_120311 = (0);
var i__120300_120312 = (0);
while(true){
if((i__120300_120312 < count__120299_120311)){
var map__120305_120313 = cljs.core._nth.call(null,chunk__120298_120310,i__120300_120312);
var map__120305_120314__$1 = (((((!((map__120305_120313 == null))))?(((((map__120305_120313.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__120305_120313.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__120305_120313):map__120305_120313);
var binding_120315 = map__120305_120314__$1;
var init_120316 = cljs.core.get.call(null,map__120305_120314__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.call(null,"var ",cljs.compiler.munge.call(null,binding_120315)," = ",init_120316,";");


var G__120317 = seq__120297_120309;
var G__120318 = chunk__120298_120310;
var G__120319 = count__120299_120311;
var G__120320 = (i__120300_120312 + (1));
seq__120297_120309 = G__120317;
chunk__120298_120310 = G__120318;
count__120299_120311 = G__120319;
i__120300_120312 = G__120320;
continue;
} else {
var temp__5735__auto___120321 = cljs.core.seq.call(null,seq__120297_120309);
if(temp__5735__auto___120321){
var seq__120297_120322__$1 = temp__5735__auto___120321;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__120297_120322__$1)){
var c__4556__auto___120323 = cljs.core.chunk_first.call(null,seq__120297_120322__$1);
var G__120324 = cljs.core.chunk_rest.call(null,seq__120297_120322__$1);
var G__120325 = c__4556__auto___120323;
var G__120326 = cljs.core.count.call(null,c__4556__auto___120323);
var G__120327 = (0);
seq__120297_120309 = G__120324;
chunk__120298_120310 = G__120325;
count__120299_120311 = G__120326;
i__120300_120312 = G__120327;
continue;
} else {
var map__120307_120328 = cljs.core.first.call(null,seq__120297_120322__$1);
var map__120307_120329__$1 = (((((!((map__120307_120328 == null))))?(((((map__120307_120328.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__120307_120328.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__120307_120328):map__120307_120328);
var binding_120330 = map__120307_120329__$1;
var init_120331 = cljs.core.get.call(null,map__120307_120329__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.call(null,"var ",cljs.compiler.munge.call(null,binding_120330)," = ",init_120331,";");


var G__120332 = cljs.core.next.call(null,seq__120297_120322__$1);
var G__120333 = null;
var G__120334 = (0);
var G__120335 = (0);
seq__120297_120309 = G__120332;
chunk__120298_120310 = G__120333;
count__120299_120311 = G__120334;
i__120300_120312 = G__120335;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.call(null,expr);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"})()");
} else {
return null;
}
}));
cljs.compiler.protocol_prefix = (function cljs$compiler$protocol_prefix(psym){
return cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym).replace((new RegExp("\\.","g")),"$").replace("/","$")),"$"].join(''));
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"invoke","invoke",1145927159),(function (p__120338){
var map__120339 = p__120338;
var map__120339__$1 = (((((!((map__120339 == null))))?(((((map__120339.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__120339.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__120339):map__120339);
var expr = map__120339__$1;
var f = cljs.core.get.call(null,map__120339__$1,new cljs.core.Keyword(null,"fn","fn",-1175266204));
var args = cljs.core.get.call(null,map__120339__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.call(null,map__120339__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(f);
var fn_QMARK_ = (function (){var and__4115__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4115__auto__)){
if(cljs.core.not.call(null,new cljs.core.Keyword(null,"dynamic","dynamic",704819571).cljs$core$IFn$_invoke$arity$1(info))){
return new cljs.core.Keyword(null,"fn-var","fn-var",1086204730).cljs$core$IFn$_invoke$arity$1(info);
} else {
return false;
}
} else {
return and__4115__auto__;
}
})();
var protocol = new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(info);
var tag = cljs.analyzer.infer_tag.call(null,env,cljs.core.first.call(null,new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var proto_QMARK_ = (function (){var and__4115__auto__ = protocol;
if(cljs.core.truth_(and__4115__auto__)){
var and__4115__auto____$1 = tag;
if(cljs.core.truth_(and__4115__auto____$1)){
var or__4126__auto__ = (function (){var and__4115__auto____$2 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4115__auto____$2)){
var and__4115__auto____$3 = protocol;
if(cljs.core.truth_(and__4115__auto____$3)){
return cljs.core._EQ_.call(null,tag,new cljs.core.Symbol(null,"not-native","not-native",-236392494,null));
} else {
return and__4115__auto____$3;
}
} else {
return and__4115__auto____$2;
}
})();
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var and__4115__auto____$2 = (function (){var or__4126__auto____$1 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556).cljs$core$IFn$_invoke$arity$1(env);
}
})();
if(cljs.core.truth_(and__4115__auto____$2)){
var or__4126__auto____$1 = cljs.core._EQ_.call(null,protocol,tag);
if(or__4126__auto____$1){
return or__4126__auto____$1;
} else {
if((!(cljs.core.set_QMARK_.call(null,tag)))){
if(cljs.core.not.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Symbol(null,"clj","clj",980036099,null),"null",new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),"null",new cljs.core.Symbol(null,"object","object",-1179821820,null),"null",new cljs.core.Symbol(null,"any","any",-948528346,null),"null",new cljs.core.Symbol(null,"js","js",-886355190,null),"null",new cljs.core.Symbol(null,"number","number",-1084057331,null),"null",new cljs.core.Symbol(null,"clj-or-nil","clj-or-nil",-2008798668,null),"null",new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null",new cljs.core.Symbol(null,"function","function",-486723946,null),"null",new cljs.core.Symbol(null,"clj-nil","clj-nil",1321798654,null),"null"], null), null).call(null,tag))){
var temp__5735__auto__ = new cljs.core.Keyword(null,"protocols","protocols",-5615896).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_existing_var.call(null,env,cljs.core.vary_meta.call(null,tag,cljs.core.assoc,new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true)));
if(cljs.core.truth_(temp__5735__auto__)){
var ps = temp__5735__auto__;
return ps.call(null,protocol);
} else {
return null;
}
} else {
return false;
}
} else {
return false;
}
}
} else {
return and__4115__auto____$2;
}
}
} else {
return and__4115__auto____$1;
}
} else {
return and__4115__auto__;
}
})();
var first_arg_tag = cljs.analyzer.infer_tag.call(null,env,cljs.core.first.call(null,new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var opt_not_QMARK_ = ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","not","cljs.core/not",100665144,null))) && (cljs.core._EQ_.call(null,first_arg_tag,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null))));
var opt_count_QMARK_ = ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null))) && (cljs.core.boolean$.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null"], null), null).call(null,first_arg_tag))));
var ns = new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(info);
var ftag = cljs.analyzer.infer_tag.call(null,env,f);
var js_QMARK_ = (function (){var or__4126__auto__ = cljs.core._EQ_.call(null,ns,new cljs.core.Symbol(null,"js","js",-886355190,null));
if(or__4126__auto__){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = cljs.core._EQ_.call(null,ns,new cljs.core.Symbol(null,"Math","Math",2033287572,null));
if(or__4126__auto____$1){
return or__4126__auto____$1;
} else {
return new cljs.core.Keyword(null,"foreign","foreign",990521149).cljs$core$IFn$_invoke$arity$1(info);
}
}
})();
var goog_QMARK_ = (cljs.core.truth_(ns)?(function (){var or__4126__auto__ = cljs.core._EQ_.call(null,ns,new cljs.core.Symbol(null,"goog","goog",-70603925,null));
if(or__4126__auto__){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = (function (){var temp__5735__auto__ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
if(cljs.core.truth_(temp__5735__auto__)){
var ns_str = temp__5735__auto__;
return cljs.core._EQ_.call(null,cljs.core.get.call(null,clojure.string.split.call(null,ns_str,/\./),(0),null),"goog");
} else {
return null;
}
})();
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return (!(cljs.core.contains_QMARK_.call(null,new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)),ns)));
}
}
})():null);
var keyword_QMARK_ = (function (){var or__4126__auto__ = cljs.core._EQ_.call(null,new cljs.core.Symbol("cljs.core","Keyword","cljs.core/Keyword",-451434488,null),ftag);
if(or__4126__auto__){
return or__4126__auto__;
} else {
var f__$1 = cljs.analyzer.unwrap_quote.call(null,f);
return ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1),new cljs.core.Keyword(null,"const","const",1709929842))) && ((new cljs.core.Keyword(null,"form","form",-1624062471).cljs$core$IFn$_invoke$arity$1(f__$1) instanceof cljs.core.Keyword)));
}
})();
var vec__120341 = (cljs.core.truth_(fn_QMARK_)?(function (){var arity = cljs.core.count.call(null,args);
var variadic_QMARK_ = new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(info);
var mps = new cljs.core.Keyword(null,"method-params","method-params",-980792179).cljs$core$IFn$_invoke$arity$1(info);
var mfa = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(info);
if(((cljs.core.not.call(null,variadic_QMARK_)) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,mps),(1))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = variadic_QMARK_;
if(cljs.core.truth_(and__4115__auto__)){
return (arity > mfa);
} else {
return and__4115__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.call(null,f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.call(null,cljs.core.assoc.call(null,info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,info__$1)),".cljs$core$IFn$_invoke$arity$variadic"].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__120336_SHARP_){
return cljs.core.dissoc.call(null,cljs.core.dissoc.call(null,p1__120336_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),mfa], null)], null);
} else {
var arities = cljs.core.map.call(null,cljs.core.count,mps);
if(cljs.core.truth_(cljs.core.some.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([arity]),arities))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.call(null,f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.call(null,cljs.core.assoc.call(null,info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,info__$1)),".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arity)].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__120337_SHARP_){
return cljs.core.dissoc.call(null,cljs.core.dissoc.call(null,p1__120337_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),null], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
}

}
}
})():new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null));
var f__$1 = cljs.core.nth.call(null,vec__120341,(0),null);
var variadic_invoke = cljs.core.nth.call(null,vec__120341,(1),null);
var env__119443__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__119443__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(opt_not_QMARK_){
cljs.compiler.emits.call(null,"(!(",cljs.core.first.call(null,args),"))");
} else {
if(opt_count_QMARK_){
cljs.compiler.emits.call(null,"((",cljs.core.first.call(null,args),").length)");
} else {
if(cljs.core.truth_(proto_QMARK_)){
var pimpl_120344 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,cljs.compiler.protocol_prefix.call(null,protocol))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,cljs.core.name.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info)))),"$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,args))].join('');
cljs.compiler.emits.call(null,cljs.core.first.call(null,args),".",pimpl_120344,"(",cljs.compiler.comma_sep.call(null,cljs.core.cons.call(null,"null",cljs.core.rest.call(null,args))),")");
} else {
if(keyword_QMARK_){
cljs.compiler.emits.call(null,f__$1,".cljs$core$IFn$_invoke$arity$",cljs.core.count.call(null,args),"(",cljs.compiler.comma_sep.call(null,args),")");
} else {
if(cljs.core.truth_(variadic_invoke)){
var mfa_120345 = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(variadic_invoke);
cljs.compiler.emits.call(null,f__$1,"(",cljs.compiler.comma_sep.call(null,cljs.core.take.call(null,mfa_120345,args)),(((mfa_120345 === (0)))?null:","),"cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([",cljs.compiler.comma_sep.call(null,cljs.core.drop.call(null,mfa_120345,args)),"], 0))");
} else {
if(cljs.core.truth_((function (){var or__4126__auto__ = fn_QMARK_;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = js_QMARK_;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return goog_QMARK_;
}
}
})())){
cljs.compiler.emits.call(null,f__$1,"(",cljs.compiler.comma_sep.call(null,args),")");
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4115__auto__)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null).call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1));
} else {
return and__4115__auto__;
}
})())){
var fprop_120346 = [".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,args))].join('');
if(cljs.core.truth_(cljs.analyzer._STAR_fn_invoke_direct_STAR_)){
cljs.compiler.emits.call(null,"(",f__$1,fprop_120346," ? ",f__$1,fprop_120346,"(",cljs.compiler.comma_sep.call(null,args),") : ",f__$1,"(",cljs.compiler.comma_sep.call(null,args),"))");
} else {
cljs.compiler.emits.call(null,"(",f__$1,fprop_120346," ? ",f__$1,fprop_120346,"(",cljs.compiler.comma_sep.call(null,args),") : ",f__$1,".call(",cljs.compiler.comma_sep.call(null,cljs.core.cons.call(null,"null",args)),"))");
}
} else {
cljs.compiler.emits.call(null,f__$1,".call(",cljs.compiler.comma_sep.call(null,cljs.core.cons.call(null,"null",args)),")");
}

}
}
}
}
}
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__119443__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"new","new",-2085437848),(function (p__120347){
var map__120348 = p__120347;
var map__120348__$1 = (((((!((map__120348 == null))))?(((((map__120348.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__120348.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__120348):map__120348);
var ctor = cljs.core.get.call(null,map__120348__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var args = cljs.core.get.call(null,map__120348__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.call(null,map__120348__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__119443__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__119443__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"(new ",ctor,"(",cljs.compiler.comma_sep.call(null,args),"))");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__119443__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"set!","set!",-1389817006),(function (p__120350){
var map__120351 = p__120350;
var map__120351__$1 = (((((!((map__120351 == null))))?(((((map__120351.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__120351.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__120351):map__120351);
var target = cljs.core.get.call(null,map__120351__$1,new cljs.core.Keyword(null,"target","target",253001721));
var val = cljs.core.get.call(null,map__120351__$1,new cljs.core.Keyword(null,"val","val",128701612));
var env = cljs.core.get.call(null,map__120351__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__119443__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__119443__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"(",target," = ",val,")");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__119443__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.emit_global_export = (function cljs$compiler$emit_global_export(ns_name,global_exports,lib){
return cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,ns_name),".",cljs.analyzer.munge_global_export.call(null,lib)," = goog.global",cljs.core.apply.call(null,cljs.core.str,cljs.core.map.call(null,(function (prop){
return ["[\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prop),"\"]"].join('');
}),clojure.string.split.call(null,cljs.core.name.call(null,(function (){var or__4126__auto__ = cljs.core.get.call(null,global_exports,cljs.core.symbol.call(null,lib));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.call(null,global_exports,cljs.core.name.call(null,lib));
}
})()),/\./))),";");
});
cljs.compiler.load_libs = (function cljs$compiler$load_libs(libs,seen,reloads,deps,ns_name){
var map__120353 = cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_);
var map__120353__$1 = (((((!((map__120353 == null))))?(((((map__120353.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__120353.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__120353):map__120353);
var options = cljs.core.get.call(null,map__120353__$1,new cljs.core.Keyword(null,"options","options",99638489));
var js_dependency_index = cljs.core.get.call(null,map__120353__$1,new cljs.core.Keyword(null,"js-dependency-index","js-dependency-index",-1887042131));
var map__120354 = options;
var map__120354__$1 = (((((!((map__120354 == null))))?(((((map__120354.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__120354.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__120354):map__120354);
var target = cljs.core.get.call(null,map__120354__$1,new cljs.core.Keyword(null,"target","target",253001721));
var nodejs_rt = cljs.core.get.call(null,map__120354__$1,new cljs.core.Keyword(null,"nodejs-rt","nodejs-rt",-512437071));
var optimizations = cljs.core.get.call(null,map__120354__$1,new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854));
var loaded_libs = cljs.compiler.munge.call(null,new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null));
var loaded_libs_temp = cljs.compiler.munge.call(null,cljs.core.gensym.call(null,new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null)));
var vec__120355 = (function (){var libs__$1 = cljs.core.remove.call(null,cljs.core.set.call(null,cljs.core.vals.call(null,seen)),cljs.core.filter.call(null,cljs.core.set.call(null,cljs.core.vals.call(null,libs)),deps));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"nodejs","nodejs",321212524),target)){
var map__120360 = cljs.core.group_by.call(null,cljs.analyzer.node_module_dep_QMARK_,libs__$1);
var map__120360__$1 = (((((!((map__120360 == null))))?(((((map__120360.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__120360.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__120360):map__120360);
var node_libs = cljs.core.get.call(null,map__120360__$1,true);
var libs_to_load = cljs.core.get.call(null,map__120360__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [node_libs,libs_to_load], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,libs__$1], null);
}
})();
var node_libs = cljs.core.nth.call(null,vec__120355,(0),null);
var libs_to_load = cljs.core.nth.call(null,vec__120355,(1),null);
var global_exports_libs = cljs.core.filter.call(null,cljs.analyzer.dep_has_global_exports_QMARK_,libs_to_load);
if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs)))){
cljs.compiler.emitln.call(null,"if(!COMPILED) ",loaded_libs_temp," = ",loaded_libs," || cljs.core.set([\"cljs.core\"]);");

cljs.compiler.emitln.call(null,"if(!COMPILED) ",loaded_libs," = cljs.core.set([\"cljs.core\"]);");
} else {
}

var seq__120362_120382 = cljs.core.seq.call(null,libs_to_load);
var chunk__120363_120383 = null;
var count__120364_120384 = (0);
var i__120365_120385 = (0);
while(true){
if((i__120365_120385 < count__120364_120384)){
var lib_120386 = cljs.core._nth.call(null,chunk__120363_120383,i__120365_120385);
if(((cljs.analyzer.foreign_dep_QMARK_.call(null,lib_120386)) && ((!(cljs.core.keyword_identical_QMARK_.call(null,optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__4126__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_120386),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_120386),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4126__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_120386),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_120386),"', 'reload-all');");
} else {
if(cljs.core._EQ_.call(null,lib_120386,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_120386),"');");
}

}
}
}


var G__120387 = seq__120362_120382;
var G__120388 = chunk__120363_120383;
var G__120389 = count__120364_120384;
var G__120390 = (i__120365_120385 + (1));
seq__120362_120382 = G__120387;
chunk__120363_120383 = G__120388;
count__120364_120384 = G__120389;
i__120365_120385 = G__120390;
continue;
} else {
var temp__5735__auto___120391 = cljs.core.seq.call(null,seq__120362_120382);
if(temp__5735__auto___120391){
var seq__120362_120392__$1 = temp__5735__auto___120391;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__120362_120392__$1)){
var c__4556__auto___120393 = cljs.core.chunk_first.call(null,seq__120362_120392__$1);
var G__120394 = cljs.core.chunk_rest.call(null,seq__120362_120392__$1);
var G__120395 = c__4556__auto___120393;
var G__120396 = cljs.core.count.call(null,c__4556__auto___120393);
var G__120397 = (0);
seq__120362_120382 = G__120394;
chunk__120363_120383 = G__120395;
count__120364_120384 = G__120396;
i__120365_120385 = G__120397;
continue;
} else {
var lib_120398 = cljs.core.first.call(null,seq__120362_120392__$1);
if(((cljs.analyzer.foreign_dep_QMARK_.call(null,lib_120398)) && ((!(cljs.core.keyword_identical_QMARK_.call(null,optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__4126__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_120398),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_120398),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4126__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_120398),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_120398),"', 'reload-all');");
} else {
if(cljs.core._EQ_.call(null,lib_120398,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_120398),"');");
}

}
}
}


var G__120399 = cljs.core.next.call(null,seq__120362_120392__$1);
var G__120400 = null;
var G__120401 = (0);
var G__120402 = (0);
seq__120362_120382 = G__120399;
chunk__120363_120383 = G__120400;
count__120364_120384 = G__120401;
i__120365_120385 = G__120402;
continue;
}
} else {
}
}
break;
}

var seq__120366_120403 = cljs.core.seq.call(null,node_libs);
var chunk__120367_120404 = null;
var count__120368_120405 = (0);
var i__120369_120406 = (0);
while(true){
if((i__120369_120406 < count__120368_120405)){
var lib_120407 = cljs.core._nth.call(null,chunk__120367_120404,i__120369_120406);
cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,ns_name),".",cljs.analyzer.munge_node_lib.call(null,lib_120407)," = require('",lib_120407,"');");


var G__120408 = seq__120366_120403;
var G__120409 = chunk__120367_120404;
var G__120410 = count__120368_120405;
var G__120411 = (i__120369_120406 + (1));
seq__120366_120403 = G__120408;
chunk__120367_120404 = G__120409;
count__120368_120405 = G__120410;
i__120369_120406 = G__120411;
continue;
} else {
var temp__5735__auto___120412 = cljs.core.seq.call(null,seq__120366_120403);
if(temp__5735__auto___120412){
var seq__120366_120413__$1 = temp__5735__auto___120412;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__120366_120413__$1)){
var c__4556__auto___120414 = cljs.core.chunk_first.call(null,seq__120366_120413__$1);
var G__120415 = cljs.core.chunk_rest.call(null,seq__120366_120413__$1);
var G__120416 = c__4556__auto___120414;
var G__120417 = cljs.core.count.call(null,c__4556__auto___120414);
var G__120418 = (0);
seq__120366_120403 = G__120415;
chunk__120367_120404 = G__120416;
count__120368_120405 = G__120417;
i__120369_120406 = G__120418;
continue;
} else {
var lib_120419 = cljs.core.first.call(null,seq__120366_120413__$1);
cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,ns_name),".",cljs.analyzer.munge_node_lib.call(null,lib_120419)," = require('",lib_120419,"');");


var G__120420 = cljs.core.next.call(null,seq__120366_120413__$1);
var G__120421 = null;
var G__120422 = (0);
var G__120423 = (0);
seq__120366_120403 = G__120420;
chunk__120367_120404 = G__120421;
count__120368_120405 = G__120422;
i__120369_120406 = G__120423;
continue;
}
} else {
}
}
break;
}

var seq__120370_120424 = cljs.core.seq.call(null,global_exports_libs);
var chunk__120371_120425 = null;
var count__120372_120426 = (0);
var i__120373_120427 = (0);
while(true){
if((i__120373_120427 < count__120372_120426)){
var lib_120428 = cljs.core._nth.call(null,chunk__120371_120425,i__120373_120427);
var map__120378_120429 = cljs.core.get.call(null,js_dependency_index,cljs.core.name.call(null,lib_120428));
var map__120378_120430__$1 = (((((!((map__120378_120429 == null))))?(((((map__120378_120429.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__120378_120429.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__120378_120429):map__120378_120429);
var global_exports_120431 = cljs.core.get.call(null,map__120378_120430__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export.call(null,ns_name,global_exports_120431,lib_120428);


var G__120432 = seq__120370_120424;
var G__120433 = chunk__120371_120425;
var G__120434 = count__120372_120426;
var G__120435 = (i__120373_120427 + (1));
seq__120370_120424 = G__120432;
chunk__120371_120425 = G__120433;
count__120372_120426 = G__120434;
i__120373_120427 = G__120435;
continue;
} else {
var temp__5735__auto___120436 = cljs.core.seq.call(null,seq__120370_120424);
if(temp__5735__auto___120436){
var seq__120370_120437__$1 = temp__5735__auto___120436;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__120370_120437__$1)){
var c__4556__auto___120438 = cljs.core.chunk_first.call(null,seq__120370_120437__$1);
var G__120439 = cljs.core.chunk_rest.call(null,seq__120370_120437__$1);
var G__120440 = c__4556__auto___120438;
var G__120441 = cljs.core.count.call(null,c__4556__auto___120438);
var G__120442 = (0);
seq__120370_120424 = G__120439;
chunk__120371_120425 = G__120440;
count__120372_120426 = G__120441;
i__120373_120427 = G__120442;
continue;
} else {
var lib_120443 = cljs.core.first.call(null,seq__120370_120437__$1);
var map__120380_120444 = cljs.core.get.call(null,js_dependency_index,cljs.core.name.call(null,lib_120443));
var map__120380_120445__$1 = (((((!((map__120380_120444 == null))))?(((((map__120380_120444.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__120380_120444.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__120380_120444):map__120380_120444);
var global_exports_120446 = cljs.core.get.call(null,map__120380_120445__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export.call(null,ns_name,global_exports_120446,lib_120443);


var G__120447 = cljs.core.next.call(null,seq__120370_120437__$1);
var G__120448 = null;
var G__120449 = (0);
var G__120450 = (0);
seq__120370_120424 = G__120447;
chunk__120371_120425 = G__120448;
count__120372_120426 = G__120449;
i__120373_120427 = G__120450;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs)))){
return cljs.compiler.emitln.call(null,"if(!COMPILED) ",loaded_libs," = cljs.core.into(",loaded_libs_temp,", ",loaded_libs,");");
} else {
return null;
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"ns*","ns*",200417856),(function (p__120451){
var map__120452 = p__120451;
var map__120452__$1 = (((((!((map__120452 == null))))?(((((map__120452.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__120452.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__120452):map__120452);
var name = cljs.core.get.call(null,map__120452__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.call(null,map__120452__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.call(null,map__120452__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.call(null,map__120452__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.call(null,map__120452__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.call(null,map__120452__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.call(null,map__120452__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.load_libs.call(null,requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

cljs.compiler.load_libs.call(null,uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

if(cljs.core.truth_(new cljs.core.Keyword(null,"repl-env","repl-env",-1976503928).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.call(null,"'nil';");
} else {
return null;
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"ns","ns",441598760),(function (p__120454){
var map__120455 = p__120454;
var map__120455__$1 = (((((!((map__120455 == null))))?(((((map__120455.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__120455.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__120455):map__120455);
var name = cljs.core.get.call(null,map__120455__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.call(null,map__120455__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.call(null,map__120455__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.call(null,map__120455__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.call(null,map__120455__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.call(null,map__120455__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.call(null,map__120455__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.emitln.call(null,"goog.provide('",cljs.compiler.munge.call(null,name),"');");

if(cljs.core._EQ_.call(null,name,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null))){
} else {
cljs.compiler.emitln.call(null,"goog.require('cljs.core');");

if(cljs.core.truth_(new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_))))){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,cljs.analyzer.constants_ns_sym),"');");
} else {
}
}

cljs.compiler.load_libs.call(null,requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

return cljs.compiler.load_libs.call(null,uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"deftype","deftype",340294561),(function (p__120457){
var map__120458 = p__120457;
var map__120458__$1 = (((((!((map__120458 == null))))?(((((map__120458.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__120458.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__120458):map__120458);
var t = cljs.core.get.call(null,map__120458__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.call(null,map__120458__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.call(null,map__120458__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.call(null,map__120458__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.call(null,map__120458__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.map.call(null,cljs.compiler.munge,fields);
cljs.compiler.emitln.call(null,"");

cljs.compiler.emitln.call(null,"/**");

cljs.compiler.emitln.call(null,"* @constructor");

var seq__120460_120484 = cljs.core.seq.call(null,protocols);
var chunk__120461_120485 = null;
var count__120462_120486 = (0);
var i__120463_120487 = (0);
while(true){
if((i__120463_120487 < count__120462_120486)){
var protocol_120488 = cljs.core._nth.call(null,chunk__120461_120485,i__120463_120487);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_120488)),"}");


var G__120489 = seq__120460_120484;
var G__120490 = chunk__120461_120485;
var G__120491 = count__120462_120486;
var G__120492 = (i__120463_120487 + (1));
seq__120460_120484 = G__120489;
chunk__120461_120485 = G__120490;
count__120462_120486 = G__120491;
i__120463_120487 = G__120492;
continue;
} else {
var temp__5735__auto___120493 = cljs.core.seq.call(null,seq__120460_120484);
if(temp__5735__auto___120493){
var seq__120460_120494__$1 = temp__5735__auto___120493;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__120460_120494__$1)){
var c__4556__auto___120495 = cljs.core.chunk_first.call(null,seq__120460_120494__$1);
var G__120496 = cljs.core.chunk_rest.call(null,seq__120460_120494__$1);
var G__120497 = c__4556__auto___120495;
var G__120498 = cljs.core.count.call(null,c__4556__auto___120495);
var G__120499 = (0);
seq__120460_120484 = G__120496;
chunk__120461_120485 = G__120497;
count__120462_120486 = G__120498;
i__120463_120487 = G__120499;
continue;
} else {
var protocol_120500 = cljs.core.first.call(null,seq__120460_120494__$1);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_120500)),"}");


var G__120501 = cljs.core.next.call(null,seq__120460_120494__$1);
var G__120502 = null;
var G__120503 = (0);
var G__120504 = (0);
seq__120460_120484 = G__120501;
chunk__120461_120485 = G__120502;
count__120462_120486 = G__120503;
i__120463_120487 = G__120504;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"*/");

cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,t)," = (function (",cljs.compiler.comma_sep.call(null,fields__$1),"){");

var seq__120464_120505 = cljs.core.seq.call(null,fields__$1);
var chunk__120465_120506 = null;
var count__120466_120507 = (0);
var i__120467_120508 = (0);
while(true){
if((i__120467_120508 < count__120466_120507)){
var fld_120509 = cljs.core._nth.call(null,chunk__120465_120506,i__120467_120508);
cljs.compiler.emitln.call(null,"this.",fld_120509," = ",fld_120509,";");


var G__120510 = seq__120464_120505;
var G__120511 = chunk__120465_120506;
var G__120512 = count__120466_120507;
var G__120513 = (i__120467_120508 + (1));
seq__120464_120505 = G__120510;
chunk__120465_120506 = G__120511;
count__120466_120507 = G__120512;
i__120467_120508 = G__120513;
continue;
} else {
var temp__5735__auto___120514 = cljs.core.seq.call(null,seq__120464_120505);
if(temp__5735__auto___120514){
var seq__120464_120515__$1 = temp__5735__auto___120514;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__120464_120515__$1)){
var c__4556__auto___120516 = cljs.core.chunk_first.call(null,seq__120464_120515__$1);
var G__120517 = cljs.core.chunk_rest.call(null,seq__120464_120515__$1);
var G__120518 = c__4556__auto___120516;
var G__120519 = cljs.core.count.call(null,c__4556__auto___120516);
var G__120520 = (0);
seq__120464_120505 = G__120517;
chunk__120465_120506 = G__120518;
count__120466_120507 = G__120519;
i__120467_120508 = G__120520;
continue;
} else {
var fld_120521 = cljs.core.first.call(null,seq__120464_120515__$1);
cljs.compiler.emitln.call(null,"this.",fld_120521," = ",fld_120521,";");


var G__120522 = cljs.core.next.call(null,seq__120464_120515__$1);
var G__120523 = null;
var G__120524 = (0);
var G__120525 = (0);
seq__120464_120505 = G__120522;
chunk__120465_120506 = G__120523;
count__120466_120507 = G__120524;
i__120467_120508 = G__120525;
continue;
}
} else {
}
}
break;
}

var seq__120468_120526 = cljs.core.seq.call(null,pmasks);
var chunk__120469_120527 = null;
var count__120470_120528 = (0);
var i__120471_120529 = (0);
while(true){
if((i__120471_120529 < count__120470_120528)){
var vec__120478_120530 = cljs.core._nth.call(null,chunk__120469_120527,i__120471_120529);
var pno_120531 = cljs.core.nth.call(null,vec__120478_120530,(0),null);
var pmask_120532 = cljs.core.nth.call(null,vec__120478_120530,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_120531,"$ = ",pmask_120532,";");


var G__120533 = seq__120468_120526;
var G__120534 = chunk__120469_120527;
var G__120535 = count__120470_120528;
var G__120536 = (i__120471_120529 + (1));
seq__120468_120526 = G__120533;
chunk__120469_120527 = G__120534;
count__120470_120528 = G__120535;
i__120471_120529 = G__120536;
continue;
} else {
var temp__5735__auto___120537 = cljs.core.seq.call(null,seq__120468_120526);
if(temp__5735__auto___120537){
var seq__120468_120538__$1 = temp__5735__auto___120537;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__120468_120538__$1)){
var c__4556__auto___120539 = cljs.core.chunk_first.call(null,seq__120468_120538__$1);
var G__120540 = cljs.core.chunk_rest.call(null,seq__120468_120538__$1);
var G__120541 = c__4556__auto___120539;
var G__120542 = cljs.core.count.call(null,c__4556__auto___120539);
var G__120543 = (0);
seq__120468_120526 = G__120540;
chunk__120469_120527 = G__120541;
count__120470_120528 = G__120542;
i__120471_120529 = G__120543;
continue;
} else {
var vec__120481_120544 = cljs.core.first.call(null,seq__120468_120538__$1);
var pno_120545 = cljs.core.nth.call(null,vec__120481_120544,(0),null);
var pmask_120546 = cljs.core.nth.call(null,vec__120481_120544,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_120545,"$ = ",pmask_120546,";");


var G__120547 = cljs.core.next.call(null,seq__120468_120538__$1);
var G__120548 = null;
var G__120549 = (0);
var G__120550 = (0);
seq__120468_120526 = G__120547;
chunk__120469_120527 = G__120548;
count__120470_120528 = G__120549;
i__120471_120529 = G__120550;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"});");

return cljs.compiler.emit.call(null,body);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"defrecord","defrecord",-1367493418),(function (p__120551){
var map__120552 = p__120551;
var map__120552__$1 = (((((!((map__120552 == null))))?(((((map__120552.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__120552.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__120552):map__120552);
var t = cljs.core.get.call(null,map__120552__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.call(null,map__120552__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.call(null,map__120552__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.call(null,map__120552__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.call(null,map__120552__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.concat.call(null,cljs.core.map.call(null,cljs.compiler.munge,fields),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"__meta","__meta",-946752628,null),new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null));
cljs.compiler.emitln.call(null,"");

cljs.compiler.emitln.call(null,"/**");

cljs.compiler.emitln.call(null,"* @constructor");

var seq__120554_120578 = cljs.core.seq.call(null,protocols);
var chunk__120555_120579 = null;
var count__120556_120580 = (0);
var i__120557_120581 = (0);
while(true){
if((i__120557_120581 < count__120556_120580)){
var protocol_120582 = cljs.core._nth.call(null,chunk__120555_120579,i__120557_120581);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_120582)),"}");


var G__120583 = seq__120554_120578;
var G__120584 = chunk__120555_120579;
var G__120585 = count__120556_120580;
var G__120586 = (i__120557_120581 + (1));
seq__120554_120578 = G__120583;
chunk__120555_120579 = G__120584;
count__120556_120580 = G__120585;
i__120557_120581 = G__120586;
continue;
} else {
var temp__5735__auto___120587 = cljs.core.seq.call(null,seq__120554_120578);
if(temp__5735__auto___120587){
var seq__120554_120588__$1 = temp__5735__auto___120587;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__120554_120588__$1)){
var c__4556__auto___120589 = cljs.core.chunk_first.call(null,seq__120554_120588__$1);
var G__120590 = cljs.core.chunk_rest.call(null,seq__120554_120588__$1);
var G__120591 = c__4556__auto___120589;
var G__120592 = cljs.core.count.call(null,c__4556__auto___120589);
var G__120593 = (0);
seq__120554_120578 = G__120590;
chunk__120555_120579 = G__120591;
count__120556_120580 = G__120592;
i__120557_120581 = G__120593;
continue;
} else {
var protocol_120594 = cljs.core.first.call(null,seq__120554_120588__$1);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_120594)),"}");


var G__120595 = cljs.core.next.call(null,seq__120554_120588__$1);
var G__120596 = null;
var G__120597 = (0);
var G__120598 = (0);
seq__120554_120578 = G__120595;
chunk__120555_120579 = G__120596;
count__120556_120580 = G__120597;
i__120557_120581 = G__120598;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"*/");

cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,t)," = (function (",cljs.compiler.comma_sep.call(null,fields__$1),"){");

var seq__120558_120599 = cljs.core.seq.call(null,fields__$1);
var chunk__120559_120600 = null;
var count__120560_120601 = (0);
var i__120561_120602 = (0);
while(true){
if((i__120561_120602 < count__120560_120601)){
var fld_120603 = cljs.core._nth.call(null,chunk__120559_120600,i__120561_120602);
cljs.compiler.emitln.call(null,"this.",fld_120603," = ",fld_120603,";");


var G__120604 = seq__120558_120599;
var G__120605 = chunk__120559_120600;
var G__120606 = count__120560_120601;
var G__120607 = (i__120561_120602 + (1));
seq__120558_120599 = G__120604;
chunk__120559_120600 = G__120605;
count__120560_120601 = G__120606;
i__120561_120602 = G__120607;
continue;
} else {
var temp__5735__auto___120608 = cljs.core.seq.call(null,seq__120558_120599);
if(temp__5735__auto___120608){
var seq__120558_120609__$1 = temp__5735__auto___120608;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__120558_120609__$1)){
var c__4556__auto___120610 = cljs.core.chunk_first.call(null,seq__120558_120609__$1);
var G__120611 = cljs.core.chunk_rest.call(null,seq__120558_120609__$1);
var G__120612 = c__4556__auto___120610;
var G__120613 = cljs.core.count.call(null,c__4556__auto___120610);
var G__120614 = (0);
seq__120558_120599 = G__120611;
chunk__120559_120600 = G__120612;
count__120560_120601 = G__120613;
i__120561_120602 = G__120614;
continue;
} else {
var fld_120615 = cljs.core.first.call(null,seq__120558_120609__$1);
cljs.compiler.emitln.call(null,"this.",fld_120615," = ",fld_120615,";");


var G__120616 = cljs.core.next.call(null,seq__120558_120609__$1);
var G__120617 = null;
var G__120618 = (0);
var G__120619 = (0);
seq__120558_120599 = G__120616;
chunk__120559_120600 = G__120617;
count__120560_120601 = G__120618;
i__120561_120602 = G__120619;
continue;
}
} else {
}
}
break;
}

var seq__120562_120620 = cljs.core.seq.call(null,pmasks);
var chunk__120563_120621 = null;
var count__120564_120622 = (0);
var i__120565_120623 = (0);
while(true){
if((i__120565_120623 < count__120564_120622)){
var vec__120572_120624 = cljs.core._nth.call(null,chunk__120563_120621,i__120565_120623);
var pno_120625 = cljs.core.nth.call(null,vec__120572_120624,(0),null);
var pmask_120626 = cljs.core.nth.call(null,vec__120572_120624,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_120625,"$ = ",pmask_120626,";");


var G__120627 = seq__120562_120620;
var G__120628 = chunk__120563_120621;
var G__120629 = count__120564_120622;
var G__120630 = (i__120565_120623 + (1));
seq__120562_120620 = G__120627;
chunk__120563_120621 = G__120628;
count__120564_120622 = G__120629;
i__120565_120623 = G__120630;
continue;
} else {
var temp__5735__auto___120631 = cljs.core.seq.call(null,seq__120562_120620);
if(temp__5735__auto___120631){
var seq__120562_120632__$1 = temp__5735__auto___120631;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__120562_120632__$1)){
var c__4556__auto___120633 = cljs.core.chunk_first.call(null,seq__120562_120632__$1);
var G__120634 = cljs.core.chunk_rest.call(null,seq__120562_120632__$1);
var G__120635 = c__4556__auto___120633;
var G__120636 = cljs.core.count.call(null,c__4556__auto___120633);
var G__120637 = (0);
seq__120562_120620 = G__120634;
chunk__120563_120621 = G__120635;
count__120564_120622 = G__120636;
i__120565_120623 = G__120637;
continue;
} else {
var vec__120575_120638 = cljs.core.first.call(null,seq__120562_120632__$1);
var pno_120639 = cljs.core.nth.call(null,vec__120575_120638,(0),null);
var pmask_120640 = cljs.core.nth.call(null,vec__120575_120638,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_120639,"$ = ",pmask_120640,";");


var G__120641 = cljs.core.next.call(null,seq__120562_120632__$1);
var G__120642 = null;
var G__120643 = (0);
var G__120644 = (0);
seq__120562_120620 = G__120641;
chunk__120563_120621 = G__120642;
count__120564_120622 = G__120643;
i__120565_120623 = G__120644;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"});");

return cljs.compiler.emit.call(null,body);
}));
cljs.compiler.emit_dot = (function cljs$compiler$emit_dot(p__120645){
var map__120646 = p__120645;
var map__120646__$1 = (((((!((map__120646 == null))))?(((((map__120646.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__120646.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__120646):map__120646);
var target = cljs.core.get.call(null,map__120646__$1,new cljs.core.Keyword(null,"target","target",253001721));
var field = cljs.core.get.call(null,map__120646__$1,new cljs.core.Keyword(null,"field","field",-1302436500));
var method = cljs.core.get.call(null,map__120646__$1,new cljs.core.Keyword(null,"method","method",55703592));
var args = cljs.core.get.call(null,map__120646__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.call(null,map__120646__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__119443__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__119443__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(cljs.core.truth_(field)){
cljs.compiler.emits.call(null,target,".",cljs.compiler.munge.call(null,field,cljs.core.PersistentHashSet.EMPTY));
} else {
cljs.compiler.emits.call(null,target,".",cljs.compiler.munge.call(null,method,cljs.core.PersistentHashSet.EMPTY),"(",cljs.compiler.comma_sep.call(null,args),")");
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__119443__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"host-field","host-field",-72662140),(function (ast){
return cljs.compiler.emit_dot.call(null,ast);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"host-call","host-call",1059629755),(function (ast){
return cljs.compiler.emit_dot.call(null,ast);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"js","js",1768080579),(function (p__120648){
var map__120649 = p__120648;
var map__120649__$1 = (((((!((map__120649 == null))))?(((((map__120649.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__120649.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__120649):map__120649);
var op = cljs.core.get.call(null,map__120649__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var env = cljs.core.get.call(null,map__120649__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var code = cljs.core.get.call(null,map__120649__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var segs = cljs.core.get.call(null,map__120649__$1,new cljs.core.Keyword(null,"segs","segs",-1940299576));
var args = cljs.core.get.call(null,map__120649__$1,new cljs.core.Keyword(null,"args","args",1315556576));
if(cljs.core.truth_((function (){var and__4115__auto__ = code;
if(cljs.core.truth_(and__4115__auto__)){
return goog.string.startsWith(clojure.string.trim.call(null,code),"/*");
} else {
return and__4115__auto__;
}
})())){
return cljs.compiler.emits.call(null,code);
} else {
var env__119443__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__119443__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(cljs.core.truth_(code)){
cljs.compiler.emits.call(null,code);
} else {
cljs.compiler.emits.call(null,cljs.core.interleave.call(null,cljs.core.concat.call(null,segs,cljs.core.repeat.call(null,null)),cljs.core.concat.call(null,args,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null))));
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__119443__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}
}));
cljs.compiler.emit_constants_table = (function cljs$compiler$emit_constants_table(table){
cljs.compiler.emitln.call(null,"goog.provide('",cljs.compiler.munge.call(null,cljs.analyzer.constants_ns_sym),"');");

cljs.compiler.emitln.call(null,"goog.require('cljs.core');");

var seq__120655 = cljs.core.seq.call(null,table);
var chunk__120656 = null;
var count__120657 = (0);
var i__120658 = (0);
while(true){
if((i__120658 < count__120657)){
var vec__120665 = cljs.core._nth.call(null,chunk__120656,i__120658);
var sym = cljs.core.nth.call(null,vec__120665,(0),null);
var value = cljs.core.nth.call(null,vec__120665,(1),null);
var ns_120671 = cljs.core.namespace.call(null,sym);
var name_120672 = cljs.core.name.call(null,sym);
cljs.compiler.emits.call(null,"cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword.call(null,sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol.call(null,sym);
} else {
throw cljs.core.ex_info.call(null,["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type.call(null,sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.call(null,";\n");


var G__120673 = seq__120655;
var G__120674 = chunk__120656;
var G__120675 = count__120657;
var G__120676 = (i__120658 + (1));
seq__120655 = G__120673;
chunk__120656 = G__120674;
count__120657 = G__120675;
i__120658 = G__120676;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__120655);
if(temp__5735__auto__){
var seq__120655__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__120655__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__120655__$1);
var G__120677 = cljs.core.chunk_rest.call(null,seq__120655__$1);
var G__120678 = c__4556__auto__;
var G__120679 = cljs.core.count.call(null,c__4556__auto__);
var G__120680 = (0);
seq__120655 = G__120677;
chunk__120656 = G__120678;
count__120657 = G__120679;
i__120658 = G__120680;
continue;
} else {
var vec__120668 = cljs.core.first.call(null,seq__120655__$1);
var sym = cljs.core.nth.call(null,vec__120668,(0),null);
var value = cljs.core.nth.call(null,vec__120668,(1),null);
var ns_120681 = cljs.core.namespace.call(null,sym);
var name_120682 = cljs.core.name.call(null,sym);
cljs.compiler.emits.call(null,"cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword.call(null,sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol.call(null,sym);
} else {
throw cljs.core.ex_info.call(null,["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type.call(null,sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.call(null,";\n");


var G__120683 = cljs.core.next.call(null,seq__120655__$1);
var G__120684 = null;
var G__120685 = (0);
var G__120686 = (0);
seq__120655 = G__120683;
chunk__120656 = G__120684;
count__120657 = G__120685;
i__120658 = G__120686;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_externs = (function cljs$compiler$emit_externs(var_args){
var G__120688 = arguments.length;
switch (G__120688) {
case 1:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1 = (function (externs){
return cljs.compiler.emit_externs.call(null,cljs.core.PersistentVector.EMPTY,externs,cljs.core.atom.call(null,cljs.core.PersistentHashSet.EMPTY),(cljs.core.truth_(cljs.env._STAR_compiler_STAR_)?cljs.analyzer.get_externs.call(null):null));
}));

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4 = (function (prefix,externs,top_level,known_externs){
var ks = cljs.core.seq.call(null,cljs.core.keys.call(null,externs));
while(true){
if(ks){
var k_120693 = cljs.core.first.call(null,ks);
var vec__120689_120694 = cljs.core.conj.call(null,prefix,k_120693);
var top_120695 = cljs.core.nth.call(null,vec__120689_120694,(0),null);
var prefix_SINGLEQUOTE__120696 = vec__120689_120694;
if(((cljs.core.not_EQ_.call(null,new cljs.core.Symbol(null,"prototype","prototype",519166522,null),k_120693)) && ((cljs.core.get_in.call(null,known_externs,prefix_SINGLEQUOTE__120696) == null)))){
if((!(((cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,top_level),top_120695)) || (cljs.core.contains_QMARK_.call(null,known_externs,top_120695)))))){
cljs.compiler.emitln.call(null,"var ",clojure.string.join.call(null,".",cljs.core.map.call(null,cljs.compiler.munge,prefix_SINGLEQUOTE__120696)),";");

cljs.core.swap_BANG_.call(null,top_level,cljs.core.conj,top_120695);
} else {
cljs.compiler.emitln.call(null,clojure.string.join.call(null,".",cljs.core.map.call(null,cljs.compiler.munge,prefix_SINGLEQUOTE__120696)),";");
}
} else {
}

var m_120697 = cljs.core.get.call(null,externs,k_120693);
if(cljs.core.empty_QMARK_.call(null,m_120697)){
} else {
cljs.compiler.emit_externs.call(null,prefix_SINGLEQUOTE__120696,m_120697,top_level,known_externs);
}

var G__120698 = cljs.core.next.call(null,ks);
ks = G__120698;
continue;
} else {
return null;
}
break;
}
}));

(cljs.compiler.emit_externs.cljs$lang$maxFixedArity = 4);

