// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true}
goog.provide('tailrecursion.priority_map');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.core');
goog.require('cljs.reader');

/**
* @constructor
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISorted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
tailrecursion.priority_map.PersistentPriorityMap = (function (priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash){
this.priority__GT_set_of_items = priority__GT_set_of_items;
this.item__GT_priority = item__GT_priority;
this.meta = meta;
this.keyfn = keyfn;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2565220111;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,item,not_found){
var self__ = this;
var coll__$1 = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,not_found);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var self__ = this;
var coll__$1 = this;
var pr_pair = (function (keyval){
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,""," ","",opts,keyval);
});
return cljs.core.pr_sequential_writer(writer,pr_pair,"#tailrecursion.priority-map {",", ","}",opts,coll__$1);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.meta;
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.count(self__.item__GT_priority);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IStack$_peek$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((cljs.core.count(self__.item__GT_priority) === (0))){
return null;
} else {
var f = cljs.core.first(self__.priority__GT_set_of_items);
var item = cljs.core.first(cljs.core.val(f));
if(cljs.core.truth_(self__.keyfn)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,cljs.core.key(f)], null);
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IStack$_pop$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((cljs.core.count(self__.item__GT_priority) === (0))){
throw (new Error("Can't pop empty priority map"));
} else {
var f = cljs.core.first(self__.priority__GT_set_of_items);
var item_set = cljs.core.val(f);
var item = cljs.core.first(item_set);
var priority_key = cljs.core.key(f);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,priority_key),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.disj.cljs$core$IFn$_invoke$arity$2(item_set,item)),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq((function (){var iter__4529__auto__ = (function tailrecursion$priority_map$iter__117403(s__117404){
return (new cljs.core.LazySeq(null,(function (){
var s__117404__$1 = s__117404;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__117404__$1);
if(temp__5735__auto__){
var xs__6292__auto__ = temp__5735__auto__;
var vec__117409 = cljs.core.first(xs__6292__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__117409,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__117409,(1),null);
var iterys__4525__auto__ = ((function (s__117404__$1,vec__117409,priority,item_set,xs__6292__auto__,temp__5735__auto__,coll__$1){
return (function tailrecursion$priority_map$iter__117403_$_iter__117405(s__117406){
return (new cljs.core.LazySeq(null,((function (s__117404__$1,vec__117409,priority,item_set,xs__6292__auto__,temp__5735__auto__,coll__$1){
return (function (){
var s__117406__$1 = s__117406;
while(true){
var temp__5735__auto____$1 = cljs.core.seq(s__117406__$1);
if(temp__5735__auto____$1){
var s__117406__$2 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__117406__$2)){
var c__4527__auto__ = cljs.core.chunk_first(s__117406__$2);
var size__4528__auto__ = cljs.core.count(c__4527__auto__);
var b__117408 = cljs.core.chunk_buffer(size__4528__auto__);
if((function (){var i__117407 = (0);
while(true){
if((i__117407 < size__4528__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4527__auto__,i__117407);
cljs.core.chunk_append(b__117408,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null));

var G__117461 = (i__117407 + (1));
i__117407 = G__117461;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__117408),tailrecursion$priority_map$iter__117403_$_iter__117405(cljs.core.chunk_rest(s__117406__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__117408),null);
}
} else {
var item = cljs.core.first(s__117406__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null),tailrecursion$priority_map$iter__117403_$_iter__117405(cljs.core.rest(s__117406__$2)));
}
} else {
return null;
}
break;
}
});})(s__117404__$1,vec__117409,priority,item_set,xs__6292__auto__,temp__5735__auto__,coll__$1))
,null,null));
});})(s__117404__$1,vec__117409,priority,item_set,xs__6292__auto__,temp__5735__auto__,coll__$1))
;
var fs__4526__auto__ = cljs.core.seq(iterys__4525__auto__(item_set));
if(fs__4526__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4526__auto__,tailrecursion$priority_map$iter__117403(cljs.core.rest(s__117404__$1)));
} else {
var G__117462 = cljs.core.rest(s__117404__$1);
s__117404__$1 = G__117462;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__(cljs.core.rseq(self__.priority__GT_set_of_items));
})());
} else {
return cljs.core.seq((function (){var iter__4529__auto__ = (function tailrecursion$priority_map$iter__117412(s__117413){
return (new cljs.core.LazySeq(null,(function (){
var s__117413__$1 = s__117413;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__117413__$1);
if(temp__5735__auto__){
var xs__6292__auto__ = temp__5735__auto__;
var vec__117418 = cljs.core.first(xs__6292__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__117418,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__117418,(1),null);
var iterys__4525__auto__ = ((function (s__117413__$1,vec__117418,priority,item_set,xs__6292__auto__,temp__5735__auto__,coll__$1){
return (function tailrecursion$priority_map$iter__117412_$_iter__117414(s__117415){
return (new cljs.core.LazySeq(null,((function (s__117413__$1,vec__117418,priority,item_set,xs__6292__auto__,temp__5735__auto__,coll__$1){
return (function (){
var s__117415__$1 = s__117415;
while(true){
var temp__5735__auto____$1 = cljs.core.seq(s__117415__$1);
if(temp__5735__auto____$1){
var s__117415__$2 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__117415__$2)){
var c__4527__auto__ = cljs.core.chunk_first(s__117415__$2);
var size__4528__auto__ = cljs.core.count(c__4527__auto__);
var b__117417 = cljs.core.chunk_buffer(size__4528__auto__);
if((function (){var i__117416 = (0);
while(true){
if((i__117416 < size__4528__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4527__auto__,i__117416);
cljs.core.chunk_append(b__117417,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__117463 = (i__117416 + (1));
i__117416 = G__117463;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__117417),tailrecursion$priority_map$iter__117412_$_iter__117414(cljs.core.chunk_rest(s__117415__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__117417),null);
}
} else {
var item = cljs.core.first(s__117415__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__117412_$_iter__117414(cljs.core.rest(s__117415__$2)));
}
} else {
return null;
}
break;
}
});})(s__117413__$1,vec__117418,priority,item_set,xs__6292__auto__,temp__5735__auto__,coll__$1))
,null,null));
});})(s__117413__$1,vec__117418,priority,item_set,xs__6292__auto__,temp__5735__auto__,coll__$1))
;
var fs__4526__auto__ = cljs.core.seq(iterys__4525__auto__(item_set));
if(fs__4526__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4526__auto__,tailrecursion$priority_map$iter__117412(cljs.core.rest(s__117413__$1)));
} else {
var G__117464 = cljs.core.rest(s__117413__$1);
s__117413__$1 = G__117464;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__(cljs.core.rseq(self__.priority__GT_set_of_items));
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = cljs.core.hash_unordered_coll(this$__$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var self__ = this;
var this$__$1 = this;
return cljs.core._equiv(self__.item__GT_priority,other);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.with_meta(tailrecursion.priority_map.PersistentPriorityMap.EMPTY,self__.meta);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
var priority = (function (){var G__117421 = item;
var G__117422 = cljs.core.cst$kw$tailrecursion$priority_DASH_map_SLASH_not_DASH_found;
return (self__.item__GT_priority.cljs$core$IFn$_invoke$arity$2 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$2(G__117421,G__117422) : self__.item__GT_priority.call(null,G__117421,G__117422));
})();
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(priority,cljs.core.cst$kw$tailrecursion$priority_DASH_map_SLASH_not_DASH_found)){
return this$__$1;
} else {
var priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(priority) : self__.keyfn.call(null,priority));
var item_set = (self__.priority__GT_set_of_items.cljs$core$IFn$_invoke$arity$1 ? self__.priority__GT_set_of_items.cljs$core$IFn$_invoke$arity$1(priority_key) : self__.priority__GT_set_of_items.call(null,priority_key));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,priority_key),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.disj.cljs$core$IFn$_invoke$arity$2(item_set,item)),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this$,item,priority){
var self__ = this;
var this$__$1 = this;
var temp__5733__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,null);
if(cljs.core.truth_(temp__5733__auto__)){
var current_priority = temp__5733__auto__;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(current_priority,priority)){
return this$__$1;
} else {
var priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(priority) : self__.keyfn.call(null,priority));
var current_priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(current_priority) : self__.keyfn.call(null,current_priority));
var item_set = cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,current_priority_key);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,current_priority_key),priority_key,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(self__.priority__GT_set_of_items,current_priority_key,cljs.core.disj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,current_priority_key),item),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([priority_key,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)], 0)),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
}
}
} else {
var priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(priority) : self__.keyfn.call(null,priority));
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
return cljs.core.contains_QMARK_(self__.item__GT_priority,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq((function (){var iter__4529__auto__ = (function tailrecursion$priority_map$iter__117423(s__117424){
return (new cljs.core.LazySeq(null,(function (){
var s__117424__$1 = s__117424;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__117424__$1);
if(temp__5735__auto__){
var xs__6292__auto__ = temp__5735__auto__;
var vec__117429 = cljs.core.first(xs__6292__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__117429,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__117429,(1),null);
var iterys__4525__auto__ = ((function (s__117424__$1,vec__117429,priority,item_set,xs__6292__auto__,temp__5735__auto__,this$__$1){
return (function tailrecursion$priority_map$iter__117423_$_iter__117425(s__117426){
return (new cljs.core.LazySeq(null,((function (s__117424__$1,vec__117429,priority,item_set,xs__6292__auto__,temp__5735__auto__,this$__$1){
return (function (){
var s__117426__$1 = s__117426;
while(true){
var temp__5735__auto____$1 = cljs.core.seq(s__117426__$1);
if(temp__5735__auto____$1){
var s__117426__$2 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__117426__$2)){
var c__4527__auto__ = cljs.core.chunk_first(s__117426__$2);
var size__4528__auto__ = cljs.core.count(c__4527__auto__);
var b__117428 = cljs.core.chunk_buffer(size__4528__auto__);
if((function (){var i__117427 = (0);
while(true){
if((i__117427 < size__4528__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4527__auto__,i__117427);
cljs.core.chunk_append(b__117428,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null));

var G__117465 = (i__117427 + (1));
i__117427 = G__117465;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__117428),tailrecursion$priority_map$iter__117423_$_iter__117425(cljs.core.chunk_rest(s__117426__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__117428),null);
}
} else {
var item = cljs.core.first(s__117426__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null),tailrecursion$priority_map$iter__117423_$_iter__117425(cljs.core.rest(s__117426__$2)));
}
} else {
return null;
}
break;
}
});})(s__117424__$1,vec__117429,priority,item_set,xs__6292__auto__,temp__5735__auto__,this$__$1))
,null,null));
});})(s__117424__$1,vec__117429,priority,item_set,xs__6292__auto__,temp__5735__auto__,this$__$1))
;
var fs__4526__auto__ = cljs.core.seq(iterys__4525__auto__(item_set));
if(fs__4526__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4526__auto__,tailrecursion$priority_map$iter__117423(cljs.core.rest(s__117424__$1)));
} else {
var G__117466 = cljs.core.rest(s__117424__$1);
s__117424__$1 = G__117466;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__(self__.priority__GT_set_of_items);
})());
} else {
return cljs.core.seq((function (){var iter__4529__auto__ = (function tailrecursion$priority_map$iter__117432(s__117433){
return (new cljs.core.LazySeq(null,(function (){
var s__117433__$1 = s__117433;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__117433__$1);
if(temp__5735__auto__){
var xs__6292__auto__ = temp__5735__auto__;
var vec__117438 = cljs.core.first(xs__6292__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__117438,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__117438,(1),null);
var iterys__4525__auto__ = ((function (s__117433__$1,vec__117438,priority,item_set,xs__6292__auto__,temp__5735__auto__,this$__$1){
return (function tailrecursion$priority_map$iter__117432_$_iter__117434(s__117435){
return (new cljs.core.LazySeq(null,((function (s__117433__$1,vec__117438,priority,item_set,xs__6292__auto__,temp__5735__auto__,this$__$1){
return (function (){
var s__117435__$1 = s__117435;
while(true){
var temp__5735__auto____$1 = cljs.core.seq(s__117435__$1);
if(temp__5735__auto____$1){
var s__117435__$2 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__117435__$2)){
var c__4527__auto__ = cljs.core.chunk_first(s__117435__$2);
var size__4528__auto__ = cljs.core.count(c__4527__auto__);
var b__117437 = cljs.core.chunk_buffer(size__4528__auto__);
if((function (){var i__117436 = (0);
while(true){
if((i__117436 < size__4528__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4527__auto__,i__117436);
cljs.core.chunk_append(b__117437,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__117467 = (i__117436 + (1));
i__117436 = G__117467;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__117437),tailrecursion$priority_map$iter__117432_$_iter__117434(cljs.core.chunk_rest(s__117435__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__117437),null);
}
} else {
var item = cljs.core.first(s__117435__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__117432_$_iter__117434(cljs.core.rest(s__117435__$2)));
}
} else {
return null;
}
break;
}
});})(s__117433__$1,vec__117438,priority,item_set,xs__6292__auto__,temp__5735__auto__,this$__$1))
,null,null));
});})(s__117433__$1,vec__117438,priority,item_set,xs__6292__auto__,temp__5735__auto__,this$__$1))
;
var fs__4526__auto__ = cljs.core.seq(iterys__4525__auto__(item_set));
if(fs__4526__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4526__auto__,tailrecursion$priority_map$iter__117432(cljs.core.rest(s__117433__$1)));
} else {
var G__117468 = cljs.core.rest(s__117433__$1);
s__117433__$1 = G__117468;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__(self__.priority__GT_set_of_items);
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this$,meta__$1){
var self__ = this;
var this$__$1 = this;
return (new tailrecursion.priority_map.PersistentPriorityMap(self__.priority__GT_set_of_items,self__.item__GT_priority,meta__$1,self__.keyfn,self__.__hash));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,entry){
var self__ = this;
var this$__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return this$__$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this$__$1,entry);
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.call = (function() {
var G__117469 = null;
var G__117469__2 = (function (self__,item){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return this$.cljs$core$ILookup$_lookup$arity$2(null,item);
});
var G__117469__3 = (function (self__,item,not_found){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return this$.cljs$core$ILookup$_lookup$arity$3(null,item,not_found);
});
G__117469 = function(self__,item,not_found){
switch(arguments.length){
case 2:
return G__117469__2.call(this,self__,item);
case 3:
return G__117469__3.call(this,self__,item,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__117469.cljs$core$IFn$_invoke$arity$2 = G__117469__2;
G__117469.cljs$core$IFn$_invoke$arity$3 = G__117469__3;
return G__117469;
})()
);

(tailrecursion.priority_map.PersistentPriorityMap.prototype.apply = (function (self__,args117402){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args117402)));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (item){
var self__ = this;
var this$ = this;
return this$.cljs$core$ILookup$_lookup$arity$2(null,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (item,not_found){
var self__ = this;
var this$ = this;
return this$.cljs$core$ILookup$_lookup$arity$3(null,item,not_found);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (this$,ascending_QMARK_){
var self__ = this;
var this$__$1 = this;
var fexpr__117441 = (cljs.core.truth_(ascending_QMARK_)?cljs.core.seq:cljs.core.rseq);
return (fexpr__117441.cljs$core$IFn$_invoke$arity$1 ? fexpr__117441.cljs$core$IFn$_invoke$arity$1(this$__$1) : fexpr__117441.call(null,this$__$1));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (this$,k,ascending_QMARK_){
var self__ = this;
var this$__$1 = this;
var sets = (cljs.core.truth_(ascending_QMARK_)?cljs.core.subseq.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,cljs.core._GT__EQ_,k):cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,cljs.core._LT__EQ_,k));
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq((function (){var iter__4529__auto__ = (function tailrecursion$priority_map$iter__117442(s__117443){
return (new cljs.core.LazySeq(null,(function (){
var s__117443__$1 = s__117443;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__117443__$1);
if(temp__5735__auto__){
var xs__6292__auto__ = temp__5735__auto__;
var vec__117448 = cljs.core.first(xs__6292__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__117448,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__117448,(1),null);
var iterys__4525__auto__ = ((function (s__117443__$1,vec__117448,priority,item_set,xs__6292__auto__,temp__5735__auto__,sets,this$__$1){
return (function tailrecursion$priority_map$iter__117442_$_iter__117444(s__117445){
return (new cljs.core.LazySeq(null,((function (s__117443__$1,vec__117448,priority,item_set,xs__6292__auto__,temp__5735__auto__,sets,this$__$1){
return (function (){
var s__117445__$1 = s__117445;
while(true){
var temp__5735__auto____$1 = cljs.core.seq(s__117445__$1);
if(temp__5735__auto____$1){
var s__117445__$2 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__117445__$2)){
var c__4527__auto__ = cljs.core.chunk_first(s__117445__$2);
var size__4528__auto__ = cljs.core.count(c__4527__auto__);
var b__117447 = cljs.core.chunk_buffer(size__4528__auto__);
if((function (){var i__117446 = (0);
while(true){
if((i__117446 < size__4528__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4527__auto__,i__117446);
cljs.core.chunk_append(b__117447,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null));

var G__117470 = (i__117446 + (1));
i__117446 = G__117470;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__117447),tailrecursion$priority_map$iter__117442_$_iter__117444(cljs.core.chunk_rest(s__117445__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__117447),null);
}
} else {
var item = cljs.core.first(s__117445__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null),tailrecursion$priority_map$iter__117442_$_iter__117444(cljs.core.rest(s__117445__$2)));
}
} else {
return null;
}
break;
}
});})(s__117443__$1,vec__117448,priority,item_set,xs__6292__auto__,temp__5735__auto__,sets,this$__$1))
,null,null));
});})(s__117443__$1,vec__117448,priority,item_set,xs__6292__auto__,temp__5735__auto__,sets,this$__$1))
;
var fs__4526__auto__ = cljs.core.seq(iterys__4525__auto__(item_set));
if(fs__4526__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4526__auto__,tailrecursion$priority_map$iter__117442(cljs.core.rest(s__117443__$1)));
} else {
var G__117471 = cljs.core.rest(s__117443__$1);
s__117443__$1 = G__117471;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__(sets);
})());
} else {
return cljs.core.seq((function (){var iter__4529__auto__ = (function tailrecursion$priority_map$iter__117451(s__117452){
return (new cljs.core.LazySeq(null,(function (){
var s__117452__$1 = s__117452;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__117452__$1);
if(temp__5735__auto__){
var xs__6292__auto__ = temp__5735__auto__;
var vec__117457 = cljs.core.first(xs__6292__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__117457,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__117457,(1),null);
var iterys__4525__auto__ = ((function (s__117452__$1,vec__117457,priority,item_set,xs__6292__auto__,temp__5735__auto__,sets,this$__$1){
return (function tailrecursion$priority_map$iter__117451_$_iter__117453(s__117454){
return (new cljs.core.LazySeq(null,((function (s__117452__$1,vec__117457,priority,item_set,xs__6292__auto__,temp__5735__auto__,sets,this$__$1){
return (function (){
var s__117454__$1 = s__117454;
while(true){
var temp__5735__auto____$1 = cljs.core.seq(s__117454__$1);
if(temp__5735__auto____$1){
var s__117454__$2 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__117454__$2)){
var c__4527__auto__ = cljs.core.chunk_first(s__117454__$2);
var size__4528__auto__ = cljs.core.count(c__4527__auto__);
var b__117456 = cljs.core.chunk_buffer(size__4528__auto__);
if((function (){var i__117455 = (0);
while(true){
if((i__117455 < size__4528__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4527__auto__,i__117455);
cljs.core.chunk_append(b__117456,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__117472 = (i__117455 + (1));
i__117455 = G__117472;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__117456),tailrecursion$priority_map$iter__117451_$_iter__117453(cljs.core.chunk_rest(s__117454__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__117456),null);
}
} else {
var item = cljs.core.first(s__117454__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__117451_$_iter__117453(cljs.core.rest(s__117454__$2)));
}
} else {
return null;
}
break;
}
});})(s__117452__$1,vec__117457,priority,item_set,xs__6292__auto__,temp__5735__auto__,sets,this$__$1))
,null,null));
});})(s__117452__$1,vec__117457,priority,item_set,xs__6292__auto__,temp__5735__auto__,sets,this$__$1))
;
var fs__4526__auto__ = cljs.core.seq(iterys__4525__auto__(item_set));
if(fs__4526__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4526__auto__,tailrecursion$priority_map$iter__117451(cljs.core.rest(s__117452__$1)));
} else {
var G__117473 = cljs.core.rest(s__117452__$1);
s__117452__$1 = G__117473;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__(sets);
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (this$,entry){
var self__ = this;
var this$__$1 = this;
var G__117460 = cljs.core.val(entry);
return (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(G__117460) : self__.keyfn.call(null,G__117460));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.compare;
}));

(tailrecursion.priority_map.PersistentPriorityMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$priority_DASH__GT_set_DASH_of_DASH_items,cljs.core.cst$sym$item_DASH__GT_priority,cljs.core.cst$sym$meta,cljs.core.cst$sym$keyfn,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
}));

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$type = true);

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$ctorStr = "tailrecursion.priority-map/PersistentPriorityMap");

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"tailrecursion.priority-map/PersistentPriorityMap");
}));

/**
 * Positional factory function for tailrecursion.priority-map/PersistentPriorityMap.
 */
tailrecursion.priority_map.__GT_PersistentPriorityMap = (function tailrecursion$priority_map$__GT_PersistentPriorityMap(priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash){
return (new tailrecursion.priority_map.PersistentPriorityMap(priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash));
});

(tailrecursion.priority_map.PersistentPriorityMap.EMPTY = (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map(),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,cljs.core.identity,null)));
tailrecursion.priority_map.pm_empty_by = (function tailrecursion$priority_map$pm_empty_by(comparator){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map_by(comparator),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,cljs.core.identity,null));
});
tailrecursion.priority_map.pm_empty_keyfn = (function tailrecursion$priority_map$pm_empty_keyfn(var_args){
var G__117475 = arguments.length;
switch (G__117475) {
case 1:
return tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1 = (function (keyfn){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map(),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,keyfn,null));
}));

(tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2 = (function (keyfn,comparator){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map_by(comparator),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,keyfn,null));
}));

(tailrecursion.priority_map.pm_empty_keyfn.cljs$lang$maxFixedArity = 2);

tailrecursion.priority_map.read_priority_map = (function tailrecursion$priority_map$read_priority_map(elems){
if(cljs.core.map_QMARK_(elems)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(tailrecursion.priority_map.PersistentPriorityMap.EMPTY,elems);
} else {
throw Error("Priority map literal expects a map for its elements.");
}
});
cljs.reader.register_tag_parser_BANG_("tailrecursion.priority-map",tailrecursion.priority_map.read_priority_map);
/**
 * keyval => key val
 *   Returns a new priority map with supplied mappings.
 */
tailrecursion.priority_map.priority_map = (function tailrecursion$priority_map$priority_map(var_args){
var args__4742__auto__ = [];
var len__4736__auto___117478 = arguments.length;
var i__4737__auto___117479 = (0);
while(true){
if((i__4737__auto___117479 < len__4736__auto___117478)){
args__4742__auto__.push((arguments[i__4737__auto___117479]));

var G__117480 = (i__4737__auto___117479 + (1));
i__4737__auto___117479 = G__117480;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return tailrecursion.priority_map.priority_map.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(tailrecursion.priority_map.priority_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.PersistentPriorityMap.EMPTY;
while(true){
if(in$){
var G__117481 = cljs.core.nnext(in$);
var G__117482 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__117481;
out = G__117482;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(tailrecursion.priority_map.priority_map.cljs$lang$applyTo = (function (seq117477){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq117477));
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied comparator.
 */
tailrecursion.priority_map.priority_map_by = (function tailrecursion$priority_map$priority_map_by(var_args){
var args__4742__auto__ = [];
var len__4736__auto___117485 = arguments.length;
var i__4737__auto___117486 = (0);
while(true){
if((i__4737__auto___117486 < len__4736__auto___117485)){
args__4742__auto__.push((arguments[i__4737__auto___117486]));

var G__117487 = (i__4737__auto___117486 + (1));
i__4737__auto___117486 = G__117487;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return tailrecursion.priority_map.priority_map_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(tailrecursion.priority_map.priority_map_by.cljs$core$IFn$_invoke$arity$variadic = (function (comparator,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.pm_empty_by(comparator);
while(true){
if(in$){
var G__117488 = cljs.core.nnext(in$);
var G__117489 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__117488;
out = G__117489;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_by.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_by.cljs$lang$applyTo = (function (seq117483){
var G__117484 = cljs.core.first(seq117483);
var seq117483__$1 = cljs.core.next(seq117483);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__117484,seq117483__$1);
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied keyfn.
 */
tailrecursion.priority_map.priority_map_keyfn = (function tailrecursion$priority_map$priority_map_keyfn(var_args){
var args__4742__auto__ = [];
var len__4736__auto___117492 = arguments.length;
var i__4737__auto___117493 = (0);
while(true){
if((i__4737__auto___117493 < len__4736__auto___117492)){
args__4742__auto__.push((arguments[i__4737__auto___117493]));

var G__117494 = (i__4737__auto___117493 + (1));
i__4737__auto___117493 = G__117494;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return tailrecursion.priority_map.priority_map_keyfn.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(tailrecursion.priority_map.priority_map_keyfn.cljs$core$IFn$_invoke$arity$variadic = (function (keyfn,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1(keyfn);
while(true){
if(in$){
var G__117495 = cljs.core.nnext(in$);
var G__117496 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__117495;
out = G__117496;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_keyfn.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_keyfn.cljs$lang$applyTo = (function (seq117490){
var G__117491 = cljs.core.first(seq117490);
var seq117490__$1 = cljs.core.next(seq117490);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__117491,seq117490__$1);
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied keyfn and comparator.
 */
tailrecursion.priority_map.priority_map_keyfn_by = (function tailrecursion$priority_map$priority_map_keyfn_by(var_args){
var args__4742__auto__ = [];
var len__4736__auto___117500 = arguments.length;
var i__4737__auto___117501 = (0);
while(true){
if((i__4737__auto___117501 < len__4736__auto___117500)){
args__4742__auto__.push((arguments[i__4737__auto___117501]));

var G__117502 = (i__4737__auto___117501 + (1));
i__4737__auto___117501 = G__117502;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return tailrecursion.priority_map.priority_map_keyfn_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(tailrecursion.priority_map.priority_map_keyfn_by.cljs$core$IFn$_invoke$arity$variadic = (function (keyfn,comparator,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2(keyfn,comparator);
while(true){
if(in$){
var G__117503 = cljs.core.nnext(in$);
var G__117504 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__117503;
out = G__117504;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_keyfn_by.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_keyfn_by.cljs$lang$applyTo = (function (seq117497){
var G__117498 = cljs.core.first(seq117497);
var seq117497__$1 = cljs.core.next(seq117497);
var G__117499 = cljs.core.first(seq117497__$1);
var seq117497__$2 = cljs.core.next(seq117497__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__117498,G__117499,seq117497__$2);
}));

