// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true}
goog.provide('fluree.db.util.async');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.core.async');
fluree.db.util.async.throw_err = (function fluree$db$util$async$throw_err(e){
if((e instanceof Error)){
throw e;
} else {
}

return e;
});
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
fluree.db.util.async.throw_if_exception = (function fluree$db$util$async$throw_if_exception(x){
if((x instanceof Error)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),(function (){var or__4126__auto__ = cljs.core.ex_data(x);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
/**
 * Takes a sequence of single-value chans and returns the conjoined into collection.
 *   Realizes entire channel sequence first, and if an error value exists returns just the exception.
 */
fluree.db.util.async.merge_into_QMARK_ = (function fluree$db$util$async$merge_into_QMARK_(coll,chs){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_102912){
var state_val_102913 = (state_102912[(1)]);
if((state_val_102913 === (7))){
var inst_102889 = (state_102912[(7)]);
var state_102912__$1 = state_102912;
var statearr_102914_102930 = state_102912__$1;
(statearr_102914_102930[(2)] = inst_102889);

(statearr_102914_102930[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102913 === (1))){
var state_102912__$1 = state_102912;
var statearr_102915_102931 = state_102912__$1;
(statearr_102915_102931[(2)] = null);

(statearr_102915_102931[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102913 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_102912,(3),cljs.core.cst$kw$default,null,(2));
var inst_102885 = cljs.core.seq(chs);
var inst_102886 = cljs.core.first(inst_102885);
var inst_102887 = cljs.core.next(inst_102885);
var inst_102888 = chs;
var inst_102889 = coll;
var state_102912__$1 = (function (){var statearr_102916 = state_102912;
(statearr_102916[(8)] = inst_102886);

(statearr_102916[(7)] = inst_102889);

(statearr_102916[(9)] = inst_102888);

(statearr_102916[(10)] = inst_102887);

return statearr_102916;
})();
var statearr_102917_102932 = state_102912__$1;
(statearr_102917_102932[(2)] = null);

(statearr_102917_102932[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102913 === (6))){
var inst_102908 = (state_102912[(2)]);
var state_102912__$1 = state_102912;
var statearr_102918_102933 = state_102912__$1;
(statearr_102918_102933[(2)] = inst_102908);


cljs.core.async.impl.ioc_helpers.process_exception(state_102912__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_102913 === (3))){
var inst_102874 = (state_102912[(2)]);
var state_102912__$1 = state_102912;
var statearr_102919_102934 = state_102912__$1;
(statearr_102919_102934[(2)] = inst_102874);


cljs.core.async.impl.ioc_helpers.process_exception(state_102912__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_102913 === (2))){
var inst_102910 = (state_102912[(2)]);
var state_102912__$1 = state_102912;
return cljs.core.async.impl.ioc_helpers.return_chan(state_102912__$1,inst_102910);
} else {
if((state_val_102913 === (9))){
var inst_102906 = (state_102912[(2)]);
var state_102912__$1 = state_102912;
var statearr_102920_102935 = state_102912__$1;
(statearr_102920_102935[(2)] = inst_102906);

(statearr_102920_102935[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102913 === (5))){
var inst_102888 = (state_102912[(9)]);
var inst_102895 = (state_102912[(11)]);
var inst_102894 = cljs.core.seq(inst_102888);
var inst_102895__$1 = cljs.core.first(inst_102894);
var inst_102896 = cljs.core.next(inst_102894);
var inst_102897 = cljs.core.not(inst_102895__$1);
var state_102912__$1 = (function (){var statearr_102921 = state_102912;
(statearr_102921[(12)] = inst_102896);

(statearr_102921[(11)] = inst_102895__$1);

return statearr_102921;
})();
if(inst_102897){
var statearr_102922_102936 = state_102912__$1;
(statearr_102922_102936[(1)] = (7));

} else {
var statearr_102923_102937 = state_102912__$1;
(statearr_102923_102937[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_102913 === (10))){
var inst_102889 = (state_102912[(7)]);
var inst_102896 = (state_102912[(12)]);
var inst_102901 = (state_102912[(2)]);
var inst_102902 = fluree.db.util.async.throw_err(inst_102901);
var inst_102903 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_102889,inst_102902);
var inst_102888 = inst_102896;
var inst_102889__$1 = inst_102903;
var state_102912__$1 = (function (){var statearr_102924 = state_102912;
(statearr_102924[(7)] = inst_102889__$1);

(statearr_102924[(9)] = inst_102888);

return statearr_102924;
})();
var statearr_102925_102938 = state_102912__$1;
(statearr_102925_102938[(2)] = null);

(statearr_102925_102938[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102913 === (8))){
var inst_102895 = (state_102912[(11)]);
var state_102912__$1 = state_102912;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_102912__$1,(10),inst_102895);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$merge_into_QMARK__$_state_machine__100742__auto__ = null;
var fluree$db$util$async$merge_into_QMARK__$_state_machine__100742__auto____0 = (function (){
var statearr_102926 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_102926[(0)] = fluree$db$util$async$merge_into_QMARK__$_state_machine__100742__auto__);

(statearr_102926[(1)] = (1));

return statearr_102926;
});
var fluree$db$util$async$merge_into_QMARK__$_state_machine__100742__auto____1 = (function (state_102912){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_102912);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e102927){if((e102927 instanceof Object)){
var ex__100745__auto__ = e102927;
var statearr_102928_102939 = state_102912;
(statearr_102928_102939[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_102912);

return cljs.core.cst$kw$recur;
} else {
throw e102927;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__102940 = state_102912;
state_102912 = G__102940;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$util$async$merge_into_QMARK__$_state_machine__100742__auto__ = function(state_102912){
switch(arguments.length){
case 0:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__100742__auto____1.call(this,state_102912);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$merge_into_QMARK__$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$merge_into_QMARK__$_state_machine__100742__auto____0;
fluree$db$util$async$merge_into_QMARK__$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$merge_into_QMARK__$_state_machine__100742__auto____1;
return fluree$db$util$async$merge_into_QMARK__$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_102929 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_102929[(6)] = c__100848__auto__);

return statearr_102929;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
/**
 * Like async/into, but checks each item for an error response and returns exception
 *   onto the response channel insted of results if thee is one.
 */
fluree.db.util.async.into_QMARK_ = (function fluree$db$util$async$into_QMARK_(coll,chan){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_102962){
var state_val_102963 = (state_102962[(1)]);
if((state_val_102963 === (7))){
var inst_102949 = (state_102962[(7)]);
var inst_102948 = (state_102962[(2)]);
var inst_102949__$1 = fluree.db.util.async.throw_err(inst_102948);
var inst_102950 = (inst_102949__$1 == null);
var state_102962__$1 = (function (){var statearr_102964 = state_102962;
(statearr_102964[(7)] = inst_102949__$1);

return statearr_102964;
})();
if(cljs.core.truth_(inst_102950)){
var statearr_102965_102980 = state_102962__$1;
(statearr_102965_102980[(1)] = (8));

} else {
var statearr_102966_102981 = state_102962__$1;
(statearr_102966_102981[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_102963 === (1))){
var state_102962__$1 = state_102962;
var statearr_102967_102982 = state_102962__$1;
(statearr_102967_102982[(2)] = null);

(statearr_102967_102982[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102963 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_102962,(3),cljs.core.cst$kw$default,null,(2));
var inst_102945 = coll;
var state_102962__$1 = (function (){var statearr_102968 = state_102962;
(statearr_102968[(8)] = inst_102945);

return statearr_102968;
})();
var statearr_102969_102983 = state_102962__$1;
(statearr_102969_102983[(2)] = null);

(statearr_102969_102983[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102963 === (6))){
var inst_102958 = (state_102962[(2)]);
var state_102962__$1 = state_102962;
var statearr_102970_102984 = state_102962__$1;
(statearr_102970_102984[(2)] = inst_102958);


cljs.core.async.impl.ioc_helpers.process_exception(state_102962__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_102963 === (3))){
var inst_102941 = (state_102962[(2)]);
var state_102962__$1 = state_102962;
var statearr_102971_102985 = state_102962__$1;
(statearr_102971_102985[(2)] = inst_102941);


cljs.core.async.impl.ioc_helpers.process_exception(state_102962__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_102963 === (2))){
var inst_102960 = (state_102962[(2)]);
var state_102962__$1 = state_102962;
return cljs.core.async.impl.ioc_helpers.return_chan(state_102962__$1,inst_102960);
} else {
if((state_val_102963 === (9))){
var inst_102945 = (state_102962[(8)]);
var inst_102949 = (state_102962[(7)]);
var inst_102953 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_102945,inst_102949);
var inst_102945__$1 = inst_102953;
var state_102962__$1 = (function (){var statearr_102972 = state_102962;
(statearr_102972[(8)] = inst_102945__$1);

return statearr_102972;
})();
var statearr_102973_102986 = state_102962__$1;
(statearr_102973_102986[(2)] = null);

(statearr_102973_102986[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102963 === (5))){
var state_102962__$1 = state_102962;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_102962__$1,(7),chan);
} else {
if((state_val_102963 === (10))){
var inst_102956 = (state_102962[(2)]);
var state_102962__$1 = state_102962;
var statearr_102974_102987 = state_102962__$1;
(statearr_102974_102987[(2)] = inst_102956);

(statearr_102974_102987[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102963 === (8))){
var inst_102945 = (state_102962[(8)]);
var state_102962__$1 = state_102962;
var statearr_102975_102988 = state_102962__$1;
(statearr_102975_102988[(2)] = inst_102945);

(statearr_102975_102988[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$into_QMARK__$_state_machine__100742__auto__ = null;
var fluree$db$util$async$into_QMARK__$_state_machine__100742__auto____0 = (function (){
var statearr_102976 = [null,null,null,null,null,null,null,null,null];
(statearr_102976[(0)] = fluree$db$util$async$into_QMARK__$_state_machine__100742__auto__);

(statearr_102976[(1)] = (1));

return statearr_102976;
});
var fluree$db$util$async$into_QMARK__$_state_machine__100742__auto____1 = (function (state_102962){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_102962);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e102977){if((e102977 instanceof Object)){
var ex__100745__auto__ = e102977;
var statearr_102978_102989 = state_102962;
(statearr_102978_102989[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_102962);

return cljs.core.cst$kw$recur;
} else {
throw e102977;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__102990 = state_102962;
state_102962 = G__102990;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$util$async$into_QMARK__$_state_machine__100742__auto__ = function(state_102962){
switch(arguments.length){
case 0:
return fluree$db$util$async$into_QMARK__$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$util$async$into_QMARK__$_state_machine__100742__auto____1.call(this,state_102962);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$into_QMARK__$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$into_QMARK__$_state_machine__100742__auto____0;
fluree$db$util$async$into_QMARK__$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$into_QMARK__$_state_machine__100742__auto____1;
return fluree$db$util$async$into_QMARK__$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_102979 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_102979[(6)] = c__100848__auto__);

return statearr_102979;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
/**
 * Returns true if core async channel.
 */
fluree.db.util.async.channel_QMARK_ = (function fluree$db$util$async$channel_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$Channel$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
}
});
