// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true}
goog.provide('fluree.db.time_travel');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.range');
goog.require('clojure.string');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
/**
 * Given a duration, returns a ISO-8601 formatted time string of now minus duration
 */
fluree.db.time_travel.duration_parse = (function fluree$db$time_travel$duration_parse(time_str){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Duration timeframes not yet supported in javascript.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_platform_DASH_support], null));
});
fluree.db.time_travel.time_to_t = (function fluree$db$time_travel$time_to_t(db,time_str){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_108869){
var state_val_108870 = (state_108869[(1)]);
if((state_val_108870 === (7))){
var inst_108822 = (state_108869[(7)]);
var inst_108820 = (state_108869[(2)]);
var inst_108822__$1 = fluree.db.dbproto._rootdb(db);
var inst_108823 = (inst_108822__$1 == null);
var state_108869__$1 = (function (){var statearr_108871 = state_108869;
(statearr_108871[(7)] = inst_108822__$1);

(statearr_108871[(8)] = inst_108820);

return statearr_108871;
})();
if(cljs.core.truth_(inst_108823)){
var statearr_108872_108906 = state_108869__$1;
(statearr_108872_108906[(1)] = (8));

} else {
var statearr_108873_108907 = state_108869__$1;
(statearr_108873_108907[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108870 === (20))){
var inst_108865 = (state_108869[(2)]);
var state_108869__$1 = state_108869;
var statearr_108874_108908 = state_108869__$1;
(statearr_108874_108908[(2)] = inst_108865);


cljs.core.async.impl.ioc_helpers.process_exception(state_108869__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_108870 === (1))){
var state_108869__$1 = state_108869;
var statearr_108875_108909 = state_108869__$1;
(statearr_108875_108909[(2)] = null);

(statearr_108875_108909[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108870 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_108869,(3),Error,null,(2));
var inst_108815 = typeof time_str === 'string';
var state_108869__$1 = state_108869;
if(cljs.core.truth_(inst_108815)){
var statearr_108876_108910 = state_108869__$1;
(statearr_108876_108910[(1)] = (5));

} else {
var statearr_108877_108911 = state_108869__$1;
(statearr_108877_108911[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108870 === (15))){
var inst_108820 = (state_108869[(8)]);
var inst_108845 = ["There is no data as of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_108820)].join('');
var inst_108846 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_108847 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_block];
var inst_108848 = cljs.core.PersistentHashMap.fromArrays(inst_108846,inst_108847);
var inst_108849 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_108845,inst_108848);
var inst_108850 = (function(){throw inst_108849})();
var state_108869__$1 = state_108869;
var statearr_108878_108912 = state_108869__$1;
(statearr_108878_108912[(2)] = inst_108850);

(statearr_108878_108912[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108870 === (21))){
var inst_108855 = (state_108869[(9)]);
var state_108869__$1 = state_108869;
var statearr_108879_108913 = state_108869__$1;
(statearr_108879_108913[(2)] = inst_108855);

(statearr_108879_108913[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108870 === (13))){
var inst_108842 = (state_108869[(10)]);
var inst_108842__$1 = (state_108869[(2)]);
var inst_108843 = cljs.core.empty_QMARK_(inst_108842__$1);
var state_108869__$1 = (function (){var statearr_108880 = state_108869;
(statearr_108880[(10)] = inst_108842__$1);

return statearr_108880;
})();
if(inst_108843){
var statearr_108881_108914 = state_108869__$1;
(statearr_108881_108914[(1)] = (15));

} else {
var statearr_108882_108915 = state_108869__$1;
(statearr_108882_108915[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108870 === (22))){
var inst_108861 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var state_108869__$1 = state_108869;
var statearr_108883_108916 = state_108869__$1;
(statearr_108883_108916[(2)] = inst_108861);

(statearr_108883_108916[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108870 === (6))){
var state_108869__$1 = state_108869;
var statearr_108884_108917 = state_108869__$1;
(statearr_108884_108917[(2)] = time_str);

(statearr_108884_108917[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108870 === (17))){
var inst_108820 = (state_108869[(8)]);
var inst_108856 = (state_108869[(11)]);
var inst_108842 = (state_108869[(10)]);
var inst_108855 = (state_108869[(9)]);
var inst_108853 = (state_108869[(2)]);
var inst_108854 = (function (){var epoch_as_of = inst_108820;
var ts = inst_108842;
var _ = inst_108853;
return (function (p1__108810_SHARP_){
return p1__108810_SHARP_.s;
});
})();
var inst_108855__$1 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.min_key,inst_108854,inst_108842);
var inst_108856__$1 = inst_108855__$1.s;
var state_108869__$1 = (function (){var statearr_108885 = state_108869;
(statearr_108885[(11)] = inst_108856__$1);

(statearr_108885[(9)] = inst_108855__$1);

return statearr_108885;
})();
if(cljs.core.truth_(inst_108856__$1)){
var statearr_108886_108918 = state_108869__$1;
(statearr_108886_108918[(1)] = (18));

} else {
var statearr_108887_108919 = state_108869__$1;
(statearr_108887_108919[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108870 === (3))){
var inst_108811 = (state_108869[(2)]);
var state_108869__$1 = state_108869;
var statearr_108888_108920 = state_108869__$1;
(statearr_108888_108920[(2)] = inst_108811);


cljs.core.async.impl.ioc_helpers.process_exception(state_108869__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_108870 === (12))){
var inst_108834 = (state_108869[(12)]);
var state_108869__$1 = state_108869;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_108869__$1,(14),inst_108834);
} else {
if((state_val_108870 === (2))){
var inst_108867 = (state_108869[(2)]);
var state_108869__$1 = state_108869;
return cljs.core.async.impl.ioc_helpers.return_chan(state_108869__$1,inst_108867);
} else {
if((state_val_108870 === (23))){
var inst_108863 = (state_108869[(2)]);
var state_108869__$1 = state_108869;
var statearr_108889_108921 = state_108869__$1;
(statearr_108889_108921[(2)] = inst_108863);

(statearr_108889_108921[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108870 === (19))){
var inst_108855 = (state_108869[(9)]);
var state_108869__$1 = state_108869;
if(cljs.core.truth_(inst_108855)){
var statearr_108890_108922 = state_108869__$1;
(statearr_108890_108922[(1)] = (21));

} else {
var statearr_108891_108923 = state_108869__$1;
(statearr_108891_108923[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108870 === (11))){
var state_108869__$1 = state_108869;
var statearr_108892_108924 = state_108869__$1;
(statearr_108892_108924[(2)] = null);

(statearr_108892_108924[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108870 === (9))){
var inst_108822 = (state_108869[(7)]);
var inst_108820 = (state_108869[(8)]);
var inst_108826 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_108827 = ["_block/instant",(0)];
var inst_108828 = (new cljs.core.PersistentVector(null,2,(5),inst_108826,inst_108827,null));
var inst_108829 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_108830 = ["_block/instant",inst_108820];
var inst_108831 = (new cljs.core.PersistentVector(null,2,(5),inst_108829,inst_108830,null));
var inst_108832 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(inst_108822,cljs.core.cst$kw$post,cljs.core._GT_,inst_108828,cljs.core._LT_,inst_108831);
var state_108869__$1 = state_108869;
var statearr_108893_108925 = state_108869__$1;
(statearr_108893_108925[(2)] = inst_108832);

(statearr_108893_108925[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108870 === (5))){
var inst_108817 = fluree.db.util.core.str__GT_epoch_ms(time_str);
var state_108869__$1 = state_108869;
var statearr_108894_108926 = state_108869__$1;
(statearr_108894_108926[(2)] = inst_108817);

(statearr_108894_108926[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108870 === (14))){
var inst_108839 = (state_108869[(2)]);
var inst_108840 = fluree.db.util.async.throw_err(inst_108839);
var state_108869__$1 = state_108869;
var statearr_108895_108927 = state_108869__$1;
(statearr_108895_108927[(2)] = inst_108840);

(statearr_108895_108927[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108870 === (16))){
var state_108869__$1 = state_108869;
var statearr_108896_108928 = state_108869__$1;
(statearr_108896_108928[(2)] = null);

(statearr_108896_108928[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108870 === (10))){
var inst_108834 = (state_108869[(12)]);
var inst_108834__$1 = (state_108869[(2)]);
var inst_108835 = (inst_108834__$1 == null);
var state_108869__$1 = (function (){var statearr_108897 = state_108869;
(statearr_108897[(12)] = inst_108834__$1);

return statearr_108897;
})();
if(cljs.core.truth_(inst_108835)){
var statearr_108898_108929 = state_108869__$1;
(statearr_108898_108929[(1)] = (11));

} else {
var statearr_108899_108930 = state_108869__$1;
(statearr_108899_108930[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108870 === (18))){
var inst_108856 = (state_108869[(11)]);
var state_108869__$1 = state_108869;
var statearr_108900_108931 = state_108869__$1;
(statearr_108900_108931[(2)] = inst_108856);

(statearr_108900_108931[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108870 === (8))){
var state_108869__$1 = state_108869;
var statearr_108901_108932 = state_108869__$1;
(statearr_108901_108932[(2)] = null);

(statearr_108901_108932[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$time_travel$time_to_t_$_state_machine__100742__auto__ = null;
var fluree$db$time_travel$time_to_t_$_state_machine__100742__auto____0 = (function (){
var statearr_108902 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_108902[(0)] = fluree$db$time_travel$time_to_t_$_state_machine__100742__auto__);

(statearr_108902[(1)] = (1));

return statearr_108902;
});
var fluree$db$time_travel$time_to_t_$_state_machine__100742__auto____1 = (function (state_108869){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_108869);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e108903){if((e108903 instanceof Object)){
var ex__100745__auto__ = e108903;
var statearr_108904_108933 = state_108869;
(statearr_108904_108933[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_108869);

return cljs.core.cst$kw$recur;
} else {
throw e108903;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__108934 = state_108869;
state_108869 = G__108934;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$time_travel$time_to_t_$_state_machine__100742__auto__ = function(state_108869){
switch(arguments.length){
case 0:
return fluree$db$time_travel$time_to_t_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$time_travel$time_to_t_$_state_machine__100742__auto____1.call(this,state_108869);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$time_travel$time_to_t_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$time_travel$time_to_t_$_state_machine__100742__auto____0;
fluree$db$time_travel$time_to_t_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$time_travel$time_to_t_$_state_machine__100742__auto____1;
return fluree$db$time_travel$time_to_t_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_108905 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_108905[(6)] = c__100848__auto__);

return statearr_108905;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
fluree.db.time_travel.t_to_block = (function fluree$db$time_travel$t_to_block(db,t){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_108984){
var state_val_108985 = (state_108984[(1)]);
if((state_val_108985 === (7))){
var inst_108955 = (state_108984[(7)]);
var inst_108955__$1 = (state_108984[(2)]);
var inst_108956 = (inst_108955__$1 == null);
var state_108984__$1 = (function (){var statearr_108986 = state_108984;
(statearr_108986[(7)] = inst_108955__$1);

return statearr_108986;
})();
if(cljs.core.truth_(inst_108956)){
var statearr_108987_109018 = state_108984__$1;
(statearr_108987_109018[(1)] = (8));

} else {
var statearr_108988_109019 = state_108984__$1;
(statearr_108988_109019[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108985 === (20))){
var inst_108980 = (state_108984[(2)]);
var state_108984__$1 = state_108984;
var statearr_108989_109020 = state_108984__$1;
(statearr_108989_109020[(2)] = inst_108980);


cljs.core.async.impl.ioc_helpers.process_exception(state_108984__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_108985 === (1))){
var state_108984__$1 = state_108984;
var statearr_108990_109021 = state_108984__$1;
(statearr_108990_109021[(2)] = null);

(statearr_108990_109021[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108985 === (4))){
var inst_108940 = (state_108984[(8)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_108984,(3),Error,null,(2));
var inst_108940__$1 = fluree.db.dbproto._rootdb(db);
var inst_108941 = (inst_108940__$1 == null);
var state_108984__$1 = (function (){var statearr_108991 = state_108984;
(statearr_108991[(8)] = inst_108940__$1);

return statearr_108991;
})();
if(cljs.core.truth_(inst_108941)){
var statearr_108992_109022 = state_108984__$1;
(statearr_108992_109022[(1)] = (5));

} else {
var statearr_108993_109023 = state_108984__$1;
(statearr_108993_109023[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108985 === (15))){
var state_108984__$1 = state_108984;
var statearr_108994_109024 = state_108984__$1;
(statearr_108994_109024[(2)] = null);

(statearr_108994_109024[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108985 === (13))){
var inst_108963 = (state_108984[(9)]);
var inst_108967 = cljs.core.first(inst_108963);
var state_108984__$1 = state_108984;
var statearr_108995_109025 = state_108984__$1;
(statearr_108995_109025[(2)] = inst_108967);

(statearr_108995_109025[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108985 === (6))){
var inst_108940 = (state_108984[(8)]);
var inst_108944 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_108945 = ["_block/number",t];
var inst_108946 = (new cljs.core.PersistentVector(null,2,(5),inst_108944,inst_108945,null));
var inst_108947 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_108948 = ["_block/number"];
var inst_108949 = (new cljs.core.PersistentVector(null,1,(5),inst_108947,inst_108948,null));
var inst_108950 = [cljs.core.cst$kw$limit];
var inst_108951 = [(1)];
var inst_108952 = cljs.core.PersistentHashMap.fromArrays(inst_108950,inst_108951);
var inst_108953 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(inst_108940,cljs.core.cst$kw$psot,cljs.core._GT__EQ_,inst_108946,cljs.core._LT__EQ_,inst_108949,inst_108952);
var state_108984__$1 = state_108984;
var statearr_108996_109026 = state_108984__$1;
(statearr_108996_109026[(2)] = inst_108953);

(statearr_108996_109026[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108985 === (17))){
var inst_108975 = (state_108984[(10)]);
var inst_108975__$1 = (state_108984[(2)]);
var inst_108976 = (inst_108975__$1 > (1));
var state_108984__$1 = (function (){var statearr_108997 = state_108984;
(statearr_108997[(10)] = inst_108975__$1);

return statearr_108997;
})();
if(cljs.core.truth_(inst_108976)){
var statearr_108998_109027 = state_108984__$1;
(statearr_108998_109027[(1)] = (18));

} else {
var statearr_108999_109028 = state_108984__$1;
(statearr_108999_109028[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108985 === (3))){
var inst_108935 = (state_108984[(2)]);
var state_108984__$1 = state_108984;
var statearr_109000_109029 = state_108984__$1;
(statearr_109000_109029[(2)] = inst_108935);


cljs.core.async.impl.ioc_helpers.process_exception(state_108984__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_108985 === (12))){
var state_108984__$1 = state_108984;
var statearr_109001_109030 = state_108984__$1;
(statearr_109001_109030[(2)] = null);

(statearr_109001_109030[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108985 === (2))){
var inst_108982 = (state_108984[(2)]);
var state_108984__$1 = state_108984;
return cljs.core.async.impl.ioc_helpers.return_chan(state_108984__$1,inst_108982);
} else {
if((state_val_108985 === (19))){
var state_108984__$1 = state_108984;
var statearr_109002_109031 = state_108984__$1;
(statearr_109002_109031[(2)] = (1));

(statearr_109002_109031[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108985 === (11))){
var inst_108960 = (state_108984[(2)]);
var inst_108961 = fluree.db.util.async.throw_err(inst_108960);
var state_108984__$1 = state_108984;
var statearr_109003_109032 = state_108984__$1;
(statearr_109003_109032[(2)] = inst_108961);

(statearr_109003_109032[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108985 === (9))){
var inst_108955 = (state_108984[(7)]);
var state_108984__$1 = state_108984;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_108984__$1,(11),inst_108955);
} else {
if((state_val_108985 === (5))){
var state_108984__$1 = state_108984;
var statearr_109004_109033 = state_108984__$1;
(statearr_109004_109033[(2)] = null);

(statearr_109004_109033[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108985 === (14))){
var inst_108969 = (state_108984[(11)]);
var inst_108969__$1 = (state_108984[(2)]);
var inst_108970 = (inst_108969__$1 == null);
var state_108984__$1 = (function (){var statearr_109005 = state_108984;
(statearr_109005[(11)] = inst_108969__$1);

return statearr_109005;
})();
if(cljs.core.truth_(inst_108970)){
var statearr_109006_109034 = state_108984__$1;
(statearr_109006_109034[(1)] = (15));

} else {
var statearr_109007_109035 = state_108984__$1;
(statearr_109007_109035[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108985 === (16))){
var inst_108969 = (state_108984[(11)]);
var inst_108973 = inst_108969.o;
var state_108984__$1 = state_108984;
var statearr_109008_109036 = state_108984__$1;
(statearr_109008_109036[(2)] = inst_108973);

(statearr_109008_109036[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108985 === (10))){
var inst_108963 = (state_108984[(9)]);
var inst_108963__$1 = (state_108984[(2)]);
var inst_108964 = (inst_108963__$1 == null);
var state_108984__$1 = (function (){var statearr_109009 = state_108984;
(statearr_109009[(9)] = inst_108963__$1);

return statearr_109009;
})();
if(cljs.core.truth_(inst_108964)){
var statearr_109010_109037 = state_108984__$1;
(statearr_109010_109037[(1)] = (12));

} else {
var statearr_109011_109038 = state_108984__$1;
(statearr_109011_109038[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108985 === (18))){
var inst_108975 = (state_108984[(10)]);
var state_108984__$1 = state_108984;
var statearr_109012_109039 = state_108984__$1;
(statearr_109012_109039[(2)] = inst_108975);

(statearr_109012_109039[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108985 === (8))){
var state_108984__$1 = state_108984;
var statearr_109013_109040 = state_108984__$1;
(statearr_109013_109040[(2)] = null);

(statearr_109013_109040[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$time_travel$t_to_block_$_state_machine__100742__auto__ = null;
var fluree$db$time_travel$t_to_block_$_state_machine__100742__auto____0 = (function (){
var statearr_109014 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_109014[(0)] = fluree$db$time_travel$t_to_block_$_state_machine__100742__auto__);

(statearr_109014[(1)] = (1));

return statearr_109014;
});
var fluree$db$time_travel$t_to_block_$_state_machine__100742__auto____1 = (function (state_108984){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_108984);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e109015){if((e109015 instanceof Object)){
var ex__100745__auto__ = e109015;
var statearr_109016_109041 = state_108984;
(statearr_109016_109041[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_108984);

return cljs.core.cst$kw$recur;
} else {
throw e109015;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__109042 = state_108984;
state_108984 = G__109042;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$time_travel$t_to_block_$_state_machine__100742__auto__ = function(state_108984){
switch(arguments.length){
case 0:
return fluree$db$time_travel$t_to_block_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$time_travel$t_to_block_$_state_machine__100742__auto____1.call(this,state_108984);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$time_travel$t_to_block_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$time_travel$t_to_block_$_state_machine__100742__auto____0;
fluree$db$time_travel$t_to_block_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$time_travel$t_to_block_$_state_machine__100742__auto____1;
return fluree$db$time_travel$t_to_block_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_109017 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_109017[(6)] = c__100848__auto__);

return statearr_109017;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
fluree.db.time_travel.non_border_t_to_block = (function fluree$db$time_travel$non_border_t_to_block(db,t){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_109090){
var state_val_109091 = (state_109090[(1)]);
if((state_val_109091 === (7))){
var inst_109057 = (state_109090[(7)]);
var inst_109057__$1 = (state_109090[(2)]);
var inst_109058 = (inst_109057__$1 == null);
var state_109090__$1 = (function (){var statearr_109092 = state_109090;
(statearr_109092[(7)] = inst_109057__$1);

return statearr_109092;
})();
if(cljs.core.truth_(inst_109058)){
var statearr_109093_109124 = state_109090__$1;
(statearr_109093_109124[(1)] = (8));

} else {
var statearr_109094_109125 = state_109090__$1;
(statearr_109094_109125[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_109091 === (20))){
var state_109090__$1 = state_109090;
var statearr_109095_109126 = state_109090__$1;
(statearr_109095_109126[(2)] = (1));

(statearr_109095_109126[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109091 === (1))){
var state_109090__$1 = state_109090;
var statearr_109096_109127 = state_109090__$1;
(statearr_109096_109127[(2)] = null);

(statearr_109096_109127[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109091 === (4))){
var inst_109048 = (state_109090[(8)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_109090,(3),Error,null,(2));
var inst_109048__$1 = fluree.db.dbproto._rootdb(db);
var inst_109049 = (inst_109048__$1 == null);
var state_109090__$1 = (function (){var statearr_109097 = state_109090;
(statearr_109097[(8)] = inst_109048__$1);

return statearr_109097;
})();
if(cljs.core.truth_(inst_109049)){
var statearr_109098_109128 = state_109090__$1;
(statearr_109098_109128[(1)] = (5));

} else {
var statearr_109099_109129 = state_109090__$1;
(statearr_109099_109129[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_109091 === (15))){
var state_109090__$1 = state_109090;
var statearr_109100_109130 = state_109090__$1;
(statearr_109100_109130[(2)] = null);

(statearr_109100_109130[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109091 === (21))){
var inst_109086 = (state_109090[(2)]);
var state_109090__$1 = state_109090;
var statearr_109101_109131 = state_109090__$1;
(statearr_109101_109131[(2)] = inst_109086);


cljs.core.async.impl.ioc_helpers.process_exception(state_109090__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_109091 === (13))){
var inst_109065 = (state_109090[(9)]);
var inst_109069 = cljs.core.first(inst_109065);
var state_109090__$1 = state_109090;
var statearr_109102_109132 = state_109090__$1;
(statearr_109102_109132[(2)] = inst_109069);

(statearr_109102_109132[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109091 === (6))){
var inst_109048 = (state_109090[(8)]);
var inst_109052 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_109053 = [t,"_block/transactions"];
var inst_109054 = (new cljs.core.PersistentVector(null,2,(5),inst_109052,inst_109053,null));
var inst_109055 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_109048,cljs.core.cst$kw$opst,cljs.core._EQ_,inst_109054);
var state_109090__$1 = state_109090;
var statearr_109103_109133 = state_109090__$1;
(statearr_109103_109133[(2)] = inst_109055);

(statearr_109103_109133[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109091 === (17))){
var inst_109077 = (state_109090[(2)]);
var inst_109078 = fluree.db.time_travel.t_to_block(db,inst_109077);
var state_109090__$1 = state_109090;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_109090__$1,(18),inst_109078);
} else {
if((state_val_109091 === (3))){
var inst_109043 = (state_109090[(2)]);
var state_109090__$1 = state_109090;
var statearr_109104_109134 = state_109090__$1;
(statearr_109104_109134[(2)] = inst_109043);


cljs.core.async.impl.ioc_helpers.process_exception(state_109090__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_109091 === (12))){
var state_109090__$1 = state_109090;
var statearr_109105_109135 = state_109090__$1;
(statearr_109105_109135[(2)] = null);

(statearr_109105_109135[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109091 === (2))){
var inst_109088 = (state_109090[(2)]);
var state_109090__$1 = state_109090;
return cljs.core.async.impl.ioc_helpers.return_chan(state_109090__$1,inst_109088);
} else {
if((state_val_109091 === (19))){
var inst_109081 = (state_109090[(10)]);
var state_109090__$1 = state_109090;
var statearr_109106_109136 = state_109090__$1;
(statearr_109106_109136[(2)] = inst_109081);

(statearr_109106_109136[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109091 === (11))){
var inst_109062 = (state_109090[(2)]);
var inst_109063 = fluree.db.util.async.throw_err(inst_109062);
var state_109090__$1 = state_109090;
var statearr_109107_109137 = state_109090__$1;
(statearr_109107_109137[(2)] = inst_109063);

(statearr_109107_109137[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109091 === (9))){
var inst_109057 = (state_109090[(7)]);
var state_109090__$1 = state_109090;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_109090__$1,(11),inst_109057);
} else {
if((state_val_109091 === (5))){
var state_109090__$1 = state_109090;
var statearr_109108_109138 = state_109090__$1;
(statearr_109108_109138[(2)] = null);

(statearr_109108_109138[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109091 === (14))){
var inst_109071 = (state_109090[(11)]);
var inst_109071__$1 = (state_109090[(2)]);
var inst_109072 = (inst_109071__$1 == null);
var state_109090__$1 = (function (){var statearr_109109 = state_109090;
(statearr_109109[(11)] = inst_109071__$1);

return statearr_109109;
})();
if(cljs.core.truth_(inst_109072)){
var statearr_109110_109139 = state_109090__$1;
(statearr_109110_109139[(1)] = (15));

} else {
var statearr_109111_109140 = state_109090__$1;
(statearr_109111_109140[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_109091 === (16))){
var inst_109071 = (state_109090[(11)]);
var inst_109075 = inst_109071.s;
var state_109090__$1 = state_109090;
var statearr_109112_109141 = state_109090__$1;
(statearr_109112_109141[(2)] = inst_109075);

(statearr_109112_109141[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109091 === (10))){
var inst_109065 = (state_109090[(9)]);
var inst_109065__$1 = (state_109090[(2)]);
var inst_109066 = (inst_109065__$1 == null);
var state_109090__$1 = (function (){var statearr_109113 = state_109090;
(statearr_109113[(9)] = inst_109065__$1);

return statearr_109113;
})();
if(cljs.core.truth_(inst_109066)){
var statearr_109114_109142 = state_109090__$1;
(statearr_109114_109142[(1)] = (12));

} else {
var statearr_109115_109143 = state_109090__$1;
(statearr_109115_109143[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_109091 === (18))){
var inst_109081 = (state_109090[(10)]);
var inst_109080 = (state_109090[(2)]);
var inst_109081__$1 = fluree.db.util.async.throw_err(inst_109080);
var inst_109082 = (inst_109081__$1 > (1));
var state_109090__$1 = (function (){var statearr_109116 = state_109090;
(statearr_109116[(10)] = inst_109081__$1);

return statearr_109116;
})();
if(cljs.core.truth_(inst_109082)){
var statearr_109117_109144 = state_109090__$1;
(statearr_109117_109144[(1)] = (19));

} else {
var statearr_109118_109145 = state_109090__$1;
(statearr_109118_109145[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_109091 === (8))){
var state_109090__$1 = state_109090;
var statearr_109119_109146 = state_109090__$1;
(statearr_109119_109146[(2)] = null);

(statearr_109119_109146[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$time_travel$non_border_t_to_block_$_state_machine__100742__auto__ = null;
var fluree$db$time_travel$non_border_t_to_block_$_state_machine__100742__auto____0 = (function (){
var statearr_109120 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_109120[(0)] = fluree$db$time_travel$non_border_t_to_block_$_state_machine__100742__auto__);

(statearr_109120[(1)] = (1));

return statearr_109120;
});
var fluree$db$time_travel$non_border_t_to_block_$_state_machine__100742__auto____1 = (function (state_109090){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_109090);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e109121){if((e109121 instanceof Object)){
var ex__100745__auto__ = e109121;
var statearr_109122_109147 = state_109090;
(statearr_109122_109147[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_109090);

return cljs.core.cst$kw$recur;
} else {
throw e109121;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__109148 = state_109090;
state_109090 = G__109148;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$time_travel$non_border_t_to_block_$_state_machine__100742__auto__ = function(state_109090){
switch(arguments.length){
case 0:
return fluree$db$time_travel$non_border_t_to_block_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$time_travel$non_border_t_to_block_$_state_machine__100742__auto____1.call(this,state_109090);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$time_travel$non_border_t_to_block_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$time_travel$non_border_t_to_block_$_state_machine__100742__auto____0;
fluree$db$time_travel$non_border_t_to_block_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$time_travel$non_border_t_to_block_$_state_machine__100742__auto____1;
return fluree$db$time_travel$non_border_t_to_block_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_109123 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_109123[(6)] = c__100848__auto__);

return statearr_109123;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
fluree.db.time_travel.block_to_int_format = (function fluree$db$time_travel$block_to_int_format(db,block){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_109203){
var state_val_109204 = (state_109203[(1)]);
if((state_val_109204 === (7))){
var inst_109199 = (state_109203[(2)]);
var state_109203__$1 = state_109203;
var statearr_109205_109228 = state_109203__$1;
(statearr_109205_109228[(2)] = inst_109199);


cljs.core.async.impl.ioc_helpers.process_exception(state_109203__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_109204 === (20))){
var inst_109193 = (state_109203[(2)]);
var state_109203__$1 = state_109203;
var statearr_109206_109229 = state_109203__$1;
(statearr_109206_109229[(2)] = inst_109193);

(statearr_109206_109229[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109204 === (1))){
var state_109203__$1 = state_109203;
var statearr_109207_109230 = state_109203__$1;
(statearr_109207_109230[(2)] = null);

(statearr_109207_109230[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109204 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_109203,(3),Error,null,(2));
var inst_109153 = cljs.core.pos_int_QMARK_(block);
var state_109203__$1 = state_109203;
if(inst_109153){
var statearr_109208_109231 = state_109203__$1;
(statearr_109208_109231[(1)] = (5));

} else {
var statearr_109209_109232 = state_109203__$1;
(statearr_109209_109232[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_109204 === (15))){
var inst_109195 = (state_109203[(2)]);
var state_109203__$1 = state_109203;
var statearr_109210_109233 = state_109203__$1;
(statearr_109210_109233[(2)] = inst_109195);

(statearr_109210_109233[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109204 === (13))){
var inst_109174 = fluree.db.time_travel.time_to_t(db,block);
var state_109203__$1 = state_109203;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_109203__$1,(16),inst_109174);
} else {
if((state_val_109204 === (6))){
var inst_109156 = typeof block === 'string';
var inst_109157 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(block,(0));
var inst_109158 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_109157);
var inst_109159 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("P",inst_109158);
var inst_109160 = ((inst_109156) && (inst_109159));
var state_109203__$1 = state_109203;
if(cljs.core.truth_(inst_109160)){
var statearr_109211_109234 = state_109203__$1;
(statearr_109211_109234[(1)] = (8));

} else {
var statearr_109212_109235 = state_109203__$1;
(statearr_109212_109235[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_109204 === (17))){
var inst_109180 = (state_109203[(2)]);
var inst_109181 = fluree.db.util.async.throw_err(inst_109180);
var state_109203__$1 = state_109203;
var statearr_109213_109236 = state_109203__$1;
(statearr_109213_109236[(2)] = inst_109181);

(statearr_109213_109236[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109204 === (3))){
var inst_109149 = (state_109203[(2)]);
var state_109203__$1 = state_109203;
var statearr_109214_109237 = state_109203__$1;
(statearr_109214_109237[(2)] = inst_109149);


cljs.core.async.impl.ioc_helpers.process_exception(state_109203__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_109204 === (12))){
var inst_109169 = (state_109203[(2)]);
var inst_109170 = fluree.db.util.async.throw_err(inst_109169);
var state_109203__$1 = state_109203;
var statearr_109215_109238 = state_109203__$1;
(statearr_109215_109238[(2)] = inst_109170);

(statearr_109215_109238[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109204 === (2))){
var inst_109201 = (state_109203[(2)]);
var state_109203__$1 = state_109203;
return cljs.core.async.impl.ioc_helpers.return_chan(state_109203__$1,inst_109201);
} else {
if((state_val_109204 === (19))){
var state_109203__$1 = state_109203;
var statearr_109216_109239 = state_109203__$1;
(statearr_109216_109239[(2)] = null);

(statearr_109216_109239[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109204 === (11))){
var inst_109165 = (state_109203[(2)]);
var inst_109166 = fluree.db.util.async.throw_err(inst_109165);
var inst_109167 = fluree.db.time_travel.t_to_block(db,inst_109166);
var state_109203__$1 = state_109203;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_109203__$1,(12),inst_109167);
} else {
if((state_val_109204 === (9))){
var inst_109172 = typeof block === 'string';
var state_109203__$1 = state_109203;
if(cljs.core.truth_(inst_109172)){
var statearr_109217_109240 = state_109203__$1;
(statearr_109217_109240[(1)] = (13));

} else {
var statearr_109218_109241 = state_109203__$1;
(statearr_109218_109241[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_109204 === (5))){
var state_109203__$1 = state_109203;
var statearr_109219_109242 = state_109203__$1;
(statearr_109219_109242[(2)] = block);

(statearr_109219_109242[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109204 === (14))){
var state_109203__$1 = state_109203;
var statearr_109220_109243 = state_109203__$1;
(statearr_109220_109243[(1)] = (18));



return cljs.core.cst$kw$recur;
} else {
if((state_val_109204 === (16))){
var inst_109176 = (state_109203[(2)]);
var inst_109177 = fluree.db.util.async.throw_err(inst_109176);
var inst_109178 = fluree.db.time_travel.t_to_block(db,inst_109177);
var state_109203__$1 = state_109203;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_109203__$1,(17),inst_109178);
} else {
if((state_val_109204 === (10))){
var inst_109197 = (state_109203[(2)]);
var state_109203__$1 = state_109203;
var statearr_109222_109244 = state_109203__$1;
(statearr_109222_109244[(2)] = inst_109197);

(statearr_109222_109244[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109204 === (18))){
var inst_109184 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([block], 0));
var inst_109185 = ["Invalid block key provided: ",inst_109184].join('');
var inst_109186 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_109187 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_time];
var inst_109188 = cljs.core.PersistentHashMap.fromArrays(inst_109186,inst_109187);
var inst_109189 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_109185,inst_109188);
var inst_109190 = (function(){throw inst_109189})();
var state_109203__$1 = state_109203;
var statearr_109223_109245 = state_109203__$1;
(statearr_109223_109245[(2)] = inst_109190);

(statearr_109223_109245[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109204 === (8))){
var inst_109162 = fluree.db.time_travel.duration_parse(block);
var inst_109163 = fluree.db.time_travel.time_to_t(db,inst_109162);
var state_109203__$1 = state_109203;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_109203__$1,(11),inst_109163);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$time_travel$block_to_int_format_$_state_machine__100742__auto__ = null;
var fluree$db$time_travel$block_to_int_format_$_state_machine__100742__auto____0 = (function (){
var statearr_109224 = [null,null,null,null,null,null,null];
(statearr_109224[(0)] = fluree$db$time_travel$block_to_int_format_$_state_machine__100742__auto__);

(statearr_109224[(1)] = (1));

return statearr_109224;
});
var fluree$db$time_travel$block_to_int_format_$_state_machine__100742__auto____1 = (function (state_109203){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_109203);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e109225){if((e109225 instanceof Object)){
var ex__100745__auto__ = e109225;
var statearr_109226_109246 = state_109203;
(statearr_109226_109246[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_109203);

return cljs.core.cst$kw$recur;
} else {
throw e109225;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__109247 = state_109203;
state_109203 = G__109247;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$time_travel$block_to_int_format_$_state_machine__100742__auto__ = function(state_109203){
switch(arguments.length){
case 0:
return fluree$db$time_travel$block_to_int_format_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$time_travel$block_to_int_format_$_state_machine__100742__auto____1.call(this,state_109203);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$time_travel$block_to_int_format_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$time_travel$block_to_int_format_$_state_machine__100742__auto____0;
fluree$db$time_travel$block_to_int_format_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$time_travel$block_to_int_format_$_state_machine__100742__auto____1;
return fluree$db$time_travel$block_to_int_format_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_109227 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_109227[(6)] = c__100848__auto__);

return statearr_109227;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
fluree.db.time_travel.block_to_t = (function fluree$db$time_travel$block_to_t(db,block){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_109297){
var state_val_109298 = (state_109297[(1)]);
if((state_val_109298 === (7))){
var inst_109262 = (state_109297[(7)]);
var inst_109262__$1 = (state_109297[(2)]);
var inst_109263 = (inst_109262__$1 == null);
var state_109297__$1 = (function (){var statearr_109299 = state_109297;
(statearr_109299[(7)] = inst_109262__$1);

return statearr_109299;
})();
if(cljs.core.truth_(inst_109263)){
var statearr_109300_109332 = state_109297__$1;
(statearr_109300_109332[(1)] = (8));

} else {
var statearr_109301_109333 = state_109297__$1;
(statearr_109301_109333[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_109298 === (20))){
var inst_109282 = (state_109297[(8)]);
var inst_109293 = (state_109297[(2)]);
var state_109297__$1 = (function (){var statearr_109302 = state_109297;
(statearr_109302[(9)] = inst_109293);

return statearr_109302;
})();
var statearr_109303_109334 = state_109297__$1;
(statearr_109303_109334[(2)] = inst_109282);


cljs.core.async.impl.ioc_helpers.process_exception(state_109297__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_109298 === (1))){
var state_109297__$1 = state_109297;
var statearr_109304_109335 = state_109297__$1;
(statearr_109304_109335[(2)] = null);

(statearr_109304_109335[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109298 === (4))){
var inst_109253 = (state_109297[(10)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_109297,(3),Error,null,(2));
var inst_109253__$1 = fluree.db.dbproto._rootdb(db);
var inst_109254 = (inst_109253__$1 == null);
var state_109297__$1 = (function (){var statearr_109305 = state_109297;
(statearr_109305[(10)] = inst_109253__$1);

return statearr_109305;
})();
if(cljs.core.truth_(inst_109254)){
var statearr_109306_109336 = state_109297__$1;
(statearr_109306_109336[(1)] = (5));

} else {
var statearr_109307_109337 = state_109297__$1;
(statearr_109307_109337[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_109298 === (15))){
var state_109297__$1 = state_109297;
var statearr_109308_109338 = state_109297__$1;
(statearr_109308_109338[(2)] = null);

(statearr_109308_109338[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109298 === (13))){
var inst_109270 = (state_109297[(11)]);
var inst_109274 = cljs.core.first(inst_109270);
var state_109297__$1 = state_109297;
var statearr_109309_109339 = state_109297__$1;
(statearr_109309_109339[(2)] = inst_109274);

(statearr_109309_109339[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109298 === (6))){
var inst_109253 = (state_109297[(10)]);
var inst_109257 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_109258 = ["_block/number",block];
var inst_109259 = (new cljs.core.PersistentVector(null,2,(5),inst_109257,inst_109258,null));
var inst_109260 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_109253,cljs.core.cst$kw$post,cljs.core._EQ_,inst_109259);
var state_109297__$1 = state_109297;
var statearr_109310_109340 = state_109297__$1;
(statearr_109310_109340[(2)] = inst_109260);

(statearr_109310_109340[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109298 === (17))){
var inst_109282 = (state_109297[(8)]);
var inst_109282__$1 = (state_109297[(2)]);
var state_109297__$1 = (function (){var statearr_109311 = state_109297;
(statearr_109311[(8)] = inst_109282__$1);

return statearr_109311;
})();
if(cljs.core.truth_(inst_109282__$1)){
var statearr_109312_109341 = state_109297__$1;
(statearr_109312_109341[(1)] = (18));

} else {
var statearr_109313_109342 = state_109297__$1;
(statearr_109313_109342[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_109298 === (3))){
var inst_109248 = (state_109297[(2)]);
var state_109297__$1 = state_109297;
var statearr_109314_109343 = state_109297__$1;
(statearr_109314_109343[(2)] = inst_109248);


cljs.core.async.impl.ioc_helpers.process_exception(state_109297__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_109298 === (12))){
var state_109297__$1 = state_109297;
var statearr_109315_109344 = state_109297__$1;
(statearr_109315_109344[(2)] = null);

(statearr_109315_109344[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109298 === (2))){
var inst_109295 = (state_109297[(2)]);
var state_109297__$1 = state_109297;
return cljs.core.async.impl.ioc_helpers.return_chan(state_109297__$1,inst_109295);
} else {
if((state_val_109298 === (19))){
var inst_109285 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([block], 0));
var inst_109286 = ["Invalid block key provided: ",inst_109285].join('');
var inst_109287 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_109288 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_time];
var inst_109289 = cljs.core.PersistentHashMap.fromArrays(inst_109287,inst_109288);
var inst_109290 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_109286,inst_109289);
var inst_109291 = (function(){throw inst_109290})();
var state_109297__$1 = state_109297;
var statearr_109316_109345 = state_109297__$1;
(statearr_109316_109345[(2)] = inst_109291);

(statearr_109316_109345[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109298 === (11))){
var inst_109267 = (state_109297[(2)]);
var inst_109268 = fluree.db.util.async.throw_err(inst_109267);
var state_109297__$1 = state_109297;
var statearr_109317_109346 = state_109297__$1;
(statearr_109317_109346[(2)] = inst_109268);

(statearr_109317_109346[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109298 === (9))){
var inst_109262 = (state_109297[(7)]);
var state_109297__$1 = state_109297;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_109297__$1,(11),inst_109262);
} else {
if((state_val_109298 === (5))){
var state_109297__$1 = state_109297;
var statearr_109318_109347 = state_109297__$1;
(statearr_109318_109347[(2)] = null);

(statearr_109318_109347[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109298 === (14))){
var inst_109276 = (state_109297[(12)]);
var inst_109276__$1 = (state_109297[(2)]);
var inst_109277 = (inst_109276__$1 == null);
var state_109297__$1 = (function (){var statearr_109319 = state_109297;
(statearr_109319[(12)] = inst_109276__$1);

return statearr_109319;
})();
if(cljs.core.truth_(inst_109277)){
var statearr_109320_109348 = state_109297__$1;
(statearr_109320_109348[(1)] = (15));

} else {
var statearr_109321_109349 = state_109297__$1;
(statearr_109321_109349[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_109298 === (16))){
var inst_109276 = (state_109297[(12)]);
var inst_109280 = inst_109276.t;
var state_109297__$1 = state_109297;
var statearr_109322_109350 = state_109297__$1;
(statearr_109322_109350[(2)] = inst_109280);

(statearr_109322_109350[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109298 === (10))){
var inst_109270 = (state_109297[(11)]);
var inst_109270__$1 = (state_109297[(2)]);
var inst_109271 = (inst_109270__$1 == null);
var state_109297__$1 = (function (){var statearr_109323 = state_109297;
(statearr_109323[(11)] = inst_109270__$1);

return statearr_109323;
})();
if(cljs.core.truth_(inst_109271)){
var statearr_109324_109351 = state_109297__$1;
(statearr_109324_109351[(1)] = (12));

} else {
var statearr_109325_109352 = state_109297__$1;
(statearr_109325_109352[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_109298 === (18))){
var state_109297__$1 = state_109297;
var statearr_109326_109353 = state_109297__$1;
(statearr_109326_109353[(2)] = null);

(statearr_109326_109353[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109298 === (8))){
var state_109297__$1 = state_109297;
var statearr_109327_109354 = state_109297__$1;
(statearr_109327_109354[(2)] = null);

(statearr_109327_109354[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$time_travel$block_to_t_$_state_machine__100742__auto__ = null;
var fluree$db$time_travel$block_to_t_$_state_machine__100742__auto____0 = (function (){
var statearr_109328 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_109328[(0)] = fluree$db$time_travel$block_to_t_$_state_machine__100742__auto__);

(statearr_109328[(1)] = (1));

return statearr_109328;
});
var fluree$db$time_travel$block_to_t_$_state_machine__100742__auto____1 = (function (state_109297){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_109297);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e109329){if((e109329 instanceof Object)){
var ex__100745__auto__ = e109329;
var statearr_109330_109355 = state_109297;
(statearr_109330_109355[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_109297);

return cljs.core.cst$kw$recur;
} else {
throw e109329;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__109356 = state_109297;
state_109297 = G__109356;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$time_travel$block_to_t_$_state_machine__100742__auto__ = function(state_109297){
switch(arguments.length){
case 0:
return fluree$db$time_travel$block_to_t_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$time_travel$block_to_t_$_state_machine__100742__auto____1.call(this,state_109297);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$time_travel$block_to_t_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$time_travel$block_to_t_$_state_machine__100742__auto____0;
fluree$db$time_travel$block_to_t_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$time_travel$block_to_t_$_state_machine__100742__auto____1;
return fluree$db$time_travel$block_to_t_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_109331 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_109331[(6)] = c__100848__auto__);

return statearr_109331;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
/**
 * Gets the database as-of a specified block. Either block number or a time string in ISO-8601 format.
 */
fluree.db.time_travel.as_of_block = (function fluree$db$time_travel$as_of_block(db,block_or_t_or_time){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_109426){
var state_val_109427 = (state_109426[(1)]);
if((state_val_109427 === (7))){
var inst_109379 = cljs.core.neg_int_QMARK_(block_or_t_or_time);
var state_109426__$1 = state_109426;
if(inst_109379){
var statearr_109428_109461 = state_109426__$1;
(statearr_109428_109461[(1)] = (13));

} else {
var statearr_109429_109462 = state_109426__$1;
(statearr_109429_109462[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_109427 === (20))){
var inst_109364 = (state_109426[(7)]);
var inst_109394 = fluree.db.time_travel.time_to_t(inst_109364,block_or_t_or_time);
var state_109426__$1 = state_109426;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_109426__$1,(23),inst_109394);
} else {
if((state_val_109427 === (27))){
var inst_109417 = (state_109426[(8)]);
var inst_109420 = (state_109426[(2)]);
var inst_109421 = fluree.db.util.async.throw_err(inst_109420);
var inst_109422 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(db,cljs.core.cst$kw$t,inst_109417,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$block,inst_109421], 0));
var state_109426__$1 = state_109426;
var statearr_109430_109463 = state_109426__$1;
(statearr_109430_109463[(2)] = inst_109422);


cljs.core.async.impl.ioc_helpers.process_exception(state_109426__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_109427 === (1))){
var state_109426__$1 = state_109426;
var statearr_109431_109464 = state_109426__$1;
(statearr_109431_109464[(2)] = null);

(statearr_109431_109464[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109427 === (24))){
var inst_109402 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([block_or_t_or_time], 0));
var inst_109403 = ["Invalid block key provided: ",inst_109402].join('');
var inst_109404 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_109405 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_time];
var inst_109406 = cljs.core.PersistentHashMap.fromArrays(inst_109404,inst_109405);
var inst_109407 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_109403,inst_109406);
var inst_109408 = (function(){throw inst_109407})();
var state_109426__$1 = state_109426;
var statearr_109432_109465 = state_109426__$1;
(statearr_109432_109465[(2)] = inst_109408);

(statearr_109432_109465[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109427 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_109426,(3),Error,null,(2));
var inst_109361 = fluree.db.dbproto._latest_db(db);
var state_109426__$1 = state_109426;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_109426__$1,(5),inst_109361);
} else {
if((state_val_109427 === (15))){
var inst_109415 = (state_109426[(2)]);
var state_109426__$1 = state_109426;
var statearr_109433_109466 = state_109426__$1;
(statearr_109433_109466[(2)] = inst_109415);

(statearr_109433_109466[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109427 === (21))){
var inst_109399 = (state_109426[(2)]);
var state_109426__$1 = state_109426;
var statearr_109434_109467 = state_109426__$1;
(statearr_109434_109467[(2)] = inst_109399);

(statearr_109434_109467[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109427 === (13))){
var state_109426__$1 = state_109426;
var statearr_109435_109468 = state_109426__$1;
(statearr_109435_109468[(2)] = block_or_t_or_time);

(statearr_109435_109468[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109427 === (22))){
var inst_109391 = (state_109426[(2)]);
var inst_109392 = fluree.db.util.async.throw_err(inst_109391);
var state_109426__$1 = state_109426;
var statearr_109436_109469 = state_109426__$1;
(statearr_109436_109469[(2)] = inst_109392);

(statearr_109436_109469[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109427 === (6))){
var state_109426__$1 = state_109426;
var statearr_109437_109470 = state_109426__$1;
(statearr_109437_109470[(2)] = null);

(statearr_109437_109470[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109427 === (25))){
var state_109426__$1 = state_109426;
var statearr_109438_109471 = state_109426__$1;
(statearr_109438_109471[(2)] = null);

(statearr_109438_109471[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109427 === (17))){
var state_109426__$1 = state_109426;
var statearr_109439_109472 = state_109426__$1;
(statearr_109439_109472[(1)] = (24));



return cljs.core.cst$kw$recur;
} else {
if((state_val_109427 === (3))){
var inst_109357 = (state_109426[(2)]);
var state_109426__$1 = state_109426;
var statearr_109441_109473 = state_109426__$1;
(statearr_109441_109473[(2)] = inst_109357);


cljs.core.async.impl.ioc_helpers.process_exception(state_109426__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_109427 === (12))){
var inst_109374 = (state_109426[(2)]);
var inst_109375 = fluree.db.util.async.throw_err(inst_109374);
var state_109426__$1 = state_109426;
var statearr_109442_109474 = state_109426__$1;
(statearr_109442_109474[(2)] = inst_109375);


cljs.core.async.impl.ioc_helpers.process_exception(state_109426__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_109427 === (2))){
var inst_109424 = (state_109426[(2)]);
var state_109426__$1 = state_109426;
return cljs.core.async.impl.ioc_helpers.return_chan(state_109426__$1,inst_109424);
} else {
if((state_val_109427 === (23))){
var inst_109396 = (state_109426[(2)]);
var inst_109397 = fluree.db.util.async.throw_err(inst_109396);
var state_109426__$1 = state_109426;
var statearr_109443_109475 = state_109426__$1;
(statearr_109443_109475[(2)] = inst_109397);

(statearr_109443_109475[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109427 === (19))){
var inst_109364 = (state_109426[(7)]);
var inst_109388 = fluree.db.time_travel.duration_parse(block_or_t_or_time);
var inst_109389 = fluree.db.time_travel.time_to_t(inst_109364,inst_109388);
var state_109426__$1 = state_109426;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_109426__$1,(22),inst_109389);
} else {
if((state_val_109427 === (11))){
var inst_109364 = (state_109426[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_109426,(10),cljs.core.cst$kw$default,null,(9));
var inst_109372 = fluree.db.time_travel.block_to_t(inst_109364,block_or_t_or_time);
var state_109426__$1 = state_109426;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_109426__$1,(12),inst_109372);
} else {
if((state_val_109427 === (9))){
var inst_109377 = (state_109426[(2)]);
var state_109426__$1 = state_109426;
var statearr_109444_109476 = state_109426__$1;
(statearr_109444_109476[(2)] = inst_109377);

(statearr_109444_109476[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109427 === (5))){
var inst_109363 = (state_109426[(2)]);
var inst_109364 = fluree.db.util.async.throw_err(inst_109363);
var inst_109365 = cljs.core.pos_int_QMARK_(block_or_t_or_time);
var state_109426__$1 = (function (){var statearr_109445 = state_109426;
(statearr_109445[(7)] = inst_109364);

return statearr_109445;
})();
if(inst_109365){
var statearr_109446_109477 = state_109426__$1;
(statearr_109446_109477[(1)] = (6));

} else {
var statearr_109447_109478 = state_109426__$1;
(statearr_109447_109478[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_109427 === (14))){
var inst_109382 = typeof block_or_t_or_time === 'string';
var state_109426__$1 = state_109426;
if(cljs.core.truth_(inst_109382)){
var statearr_109448_109479 = state_109426__$1;
(statearr_109448_109479[(1)] = (16));

} else {
var statearr_109449_109480 = state_109426__$1;
(statearr_109449_109480[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_109427 === (26))){
var inst_109411 = (state_109426[(2)]);
var state_109426__$1 = state_109426;
var statearr_109450_109481 = state_109426__$1;
(statearr_109450_109481[(2)] = inst_109411);

(statearr_109450_109481[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109427 === (16))){
var inst_109384 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(block_or_t_or_time,(0));
var inst_109385 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_109384);
var inst_109386 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("P",inst_109385);
var state_109426__$1 = state_109426;
if(inst_109386){
var statearr_109451_109482 = state_109426__$1;
(statearr_109451_109482[(1)] = (19));

} else {
var statearr_109452_109483 = state_109426__$1;
(statearr_109452_109483[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_109427 === (10))){
var inst_109364 = (state_109426[(7)]);
var inst_109367 = (state_109426[(2)]);
var inst_109368 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(inst_109364);
var state_109426__$1 = (function (){var statearr_109453 = state_109426;
(statearr_109453[(9)] = inst_109367);

return statearr_109453;
})();
var statearr_109454_109484 = state_109426__$1;
(statearr_109454_109484[(2)] = inst_109368);


cljs.core.async.impl.ioc_helpers.process_exception(state_109426__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_109427 === (18))){
var inst_109413 = (state_109426[(2)]);
var state_109426__$1 = state_109426;
var statearr_109455_109485 = state_109426__$1;
(statearr_109455_109485[(2)] = inst_109413);

(statearr_109455_109485[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109427 === (8))){
var inst_109417 = (state_109426[(8)]);
var inst_109364 = (state_109426[(7)]);
var inst_109417__$1 = (state_109426[(2)]);
var inst_109418 = fluree.db.time_travel.t_to_block(inst_109364,inst_109417__$1);
var state_109426__$1 = (function (){var statearr_109456 = state_109426;
(statearr_109456[(8)] = inst_109417__$1);

return statearr_109456;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_109426__$1,(27),inst_109418);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$time_travel$as_of_block_$_state_machine__100742__auto__ = null;
var fluree$db$time_travel$as_of_block_$_state_machine__100742__auto____0 = (function (){
var statearr_109457 = [null,null,null,null,null,null,null,null,null,null];
(statearr_109457[(0)] = fluree$db$time_travel$as_of_block_$_state_machine__100742__auto__);

(statearr_109457[(1)] = (1));

return statearr_109457;
});
var fluree$db$time_travel$as_of_block_$_state_machine__100742__auto____1 = (function (state_109426){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_109426);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e109458){if((e109458 instanceof Object)){
var ex__100745__auto__ = e109458;
var statearr_109459_109486 = state_109426;
(statearr_109459_109486[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_109426);

return cljs.core.cst$kw$recur;
} else {
throw e109458;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__109487 = state_109426;
state_109426 = G__109487;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$time_travel$as_of_block_$_state_machine__100742__auto__ = function(state_109426){
switch(arguments.length){
case 0:
return fluree$db$time_travel$as_of_block_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$time_travel$as_of_block_$_state_machine__100742__auto____1.call(this,state_109426);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$time_travel$as_of_block_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$time_travel$as_of_block_$_state_machine__100742__auto____0;
fluree$db$time_travel$as_of_block_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$time_travel$as_of_block_$_state_machine__100742__auto____1;
return fluree$db$time_travel$as_of_block_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_109460 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_109460[(6)] = c__100848__auto__);

return statearr_109460;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
