// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true}
goog.provide('fluree.db.session');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.graphdb');
goog.require('cljs.core.async');
goog.require('cljs.cache');
goog.require('clojure.string');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.operations');
goog.require('fluree.db.flake');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.schema');



/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.session.DbSession = (function (conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.db_name = db_name;
this.update_chan = update_chan;
this.transact_chan = transact_chan;
this.state = state;
this.schema_cache = schema_cache;
this.blank_db = blank_db;
this.close = close;
this.id = id;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k117599,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__117603 = k117599;
var G__117603__$1 = (((G__117603 instanceof cljs.core.Keyword))?G__117603.fqn:null);
switch (G__117603__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "db-name":
return self__.db_name;

break;
case "update-chan":
return self__.update_chan;

break;
case "transact-chan":
return self__.transact_chan;

break;
case "state":
return self__.state;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "blank-db":
return self__.blank_db;

break;
case "close":
return self__.close;

break;
case "id":
return self__.id;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k117599,else__4383__auto__);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__117604){
var vec__117605 = p__117604;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__117605,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__117605,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(fluree.db.session.DbSession.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#fluree.db.session.DbSession{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$conn,self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$network,self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$dbid,self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$db_DASH_name,self__.db_name],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$update_DASH_chan,self__.update_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$transact_DASH_chan,self__.transact_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$state,self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$blank_DASH_db,self__.blank_db],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$close,self__.close],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$id,self__.id],null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__117598){
var self__ = this;
var G__117598__$1 = this;
return (new cljs.core.RecordIter((0),G__117598__$1,11,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$db_DASH_name,cljs.core.cst$kw$update_DASH_chan,cljs.core.cst$kw$transact_DASH_chan,cljs.core.cst$kw$state,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$blank_DASH_db,cljs.core.cst$kw$close,cljs.core.cst$kw$id], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (11 + cljs.core.count(self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (){var fexpr__117608 = (function (coll__4377__auto__){
return (1635626254 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
});
return fexpr__117608(this__4376__auto____$1);
})();
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this117600,other117601){
var self__ = this;
var this117600__$1 = this;
return (((!((other117601 == null)))) && ((this117600__$1.constructor === other117601.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this117600__$1.conn,other117601.conn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this117600__$1.network,other117601.network)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this117600__$1.dbid,other117601.dbid)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this117600__$1.db_name,other117601.db_name)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this117600__$1.update_chan,other117601.update_chan)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this117600__$1.transact_chan,other117601.transact_chan)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this117600__$1.state,other117601.state)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this117600__$1.schema_cache,other117601.schema_cache)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this117600__$1.blank_db,other117601.blank_db)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this117600__$1.close,other117601.close)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this117600__$1.id,other117601.id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this117600__$1.__extmap,other117601.__extmap)));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [cljs.core.cst$kw$dbid,null,cljs.core.cst$kw$update_DASH_chan,null,cljs.core.cst$kw$db_DASH_name,null,cljs.core.cst$kw$state,null,cljs.core.cst$kw$close,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$schema_DASH_cache,null,cljs.core.cst$kw$transact_DASH_chan,null,cljs.core.cst$kw$network,null,cljs.core.cst$kw$blank_DASH_db,null,cljs.core.cst$kw$conn,null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__117598){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__117609 = cljs.core.keyword_identical_QMARK_;
var expr__117610 = k__4388__auto__;
if(cljs.core.truth_((function (){var G__117612 = cljs.core.cst$kw$conn;
var G__117613 = expr__117610;
return (pred__117609.cljs$core$IFn$_invoke$arity$2 ? pred__117609.cljs$core$IFn$_invoke$arity$2(G__117612,G__117613) : pred__117609.call(null,G__117612,G__117613));
})())){
return (new fluree.db.session.DbSession(G__117598,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__117614 = cljs.core.cst$kw$network;
var G__117615 = expr__117610;
return (pred__117609.cljs$core$IFn$_invoke$arity$2 ? pred__117609.cljs$core$IFn$_invoke$arity$2(G__117614,G__117615) : pred__117609.call(null,G__117614,G__117615));
})())){
return (new fluree.db.session.DbSession(self__.conn,G__117598,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__117616 = cljs.core.cst$kw$dbid;
var G__117617 = expr__117610;
return (pred__117609.cljs$core$IFn$_invoke$arity$2 ? pred__117609.cljs$core$IFn$_invoke$arity$2(G__117616,G__117617) : pred__117609.call(null,G__117616,G__117617));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,G__117598,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__117618 = cljs.core.cst$kw$db_DASH_name;
var G__117619 = expr__117610;
return (pred__117609.cljs$core$IFn$_invoke$arity$2 ? pred__117609.cljs$core$IFn$_invoke$arity$2(G__117618,G__117619) : pred__117609.call(null,G__117618,G__117619));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,G__117598,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__117620 = cljs.core.cst$kw$update_DASH_chan;
var G__117621 = expr__117610;
return (pred__117609.cljs$core$IFn$_invoke$arity$2 ? pred__117609.cljs$core$IFn$_invoke$arity$2(G__117620,G__117621) : pred__117609.call(null,G__117620,G__117621));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,G__117598,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__117622 = cljs.core.cst$kw$transact_DASH_chan;
var G__117623 = expr__117610;
return (pred__117609.cljs$core$IFn$_invoke$arity$2 ? pred__117609.cljs$core$IFn$_invoke$arity$2(G__117622,G__117623) : pred__117609.call(null,G__117622,G__117623));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,G__117598,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__117624 = cljs.core.cst$kw$state;
var G__117625 = expr__117610;
return (pred__117609.cljs$core$IFn$_invoke$arity$2 ? pred__117609.cljs$core$IFn$_invoke$arity$2(G__117624,G__117625) : pred__117609.call(null,G__117624,G__117625));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,G__117598,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__117626 = cljs.core.cst$kw$schema_DASH_cache;
var G__117627 = expr__117610;
return (pred__117609.cljs$core$IFn$_invoke$arity$2 ? pred__117609.cljs$core$IFn$_invoke$arity$2(G__117626,G__117627) : pred__117609.call(null,G__117626,G__117627));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,G__117598,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__117628 = cljs.core.cst$kw$blank_DASH_db;
var G__117629 = expr__117610;
return (pred__117609.cljs$core$IFn$_invoke$arity$2 ? pred__117609.cljs$core$IFn$_invoke$arity$2(G__117628,G__117629) : pred__117609.call(null,G__117628,G__117629));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,G__117598,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__117630 = cljs.core.cst$kw$close;
var G__117631 = expr__117610;
return (pred__117609.cljs$core$IFn$_invoke$arity$2 ? pred__117609.cljs$core$IFn$_invoke$arity$2(G__117630,G__117631) : pred__117609.call(null,G__117630,G__117631));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,G__117598,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__117632 = cljs.core.cst$kw$id;
var G__117633 = expr__117610;
return (pred__117609.cljs$core$IFn$_invoke$arity$2 ? pred__117609.cljs$core$IFn$_invoke$arity$2(G__117632,G__117633) : pred__117609.call(null,G__117632,G__117633));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,G__117598,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__117598),null));
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$conn,self__.conn,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$network,self__.network,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$dbid,self__.dbid,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$db_DASH_name,self__.db_name,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$update_DASH_chan,self__.update_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$transact_DASH_chan,self__.transact_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$state,self__.state,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$blank_DASH_db,self__.blank_db,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$close,self__.close,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$id,self__.id,null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__117598){
var self__ = this;
var this__4379__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,G__117598,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4386__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(fluree.db.session.DbSession.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$conn,cljs.core.cst$sym$network,cljs.core.cst$sym$dbid,cljs.core.cst$sym$db_DASH_name,cljs.core.cst$sym$update_DASH_chan,cljs.core.cst$sym$transact_DASH_chan,cljs.core.cst$sym$state,cljs.core.cst$sym$schema_DASH_cache,cljs.core.cst$sym$blank_DASH_db,cljs.core.cst$sym$close,cljs.core.cst$sym$id], null);
}));

(fluree.db.session.DbSession.cljs$lang$type = true);

(fluree.db.session.DbSession.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"fluree.db.session/DbSession",null,(1),null));
}));

(fluree.db.session.DbSession.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"fluree.db.session/DbSession");
}));

/**
 * Positional factory function for fluree.db.session/DbSession.
 */
fluree.db.session.__GT_DbSession = (function fluree$db$session$__GT_DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id){
return (new fluree.db.session.DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,null,null,null));
});

/**
 * Factory function for fluree.db.session/DbSession, taking a map of keywords to field values.
 */
fluree.db.session.map__GT_DbSession = (function fluree$db$session$map__GT_DbSession(G__117602){
var extmap__4419__auto__ = (function (){var G__117634 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__117602,cljs.core.cst$kw$conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$db_DASH_name,cljs.core.cst$kw$update_DASH_chan,cljs.core.cst$kw$transact_DASH_chan,cljs.core.cst$kw$state,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$blank_DASH_db,cljs.core.cst$kw$close,cljs.core.cst$kw$id], 0));
if(cljs.core.record_QMARK_(G__117602)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__117634);
} else {
return G__117634;
}
})();
return (new fluree.db.session.DbSession(cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(G__117602),cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(G__117602),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(G__117602),cljs.core.cst$kw$db_DASH_name.cljs$core$IFn$_invoke$arity$1(G__117602),cljs.core.cst$kw$update_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__117602),cljs.core.cst$kw$transact_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__117602),cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(G__117602),cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(G__117602),cljs.core.cst$kw$blank_DASH_db.cljs$core$IFn$_invoke$arity$1(G__117602),cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(G__117602),cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(G__117602),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

fluree.db.session.cache_factory = (function fluree$db$session$cache_factory(){
return cljs.core.PersistentArrayMap.EMPTY;
});
fluree.db.session.session_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.session.cache_factory());
/**
 * Only replaces cache if an existing conn is not already present.
 *   Returns the cached connection.
 */
fluree.db.session.cache_BANG_ = (function fluree$db$session$cache_BANG_(session){
var map__117636 = session;
var map__117636__$1 = (((((!((map__117636 == null))))?(((((map__117636.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__117636.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__117636):map__117636);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__117636__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__117636__$1,cljs.core.cst$kw$dbid);
var cache_key = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(fluree.db.session.session_cache,(function (c){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(c,cache_key))){
return c;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(c,cache_key,session);
}
}));

return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),cache_key);
});
/**
 * Retrieves session from cache.
 */
fluree.db.session.from_cache = (function fluree$db$session$from_cache(network,dbid){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Removes a specific session from cache.
 */
fluree.db.session.remove_cache_BANG_ = (function fluree$db$session$remove_cache_BANG_(network,dbid){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.session.session_cache,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Clears entire session cache. Should not be used under normal circumstances as sessions will not be properly closed.
 */
fluree.db.session.reset_cache_BANG_ = (function fluree$db$session$reset_cache_BANG_(){
return cljs.core.reset_BANG_(fluree.db.session.session_cache,fluree.db.session.cache_factory());
});
fluree.db.session.full_load_existing_db = (function fluree$db$session$full_load_existing_db(session){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__100848__auto___117843 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_117777){
var state_val_117778 = (state_117777[(1)]);
if((state_val_117778 === (7))){
var inst_117660 = (state_117777[(2)]);
var state_117777__$1 = state_117777;
if(cljs.core.truth_(inst_117660)){
var statearr_117779_117844 = state_117777__$1;
(statearr_117779_117844[(1)] = (11));

} else {
var statearr_117780_117845 = state_117777__$1;
(statearr_117780_117845[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117778 === (20))){
var inst_117687 = (state_117777[(2)]);
var inst_117688 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_117689 = [(400),cljs.core.cst$kw$db_SLASH_unavailable];
var inst_117690 = cljs.core.PersistentHashMap.fromArrays(inst_117688,inst_117689);
var inst_117691 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_117687,inst_117690);
var inst_117692 = (function(){throw inst_117691})();
var state_117777__$1 = state_117777;
var statearr_117781_117846 = state_117777__$1;
(statearr_117781_117846[(2)] = inst_117692);

(statearr_117781_117846[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117778 === (27))){
var inst_117705 = (state_117777[(7)]);
var state_117777__$1 = state_117777;
var statearr_117782_117847 = state_117777__$1;
(statearr_117782_117847[(2)] = inst_117705);

(statearr_117782_117847[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117778 === (1))){
var state_117777__$1 = state_117777;
var statearr_117783_117848 = state_117777__$1;
(statearr_117783_117848[(2)] = null);

(statearr_117783_117848[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117778 === (24))){
var inst_117762 = (state_117777[(8)]);
var inst_117762__$1 = (state_117777[(2)]);
var inst_117763 = fluree.db.query.schema.schema_map(inst_117762__$1);
var state_117777__$1 = (function (){var statearr_117784 = state_117777;
(statearr_117784[(8)] = inst_117762__$1);

return statearr_117784;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_117777__$1,(44),inst_117763);
} else {
if((state_val_117778 === (39))){
var inst_117729 = (state_117777[(2)]);
var state_117777__$1 = state_117777;
var statearr_117785_117849 = state_117777__$1;
(statearr_117785_117849[(2)] = inst_117729);

(statearr_117785_117849[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117778 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_117777,(3),cljs.core.cst$kw$default,null,(2));
var inst_117644 = cljs.core.cst$kw$blank_DASH_db.cljs$core$IFn$_invoke$arity$1(session);
var inst_117646 = (session == null);
var inst_117647 = cljs.core.not(inst_117646);
var state_117777__$1 = (function (){var statearr_117786 = state_117777;
(statearr_117786[(9)] = inst_117644);

return statearr_117786;
})();
if(inst_117647){
var statearr_117787_117850 = state_117777__$1;
(statearr_117787_117850[(1)] = (5));

} else {
var statearr_117788_117851 = state_117777__$1;
(statearr_117788_117851[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117778 === (15))){
var inst_117675 = (state_117777[(10)]);
var inst_117680 = cljs.core.empty_QMARK_(inst_117675);
var state_117777__$1 = state_117777;
if(inst_117680){
var statearr_117789_117852 = state_117777__$1;
(statearr_117789_117852[(1)] = (18));

} else {
var statearr_117790_117853 = state_117777__$1;
(statearr_117790_117853[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117778 === (21))){
var inst_117675 = (state_117777[(10)]);
var inst_117700 = (state_117777[(11)]);
var inst_117699 = (state_117777[(2)]);
var inst_117700__$1 = fluree.db.util.async.throw_err(inst_117699);
var inst_117701 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_117675);
var state_117777__$1 = (function (){var statearr_117791 = state_117777;
(statearr_117791[(12)] = inst_117701);

(statearr_117791[(11)] = inst_117700__$1);

return statearr_117791;
})();
if(cljs.core.truth_(inst_117700__$1)){
var statearr_117792_117854 = state_117777__$1;
(statearr_117792_117854[(1)] = (22));

} else {
var statearr_117793_117855 = state_117777__$1;
(statearr_117793_117855[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117778 === (31))){
var inst_117714 = (state_117777[(13)]);
var inst_117718 = (inst_117714 == null);
var inst_117719 = cljs.core.not(inst_117718);
var state_117777__$1 = state_117777;
if(inst_117719){
var statearr_117794_117856 = state_117777__$1;
(statearr_117794_117856[(1)] = (34));

} else {
var statearr_117795_117857 = state_117777__$1;
(statearr_117795_117857[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117778 === (32))){
var inst_117667 = (state_117777[(14)]);
var inst_117668 = (state_117777[(15)]);
var inst_117706 = (state_117777[(16)]);
var inst_117748 = ["Error reading block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_117706)," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_117667),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_117668),"."].join('');
var inst_117749 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_117750 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_117751 = cljs.core.PersistentHashMap.fromArrays(inst_117749,inst_117750);
var inst_117752 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_117748,inst_117751);
var inst_117753 = (function(){throw inst_117752})();
var state_117777__$1 = state_117777;
var statearr_117796_117858 = state_117777__$1;
(statearr_117796_117858[(2)] = inst_117753);

(statearr_117796_117858[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117778 === (40))){
var inst_117714 = (state_117777[(13)]);
var inst_117734 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_117714);
var state_117777__$1 = state_117777;
var statearr_117797_117859 = state_117777__$1;
(statearr_117797_117859[(2)] = inst_117734);

(statearr_117797_117859[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117778 === (33))){
var inst_117755 = (state_117777[(2)]);
var state_117777__$1 = state_117777;
var statearr_117798_117860 = state_117777__$1;
(statearr_117798_117860[(2)] = inst_117755);

(statearr_117798_117860[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117778 === (13))){
var inst_117667 = (state_117777[(14)]);
var inst_117666 = (state_117777[(17)]);
var inst_117668 = (state_117777[(15)]);
var inst_117665 = (state_117777[(2)]);
var inst_117666__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_117665,cljs.core.cst$kw$conn);
var inst_117667__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_117665,cljs.core.cst$kw$network);
var inst_117668__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_117665,cljs.core.cst$kw$dbid);
var inst_117669 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_117670 = [inst_117667__$1,inst_117668__$1];
var inst_117671 = (new cljs.core.PersistentVector(null,2,(5),inst_117669,inst_117670,null));
var inst_117672 = fluree.db.operations.ledger_info_async(inst_117666__$1,inst_117671);
var state_117777__$1 = (function (){var statearr_117799 = state_117777;
(statearr_117799[(14)] = inst_117667__$1);

(statearr_117799[(17)] = inst_117666__$1);

(statearr_117799[(15)] = inst_117668__$1);

return statearr_117799;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_117777__$1,(14),inst_117672);
} else {
if((state_val_117778 === (22))){
var inst_117700 = (state_117777[(11)]);
var inst_117703 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_117700);
var inst_117704 = (inst_117703 + (1));
var inst_117705 = inst_117700;
var inst_117706 = inst_117704;
var state_117777__$1 = (function (){var statearr_117800 = state_117777;
(statearr_117800[(7)] = inst_117705);

(statearr_117800[(16)] = inst_117706);

return statearr_117800;
})();
var statearr_117801_117861 = state_117777__$1;
(statearr_117801_117861[(2)] = null);

(statearr_117801_117861[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117778 === (36))){
var inst_117732 = (state_117777[(2)]);
var state_117777__$1 = state_117777;
if(cljs.core.truth_(inst_117732)){
var statearr_117802_117862 = state_117777__$1;
(statearr_117802_117862[(1)] = (40));

} else {
var statearr_117803_117863 = state_117777__$1;
(statearr_117803_117863[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117778 === (41))){
var inst_117714 = (state_117777[(13)]);
var state_117777__$1 = state_117777;
var statearr_117804_117864 = state_117777__$1;
(statearr_117804_117864[(2)] = inst_117714);

(statearr_117804_117864[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117778 === (43))){
var inst_117706 = (state_117777[(16)]);
var inst_117743 = (state_117777[(2)]);
var inst_117744 = fluree.db.util.async.throw_err(inst_117743);
var inst_117745 = (inst_117706 + (1));
var inst_117705 = inst_117744;
var inst_117706__$1 = inst_117745;
var state_117777__$1 = (function (){var statearr_117805 = state_117777;
(statearr_117805[(7)] = inst_117705);

(statearr_117805[(16)] = inst_117706__$1);

return statearr_117805;
})();
var statearr_117806_117865 = state_117777__$1;
(statearr_117806_117865[(2)] = null);

(statearr_117806_117865[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117778 === (29))){
var inst_117757 = (state_117777[(2)]);
var state_117777__$1 = state_117777;
var statearr_117807_117866 = state_117777__$1;
(statearr_117807_117866[(2)] = inst_117757);

(statearr_117807_117866[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117778 === (44))){
var inst_117762 = (state_117777[(8)]);
var inst_117767 = (state_117777[(18)]);
var inst_117765 = (state_117777[(2)]);
var inst_117766 = fluree.db.util.async.throw_err(inst_117765);
var inst_117767__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_117762,cljs.core.cst$kw$schema,inst_117766);
var inst_117768 = fluree.db.query.schema.setting_map(inst_117767__$1);
var state_117777__$1 = (function (){var statearr_117808 = state_117777;
(statearr_117808[(18)] = inst_117767__$1);

return statearr_117808;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_117777__$1,(45),inst_117768);
} else {
if((state_val_117778 === (6))){
var state_117777__$1 = state_117777;
var statearr_117809_117867 = state_117777__$1;
(statearr_117809_117867[(2)] = false);

(statearr_117809_117867[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117778 === (28))){
var inst_117667 = (state_117777[(14)]);
var inst_117666 = (state_117777[(17)]);
var inst_117668 = (state_117777[(15)]);
var inst_117706 = (state_117777[(16)]);
var inst_117711 = fluree.db.storage.core.read_block(inst_117666,inst_117667,inst_117668,inst_117706);
var state_117777__$1 = state_117777;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_117777__$1,(30),inst_117711);
} else {
if((state_val_117778 === (25))){
var inst_117701 = (state_117777[(12)]);
var inst_117706 = (state_117777[(16)]);
var inst_117708 = (inst_117706 > inst_117701);
var state_117777__$1 = state_117777;
if(cljs.core.truth_(inst_117708)){
var statearr_117810_117868 = state_117777__$1;
(statearr_117810_117868[(1)] = (27));

} else {
var statearr_117811_117869 = state_117777__$1;
(statearr_117811_117869[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117778 === (34))){
var inst_117714 = (state_117777[(13)]);
var inst_117721 = inst_117714.cljs$lang$protocol_mask$partition0$;
var inst_117722 = (inst_117721 & (64));
var inst_117723 = inst_117714.cljs$core$ISeq$;
var inst_117724 = (cljs.core.PROTOCOL_SENTINEL === inst_117723);
var inst_117725 = ((inst_117722) || (inst_117724));
var state_117777__$1 = state_117777;
if(cljs.core.truth_(inst_117725)){
var statearr_117812_117870 = state_117777__$1;
(statearr_117812_117870[(1)] = (37));

} else {
var statearr_117813_117871 = state_117777__$1;
(statearr_117813_117871[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117778 === (17))){
var inst_117675 = (state_117777[(10)]);
var inst_117667 = (state_117777[(14)]);
var inst_117666 = (state_117777[(17)]);
var inst_117668 = (state_117777[(15)]);
var inst_117644 = (state_117777[(9)]);
var inst_117695 = (state_117777[(2)]);
var inst_117696 = cljs.core.cst$kw$index.cljs$core$IFn$_invoke$arity$1(inst_117675);
var inst_117697 = fluree.db.storage.core.reify_db(inst_117666,inst_117667,inst_117668,inst_117644,inst_117696);
var state_117777__$1 = (function (){var statearr_117814 = state_117777;
(statearr_117814[(19)] = inst_117695);

return statearr_117814;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_117777__$1,(21),inst_117697);
} else {
if((state_val_117778 === (3))){
var inst_117638 = (state_117777[(2)]);
var inst_117639 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_117638);
var state_117777__$1 = state_117777;
var statearr_117815_117872 = state_117777__$1;
(statearr_117815_117872[(2)] = inst_117639);


cljs.core.async.impl.ioc_helpers.process_exception(state_117777__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_117778 === (12))){
var state_117777__$1 = state_117777;
var statearr_117816_117873 = state_117777__$1;
(statearr_117816_117873[(2)] = session);

(statearr_117816_117873[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117778 === (2))){
var inst_117775 = (state_117777[(2)]);
var state_117777__$1 = state_117777;
return cljs.core.async.impl.ioc_helpers.return_chan(state_117777__$1,inst_117775);
} else {
if((state_val_117778 === (23))){
var state_117777__$1 = state_117777;
var statearr_117817_117874 = state_117777__$1;
(statearr_117817_117874[(2)] = null);

(statearr_117817_117874[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117778 === (35))){
var state_117777__$1 = state_117777;
var statearr_117818_117875 = state_117777__$1;
(statearr_117818_117875[(2)] = false);

(statearr_117818_117875[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117778 === (19))){
var inst_117675 = (state_117777[(10)]);
var inst_117667 = (state_117777[(14)]);
var inst_117668 = (state_117777[(15)]);
var inst_117684 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_117675);
var inst_117685 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_117667),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_117668)," is not currently available. Status is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_117684),"."].join('');
var state_117777__$1 = state_117777;
var statearr_117819_117876 = state_117777__$1;
(statearr_117819_117876[(2)] = inst_117685);

(statearr_117819_117876[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117778 === (11))){
var inst_117662 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,session);
var state_117777__$1 = state_117777;
var statearr_117820_117877 = state_117777__$1;
(statearr_117820_117877[(2)] = inst_117662);

(statearr_117820_117877[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117778 === (9))){
var state_117777__$1 = state_117777;
var statearr_117821_117878 = state_117777__$1;
(statearr_117821_117878[(2)] = false);

(statearr_117821_117878[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117778 === (5))){
var inst_117649 = session.cljs$lang$protocol_mask$partition0$;
var inst_117650 = (inst_117649 & (64));
var inst_117651 = session.cljs$core$ISeq$;
var inst_117652 = (cljs.core.PROTOCOL_SENTINEL === inst_117651);
var inst_117653 = ((inst_117650) || (inst_117652));
var state_117777__$1 = state_117777;
if(cljs.core.truth_(inst_117653)){
var statearr_117822_117879 = state_117777__$1;
(statearr_117822_117879[(1)] = (8));

} else {
var statearr_117823_117880 = state_117777__$1;
(statearr_117823_117880[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117778 === (14))){
var inst_117675 = (state_117777[(10)]);
var inst_117674 = (state_117777[(2)]);
var inst_117675__$1 = fluree.db.util.async.throw_err(inst_117674);
var inst_117676 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_117675__$1);
var inst_117677 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_117676);
var inst_117678 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$ready,inst_117677);
var state_117777__$1 = (function (){var statearr_117824 = state_117777;
(statearr_117824[(10)] = inst_117675__$1);

return statearr_117824;
})();
if(inst_117678){
var statearr_117825_117881 = state_117777__$1;
(statearr_117825_117881[(1)] = (15));

} else {
var statearr_117826_117882 = state_117777__$1;
(statearr_117826_117882[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117778 === (45))){
var inst_117767 = (state_117777[(18)]);
var inst_117770 = (state_117777[(2)]);
var inst_117771 = fluree.db.util.async.throw_err(inst_117770);
var inst_117772 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_117767,cljs.core.cst$kw$settings,inst_117771);
var inst_117773 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_117772);
var state_117777__$1 = state_117777;
var statearr_117827_117883 = state_117777__$1;
(statearr_117827_117883[(2)] = inst_117773);


cljs.core.async.impl.ioc_helpers.process_exception(state_117777__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_117778 === (26))){
var inst_117759 = (state_117777[(2)]);
var state_117777__$1 = state_117777;
var statearr_117828_117884 = state_117777__$1;
(statearr_117828_117884[(2)] = inst_117759);

(statearr_117828_117884[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117778 === (16))){
var state_117777__$1 = state_117777;
var statearr_117829_117885 = state_117777__$1;
(statearr_117829_117885[(2)] = null);

(statearr_117829_117885[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117778 === (38))){
var state_117777__$1 = state_117777;
var statearr_117830_117886 = state_117777__$1;
(statearr_117830_117886[(2)] = false);

(statearr_117830_117886[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117778 === (30))){
var inst_117714 = (state_117777[(13)]);
var inst_117713 = (state_117777[(2)]);
var inst_117714__$1 = fluree.db.util.async.throw_err(inst_117713);
var state_117777__$1 = (function (){var statearr_117831 = state_117777;
(statearr_117831[(13)] = inst_117714__$1);

return statearr_117831;
})();
if(cljs.core.truth_(inst_117714__$1)){
var statearr_117832_117887 = state_117777__$1;
(statearr_117832_117887[(1)] = (31));

} else {
var statearr_117833_117888 = state_117777__$1;
(statearr_117833_117888[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117778 === (10))){
var inst_117657 = (state_117777[(2)]);
var state_117777__$1 = state_117777;
var statearr_117834_117889 = state_117777__$1;
(statearr_117834_117889[(2)] = inst_117657);

(statearr_117834_117889[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117778 === (18))){
var inst_117667 = (state_117777[(14)]);
var inst_117668 = (state_117777[(15)]);
var inst_117682 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_117667),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_117668)," is not found on this ledger group."].join('');
var state_117777__$1 = state_117777;
var statearr_117835_117890 = state_117777__$1;
(statearr_117835_117890[(2)] = inst_117682);

(statearr_117835_117890[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117778 === (42))){
var inst_117705 = (state_117777[(7)]);
var inst_117737 = (state_117777[(2)]);
var inst_117738 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_117737,cljs.core.cst$kw$flakes);
var inst_117739 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_117737,cljs.core.cst$kw$block);
var inst_117740 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_117737,cljs.core.cst$kw$t);
var inst_117741 = fluree.db.dbproto._with(inst_117705,inst_117739,inst_117738);
var state_117777__$1 = (function (){var statearr_117836 = state_117777;
(statearr_117836[(20)] = inst_117740);

return statearr_117836;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_117777__$1,(43),inst_117741);
} else {
if((state_val_117778 === (37))){
var state_117777__$1 = state_117777;
var statearr_117837_117891 = state_117777__$1;
(statearr_117837_117891[(2)] = true);

(statearr_117837_117891[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117778 === (8))){
var state_117777__$1 = state_117777;
var statearr_117838_117892 = state_117777__$1;
(statearr_117838_117892[(2)] = true);

(statearr_117838_117892[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$full_load_existing_db_$_state_machine__100742__auto__ = null;
var fluree$db$session$full_load_existing_db_$_state_machine__100742__auto____0 = (function (){
var statearr_117839 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_117839[(0)] = fluree$db$session$full_load_existing_db_$_state_machine__100742__auto__);

(statearr_117839[(1)] = (1));

return statearr_117839;
});
var fluree$db$session$full_load_existing_db_$_state_machine__100742__auto____1 = (function (state_117777){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_117777);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e117840){if((e117840 instanceof Object)){
var ex__100745__auto__ = e117840;
var statearr_117841_117893 = state_117777;
(statearr_117841_117893[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_117777);

return cljs.core.cst$kw$recur;
} else {
throw e117840;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__117894 = state_117777;
state_117777 = G__117894;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$session$full_load_existing_db_$_state_machine__100742__auto__ = function(state_117777){
switch(arguments.length){
case 0:
return fluree$db$session$full_load_existing_db_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$session$full_load_existing_db_$_state_machine__100742__auto____1.call(this,state_117777);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$full_load_existing_db_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$full_load_existing_db_$_state_machine__100742__auto____0;
fluree$db$session$full_load_existing_db_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$full_load_existing_db_$_state_machine__100742__auto____1;
return fluree$db$session$full_load_existing_db_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_117842 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_117842[(6)] = c__100848__auto___117843);

return statearr_117842;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));


return pc;
});
/**
 * Performs a compare and set! to update db, but only does so if
 *   existing db promise-chan is the same as old-db-ch.
 * 
 *   Returns true if successful, false if it did not replace.
 */
fluree.db.session.cas_db_BANG_ = (function fluree$db$session$cas_db_BANG_(session,old_db_ch,new_db_ch){
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),(function (state){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(old_db_ch,cljs.core.cst$kw$db_SLASH_db.cljs$core$IFn$_invoke$arity$1(state))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(state,cljs.core.cst$kw$db_SLASH_db,new_db_ch);
} else {
return state;
}
}));
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new_db_ch,cljs.core.cst$kw$db_SLASH_db.cljs$core$IFn$_invoke$arity$1(new_state));
});
/**
 * Clears db from cache, forcing a new full load next time db is requested.
 */
fluree.db.session.clear_db_BANG_ = (function fluree$db$session$clear_db_BANG_(session){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,cljs.core.cst$kw$db_SLASH_db,null);
});
/**
 * Clears any current db that is cached and forces a db reload.
 */
fluree.db.session.reload_db_BANG_ = (function fluree$db$session$reload_db_BANG_(session){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,cljs.core.cst$kw$db_SLASH_db,fluree.db.session.full_load_existing_db(session));
});
/**
 * Returns block currently being indexed (truthy), or nil (falsey) if not currently indexing.
 */
fluree.db.session.indexing_QMARK_ = (function fluree$db$session$indexing_QMARK_(session){
return cljs.core.cst$kw$db_SLASH_indexing.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Returns block of last indexed block, but only for indexing done by this server.
 */
fluree.db.session.indexed = (function fluree$db$session$indexed(session){
return cljs.core.cst$kw$db_SLASH_indexed.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Attempts to acquire indexing lock, and if successful returns true, else false.
 */
fluree.db.session.acquire_indexing_lock_BANG_ = (function fluree$db$session$acquire_indexing_lock_BANG_(session,block){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),(function (s){
var G__117895 = s;
if((cljs.core.cst$kw$db_SLASH_indexing.cljs$core$IFn$_invoke$arity$1(s) == null)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__117895,cljs.core.cst$kw$db_SLASH_indexing,block);
} else {
return G__117895;
}
}));

return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(block,fluree.db.session.indexing_QMARK_(session));
});
/**
 * Releases indexing lock, and updates the last indexed value on the connection with provided block number.
 */
fluree.db.session.release_indexing_lock_BANG_ = (function fluree$db$session$release_indexing_lock_BANG_(session,block){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,cljs.core.cst$kw$db_SLASH_indexing,null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$db_SLASH_indexed,block], 0));
});
fluree.db.session.alias__GT_id_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.cache.lru_cache_factory(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$threshold,(100)], null)));
/**
 * Returns ledger id from alias.
 */
fluree.db.session.ledger_alias__GT_id = (function fluree$db$session$ledger_alias__GT_id(conn,network,alias){
var or__4126__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.alias__GT_id_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var dbid = alias;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.session.alias__GT_id_cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null),dbid);

return dbid;
}
});
/**
 * Resolves a ledger identity in the form of 'network/alias' and returns a
 *   two-tuple of [network ledger-id].
 * 
 *   An alias lookup is always performed first, and if an alias doesn't exist it is assumed
 *   the provided name is a ledger-id.
 * 
 *   If you are providing a ledger-id, and wish to skip an alias lookup, a prefix of '$'
 *   can be used for the name portion of the ledger.
 * 
 *   i.e.
 *   - testnet/testledger - Look for ledger with an alias testledger on network testnet.
 *   - testnet/$testledger - look for a ledger with id testledger on network testnet (skip alias lookup).
 *   - [testnet testledger] - already in form of [network ledger-id]
 */
fluree.db.session.resolve_ledger = (function fluree$db$session$resolve_ledger(conn,ledger){
if(cljs.core.sequential_QMARK_(ledger)){
return ledger;
} else {
var ledger__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(ledger);
var network = cljs.core.namespace(ledger__$1);
var maybe_alias = cljs.core.name(ledger__$1);
var _ = (cljs.core.truth_((function (){var and__4115__auto__ = network;
if(cljs.core.truth_(and__4115__auto__)){
return maybe_alias;
} else {
return and__4115__auto__;
}
})())?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ledger__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_db], null))})());
if(clojure.string.starts_with_QMARK_(maybe_alias,"$")){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,cljs.core.subs.cljs$core$IFn$_invoke$arity$2(maybe_alias,(1))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,fluree.db.session.ledger_alias__GT_id(conn,network,maybe_alias),maybe_alias], null);
}
}
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.session !== 'undefined') && (typeof fluree.db.session.process_ledger_update !== 'undefined')){
} else {
fluree.db.session.process_ledger_update = (function (){var method_table__4619__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4620__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4621__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4622__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4623__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__117896 = cljs.core.get_global_hierarchy;
return (fexpr__117896.cljs$core$IFn$_invoke$arity$0 ? fexpr__117896.cljs$core$IFn$_invoke$arity$0() : fexpr__117896.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("fluree.db.session","process-ledger-update"),(function (_,event_type,___$1){
return event_type;
}),cljs.core.cst$kw$default,hierarchy__4623__auto__,method_table__4619__auto__,prefer_table__4620__auto__,method_cache__4621__auto__,cached_hierarchy__4622__auto__));
})();
}
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$block,(function (session,event_type,p__117898){
var map__117899 = p__117898;
var map__117899__$1 = (((((!((map__117899 == null))))?(((((map__117899.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__117899.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__117899):map__117899);
var data = map__117899__$1;
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__117899__$1,cljs.core.cst$kw$block);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__117899__$1,cljs.core.cst$kw$t);
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__117899__$1,cljs.core.cst$kw$flakes);
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_117945){
var state_val_117946 = (state_117945[(1)]);
if((state_val_117946 === (7))){
var inst_117909 = (state_117945[(7)]);
var inst_117917 = ((1) + inst_117909);
var inst_117918 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_117917);
var state_117945__$1 = state_117945;
if(inst_117918){
var statearr_117947_117970 = state_117945__$1;
(statearr_117947_117970[(1)] = (9));

} else {
var statearr_117948_117971 = state_117945__$1;
(statearr_117948_117971[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117946 === (1))){
var state_117945__$1 = state_117945;
var statearr_117949_117972 = state_117945__$1;
(statearr_117949_117972[(2)] = null);

(statearr_117949_117972[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117946 === (4))){
var inst_117905 = (state_117945[(8)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_117945,(3),Error,null,(2));
var inst_117905__$1 = (fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 ? fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session) : fluree.db.session.current_db.call(null,session));
var state_117945__$1 = (function (){var statearr_117950 = state_117945;
(statearr_117950[(8)] = inst_117905__$1);

return statearr_117950;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_117945__$1,(5),inst_117905__$1);
} else {
if((state_val_117946 === (13))){
var state_117945__$1 = state_117945;
var statearr_117951_117973 = state_117945__$1;
(statearr_117951_117973[(2)] = null);

(statearr_117951_117973[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117946 === (6))){
var inst_117912 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_117913 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_117914 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_117912),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_117913),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but DB is already more current. No-op."].join('');
var inst_117915 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_117914], 0));
var state_117945__$1 = state_117945;
var statearr_117952_117974 = state_117945__$1;
(statearr_117952_117974[(2)] = inst_117915);

(statearr_117952_117974[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117946 === (3))){
var inst_117901 = (state_117945[(2)]);
var state_117945__$1 = state_117945;
var statearr_117953_117975 = state_117945__$1;
(statearr_117953_117975[(2)] = inst_117901);


cljs.core.async.impl.ioc_helpers.process_exception(state_117945__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_117946 === (12))){
var inst_117909 = (state_117945[(7)]);
var inst_117930 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_117931 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_117932 = ["Missing block(s): ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_117930),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_117931),". Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but latest local block is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_117909),". Forcing a db reload."].join('');
var inst_117933 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_117932], 0));
var inst_117934 = fluree.db.session.reload_db_BANG_(session);
var state_117945__$1 = (function (){var statearr_117954 = state_117945;
(statearr_117954[(9)] = inst_117933);

return statearr_117954;
})();
var statearr_117955_117976 = state_117945__$1;
(statearr_117955_117976[(2)] = inst_117934);

(statearr_117955_117976[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117946 === (2))){
var inst_117943 = (state_117945[(2)]);
var state_117945__$1 = state_117945;
return cljs.core.async.impl.ioc_helpers.return_chan(state_117945__$1,inst_117943);
} else {
if((state_val_117946 === (11))){
var inst_117939 = (state_117945[(2)]);
var state_117945__$1 = state_117945;
var statearr_117956_117977 = state_117945__$1;
(statearr_117956_117977[(2)] = inst_117939);

(statearr_117956_117977[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117946 === (9))){
var inst_117908 = (state_117945[(10)]);
var inst_117909 = (state_117945[(7)]);
var inst_117905 = (state_117945[(8)]);
var inst_117920 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_117921 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_117922 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_117920),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_117921),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", DB at that block, update cached db with flakes."].join('');
var inst_117923 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_117922], 0));
var inst_117924 = (function (){var current_db_ch = inst_117905;
var current_db = inst_117908;
var current_block = inst_117909;
return (function (p1__117897_SHARP_){
if((p1__117897_SHARP_ instanceof fluree.db.flake.Flake)){
return p1__117897_SHARP_;
} else {
return fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(p1__117897_SHARP_);
}
});
})();
var inst_117925 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_117924,flakes);
var inst_117926 = fluree.db.dbproto._with(inst_117908,block,inst_117925);
var inst_117927 = fluree.db.session.cas_db_BANG_(session,inst_117905,inst_117926);
var state_117945__$1 = (function (){var statearr_117957 = state_117945;
(statearr_117957[(11)] = inst_117923);

return statearr_117957;
})();
var statearr_117958_117978 = state_117945__$1;
(statearr_117958_117978[(2)] = inst_117927);

(statearr_117958_117978[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117946 === (5))){
var inst_117908 = (state_117945[(10)]);
var inst_117909 = (state_117945[(7)]);
var inst_117907 = (state_117945[(2)]);
var inst_117908__$1 = fluree.db.util.async.throw_err(inst_117907);
var inst_117909__$1 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_117908__$1);
var inst_117910 = (block <= inst_117909__$1);
var state_117945__$1 = (function (){var statearr_117959 = state_117945;
(statearr_117959[(10)] = inst_117908__$1);

(statearr_117959[(7)] = inst_117909__$1);

return statearr_117959;
})();
if(cljs.core.truth_(inst_117910)){
var statearr_117960_117979 = state_117945__$1;
(statearr_117960_117979[(1)] = (6));

} else {
var statearr_117961_117980 = state_117945__$1;
(statearr_117961_117980[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117946 === (14))){
var inst_117937 = (state_117945[(2)]);
var state_117945__$1 = state_117945;
var statearr_117962_117981 = state_117945__$1;
(statearr_117962_117981[(2)] = inst_117937);

(statearr_117962_117981[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117946 === (10))){
var state_117945__$1 = state_117945;
var statearr_117963_117982 = state_117945__$1;
(statearr_117963_117982[(1)] = (12));



return cljs.core.cst$kw$recur;
} else {
if((state_val_117946 === (8))){
var inst_117941 = (state_117945[(2)]);
var state_117945__$1 = state_117945;
var statearr_117965_117983 = state_117945__$1;
(statearr_117965_117983[(2)] = inst_117941);


cljs.core.async.impl.ioc_helpers.process_exception(state_117945__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__100742__auto__ = null;
var fluree$db$session$state_machine__100742__auto____0 = (function (){
var statearr_117966 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_117966[(0)] = fluree$db$session$state_machine__100742__auto__);

(statearr_117966[(1)] = (1));

return statearr_117966;
});
var fluree$db$session$state_machine__100742__auto____1 = (function (state_117945){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_117945);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e117967){if((e117967 instanceof Object)){
var ex__100745__auto__ = e117967;
var statearr_117968_117984 = state_117945;
(statearr_117968_117984[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_117945);

return cljs.core.cst$kw$recur;
} else {
throw e117967;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__117985 = state_117945;
state_117945 = G__117985;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$session$state_machine__100742__auto__ = function(state_117945){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__100742__auto____1.call(this,state_117945);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__100742__auto____0;
fluree$db$session$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__100742__auto____1;
return fluree$db$session$state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_117969 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_117969[(6)] = c__100848__auto__);

return statearr_117969;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$new_DASH_index,(function (session,header,block){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_117992){
var state_val_117993 = (state_117992[(1)]);
if((state_val_117993 === (1))){
var inst_117986 = fluree.db.session.clear_db_BANG_(session);
var inst_117987 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_117988 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_117989 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_117987),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_117988)," re-indexed as of block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_117990 = fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_117989], 0));
var state_117992__$1 = (function (){var statearr_117994 = state_117992;
(statearr_117994[(7)] = inst_117990);

(statearr_117994[(8)] = inst_117986);

return statearr_117994;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_117992__$1,true);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__100742__auto__ = null;
var fluree$db$session$state_machine__100742__auto____0 = (function (){
var statearr_117995 = [null,null,null,null,null,null,null,null,null];
(statearr_117995[(0)] = fluree$db$session$state_machine__100742__auto__);

(statearr_117995[(1)] = (1));

return statearr_117995;
});
var fluree$db$session$state_machine__100742__auto____1 = (function (state_117992){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_117992);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e117996){if((e117996 instanceof Object)){
var ex__100745__auto__ = e117996;
var statearr_117997_117999 = state_117992;
(statearr_117997_117999[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_117992);

return cljs.core.cst$kw$recur;
} else {
throw e117996;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__118000 = state_117992;
state_117992 = G__118000;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$session$state_machine__100742__auto__ = function(state_117992){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__100742__auto____1.call(this,state_117992);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__100742__auto____0;
fluree$db$session$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__100742__auto____1;
return fluree$db$session$state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_117998 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_117998[(6)] = c__100848__auto__);

return statearr_117998;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
}));
fluree.db.session.closed_QMARK_ = (function fluree$db$session$closed_QMARK_(session){
return cljs.core.cst$kw$closed_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Properly shuts down a session.
 *   Returns true if shut down, false if it was already shut down.
 * 
 *   Calling with a session will shut down session, calling with
 *   two arity network + dbid will see if a session is in cache and
 *   then perform the shutdown on the cached session, else will return
 *   false.
 */
fluree.db.session.close = (function fluree$db$session$close(var_args){
var G__118002 = arguments.length;
switch (G__118002) {
case 1:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$1 = (function (session){
if(cljs.core.truth_(fluree.db.session.closed_QMARK_(session))){
return false;
} else {
var map__118003 = session;
var map__118003__$1 = (((((!((map__118003 == null))))?(((((map__118003.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__118003.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__118003):map__118003);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__118003__$1,cljs.core.cst$kw$conn);
var update_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__118003__$1,cljs.core.cst$kw$update_DASH_chan);
var transact_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__118003__$1,cljs.core.cst$kw$transact_DASH_chan);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__118003__$1,cljs.core.cst$kw$state);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__118003__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__118003__$1,cljs.core.cst$kw$dbid);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__118003__$1,cljs.core.cst$kw$id);
var closed_QMARK_ = fluree.db.session.closed_QMARK_(session);
if(cljs.core.truth_(closed_QMARK_)){
fluree.db.session.remove_cache_BANG_(network,dbid);

return false;
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,cljs.core.cst$kw$closed_QMARK_,true);

var fexpr__118005_118008 = cljs.core.cst$kw$remove_DASH_listener.cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__118005_118008.cljs$core$IFn$_invoke$arity$3 ? fexpr__118005_118008.cljs$core$IFn$_invoke$arity$3(network,dbid,id) : fexpr__118005_118008.call(null,network,dbid,id));

cljs.core.async.close_BANG_(update_chan);

if(cljs.core.truth_(transact_chan)){
cljs.core.async.close_BANG_(transact_chan);
} else {
}

fluree.db.session.remove_cache_BANG_(network,dbid);

if(cljs.core.fn_QMARK_(cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(session))){
var fexpr__118006_118009 = cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(session);
(fexpr__118006_118009.cljs$core$IFn$_invoke$arity$0 ? fexpr__118006_118009.cljs$core$IFn$_invoke$arity$0() : fexpr__118006_118009.call(null));
} else {
}

return true;
}
}
}));

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$2 = (function (network,dbid){
var temp__5733__auto__ = fluree.db.session.from_cache(network,dbid);
if(cljs.core.truth_(temp__5733__auto__)){
var session = temp__5733__auto__;
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);
} else {
return false;
}
}));

(fluree.db.session.close.cljs$lang$maxFixedArity = 2);

/**
 * Creates loop that takes new blocks / index commands and processes them in order
 *   ensuring the consistency of the database.
 */
fluree.db.session.process_ledger_updates = (function fluree$db$session$process_ledger_updates(conn,network,ledger_id,update_chan){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_118059){
var state_val_118060 = (state_118059[(1)]);
if((state_val_118060 === (7))){
var inst_118055 = (state_118059[(2)]);
var state_118059__$1 = state_118059;
var statearr_118061_118085 = state_118059__$1;
(statearr_118061_118085[(2)] = inst_118055);

(statearr_118061_118085[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118060 === (1))){
var state_118059__$1 = state_118059;
var statearr_118062_118086 = state_118059__$1;
(statearr_118062_118086[(2)] = null);

(statearr_118062_118086[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118060 === (4))){
var inst_118013 = (state_118059[(7)]);
var inst_118012 = (state_118059[(2)]);
var inst_118013__$1 = fluree.db.util.async.throw_err(inst_118012);
var inst_118014 = fluree.db.session.from_cache(network,ledger_id);
var inst_118015 = (inst_118013__$1 == null);
var state_118059__$1 = (function (){var statearr_118063 = state_118059;
(statearr_118063[(8)] = inst_118014);

(statearr_118063[(7)] = inst_118013__$1);

return statearr_118063;
})();
if(cljs.core.truth_(inst_118015)){
var statearr_118064_118087 = state_118059__$1;
(statearr_118064_118087[(1)] = (5));

} else {
var statearr_118065_118088 = state_118059__$1;
(statearr_118065_118088[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_118060 === (15))){
var inst_118013 = (state_118059[(7)]);
var inst_118028 = (state_118059[(2)]);
var inst_118029 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_118028,"Exception processing ledger updates for message: ",inst_118013], 0));
var state_118059__$1 = state_118059;
var statearr_118066_118089 = state_118059__$1;
(statearr_118066_118089[(2)] = inst_118029);


cljs.core.async.impl.ioc_helpers.process_exception(state_118059__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_118060 === (13))){
var inst_118051 = (state_118059[(2)]);
var state_118059__$1 = state_118059;
var statearr_118067_118090 = state_118059__$1;
(statearr_118067_118090[(2)] = inst_118051);

(statearr_118067_118090[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118060 === (6))){
var inst_118014 = (state_118059[(8)]);
var inst_118020 = (inst_118014 == null);
var state_118059__$1 = state_118059;
if(cljs.core.truth_(inst_118020)){
var statearr_118068_118091 = state_118059__$1;
(statearr_118068_118091[(1)] = (8));

} else {
var statearr_118069_118092 = state_118059__$1;
(statearr_118069_118092[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_118060 === (17))){
var inst_118044 = (state_118059[(2)]);
var inst_118045 = fluree.db.util.async.throw_err(inst_118044);
var state_118059__$1 = state_118059;
var statearr_118070_118093 = state_118059__$1;
(statearr_118070_118093[(2)] = inst_118045);


cljs.core.async.impl.ioc_helpers.process_exception(state_118059__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_118060 === (3))){
var inst_118057 = (state_118059[(2)]);
var state_118059__$1 = state_118059;
return cljs.core.async.impl.ioc_helpers.return_chan(state_118059__$1,inst_118057);
} else {
if((state_val_118060 === (12))){
var state_118059__$1 = state_118059;
var statearr_118071_118094 = state_118059__$1;
(statearr_118071_118094[(2)] = null);

(statearr_118071_118094[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118060 === (2))){
var state_118059__$1 = state_118059;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_118059__$1,(4),update_chan);
} else {
if((state_val_118060 === (11))){
var state_118059__$1 = state_118059;
var statearr_118072_118095 = state_118059__$1;
(statearr_118072_118095[(2)] = null);

(statearr_118072_118095[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118060 === (9))){
var state_118059__$1 = state_118059;
var statearr_118073_118096 = state_118059__$1;
(statearr_118073_118096[(1)] = (11));



return cljs.core.cst$kw$recur;
} else {
if((state_val_118060 === (5))){
var inst_118017 = ["Channel closed for session updates for: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"."].join('');
var inst_118018 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_118017], 0));
var state_118059__$1 = state_118059;
var statearr_118075_118097 = state_118059__$1;
(statearr_118075_118097[(2)] = inst_118018);

(statearr_118075_118097[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118060 === (14))){
var inst_118047 = (state_118059[(2)]);
var state_118059__$1 = (function (){var statearr_118076 = state_118059;
(statearr_118076[(9)] = inst_118047);

return statearr_118076;
})();
var statearr_118077_118098 = state_118059__$1;
(statearr_118077_118098[(2)] = null);

(statearr_118077_118098[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118060 === (16))){
var inst_118014 = (state_118059[(8)]);
var inst_118013 = (state_118059[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_118059,(15),cljs.core.cst$kw$default,null,(14));
var inst_118036 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_118013,(0),null);
var inst_118037 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_118013,(1),null);
var inst_118038 = ["[process-ledger-updates[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"]: "].join('');
var inst_118039 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_118013], 0));
var inst_118040 = fluree.db.util.core.trunc(inst_118039,(200));
var inst_118041 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_118038,inst_118040], 0));
var inst_118042 = (fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3 ? fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3(inst_118014,inst_118036,inst_118037) : fluree.db.session.process_ledger_update.call(null,inst_118014,inst_118036,inst_118037));
var state_118059__$1 = (function (){var statearr_118078 = state_118059;
(statearr_118078[(10)] = inst_118041);

return statearr_118078;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_118059__$1,(17),inst_118042);
} else {
if((state_val_118060 === (10))){
var inst_118053 = (state_118059[(2)]);
var state_118059__$1 = state_118059;
var statearr_118079_118099 = state_118059__$1;
(statearr_118079_118099[(2)] = inst_118053);

(statearr_118079_118099[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118060 === (8))){
var inst_118013 = (state_118059[(7)]);
var inst_118022 = cljs.core.first(inst_118013);
var inst_118023 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_118022], 0));
var inst_118024 = ["Ledger update received for session that is no longer open: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Message: ",inst_118023].join('');
var inst_118025 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_118024], 0));
var state_118059__$1 = state_118059;
var statearr_118080_118100 = state_118059__$1;
(statearr_118080_118100[(2)] = inst_118025);

(statearr_118080_118100[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$process_ledger_updates_$_state_machine__100742__auto__ = null;
var fluree$db$session$process_ledger_updates_$_state_machine__100742__auto____0 = (function (){
var statearr_118081 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_118081[(0)] = fluree$db$session$process_ledger_updates_$_state_machine__100742__auto__);

(statearr_118081[(1)] = (1));

return statearr_118081;
});
var fluree$db$session$process_ledger_updates_$_state_machine__100742__auto____1 = (function (state_118059){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_118059);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e118082){if((e118082 instanceof Object)){
var ex__100745__auto__ = e118082;
var statearr_118083_118101 = state_118059;
(statearr_118083_118101[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_118059);

return cljs.core.cst$kw$recur;
} else {
throw e118082;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__118102 = state_118059;
state_118059 = G__118102;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$session$process_ledger_updates_$_state_machine__100742__auto__ = function(state_118059){
switch(arguments.length){
case 0:
return fluree$db$session$process_ledger_updates_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$session$process_ledger_updates_$_state_machine__100742__auto____1.call(this,state_118059);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$process_ledger_updates_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$process_ledger_updates_$_state_machine__100742__auto____0;
fluree$db$session$process_ledger_updates_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$process_ledger_updates_$_state_machine__100742__auto____1;
return fluree$db$session$process_ledger_updates_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_118084 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_118084[(6)] = c__100848__auto__);

return statearr_118084;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
/**
 * Creates a connection without first checking if db exists. Only useful if reloading
 *   and replacing an existing DB.
 */
fluree.db.session.session_factory = (function fluree$db$session$session_factory(p__118103){
var map__118104 = p__118103;
var map__118104__$1 = (((((!((map__118104 == null))))?(((((map__118104.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__118104.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__118104):map__118104);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__118104__$1,cljs.core.cst$kw$network);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__118104__$1,cljs.core.cst$kw$conn);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__118104__$1,cljs.core.cst$kw$dbid);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__118104__$1,cljs.core.cst$kw$db);
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__118104__$1,cljs.core.cst$kw$transactor_QMARK_);
var db_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__118104__$1,cljs.core.cst$kw$db_DASH_name);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__118104__$1,cljs.core.cst$kw$state);
var close = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__118104__$1,cljs.core.cst$kw$close);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__118104__$1,cljs.core.cst$kw$id);
var schema_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var update_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var transact_chan = (cljs.core.truth_(transactor_QMARK_)?cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0():null);
var state__$1 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([state,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$req_SLASH_sync,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$req_SLASH_count,(0),cljs.core.cst$kw$req_SLASH_last,null,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$db_SLASH_db,(cljs.core.truth_(db)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$schema_DASH_cache,schema_cache):null),cljs.core.cst$kw$db_SLASH_indexing,null,cljs.core.cst$kw$closed_QMARK_,false], null)], 0)));
var session = fluree.db.session.map__GT_DbSession(cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$dbid,cljs.core.cst$kw$update_DASH_chan,cljs.core.cst$kw$db_DASH_name,cljs.core.cst$kw$state,cljs.core.cst$kw$close,cljs.core.cst$kw$id,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$transact_DASH_chan,cljs.core.cst$kw$network,cljs.core.cst$kw$blank_DASH_db,cljs.core.cst$kw$conn],[dbid,update_chan,db_name,state__$1,close,id,schema_cache,transact_chan,network,null,conn]));
var current_db_fn = (function (){
return (fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 ? fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session) : fluree.db.session.current_db.call(null,session));
});
var blank_db = fluree.db.graphdb.blank_db(conn,network,dbid,schema_cache,current_db_fn);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session,cljs.core.cst$kw$blank_DASH_db,blank_db);
});
/**
 * Blocks can have multiple transactions. If we are monitoring a single transaction
 *   we take a full block response and return a map with just that transaction's details.
 *   If the entire block details are desired, the block can be used to retrieve them.
 * 
 *   If throw? is true, throws an exception if non-2xx response.
 */
fluree.db.session.block_response__GT_tx_response = (function fluree$db$session$block_response__GT_tx_response(block_result,txid){
var map__118109 = block_result;
var map__118109__$1 = (((((!((map__118109 == null))))?(((((map__118109.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__118109.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__118109):map__118109);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__118109__$1,cljs.core.cst$kw$block);
var hash = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__118109__$1,cljs.core.cst$kw$hash);
var instant = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__118109__$1,cljs.core.cst$kw$instant);
var txns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__118109__$1,cljs.core.cst$kw$txns);
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__118109__$1,cljs.core.cst$kw$flakes);
var tx_result = (function (){var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(txid));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,txid);
}
})();
var _ = (cljs.core.truth_(tx_result)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Unexpected error, unable to get tx results for txid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(txid)," out of block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join(''),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error,cljs.core.cst$kw$block,cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([block_result], 0))], null))})());
var map__118110 = tx_result;
var map__118110__$1 = (((((!((map__118110 == null))))?(((((map__118110.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__118110.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__118110):map__118110);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__118110__$1,cljs.core.cst$kw$t);
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__118110__$1,cljs.core.cst$kw$status);
var t_filter = (((cljs.core.first(flakes) instanceof fluree.db.flake.Flake))?(function (p1__118106_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,p1__118106_SHARP_.t);
}):(function (p1__118107_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__118107_SHARP_,(3)));
}));
var response = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(tx_result,cljs.core.cst$kw$block,block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$hash,hash,cljs.core.cst$kw$instant,instant,cljs.core.cst$kw$flakes,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(t_filter,flakes)], 0));
if((cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(response) < (300))){
return response;
} else {
var error_msg = cljs.core.some((function (p1__118108_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((109),cljs.core.second(p1__118108_SHARP_))){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__118108_SHARP_,(2));
} else {
return null;
}
}),cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(response));
var vec__118113 = (cljs.core.truth_(error_msg)?cljs.core.re_find(/^([0-9]+) ([^ ]+) (.+)/,error_msg):null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__118113,(0),null);
var status__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__118113,(1),null);
var error = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__118113,(2),null);
var message = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__118113,(3),null);
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var or__4126__auto__ = message;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return "Unknown error.";
}
})(),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(response),cljs.core.cst$kw$error,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(error),cljs.core.cst$kw$meta,response], null));
}
});
/**
 * Creates new session and caches it.
 * 
 *   Will tolerate race conditions, and if this call successfully created the session
 *   it will attach an extra key, :new? true, to the session.
 * 
 *   If another process created the session first, will return the other process' session.
 */
fluree.db.session.create_and_cache_session = (function fluree$db$session$create_and_cache_session(opts){
var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Create and cache session. Opt keys: ",cljs.core.keys(opts)], 0));
var id = fluree.db.util.core.random_uuid();
var session = fluree.db.session.session_factory(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,cljs.core.cst$kw$id,id));
var session_STAR_ = fluree.db.session.cache_BANG_(session);
var new_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(id,cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(session_STAR_));
if(new_QMARK_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session_STAR_,cljs.core.cst$kw$new_QMARK_,true);
} else {
return session_STAR_;
}
});
/**
 * Returns connection to the given ledger, and ensures it is cached.
 * 
 *   If 'state' is provided, it will get merged into the connection's state.
 *   Use namespaced keys, so as to not to create a conflict with system state keys.
 * 
 *   Options supported:
 *   - connect? - attempts to create a streaming connection to db - will fail if db does not exist
 *           - ensure is 'false' if trying to create a new db that does not yet exist.
 *   - state    - initial state map to use
 *   - auth     - the auth
 *   - jwt      - jwt from password login
 *   
 */
fluree.db.session.session = (function fluree$db$session$session(var_args){
var G__118117 = arguments.length;
switch (G__118117) {
case 2:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__118118){
var map__118119 = p__118118;
var map__118119__$1 = (((((!((map__118119 == null))))?(((((map__118119.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__118119.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__118119):map__118119);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__118119__$1,cljs.core.cst$kw$state);
var connect_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__118119__$1,cljs.core.cst$kw$connect_QMARK_);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__118119__$1,cljs.core.cst$kw$auth);
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__118119__$1,cljs.core.cst$kw$jwt);
var vec__118121 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__118121,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__118121,(1),null);
var ledger_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__118121,(2),null);
var connect_QMARK___$1 = ((connect_QMARK_ === false)?false:true);
var transactor_QMARK_ = cljs.core.cst$kw$transactor_QMARK_.cljs$core$IFn$_invoke$arity$1(conn);
var opts = fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$auth,auth,cljs.core.cst$kw$jwt,jwt], null));
var or__4126__auto__ = fluree.db.session.from_cache(network,ledger_id);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var session = fluree.db.session.create_and_cache_session(new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$network,network,cljs.core.cst$kw$dbid,ledger_id,cljs.core.cst$kw$db_DASH_name,null,cljs.core.cst$kw$auth,auth,cljs.core.cst$kw$jwt,jwt,cljs.core.cst$kw$conn,conn,cljs.core.cst$kw$state,(function (){var or__4126__auto____$1 = state;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),cljs.core.cst$kw$transactor_QMARK_,transactor_QMARK_], null));
var new_QMARK_ = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(session) === true;
if(new_QMARK_){
if(connect_QMARK___$1){
fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,opts);

var G__118125_118244 = network;
var G__118126_118245 = ledger_id;
var G__118127_118246 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(session);
var G__118128_118247 = (function (event_type,event_data){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$update_DASH_chan.cljs$core$IFn$_invoke$arity$1(session),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [event_type,event_data], null));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$block,event_type)){
var temp__5735__auto__ = cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)),cljs.core.cst$kw$db_SLASH_pending_DASH_tx));
if(cljs.core.truth_(temp__5735__auto__)){
var tx_callbacks = temp__5735__auto__;
var tids = cljs.core.keys(cljs.core.cst$kw$txns.cljs$core$IFn$_invoke$arity$1(event_data));
var seq__118129 = cljs.core.seq(tids);
var chunk__118130 = null;
var count__118131 = (0);
var i__118132 = (0);
while(true){
if((i__118132 < count__118131)){
var tid = chunk__118130.cljs$core$IIndexed$_nth$arity$2(null,i__118132);
var temp__5735__auto___118249__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5735__auto___118249__$1)){
var keyed_callbacks_118250 = temp__5735__auto___118249__$1;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_118251 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__118173_118252 = cljs.core.seq(keyed_callbacks_118250);
var chunk__118174_118253 = null;
var count__118175_118254 = (0);
var i__118176_118255 = (0);
while(true){
if((i__118176_118255 < count__118175_118254)){
var vec__118185_118256 = chunk__118174_118253.cljs$core$IIndexed$_nth$arity$2(null,i__118176_118255);
var k_118257 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__118185_118256,(0),null);
var f_118258 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__118185_118256,(1),null);
try{(f_118258.cljs$core$IFn$_invoke$arity$1 ? f_118258.cljs$core$IFn$_invoke$arity$1(tx_response_118251) : f_118258.call(null,tx_response_118251));
}catch (e118188){var e_118259 = e118188;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_118259,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__118260 = seq__118173_118252;
var G__118261 = chunk__118174_118253;
var G__118262 = count__118175_118254;
var G__118263 = (i__118176_118255 + (1));
seq__118173_118252 = G__118260;
chunk__118174_118253 = G__118261;
count__118175_118254 = G__118262;
i__118176_118255 = G__118263;
continue;
} else {
var temp__5735__auto___118264__$2 = cljs.core.seq(seq__118173_118252);
if(temp__5735__auto___118264__$2){
var seq__118173_118265__$1 = temp__5735__auto___118264__$2;
if(cljs.core.chunked_seq_QMARK_(seq__118173_118265__$1)){
var c__4556__auto___118266 = cljs.core.chunk_first(seq__118173_118265__$1);
var G__118267 = cljs.core.chunk_rest(seq__118173_118265__$1);
var G__118268 = c__4556__auto___118266;
var G__118269 = cljs.core.count(c__4556__auto___118266);
var G__118270 = (0);
seq__118173_118252 = G__118267;
chunk__118174_118253 = G__118268;
count__118175_118254 = G__118269;
i__118176_118255 = G__118270;
continue;
} else {
var vec__118189_118271 = cljs.core.first(seq__118173_118265__$1);
var k_118272 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__118189_118271,(0),null);
var f_118273 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__118189_118271,(1),null);
try{(f_118273.cljs$core$IFn$_invoke$arity$1 ? f_118273.cljs$core$IFn$_invoke$arity$1(tx_response_118251) : f_118273.call(null,tx_response_118251));
}catch (e118192){var e_118274 = e118192;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_118274,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__118275 = cljs.core.next(seq__118173_118265__$1);
var G__118276 = null;
var G__118277 = (0);
var G__118278 = (0);
seq__118173_118252 = G__118275;
chunk__118174_118253 = G__118276;
count__118175_118254 = G__118277;
i__118176_118255 = G__118278;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__118279 = seq__118129;
var G__118280 = chunk__118130;
var G__118281 = count__118131;
var G__118282 = (i__118132 + (1));
seq__118129 = G__118279;
chunk__118130 = G__118280;
count__118131 = G__118281;
i__118132 = G__118282;
continue;
} else {
var temp__5735__auto____$1 = cljs.core.seq(seq__118129);
if(temp__5735__auto____$1){
var seq__118129__$1 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_(seq__118129__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__118129__$1);
var G__118283 = cljs.core.chunk_rest(seq__118129__$1);
var G__118284 = c__4556__auto__;
var G__118285 = cljs.core.count(c__4556__auto__);
var G__118286 = (0);
seq__118129 = G__118283;
chunk__118130 = G__118284;
count__118131 = G__118285;
i__118132 = G__118286;
continue;
} else {
var tid = cljs.core.first(seq__118129__$1);
var temp__5735__auto___118287__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5735__auto___118287__$2)){
var keyed_callbacks_118288 = temp__5735__auto___118287__$2;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_118289 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__118193_118290 = cljs.core.seq(keyed_callbacks_118288);
var chunk__118194_118291 = null;
var count__118195_118292 = (0);
var i__118196_118293 = (0);
while(true){
if((i__118196_118293 < count__118195_118292)){
var vec__118205_118294 = chunk__118194_118291.cljs$core$IIndexed$_nth$arity$2(null,i__118196_118293);
var k_118295 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__118205_118294,(0),null);
var f_118296 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__118205_118294,(1),null);
try{(f_118296.cljs$core$IFn$_invoke$arity$1 ? f_118296.cljs$core$IFn$_invoke$arity$1(tx_response_118289) : f_118296.call(null,tx_response_118289));
}catch (e118208){var e_118297 = e118208;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_118297,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__118298 = seq__118193_118290;
var G__118299 = chunk__118194_118291;
var G__118300 = count__118195_118292;
var G__118301 = (i__118196_118293 + (1));
seq__118193_118290 = G__118298;
chunk__118194_118291 = G__118299;
count__118195_118292 = G__118300;
i__118196_118293 = G__118301;
continue;
} else {
var temp__5735__auto___118302__$3 = cljs.core.seq(seq__118193_118290);
if(temp__5735__auto___118302__$3){
var seq__118193_118303__$1 = temp__5735__auto___118302__$3;
if(cljs.core.chunked_seq_QMARK_(seq__118193_118303__$1)){
var c__4556__auto___118304 = cljs.core.chunk_first(seq__118193_118303__$1);
var G__118305 = cljs.core.chunk_rest(seq__118193_118303__$1);
var G__118306 = c__4556__auto___118304;
var G__118307 = cljs.core.count(c__4556__auto___118304);
var G__118308 = (0);
seq__118193_118290 = G__118305;
chunk__118194_118291 = G__118306;
count__118195_118292 = G__118307;
i__118196_118293 = G__118308;
continue;
} else {
var vec__118209_118309 = cljs.core.first(seq__118193_118303__$1);
var k_118310 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__118209_118309,(0),null);
var f_118311 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__118209_118309,(1),null);
try{(f_118311.cljs$core$IFn$_invoke$arity$1 ? f_118311.cljs$core$IFn$_invoke$arity$1(tx_response_118289) : f_118311.call(null,tx_response_118289));
}catch (e118212){var e_118312 = e118212;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_118312,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__118313 = cljs.core.next(seq__118193_118303__$1);
var G__118314 = null;
var G__118315 = (0);
var G__118316 = (0);
seq__118193_118290 = G__118313;
chunk__118194_118291 = G__118314;
count__118195_118292 = G__118315;
i__118196_118293 = G__118316;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__118317 = cljs.core.next(seq__118129__$1);
var G__118318 = null;
var G__118319 = (0);
var G__118320 = (0);
seq__118129 = G__118317;
chunk__118130 = G__118318;
count__118131 = G__118319;
i__118132 = G__118320;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
});
var fexpr__118124_118248 = cljs.core.cst$kw$add_DASH_listener.cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__118124_118248.cljs$core$IFn$_invoke$arity$4 ? fexpr__118124_118248.cljs$core$IFn$_invoke$arity$4(G__118125_118244,G__118126_118245,G__118127_118246,G__118128_118247) : fexpr__118124_118248.call(null,G__118125_118244,G__118126_118245,G__118127_118246,G__118128_118247));

fluree.db.session.process_ledger_updates(conn,network,ledger_id,cljs.core.cst$kw$update_DASH_chan.cljs$core$IFn$_invoke$arity$1(session));
} else {
}

if(cljs.core.truth_(transactor_QMARK_)){
var transact_handler_118321 = cljs.core.cst$kw$transact_DASH_handler.cljs$core$IFn$_invoke$arity$1(conn);
var c__100848__auto___118322 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_118229){
var state_val_118230 = (state_118229[(1)]);
if((state_val_118230 === (1))){
var state_118229__$1 = state_118229;
var statearr_118231_118323 = state_118229__$1;
(statearr_118231_118323[(2)] = null);

(statearr_118231_118323[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118230 === (2))){
var inst_118214 = cljs.core.cst$kw$transact_DASH_chan.cljs$core$IFn$_invoke$arity$1(session);
var state_118229__$1 = state_118229;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_118229__$1,(4),inst_118214);
} else {
if((state_val_118230 === (3))){
var inst_118227 = (state_118229[(2)]);
var state_118229__$1 = state_118229;
return cljs.core.async.impl.ioc_helpers.return_chan(state_118229__$1,inst_118227);
} else {
if((state_val_118230 === (4))){
var inst_118216 = (state_118229[(7)]);
var inst_118216__$1 = (state_118229[(2)]);
var inst_118217 = (inst_118216__$1 == null);
var state_118229__$1 = (function (){var statearr_118232 = state_118229;
(statearr_118232[(7)] = inst_118216__$1);

return statearr_118232;
})();
if(cljs.core.truth_(inst_118217)){
var statearr_118233_118324 = state_118229__$1;
(statearr_118233_118324[(1)] = (5));

} else {
var statearr_118234_118325 = state_118229__$1;
(statearr_118234_118325[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_118230 === (5))){
var inst_118219 = ["Transactor session closing for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_alias),"]"].join('');
var inst_118220 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_118219], 0));
var state_118229__$1 = state_118229;
var statearr_118235_118326 = state_118229__$1;
(statearr_118235_118326[(2)] = inst_118220);

(statearr_118235_118326[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118230 === (6))){
var inst_118216 = (state_118229[(7)]);
var inst_118222 = (transact_handler_118321.cljs$core$IFn$_invoke$arity$2 ? transact_handler_118321.cljs$core$IFn$_invoke$arity$2(conn,inst_118216) : transact_handler_118321.call(null,conn,inst_118216));
var state_118229__$1 = (function (){var statearr_118236 = state_118229;
(statearr_118236[(8)] = inst_118222);

return statearr_118236;
})();
var statearr_118237_118327 = state_118229__$1;
(statearr_118237_118327[(2)] = null);

(statearr_118237_118327[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118230 === (7))){
var inst_118225 = (state_118229[(2)]);
var state_118229__$1 = state_118229;
var statearr_118238_118328 = state_118229__$1;
(statearr_118238_118328[(2)] = inst_118225);

(statearr_118238_118328[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__100742__auto__ = null;
var fluree$db$session$state_machine__100742__auto____0 = (function (){
var statearr_118239 = [null,null,null,null,null,null,null,null,null];
(statearr_118239[(0)] = fluree$db$session$state_machine__100742__auto__);

(statearr_118239[(1)] = (1));

return statearr_118239;
});
var fluree$db$session$state_machine__100742__auto____1 = (function (state_118229){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_118229);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e118240){if((e118240 instanceof Object)){
var ex__100745__auto__ = e118240;
var statearr_118241_118329 = state_118229;
(statearr_118241_118329[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_118229);

return cljs.core.cst$kw$recur;
} else {
throw e118240;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__118330 = state_118229;
state_118229 = G__118330;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$session$state_machine__100742__auto__ = function(state_118229){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__100742__auto____1.call(this,state_118229);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__100742__auto____0;
fluree$db$session$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__100742__auto____1;
return fluree$db$session$state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_118242 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_118242[(6)] = c__100848__auto___118322);

return statearr_118242;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

} else {
}
} else {
}

return session;
}
}));

(fluree.db.session.session.cljs$lang$maxFixedArity = 3);

/**
 * Gets the latest db from the central DB atom if available, or loads it from scratch.
 *   DB is returned as a core async promise channel.
 */
fluree.db.session.current_db = (function fluree$db$session$current_db(session){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),(function (p1__118331_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(p1__118331_SHARP_,cljs.core.cst$kw$req_SLASH_last,fluree.db.util.core.current_time_millis(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$req_SLASH_count,(cljs.core.cst$kw$req_SLASH_count.cljs$core$IFn$_invoke$arity$1(p1__118331_SHARP_) + (1))], 0));
}));

var db = cljs.core.cst$kw$db_SLASH_db.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
if((db == null)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(session),cljs.core.empty);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),(function (p1__118332_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__118332_SHARP_,cljs.core.cst$kw$db_SLASH_db,fluree.db.session.full_load_existing_db(session));
}));

return cljs.core.cst$kw$db_SLASH_db.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
} else {
return db;
}
});
/**
 * Creates a session and returns a blank db.
 */
fluree.db.session.blank_db = (function fluree$db$session$blank_db(conn,ledger){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$connect_QMARK_,false], null));
return cljs.core.cst$kw$blank_DASH_db.cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Returns core async channel containing current db
 */
fluree.db.session.db = (function fluree$db$session$db(conn,ledger,opts){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts);
return fluree.db.session.current_db(session);
});
/**
 * Useful for a shutdown process. Closes all sessions for a given connection-id.
 *   If no connection given, closes all sessions.
 */
fluree.db.session.close_all_sessions = (function fluree$db$session$close_all_sessions(var_args){
var G__118335 = arguments.length;
switch (G__118335) {
case 0:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0 = (function (){
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(null);
}));

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
var sessions = (function (){var G__118336 = cljs.core.vals(cljs.core.deref(fluree.db.session.session_cache));
if(cljs.core.truth_(conn_id)){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__118333_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(conn_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(p1__118333_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$id], null)));
}),G__118336);
} else {
return G__118336;
}
})();
var seq__118337 = cljs.core.seq(sessions);
var chunk__118338 = null;
var count__118339 = (0);
var i__118340 = (0);
while(true){
if((i__118340 < count__118339)){
var session = chunk__118338.cljs$core$IIndexed$_nth$arity$2(null,i__118340);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__118342 = seq__118337;
var G__118343 = chunk__118338;
var G__118344 = count__118339;
var G__118345 = (i__118340 + (1));
seq__118337 = G__118342;
chunk__118338 = G__118343;
count__118339 = G__118344;
i__118340 = G__118345;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__118337);
if(temp__5735__auto__){
var seq__118337__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__118337__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__118337__$1);
var G__118346 = cljs.core.chunk_rest(seq__118337__$1);
var G__118347 = c__4556__auto__;
var G__118348 = cljs.core.count(c__4556__auto__);
var G__118349 = (0);
seq__118337 = G__118346;
chunk__118338 = G__118347;
count__118339 = G__118348;
i__118340 = G__118349;
continue;
} else {
var session = cljs.core.first(seq__118337__$1);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__118350 = cljs.core.next(seq__118337__$1);
var G__118351 = null;
var G__118352 = (0);
var G__118353 = (0);
seq__118337 = G__118350;
chunk__118338 = G__118351;
count__118339 = G__118352;
i__118340 = G__118353;
continue;
}
} else {
return null;
}
}
break;
}
}));

(fluree.db.session.close_all_sessions.cljs$lang$maxFixedArity = 1);

/**
 * Adds a callback function to call when we see a completed transaction in a block
 *   for the given tid.
 * 
 *   Key is any arbitrary key provided that allows the callback to be unregistered later
 *   with monitor-tx-remove. It must be unique.
 */
fluree.db.session.monitor_tx = (function fluree$db$session$monitor_tx(session,tid,key,f){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$db_SLASH_pending_DASH_tx,tid,key], null),(function (x){
if(cljs.core.truth_(x)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Key provided to monitor-tx must be unique.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_request], null));
} else {
}

return f;
}));
});
/**
 * Removes callback from supplied transaction id and key.
 * 
 *   Will return true if callback successfully removed, else false if
 *   callback didn't exist.
 */
fluree.db.session.monitor_tx_remove = (function fluree$db$session$monitor_tx_remove(session,tid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$db_SLASH_pending_DASH_tx,tid,key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,(function (pending_txs){
var updated = cljs.core.update.cljs$core$IFn$_invoke$arity$4(pending_txs,tid,cljs.core.dissoc,key);
if(cljs.core.empty_QMARK_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(updated,tid))){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(updated,tid);
} else {
return updated;
}
}));

return true;
} else {
return false;
}
});
