// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true}
goog.provide('fluree.db.query.schema');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.schema');
/**
 * Takes an predicate name (string) and returns the namespace portion of it as a keyword.
 */
fluree.db.query.schema.pred_name__GT_keyword = (function fluree$db$query$schema$pred_name__GT_keyword(pred_name){
if(typeof pred_name === 'string'){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.re_find(/[^\/]+$/,pred_name));
} else {
return null;
}
});
/**
 * Converts a tag sid for a _predicate/type attributes into a keyword of just the 'name'.
 */
fluree.db.query.schema.convert_type_to_kw = (function fluree$db$query$schema$convert_type_to_kw(type_tag_sid,db){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_105323){
var state_val_105324 = (state_105323[(1)]);
if((state_val_105324 === (1))){
var state_105323__$1 = state_105323;
var statearr_105325_105332 = state_105323__$1;
(statearr_105325_105332[(2)] = null);

(statearr_105325_105332[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105324 === (2))){
var inst_105321 = (state_105323[(2)]);
var state_105323__$1 = state_105323;
return cljs.core.async.impl.ioc_helpers.return_chan(state_105323__$1,inst_105321);
} else {
if((state_val_105324 === (3))){
var inst_105311 = (state_105323[(2)]);
var state_105323__$1 = state_105323;
var statearr_105326_105333 = state_105323__$1;
(statearr_105326_105333[(2)] = inst_105311);


cljs.core.async.impl.ioc_helpers.process_exception(state_105323__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_105324 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_105323,(3),Error,null,(2));
var inst_105315 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,type_tag_sid,"_predicate/type");
var state_105323__$1 = state_105323;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_105323__$1,(5),inst_105315);
} else {
if((state_val_105324 === (5))){
var inst_105317 = (state_105323[(2)]);
var inst_105318 = fluree.db.util.async.throw_err(inst_105317);
var inst_105319 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_105318);
var state_105323__$1 = state_105323;
var statearr_105327_105334 = state_105323__$1;
(statearr_105327_105334[(2)] = inst_105319);


cljs.core.async.impl.ioc_helpers.process_exception(state_105323__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__100742__auto__ = null;
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__100742__auto____0 = (function (){
var statearr_105328 = [null,null,null,null,null,null,null];
(statearr_105328[(0)] = fluree$db$query$schema$convert_type_to_kw_$_state_machine__100742__auto__);

(statearr_105328[(1)] = (1));

return statearr_105328;
});
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__100742__auto____1 = (function (state_105323){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_105323);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e105329){if((e105329 instanceof Object)){
var ex__100745__auto__ = e105329;
var statearr_105330_105335 = state_105323;
(statearr_105330_105335[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_105323);

return cljs.core.cst$kw$recur;
} else {
throw e105329;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__105336 = state_105323;
state_105323 = G__105336;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$query$schema$convert_type_to_kw_$_state_machine__100742__auto__ = function(state_105323){
switch(arguments.length){
case 0:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__100742__auto____1.call(this,state_105323);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$convert_type_to_kw_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__100742__auto____0;
fluree$db$query$schema$convert_type_to_kw_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__100742__auto____1;
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_105331 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_105331[(6)] = c__100848__auto__);

return statearr_105331;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
fluree.db.query.schema.pred_objects_unique_QMARK_ = (function fluree$db$query$schema$pred_objects_unique_QMARK_(db,pred_id){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_105365){
var state_val_105366 = (state_105365[(1)]);
if((state_val_105366 === (7))){
var inst_105350 = (state_105365[(7)]);
var state_105365__$1 = state_105365;
var statearr_105367_105384 = state_105365__$1;
(statearr_105367_105384[(2)] = inst_105350);

(statearr_105367_105384[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105366 === (1))){
var state_105365__$1 = state_105365;
var statearr_105368_105385 = state_105365__$1;
(statearr_105368_105385[(2)] = null);

(statearr_105368_105385[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105366 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_105365,(3),Error,null,(2));
var inst_105342 = (function (){return (function (p1__105337_SHARP_){
return p1__105337_SHARP_.o;
});
})();
var inst_105343 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_105344 = [pred_id];
var inst_105345 = (new cljs.core.PersistentVector(null,1,(5),inst_105343,inst_105344,null));
var inst_105346 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_105345);
var state_105365__$1 = (function (){var statearr_105369 = state_105365;
(statearr_105369[(8)] = inst_105342);

return statearr_105369;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_105365__$1,(5),inst_105346);
} else {
if((state_val_105366 === (6))){
var inst_105350 = (state_105365[(7)]);
var inst_105352 = cljs.core.empty_QMARK_(inst_105350);
var inst_105353 = (!(inst_105352));
var state_105365__$1 = state_105365;
var statearr_105370_105386 = state_105365__$1;
(statearr_105370_105386[(2)] = inst_105353);

(statearr_105370_105386[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105366 === (3))){
var inst_105338 = (state_105365[(2)]);
var state_105365__$1 = state_105365;
var statearr_105371_105387 = state_105365__$1;
(statearr_105371_105387[(2)] = inst_105338);


cljs.core.async.impl.ioc_helpers.process_exception(state_105365__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_105366 === (2))){
var inst_105363 = (state_105365[(2)]);
var state_105365__$1 = state_105365;
return cljs.core.async.impl.ioc_helpers.return_chan(state_105365__$1,inst_105363);
} else {
if((state_val_105366 === (11))){
var inst_105361 = (state_105365[(2)]);
var state_105365__$1 = state_105365;
var statearr_105372_105388 = state_105365__$1;
(statearr_105372_105388[(2)] = inst_105361);


cljs.core.async.impl.ioc_helpers.process_exception(state_105365__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_105366 === (9))){
var inst_105350 = (state_105365[(7)]);
var inst_105358 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,inst_105350);
var state_105365__$1 = state_105365;
var statearr_105373_105389 = state_105365__$1;
(statearr_105373_105389[(2)] = inst_105358);

(statearr_105373_105389[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105366 === (5))){
var inst_105342 = (state_105365[(8)]);
var inst_105350 = (state_105365[(7)]);
var inst_105348 = (state_105365[(2)]);
var inst_105349 = fluree.db.util.async.throw_err(inst_105348);
var inst_105350__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_105342,inst_105349);
var state_105365__$1 = (function (){var statearr_105374 = state_105365;
(statearr_105374[(7)] = inst_105350__$1);

return statearr_105374;
})();
if(cljs.core.truth_(inst_105350__$1)){
var statearr_105375_105390 = state_105365__$1;
(statearr_105375_105390[(1)] = (6));

} else {
var statearr_105376_105391 = state_105365__$1;
(statearr_105376_105391[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105366 === (10))){
var state_105365__$1 = state_105365;
var statearr_105377_105392 = state_105365__$1;
(statearr_105377_105392[(2)] = true);

(statearr_105377_105392[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105366 === (8))){
var inst_105356 = (state_105365[(2)]);
var state_105365__$1 = state_105365;
if(cljs.core.truth_(inst_105356)){
var statearr_105378_105393 = state_105365__$1;
(statearr_105378_105393[(1)] = (9));

} else {
var statearr_105379_105394 = state_105365__$1;
(statearr_105379_105394[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__100742__auto__ = null;
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__100742__auto____0 = (function (){
var statearr_105380 = [null,null,null,null,null,null,null,null,null];
(statearr_105380[(0)] = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__100742__auto__);

(statearr_105380[(1)] = (1));

return statearr_105380;
});
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__100742__auto____1 = (function (state_105365){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_105365);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e105381){if((e105381 instanceof Object)){
var ex__100745__auto__ = e105381;
var statearr_105382_105395 = state_105365;
(statearr_105382_105395[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_105365);

return cljs.core.cst$kw$recur;
} else {
throw e105381;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__105396 = state_105365;
state_105365 = G__105396;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__100742__auto__ = function(state_105365){
switch(arguments.length){
case 0:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__100742__auto____1.call(this,state_105365);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__100742__auto____0;
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__100742__auto____1;
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_105383 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_105383[(6)] = c__100848__auto__);

return statearr_105383;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
/**
 * Returns a map of predicate changes with their respective old
 *   value and new value, both the key and value of the map are two-tuples as follows:
 *   {subid  {:new?  true
 *        :type  {:old :int :new :long}
 *        :index {:old nil  :new true }}}
 * 
 *   If the predicate being changed is the :type, it resolves the type _tag to its short keyword name
 * 
 *   When an old value does not exist, old-val is nil.
 *   If they subject being created is completely new, :new? true 
 */
fluree.db.query.schema.new_pred_changes = (function fluree$db$query$schema$new_pred_changes(db,tempids,flakes){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_105470){
var state_val_105471 = (state_105470[(1)]);
if((state_val_105471 === (7))){
var inst_105421 = (state_105470[(7)]);
var state_105470__$1 = state_105470;
var statearr_105472_105499 = state_105470__$1;
(statearr_105472_105499[(2)] = inst_105421);

(statearr_105472_105499[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105471 === (1))){
var state_105470__$1 = state_105470;
var statearr_105473_105500 = state_105470__$1;
(statearr_105473_105500[(2)] = null);

(statearr_105473_105500[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105471 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_105470,(3),Error,null,(2));
var inst_105403 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
var inst_105404 = cljs.core.PersistentHashSet.EMPTY;
var inst_105405 = cljs.core.vals(tempids);
var inst_105406 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_105404,inst_105405);
var inst_105407 = (function (){var pred_flakes = inst_105403;
var is_new_QMARK_ = inst_105406;
return (function (p1__105397_SHARP_,p2__105398_SHARP_){
return cljs.core.assoc_in(p1__105397_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2__105398_SHARP_.s,cljs.core.cst$kw$new_QMARK_], null),cljs.core.boolean$((function (){var G__105474 = p2__105398_SHARP_.s;
return (is_new_QMARK_.cljs$core$IFn$_invoke$arity$1 ? is_new_QMARK_.cljs$core$IFn$_invoke$arity$1(G__105474) : is_new_QMARK_.call(null,G__105474));
})()));
});
})();
var inst_105408 = cljs.core.PersistentHashMap.EMPTY;
var inst_105409 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_105407,inst_105408,inst_105403);
var inst_105417 = cljs.core.seq(inst_105403);
var inst_105418 = cljs.core.first(inst_105417);
var inst_105419 = cljs.core.next(inst_105417);
var inst_105420 = inst_105403;
var inst_105421 = inst_105409;
var state_105470__$1 = (function (){var statearr_105475 = state_105470;
(statearr_105475[(8)] = inst_105418);

(statearr_105475[(7)] = inst_105421);

(statearr_105475[(9)] = inst_105419);

(statearr_105475[(10)] = inst_105420);

return statearr_105475;
})();
var statearr_105476_105501 = state_105470__$1;
(statearr_105476_105501[(2)] = null);

(statearr_105476_105501[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105471 === (15))){
var inst_105434 = (state_105470[(11)]);
var inst_105421 = (state_105470[(7)]);
var inst_105447 = (state_105470[(12)]);
var inst_105427 = (state_105470[(13)]);
var inst_105455 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_105456 = inst_105427.s;
var inst_105457 = [inst_105456,inst_105434,cljs.core.cst$kw$new];
var inst_105458 = (new cljs.core.PersistentVector(null,3,(5),inst_105455,inst_105457,null));
var inst_105459 = cljs.core.assoc_in(inst_105421,inst_105458,inst_105447);
var state_105470__$1 = state_105470;
var statearr_105477_105502 = state_105470__$1;
(statearr_105477_105502[(2)] = inst_105459);

(statearr_105477_105502[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105471 === (13))){
var inst_105442 = (state_105470[(2)]);
var inst_105443 = fluree.db.util.async.throw_err(inst_105442);
var state_105470__$1 = state_105470;
var statearr_105478_105503 = state_105470__$1;
(statearr_105478_105503[(2)] = inst_105443);

(statearr_105478_105503[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105471 === (6))){
var inst_105466 = (state_105470[(2)]);
var state_105470__$1 = state_105470;
var statearr_105479_105504 = state_105470__$1;
(statearr_105479_105504[(2)] = inst_105466);


cljs.core.async.impl.ioc_helpers.process_exception(state_105470__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_105471 === (3))){
var inst_105399 = (state_105470[(2)]);
var state_105470__$1 = state_105470;
var statearr_105480_105505 = state_105470__$1;
(statearr_105480_105505[(2)] = inst_105399);


cljs.core.async.impl.ioc_helpers.process_exception(state_105470__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_105471 === (12))){
var inst_105436 = (state_105470[(14)]);
var inst_105447 = (state_105470[(2)]);
var state_105470__$1 = (function (){var statearr_105481 = state_105470;
(statearr_105481[(12)] = inst_105447);

return statearr_105481;
})();
if(cljs.core.truth_(inst_105436)){
var statearr_105482_105506 = state_105470__$1;
(statearr_105482_105506[(1)] = (14));

} else {
var statearr_105483_105507 = state_105470__$1;
(statearr_105483_105507[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105471 === (2))){
var inst_105468 = (state_105470[(2)]);
var state_105470__$1 = state_105470;
return cljs.core.async.impl.ioc_helpers.return_chan(state_105470__$1,inst_105468);
} else {
if((state_val_105471 === (11))){
var inst_105427 = (state_105470[(13)]);
var inst_105445 = inst_105427.o;
var state_105470__$1 = state_105470;
var statearr_105484_105508 = state_105470__$1;
(statearr_105484_105508[(2)] = inst_105445);

(statearr_105484_105508[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105471 === (9))){
var inst_105464 = (state_105470[(2)]);
var state_105470__$1 = state_105470;
var statearr_105485_105509 = state_105470__$1;
(statearr_105485_105509[(2)] = inst_105464);

(statearr_105485_105509[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105471 === (5))){
var inst_105427 = (state_105470[(13)]);
var inst_105420 = (state_105470[(10)]);
var inst_105426 = cljs.core.seq(inst_105420);
var inst_105427__$1 = cljs.core.first(inst_105426);
var inst_105428 = cljs.core.next(inst_105426);
var inst_105429 = cljs.core.not(inst_105427__$1);
var state_105470__$1 = (function (){var statearr_105486 = state_105470;
(statearr_105486[(15)] = inst_105428);

(statearr_105486[(13)] = inst_105427__$1);

return statearr_105486;
})();
if(inst_105429){
var statearr_105487_105510 = state_105470__$1;
(statearr_105487_105510[(1)] = (7));

} else {
var statearr_105488_105511 = state_105470__$1;
(statearr_105488_105511[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105471 === (14))){
var inst_105434 = (state_105470[(11)]);
var inst_105421 = (state_105470[(7)]);
var inst_105447 = (state_105470[(12)]);
var inst_105427 = (state_105470[(13)]);
var inst_105449 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_105450 = inst_105427.s;
var inst_105451 = [inst_105450,inst_105434,cljs.core.cst$kw$old];
var inst_105452 = (new cljs.core.PersistentVector(null,3,(5),inst_105449,inst_105451,null));
var inst_105453 = cljs.core.assoc_in(inst_105421,inst_105452,inst_105447);
var state_105470__$1 = state_105470;
var statearr_105489_105512 = state_105470__$1;
(statearr_105489_105512[(2)] = inst_105453);

(statearr_105489_105512[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105471 === (16))){
var inst_105428 = (state_105470[(15)]);
var inst_105461 = (state_105470[(2)]);
var inst_105420 = inst_105428;
var inst_105421 = inst_105461;
var state_105470__$1 = (function (){var statearr_105490 = state_105470;
(statearr_105490[(7)] = inst_105421);

(statearr_105490[(10)] = inst_105420);

return statearr_105490;
})();
var statearr_105491_105513 = state_105470__$1;
(statearr_105491_105513[(2)] = null);

(statearr_105491_105513[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105471 === (10))){
var inst_105427 = (state_105470[(13)]);
var inst_105439 = inst_105427.o;
var inst_105440 = fluree.db.query.schema.convert_type_to_kw(inst_105439,db);
var state_105470__$1 = state_105470;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_105470__$1,(13),inst_105440);
} else {
if((state_val_105471 === (8))){
var inst_105434 = (state_105470[(11)]);
var inst_105427 = (state_105470[(13)]);
var inst_105432 = inst_105427.p;
var inst_105433 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,inst_105432);
var inst_105434__$1 = fluree.db.query.schema.pred_name__GT_keyword(inst_105433);
var inst_105435 = inst_105427.op;
var inst_105436 = inst_105435 === false;
var inst_105437 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$type,inst_105434__$1);
var state_105470__$1 = (function (){var statearr_105492 = state_105470;
(statearr_105492[(11)] = inst_105434__$1);

(statearr_105492[(14)] = inst_105436);

return statearr_105492;
})();
if(inst_105437){
var statearr_105493_105514 = state_105470__$1;
(statearr_105493_105514[(1)] = (10));

} else {
var statearr_105494_105515 = state_105470__$1;
(statearr_105494_105515[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$new_pred_changes_$_state_machine__100742__auto__ = null;
var fluree$db$query$schema$new_pred_changes_$_state_machine__100742__auto____0 = (function (){
var statearr_105495 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_105495[(0)] = fluree$db$query$schema$new_pred_changes_$_state_machine__100742__auto__);

(statearr_105495[(1)] = (1));

return statearr_105495;
});
var fluree$db$query$schema$new_pred_changes_$_state_machine__100742__auto____1 = (function (state_105470){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_105470);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e105496){if((e105496 instanceof Object)){
var ex__100745__auto__ = e105496;
var statearr_105497_105516 = state_105470;
(statearr_105497_105516[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_105470);

return cljs.core.cst$kw$recur;
} else {
throw e105496;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__105517 = state_105470;
state_105470 = G__105517;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$query$schema$new_pred_changes_$_state_machine__100742__auto__ = function(state_105470){
switch(arguments.length){
case 0:
return fluree$db$query$schema$new_pred_changes_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$query$schema$new_pred_changes_$_state_machine__100742__auto____1.call(this,state_105470);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$new_pred_changes_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$new_pred_changes_$_state_machine__100742__auto____0;
fluree$db$query$schema$new_pred_changes_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$new_pred_changes_$_state_machine__100742__auto____1;
return fluree$db$query$schema$new_pred_changes_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_105498 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_105498[(6)] = c__100848__auto__);

return statearr_105498;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
/**
 * Throw an error if schema update attempt is invalid.
 */
fluree.db.query.schema.type_error = (function fluree$db$query$schema$type_error(var_args){
var G__105519 = arguments.length;
switch (G__105519) {
case 3:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3 = (function (current_type,new_type,throw_QMARK_){
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(null,current_type,new_type,throw_QMARK_);
}));

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4 = (function (db,current_type,new_type,throw_QMARK_){
var message = ["Cannot convert an _predicate from ",cljs.core.name(current_type)," to ",cljs.core.name(new_type),"."].join('');
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_tx], null));
} else {
return db;
}
}));

(fluree.db.query.schema.type_error.cljs$lang$maxFixedArity = 4);

/**
 * Accepts a db (should have root permissions) and a map of predicate changes as produced by new-pred-changes.
 *   Returns a db with updated idxs if relevant, i.e. if non-unique predicate converted to unique
 *   If optional throw? parameter is true, will throw with an ex-info error.
 */
fluree.db.query.schema.predicate_change_error = (function fluree$db$query$schema$predicate_change_error(var_args){
var G__105522 = arguments.length;
switch (G__105522) {
case 2:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2 = (function (pred_changes,db){
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(pred_changes,db,false);
}));

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3 = (function (pred_changes,db,throw_QMARK_){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_105826){
var state_val_105827 = (state_105826[(1)]);
if((state_val_105827 === (65))){
var inst_105690 = (state_105826[(7)]);
var state_105826__$1 = state_105826;
var G__105828_105993 = inst_105690;
var G__105828_105994__$1 = (((G__105828_105993 instanceof cljs.core.Keyword))?G__105828_105993.fqn:null);
switch (G__105828_105994__$1) {
case "long":
var statearr_105829_105996 = state_105826__$1;
(statearr_105829_105996[(1)] = (69));


break;
case "bigint":
var statearr_105830_105997 = state_105826__$1;
(statearr_105830_105997[(1)] = (73));


break;
case "double":
var statearr_105831_105998 = state_105826__$1;
(statearr_105831_105998[(1)] = (77));


break;
case "float":
var statearr_105832_105999 = state_105826__$1;
(statearr_105832_105999[(1)] = (81));


break;
case "bigdec":
var statearr_105833_106000 = state_105826__$1;
(statearr_105833_106000[(1)] = (85));


break;
case "string":
var statearr_105834_106001 = state_105826__$1;
(statearr_105834_106001[(1)] = (89));


break;
case "instant":
var statearr_105835_106002 = state_105826__$1;
(statearr_105835_106002[(1)] = (93));


break;
default:
var statearr_105836_106003 = state_105826__$1;
(statearr_105836_106003[(1)] = (97));



}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (70))){
var inst_105657 = (state_105826[(8)]);
var state_105826__$1 = state_105826;
var statearr_105837_106004 = state_105826__$1;
(statearr_105837_106004[(2)] = inst_105657);

(statearr_105837_106004[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (62))){
var inst_105689 = (state_105826[(9)]);
var inst_105690 = (state_105826[(7)]);
var inst_105699 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_105689,inst_105690,throw_QMARK_);
var state_105826__$1 = state_105826;
var statearr_105838_106005 = state_105826__$1;
(statearr_105838_106005[(2)] = inst_105699);

(statearr_105838_106005[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (74))){
var inst_105657 = (state_105826[(8)]);
var state_105826__$1 = state_105826;
var statearr_105839_106006 = state_105826__$1;
(statearr_105839_106006[(2)] = inst_105657);

(statearr_105839_106006[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (7))){
var inst_105546 = (state_105826[(10)]);
var state_105826__$1 = state_105826;
var statearr_105840_106007 = state_105826__$1;
(statearr_105840_106007[(2)] = inst_105546);

(statearr_105840_106007[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (59))){
var inst_105657 = (state_105826[(8)]);
var state_105826__$1 = state_105826;
var statearr_105841_106008 = state_105826__$1;
(statearr_105841_106008[(2)] = inst_105657);

(statearr_105841_106008[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (86))){
var inst_105657 = (state_105826[(8)]);
var state_105826__$1 = state_105826;
var statearr_105842_106009 = state_105826__$1;
(statearr_105842_106009[(2)] = inst_105657);

(statearr_105842_106009[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (20))){
var inst_105581 = (state_105826[(11)]);
var state_105826__$1 = state_105826;
var statearr_105843_106010 = state_105826__$1;
(statearr_105843_106010[(2)] = inst_105581);

(statearr_105843_106010[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (72))){
var inst_105710 = (state_105826[(2)]);
var state_105826__$1 = state_105826;
var statearr_105844_106011 = state_105826__$1;
(statearr_105844_106011[(2)] = inst_105710);

(statearr_105844_106011[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (58))){
var inst_105689 = (state_105826[(9)]);
var inst_105690 = (state_105826[(7)]);
var inst_105688 = (state_105826[(2)]);
var inst_105689__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_105688,cljs.core.cst$kw$old);
var inst_105690__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_105688,cljs.core.cst$kw$new);
var inst_105691 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_105690__$1,inst_105689__$1);
var state_105826__$1 = (function (){var statearr_105845 = state_105826;
(statearr_105845[(9)] = inst_105689__$1);

(statearr_105845[(7)] = inst_105690__$1);

return statearr_105845;
})();
if(inst_105691){
var statearr_105846_106012 = state_105826__$1;
(statearr_105846_106012[(1)] = (59));

} else {
var statearr_105847_106013 = state_105826__$1;
(statearr_105847_106013[(1)] = (60));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (60))){
var inst_105689 = (state_105826[(9)]);
var inst_105690 = (state_105826[(7)]);
var inst_105694 = [cljs.core.cst$kw$bigint,null,cljs.core.cst$kw$string,null,cljs.core.cst$kw$bigdec,null];
var inst_105695 = (inst_105690.cljs$core$IFn$_invoke$arity$5 ? inst_105690.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_105694,null) : inst_105690.call(null,cljs.core.PersistentArrayMap,null,3,inst_105694,null));
var inst_105696 = (inst_105690.cljs$core$IFn$_invoke$arity$4 ? inst_105690.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_105695,null) : inst_105690.call(null,cljs.core.PersistentHashSet,null,inst_105695,null));
var inst_105697 = (inst_105696.cljs$core$IFn$_invoke$arity$1 ? inst_105696.cljs$core$IFn$_invoke$arity$1(inst_105689) : inst_105696.call(null,inst_105689));
var state_105826__$1 = state_105826;
if(cljs.core.truth_(inst_105697)){
var statearr_105848_106014 = state_105826__$1;
(statearr_105848_106014[(1)] = (62));

} else {
var statearr_105849_106015 = state_105826__$1;
(statearr_105849_106015[(1)] = (63));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (27))){
var inst_105607 = (state_105826[(2)]);
var state_105826__$1 = state_105826;
var statearr_105850_106016 = state_105826__$1;
(statearr_105850_106016[(2)] = inst_105607);

(statearr_105850_106016[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (1))){
var state_105826__$1 = state_105826;
var statearr_105851_106017 = state_105826__$1;
(statearr_105851_106017[(2)] = null);

(statearr_105851_106017[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (69))){
var inst_105689 = (state_105826[(9)]);
var inst_105690 = (state_105826[(7)]);
var inst_105702 = [cljs.core.cst$kw$instant,null,cljs.core.cst$kw$int,null];
var inst_105703 = (inst_105690.cljs$core$IFn$_invoke$arity$5 ? inst_105690.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_105702,null) : inst_105690.call(null,cljs.core.PersistentArrayMap,null,2,inst_105702,null));
var inst_105704 = (inst_105690.cljs$core$IFn$_invoke$arity$4 ? inst_105690.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_105703,null) : inst_105690.call(null,cljs.core.PersistentHashSet,null,inst_105703,null));
var inst_105705 = (inst_105704.cljs$core$IFn$_invoke$arity$1 ? inst_105704.cljs$core$IFn$_invoke$arity$1(inst_105689) : inst_105704.call(null,inst_105689));
var state_105826__$1 = state_105826;
if(cljs.core.truth_(inst_105705)){
var statearr_105852_106018 = state_105826__$1;
(statearr_105852_106018[(1)] = (70));

} else {
var statearr_105853_106019 = state_105826__$1;
(statearr_105853_106019[(1)] = (71));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (101))){
var inst_105558 = (state_105826[(12)]);
var inst_105791 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_105558);
var inst_105792 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_105791);
var inst_105793 = inst_105792 === true;
var inst_105794 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_105558);
var inst_105795 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_105794);
var inst_105796 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$ref,inst_105795);
var inst_105797 = (!(inst_105796));
var inst_105798 = ((inst_105793) && (inst_105797));
var state_105826__$1 = state_105826;
var statearr_105854_106020 = state_105826__$1;
(statearr_105854_106020[(2)] = inst_105798);

(statearr_105854_106020[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (24))){
var inst_105611 = (state_105826[(13)]);
var inst_105558 = (state_105826[(12)]);
var inst_105610 = (state_105826[(2)]);
var inst_105611__$1 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_105558);
var state_105826__$1 = (function (){var statearr_105855 = state_105826;
(statearr_105855[(13)] = inst_105611__$1);

(statearr_105855[(14)] = inst_105610);

return statearr_105855;
})();
if(cljs.core.truth_(inst_105611__$1)){
var statearr_105856_106021 = state_105826__$1;
(statearr_105856_106021[(1)] = (28));

} else {
var statearr_105857_106022 = state_105826__$1;
(statearr_105857_106022[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (102))){
var inst_105789 = (state_105826[(15)]);
var state_105826__$1 = state_105826;
var statearr_105858_106023 = state_105826__$1;
(statearr_105858_106023[(2)] = inst_105789);

(statearr_105858_106023[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (55))){
var inst_105680 = (state_105826[(2)]);
var state_105826__$1 = state_105826;
var statearr_105859_106024 = state_105826__$1;
(statearr_105859_106024[(2)] = inst_105680);

(statearr_105859_106024[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (85))){
var inst_105689 = (state_105826[(9)]);
var inst_105690 = (state_105826[(7)]);
var inst_105742 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$double,null,cljs.core.cst$kw$int,null,cljs.core.cst$kw$bigint,null,cljs.core.cst$kw$float,null];
var inst_105743 = (inst_105690.cljs$core$IFn$_invoke$arity$5 ? inst_105690.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_105742,null) : inst_105690.call(null,cljs.core.PersistentArrayMap,null,5,inst_105742,null));
var inst_105744 = (inst_105690.cljs$core$IFn$_invoke$arity$4 ? inst_105690.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_105743,null) : inst_105690.call(null,cljs.core.PersistentHashSet,null,inst_105743,null));
var inst_105745 = (inst_105744.cljs$core$IFn$_invoke$arity$1 ? inst_105744.cljs$core$IFn$_invoke$arity$1(inst_105689) : inst_105744.call(null,inst_105689));
var state_105826__$1 = state_105826;
if(cljs.core.truth_(inst_105745)){
var statearr_105860_106025 = state_105826__$1;
(statearr_105860_106025[(1)] = (86));

} else {
var statearr_105861_106026 = state_105826__$1;
(statearr_105861_106026[(1)] = (87));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (39))){
var inst_105626 = (state_105826[(16)]);
var state_105826__$1 = state_105826;
var statearr_105862_106027 = state_105826__$1;
(statearr_105862_106027[(2)] = inst_105626);

(statearr_105862_106027[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (88))){
var inst_105750 = (state_105826[(2)]);
var state_105826__$1 = state_105826;
var statearr_105863_106028 = state_105826__$1;
(statearr_105863_106028[(2)] = inst_105750);

(statearr_105863_106028[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (46))){
var inst_105664 = (state_105826[(2)]);
var state_105826__$1 = state_105826;
if(cljs.core.truth_(inst_105664)){
var statearr_105864_106029 = state_105826__$1;
(statearr_105864_106029[(1)] = (47));

} else {
var statearr_105865_106030 = state_105826__$1;
(statearr_105865_106030[(1)] = (48));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_105826,(3),Error,null,(2));
var inst_105540 = cljs.core.seq(pred_changes);
var inst_105541 = cljs.core.first(inst_105540);
var inst_105542 = cljs.core.next(inst_105540);
var inst_105543 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_105541,(0),null);
var inst_105544 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_105541,(1),null);
var inst_105545 = pred_changes;
var inst_105546 = db;
var state_105826__$1 = (function (){var statearr_105866 = state_105826;
(statearr_105866[(17)] = inst_105545);

(statearr_105866[(10)] = inst_105546);

(statearr_105866[(18)] = inst_105544);

(statearr_105866[(19)] = inst_105543);

(statearr_105866[(20)] = inst_105542);

return statearr_105866;
})();
var statearr_105867_106031 = state_105826__$1;
(statearr_105867_106031[(2)] = null);

(statearr_105867_106031[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (77))){
var inst_105689 = (state_105826[(9)]);
var inst_105690 = (state_105826[(7)]);
var inst_105722 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$int,null,cljs.core.cst$kw$float,null];
var inst_105723 = (inst_105690.cljs$core$IFn$_invoke$arity$5 ? inst_105690.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_105722,null) : inst_105690.call(null,cljs.core.PersistentArrayMap,null,3,inst_105722,null));
var inst_105724 = (inst_105690.cljs$core$IFn$_invoke$arity$4 ? inst_105690.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_105723,null) : inst_105690.call(null,cljs.core.PersistentHashSet,null,inst_105723,null));
var inst_105725 = (inst_105724.cljs$core$IFn$_invoke$arity$1 ? inst_105724.cljs$core$IFn$_invoke$arity$1(inst_105689) : inst_105724.call(null,inst_105689));
var state_105826__$1 = state_105826;
if(cljs.core.truth_(inst_105725)){
var statearr_105868_106032 = state_105826__$1;
(statearr_105868_106032[(1)] = (78));

} else {
var statearr_105869_106033 = state_105826__$1;
(statearr_105869_106033[(1)] = (79));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (106))){
var inst_105556 = (state_105826[(21)]);
var inst_105817 = (state_105826[(2)]);
var inst_105545 = inst_105556;
var inst_105546 = inst_105817;
var state_105826__$1 = (function (){var statearr_105870 = state_105826;
(statearr_105870[(17)] = inst_105545);

(statearr_105870[(10)] = inst_105546);

return statearr_105870;
})();
var statearr_105871_106034 = state_105826__$1;
(statearr_105871_106034[(2)] = null);

(statearr_105871_106034[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (95))){
var inst_105689 = (state_105826[(9)]);
var inst_105690 = (state_105826[(7)]);
var inst_105768 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_105689,inst_105690,throw_QMARK_);
var state_105826__$1 = state_105826;
var statearr_105872_106035 = state_105826__$1;
(statearr_105872_106035[(2)] = inst_105768);

(statearr_105872_106035[(1)] = (96));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (54))){
var state_105826__$1 = state_105826;
var statearr_105873_106036 = state_105826__$1;
(statearr_105873_106036[(2)] = false);

(statearr_105873_106036[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (92))){
var inst_105760 = (state_105826[(2)]);
var state_105826__$1 = state_105826;
var statearr_105874_106037 = state_105826__$1;
(statearr_105874_106037[(2)] = inst_105760);

(statearr_105874_106037[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (104))){
var state_105826__$1 = state_105826;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_105875_106038 = state_105826__$1;
(statearr_105875_106038[(1)] = (107));

} else {
var statearr_105876_106039 = state_105826__$1;
(statearr_105876_106039[(1)] = (108));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (15))){
var inst_105579 = (state_105826[(22)]);
var inst_105558 = (state_105826[(12)]);
var inst_105578 = (state_105826[(2)]);
var inst_105579__$1 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_105558);
var state_105826__$1 = (function (){var statearr_105877 = state_105826;
(statearr_105877[(22)] = inst_105579__$1);

(statearr_105877[(23)] = inst_105578);

return statearr_105877;
})();
if(cljs.core.truth_(inst_105579__$1)){
var statearr_105878_106040 = state_105826__$1;
(statearr_105878_106040[(1)] = (16));

} else {
var statearr_105879_106041 = state_105826__$1;
(statearr_105879_106041[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (48))){
var inst_105657 = (state_105826[(8)]);
var state_105826__$1 = state_105826;
var statearr_105880_106042 = state_105826__$1;
(statearr_105880_106042[(2)] = inst_105657);

(statearr_105880_106042[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (50))){
var inst_105667 = (state_105826[(24)]);
var inst_105672 = inst_105667.cljs$lang$protocol_mask$partition0$;
var inst_105673 = (inst_105672 & (64));
var inst_105674 = inst_105667.cljs$core$ISeq$;
var inst_105675 = (cljs.core.PROTOCOL_SENTINEL === inst_105674);
var inst_105676 = ((inst_105673) || (inst_105675));
var state_105826__$1 = state_105826;
if(cljs.core.truth_(inst_105676)){
var statearr_105881_106043 = state_105826__$1;
(statearr_105881_106043[(1)] = (53));

} else {
var statearr_105882_106044 = state_105826__$1;
(statearr_105882_106044[(1)] = (54));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (75))){
var inst_105689 = (state_105826[(9)]);
var inst_105690 = (state_105826[(7)]);
var inst_105718 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_105689,inst_105690,throw_QMARK_);
var state_105826__$1 = state_105826;
var statearr_105883_106045 = state_105826__$1;
(statearr_105883_106045[(2)] = inst_105718);

(statearr_105883_106045[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (99))){
var state_105826__$1 = state_105826;
var statearr_105884_106046 = state_105826__$1;
(statearr_105884_106046[(2)] = false);

(statearr_105884_106046[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (21))){
var inst_105594 = (state_105826[(2)]);
var state_105826__$1 = state_105826;
var statearr_105885_106047 = state_105826__$1;
(statearr_105885_106047[(2)] = inst_105594);

(statearr_105885_106047[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (31))){
var inst_105610 = (state_105826[(14)]);
var inst_105623 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_105610,"a component","a non-component",throw_QMARK_);
var state_105826__$1 = state_105826;
var statearr_105886_106048 = state_105826__$1;
(statearr_105886_106048[(2)] = inst_105623);

(statearr_105886_106048[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (32))){
var inst_105610 = (state_105826[(14)]);
var state_105826__$1 = state_105826;
var statearr_105887_106049 = state_105826__$1;
(statearr_105887_106049[(2)] = inst_105610);

(statearr_105887_106049[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (40))){
var inst_105558 = (state_105826[(12)]);
var inst_105658 = (state_105826[(25)]);
var inst_105657 = (state_105826[(2)]);
var inst_105658__$1 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_105558);
var state_105826__$1 = (function (){var statearr_105888 = state_105826;
(statearr_105888[(8)] = inst_105657);

(statearr_105888[(25)] = inst_105658__$1);

return statearr_105888;
})();
if(cljs.core.truth_(inst_105658__$1)){
var statearr_105889_106050 = state_105826__$1;
(statearr_105889_106050[(1)] = (44));

} else {
var statearr_105890_106051 = state_105826__$1;
(statearr_105890_106051[(1)] = (45));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (91))){
var inst_105689 = (state_105826[(9)]);
var inst_105690 = (state_105826[(7)]);
var inst_105758 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_105689,inst_105690,throw_QMARK_);
var state_105826__$1 = state_105826;
var statearr_105891_106052 = state_105826__$1;
(statearr_105891_106052[(2)] = inst_105758);

(statearr_105891_106052[(1)] = (92));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (108))){
var inst_105785 = (state_105826[(26)]);
var state_105826__$1 = state_105826;
var statearr_105892_106053 = state_105826__$1;
(statearr_105892_106053[(2)] = inst_105785);

(statearr_105892_106053[(1)] = (109));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (56))){
var inst_105667 = (state_105826[(24)]);
var inst_105685 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_105667);
var state_105826__$1 = state_105826;
var statearr_105893_106054 = state_105826__$1;
(statearr_105893_106054[(2)] = inst_105685);

(statearr_105893_106054[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (33))){
var inst_105627 = (state_105826[(27)]);
var inst_105558 = (state_105826[(12)]);
var inst_105626 = (state_105826[(2)]);
var inst_105627__$1 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_105558);
var state_105826__$1 = (function (){var statearr_105894 = state_105826;
(statearr_105894[(27)] = inst_105627__$1);

(statearr_105894[(16)] = inst_105626);

return statearr_105894;
})();
if(cljs.core.truth_(inst_105627__$1)){
var statearr_105895_106055 = state_105826__$1;
(statearr_105895_106055[(1)] = (34));

} else {
var statearr_105896_106056 = state_105826__$1;
(statearr_105896_106056[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (13))){
var inst_105546 = (state_105826[(10)]);
var inst_105575 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_105546,"multi-cardinality","single-cardinality",throw_QMARK_);
var state_105826__$1 = state_105826;
var statearr_105897_106057 = state_105826__$1;
(statearr_105897_106057[(2)] = inst_105575);

(statearr_105897_106057[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (22))){
var state_105826__$1 = state_105826;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_105898_106058 = state_105826__$1;
(statearr_105898_106058[(1)] = (25));

} else {
var statearr_105899_106059 = state_105826__$1;
(statearr_105899_106059[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (90))){
var inst_105657 = (state_105826[(8)]);
var state_105826__$1 = state_105826;
var statearr_105900_106060 = state_105826__$1;
(statearr_105900_106060[(2)] = inst_105657);

(statearr_105900_106060[(1)] = (92));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (109))){
var inst_105814 = (state_105826[(2)]);
var state_105826__$1 = state_105826;
var statearr_105901_106061 = state_105826__$1;
(statearr_105901_106061[(2)] = inst_105814);

(statearr_105901_106061[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (36))){
var inst_105642 = (state_105826[(2)]);
var state_105826__$1 = state_105826;
if(cljs.core.truth_(inst_105642)){
var statearr_105902_106062 = state_105826__$1;
(statearr_105902_106062[(1)] = (38));

} else {
var statearr_105903_106063 = state_105826__$1;
(statearr_105903_106063[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (41))){
var inst_105546 = (state_105826[(10)]);
var inst_105557 = (state_105826[(28)]);
var inst_105645 = fluree.db.dbproto._p_prop(inst_105546,cljs.core.cst$kw$name,inst_105557);
var inst_105646 = ["The _predicate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_105645)," cannot be set to unique, because there are existing non-unique values."].join('');
var inst_105647 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_105648 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_105649 = cljs.core.PersistentHashMap.fromArrays(inst_105647,inst_105648);
var inst_105650 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_105646,inst_105649);
var inst_105651 = (function(){throw inst_105650})();
var state_105826__$1 = state_105826;
var statearr_105904_106064 = state_105826__$1;
(statearr_105904_106064[(2)] = inst_105651);

(statearr_105904_106064[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (89))){
var inst_105689 = (state_105826[(9)]);
var inst_105690 = (state_105826[(7)]);
var inst_105752 = [cljs.core.cst$kw$geojson,null,cljs.core.cst$kw$bytes,null,cljs.core.cst$kw$uri,null,cljs.core.cst$kw$uuid,null,cljs.core.cst$kw$json,null];
var inst_105753 = (inst_105690.cljs$core$IFn$_invoke$arity$5 ? inst_105690.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_105752,null) : inst_105690.call(null,cljs.core.PersistentArrayMap,null,5,inst_105752,null));
var inst_105754 = (inst_105690.cljs$core$IFn$_invoke$arity$4 ? inst_105690.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_105753,null) : inst_105690.call(null,cljs.core.PersistentHashSet,null,inst_105753,null));
var inst_105755 = (inst_105754.cljs$core$IFn$_invoke$arity$1 ? inst_105754.cljs$core$IFn$_invoke$arity$1(inst_105689) : inst_105754.call(null,inst_105689));
var state_105826__$1 = state_105826;
if(cljs.core.truth_(inst_105755)){
var statearr_105905_106065 = state_105826__$1;
(statearr_105905_106065[(1)] = (90));

} else {
var statearr_105906_106066 = state_105826__$1;
(statearr_105906_106066[(1)] = (91));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (100))){
var inst_105804 = (state_105826[(2)]);
var state_105826__$1 = state_105826;
if(cljs.core.truth_(inst_105804)){
var statearr_105907_106067 = state_105826__$1;
(statearr_105907_106067[(1)] = (104));

} else {
var statearr_105908_106068 = state_105826__$1;
(statearr_105908_106068[(1)] = (105));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (43))){
var inst_105654 = (state_105826[(2)]);
var state_105826__$1 = state_105826;
var statearr_105909_106069 = state_105826__$1;
(statearr_105909_106069[(2)] = inst_105654);

(statearr_105909_106069[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (61))){
var inst_105782 = (state_105826[(2)]);
var state_105826__$1 = state_105826;
var statearr_105910_106070 = state_105826__$1;
(statearr_105910_106070[(2)] = inst_105782);

(statearr_105910_106070[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (29))){
var inst_105611 = (state_105826[(13)]);
var state_105826__$1 = state_105826;
var statearr_105911_106071 = state_105826__$1;
(statearr_105911_106071[(2)] = inst_105611);

(statearr_105911_106071[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (44))){
var inst_105558 = (state_105826[(12)]);
var inst_105660 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_105558);
var inst_105661 = cljs.core.cst$kw$old.cljs$core$IFn$_invoke$arity$1(inst_105660);
var state_105826__$1 = state_105826;
var statearr_105912_106072 = state_105826__$1;
(statearr_105912_106072[(2)] = inst_105661);

(statearr_105912_106072[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (93))){
var inst_105689 = (state_105826[(9)]);
var inst_105690 = (state_105826[(7)]);
var inst_105762 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$int,null];
var inst_105763 = (inst_105690.cljs$core$IFn$_invoke$arity$5 ? inst_105690.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_105762,null) : inst_105690.call(null,cljs.core.PersistentArrayMap,null,2,inst_105762,null));
var inst_105764 = (inst_105690.cljs$core$IFn$_invoke$arity$4 ? inst_105690.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_105763,null) : inst_105690.call(null,cljs.core.PersistentHashSet,null,inst_105763,null));
var inst_105765 = (inst_105764.cljs$core$IFn$_invoke$arity$1 ? inst_105764.cljs$core$IFn$_invoke$arity$1(inst_105689) : inst_105764.call(null,inst_105689));
var state_105826__$1 = state_105826;
if(cljs.core.truth_(inst_105765)){
var statearr_105913_106073 = state_105826__$1;
(statearr_105913_106073[(1)] = (94));

} else {
var statearr_105914_106074 = state_105826__$1;
(statearr_105914_106074[(1)] = (95));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (6))){
var inst_105822 = (state_105826[(2)]);
var state_105826__$1 = state_105826;
var statearr_105915_106075 = state_105826__$1;
(statearr_105915_106075[(2)] = inst_105822);


cljs.core.async.impl.ioc_helpers.process_exception(state_105826__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (28))){
var inst_105558 = (state_105826[(12)]);
var inst_105613 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_105558);
var inst_105614 = cljs.core.not(inst_105613);
var inst_105615 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_105558);
var inst_105616 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_105615);
var inst_105617 = inst_105616 === true;
var inst_105618 = ((inst_105614) && (inst_105617));
var state_105826__$1 = state_105826;
var statearr_105916_106076 = state_105826__$1;
(statearr_105916_106076[(2)] = inst_105618);

(statearr_105916_106076[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (64))){
var inst_105780 = (state_105826[(2)]);
var state_105826__$1 = state_105826;
var statearr_105917_106077 = state_105826__$1;
(statearr_105917_106077[(2)] = inst_105780);

(statearr_105917_106077[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (103))){
var inst_105801 = (state_105826[(2)]);
var state_105826__$1 = state_105826;
var statearr_105918_106078 = state_105826__$1;
(statearr_105918_106078[(2)] = inst_105801);

(statearr_105918_106078[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (51))){
var state_105826__$1 = state_105826;
var statearr_105919_106079 = state_105826__$1;
(statearr_105919_106079[(2)] = false);

(statearr_105919_106079[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (25))){
var inst_105600 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_105601 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_105602 = cljs.core.PersistentHashMap.fromArrays(inst_105600,inst_105601);
var inst_105603 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A boolean _predicate cannot be unique.",inst_105602);
var inst_105604 = (function(){throw inst_105603})();
var state_105826__$1 = state_105826;
var statearr_105920_106080 = state_105826__$1;
(statearr_105920_106080[(2)] = inst_105604);

(statearr_105920_106080[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (34))){
var inst_105546 = (state_105826[(10)]);
var inst_105558 = (state_105826[(12)]);
var inst_105557 = (state_105826[(28)]);
var inst_105629 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_105558);
var inst_105630 = cljs.core.not(inst_105629);
var inst_105631 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_105558);
var inst_105632 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_105631);
var inst_105633 = inst_105632 === true;
var inst_105634 = fluree.db.query.schema.pred_objects_unique_QMARK_(inst_105546,inst_105557);
var state_105826__$1 = (function (){var statearr_105921 = state_105826;
(statearr_105921[(29)] = inst_105633);

(statearr_105921[(30)] = inst_105630);

return statearr_105921;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_105826__$1,(37),inst_105634);
} else {
if((state_val_105827 === (17))){
var inst_105579 = (state_105826[(22)]);
var state_105826__$1 = state_105826;
var statearr_105922_106081 = state_105826__$1;
(statearr_105922_106081[(2)] = inst_105579);

(statearr_105922_106081[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (3))){
var inst_105523 = (state_105826[(2)]);
var state_105826__$1 = state_105826;
var statearr_105923_106082 = state_105826__$1;
(statearr_105923_106082[(2)] = inst_105523);


cljs.core.async.impl.ioc_helpers.process_exception(state_105826__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (12))){
var inst_105573 = (state_105826[(2)]);
var state_105826__$1 = state_105826;
if(cljs.core.truth_(inst_105573)){
var statearr_105924_106083 = state_105826__$1;
(statearr_105924_106083[(1)] = (13));

} else {
var statearr_105925_106084 = state_105826__$1;
(statearr_105925_106084[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (2))){
var inst_105824 = (state_105826[(2)]);
var state_105826__$1 = state_105826;
return cljs.core.async.impl.ioc_helpers.return_chan(state_105826__$1,inst_105824);
} else {
if((state_val_105827 === (66))){
var state_105826__$1 = state_105826;
var statearr_105926_106085 = state_105826__$1;
(statearr_105926_106085[(2)] = null);

(statearr_105926_106085[(1)] = (67));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (107))){
var inst_105807 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_105808 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_105809 = cljs.core.PersistentHashMap.fromArrays(inst_105807,inst_105808);
var inst_105810 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A component _predicate must be of type \"ref.\"",inst_105809);
var inst_105811 = (function(){throw inst_105810})();
var state_105826__$1 = state_105826;
var statearr_105927_106086 = state_105826__$1;
(statearr_105927_106086[(2)] = inst_105811);

(statearr_105927_106086[(1)] = (109));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (23))){
var inst_105578 = (state_105826[(23)]);
var state_105826__$1 = state_105826;
var statearr_105928_106087 = state_105826__$1;
(statearr_105928_106087[(2)] = inst_105578);

(statearr_105928_106087[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (47))){
var inst_105558 = (state_105826[(12)]);
var inst_105667 = (state_105826[(24)]);
var inst_105667__$1 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_105558);
var inst_105669 = (inst_105667__$1 == null);
var inst_105670 = cljs.core.not(inst_105669);
var state_105826__$1 = (function (){var statearr_105929 = state_105826;
(statearr_105929[(24)] = inst_105667__$1);

return statearr_105929;
})();
if(inst_105670){
var statearr_105930_106088 = state_105826__$1;
(statearr_105930_106088[(1)] = (50));

} else {
var statearr_105931_106089 = state_105826__$1;
(statearr_105931_106089[(1)] = (51));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (35))){
var inst_105627 = (state_105826[(27)]);
var state_105826__$1 = state_105826;
var statearr_105932_106090 = state_105826__$1;
(statearr_105932_106090[(2)] = inst_105627);

(statearr_105932_106090[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (82))){
var inst_105657 = (state_105826[(8)]);
var state_105826__$1 = state_105826;
var statearr_105933_106091 = state_105826__$1;
(statearr_105933_106091[(2)] = inst_105657);

(statearr_105933_106091[(1)] = (84));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (76))){
var inst_105720 = (state_105826[(2)]);
var state_105826__$1 = state_105826;
var statearr_105934_106092 = state_105826__$1;
(statearr_105934_106092[(2)] = inst_105720);

(statearr_105934_106092[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (97))){
var inst_105689 = (state_105826[(9)]);
var inst_105690 = (state_105826[(7)]);
var inst_105772 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_105689,inst_105690,throw_QMARK_);
var state_105826__$1 = state_105826;
var statearr_105935_106093 = state_105826__$1;
(statearr_105935_106093[(2)] = inst_105772);

(statearr_105935_106093[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (19))){
var inst_105558 = (state_105826[(12)]);
var inst_105583 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_105558);
var inst_105584 = inst_105583 === true;
var inst_105585 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_105558);
var inst_105586 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_105585);
var inst_105587 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$boolean,inst_105586);
var inst_105588 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_105558);
var inst_105589 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_105588);
var inst_105590 = inst_105589 === true;
var inst_105591 = ((inst_105584) && (inst_105587) && (inst_105590));
var state_105826__$1 = state_105826;
var statearr_105936_106094 = state_105826__$1;
(statearr_105936_106094[(2)] = inst_105591);

(statearr_105936_106094[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (57))){
var inst_105667 = (state_105826[(24)]);
var state_105826__$1 = state_105826;
var statearr_105937_106095 = state_105826__$1;
(statearr_105937_106095[(2)] = inst_105667);

(statearr_105937_106095[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (68))){
var inst_105775 = (state_105826[(2)]);
var state_105826__$1 = state_105826;
var statearr_105938_106096 = state_105826__$1;
(statearr_105938_106096[(2)] = inst_105775);

(statearr_105938_106096[(1)] = (67));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (11))){
var inst_105562 = (state_105826[(31)]);
var state_105826__$1 = state_105826;
var statearr_105939_106097 = state_105826__$1;
(statearr_105939_106097[(2)] = inst_105562);

(statearr_105939_106097[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (9))){
var inst_105820 = (state_105826[(2)]);
var state_105826__$1 = state_105826;
var statearr_105940_106098 = state_105826__$1;
(statearr_105940_106098[(2)] = inst_105820);

(statearr_105940_106098[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (5))){
var inst_105545 = (state_105826[(17)]);
var inst_105557 = (state_105826[(28)]);
var inst_105554 = cljs.core.seq(inst_105545);
var inst_105555 = cljs.core.first(inst_105554);
var inst_105556 = cljs.core.next(inst_105554);
var inst_105557__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_105555,(0),null);
var inst_105558 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_105555,(1),null);
var inst_105559 = cljs.core.not(inst_105557__$1);
var state_105826__$1 = (function (){var statearr_105941 = state_105826;
(statearr_105941[(12)] = inst_105558);

(statearr_105941[(28)] = inst_105557__$1);

(statearr_105941[(21)] = inst_105556);

return statearr_105941;
})();
if(inst_105559){
var statearr_105942_106099 = state_105826__$1;
(statearr_105942_106099[(1)] = (7));

} else {
var statearr_105943_106100 = state_105826__$1;
(statearr_105943_106100[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (83))){
var inst_105689 = (state_105826[(9)]);
var inst_105690 = (state_105826[(7)]);
var inst_105738 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_105689,inst_105690,throw_QMARK_);
var state_105826__$1 = state_105826;
var statearr_105944_106101 = state_105826__$1;
(statearr_105944_106101[(2)] = inst_105738);

(statearr_105944_106101[(1)] = (84));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (14))){
var inst_105546 = (state_105826[(10)]);
var state_105826__$1 = state_105826;
var statearr_105945_106102 = state_105826__$1;
(statearr_105945_106102[(2)] = inst_105546);

(statearr_105945_106102[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (45))){
var inst_105658 = (state_105826[(25)]);
var state_105826__$1 = state_105826;
var statearr_105946_106103 = state_105826__$1;
(statearr_105946_106103[(2)] = inst_105658);

(statearr_105946_106103[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (53))){
var state_105826__$1 = state_105826;
var statearr_105947_106104 = state_105826__$1;
(statearr_105947_106104[(2)] = true);

(statearr_105947_106104[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (78))){
var inst_105657 = (state_105826[(8)]);
var state_105826__$1 = state_105826;
var statearr_105948_106105 = state_105826__$1;
(statearr_105948_106105[(2)] = inst_105657);

(statearr_105948_106105[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (26))){
var inst_105578 = (state_105826[(23)]);
var state_105826__$1 = state_105826;
var statearr_105949_106106 = state_105826__$1;
(statearr_105949_106106[(2)] = inst_105578);

(statearr_105949_106106[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (16))){
var inst_105558 = (state_105826[(12)]);
var inst_105581 = (state_105826[(11)]);
var inst_105581__$1 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_105558);
var state_105826__$1 = (function (){var statearr_105950 = state_105826;
(statearr_105950[(11)] = inst_105581__$1);

return statearr_105950;
})();
if(cljs.core.truth_(inst_105581__$1)){
var statearr_105951_106107 = state_105826__$1;
(statearr_105951_106107[(1)] = (19));

} else {
var statearr_105952_106108 = state_105826__$1;
(statearr_105952_106108[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (81))){
var inst_105689 = (state_105826[(9)]);
var inst_105690 = (state_105826[(7)]);
var inst_105732 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$int,null,cljs.core.cst$kw$float,null];
var inst_105733 = (inst_105690.cljs$core$IFn$_invoke$arity$5 ? inst_105690.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_105732,null) : inst_105690.call(null,cljs.core.PersistentArrayMap,null,3,inst_105732,null));
var inst_105734 = (inst_105690.cljs$core$IFn$_invoke$arity$4 ? inst_105690.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_105733,null) : inst_105690.call(null,cljs.core.PersistentHashSet,null,inst_105733,null));
var inst_105735 = (inst_105734.cljs$core$IFn$_invoke$arity$1 ? inst_105734.cljs$core$IFn$_invoke$arity$1(inst_105689) : inst_105734.call(null,inst_105689));
var state_105826__$1 = state_105826;
if(cljs.core.truth_(inst_105735)){
var statearr_105953_106109 = state_105826__$1;
(statearr_105953_106109[(1)] = (82));

} else {
var statearr_105954_106110 = state_105826__$1;
(statearr_105954_106110[(1)] = (83));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (79))){
var inst_105689 = (state_105826[(9)]);
var inst_105690 = (state_105826[(7)]);
var inst_105728 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_105689,inst_105690,throw_QMARK_);
var state_105826__$1 = state_105826;
var statearr_105955_106111 = state_105826__$1;
(statearr_105955_106111[(2)] = inst_105728);

(statearr_105955_106111[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (38))){
var state_105826__$1 = state_105826;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_105956_106112 = state_105826__$1;
(statearr_105956_106112[(1)] = (41));

} else {
var statearr_105957_106113 = state_105826__$1;
(statearr_105957_106113[(1)] = (42));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (98))){
var inst_105558 = (state_105826[(12)]);
var inst_105789 = (state_105826[(15)]);
var inst_105789__$1 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_105558);
var state_105826__$1 = (function (){var statearr_105958 = state_105826;
(statearr_105958[(15)] = inst_105789__$1);

return statearr_105958;
})();
if(cljs.core.truth_(inst_105789__$1)){
var statearr_105959_106114 = state_105826__$1;
(statearr_105959_106114[(1)] = (101));

} else {
var statearr_105960_106115 = state_105826__$1;
(statearr_105960_106115[(1)] = (102));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (87))){
var inst_105689 = (state_105826[(9)]);
var inst_105690 = (state_105826[(7)]);
var inst_105748 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_105689,inst_105690,throw_QMARK_);
var state_105826__$1 = state_105826;
var statearr_105961_106116 = state_105826__$1;
(statearr_105961_106116[(2)] = inst_105748);

(statearr_105961_106116[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (30))){
var inst_105621 = (state_105826[(2)]);
var state_105826__$1 = state_105826;
if(cljs.core.truth_(inst_105621)){
var statearr_105962_106117 = state_105826__$1;
(statearr_105962_106117[(1)] = (31));

} else {
var statearr_105963_106118 = state_105826__$1;
(statearr_105963_106118[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (73))){
var inst_105689 = (state_105826[(9)]);
var inst_105690 = (state_105826[(7)]);
var inst_105712 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$instant,null,cljs.core.cst$kw$int,null];
var inst_105713 = (inst_105690.cljs$core$IFn$_invoke$arity$5 ? inst_105690.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_105712,null) : inst_105690.call(null,cljs.core.PersistentArrayMap,null,3,inst_105712,null));
var inst_105714 = (inst_105690.cljs$core$IFn$_invoke$arity$4 ? inst_105690.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_105713,null) : inst_105690.call(null,cljs.core.PersistentHashSet,null,inst_105713,null));
var inst_105715 = (inst_105714.cljs$core$IFn$_invoke$arity$1 ? inst_105714.cljs$core$IFn$_invoke$arity$1(inst_105689) : inst_105714.call(null,inst_105689));
var state_105826__$1 = state_105826;
if(cljs.core.truth_(inst_105715)){
var statearr_105964_106119 = state_105826__$1;
(statearr_105964_106119[(1)] = (74));

} else {
var statearr_105965_106120 = state_105826__$1;
(statearr_105965_106120[(1)] = (75));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (96))){
var inst_105770 = (state_105826[(2)]);
var state_105826__$1 = state_105826;
var statearr_105966_106121 = state_105826__$1;
(statearr_105966_106121[(2)] = inst_105770);

(statearr_105966_106121[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (10))){
var inst_105558 = (state_105826[(12)]);
var inst_105564 = cljs.core.cst$kw$multi.cljs$core$IFn$_invoke$arity$1(inst_105558);
var inst_105565 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_105564);
var inst_105566 = inst_105565 === false;
var inst_105567 = cljs.core.cst$kw$multi.cljs$core$IFn$_invoke$arity$1(inst_105558);
var inst_105568 = cljs.core.cst$kw$old.cljs$core$IFn$_invoke$arity$1(inst_105567);
var inst_105569 = inst_105568 === true;
var inst_105570 = ((inst_105566) && (inst_105569));
var state_105826__$1 = state_105826;
var statearr_105967_106122 = state_105826__$1;
(statearr_105967_106122[(2)] = inst_105570);

(statearr_105967_106122[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (18))){
var inst_105597 = (state_105826[(2)]);
var state_105826__$1 = state_105826;
if(cljs.core.truth_(inst_105597)){
var statearr_105968_106123 = state_105826__$1;
(statearr_105968_106123[(1)] = (22));

} else {
var statearr_105969_106124 = state_105826__$1;
(statearr_105969_106124[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (105))){
var inst_105785 = (state_105826[(26)]);
var state_105826__$1 = state_105826;
var statearr_105970_106125 = state_105826__$1;
(statearr_105970_106125[(2)] = inst_105785);

(statearr_105970_106125[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (52))){
var inst_105683 = (state_105826[(2)]);
var state_105826__$1 = state_105826;
if(cljs.core.truth_(inst_105683)){
var statearr_105971_106126 = state_105826__$1;
(statearr_105971_106126[(1)] = (56));

} else {
var statearr_105972_106127 = state_105826__$1;
(statearr_105972_106127[(1)] = (57));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (67))){
var inst_105778 = (state_105826[(2)]);
var state_105826__$1 = state_105826;
var statearr_105973_106128 = state_105826__$1;
(statearr_105973_106128[(2)] = inst_105778);

(statearr_105973_106128[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (71))){
var inst_105689 = (state_105826[(9)]);
var inst_105690 = (state_105826[(7)]);
var inst_105708 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_105689,inst_105690,throw_QMARK_);
var state_105826__$1 = state_105826;
var statearr_105974_106129 = state_105826__$1;
(statearr_105974_106129[(2)] = inst_105708);

(statearr_105974_106129[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (42))){
var inst_105626 = (state_105826[(16)]);
var state_105826__$1 = state_105826;
var statearr_105975_106130 = state_105826__$1;
(statearr_105975_106130[(2)] = inst_105626);

(statearr_105975_106130[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (80))){
var inst_105730 = (state_105826[(2)]);
var state_105826__$1 = state_105826;
var statearr_105976_106131 = state_105826__$1;
(statearr_105976_106131[(2)] = inst_105730);

(statearr_105976_106131[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (37))){
var inst_105633 = (state_105826[(29)]);
var inst_105630 = (state_105826[(30)]);
var inst_105636 = (state_105826[(2)]);
var inst_105637 = fluree.db.util.async.throw_err(inst_105636);
var inst_105638 = cljs.core.not(inst_105637);
var inst_105639 = ((inst_105630) && (inst_105633) && (inst_105638));
var state_105826__$1 = state_105826;
var statearr_105977_106132 = state_105826__$1;
(statearr_105977_106132[(2)] = inst_105639);

(statearr_105977_106132[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (63))){
var state_105826__$1 = state_105826;
var statearr_105978_106133 = state_105826__$1;
(statearr_105978_106133[(1)] = (65));



return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (94))){
var inst_105657 = (state_105826[(8)]);
var state_105826__$1 = state_105826;
var statearr_105980_106134 = state_105826__$1;
(statearr_105980_106134[(2)] = inst_105657);

(statearr_105980_106134[(1)] = (96));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (8))){
var inst_105558 = (state_105826[(12)]);
var inst_105562 = (state_105826[(31)]);
var inst_105562__$1 = cljs.core.cst$kw$multi.cljs$core$IFn$_invoke$arity$1(inst_105558);
var state_105826__$1 = (function (){var statearr_105981 = state_105826;
(statearr_105981[(31)] = inst_105562__$1);

return statearr_105981;
})();
if(cljs.core.truth_(inst_105562__$1)){
var statearr_105982_106135 = state_105826__$1;
(statearr_105982_106135[(1)] = (10));

} else {
var statearr_105983_106136 = state_105826__$1;
(statearr_105983_106136[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (49))){
var inst_105558 = (state_105826[(12)]);
var inst_105785 = (state_105826[(2)]);
var inst_105786 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_105558);
var inst_105787 = inst_105786 === true;
var state_105826__$1 = (function (){var statearr_105984 = state_105826;
(statearr_105984[(26)] = inst_105785);

return statearr_105984;
})();
if(cljs.core.truth_(inst_105787)){
var statearr_105985_106137 = state_105826__$1;
(statearr_105985_106137[(1)] = (98));

} else {
var statearr_105986_106138 = state_105826__$1;
(statearr_105986_106138[(1)] = (99));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105827 === (84))){
var inst_105740 = (state_105826[(2)]);
var state_105826__$1 = state_105826;
var statearr_105987_106139 = state_105826__$1;
(statearr_105987_106139[(2)] = inst_105740);

(statearr_105987_106139[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__100742__auto__ = null;
var fluree$db$query$schema$state_machine__100742__auto____0 = (function (){
var statearr_105988 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_105988[(0)] = fluree$db$query$schema$state_machine__100742__auto__);

(statearr_105988[(1)] = (1));

return statearr_105988;
});
var fluree$db$query$schema$state_machine__100742__auto____1 = (function (state_105826){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_105826);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e105989){if((e105989 instanceof Object)){
var ex__100745__auto__ = e105989;
var statearr_105990_106140 = state_105826;
(statearr_105990_106140[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_105826);

return cljs.core.cst$kw$recur;
} else {
throw e105989;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__106141 = state_105826;
state_105826 = G__106141;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__100742__auto__ = function(state_105826){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__100742__auto____1.call(this,state_105826);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__100742__auto____0;
fluree$db$query$schema$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__100742__auto____1;
return fluree$db$query$schema$state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_105991 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_105991[(6)] = c__100848__auto__);

return statearr_105991;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
}));

(fluree.db.query.schema.predicate_change_error.cljs$lang$maxFixedArity = 3);

fluree.db.query.schema.validate_schema_change = (function fluree$db$query$schema$validate_schema_change(db,tempids,flakes){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_106162){
var state_val_106163 = (state_106162[(1)]);
if((state_val_106163 === (7))){
var inst_106149 = (state_106162[(7)]);
var inst_106153 = fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(inst_106149,db,true);
var state_106162__$1 = state_106162;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_106162__$1,(9),inst_106153);
} else {
if((state_val_106163 === (1))){
var state_106162__$1 = state_106162;
var statearr_106164_106176 = state_106162__$1;
(statearr_106164_106176[(2)] = null);

(statearr_106164_106176[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106163 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_106162,(3),Error,null,(2));
var inst_106146 = fluree.db.query.schema.new_pred_changes(db,tempids,flakes);
var state_106162__$1 = state_106162;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_106162__$1,(5),inst_106146);
} else {
if((state_val_106163 === (6))){
var state_106162__$1 = state_106162;
var statearr_106165_106177 = state_106162__$1;
(statearr_106165_106177[(2)] = db);

(statearr_106165_106177[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106163 === (3))){
var inst_106142 = (state_106162[(2)]);
var state_106162__$1 = state_106162;
var statearr_106166_106178 = state_106162__$1;
(statearr_106166_106178[(2)] = inst_106142);


cljs.core.async.impl.ioc_helpers.process_exception(state_106162__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_106163 === (2))){
var inst_106160 = (state_106162[(2)]);
var state_106162__$1 = state_106162;
return cljs.core.async.impl.ioc_helpers.return_chan(state_106162__$1,inst_106160);
} else {
if((state_val_106163 === (9))){
var inst_106155 = (state_106162[(2)]);
var inst_106156 = fluree.db.util.async.throw_err(inst_106155);
var state_106162__$1 = state_106162;
var statearr_106167_106179 = state_106162__$1;
(statearr_106167_106179[(2)] = inst_106156);

(statearr_106167_106179[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106163 === (5))){
var inst_106149 = (state_106162[(7)]);
var inst_106148 = (state_106162[(2)]);
var inst_106149__$1 = fluree.db.util.async.throw_err(inst_106148);
var inst_106150 = cljs.core.empty_QMARK_(inst_106149__$1);
var state_106162__$1 = (function (){var statearr_106168 = state_106162;
(statearr_106168[(7)] = inst_106149__$1);

return statearr_106168;
})();
if(inst_106150){
var statearr_106169_106180 = state_106162__$1;
(statearr_106169_106180[(1)] = (6));

} else {
var statearr_106170_106181 = state_106162__$1;
(statearr_106170_106181[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_106163 === (8))){
var inst_106158 = (state_106162[(2)]);
var state_106162__$1 = state_106162;
var statearr_106171_106182 = state_106162__$1;
(statearr_106171_106182[(2)] = inst_106158);


cljs.core.async.impl.ioc_helpers.process_exception(state_106162__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$validate_schema_change_$_state_machine__100742__auto__ = null;
var fluree$db$query$schema$validate_schema_change_$_state_machine__100742__auto____0 = (function (){
var statearr_106172 = [null,null,null,null,null,null,null,null];
(statearr_106172[(0)] = fluree$db$query$schema$validate_schema_change_$_state_machine__100742__auto__);

(statearr_106172[(1)] = (1));

return statearr_106172;
});
var fluree$db$query$schema$validate_schema_change_$_state_machine__100742__auto____1 = (function (state_106162){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_106162);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e106173){if((e106173 instanceof Object)){
var ex__100745__auto__ = e106173;
var statearr_106174_106183 = state_106162;
(statearr_106174_106183[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_106162);

return cljs.core.cst$kw$recur;
} else {
throw e106173;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__106184 = state_106162;
state_106162 = G__106184;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$query$schema$validate_schema_change_$_state_machine__100742__auto__ = function(state_106162){
switch(arguments.length){
case 0:
return fluree$db$query$schema$validate_schema_change_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$query$schema$validate_schema_change_$_state_machine__100742__auto____1.call(this,state_106162);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$validate_schema_change_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$validate_schema_change_$_state_machine__100742__auto____0;
fluree$db$query$schema$validate_schema_change_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$validate_schema_change_$_state_machine__100742__auto____1;
return fluree$db$query$schema$validate_schema_change_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_106175 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_106175[(6)] = c__100848__auto__);

return statearr_106175;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
fluree.db.query.schema.predicate_re = /(?:([^\/]+)\/)([^\/]+)/;
fluree.db.query.schema.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.query.schema.reverse_ref_QMARK_ = (function fluree$db$query$schema$reverse_ref_QMARK_(var_args){
var G__106186 = arguments.length;
switch (G__106186) {
case 1:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (predicate_name){
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2(predicate_name,false);
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (predicate_name,throw_QMARK_){
if(typeof predicate_name === 'string'){
return cljs.core.boolean$(cljs.core.re_matches(fluree.db.query.schema.pred_reverse_ref_re,predicate_name));
} else {
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
} else {
return false;
}
}
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$lang$maxFixedArity = 2);

/**
 * Reverses an predicate name.
 */
fluree.db.query.schema.reverse_ref = (function fluree$db$query$schema$reverse_ref(predicate_name){
if(typeof predicate_name === 'string'){
var vec__106188 = cljs.core.re_matches(/(?:([^\/]+)\/)?([^\/]+)/,predicate_name);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106188,(0),null);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106188,(1),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106188,(2),null);
if(cljs.core.truth_(ns)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_",cljs.core.nth.cljs$core$IFn$_invoke$arity$2(name,(0)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.subs.cljs$core$IFn$_invoke$arity$2(name,(1))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('');
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, does not contain a namespace portion: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
});
fluree.db.query.schema.type_sid__GT_type = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(2)),fluree.db.flake.__GT_sid((3),(9)),fluree.db.flake.__GT_sid((3),(14)),fluree.db.flake.__GT_sid((3),(16)),fluree.db.flake.__GT_sid((3),(8)),fluree.db.flake.__GT_sid((3),(4)),fluree.db.flake.__GT_sid((3),(5)),fluree.db.flake.__GT_sid((3),(15)),fluree.db.flake.__GT_sid((3),(17)),fluree.db.flake.__GT_sid((3),(11)),fluree.db.flake.__GT_sid((3),(12)),fluree.db.flake.__GT_sid((3),(1)),fluree.db.flake.__GT_sid((3),(10)),fluree.db.flake.__GT_sid((3),(6)),fluree.db.flake.__GT_sid((3),(7)),fluree.db.flake.__GT_sid((3),(13))],[cljs.core.cst$kw$ref,cljs.core.cst$kw$int,cljs.core.cst$kw$bigdec,cljs.core.cst$kw$json,cljs.core.cst$kw$bytes,cljs.core.cst$kw$boolean,cljs.core.cst$kw$instant,cljs.core.cst$kw$tag,cljs.core.cst$kw$geojson,cljs.core.cst$kw$bigint,cljs.core.cst$kw$float,cljs.core.cst$kw$string,cljs.core.cst$kw$long,cljs.core.cst$kw$uuid,cljs.core.cst$kw$uri,cljs.core.cst$kw$double]);
fluree.db.query.schema.lang_sid__GT_lang = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(62)),fluree.db.flake.__GT_sid((3),(68)),fluree.db.flake.__GT_sid((3),(67)),fluree.db.flake.__GT_sid((3),(69)),fluree.db.flake.__GT_sid((3),(63)),fluree.db.flake.__GT_sid((3),(70)),fluree.db.flake.__GT_sid((3),(65)),fluree.db.flake.__GT_sid((3),(66)),fluree.db.flake.__GT_sid((3),(64)),fluree.db.flake.__GT_sid((3),(61))],[cljs.core.cst$kw$bn,cljs.core.cst$kw$hi,cljs.core.cst$kw$fr,cljs.core.cst$kw$id,cljs.core.cst$kw$br,cljs.core.cst$kw$ru,cljs.core.cst$kw$en,cljs.core.cst$kw$es,cljs.core.cst$kw$cn,cljs.core.cst$kw$ar]);
fluree.db.query.schema.flake__GT_pred_map = (function fluree$db$query$schema$flake__GT_pred_map(flakes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,flake){
var p = flake.p;
var o = flake.o;
var existing_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,p);
if(cljs.core.truth_((function (){var and__4115__auto__ = existing_QMARK_;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.vector_QMARK_(existing_QMARK_);
} else {
return and__4115__auto__;
}
})())){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,cljs.core.conj,o);
} else {
if(cljs.core.truth_(existing_QMARK_)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,(function (p1__106191_SHARP_,p2__106192_SHARP_){
return cljs.core.vec(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__106191_SHARP_,p2__106192_SHARP_], null));
}),o);
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,p,o);

}
}
}),cljs.core.PersistentArrayMap.EMPTY,flakes);
});
/**
 * Returns a map of the schema for a db to allow quick lookups of schema properties.
 *   Schema is a map with two keys:
 *   - :coll - collection info, mapping cid->name and name->cid all within the same map
 *   - :pred - predicate info, mapping pid->properties and name->properties for quick lookup based on id or name respectively
 *   
 */
fluree.db.query.schema.schema_map = (function fluree$db$query$schema$schema_map(db){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_106255){
var state_val_106256 = (state_106255[(1)]);
if((state_val_106256 === (1))){
var state_106255__$1 = state_106255;
var statearr_106257_106268 = state_106255__$1;
(statearr_106257_106268[(2)] = null);

(statearr_106257_106268[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106256 === (2))){
var inst_106253 = (state_106255[(2)]);
var state_106255__$1 = state_106255;
return cljs.core.async.impl.ioc_helpers.return_chan(state_106255__$1,inst_106253);
} else {
if((state_val_106256 === (3))){
var inst_106198 = (state_106255[(2)]);
var state_106255__$1 = state_106255;
var statearr_106258_106269 = state_106255__$1;
(statearr_106258_106269[(2)] = inst_106198);


cljs.core.async.impl.ioc_helpers.process_exception(state_106255__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_106256 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_106255,(3),Error,null,(2));
var inst_106208 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_106209 = fluree.db.flake.max_subject_id((1));
var inst_106210 = [inst_106209];
var inst_106211 = (new cljs.core.PersistentVector(null,1,(5),inst_106208,inst_106210,null));
var inst_106212 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_106213 = [(0)];
var inst_106214 = (new cljs.core.PersistentVector(null,1,(5),inst_106212,inst_106213,null));
var inst_106215 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$spot,cljs.core._GT__EQ_,inst_106211,cljs.core._LT__EQ_,inst_106214);
var state_106255__$1 = state_106255;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_106255__$1,(5),inst_106215);
} else {
if((state_val_106256 === (5))){
var inst_106217 = (state_106255[(2)]);
var inst_106218 = fluree.db.util.async.throw_err(inst_106217);
var inst_106219 = (function (){var schema_flakes = inst_106218;
return (function (p1__106193_SHARP_){
return (p1__106193_SHARP_.s <= fluree.db.flake.MAX_COLL_SUBJECTS);
});
})();
var inst_106220 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_106219,inst_106218);
var inst_106221 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_106220,(0),null);
var inst_106222 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_106220,(1),null);
var inst_106223 = (function (){var schema_flakes = inst_106218;
var vec__106202 = inst_106220;
var collection_flakes = inst_106221;
var predicate_flakes = inst_106222;
return (function (acc,coll_flakes){
var sid = cljs.core.first(coll_flakes).s;
var id = fluree.db.flake.sid__GT_i(sid);
var p__GT_v = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__106195_SHARP_,p2__106196_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__106195_SHARP_,p2__106196_SHARP_.p,p2__106196_SHARP_.o);
}),cljs.core.PersistentArrayMap.EMPTY,coll_flakes);
var c_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(40));
var spec = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(43));
var specDoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(44));
var c_props = new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$name,c_name,cljs.core.cst$kw$sid,sid,cljs.core.cst$kw$spec,spec,cljs.core.cst$kw$specDoc,specDoc,cljs.core.cst$kw$id,id], null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(acc,id,c_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c_name,c_props], 0));
});
})();
var inst_106224 = [(-1),"_tx"];
var inst_106225 = [cljs.core.cst$kw$name,cljs.core.cst$kw$id,cljs.core.cst$kw$sid];
var inst_106226 = ["_tx",(-1),(-1)];
var inst_106227 = cljs.core.PersistentHashMap.fromArrays(inst_106225,inst_106226);
var inst_106228 = [cljs.core.cst$kw$name,cljs.core.cst$kw$id,cljs.core.cst$kw$sid];
var inst_106229 = ["_tx",(-1),(-1)];
var inst_106230 = cljs.core.PersistentHashMap.fromArrays(inst_106228,inst_106229);
var inst_106231 = [inst_106227,inst_106230];
var inst_106232 = cljs.core.PersistentHashMap.fromArrays(inst_106224,inst_106231);
var inst_106233 = (function (){var schema_flakes = inst_106218;
var vec__106202 = inst_106220;
var collection_flakes = inst_106221;
var predicate_flakes = inst_106222;
return (function (p1__106194_SHARP_){
return p1__106194_SHARP_.s;
});
})();
var inst_106234 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_106233,inst_106221);
var inst_106235 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_106223,inst_106232,inst_106234);
var inst_106237 = (function (){var schema_flakes = inst_106218;
var vec__106202 = inst_106220;
var collection_flakes = inst_106221;
var predicate_flakes = inst_106222;
var coll = inst_106235;
return (function (p__106236,pred_flakes){
var vec__106259 = p__106236;
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106259,(0),null);
var fullText = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106259,(1),null);
var id = cljs.core.first(pred_flakes).s;
var p__GT_v = fluree.db.query.schema.flake__GT_pred_map(pred_flakes);
var p_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(10));
var p_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.type_sid__GT_type,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(12)));
var ref_QMARK_ = cljs.core.boolean$((function (){var fexpr__106262 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$ref,null,cljs.core.cst$kw$tag,null], null), null);
return (fexpr__106262.cljs$core$IFn$_invoke$arity$1 ? fexpr__106262.cljs$core$IFn$_invoke$arity$1(p_type) : fexpr__106262.call(null,p_type));
})());
var idx_QMARK_ = cljs.core.boolean$((function (){var or__4126__auto__ = ref_QMARK_;
if(or__4126__auto__){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15));
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13));
}
}
})());
var fullText_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(27));
var p_props = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$unique,cljs.core.cst$kw$restrictCollection,cljs.core.cst$kw$index,cljs.core.cst$kw$name,cljs.core.cst$kw$noHistory,cljs.core.cst$kw$type,cljs.core.cst$kw$txSpec,cljs.core.cst$kw$component,cljs.core.cst$kw$txSpecDoc,cljs.core.cst$kw$spec,cljs.core.cst$kw$multi,cljs.core.cst$kw$id,cljs.core.cst$kw$specDoc,cljs.core.cst$kw$idx_QMARK_,cljs.core.cst$kw$ref_QMARK_,cljs.core.cst$kw$upsert,cljs.core.cst$kw$restrictTag,cljs.core.cst$kw$fullText],[cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(19)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15))),p_name,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(18))),p_type,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(24)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(17))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(25)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(20)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(14))),id,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(23)),idx_QMARK_,ref_QMARK_,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(16))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(26)),fullText_QMARK_]);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(pred,id,p_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([p_name,p_props], 0)),(cljs.core.truth_(fullText_QMARK_)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(fullText,id):fullText)], null);
});
})();
var inst_106238 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_106239 = cljs.core.PersistentHashMap.EMPTY;
var inst_106240 = cljs.core.PersistentHashSet.EMPTY;
var inst_106241 = [inst_106239,inst_106240];
var inst_106242 = (new cljs.core.PersistentVector(null,2,(5),inst_106238,inst_106241,null));
var inst_106243 = (function (){var schema_flakes = inst_106218;
var vec__106202 = inst_106220;
var collection_flakes = inst_106221;
var predicate_flakes = inst_106222;
var coll = inst_106235;
return (function (p1__106197_SHARP_){
return p1__106197_SHARP_.s;
});
})();
var inst_106244 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_106243,inst_106222);
var inst_106245 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_106237,inst_106242,inst_106244);
var inst_106246 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_106245,(0),null);
var inst_106247 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_106245,(1),null);
var inst_106248 = [cljs.core.cst$kw$t,cljs.core.cst$kw$coll,cljs.core.cst$kw$pred,cljs.core.cst$kw$fullText];
var inst_106249 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_106250 = [inst_106249,inst_106235,inst_106246,inst_106247];
var inst_106251 = cljs.core.PersistentHashMap.fromArrays(inst_106248,inst_106250);
var state_106255__$1 = state_106255;
var statearr_106263_106270 = state_106255__$1;
(statearr_106263_106270[(2)] = inst_106251);


cljs.core.async.impl.ioc_helpers.process_exception(state_106255__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$schema_map_$_state_machine__100742__auto__ = null;
var fluree$db$query$schema$schema_map_$_state_machine__100742__auto____0 = (function (){
var statearr_106264 = [null,null,null,null,null,null,null];
(statearr_106264[(0)] = fluree$db$query$schema$schema_map_$_state_machine__100742__auto__);

(statearr_106264[(1)] = (1));

return statearr_106264;
});
var fluree$db$query$schema$schema_map_$_state_machine__100742__auto____1 = (function (state_106255){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_106255);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e106265){if((e106265 instanceof Object)){
var ex__100745__auto__ = e106265;
var statearr_106266_106271 = state_106255;
(statearr_106266_106271[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_106255);

return cljs.core.cst$kw$recur;
} else {
throw e106265;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__106272 = state_106255;
state_106255 = G__106272;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$query$schema$schema_map_$_state_machine__100742__auto__ = function(state_106255){
switch(arguments.length){
case 0:
return fluree$db$query$schema$schema_map_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$query$schema$schema_map_$_state_machine__100742__auto____1.call(this,state_106255);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$schema_map_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$schema_map_$_state_machine__100742__auto____0;
fluree$db$query$schema$schema_map_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$schema_map_$_state_machine__100742__auto____1;
return fluree$db$query$schema$schema_map_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_106267 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_106267[(6)] = c__100848__auto__);

return statearr_106267;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
fluree.db.query.schema.setting_map = (function fluree$db$query$schema$setting_map(db){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_106308){
var state_val_106309 = (state_106308[(1)]);
if((state_val_106309 === (1))){
var state_106308__$1 = state_106308;
var statearr_106310_106321 = state_106308__$1;
(statearr_106310_106321[(2)] = null);

(statearr_106310_106321[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106309 === (2))){
var inst_106306 = (state_106308[(2)]);
var state_106308__$1 = state_106308;
return cljs.core.async.impl.ioc_helpers.return_chan(state_106308__$1,inst_106306);
} else {
if((state_val_106309 === (3))){
var inst_106273 = (state_106308[(2)]);
var state_106308__$1 = state_106308;
var statearr_106311_106322 = state_106308__$1;
(statearr_106311_106322[(2)] = inst_106273);


cljs.core.async.impl.ioc_helpers.process_exception(state_106308__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_106309 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_106308,(3),Error,null,(2));
var state_106308__$1 = state_106308;
var statearr_106312_106323 = state_106308__$1;
(statearr_106312_106323[(2)] = null);

(statearr_106312_106323[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_106309 === (5))){
var inst_106292 = (state_106308[(2)]);
var inst_106293 = fluree.db.query.schema.flake__GT_pred_map(inst_106292);
var inst_106294 = [cljs.core.cst$kw$passwords,cljs.core.cst$kw$anonymous,cljs.core.cst$kw$language,cljs.core.cst$kw$ledgers,cljs.core.cst$kw$txMax,cljs.core.cst$kw$consensus];
var inst_106295 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_106293,(114));
var inst_106296 = cljs.core.boolean$(inst_106295);
var inst_106297 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_106293,(110));
var inst_106298 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_106293,(117));
var inst_106299 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.lang_sid__GT_lang,inst_106298);
var inst_106300 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_106293,(111));
var inst_106301 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_106293,(115));
var inst_106302 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_106293,(112));
var inst_106303 = [inst_106296,inst_106297,inst_106299,inst_106300,inst_106301,inst_106302];
var inst_106304 = cljs.core.PersistentHashMap.fromArrays(inst_106294,inst_106303);
var state_106308__$1 = state_106308;
var statearr_106313_106324 = state_106308__$1;
(statearr_106313_106324[(2)] = inst_106304);


cljs.core.async.impl.ioc_helpers.process_exception(state_106308__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_106309 === (6))){
var inst_106277 = (state_106308[(2)]);
var state_106308__$1 = (function (){var statearr_106314 = state_106308;
(statearr_106314[(7)] = inst_106277);

return statearr_106314;
})();
var statearr_106315_106325 = state_106308__$1;
(statearr_106315_106325[(2)] = null);


cljs.core.async.impl.ioc_helpers.process_exception(state_106308__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_106309 === (7))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_106308,(6),cljs.core.cst$kw$default,null,(5));
var inst_106281 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_106282 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_106283 = ["_setting/id","root"];
var inst_106284 = (new cljs.core.PersistentVector(null,2,(5),inst_106282,inst_106283,null));
var inst_106285 = [inst_106284];
var inst_106286 = (new cljs.core.PersistentVector(null,1,(5),inst_106281,inst_106285,null));
var inst_106287 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_106286);
var state_106308__$1 = state_106308;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_106308__$1,(8),inst_106287);
} else {
if((state_val_106309 === (8))){
var inst_106289 = (state_106308[(2)]);
var inst_106290 = fluree.db.util.async.throw_err(inst_106289);
var state_106308__$1 = state_106308;
var statearr_106316_106326 = state_106308__$1;
(statearr_106316_106326[(2)] = inst_106290);


cljs.core.async.impl.ioc_helpers.process_exception(state_106308__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$setting_map_$_state_machine__100742__auto__ = null;
var fluree$db$query$schema$setting_map_$_state_machine__100742__auto____0 = (function (){
var statearr_106317 = [null,null,null,null,null,null,null,null];
(statearr_106317[(0)] = fluree$db$query$schema$setting_map_$_state_machine__100742__auto__);

(statearr_106317[(1)] = (1));

return statearr_106317;
});
var fluree$db$query$schema$setting_map_$_state_machine__100742__auto____1 = (function (state_106308){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_106308);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e106318){if((e106318 instanceof Object)){
var ex__100745__auto__ = e106318;
var statearr_106319_106327 = state_106308;
(statearr_106319_106327[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_106308);

return cljs.core.cst$kw$recur;
} else {
throw e106318;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__106328 = state_106308;
state_106308 = G__106328;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$query$schema$setting_map_$_state_machine__100742__auto__ = function(state_106308){
switch(arguments.length){
case 0:
return fluree$db$query$schema$setting_map_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$query$schema$setting_map_$_state_machine__100742__auto____1.call(this,state_106308);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$setting_map_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$setting_map_$_state_machine__100742__auto____0;
fluree$db$query$schema$setting_map_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$setting_map_$_state_machine__100742__auto____1;
return fluree$db$query$schema$setting_map_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_106320 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_106320[(6)] = c__100848__auto__);

return statearr_106320;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
/**
 * Returns schema version from a db, which is the :t when the schema was last updated.
 */
fluree.db.query.schema.version = (function fluree$db$query$schema$version(db){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$schema,cljs.core.cst$kw$t], null));
});
