// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true}
goog.provide('fluree.db.query.analytical_wikidata');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
fluree.db.query.analytical_wikidata.variable_QMARK_ = (function fluree$db$query$analytical_wikidata$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
/**
 * Takes replacement vars, retrieves values from ctx, and puts into Wikidata VALUES statement,
 *   i.e. VALUES (?name ?countryName) {("Vincent van Gogh" "Kingdom of the Netherlands") ("Edvard Munch" "Norway")}
 */
fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt = (function fluree$db$query$analytical_wikidata$replacementVars__GT_ValuesSmt(vars,values){
var value_groups = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (value_group){
var stringified = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__109637_SHARP_){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__109637_SHARP_),"\""].join('');
}),value_group);
var joined_group = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",stringified);
return [" ( ",joined_group," ) "].join('');
}),values);
var value_group_str = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",value_groups);
return ["VALUES ( ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",vars)," ) { ",value_group_str," } "].join('');
});
fluree.db.query.analytical_wikidata.get_next_wd_clauses = (function fluree$db$query$analytical_wikidata$get_next_wd_clauses(coll){
var G__109641 = coll;
var vec__109642 = G__109641;
var seq__109643 = cljs.core.seq(vec__109642);
var first__109644 = cljs.core.first(seq__109643);
var seq__109643__$1 = cljs.core.next(seq__109643);
var clause = first__109644;
var r = seq__109643__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__109641__$1 = G__109641;
var res__$1 = res;
while(true){
var vec__109648 = G__109641__$1;
var seq__109649 = cljs.core.seq(vec__109648);
var first__109650 = cljs.core.first(seq__109649);
var seq__109649__$1 = cljs.core.next(seq__109649);
var clause__$1 = first__109650;
var r__$1 = seq__109649__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__109651 = r__$1;
var G__109652 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__109641__$1 = G__109651;
res__$1 = G__109652;
continue;
} else {
return res__$2;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.get_all_wd_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_clauses(coll){
var G__109656 = coll;
var vec__109657 = G__109656;
var seq__109658 = cljs.core.seq(vec__109657);
var first__109659 = cljs.core.first(seq__109658);
var seq__109658__$1 = cljs.core.next(seq__109658);
var clause = first__109659;
var r = seq__109658__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__109656__$1 = G__109656;
var res__$1 = res;
while(true){
var vec__109663 = G__109656__$1;
var seq__109664 = cljs.core.seq(vec__109663);
var first__109665 = cljs.core.first(seq__109664);
var seq__109664__$1 = cljs.core.next(seq__109664);
var clause__$1 = first__109665;
var r__$1 = seq__109664__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__109666 = r__$1;
var G__109667 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,cljs.core.rest(clause__$1));
G__109656__$1 = G__109666;
res__$1 = G__109667;
continue;
} else {
var G__109668 = r__$1;
var G__109669 = res__$2;
G__109656__$1 = G__109668;
res__$1 = G__109669;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.drop_all_wd_clauses = (function fluree$db$query$analytical_wikidata$drop_all_wd_clauses(coll){
var G__109673 = coll;
var vec__109674 = G__109673;
var seq__109675 = cljs.core.seq(vec__109674);
var first__109676 = cljs.core.first(seq__109675);
var seq__109675__$1 = cljs.core.next(seq__109675);
var clause = first__109676;
var r = seq__109675__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__109673__$1 = G__109673;
var res__$1 = res;
while(true){
var vec__109680 = G__109673__$1;
var seq__109681 = cljs.core.seq(vec__109680);
var first__109682 = cljs.core.first(seq__109681);
var seq__109681__$1 = cljs.core.next(seq__109681);
var clause__$1 = first__109682;
var r__$1 = seq__109681__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__109683 = r__$1;
var G__109684 = res__$2;
G__109673__$1 = G__109683;
res__$1 = G__109684;
continue;
} else {
var G__109685 = r__$1;
var G__109686 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__109673__$1 = G__109685;
res__$1 = G__109686;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.wikiDataVar_QMARK_ = (function fluree$db$query$analytical_wikidata$wikiDataVar_QMARK_(string){
if(cljs.core.truth_(((typeof string === 'string')?cljs.core.re_matches(/^wd(t)*:(P|Q)\d+$/,string):false))){
cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(string);
} else {
if(typeof string === 'string'){
["\"",string,"\""].join('');
} else {
}
}


return string;
});
fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata = (function fluree$db$query$analytical_wikidata$ad_hoc_clause_to_wikidata(clause,optional_QMARK_){
var clause_str = [clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical_wikidata.wikiDataVar_QMARK_,clause)),"."].join('');
if(cljs.core.truth_(optional_QMARK_)){
return ["OPTIONAL {",clause_str,"}"].join('');
} else {
return clause_str;
}
});
fluree.db.query.analytical_wikidata.parse_prefixes = (function fluree$db$query$analytical_wikidata$parse_prefixes(prefixes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc_str,prefix){
var pfx = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([fluree.db.util.core.keyword__GT_str(cljs.core.key(prefix)),":"].join(''));
var source = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.val(prefix));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc_str)," PREFIX ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfx)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source)," \n "].join('');
}),"",prefixes);
});
fluree.db.query.analytical_wikidata.generateWikiDataQuery = (function fluree$db$query$analytical_wikidata$generateWikiDataQuery(q_map,clauses,select_vars,value_clause,optional_clauses){
var opts = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$limit,(100),cljs.core.cst$kw$offset,(0),cljs.core.cst$kw$distinct,false,cljs.core.cst$kw$language,"en"], null),cljs.core.cst$kw$wikidataOpts.cljs$core$IFn$_invoke$arity$1(q_map),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$wikidataOpts], null),q_map)], 0));
var map__109690 = opts;
var map__109690__$1 = (((((!((map__109690 == null))))?(((((map__109690.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__109690.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__109690):map__109690);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__109690__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__109690__$1,cljs.core.cst$kw$offset);
var distinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__109690__$1,cljs.core.cst$kw$distinct);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__109690__$1,cljs.core.cst$kw$language);
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__109690__$1,cljs.core.cst$kw$prefixes);
var prefixes__$1 = (cljs.core.truth_(prefixes)?fluree.db.query.analytical_wikidata.parse_prefixes(prefixes):null);
var select_smt = ["SELECT ",(cljs.core.truth_(distinct)?"DISTINCT ":null)," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__109687_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__109687_SHARP_),"Label"].join('');
}),select_vars))," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",select_vars)].join('');
var where_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__109688_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__109688_SHARP_,false);
}),clauses));
var optional_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__109689_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__109689_SHARP_,true);
}),optional_clauses));
var serviceLabel = ["SERVICE wikibase:label { bd:serviceParam wikibase:language \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4126__auto__ = language;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return "en";
}
})()),"\" . }"].join('');
var full_query = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefixes__$1)," ",select_smt," WHERE { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_clause)," ",where_smt," ",optional_smt," ",serviceLabel," } ",(cljs.core.truth_(limit)?["\n                          LIMIT ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit)].join(''):null)," OFFSET ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset)].join('');
return full_query;
});
fluree.db.query.analytical_wikidata.wikidataURL = "https://query.wikidata.org/bigdata/namespace/wdq/sparql?format=json&query=";
fluree.db.query.analytical_wikidata.submit_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_wikidata_query(query){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_109705){
var state_val_109706 = (state_109705[(1)]);
if((state_val_109706 === (1))){
var inst_109692 = fluree.db.util.core.url_encode(query);
var inst_109693 = [fluree.db.query.analytical_wikidata.wikidataURL,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_109692)].join('');
var inst_109694 = ["User-Agent","Accept"];
var inst_109695 = ["Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36","application/sparql-results+json"];
var inst_109696 = cljs.core.PersistentHashMap.fromArrays(inst_109694,inst_109695);
var inst_109697 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$request_DASH_timeout,cljs.core.cst$kw$output_DASH_format];
var inst_109698 = [inst_109696,(30000),cljs.core.cst$kw$wikidata];
var inst_109699 = cljs.core.PersistentHashMap.fromArrays(inst_109697,inst_109698);
var inst_109700 = fluree.db.util.xhttp.get(inst_109693,inst_109699);
var state_109705__$1 = state_109705;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_109705__$1,(2),inst_109700);
} else {
if((state_val_109706 === (2))){
var inst_109702 = (state_109705[(2)]);
var inst_109703 = fluree.db.util.async.throw_err(inst_109702);
var state_109705__$1 = state_109705;
return cljs.core.async.impl.ioc_helpers.return_chan(state_109705__$1,inst_109703);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__100742__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__100742__auto____0 = (function (){
var statearr_109707 = [null,null,null,null,null,null,null];
(statearr_109707[(0)] = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__100742__auto__);

(statearr_109707[(1)] = (1));

return statearr_109707;
});
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__100742__auto____1 = (function (state_109705){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_109705);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e109708){if((e109708 instanceof Object)){
var ex__100745__auto__ = e109708;
var statearr_109709_109711 = state_109705;
(statearr_109709_109711[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_109705);

return cljs.core.cst$kw$recur;
} else {
throw e109708;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__109712 = state_109705;
state_109705 = G__109712;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__100742__auto__ = function(state_109705){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__100742__auto____1.call(this,state_109705);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__100742__auto____0;
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__100742__auto____1;
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_109710 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_109710[(6)] = c__100848__auto__);

return statearr_109710;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query(query){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_109730){
var state_val_109731 = (state_109730[(1)]);
if((state_val_109731 === (1))){
var inst_109713 = fluree.db.query.analytical_wikidata.submit_wikidata_query(query);
var state_109730__$1 = state_109730;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_109730__$1,(2),inst_109713);
} else {
if((state_val_109731 === (2))){
var inst_109716 = (state_109730[(7)]);
var inst_109715 = (state_109730[(2)]);
var inst_109716__$1 = fluree.db.util.async.throw_err(inst_109715);
var inst_109717 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_109716__$1);
var inst_109718 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_109717);
var state_109730__$1 = (function (){var statearr_109732 = state_109730;
(statearr_109732[(7)] = inst_109716__$1);

return statearr_109732;
})();
if(inst_109718){
var statearr_109733_109741 = state_109730__$1;
(statearr_109733_109741[(1)] = (3));

} else {
var statearr_109734_109742 = state_109730__$1;
(statearr_109734_109742[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_109731 === (3))){
var inst_109716 = (state_109730[(7)]);
var state_109730__$1 = state_109730;
var statearr_109735_109743 = state_109730__$1;
(statearr_109735_109743[(2)] = inst_109716);

(statearr_109735_109743[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109731 === (4))){
var inst_109716 = (state_109730[(7)]);
var inst_109721 = (function (){var body = inst_109716;
return (function (item){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,k_v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.key(k_v),cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(cljs.core.val(k_v)));
}),cljs.core.PersistentArrayMap.EMPTY,item);
});
})();
var inst_109722 = cljs.core.second(inst_109716);
var inst_109723 = cljs.core.second(inst_109722);
var inst_109724 = cljs.core.first(inst_109723);
var inst_109725 = cljs.core.second(inst_109724);
var inst_109726 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_109721,inst_109725);
var state_109730__$1 = state_109730;
var statearr_109736_109744 = state_109730__$1;
(statearr_109736_109744[(2)] = inst_109726);

(statearr_109736_109744[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109731 === (5))){
var inst_109728 = (state_109730[(2)]);
var state_109730__$1 = state_109730;
return cljs.core.async.impl.ioc_helpers.return_chan(state_109730__$1,inst_109728);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__100742__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__100742__auto____0 = (function (){
var statearr_109737 = [null,null,null,null,null,null,null,null];
(statearr_109737[(0)] = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__100742__auto__);

(statearr_109737[(1)] = (1));

return statearr_109737;
});
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__100742__auto____1 = (function (state_109730){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_109730);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e109738){if((e109738 instanceof Object)){
var ex__100745__auto__ = e109738;
var statearr_109739_109745 = state_109730;
(statearr_109739_109745[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_109730);

return cljs.core.cst$kw$recur;
} else {
throw e109738;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__109746 = state_109730;
state_109730 = G__109746;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__100742__auto__ = function(state_109730){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__100742__auto____1.call(this,state_109730);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__100742__auto____0;
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__100742__auto____1;
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_109740 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_109740[(6)] = c__100848__auto__);

return statearr_109740;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples = (function fluree$db$query$analytical_wikidata$wikiDataResp__GT_tuples(wikidataRes,vars){
var labelVars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__109747_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__109747_SHARP_),"Label"].join(''));
}),vars);
var headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,vars),labelVars);
var headers_as_kws = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__109748_SHARP_){
return fluree.db.util.core.str__GT_keyword(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__109748_SHARP_),(1)));
}),headers);
var results = cljs.core.cst$kw$bindings.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$results.cljs$core$IFn$_invoke$arity$1(wikidataRes));
var tuples = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__109749_SHARP_){
return cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1((p1__109749_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__109749_SHARP_.cljs$core$IFn$_invoke$arity$1(res) : p1__109749_SHARP_.call(null,res)));
}),headers_as_kws);
}),results);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$vars,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$tuples,tuples], null);
});
fluree.db.query.analytical_wikidata.get_wikidata_tuples = (function fluree$db$query$analytical_wikidata$get_wikidata_tuples(q_map,clauses,matching_vars,matching_vals,all_vars,optional_clauses){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_109784){
var state_val_109785 = (state_109784[(1)]);
if((state_val_109785 === (7))){
var inst_109759 = (state_109784[(2)]);
var inst_109760 = fluree.db.query.analytical_wikidata.generateWikiDataQuery(q_map,clauses,all_vars,inst_109759,optional_clauses);
var inst_109761 = fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query(inst_109760);
var state_109784__$1 = state_109784;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_109784__$1,(8),inst_109761);
} else {
if((state_val_109785 === (1))){
var state_109784__$1 = state_109784;
var statearr_109786_109802 = state_109784__$1;
(statearr_109786_109802[(2)] = null);

(statearr_109786_109802[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109785 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_109784,(3),Error,null,(2));
var inst_109754 = cljs.core.empty_QMARK_(matching_vars);
var state_109784__$1 = state_109784;
if(inst_109754){
var statearr_109787_109803 = state_109784__$1;
(statearr_109787_109803[(1)] = (5));

} else {
var statearr_109788_109804 = state_109784__$1;
(statearr_109788_109804[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_109785 === (6))){
var inst_109757 = fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt(matching_vars,matching_vals);
var state_109784__$1 = state_109784;
var statearr_109789_109805 = state_109784__$1;
(statearr_109789_109805[(2)] = inst_109757);

(statearr_109789_109805[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109785 === (3))){
var inst_109750 = (state_109784[(2)]);
var state_109784__$1 = state_109784;
var statearr_109790_109806 = state_109784__$1;
(statearr_109790_109806[(2)] = inst_109750);


cljs.core.async.impl.ioc_helpers.process_exception(state_109784__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_109785 === (2))){
var inst_109782 = (state_109784[(2)]);
var state_109784__$1 = state_109784;
return cljs.core.async.impl.ioc_helpers.return_chan(state_109784__$1,inst_109782);
} else {
if((state_val_109785 === (11))){
var inst_109780 = (state_109784[(2)]);
var state_109784__$1 = state_109784;
var statearr_109791_109807 = state_109784__$1;
(statearr_109791_109807[(2)] = inst_109780);


cljs.core.async.impl.ioc_helpers.process_exception(state_109784__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_109785 === (9))){
var inst_109764 = (state_109784[(7)]);
var inst_109768 = cljs.core.cst$kw$message.cljs$core$IFn$_invoke$arity$1(inst_109764);
var inst_109769 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(inst_109768,(0),(1000));
var inst_109770 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_109771 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_109764);
var inst_109772 = cljs.core.cst$kw$error.cljs$core$IFn$_invoke$arity$1(inst_109764);
var inst_109773 = [inst_109771,inst_109772];
var inst_109774 = cljs.core.PersistentHashMap.fromArrays(inst_109770,inst_109773);
var inst_109775 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_109769,inst_109774);
var inst_109776 = (function(){throw inst_109775})();
var state_109784__$1 = state_109784;
var statearr_109792_109808 = state_109784__$1;
(statearr_109792_109808[(2)] = inst_109776);

(statearr_109792_109808[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109785 === (5))){
var state_109784__$1 = state_109784;
var statearr_109793_109809 = state_109784__$1;
(statearr_109793_109809[(2)] = null);

(statearr_109793_109809[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109785 === (10))){
var inst_109764 = (state_109784[(7)]);
var inst_109778 = fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples(inst_109764,all_vars);
var state_109784__$1 = state_109784;
var statearr_109794_109810 = state_109784__$1;
(statearr_109794_109810[(2)] = inst_109778);

(statearr_109794_109810[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109785 === (8))){
var inst_109764 = (state_109784[(7)]);
var inst_109763 = (state_109784[(2)]);
var inst_109764__$1 = fluree.db.util.async.throw_err(inst_109763);
var inst_109765 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_109764__$1);
var inst_109766 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((400),inst_109765);
var state_109784__$1 = (function (){var statearr_109795 = state_109784;
(statearr_109795[(7)] = inst_109764__$1);

return statearr_109795;
})();
if(inst_109766){
var statearr_109796_109811 = state_109784__$1;
(statearr_109796_109811[(1)] = (9));

} else {
var statearr_109797_109812 = state_109784__$1;
(statearr_109797_109812[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__100742__auto__ = null;
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__100742__auto____0 = (function (){
var statearr_109798 = [null,null,null,null,null,null,null,null];
(statearr_109798[(0)] = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__100742__auto__);

(statearr_109798[(1)] = (1));

return statearr_109798;
});
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__100742__auto____1 = (function (state_109784){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_109784);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e109799){if((e109799 instanceof Object)){
var ex__100745__auto__ = e109799;
var statearr_109800_109813 = state_109784;
(statearr_109800_109813[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_109784);

return cljs.core.cst$kw$recur;
} else {
throw e109799;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__109814 = state_109784;
state_109784 = G__109814;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__100742__auto__ = function(state_109784){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__100742__auto____1.call(this,state_109784);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__100742__auto____0;
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__100742__auto____1;
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_109801 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_109801[(6)] = c__100848__auto__);

return statearr_109801;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
