// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true}
goog.provide('fluree.db.operations');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
/**
 * Returns true if connection has been closed.
 */
fluree.db.operations.conn_closed_QMARK_ = (function fluree$db$operations$conn_closed_QMARK_(conn){
return cljs.core.cst$kw$close_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Creates the operation header.
 */
fluree.db.operations.formulate_op_header = (function fluree$db$operations$formulate_op_header(var_args){
var G__108058 = arguments.length;
switch (G__108058) {
case 2:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2 = (function (operation,db){
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3(operation,db,(60000));
}));

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3 = (function (operation,db,timeout){
var req_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid());
var header = new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$db,db,cljs.core.cst$kw$op,operation,cljs.core.cst$kw$req_DASH_id,req_id,cljs.core.cst$kw$timestamp,fluree.db.util.core.current_time_millis(),cljs.core.cst$kw$timeout,timeout], null);
return header;
}));

(fluree.db.operations.formulate_op_header.cljs$lang$maxFixedArity = 3);

/**
 * Sends operation off, returns core async promise channel that will have eventual response
 *   or timeout response.
 * 
 *   Records the request-id which is stored in an atom along with the response channel.
 * 
 *   Incoming ledger notifications will look at request id and see if
 *   there is a matching request-id in the record with its corresponding
 *   async channel, and if so it will populate that channel with the response.
 * 
 *   We use the timeout to create a timeout channel, so if no transactions with
 *   the corresponding request id are 'seen' in that timeframe, a timeout response
 *   is given.
 */
fluree.db.operations.send_operation = (function fluree$db$operations$send_operation(var_args){
var G__108061 = arguments.length;
switch (G__108061) {
case 3:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3 = (function (conn,operation,data){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4(conn,operation,data,null);
}));

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4 = (function (conn,operation,data,opts){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__100848__auto___108104 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_108089){
var state_val_108090 = (state_108089[(1)]);
if((state_val_108090 === (1))){
var state_108089__$1 = state_108089;
var statearr_108091_108105 = state_108089__$1;
(statearr_108091_108105[(2)] = null);

(statearr_108091_108105[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108090 === (2))){
var inst_108087 = (state_108089[(2)]);
var state_108089__$1 = state_108089;
return cljs.core.async.impl.ioc_helpers.return_chan(state_108089__$1,inst_108087);
} else {
if((state_val_108090 === (3))){
var inst_108062 = (state_108089[(2)]);
var inst_108063 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_108062);
var state_108089__$1 = state_108089;
var statearr_108092_108106 = state_108089__$1;
(statearr_108092_108106[(2)] = inst_108063);


cljs.core.async.impl.ioc_helpers.process_exception(state_108089__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_108090 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_108089,(3),cljs.core.cst$kw$default,null,(2));
var inst_108067 = fluree.db.operations.conn_closed_QMARK_(conn);
var state_108089__$1 = state_108089;
if(cljs.core.truth_(inst_108067)){
var statearr_108093_108107 = state_108089__$1;
(statearr_108093_108107[(1)] = (5));

} else {
var statearr_108094_108108 = state_108089__$1;
(statearr_108094_108108[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108090 === (5))){
var inst_108069 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_108070 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_connection];
var inst_108071 = cljs.core.PersistentHashMap.fromArrays(inst_108069,inst_108070);
var inst_108072 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection was closed.",inst_108071);
var inst_108073 = (function(){throw inst_108072})();
var state_108089__$1 = state_108089;
var statearr_108095_108109 = state_108089__$1;
(statearr_108095_108109[(2)] = inst_108073);

(statearr_108095_108109[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108090 === (6))){
var inst_108075 = cljs.core.cst$kw$req_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var inst_108076 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_108077 = [operation,data,pc,opts];
var inst_108078 = (new cljs.core.PersistentVector(null,4,(5),inst_108076,inst_108077,null));
var inst_108079 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_108075,inst_108078);
var inst_108080 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_108081 = [operation,data,pc,opts];
var inst_108082 = (new cljs.core.PersistentVector(null,4,(5),inst_108080,inst_108081,null));
var inst_108083 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Put operation on connection req-chan: ",inst_108082], 0));
var state_108089__$1 = (function (){var statearr_108096 = state_108089;
(statearr_108096[(7)] = inst_108079);

return statearr_108096;
})();
var statearr_108097_108110 = state_108089__$1;
(statearr_108097_108110[(2)] = inst_108083);

(statearr_108097_108110[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108090 === (7))){
var inst_108085 = (state_108089[(2)]);
var state_108089__$1 = state_108089;
var statearr_108098_108111 = state_108089__$1;
(statearr_108098_108111[(2)] = inst_108085);


cljs.core.async.impl.ioc_helpers.process_exception(state_108089__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$operations$state_machine__100742__auto__ = null;
var fluree$db$operations$state_machine__100742__auto____0 = (function (){
var statearr_108099 = [null,null,null,null,null,null,null,null];
(statearr_108099[(0)] = fluree$db$operations$state_machine__100742__auto__);

(statearr_108099[(1)] = (1));

return statearr_108099;
});
var fluree$db$operations$state_machine__100742__auto____1 = (function (state_108089){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_108089);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e108100){if((e108100 instanceof Object)){
var ex__100745__auto__ = e108100;
var statearr_108101_108112 = state_108089;
(statearr_108101_108112[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_108089);

return cljs.core.cst$kw$recur;
} else {
throw e108100;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__108113 = state_108089;
state_108089 = G__108113;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$operations$state_machine__100742__auto__ = function(state_108089){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__100742__auto____1.call(this,state_108089);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__100742__auto____0;
fluree$db$operations$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__100742__auto____1;
return fluree$db$operations$state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_108102 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_108102[(6)] = c__100848__auto___108104);

return statearr_108102;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));


return pc;
}));

(fluree.db.operations.send_operation.cljs$lang$maxFixedArity = 4);

/**
 * A quick async response to confirm as initiated, but deletion happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.delete_ledger_async = (function fluree$db$operations$delete_ledger_async(var_args){
var G__108115 = arguments.length;
switch (G__108115) {
case 1:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2(session,null);
}));

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2 = (function (session,p__108116){
var map__108117 = p__108116;
var map__108117__$1 = (((((!((map__108117 == null))))?(((((map__108117.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__108117.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__108117):map__108117);
var opts = map__108117__$1;
var snapshot_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__108117__$1,cljs.core.cst$kw$snapshot_QMARK_);
var map__108119 = session;
var map__108119__$1 = (((((!((map__108119 == null))))?(((((map__108119.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__108119.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__108119):map__108119);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__108119__$1,cljs.core.cst$kw$dbid);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__108119__$1,cljs.core.cst$kw$network);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__108119__$1,cljs.core.cst$kw$conn);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$delete_DASH_db,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$network,network,cljs.core.cst$kw$dbid,dbid,cljs.core.cst$kw$snapshot_QMARK_,snapshot_QMARK_], null));
}));

(fluree.db.operations.delete_ledger_async.cljs$lang$maxFixedArity = 2);

/**
 * A quick async response to confirm as initiated, but garbage collection happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.garbage_collect_async = (function fluree$db$operations$garbage_collect_async(var_args){
var args__4742__auto__ = [];
var len__4736__auto___108178 = arguments.length;
var i__4737__auto___108179 = (0);
while(true){
if((i__4737__auto___108179 < len__4736__auto___108178)){
args__4742__auto__.push((arguments[i__4737__auto___108179]));

var G__108180 = (i__4737__auto___108179 + (1));
i__4737__auto___108179 = G__108180;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic = (function (session,p__108124){
var vec__108125 = p__108124;
var map__108128 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__108125,(0),null);
var map__108128__$1 = (((((!((map__108128 == null))))?(((((map__108128.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__108128.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__108128):map__108128);
var toBlock = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__108128__$1,cljs.core.cst$kw$toBlock);
var toTime = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__108128__$1,cljs.core.cst$kw$toTime);
var opts = vec__108125;
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_108160){
var state_val_108161 = (state_108160[(1)]);
if((state_val_108161 === (7))){
var inst_108143 = (state_108160[(2)]);
var state_108160__$1 = state_108160;
var statearr_108162_108181 = state_108160__$1;
(statearr_108162_108181[(2)] = inst_108143);

(statearr_108162_108181[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108161 === (1))){
var inst_108132 = (session == null);
var inst_108133 = cljs.core.not(inst_108132);
var state_108160__$1 = state_108160;
if(inst_108133){
var statearr_108163_108182 = state_108160__$1;
(statearr_108163_108182[(1)] = (2));

} else {
var statearr_108164_108183 = state_108160__$1;
(statearr_108164_108183[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108161 === (4))){
var inst_108146 = (state_108160[(2)]);
var state_108160__$1 = state_108160;
if(cljs.core.truth_(inst_108146)){
var statearr_108165_108184 = state_108160__$1;
(statearr_108165_108184[(1)] = (8));

} else {
var statearr_108166_108185 = state_108160__$1;
(statearr_108166_108185[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108161 === (6))){
var state_108160__$1 = state_108160;
var statearr_108167_108186 = state_108160__$1;
(statearr_108167_108186[(2)] = false);

(statearr_108167_108186[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108161 === (3))){
var state_108160__$1 = state_108160;
var statearr_108168_108187 = state_108160__$1;
(statearr_108168_108187[(2)] = false);

(statearr_108168_108187[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108161 === (2))){
var inst_108135 = session.cljs$lang$protocol_mask$partition0$;
var inst_108136 = (inst_108135 & (64));
var inst_108137 = session.cljs$core$ISeq$;
var inst_108138 = (cljs.core.PROTOCOL_SENTINEL === inst_108137);
var inst_108139 = ((inst_108136) || (inst_108138));
var state_108160__$1 = state_108160;
if(cljs.core.truth_(inst_108139)){
var statearr_108169_108188 = state_108160__$1;
(statearr_108169_108188[(1)] = (5));

} else {
var statearr_108170_108189 = state_108160__$1;
(statearr_108170_108189[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108161 === (9))){
var state_108160__$1 = state_108160;
var statearr_108171_108190 = state_108160__$1;
(statearr_108171_108190[(2)] = session);

(statearr_108171_108190[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108161 === (5))){
var state_108160__$1 = state_108160;
var statearr_108172_108191 = state_108160__$1;
(statearr_108172_108191[(2)] = true);

(statearr_108172_108191[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108161 === (10))){
var inst_108151 = (state_108160[(2)]);
var inst_108152 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_108151,cljs.core.cst$kw$network);
var inst_108153 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_108151,cljs.core.cst$kw$dbid);
var inst_108154 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_108151,cljs.core.cst$kw$conn);
var inst_108155 = [cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$toBlock,cljs.core.cst$kw$toTime];
var inst_108156 = [inst_108152,inst_108153,toBlock,toTime];
var inst_108157 = cljs.core.PersistentHashMap.fromArrays(inst_108155,inst_108156);
var inst_108158 = fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(inst_108154,cljs.core.cst$kw$garbage,inst_108157);
var state_108160__$1 = state_108160;
return cljs.core.async.impl.ioc_helpers.return_chan(state_108160__$1,inst_108158);
} else {
if((state_val_108161 === (8))){
var inst_108148 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,session);
var state_108160__$1 = state_108160;
var statearr_108173_108192 = state_108160__$1;
(statearr_108173_108192[(2)] = inst_108148);

(statearr_108173_108192[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$operations$state_machine__100742__auto__ = null;
var fluree$db$operations$state_machine__100742__auto____0 = (function (){
var statearr_108174 = [null,null,null,null,null,null,null];
(statearr_108174[(0)] = fluree$db$operations$state_machine__100742__auto__);

(statearr_108174[(1)] = (1));

return statearr_108174;
});
var fluree$db$operations$state_machine__100742__auto____1 = (function (state_108160){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_108160);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e108175){if((e108175 instanceof Object)){
var ex__100745__auto__ = e108175;
var statearr_108176_108193 = state_108160;
(statearr_108176_108193[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_108160);

return cljs.core.cst$kw$recur;
} else {
throw e108175;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__108194 = state_108160;
state_108160 = G__108194;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$operations$state_machine__100742__auto__ = function(state_108160){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__100742__auto____1.call(this,state_108160);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__100742__auto____0;
fluree$db$operations$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__100742__auto____1;
return fluree$db$operations$state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_108177 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_108177[(6)] = c__100848__auto__);

return statearr_108177;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
}));

(fluree.db.operations.garbage_collect_async.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.operations.garbage_collect_async.cljs$lang$applyTo = (function (seq108122){
var G__108123 = cljs.core.first(seq108122);
var seq108122__$1 = cljs.core.next(seq108122);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__108123,seq108122__$1);
}));

/**
 * A quick async response to confirm, but archival happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.snapshot_ledger_async = (function fluree$db$operations$snapshot_ledger_async(session,opts){
var map__108195 = session;
var map__108195__$1 = (((((!((map__108195 == null))))?(((((map__108195.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__108195.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__108195):map__108195);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__108195__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__108195__$1,cljs.core.cst$kw$dbid);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__108195__$1,cljs.core.cst$kw$conn);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$snapshot_DASH_db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Submits a command to connected tx-group server
 */
fluree.db.operations.command_async = (function fluree$db$operations$command_async(conn,cmd){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$cmd,cmd);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.unsigned_command_async = (function fluree$db$operations$unsigned_command_async(conn,unsigned_cmd_map){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$unsigned_DASH_cmd,unsigned_cmd_map);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_info_async = (function fluree$db$operations$ledger_info_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$ledger_DASH_info,ledger);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_status_async = (function fluree$db$operations$ledger_status_async(conn,ledger){
return cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$ledger_DASH_info,ledger));
});
/**
 * Returns stats about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_stats_async = (function fluree$db$operations$ledger_stats_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$ledger_DASH_stats,ledger);
});
/**
 * Returns a list of ledgers in two-tuples of [network ledger-id].
 */
fluree.db.operations.ledgers_async = (function fluree$db$operations$ledgers_async(conn){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$db_DASH_list,null);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.transact_async = (function fluree$db$operations$transact_async(conn,tx_map){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Sending transaction async: ",tx_map], 0));

return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$tx,tx_map);
});
/**
 * Starts a subscription to the session's ledger.
 * 
 *   Supported options:
 *   - auth    - auth, if specified, takes precedence
 *   - jwt     - valid jwt
 *   
 */
fluree.db.operations.subscribe = (function fluree$db$operations$subscribe(var_args){
var G__108198 = arguments.length;
switch (G__108198) {
case 1:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,null);
}));

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2 = (function (session,opts){
var map__108199 = opts;
var map__108199__$1 = (((((!((map__108199 == null))))?(((((map__108199.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__108199.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__108199):map__108199);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__108199__$1,cljs.core.cst$kw$auth);
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__108199__$1,cljs.core.cst$kw$jwt);
var conn = cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(session);
var auth_or_jwt = (function (){var or__4126__auto__ = auth;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return jwt;
}
})();
var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Subscribe to: ",cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session),auth_or_jwt], 0));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$subscribe,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session)], null),auth_or_jwt], null));
}));

(fluree.db.operations.subscribe.cljs$lang$maxFixedArity = 2);

/**
 * Unsubscribes from the session's ledger.
 */
fluree.db.operations.unsubscribe = (function fluree$db$operations$unsubscribe(session){
var conn = cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(session);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$unsbuscribe,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session)], null));
});
