// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true}
goog.provide('fluree.db.graphdb');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.util.schema');
goog.require('clojure.data.avl');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.index');
goog.require('fluree.db.query.range');
goog.require('fluree.db.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
/**
 * Returns when ledger name is valid.
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_name = (function fluree$db$graphdb$validate_ledger_name(ledger_id,type){
if(cljs.core.truth_(cljs.core.re_matches(/^[a-z0-9-]{1,100}/,ledger_id))){
return null;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)," id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Must match a-z0-9- and be no more than 100 characters long."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_db], null));
}
});
/**
 * Returns two-tuple of [network name-or-dbid] if db-ident is valid.
 * 
 *   Will ignore a direct db name reference (prefixed with '_')
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_ident = (function fluree$db$graphdb$validate_ledger_ident(ledger){
var vec__116107 = cljs.core.re_find(/^([^\/]+)\/(?:_)?([^\/]+)$/,fluree.db.util.core.keyword__GT_str(ledger));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__116107,(0),null);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__116107,(1),null);
var maybe_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__116107,(2),null);
if(cljs.core.truth_((function (){var and__4115__auto__ = network;
if(cljs.core.truth_(and__4115__auto__)){
return maybe_alias;
} else {
return and__4115__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,maybe_alias], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_ledger_DASH_name], null));
}
});
fluree.db.graphdb.exclude_predicates = cljs.core.PersistentHashSet.createAsIfByAssoc([(107),(108),(106)]);
fluree.db.graphdb.add_predicate_to_idx = (function fluree$db$graphdb$add_predicate_to_idx(db,pred_id){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_116201){
var state_val_116202 = (state_116201[(1)]);
if((state_val_116202 === (7))){
var state_116201__$1 = state_116201;
var statearr_116203_116242 = state_116201__$1;
(statearr_116203_116242[(2)] = false);

(statearr_116203_116242[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116202 === (20))){
var inst_116165 = (state_116201[(2)]);
var state_116201__$1 = state_116201;
var statearr_116204_116243 = state_116201__$1;
(statearr_116204_116243[(2)] = inst_116165);

(statearr_116204_116243[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116202 === (1))){
var state_116201__$1 = state_116201;
var statearr_116205_116244 = state_116201__$1;
(statearr_116205_116244[(2)] = null);

(statearr_116205_116244[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116202 === (24))){
var inst_116178 = ["You cannot add ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_id)," to the index at this point. There are too many affected flakes."].join('');
var inst_116179 = [cljs.core.cst$kw$error,cljs.core.cst$kw$status];
var inst_116180 = [cljs.core.cst$kw$db_SLASH_max_DASH_novelty_DASH_size,(400)];
var inst_116181 = cljs.core.PersistentHashMap.fromArrays(inst_116179,inst_116180);
var inst_116182 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_116178,inst_116181);
var inst_116183 = (function(){throw inst_116182})();
var state_116201__$1 = state_116201;
var statearr_116206_116245 = state_116201__$1;
(statearr_116206_116245[(2)] = inst_116183);

(statearr_116206_116245[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116202 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_116201,(3),Error,null,(2));
var inst_116116 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_116117 = [pred_id];
var inst_116118 = (new cljs.core.PersistentVector(null,1,(5),inst_116116,inst_116117,null));
var inst_116119 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_116118);
var state_116201__$1 = state_116201;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_116201__$1,(5),inst_116119);
} else {
if((state_val_116202 === (15))){
var inst_116152 = (state_116201[(7)]);
var inst_116157 = inst_116152.cljs$lang$protocol_mask$partition0$;
var inst_116158 = (inst_116157 & (64));
var inst_116159 = inst_116152.cljs$core$ISeq$;
var inst_116160 = (cljs.core.PROTOCOL_SENTINEL === inst_116159);
var inst_116161 = ((inst_116158) || (inst_116160));
var state_116201__$1 = state_116201;
if(cljs.core.truth_(inst_116161)){
var statearr_116207_116246 = state_116201__$1;
(statearr_116207_116246[(1)] = (18));

} else {
var statearr_116208_116247 = state_116201__$1;
(statearr_116208_116247[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116202 === (21))){
var inst_116152 = (state_116201[(7)]);
var inst_116170 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_116152);
var state_116201__$1 = state_116201;
var statearr_116209_116248 = state_116201__$1;
(statearr_116209_116248[(2)] = inst_116170);

(statearr_116209_116248[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116202 === (13))){
var inst_116123 = (state_116201[(8)]);
var state_116201__$1 = state_116201;
var statearr_116210_116249 = state_116201__$1;
(statearr_116210_116249[(2)] = inst_116123);

(statearr_116210_116249[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116202 === (22))){
var inst_116152 = (state_116201[(7)]);
var state_116201__$1 = state_116201;
var statearr_116211_116250 = state_116201__$1;
(statearr_116211_116250[(2)] = inst_116152);

(statearr_116211_116250[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116202 === (6))){
var inst_116123 = (state_116201[(8)]);
var inst_116128 = inst_116123.cljs$lang$protocol_mask$partition0$;
var inst_116129 = (inst_116128 & (64));
var inst_116130 = inst_116123.cljs$core$ISeq$;
var inst_116131 = (cljs.core.PROTOCOL_SENTINEL === inst_116130);
var inst_116132 = ((inst_116129) || (inst_116131));
var state_116201__$1 = state_116201;
if(cljs.core.truth_(inst_116132)){
var statearr_116212_116251 = state_116201__$1;
(statearr_116212_116251[(1)] = (9));

} else {
var statearr_116213_116252 = state_116201__$1;
(statearr_116213_116252[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116202 === (25))){
var state_116201__$1 = state_116201;
var statearr_116214_116253 = state_116201__$1;
(statearr_116214_116253[(2)] = null);

(statearr_116214_116253[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116202 === (17))){
var inst_116168 = (state_116201[(2)]);
var state_116201__$1 = state_116201;
if(cljs.core.truth_(inst_116168)){
var statearr_116215_116254 = state_116201__$1;
(statearr_116215_116254[(1)] = (21));

} else {
var statearr_116216_116255 = state_116201__$1;
(statearr_116216_116255[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116202 === (3))){
var inst_116110 = (state_116201[(2)]);
var state_116201__$1 = state_116201;
var statearr_116217_116256 = state_116201__$1;
(statearr_116217_116256[(2)] = inst_116110);


cljs.core.async.impl.ioc_helpers.process_exception(state_116201__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116202 === (12))){
var inst_116123 = (state_116201[(8)]);
var inst_116141 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_116123);
var state_116201__$1 = state_116201;
var statearr_116218_116257 = state_116201__$1;
(statearr_116218_116257[(2)] = inst_116141);

(statearr_116218_116257[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116202 === (2))){
var inst_116199 = (state_116201[(2)]);
var state_116201__$1 = state_116201;
return cljs.core.async.impl.ioc_helpers.return_chan(state_116201__$1,inst_116199);
} else {
if((state_val_116202 === (23))){
var inst_116148 = (state_116201[(9)]);
var inst_116173 = (state_116201[(2)]);
var inst_116174 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_116173,cljs.core.cst$kw$novelty_DASH_min);
var inst_116175 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_116173,cljs.core.cst$kw$novelty_DASH_max);
var inst_116176 = (inst_116148 > inst_116175);
var state_116201__$1 = (function (){var statearr_116219 = state_116201;
(statearr_116219[(10)] = inst_116174);

return statearr_116219;
})();
if(cljs.core.truth_(inst_116176)){
var statearr_116220_116258 = state_116201__$1;
(statearr_116220_116258[(1)] = (24));

} else {
var statearr_116221_116259 = state_116201__$1;
(statearr_116221_116259[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116202 === (19))){
var state_116201__$1 = state_116201;
var statearr_116222_116260 = state_116201__$1;
(statearr_116222_116260[(2)] = false);

(statearr_116222_116260[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116202 === (11))){
var inst_116136 = (state_116201[(2)]);
var state_116201__$1 = state_116201;
var statearr_116223_116261 = state_116201__$1;
(statearr_116223_116261[(2)] = inst_116136);

(statearr_116223_116261[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116202 === (9))){
var state_116201__$1 = state_116201;
var statearr_116224_116262 = state_116201__$1;
(statearr_116224_116262[(2)] = true);

(statearr_116224_116262[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116202 === (5))){
var inst_116123 = (state_116201[(8)]);
var inst_116121 = (state_116201[(2)]);
var inst_116122 = fluree.db.util.async.throw_err(inst_116121);
var inst_116123__$1 = cljs.core.cst$kw$novelty.cljs$core$IFn$_invoke$arity$1(db);
var inst_116125 = (inst_116123__$1 == null);
var inst_116126 = cljs.core.not(inst_116125);
var state_116201__$1 = (function (){var statearr_116225 = state_116201;
(statearr_116225[(11)] = inst_116122);

(statearr_116225[(8)] = inst_116123__$1);

return statearr_116225;
})();
if(inst_116126){
var statearr_116226_116263 = state_116201__$1;
(statearr_116226_116263[(1)] = (6));

} else {
var statearr_116227_116264 = state_116201__$1;
(statearr_116227_116264[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116202 === (14))){
var inst_116152 = (state_116201[(7)]);
var inst_116122 = (state_116201[(11)]);
var inst_116144 = (state_116201[(2)]);
var inst_116145 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_116144,cljs.core.cst$kw$post);
var inst_116146 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_116144,cljs.core.cst$kw$size);
var inst_116147 = fluree.db.flake.size_bytes(inst_116122);
var inst_116148 = (inst_116146 + inst_116147);
var inst_116149 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_116150 = [cljs.core.cst$kw$conn,cljs.core.cst$kw$meta];
var inst_116151 = (new cljs.core.PersistentVector(null,2,(5),inst_116149,inst_116150,null));
var inst_116152__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_116151);
var inst_116154 = (inst_116152__$1 == null);
var inst_116155 = cljs.core.not(inst_116154);
var state_116201__$1 = (function (){var statearr_116228 = state_116201;
(statearr_116228[(9)] = inst_116148);

(statearr_116228[(7)] = inst_116152__$1);

(statearr_116228[(12)] = inst_116145);

return statearr_116228;
})();
if(inst_116155){
var statearr_116229_116265 = state_116201__$1;
(statearr_116229_116265[(1)] = (15));

} else {
var statearr_116230_116266 = state_116201__$1;
(statearr_116230_116266[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116202 === (26))){
var inst_116148 = (state_116201[(9)]);
var inst_116122 = (state_116201[(11)]);
var inst_116145 = (state_116201[(12)]);
var inst_116186 = (state_116201[(2)]);
var inst_116187 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_116145,inst_116122);
var inst_116188 = cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(db);
var inst_116189 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_116188,cljs.core.empty);
var inst_116190 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_116191 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$post];
var inst_116192 = (new cljs.core.PersistentVector(null,2,(5),inst_116190,inst_116191,null));
var inst_116193 = cljs.core.assoc_in(db,inst_116192,inst_116187);
var inst_116194 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_116195 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$size];
var inst_116196 = (new cljs.core.PersistentVector(null,2,(5),inst_116194,inst_116195,null));
var inst_116197 = cljs.core.assoc_in(inst_116193,inst_116196,inst_116148);
var state_116201__$1 = (function (){var statearr_116231 = state_116201;
(statearr_116231[(13)] = inst_116186);

(statearr_116231[(14)] = inst_116189);

return statearr_116231;
})();
var statearr_116232_116267 = state_116201__$1;
(statearr_116232_116267[(2)] = inst_116197);


cljs.core.async.impl.ioc_helpers.process_exception(state_116201__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116202 === (16))){
var state_116201__$1 = state_116201;
var statearr_116233_116268 = state_116201__$1;
(statearr_116233_116268[(2)] = false);

(statearr_116233_116268[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116202 === (10))){
var state_116201__$1 = state_116201;
var statearr_116234_116269 = state_116201__$1;
(statearr_116234_116269[(2)] = false);

(statearr_116234_116269[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116202 === (18))){
var state_116201__$1 = state_116201;
var statearr_116235_116270 = state_116201__$1;
(statearr_116235_116270[(2)] = true);

(statearr_116235_116270[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116202 === (8))){
var inst_116139 = (state_116201[(2)]);
var state_116201__$1 = state_116201;
if(cljs.core.truth_(inst_116139)){
var statearr_116236_116271 = state_116201__$1;
(statearr_116236_116271[(1)] = (12));

} else {
var statearr_116237_116272 = state_116201__$1;
(statearr_116237_116272[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__100742__auto__ = null;
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__100742__auto____0 = (function (){
var statearr_116238 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_116238[(0)] = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__100742__auto__);

(statearr_116238[(1)] = (1));

return statearr_116238;
});
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__100742__auto____1 = (function (state_116201){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_116201);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e116239){if((e116239 instanceof Object)){
var ex__100745__auto__ = e116239;
var statearr_116240_116273 = state_116201;
(statearr_116240_116273[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_116201);

return cljs.core.cst$kw$recur;
} else {
throw e116239;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__116274 = state_116201;
state_116201 = G__116274;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__100742__auto__ = function(state_116201){
switch(arguments.length){
case 0:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__100742__auto____1.call(this,state_116201);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__100742__auto____0;
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__100742__auto____1;
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_116241 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_116241[(6)] = c__100848__auto__);

return statearr_116241;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
/**
 * Processes a single transaction, adding it to the DB.
 *   Assumes flakes are already properly sorted.
 */
fluree.db.graphdb.with_t = (function fluree$db$graphdb$with_t(db,flakes){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_116469){
var state_val_116470 = (state_116469[(1)]);
if((state_val_116470 === (7))){
var inst_116300 = (state_116469[(7)]);
var inst_116304 = (state_116469[(8)]);
var inst_116283 = (state_116469[(9)]);
var inst_116314 = (state_116469[(10)]);
var inst_116308 = (state_116469[(11)]);
var inst_116298 = (state_116469[(12)]);
var inst_116298__$1 = (state_116469[(2)]);
var inst_116299 = (function (){var t = inst_116283;
var _ = inst_116298__$1;
return (function (p1__116275_SHARP_){
return cljs.core.not((function (){var G__116471 = p1__116275_SHARP_.p;
return (fluree.db.graphdb.exclude_predicates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.graphdb.exclude_predicates.cljs$core$IFn$_invoke$arity$1(G__116471) : fluree.db.graphdb.exclude_predicates.call(null,G__116471));
})());
});
})();
var inst_116300__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_116299,flakes);
var inst_116301 = cljs.core.PersistentHashSet.EMPTY;
var inst_116302 = (function (){var t = inst_116283;
var _ = inst_116298__$1;
var add_flakes = inst_116300__$1;
return (function (p1__116276_SHARP_){
return p1__116276_SHARP_.p;
});
})();
var inst_116303 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_116302,inst_116300__$1);
var inst_116304__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_116301,inst_116303);
var inst_116305 = cljs.core.PersistentHashMap.EMPTY;
var inst_116306 = (function (){var t = inst_116283;
var _ = inst_116298__$1;
var add_flakes = inst_116300__$1;
var add_preds = inst_116304__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$idx_QMARK_,p)], null);
});
})();
var inst_116307 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_116306,inst_116304__$1);
var inst_116308__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_116305,inst_116307);
var inst_116309 = cljs.core.PersistentHashMap.EMPTY;
var inst_116310 = (function (){var t = inst_116283;
var _ = inst_116298__$1;
var add_flakes = inst_116300__$1;
var add_preds = inst_116304__$1;
var idx_QMARK__map = inst_116308__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$ref_QMARK_,p)], null);
});
})();
var inst_116311 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_116310,inst_116304__$1);
var inst_116312 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_116309,inst_116311);
var inst_116313 = fluree.db.flake.size_bytes(inst_116300__$1);
var inst_116314__$1 = fluree.db.util.schema.schema_change_QMARK_(inst_116300__$1);
var inst_116315 = fluree.db.util.schema.setting_change_QMARK_(inst_116300__$1);
var inst_116316 = cljs.core.cst$kw$ecount.cljs$core$IFn$_invoke$arity$1(db);
var inst_116317 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_116316,(0));
var state_116469__$1 = (function (){var statearr_116472 = state_116469;
(statearr_116472[(7)] = inst_116300__$1);

(statearr_116472[(8)] = inst_116304__$1);

(statearr_116472[(13)] = inst_116317);

(statearr_116472[(10)] = inst_116314__$1);

(statearr_116472[(14)] = inst_116313);

(statearr_116472[(11)] = inst_116308__$1);

(statearr_116472[(12)] = inst_116298__$1);

(statearr_116472[(15)] = inst_116315);

(statearr_116472[(16)] = inst_116312);

return statearr_116472;
})();
if(cljs.core.truth_(inst_116314__$1)){
var statearr_116473_116531 = state_116469__$1;
(statearr_116473_116531[(1)] = (8));

} else {
var statearr_116474_116532 = state_116469__$1;
(statearr_116474_116532[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116470 === (20))){
var inst_116300 = (state_116469[(7)]);
var inst_116304 = (state_116469[(8)]);
var inst_116283 = (state_116469[(9)]);
var inst_116395 = (state_116469[(17)]);
var inst_116323 = (state_116469[(18)]);
var inst_116317 = (state_116469[(13)]);
var inst_116314 = (state_116469[(10)]);
var inst_116313 = (state_116469[(14)]);
var inst_116308 = (state_116469[(11)]);
var inst_116392 = (state_116469[(19)]);
var inst_116394 = (state_116469[(20)]);
var inst_116298 = (state_116469[(12)]);
var inst_116393 = (state_116469[(21)]);
var inst_116391 = (state_116469[(22)]);
var inst_116315 = (state_116469[(15)]);
var inst_116372 = (state_116469[(23)]);
var inst_116363 = (state_116469[(24)]);
var inst_116312 = (state_116469[(16)]);
var inst_116402 = (state_116469[(25)]);
var inst_116373 = (state_116469[(26)]);
var inst_116396 = (state_116469[(27)]);
var inst_116403 = (state_116469[(28)]);
var inst_116441 = inst_116402.s;
var inst_116442 = fluree.db.flake.sid__GT_cid(inst_116441);
var inst_116443 = (function (){var flakes_bytes = inst_116313;
var t = inst_116283;
var first__116370 = inst_116372;
var spot = inst_116392;
var add_flakes = inst_116300;
var root_setting_change_QMARK_ = inst_116315;
var G__116367 = inst_116391;
var ref_QMARK__map = inst_116312;
var r = inst_116403;
var psot = inst_116393;
var add_pred_to_idx_QMARK_ = inst_116323;
var _ = inst_116298;
var seq__116369 = inst_116373;
var cid = inst_116442;
var ecount = inst_116396;
var pred_ecount = inst_116317;
var vec__116398 = inst_116391;
var db_STAR_ = inst_116363;
var schema_change_QMARK_ = inst_116314;
var add_preds = inst_116304;
var opst = inst_116395;
var seq__116399 = inst_116403;
var vec__116368 = inst_116300;
var idx_QMARK__map = inst_116308;
var first__116400 = inst_116402;
var post = inst_116394;
var f = inst_116402;
return (function (p1__116277_SHARP_){
if(cljs.core.truth_(p1__116277_SHARP_)){
var x__4214__auto__ = p1__116277_SHARP_;
var y__4215__auto__ = f.s;
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
} else {
return f.s;
}
});
})();
var inst_116444 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_116396,inst_116442,inst_116443);
var inst_116445 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_116392,inst_116402);
var inst_116446 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_116393,inst_116402);
var inst_116447 = inst_116402.p;
var inst_116448 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_116308,inst_116447);
var state_116469__$1 = (function (){var statearr_116475 = state_116469;
(statearr_116475[(29)] = inst_116444);

(statearr_116475[(30)] = inst_116446);

(statearr_116475[(31)] = inst_116445);

return statearr_116475;
})();
if(cljs.core.truth_(inst_116448)){
var statearr_116476_116533 = state_116469__$1;
(statearr_116476_116533[(1)] = (33));

} else {
var statearr_116477_116534 = state_116469__$1;
(statearr_116477_116534[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116470 === (27))){
var inst_116315 = (state_116469[(15)]);
var inst_116429 = (state_116469[(2)]);
var state_116469__$1 = (function (){var statearr_116478 = state_116469;
(statearr_116478[(32)] = inst_116429);

return statearr_116478;
})();
if(cljs.core.truth_(inst_116315)){
var statearr_116479_116535 = state_116469__$1;
(statearr_116479_116535[(1)] = (29));

} else {
var statearr_116480_116536 = state_116469__$1;
(statearr_116480_116536[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116470 === (1))){
var state_116469__$1 = state_116469;
var statearr_116481_116537 = state_116469__$1;
(statearr_116481_116537[(2)] = null);

(statearr_116481_116537[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116470 === (24))){
var inst_116420 = (state_116469[(2)]);
var state_116469__$1 = state_116469;
if(cljs.core.truth_(inst_116420)){
var statearr_116482_116538 = state_116469__$1;
(statearr_116482_116538[(1)] = (25));

} else {
var statearr_116483_116539 = state_116469__$1;
(statearr_116483_116539[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116470 === (4))){
var inst_116283 = (state_116469[(9)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_116469,(3),Error,null,(2));
var inst_116282 = cljs.core.first(flakes);
var inst_116283__$1 = inst_116282.t;
var inst_116284 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_116285 = (inst_116284 - (1));
var inst_116286 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(inst_116283__$1,inst_116285);
var state_116469__$1 = (function (){var statearr_116484 = state_116469;
(statearr_116484[(9)] = inst_116283__$1);

return statearr_116484;
})();
if(inst_116286){
var statearr_116485_116540 = state_116469__$1;
(statearr_116485_116540[(1)] = (5));

} else {
var statearr_116486_116541 = state_116469__$1;
(statearr_116486_116541[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116470 === (15))){
var inst_116351 = (state_116469[(2)]);
var state_116469__$1 = state_116469;
var statearr_116487_116542 = state_116469__$1;
(statearr_116487_116542[(2)] = inst_116351);

(statearr_116487_116542[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116470 === (21))){
var inst_116463 = (state_116469[(2)]);
var state_116469__$1 = state_116469;
var statearr_116488_116543 = state_116469__$1;
(statearr_116488_116543[(2)] = inst_116463);

(statearr_116488_116543[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116470 === (31))){
var inst_116439 = (state_116469[(2)]);
var state_116469__$1 = state_116469;
var statearr_116489_116544 = state_116469__$1;
(statearr_116489_116544[(2)] = inst_116439);

(statearr_116489_116544[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116470 === (32))){
var inst_116429 = (state_116469[(32)]);
var inst_116434 = (state_116469[(2)]);
var inst_116435 = fluree.db.util.async.throw_err(inst_116434);
var inst_116436 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_116429,cljs.core.cst$kw$settings,inst_116435);
var state_116469__$1 = state_116469;
var statearr_116490_116545 = state_116469__$1;
(statearr_116490_116545[(2)] = inst_116436);

(statearr_116490_116545[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116470 === (33))){
var inst_116394 = (state_116469[(20)]);
var inst_116402 = (state_116469[(25)]);
var inst_116450 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_116394,inst_116402);
var state_116469__$1 = state_116469;
var statearr_116491_116546 = state_116469__$1;
(statearr_116491_116546[(2)] = inst_116450);

(statearr_116491_116546[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116470 === (13))){
var inst_116341 = (state_116469[(33)]);
var inst_116335 = (state_116469[(34)]);
var inst_116344 = fluree.db.graphdb.add_predicate_to_idx(inst_116335,inst_116341);
var state_116469__$1 = state_116469;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_116469__$1,(16),inst_116344);
} else {
if((state_val_116470 === (22))){
var inst_116314 = (state_116469[(10)]);
var state_116469__$1 = state_116469;
var statearr_116492_116547 = state_116469__$1;
(statearr_116492_116547[(2)] = inst_116314);

(statearr_116492_116547[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116470 === (36))){
var inst_116395 = (state_116469[(17)]);
var inst_116402 = (state_116469[(25)]);
var inst_116457 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_116395,inst_116402);
var state_116469__$1 = state_116469;
var statearr_116493_116548 = state_116469__$1;
(statearr_116493_116548[(2)] = inst_116457);

(statearr_116493_116548[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116470 === (29))){
var inst_116429 = (state_116469[(32)]);
var inst_116432 = fluree.db.query.schema.setting_map(inst_116429);
var state_116469__$1 = state_116469;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_116469__$1,(32),inst_116432);
} else {
if((state_val_116470 === (6))){
var state_116469__$1 = state_116469;
var statearr_116494_116549 = state_116469__$1;
(statearr_116494_116549[(2)] = null);

(statearr_116494_116549[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116470 === (28))){
var inst_116414 = (state_116469[(35)]);
var inst_116424 = (state_116469[(2)]);
var inst_116425 = fluree.db.util.async.throw_err(inst_116424);
var inst_116426 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_116414,cljs.core.cst$kw$schema,inst_116425);
var state_116469__$1 = state_116469;
var statearr_116495_116550 = state_116469__$1;
(statearr_116495_116550[(2)] = inst_116426);

(statearr_116495_116550[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116470 === (25))){
var inst_116414 = (state_116469[(35)]);
var inst_116422 = fluree.db.query.schema.schema_map(inst_116414);
var state_116469__$1 = state_116469;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_116469__$1,(28),inst_116422);
} else {
if((state_val_116470 === (34))){
var inst_116394 = (state_116469[(20)]);
var state_116469__$1 = state_116469;
var statearr_116496_116551 = state_116469__$1;
(statearr_116496_116551[(2)] = inst_116394);

(statearr_116496_116551[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116470 === (17))){
var inst_116391 = (state_116469[(22)]);
var inst_116402 = (state_116469[(25)]);
var inst_116401 = cljs.core.seq(inst_116391);
var inst_116402__$1 = cljs.core.first(inst_116401);
var inst_116403 = cljs.core.next(inst_116401);
var inst_116404 = cljs.core.not(inst_116402__$1);
var state_116469__$1 = (function (){var statearr_116497 = state_116469;
(statearr_116497[(25)] = inst_116402__$1);

(statearr_116497[(28)] = inst_116403);

return statearr_116497;
})();
if(inst_116404){
var statearr_116498_116552 = state_116469__$1;
(statearr_116498_116552[(1)] = (19));

} else {
var statearr_116499_116553 = state_116469__$1;
(statearr_116499_116553[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116470 === (3))){
var inst_116278 = (state_116469[(2)]);
var state_116469__$1 = state_116469;
var statearr_116500_116554 = state_116469__$1;
(statearr_116500_116554[(2)] = inst_116278);


cljs.core.async.impl.ioc_helpers.process_exception(state_116469__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116470 === (12))){
var inst_116300 = (state_116469[(7)]);
var inst_116283 = (state_116469[(9)]);
var inst_116313 = (state_116469[(14)]);
var inst_116363 = (state_116469[(24)]);
var inst_116353 = (state_116469[(2)]);
var inst_116354 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_116353,cljs.core.cst$kw$t,inst_116283);
var inst_116355 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_116356 = [cljs.core.cst$kw$stats,cljs.core.cst$kw$size];
var inst_116357 = (new cljs.core.PersistentVector(null,2,(5),inst_116355,inst_116356,null));
var inst_116358 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_116354,inst_116357,cljs.core._PLUS_,inst_116313);
var inst_116359 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_116360 = [cljs.core.cst$kw$stats,cljs.core.cst$kw$flakes];
var inst_116361 = (new cljs.core.PersistentVector(null,2,(5),inst_116359,inst_116360,null));
var inst_116362 = cljs.core.count(inst_116300);
var inst_116363__$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_116358,inst_116361,cljs.core._PLUS_,inst_116362);
var inst_116371 = cljs.core.seq(inst_116300);
var inst_116372 = cljs.core.first(inst_116371);
var inst_116373 = cljs.core.next(inst_116371);
var inst_116374 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_116375 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$spot];
var inst_116376 = (new cljs.core.PersistentVector(null,2,(5),inst_116374,inst_116375,null));
var inst_116377 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_116363__$1,inst_116376);
var inst_116378 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_116379 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$psot];
var inst_116380 = (new cljs.core.PersistentVector(null,2,(5),inst_116378,inst_116379,null));
var inst_116381 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_116363__$1,inst_116380);
var inst_116382 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_116383 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$post];
var inst_116384 = (new cljs.core.PersistentVector(null,2,(5),inst_116382,inst_116383,null));
var inst_116385 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_116363__$1,inst_116384);
var inst_116386 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_116387 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$opst];
var inst_116388 = (new cljs.core.PersistentVector(null,2,(5),inst_116386,inst_116387,null));
var inst_116389 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_116363__$1,inst_116388);
var inst_116390 = cljs.core.cst$kw$ecount.cljs$core$IFn$_invoke$arity$1(db);
var inst_116391 = inst_116300;
var inst_116392 = inst_116377;
var inst_116393 = inst_116381;
var inst_116394 = inst_116385;
var inst_116395 = inst_116389;
var inst_116396 = inst_116390;
var state_116469__$1 = (function (){var statearr_116501 = state_116469;
(statearr_116501[(17)] = inst_116395);

(statearr_116501[(19)] = inst_116392);

(statearr_116501[(20)] = inst_116394);

(statearr_116501[(21)] = inst_116393);

(statearr_116501[(22)] = inst_116391);

(statearr_116501[(23)] = inst_116372);

(statearr_116501[(24)] = inst_116363__$1);

(statearr_116501[(26)] = inst_116373);

(statearr_116501[(27)] = inst_116396);

return statearr_116501;
})();
var statearr_116502_116555 = state_116469__$1;
(statearr_116502_116555[(2)] = null);

(statearr_116502_116555[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116470 === (2))){
var inst_116467 = (state_116469[(2)]);
var state_116469__$1 = state_116469;
return cljs.core.async.impl.ioc_helpers.return_chan(state_116469__$1,inst_116467);
} else {
if((state_val_116470 === (23))){
var inst_116414 = (state_116469[(35)]);
var inst_116417 = cljs.core.cst$kw$schema.cljs$core$IFn$_invoke$arity$1(inst_116414);
var inst_116418 = (inst_116417 == null);
var state_116469__$1 = state_116469;
var statearr_116503_116556 = state_116469__$1;
(statearr_116503_116556[(2)] = inst_116418);

(statearr_116503_116556[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116470 === (35))){
var inst_116312 = (state_116469[(16)]);
var inst_116402 = (state_116469[(25)]);
var inst_116453 = (state_116469[(2)]);
var inst_116454 = inst_116402.p;
var inst_116455 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_116312,inst_116454);
var state_116469__$1 = (function (){var statearr_116504 = state_116469;
(statearr_116504[(36)] = inst_116453);

return statearr_116504;
})();
if(cljs.core.truth_(inst_116455)){
var statearr_116505_116557 = state_116469__$1;
(statearr_116505_116557[(1)] = (36));

} else {
var statearr_116506_116558 = state_116469__$1;
(statearr_116506_116558[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116470 === (19))){
var inst_116395 = (state_116469[(17)]);
var inst_116314 = (state_116469[(10)]);
var inst_116313 = (state_116469[(14)]);
var inst_116392 = (state_116469[(19)]);
var inst_116394 = (state_116469[(20)]);
var inst_116393 = (state_116469[(21)]);
var inst_116363 = (state_116469[(24)]);
var inst_116396 = (state_116469[(27)]);
var inst_116406 = [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst,cljs.core.cst$kw$size];
var inst_116407 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_116408 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$size];
var inst_116409 = (new cljs.core.PersistentVector(null,2,(5),inst_116407,inst_116408,null));
var inst_116410 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_116363,inst_116409);
var inst_116411 = (inst_116313 + inst_116410);
var inst_116412 = [inst_116392,inst_116393,inst_116394,inst_116395,inst_116411];
var inst_116413 = cljs.core.PersistentHashMap.fromArrays(inst_116406,inst_116412);
var inst_116414 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_116363,cljs.core.cst$kw$ecount,inst_116396,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$novelty,inst_116413], 0));
var state_116469__$1 = (function (){var statearr_116507 = state_116469;
(statearr_116507[(35)] = inst_116414);

return statearr_116507;
})();
if(cljs.core.truth_(inst_116314)){
var statearr_116508_116559 = state_116469__$1;
(statearr_116508_116559[(1)] = (22));

} else {
var statearr_116509_116560 = state_116469__$1;
(statearr_116509_116560[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116470 === (11))){
var inst_116334 = (state_116469[(37)]);
var inst_116341 = (state_116469[(33)]);
var inst_116340 = cljs.core.seq(inst_116334);
var inst_116341__$1 = cljs.core.first(inst_116340);
var inst_116342 = cljs.core.next(inst_116340);
var state_116469__$1 = (function (){var statearr_116510 = state_116469;
(statearr_116510[(33)] = inst_116341__$1);

(statearr_116510[(38)] = inst_116342);

return statearr_116510;
})();
if(cljs.core.truth_(inst_116341__$1)){
var statearr_116511_116561 = state_116469__$1;
(statearr_116511_116561[(1)] = (13));

} else {
var statearr_116512_116562 = state_116469__$1;
(statearr_116512_116562[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116470 === (9))){
var inst_116321 = cljs.core.PersistentVector.EMPTY;
var state_116469__$1 = state_116469;
var statearr_116513_116563 = state_116469__$1;
(statearr_116513_116563[(2)] = inst_116321);

(statearr_116513_116563[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116470 === (5))){
var inst_116283 = (state_116469[(9)]);
var inst_116288 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db);
var inst_116289 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_116290 = ["Invalid with called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_116288)," because current 't', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_116289)," is not beyond supplied transaction t: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_116283),"."].join('');
var inst_116291 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_116292 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_116293 = cljs.core.PersistentHashMap.fromArrays(inst_116291,inst_116292);
var inst_116294 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_116290,inst_116293);
var inst_116295 = (function(){throw inst_116294})();
var state_116469__$1 = state_116469;
var statearr_116514_116564 = state_116469__$1;
(statearr_116514_116564[(2)] = inst_116295);

(statearr_116514_116564[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116470 === (14))){
var inst_116335 = (state_116469[(34)]);
var state_116469__$1 = state_116469;
var statearr_116515_116565 = state_116469__$1;
(statearr_116515_116565[(2)] = inst_116335);

(statearr_116515_116565[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116470 === (26))){
var inst_116414 = (state_116469[(35)]);
var state_116469__$1 = state_116469;
var statearr_116516_116566 = state_116469__$1;
(statearr_116516_116566[(2)] = inst_116414);

(statearr_116516_116566[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116470 === (16))){
var inst_116342 = (state_116469[(38)]);
var inst_116346 = (state_116469[(2)]);
var inst_116347 = fluree.db.util.async.throw_err(inst_116346);
var inst_116334 = inst_116342;
var inst_116335 = inst_116347;
var state_116469__$1 = (function (){var statearr_116517 = state_116469;
(statearr_116517[(37)] = inst_116334);

(statearr_116517[(34)] = inst_116335);

return statearr_116517;
})();
var statearr_116518_116567 = state_116469__$1;
(statearr_116518_116567[(2)] = null);

(statearr_116518_116567[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116470 === (38))){
var inst_116444 = (state_116469[(29)]);
var inst_116446 = (state_116469[(30)]);
var inst_116445 = (state_116469[(31)]);
var inst_116453 = (state_116469[(36)]);
var inst_116403 = (state_116469[(28)]);
var inst_116460 = (state_116469[(2)]);
var inst_116391 = inst_116403;
var inst_116392 = inst_116445;
var inst_116393 = inst_116446;
var inst_116394 = inst_116453;
var inst_116395 = inst_116460;
var inst_116396 = inst_116444;
var state_116469__$1 = (function (){var statearr_116519 = state_116469;
(statearr_116519[(17)] = inst_116395);

(statearr_116519[(19)] = inst_116392);

(statearr_116519[(20)] = inst_116394);

(statearr_116519[(21)] = inst_116393);

(statearr_116519[(22)] = inst_116391);

(statearr_116519[(27)] = inst_116396);

return statearr_116519;
})();
var statearr_116520_116568 = state_116469__$1;
(statearr_116520_116568[(2)] = null);

(statearr_116520_116568[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116470 === (30))){
var inst_116429 = (state_116469[(32)]);
var state_116469__$1 = state_116469;
var statearr_116521_116569 = state_116469__$1;
(statearr_116521_116569[(2)] = inst_116429);

(statearr_116521_116569[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116470 === (10))){
var inst_116323 = (state_116469[(18)]);
var inst_116323__$1 = (state_116469[(2)]);
var inst_116331 = cljs.core.seq(inst_116323__$1);
var inst_116332 = cljs.core.first(inst_116331);
var inst_116333 = cljs.core.next(inst_116331);
var inst_116334 = inst_116323__$1;
var inst_116335 = db;
var state_116469__$1 = (function (){var statearr_116522 = state_116469;
(statearr_116522[(18)] = inst_116323__$1);

(statearr_116522[(37)] = inst_116334);

(statearr_116522[(39)] = inst_116332);

(statearr_116522[(40)] = inst_116333);

(statearr_116522[(34)] = inst_116335);

return statearr_116522;
})();
var statearr_116523_116570 = state_116469__$1;
(statearr_116523_116570[(2)] = null);

(statearr_116523_116570[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116470 === (18))){
var inst_116465 = (state_116469[(2)]);
var state_116469__$1 = state_116469;
var statearr_116524_116571 = state_116469__$1;
(statearr_116524_116571[(2)] = inst_116465);


cljs.core.async.impl.ioc_helpers.process_exception(state_116469__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116470 === (37))){
var inst_116395 = (state_116469[(17)]);
var state_116469__$1 = state_116469;
var statearr_116525_116572 = state_116469__$1;
(statearr_116525_116572[(2)] = inst_116395);

(statearr_116525_116572[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116470 === (8))){
var inst_116300 = (state_116469[(7)]);
var inst_116317 = (state_116469[(13)]);
var inst_116319 = fluree.db.util.schema.add_to_post_preds_QMARK_(inst_116300,inst_116317);
var state_116469__$1 = state_116469;
var statearr_116526_116573 = state_116469__$1;
(statearr_116526_116573[(2)] = inst_116319);

(statearr_116526_116573[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$with_t_$_state_machine__100742__auto__ = null;
var fluree$db$graphdb$with_t_$_state_machine__100742__auto____0 = (function (){
var statearr_116527 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_116527[(0)] = fluree$db$graphdb$with_t_$_state_machine__100742__auto__);

(statearr_116527[(1)] = (1));

return statearr_116527;
});
var fluree$db$graphdb$with_t_$_state_machine__100742__auto____1 = (function (state_116469){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_116469);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e116528){if((e116528 instanceof Object)){
var ex__100745__auto__ = e116528;
var statearr_116529_116574 = state_116469;
(statearr_116529_116574[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_116469);

return cljs.core.cst$kw$recur;
} else {
throw e116528;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__116575 = state_116469;
state_116469 = G__116575;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$graphdb$with_t_$_state_machine__100742__auto__ = function(state_116469){
switch(arguments.length){
case 0:
return fluree$db$graphdb$with_t_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$graphdb$with_t_$_state_machine__100742__auto____1.call(this,state_116469);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$with_t_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$with_t_$_state_machine__100742__auto____0;
fluree$db$graphdb$with_t_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$with_t_$_state_machine__100742__auto____1;
return fluree$db$graphdb$with_t_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_116530 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_116530[(6)] = c__100848__auto__);

return statearr_116530;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
/**
 * Returns db 'with' flakes added as a core async promise channel.
 *   Note this always does a re-sort.
 */
fluree.db.graphdb.with$ = (function fluree$db$graphdb$with(db,block,flakes){
var resp_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__100848__auto___116710 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_116667){
var state_val_116668 = (state_116667[(1)]);
if((state_val_116668 === (7))){
var inst_116595 = (state_116667[(2)]);
var inst_116596 = cljs.core.empty_QMARK_(flakes);
var state_116667__$1 = (function (){var statearr_116669 = state_116667;
(statearr_116669[(7)] = inst_116595);

return statearr_116669;
})();
if(inst_116596){
var statearr_116670_116711 = state_116667__$1;
(statearr_116670_116711[(1)] = (8));

} else {
var statearr_116671_116712 = state_116667__$1;
(statearr_116671_116712[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116668 === (20))){
var state_116667__$1 = state_116667;
var statearr_116672_116713 = state_116667__$1;
(statearr_116672_116713[(2)] = null);

(statearr_116672_116713[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116668 === (1))){
var state_116667__$1 = state_116667;
var statearr_116673_116714 = state_116667__$1;
(statearr_116673_116714[(2)] = null);

(statearr_116673_116714[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116668 === (24))){
var inst_116642 = (state_116667[(8)]);
var inst_116624 = (state_116667[(9)]);
var inst_116625 = (state_116667[(10)]);
var inst_116647 = inst_116624.t;
var inst_116648 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_116649 = [inst_116624];
var inst_116650 = (new cljs.core.PersistentVector(null,1,(5),inst_116648,inst_116649,null));
var inst_116615 = inst_116625;
var inst_116616 = inst_116647;
var inst_116617 = inst_116650;
var inst_116618 = inst_116642;
var state_116667__$1 = (function (){var statearr_116674 = state_116667;
(statearr_116674[(11)] = inst_116617);

(statearr_116674[(12)] = inst_116618);

(statearr_116674[(13)] = inst_116616);

(statearr_116674[(14)] = inst_116615);

return statearr_116674;
})();
var statearr_116675_116715 = state_116667__$1;
(statearr_116675_116715[(2)] = null);

(statearr_116675_116715[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116668 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_116667,(3),cljs.core.cst$kw$default,null,(2));
var inst_116581 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(db);
var inst_116582 = (inst_116581 + (1));
var inst_116583 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_116582);
var state_116667__$1 = state_116667;
if(inst_116583){
var statearr_116676_116716 = state_116667__$1;
(statearr_116676_116716[(1)] = (5));

} else {
var statearr_116677_116717 = state_116667__$1;
(statearr_116677_116717[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116668 === (15))){
var inst_116631 = (state_116667[(2)]);
var state_116667__$1 = state_116667;
if(cljs.core.truth_(inst_116631)){
var statearr_116678_116718 = state_116667__$1;
(statearr_116678_116718[(1)] = (16));

} else {
var statearr_116679_116719 = state_116667__$1;
(statearr_116679_116719[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116668 === (21))){
var inst_116656 = (state_116667[(2)]);
var state_116667__$1 = state_116667;
var statearr_116680_116720 = state_116667__$1;
(statearr_116680_116720[(2)] = inst_116656);

(statearr_116680_116720[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116668 === (13))){
var inst_116616 = (state_116667[(13)]);
var inst_116624 = (state_116667[(9)]);
var inst_116627 = inst_116624.t;
var inst_116628 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_116616,inst_116627);
var state_116667__$1 = state_116667;
var statearr_116681_116721 = state_116667__$1;
(statearr_116681_116721[(2)] = inst_116628);

(statearr_116681_116721[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116668 === (22))){
var inst_116624 = (state_116667[(9)]);
var inst_116641 = (state_116667[(2)]);
var inst_116642 = fluree.db.util.async.throw_err(inst_116641);
var inst_116643 = (inst_116624 == null);
var state_116667__$1 = (function (){var statearr_116682 = state_116667;
(statearr_116682[(8)] = inst_116642);

return statearr_116682;
})();
if(cljs.core.truth_(inst_116643)){
var statearr_116683_116722 = state_116667__$1;
(statearr_116683_116722[(1)] = (23));

} else {
var statearr_116684_116723 = state_116667__$1;
(statearr_116684_116723[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116668 === (6))){
var state_116667__$1 = state_116667;
var statearr_116685_116724 = state_116667__$1;
(statearr_116685_116724[(2)] = null);

(statearr_116685_116724[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116668 === (25))){
var inst_116653 = (state_116667[(2)]);
var state_116667__$1 = state_116667;
var statearr_116686_116725 = state_116667__$1;
(statearr_116686_116725[(2)] = inst_116653);

(statearr_116686_116725[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116668 === (17))){
var state_116667__$1 = state_116667;
var statearr_116687_116726 = state_116667__$1;
(statearr_116687_116726[(1)] = (19));



return cljs.core.cst$kw$recur;
} else {
if((state_val_116668 === (3))){
var inst_116576 = (state_116667[(2)]);
var inst_116577 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_116576);
var state_116667__$1 = state_116667;
var statearr_116689_116727 = state_116667__$1;
(statearr_116689_116727[(2)] = inst_116577);


cljs.core.async.impl.ioc_helpers.process_exception(state_116667__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116668 === (12))){
var inst_116660 = (state_116667[(2)]);
var inst_116661 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_116660);
var state_116667__$1 = state_116667;
var statearr_116690_116728 = state_116667__$1;
(statearr_116690_116728[(2)] = inst_116661);

(statearr_116690_116728[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116668 === (2))){
var inst_116665 = (state_116667[(2)]);
var state_116667__$1 = state_116667;
return cljs.core.async.impl.ioc_helpers.return_chan(state_116667__$1,inst_116665);
} else {
if((state_val_116668 === (23))){
var inst_116642 = (state_116667[(8)]);
var inst_116645 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_116642,cljs.core.cst$kw$block,block);
var state_116667__$1 = state_116667;
var statearr_116691_116729 = state_116667__$1;
(statearr_116691_116729[(2)] = inst_116645);

(statearr_116691_116729[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116668 === (19))){
var inst_116617 = (state_116667[(11)]);
var inst_116618 = (state_116667[(12)]);
var inst_116616 = (state_116667[(13)]);
var inst_116637 = (inst_116616 + (1));
var inst_116638 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_116618,cljs.core.cst$kw$t,inst_116637);
var inst_116639 = fluree.db.graphdb.with_t(inst_116638,inst_116617);
var state_116667__$1 = state_116667;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_116667__$1,(22),inst_116639);
} else {
if((state_val_116668 === (11))){
var inst_116624 = (state_116667[(9)]);
var inst_116615 = (state_116667[(14)]);
var inst_116623 = cljs.core.seq(inst_116615);
var inst_116624__$1 = cljs.core.first(inst_116623);
var inst_116625 = cljs.core.next(inst_116623);
var state_116667__$1 = (function (){var statearr_116692 = state_116667;
(statearr_116692[(9)] = inst_116624__$1);

(statearr_116692[(10)] = inst_116625);

return statearr_116692;
})();
if(cljs.core.truth_(inst_116624__$1)){
var statearr_116693_116730 = state_116667__$1;
(statearr_116693_116730[(1)] = (13));

} else {
var statearr_116694_116731 = state_116667__$1;
(statearr_116694_116731[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116668 === (9))){
var inst_116601 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_block,flakes);
var inst_116609 = cljs.core.seq(inst_116601);
var inst_116610 = cljs.core.first(inst_116609);
var inst_116611 = cljs.core.next(inst_116609);
var inst_116612 = cljs.core.first(inst_116601);
var inst_116613 = inst_116612.t;
var inst_116614 = cljs.core.PersistentVector.EMPTY;
var inst_116615 = inst_116601;
var inst_116616 = inst_116613;
var inst_116617 = inst_116614;
var inst_116618 = db;
var state_116667__$1 = (function (){var statearr_116695 = state_116667;
(statearr_116695[(11)] = inst_116617);

(statearr_116695[(12)] = inst_116618);

(statearr_116695[(15)] = inst_116611);

(statearr_116695[(13)] = inst_116616);

(statearr_116695[(16)] = inst_116610);

(statearr_116695[(14)] = inst_116615);

return statearr_116695;
})();
var statearr_116696_116732 = state_116667__$1;
(statearr_116696_116732[(2)] = null);

(statearr_116696_116732[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116668 === (5))){
var inst_116585 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db);
var inst_116586 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(db);
var inst_116587 = ["Invalid 'with' called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_116585)," because current db 'block', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_116586)," must be one less than supplied block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_116588 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_116589 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_116590 = cljs.core.PersistentHashMap.fromArrays(inst_116588,inst_116589);
var inst_116591 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_116587,inst_116590);
var inst_116592 = (function(){throw inst_116591})();
var state_116667__$1 = state_116667;
var statearr_116699_116733 = state_116667__$1;
(statearr_116699_116733[(2)] = inst_116592);

(statearr_116699_116733[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116668 === (14))){
var inst_116624 = (state_116667[(9)]);
var state_116667__$1 = state_116667;
var statearr_116700_116734 = state_116667__$1;
(statearr_116700_116734[(2)] = inst_116624);

(statearr_116700_116734[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116668 === (16))){
var inst_116617 = (state_116667[(11)]);
var inst_116618 = (state_116667[(12)]);
var inst_116616 = (state_116667[(13)]);
var inst_116624 = (state_116667[(9)]);
var inst_116625 = (state_116667[(10)]);
var inst_116633 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_116617,inst_116624);
var tmp116697 = inst_116618;
var tmp116698 = inst_116616;
var inst_116615 = inst_116625;
var inst_116616__$1 = tmp116698;
var inst_116617__$1 = inst_116633;
var inst_116618__$1 = tmp116697;
var state_116667__$1 = (function (){var statearr_116701 = state_116667;
(statearr_116701[(11)] = inst_116617__$1);

(statearr_116701[(12)] = inst_116618__$1);

(statearr_116701[(13)] = inst_116616__$1);

(statearr_116701[(14)] = inst_116615);

return statearr_116701;
})();
var statearr_116702_116735 = state_116667__$1;
(statearr_116702_116735[(2)] = null);

(statearr_116702_116735[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116668 === (10))){
var inst_116663 = (state_116667[(2)]);
var state_116667__$1 = state_116667;
var statearr_116703_116736 = state_116667__$1;
(statearr_116703_116736[(2)] = inst_116663);


cljs.core.async.impl.ioc_helpers.process_exception(state_116667__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116668 === (18))){
var inst_116658 = (state_116667[(2)]);
var state_116667__$1 = state_116667;
var statearr_116704_116737 = state_116667__$1;
(statearr_116704_116737[(2)] = inst_116658);

(statearr_116704_116737[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116668 === (8))){
var inst_116598 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$block,block);
var inst_116599 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_116598);
var state_116667__$1 = state_116667;
var statearr_116705_116738 = state_116667__$1;
(statearr_116705_116738[(2)] = inst_116599);

(statearr_116705_116738[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$with_$_state_machine__100742__auto__ = null;
var fluree$db$graphdb$with_$_state_machine__100742__auto____0 = (function (){
var statearr_116706 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_116706[(0)] = fluree$db$graphdb$with_$_state_machine__100742__auto__);

(statearr_116706[(1)] = (1));

return statearr_116706;
});
var fluree$db$graphdb$with_$_state_machine__100742__auto____1 = (function (state_116667){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_116667);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e116707){if((e116707 instanceof Object)){
var ex__100745__auto__ = e116707;
var statearr_116708_116739 = state_116667;
(statearr_116708_116739[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_116667);

return cljs.core.cst$kw$recur;
} else {
throw e116707;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__116740 = state_116667;
state_116667 = G__116740;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$graphdb$with_$_state_machine__100742__auto__ = function(state_116667){
switch(arguments.length){
case 0:
return fluree$db$graphdb$with_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$graphdb$with_$_state_machine__100742__auto____1.call(this,state_116667);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$with_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$with_$_state_machine__100742__auto____0;
fluree$db$graphdb$with_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$with_$_state_machine__100742__auto____1;
return fluree$db$graphdb$with_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_116709 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_116709[(6)] = c__100848__auto___116710);

return statearr_116709;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));


return resp_ch;
});
/**
 * Returns true if db is a forward time travel db.
 */
fluree.db.graphdb.forward_time_travel_db_QMARK_ = (function fluree$db$graphdb$forward_time_travel_db_QMARK_(db){
return (!((cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(db) == null)));
});
/**
 * Returns a core async chan with a new db based on the provided db, including the provided flakes.
 *   Flakes can contain one or more 't's, but should be sequential and start after the current
 *   't' of the provided db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.).
 *   Remember 't' is negative and thus should be in descending order.
 * 
 *   A tt-id (time-travel-id), if provided, can be any unique identifier of any type and is required.
 *   It must be unique (to the computer/process) to avoid any query caching issues.
 * 
 *   A forward-time-travel dbf can be further forward-time-traveled. If a tt-id is provided, ensure
 *   it is unique for each successive call.
 * 
 *   A forward-time travel DB is held in memory, and is not shared across servers. Ensure you
 *   have adequate memory to hold the flakes you generate and add. If access is provided via
 *   an external API, do any desired size restrictions or controls within your API endpoint.
 * 
 *   Remember schema operations done via forward-time-travel should be done in a 't' prior to
 *   the flakes that end up requiring the schema change.
 */
fluree.db.graphdb.forward_time_travel = (function fluree$db$graphdb$forward_time_travel(db,tt_id,flakes){
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_116793){
var state_val_116794 = (state_116793[(1)]);
if((state_val_116794 === (7))){
var inst_116750 = (state_116793[(2)]);
var inst_116751 = (function (){var tt_id_SINGLEQUOTE_ = inst_116750;
return (function (db_STAR_,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db_STAR_,idx,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(db_STAR_,idx),cljs.core.cst$kw$tt_DASH_id,tt_id_SINGLEQUOTE_));
});
})();
var inst_116752 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$tt_DASH_id,inst_116750);
var inst_116753 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_116754 = [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst];
var inst_116755 = (new cljs.core.PersistentVector(null,4,(5),inst_116753,inst_116754,null));
var inst_116756 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_116751,inst_116752,inst_116755);
var inst_116757 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$t,flakes);
var inst_116758 = cljs.core.reverse(inst_116757);
var inst_116759 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$t,inst_116758);
var inst_116767 = cljs.core.seq(inst_116759);
var inst_116768 = cljs.core.first(inst_116767);
var inst_116769 = cljs.core.next(inst_116767);
var inst_116770 = inst_116756;
var inst_116771 = inst_116759;
var state_116793__$1 = (function (){var statearr_116795 = state_116793;
(statearr_116795[(7)] = inst_116770);

(statearr_116795[(8)] = inst_116768);

(statearr_116795[(9)] = inst_116769);

(statearr_116795[(10)] = inst_116771);

return statearr_116795;
})();
var statearr_116796_116815 = state_116793__$1;
(statearr_116796_116815[(2)] = null);

(statearr_116796_116815[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116794 === (1))){
var state_116793__$1 = state_116793;
var statearr_116797_116816 = state_116793__$1;
(statearr_116797_116816[(2)] = null);

(statearr_116797_116816[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116794 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_116793,(3),Error,null,(2));
var inst_116745 = (tt_id == null);
var state_116793__$1 = state_116793;
if(cljs.core.truth_(inst_116745)){
var statearr_116798_116817 = state_116793__$1;
(statearr_116798_116817[(1)] = (5));

} else {
var statearr_116799_116818 = state_116793__$1;
(statearr_116799_116818[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116794 === (13))){
var inst_116778 = (state_116793[(11)]);
var inst_116782 = (state_116793[(2)]);
var inst_116783 = fluree.db.util.async.throw_err(inst_116782);
var inst_116770 = inst_116783;
var inst_116771 = inst_116778;
var state_116793__$1 = (function (){var statearr_116800 = state_116793;
(statearr_116800[(7)] = inst_116770);

(statearr_116800[(10)] = inst_116771);

return statearr_116800;
})();
var statearr_116801_116819 = state_116793__$1;
(statearr_116801_116819[(2)] = null);

(statearr_116801_116819[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116794 === (6))){
var state_116793__$1 = state_116793;
var statearr_116802_116820 = state_116793__$1;
(statearr_116802_116820[(2)] = tt_id);

(statearr_116802_116820[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116794 === (3))){
var inst_116741 = (state_116793[(2)]);
var state_116793__$1 = state_116793;
var statearr_116803_116821 = state_116793__$1;
(statearr_116803_116821[(2)] = inst_116741);


cljs.core.async.impl.ioc_helpers.process_exception(state_116793__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116794 === (12))){
var inst_116787 = (state_116793[(2)]);
var state_116793__$1 = state_116793;
var statearr_116804_116822 = state_116793__$1;
(statearr_116804_116822[(2)] = inst_116787);

(statearr_116804_116822[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116794 === (2))){
var inst_116791 = (state_116793[(2)]);
var state_116793__$1 = state_116793;
return cljs.core.async.impl.ioc_helpers.return_chan(state_116793__$1,inst_116791);
} else {
if((state_val_116794 === (11))){
var inst_116770 = (state_116793[(7)]);
var state_116793__$1 = state_116793;
var statearr_116805_116823 = state_116793__$1;
(statearr_116805_116823[(2)] = inst_116770);

(statearr_116805_116823[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116794 === (9))){
var inst_116789 = (state_116793[(2)]);
var state_116793__$1 = state_116793;
var statearr_116806_116824 = state_116793__$1;
(statearr_116806_116824[(2)] = inst_116789);


cljs.core.async.impl.ioc_helpers.process_exception(state_116793__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116794 === (5))){
var inst_116747 = fluree.db.util.core.random_uuid();
var state_116793__$1 = state_116793;
var statearr_116807_116825 = state_116793__$1;
(statearr_116807_116825[(2)] = inst_116747);

(statearr_116807_116825[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116794 === (10))){
var inst_116770 = (state_116793[(7)]);
var inst_116777 = (state_116793[(12)]);
var inst_116780 = fluree.db.graphdb.with_t(inst_116770,inst_116777);
var state_116793__$1 = state_116793;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_116793__$1,(13),inst_116780);
} else {
if((state_val_116794 === (8))){
var inst_116777 = (state_116793[(12)]);
var inst_116771 = (state_116793[(10)]);
var inst_116776 = cljs.core.seq(inst_116771);
var inst_116777__$1 = cljs.core.first(inst_116776);
var inst_116778 = cljs.core.next(inst_116776);
var state_116793__$1 = (function (){var statearr_116808 = state_116793;
(statearr_116808[(12)] = inst_116777__$1);

(statearr_116808[(11)] = inst_116778);

return statearr_116808;
})();
if(cljs.core.truth_(inst_116777__$1)){
var statearr_116809_116826 = state_116793__$1;
(statearr_116809_116826[(1)] = (10));

} else {
var statearr_116810_116827 = state_116793__$1;
(statearr_116810_116827[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$forward_time_travel_$_state_machine__100742__auto__ = null;
var fluree$db$graphdb$forward_time_travel_$_state_machine__100742__auto____0 = (function (){
var statearr_116811 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_116811[(0)] = fluree$db$graphdb$forward_time_travel_$_state_machine__100742__auto__);

(statearr_116811[(1)] = (1));

return statearr_116811;
});
var fluree$db$graphdb$forward_time_travel_$_state_machine__100742__auto____1 = (function (state_116793){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_116793);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e116812){if((e116812 instanceof Object)){
var ex__100745__auto__ = e116812;
var statearr_116813_116828 = state_116793;
(statearr_116813_116828[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_116793);

return cljs.core.cst$kw$recur;
} else {
throw e116812;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__116829 = state_116793;
state_116793 = G__116829;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$graphdb$forward_time_travel_$_state_machine__100742__auto__ = function(state_116793){
switch(arguments.length){
case 0:
return fluree$db$graphdb$forward_time_travel_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$graphdb$forward_time_travel_$_state_machine__100742__auto____1.call(this,state_116793);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$forward_time_travel_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$forward_time_travel_$_state_machine__100742__auto____0;
fluree$db$graphdb$forward_time_travel_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$forward_time_travel_$_state_machine__100742__auto____1;
return fluree$db$graphdb$forward_time_travel_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_116814 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_116814[(6)] = c__100848__auto__);

return statearr_116814;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
});
/**
 * Returns subject ID of ident as async promise channel.
 *   Closes channel (nil) if doesn't exist, or if strict? is true, will return exception.
 */
fluree.db.graphdb.subid = (function fluree$db$graphdb$subid(db,ident,strict_QMARK_){
var return_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__100848__auto___116997 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_116941){
var state_val_116942 = (state_116941[(1)]);
if((state_val_116942 === (7))){
var inst_116912 = (state_116941[(7)]);
var inst_116912__$1 = (state_116941[(2)]);
var state_116941__$1 = (function (){var statearr_116943 = state_116941;
(statearr_116943[(7)] = inst_116912__$1);

return statearr_116943;
})();
if(cljs.core.truth_(inst_116912__$1)){
var statearr_116944_116998 = state_116941__$1;
(statearr_116944_116998[(1)] = (28));

} else {
var statearr_116945_116999 = state_116941__$1;
(statearr_116945_116999[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116942 === (20))){
var inst_116882 = (state_116941[(8)]);
var inst_116886 = cljs.core.first(inst_116882);
var state_116941__$1 = state_116941;
var statearr_116946_117000 = state_116941__$1;
(statearr_116946_117000[(2)] = inst_116886);

(statearr_116946_117000[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116942 === (27))){
var inst_116906 = (state_116941[(2)]);
var state_116941__$1 = state_116941;
var statearr_116947_117001 = state_116941__$1;
(statearr_116947_117001[(2)] = inst_116906);

(statearr_116947_117001[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116942 === (1))){
var state_116941__$1 = state_116941;
var statearr_116948_117002 = state_116941__$1;
(statearr_116948_117002[(2)] = null);

(statearr_116948_117002[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116942 === (24))){
var inst_116894 = (state_116941[(2)]);
var state_116941__$1 = state_116941;
var statearr_116949_117003 = state_116941__$1;
(statearr_116949_117003[(2)] = inst_116894);

(statearr_116949_117003[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116942 === (39))){
var inst_116933 = (state_116941[(2)]);
var state_116941__$1 = state_116941;
var statearr_116950_117004 = state_116941__$1;
(statearr_116950_117004[(2)] = inst_116933);

(statearr_116950_117004[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116942 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_116941,(3),cljs.core.cst$kw$default,null,(2));
var inst_116840 = typeof ident === 'number';
var state_116941__$1 = state_116941;
if(cljs.core.truth_(inst_116840)){
var statearr_116951_117005 = state_116941__$1;
(statearr_116951_117005[(1)] = (5));

} else {
var statearr_116952_117006 = state_116941__$1;
(statearr_116952_117006[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116942 === (15))){
var inst_116873 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_116874 = cljs.core.first(ident);
var inst_116875 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,inst_116874);
var inst_116876 = cljs.core.second(ident);
var inst_116877 = [inst_116875,inst_116876];
var inst_116878 = (new cljs.core.PersistentVector(null,2,(5),inst_116873,inst_116877,null));
var inst_116879 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$post,cljs.core._EQ_,inst_116878);
var state_116941__$1 = state_116941;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_116941__$1,(18),inst_116879);
} else {
if((state_val_116942 === (21))){
var inst_116888 = (state_116941[(9)]);
var inst_116888__$1 = (state_116941[(2)]);
var inst_116889 = (inst_116888__$1 == null);
var state_116941__$1 = (function (){var statearr_116953 = state_116941;
(statearr_116953[(9)] = inst_116888__$1);

return statearr_116953;
})();
if(cljs.core.truth_(inst_116889)){
var statearr_116954_117007 = state_116941__$1;
(statearr_116954_117007[(1)] = (22));

} else {
var statearr_116955_117008 = state_116941__$1;
(statearr_116955_117008[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116942 === (31))){
var state_116941__$1 = state_116941;
var statearr_116956_117009 = state_116941__$1;
(statearr_116956_117009[(2)] = strict_QMARK_);

(statearr_116956_117009[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116942 === (32))){
var state_116941__$1 = state_116941;
var statearr_116957_117010 = state_116941__$1;
(statearr_116957_117010[(2)] = false);

(statearr_116957_117010[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116942 === (33))){
var inst_116920 = (state_116941[(2)]);
var state_116941__$1 = state_116941;
if(cljs.core.truth_(inst_116920)){
var statearr_116958_117011 = state_116941__$1;
(statearr_116958_117011[(1)] = (34));

} else {
var statearr_116959_117012 = state_116941__$1;
(statearr_116959_117012[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116942 === (13))){
var inst_116870 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_116941__$1 = state_116941;
if(inst_116870){
var statearr_116960_117013 = state_116941__$1;
(statearr_116960_117013[(1)] = (15));

} else {
var statearr_116961_117014 = state_116941__$1;
(statearr_116961_117014[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116942 === (22))){
var state_116941__$1 = state_116941;
var statearr_116962_117015 = state_116941__$1;
(statearr_116962_117015[(2)] = null);

(statearr_116962_117015[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116942 === (36))){
var inst_116935 = (state_116941[(2)]);
var state_116941__$1 = state_116941;
var statearr_116963_117016 = state_116941__$1;
(statearr_116963_117016[(2)] = inst_116935);

(statearr_116963_117016[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116942 === (29))){
var inst_116912 = (state_116941[(7)]);
var inst_116916 = (inst_116912 == null);
var state_116941__$1 = state_116941;
if(cljs.core.truth_(inst_116916)){
var statearr_116964_117017 = state_116941__$1;
(statearr_116964_117017[(1)] = (31));

} else {
var statearr_116965_117018 = state_116941__$1;
(statearr_116965_117018[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116942 === (6))){
var inst_116855 = fluree.db.util.core.pred_ident_QMARK_(ident);
var inst_116856 = cljs.core.first(ident);
var inst_116857 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,inst_116856);
var inst_116858 = (inst_116857 == null);
var inst_116859 = ((inst_116855) && (inst_116858));
var state_116941__$1 = state_116941;
if(cljs.core.truth_(inst_116859)){
var statearr_116966_117019 = state_116941__$1;
(statearr_116966_117019[(1)] = (12));

} else {
var statearr_116967_117020 = state_116941__$1;
(statearr_116967_117020[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116942 === (28))){
var inst_116912 = (state_116941[(7)]);
var inst_116914 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_116912);
var state_116941__$1 = state_116941;
var statearr_116968_117021 = state_116941__$1;
(statearr_116968_117021[(2)] = inst_116914);

(statearr_116968_117021[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116942 === (25))){
var inst_116897 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ident], 0));
var inst_116898 = ["Entid lookup must be a number or valid two-tuple identity: ",inst_116897].join('');
var inst_116899 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_116900 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_ident];
var inst_116901 = cljs.core.PersistentHashMap.fromArrays(inst_116899,inst_116900);
var inst_116902 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_116898,inst_116901);
var inst_116903 = (function(){throw inst_116902})();
var state_116941__$1 = state_116941;
var statearr_116969_117022 = state_116941__$1;
(statearr_116969_117022[(2)] = inst_116903);

(statearr_116969_117022[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116942 === (34))){
var inst_116922 = ["Subject identity does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_116923 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_116924 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_subject];
var inst_116925 = cljs.core.PersistentHashMap.fromArrays(inst_116923,inst_116924);
var inst_116926 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_116922,inst_116925);
var inst_116927 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_116926);
var state_116941__$1 = state_116941;
var statearr_116970_117023 = state_116941__$1;
(statearr_116970_117023[(2)] = inst_116927);

(statearr_116970_117023[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116942 === (17))){
var inst_116908 = (state_116941[(2)]);
var state_116941__$1 = state_116941;
var statearr_116971_117024 = state_116941__$1;
(statearr_116971_117024[(2)] = inst_116908);

(statearr_116971_117024[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116942 === (3))){
var inst_116830 = (state_116941[(2)]);
var inst_116831 = ["Error looking up subject id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_116832 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_116833 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_subject];
var inst_116834 = cljs.core.PersistentHashMap.fromArrays(inst_116832,inst_116833);
var inst_116835 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(inst_116831,inst_116834,inst_116830);
var inst_116836 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_116835);
var state_116941__$1 = state_116941;
var statearr_116972_117025 = state_116941__$1;
(statearr_116972_117025[(2)] = inst_116836);


cljs.core.async.impl.ioc_helpers.process_exception(state_116941__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116942 === (12))){
var inst_116861 = cljs.core.first(ident);
var inst_116862 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_116861], 0));
var inst_116863 = ["Subject ID lookup failed. The predicate ",inst_116862," does not exist."].join('');
var inst_116864 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_116865 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_ident];
var inst_116866 = cljs.core.PersistentHashMap.fromArrays(inst_116864,inst_116865);
var inst_116867 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_116863,inst_116866);
var inst_116868 = (function(){throw inst_116867})();
var state_116941__$1 = state_116941;
var statearr_116973_117026 = state_116941__$1;
(statearr_116973_117026[(2)] = inst_116868);

(statearr_116973_117026[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116942 === (2))){
var inst_116939 = (state_116941[(2)]);
var state_116941__$1 = state_116941;
return cljs.core.async.impl.ioc_helpers.return_chan(state_116941__$1,inst_116939);
} else {
if((state_val_116942 === (23))){
var inst_116888 = (state_116941[(9)]);
var inst_116892 = inst_116888.s;
var state_116941__$1 = state_116941;
var statearr_116974_117027 = state_116941__$1;
(statearr_116974_117027[(2)] = inst_116892);

(statearr_116974_117027[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116942 === (35))){
var state_116941__$1 = state_116941;
var statearr_116975_117028 = state_116941__$1;
(statearr_116975_117028[(1)] = (37));



return cljs.core.cst$kw$recur;
} else {
if((state_val_116942 === (19))){
var state_116941__$1 = state_116941;
var statearr_116977_117029 = state_116941__$1;
(statearr_116977_117029[(2)] = null);

(statearr_116977_117029[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116942 === (11))){
var inst_116853 = (state_116941[(2)]);
var state_116941__$1 = state_116941;
var statearr_116978_117030 = state_116941__$1;
(statearr_116978_117030[(2)] = inst_116853);

(statearr_116978_117030[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116942 === (9))){
var state_116941__$1 = state_116941;
var statearr_116979_117031 = state_116941__$1;
(statearr_116979_117031[(2)] = ident);

(statearr_116979_117031[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116942 === (5))){
var inst_116842 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_116843 = [ident];
var inst_116844 = (new cljs.core.PersistentVector(null,1,(5),inst_116842,inst_116843,null));
var inst_116845 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_116844);
var state_116941__$1 = state_116941;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_116941__$1,(8),inst_116845);
} else {
if((state_val_116942 === (14))){
var inst_116910 = (state_116941[(2)]);
var state_116941__$1 = state_116941;
var statearr_116980_117032 = state_116941__$1;
(statearr_116980_117032[(2)] = inst_116910);

(statearr_116980_117032[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116942 === (26))){
var state_116941__$1 = state_116941;
var statearr_116981_117033 = state_116941__$1;
(statearr_116981_117033[(2)] = null);

(statearr_116981_117033[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116942 === (16))){
var state_116941__$1 = state_116941;
var statearr_116982_117034 = state_116941__$1;
(statearr_116982_117034[(1)] = (25));



return cljs.core.cst$kw$recur;
} else {
if((state_val_116942 === (38))){
var state_116941__$1 = state_116941;
var statearr_116984_117035 = state_116941__$1;
(statearr_116984_117035[(2)] = null);

(statearr_116984_117035[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116942 === (30))){
var inst_116937 = (state_116941[(2)]);
var state_116941__$1 = state_116941;
var statearr_116985_117036 = state_116941__$1;
(statearr_116985_117036[(2)] = inst_116937);


cljs.core.async.impl.ioc_helpers.process_exception(state_116941__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116942 === (10))){
var state_116941__$1 = state_116941;
var statearr_116986_117037 = state_116941__$1;
(statearr_116986_117037[(2)] = null);

(statearr_116986_117037[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116942 === (18))){
var inst_116882 = (state_116941[(8)]);
var inst_116881 = (state_116941[(2)]);
var inst_116882__$1 = fluree.db.util.async.throw_err(inst_116881);
var inst_116883 = (inst_116882__$1 == null);
var state_116941__$1 = (function (){var statearr_116987 = state_116941;
(statearr_116987[(8)] = inst_116882__$1);

return statearr_116987;
})();
if(cljs.core.truth_(inst_116883)){
var statearr_116988_117038 = state_116941__$1;
(statearr_116988_117038[(1)] = (19));

} else {
var statearr_116989_117039 = state_116941__$1;
(statearr_116989_117039[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116942 === (37))){
var inst_116930 = cljs.core.async.close_BANG_(return_chan);
var state_116941__$1 = state_116941;
var statearr_116990_117040 = state_116941__$1;
(statearr_116990_117040[(2)] = inst_116930);

(statearr_116990_117040[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116942 === (8))){
var inst_116847 = (state_116941[(2)]);
var inst_116848 = fluree.db.util.async.throw_err(inst_116847);
var inst_116849 = cljs.core.not_empty(inst_116848);
var state_116941__$1 = state_116941;
if(cljs.core.truth_(inst_116849)){
var statearr_116991_117041 = state_116941__$1;
(statearr_116991_117041[(1)] = (9));

} else {
var statearr_116992_117042 = state_116941__$1;
(statearr_116992_117042[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$subid_$_state_machine__100742__auto__ = null;
var fluree$db$graphdb$subid_$_state_machine__100742__auto____0 = (function (){
var statearr_116993 = [null,null,null,null,null,null,null,null,null,null];
(statearr_116993[(0)] = fluree$db$graphdb$subid_$_state_machine__100742__auto__);

(statearr_116993[(1)] = (1));

return statearr_116993;
});
var fluree$db$graphdb$subid_$_state_machine__100742__auto____1 = (function (state_116941){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_116941);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e116994){if((e116994 instanceof Object)){
var ex__100745__auto__ = e116994;
var statearr_116995_117043 = state_116941;
(statearr_116995_117043[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_116941);

return cljs.core.cst$kw$recur;
} else {
throw e116994;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__117044 = state_116941;
state_116941 = G__117044;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$graphdb$subid_$_state_machine__100742__auto__ = function(state_116941){
switch(arguments.length){
case 0:
return fluree$db$graphdb$subid_$_state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$graphdb$subid_$_state_machine__100742__auto____1.call(this,state_116941);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$subid_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$subid_$_state_machine__100742__auto____0;
fluree$db$graphdb$subid_$_state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$subid_$_state_machine__100742__auto____1;
return fluree$db$graphdb$subid_$_state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_116996 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_116996[(6)] = c__100848__auto___116997);

return statearr_116996;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));


return return_chan;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fluree.db.dbproto.IFlureeDb}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.graphdb.GraphDb = (function (conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.stats = stats;
this.spot = spot;
this.psot = psot;
this.post = post;
this.opst = opst;
this.schema = schema;
this.settings = settings;
this.index_configs = index_configs;
this.schema_cache = schema_cache;
this.novelty = novelty;
this.permissions = permissions;
this.fork = fork;
this.fork_block = fork_block;
this.current_db_fn = current_db_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k117046,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__117050 = k117046;
var G__117050__$1 = (((G__117050 instanceof cljs.core.Keyword))?G__117050.fqn:null);
switch (G__117050__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "stats":
return self__.stats;

break;
case "spot":
return self__.spot;

break;
case "psot":
return self__.psot;

break;
case "post":
return self__.post;

break;
case "opst":
return self__.opst;

break;
case "schema":
return self__.schema;

break;
case "settings":
return self__.settings;

break;
case "index-configs":
return self__.index_configs;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "novelty":
return self__.novelty;

break;
case "permissions":
return self__.permissions;

break;
case "fork":
return self__.fork;

break;
case "fork-block":
return self__.fork_block;

break;
case "current-db-fn":
return self__.current_db_fn;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k117046,else__4383__auto__);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__117051){
var vec__117052 = p__117051;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__117052,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__117052,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#fluree.db.graphdb.GraphDb{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$conn,self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$network,self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$dbid,self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$block,self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$t,self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tt_DASH_id,self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$stats,self__.stats],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$spot,self__.spot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$psot,self__.psot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$post,self__.post],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$opst,self__.opst],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$schema,self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$settings,self__.settings],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$index_DASH_configs,self__.index_configs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$novelty,self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$permissions,self__.permissions],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$fork,self__.fork],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$fork_DASH_block,self__.fork_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$current_DASH_db_DASH_fn,self__.current_db_fn],null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__117045){
var self__ = this;
var G__117045__$1 = this;
return (new cljs.core.RecordIter((0),G__117045__$1,20,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$stats,cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst,cljs.core.cst$kw$schema,cljs.core.cst$kw$settings,cljs.core.cst$kw$index_DASH_configs,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$novelty,cljs.core.cst$kw$permissions,cljs.core.cst$kw$fork,cljs.core.cst$kw$fork_DASH_block,cljs.core.cst$kw$current_DASH_db_DASH_fn], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (20 + cljs.core.count(self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (){var fexpr__117055 = (function (coll__4377__auto__){
return (485580545 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
});
return fexpr__117055(this__4376__auto____$1);
})();
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this117047,other117048){
var self__ = this;
var this117047__$1 = this;
return (((!((other117048 == null)))) && ((this117047__$1.constructor === other117048.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this117047__$1.conn,other117048.conn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this117047__$1.network,other117048.network)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this117047__$1.dbid,other117048.dbid)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this117047__$1.block,other117048.block)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this117047__$1.t,other117048.t)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this117047__$1.tt_id,other117048.tt_id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this117047__$1.stats,other117048.stats)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this117047__$1.spot,other117048.spot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this117047__$1.psot,other117048.psot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this117047__$1.post,other117048.post)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this117047__$1.opst,other117048.opst)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this117047__$1.schema,other117048.schema)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this117047__$1.settings,other117048.settings)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this117047__$1.index_configs,other117048.index_configs)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this117047__$1.schema_cache,other117048.schema_cache)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this117047__$1.novelty,other117048.novelty)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this117047__$1.permissions,other117048.permissions)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this117047__$1.fork,other117048.fork)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this117047__$1.fork_block,other117048.fork_block)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this117047__$1.current_db_fn,other117048.current_db_fn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this117047__$1.__extmap,other117048.__extmap)));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 20, [cljs.core.cst$kw$current_DASH_db_DASH_fn,null,cljs.core.cst$kw$schema,null,cljs.core.cst$kw$block,null,cljs.core.cst$kw$psot,null,cljs.core.cst$kw$permissions,null,cljs.core.cst$kw$dbid,null,cljs.core.cst$kw$settings,null,cljs.core.cst$kw$index_DASH_configs,null,cljs.core.cst$kw$opst,null,cljs.core.cst$kw$fork_DASH_block,null,cljs.core.cst$kw$schema_DASH_cache,null,cljs.core.cst$kw$post,null,cljs.core.cst$kw$novelty,null,cljs.core.cst$kw$t,null,cljs.core.cst$kw$network,null,cljs.core.cst$kw$fork,null,cljs.core.cst$kw$tt_DASH_id,null,cljs.core.cst$kw$stats,null,cljs.core.cst$kw$spot,null,cljs.core.cst$kw$conn,null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__117045){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__117056 = cljs.core.keyword_identical_QMARK_;
var expr__117057 = k__4388__auto__;
if(cljs.core.truth_((function (){var G__117059 = cljs.core.cst$kw$conn;
var G__117060 = expr__117057;
return (pred__117056.cljs$core$IFn$_invoke$arity$2 ? pred__117056.cljs$core$IFn$_invoke$arity$2(G__117059,G__117060) : pred__117056.call(null,G__117059,G__117060));
})())){
return (new fluree.db.graphdb.GraphDb(G__117045,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__117061 = cljs.core.cst$kw$network;
var G__117062 = expr__117057;
return (pred__117056.cljs$core$IFn$_invoke$arity$2 ? pred__117056.cljs$core$IFn$_invoke$arity$2(G__117061,G__117062) : pred__117056.call(null,G__117061,G__117062));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,G__117045,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__117063 = cljs.core.cst$kw$dbid;
var G__117064 = expr__117057;
return (pred__117056.cljs$core$IFn$_invoke$arity$2 ? pred__117056.cljs$core$IFn$_invoke$arity$2(G__117063,G__117064) : pred__117056.call(null,G__117063,G__117064));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,G__117045,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__117065 = cljs.core.cst$kw$block;
var G__117066 = expr__117057;
return (pred__117056.cljs$core$IFn$_invoke$arity$2 ? pred__117056.cljs$core$IFn$_invoke$arity$2(G__117065,G__117066) : pred__117056.call(null,G__117065,G__117066));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,G__117045,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__117067 = cljs.core.cst$kw$t;
var G__117068 = expr__117057;
return (pred__117056.cljs$core$IFn$_invoke$arity$2 ? pred__117056.cljs$core$IFn$_invoke$arity$2(G__117067,G__117068) : pred__117056.call(null,G__117067,G__117068));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,G__117045,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__117069 = cljs.core.cst$kw$tt_DASH_id;
var G__117070 = expr__117057;
return (pred__117056.cljs$core$IFn$_invoke$arity$2 ? pred__117056.cljs$core$IFn$_invoke$arity$2(G__117069,G__117070) : pred__117056.call(null,G__117069,G__117070));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,G__117045,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__117071 = cljs.core.cst$kw$stats;
var G__117072 = expr__117057;
return (pred__117056.cljs$core$IFn$_invoke$arity$2 ? pred__117056.cljs$core$IFn$_invoke$arity$2(G__117071,G__117072) : pred__117056.call(null,G__117071,G__117072));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,G__117045,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__117073 = cljs.core.cst$kw$spot;
var G__117074 = expr__117057;
return (pred__117056.cljs$core$IFn$_invoke$arity$2 ? pred__117056.cljs$core$IFn$_invoke$arity$2(G__117073,G__117074) : pred__117056.call(null,G__117073,G__117074));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,G__117045,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__117075 = cljs.core.cst$kw$psot;
var G__117076 = expr__117057;
return (pred__117056.cljs$core$IFn$_invoke$arity$2 ? pred__117056.cljs$core$IFn$_invoke$arity$2(G__117075,G__117076) : pred__117056.call(null,G__117075,G__117076));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,G__117045,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__117077 = cljs.core.cst$kw$post;
var G__117078 = expr__117057;
return (pred__117056.cljs$core$IFn$_invoke$arity$2 ? pred__117056.cljs$core$IFn$_invoke$arity$2(G__117077,G__117078) : pred__117056.call(null,G__117077,G__117078));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,G__117045,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__117079 = cljs.core.cst$kw$opst;
var G__117080 = expr__117057;
return (pred__117056.cljs$core$IFn$_invoke$arity$2 ? pred__117056.cljs$core$IFn$_invoke$arity$2(G__117079,G__117080) : pred__117056.call(null,G__117079,G__117080));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,G__117045,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__117081 = cljs.core.cst$kw$schema;
var G__117082 = expr__117057;
return (pred__117056.cljs$core$IFn$_invoke$arity$2 ? pred__117056.cljs$core$IFn$_invoke$arity$2(G__117081,G__117082) : pred__117056.call(null,G__117081,G__117082));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,G__117045,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__117083 = cljs.core.cst$kw$settings;
var G__117084 = expr__117057;
return (pred__117056.cljs$core$IFn$_invoke$arity$2 ? pred__117056.cljs$core$IFn$_invoke$arity$2(G__117083,G__117084) : pred__117056.call(null,G__117083,G__117084));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,G__117045,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__117085 = cljs.core.cst$kw$index_DASH_configs;
var G__117086 = expr__117057;
return (pred__117056.cljs$core$IFn$_invoke$arity$2 ? pred__117056.cljs$core$IFn$_invoke$arity$2(G__117085,G__117086) : pred__117056.call(null,G__117085,G__117086));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,G__117045,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__117087 = cljs.core.cst$kw$schema_DASH_cache;
var G__117088 = expr__117057;
return (pred__117056.cljs$core$IFn$_invoke$arity$2 ? pred__117056.cljs$core$IFn$_invoke$arity$2(G__117087,G__117088) : pred__117056.call(null,G__117087,G__117088));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,G__117045,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__117089 = cljs.core.cst$kw$novelty;
var G__117090 = expr__117057;
return (pred__117056.cljs$core$IFn$_invoke$arity$2 ? pred__117056.cljs$core$IFn$_invoke$arity$2(G__117089,G__117090) : pred__117056.call(null,G__117089,G__117090));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,G__117045,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__117091 = cljs.core.cst$kw$permissions;
var G__117092 = expr__117057;
return (pred__117056.cljs$core$IFn$_invoke$arity$2 ? pred__117056.cljs$core$IFn$_invoke$arity$2(G__117091,G__117092) : pred__117056.call(null,G__117091,G__117092));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,G__117045,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__117093 = cljs.core.cst$kw$fork;
var G__117094 = expr__117057;
return (pred__117056.cljs$core$IFn$_invoke$arity$2 ? pred__117056.cljs$core$IFn$_invoke$arity$2(G__117093,G__117094) : pred__117056.call(null,G__117093,G__117094));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,G__117045,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__117095 = cljs.core.cst$kw$fork_DASH_block;
var G__117096 = expr__117057;
return (pred__117056.cljs$core$IFn$_invoke$arity$2 ? pred__117056.cljs$core$IFn$_invoke$arity$2(G__117095,G__117096) : pred__117056.call(null,G__117095,G__117096));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,G__117045,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__117097 = cljs.core.cst$kw$current_DASH_db_DASH_fn;
var G__117098 = expr__117057;
return (pred__117056.cljs$core$IFn$_invoke$arity$2 ? pred__117056.cljs$core$IFn$_invoke$arity$2(G__117097,G__117098) : pred__117056.call(null,G__117097,G__117098));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,G__117045,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__117045),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$conn,self__.conn,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$network,self__.network,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$dbid,self__.dbid,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$block,self__.block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$t,self__.t,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tt_DASH_id,self__.tt_id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$stats,self__.stats,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$spot,self__.spot,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$psot,self__.psot,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$post,self__.post,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$opst,self__.opst,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$schema,self__.schema,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$settings,self__.settings,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$index_DASH_configs,self__.index_configs,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$novelty,self__.novelty,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$permissions,self__.permissions,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$fork,self__.fork,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$fork_DASH_block,self__.fork_block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$current_DASH_db_DASH_fn,self__.current_db_fn,null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__117045){
var self__ = this;
var this__4379__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,G__117045,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4386__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_117111){
var state_val_117112 = (state_117111[(1)]);
if((state_val_117112 === (1))){
var state_117111__$1 = state_117111;
var statearr_117113_117331 = state_117111__$1;
(statearr_117113_117331[(2)] = null);

(statearr_117113_117331[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117112 === (2))){
var inst_117109 = (state_117111[(2)]);
var state_117111__$1 = state_117111;
return cljs.core.async.impl.ioc_helpers.return_chan(state_117111__$1,inst_117109);
} else {
if((state_val_117112 === (3))){
var inst_117099 = (state_117111[(2)]);
var state_117111__$1 = state_117111;
var statearr_117114_117332 = state_117111__$1;
(statearr_117114_117332[(2)] = inst_117099);


cljs.core.async.impl.ioc_helpers.process_exception(state_117111__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_117112 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_117111,(3),Error,null,(2));
var inst_117103 = (self__.current_db_fn.cljs$core$IFn$_invoke$arity$0 ? self__.current_db_fn.cljs$core$IFn$_invoke$arity$0() : self__.current_db_fn.call(null));
var state_117111__$1 = state_117111;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_117111__$1,(5),inst_117103);
} else {
if((state_val_117112 === (5))){
var inst_117105 = (state_117111[(2)]);
var inst_117106 = fluree.db.util.async.throw_err(inst_117105);
var inst_117107 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_117106,cljs.core.cst$kw$permissions,self__.permissions);
var state_117111__$1 = state_117111;
var statearr_117115_117333 = state_117111__$1;
(statearr_117115_117333[(2)] = inst_117107);


cljs.core.async.impl.ioc_helpers.process_exception(state_117111__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__100742__auto__ = null;
var fluree$db$graphdb$state_machine__100742__auto____0 = (function (){
var statearr_117116 = [null,null,null,null,null,null,null];
(statearr_117116[(0)] = fluree$db$graphdb$state_machine__100742__auto__);

(statearr_117116[(1)] = (1));

return statearr_117116;
});
var fluree$db$graphdb$state_machine__100742__auto____1 = (function (state_117111){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_117111);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e117117){if((e117117 instanceof Object)){
var ex__100745__auto__ = e117117;
var statearr_117118_117334 = state_117111;
(statearr_117118_117334[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_117111);

return cljs.core.cst$kw$recur;
} else {
throw e117117;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__117335 = state_117111;
state_117111 = G__117335;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__100742__auto__ = function(state_117111){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__100742__auto____1.call(this,state_117111);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__100742__auto____0;
fluree$db$graphdb$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__100742__auto____1;
return fluree$db$graphdb$state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_117119 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_117119[(6)] = c__100848__auto__);

return statearr_117119;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 = (function (this$,pred_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.add_predicate_to_idx(this$__$1,pred_id);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 = (function (this$,property,collection){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_((function (){var fexpr__117120 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$sid,null], null), null);
return (fexpr__117120.cljs$core$IFn$_invoke$arity$1 ? fexpr__117120.cljs$core$IFn$_invoke$arity$1(property) : fexpr__117120.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid collection property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:name :id :sid} property)"].join('')));
}

if(cljs.core.neg_int_QMARK_(collection)){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$coll,"_tx",property], null));
} else {
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$coll,collection,property], null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 = (function (this$,property,predicate){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_((function (){var fexpr__117121 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 17, [cljs.core.cst$kw$unique,null,cljs.core.cst$kw$restrictCollection,null,cljs.core.cst$kw$index,null,cljs.core.cst$kw$name,null,cljs.core.cst$kw$noHistory,null,cljs.core.cst$kw$type,null,cljs.core.cst$kw$txSpec,null,cljs.core.cst$kw$component,null,cljs.core.cst$kw$txSpecDoc,null,cljs.core.cst$kw$spec,null,cljs.core.cst$kw$multi,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$specDoc,null,cljs.core.cst$kw$idx_QMARK_,null,cljs.core.cst$kw$ref_QMARK_,null,cljs.core.cst$kw$upsert,null,cljs.core.cst$kw$restrictTag,null], null), null);
return (fexpr__117121.cljs$core$IFn$_invoke$arity$1 ? fexpr__117121.cljs$core$IFn$_invoke$arity$1(property) : fexpr__117121.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid predicate property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:unique :restrictCollection :index :name :noHistory :type :txSpec :component :txSpecDoc :spec :multi :id :specDoc :idx? :ref? :upsert :restrictTag} property)"].join('')));
}

var G__117122 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$pred,predicate,property], null));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$restrictCollection,property)){
return this$__$1.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3(null,cljs.core.cst$kw$id,G__117122);
} else {
return G__117122;
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$3 = (function (this$,block__$1,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$(this$__$1,block__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$2 = (function (this$,ident){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,false);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$3 = (function (this$,ident,strict_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,strict_QMARK_);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_search$arity$2 = (function (this$,fparts){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2(this$__$1,fparts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(this$__$1,cljs.core.cst$kw$permissions,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$root_QMARK_,true,cljs.core.cst$kw$collection,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,true], null),cljs.core.cst$kw$predicate,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,true], null)], null));
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 = (function (db,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,null,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 = (function (db,tt_id__$1,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,tt_id__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_query$arity$2 = (function (this$,query_map){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2(this$__$1,query_map);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_query$arity$3 = (function (this$,query_map,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$3(this$__$1,query_map,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 = (function (this$,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t(this$__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$2 = (function (this$,tag_id){
var self__ = this;
var this$__$1 = this;
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_117151){
var state_val_117152 = (state_117151[(1)]);
if((state_val_117152 === (7))){
var inst_117135 = (state_117151[(7)]);
var inst_117139 = cljs.core.first(inst_117135);
var state_117151__$1 = state_117151;
var statearr_117153_117336 = state_117151__$1;
(statearr_117153_117336[(2)] = inst_117139);

(statearr_117153_117336[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117152 === (1))){
var state_117151__$1 = state_117151;
var statearr_117154_117337 = state_117151__$1;
(statearr_117154_117337[(2)] = null);

(statearr_117154_117337[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117152 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_117151,(3),Error,null,(2));
var inst_117128 = this$__$1.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1(null);
var inst_117129 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_117130 = [tag_id,(30)];
var inst_117131 = (new cljs.core.PersistentVector(null,2,(5),inst_117129,inst_117130,null));
var inst_117132 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_117128,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_117131);
var state_117151__$1 = state_117151;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_117151__$1,(5),inst_117132);
} else {
if((state_val_117152 === (6))){
var state_117151__$1 = state_117151;
var statearr_117155_117338 = state_117151__$1;
(statearr_117155_117338[(2)] = null);

(statearr_117155_117338[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117152 === (3))){
var inst_117123 = (state_117151[(2)]);
var state_117151__$1 = state_117151;
var statearr_117156_117339 = state_117151__$1;
(statearr_117156_117339[(2)] = inst_117123);


cljs.core.async.impl.ioc_helpers.process_exception(state_117151__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_117152 === (2))){
var inst_117149 = (state_117151[(2)]);
var state_117151__$1 = state_117151;
return cljs.core.async.impl.ioc_helpers.return_chan(state_117151__$1,inst_117149);
} else {
if((state_val_117152 === (11))){
var inst_117147 = (state_117151[(2)]);
var state_117151__$1 = state_117151;
var statearr_117157_117340 = state_117151__$1;
(statearr_117157_117340[(2)] = inst_117147);


cljs.core.async.impl.ioc_helpers.process_exception(state_117151__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_117152 === (9))){
var state_117151__$1 = state_117151;
var statearr_117158_117341 = state_117151__$1;
(statearr_117158_117341[(2)] = null);

(statearr_117158_117341[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117152 === (5))){
var inst_117135 = (state_117151[(7)]);
var inst_117134 = (state_117151[(2)]);
var inst_117135__$1 = fluree.db.util.async.throw_err(inst_117134);
var inst_117136 = (inst_117135__$1 == null);
var state_117151__$1 = (function (){var statearr_117159 = state_117151;
(statearr_117159[(7)] = inst_117135__$1);

return statearr_117159;
})();
if(cljs.core.truth_(inst_117136)){
var statearr_117160_117342 = state_117151__$1;
(statearr_117160_117342[(1)] = (6));

} else {
var statearr_117161_117343 = state_117151__$1;
(statearr_117161_117343[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117152 === (10))){
var inst_117141 = (state_117151[(8)]);
var inst_117145 = inst_117141.o;
var state_117151__$1 = state_117151;
var statearr_117162_117344 = state_117151__$1;
(statearr_117162_117344[(2)] = inst_117145);

(statearr_117162_117344[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117152 === (8))){
var inst_117141 = (state_117151[(8)]);
var inst_117141__$1 = (state_117151[(2)]);
var inst_117142 = (inst_117141__$1 == null);
var state_117151__$1 = (function (){var statearr_117163 = state_117151;
(statearr_117163[(8)] = inst_117141__$1);

return statearr_117163;
})();
if(cljs.core.truth_(inst_117142)){
var statearr_117164_117345 = state_117151__$1;
(statearr_117164_117345[(1)] = (9));

} else {
var statearr_117165_117346 = state_117151__$1;
(statearr_117165_117346[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__100742__auto__ = null;
var fluree$db$graphdb$state_machine__100742__auto____0 = (function (){
var statearr_117166 = [null,null,null,null,null,null,null,null,null];
(statearr_117166[(0)] = fluree$db$graphdb$state_machine__100742__auto__);

(statearr_117166[(1)] = (1));

return statearr_117166;
});
var fluree$db$graphdb$state_machine__100742__auto____1 = (function (state_117151){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_117151);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e117167){if((e117167 instanceof Object)){
var ex__100745__auto__ = e117167;
var statearr_117168_117347 = state_117151;
(statearr_117168_117347[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_117151);

return cljs.core.cst$kw$recur;
} else {
throw e117167;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__117348 = state_117151;
state_117151 = G__117348;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__100742__auto__ = function(state_117151){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__100742__auto____1.call(this,state_117151);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__100742__auto____0;
fluree$db$graphdb$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__100742__auto____1;
return fluree$db$graphdb$state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_117169 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_117169[(6)] = c__100848__auto__);

return statearr_117169;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$3 = (function (this$,tag_id,pred){
var self__ = this;
var this$__$1 = this;
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_117202){
var state_val_117203 = (state_117202[(1)]);
if((state_val_117203 === (7))){
var inst_117179 = (state_117202[(2)]);
var inst_117180 = this$__$1.fluree$db$dbproto$IFlureeDb$_tag$arity$2(null,tag_id);
var state_117202__$1 = (function (){var statearr_117204 = state_117202;
(statearr_117204[(7)] = inst_117179);

return statearr_117204;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_117202__$1,(8),inst_117180);
} else {
if((state_val_117203 === (1))){
var state_117202__$1 = state_117202;
var statearr_117205_117349 = state_117202__$1;
(statearr_117205_117349[(2)] = null);

(statearr_117205_117349[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117203 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_117202,(3),Error,null,(2));
var inst_117174 = typeof pred === 'string';
var state_117202__$1 = state_117202;
if(cljs.core.truth_(inst_117174)){
var statearr_117206_117350 = state_117202__$1;
(statearr_117206_117350[(1)] = (5));

} else {
var statearr_117207_117351 = state_117202__$1;
(statearr_117207_117351[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117203 === (15))){
var inst_117183 = (state_117202[(8)]);
var inst_117191 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(inst_117183,/:/);
var inst_117192 = cljs.core.second(inst_117191);
var state_117202__$1 = state_117202;
var statearr_117208_117352 = state_117202__$1;
(statearr_117208_117352[(2)] = inst_117192);

(statearr_117208_117352[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117203 === (13))){
var state_117202__$1 = state_117202;
var statearr_117209_117353 = state_117202__$1;
(statearr_117209_117353[(2)] = null);

(statearr_117209_117353[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117203 === (6))){
var inst_117177 = this$__$1.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3(null,cljs.core.cst$kw$name,pred);
var state_117202__$1 = state_117202;
var statearr_117210_117354 = state_117202__$1;
(statearr_117210_117354[(2)] = inst_117177);

(statearr_117210_117354[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117203 === (17))){
var inst_117195 = (state_117202[(2)]);
var state_117202__$1 = state_117202;
var statearr_117211_117355 = state_117202__$1;
(statearr_117211_117355[(2)] = inst_117195);

(statearr_117211_117355[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117203 === (3))){
var inst_117170 = (state_117202[(2)]);
var state_117202__$1 = state_117202;
var statearr_117212_117356 = state_117202__$1;
(statearr_117212_117356[(2)] = inst_117170);


cljs.core.async.impl.ioc_helpers.process_exception(state_117202__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_117203 === (12))){
var inst_117183 = (state_117202[(8)]);
var inst_117189 = clojure.string.includes_QMARK_(inst_117183,":");
var state_117202__$1 = state_117202;
if(inst_117189){
var statearr_117213_117357 = state_117202__$1;
(statearr_117213_117357[(1)] = (15));

} else {
var statearr_117214_117358 = state_117202__$1;
(statearr_117214_117358[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117203 === (2))){
var inst_117200 = (state_117202[(2)]);
var state_117202__$1 = state_117202;
return cljs.core.async.impl.ioc_helpers.return_chan(state_117202__$1,inst_117200);
} else {
if((state_val_117203 === (11))){
var inst_117187 = (state_117202[(2)]);
var state_117202__$1 = state_117202;
if(cljs.core.truth_(inst_117187)){
var statearr_117215_117359 = state_117202__$1;
(statearr_117215_117359[(1)] = (12));

} else {
var statearr_117216_117360 = state_117202__$1;
(statearr_117216_117360[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117203 === (9))){
var inst_117183 = (state_117202[(8)]);
var state_117202__$1 = state_117202;
var statearr_117217_117361 = state_117202__$1;
(statearr_117217_117361[(2)] = inst_117183);

(statearr_117217_117361[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117203 === (5))){
var state_117202__$1 = state_117202;
var statearr_117218_117362 = state_117202__$1;
(statearr_117218_117362[(2)] = pred);

(statearr_117218_117362[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117203 === (14))){
var inst_117198 = (state_117202[(2)]);
var state_117202__$1 = state_117202;
var statearr_117219_117363 = state_117202__$1;
(statearr_117219_117363[(2)] = inst_117198);


cljs.core.async.impl.ioc_helpers.process_exception(state_117202__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_117203 === (16))){
var inst_117183 = (state_117202[(8)]);
var state_117202__$1 = state_117202;
var statearr_117220_117364 = state_117202__$1;
(statearr_117220_117364[(2)] = inst_117183);

(statearr_117220_117364[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117203 === (10))){
var inst_117179 = (state_117202[(7)]);
var state_117202__$1 = state_117202;
var statearr_117221_117365 = state_117202__$1;
(statearr_117221_117365[(2)] = inst_117179);

(statearr_117221_117365[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117203 === (8))){
var inst_117179 = (state_117202[(7)]);
var inst_117182 = (state_117202[(2)]);
var inst_117183 = fluree.db.util.async.throw_err(inst_117182);
var state_117202__$1 = (function (){var statearr_117222 = state_117202;
(statearr_117222[(8)] = inst_117183);

return statearr_117222;
})();
if(cljs.core.truth_(inst_117179)){
var statearr_117223_117366 = state_117202__$1;
(statearr_117223_117366[(1)] = (9));

} else {
var statearr_117224_117367 = state_117202__$1;
(statearr_117224_117367[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__100742__auto__ = null;
var fluree$db$graphdb$state_machine__100742__auto____0 = (function (){
var statearr_117225 = [null,null,null,null,null,null,null,null,null];
(statearr_117225[(0)] = fluree$db$graphdb$state_machine__100742__auto__);

(statearr_117225[(1)] = (1));

return statearr_117225;
});
var fluree$db$graphdb$state_machine__100742__auto____1 = (function (state_117202){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_117202);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e117226){if((e117226 instanceof Object)){
var ex__100745__auto__ = e117226;
var statearr_117227_117368 = state_117202;
(statearr_117227_117368[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_117202);

return cljs.core.cst$kw$recur;
} else {
throw e117226;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__117369 = state_117202;
state_117202 = G__117369;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__100742__auto__ = function(state_117202){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__100742__auto____1.call(this,state_117202);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__100742__auto____0;
fluree$db$graphdb$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__100742__auto____1;
return fluree$db$graphdb$state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_117228 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_117228[(6)] = c__100848__auto__);

return statearr_117228;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 = (function (this$,tag_name){
var self__ = this;
var this$__$1 = this;
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_117257){
var state_val_117258 = (state_117257[(1)]);
if((state_val_117258 === (7))){
var inst_117241 = (state_117257[(7)]);
var inst_117245 = cljs.core.first(inst_117241);
var state_117257__$1 = state_117257;
var statearr_117259_117370 = state_117257__$1;
(statearr_117259_117370[(2)] = inst_117245);

(statearr_117259_117370[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117258 === (1))){
var state_117257__$1 = state_117257;
var statearr_117260_117371 = state_117257__$1;
(statearr_117260_117371[(2)] = null);

(statearr_117260_117371[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117258 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_117257,(3),Error,null,(2));
var inst_117234 = this$__$1.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1(null);
var inst_117235 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_117236 = [(30),tag_name];
var inst_117237 = (new cljs.core.PersistentVector(null,2,(5),inst_117235,inst_117236,null));
var inst_117238 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_117234,cljs.core.cst$kw$post,cljs.core._EQ_,inst_117237);
var state_117257__$1 = state_117257;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_117257__$1,(5),inst_117238);
} else {
if((state_val_117258 === (6))){
var state_117257__$1 = state_117257;
var statearr_117261_117372 = state_117257__$1;
(statearr_117261_117372[(2)] = null);

(statearr_117261_117372[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117258 === (3))){
var inst_117229 = (state_117257[(2)]);
var state_117257__$1 = state_117257;
var statearr_117262_117373 = state_117257__$1;
(statearr_117262_117373[(2)] = inst_117229);


cljs.core.async.impl.ioc_helpers.process_exception(state_117257__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_117258 === (2))){
var inst_117255 = (state_117257[(2)]);
var state_117257__$1 = state_117257;
return cljs.core.async.impl.ioc_helpers.return_chan(state_117257__$1,inst_117255);
} else {
if((state_val_117258 === (11))){
var inst_117253 = (state_117257[(2)]);
var state_117257__$1 = state_117257;
var statearr_117263_117374 = state_117257__$1;
(statearr_117263_117374[(2)] = inst_117253);


cljs.core.async.impl.ioc_helpers.process_exception(state_117257__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_117258 === (9))){
var state_117257__$1 = state_117257;
var statearr_117264_117375 = state_117257__$1;
(statearr_117264_117375[(2)] = null);

(statearr_117264_117375[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117258 === (5))){
var inst_117241 = (state_117257[(7)]);
var inst_117240 = (state_117257[(2)]);
var inst_117241__$1 = fluree.db.util.async.throw_err(inst_117240);
var inst_117242 = (inst_117241__$1 == null);
var state_117257__$1 = (function (){var statearr_117265 = state_117257;
(statearr_117265[(7)] = inst_117241__$1);

return statearr_117265;
})();
if(cljs.core.truth_(inst_117242)){
var statearr_117266_117376 = state_117257__$1;
(statearr_117266_117376[(1)] = (6));

} else {
var statearr_117267_117377 = state_117257__$1;
(statearr_117267_117377[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117258 === (10))){
var inst_117247 = (state_117257[(8)]);
var inst_117251 = inst_117247.s;
var state_117257__$1 = state_117257;
var statearr_117268_117378 = state_117257__$1;
(statearr_117268_117378[(2)] = inst_117251);

(statearr_117268_117378[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117258 === (8))){
var inst_117247 = (state_117257[(8)]);
var inst_117247__$1 = (state_117257[(2)]);
var inst_117248 = (inst_117247__$1 == null);
var state_117257__$1 = (function (){var statearr_117269 = state_117257;
(statearr_117269[(8)] = inst_117247__$1);

return statearr_117269;
})();
if(cljs.core.truth_(inst_117248)){
var statearr_117270_117379 = state_117257__$1;
(statearr_117270_117379[(1)] = (9));

} else {
var statearr_117271_117380 = state_117257__$1;
(statearr_117271_117380[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__100742__auto__ = null;
var fluree$db$graphdb$state_machine__100742__auto____0 = (function (){
var statearr_117272 = [null,null,null,null,null,null,null,null,null];
(statearr_117272[(0)] = fluree$db$graphdb$state_machine__100742__auto__);

(statearr_117272[(1)] = (1));

return statearr_117272;
});
var fluree$db$graphdb$state_machine__100742__auto____1 = (function (state_117257){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_117257);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e117273){if((e117273 instanceof Object)){
var ex__100745__auto__ = e117273;
var statearr_117274_117381 = state_117257;
(statearr_117274_117381[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_117257);

return cljs.core.cst$kw$recur;
} else {
throw e117273;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__117382 = state_117257;
state_117257 = G__117382;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__100742__auto__ = function(state_117257){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__100742__auto____1.call(this,state_117257);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__100742__auto____0;
fluree$db$graphdb$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__100742__auto____1;
return fluree$db$graphdb$state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_117275 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_117275[(6)] = c__100848__auto__);

return statearr_117275;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 = (function (this$,tag_name,pred){
var self__ = this;
var this$__$1 = this;
var c__100848__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__100849__auto__ = (function (){var switch__100741__auto__ = (function (state_117307){
var state_val_117308 = (state_117307[(1)]);
if((state_val_117308 === (7))){
var inst_117303 = (state_117307[(2)]);
var state_117307__$1 = state_117307;
var statearr_117309_117383 = state_117307__$1;
(statearr_117309_117383[(2)] = inst_117303);


cljs.core.async.impl.ioc_helpers.process_exception(state_117307__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_117308 === (1))){
var state_117307__$1 = state_117307;
var statearr_117310_117384 = state_117307__$1;
(statearr_117310_117384[(2)] = null);

(statearr_117310_117384[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117308 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_117307,(3),Error,null,(2));
var inst_117280 = clojure.string.includes_QMARK_(tag_name,"/");
var state_117307__$1 = state_117307;
if(inst_117280){
var statearr_117311_117385 = state_117307__$1;
(statearr_117311_117385[(1)] = (5));

} else {
var statearr_117312_117386 = state_117307__$1;
(statearr_117312_117386[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117308 === (15))){
var inst_117297 = (state_117307[(2)]);
var inst_117298 = fluree.db.util.async.throw_err(inst_117297);
var state_117307__$1 = state_117307;
var statearr_117313_117387 = state_117307__$1;
(statearr_117313_117387[(2)] = inst_117298);

(statearr_117313_117387[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117308 === (13))){
var state_117307__$1 = state_117307;
var statearr_117314_117388 = state_117307__$1;
(statearr_117314_117388[(2)] = null);

(statearr_117314_117388[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117308 === (6))){
var inst_117287 = typeof pred === 'string';
var state_117307__$1 = state_117307;
if(cljs.core.truth_(inst_117287)){
var statearr_117315_117389 = state_117307__$1;
(statearr_117315_117389[(1)] = (9));

} else {
var statearr_117316_117390 = state_117307__$1;
(statearr_117316_117390[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117308 === (3))){
var inst_117276 = (state_117307[(2)]);
var state_117307__$1 = state_117307;
var statearr_117317_117391 = state_117307__$1;
(statearr_117317_117391[(2)] = inst_117276);


cljs.core.async.impl.ioc_helpers.process_exception(state_117307__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_117308 === (12))){
var inst_117292 = (state_117307[(7)]);
var inst_117294 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_117292),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag_name)].join('');
var inst_117295 = this$__$1.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2(null,inst_117294);
var state_117307__$1 = state_117307;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_117307__$1,(15),inst_117295);
} else {
if((state_val_117308 === (2))){
var inst_117305 = (state_117307[(2)]);
var state_117307__$1 = state_117307;
return cljs.core.async.impl.ioc_helpers.return_chan(state_117307__$1,inst_117305);
} else {
if((state_val_117308 === (11))){
var inst_117292 = (state_117307[(7)]);
var inst_117292__$1 = (state_117307[(2)]);
var state_117307__$1 = (function (){var statearr_117318 = state_117307;
(statearr_117318[(7)] = inst_117292__$1);

return statearr_117318;
})();
if(cljs.core.truth_(inst_117292__$1)){
var statearr_117319_117392 = state_117307__$1;
(statearr_117319_117392[(1)] = (12));

} else {
var statearr_117320_117393 = state_117307__$1;
(statearr_117320_117393[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117308 === (9))){
var state_117307__$1 = state_117307;
var statearr_117321_117394 = state_117307__$1;
(statearr_117321_117394[(2)] = pred);

(statearr_117321_117394[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117308 === (5))){
var inst_117282 = this$__$1.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2(null,tag_name);
var state_117307__$1 = state_117307;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_117307__$1,(8),inst_117282);
} else {
if((state_val_117308 === (14))){
var inst_117301 = (state_117307[(2)]);
var state_117307__$1 = state_117307;
var statearr_117322_117395 = state_117307__$1;
(statearr_117322_117395[(2)] = inst_117301);

(statearr_117322_117395[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117308 === (10))){
var inst_117290 = this$__$1.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3(null,cljs.core.cst$kw$name,pred);
var state_117307__$1 = state_117307;
var statearr_117323_117396 = state_117307__$1;
(statearr_117323_117396[(2)] = inst_117290);

(statearr_117323_117396[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117308 === (8))){
var inst_117284 = (state_117307[(2)]);
var inst_117285 = fluree.db.util.async.throw_err(inst_117284);
var state_117307__$1 = state_117307;
var statearr_117324_117397 = state_117307__$1;
(statearr_117324_117397[(2)] = inst_117285);

(statearr_117324_117397[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__100742__auto__ = null;
var fluree$db$graphdb$state_machine__100742__auto____0 = (function (){
var statearr_117325 = [null,null,null,null,null,null,null,null];
(statearr_117325[(0)] = fluree$db$graphdb$state_machine__100742__auto__);

(statearr_117325[(1)] = (1));

return statearr_117325;
});
var fluree$db$graphdb$state_machine__100742__auto____1 = (function (state_117307){
while(true){
var ret_value__100743__auto__ = (function (){try{while(true){
var result__100744__auto__ = switch__100741__auto__(state_117307);
if(cljs.core.keyword_identical_QMARK_(result__100744__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__100744__auto__;
}
break;
}
}catch (e117326){if((e117326 instanceof Object)){
var ex__100745__auto__ = e117326;
var statearr_117327_117398 = state_117307;
(statearr_117327_117398[(5)] = ex__100745__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_117307);

return cljs.core.cst$kw$recur;
} else {
throw e117326;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__100743__auto__,cljs.core.cst$kw$recur)){
var G__117399 = state_117307;
state_117307 = G__117399;
continue;
} else {
return ret_value__100743__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__100742__auto__ = function(state_117307){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__100742__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__100742__auto____1.call(this,state_117307);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__100742__auto____0;
fluree$db$graphdb$state_machine__100742__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__100742__auto____1;
return fluree$db$graphdb$state_machine__100742__auto__;
})()
})();
var state__100850__auto__ = (function (){var statearr_117328 = (f__100849__auto__.cljs$core$IFn$_invoke$arity$0 ? f__100849__auto__.cljs$core$IFn$_invoke$arity$0() : f__100849__auto__.call(null));
(statearr_117328[(6)] = c__100848__auto__);

return statearr_117328;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__100850__auto__);
}));

return c__100848__auto__;
}));

(fluree.db.graphdb.GraphDb.getBasis = (function (){
return new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$conn,cljs.core.cst$sym$network,cljs.core.cst$sym$dbid,cljs.core.cst$sym$block,cljs.core.cst$sym$t,cljs.core.cst$sym$tt_DASH_id,cljs.core.cst$sym$stats,cljs.core.cst$sym$spot,cljs.core.cst$sym$psot,cljs.core.cst$sym$post,cljs.core.cst$sym$opst,cljs.core.cst$sym$schema,cljs.core.cst$sym$settings,cljs.core.cst$sym$index_DASH_configs,cljs.core.cst$sym$schema_DASH_cache,cljs.core.cst$sym$novelty,cljs.core.cst$sym$permissions,cljs.core.cst$sym$fork,cljs.core.cst$sym$fork_DASH_block,cljs.core.cst$sym$current_DASH_db_DASH_fn], null);
}));

(fluree.db.graphdb.GraphDb.cljs$lang$type = true);

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"fluree.db.graphdb/GraphDb",null,(1),null));
}));

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"fluree.db.graphdb/GraphDb");
}));

/**
 * Positional factory function for fluree.db.graphdb/GraphDb.
 */
fluree.db.graphdb.__GT_GraphDb = (function fluree$db$graphdb$__GT_GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn){
return (new fluree.db.graphdb.GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,null,null,null));
});

/**
 * Factory function for fluree.db.graphdb/GraphDb, taking a map of keywords to field values.
 */
fluree.db.graphdb.map__GT_GraphDb = (function fluree$db$graphdb$map__GT_GraphDb(G__117049){
var extmap__4419__auto__ = (function (){var G__117329 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__117049,cljs.core.cst$kw$conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$stats,cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst,cljs.core.cst$kw$schema,cljs.core.cst$kw$settings,cljs.core.cst$kw$index_DASH_configs,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$novelty,cljs.core.cst$kw$permissions,cljs.core.cst$kw$fork,cljs.core.cst$kw$fork_DASH_block,cljs.core.cst$kw$current_DASH_db_DASH_fn], 0));
if(cljs.core.record_QMARK_(G__117049)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__117329);
} else {
return G__117329;
}
})();
return (new fluree.db.graphdb.GraphDb(cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(G__117049),cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(G__117049),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(G__117049),cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(G__117049),cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(G__117049),cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(G__117049),cljs.core.cst$kw$stats.cljs$core$IFn$_invoke$arity$1(G__117049),cljs.core.cst$kw$spot.cljs$core$IFn$_invoke$arity$1(G__117049),cljs.core.cst$kw$psot.cljs$core$IFn$_invoke$arity$1(G__117049),cljs.core.cst$kw$post.cljs$core$IFn$_invoke$arity$1(G__117049),cljs.core.cst$kw$opst.cljs$core$IFn$_invoke$arity$1(G__117049),cljs.core.cst$kw$schema.cljs$core$IFn$_invoke$arity$1(G__117049),cljs.core.cst$kw$settings.cljs$core$IFn$_invoke$arity$1(G__117049),cljs.core.cst$kw$index_DASH_configs.cljs$core$IFn$_invoke$arity$1(G__117049),cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(G__117049),cljs.core.cst$kw$novelty.cljs$core$IFn$_invoke$arity$1(G__117049),cljs.core.cst$kw$permissions.cljs$core$IFn$_invoke$arity$1(G__117049),cljs.core.cst$kw$fork.cljs$core$IFn$_invoke$arity$1(G__117049),cljs.core.cst$kw$fork_DASH_block.cljs$core$IFn$_invoke$arity$1(G__117049),cljs.core.cst$kw$current_DASH_db_DASH_fn.cljs$core$IFn$_invoke$arity$1(G__117049),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (db,w,opts){
var db__$1 = this;
cljs.core._write(w,"#FlureeGraphDB ");

return cljs.core._write(w,cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$network,db__$1.network,cljs.core.cst$kw$dbid,db__$1.dbid,cljs.core.cst$kw$block,db__$1.block,cljs.core.cst$kw$t,db__$1.t,cljs.core.cst$kw$stats,db__$1.stats,cljs.core.cst$kw$permissions,db__$1.permissions], null)], 0)));
}));
fluree.db.graphdb.new_novelty_map = (function fluree$db$graphdb$new_novelty_map(index_configs){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,idx){
var ss = clojure.data.avl.sorted_set_by(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(index_configs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [idx,cljs.core.cst$kw$historyComparator], null)));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,idx,ss);
}),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$size,(0)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst], null));
});
fluree.db.graphdb.new_empty_index = (function fluree$db$graphdb$new_empty_index(conn,index_configs,network,dbid,idx){
var index_config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(index_configs,idx);
var _ = (cljs.core.truth_(index_config)?null:(function(){throw (new Error(["Assert failed: ",["No index config found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","index-config"].join('')))})());
var comparator = cljs.core.cst$kw$historyComparator.cljs$core$IFn$_invoke$arity$1(index_config);
var ___$1 = (cljs.core.truth_(comparator)?null:(function(){throw (new Error(["Assert failed: ",["No index comparator found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","comparator"].join('')))})());
var first_flake = fluree.db.flake.__GT_Flake(fluree.db.util.core.max_long,(0),fluree.db.util.core.max_long,(0),true,null);
var child_node = fluree.db.storage.core.map__GT_UnresolvedNode(cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$block,cljs.core.cst$kw$dbid,cljs.core.cst$kw$config,cljs.core.cst$kw$leaf,cljs.core.cst$kw$size,cljs.core.cst$kw$leftmost_QMARK_,cljs.core.cst$kw$id,cljs.core.cst$kw$t,cljs.core.cst$kw$network,cljs.core.cst$kw$first,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$rhs,cljs.core.cst$kw$conn],[(0),dbid,index_config,true,(0),true,cljs.core.cst$kw$empty,(0),network,first_flake,null,null,conn]));
var children = clojure.data.avl.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic(comparator,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([first_flake,child_node], 0));
var idx_node = fluree.db.index.__GT_IndexNode((0),(0),null,children,index_config,true);
return idx_node;
});
fluree.db.graphdb.default_index_configs = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$spot,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$spot,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_spot,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_spot_novelty], null)),cljs.core.cst$kw$psot,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$psot,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_psot,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_psot_novelty], null)),cljs.core.cst$kw$post,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$post,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_post,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_post_novelty], null)),cljs.core.cst$kw$opst,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$opst,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_opst,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_opst_novelty], null))], null);
fluree.db.graphdb.blank_db = (function fluree$db$graphdb$blank_db(conn,network,dbid,schema_cache,current_db_fn){
if(cljs.core.truth_(conn)){
} else {
throw (new Error(["Assert failed: ","No conn provided when creating new db.","\n","conn"].join('')));
}

if(cljs.core.truth_(network)){
} else {
throw (new Error(["Assert failed: ","No network provided when creating new db.","\n","network"].join('')));
}

if(cljs.core.truth_(dbid)){
} else {
throw (new Error(["Assert failed: ","No dbid provided when creating new db.","\n","dbid"].join('')));
}

var novelty = fluree.db.graphdb.new_novelty_map(fluree.db.graphdb.default_index_configs);
var permissions = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$collection,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,false], null),cljs.core.cst$kw$predicate,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,true], null),cljs.core.cst$kw$root_QMARK_,true], null);
var spot = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$spot);
var psot = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$psot);
var post = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$post);
var opst = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$opst);
var stats = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$flakes,(0),cljs.core.cst$kw$size,(0),cljs.core.cst$kw$indexed,(0)], null);
var fork = null;
var fork_block = null;
var schema = null;
var settings = null;
return fluree.db.graphdb.__GT_GraphDb(conn,network,dbid,(0),(-1),null,stats,spot,psot,post,opst,schema,settings,fluree.db.graphdb.default_index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn);
});
fluree.db.graphdb.graphdb_QMARK_ = (function fluree$db$graphdb$graphdb_QMARK_(db){
return (db instanceof fluree.db.graphdb.GraphDb);
});
