(defproject fluree.db/server "0.16.1"
  :description "FlureeDB Server, containing ability to start as a ledger, query peer, or both (dev)."
  :url "https://www.flur.ee"

  :dependencies [[org.clojure/clojure "1.10.1"]
                 [org.clojure/data.xml "0.0.8"]
                 [com.fluree/db "0.16.0"]
                 [com.fluree/raft "0.11.3"]
                 [com.fluree/crypto "0.3.3"]

                 ;; network comm
                 [net.async/async "0.1.0"]

                 ;; Lucene
                 [clucie "0.4.2"]

                 ;; web server
                 [aleph-middleware "0.2.0" :exclusions [aleph-middleware aleph]]
                 [ring/ring-core "1.7.0"]
                 [ring-cors "0.1.12"]
                 [compojure "1.6.1"]]

  :repositories {"deps.co-snapshots"
                 {:url      "https://repo.deps.co/fluree/snapshots"
                  :username :env/deps_key
                  :password :env/deps_secret
                  :releases false}
                 "deps.co-releases"
                 {:url       "https://repo.deps.co/fluree/releases"
                  :username  :env/deps_key
                  :password  :env/deps_secret
                  :snapshots false}}

  :main ^:skip-aot fluree.db.server
  :target-path "target/%s"
  :profiles {:uberjar {:aot         :all
                       :omit-source true}
             :dev     {:source-paths ["dev"]
                       :env          {:dev                 "true"
                                      :fdb-mode            "dev"
                                      :fdb-properties-file ""}
                       :repl-options {:init-ns user
                                      :init    nil #_(reset)}
                       :dependencies [[lein-environ "1.1.0"]
                                      [org.clojure/tools.namespace "0.2.11"]
                                      [ruiyun/tools.timer "1.0.1"]
                                      [criterium "0.4.4"]]}})
