(defproject com.fluree/db "0.16.0"
  :description "FlureeDB"
  :url "https://flur.ee"
  :license {:name "Copyright 2017, 2018, 2019, 2020 Fluree, PBC. All rights reserved."}
  :dependencies [[org.clojure/clojure "1.10.1"]
                 [org.clojure/clojurescript "1.10.520"]
                 [org.clojure/core.async "0.4.490"]
                 [org.clojure/core.cache "0.7.1"]
                 [org.clojars.mmb90/cljs-cache "0.1.4"]     ;; core.cache for cljs
                 [org.clojure/tools.logging "0.4.1"]
                 [org.clojure/data.avl "0.1.0"]
                 [org.clojure/tools.reader "1.3.2"]
                 [environ "1.1.0"]
                 [byte-streams "0.2.4"]


                 [cheshire "5.8.1"]

                 ;; logging
                 [logback-bundle/core-bundle "0.3.0"]
                 [org.slf4j/slf4j-api "1.7.25"]

                 ;; storage
                 [cc.qbits/alia "4.2.1"]
                 [cc.qbits/alia-async "4.0.2"]
                 [cc.qbits/hayt "4.0.0"]

                 ;; Lucene
                 [clucie "0.4.2"]

                 ;; messaging
                 [aleph "0.4.6"]

                 ;; Instaparse
                 [instaparse "1.4.9"]

                 ;; benchmarking
                 [criterium "0.4.4"]

                 ;; serialization / compression
                 [com.damballa/abracad "0.4.13"]
                 [com.taoensso/nippy "2.14.0" :exclusions [org.clojure/tools.reader]] ;; tools.reader explicitly specified
                 [org.xerial.snappy/snappy-java "1.1.7.1"]
                 [com.fluree/alphabase "3.2.1"]

                 ;; crypto
                 [com.fluree/crypto "0.3.3"]
                 [org.bouncycastle/bcprov-jdk15on "1.55"]

                 ;; cljs
                 [figwheel-sidecar "0.5.18"]]

  :target-path "target/%s"
  :node-dependencies [[source-map-support "0.5.16"]]
  :plugins [[s3-wagon-private "1.2.0"
             :exclusions [commons-codec]]
            [lein-environ "1.1.0"]
            [lein-codox "0.10.4"]
            [lein-cljsbuild "1.1.7" :exclusions [[org.clojure/clojure]]]]

  :repositories {"deps.co-snapshots"
                 {:url "https://repo.deps.co/fluree/snapshots"
                  :username :env/deps_key
                  :password :env/deps_secret
                  :releases false}

                 "deps.co-releases"
                 {:url "https://repo.deps.co/fluree/releases"
                  :username :env/deps_key
                  :password :env/deps_secret
                  :snapshots false}}

  :profiles {:dev           [:project/dev :profiles/dev]
             :prod          [:project/prod :profiles/prod]
             :test          [:project/test :profiles/test]

             :profiles/prod {}
             :profiles/dev  {}
             :profiles/test {}
             :project/prod  {:source-paths ["prod"]}
             :project/dev   {:source-paths  ["src" "dev" "script"]
                             :repl-options  {:nrepl-middleware [cider.piggieback/wrap-cljs-repl]
                                             :init-ns          user
                                             :init             nil #_(reset)}
                             :dependencies  [[org.clojure/tools.namespace "0.3.1"]
                                             ;; [com.clojure-goes-fast/clj-memory-meter "0.1.0"]
                                             [binaryage/devtools "0.9.10"]
                                             [figwheel-sidecar "0.5.18"]
                                             [cider/piggieback "0.4.1"]]
                             :env           {:dev                 "true"
                                             :fdb-mode            "dev"
                                             :fdb-properties-file ""}
                             :clean-targets ^{:protect false} ["resources/public/js/compiled"
                                                               :target-path]}
             :project/test  {}}

  :cljsbuild {:builds
              [{:id           "dev"
                :source-paths ["src" "src-cljs"]


                ;; The presence of a :figwheel configuration here
                ;; will cause figwheel to inject the figwheel client
                ;; into your build
                :figwheel     {:on-jsload "flureedb/on-js-reload"
                               ;; :open-urls will pop open your application
                               ;; in the default browser once Figwheel has
                               ;; started and compiled your application.
                               ;; Comment this out once it no longer serves you.
                               :open-urls ["http://localhost:3449/index.html"]}

                :compiler     {:main                 flureedb
                               :asset-path           "js/compiled/out"
                               :output-to            "resources/public/js/compiled/flureedb.js"
                               :output-dir           "resources/public/js/compiled/out"
                               :source-map-timestamp true
                               ;; To console.log CLJS data-structures make sure you enable devtools in Chrome
                               ;; https://github.com/binaryage/cljs-devtools
                               :preloads             [devtools.preload]
                               :pretty-print         false
                               :optimize-constants   true
                               :static-fns           true
                               :install-deps         true
                               :npm-deps             {:scrypt-js "2.0.4"}
                               :libs                 ["checkouts/fluree.crypto/src/goog/crypt/pkcs7.js"
                                                      "checkouts/fluree.crypto/src/sjcl"
                                                      "checkouts/fluree.crypto/src/jssha3/sha3.js"]}}

               ; This next build is a compressed minified build for
               ; production. You can build this with:
               ;    lein cljsbuild once min
               ; Note: ':pseudo-names true' option escalates
               ; the footprint of the minimized build
               {:id           "min"
                :source-paths ["src" "src-cljs"]
                :compiler     {:asset-path    "js"
                               :output-to     "resources/build/flureedb.js"
                               :output-dir    "resources/build/flureedb-out"
                               :main          flureedb
                               :optimizations :advanced
                               :pretty-print  false
                               :infer-externs true
                               :install-deps  true
                               :npm-deps      {:scrypt-js "2.0.4"}
                               :libs          ["checkouts/fluree.crypto/src/goog/crypt/pkcs7.js"
                                               "checkouts/fluree.crypto/src/sjcl"
                                               "checkouts/fluree.crypto/src/jssha3/sha3.js"]}}
               ; builds worker with no optimizations for dev. Must use modified loader located
               ; at resources/public/js/flureeworker-dev.js and not the one listed below in :ouput-to
               ; build with `lein cljsbuild auto worker-dev` for auto-build updating
               {:id           "worker-dev"
                :source-paths ["src" "src-cljs"]
                :compiler     {:asset-path    "js-react-wrapper/build"
                               :output-to     "resources/build/flureeworker-dont-use-me.js"
                               :output-dir    "resources/build/flureeworker-dev-out"
                               :main          flureeworker
                               :optimizations :none
                               :pretty-print  true
                               :infer-externs true
                               :install-deps  true
                               :npm-deps      {:scrypt-js "2.0.4"}
                               :libs          ["checkouts/fluree.crypto/src/goog/crypt/pkcs7.js"
                                               "checkouts/fluree.crypto/src/sjcl"
                                               "checkouts/fluree.crypto/src/jssha3/sha3.js"]}}
               ; This next build is a compressed minified build for production. You can build this with:
               ;    lein cljsbuild once worker-min
               ; Note: ':pseudo-names true' option escalates
               ; the footprint of the minimized build
               {:id           "worker-min"
                :source-paths ["src" "src-cljs"]
                :compiler     {:asset-path    "js"
                               :output-to     "resources/build/flureeworker.js"
                               :output-dir    "resources/build/flureeworker-out"
                               :main          flureeworker
                               :optimizations :advanced
                               :pretty-print  false
                               :infer-externs true
                               :install-deps  true
                               :npm-deps      {:scrypt-js "2.0.4"}
                               :libs          ["checkouts/fluree.crypto/src/goog/crypt/pkcs7.js"
                                               "checkouts/fluree.crypto/src/sjcl"
                                               "checkouts/fluree.crypto/src/jssha3/sha3.js"]}}
               ; This next build is for the nodejs version
               ; Self-hosted ClojureScript is compatible with :simple.
               {:id "nodejs"
                :source-paths ["src" "src-cljs" "src-nodejs"]
                :compiler {:target             :nodejs
                           ;:dump-core          true
                           :main               flureenjs
                           :output-to          "resources/build/flureenjs.js"
                           :output-dir         "resources/build/nodejs-out"
                           ;:source-map         "resources/build/flureenjs.js.map"
                           :output-wrapper     true
                           ;:optimize-constants true
                           ;:static-fns         true
                           :optimizations      :simple
                           :pretty-print       false
                           :infer-externs      true
                           :install-deps       true
                           :npm-deps           {:scrypt-js "2.0.4"}
                           :libs               ["checkouts/fluree.crypto/src/goog/crypt/pkcs7.js"
                                                "checkouts/fluree.crypto/src/sjcl"
                                                "checkouts/fluree.crypto/src/jssha3/sha3.js"]}}]}


  :figwheel {;; :http-server-root "public" ;; default and assumes "resources"
             ;; :server-port 3449 ;; default
             ;; :server-ip "127.0.0.1"

             :css-dirs ["resources/public/css"]})             ;; watch and update CSS

             ;; Start an nREPL server into the running figwheel process
             ;; :nrepl-port 7888

             ;; Server Ring Handler (optional)
             ;; if you want to embed a ring handler into the figwheel http-kit
             ;; server, this is for simple ring servers, if this

             ;; doesn't work for you just run your own server :) (see lein-ring)

             ;; :ring-handler hello_world.server/handler

             ;; To be able to open files in your editor from the heads up display
             ;; you will need to put a script on your path.
             ;; that script will have to take a file path and a line number
             ;; ie. in  ~/bin/myfile-opener
             ;; #! /bin/sh
             ;; emacsclient -n +$2 $1
             ;;
             ;; :open-file-command "myfile-opener"

             ;; if you are using emacsclient you can just use
             ;; :open-file-command "emacsclient"

             ;; if you want to disable the REPL
             ;; :repl false

             ;; to configure a different figwheel logfile path
             ;; :server-logfile "tmp/logs/figwheel-logfile.log"

             ;; to pipe all the output to the repl
             ;; :server-logfile false



